/*
 * Java-Gnome Bindings Library
 *
 * Copyright 2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

/**
 * @author Ismael Juma <ismael@juma.me.uk>
 */

import org.gnu.glib.EventType;

public class DropDragEvent extends DragEvent {
    public static class Type extends EventType {
        private Type(int id, String name) {
            super(id, name);
        }

        public static Type DROP = new Type(0, "DROP");
    }

    private final int x;

    private final int y;

    private final int time;

    public DropDragEvent(DragEvent event, int x, int y, int time) {
        super(event);
        this.x = x;
        this.y = y;
        this.time = time;
    }

    public int getTime() {
        return time;
    }

    public int getX() {
        return x;
    }

    public int getY() {
        return y;
    }
}
