/*
 * Java-Gnome Bindings Library
 *
 * * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

import org.gnu.glib.EventType;

/**
 * An event representing action by a {@link org.gnu.gtk.OptionMenu} widget.
 * 
 * @deprecated Use {@link org.gnu.gtk.event.ComboBoxEvent} instead.
 * 
 */
public class OptionMenuEvent extends GtkEvent {

    /**
     * Type of a OptionMenuEvent
     */
    public static class Type extends EventType {
        private Type(int id, String name) {
            super(id, name);
        }

        /**
         * Emitted when a option menu selection changes.
         */
        public static final Type CHANGE = new Type(1, "CHANGE");
    }

    /**
     * Creates a new OptionMenu Event. This is used internally by java-gnome.
     * Users only have to deal with listeners.
     */
    public OptionMenuEvent(Object source, OptionMenuEvent.Type type) {
        super(source, type);
    }

    /**
     * @return True if the type of this event is the same as that stated.
     */
    public boolean isOfType(OptionMenuEvent.Type type) {
        return (this.type.getID() == type.getID());
    }
}
