// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_RECENTCHOOSER_H
#define _GTKMM_RECENTCHOOSER_H


#include <glibmm.h>

/* Copyright (C) 2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkrecentchooser.h>
#include <glibmm/interface.h>
#include <gtkmm/recentinfo.h>
#include <gtkmm/recentfilter.h>
#include <gtkmm/recentmanager.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkRecentChooser GtkRecentChooser;
typedef struct _GtkRecentChooserClass GtkRecentChooserClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class RecentChooser_Class; } // namespace Gtk
namespace Gtk
{

/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum RecentSortType
{
  RECENT_SORT_NONE,
  RECENT_SORT_MRU,
  RECENT_SORT_LRU,
  RECENT_SORT_CUSTOM
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::RecentSortType> : public Glib::Value_Enum<Gtk::RecentSortType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** Exception class for Gtk::RecentChooser errors.
 */
class RecentChooserError : public Glib::Error
{
public:
  enum Code
  {
    NOT_FOUND,
    INVALID_URI
  };

  RecentChooserError(Code error_code, const Glib::ustring& error_message);
  explicit RecentChooserError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static void throw_func(GError* gobject);
#else
  //When not using exceptions, we just pass the Exception object around without throwing it:
  static std::auto_ptr<Glib::Error> throw_func(GError* gobject);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  friend void wrap_init(); // uses throw_func()
#endif
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::RecentChooserError::Code> : public Glib::Value_Enum<Gtk::RecentChooserError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** RecentChooser is an interface that can be implemented by widgets
 * displaying the list of recently used files.  In GTK+, the main objects
 * that implement this interface are RecentChooserWidget, RecentChooserDialog
 * and RecentChooserMenu.
 *
 * @newin2p10
 *
 * @ingroup RecentFiles
 */

class RecentChooser : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef RecentChooser CppObjectType;
  typedef RecentChooser_Class CppClassType;
  typedef GtkRecentChooser BaseObjectType;
  typedef GtkRecentChooserIface BaseClassType;

private:
  friend class RecentChooser_Class;
  static CppClassType recentchooser_class_;

  // noncopyable
  RecentChooser(const RecentChooser&);
  RecentChooser& operator=(const RecentChooser&);

protected:
  RecentChooser(); // you must derive from this class
  explicit RecentChooser(GtkRecentChooser* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~RecentChooser();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkRecentChooser*       gobj()       { return reinterpret_cast<GtkRecentChooser*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GtkRecentChooser* gobj() const { return reinterpret_cast<GtkRecentChooser*>(gobject_); }

private:

public:

  
  void set_show_private(bool show_private = true);
  
  bool get_show_private() const;
  
  void set_show_not_found(bool show_not_found = true);
  
  bool get_show_not_found() const;
  
  void set_select_multiple(bool select_multiple = true);
  
  bool get_select_multiple() const;
  
  void set_limit(int limit);
  void unset_limit();
  
  int get_limit() const;
  
  void set_local_only(bool local_only = true);
  
  bool get_local_only() const;
  
  void set_show_tips(bool show_tips = true);
  
  bool get_show_tips() const;

  // TODO: These methods are declared in gtkrecentchooser.h but throw errors when
  // using them on RecentChooserWidget or RecentChooserDialog.
  // RecentChooserMenu reimplements them.
  // In an email titled "GtkRecentChooser API glitch", Emmanuele Bassi said that these would be 
  // deprecated in GTK+ 2.12. murrayc.
  //_WRAP_METHOD(void set_show_numbers(bool show_numbers = true), gtk_recent_chooser_set_show_numbers)
  //_WRAP_METHOD(bool get_show_numbers() const, gtk_recent_chooser_get_show_numbers)
  

  void set_show_icons(bool show_icons = true);
  
  bool get_show_icons() const;
  
  void set_sort_type(RecentSortType sort_type);
  
  RecentSortType get_sort_type() const;


  /** This callback should return -1 if b compares before a, 0 if they compare
   * equal and 1 if a compares after b.
   * For instance, int on_sort_compare(const Glib::RefPtr<Gtk::RecentInfo>& a, const Gtk::RecentInfo& b);
   */
  typedef sigc::slot<int, const Glib::RefPtr<RecentInfo>&, const Glib::RefPtr<RecentInfo>&> SlotCompare;
  

  /** Sets the comparison function used when sorting the list of recently
   * used resources and the sort type is #RECENT_SORT_CUSTOM.
   */
  void set_sort_func(const SlotCompare& slot);

  // TODO: Return type should be void since it will never return false but
  // throwing RecentChooserError instead
  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_current_uri(const Glib::ustring& uri);
#else
  bool set_current_uri(const Glib::ustring& uri, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  Glib::ustring get_current_uri() const;
  
  Glib::RefPtr<RecentInfo> get_current_item();
  
  Glib::RefPtr<const RecentInfo> get_current_item() const;
  // TODO: Same here
  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool select_uri(const Glib::ustring& uri);
#else
  bool select_uri(const Glib::ustring& uri, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  void unselect_uri(const Glib::ustring& uri);
  
  void select_all();
  
  void unselect_all();

  typedef Glib::ListHandle<RecentInfo, RecentInfoTraits> ListHandle_RecentInfos;
  

  ListHandle_RecentInfos get_items() const;

  /** Gets the URI of the recently used resources.
   *
   * The return value of this function is affected by the "sort-type" and
   * "limit" properties of the recent chooser.
   */
  Glib::StringArrayHandle get_uris() const;
  

  void add_filter(const RecentFilter& filter);
  
  void remove_filter(const RecentFilter& filter);
  
  Glib::SListHandle<RecentFilter*> list_filters();
  
  Glib::SListHandle<const RecentFilter*> list_filters() const;
  
  void set_filter(const RecentFilter& filter);
  
  RecentFilter* get_filter();
  
  const RecentFilter* get_filter() const;

  /** This signal is emitted when there is a change in the set of
   * selected recently used resources.  This can happen when a user
   * modifies the selection with the mouse or the keyboard, or when
   * explicitely calling functions to change the selection.
   */
  

  Glib::SignalProxy0< void > signal_selection_changed();


  /** This signal is emitted when the user "activates" a recent item
   * in the recent chooser.  This can happen by double-clicking on an item
   * in the recently used resources list, or by pressing
   * <keycap>Enter</keycap>.
   */
  

  Glib::SignalProxy0< void > signal_item_activated();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<RecentManager> > property_recent_manager() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_private() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_private() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_tips() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_tips() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_icons() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_icons() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_not_found() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_not_found() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_select_multiple() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_select_multiple() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_local_only() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_local_only() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_limit() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_limit() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<RecentSortType> property_sort_type() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<RecentSortType> property_sort_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<RecentFilter*> property_filter() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<RecentFilter*> property_filter() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:

  // As in editable.hg
  

  // TODO: How to wrap those vfuncs?

  //__CONVERSION(`ListHandle_RecentInfos', `GList*', `($3).data()')
  //__CONVERSION(`Glib::SListHandle<RecentFilter*>', `GSList*', `($3).data()')

  //_WRAP_VFUNC(bool set_current_uri(const Glib::ustring& uri), "set_current_uri", errthrow)
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Glib::ustring get_current_uri_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  //_WRAP_VFUNC(bool select_uri(const Glib::ustring& uri), "select_uri", errthrow)
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void unselect_uri_vfunc(const Glib::ustring& uri);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void select_all_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void unselect_all_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED

  //_WRAP_VFUNC(ArrayHandle_RecentInfos get_items() const, "get_items")
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Glib::RefPtr<RecentManager> get_recent_manager_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void add_filter_vfunc(const RecentFilter& filter);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void remove_filter_vfunc(const RecentFilter& filter);
#endif //GLIBMM_VFUNCS_ENABLED

  //_WRAP_VFUNC(Glib::SListHandle<RecentFilter*> list_filters(), "list_filters")
  //_WRAP_VFUNC(void set_sort_func(const SlotCompare& slot), "set_sort_func")


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};
 
} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::RecentChooser
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gtk::RecentChooser> wrap(GtkRecentChooser* object, bool take_copy = false);

} // namespace Glib


#endif /* _GTKMM_RECENTCHOOSER_H */

