// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_ENTRYCOMPLETION_H
#define _GTKMM_ENTRYCOMPLETION_H


#include <glibmm.h>

/* $Id: entrycompletion.hg,v 1.24 2006/07/19 16:58:50 murrayc Exp $ */

/* Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/widget.h>
#include <gtkmm/treemodel.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkEntryCompletion GtkEntryCompletion;
typedef struct _GtkEntryCompletionClass GtkEntryCompletionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class EntryCompletion_Class; } // namespace Gtk
namespace Gtk
{

class Entry;

//TODO: This should derive+implement from CellLayout, when we can break ABI.

class EntryCompletion : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef EntryCompletion CppObjectType;
  typedef EntryCompletion_Class CppClassType;
  typedef GtkEntryCompletion BaseObjectType;
  typedef GtkEntryCompletionClass BaseClassType;

private:  friend class EntryCompletion_Class;
  static CppClassType entrycompletion_class_;

private:
  // noncopyable
  EntryCompletion(const EntryCompletion&);
  EntryCompletion& operator=(const EntryCompletion&);

protected:
  explicit EntryCompletion(const Glib::ConstructParams& construct_params);
  explicit EntryCompletion(GtkEntryCompletion* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~EntryCompletion();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkEntryCompletion*       gobj()       { return reinterpret_cast<GtkEntryCompletion*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkEntryCompletion* gobj() const { return reinterpret_cast<GtkEntryCompletion*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkEntryCompletion* gobj_copy();

private:


protected:
  EntryCompletion();

public:
  
  static Glib::RefPtr<EntryCompletion> create();


  //Careful, this actually returns a GtkWidget*, so it might not always be a GtkEntry in future GTK+ versions.
  
  /** Gets the entry @a completion  has been attached to.
   * @return The entry @a completion  has been attached to.
   * 
   * @newin2p4.
   */
  Entry* get_entry();
  
  /** Gets the entry @a completion  has been attached to.
   * @return The entry @a completion  has been attached to.
   * 
   * @newin2p4.
   */
  const Entry* get_entry() const;

  
  /** Sets the model for a Gtk::EntryCompletion. If @a completion  already has
   * a model set, it will remove it before setting the new model.
   * If model is <tt>0</tt>, then it will unset the model.
   * 
   * @newin2p4
   * @param model The Gtk::TreeModel.
   */
  void set_model(const Glib::RefPtr<TreeModel>& model);
  
  /** Returns the model the Gtk::EntryCompletion is using as data source.
   * Returns <tt>0</tt> if the model is unset.
   * @return A Gtk::TreeModel, or <tt>0</tt> if none is currently being used.
   * 
   * @newin2p4.
   */
  Glib::RefPtr<TreeModel> get_model();
  
  /** Returns the model the Gtk::EntryCompletion is using as data source.
   * Returns <tt>0</tt> if the model is unset.
   * @return A Gtk::TreeModel, or <tt>0</tt> if none is currently being used.
   * 
   * @newin2p4.
   */
  Glib::RefPtr<const TreeModel> get_model() const;

  /// For example, bool on_match(const Glib::ustring& key, const TreeModel::const_iterator& iter);
  typedef sigc::slot<bool, const Glib::ustring&, const TreeModel::const_iterator&> SlotMatch;
  
  void set_match_func(const SlotMatch& slot);
  
  
  /** Requires the length of the search key for @a completion  to be at least
   *  @a length . This is useful for long lists, where completing using a small
   * key takes a lot of time and will come up with meaningless results anyway
   * (ie, a too large dataset).
   * 
   * @newin2p4
   * @param length The minimum length of the key in order to start completing.
   */
  void set_minimum_key_length(int length);
  
  /** Returns the minimum key length as set for @a completion .
   * @return The currently used minimum key length.
   * 
   * @newin2p4.
   */
  int get_minimum_key_length() const;
  
  /** Requests a completion operation, or in other words a refiltering of the
   * current list with completions, using the current key. The completion list
   * view will be updated accordingly.
   * 
   * @newin2p4
   */
  void complete();

  
  /** Requests a prefix insertion. 
   * 
   * @newin2p6
   */
  void insert_prefix();

  //We reordered the parameters, compared to the C version, so that we can have method overloads without the index.

  // TODO: We would really like an insert() which before-inserts an iterator, like ListStore::insert(),
  // but there is no EntryCompletion::insert_before() for us to use.
  void insert_action_text(const Glib::ustring& text, int index);
  void prepend_action_text(const Glib::ustring& text);
  //TODO: Add append_action_text() somehow? It would be slow if we count the children each time. murrayc.
  
  void insert_action_markup(const Glib::ustring& markup, int index);
  void prepend_action_markup(const Glib::ustring& markup);
  

  //TODO: Change default - it would be nicer to delete the last action instead of the first.
  
  /** Deletes the action at @a index  from @a completion 's action list.
   * 
   * @newin2p4
   * @param index The index of the item to Delete.
   */
  void delete_action(int index = 0);

  
  /** Sets whether the common prefix of the possible completions should
   * be automatically inserted in the entry.
   * 
   * @newin2p6
   * @param inline_completion <tt>true</tt> to do inline completion.
   */
  void set_inline_completion(bool inline_completion = true);
  
  /** Returns whether the common prefix of the possible completions should
   * be automatically inserted in the entry.
   * @return <tt>true</tt> if inline completion is turned on
   * 
   * @newin2p6.
   */
  bool get_inline_completion() const;
  
  /** Sets whether the completions should be presented in a popup window.
   * 
   * @newin2p6
   * @param popup_completion <tt>true</tt> to do popup completion.
   */
  void set_popup_completion(bool popup_completion = true);
  
  /** Returns whether the completions should be presented in a popup window.
   * @return <tt>true</tt> if popup completion is turned on
   * 
   * @newin2p6.
   */
  bool get_popup_completion() const;

  
  /** Sets whether the completion popup window will be resized to be the same
   * width as the entry.
   * 
   * @newin2p8
   * @param popup_set_width <tt>true</tt> to make the width of the popup the same as the entry.
   */
  void set_popup_set_width(bool popup_set_width = true);
  
  /** Returns whether the  completion popup window will be resized to the 
   * width of the entry.
   * @return <tt>true</tt> if the popup window will be resized to the width of 
   * the entry
   * 
   * @newin2p8.
   */
  bool get_popup_set_width() const;
  
  /** Sets whether the completion popup window will appear even if there is
   * only a single match. You may want to set this to <tt>false</tt> if you
   * are using inline
   * completion.
   * 
   * @newin2p8
   * @param popup_single_match <tt>true</tt> if the popup should appear even for a single
   * match.
   */
  void set_popup_single_width(bool popup_single_match = true);
  
  /** Returns whether the completion popup window will appear even if there is
   * only a single match.
   * @return <tt>true</tt> if the popup window will appear regardless of the
   * number of matches.
   * 
   * @newin2p8.
   */
  bool get_popup_single_match() const;

  
  /** Convenience function for setting up the most used case of this code: a
   * completion list with just strings. This function will set up @a completion 
   * to have a list displaying all (and just) strings in the completion list,
   * and to get those strings from @a column  in the model of @a completion .
   * 
   * This functions creates and adds a Gtk::CellRendererText for the selected 
   * column. If you need to set the text column, but don't want the cell 
   * renderer, use Glib::object_set() to set the ::text_column property directly.
   * 
   * @newin2p4
   * @param column The column in the model of @a completion  to get strings from.
   */
  void set_text_column(const TreeModelColumnBase& column);
  
  /** Convenience function for setting up the most used case of this code: a
   * completion list with just strings. This function will set up @a completion 
   * to have a list displaying all (and just) strings in the completion list,
   * and to get those strings from @a column  in the model of @a completion .
   * 
   * This functions creates and adds a Gtk::CellRendererText for the selected 
   * column. If you need to set the text column, but don't want the cell 
   * renderer, use Glib::object_set() to set the ::text_column property directly.
   * 
   * @newin2p4
   * @param column The column in the model of @a completion  to get strings from.
   */
  void set_text_column(int column);
  
  /** Returns the column in the model of @a completion  to get strings from.
   * @return The column containing the strings
   * 
   * @newin2p6.
   */
  int get_text_column();

  /** Emitted when an action is activated.
   *
   * @param index The index of the activated action.
   */
  

  Glib::SignalProxy1< void,int > signal_action_activated();


  //We completely hand-code this signal because we want to change how the parameters are wrapped,
  //because we need both the iter and the model to make the C++ iter.
  

  /** Emitted when a match from the list is selected. 
   * The default behaviour is to replace the contents of the 
   * entry with the contents of the text column in the row 
   * pointed to by @a iter.
   *
   * @param model The TreeModel containing the matches
   * @param iter A TreeModel::iterator positioned at the selected match
   * @result true if the signal has been handled
   * 
   * @par Prototype:
   * <tt>bool %match_selected(const TreeModel::iterator& iter)</tt>
   */
  Glib::SignalProxy1< bool, const TreeModel::iterator& > signal_match_selected();

  
  //We use no_default_handler for this, because we can not add a new vfunc to 2.5 without breaking ABI.
  //TODO: Remove no_default_handler when we do an ABI-break-with-parallel-install.
  /** Emitted when the inline autocompletion is triggered. 
   * The default behaviour is to make the entry display the 
   * whole prefix and select the newly inserted part.
   *
   * Applications may connect to this signal in order to insert only a
   * smaller part of the @a prefix into the entry - e.g. the entry used in
   * the FileChooser inserts only the part of the prefix up to the 
   * next '/'.
   * 
   * @newin2p6
   *
   * @param prefix The common prefix of all possible completions.
   * @result true if the signal has been handled
   */ 
  

  Glib::SignalProxy1< bool,const Glib::ustring& > signal_insert_prefix();
 

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The model to find matches in.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gtk::TreeModel> > property_model() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The model to find matches in.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gtk::TreeModel> > property_model() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Minimum length of the search key in order to look up matches.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_minimum_key_length() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Minimum length of the search key in order to look up matches.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_minimum_key_length() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The column of the model containing the strings.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_text_column() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The column of the model containing the strings.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_text_column() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the common prefix should be inserted automatically.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_inline_completion() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the common prefix should be inserted automatically.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_inline_completion() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the completions should be shown in a popup window.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_popup_completion() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the completions should be shown in a popup window.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_popup_completion() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_popup_set_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_popup_set_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_popup_single_match() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_popup_single_match() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  //Default Signal Handler:
  virtual bool on_match_selected(const TreeModel::iterator& iter);        
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_action_activated(int index);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::EntryCompletion
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gtk::EntryCompletion> wrap(GtkEntryCompletion* object, bool take_copy = false);
}


#endif /* _GTKMM_ENTRYCOMPLETION_H */

