/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Handle;

/**
 * Interface for Sortable models used by {@link TreeView}.
 */
public interface TreeSortable {

    // These methods are implemented in each sortable class, unfortunately.
    // The class TreeSortableHelper has methods that help since Java doesn't
    // have multiple-inheritance.

    /**
     * Get the handle of the object.
     */
    public Handle getHandle();

    /**
     * Set the column in the model to sort on.
     */
    public void setSortColumn(DataColumn column, SortType order);

    /**
     * Get a DataColumn object representing the currently sorted column. This is
     * not the same DataColumn used to create the store. It is only of type
     * DataColumn (not DataColumnString, etc). It can be compared with another
     * DataColumn object using the <tt>{@link DataColumn#equals}</tt> method.
     * 
     * @return A DataColumn object representing the currently sorted column or
     *         <tt>null</tt> if the is no column currently sorted.
     */
    public DataColumn getSortColumn();

    /**
     * Get the current sorting order of the store.
     * 
     * @return A SortType object defining the current sorting order of the store
     *         or <tt>null</tt> if there is no current sort order.
     */
    public SortType getSortOrder();

    /**
     * Set the class used to sort the list according to the values stored in the
     * given DataColumn.
     */
    public void setSortMethod(TreeIterComparison method, DataColumn column);

    /**
     * Call-back method invoked by the JNI code when sorting is required. For
     * internal use only.
     */
    public int handleCompareFunc(Handle model, Handle aIter, Handle bIter,
            int col);

}
