/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;

import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.pango.Attribute;

/**
 *
 */
public class PangoAttrStipple extends Attribute 
{
    public PangoAttrStipple( Bitmap stipple ) {
        super( gdk_pango_attr_stipple_new( stipple.getHandle() ) );
    }

    public Bitmap getStipple() {
        Handle bit = getStipple( getHandle() );
        GObject obj = GObject.getGObjectFromHandle( bit );
        if ( obj == null ) {
            return new Bitmap( bit );
        } else {
            return (Bitmap)obj;
        }
    }

    native static final protected Handle getStipple (Handle obj);
    native static final protected Handle gdk_pango_attr_stipple_new (Handle stipple);
}

