/* puzzle-view.c generated by valac 0.20.1, the Vala compiler
 * generated from puzzle-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_TILE_IMAGE (tile_image_get_type ())
#define TILE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE_IMAGE, TileImage))
#define TILE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE_IMAGE, TileImageClass))
#define IS_TILE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE_IMAGE))
#define IS_TILE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE_IMAGE))
#define TILE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE_IMAGE, TileImageClass))

typedef struct _TileImage TileImage;
typedef struct _TileImageClass TileImageClass;
typedef struct _TileImagePrivate TileImagePrivate;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
#define _tile_unref0(var) ((var == NULL) ? NULL : (var = (tile_unref (var), NULL)))
typedef struct _ParamSpecTileImage ParamSpecTileImage;

#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;
typedef struct _PuzzleViewPrivate PuzzleViewPrivate;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
#define _puzzle_unref0(var) ((var == NULL) ? NULL : (var = (puzzle_unref (var), NULL)))
#define _theme_unref0(var) ((var == NULL) ? NULL : (var = (theme_unref (var), NULL)))
#define _tile_image_unref0(var) ((var == NULL) ? NULL : (var = (tile_image_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _TileImage {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TileImagePrivate * priv;
	Tile* tile;
	gdouble x;
	gdouble y;
	gdouble source_x;
	gdouble source_y;
	gdouble source_time;
	gdouble target_x;
	gdouble target_y;
	gdouble duration;
};

struct _TileImageClass {
	GTypeClass parent_class;
	void (*finalize) (TileImage *self);
};

struct _ParamSpecTileImage {
	GParamSpec parent_instance;
};

struct _PuzzleView {
	GtkDrawingArea parent_instance;
	PuzzleViewPrivate * priv;
};

struct _PuzzleViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _PuzzleViewPrivate {
	Puzzle* _puzzle;
	Theme* theme;
	TileImage* selected_tile;
	guint selection_timeout;
	gdouble selected_x_offset;
	gdouble selected_y_offset;
	GHashTable* tiles;
	GTimer* animation_timer;
	guint animation_timeout;
};


static gpointer tile_image_parent_class = NULL;
static gpointer puzzle_view_parent_class = NULL;

gpointer tile_image_ref (gpointer instance);
void tile_image_unref (gpointer instance);
GParamSpec* param_spec_tile_image (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tile_image (GValue* value, gpointer v_object);
void value_take_tile_image (GValue* value, gpointer v_object);
gpointer value_get_tile_image (const GValue* value);
GType tile_image_get_type (void) G_GNUC_CONST;
gpointer tile_ref (gpointer instance);
void tile_unref (gpointer instance);
GParamSpec* param_spec_tile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tile (GValue* value, gpointer v_object);
void value_take_tile (GValue* value, gpointer v_object);
gpointer value_get_tile (const GValue* value);
GType tile_get_type (void) G_GNUC_CONST;
enum  {
	TILE_IMAGE_DUMMY_PROPERTY
};
TileImage* tile_image_new (Tile* tile);
TileImage* tile_image_construct (GType object_type, Tile* tile);
static void tile_image_finalize (TileImage* obj);
GType puzzle_view_get_type (void) G_GNUC_CONST;
gpointer puzzle_ref (gpointer instance);
void puzzle_unref (gpointer instance);
GParamSpec* param_spec_puzzle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_puzzle (GValue* value, gpointer v_object);
void value_take_puzzle (GValue* value, gpointer v_object);
gpointer value_get_puzzle (const GValue* value);
GType puzzle_get_type (void) G_GNUC_CONST;
gpointer theme_ref (gpointer instance);
void theme_unref (gpointer instance);
GParamSpec* param_spec_theme (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_theme (GValue* value, gpointer v_object);
void value_take_theme (GValue* value, gpointer v_object);
gpointer value_get_theme (const GValue* value);
GType theme_get_type (void) G_GNUC_CONST;
#define PUZZLE_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PUZZLE_VIEW, PuzzleViewPrivate))
enum  {
	PUZZLE_VIEW_DUMMY_PROPERTY,
	PUZZLE_VIEW_PUZZLE
};
#define PUZZLE_VIEW_minimum_size 40
PuzzleView* puzzle_view_new (void);
PuzzleView* puzzle_view_construct (GType object_type);
static void _tile_unref0_ (gpointer var);
static void _tile_image_unref0_ (gpointer var);
Theme* theme_new (void);
Theme* theme_construct (GType object_type);
static void puzzle_view_redraw_tile (PuzzleView* self, TileImage* image);
static void puzzle_view_get_dimensions (PuzzleView* self, guint* x, guint* y, guint* size, guint* gap);
static void puzzle_view_move_tile_to_location (PuzzleView* self, TileImage* image, guint x, guint y, gdouble duration);
Puzzle* puzzle_view_get_puzzle (PuzzleView* self);
guint puzzle_get_size (Puzzle* self);
static void puzzle_view_move_tile (PuzzleView* self, TileImage* image, gdouble x, gdouble y, gdouble duration);
static gboolean puzzle_view_animate_cb (PuzzleView* self);
static gboolean _puzzle_view_animate_cb_gsource_func (gpointer self);
static void puzzle_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural);
static void puzzle_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural);
static void puzzle_view_tile_moved_cb (PuzzleView* self, Puzzle* puzzle, Tile* tile, guint x, guint y);
static gboolean puzzle_view_real_configure_event (GtkWidget* base, GdkEventConfigure* event);
void puzzle_get_tile_location (Puzzle* self, Tile* tile, guint* x, guint* y);
static gboolean puzzle_view_real_draw (GtkWidget* base, cairo_t* context);
void theme_draw_arrow (Theme* self, cairo_t* context, guint size, guint gap);
void theme_draw_socket (Theme* self, cairo_t* context, guint size);
gboolean puzzle_get_paused (Puzzle* self);
void theme_draw_paused_tile (Theme* self, cairo_t* context, guint size);
void theme_draw_tile (Theme* self, cairo_t* context, guint size, Tile* tile);
static void puzzle_view_pick_tile (PuzzleView* self, gdouble x, gdouble y);
gboolean puzzle_get_is_solved (Puzzle* self);
static gboolean puzzle_view_selection_timeout_cb (PuzzleView* self);
static gboolean _puzzle_view_selection_timeout_cb_gsource_func (gpointer self);
static void puzzle_view_drop_tile (PuzzleView* self, gdouble x, gdouble y);
gboolean puzzle_can_switch (Puzzle* self, guint x0, guint y0, guint x1, guint y1);
void puzzle_switch_tiles (Puzzle* self, guint x0, guint y0, guint x1, guint y1);
static gboolean puzzle_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static gboolean puzzle_view_real_button_release_event (GtkWidget* base, GdkEventButton* event);
static gboolean puzzle_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event);
void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value);
Tile* puzzle_get_tile (Puzzle* self, guint x, guint y);
static void _puzzle_view_tile_moved_cb_puzzle_tile_moved (Puzzle* _sender, Tile* tile, guint x, guint y, gpointer self);
static void _puzzle_view_puzzle___lambda2_ (PuzzleView* self);
static void __puzzle_view_puzzle___lambda2__puzzle_paused_changed (Puzzle* _sender, gpointer self);
static void puzzle_view_finalize (GObject* obj);
static void _vala_puzzle_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_puzzle_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _tile_ref0 (gpointer self) {
	return self ? tile_ref (self) : NULL;
}


TileImage* tile_image_construct (GType object_type, Tile* tile) {
	TileImage* self = NULL;
	Tile* _tmp0_;
	Tile* _tmp1_;
	g_return_val_if_fail (tile != NULL, NULL);
	self = (TileImage*) g_type_create_instance (object_type);
	_tmp0_ = tile;
	_tmp1_ = _tile_ref0 (_tmp0_);
	_tile_unref0 (self->tile);
	self->tile = _tmp1_;
	return self;
}


TileImage* tile_image_new (Tile* tile) {
	return tile_image_construct (TYPE_TILE_IMAGE, tile);
}


static void value_tile_image_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_tile_image_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tile_image_unref (value->data[0].v_pointer);
	}
}


static void value_tile_image_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tile_image_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_tile_image_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_tile_image_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TileImage* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tile_image_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_tile_image_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TileImage** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tile_image_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_tile_image (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTileImage* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TILE_IMAGE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_tile_image (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TILE_IMAGE), NULL);
	return value->data[0].v_pointer;
}


void value_set_tile_image (GValue* value, gpointer v_object) {
	TileImage* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TILE_IMAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TILE_IMAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tile_image_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tile_image_unref (old);
	}
}


void value_take_tile_image (GValue* value, gpointer v_object) {
	TileImage* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TILE_IMAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TILE_IMAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tile_image_unref (old);
	}
}


static void tile_image_class_init (TileImageClass * klass) {
	tile_image_parent_class = g_type_class_peek_parent (klass);
	TILE_IMAGE_CLASS (klass)->finalize = tile_image_finalize;
}


static void tile_image_instance_init (TileImage * self) {
	self->ref_count = 1;
}


static void tile_image_finalize (TileImage* obj) {
	TileImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TILE_IMAGE, TileImage);
	_tile_unref0 (self->tile);
}


GType tile_image_get_type (void) {
	static volatile gsize tile_image_type_id__volatile = 0;
	if (g_once_init_enter (&tile_image_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_tile_image_init, value_tile_image_free_value, value_tile_image_copy_value, value_tile_image_peek_pointer, "p", value_tile_image_collect_value, "p", value_tile_image_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TileImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tile_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TileImage), 0, (GInstanceInitFunc) tile_image_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tile_image_type_id;
		tile_image_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TileImage", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tile_image_type_id__volatile, tile_image_type_id);
	}
	return tile_image_type_id__volatile;
}


gpointer tile_image_ref (gpointer instance) {
	TileImage* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void tile_image_unref (gpointer instance) {
	TileImage* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TILE_IMAGE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _tile_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (tile_unref (var), NULL));
}


static void _tile_image_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (tile_image_unref (var), NULL));
}


PuzzleView* puzzle_view_construct (GType object_type) {
	PuzzleView * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	Theme* _tmp3_;
	GTimer* _tmp4_;
	GTimer* _tmp5_;
	self = (PuzzleView*) g_object_new (object_type, NULL);
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_POINTER_MOTION_MASK) | GDK_BUTTON_RELEASE_MASK));
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _tile_unref0_, _tile_image_unref0_);
	_g_hash_table_unref0 (self->priv->tiles);
	self->priv->tiles = _tmp2_;
	_tmp3_ = theme_new ();
	_theme_unref0 (self->priv->theme);
	self->priv->theme = _tmp3_;
	_tmp4_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->animation_timer);
	self->priv->animation_timer = _tmp4_;
	_tmp5_ = self->priv->animation_timer;
	g_timer_start (_tmp5_);
	return self;
}


PuzzleView* puzzle_view_new (void) {
	return puzzle_view_construct (TYPE_PUZZLE_VIEW);
}


static void puzzle_view_redraw_tile (PuzzleView* self, TileImage* image) {
	guint x_offset = 0U;
	guint y_offset = 0U;
	guint size = 0U;
	guint gap = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	TileImage* _tmp4_;
	gdouble _tmp5_;
	TileImage* _tmp6_;
	gdouble _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	puzzle_view_get_dimensions (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x_offset = _tmp0_;
	y_offset = _tmp1_;
	size = _tmp2_;
	gap = _tmp3_;
	_tmp4_ = image;
	_tmp5_ = _tmp4_->x;
	_tmp6_ = image;
	_tmp7_ = _tmp6_->y;
	gtk_widget_queue_draw_area ((GtkWidget*) self, (gint) (_tmp5_ + 0.5), (gint) (_tmp7_ + 0.5), (gint) size, (gint) size);
}


static void puzzle_view_move_tile_to_location (PuzzleView* self, TileImage* image, guint x, guint y, gdouble duration) {
	guint x_offset = 0U;
	guint y_offset = 0U;
	guint size = 0U;
	guint gap = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	guint target_x;
	guint _tmp7_;
	Puzzle* _tmp8_;
	Puzzle* _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	guint _tmp14_;
	guint _tmp15_;
	guint _tmp16_;
	guint target_y;
	TileImage* _tmp17_;
	guint _tmp18_;
	gdouble _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	puzzle_view_get_dimensions (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x_offset = _tmp0_;
	y_offset = _tmp1_;
	size = _tmp2_;
	gap = _tmp3_;
	_tmp4_ = x_offset;
	_tmp5_ = x;
	_tmp6_ = size;
	target_x = _tmp4_ + (_tmp5_ * _tmp6_);
	_tmp7_ = x;
	_tmp8_ = puzzle_view_get_puzzle (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = puzzle_get_size (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp7_ >= _tmp11_) {
		guint _tmp12_;
		guint _tmp13_;
		_tmp12_ = target_x;
		_tmp13_ = gap;
		target_x = _tmp12_ + _tmp13_;
	}
	_tmp14_ = y_offset;
	_tmp15_ = y;
	_tmp16_ = size;
	target_y = _tmp14_ + (_tmp15_ * _tmp16_);
	_tmp17_ = image;
	_tmp18_ = target_x;
	_tmp19_ = duration;
	puzzle_view_move_tile (self, _tmp17_, (gdouble) _tmp18_, (gdouble) target_y, _tmp19_);
}


static gboolean _puzzle_view_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = puzzle_view_animate_cb (self);
	return result;
}


static void puzzle_view_move_tile (PuzzleView* self, TileImage* image, gdouble x, gdouble y, gdouble duration) {
	gboolean _tmp0_ = FALSE;
	TileImage* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gboolean _tmp7_;
	TileImage* _tmp8_;
	TileImage* _tmp9_;
	gdouble _tmp10_;
	TileImage* _tmp11_;
	TileImage* _tmp12_;
	gdouble _tmp13_;
	TileImage* _tmp14_;
	GTimer* _tmp15_;
	gdouble _tmp16_ = 0.0;
	TileImage* _tmp17_;
	gdouble _tmp18_;
	TileImage* _tmp19_;
	gdouble _tmp20_;
	TileImage* _tmp21_;
	gdouble _tmp22_;
	gdouble _tmp23_;
	guint _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	_tmp1_ = image;
	_tmp2_ = _tmp1_->x;
	_tmp3_ = x;
	if (_tmp2_ == _tmp3_) {
		TileImage* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		_tmp4_ = image;
		_tmp5_ = _tmp4_->y;
		_tmp6_ = y;
		_tmp0_ = _tmp5_ == _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		return;
	}
	_tmp8_ = image;
	_tmp9_ = image;
	_tmp10_ = _tmp9_->x;
	_tmp8_->source_x = _tmp10_;
	_tmp11_ = image;
	_tmp12_ = image;
	_tmp13_ = _tmp12_->y;
	_tmp11_->source_y = _tmp13_;
	_tmp14_ = image;
	_tmp15_ = self->priv->animation_timer;
	_tmp16_ = g_timer_elapsed (_tmp15_, NULL);
	_tmp14_->source_time = _tmp16_;
	_tmp17_ = image;
	_tmp18_ = x;
	_tmp17_->target_x = _tmp18_;
	_tmp19_ = image;
	_tmp20_ = y;
	_tmp19_->target_y = _tmp20_;
	_tmp21_ = image;
	_tmp22_ = duration;
	_tmp21_->duration = _tmp22_;
	_tmp23_ = duration;
	if (_tmp23_ == ((gdouble) 0)) {
		TileImage* _tmp24_;
		TileImage* _tmp25_;
		TileImage* _tmp26_;
		gdouble _tmp27_;
		TileImage* _tmp28_;
		TileImage* _tmp29_;
		gdouble _tmp30_;
		TileImage* _tmp31_;
		_tmp24_ = image;
		puzzle_view_redraw_tile (self, _tmp24_);
		_tmp25_ = image;
		_tmp26_ = image;
		_tmp27_ = _tmp26_->target_x;
		_tmp25_->x = _tmp27_;
		_tmp28_ = image;
		_tmp29_ = image;
		_tmp30_ = _tmp29_->target_y;
		_tmp28_->y = _tmp30_;
		_tmp31_ = image;
		puzzle_view_redraw_tile (self, _tmp31_);
		return;
	}
	_tmp32_ = self->priv->animation_timeout;
	if (_tmp32_ == ((guint) 0)) {
		guint _tmp33_ = 0U;
		_tmp33_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 10, _puzzle_view_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->animation_timeout = _tmp33_;
	}
}


static gpointer _tile_image_ref0 (gpointer self) {
	return self ? tile_image_ref (self) : NULL;
}


static gboolean puzzle_view_animate_cb (PuzzleView* self) {
	gboolean result = FALSE;
	GTimer* _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble t;
	guint x_offset = 0U;
	guint y_offset = 0U;
	guint size = 0U;
	guint gap = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	gboolean animating;
	GHashTable* _tmp6_;
	GHashTableIter iter = {0};
	gboolean _tmp56_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->animation_timer;
	_tmp1_ = g_timer_elapsed (_tmp0_, NULL);
	t = _tmp1_;
	puzzle_view_get_dimensions (self, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	x_offset = _tmp2_;
	y_offset = _tmp3_;
	size = _tmp4_;
	gap = _tmp5_;
	animating = FALSE;
	_tmp6_ = self->priv->tiles;
	g_hash_table_iter_init (&iter, _tmp6_);
	while (TRUE) {
		Tile* tile = NULL;
		TileImage* image = NULL;
		gconstpointer _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		Tile* _tmp10_;
		TileImage* _tmp11_;
		gboolean _tmp12_ = FALSE;
		TileImage* _tmp13_;
		gdouble _tmp14_;
		TileImage* _tmp15_;
		gdouble _tmp16_;
		gboolean _tmp21_;
		TileImage* _tmp22_;
		gdouble _tmp23_;
		TileImage* _tmp24_;
		gdouble _tmp25_;
		TileImage* _tmp26_;
		gdouble _tmp27_;
		TileImage* _tmp55_;
		_tmp9_ = g_hash_table_iter_next (&iter, &_tmp7_, &_tmp8_);
		_tile_unref0 (tile);
		_tmp10_ = _tile_ref0 (_tmp7_);
		tile = _tmp10_;
		_tile_image_unref0 (image);
		_tmp11_ = _tile_image_ref0 (_tmp8_);
		image = _tmp11_;
		if (!_tmp9_) {
			_tile_image_unref0 (image);
			_tile_unref0 (tile);
			break;
		}
		_tmp13_ = image;
		_tmp14_ = _tmp13_->x;
		_tmp15_ = image;
		_tmp16_ = _tmp15_->target_x;
		if (_tmp14_ == _tmp16_) {
			TileImage* _tmp17_;
			gdouble _tmp18_;
			TileImage* _tmp19_;
			gdouble _tmp20_;
			_tmp17_ = image;
			_tmp18_ = _tmp17_->y;
			_tmp19_ = image;
			_tmp20_ = _tmp19_->target_y;
			_tmp12_ = _tmp18_ == _tmp20_;
		} else {
			_tmp12_ = FALSE;
		}
		_tmp21_ = _tmp12_;
		if (_tmp21_) {
			_tile_image_unref0 (image);
			_tile_unref0 (tile);
			continue;
		}
		_tmp22_ = image;
		puzzle_view_redraw_tile (self, _tmp22_);
		_tmp23_ = t;
		_tmp24_ = image;
		_tmp25_ = _tmp24_->source_time;
		_tmp26_ = image;
		_tmp27_ = _tmp26_->duration;
		if (_tmp23_ >= (_tmp25_ + _tmp27_)) {
			TileImage* _tmp28_;
			TileImage* _tmp29_;
			gdouble _tmp30_;
			TileImage* _tmp31_;
			TileImage* _tmp32_;
			gdouble _tmp33_;
			_tmp28_ = image;
			_tmp29_ = image;
			_tmp30_ = _tmp29_->target_x;
			_tmp28_->x = _tmp30_;
			_tmp31_ = image;
			_tmp32_ = image;
			_tmp33_ = _tmp32_->target_y;
			_tmp31_->y = _tmp33_;
		} else {
			gdouble _tmp34_;
			TileImage* _tmp35_;
			gdouble _tmp36_;
			TileImage* _tmp37_;
			gdouble _tmp38_;
			gdouble d;
			TileImage* _tmp39_;
			TileImage* _tmp40_;
			gdouble _tmp41_;
			TileImage* _tmp42_;
			gdouble _tmp43_;
			TileImage* _tmp44_;
			gdouble _tmp45_;
			gdouble _tmp46_;
			TileImage* _tmp47_;
			TileImage* _tmp48_;
			gdouble _tmp49_;
			TileImage* _tmp50_;
			gdouble _tmp51_;
			TileImage* _tmp52_;
			gdouble _tmp53_;
			gdouble _tmp54_;
			_tmp34_ = t;
			_tmp35_ = image;
			_tmp36_ = _tmp35_->source_time;
			_tmp37_ = image;
			_tmp38_ = _tmp37_->duration;
			d = (_tmp34_ - _tmp36_) / _tmp38_;
			_tmp39_ = image;
			_tmp40_ = image;
			_tmp41_ = _tmp40_->source_x;
			_tmp42_ = image;
			_tmp43_ = _tmp42_->target_x;
			_tmp44_ = image;
			_tmp45_ = _tmp44_->source_x;
			_tmp46_ = d;
			_tmp39_->x = _tmp41_ + ((_tmp43_ - _tmp45_) * _tmp46_);
			_tmp47_ = image;
			_tmp48_ = image;
			_tmp49_ = _tmp48_->source_y;
			_tmp50_ = image;
			_tmp51_ = _tmp50_->target_y;
			_tmp52_ = image;
			_tmp53_ = _tmp52_->source_y;
			_tmp54_ = d;
			_tmp47_->y = _tmp49_ + ((_tmp51_ - _tmp53_) * _tmp54_);
			animating = TRUE;
		}
		_tmp55_ = image;
		puzzle_view_redraw_tile (self, _tmp55_);
		_tile_image_unref0 (image);
		_tile_unref0 (tile);
	}
	_tmp56_ = animating;
	if (_tmp56_) {
		result = TRUE;
		return result;
	}
	self->priv->animation_timeout = (guint) 0;
	result = FALSE;
	return result;
}


static void puzzle_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural) {
	PuzzleView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint size;
	Puzzle* _tmp0_;
	Puzzle* _tmp1_;
	gint _tmp6_;
	gint _tmp7_ = 0;
	self = (PuzzleView*) base;
	size = 0;
	_tmp0_ = puzzle_view_get_puzzle (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		Puzzle* _tmp2_;
		Puzzle* _tmp3_;
		guint _tmp4_;
		guint _tmp5_;
		_tmp2_ = puzzle_view_get_puzzle (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = puzzle_get_size (_tmp3_);
		_tmp5_ = _tmp4_;
		size = (gint) (((_tmp5_ * 2) + 1.5) * PUZZLE_VIEW_minimum_size);
	}
	_tmp6_ = size;
	_tmp7_ = MAX (_tmp6_, 500);
	_vala_natural = _tmp7_;
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void puzzle_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural) {
	PuzzleView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint size;
	Puzzle* _tmp0_;
	Puzzle* _tmp1_;
	gint _tmp6_;
	gint _tmp7_ = 0;
	self = (PuzzleView*) base;
	size = 0;
	_tmp0_ = puzzle_view_get_puzzle (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		Puzzle* _tmp2_;
		Puzzle* _tmp3_;
		guint _tmp4_;
		guint _tmp5_;
		_tmp2_ = puzzle_view_get_puzzle (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = puzzle_get_size (_tmp3_);
		_tmp5_ = _tmp4_;
		size = (gint) ((_tmp5_ + 1) * PUZZLE_VIEW_minimum_size);
	}
	_tmp6_ = size;
	_tmp7_ = MAX (_tmp6_, 300);
	_vala_natural = _tmp7_;
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void puzzle_view_get_dimensions (PuzzleView* self, guint* x, guint* y, guint* size, guint* gap) {
	guint _vala_x = 0U;
	guint _vala_y = 0U;
	guint _vala_size = 0U;
	guint _vala_gap = 0U;
	gint _tmp0_ = 0;
	Puzzle* _tmp1_;
	Puzzle* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint width;
	gint _tmp5_ = 0;
	Puzzle* _tmp6_;
	Puzzle* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	guint height;
	guint _tmp10_ = 0U;
	gint _tmp11_ = 0;
	Puzzle* _tmp12_;
	Puzzle* _tmp13_;
	guint _tmp14_;
	guint _tmp15_;
	gint _tmp16_ = 0;
	Puzzle* _tmp17_;
	Puzzle* _tmp18_;
	guint _tmp19_;
	guint _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = puzzle_view_get_puzzle (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = puzzle_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	width = (guint) (_tmp0_ / ((2 * _tmp4_) + 1.5));
	_tmp5_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp6_ = puzzle_view_get_puzzle (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = puzzle_get_size (_tmp7_);
	_tmp9_ = _tmp8_;
	height = (guint) (_tmp5_ / (_tmp9_ + 1));
	_tmp10_ = MIN (width, height);
	_vala_size = _tmp10_;
	_vala_gap = _vala_size / 2;
	_tmp11_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp12_ = puzzle_view_get_puzzle (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = puzzle_get_size (_tmp13_);
	_tmp15_ = _tmp14_;
	_vala_x = ((_tmp11_ - ((2 * _tmp15_) * _vala_size)) - _vala_gap) / 2;
	_tmp16_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp17_ = puzzle_view_get_puzzle (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = puzzle_get_size (_tmp18_);
	_tmp20_ = _tmp19_;
	_vala_y = (_tmp16_ - (_tmp20_ * _vala_size)) / 2;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (size) {
		*size = _vala_size;
	}
	if (gap) {
		*gap = _vala_gap;
	}
}


static void puzzle_view_tile_moved_cb (PuzzleView* self, Puzzle* puzzle, Tile* tile, guint x, guint y) {
	GHashTable* _tmp0_;
	Tile* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	guint _tmp3_;
	guint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (puzzle != NULL);
	g_return_if_fail (tile != NULL);
	_tmp0_ = self->priv->tiles;
	_tmp1_ = tile;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = x;
	_tmp4_ = y;
	puzzle_view_move_tile_to_location (self, (TileImage*) _tmp2_, _tmp3_, _tmp4_, 0.2);
}


static gboolean puzzle_view_real_configure_event (GtkWidget* base, GdkEventConfigure* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	GHashTable* _tmp0_;
	GHashTableIter iter = {0};
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->tiles;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		Tile* tile = NULL;
		TileImage* image = NULL;
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		Tile* _tmp4_;
		TileImage* _tmp5_;
		guint x = 0U;
		guint y = 0U;
		Puzzle* _tmp6_;
		Puzzle* _tmp7_;
		Tile* _tmp8_;
		guint _tmp9_ = 0U;
		guint _tmp10_ = 0U;
		TileImage* _tmp11_;
		guint _tmp12_;
		guint _tmp13_;
		_tmp3_ = g_hash_table_iter_next (&iter, &_tmp1_, &_tmp2_);
		_tile_unref0 (tile);
		_tmp4_ = _tile_ref0 (_tmp1_);
		tile = _tmp4_;
		_tile_image_unref0 (image);
		_tmp5_ = _tile_image_ref0 (_tmp2_);
		image = _tmp5_;
		if (!_tmp3_) {
			_tile_image_unref0 (image);
			_tile_unref0 (tile);
			break;
		}
		_tmp6_ = puzzle_view_get_puzzle (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = tile;
		puzzle_get_tile_location (_tmp7_, _tmp8_, &_tmp9_, &_tmp10_);
		x = _tmp9_;
		y = _tmp10_;
		_tmp11_ = image;
		_tmp12_ = x;
		_tmp13_ = y;
		puzzle_view_move_tile_to_location (self, _tmp11_, _tmp12_, _tmp13_, (gdouble) 0);
		_tile_image_unref0 (image);
		_tile_unref0 (tile);
	}
	_tile_image_unref0 (self->priv->selected_tile);
	self->priv->selected_tile = NULL;
	result = FALSE;
	return result;
}


static gboolean puzzle_view_real_draw (GtkWidget* base, cairo_t* context) {
	PuzzleView * self;
	gboolean result = FALSE;
	Puzzle* _tmp0_;
	Puzzle* _tmp1_;
	guint x_offset = 0U;
	guint y_offset = 0U;
	guint size = 0U;
	guint gap = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	cairo_t* _tmp6_;
	guint _tmp7_;
	gdouble w;
	guint _tmp8_;
	Puzzle* _tmp9_;
	Puzzle* _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	gdouble _tmp15_;
	gdouble ax;
	guint _tmp16_;
	Puzzle* _tmp17_;
	Puzzle* _tmp18_;
	guint _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	gdouble ay;
	cairo_t* _tmp22_;
	gdouble _tmp23_;
	gdouble _tmp24_;
	Theme* _tmp25_;
	cairo_t* _tmp26_;
	guint _tmp27_;
	guint _tmp28_;
	cairo_t* _tmp29_;
	GHashTable* _tmp71_;
	GHashTableIter iter = {0};
	GHashTable* _tmp109_;
	Puzzle* _tmp147_;
	Puzzle* _tmp148_;
	gboolean _tmp149_;
	gboolean _tmp150_;
	self = (PuzzleView*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = puzzle_view_get_puzzle (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	puzzle_view_get_dimensions (self, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	x_offset = _tmp2_;
	y_offset = _tmp3_;
	size = _tmp4_;
	gap = _tmp5_;
	_tmp6_ = context;
	cairo_save (_tmp6_);
	_tmp7_ = gap;
	w = _tmp7_ * 0.5;
	_tmp8_ = x_offset;
	_tmp9_ = puzzle_view_get_puzzle (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = puzzle_get_size (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = size;
	_tmp14_ = gap;
	_tmp15_ = w;
	ax = (_tmp8_ + (_tmp12_ * _tmp13_)) + ((_tmp14_ - _tmp15_) * 0.5);
	_tmp16_ = y_offset;
	_tmp17_ = puzzle_view_get_puzzle (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = puzzle_get_size (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = size;
	ay = _tmp16_ + ((_tmp20_ * _tmp21_) * 0.5);
	_tmp22_ = context;
	_tmp23_ = ax;
	_tmp24_ = ay;
	cairo_translate (_tmp22_, _tmp23_, _tmp24_);
	_tmp25_ = self->priv->theme;
	_tmp26_ = context;
	_tmp27_ = size;
	_tmp28_ = gap;
	theme_draw_arrow (_tmp25_, _tmp26_, _tmp27_, _tmp28_);
	_tmp29_ = context;
	cairo_restore (_tmp29_);
	{
		gint y;
		y = 0;
		{
			gboolean _tmp30_;
			_tmp30_ = TRUE;
			while (TRUE) {
				gboolean _tmp31_;
				gint _tmp33_;
				Puzzle* _tmp34_;
				Puzzle* _tmp35_;
				guint _tmp36_;
				guint _tmp37_;
				_tmp31_ = _tmp30_;
				if (!_tmp31_) {
					gint _tmp32_;
					_tmp32_ = y;
					y = _tmp32_ + 1;
				}
				_tmp30_ = FALSE;
				_tmp33_ = y;
				_tmp34_ = puzzle_view_get_puzzle (self);
				_tmp35_ = _tmp34_;
				_tmp36_ = puzzle_get_size (_tmp35_);
				_tmp37_ = _tmp36_;
				if (!(((guint) _tmp33_) < _tmp37_)) {
					break;
				}
				{
					gint x;
					x = 0;
					{
						gboolean _tmp38_;
						_tmp38_ = TRUE;
						while (TRUE) {
							gboolean _tmp39_;
							gint _tmp41_;
							Puzzle* _tmp42_;
							Puzzle* _tmp43_;
							guint _tmp44_;
							guint _tmp45_;
							cairo_t* _tmp46_;
							gint _tmp47_;
							Puzzle* _tmp48_;
							Puzzle* _tmp49_;
							guint _tmp50_;
							guint _tmp51_;
							Theme* _tmp67_;
							cairo_t* _tmp68_;
							guint _tmp69_;
							cairo_t* _tmp70_;
							_tmp39_ = _tmp38_;
							if (!_tmp39_) {
								gint _tmp40_;
								_tmp40_ = x;
								x = _tmp40_ + 1;
							}
							_tmp38_ = FALSE;
							_tmp41_ = x;
							_tmp42_ = puzzle_view_get_puzzle (self);
							_tmp43_ = _tmp42_;
							_tmp44_ = puzzle_get_size (_tmp43_);
							_tmp45_ = _tmp44_;
							if (!(((guint) _tmp41_) < (_tmp45_ * 2))) {
								break;
							}
							_tmp46_ = context;
							cairo_save (_tmp46_);
							_tmp47_ = x;
							_tmp48_ = puzzle_view_get_puzzle (self);
							_tmp49_ = _tmp48_;
							_tmp50_ = puzzle_get_size (_tmp49_);
							_tmp51_ = _tmp50_;
							if (((guint) _tmp47_) >= _tmp51_) {
								cairo_t* _tmp52_;
								guint _tmp53_;
								guint _tmp54_;
								gint _tmp55_;
								guint _tmp56_;
								guint _tmp57_;
								gint _tmp58_;
								guint _tmp59_;
								_tmp52_ = context;
								_tmp53_ = x_offset;
								_tmp54_ = gap;
								_tmp55_ = x;
								_tmp56_ = size;
								_tmp57_ = y_offset;
								_tmp58_ = y;
								_tmp59_ = size;
								cairo_translate (_tmp52_, (gdouble) ((_tmp53_ + _tmp54_) + (_tmp55_ * _tmp56_)), (gdouble) (_tmp57_ + (_tmp58_ * _tmp59_)));
							} else {
								cairo_t* _tmp60_;
								guint _tmp61_;
								gint _tmp62_;
								guint _tmp63_;
								guint _tmp64_;
								gint _tmp65_;
								guint _tmp66_;
								_tmp60_ = context;
								_tmp61_ = x_offset;
								_tmp62_ = x;
								_tmp63_ = size;
								_tmp64_ = y_offset;
								_tmp65_ = y;
								_tmp66_ = size;
								cairo_translate (_tmp60_, (gdouble) (_tmp61_ + (_tmp62_ * _tmp63_)), (gdouble) (_tmp64_ + (_tmp65_ * _tmp66_)));
							}
							_tmp67_ = self->priv->theme;
							_tmp68_ = context;
							_tmp69_ = size;
							theme_draw_socket (_tmp67_, _tmp68_, _tmp69_);
							_tmp70_ = context;
							cairo_restore (_tmp70_);
						}
					}
				}
			}
		}
	}
	_tmp71_ = self->priv->tiles;
	g_hash_table_iter_init (&iter, _tmp71_);
	while (TRUE) {
		Tile* tile = NULL;
		TileImage* image = NULL;
		gconstpointer _tmp72_ = NULL;
		gconstpointer _tmp73_ = NULL;
		gboolean _tmp74_ = FALSE;
		Tile* _tmp75_;
		TileImage* _tmp76_;
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_ = FALSE;
		TileImage* _tmp79_;
		TileImage* _tmp80_;
		gboolean _tmp85_;
		gboolean _tmp90_;
		cairo_t* _tmp91_;
		cairo_t* _tmp92_;
		TileImage* _tmp93_;
		gdouble _tmp94_;
		TileImage* _tmp95_;
		gdouble _tmp96_;
		Puzzle* _tmp97_;
		Puzzle* _tmp98_;
		gboolean _tmp99_;
		gboolean _tmp100_;
		cairo_t* _tmp108_;
		_tmp74_ = g_hash_table_iter_next (&iter, &_tmp72_, &_tmp73_);
		_tile_unref0 (tile);
		_tmp75_ = _tile_ref0 (_tmp72_);
		tile = _tmp75_;
		_tile_image_unref0 (image);
		_tmp76_ = _tile_image_ref0 (_tmp73_);
		image = _tmp76_;
		if (!_tmp74_) {
			_tile_image_unref0 (image);
			_tile_unref0 (tile);
			break;
		}
		_tmp79_ = image;
		_tmp80_ = self->priv->selected_tile;
		if (_tmp79_ == _tmp80_) {
			_tmp78_ = TRUE;
		} else {
			TileImage* _tmp81_;
			gdouble _tmp82_;
			TileImage* _tmp83_;
			gdouble _tmp84_;
			_tmp81_ = image;
			_tmp82_ = _tmp81_->x;
			_tmp83_ = image;
			_tmp84_ = _tmp83_->target_x;
			_tmp78_ = _tmp82_ != _tmp84_;
		}
		_tmp85_ = _tmp78_;
		if (_tmp85_) {
			_tmp77_ = TRUE;
		} else {
			TileImage* _tmp86_;
			gdouble _tmp87_;
			TileImage* _tmp88_;
			gdouble _tmp89_;
			_tmp86_ = image;
			_tmp87_ = _tmp86_->y;
			_tmp88_ = image;
			_tmp89_ = _tmp88_->target_y;
			_tmp77_ = _tmp87_ != _tmp89_;
		}
		_tmp90_ = _tmp77_;
		if (_tmp90_) {
			_tile_image_unref0 (image);
			_tile_unref0 (tile);
			continue;
		}
		_tmp91_ = context;
		cairo_save (_tmp91_);
		_tmp92_ = context;
		_tmp93_ = image;
		_tmp94_ = _tmp93_->x;
		_tmp95_ = image;
		_tmp96_ = _tmp95_->y;
		cairo_translate (_tmp92_, (gdouble) ((gint) (_tmp94_ + 0.5)), (gdouble) ((gint) (_tmp96_ + 0.5)));
		_tmp97_ = puzzle_view_get_puzzle (self);
		_tmp98_ = _tmp97_;
		_tmp99_ = puzzle_get_paused (_tmp98_);
		_tmp100_ = _tmp99_;
		if (_tmp100_) {
			Theme* _tmp101_;
			cairo_t* _tmp102_;
			guint _tmp103_;
			_tmp101_ = self->priv->theme;
			_tmp102_ = context;
			_tmp103_ = size;
			theme_draw_paused_tile (_tmp101_, _tmp102_, _tmp103_);
		} else {
			Theme* _tmp104_;
			cairo_t* _tmp105_;
			guint _tmp106_;
			Tile* _tmp107_;
			_tmp104_ = self->priv->theme;
			_tmp105_ = context;
			_tmp106_ = size;
			_tmp107_ = tile;
			theme_draw_tile (_tmp104_, _tmp105_, _tmp106_, _tmp107_);
		}
		_tmp108_ = context;
		cairo_restore (_tmp108_);
		_tile_image_unref0 (image);
		_tile_unref0 (tile);
	}
	_tmp109_ = self->priv->tiles;
	g_hash_table_iter_init (&iter, _tmp109_);
	while (TRUE) {
		Tile* tile = NULL;
		TileImage* image = NULL;
		gconstpointer _tmp110_ = NULL;
		gconstpointer _tmp111_ = NULL;
		gboolean _tmp112_ = FALSE;
		Tile* _tmp113_;
		TileImage* _tmp114_;
		gboolean _tmp115_ = FALSE;
		gboolean _tmp116_ = FALSE;
		TileImage* _tmp117_;
		TileImage* _tmp118_;
		gboolean _tmp123_;
		gboolean _tmp128_;
		cairo_t* _tmp129_;
		cairo_t* _tmp130_;
		TileImage* _tmp131_;
		gdouble _tmp132_;
		TileImage* _tmp133_;
		gdouble _tmp134_;
		Puzzle* _tmp135_;
		Puzzle* _tmp136_;
		gboolean _tmp137_;
		gboolean _tmp138_;
		cairo_t* _tmp146_;
		_tmp112_ = g_hash_table_iter_next (&iter, &_tmp110_, &_tmp111_);
		_tile_unref0 (tile);
		_tmp113_ = _tile_ref0 (_tmp110_);
		tile = _tmp113_;
		_tile_image_unref0 (image);
		_tmp114_ = _tile_image_ref0 (_tmp111_);
		image = _tmp114_;
		if (!_tmp112_) {
			_tile_image_unref0 (image);
			_tile_unref0 (tile);
			break;
		}
		_tmp117_ = image;
		_tmp118_ = self->priv->selected_tile;
		if (_tmp117_ != _tmp118_) {
			TileImage* _tmp119_;
			gdouble _tmp120_;
			TileImage* _tmp121_;
			gdouble _tmp122_;
			_tmp119_ = image;
			_tmp120_ = _tmp119_->x;
			_tmp121_ = image;
			_tmp122_ = _tmp121_->target_x;
			_tmp116_ = _tmp120_ == _tmp122_;
		} else {
			_tmp116_ = FALSE;
		}
		_tmp123_ = _tmp116_;
		if (_tmp123_) {
			TileImage* _tmp124_;
			gdouble _tmp125_;
			TileImage* _tmp126_;
			gdouble _tmp127_;
			_tmp124_ = image;
			_tmp125_ = _tmp124_->y;
			_tmp126_ = image;
			_tmp127_ = _tmp126_->target_y;
			_tmp115_ = _tmp125_ == _tmp127_;
		} else {
			_tmp115_ = FALSE;
		}
		_tmp128_ = _tmp115_;
		if (_tmp128_) {
			_tile_image_unref0 (image);
			_tile_unref0 (tile);
			continue;
		}
		_tmp129_ = context;
		cairo_save (_tmp129_);
		_tmp130_ = context;
		_tmp131_ = image;
		_tmp132_ = _tmp131_->x;
		_tmp133_ = image;
		_tmp134_ = _tmp133_->y;
		cairo_translate (_tmp130_, (gdouble) ((gint) (_tmp132_ + 0.5)), (gdouble) ((gint) (_tmp134_ + 0.5)));
		_tmp135_ = puzzle_view_get_puzzle (self);
		_tmp136_ = _tmp135_;
		_tmp137_ = puzzle_get_paused (_tmp136_);
		_tmp138_ = _tmp137_;
		if (_tmp138_) {
			Theme* _tmp139_;
			cairo_t* _tmp140_;
			guint _tmp141_;
			_tmp139_ = self->priv->theme;
			_tmp140_ = context;
			_tmp141_ = size;
			theme_draw_paused_tile (_tmp139_, _tmp140_, _tmp141_);
		} else {
			Theme* _tmp142_;
			cairo_t* _tmp143_;
			guint _tmp144_;
			Tile* _tmp145_;
			_tmp142_ = self->priv->theme;
			_tmp143_ = context;
			_tmp144_ = size;
			_tmp145_ = tile;
			theme_draw_tile (_tmp142_, _tmp143_, _tmp144_, _tmp145_);
		}
		_tmp146_ = context;
		cairo_restore (_tmp146_);
		_tile_image_unref0 (image);
		_tile_unref0 (tile);
	}
	_tmp147_ = puzzle_view_get_puzzle (self);
	_tmp148_ = _tmp147_;
	_tmp149_ = puzzle_get_paused (_tmp148_);
	_tmp150_ = _tmp149_;
	if (_tmp150_) {
		cairo_t* _tmp151_;
		cairo_t* _tmp152_;
		cairo_t* _tmp153_;
		cairo_t* _tmp154_;
		gint _tmp155_ = 0;
		const gchar* _tmp156_ = NULL;
		gchar* _tmp157_;
		gchar* text;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp158_;
		const gchar* _tmp159_;
		cairo_text_extents_t _tmp160_ = {0};
		cairo_t* _tmp161_;
		gint _tmp162_ = 0;
		cairo_text_extents_t _tmp163_;
		gdouble _tmp164_;
		gint _tmp165_ = 0;
		cairo_text_extents_t _tmp166_;
		gdouble _tmp167_;
		cairo_t* _tmp168_;
		cairo_t* _tmp169_;
		const gchar* _tmp170_;
		_tmp151_ = context;
		cairo_set_source_rgba (_tmp151_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
		_tmp152_ = context;
		cairo_paint (_tmp152_);
		_tmp153_ = context;
		cairo_select_font_face (_tmp153_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		_tmp154_ = context;
		_tmp155_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		cairo_set_font_size (_tmp154_, _tmp155_ * 0.125);
		_tmp156_ = _ ("Paused");
		_tmp157_ = g_strdup (_tmp156_);
		text = _tmp157_;
		_tmp158_ = context;
		_tmp159_ = text;
		cairo_text_extents (_tmp158_, _tmp159_, &_tmp160_);
		extents = _tmp160_;
		_tmp161_ = context;
		_tmp162_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp163_ = extents;
		_tmp164_ = _tmp163_.width;
		_tmp165_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp166_ = extents;
		_tmp167_ = _tmp166_.height;
		cairo_move_to (_tmp161_, (_tmp162_ - _tmp164_) / 2.0, (_tmp165_ + _tmp167_) / 2.0);
		_tmp168_ = context;
		cairo_set_source_rgb (_tmp168_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp169_ = context;
		_tmp170_ = text;
		cairo_show_text (_tmp169_, _tmp170_);
		_g_free0 (text);
	}
	result = FALSE;
	return result;
}


static gboolean _puzzle_view_selection_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = puzzle_view_selection_timeout_cb (self);
	return result;
}


static void puzzle_view_pick_tile (PuzzleView* self, gdouble x, gdouble y) {
	TileImage* _tmp0_;
	Puzzle* _tmp1_;
	Puzzle* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	guint x_offset = 0U;
	guint y_offset = 0U;
	guint size = 0U;
	guint gap = 0U;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	GHashTable* _tmp9_;
	GHashTableIter iter = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_tile;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = puzzle_view_get_puzzle (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = puzzle_get_is_solved (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		return;
	}
	puzzle_view_get_dimensions (self, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_);
	x_offset = _tmp5_;
	y_offset = _tmp6_;
	size = _tmp7_;
	gap = _tmp8_;
	_tmp9_ = self->priv->tiles;
	g_hash_table_iter_init (&iter, _tmp9_);
	while (TRUE) {
		Tile* tile = NULL;
		TileImage* image = NULL;
		gconstpointer _tmp10_ = NULL;
		gconstpointer _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		Tile* _tmp13_;
		TileImage* _tmp14_;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gdouble _tmp18_;
		TileImage* _tmp19_;
		gdouble _tmp20_;
		gboolean _tmp25_;
		gboolean _tmp29_;
		gboolean _tmp34_;
		_tmp12_ = g_hash_table_iter_next (&iter, &_tmp10_, &_tmp11_);
		_tile_unref0 (tile);
		_tmp13_ = _tile_ref0 (_tmp10_);
		tile = _tmp13_;
		_tile_image_unref0 (image);
		_tmp14_ = _tile_image_ref0 (_tmp11_);
		image = _tmp14_;
		if (!_tmp12_) {
			_tile_image_unref0 (image);
			_tile_unref0 (tile);
			break;
		}
		_tmp18_ = x;
		_tmp19_ = image;
		_tmp20_ = _tmp19_->x;
		if (_tmp18_ >= _tmp20_) {
			gdouble _tmp21_;
			TileImage* _tmp22_;
			gdouble _tmp23_;
			guint _tmp24_;
			_tmp21_ = x;
			_tmp22_ = image;
			_tmp23_ = _tmp22_->x;
			_tmp24_ = size;
			_tmp17_ = _tmp21_ <= (_tmp23_ + _tmp24_);
		} else {
			_tmp17_ = FALSE;
		}
		_tmp25_ = _tmp17_;
		if (_tmp25_) {
			gdouble _tmp26_;
			TileImage* _tmp27_;
			gdouble _tmp28_;
			_tmp26_ = y;
			_tmp27_ = image;
			_tmp28_ = _tmp27_->y;
			_tmp16_ = _tmp26_ >= _tmp28_;
		} else {
			_tmp16_ = FALSE;
		}
		_tmp29_ = _tmp16_;
		if (_tmp29_) {
			gdouble _tmp30_;
			TileImage* _tmp31_;
			gdouble _tmp32_;
			guint _tmp33_;
			_tmp30_ = y;
			_tmp31_ = image;
			_tmp32_ = _tmp31_->y;
			_tmp33_ = size;
			_tmp15_ = _tmp30_ <= (_tmp32_ + _tmp33_);
		} else {
			_tmp15_ = FALSE;
		}
		_tmp34_ = _tmp15_;
		if (_tmp34_) {
			TileImage* _tmp35_;
			TileImage* _tmp36_;
			gdouble _tmp37_;
			TileImage* _tmp38_;
			gdouble _tmp39_;
			gdouble _tmp40_;
			TileImage* _tmp41_;
			gdouble _tmp42_;
			guint _tmp43_;
			guint _tmp45_ = 0U;
			_tmp35_ = image;
			_tmp36_ = _tile_image_ref0 (_tmp35_);
			_tile_image_unref0 (self->priv->selected_tile);
			self->priv->selected_tile = _tmp36_;
			_tmp37_ = x;
			_tmp38_ = image;
			_tmp39_ = _tmp38_->x;
			self->priv->selected_x_offset = _tmp37_ - _tmp39_;
			_tmp40_ = y;
			_tmp41_ = image;
			_tmp42_ = _tmp41_->y;
			self->priv->selected_y_offset = _tmp40_ - _tmp42_;
			_tmp43_ = self->priv->selection_timeout;
			if (_tmp43_ != ((guint) 0)) {
				guint _tmp44_;
				_tmp44_ = self->priv->selection_timeout;
				g_source_remove (_tmp44_);
			}
			_tmp45_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _puzzle_view_selection_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->selection_timeout = _tmp45_;
		}
		_tile_image_unref0 (image);
		_tile_unref0 (tile);
	}
}


static gboolean puzzle_view_selection_timeout_cb (PuzzleView* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->selection_timeout = (guint) 0;
	result = FALSE;
	return result;
}


static void puzzle_view_drop_tile (PuzzleView* self, gdouble x, gdouble y) {
	TileImage* _tmp0_;
	guint x_offset = 0U;
	guint y_offset = 0U;
	guint size = 0U;
	guint gap = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	gdouble _tmp5_;
	guint _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	guint _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	gdouble _tmp14_ = 0.0;
	gint tile_y;
	gint _tmp15_;
	gint _tmp16_ = 0;
	gint _tmp17_;
	Puzzle* _tmp18_;
	Puzzle* _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	gint _tmp22_ = 0;
	gint tile_x = 0;
	gdouble _tmp23_;
	guint _tmp24_;
	guint _tmp25_;
	Puzzle* _tmp26_;
	Puzzle* _tmp27_;
	guint _tmp28_;
	guint _tmp29_;
	guint _tmp30_;
	guint selected_x = 0U;
	guint selected_y = 0U;
	Puzzle* _tmp69_;
	Puzzle* _tmp70_;
	TileImage* _tmp71_;
	Tile* _tmp72_;
	guint _tmp73_ = 0U;
	guint _tmp74_ = 0U;
	Puzzle* _tmp75_;
	Puzzle* _tmp76_;
	guint _tmp77_;
	guint _tmp78_;
	gint _tmp79_;
	gint _tmp80_;
	gboolean _tmp81_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_tile;
	if (_tmp0_ == NULL) {
		return;
	}
	puzzle_view_get_dimensions (self, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	x_offset = _tmp1_;
	y_offset = _tmp2_;
	size = _tmp3_;
	gap = _tmp4_;
	_tmp5_ = x;
	_tmp6_ = size;
	_tmp7_ = self->priv->selected_x_offset;
	x = _tmp5_ + ((_tmp6_ * 0.5) - _tmp7_);
	_tmp8_ = y;
	_tmp9_ = size;
	_tmp10_ = self->priv->selected_x_offset;
	y = _tmp8_ + ((_tmp9_ * 0.5) - _tmp10_);
	_tmp11_ = y;
	_tmp12_ = y_offset;
	_tmp13_ = size;
	_tmp14_ = floor ((_tmp11_ - _tmp12_) / _tmp13_);
	tile_y = (gint) _tmp14_;
	_tmp15_ = tile_y;
	_tmp16_ = MAX (_tmp15_, 0);
	tile_y = _tmp16_;
	_tmp17_ = tile_y;
	_tmp18_ = puzzle_view_get_puzzle (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = puzzle_get_size (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = MIN (_tmp17_, ((gint) _tmp21_) - 1);
	tile_y = _tmp22_;
	_tmp23_ = x;
	_tmp24_ = x_offset;
	_tmp25_ = size;
	_tmp26_ = puzzle_view_get_puzzle (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = puzzle_get_size (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = gap;
	if (_tmp23_ > ((_tmp24_ + (_tmp25_ * _tmp29_)) + (_tmp30_ * 0.5))) {
		Puzzle* _tmp31_;
		Puzzle* _tmp32_;
		guint _tmp33_;
		guint _tmp34_;
		gdouble _tmp35_;
		guint _tmp36_;
		Puzzle* _tmp37_;
		Puzzle* _tmp38_;
		guint _tmp39_;
		guint _tmp40_;
		guint _tmp41_;
		guint _tmp42_;
		guint _tmp43_;
		gdouble _tmp44_ = 0.0;
		gint _tmp45_;
		Puzzle* _tmp46_;
		Puzzle* _tmp47_;
		guint _tmp48_;
		guint _tmp49_;
		gint _tmp50_ = 0;
		gint _tmp51_;
		Puzzle* _tmp52_;
		Puzzle* _tmp53_;
		guint _tmp54_;
		guint _tmp55_;
		gint _tmp56_ = 0;
		_tmp31_ = puzzle_view_get_puzzle (self);
		_tmp32_ = _tmp31_;
		_tmp33_ = puzzle_get_size (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = x;
		_tmp36_ = x_offset;
		_tmp37_ = puzzle_view_get_puzzle (self);
		_tmp38_ = _tmp37_;
		_tmp39_ = puzzle_get_size (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = size;
		_tmp42_ = gap;
		_tmp43_ = size;
		_tmp44_ = floor ((_tmp35_ - ((_tmp36_ + (_tmp40_ * _tmp41_)) + _tmp42_)) / _tmp43_);
		tile_x = ((gint) _tmp34_) + ((gint) _tmp44_);
		_tmp45_ = tile_x;
		_tmp46_ = puzzle_view_get_puzzle (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = puzzle_get_size (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = MAX (_tmp45_, (gint) _tmp49_);
		tile_x = _tmp50_;
		_tmp51_ = tile_x;
		_tmp52_ = puzzle_view_get_puzzle (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = puzzle_get_size (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = MIN (_tmp51_, (2 * ((gint) _tmp55_)) - 1);
		tile_x = _tmp56_;
	} else {
		gdouble _tmp57_;
		guint _tmp58_;
		guint _tmp59_;
		gdouble _tmp60_ = 0.0;
		gint _tmp61_;
		gint _tmp62_ = 0;
		gint _tmp63_;
		Puzzle* _tmp64_;
		Puzzle* _tmp65_;
		guint _tmp66_;
		guint _tmp67_;
		gint _tmp68_ = 0;
		_tmp57_ = x;
		_tmp58_ = x_offset;
		_tmp59_ = size;
		_tmp60_ = floor ((_tmp57_ - _tmp58_) / _tmp59_);
		tile_x = (gint) _tmp60_;
		_tmp61_ = tile_x;
		_tmp62_ = MAX (_tmp61_, 0);
		tile_x = _tmp62_;
		_tmp63_ = tile_x;
		_tmp64_ = puzzle_view_get_puzzle (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = puzzle_get_size (_tmp65_);
		_tmp67_ = _tmp66_;
		_tmp68_ = MIN (_tmp63_, ((gint) _tmp67_) - 1);
		tile_x = _tmp68_;
	}
	_tmp69_ = puzzle_view_get_puzzle (self);
	_tmp70_ = _tmp69_;
	_tmp71_ = self->priv->selected_tile;
	_tmp72_ = _tmp71_->tile;
	puzzle_get_tile_location (_tmp70_, _tmp72_, &_tmp73_, &_tmp74_);
	selected_x = _tmp73_;
	selected_y = _tmp74_;
	_tmp75_ = puzzle_view_get_puzzle (self);
	_tmp76_ = _tmp75_;
	_tmp77_ = selected_x;
	_tmp78_ = selected_y;
	_tmp79_ = tile_x;
	_tmp80_ = tile_y;
	_tmp81_ = puzzle_can_switch (_tmp76_, _tmp77_, _tmp78_, (guint) _tmp79_, (guint) _tmp80_);
	if (_tmp81_) {
		Puzzle* _tmp82_;
		Puzzle* _tmp83_;
		guint _tmp84_;
		guint _tmp85_;
		gint _tmp86_;
		gint _tmp87_;
		_tmp82_ = puzzle_view_get_puzzle (self);
		_tmp83_ = _tmp82_;
		_tmp84_ = selected_x;
		_tmp85_ = selected_y;
		_tmp86_ = tile_x;
		_tmp87_ = tile_y;
		puzzle_switch_tiles (_tmp83_, _tmp84_, _tmp85_, (guint) _tmp86_, (guint) _tmp87_);
	} else {
		TileImage* _tmp88_;
		guint _tmp89_;
		guint _tmp90_;
		_tmp88_ = self->priv->selected_tile;
		_tmp89_ = selected_x;
		_tmp90_ = selected_y;
		puzzle_view_move_tile_to_location (self, _tmp88_, _tmp89_, _tmp90_, 0.2);
	}
	_tile_image_unref0 (self->priv->selected_tile);
	self->priv->selected_tile = NULL;
}


static gboolean puzzle_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	Puzzle* _tmp0_;
	Puzzle* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GdkEventButton _tmp4_;
	GdkEventType _tmp5_;
	GdkEventButton _tmp6_;
	guint _tmp7_;
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = puzzle_view_get_puzzle (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = puzzle_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = *event;
	_tmp5_ = _tmp4_.type;
	if (_tmp5_ != GDK_BUTTON_PRESS) {
		result = FALSE;
		return result;
	}
	_tmp6_ = *event;
	_tmp7_ = _tmp6_.button;
	if (_tmp7_ == ((guint) 1)) {
		TileImage* _tmp8_;
		_tmp8_ = self->priv->selected_tile;
		if (_tmp8_ == NULL) {
			GdkEventButton _tmp9_;
			gdouble _tmp10_;
			GdkEventButton _tmp11_;
			gdouble _tmp12_;
			_tmp9_ = *event;
			_tmp10_ = _tmp9_.x;
			_tmp11_ = *event;
			_tmp12_ = _tmp11_.y;
			puzzle_view_pick_tile (self, _tmp10_, _tmp12_);
		} else {
			TileImage* _tmp13_;
			_tmp13_ = self->priv->selected_tile;
			if (_tmp13_ != NULL) {
				GdkEventButton _tmp14_;
				gdouble _tmp15_;
				GdkEventButton _tmp16_;
				gdouble _tmp17_;
				_tmp14_ = *event;
				_tmp15_ = _tmp14_.x;
				_tmp16_ = *event;
				_tmp17_ = _tmp16_.y;
				puzzle_view_drop_tile (self, _tmp15_, _tmp17_);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean puzzle_view_real_button_release_event (GtkWidget* base, GdkEventButton* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GdkEventButton _tmp2_;
	guint _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp7_;
	guint _tmp12_;
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.button;
	if (_tmp3_ == ((guint) 1)) {
		TileImage* _tmp4_;
		_tmp4_ = self->priv->selected_tile;
		_tmp1_ = _tmp4_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp5_ = _tmp1_;
	if (_tmp5_) {
		guint _tmp6_;
		_tmp6_ = self->priv->selection_timeout;
		_tmp0_ = _tmp6_ == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		GdkEventButton _tmp8_;
		gdouble _tmp9_;
		GdkEventButton _tmp10_;
		gdouble _tmp11_;
		_tmp8_ = *event;
		_tmp9_ = _tmp8_.x;
		_tmp10_ = *event;
		_tmp11_ = _tmp10_.y;
		puzzle_view_drop_tile (self, _tmp9_, _tmp11_);
	}
	_tmp12_ = self->priv->selection_timeout;
	if (_tmp12_ != ((guint) 0)) {
		guint _tmp13_;
		_tmp13_ = self->priv->selection_timeout;
		g_source_remove (_tmp13_);
	}
	self->priv->selection_timeout = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean puzzle_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	TileImage* _tmp0_;
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->selected_tile;
	if (_tmp0_ != NULL) {
		TileImage* _tmp1_;
		GdkEventMotion _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
		GdkEventMotion _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		_tmp1_ = self->priv->selected_tile;
		_tmp2_ = *event;
		_tmp3_ = _tmp2_.x;
		_tmp4_ = self->priv->selected_x_offset;
		_tmp5_ = *event;
		_tmp6_ = _tmp5_.y;
		_tmp7_ = self->priv->selected_y_offset;
		puzzle_view_move_tile (self, _tmp1_, (gdouble) ((gint) (_tmp3_ - _tmp4_)), (gdouble) ((gint) (_tmp6_ - _tmp7_)), (gdouble) 0);
	}
	result = FALSE;
	return result;
}


Puzzle* puzzle_view_get_puzzle (PuzzleView* self) {
	Puzzle* result;
	Puzzle* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_puzzle;
	result = _tmp0_;
	return result;
}


static gpointer _puzzle_ref0 (gpointer self) {
	return self ? puzzle_ref (self) : NULL;
}


static void _puzzle_view_tile_moved_cb_puzzle_tile_moved (Puzzle* _sender, Tile* tile, guint x, guint y, gpointer self) {
	puzzle_view_tile_moved_cb (self, _sender, tile, x, y);
}


static void _puzzle_view_puzzle___lambda2_ (PuzzleView* self) {
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void __puzzle_view_puzzle___lambda2__puzzle_paused_changed (Puzzle* _sender, gpointer self) {
	_puzzle_view_puzzle___lambda2_ (self);
}


void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value) {
	Puzzle* _tmp0_;
	Puzzle* _tmp2_;
	Puzzle* _tmp3_;
	GHashTable* _tmp4_;
	Puzzle* _tmp37_;
	Puzzle* _tmp38_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_puzzle;
	if (_tmp0_ != NULL) {
		Puzzle* _tmp1_;
		_tmp1_ = self->priv->_puzzle;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = value;
	_tmp3_ = _puzzle_ref0 (_tmp2_);
	_puzzle_unref0 (self->priv->_puzzle);
	self->priv->_puzzle = _tmp3_;
	_tmp4_ = self->priv->tiles;
	g_hash_table_remove_all (_tmp4_);
	{
		gint y;
		y = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_;
				gint _tmp8_;
				Puzzle* _tmp9_;
				Puzzle* _tmp10_;
				guint _tmp11_;
				guint _tmp12_;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = y;
					y = _tmp7_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp8_ = y;
				_tmp9_ = puzzle_view_get_puzzle (self);
				_tmp10_ = _tmp9_;
				_tmp11_ = puzzle_get_size (_tmp10_);
				_tmp12_ = _tmp11_;
				if (!(((guint) _tmp8_) < _tmp12_)) {
					break;
				}
				{
					gint x;
					x = 0;
					{
						gboolean _tmp13_;
						_tmp13_ = TRUE;
						while (TRUE) {
							gboolean _tmp14_;
							gint _tmp16_;
							Puzzle* _tmp17_;
							Puzzle* _tmp18_;
							guint _tmp19_;
							guint _tmp20_;
							Puzzle* _tmp21_;
							Puzzle* _tmp22_;
							gint _tmp23_;
							gint _tmp24_;
							Tile* _tmp25_ = NULL;
							Tile* tile;
							Tile* _tmp26_;
							Tile* _tmp27_;
							TileImage* _tmp28_;
							TileImage* image;
							TileImage* _tmp29_;
							gint _tmp30_;
							gint _tmp31_;
							GHashTable* _tmp32_;
							Tile* _tmp33_;
							Tile* _tmp34_;
							TileImage* _tmp35_;
							TileImage* _tmp36_;
							_tmp14_ = _tmp13_;
							if (!_tmp14_) {
								gint _tmp15_;
								_tmp15_ = x;
								x = _tmp15_ + 1;
							}
							_tmp13_ = FALSE;
							_tmp16_ = x;
							_tmp17_ = puzzle_view_get_puzzle (self);
							_tmp18_ = _tmp17_;
							_tmp19_ = puzzle_get_size (_tmp18_);
							_tmp20_ = _tmp19_;
							if (!(((guint) _tmp16_) < (_tmp20_ * 2))) {
								break;
							}
							_tmp21_ = puzzle_view_get_puzzle (self);
							_tmp22_ = _tmp21_;
							_tmp23_ = x;
							_tmp24_ = y;
							_tmp25_ = puzzle_get_tile (_tmp22_, (guint) _tmp23_, (guint) _tmp24_);
							tile = _tmp25_;
							_tmp26_ = tile;
							if (_tmp26_ == NULL) {
								_tile_unref0 (tile);
								continue;
							}
							_tmp27_ = tile;
							_tmp28_ = tile_image_new (_tmp27_);
							image = _tmp28_;
							_tmp29_ = image;
							_tmp30_ = x;
							_tmp31_ = y;
							puzzle_view_move_tile_to_location (self, _tmp29_, (guint) _tmp30_, (guint) _tmp31_, (gdouble) 0);
							_tmp32_ = self->priv->tiles;
							_tmp33_ = tile;
							_tmp34_ = _tile_ref0 (_tmp33_);
							_tmp35_ = image;
							_tmp36_ = _tile_image_ref0 (_tmp35_);
							g_hash_table_insert (_tmp32_, _tmp34_, _tmp36_);
							_tile_image_unref0 (image);
							_tile_unref0 (tile);
						}
					}
				}
			}
		}
	}
	_tmp37_ = self->priv->_puzzle;
	g_signal_connect_object (_tmp37_, "tile-moved", (GCallback) _puzzle_view_tile_moved_cb_puzzle_tile_moved, self, 0);
	_tmp38_ = self->priv->_puzzle;
	g_signal_connect_object (_tmp38_, "paused-changed", (GCallback) __puzzle_view_puzzle___lambda2__puzzle_paused_changed, self, 0);
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "puzzle");
}


static void puzzle_view_class_init (PuzzleViewClass * klass) {
	puzzle_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PuzzleViewPrivate));
	GTK_WIDGET_CLASS (klass)->get_preferred_width = puzzle_view_real_get_preferred_width;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = puzzle_view_real_get_preferred_height;
	GTK_WIDGET_CLASS (klass)->configure_event = puzzle_view_real_configure_event;
	GTK_WIDGET_CLASS (klass)->draw = puzzle_view_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = puzzle_view_real_button_press_event;
	GTK_WIDGET_CLASS (klass)->button_release_event = puzzle_view_real_button_release_event;
	GTK_WIDGET_CLASS (klass)->motion_notify_event = puzzle_view_real_motion_notify_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_puzzle_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_puzzle_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = puzzle_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_PUZZLE, param_spec_puzzle ("puzzle", "puzzle", "puzzle", TYPE_PUZZLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void puzzle_view_instance_init (PuzzleView * self) {
	self->priv = PUZZLE_VIEW_GET_PRIVATE (self);
	self->priv->_puzzle = NULL;
	self->priv->selected_tile = NULL;
	self->priv->selection_timeout = (guint) 0;
	self->priv->animation_timeout = (guint) 0;
}


static void puzzle_view_finalize (GObject* obj) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE_VIEW, PuzzleView);
	_puzzle_unref0 (self->priv->_puzzle);
	_theme_unref0 (self->priv->theme);
	_tile_image_unref0 (self->priv->selected_tile);
	_g_hash_table_unref0 (self->priv->tiles);
	_g_timer_destroy0 (self->priv->animation_timer);
	G_OBJECT_CLASS (puzzle_view_parent_class)->finalize (obj);
}


GType puzzle_view_get_type (void) {
	static volatile gsize puzzle_view_type_id__volatile = 0;
	if (g_once_init_enter (&puzzle_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PuzzleViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PuzzleView), 0, (GInstanceInitFunc) puzzle_view_instance_init, NULL };
		GType puzzle_view_type_id;
		puzzle_view_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "PuzzleView", &g_define_type_info, 0);
		g_once_init_leave (&puzzle_view_type_id__volatile, puzzle_view_type_id);
	}
	return puzzle_view_type_id__volatile;
}


static void _vala_puzzle_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
	switch (property_id) {
		case PUZZLE_VIEW_PUZZLE:
		value_set_puzzle (value, puzzle_view_get_puzzle (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_puzzle_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
	switch (property_id) {
		case PUZZLE_VIEW_PUZZLE:
		puzzle_view_set_puzzle (self, value_get_puzzle (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



