/* gnome-tetravex.c generated by valac 0.21.1.1-0d6f, the Vala compiler
 * generated from gnome-tetravex.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <pango/pango.h>


#define TYPE_TETRAVEX (tetravex_get_type ())
#define TETRAVEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TETRAVEX, Tetravex))
#define TETRAVEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TETRAVEX, TetravexClass))
#define IS_TETRAVEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TETRAVEX))
#define IS_TETRAVEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TETRAVEX))
#define TETRAVEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TETRAVEX, TetravexClass))

typedef struct _Tetravex Tetravex;
typedef struct _TetravexClass TetravexClass;
typedef struct _TetravexPrivate TetravexPrivate;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;

#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _puzzle_unref0(var) ((var == NULL) ? NULL : (var = (puzzle_unref (var), NULL)))
#define _history_unref0(var) ((var == NULL) ? NULL : (var = (history_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;
#define _history_entry_unref0(var) ((var == NULL) ? NULL : (var = (history_entry_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_SCORE_DIALOG (score_dialog_get_type ())
#define SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_DIALOG, ScoreDialog))
#define SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_DIALOG, ScoreDialogClass))
#define IS_SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_DIALOG))
#define IS_SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_DIALOG))
#define SCORE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_DIALOG, ScoreDialogClass))

typedef struct _ScoreDialog ScoreDialog;
typedef struct _ScoreDialogClass ScoreDialogClass;
typedef struct _ScoreDialogPrivate ScoreDialogPrivate;
typedef struct _HistoryPrivate HistoryPrivate;
typedef struct _HistoryEntryPrivate HistoryEntryPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _Tetravex {
	GtkApplication parent_instance;
	TetravexPrivate * priv;
};

struct _TetravexClass {
	GtkApplicationClass parent_class;
};

struct _TetravexPrivate {
	GSettings* settings;
	Puzzle* puzzle;
	GtkLabel* clock_label;
	History* history;
	PuzzleView* view;
	GtkWindow* window;
	gint window_width;
	gint window_height;
	gboolean is_fullscreen;
	gboolean is_maximized;
	GtkToolButton* pause_button;
	GtkToolButton* fullscreen_button;
};

struct _ScoreDialog {
	GtkDialog parent_instance;
	ScoreDialogPrivate * priv;
};

struct _ScoreDialogClass {
	GtkDialogClass parent_class;
};

struct _ScoreDialogPrivate {
	History* history;
	HistoryEntry* selected_entry;
	GtkListStore* size_model;
	GtkListStore* score_model;
	GtkComboBox* size_combo;
};

struct _History {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HistoryPrivate * priv;
	gchar* filename;
	GList* entries;
};

struct _HistoryClass {
	GTypeClass parent_class;
	void (*finalize) (History *self);
};

struct _HistoryEntry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HistoryEntryPrivate * priv;
	GDateTime* date;
	guint size;
	guint duration;
};

struct _HistoryEntryClass {
	GTypeClass parent_class;
	void (*finalize) (HistoryEntry *self);
};


static gpointer tetravex_parent_class = NULL;
static gpointer score_dialog_parent_class = NULL;

GType tetravex_get_type (void) G_GNUC_CONST;
gpointer puzzle_ref (gpointer instance);
void puzzle_unref (gpointer instance);
GParamSpec* param_spec_puzzle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_puzzle (GValue* value, gpointer v_object);
void value_take_puzzle (GValue* value, gpointer v_object);
gpointer value_get_puzzle (const GValue* value);
GType puzzle_get_type (void) G_GNUC_CONST;
gpointer history_ref (gpointer instance);
void history_unref (gpointer instance);
GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history (GValue* value, gpointer v_object);
void value_take_history (GValue* value, gpointer v_object);
gpointer value_get_history (const GValue* value);
GType history_get_type (void) G_GNUC_CONST;
GType puzzle_view_get_type (void) G_GNUC_CONST;
#define TETRAVEX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TETRAVEX, TetravexPrivate))
enum  {
	TETRAVEX_DUMMY_PROPERTY
};
#define TETRAVEX_KEY_GRID_SIZE "grid-size"
static void tetravex_new_game_cb (Tetravex* self);
static void _tetravex_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_pause_cb (Tetravex* self, GSimpleAction* action, GVariant* parameter);
static void _tetravex_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_fullscreen_cb (Tetravex* self);
static void _tetravex_fullscreen_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_solve_cb (Tetravex* self);
static void _tetravex_solve_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_scores_cb (Tetravex* self);
static void _tetravex_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_quit_cb (Tetravex* self);
static void _tetravex_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_move_up_cb (Tetravex* self);
static void _tetravex_move_up_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_move_down_cb (Tetravex* self);
static void _tetravex_move_down_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_move_left_cb (Tetravex* self);
static void _tetravex_move_left_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_move_right_cb (Tetravex* self);
static void _tetravex_move_right_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_radio_cb (Tetravex* self, GSimpleAction* action, GVariant* parameter);
static void _tetravex_radio_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_size_changed (Tetravex* self, GSimpleAction* action, GVariant* value);
static void _tetravex_size_changed_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self);
static void tetravex_help_cb (Tetravex* self);
static void _tetravex_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_about_cb (Tetravex* self);
static void _tetravex_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Tetravex* tetravex_new (void);
Tetravex* tetravex_construct (GType object_type);
static void tetravex_real_startup (GApplication* base);
History* history_new (const gchar* filename);
History* history_construct (GType object_type, const gchar* filename);
void history_load (History* self);
static gboolean tetravex_window_configure_event_cb (Tetravex* self, GdkEventConfigure* event);
static gboolean _tetravex_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean tetravex_window_state_event_cb (Tetravex* self, GdkEventWindowState* event);
static gboolean _tetravex_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static GVariant* _variant_new1 (gchar* value);
PuzzleView* puzzle_view_new (void);
PuzzleView* puzzle_view_construct (GType object_type);
static gboolean tetravex_view_button_press_event (Tetravex* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _tetravex_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void tetravex_tick_cb (Tetravex* self);
static void tetravex_new_game (Tetravex* self);
static void tetravex_real_shutdown (GApplication* base);
static void tetravex_real_activate (GApplication* base);
Puzzle* puzzle_new (guint size);
Puzzle* puzzle_construct (GType object_type, guint size);
static void _tetravex_tick_cb_puzzle_tick (Puzzle* _sender, gpointer self);
static void tetravex_solved_cb (Tetravex* self, Puzzle* puzzle);
static void _tetravex_solved_cb_puzzle_solved (Puzzle* _sender, gpointer self);
void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value);
static GVariant* _variant_new2 (gboolean value);
gdouble puzzle_get_elapsed (Puzzle* self);
gpointer history_entry_ref (gpointer instance);
void history_entry_unref (gpointer instance);
GParamSpec* param_spec_history_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history_entry (GValue* value, gpointer v_object);
void value_take_history_entry (GValue* value, gpointer v_object);
gpointer value_get_history_entry (const GValue* value);
GType history_entry_get_type (void) G_GNUC_CONST;
guint puzzle_get_size (Puzzle* self);
HistoryEntry* history_entry_new (GDateTime* date, guint size, guint duration);
HistoryEntry* history_entry_construct (GType object_type, GDateTime* date, guint size, guint duration);
void history_add (History* self, HistoryEntry* entry);
void history_save (History* self);
static gint tetravex_show_scores (Tetravex* self, HistoryEntry* selected_entry, gboolean show_quit);
GType score_dialog_get_type (void) G_GNUC_CONST;
ScoreDialog* score_dialog_new (History* history, HistoryEntry* selected_entry, gboolean show_quit);
ScoreDialog* score_dialog_construct (GType object_type, History* history, HistoryEntry* selected_entry, gboolean show_quit);
gboolean puzzle_get_paused (Puzzle* self);
void puzzle_set_paused (Puzzle* self, gboolean value);
void puzzle_solve (Puzzle* self);
static gchar* _variant_get3 (GVariant* value);
void puzzle_move_up (Puzzle* self);
void puzzle_move_left (Puzzle* self);
void puzzle_move_right (Puzzle* self);
void puzzle_move_down (Puzzle* self);
gint tetravex_main (gchar** args, int args_length1);
static void tetravex_finalize (GObject* obj);
#define SCORE_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SCORE_DIALOG, ScoreDialogPrivate))
enum  {
	SCORE_DIALOG_DUMMY_PROPERTY
};
static void score_dialog_entry_added_cb (ScoreDialog* self, HistoryEntry* entry);
static void _score_dialog_entry_added_cb_history_entry_added (History* _sender, HistoryEntry* entry, gpointer self);
static void score_dialog_size_changed_cb (ScoreDialog* self, GtkComboBox* combo);
static void _score_dialog_size_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
void score_dialog_set_size (ScoreDialog* self, guint size);
static gint score_dialog_compare_entries (HistoryEntry* a, HistoryEntry* b);
static gint _score_dialog_compare_entries_gcompare_func (gconstpointer a, gconstpointer b);
static void score_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry TETRAVEX_action_entries[13] = {{"new-game", _tetravex_new_game_cb_gsimple_action_activate_callback}, {"pause", _tetravex_pause_cb_gsimple_action_activate_callback}, {"fullscreen", _tetravex_fullscreen_cb_gsimple_action_activate_callback}, {"solve", _tetravex_solve_cb_gsimple_action_activate_callback}, {"scores", _tetravex_scores_cb_gsimple_action_activate_callback}, {"quit", _tetravex_quit_cb_gsimple_action_activate_callback}, {"move-up", _tetravex_move_up_cb_gsimple_action_activate_callback}, {"move-down", _tetravex_move_down_cb_gsimple_action_activate_callback}, {"move-left", _tetravex_move_left_cb_gsimple_action_activate_callback}, {"move-right", _tetravex_move_right_cb_gsimple_action_activate_callback}, {"size", _tetravex_radio_cb_gsimple_action_activate_callback, "s", "'2'", _tetravex_size_changed_gsimple_action_change_state_callback}, {"help", _tetravex_help_cb_gsimple_action_activate_callback}, {"about", _tetravex_about_cb_gsimple_action_activate_callback}};

static void _tetravex_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_new_game_cb (self);
}


static void _tetravex_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_pause_cb (self, action, parameter);
}


static void _tetravex_fullscreen_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_fullscreen_cb (self);
}


static void _tetravex_solve_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_solve_cb (self);
}


static void _tetravex_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_scores_cb (self);
}


static void _tetravex_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_quit_cb (self);
}


static void _tetravex_move_up_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_move_up_cb (self);
}


static void _tetravex_move_down_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_move_down_cb (self);
}


static void _tetravex_move_left_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_move_left_cb (self);
}


static void _tetravex_move_right_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_move_right_cb (self);
}


static void _tetravex_radio_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_radio_cb (self, action, parameter);
}


static void _tetravex_size_changed_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self) {
	tetravex_size_changed (self, action, value);
}


static void _tetravex_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_help_cb (self);
}


static void _tetravex_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_about_cb (self);
}


Tetravex* tetravex_construct (GType object_type) {
	Tetravex * self = NULL;
	self = (Tetravex*) g_object_new (object_type, "application-id", "org.gnome.tetravex", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	return self;
}


Tetravex* tetravex_new (void) {
	return tetravex_construct (TYPE_TETRAVEX);
}


static gboolean _tetravex_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = tetravex_window_configure_event_cb (self, event);
	return result;
}


static gboolean _tetravex_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = tetravex_window_state_event_cb (self, event);
	return result;
}


static GVariant* _variant_new1 (gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static gboolean _tetravex_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = tetravex_view_button_press_event (self, _sender, event);
	return result;
}


static void tetravex_real_startup (GApplication* base) {
	Tetravex * self;
	const gchar* _tmp0_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GObject* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	History* _tmp10_ = NULL;
	History* _tmp11_ = NULL;
	GtkApplicationWindow* _tmp12_ = NULL;
	GtkWindow* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GtkWindow* _tmp15_ = NULL;
	GtkWindow* _tmp16_ = NULL;
	GtkWindow* _tmp17_ = NULL;
	GSettings* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	GSettings* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	GSettings* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	GAction* _tmp28_ = NULL;
	GSettings* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	GVariant* _tmp33_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp34_ = NULL;
	GtkWindow* _tmp35_ = NULL;
	GtkToolbar* toolbar = NULL;
	GtkToolbar* _tmp36_ = NULL;
	GtkStyleContext* _tmp37_ = NULL;
	GtkToolButton* new_game_button = NULL;
	const gchar* _tmp38_ = NULL;
	GtkToolButton* _tmp39_ = NULL;
	GtkToolButton* solve_button = NULL;
	const gchar* _tmp40_ = NULL;
	GtkToolButton* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	GtkToolButton* _tmp43_ = NULL;
	GtkToolButton* _tmp44_ = NULL;
	GtkToolButton* _tmp45_ = NULL;
	GtkToolButton* _tmp46_ = NULL;
	GtkToolButton* _tmp47_ = NULL;
	GtkToolButton* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	GtkToolButton* _tmp50_ = NULL;
	GtkToolButton* _tmp51_ = NULL;
	GtkToolButton* _tmp52_ = NULL;
	GtkToolButton* _tmp53_ = NULL;
	GtkToolButton* _tmp54_ = NULL;
	GtkToolButton* _tmp55_ = NULL;
	PuzzleView* _tmp56_ = NULL;
	PuzzleView* _tmp57_ = NULL;
	PuzzleView* _tmp58_ = NULL;
	PuzzleView* _tmp59_ = NULL;
	PuzzleView* _tmp60_ = NULL;
	PuzzleView* _tmp61_ = NULL;
	GtkToolItem* time_item = NULL;
	GtkToolItem* _tmp62_ = NULL;
	GtkAlignment* time_align = NULL;
	GtkAlignment* _tmp63_ = NULL;
	GtkBox* time_box = NULL;
	GtkBox* _tmp64_ = NULL;
	GtkLabel* _tmp65_ = NULL;
	GtkLabel* _tmp66_ = NULL;
	GtkLabel* _tmp67_ = NULL;
	GError * _inner_error_ = NULL;
	self = (Tetravex*) base;
	G_APPLICATION_CLASS (tetravex_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = _ ("Tetravex");
	g_set_application_name (_tmp0_);
	gtk_window_set_default_icon_name ("gnome-tetravex");
	g_action_map_add_action_entries ((GActionMap*) self, TETRAVEX_action_entries, G_N_ELEMENTS (TETRAVEX_action_entries), self);
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>n", "app.new-game", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "Pause", "app.pause", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "F11", "app.fullscreen", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "F1", "app.help", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>q", "app.quit", NULL);
	_tmp1_ = gtk_builder_new ();
	builder = _tmp1_;
	{
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = g_build_filename (DATA_DIRECTORY, "gnome-tetravex.ui", NULL);
		_tmp3_ = _tmp2_;
		gtk_builder_add_from_file (builder, _tmp3_, &_inner_error_);
		_g_free0 (_tmp3_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e->message;
		g_error ("gnome-tetravex.vala:75: Unable to build menus: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = gtk_builder_get_object (builder, "gnome-tetravex-menu");
	gtk_application_set_app_menu ((GtkApplication*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp5_) : NULL);
	_tmp6_ = g_settings_new ("org.gnome.tetravex");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp6_;
	_tmp7_ = g_get_user_data_dir ();
	_tmp8_ = g_build_filename (_tmp7_, "gnome-tetravex", "history", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = history_new (_tmp9_);
	_history_unref0 (self->priv->history);
	self->priv->history = _tmp10_;
	_g_free0 (_tmp9_);
	_tmp11_ = self->priv->history;
	history_load (_tmp11_);
	_tmp12_ = (GtkApplicationWindow*) gtk_application_window_new ((GtkApplication*) self);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = (GtkWindow*) _tmp12_;
	_tmp13_ = self->priv->window;
	_tmp14_ = _ ("Tetravex");
	gtk_window_set_title (_tmp13_, _tmp14_);
	_tmp15_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp15_, "configure-event", (GCallback) _tetravex_window_configure_event_cb_gtk_widget_configure_event, self, 0);
	_tmp16_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp16_, "window-state-event", (GCallback) _tetravex_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp17_ = self->priv->window;
	_tmp18_ = self->priv->settings;
	_tmp19_ = g_settings_get_int (_tmp18_, "window-width");
	_tmp20_ = self->priv->settings;
	_tmp21_ = g_settings_get_int (_tmp20_, "window-height");
	gtk_window_set_default_size (_tmp17_, _tmp19_, _tmp21_);
	_tmp22_ = self->priv->settings;
	_tmp23_ = g_settings_get_boolean (_tmp22_, "window-is-fullscreen");
	if (_tmp23_) {
		GtkWindow* _tmp24_ = NULL;
		_tmp24_ = self->priv->window;
		gtk_window_fullscreen (_tmp24_);
	} else {
		GSettings* _tmp25_ = NULL;
		gboolean _tmp26_ = FALSE;
		_tmp25_ = self->priv->settings;
		_tmp26_ = g_settings_get_boolean (_tmp25_, "window-is-maximized");
		if (_tmp26_) {
			GtkWindow* _tmp27_ = NULL;
			_tmp27_ = self->priv->window;
			gtk_window_maximize (_tmp27_);
		}
	}
	_tmp28_ = g_action_map_lookup_action ((GActionMap*) self, "size");
	_tmp29_ = self->priv->settings;
	_tmp30_ = g_settings_get_int (_tmp29_, TETRAVEX_KEY_GRID_SIZE);
	_tmp31_ = g_strdup_printf ("%d", _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = _variant_new1 (_tmp32_);
	g_simple_action_set_state (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp28_) : NULL, _tmp33_);
	_g_free0 (_tmp32_);
	_tmp34_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp34_);
	grid = _tmp34_;
	gtk_widget_show ((GtkWidget*) grid);
	_tmp35_ = self->priv->window;
	gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) grid);
	_tmp36_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp36_);
	toolbar = _tmp36_;
	gtk_toolbar_set_show_arrow (toolbar, FALSE);
	_tmp37_ = gtk_widget_get_style_context ((GtkWidget*) toolbar);
	gtk_style_context_add_class (_tmp37_, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
	gtk_widget_show ((GtkWidget*) toolbar);
	gtk_grid_attach (grid, (GtkWidget*) toolbar, 0, 0, 1, 1);
	_tmp38_ = _ ("_New");
	_tmp39_ = (GtkToolButton*) gtk_tool_button_new (NULL, _tmp38_);
	g_object_ref_sink (_tmp39_);
	new_game_button = _tmp39_;
	gtk_tool_button_set_use_underline (new_game_button, TRUE);
	gtk_tool_button_set_icon_name (new_game_button, "document-new");
	gtk_actionable_set_action_name ((GtkActionable*) new_game_button, "app.new-game");
	gtk_tool_item_set_is_important ((GtkToolItem*) new_game_button, TRUE);
	gtk_widget_show ((GtkWidget*) new_game_button);
	gtk_toolbar_insert (toolbar, (GtkToolItem*) new_game_button, -1);
	_tmp40_ = _ ("Solve");
	_tmp41_ = (GtkToolButton*) gtk_tool_button_new (NULL, _tmp40_);
	g_object_ref_sink (_tmp41_);
	solve_button = _tmp41_;
	gtk_actionable_set_action_name ((GtkActionable*) solve_button, "app.solve");
	gtk_tool_item_set_is_important ((GtkToolItem*) solve_button, TRUE);
	gtk_widget_show ((GtkWidget*) solve_button);
	gtk_toolbar_insert (toolbar, (GtkToolItem*) solve_button, -1);
	_tmp42_ = _ ("_Pause");
	_tmp43_ = (GtkToolButton*) gtk_tool_button_new (NULL, _tmp42_);
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->pause_button);
	self->priv->pause_button = _tmp43_;
	_tmp44_ = self->priv->pause_button;
	gtk_tool_button_set_icon_name (_tmp44_, "media-playback-pause");
	_tmp45_ = self->priv->pause_button;
	gtk_tool_button_set_use_underline (_tmp45_, TRUE);
	_tmp46_ = self->priv->pause_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp46_, "app.pause");
	_tmp47_ = self->priv->pause_button;
	gtk_widget_show ((GtkWidget*) _tmp47_);
	_tmp48_ = self->priv->pause_button;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp48_, -1);
	_tmp49_ = _ ("_Fullscreen");
	_tmp50_ = (GtkToolButton*) gtk_tool_button_new (NULL, _tmp49_);
	g_object_ref_sink (_tmp50_);
	_g_object_unref0 (self->priv->fullscreen_button);
	self->priv->fullscreen_button = _tmp50_;
	_tmp51_ = self->priv->fullscreen_button;
	gtk_tool_button_set_icon_name (_tmp51_, "view-fullscreen");
	_tmp52_ = self->priv->fullscreen_button;
	gtk_tool_button_set_use_underline (_tmp52_, TRUE);
	_tmp53_ = self->priv->fullscreen_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp53_, "app.fullscreen");
	_tmp54_ = self->priv->fullscreen_button;
	gtk_widget_show ((GtkWidget*) _tmp54_);
	_tmp55_ = self->priv->fullscreen_button;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp55_, -1);
	_tmp56_ = puzzle_view_new ();
	g_object_ref_sink (_tmp56_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp56_;
	_tmp57_ = self->priv->view;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp57_, TRUE);
	_tmp58_ = self->priv->view;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp58_, TRUE);
	_tmp59_ = self->priv->view;
	g_signal_connect_object ((GtkWidget*) _tmp59_, "button-press-event", (GCallback) _tetravex_view_button_press_event_gtk_widget_button_press_event, self, 0);
	_tmp60_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp60_);
	_tmp61_ = self->priv->view;
	gtk_grid_attach (grid, (GtkWidget*) _tmp61_, 0, 1, 1, 1);
	_tmp62_ = gtk_tool_item_new ();
	g_object_ref_sink (_tmp62_);
	time_item = _tmp62_;
	gtk_tool_item_set_expand (time_item, TRUE);
	gtk_widget_show ((GtkWidget*) time_item);
	gtk_toolbar_insert (toolbar, time_item, -1);
	_tmp63_ = (GtkAlignment*) gtk_alignment_new (1.0f, 0.5f, 0.0f, 0.0f);
	g_object_ref_sink (_tmp63_);
	time_align = _tmp63_;
	gtk_widget_show ((GtkWidget*) time_align);
	gtk_container_add ((GtkContainer*) time_item, (GtkWidget*) time_align);
	_tmp64_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp64_);
	time_box = _tmp64_;
	gtk_widget_show ((GtkWidget*) time_box);
	gtk_container_add ((GtkContainer*) time_align, (GtkWidget*) time_box);
	_tmp65_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp65_);
	_g_object_unref0 (self->priv->clock_label);
	self->priv->clock_label = _tmp65_;
	_tmp66_ = self->priv->clock_label;
	gtk_widget_show ((GtkWidget*) _tmp66_);
	_tmp67_ = self->priv->clock_label;
	gtk_box_pack_start (time_box, (GtkWidget*) _tmp67_, FALSE, FALSE, (guint) 0);
	tetravex_tick_cb (self);
	tetravex_new_game (self);
	_g_object_unref0 (time_box);
	_g_object_unref0 (time_align);
	_g_object_unref0 (time_item);
	_g_object_unref0 (solve_button);
	_g_object_unref0 (new_game_button);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (grid);
	_g_object_unref0 (builder);
}


static gboolean tetravex_window_configure_event_cb (Tetravex* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->is_maximized;
	if (!_tmp1_) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->priv->is_fullscreen;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		GdkEventConfigure _tmp4_ = {0};
		gint _tmp5_ = 0;
		GdkEventConfigure _tmp6_ = {0};
		gint _tmp7_ = 0;
		_tmp4_ = *event;
		_tmp5_ = _tmp4_.width;
		self->priv->window_width = _tmp5_;
		_tmp6_ = *event;
		_tmp7_ = _tmp6_.height;
		self->priv->window_height = _tmp7_;
	}
	result = FALSE;
	return result;
}


static gboolean tetravex_window_state_event_cb (Tetravex* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState _tmp0_ = {0};
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState _tmp4_ = {0};
	GdkWindowState _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState _tmp2_ = {0};
		GdkWindowState _tmp3_ = 0;
		_tmp2_ = *event;
		_tmp3_ = _tmp2_.new_window_state;
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	_tmp4_ = *event;
	_tmp5_ = _tmp4_.changed_mask;
	if ((_tmp5_ & GDK_WINDOW_STATE_FULLSCREEN) != 0) {
		GdkEventWindowState _tmp6_ = {0};
		GdkWindowState _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
		_tmp6_ = *event;
		_tmp7_ = _tmp6_.new_window_state;
		self->priv->is_fullscreen = (_tmp7_ & GDK_WINDOW_STATE_FULLSCREEN) != 0;
		_tmp8_ = self->priv->is_fullscreen;
		if (_tmp8_) {
			GtkToolButton* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			GtkToolButton* _tmp11_ = NULL;
			_tmp9_ = self->priv->fullscreen_button;
			_tmp10_ = _ ("_Leave Fullscreen");
			gtk_tool_button_set_label (_tmp9_, _tmp10_);
			_tmp11_ = self->priv->fullscreen_button;
			gtk_tool_button_set_icon_name (_tmp11_, "view-restore");
		} else {
			GtkToolButton* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			GtkToolButton* _tmp14_ = NULL;
			_tmp12_ = self->priv->fullscreen_button;
			_tmp13_ = _ ("_Fullscreen");
			gtk_tool_button_set_label (_tmp12_, _tmp13_);
			_tmp14_ = self->priv->fullscreen_button;
			gtk_tool_button_set_icon_name (_tmp14_, "view-fullscreen");
		}
	}
	result = FALSE;
	return result;
}


static void tetravex_real_shutdown (GApplication* base) {
	Tetravex * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GSettings* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	self = (Tetravex*) base;
	G_APPLICATION_CLASS (tetravex_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->window_width;
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->window_height;
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
	_tmp6_ = self->priv->settings;
	_tmp7_ = self->priv->is_fullscreen;
	g_settings_set_boolean (_tmp6_, "window-is-fullscreen", _tmp7_);
}


static void tetravex_real_activate (GApplication* base) {
	Tetravex * self;
	GtkWindow* _tmp0_ = NULL;
	self = (Tetravex*) base;
	_tmp0_ = self->priv->window;
	gtk_window_present (_tmp0_);
}


static void _tetravex_tick_cb_puzzle_tick (Puzzle* _sender, gpointer self) {
	tetravex_tick_cb (self);
}


static void _tetravex_solved_cb_puzzle_solved (Puzzle* _sender, gpointer self) {
	tetravex_solved_cb (self, _sender);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GVariant* _variant_new2 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static void tetravex_new_game (Tetravex* self) {
	Puzzle* _tmp0_ = NULL;
	gint size = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Puzzle* _tmp4_ = NULL;
	Puzzle* _tmp5_ = NULL;
	Puzzle* _tmp6_ = NULL;
	PuzzleView* _tmp7_ = NULL;
	Puzzle* _tmp8_ = NULL;
	GSimpleAction* pause = NULL;
	GAction* _tmp9_ = NULL;
	GSimpleAction* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzle;
	if (_tmp0_ != NULL) {
		Puzzle* _tmp1_ = NULL;
		_tmp1_ = self->priv->puzzle;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_int (_tmp2_, TETRAVEX_KEY_GRID_SIZE);
	size = _tmp3_;
	_tmp4_ = puzzle_new ((guint) size);
	_puzzle_unref0 (self->priv->puzzle);
	self->priv->puzzle = _tmp4_;
	_tmp5_ = self->priv->puzzle;
	g_signal_connect_object (_tmp5_, "tick", (GCallback) _tetravex_tick_cb_puzzle_tick, self, 0);
	_tmp6_ = self->priv->puzzle;
	g_signal_connect_object (_tmp6_, "solved", (GCallback) _tetravex_solved_cb_puzzle_solved, self, 0);
	_tmp7_ = self->priv->view;
	_tmp8_ = self->priv->puzzle;
	puzzle_view_set_puzzle (_tmp7_, _tmp8_);
	tetravex_tick_cb (self);
	_tmp9_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp9_) : NULL);
	pause = _tmp10_;
	_tmp11_ = _variant_new2 (FALSE);
	g_signal_emit_by_name (pause, "change-state", _tmp11_);
	_g_object_unref0 (pause);
}


static void tetravex_tick_cb (Tetravex* self) {
	gint elapsed = 0;
	Puzzle* _tmp0_ = NULL;
	gint hours = 0;
	gint _tmp4_ = 0;
	gint minutes = 0;
	gint _tmp5_ = 0;
	gint seconds = 0;
	gint _tmp6_ = 0;
	GtkLabel* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	elapsed = 0;
	_tmp0_ = self->priv->puzzle;
	if (_tmp0_ != NULL) {
		Puzzle* _tmp1_ = NULL;
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		_tmp1_ = self->priv->puzzle;
		_tmp2_ = puzzle_get_elapsed (_tmp1_);
		_tmp3_ = _tmp2_;
		elapsed = (gint) (_tmp3_ + 0.5);
	}
	_tmp4_ = elapsed;
	hours = _tmp4_ / 3600;
	_tmp5_ = elapsed;
	minutes = (_tmp5_ - (hours * 3600)) / 60;
	_tmp6_ = elapsed;
	seconds = (_tmp6_ - (hours * 3600)) - (minutes * 60);
	_tmp7_ = self->priv->clock_label;
	_tmp8_ = _ ("Time");
	_tmp9_ = g_strdup_printf ("%s: %02d:%02d:%02d", _tmp8_, hours, minutes, seconds);
	_tmp10_ = _tmp9_;
	gtk_label_set_text (_tmp7_, _tmp10_);
	_g_free0 (_tmp10_);
}


static void tetravex_solved_cb (Tetravex* self, Puzzle* puzzle) {
	GDateTime* date = NULL;
	GDateTime* _tmp0_ = NULL;
	guint duration = 0U;
	Puzzle* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	HistoryEntry* entry = NULL;
	GDateTime* _tmp4_ = NULL;
	Puzzle* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	HistoryEntry* _tmp9_ = NULL;
	History* _tmp10_ = NULL;
	HistoryEntry* _tmp11_ = NULL;
	History* _tmp12_ = NULL;
	HistoryEntry* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (puzzle != NULL);
	_tmp0_ = g_date_time_new_now_local ();
	date = _tmp0_;
	_tmp1_ = puzzle;
	_tmp2_ = puzzle_get_elapsed (_tmp1_);
	_tmp3_ = _tmp2_;
	duration = (guint) (_tmp3_ + 0.5);
	_tmp4_ = date;
	_tmp5_ = puzzle;
	_tmp6_ = puzzle_get_size (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = duration;
	_tmp9_ = history_entry_new (_tmp4_, _tmp7_, _tmp8_);
	entry = _tmp9_;
	_tmp10_ = self->priv->history;
	_tmp11_ = entry;
	history_add (_tmp10_, _tmp11_);
	_tmp12_ = self->priv->history;
	history_save (_tmp12_);
	_tmp13_ = entry;
	_tmp14_ = tetravex_show_scores (self, _tmp13_, TRUE);
	if (_tmp14_ == ((gint) GTK_RESPONSE_CLOSE)) {
		GtkWindow* _tmp15_ = NULL;
		_tmp15_ = self->priv->window;
		gtk_widget_destroy ((GtkWidget*) _tmp15_);
	} else {
		tetravex_new_game (self);
	}
	_history_entry_unref0 (entry);
	_g_date_time_unref0 (date);
}


static gint tetravex_show_scores (Tetravex* self, HistoryEntry* selected_entry, gboolean show_quit) {
	gint result = 0;
	ScoreDialog* dialog = NULL;
	History* _tmp0_ = NULL;
	HistoryEntry* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	ScoreDialog* _tmp3_ = NULL;
	GtkWindow* _tmp4_ = NULL;
	gint _result_ = 0;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->history;
	_tmp1_ = selected_entry;
	_tmp2_ = show_quit;
	_tmp3_ = score_dialog_new (_tmp0_, _tmp1_, _tmp2_);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	gtk_window_set_modal ((GtkWindow*) dialog, TRUE);
	_tmp4_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) dialog, _tmp4_);
	_tmp5_ = gtk_dialog_run ((GtkDialog*) dialog);
	_result_ = _tmp5_;
	gtk_widget_destroy ((GtkWidget*) dialog);
	result = _result_;
	_g_object_unref0 (dialog);
	return result;
}


static void tetravex_new_game_cb (Tetravex* self) {
	g_return_if_fail (self != NULL);
	tetravex_new_game (self);
}


static void tetravex_quit_cb (Tetravex* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void tetravex_scores_cb (Tetravex* self) {
	g_return_if_fail (self != NULL);
	tetravex_show_scores (self, NULL, FALSE);
}


static gboolean tetravex_view_button_press_event (Tetravex* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	Puzzle* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->puzzle;
	_tmp1_ = puzzle_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Puzzle* _tmp3_ = NULL;
		_tmp3_ = self->priv->puzzle;
		puzzle_set_paused (_tmp3_, FALSE);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void tetravex_solve_cb (Tetravex* self) {
	Puzzle* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzle;
	puzzle_solve (_tmp0_);
}


static void tetravex_help_cb (Tetravex* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-tetravex", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("gnome-tetravex.vala:303: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void tetravex_about_cb (Tetravex* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	gchar* license = NULL;
	gchar* _tmp5_ = NULL;
	GtkWindow* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Lars Rydlinge");
	_tmp1_ = g_strdup ("Robert Ancell");
	_tmp2_ = g_new0 (gchar*, 3 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp2_[2] = NULL;
	authors = _tmp2_;
	authors_length1 = 3;
	_authors_size_ = authors_length1;
	_tmp3_ = g_strdup ("Rob Bradford");
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp4_[1] = NULL;
	documenters = _tmp4_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp5_ = g_strdup ("Tetravex is free software; you can redistribute it and/or modify it un" \
"der the terms of the GNU General Public License as published by the Fr" \
"ee Software Foundation; either version 2 of the License, or (at your o" \
"ption) any later version.\n" \
"\n" \
"Tetravex is distributed in the hope that it will be useful, but WITHOU" \
"T ANY WARRANTY; without even the implied warranty of MERCHANTABILITY o" \
"r FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License" \
" for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License alon" \
"g with Tetravex; if not, write to the Free Software Foundation, Inc., " \
"51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA");
	license = _tmp5_;
	_tmp6_ = self->priv->window;
	_tmp7_ = _ ("Tetravex");
	_tmp8_ = _ ("Position pieces so that the same numbers are touching each other\n" \
"\n" \
"Tetravex is a part of GNOME Games.");
	_tmp9_ = _ ("translator-credits");
	_tmp10_ = _ ("GNOME Games web site");
	gtk_show_about_dialog (_tmp6_, "program-name", _tmp7_, "version", VERSION, "comments", _tmp8_, "copyright", "Copyright \xc2\xa9 1999-2008 Lars Rydlinge", "license", license, "wrap-license", TRUE, "authors", authors, "documenters", documenters, "translator-credits", _tmp9_, "logo-icon-name", "gnome-tetravex", "website", "http://www.gnome.org/projects/gnome-games", "website-label", _tmp10_, NULL, NULL);
	_g_free0 (license);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static gchar* _variant_get3 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void tetravex_size_changed (Tetravex* self, GSimpleAction* action, GVariant* value) {
	gchar size = '\0';
	GVariant* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar _tmp3_ = '\0';
	gchar _tmp4_ = '\0';
	gchar _tmp5_ = '\0';
	GSettings* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GSettings* _tmp8_ = NULL;
	gchar _tmp9_ = '\0';
	GSimpleAction* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = value;
	_tmp1_ = _variant_get3 (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_get (_tmp2_, (glong) 0);
	_tmp4_ = _tmp3_ - '0';
	_g_free0 (_tmp2_);
	size = _tmp4_;
	_tmp5_ = size;
	_tmp6_ = self->priv->settings;
	_tmp7_ = g_settings_get_int (_tmp6_, TETRAVEX_KEY_GRID_SIZE);
	if (((gint) _tmp5_) == _tmp7_) {
		return;
	}
	_tmp8_ = self->priv->settings;
	_tmp9_ = size;
	g_settings_set_int (_tmp8_, TETRAVEX_KEY_GRID_SIZE, (gint) _tmp9_);
	_tmp10_ = action;
	_tmp11_ = value;
	g_simple_action_set_state (_tmp10_, _tmp11_);
	tetravex_new_game (self);
}


static void tetravex_move_up_cb (Tetravex* self) {
	Puzzle* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzle;
	puzzle_move_up (_tmp0_);
}


static void tetravex_move_left_cb (Tetravex* self) {
	Puzzle* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzle;
	puzzle_move_left (_tmp0_);
}


static void tetravex_move_right_cb (Tetravex* self) {
	Puzzle* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzle;
	puzzle_move_right (_tmp0_);
}


static void tetravex_move_down_cb (Tetravex* self) {
	Puzzle* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzle;
	puzzle_move_down (_tmp0_);
}


static void tetravex_pause_cb (Tetravex* self, GSimpleAction* action, GVariant* parameter) {
	Puzzle* _tmp0_ = NULL;
	Puzzle* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GSimpleAction* solve = NULL;
	GAction* _tmp4_ = NULL;
	GSimpleAction* _tmp5_ = NULL;
	GSimpleAction* _tmp6_ = NULL;
	Puzzle* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	Puzzle* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->puzzle;
	_tmp1_ = self->priv->puzzle;
	_tmp2_ = puzzle_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	puzzle_set_paused (_tmp0_, !_tmp3_);
	_tmp4_ = g_action_map_lookup_action ((GActionMap*) self, "solve");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp4_) : NULL);
	solve = _tmp5_;
	_tmp6_ = solve;
	_tmp7_ = self->priv->puzzle;
	_tmp8_ = puzzle_get_paused (_tmp7_);
	_tmp9_ = _tmp8_;
	g_simple_action_set_enabled (_tmp6_, !_tmp9_);
	_tmp10_ = self->priv->puzzle;
	_tmp11_ = puzzle_get_paused (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_) {
		GtkToolButton* _tmp13_ = NULL;
		GtkToolButton* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		_tmp13_ = self->priv->pause_button;
		gtk_tool_button_set_icon_name (_tmp13_, "media-playback-start");
		_tmp14_ = self->priv->pause_button;
		_tmp15_ = _ ("Res_ume");
		gtk_tool_button_set_label (_tmp14_, _tmp15_);
	} else {
		GtkToolButton* _tmp16_ = NULL;
		GtkToolButton* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		_tmp16_ = self->priv->pause_button;
		gtk_tool_button_set_icon_name (_tmp16_, "media-playback-pause");
		_tmp17_ = self->priv->pause_button;
		_tmp18_ = _ ("_Pause");
		gtk_tool_button_set_label (_tmp17_, _tmp18_);
	}
	_g_object_unref0 (solve);
}


static void tetravex_fullscreen_cb (Tetravex* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_fullscreen;
	if (_tmp0_) {
		GtkWindow* _tmp1_ = NULL;
		_tmp1_ = self->priv->window;
		gtk_window_unfullscreen (_tmp1_);
	} else {
		GtkWindow* _tmp2_ = NULL;
		_tmp2_ = self->priv->window;
		gtk_window_fullscreen (_tmp2_);
	}
}


static void tetravex_radio_cb (Tetravex* self, GSimpleAction* action, GVariant* parameter) {
	GSimpleAction* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = parameter;
	g_signal_emit_by_name (_tmp0_, "change-state", _tmp1_);
}


gint tetravex_main (gchar** args, int args_length1) {
	gint result = 0;
	Tetravex* app = NULL;
	Tetravex* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = tetravex_new ();
	app = _tmp0_;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = g_application_run ((GApplication*) app, _tmp1__length1, _tmp1_);
	result = _tmp2_;
	_g_object_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return tetravex_main (argv, argc);
}


static void tetravex_class_init (TetravexClass * klass) {
	tetravex_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TetravexPrivate));
	G_APPLICATION_CLASS (klass)->startup = tetravex_real_startup;
	G_APPLICATION_CLASS (klass)->shutdown = tetravex_real_shutdown;
	G_APPLICATION_CLASS (klass)->activate = tetravex_real_activate;
	G_OBJECT_CLASS (klass)->finalize = tetravex_finalize;
}


static void tetravex_instance_init (Tetravex * self) {
	self->priv = TETRAVEX_GET_PRIVATE (self);
}


static void tetravex_finalize (GObject* obj) {
	Tetravex * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TETRAVEX, Tetravex);
	_g_object_unref0 (self->priv->settings);
	_puzzle_unref0 (self->priv->puzzle);
	_g_object_unref0 (self->priv->clock_label);
	_history_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->pause_button);
	_g_object_unref0 (self->priv->fullscreen_button);
	G_OBJECT_CLASS (tetravex_parent_class)->finalize (obj);
}


GType tetravex_get_type (void) {
	static volatile gsize tetravex_type_id__volatile = 0;
	if (g_once_init_enter (&tetravex_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TetravexClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tetravex_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Tetravex), 0, (GInstanceInitFunc) tetravex_instance_init, NULL };
		GType tetravex_type_id;
		tetravex_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Tetravex", &g_define_type_info, 0);
		g_once_init_leave (&tetravex_type_id__volatile, tetravex_type_id);
	}
	return tetravex_type_id__volatile;
}


static gpointer _history_ref0 (gpointer self) {
	return self ? history_ref (self) : NULL;
}


static void _score_dialog_entry_added_cb_history_entry_added (History* _sender, HistoryEntry* entry, gpointer self) {
	score_dialog_entry_added_cb (self, entry);
}


static gpointer _history_entry_ref0 (gpointer self) {
	return self ? history_entry_ref (self) : NULL;
}


static void _score_dialog_size_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	score_dialog_size_changed_cb (self, _sender);
}


ScoreDialog* score_dialog_construct (GType object_type, History* history, HistoryEntry* selected_entry, gboolean show_quit) {
	ScoreDialog * self = NULL;
	History* _tmp0_ = NULL;
	History* _tmp1_ = NULL;
	History* _tmp2_ = NULL;
	HistoryEntry* _tmp3_ = NULL;
	HistoryEntry* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GtkBox* vbox = NULL;
	GtkBox* _tmp7_ = NULL;
	GtkBox* _tmp8_ = NULL;
	GtkBox* _tmp9_ = NULL;
	GtkBox* _tmp10_ = NULL;
	GtkBox* _tmp11_ = NULL;
	GtkBox* hbox = NULL;
	GtkBox* _tmp12_ = NULL;
	GtkBox* _tmp13_ = NULL;
	GtkBox* _tmp14_ = NULL;
	GtkBox* _tmp15_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	GtkBox* _tmp19_ = NULL;
	GtkLabel* _tmp20_ = NULL;
	GtkListStore* _tmp21_ = NULL;
	GtkComboBox* _tmp22_ = NULL;
	GtkComboBox* _tmp23_ = NULL;
	GtkComboBox* _tmp24_ = NULL;
	GtkListStore* _tmp25_ = NULL;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp26_ = NULL;
	GtkComboBox* _tmp27_ = NULL;
	GtkCellRendererText* _tmp28_ = NULL;
	GtkComboBox* _tmp29_ = NULL;
	GtkCellRendererText* _tmp30_ = NULL;
	GtkComboBox* _tmp31_ = NULL;
	GtkBox* _tmp32_ = NULL;
	GtkComboBox* _tmp33_ = NULL;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp34_ = NULL;
	GtkScrolledWindow* _tmp35_ = NULL;
	GtkScrolledWindow* _tmp36_ = NULL;
	GtkScrolledWindow* _tmp37_ = NULL;
	GtkBox* _tmp38_ = NULL;
	GtkScrolledWindow* _tmp39_ = NULL;
	GtkListStore* _tmp40_ = NULL;
	GtkTreeView* scores = NULL;
	GtkTreeView* _tmp41_ = NULL;
	GtkCellRendererText* _tmp42_ = NULL;
	GtkTreeView* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	GtkCellRendererText* _tmp45_ = NULL;
	GtkCellRendererText* _tmp46_ = NULL;
	GtkCellRendererText* _tmp47_ = NULL;
	GtkTreeView* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	GtkCellRendererText* _tmp50_ = NULL;
	GtkTreeView* _tmp51_ = NULL;
	GtkListStore* _tmp52_ = NULL;
	GtkTreeView* _tmp53_ = NULL;
	GtkScrolledWindow* _tmp54_ = NULL;
	GtkTreeView* _tmp55_ = NULL;
	History* _tmp56_ = NULL;
	GList* _tmp57_ = NULL;
	g_return_val_if_fail (history != NULL, NULL);
	self = (ScoreDialog*) g_object_new (object_type, NULL);
	_tmp0_ = history;
	_tmp1_ = _history_ref0 (_tmp0_);
	_history_unref0 (self->priv->history);
	self->priv->history = _tmp1_;
	_tmp2_ = history;
	g_signal_connect_object (_tmp2_, "entry-added", (GCallback) _score_dialog_entry_added_cb_history_entry_added, self, 0);
	_tmp3_ = selected_entry;
	_tmp4_ = _history_entry_ref0 (_tmp3_);
	_history_entry_unref0 (self->priv->selected_entry);
	self->priv->selected_entry = _tmp4_;
	_tmp5_ = show_quit;
	if (_tmp5_) {
		const gchar* _tmp6_ = NULL;
		gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_QUIT, (gint) GTK_RESPONSE_CLOSE);
		_tmp6_ = _ ("New Game");
		gtk_dialog_add_button ((GtkDialog*) self, _tmp6_, (gint) GTK_RESPONSE_OK);
	} else {
		gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_OK, (gint) GTK_RESPONSE_DELETE_EVENT);
	}
	gtk_widget_set_size_request ((GtkWidget*) self, 200, 300);
	_tmp7_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
	g_object_ref_sink (_tmp7_);
	vbox = _tmp7_;
	_tmp8_ = vbox;
	gtk_container_set_border_width ((GtkContainer*) _tmp8_, (guint) 6);
	_tmp9_ = vbox;
	gtk_widget_show ((GtkWidget*) _tmp9_);
	_tmp10_ = (GtkBox*) gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp11_ = vbox;
	gtk_box_pack_start (_tmp10_, (GtkWidget*) _tmp11_, TRUE, TRUE, (guint) 0);
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp12_);
	hbox = _tmp12_;
	_tmp13_ = hbox;
	gtk_widget_show ((GtkWidget*) _tmp13_);
	_tmp14_ = vbox;
	_tmp15_ = hbox;
	gtk_box_pack_start (_tmp14_, (GtkWidget*) _tmp15_, FALSE, FALSE, (guint) 0);
	_tmp16_ = _ ("Size:");
	_tmp17_ = (GtkLabel*) gtk_label_new (_tmp16_);
	g_object_ref_sink (_tmp17_);
	label = _tmp17_;
	_tmp18_ = label;
	gtk_widget_show ((GtkWidget*) _tmp18_);
	_tmp19_ = hbox;
	_tmp20_ = label;
	gtk_box_pack_start (_tmp19_, (GtkWidget*) _tmp20_, FALSE, FALSE, (guint) 0);
	_tmp21_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
	_g_object_unref0 (self->priv->size_model);
	self->priv->size_model = _tmp21_;
	_tmp22_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->size_combo);
	self->priv->size_combo = _tmp22_;
	_tmp23_ = self->priv->size_combo;
	g_signal_connect_object (_tmp23_, "changed", (GCallback) _score_dialog_size_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp24_ = self->priv->size_combo;
	_tmp25_ = self->priv->size_model;
	gtk_combo_box_set_model (_tmp24_, (GtkTreeModel*) _tmp25_);
	_tmp26_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp26_);
	renderer = _tmp26_;
	_tmp27_ = self->priv->size_combo;
	_tmp28_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp27_, (GtkCellRenderer*) _tmp28_, TRUE);
	_tmp29_ = self->priv->size_combo;
	_tmp30_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp29_, (GtkCellRenderer*) _tmp30_, "text", 0);
	_tmp31_ = self->priv->size_combo;
	gtk_widget_show ((GtkWidget*) _tmp31_);
	_tmp32_ = hbox;
	_tmp33_ = self->priv->size_combo;
	gtk_box_pack_start (_tmp32_, (GtkWidget*) _tmp33_, TRUE, TRUE, (guint) 0);
	_tmp34_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp34_);
	scroll = _tmp34_;
	_tmp35_ = scroll;
	gtk_scrolled_window_set_shadow_type (_tmp35_, GTK_SHADOW_ETCHED_IN);
	_tmp36_ = scroll;
	gtk_scrolled_window_set_policy (_tmp36_, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp37_ = scroll;
	gtk_widget_show ((GtkWidget*) _tmp37_);
	_tmp38_ = vbox;
	_tmp39_ = scroll;
	gtk_box_pack_start (_tmp38_, (GtkWidget*) _tmp39_, TRUE, TRUE, (guint) 0);
	_tmp40_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT);
	_g_object_unref0 (self->priv->score_model);
	self->priv->score_model = _tmp40_;
	_tmp41_ = (GtkTreeView*) gtk_tree_view_new ();
	g_object_ref_sink (_tmp41_);
	scores = _tmp41_;
	_tmp42_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp42_);
	_g_object_unref0 (renderer);
	renderer = _tmp42_;
	_tmp43_ = scores;
	_tmp44_ = _ ("Date");
	_tmp45_ = renderer;
	gtk_tree_view_insert_column_with_attributes (_tmp43_, -1, _tmp44_, (GtkCellRenderer*) _tmp45_, "text", 0, "weight", 2, NULL);
	_tmp46_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (renderer);
	renderer = _tmp46_;
	_tmp47_ = renderer;
	g_object_set ((GtkCellRenderer*) _tmp47_, "xalign", 1.0f, NULL);
	_tmp48_ = scores;
	_tmp49_ = _ ("Time");
	_tmp50_ = renderer;
	gtk_tree_view_insert_column_with_attributes (_tmp48_, -1, _tmp49_, (GtkCellRenderer*) _tmp50_, "text", 1, "weight", 2, NULL);
	_tmp51_ = scores;
	_tmp52_ = self->priv->score_model;
	gtk_tree_view_set_model (_tmp51_, (GtkTreeModel*) _tmp52_);
	_tmp53_ = scores;
	gtk_widget_show ((GtkWidget*) _tmp53_);
	_tmp54_ = scroll;
	_tmp55_ = scores;
	gtk_container_add ((GtkContainer*) _tmp54_, (GtkWidget*) _tmp55_);
	_tmp56_ = history;
	_tmp57_ = _tmp56_->entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp57_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			HistoryEntry* _tmp58_ = NULL;
			HistoryEntry* entry = NULL;
			_tmp58_ = _history_entry_ref0 ((HistoryEntry*) entry_it->data);
			entry = _tmp58_;
			{
				HistoryEntry* _tmp59_ = NULL;
				_tmp59_ = entry;
				score_dialog_entry_added_cb (self, _tmp59_);
				_history_entry_unref0 (entry);
			}
		}
	}
	_g_object_unref0 (scores);
	_g_object_unref0 (scroll);
	_g_object_unref0 (renderer);
	_g_object_unref0 (label);
	_g_object_unref0 (hbox);
	_g_object_unref0 (vbox);
	return self;
}


ScoreDialog* score_dialog_new (History* history, HistoryEntry* selected_entry, gboolean show_quit) {
	return score_dialog_construct (TYPE_SCORE_DIALOG, history, selected_entry, show_quit);
}


static gint _score_dialog_compare_entries_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = score_dialog_compare_entries (a, b);
	return result;
}


void score_dialog_set_size (ScoreDialog* self, guint size) {
	GtkListStore* _tmp0_ = NULL;
	GList* entries = NULL;
	History* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->score_model;
	gtk_list_store_clear (_tmp0_);
	_tmp1_ = self->priv->history;
	_tmp2_ = _tmp1_->entries;
	_tmp3_ = g_list_copy (_tmp2_);
	entries = _tmp3_;
	entries = g_list_sort (entries, _score_dialog_compare_entries_gcompare_func);
	_tmp4_ = entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp4_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			HistoryEntry* entry = NULL;
			entry = (HistoryEntry*) entry_it->data;
			{
				HistoryEntry* _tmp5_ = NULL;
				guint _tmp6_ = 0U;
				guint _tmp7_ = 0U;
				gchar* date_label = NULL;
				HistoryEntry* _tmp8_ = NULL;
				GDateTime* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				gchar* time_label = NULL;
				HistoryEntry* _tmp11_ = NULL;
				guint _tmp12_ = 0U;
				gchar* _tmp13_ = NULL;
				HistoryEntry* _tmp14_ = NULL;
				guint _tmp15_ = 0U;
				gint weight = 0;
				HistoryEntry* _tmp21_ = NULL;
				HistoryEntry* _tmp22_ = NULL;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp23_ = NULL;
				GtkTreeIter _tmp24_ = {0};
				GtkListStore* _tmp25_ = NULL;
				GtkTreeIter _tmp26_ = {0};
				const gchar* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				_tmp5_ = entry;
				_tmp6_ = _tmp5_->size;
				_tmp7_ = size;
				if (_tmp6_ != _tmp7_) {
					continue;
				}
				_tmp8_ = entry;
				_tmp9_ = _tmp8_->date;
				_tmp10_ = g_date_time_format (_tmp9_, "%d/%m/%Y");
				date_label = _tmp10_;
				_tmp11_ = entry;
				_tmp12_ = _tmp11_->duration;
				_tmp13_ = g_strdup_printf ("%us", _tmp12_);
				time_label = _tmp13_;
				_tmp14_ = entry;
				_tmp15_ = _tmp14_->duration;
				if (_tmp15_ >= ((guint) 60)) {
					HistoryEntry* _tmp16_ = NULL;
					guint _tmp17_ = 0U;
					HistoryEntry* _tmp18_ = NULL;
					guint _tmp19_ = 0U;
					gchar* _tmp20_ = NULL;
					_tmp16_ = entry;
					_tmp17_ = _tmp16_->duration;
					_tmp18_ = entry;
					_tmp19_ = _tmp18_->duration;
					_tmp20_ = g_strdup_printf ("%um %us", _tmp17_ / 60, _tmp19_ % 60);
					_g_free0 (time_label);
					time_label = _tmp20_;
				}
				weight = (gint) PANGO_WEIGHT_NORMAL;
				_tmp21_ = entry;
				_tmp22_ = self->priv->selected_entry;
				if (_tmp21_ == _tmp22_) {
					weight = (gint) PANGO_WEIGHT_BOLD;
				}
				_tmp23_ = self->priv->score_model;
				gtk_list_store_append (_tmp23_, &_tmp24_);
				iter = _tmp24_;
				_tmp25_ = self->priv->score_model;
				_tmp26_ = iter;
				_tmp27_ = date_label;
				_tmp28_ = time_label;
				_tmp29_ = weight;
				gtk_list_store_set (_tmp25_, &_tmp26_, 0, _tmp27_, 1, _tmp28_, 2, _tmp29_, -1);
				_g_free0 (time_label);
				_g_free0 (date_label);
			}
		}
	}
	_g_list_free0 (entries);
}


static gint score_dialog_compare_entries (HistoryEntry* a, HistoryEntry* b) {
	gint result = 0;
	HistoryEntry* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	HistoryEntry* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	HistoryEntry* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	HistoryEntry* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	HistoryEntry* _tmp16_ = NULL;
	GDateTime* _tmp17_ = NULL;
	HistoryEntry* _tmp18_ = NULL;
	GDateTime* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = _tmp0_->size;
	_tmp2_ = b;
	_tmp3_ = _tmp2_->size;
	if (_tmp1_ != _tmp3_) {
		HistoryEntry* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		HistoryEntry* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
		_tmp4_ = a;
		_tmp5_ = _tmp4_->size;
		_tmp6_ = b;
		_tmp7_ = _tmp6_->size;
		result = ((gint) _tmp5_) - ((gint) _tmp7_);
		return result;
	}
	_tmp8_ = a;
	_tmp9_ = _tmp8_->duration;
	_tmp10_ = b;
	_tmp11_ = _tmp10_->duration;
	if (_tmp9_ != _tmp11_) {
		HistoryEntry* _tmp12_ = NULL;
		guint _tmp13_ = 0U;
		HistoryEntry* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		_tmp12_ = a;
		_tmp13_ = _tmp12_->duration;
		_tmp14_ = b;
		_tmp15_ = _tmp14_->duration;
		result = ((gint) _tmp13_) - ((gint) _tmp15_);
		return result;
	}
	_tmp16_ = a;
	_tmp17_ = _tmp16_->date;
	_tmp18_ = b;
	_tmp19_ = _tmp18_->date;
	_tmp20_ = g_date_time_compare (_tmp17_, _tmp19_);
	result = _tmp20_;
	return result;
}


static void score_dialog_size_changed_cb (ScoreDialog* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint size = 0;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gint _tmp7_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &size, -1);
	_tmp7_ = size;
	score_dialog_set_size (self, (guint) _tmp7_);
}


static void score_dialog_entry_added_cb (ScoreDialog* self, HistoryEntry* entry) {
	GtkTreeIter iter = {0};
	gboolean have_size_entry = FALSE;
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	have_size_entry = FALSE;
	_tmp0_ = self->priv->size_model;
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				gint size = 0;
				gint height = 0;
				gint n_mines = 0;
				GtkListStore* _tmp7_ = NULL;
				GtkTreeIter _tmp8_ = {0};
				gint _tmp9_ = 0;
				HistoryEntry* _tmp10_ = NULL;
				guint _tmp11_ = 0U;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					GtkListStore* _tmp5_ = NULL;
					gboolean _tmp6_ = FALSE;
					_tmp5_ = self->priv->size_model;
					_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter);
					if (!_tmp6_) {
						break;
					}
				}
				_tmp3_ = FALSE;
				_tmp7_ = self->priv->size_model;
				_tmp8_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp7_, &_tmp8_, 1, &size, 2, &height, 3, &n_mines, -1);
				_tmp9_ = size;
				_tmp10_ = entry;
				_tmp11_ = _tmp10_->size;
				if (((guint) _tmp9_) == _tmp11_) {
					have_size_entry = TRUE;
					break;
				}
			}
		}
	}
	_tmp12_ = have_size_entry;
	if (!_tmp12_) {
		gchar* label = NULL;
		HistoryEntry* _tmp13_ = NULL;
		guint _tmp14_ = 0U;
		HistoryEntry* _tmp15_ = NULL;
		guint _tmp16_ = 0U;
		gchar* _tmp17_ = NULL;
		GtkListStore* _tmp18_ = NULL;
		GtkTreeIter _tmp19_ = {0};
		GtkListStore* _tmp20_ = NULL;
		GtkTreeIter _tmp21_ = {0};
		const gchar* _tmp22_ = NULL;
		HistoryEntry* _tmp23_ = NULL;
		guint _tmp24_ = 0U;
		GtkComboBox* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gboolean _tmp29_ = FALSE;
		HistoryEntry* _tmp30_ = NULL;
		gboolean _tmp35_ = FALSE;
		_tmp13_ = entry;
		_tmp14_ = _tmp13_->size;
		_tmp15_ = entry;
		_tmp16_ = _tmp15_->size;
		_tmp17_ = g_strdup_printf ("%u × %u", _tmp14_, _tmp16_);
		label = _tmp17_;
		_tmp18_ = self->priv->size_model;
		gtk_list_store_append (_tmp18_, &_tmp19_);
		iter = _tmp19_;
		_tmp20_ = self->priv->size_model;
		_tmp21_ = iter;
		_tmp22_ = label;
		_tmp23_ = entry;
		_tmp24_ = _tmp23_->size;
		gtk_list_store_set (_tmp20_, &_tmp21_, 0, _tmp22_, 1, _tmp24_, -1);
		_tmp25_ = self->priv->size_combo;
		_tmp26_ = gtk_combo_box_get_active (_tmp25_);
		if (_tmp26_ == (-1)) {
			GtkComboBox* _tmp27_ = NULL;
			GtkTreeIter _tmp28_ = {0};
			_tmp27_ = self->priv->size_combo;
			_tmp28_ = iter;
			gtk_combo_box_set_active_iter (_tmp27_, &_tmp28_);
		}
		_tmp30_ = self->priv->selected_entry;
		if (_tmp30_ != NULL) {
			HistoryEntry* _tmp31_ = NULL;
			guint _tmp32_ = 0U;
			HistoryEntry* _tmp33_ = NULL;
			guint _tmp34_ = 0U;
			_tmp31_ = entry;
			_tmp32_ = _tmp31_->size;
			_tmp33_ = self->priv->selected_entry;
			_tmp34_ = _tmp33_->size;
			_tmp29_ = _tmp32_ == _tmp34_;
		} else {
			_tmp29_ = FALSE;
		}
		_tmp35_ = _tmp29_;
		if (_tmp35_) {
			GtkComboBox* _tmp36_ = NULL;
			GtkTreeIter _tmp37_ = {0};
			_tmp36_ = self->priv->size_combo;
			_tmp37_ = iter;
			gtk_combo_box_set_active_iter (_tmp36_, &_tmp37_);
		}
		_g_free0 (label);
	}
}


static void score_dialog_class_init (ScoreDialogClass * klass) {
	score_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ScoreDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = score_dialog_finalize;
}


static void score_dialog_instance_init (ScoreDialog * self) {
	self->priv = SCORE_DIALOG_GET_PRIVATE (self);
	self->priv->selected_entry = NULL;
}


static void score_dialog_finalize (GObject* obj) {
	ScoreDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCORE_DIALOG, ScoreDialog);
	_history_unref0 (self->priv->history);
	_history_entry_unref0 (self->priv->selected_entry);
	_g_object_unref0 (self->priv->size_model);
	_g_object_unref0 (self->priv->score_model);
	_g_object_unref0 (self->priv->size_combo);
	G_OBJECT_CLASS (score_dialog_parent_class)->finalize (obj);
}


GType score_dialog_get_type (void) {
	static volatile gsize score_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&score_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ScoreDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) score_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScoreDialog), 0, (GInstanceInitFunc) score_dialog_instance_init, NULL };
		GType score_dialog_type_id;
		score_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "ScoreDialog", &g_define_type_info, 0);
		g_once_init_leave (&score_dialog_type_id__volatile, score_dialog_type_id);
	}
	return score_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



