/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-project-chooser.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-project-chooser
 * @title: IAnjutaProjectChooser
 * @short_description: Interface for selecting project node
 * @see_also:
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-project-chooser.h
 *
 */

#include "ianjuta-project-chooser.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_project_chooser_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-project-chooser-quark");
	}
	
	return quark;
}

/**
 * ianjuta_project_chooser_get_selected:
 * @obj: Self
 * @err: Error propagation and reporting.
 *
 * Gets the currently selected element in the project chooser.
 *
 * Returns: (transfer none): A #GFile corresponding to the selected
 * element in the project view or %NULL if no valid node is selected.
 * The file is owned by the widget If you want to keep a pointer to
 * the file you must add a refcount using g_object_ref().
 */
GFile*
ianjuta_project_chooser_get_selected (IAnjutaProjectChooser *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_CHOOSER(obj), NULL);
	return IANJUTA_PROJECT_CHOOSER_GET_IFACE (obj)->get_selected (obj, err);
}

/* Default implementation */
static GFile*
ianjuta_project_chooser_get_selected_default (IAnjutaProjectChooser *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_project_chooser_set_project_model:
 * @obj: Self
 * @manager: A project manager
 * @child_type: Select one element type: source, group or target
 * @err: Error propagation and reporting.
 *
 * Initialize a project chooser button allowing to select a parent node
 * where you can add the nodes of type child_type.
 * As special cases with
 * <variablelist>
 *   <varlistentry>
 *     <term>ANJUTA_PROJECT_ROOT</term>
 *     <listitem><para>all nodes are included</para></listitem>
 *   </varlistentry>
 *   <varlistentry>
 *     <term>ANJUTA_PROJECT_MODULE</term>
 *     <listitem><para>only modules are included, this can be used
 *     to add a new package. While ANJUTA_PROJECT_PACKAGE allows you
 *     to select a target using a package.</para></listitem>
 *   </varlistentry>
 * </variablelist>
 *
 * Returns: TRUE if sucessful, other FALSE.
 */
gboolean
ianjuta_project_chooser_set_project_model (IAnjutaProjectChooser *obj, IAnjutaProjectManager *manager,   AnjutaProjectNodeType child_type, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_CHOOSER(obj), FALSE);
	g_return_val_if_fail ((manager == NULL) ||IANJUTA_IS_PROJECT_MANAGER(manager), FALSE);
	return IANJUTA_PROJECT_CHOOSER_GET_IFACE (obj)->set_project_model (obj, manager, child_type, err);
}

/* Default implementation */
static gboolean
ianjuta_project_chooser_set_project_model_default (IAnjutaProjectChooser *obj, IAnjutaProjectManager *manager,   AnjutaProjectNodeType child_type, GError **err)
{
	g_return_val_if_reached (FALSE);
}

static void
ianjuta_project_chooser_base_init (IAnjutaProjectChooserIface* klass)
{
	static gboolean initialized = FALSE;

	klass->get_selected = ianjuta_project_chooser_get_selected_default;
	klass->set_project_model = ianjuta_project_chooser_set_project_model_default;
	
	if (!initialized) {

		/**
		* IAnjutaProjectChooser::changed:
		* @obj: Self
		*
		* Emitted when the selected node is changed.
		*/
		g_signal_new ("changed",
			IANJUTA_TYPE_PROJECT_CHOOSER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaProjectChooserIface, changed),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE,
			0,
			NULL);


		initialized = TRUE;
	}
}

GType
ianjuta_project_chooser_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaProjectChooserIface),
			(GBaseInitFunc) ianjuta_project_chooser_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaProjectChooser", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
