/* rygel-main.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-main.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2012 Openismus GmbH.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "rygel-core.h"
#include <libgupnp/gupnp.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <glib-unix.h>
#include <signal.h>
#include <gio/gio.h>
#include <libgssdp/gssdp.h>
#include <locale.h>
#include <unistd.h>


#define RYGEL_TYPE_MAIN (rygel_main_get_type ())
#define RYGEL_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MAIN, RygelMain))
#define RYGEL_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MAIN, RygelMainClass))
#define RYGEL_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MAIN))
#define RYGEL_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MAIN))
#define RYGEL_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MAIN, RygelMainClass))

typedef struct _RygelMain RygelMain;
typedef struct _RygelMainClass RygelMainClass;
typedef struct _RygelMainPrivate RygelMainPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_root_device_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_root_device_factory_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelMainCreateDeviceData RygelMainCreateDeviceData;

#define RYGEL_TYPE_DBUS_SERVICE (rygel_dbus_service_get_type ())
#define RYGEL_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DBUS_SERVICE, RygelDBusService))
#define RYGEL_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DBUS_SERVICE, RygelDBusServiceClass))
#define RYGEL_IS_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DBUS_SERVICE))
#define RYGEL_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DBUS_SERVICE))
#define RYGEL_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DBUS_SERVICE, RygelDBusServiceClass))

typedef struct _RygelDBusService RygelDBusService;
typedef struct _RygelDBusServiceClass RygelDBusServiceClass;

struct _RygelMain {
	GObject parent_instance;
	RygelMainPrivate * priv;
	gboolean need_restart;
};

struct _RygelMainClass {
	GObjectClass parent_class;
};

struct _RygelMainPrivate {
	RygelPluginLoader* plugin_loader;
	GUPnPContextManager* context_manager;
	GeeArrayList* factories;
	GeeArrayList* root_devices;
	RygelConfiguration* config;
	RygelLogHandler* log_handler;
	GMainLoop* main_loop;
	gint exit_code;
};

struct _RygelMainCreateDeviceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMain* self;
	RygelPlugin* plugin;
	RygelRootDeviceFactory* factory;
	RygelRootDeviceFactory* _tmp0_;
	RygelPlugin* _tmp1_;
	RygelRootDevice* _tmp2_;
	RygelRootDevice* device;
	gboolean _tmp3_;
	RygelPlugin* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	RygelConfiguration* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	RygelRootDevice* _tmp10_;
	gboolean _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	RygelRootDevice* _tmp14_;
	RygelPlugin* _tmp15_;
	GError* _error_;
	const gchar* _tmp16_;
	RygelPlugin* _tmp17_;
	const gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError * _inner_error_;
};


static gpointer rygel_main_parent_class = NULL;
static gint rygel_main_PLUGIN_TIMEOUT;
static gint rygel_main_PLUGIN_TIMEOUT = 5;

gboolean gst_preset_set_app_dir (const gchar* app_dir);
GType rygel_main_get_type (void) G_GNUC_CONST;
#define RYGEL_MAIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MAIN, RygelMainPrivate))
enum  {
	RYGEL_MAIN_DUMMY_PROPERTY
};
static RygelMain* rygel_main_new (GError** error);
static RygelMain* rygel_main_construct (GType object_type, GError** error);
static void rygel_main_on_plugin_loaded (RygelMain* self, RygelPluginLoader* plugin_loader, RygelPlugin* plugin);
static void _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self);
static gboolean __lambda2_ (RygelMain* self);
void rygel_main_restart (RygelMain* self);
static gboolean ___lambda2__gsource_func (gpointer self);
static gboolean __lambda3_ (RygelMain* self);
void rygel_main_exit (RygelMain* self, gint exit_code);
static gboolean ___lambda3__gsource_func (gpointer self);
static gboolean __lambda4_ (RygelMain* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static gint rygel_main_run (RygelMain* self);
void rygel_main_dbus_available (RygelMain* self);
static GUPnPContextManager* rygel_main_create_context_manager (RygelMain* self);
static gboolean __lambda5_ (RygelMain* self);
static gboolean ___lambda5__gsource_func (gpointer self);
static void rygel_main_create_device (RygelMain* self, RygelPlugin* plugin, RygelRootDeviceFactory* factory, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_main_create_device_finish (RygelMain* self, GAsyncResult* _res_);
static void rygel_main_on_context_available (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context);
static void _rygel_main_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self);
static void rygel_main_on_context_unavailable (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context);
static void _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self);
static void rygel_main_create_device_data_free (gpointer _data);
static gboolean rygel_main_create_device_co (RygelMainCreateDeviceData* _data_);
static gboolean _rygel_main_create_device_co_gsource_func (gpointer self);
static void rygel_main_on_plugin_active_notify (RygelMain* self, GObject* obj, GParamSpec* spec);
static void _rygel_main_on_plugin_active_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gint rygel_main_main (gchar** args, int args_length1);
GType rygel_dbus_service_get_type (void) G_GNUC_CONST;
guint rygel_dbus_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
static gchar** _vala_array_dup1 (gchar** self, int length);
RygelDBusService* rygel_dbus_service_new (RygelMain* main);
RygelDBusService* rygel_dbus_service_construct (GType object_type, RygelMain* main);
void rygel_dbus_service_publish (RygelDBusService* self);
void rygel_dbus_service_unpublish (RygelDBusService* self);
static void rygel_main_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self) {
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_on_plugin_loaded (self, _sender, plugin);
#line 184 "rygel-main.c"
}


static gboolean __lambda2_ (RygelMain* self) {
	gboolean result = FALSE;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_restart (self);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = TRUE;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 196 "rygel-main.c"
}


static gboolean ___lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda2_ (self);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 205 "rygel-main.c"
}


static gboolean __lambda3_ (RygelMain* self) {
	gboolean result = FALSE;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_exit (self, 0);
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = FALSE;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 217 "rygel-main.c"
}


static gboolean ___lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda3_ (self);
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 226 "rygel-main.c"
}


static gboolean __lambda4_ (RygelMain* self) {
	gboolean result = FALSE;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_exit (self, 0);
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = FALSE;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 238 "rygel-main.c"
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ (self);
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 247 "rygel-main.c"
}


static RygelMain* rygel_main_construct (GType object_type, GError** error) {
	RygelMain * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelLogHandler* _tmp1_ = NULL;
	RygelMetaConfig* _tmp2_ = NULL;
	RygelPluginLoader* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GMainLoop* _tmp6_;
	RygelPluginLoader* _tmp7_;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self = (RygelMain*) g_object_new (object_type, NULL);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = _ (PACKAGE_NAME);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_set_application_name (_tmp0_);
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = rygel_log_handler_get_default ();
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->log_handler);
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->log_handler = _tmp1_;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = rygel_meta_config_get_default ();
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->config);
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->config = (RygelConfiguration*) _tmp2_;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = rygel_plugin_loader_new ();
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->plugin_loader);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->plugin_loader = _tmp3_;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp4_ = gee_array_list_new (RYGEL_TYPE_ROOT_DEVICE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->root_devices);
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->root_devices = _tmp4_;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp5_ = gee_array_list_new (RYGEL_TYPE_ROOT_DEVICE_FACTORY, (GBoxedCopyFunc) rygel_root_device_factory_ref, rygel_root_device_factory_unref, NULL);
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->factories);
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->factories = _tmp5_;
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp6_ = g_main_loop_new (NULL, FALSE);
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->main_loop = _tmp6_;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->exit_code = 0;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp7_ = self->priv->plugin_loader;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_signal_connect_object (_tmp7_, "plugin-available", (GCallback) _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available, self, 0);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, SIGHUP, ___lambda2__gsource_func, g_object_ref (self), g_object_unref);
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, SIGINT, ___lambda3__gsource_func, g_object_ref (self), g_object_unref);
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, SIGTERM, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	gst_preset_set_app_dir (PRESET_DIR);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return self;
#line 319 "rygel-main.c"
}


static RygelMain* rygel_main_new (GError** error) {
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return rygel_main_construct (RYGEL_TYPE_MAIN, error);
#line 326 "rygel-main.c"
}


void rygel_main_exit (RygelMain* self, gint exit_code) {
	gint _tmp0_;
	GMainLoop* _tmp1_;
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = exit_code;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->exit_code = _tmp0_;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->root_devices);
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->root_devices = NULL;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = self->priv->main_loop;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_main_loop_quit (_tmp1_);
#line 347 "rygel-main.c"
}


void rygel_main_restart (RygelMain* self) {
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->need_restart = TRUE;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_exit (self, 0);
#line 358 "rygel-main.c"
}


static gint rygel_main_run (RygelMain* self) {
	gint result = 0;
	GMainLoop* _tmp0_;
	gint _tmp1_;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = self->priv->main_loop;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_main_loop_run (_tmp0_);
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = self->priv->exit_code;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = _tmp1_;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 378 "rygel-main.c"
}


static gboolean __lambda5_ (RygelMain* self) {
	gboolean result = FALSE;
	RygelPluginLoader* _tmp0_;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = self->priv->plugin_loader;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = rygel_plugin_loader_list_plugins (_tmp0_);
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = _tmp1_;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = gee_collection_get_size (_tmp2_);
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp4_ = _tmp3_;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp5_ = _tmp4_ == 0;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (_tmp2_);
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp5_) {
#line 406 "rygel-main.c"
		gint _tmp6_;
		const gchar* _tmp7_ = NULL;
		gint _tmp8_;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp6_ = rygel_main_PLUGIN_TIMEOUT;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp7_ = ngettext ("No plugins found in %d second; giving up..", "No plugins found in %d seconds; giving up..", (gulong) _tmp6_);
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp8_ = rygel_main_PLUGIN_TIMEOUT;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_warning (_tmp7_, _tmp8_);
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		rygel_main_exit (self, -82);
#line 420 "rygel-main.c"
	}
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = FALSE;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 426 "rygel-main.c"
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ (self);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 435 "rygel-main.c"
}


void rygel_main_dbus_available (RygelMain* self) {
	GUPnPContextManager* _tmp0_ = NULL;
	RygelPluginLoader* _tmp1_;
	gint _tmp2_;
	gint timeout;
	gint _tmp8_;
	GError * _inner_error_ = NULL;
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = rygel_main_create_context_manager (self);
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->context_manager);
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->context_manager = _tmp0_;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = self->priv->plugin_loader;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_plugin_loader_load_plugins (_tmp1_);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = rygel_main_PLUGIN_TIMEOUT;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	timeout = _tmp2_;
#line 462 "rygel-main.c"
	{
		RygelMetaConfig* _tmp3_ = NULL;
		RygelMetaConfig* config;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_ = 0;
		gint _tmp7_;
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp3_ = rygel_meta_config_get_default ();
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		config = _tmp3_;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp4_ = rygel_main_PLUGIN_TIMEOUT;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp5_ = G_MAXINT;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp6_ = rygel_configuration_get_int ((RygelConfiguration*) config, "plugin", "TIMEOUT", _tmp4_, _tmp5_, &_inner_error_);
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp7_ = _tmp6_;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_inner_error_ != NULL) {
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_object_unref0 (config);
#line 486 "rygel-main.c"
			goto __catch3_g_error;
		}
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		timeout = _tmp7_;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (config);
#line 493 "rygel-main.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_error_ = _inner_error_;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_inner_error_ = NULL;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_error_free0 (_error_);
#line 505 "rygel-main.c"
	}
	__finally3:
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_inner_error_ != NULL) {
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_clear_error (&_inner_error_);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return;
#line 516 "rygel-main.c"
	}
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp8_ = timeout;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp8_, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
#line 522 "rygel-main.c"
}


static void rygel_main_on_plugin_loaded (RygelMain* self, RygelPluginLoader* plugin_loader, RygelPlugin* plugin) {
	GeeArrayList* _tmp0_;
	GeeIterator* _tmp1_ = NULL;
	GeeIterator* iterator;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (plugin_loader != NULL);
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (plugin != NULL);
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = self->priv->factories;
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	iterator = _tmp1_;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	while (TRUE) {
#line 544 "rygel-main.c"
		GeeIterator* _tmp2_;
		gboolean _tmp3_ = FALSE;
		RygelPlugin* _tmp4_;
		GeeIterator* _tmp5_;
		gpointer _tmp6_ = NULL;
		RygelRootDeviceFactory* _tmp7_;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp2_ = iterator;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp3_ = gee_iterator_next (_tmp2_);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (!_tmp3_) {
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			break;
#line 559 "rygel-main.c"
		}
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp4_ = plugin;
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp5_ = iterator;
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp6_ = gee_iterator_get (_tmp5_);
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp7_ = (RygelRootDeviceFactory*) _tmp6_;
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		rygel_main_create_device (self, _tmp4_, _tmp7_, NULL, NULL);
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_rygel_root_device_factory_unref0 (_tmp7_);
#line 573 "rygel-main.c"
	}
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (iterator);
#line 577 "rygel-main.c"
}


static void _rygel_main_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self) {
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_on_context_available (self, _sender, p0);
#line 584 "rygel-main.c"
}


static void _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self) {
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_on_context_unavailable (self, _sender, p0);
#line 591 "rygel-main.c"
}


static GUPnPContextManager* rygel_main_create_context_manager (RygelMain* self) {
	GUPnPContextManager* result = NULL;
	gint port;
	gint _tmp3_;
	GUPnPContextManager* _tmp4_ = NULL;
	GUPnPContextManager* manager;
	GError * _inner_error_ = NULL;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	port = 0;
#line 606 "rygel-main.c"
	{
		RygelConfiguration* _tmp0_;
		gint _tmp1_ = 0;
		gint _tmp2_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp0_ = self->priv->config;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp1_ = rygel_configuration_get_port (_tmp0_, &_inner_error_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp2_ = _tmp1_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_inner_error_ != NULL) {
#line 619 "rygel-main.c"
			goto __catch4_g_error;
		}
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		port = _tmp2_;
#line 624 "rygel-main.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* err = NULL;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		err = _inner_error_;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_inner_error_ = NULL;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_error_free0 (err);
#line 636 "rygel-main.c"
	}
	__finally4:
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_inner_error_ != NULL) {
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_clear_error (&_inner_error_);
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return NULL;
#line 647 "rygel-main.c"
	}
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = port;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp4_ = gupnp_context_manager_create ((guint) _tmp3_);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	manager = _tmp4_;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_signal_connect_object (manager, "context-available", (GCallback) _rygel_main_on_context_available_gupnp_context_manager_context_available, self, 0);
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_signal_connect_object (manager, "context-unavailable", (GCallback) _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable, self, 0);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = manager;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 663 "rygel-main.c"
}


static void rygel_main_on_context_available (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context) {
	gchar* iface;
	GUPnPContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GUPnPContext* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GUPnPContext* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	gboolean _tmp19_;
	gboolean _tmp24_;
	GError * _inner_error_ = NULL;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (manager != NULL);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (context != NULL);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	iface = NULL;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = context;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = gssdp_client_get_network ((GSSDPClient*) _tmp0_);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = _tmp1_;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = context;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp4_ = gssdp_client_get_interface ((GSSDPClient*) _tmp3_);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp5_ = _tmp4_;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp6_ = context;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp7_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp6_);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp8_ = _tmp7_;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_debug ("rygel-main.vala:145: New network %s (%s) context available. IP: %s", _tmp2_, _tmp5_, _tmp8_);
#line 712 "rygel-main.c"
	{
		RygelConfiguration* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp9_ = self->priv->config;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp10_ = rygel_configuration_get_interface (_tmp9_, &_inner_error_);
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp11_ = _tmp10_;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_inner_error_ != NULL) {
#line 725 "rygel-main.c"
			goto __catch5_g_error;
		}
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_free0 (iface);
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		iface = _tmp11_;
#line 732 "rygel-main.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* err = NULL;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		err = _inner_error_;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_inner_error_ = NULL;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_error_free0 (err);
#line 744 "rygel-main.c"
	}
	__finally5:
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_inner_error_ != NULL) {
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_free0 (iface);
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_clear_error (&_inner_error_);
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return;
#line 757 "rygel-main.c"
	}
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp14_ = iface;
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp14_ == NULL) {
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp13_ = TRUE;
#line 765 "rygel-main.c"
	} else {
		const gchar* _tmp15_;
		GUPnPContext* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp15_ = iface;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp16_ = context;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp17_ = gssdp_client_get_interface ((GSSDPClient*) _tmp16_);
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp18_ = _tmp17_;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp13_ = g_strcmp0 (_tmp15_, _tmp18_) == 0;
#line 781 "rygel-main.c"
	}
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp19_ = _tmp13_;
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp19_) {
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp12_ = TRUE;
#line 789 "rygel-main.c"
	} else {
		const gchar* _tmp20_;
		GUPnPContext* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp20_ = iface;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp21_ = context;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp22_ = gssdp_client_get_network ((GSSDPClient*) _tmp21_);
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp23_ = _tmp22_;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp12_ = g_strcmp0 (_tmp20_, _tmp23_) == 0;
#line 805 "rygel-main.c"
	}
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp24_ = _tmp12_;
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp24_) {
#line 811 "rygel-main.c"
		{
			GUPnPContext* _tmp25_;
			RygelRootDeviceFactory* _tmp26_;
			RygelRootDeviceFactory* factory;
			GeeArrayList* _tmp27_;
			RygelRootDeviceFactory* _tmp28_;
			RygelPluginLoader* _tmp29_;
			GeeCollection* _tmp30_ = NULL;
			GeeCollection* _tmp31_;
			GeeIterator* _tmp32_ = NULL;
			GeeIterator* _tmp33_;
			GeeIterator* iterator;
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp25_ = context;
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp26_ = rygel_root_device_factory_new (_tmp25_, &_inner_error_);
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			factory = _tmp26_;
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (_inner_error_ != NULL) {
#line 832 "rygel-main.c"
				goto __catch6_g_error;
			}
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp27_ = self->priv->factories;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp28_ = factory;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp29_ = self->priv->plugin_loader;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp30_ = rygel_plugin_loader_list_plugins (_tmp29_);
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp31_ = _tmp30_;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp32_ = gee_iterable_iterator ((GeeIterable*) _tmp31_);
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp33_ = _tmp32_;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_object_unref0 (_tmp31_);
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			iterator = _tmp33_;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			while (TRUE) {
#line 857 "rygel-main.c"
				GeeIterator* _tmp34_;
				gboolean _tmp35_ = FALSE;
				GeeIterator* _tmp36_;
				gpointer _tmp37_ = NULL;
				RygelPlugin* _tmp38_;
				RygelRootDeviceFactory* _tmp39_;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp34_ = iterator;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp35_ = gee_iterator_next (_tmp34_);
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				if (!_tmp35_) {
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
					break;
#line 872 "rygel-main.c"
				}
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp36_ = iterator;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp37_ = gee_iterator_get (_tmp36_);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp38_ = (RygelPlugin*) _tmp37_;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp39_ = factory;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				rygel_main_create_device (self, _tmp38_, _tmp39_, NULL, NULL);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_g_object_unref0 (_tmp38_);
#line 886 "rygel-main.c"
			}
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_object_unref0 (iterator);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_rygel_root_device_factory_unref0 (factory);
#line 892 "rygel-main.c"
		}
		goto __finally6;
		__catch6_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp40_ = NULL;
			GError* _tmp41_;
			const gchar* _tmp42_;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			err = _inner_error_;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_inner_error_ = NULL;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp40_ = _ ("Failed to create root device factory: %s");
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp41_ = err;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp42_ = _tmp41_->message;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			g_warning (_tmp40_, _tmp42_);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_error_free0 (err);
#line 915 "rygel-main.c"
		}
		__finally6:
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_inner_error_ != NULL) {
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_free0 (iface);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			g_clear_error (&_inner_error_);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			return;
#line 928 "rygel-main.c"
		}
	} else {
		GUPnPContext* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		GUPnPContext* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp43_ = context;
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp44_ = gssdp_client_get_network ((GSSDPClient*) _tmp43_);
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp45_ = _tmp44_;
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp46_ = context;
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp47_ = gssdp_client_get_interface ((GSSDPClient*) _tmp46_);
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp48_ = _tmp47_;
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_debug ("rygel-main.vala:170: Ignoring network %s (%s) context.", _tmp45_, _tmp48_);
#line 951 "rygel-main.c"
	}
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_free0 (iface);
#line 955 "rygel-main.c"
}


static void rygel_main_on_context_unavailable (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context) {
	GUPnPContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GUPnPContext* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GUPnPContext* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeIterator* _tmp10_ = NULL;
	GeeIterator* factory_iter;
	GeeArrayList* _tmp20_;
	GeeIterator* _tmp21_ = NULL;
	GeeIterator* device_iter;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (manager != NULL);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (context != NULL);
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = context;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = gssdp_client_get_network ((GSSDPClient*) _tmp0_);
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = _tmp1_;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = context;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp4_ = gssdp_client_get_interface ((GSSDPClient*) _tmp3_);
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp5_ = _tmp4_;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp6_ = context;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp7_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp6_);
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp8_ = _tmp7_;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_debug ("rygel-main.vala:178: Network %s (%s) context now unavailable. IP: %s", _tmp2_, _tmp5_, _tmp8_);
#line 183 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp9_ = self->priv->factories;
#line 183 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp10_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp9_);
#line 183 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	factory_iter = _tmp10_;
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	while (TRUE) {
#line 1009 "rygel-main.c"
		GeeIterator* _tmp11_;
		gboolean _tmp12_ = FALSE;
		GUPnPContext* _tmp13_;
		GeeIterator* _tmp14_;
		gpointer _tmp15_ = NULL;
		RygelRootDeviceFactory* _tmp16_;
		GUPnPContext* _tmp17_;
		gboolean _tmp18_;
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp11_ = factory_iter;
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp12_ = gee_iterator_next (_tmp11_);
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (!_tmp12_) {
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			break;
#line 1026 "rygel-main.c"
		}
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp13_ = context;
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp14_ = factory_iter;
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp15_ = gee_iterator_get (_tmp14_);
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp16_ = (RygelRootDeviceFactory*) _tmp15_;
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp17_ = _tmp16_->context;
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp18_ = _tmp13_ == _tmp17_;
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_rygel_root_device_factory_unref0 (_tmp16_);
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_tmp18_) {
#line 1044 "rygel-main.c"
			GeeIterator* _tmp19_;
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp19_ = factory_iter;
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			gee_iterator_remove (_tmp19_);
#line 1050 "rygel-main.c"
		}
	}
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp20_ = self->priv->root_devices;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp21_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp20_);
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	device_iter = _tmp21_;
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	while (TRUE) {
#line 1061 "rygel-main.c"
		GeeIterator* _tmp22_;
		gboolean _tmp23_ = FALSE;
		GUPnPContext* _tmp24_;
		GeeIterator* _tmp25_;
		gpointer _tmp26_ = NULL;
		RygelRootDevice* _tmp27_;
		GUPnPContext* _tmp28_;
		GUPnPContext* _tmp29_;
		gboolean _tmp30_;
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp22_ = device_iter;
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp23_ = gee_iterator_next (_tmp22_);
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (!_tmp23_) {
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			break;
#line 1079 "rygel-main.c"
		}
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp24_ = context;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp25_ = device_iter;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp26_ = gee_iterator_get (_tmp25_);
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp27_ = (RygelRootDevice*) _tmp26_;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp28_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp27_);
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp29_ = _tmp28_;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp30_ = _tmp24_ == _tmp29_;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (_tmp27_);
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_tmp30_) {
#line 1099 "rygel-main.c"
			GeeIterator* _tmp31_;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp31_ = device_iter;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			gee_iterator_remove (_tmp31_);
#line 1105 "rygel-main.c"
		}
	}
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (device_iter);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (factory_iter);
#line 1112 "rygel-main.c"
}


static void rygel_main_create_device_data_free (gpointer _data) {
	RygelMainCreateDeviceData* _data_;
	_data_ = _data;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (_data_->plugin);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_rygel_root_device_factory_unref0 (_data_->factory);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (_data_->self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_slice_free (RygelMainCreateDeviceData, _data_);
#line 1127 "rygel-main.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return self ? g_object_ref (self) : NULL;
#line 1134 "rygel-main.c"
}


static gpointer _rygel_root_device_factory_ref0 (gpointer self) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return self ? rygel_root_device_factory_ref (self) : NULL;
#line 1141 "rygel-main.c"
}


static void rygel_main_create_device (RygelMain* self, RygelPlugin* plugin, RygelRootDeviceFactory* factory, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMainCreateDeviceData* _data_;
	RygelMain* _tmp0_;
	RygelPlugin* _tmp1_;
	RygelPlugin* _tmp2_;
	RygelRootDeviceFactory* _tmp3_;
	RygelRootDeviceFactory* _tmp4_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_ = g_slice_new0 (RygelMainCreateDeviceData);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_main_create_device);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_main_create_device_data_free);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_->self = _tmp0_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = plugin;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_->plugin = _tmp2_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = factory;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp4_ = _rygel_root_device_factory_ref0 (_tmp3_);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_->factory = _tmp4_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_create_device_co (_data_);
#line 1176 "rygel-main.c"
}


static void rygel_main_create_device_finish (RygelMain* self, GAsyncResult* _res_) {
	RygelMainCreateDeviceData* _data_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1184 "rygel-main.c"
}


static gboolean _rygel_main_create_device_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_main_create_device_co (self);
#line 206 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 1193 "rygel-main.c"
}


static void _rygel_main_on_plugin_active_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_on_plugin_active_notify (self, _sender, pspec);
#line 1200 "rygel-main.c"
}


static gboolean rygel_main_create_device_co (RygelMainCreateDeviceData* _data_) {
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	switch (_data_->_state_) {
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		case 0:
#line 1209 "rygel-main.c"
		goto _state_0;
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		case 1:
#line 1213 "rygel-main.c"
		goto _state_1;
		default:
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_assert_not_reached ();
#line 1218 "rygel-main.c"
	}
	_state_0:
#line 206 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_main_create_device_co_gsource_func, _data_, NULL);
#line 207 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_->_state_ = 1;
#line 207 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return FALSE;
#line 1227 "rygel-main.c"
	_state_1:
	;
	{
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp0_ = _data_->factory;
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp1_ = _data_->plugin;
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp2_ = NULL;
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp2_ = rygel_root_device_factory_create (_data_->_tmp0_, _data_->_tmp1_, &_data_->_inner_error_);
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->device = _data_->_tmp2_;
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1243 "rygel-main.c"
			goto __catch7_g_error;
		}
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp4_ = _data_->plugin;
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp5_ = rygel_plugin_get_active (_data_->_tmp4_);
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_data_->_tmp6_) {
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp7_ = _data_->self->priv->config;
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp8_ = FALSE;
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp8_ = rygel_configuration_get_upnp_enabled (_data_->_tmp7_, &_data_->_inner_error_);
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp9_ = _data_->_tmp8_;
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (_data_->_inner_error_ != NULL) {
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_g_object_unref0 (_data_->device);
#line 1266 "rygel-main.c"
				goto __catch7_g_error;
			}
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp3_ = _data_->_tmp9_;
#line 1271 "rygel-main.c"
		} else {
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp3_ = FALSE;
#line 1275 "rygel-main.c"
		}
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp10_ = _data_->device;
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp11_ = _data_->_tmp3_;
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		gupnp_root_device_set_available ((GUPnPRootDevice*) _data_->_tmp10_, _data_->_tmp11_);
#line 218 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp12_ = _data_->self->priv->root_devices;
#line 218 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_data_->_tmp12_ != NULL) {
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp13_ = _data_->self->priv->root_devices;
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp14_ = _data_->device;
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp13_, _data_->_tmp14_);
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp15_ = _data_->plugin;
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			g_signal_connect_object ((GObject*) _data_->_tmp15_, "notify::active", (GCallback) _rygel_main_on_plugin_active_notify_g_object_notify, _data_->self, 0);
#line 1297 "rygel-main.c"
		}
#line 209 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (_data_->device);
#line 1301 "rygel-main.c"
	}
	goto __finally7;
	__catch7_g_error:
	{
#line 209 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 209 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_inner_error_ = NULL;
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp16_ = NULL;
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp16_ = _ ("Failed to create RootDevice for %s. Reason: %s");
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp17_ = _data_->plugin;
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp18_ = _data_->_tmp17_->name;
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp19_ = _data_->_error_;
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp20_ = _data_->_tmp19_->message;
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_warning (_data_->_tmp16_, _data_->_tmp18_, _data_->_tmp20_);
#line 209 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_error_free0 (_data_->_error_);
#line 1326 "rygel-main.c"
	}
	__finally7:
#line 209 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_data_->_inner_error_ != NULL) {
#line 209 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 209 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_clear_error (&_data_->_inner_error_);
#line 209 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return FALSE;
#line 1337 "rygel-main.c"
	}
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_data_->_state_ == 0) {
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1343 "rygel-main.c"
	} else {
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1347 "rygel-main.c"
	}
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_object_unref (_data_->_async_result);
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return FALSE;
#line 1353 "rygel-main.c"
}


static void rygel_main_on_plugin_active_notify (RygelMain* self, GObject* obj, GParamSpec* spec) {
	GeeArrayList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GObject* _tmp2_;
	RygelPlugin* _tmp3_;
	RygelPlugin* plugin;
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (obj != NULL);
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (spec != NULL);
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = self->priv->root_devices;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = G_UNLIKELY (_tmp0_ == NULL);
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp1_) {
#line 233 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return;
#line 1377 "rygel-main.c"
	}
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = obj;
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_PLUGIN) ? ((RygelPlugin*) _tmp2_) : NULL);
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	plugin = _tmp3_;
#line 1385 "rygel-main.c"
	{
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		GeeArrayList* _device_list;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _device_size;
		gint _device_index;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp4_ = self->priv->root_devices;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_device_list = _tmp5_;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp6_ = _device_list;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp8_ = _tmp7_;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_device_size = _tmp8_;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_device_index = -1;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		while (TRUE) {
#line 1413 "rygel-main.c"
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GeeArrayList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_ = NULL;
			RygelRootDevice* device;
			RygelRootDevice* _tmp15_;
			GUPnPResourceFactory* _tmp16_;
			GUPnPResourceFactory* _tmp17_;
			RygelPlugin* _tmp18_;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp9_ = _device_index;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_device_index = _tmp9_ + 1;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp10_ = _device_index;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp11_ = _device_size;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				break;
#line 1437 "rygel-main.c"
			}
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp12_ = _device_list;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp13_ = _device_index;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			device = (RygelRootDevice*) _tmp14_;
#line 239 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp15_ = device;
#line 239 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp16_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp15_);
#line 239 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp17_ = _tmp16_;
#line 239 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp18_ = plugin;
#line 239 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (_tmp17_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GUPNP_TYPE_RESOURCE_FACTORY, GUPnPResourceFactory)) {
#line 1457 "rygel-main.c"
				RygelRootDevice* _tmp19_;
				RygelPlugin* _tmp20_;
				gboolean _tmp21_;
				gboolean _tmp22_;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp19_ = device;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp20_ = plugin;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp21_ = rygel_plugin_get_active (_tmp20_);
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp22_ = _tmp21_;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				gupnp_root_device_set_available ((GUPnPRootDevice*) _tmp19_, _tmp22_);
#line 1472 "rygel-main.c"
			}
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_object_unref0 (device);
#line 1476 "rygel-main.c"
		}
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (_device_list);
#line 1480 "rygel-main.c"
	}
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (plugin);
#line 1484 "rygel-main.c"
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = g_new0 (gchar*, length + 1);
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	for (i = 0; i < length; i++) {
#line 1495 "rygel-main.c"
		gchar* _tmp0_;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp0_ = g_strdup (self[i]);
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		result[i] = _tmp0_;
#line 1501 "rygel-main.c"
	}
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 1505 "rygel-main.c"
}


static gint rygel_main_main (gchar** args, int args_length1) {
	gint result = 0;
	RygelMain* main;
	RygelDBusService* service;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** original_args;
	gint original_args_length1;
	gint _original_args_size_;
	RygelMain* _tmp8_;
	gint _tmp9_ = 0;
	gint exit_code;
	RygelDBusService* _tmp10_;
	RygelMain* _tmp12_;
	gboolean _tmp13_;
	GError * _inner_error_ = NULL;
#line 246 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	main = NULL;
#line 247 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	service = NULL;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = args;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0__length1 = args_length1;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1__length1 = _tmp0__length1;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	original_args = _tmp1_;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	original_args_length1 = _tmp1__length1;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_original_args_size_ = original_args_length1;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	setlocale (LC_ALL, "");
#line 252 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 254 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	textdomain (GETTEXT_PACKAGE);
#line 1553 "rygel-main.c"
	{
		RygelMain* _tmp2_;
		RygelMain* _tmp3_;
		RygelMain* _tmp4_;
		RygelDBusService* _tmp5_;
		RygelDBusService* _tmp6_;
#line 259 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		rygel_cmdline_config_parse_args (&args, &args_length1, &_inner_error_);
#line 259 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_inner_error_ != NULL) {
#line 259 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
#line 1566 "rygel-main.c"
				goto __catch8_rygel_cmdline_config_error_version_only;
			}
			goto __catch8_g_error;
		}
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		rygel_meta_config_register_default_configurations ();
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp2_ = rygel_main_new (&_inner_error_);
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp3_ = _tmp2_;
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_inner_error_ != NULL) {
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
#line 1581 "rygel-main.c"
				goto __catch8_rygel_cmdline_config_error_version_only;
			}
			goto __catch8_g_error;
		}
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (main);
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		main = _tmp3_;
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp4_ = main;
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp5_ = rygel_dbus_service_new (_tmp4_);
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (service);
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		service = _tmp5_;
#line 264 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp6_ = service;
#line 264 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		rygel_dbus_service_publish (_tmp6_);
#line 1602 "rygel-main.c"
	}
	goto __finally8;
	__catch8_rygel_cmdline_config_error_version_only:
	{
		GError* err = NULL;
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		err = _inner_error_;
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_inner_error_ = NULL;
#line 266 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		result = 0;
#line 266 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_error_free0 (err);
#line 266 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
#line 266 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (service);
#line 266 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (main);
#line 266 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return result;
#line 1624 "rygel-main.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp7_;
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		err = _inner_error_;
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_inner_error_ = NULL;
#line 268 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp7_ = err->message;
#line 268 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_error ("rygel-main.vala:268: %s", _tmp7_);
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_error_free0 (err);
#line 1641 "rygel-main.c"
	}
	__finally8:
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_inner_error_ != NULL) {
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (service);
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (main);
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_clear_error (&_inner_error_);
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return 0;
#line 1658 "rygel-main.c"
	}
#line 271 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp8_ = main;
#line 271 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp9_ = rygel_main_run (_tmp8_);
#line 271 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	exit_code = _tmp9_;
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp10_ = service;
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp10_ != NULL) {
#line 1670 "rygel-main.c"
		RygelDBusService* _tmp11_;
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp11_ = service;
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		rygel_dbus_service_unpublish (_tmp11_);
#line 1676 "rygel-main.c"
	}
#line 276 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp12_ = main;
#line 276 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp13_ = _tmp12_->need_restart;
#line 276 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp13_) {
#line 1684 "rygel-main.c"
		gchar** _tmp14_;
		gint _tmp14__length1;
		const gchar* _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp14_ = original_args;
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp14__length1 = original_args_length1;
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp15_ = _tmp14_[0];
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp16_ = original_args;
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp16__length1 = original_args_length1;
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		execvp (_tmp15_, _tmp16_);
#line 1702 "rygel-main.c"
	}
#line 280 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = exit_code;
#line 280 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
#line 280 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (service);
#line 280 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (main);
#line 280 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 1714 "rygel-main.c"
}


int main (int argc, char ** argv) {
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_type_init ();
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return rygel_main_main (argv, argc);
#line 1723 "rygel-main.c"
}


static void rygel_main_class_init (RygelMainClass * klass) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_parent_class = g_type_class_peek_parent (klass);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_type_class_add_private (klass, sizeof (RygelMainPrivate));
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_main_finalize;
#line 1734 "rygel-main.c"
}


static void rygel_main_instance_init (RygelMain * self) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv = RYGEL_MAIN_GET_PRIVATE (self);
#line 1741 "rygel-main.c"
}


static void rygel_main_finalize (GObject* obj) {
	RygelMain * self;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MAIN, RygelMain);
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->plugin_loader);
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->context_manager);
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->factories);
#line 39 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->root_devices);
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->config);
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->log_handler);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	G_OBJECT_CLASS (rygel_main_parent_class)->finalize (obj);
#line 1765 "rygel-main.c"
}


GType rygel_main_get_type (void) {
	static volatile gsize rygel_main_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_main_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMain), 0, (GInstanceInitFunc) rygel_main_instance_init, NULL };
		GType rygel_main_type_id;
		rygel_main_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMain", &g_define_type_info, 0);
		g_once_init_leave (&rygel_main_type_id__volatile, rygel_main_type_id);
	}
	return rygel_main_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



