/* iso-extractor.c generated by valac 0.17.5.2-8558, the Vala compiler
 * generated from iso-extractor.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/
/* Helper class to extract files from an ISO image*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libcommon.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <errno.h>


#define BOXES_TYPE_ISO_EXTRACTOR (boxes_iso_extractor_get_type ())
#define BOXES_ISO_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_ISO_EXTRACTOR, BoxesISOExtractor))
#define BOXES_ISO_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_ISO_EXTRACTOR, BoxesISOExtractorClass))
#define BOXES_IS_ISO_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_ISO_EXTRACTOR))
#define BOXES_IS_ISO_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_ISO_EXTRACTOR))
#define BOXES_ISO_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_ISO_EXTRACTOR, BoxesISOExtractorClass))

typedef struct _BoxesISOExtractor BoxesISOExtractor;
typedef struct _BoxesISOExtractorClass BoxesISOExtractorClass;
typedef struct _BoxesISOExtractorPrivate BoxesISOExtractorPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BoxesIsoExtractorMountMediaData BoxesIsoExtractorMountMediaData;
typedef struct _BoxesIsoExtractorEnumerateChildrenData BoxesIsoExtractorEnumerateChildrenData;

struct _BoxesISOExtractor {
	GObject parent_instance;
	BoxesISOExtractorPrivate * priv;
};

struct _BoxesISOExtractorClass {
	GObjectClass parent_class;
};

struct _BoxesISOExtractorPrivate {
	gchar* device_file;
	gchar* mount_point;
	gboolean mounted;
};

struct _BoxesIsoExtractorMountMediaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesISOExtractor* self;
	GCancellable* cancellable;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* iso_name;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* temp_name;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* mount_point;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar** _tmp29_;
	gchar** argv;
	gint argv_length1;
	gint _argv_size_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	GCancellable* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	GError * _inner_error_;
};

struct _BoxesIsoExtractorEnumerateChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesISOExtractor* self;
	gchar* rel_path;
	GCancellable* cancellable;
	GFileEnumerator* result;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* abs_src_path;
	GFile* _tmp4_;
	GFile* dir;
	GCancellable* _tmp5_;
	GFileEnumerator* _tmp6_;
	GFileEnumerator* _tmp7_;
	GError * _inner_error_;
};


static gpointer boxes_iso_extractor_parent_class = NULL;

GType boxes_iso_extractor_get_type (void) G_GNUC_CONST;
#define BOXES_ISO_EXTRACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_ISO_EXTRACTOR, BoxesISOExtractorPrivate))
enum  {
	BOXES_ISO_EXTRACTOR_DUMMY_PROPERTY
};
BoxesISOExtractor* boxes_iso_extractor_new (const gchar* iso_path);
BoxesISOExtractor* boxes_iso_extractor_construct (GType object_type, const gchar* iso_path);
static void boxes_iso_extractor_mount_media_data_free (gpointer _data);
void boxes_iso_extractor_mount_media (BoxesISOExtractor* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void boxes_iso_extractor_mount_media_finish (BoxesISOExtractor* self, GAsyncResult* _res_, GError** error);
static gboolean boxes_iso_extractor_mount_media_co (BoxesIsoExtractorMountMediaData* _data_);
static void boxes_iso_extractor_mount_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void boxes_iso_extractor_enumerate_children_data_free (gpointer _data);
void boxes_iso_extractor_enumerate_children (BoxesISOExtractor* self, const gchar* rel_path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFileEnumerator* boxes_iso_extractor_enumerate_children_finish (BoxesISOExtractor* self, GAsyncResult* _res_, GError** error);
static gboolean boxes_iso_extractor_enumerate_children_co (BoxesIsoExtractorEnumerateChildrenData* _data_);
static void boxes_iso_extractor_enumerate_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* boxes_iso_extractor_get_absolute_path (BoxesISOExtractor* self, const gchar* relative_path, GError** error);
static void boxes_iso_extractor_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


BoxesISOExtractor* boxes_iso_extractor_construct (GType object_type, const gchar* iso_path) {
	BoxesISOExtractor * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (iso_path != NULL, NULL);
	self = (BoxesISOExtractor*) g_object_new (object_type, NULL);
	_tmp0_ = iso_path;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->device_file);
	self->priv->device_file = _tmp1_;
	return self;
}


BoxesISOExtractor* boxes_iso_extractor_new (const gchar* iso_path) {
	return boxes_iso_extractor_construct (BOXES_TYPE_ISO_EXTRACTOR, iso_path);
}


static void boxes_iso_extractor_mount_media_data_free (gpointer _data) {
	BoxesIsoExtractorMountMediaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesIsoExtractorMountMediaData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void boxes_iso_extractor_mount_media (BoxesISOExtractor* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesIsoExtractorMountMediaData* _data_;
	BoxesISOExtractor* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (BoxesIsoExtractorMountMediaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, boxes_iso_extractor_mount_media);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_iso_extractor_mount_media_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->cancellable = _tmp2_;
	boxes_iso_extractor_mount_media_co (_data_);
}


void boxes_iso_extractor_mount_media_finish (BoxesISOExtractor* self, GAsyncResult* _res_, GError** error) {
	BoxesIsoExtractorMountMediaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void boxes_iso_extractor_mount_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesIsoExtractorMountMediaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_iso_extractor_mount_media_co (_data_);
}


static gboolean boxes_iso_extractor_mount_media_co (BoxesIsoExtractorMountMediaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->mounted;
	if (_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->device_file;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_file_new_for_path (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_file_get_basename (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp3_);
	_data_->iso_name = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->iso_name;
	_data_->_tmp7_ = g_strconcat (_data_->_tmp6_, "-XXXXXX", NULL);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = boxes_get_user_pkgcache (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_g_free0 (_data_->_tmp8_);
	_data_->temp_name = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->temp_name;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = mkdtemp (_data_->_tmp11_);
	_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
	_data_->mount_point = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->mount_point;
	if (_data_->_tmp14_ == NULL) {
		_data_->_tmp15_ = errno;
		_data_->_tmp16_ = 0;
		_data_->_tmp16_ = g_io_error_from_errno (_data_->_tmp15_);
		_data_->_tmp17_ = _data_->temp_name;
		_data_->_tmp18_ = g_error_new ((GQuark) G_IO_ERROR, _data_->_tmp16_, "Failed to create temporary mountpoint %s", _data_->_tmp17_);
		_data_->_inner_error_ = (GError*) _data_->_tmp18_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_free0 (_data_->mount_point);
		_g_free0 (_data_->temp_name);
		_g_free0 (_data_->iso_name);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = _data_->mount_point;
	_data_->_tmp20_ = g_strdup (_data_->_tmp19_);
	_g_free0 (_data_->self->priv->mount_point);
	_data_->self->priv->mount_point = _data_->_tmp20_;
	_data_->_tmp21_ = _data_->self->priv->device_file;
	_data_->_tmp22_ = _data_->mount_point;
	g_debug ("iso-extractor.vala:35: Mounting '%s' on '%s'..", _data_->_tmp21_, _data_->_tmp22_);
	_data_->_tmp23_ = g_strdup ("fuseiso");
	_data_->_tmp24_ = g_strdup ("-p");
	_data_->_tmp25_ = _data_->self->priv->device_file;
	_data_->_tmp26_ = g_strdup (_data_->_tmp25_);
	_data_->_tmp27_ = _data_->mount_point;
	_data_->_tmp28_ = g_strdup (_data_->_tmp27_);
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = g_new0 (gchar*, 4 + 1);
	_data_->_tmp29_[0] = _data_->_tmp23_;
	_data_->_tmp29_[1] = _data_->_tmp24_;
	_data_->_tmp29_[2] = _data_->_tmp26_;
	_data_->_tmp29_[3] = _data_->_tmp28_;
	_data_->argv = _data_->_tmp29_;
	_data_->argv_length1 = 4;
	_data_->_argv_size_ = _data_->argv_length1;
	_data_->_tmp30_ = _data_->argv;
	_data_->_tmp30__length1 = _data_->argv_length1;
	_data_->_tmp31_ = _data_->cancellable;
	_data_->_state_ = 1;
	boxes_exec (_data_->_tmp30_, _data_->_tmp30__length1, _data_->_tmp31_, boxes_iso_extractor_mount_media_ready, _data_);
	return FALSE;
	_state_1:
	boxes_exec_finish (_data_->_res_, NULL, NULL, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->mount_point);
		_g_free0 (_data_->temp_name);
		_g_free0 (_data_->iso_name);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp32_ = _data_->self->priv->device_file;
	_data_->_tmp33_ = _data_->mount_point;
	g_debug ("iso-extractor.vala:39: '%s' now mounted on '%s'.", _data_->_tmp32_, _data_->_tmp33_);
	_data_->self->priv->mounted = TRUE;
	_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_data_->mount_point);
	_g_free0 (_data_->temp_name);
	_g_free0 (_data_->iso_name);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void boxes_iso_extractor_enumerate_children_data_free (gpointer _data) {
	BoxesIsoExtractorEnumerateChildrenData* _data_;
	_data_ = _data;
	_g_free0 (_data_->rel_path);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesIsoExtractorEnumerateChildrenData, _data_);
}


void boxes_iso_extractor_enumerate_children (BoxesISOExtractor* self, const gchar* rel_path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesIsoExtractorEnumerateChildrenData* _data_;
	BoxesISOExtractor* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (BoxesIsoExtractorEnumerateChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, boxes_iso_extractor_enumerate_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_iso_extractor_enumerate_children_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = rel_path;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->rel_path = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->cancellable = _tmp4_;
	boxes_iso_extractor_enumerate_children_co (_data_);
}


GFileEnumerator* boxes_iso_extractor_enumerate_children_finish (BoxesISOExtractor* self, GAsyncResult* _res_, GError** error) {
	GFileEnumerator* result;
	BoxesIsoExtractorEnumerateChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void boxes_iso_extractor_enumerate_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesIsoExtractorEnumerateChildrenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_iso_extractor_enumerate_children_co (_data_);
}


static gboolean boxes_iso_extractor_enumerate_children_co (BoxesIsoExtractorEnumerateChildrenData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->mounted;
	g_return_val_if_fail (_data_->_tmp0_, FALSE);
	_data_->_tmp1_ = _data_->self->priv->mount_point;
	_data_->_tmp2_ = _data_->rel_path;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = g_build_filename (_data_->_tmp1_, _data_->_tmp2_, NULL);
	_data_->abs_src_path = _data_->_tmp3_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_file_new_for_path (_data_->abs_src_path);
	_data_->dir = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->cancellable;
	_data_->_state_ = 1;
	g_file_enumerate_children_async (_data_->dir, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, G_PRIORITY_DEFAULT, _data_->_tmp5_, boxes_iso_extractor_enumerate_children_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_file_enumerate_children_finish (_data_->dir, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp7_ = _data_->_tmp6_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->dir);
		_g_free0 (_data_->abs_src_path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_tmp7_;
	_g_object_unref0 (_data_->dir);
	_g_free0 (_data_->abs_src_path);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->dir);
	_g_free0 (_data_->abs_src_path);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


gchar* boxes_iso_extractor_get_absolute_path (BoxesISOExtractor* self, const gchar* relative_path, GError** error) {
	gchar* result = NULL;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (relative_path != NULL, NULL);
	_tmp0_ = self->priv->mounted;
	g_return_val_if_fail (_tmp0_, NULL);
	_tmp1_ = self->priv->mount_point;
	_tmp2_ = relative_path;
	_tmp3_ = g_build_filename (_tmp1_, _tmp2_, NULL);
	result = _tmp3_;
	return result;
}


static void boxes_iso_extractor_class_init (BoxesISOExtractorClass * klass) {
	boxes_iso_extractor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BoxesISOExtractorPrivate));
	G_OBJECT_CLASS (klass)->finalize = boxes_iso_extractor_finalize;
}


static void boxes_iso_extractor_instance_init (BoxesISOExtractor * self) {
	self->priv = BOXES_ISO_EXTRACTOR_GET_PRIVATE (self);
}


static void boxes_iso_extractor_finalize (GObject* obj) {
	BoxesISOExtractor * self;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** argv;
	gint argv_length1;
	gint _argv_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_ISO_EXTRACTOR, BoxesISOExtractor);
	_tmp0_ = self->priv->mounted;
	if (!_tmp0_) {
		goto _return;
	}
	_tmp1_ = self->priv->mount_point;
	g_debug ("iso-extractor.vala:17: Unmounting '%s'..", _tmp1_);
	_tmp2_ = g_strdup ("fusermount");
	_tmp3_ = g_strdup ("-u");
	_tmp4_ = self->priv->mount_point;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = g_new0 (gchar*, 3 + 1);
	_tmp6_[0] = _tmp2_;
	_tmp6_[1] = _tmp3_;
	_tmp6_[2] = _tmp5_;
	argv = _tmp6_;
	argv_length1 = 3;
	_argv_size_ = argv_length1;
	_tmp7_ = argv;
	_tmp7__length1 = argv_length1;
	boxes_exec (_tmp7_, _tmp7__length1, NULL, NULL, NULL);
	_tmp8_ = self->priv->mount_point;
	g_debug ("iso-extractor.vala:20: Unmounted '%s'.", _tmp8_);
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	_return:
	_g_free0 (self->priv->device_file);
	_g_free0 (self->priv->mount_point);
	G_OBJECT_CLASS (boxes_iso_extractor_parent_class)->finalize (obj);
}


GType boxes_iso_extractor_get_type (void) {
	static volatile gsize boxes_iso_extractor_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_iso_extractor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesISOExtractorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_iso_extractor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesISOExtractor), 0, (GInstanceInitFunc) boxes_iso_extractor_instance_init, NULL };
		GType boxes_iso_extractor_type_id;
		boxes_iso_extractor_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesISOExtractor", &g_define_type_info, 0);
		g_once_init_leave (&boxes_iso_extractor_type_id__volatile, boxes_iso_extractor_type_id);
	}
	return boxes_iso_extractor_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



