/* rygel-thumbnailer.c generated by valac 0.15.1.36-84b2b, the Vala compiler
 * generated from rygel-thumbnailer.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_THUMBNAILER (rygel_thumbnailer_get_type ())
#define RYGEL_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailer))
#define RYGEL_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))
#define RYGEL_IS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_IS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))

typedef struct _RygelThumbnailer RygelThumbnailer;
typedef struct _RygelThumbnailerClass RygelThumbnailerClass;
typedef struct _RygelThumbnailerPrivate RygelThumbnailerPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_DBUS_THUMBNAILER (rygel_dbus_thumbnailer_get_type ())
#define RYGEL_DBUS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DBUS_THUMBNAILER, RygelDbusThumbnailer))
#define RYGEL_DBUS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DBUS_THUMBNAILER, RygelDbusThumbnailerClass))
#define RYGEL_IS_DBUS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DBUS_THUMBNAILER))
#define RYGEL_IS_DBUS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DBUS_THUMBNAILER))
#define RYGEL_DBUS_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DBUS_THUMBNAILER, RygelDbusThumbnailerClass))

typedef struct _RygelDbusThumbnailer RygelDbusThumbnailer;
typedef struct _RygelDbusThumbnailerClass RygelDbusThumbnailerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	THUMBNAILER_ERROR_NO_DIR,
	THUMBNAILER_ERROR_NO_THUMBNAIL
} ThumbnailerError;
#define THUMBNAILER_ERROR thumbnailer_error_quark ()
struct _RygelThumbnailer {
	GObject parent_instance;
	RygelThumbnailerPrivate * priv;
	gchar* directory;
};

struct _RygelThumbnailerClass {
	GObjectClass parent_class;
};

struct _RygelThumbnailerPrivate {
	RygelThumbnail* template;
	gchar* extension;
	RygelDbusThumbnailer* thumbler;
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};

struct _RygelThumbnail {
	RygelIconInfo parent_instance;
	RygelThumbnailPrivate * priv;
	gchar* dlna_profile;
};

struct _RygelThumbnailClass {
	RygelIconInfoClass parent_class;
	GUPnPDIDLLiteResource* (*add_resource) (RygelThumbnail* self, GUPnPDIDLLiteItem* didl_item, const gchar* protocol);
};


static gpointer rygel_thumbnailer_parent_class = NULL;
static RygelThumbnailer* rygel_thumbnailer_thumbnailer;
static RygelThumbnailer* rygel_thumbnailer_thumbnailer = NULL;
static gboolean rygel_thumbnailer_first_time;
static gboolean rygel_thumbnailer_first_time = TRUE;

GQuark thumbnailer_error_quark (void);
GType rygel_thumbnailer_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_dbus_thumbnailer_get_type (void) G_GNUC_CONST;
#define RYGEL_THUMBNAILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerPrivate))
enum  {
	RYGEL_THUMBNAILER_DUMMY_PROPERTY
};
static RygelThumbnailer* rygel_thumbnailer_new (GError** error);
static RygelThumbnailer* rygel_thumbnailer_construct (GType object_type, GError** error);
RygelThumbnail* rygel_thumbnail_new (const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelThumbnail* rygel_thumbnail_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelDbusThumbnailer* rygel_dbus_thumbnailer_new (const gchar* flavor, GError** error);
RygelDbusThumbnailer* rygel_dbus_thumbnailer_construct (GType object_type, const gchar* flavor, GError** error);
RygelThumbnailer* rygel_thumbnailer_get_default (void);
RygelThumbnail* rygel_thumbnailer_get_thumbnail (RygelThumbnailer* self, const gchar* uri, const gchar* mime_type, GError** error);
void rygel_dbus_thumbnailer_queue_thumbnail_task (RygelDbusThumbnailer* self, const gchar* file_path, const gchar* mime);
static void rygel_thumbnailer_finalize (GObject* obj);


GQuark thumbnailer_error_quark (void) {
	return g_quark_from_static_string ("thumbnailer_error-quark");
}


static RygelThumbnailer* rygel_thumbnailer_construct (GType object_type, GError** error) {
	RygelThumbnailer * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* dir;
	const gchar* _tmp2_;
	GFile* _tmp3_ = NULL;
	GFile* file;
	RygelThumbnail* _tmp4_;
	GFile* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	GError * _inner_error_ = NULL;
	self = (RygelThumbnailer*) g_object_new (object_type, NULL);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_build_filename (_tmp0_, ".thumbnails", "cropped", NULL);
	dir = _tmp1_;
	_tmp2_ = dir;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	file = _tmp3_;
	_tmp4_ = rygel_thumbnail_new ("image/jpeg", "JPEG_TN", "jpg");
	_rygel_icon_info_unref0 (self->priv->template);
	self->priv->template = _tmp4_;
	_tmp5_ = file;
	_tmp6_ = g_file_query_exists (_tmp5_, NULL);
	if (!_tmp6_) {
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_;
		GFile* _tmp10_ = NULL;
		GFile* _tmp11_;
		gboolean _tmp12_ = FALSE;
		_tmp7_ = g_get_home_dir ();
		_tmp8_ = g_build_filename (_tmp7_, ".thumbnails", "normal", NULL);
		_g_free0 (dir);
		dir = _tmp8_;
		_tmp9_ = dir;
		_tmp10_ = g_file_new_for_path (_tmp9_);
		_g_object_unref0 (file);
		file = _tmp10_;
		_tmp11_ = file;
		_tmp12_ = g_file_query_exists (_tmp11_, NULL);
		if (!_tmp12_) {
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			gchar* message;
			const gchar* _tmp15_;
			GError* _tmp16_;
			_tmp13_ = _ ("Failed to find thumbnails folder.");
			_tmp14_ = g_strdup (_tmp13_);
			message = _tmp14_;
			_tmp15_ = message;
			_tmp16_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_DIR, _tmp15_);
			_inner_error_ = _tmp16_;
			if (_inner_error_->domain == THUMBNAILER_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (message);
				_g_object_unref0 (file);
				_g_free0 (dir);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (message);
				_g_object_unref0 (file);
				_g_free0 (dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_free0 (message);
		} else {
			RygelThumbnail* _tmp17_;
			gchar* _tmp18_;
			RygelThumbnail* _tmp19_;
			gchar* _tmp20_;
			RygelThumbnail* _tmp21_;
			gchar* _tmp22_;
			RygelThumbnail* _tmp23_;
			RygelThumbnail* _tmp24_;
			RygelThumbnail* _tmp25_;
			RygelThumbnail* _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp17_ = self->priv->template;
			_tmp18_ = g_strdup ("image/png");
			_g_free0 (((RygelIconInfo*) _tmp17_)->mime_type);
			((RygelIconInfo*) _tmp17_)->mime_type = _tmp18_;
			_tmp19_ = self->priv->template;
			_tmp20_ = g_strdup ("PNG_TN");
			_g_free0 (_tmp19_->dlna_profile);
			_tmp19_->dlna_profile = _tmp20_;
			_tmp21_ = self->priv->template;
			_tmp22_ = g_strdup ("png");
			_g_free0 (((RygelIconInfo*) _tmp21_)->file_extension);
			((RygelIconInfo*) _tmp21_)->file_extension = _tmp22_;
			_tmp23_ = self->priv->template;
			((RygelIconInfo*) _tmp23_)->width = 128;
			_tmp24_ = self->priv->template;
			((RygelIconInfo*) _tmp24_)->height = 128;
			_tmp25_ = self->priv->template;
			((RygelIconInfo*) _tmp25_)->depth = 32;
			_tmp26_ = self->priv->template;
			_tmp27_ = ((RygelIconInfo*) _tmp26_)->file_extension;
			_tmp28_ = g_strconcat (".", _tmp27_, NULL);
			_g_free0 (self->priv->extension);
			self->priv->extension = _tmp28_;
		}
	} else {
		RygelThumbnail* _tmp29_;
		RygelThumbnail* _tmp30_;
		RygelThumbnail* _tmp31_;
		gchar* _tmp32_;
		_tmp29_ = self->priv->template;
		((RygelIconInfo*) _tmp29_)->width = 124;
		_tmp30_ = self->priv->template;
		((RygelIconInfo*) _tmp30_)->height = 124;
		_tmp31_ = self->priv->template;
		((RygelIconInfo*) _tmp31_)->depth = 24;
		_tmp32_ = g_strdup (".jpeg");
		_g_free0 (self->priv->extension);
		self->priv->extension = _tmp32_;
	}
	_tmp33_ = dir;
	_tmp34_ = g_strdup (_tmp33_);
	_g_free0 (self->directory);
	self->directory = _tmp34_;
	{
		RygelDbusThumbnailer* _tmp35_;
		RygelDbusThumbnailer* _tmp36_;
		_tmp35_ = rygel_dbus_thumbnailer_new ("normal", &_inner_error_);
		_tmp36_ = _tmp35_;
		if (_inner_error_ != NULL) {
			goto __catch61_g_error;
		}
		_g_object_unref0 (self->priv->thumbler);
		self->priv->thumbler = _tmp36_;
	}
	goto __finally61;
	__catch61_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally61:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == THUMBNAILER_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (file);
			_g_free0 (dir);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (file);
			_g_free0 (dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (file);
	_g_free0 (dir);
	return self;
}


static RygelThumbnailer* rygel_thumbnailer_new (GError** error) {
	return rygel_thumbnailer_construct (RYGEL_TYPE_THUMBNAILER, error);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelThumbnailer* rygel_thumbnailer_get_default (void) {
	RygelThumbnailer* result = NULL;
	gboolean _tmp0_;
	RygelThumbnailer* _tmp6_;
	RygelThumbnailer* _tmp7_;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_thumbnailer_first_time;
	if (_tmp0_) {
		{
			RygelThumbnailer* _tmp1_;
			RygelThumbnailer* _tmp2_;
			_tmp1_ = rygel_thumbnailer_new (&_inner_error_);
			_tmp2_ = _tmp1_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == THUMBNAILER_ERROR) {
					goto __catch62_thumbnailer_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_object_unref0 (rygel_thumbnailer_thumbnailer);
			rygel_thumbnailer_thumbnailer = _tmp2_;
		}
		goto __finally62;
		__catch62_thumbnailer_error:
		{
			GError* err = NULL;
			const gchar* _tmp3_ = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp3_ = _ ("No thumbnailer available: %s");
			_tmp4_ = err;
			_tmp5_ = _tmp4_->message;
			g_warning (_tmp3_, _tmp5_);
			_g_error_free0 (err);
		}
		__finally62:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		rygel_thumbnailer_first_time = FALSE;
	}
	_tmp6_ = rygel_thumbnailer_thumbnailer;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


RygelThumbnail* rygel_thumbnailer_get_thumbnail (RygelThumbnailer* self, const gchar* uri, const gchar* mime_type, GError** error) {
	RygelThumbnail* result = NULL;
	RygelThumbnail* thumbnail;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* path;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* full_path;
	const gchar* _tmp9_;
	GFile* _tmp10_ = NULL;
	GFile* file;
	gboolean _tmp11_ = FALSE;
	RygelDbusThumbnailer* _tmp12_;
	gboolean _tmp15_;
	GFile* _tmp19_;
	GFileInfo* _tmp20_ = NULL;
	GFileInfo* info;
	GFileInfo* _tmp21_;
	gboolean _tmp22_ = FALSE;
	RygelThumbnail* _tmp25_;
	const gchar* _tmp26_;
	RygelThumbnail* _tmp27_;
	const gchar* _tmp28_;
	RygelThumbnail* _tmp29_;
	const gchar* _tmp30_;
	RygelThumbnail* _tmp31_;
	RygelThumbnail* _tmp32_;
	RygelThumbnail* _tmp33_;
	gint _tmp34_;
	RygelThumbnail* _tmp35_;
	RygelThumbnail* _tmp36_;
	gint _tmp37_;
	RygelThumbnail* _tmp38_;
	RygelThumbnail* _tmp39_;
	gint _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_;
	RygelThumbnail* _tmp44_;
	RygelThumbnail* _tmp45_;
	GFileInfo* _tmp46_;
	guint64 _tmp47_ = 0ULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (mime_type != NULL, NULL);
	thumbnail = NULL;
	_tmp0_ = uri;
	_tmp1_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp0_, (gsize) (-1));
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->extension;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	path = _tmp5_;
	_tmp6_ = self->directory;
	_tmp7_ = path;
	_tmp8_ = g_build_filename (_tmp6_, _tmp7_, NULL);
	full_path = _tmp8_;
	_tmp9_ = full_path;
	_tmp10_ = g_file_new_for_path (_tmp9_);
	file = _tmp10_;
	_tmp12_ = self->priv->thumbler;
	if (_tmp12_ != NULL) {
		GFile* _tmp13_;
		gboolean _tmp14_ = FALSE;
		_tmp13_ = file;
		_tmp14_ = g_file_query_exists (_tmp13_, NULL);
		_tmp11_ = !_tmp14_;
	} else {
		_tmp11_ = FALSE;
	}
	_tmp15_ = _tmp11_;
	if (_tmp15_) {
		RygelDbusThumbnailer* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp16_ = self->priv->thumbler;
		_tmp17_ = uri;
		_tmp18_ = mime_type;
		rygel_dbus_thumbnailer_queue_thumbnail_task (_tmp16_, _tmp17_, _tmp18_);
	}
	_tmp19_ = file;
	_tmp20_ = g_file_query_info (_tmp19_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp20_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		_g_free0 (full_path);
		_g_free0 (path);
		_rygel_icon_info_unref0 (thumbnail);
		return NULL;
	}
	_tmp21_ = info;
	_tmp22_ = g_file_info_get_attribute_boolean (_tmp21_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
	if (!_tmp22_) {
		const gchar* _tmp23_ = NULL;
		GError* _tmp24_;
		_tmp23_ = _ ("No thumbnail available");
		_tmp24_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_THUMBNAIL, _tmp23_);
		_inner_error_ = _tmp24_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		_g_free0 (full_path);
		_g_free0 (path);
		_rygel_icon_info_unref0 (thumbnail);
		return NULL;
	}
	_tmp25_ = self->priv->template;
	_tmp26_ = ((RygelIconInfo*) _tmp25_)->mime_type;
	_tmp27_ = self->priv->template;
	_tmp28_ = _tmp27_->dlna_profile;
	_tmp29_ = self->priv->template;
	_tmp30_ = ((RygelIconInfo*) _tmp29_)->file_extension;
	_tmp31_ = rygel_thumbnail_new (_tmp26_, _tmp28_, _tmp30_);
	_rygel_icon_info_unref0 (thumbnail);
	thumbnail = _tmp31_;
	_tmp32_ = thumbnail;
	_tmp33_ = self->priv->template;
	_tmp34_ = ((RygelIconInfo*) _tmp33_)->width;
	((RygelIconInfo*) _tmp32_)->width = _tmp34_;
	_tmp35_ = thumbnail;
	_tmp36_ = self->priv->template;
	_tmp37_ = ((RygelIconInfo*) _tmp36_)->height;
	((RygelIconInfo*) _tmp35_)->height = _tmp37_;
	_tmp38_ = thumbnail;
	_tmp39_ = self->priv->template;
	_tmp40_ = ((RygelIconInfo*) _tmp39_)->depth;
	((RygelIconInfo*) _tmp38_)->depth = _tmp40_;
	_tmp41_ = full_path;
	_tmp42_ = g_filename_to_uri (_tmp41_, NULL, &_inner_error_);
	_tmp43_ = _tmp42_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		_g_free0 (full_path);
		_g_free0 (path);
		_rygel_icon_info_unref0 (thumbnail);
		return NULL;
	}
	_tmp44_ = thumbnail;
	_g_free0 (((RygelIconInfo*) _tmp44_)->uri);
	((RygelIconInfo*) _tmp44_)->uri = _tmp43_;
	_tmp45_ = thumbnail;
	_tmp46_ = info;
	_tmp47_ = g_file_info_get_attribute_uint64 (_tmp46_, G_FILE_ATTRIBUTE_STANDARD_SIZE);
	((RygelIconInfo*) _tmp45_)->size = (gint64) _tmp47_;
	result = thumbnail;
	_g_object_unref0 (info);
	_g_object_unref0 (file);
	_g_free0 (full_path);
	_g_free0 (path);
	return result;
}


static void rygel_thumbnailer_class_init (RygelThumbnailerClass * klass) {
	rygel_thumbnailer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelThumbnailerPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_thumbnailer_finalize;
}


static void rygel_thumbnailer_instance_init (RygelThumbnailer * self) {
	self->priv = RYGEL_THUMBNAILER_GET_PRIVATE (self);
	self->priv->thumbler = NULL;
}


static void rygel_thumbnailer_finalize (GObject* obj) {
	RygelThumbnailer * self;
	self = RYGEL_THUMBNAILER (obj);
	_g_free0 (self->directory);
	_rygel_icon_info_unref0 (self->priv->template);
	_g_free0 (self->priv->extension);
	_g_object_unref0 (self->priv->thumbler);
	G_OBJECT_CLASS (rygel_thumbnailer_parent_class)->finalize (obj);
}


/**
 * Provides thumbnails for images and vidoes.
 */
GType rygel_thumbnailer_get_type (void) {
	static volatile gsize rygel_thumbnailer_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnailer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnailer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnailer), 0, (GInstanceInitFunc) rygel_thumbnailer_instance_init, NULL };
		GType rygel_thumbnailer_type_id;
		rygel_thumbnailer_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelThumbnailer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_thumbnailer_type_id__volatile, rygel_thumbnailer_type_id);
	}
	return rygel_thumbnailer_type_id__volatile;
}



