/* iagno.c generated by valac 0.15.1, the Vala compiler
 * generated from iagno.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include "gtk/gtk.h"
#include <gio/gio.h>
#include <games-file-list.h>
#include <stdlib.h>
#include <string.h>
#include <games-stock.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <games-settings.h>
#include <games-preimage.h>
#include <canberra-gtk.h>
#include <canberra.h>
#include <gdk/gdk.h>
#include <games-frame.h>
#include <locale.h>


#define TYPE_IAGNO (iagno_get_type ())
#define IAGNO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IAGNO, Iagno))
#define IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IAGNO, IagnoClass))
#define IS_IAGNO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IAGNO))
#define IS_IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IAGNO))
#define IAGNO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IAGNO, IagnoClass))

typedef struct _Iagno Iagno;
typedef struct _IagnoClass IagnoClass;
typedef struct _IagnoPrivate IagnoPrivate;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;

#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _computer_player_unref0(var) ((var == NULL) ? NULL : (var = (computer_player_unref (var), NULL)))
#define _game_unref0(var) ((var == NULL) ? NULL : (var = (game_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GamePrivate GamePrivate;

#define TYPE_PLAYER (player_get_type ())
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _Iagno {
	GtkApplication parent_instance;
	IagnoPrivate * priv;
};

struct _IagnoClass {
	GtkApplicationClass parent_class;
};

struct _IagnoPrivate {
	GSettings* settings;
	GtkWindow* window;
	GtkStatusbar* statusbar;
	guint statusbar_id;
	GameView* view;
	GtkLabel* dark_score_label;
	GtkLabel* light_score_label;
	GtkAction* new_game_action;
	GtkAction* undo_action;
	ComputerPlayer* light_computer;
	ComputerPlayer* dark_computer;
	guint computer_timer;
	Game* game;
	gboolean was_pass;
	GamesFileList* theme_file_list;
	gchar* ui_description;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_LIGHT,
	PLAYER_DARK
} Player;

struct _Game {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GamePrivate * priv;
	Player* tiles;
	gint tiles_length1;
	gint tiles_length2;
	Player current_color;
};

struct _GameClass {
	GTypeClass parent_class;
	void (*finalize) (Game *self);
};


static gpointer iagno_parent_class = NULL;

GType iagno_get_type (void) G_GNUC_CONST;
GType game_view_get_type (void) G_GNUC_CONST;
gpointer computer_player_ref (gpointer instance);
void computer_player_unref (gpointer instance);
GParamSpec* param_spec_computer_player (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_computer_player (GValue* value, gpointer v_object);
void value_take_computer_player (GValue* value, gpointer v_object);
gpointer value_get_computer_player (const GValue* value);
GType computer_player_get_type (void) G_GNUC_CONST;
gpointer game_ref (gpointer instance);
void game_unref (gpointer instance);
GParamSpec* param_spec_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_game (GValue* value, gpointer v_object);
void value_take_game (GValue* value, gpointer v_object);
gpointer value_get_game (const GValue* value);
GType game_get_type (void) G_GNUC_CONST;
#define IAGNO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IAGNO, IagnoPrivate))
enum  {
	IAGNO_DUMMY_PROPERTY
};
static void iagno_new_game_cb (Iagno* self);
static void _iagno_new_game_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void iagno_undo_move_cb (Iagno* self);
static void _iagno_undo_move_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void iagno_quit_game_cb (Iagno* self);
static void _iagno_quit_game_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void iagno_properties_cb (Iagno* self);
static void _iagno_properties_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void iagno_help_cb (Iagno* self, GtkAction* action);
static void _iagno_help_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void iagno_about_cb (Iagno* self, GtkAction* action);
static void _iagno_about_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void _iagno_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _iagno_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_real_startup (GApplication* base);
Iagno* iagno_new (void);
Iagno* iagno_construct (GType object_type);
static void iagno_real_activate (GApplication* base);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
void game_view_set_game (GameView* self, Game* value);
static void iagno_player_move_cb (Iagno* self, gint x, gint y);
static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self);
void game_view_set_show_grid (GameView* self, gboolean value);
void game_view_set_flip_final_result (GameView* self, gboolean value);
static GamesPreimage* iagno_load_theme_texture (Iagno* self, const gchar* filename, gboolean fail_on_error);
void game_view_set_theme (GameView* self, GamesPreimage* value);
static void iagno_start_game (Iagno* self);
Game* game_new (gint width, gint height);
Game* game_construct (GType object_type, gint width, gint height);
static void iagno_game_move_cb (Iagno* self);
static void _iagno_game_move_cb_game_move (Game* _sender, gpointer self);
static void iagno_game_complete_cb (Iagno* self);
static void _iagno_game_complete_cb_game_complete (Game* _sender, gpointer self);
ComputerPlayer* computer_player_new (Game* game, gint level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint level);
static void iagno_update_ui (Iagno* self);
void game_start (Game* self);
gboolean game_get_can_undo (Game* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
GType player_get_type (void) G_GNUC_CONST;
static void iagno_show_message (Iagno* self, const gchar* message);
void game_undo (Game* self, gint count);
static void iagno_show_properties_dialog (Iagno* self);
static void iagno_play_sound (Iagno* self, const gchar* name);
gboolean game_get_can_move (Game* self);
void game_pass (Game* self);
static gboolean iagno_computer_move_cb (Iagno* self);
static gboolean _iagno_computer_move_cb_gsource_func (gpointer self);
void computer_player_move (ComputerPlayer* self);
gint game_place_tile (Game* self, gint x, gint y);
static void iagno_dark_human_cb (Iagno* self, GtkToggleButton* widget);
static void iagno_dark_level_one_cb (Iagno* self, GtkToggleButton* widget);
static void iagno_dark_level_two_cb (Iagno* self, GtkToggleButton* widget);
static void iagno_dark_level_three_cb (Iagno* self, GtkToggleButton* widget);
static void iagno_light_human_cb (Iagno* self, GtkToggleButton* widget);
static void iagno_light_level_one_cb (Iagno* self, GtkToggleButton* widget);
static void iagno_light_level_two_cb (Iagno* self, GtkToggleButton* widget);
static void iagno_light_level_three_cb (Iagno* self, GtkToggleButton* widget);
static void iagno_sound_select (Iagno* self, GtkToggleButton* widget);
static void iagno_grid_toggled_cb (Iagno* self, GtkToggleButton* widget);
gboolean game_view_get_show_grid (GameView* self);
static void iagno_flip_final_toggled_cb (Iagno* self, GtkToggleButton* widget);
gboolean game_view_get_flip_final_result (GameView* self);
static void iagno_propbox_response_cb (Iagno* self, GtkWidget* widget, gint response_id);
static gboolean iagno_propbox_close_cb (Iagno* self, GtkWidget* widget, GdkEventAny* event);
static void iagno_theme_changed_cb (Iagno* self, GtkComboBox* widget);
void game_view_redraw (GameView* self);
static void _iagno_propbox_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean _iagno_propbox_close_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void _iagno_sound_select_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _iagno_dark_human_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _iagno_dark_level_one_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _iagno_dark_level_two_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _iagno_dark_level_three_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _iagno_light_human_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _iagno_light_level_one_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _iagno_light_level_two_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _iagno_light_level_three_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _iagno_grid_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _iagno_flip_final_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _iagno_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
gint iagno_main (gchar** args, int args_length1);
static void iagno_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GtkActionEntry IAGNO_actions[9] = {{"GameMenu", NULL, "_Game"}, {"SettingsMenu", NULL, "_Settings"}, {"HelpMenu", NULL, "_Help"}, {"NewGame", GAMES_STOCK_NEW_GAME, NULL, NULL, NULL, (GCallback) _iagno_new_game_cb_gtk_action_callback}, {"UndoMove", GAMES_STOCK_UNDO_MOVE, NULL, NULL, NULL, (GCallback) _iagno_undo_move_cb_gtk_action_callback}, {"Quit", GTK_STOCK_QUIT, NULL, NULL, NULL, (GCallback) _iagno_quit_game_cb_gtk_action_callback}, {"Preferences", GTK_STOCK_PREFERENCES, NULL, NULL, NULL, (GCallback) _iagno_properties_cb_gtk_action_callback}, {"Contents", GAMES_STOCK_CONTENTS, NULL, NULL, NULL, (GCallback) _iagno_help_cb_gtk_action_callback}, {"About", GTK_STOCK_ABOUT, NULL, NULL, NULL, (GCallback) _iagno_about_cb_gtk_action_callback}};
static const GActionEntry IAGNO_app_actions[2] = {{"new-game", _iagno_new_game_cb_gsimple_action_activate_callback}, {"undo-move", _iagno_undo_move_cb_gsimple_action_activate_callback}};

static void _iagno_new_game_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	iagno_new_game_cb (self);
}


static void _iagno_undo_move_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	iagno_undo_move_cb (self);
}


static void _iagno_quit_game_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	iagno_quit_game_cb (self);
}


static void _iagno_properties_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	iagno_properties_cb (self);
}


static void _iagno_help_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	iagno_help_cb (self, action);
}


static void _iagno_about_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	iagno_about_cb (self, action);
}


static void _iagno_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_new_game_cb (self);
}


static void _iagno_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_undo_move_cb (self);
}


static void iagno_real_startup (GApplication* base) {
	Iagno * self;
	self = (Iagno*) base;
	G_APPLICATION_CLASS (iagno_parent_class)->startup ((GApplication*) GTK_APPLICATION (self));
	g_action_map_add_action_entries ((GActionMap*) self, IAGNO_app_actions, G_N_ELEMENTS (IAGNO_app_actions), self);
}


Iagno* iagno_construct (GType object_type) {
	Iagno * self = NULL;
	self = (Iagno*) g_object_new (object_type, "application-id", "org.gnome.iagno", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	return self;
}


Iagno* iagno_new (void) {
	return iagno_construct (TYPE_IAGNO);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self) {
	iagno_player_move_cb (self, x, y);
}


static void iagno_real_activate (GApplication* base) {
	Iagno * self;
	GtkWindow* _tmp0_;
	GSettings* _tmp2_;
	GtkBuilder* _tmp3_;
	GtkBuilder* builder;
	GtkBuilder* _tmp8_;
	GObject* _tmp9_ = NULL;
	GtkWindow* _tmp10_;
	GtkBuilder* _tmp11_;
	GObject* _tmp12_ = NULL;
	GtkGrid* _tmp13_;
	GtkGrid* top_grid;
	GtkWindow* _tmp14_;
	const gchar* _tmp15_ = NULL;
	GtkWindow* _tmp16_;
	GtkWindow* _tmp17_;
	GtkUIManager* _tmp18_;
	GtkUIManager* ui_manager;
	GtkActionGroup* _tmp19_;
	GtkActionGroup* action_group;
	GtkActionGroup* _tmp20_;
	GtkActionGroup* _tmp21_;
	GtkUIManager* _tmp22_;
	GtkActionGroup* _tmp23_;
	GtkWindow* _tmp28_;
	GtkUIManager* _tmp29_;
	GtkAccelGroup* _tmp30_ = NULL;
	GtkActionGroup* _tmp31_;
	GtkAction* _tmp32_ = NULL;
	GtkAction* _tmp33_;
	GtkActionGroup* _tmp34_;
	GtkAction* _tmp35_ = NULL;
	GtkAction* _tmp36_;
	GtkAction* _tmp37_;
	GtkUIManager* _tmp38_;
	GtkWidget* _tmp39_ = NULL;
	GtkMenuBar* _tmp40_;
	GtkMenuBar* menubar;
	GtkGrid* _tmp41_;
	GtkMenuBar* _tmp42_;
	GameView* _tmp43_;
	GameView* _tmp44_;
	GameView* _tmp45_;
	GameView* _tmp46_;
	GameView* _tmp47_;
	Game* _tmp48_;
	GameView* _tmp49_;
	GameView* _tmp50_;
	GSettings* _tmp51_;
	gboolean _tmp52_ = FALSE;
	GameView* _tmp53_;
	GSettings* _tmp54_;
	gboolean _tmp55_ = FALSE;
	GSettings* _tmp56_;
	gchar* _tmp57_ = NULL;
	gchar* tile_set;
	const gchar* _tmp58_;
	GamesPreimage* _tmp59_ = NULL;
	GamesPreimage* theme;
	GamesPreimage* _tmp60_;
	GameView* _tmp63_;
	GamesPreimage* _tmp64_;
	GameView* _tmp65_;
	GtkGrid* _tmp66_;
	GameView* _tmp67_;
	GtkStatusbar* _tmp68_;
	GtkStatusbar* _tmp69_;
	GtkStatusbar* _tmp70_;
	GtkBuilder* _tmp71_;
	GObject* _tmp72_ = NULL;
	GtkToolbar* _tmp73_;
	GtkToolbar* toolbar;
	GtkToolbar* _tmp74_;
	GtkToolbar* _tmp75_;
	GtkStyleContext* _tmp76_ = NULL;
	GtkToolbar* _tmp77_;
	GtkSeparatorToolItem* _tmp78_;
	GtkSeparatorToolItem* _tmp79_;
	GtkToolItem* _tmp80_;
	GtkToolItem* _tmp81_;
	GtkToolItem* status_item;
	GtkToolItem* _tmp82_;
	GtkToolItem* _tmp83_;
	GtkAlignment* _tmp84_;
	GtkAlignment* _tmp85_;
	GtkAlignment* status_alignment;
	GtkAlignment* _tmp86_;
	GtkStatusbar* _tmp87_;
	GtkToolItem* _tmp88_;
	GtkAlignment* _tmp89_;
	GtkToolbar* _tmp90_;
	GtkToolItem* _tmp91_;
	GtkToolbar* _tmp92_;
	GtkGrid* _tmp93_;
	GtkGrid* _tmp94_;
	GtkGrid* grid;
	GtkGrid* _tmp95_;
	GtkGrid* _tmp96_;
	GtkStatusbar* _tmp97_;
	GtkGrid* _tmp98_;
	GtkUIManager* _tmp99_;
	GtkGrid* _tmp100_;
	const gchar* _tmp101_ = NULL;
	GtkLabel* _tmp102_;
	GtkLabel* _tmp103_;
	GtkLabel* label;
	GtkLabel* _tmp104_;
	GtkGrid* _tmp105_;
	GtkLabel* _tmp106_;
	GtkLabel* _tmp107_;
	GtkLabel* _tmp108_;
	GtkLabel* _tmp109_;
	GtkGrid* _tmp110_;
	GtkLabel* _tmp111_;
	const gchar* _tmp112_ = NULL;
	GtkLabel* _tmp113_;
	GtkLabel* _tmp114_;
	GtkLabel* _tmp115_;
	GtkGrid* _tmp116_;
	GtkLabel* _tmp117_;
	GtkLabel* _tmp118_;
	GtkLabel* _tmp119_;
	GtkLabel* _tmp120_;
	GtkGrid* _tmp121_;
	GtkLabel* _tmp122_;
	GtkStatusbar* _tmp123_;
	guint _tmp124_ = 0U;
	GtkWindow* _tmp125_;
	GError * _inner_error_ = NULL;
	self = (Iagno*) base;
	_tmp0_ = self->priv->window;
	if (_tmp0_ != NULL) {
		GtkWindow* _tmp1_;
		_tmp1_ = self->priv->window;
		gtk_widget_show ((GtkWidget*) _tmp1_);
		return;
	}
	_tmp2_ = g_settings_new ("org.gnome.iagno");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	_tmp3_ = gtk_builder_new ();
	builder = _tmp3_;
	{
		GtkBuilder* _tmp4_;
		_tmp4_ = builder;
		gtk_builder_add_from_file (_tmp4_, DATA_DIRECTORY "/iagno.ui", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "Could not load UI: %s\n", _tmp7_);
		_g_error_free0 (e);
		_g_object_unref0 (builder);
		return;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = builder;
	_tmp9_ = gtk_builder_get_object (_tmp8_, "window");
	_tmp10_ = _g_object_ref0 (GTK_IS_WINDOW (_tmp9_) ? ((GtkWindow*) _tmp9_) : NULL);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp10_;
	_tmp11_ = builder;
	_tmp12_ = gtk_builder_get_object (_tmp11_, "grid");
	_tmp13_ = _g_object_ref0 (GTK_IS_GRID (_tmp12_) ? ((GtkGrid*) _tmp12_) : NULL);
	top_grid = _tmp13_;
	_tmp14_ = self->priv->window;
	_tmp15_ = _ ("Iagno");
	gtk_window_set_title (_tmp14_, _tmp15_);
	_tmp16_ = self->priv->window;
	games_settings_bind_window_state ("/org/gnome/iagno/", _tmp16_);
	_tmp17_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, _tmp17_);
	_tmp18_ = gtk_ui_manager_new ();
	ui_manager = _tmp18_;
	_tmp19_ = gtk_action_group_new ("group");
	action_group = _tmp19_;
	_tmp20_ = action_group;
	gtk_action_group_set_translation_domain (_tmp20_, GETTEXT_PACKAGE);
	_tmp21_ = action_group;
	gtk_action_group_add_actions (_tmp21_, IAGNO_actions, G_N_ELEMENTS (IAGNO_actions), self);
	_tmp22_ = ui_manager;
	_tmp23_ = action_group;
	gtk_ui_manager_insert_action_group (_tmp22_, _tmp23_, 0);
	{
		GtkUIManager* _tmp24_;
		const gchar* _tmp25_;
		_tmp24_ = ui_manager;
		_tmp25_ = self->priv->ui_description;
		gtk_ui_manager_add_ui_from_string (_tmp24_, _tmp25_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp26_;
		const gchar* _tmp27_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->message;
		g_warning ("iagno.vala:125: Failed to load UI: %s", _tmp27_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (action_group);
		_g_object_unref0 (ui_manager);
		_g_object_unref0 (top_grid);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp28_ = self->priv->window;
	_tmp29_ = ui_manager;
	_tmp30_ = gtk_ui_manager_get_accel_group (_tmp29_);
	gtk_window_add_accel_group (_tmp28_, _tmp30_);
	_tmp31_ = action_group;
	_tmp32_ = gtk_action_group_get_action (_tmp31_, "NewGame");
	_tmp33_ = _g_object_ref0 (_tmp32_);
	_g_object_unref0 (self->priv->new_game_action);
	self->priv->new_game_action = _tmp33_;
	_tmp34_ = action_group;
	_tmp35_ = gtk_action_group_get_action (_tmp34_, "UndoMove");
	_tmp36_ = _g_object_ref0 (_tmp35_);
	_g_object_unref0 (self->priv->undo_action);
	self->priv->undo_action = _tmp36_;
	_tmp37_ = self->priv->undo_action;
	gtk_action_set_sensitive (_tmp37_, FALSE);
	_tmp38_ = ui_manager;
	_tmp39_ = gtk_ui_manager_get_widget (_tmp38_, "/MainMenu");
	_tmp40_ = _g_object_ref0 (GTK_MENU_BAR (_tmp39_));
	menubar = _tmp40_;
	_tmp41_ = top_grid;
	_tmp42_ = menubar;
	gtk_grid_attach (_tmp41_, (GtkWidget*) _tmp42_, 0, 0, 1, 1);
	_tmp43_ = game_view_new ();
	_tmp44_ = g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp44_;
	_tmp45_ = self->priv->view;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp45_, TRUE);
	_tmp46_ = self->priv->view;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp46_, TRUE);
	_tmp47_ = self->priv->view;
	_tmp48_ = self->priv->game;
	game_view_set_game (_tmp47_, _tmp48_);
	_tmp49_ = self->priv->view;
	g_signal_connect_object (_tmp49_, "move", (GCallback) _iagno_player_move_cb_game_view_move, self, 0);
	_tmp50_ = self->priv->view;
	_tmp51_ = self->priv->settings;
	_tmp52_ = g_settings_get_boolean (_tmp51_, "show-grid");
	game_view_set_show_grid (_tmp50_, _tmp52_);
	_tmp53_ = self->priv->view;
	_tmp54_ = self->priv->settings;
	_tmp55_ = g_settings_get_boolean (_tmp54_, "flip-final-results");
	game_view_set_flip_final_result (_tmp53_, _tmp55_);
	_tmp56_ = self->priv->settings;
	_tmp57_ = g_settings_get_string (_tmp56_, "tileset");
	tile_set = _tmp57_;
	_tmp58_ = tile_set;
	_tmp59_ = iagno_load_theme_texture (self, _tmp58_, FALSE);
	theme = _tmp59_;
	_tmp60_ = theme;
	if (_tmp60_ == NULL) {
		const gchar* _tmp61_;
		GamesPreimage* _tmp62_ = NULL;
		_tmp61_ = tile_set;
		g_warning ("iagno.vala:147: Unable to load theme %s, falling back to default", _tmp61_);
		_tmp62_ = iagno_load_theme_texture (self, "black_and_white.svg", TRUE);
		_g_object_unref0 (theme);
		theme = _tmp62_;
	}
	_tmp63_ = self->priv->view;
	_tmp64_ = theme;
	game_view_set_theme (_tmp63_, _tmp64_);
	_tmp65_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp65_);
	_tmp66_ = top_grid;
	_tmp67_ = self->priv->view;
	gtk_grid_attach (_tmp66_, (GtkWidget*) _tmp67_, 0, 2, 1, 1);
	_tmp68_ = (GtkStatusbar*) gtk_statusbar_new ();
	_tmp69_ = g_object_ref_sink (_tmp68_);
	_g_object_unref0 (self->priv->statusbar);
	self->priv->statusbar = _tmp69_;
	_tmp70_ = self->priv->statusbar;
	gtk_widget_show ((GtkWidget*) _tmp70_);
	_tmp71_ = builder;
	_tmp72_ = gtk_builder_get_object (_tmp71_, "toolbar");
	_tmp73_ = _g_object_ref0 (GTK_IS_TOOLBAR (_tmp72_) ? ((GtkToolbar*) _tmp72_) : NULL);
	toolbar = _tmp73_;
	_tmp74_ = toolbar;
	gtk_toolbar_set_show_arrow (_tmp74_, FALSE);
	_tmp75_ = toolbar;
	_tmp76_ = gtk_widget_get_style_context ((GtkWidget*) _tmp75_);
	gtk_style_context_add_class (_tmp76_, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
	_tmp77_ = toolbar;
	_tmp78_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	_tmp79_ = g_object_ref_sink (_tmp78_);
	gtk_toolbar_insert (_tmp77_, (GtkToolItem*) _tmp79_, -1);
	_g_object_unref0 (_tmp79_);
	_tmp80_ = gtk_tool_item_new ();
	_tmp81_ = g_object_ref_sink (_tmp80_);
	status_item = _tmp81_;
	_tmp82_ = status_item;
	gtk_tool_item_set_visible_horizontal (_tmp82_, TRUE);
	_tmp83_ = status_item;
	gtk_tool_item_set_expand (_tmp83_, TRUE);
	_tmp84_ = (GtkAlignment*) gtk_alignment_new (1.0f, 0.5f, 0.0f, 0.0f);
	_tmp85_ = g_object_ref_sink (_tmp84_);
	status_alignment = _tmp85_;
	_tmp86_ = status_alignment;
	_tmp87_ = self->priv->statusbar;
	gtk_container_add ((GtkContainer*) _tmp86_, (GtkWidget*) _tmp87_);
	_tmp88_ = status_item;
	_tmp89_ = status_alignment;
	gtk_container_add ((GtkContainer*) _tmp88_, (GtkWidget*) _tmp89_);
	_tmp90_ = toolbar;
	_tmp91_ = status_item;
	gtk_toolbar_insert (_tmp90_, _tmp91_, -1);
	_tmp92_ = toolbar;
	gtk_widget_show_all ((GtkWidget*) _tmp92_);
	_tmp93_ = (GtkGrid*) gtk_grid_new ();
	_tmp94_ = g_object_ref_sink (_tmp93_);
	grid = _tmp94_;
	_tmp95_ = grid;
	gtk_grid_set_column_spacing (_tmp95_, (guint) 6);
	_tmp96_ = grid;
	gtk_widget_show ((GtkWidget*) _tmp96_);
	_tmp97_ = self->priv->statusbar;
	_tmp98_ = grid;
	gtk_box_pack_start ((GtkBox*) _tmp97_, (GtkWidget*) _tmp98_, FALSE, TRUE, (guint) 0);
	_tmp99_ = ui_manager;
	_tmp100_ = grid;
	games_stock_prepare_for_statusbar_tooltips (_tmp99_, (GtkWidget*) _tmp100_);
	_tmp101_ = _ ("Dark:");
	_tmp102_ = (GtkLabel*) gtk_label_new (_tmp101_);
	_tmp103_ = g_object_ref_sink (_tmp102_);
	label = _tmp103_;
	_tmp104_ = label;
	gtk_widget_show ((GtkWidget*) _tmp104_);
	_tmp105_ = grid;
	_tmp106_ = label;
	gtk_grid_attach (_tmp105_, (GtkWidget*) _tmp106_, 1, 0, 1, 1);
	_tmp107_ = (GtkLabel*) gtk_label_new ("00");
	_tmp108_ = g_object_ref_sink (_tmp107_);
	_g_object_unref0 (self->priv->dark_score_label);
	self->priv->dark_score_label = _tmp108_;
	_tmp109_ = self->priv->dark_score_label;
	gtk_widget_show ((GtkWidget*) _tmp109_);
	_tmp110_ = grid;
	_tmp111_ = self->priv->dark_score_label;
	gtk_grid_attach (_tmp110_, (GtkWidget*) _tmp111_, 2, 0, 1, 1);
	_tmp112_ = _ ("Light:");
	_tmp113_ = (GtkLabel*) gtk_label_new (_tmp112_);
	_tmp114_ = g_object_ref_sink (_tmp113_);
	_g_object_unref0 (label);
	label = _tmp114_;
	_tmp115_ = label;
	gtk_widget_show ((GtkWidget*) _tmp115_);
	_tmp116_ = grid;
	_tmp117_ = label;
	gtk_grid_attach (_tmp116_, (GtkWidget*) _tmp117_, 4, 0, 1, 1);
	_tmp118_ = (GtkLabel*) gtk_label_new ("00");
	_tmp119_ = g_object_ref_sink (_tmp118_);
	_g_object_unref0 (self->priv->light_score_label);
	self->priv->light_score_label = _tmp119_;
	_tmp120_ = self->priv->light_score_label;
	gtk_widget_show ((GtkWidget*) _tmp120_);
	_tmp121_ = grid;
	_tmp122_ = self->priv->light_score_label;
	gtk_grid_attach (_tmp121_, (GtkWidget*) _tmp122_, 5, 0, 1, 1);
	_tmp123_ = self->priv->statusbar;
	_tmp124_ = gtk_statusbar_get_context_id (_tmp123_, "iagno");
	self->priv->statusbar_id = _tmp124_;
	iagno_start_game (self);
	_tmp125_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp125_);
	_g_object_unref0 (label);
	_g_object_unref0 (grid);
	_g_object_unref0 (status_alignment);
	_g_object_unref0 (status_item);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (theme);
	_g_free0 (tile_set);
	_g_object_unref0 (menubar);
	_g_object_unref0 (action_group);
	_g_object_unref0 (ui_manager);
	_g_object_unref0 (top_grid);
	_g_object_unref0 (builder);
}


static GamesPreimage* iagno_load_theme_texture (Iagno* self, const gchar* filename, gboolean fail_on_error) {
	GamesPreimage* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* path;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = filename;
	_tmp1_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp0_, NULL);
	path = _tmp1_;
	{
		GamesPreimage* _tmp2_;
		GamesPreimage* _tmp3_;
		_tmp2_ = games_preimage_new_from_file (path, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		result = _tmp3_;
		_g_free0 (path);
		return result;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = filename;
		g_warning ("iagno.vala:211: Failed to load theme %s: %s", _tmp4_, path);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (path);
		return result;
	}
	__finally2:
	_g_free0 (path);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static void iagno_quit_game_cb (Iagno* self) {
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void iagno_new_game_cb (Iagno* self) {
	g_return_if_fail (self != NULL);
	iagno_start_game (self);
}


static void _iagno_game_move_cb_game_move (Game* _sender, gpointer self) {
	iagno_game_move_cb (self);
}


static void _iagno_game_complete_cb_game_complete (Game* _sender, gpointer self) {
	iagno_game_complete_cb (self);
}


static void iagno_start_game (Iagno* self) {
	guint _tmp0_;
	Game* _tmp2_;
	Game* _tmp4_;
	Game* _tmp5_;
	Game* _tmp6_;
	GameView* _tmp7_;
	Game* _tmp8_;
	GSettings* _tmp9_;
	gint _tmp10_ = 0;
	gint dark_level;
	gint _tmp11_;
	GSettings* _tmp15_;
	gint _tmp16_ = 0;
	gint light_level;
	gint _tmp17_;
	Game* _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->computer_timer;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->computer_timer;
		g_source_remove (_tmp1_);
		self->priv->computer_timer = (guint) 0;
	}
	_tmp2_ = self->priv->game;
	if (_tmp2_ != NULL) {
		Game* _tmp3_;
		_tmp3_ = self->priv->game;
		g_signal_handlers_disconnect_by_func (_tmp3_, NULL, self);
	}
	_tmp4_ = game_new (8, 8);
	_game_unref0 (self->priv->game);
	self->priv->game = _tmp4_;
	_tmp5_ = self->priv->game;
	g_signal_connect_object (_tmp5_, "move", (GCallback) _iagno_game_move_cb_game_move, self, 0);
	_tmp6_ = self->priv->game;
	g_signal_connect_object (_tmp6_, "complete", (GCallback) _iagno_game_complete_cb_game_complete, self, 0);
	_tmp7_ = self->priv->view;
	_tmp8_ = self->priv->game;
	game_view_set_game (_tmp7_, _tmp8_);
	_tmp9_ = self->priv->settings;
	_tmp10_ = g_settings_get_int (_tmp9_, "black-level");
	dark_level = _tmp10_;
	_tmp11_ = dark_level;
	if (_tmp11_ > 0) {
		Game* _tmp12_;
		gint _tmp13_;
		ComputerPlayer* _tmp14_;
		_tmp12_ = self->priv->game;
		_tmp13_ = dark_level;
		_tmp14_ = computer_player_new (_tmp12_, _tmp13_);
		_computer_player_unref0 (self->priv->dark_computer);
		self->priv->dark_computer = _tmp14_;
	} else {
		_computer_player_unref0 (self->priv->dark_computer);
		self->priv->dark_computer = NULL;
	}
	_tmp15_ = self->priv->settings;
	_tmp16_ = g_settings_get_int (_tmp15_, "white-level");
	light_level = _tmp16_;
	_tmp17_ = light_level;
	if (_tmp17_ > 0) {
		Game* _tmp18_;
		gint _tmp19_;
		ComputerPlayer* _tmp20_;
		_tmp18_ = self->priv->game;
		_tmp19_ = light_level;
		_tmp20_ = computer_player_new (_tmp18_, _tmp19_);
		_computer_player_unref0 (self->priv->light_computer);
		self->priv->light_computer = _tmp20_;
	} else {
		_computer_player_unref0 (self->priv->light_computer);
		self->priv->light_computer = NULL;
	}
	iagno_update_ui (self);
	_tmp21_ = self->priv->game;
	game_start (_tmp21_);
}


static void iagno_update_ui (Iagno* self) {
	gboolean _tmp0_ = FALSE;
	ComputerPlayer* _tmp1_;
	gboolean _tmp3_;
	GtkLabel* _tmp9_;
	const gchar* _tmp10_ = NULL;
	Game* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	GtkLabel* _tmp16_;
	const gchar* _tmp17_ = NULL;
	Game* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	gboolean _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->light_computer;
	if (_tmp1_ != NULL) {
		ComputerPlayer* _tmp2_;
		_tmp2_ = self->priv->dark_computer;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		GtkAction* _tmp4_;
		_tmp4_ = self->priv->undo_action;
		gtk_action_set_sensitive (_tmp4_, FALSE);
	} else {
		GtkAction* _tmp5_;
		Game* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = self->priv->undo_action;
		_tmp6_ = self->priv->game;
		_tmp7_ = game_get_can_undo (_tmp6_);
		_tmp8_ = _tmp7_;
		gtk_action_set_sensitive (_tmp5_, _tmp8_);
	}
	_tmp9_ = self->priv->dark_score_label;
	_tmp10_ = _ ("%.2d");
	_tmp11_ = self->priv->game;
	_tmp12_ = game_get_n_dark_tiles (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strdup_printf (_tmp10_, _tmp13_);
	_tmp15_ = _tmp14_;
	gtk_label_set_text (_tmp9_, _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = self->priv->light_score_label;
	_tmp17_ = _ ("%.2d");
	_tmp18_ = self->priv->game;
	_tmp19_ = game_get_n_light_tiles (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strdup_printf (_tmp17_, _tmp20_);
	_tmp22_ = _tmp21_;
	gtk_label_set_text (_tmp16_, _tmp22_);
	_g_free0 (_tmp22_);
	_tmp23_ = self->priv->was_pass;
	if (_tmp23_) {
		Game* _tmp24_;
		Player _tmp25_;
		_tmp24_ = self->priv->game;
		_tmp25_ = _tmp24_->current_color;
		if (_tmp25_ == PLAYER_DARK) {
			const gchar* _tmp26_ = NULL;
			_tmp26_ = _ ("Light must pass, Dark's move");
			iagno_show_message (self, _tmp26_);
		} else {
			const gchar* _tmp27_ = NULL;
			_tmp27_ = _ ("Dark must pass, Light's move");
			iagno_show_message (self, _tmp27_);
		}
	} else {
		Game* _tmp28_;
		Player _tmp29_;
		_tmp28_ = self->priv->game;
		_tmp29_ = _tmp28_->current_color;
		if (_tmp29_ == PLAYER_DARK) {
			const gchar* _tmp30_ = NULL;
			_tmp30_ = _ ("Dark's move");
			iagno_show_message (self, _tmp30_);
		} else {
			Game* _tmp31_;
			Player _tmp32_;
			_tmp31_ = self->priv->game;
			_tmp32_ = _tmp31_->current_color;
			if (_tmp32_ == PLAYER_LIGHT) {
				const gchar* _tmp33_ = NULL;
				_tmp33_ = _ ("Light's move");
				iagno_show_message (self, _tmp33_);
			}
		}
	}
}


static void iagno_undo_move_cb (Iagno* self) {
	guint _tmp0_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Game* _tmp4_;
	Player _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->computer_timer;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->computer_timer;
		g_source_remove (_tmp1_);
		self->priv->computer_timer = (guint) 0;
	}
	_tmp4_ = self->priv->game;
	_tmp5_ = _tmp4_->current_color;
	if (_tmp5_ == PLAYER_DARK) {
		ComputerPlayer* _tmp6_;
		_tmp6_ = self->priv->dark_computer;
		_tmp3_ = _tmp6_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp7_ = _tmp3_;
	if (_tmp7_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		Game* _tmp9_;
		Player _tmp10_;
		gboolean _tmp12_;
		_tmp9_ = self->priv->game;
		_tmp10_ = _tmp9_->current_color;
		if (_tmp10_ == PLAYER_LIGHT) {
			ComputerPlayer* _tmp11_;
			_tmp11_ = self->priv->light_computer;
			_tmp8_ = _tmp11_ != NULL;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp12_ = _tmp8_;
		_tmp2_ = _tmp12_;
	}
	_tmp13_ = _tmp2_;
	if (_tmp13_) {
		Game* _tmp14_;
		_tmp14_ = self->priv->game;
		game_undo (_tmp14_, 1);
	} else {
		Game* _tmp15_;
		_tmp15_ = self->priv->game;
		game_undo (_tmp15_, 2);
	}
}


static void iagno_about_cb (Iagno* self, GtkAction* action) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** authors;
	gint authors_length1;
	gint _authors_size_;
	gchar* _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** documenters;
	gint documenters_length1;
	gint _documenters_size_;
	GtkWindow* _tmp5_;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_strdup ("Ian Peters");
	_tmp1_ = g_strdup ("Robert Ancell");
	_tmp2_ = g_new0 (gchar*, 3 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp2_[2] = NULL;
	authors = _tmp2_;
	authors_length1 = 3;
	_authors_size_ = authors_length1;
	_tmp3_ = g_strdup ("Eric Baudais");
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp4_[1] = NULL;
	documenters = _tmp4_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp5_ = self->priv->window;
	_tmp6_ = _ ("Iagno");
	_tmp7_ = _ ("Iagno");
	_tmp8_ = games_get_license (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _ ("A disk flipping game derived from Reversi.\n" \
"\n" \
"Iagno is a part of GNOME Games.");
	_tmp11_ = _ ("translator-credits");
	_tmp12_ = _ ("GNOME Games web site");
	gtk_show_about_dialog (_tmp5_, "name", _tmp6_, "version", VERSION, "copyright", "Copyright \xc2\xa9 1998-2008 Ian Peters", "license", _tmp9_, "comments", _tmp10_, "authors", authors, "documenters", documenters, "translator-credits", _tmp11_, "logo-icon-name", "iagno", "website-label", _tmp12_, "website", "http://www.gnome.org/projects/gnome-games/", "wrap-license", TRUE, NULL, NULL);
	_g_free0 (_tmp9_);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void iagno_properties_cb (Iagno* self) {
	g_return_if_fail (self != NULL);
	iagno_show_properties_dialog (self);
}


static void iagno_show_message (Iagno* self, const gchar* message) {
	GtkStatusbar* _tmp0_;
	guint _tmp1_;
	GtkStatusbar* _tmp2_;
	guint _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->statusbar;
	_tmp1_ = self->priv->statusbar_id;
	gtk_statusbar_pop (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->statusbar;
	_tmp3_ = self->priv->statusbar_id;
	_tmp4_ = message;
	gtk_statusbar_push (_tmp2_, _tmp3_, _tmp4_);
}


static void iagno_help_cb (Iagno* self, GtkAction* action) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		GtkWindow* _tmp0_;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:iagno", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("iagno.vala:344: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gboolean _iagno_computer_move_cb_gsource_func (gpointer self) {
	gboolean result;
	result = iagno_computer_move_cb (self);
	return result;
}


static void iagno_game_move_cb (Iagno* self) {
	Game* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	Game* _tmp6_;
	Player _tmp7_;
	gboolean _tmp9_;
	gboolean _tmp15_;
	g_return_if_fail (self != NULL);
	iagno_play_sound (self, "flip-piece");
	_tmp0_ = self->priv->game;
	_tmp1_ = game_get_can_move (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		Game* _tmp3_;
		self->priv->was_pass = TRUE;
		_tmp3_ = self->priv->game;
		game_pass (_tmp3_);
		return;
	}
	iagno_update_ui (self);
	self->priv->was_pass = FALSE;
	_tmp6_ = self->priv->game;
	_tmp7_ = _tmp6_->current_color;
	if (_tmp7_ == PLAYER_LIGHT) {
		ComputerPlayer* _tmp8_;
		_tmp8_ = self->priv->light_computer;
		_tmp5_ = _tmp8_ != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp9_ = _tmp5_;
	if (_tmp9_) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp10_ = FALSE;
		Game* _tmp11_;
		Player _tmp12_;
		gboolean _tmp14_;
		_tmp11_ = self->priv->game;
		_tmp12_ = _tmp11_->current_color;
		if (_tmp12_ == PLAYER_DARK) {
			ComputerPlayer* _tmp13_;
			_tmp13_ = self->priv->dark_computer;
			_tmp10_ = _tmp13_ != NULL;
		} else {
			_tmp10_ = FALSE;
		}
		_tmp14_ = _tmp10_;
		_tmp4_ = _tmp14_;
	}
	_tmp15_ = _tmp4_;
	if (_tmp15_) {
		guint _tmp16_ = 0U;
		_tmp16_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _iagno_computer_move_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->computer_timer = _tmp16_;
	}
}


static gboolean iagno_computer_move_cb (Iagno* self) {
	gboolean result = FALSE;
	Game* _tmp0_;
	Player _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->current_color;
	if (_tmp1_ == PLAYER_LIGHT) {
		ComputerPlayer* _tmp2_;
		_tmp2_ = self->priv->light_computer;
		computer_player_move (_tmp2_);
	} else {
		ComputerPlayer* _tmp3_;
		_tmp3_ = self->priv->dark_computer;
		computer_player_move (_tmp3_);
	}
	self->priv->computer_timer = (guint) 0;
	result = FALSE;
	return result;
}


static void iagno_game_complete_cb (Iagno* self) {
	Game* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Game* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Game* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	Game* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	Game* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	Game* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = game_get_n_light_tiles (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->game;
	_tmp4_ = game_get_n_dark_tiles (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp2_ > _tmp5_) {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = _ ("Light player wins!");
		iagno_show_message (self, _tmp6_);
	}
	_tmp7_ = self->priv->game;
	_tmp8_ = game_get_n_dark_tiles (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->game;
	_tmp11_ = game_get_n_light_tiles (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp9_ > _tmp12_) {
		const gchar* _tmp13_ = NULL;
		_tmp13_ = _ ("Dark player wins!");
		iagno_show_message (self, _tmp13_);
	}
	_tmp14_ = self->priv->game;
	_tmp15_ = game_get_n_light_tiles (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->game;
	_tmp18_ = game_get_n_dark_tiles (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp16_ == _tmp19_) {
		const gchar* _tmp20_ = NULL;
		_tmp20_ = _ ("The game was a draw.");
		iagno_show_message (self, _tmp20_);
	}
	iagno_play_sound (self, "gameover");
}


static void iagno_play_sound (Iagno* self, const gchar* name) {
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GameView* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "sound");
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->view;
	_tmp3_ = name;
	_tmp4_ = name;
	_tmp5_ = g_strdup_printf ("%s.ogg", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_build_filename (SOUND_DIRECTORY, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	ca_gtk_play_for_widget ((GtkWidget*) _tmp2_, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp3_, CA_PROP_MEDIA_FILENAME, _tmp8_, NULL);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
}


static void iagno_player_move_cb (Iagno* self, gint x, gint y) {
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_;
	Player _tmp2_;
	gboolean _tmp5_;
	gboolean _tmp6_ = FALSE;
	Game* _tmp7_;
	Player _tmp8_;
	gboolean _tmp11_;
	Game* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game;
	_tmp2_ = _tmp1_->current_color;
	if (_tmp2_ == PLAYER_LIGHT) {
		GSettings* _tmp3_;
		gint _tmp4_ = 0;
		_tmp3_ = self->priv->settings;
		_tmp4_ = g_settings_get_int (_tmp3_, "white-level");
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		return;
	}
	_tmp7_ = self->priv->game;
	_tmp8_ = _tmp7_->current_color;
	if (_tmp8_ == PLAYER_DARK) {
		GSettings* _tmp9_;
		gint _tmp10_ = 0;
		_tmp9_ = self->priv->settings;
		_tmp10_ = g_settings_get_int (_tmp9_, "black-level");
		_tmp6_ = _tmp10_ > 0;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp11_ = _tmp6_;
	if (_tmp11_) {
		return;
	}
	_tmp12_ = self->priv->game;
	_tmp13_ = x;
	_tmp14_ = y;
	_tmp15_ = game_place_tile (_tmp12_, _tmp13_, _tmp14_);
	if (_tmp15_ == 0) {
		const gchar* _tmp16_ = NULL;
		_tmp16_ = _ ("Invalid move.");
		iagno_show_message (self, _tmp16_);
	}
}


static void iagno_dark_human_cb (Iagno* self, GtkToggleButton* widget) {
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	if (_tmp1_) {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->settings;
		g_settings_set_int (_tmp2_, "black-level", 0);
	}
}


static void iagno_dark_level_one_cb (Iagno* self, GtkToggleButton* widget) {
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	if (_tmp1_) {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->settings;
		g_settings_set_int (_tmp2_, "black-level", 1);
	}
}


static void iagno_dark_level_two_cb (Iagno* self, GtkToggleButton* widget) {
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	if (_tmp1_) {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->settings;
		g_settings_set_int (_tmp2_, "black-level", 2);
	}
}


static void iagno_dark_level_three_cb (Iagno* self, GtkToggleButton* widget) {
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	if (_tmp1_) {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->settings;
		g_settings_set_int (_tmp2_, "black-level", 3);
	}
}


static void iagno_light_human_cb (Iagno* self, GtkToggleButton* widget) {
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	if (_tmp1_) {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->settings;
		g_settings_set_int (_tmp2_, "white-level", 0);
	}
}


static void iagno_light_level_one_cb (Iagno* self, GtkToggleButton* widget) {
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	if (_tmp1_) {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->settings;
		g_settings_set_int (_tmp2_, "white-level", 1);
	}
}


static void iagno_light_level_two_cb (Iagno* self, GtkToggleButton* widget) {
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	if (_tmp1_) {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->settings;
		g_settings_set_int (_tmp2_, "white-level", 2);
	}
}


static void iagno_light_level_three_cb (Iagno* self, GtkToggleButton* widget) {
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	if (_tmp1_) {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->settings;
		g_settings_set_int (_tmp2_, "white-level", 3);
	}
}


static void iagno_sound_select (Iagno* self, GtkToggleButton* widget) {
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean play_sounds;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	play_sounds = _tmp1_;
	_tmp2_ = self->priv->settings;
	g_settings_set_boolean (_tmp2_, "sound", play_sounds);
}


static void iagno_grid_toggled_cb (Iagno* self, GtkToggleButton* widget) {
	GameView* _tmp0_;
	GtkToggleButton* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GSettings* _tmp3_;
	GameView* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = widget;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	game_view_set_show_grid (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->settings;
	_tmp4_ = self->priv->view;
	_tmp5_ = game_view_get_show_grid (_tmp4_);
	_tmp6_ = _tmp5_;
	g_settings_set_boolean (_tmp3_, "show-grid", _tmp6_);
}


static void iagno_flip_final_toggled_cb (Iagno* self, GtkToggleButton* widget) {
	GameView* _tmp0_;
	GtkToggleButton* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GSettings* _tmp3_;
	GameView* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = widget;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	game_view_set_flip_final_result (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->settings;
	_tmp4_ = self->priv->view;
	_tmp5_ = game_view_get_flip_final_result (_tmp4_);
	_tmp6_ = _tmp5_;
	g_settings_set_boolean (_tmp3_, "flip-final-results", _tmp6_);
}


static void iagno_propbox_response_cb (Iagno* self, GtkWidget* widget, gint response_id) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	gtk_widget_hide (_tmp0_);
}


static gboolean iagno_propbox_close_cb (Iagno* self, GtkWidget* widget, GdkEventAny* event) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = widget;
	gtk_widget_hide (_tmp0_);
	result = TRUE;
	return result;
}


static void iagno_theme_changed_cb (Iagno* self, GtkComboBox* widget) {
	GamesFileList* _tmp0_;
	GtkComboBox* _tmp1_;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* tile_set;
	GSettings* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GamesPreimage* _tmp8_ = NULL;
	GamesPreimage* theme;
	GamesPreimage* _tmp9_;
	GameView* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->theme_file_list;
	_tmp1_ = widget;
	_tmp2_ = gtk_combo_box_get_active (_tmp1_);
	_tmp3_ = games_file_list_get_nth (_tmp0_, _tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	tile_set = _tmp4_;
	_tmp5_ = self->priv->settings;
	_tmp6_ = tile_set;
	g_settings_set_string (_tmp5_, "tileset", _tmp6_);
	_tmp7_ = tile_set;
	_tmp8_ = iagno_load_theme_texture (self, _tmp7_, FALSE);
	theme = _tmp8_;
	_tmp9_ = theme;
	if (_tmp9_ == NULL) {
		const gchar* _tmp10_;
		_tmp10_ = tile_set;
		g_warning ("iagno.vala:496: Unable to load theme %s", _tmp10_);
	} else {
		GameView* _tmp11_;
		GamesPreimage* _tmp12_;
		_tmp11_ = self->priv->view;
		_tmp12_ = theme;
		game_view_set_theme (_tmp11_, _tmp12_);
	}
	_tmp13_ = self->priv->view;
	game_view_redraw (_tmp13_);
	_g_object_unref0 (theme);
	_g_free0 (tile_set);
}


static void _iagno_propbox_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	iagno_propbox_response_cb (self, _sender, response_id);
}


static gboolean _iagno_propbox_close_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = iagno_propbox_close_cb (self, _sender, event);
	return result;
}


static void _iagno_sound_select_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_sound_select (self, _sender);
}


static void _iagno_dark_human_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_dark_human_cb (self, _sender);
}


static void _iagno_dark_level_one_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_dark_level_one_cb (self, _sender);
}


static void _iagno_dark_level_two_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_dark_level_two_cb (self, _sender);
}


static void _iagno_dark_level_three_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_dark_level_three_cb (self, _sender);
}


static void _iagno_light_human_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_light_human_cb (self, _sender);
}


static void _iagno_light_level_one_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_light_level_one_cb (self, _sender);
}


static void _iagno_light_level_two_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_light_level_two_cb (self, _sender);
}


static void _iagno_light_level_three_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_light_level_three_cb (self, _sender);
}


static void _iagno_grid_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_grid_toggled_cb (self, _sender);
}


static void _iagno_flip_final_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_flip_final_toggled_cb (self, _sender);
}


static void _iagno_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	iagno_theme_changed_cb (self, _sender);
}


static void iagno_show_properties_dialog (Iagno* self) {
	const gchar* _tmp0_ = NULL;
	GtkWindow* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* propbox;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GtkBox* _tmp6_ = NULL;
	GtkBox* _tmp7_;
	GtkBox* box;
	GtkBox* _tmp8_;
	GtkDialog* _tmp9_;
	GtkDialog* _tmp10_;
	GtkDialog* _tmp11_;
	GtkNotebook* _tmp12_;
	GtkNotebook* _tmp13_;
	GtkNotebook* notebook;
	GtkNotebook* _tmp14_;
	GtkBox* _tmp15_;
	GtkNotebook* _tmp16_;
	const gchar* _tmp17_ = NULL;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* label;
	GtkBox* _tmp20_;
	GtkBox* _tmp21_;
	GtkBox* vbox;
	GtkBox* _tmp22_;
	GtkNotebook* _tmp23_;
	GtkBox* _tmp24_;
	GtkLabel* _tmp25_;
	GtkGrid* _tmp26_;
	GtkGrid* _tmp27_;
	GtkGrid* grid;
	GtkGrid* _tmp28_;
	GtkBox* _tmp29_;
	GtkGrid* _tmp30_;
	GtkBox* _tmp31_;
	GtkBox* _tmp32_;
	GtkBox* vbox2;
	GtkBox* _tmp33_;
	GtkBox* _tmp34_;
	const gchar* _tmp35_ = NULL;
	GtkCheckButton* _tmp36_;
	GtkCheckButton* _tmp37_;
	GtkCheckButton* enable_sounds_button;
	GtkCheckButton* _tmp38_;
	GSettings* _tmp39_;
	gboolean _tmp40_ = FALSE;
	GtkCheckButton* _tmp41_;
	GtkBox* _tmp42_;
	GtkCheckButton* _tmp43_;
	const gchar* _tmp44_ = NULL;
	GamesFrame* _tmp45_;
	GamesFrame* _tmp46_;
	GamesFrame* frame;
	GtkGrid* _tmp47_;
	GamesFrame* _tmp48_;
	GtkBox* _tmp49_;
	GtkBox* _tmp50_;
	GamesFrame* _tmp51_;
	GtkBox* _tmp52_;
	const gchar* _tmp53_ = NULL;
	GtkRadioButton* _tmp54_;
	GtkRadioButton* _tmp55_;
	GtkRadioButton* computer_button;
	GSettings* _tmp56_;
	gint _tmp57_ = 0;
	GtkRadioButton* _tmp59_;
	GtkBox* _tmp60_;
	GtkRadioButton* _tmp61_;
	GtkRadioButton* _tmp62_;
	GSList* _tmp63_ = NULL;
	const gchar* _tmp64_ = NULL;
	GtkRadioButton* _tmp65_;
	GtkRadioButton* _tmp66_;
	GSettings* _tmp67_;
	gint _tmp68_ = 0;
	GtkRadioButton* _tmp70_;
	GtkBox* _tmp71_;
	GtkRadioButton* _tmp72_;
	GtkRadioButton* _tmp73_;
	GSList* _tmp74_ = NULL;
	const gchar* _tmp75_ = NULL;
	GtkRadioButton* _tmp76_;
	GtkRadioButton* _tmp77_;
	GSettings* _tmp78_;
	gint _tmp79_ = 0;
	GtkRadioButton* _tmp81_;
	GtkBox* _tmp82_;
	GtkRadioButton* _tmp83_;
	GtkRadioButton* _tmp84_;
	GSList* _tmp85_ = NULL;
	const gchar* _tmp86_ = NULL;
	GtkRadioButton* _tmp87_;
	GtkRadioButton* _tmp88_;
	GSettings* _tmp89_;
	gint _tmp90_ = 0;
	GtkRadioButton* _tmp92_;
	GtkBox* _tmp93_;
	GtkRadioButton* _tmp94_;
	const gchar* _tmp95_ = NULL;
	GamesFrame* _tmp96_;
	GamesFrame* _tmp97_;
	GtkGrid* _tmp98_;
	GamesFrame* _tmp99_;
	GtkBox* _tmp100_;
	GtkBox* _tmp101_;
	GamesFrame* _tmp102_;
	GtkBox* _tmp103_;
	const gchar* _tmp104_ = NULL;
	GtkRadioButton* _tmp105_;
	GtkRadioButton* _tmp106_;
	GSettings* _tmp107_;
	gint _tmp108_ = 0;
	GtkRadioButton* _tmp110_;
	GtkBox* _tmp111_;
	GtkRadioButton* _tmp112_;
	GtkRadioButton* _tmp113_;
	GSList* _tmp114_ = NULL;
	const gchar* _tmp115_ = NULL;
	GtkRadioButton* _tmp116_;
	GtkRadioButton* _tmp117_;
	GSettings* _tmp118_;
	gint _tmp119_ = 0;
	GtkRadioButton* _tmp121_;
	GtkBox* _tmp122_;
	GtkRadioButton* _tmp123_;
	GtkRadioButton* _tmp124_;
	GSList* _tmp125_ = NULL;
	const gchar* _tmp126_ = NULL;
	GtkRadioButton* _tmp127_;
	GtkRadioButton* _tmp128_;
	GSettings* _tmp129_;
	gint _tmp130_ = 0;
	GtkRadioButton* _tmp132_;
	GtkBox* _tmp133_;
	GtkRadioButton* _tmp134_;
	GtkRadioButton* _tmp135_;
	GSList* _tmp136_ = NULL;
	const gchar* _tmp137_ = NULL;
	GtkRadioButton* _tmp138_;
	GtkRadioButton* _tmp139_;
	GSettings* _tmp140_;
	gint _tmp141_ = 0;
	GtkRadioButton* _tmp143_;
	GtkBox* _tmp144_;
	GtkRadioButton* _tmp145_;
	const gchar* _tmp146_ = NULL;
	GtkLabel* _tmp147_;
	GtkLabel* _tmp148_;
	GtkGrid* _tmp149_;
	GtkGrid* _tmp150_;
	GtkGrid* _tmp151_;
	GtkGrid* _tmp152_;
	GtkNotebook* _tmp153_;
	GtkGrid* _tmp154_;
	GtkLabel* _tmp155_;
	const gchar* _tmp156_ = NULL;
	GamesFrame* _tmp157_;
	GamesFrame* _tmp158_;
	GtkGrid* _tmp159_;
	GamesFrame* _tmp160_;
	GtkBox* _tmp161_;
	GtkBox* _tmp162_;
	GamesFrame* _tmp163_;
	GtkBox* _tmp164_;
	const gchar* _tmp165_ = NULL;
	GtkCheckButton* _tmp166_;
	GtkCheckButton* _tmp167_;
	GtkCheckButton* grid_button;
	GSettings* _tmp168_;
	gboolean _tmp169_ = FALSE;
	GtkBox* _tmp170_;
	const gchar* _tmp171_ = NULL;
	GtkCheckButton* _tmp172_;
	GtkCheckButton* _tmp173_;
	GtkCheckButton* flip_final_button;
	GSettings* _tmp174_;
	gboolean _tmp175_ = FALSE;
	GtkBox* _tmp176_;
	GtkBox* _tmp177_;
	GtkBox* _tmp178_;
	GtkBox* hbox;
	GtkBox* _tmp179_;
	const gchar* _tmp180_ = NULL;
	GtkLabel* _tmp181_;
	GtkLabel* _tmp182_;
	GtkLabel* _tmp183_;
	gchar* _tmp184_ = NULL;
	gchar* _tmp185_;
	GamesFileList* _tmp186_;
	GamesFileList* _tmp187_;
	GamesFileList* _tmp188_;
	GSettings* _tmp189_;
	gchar* _tmp190_ = NULL;
	gchar* _tmp191_;
	GtkWidget* _tmp192_ = NULL;
	GtkComboBox* _tmp193_;
	GtkComboBox* theme_combo;
	GtkLabel* _tmp194_;
	GtkDialog* _tmp195_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Iagno Preferences");
	_tmp1_ = self->priv->window;
	_tmp2_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, _tmp1_, 0, GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, NULL, NULL);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	propbox = _tmp3_;
	_tmp4_ = propbox;
	gtk_container_set_border_width ((GtkContainer*) _tmp4_, (guint) 5);
	_tmp5_ = propbox;
	_tmp6_ = gtk_dialog_get_content_area (_tmp5_);
	_tmp7_ = _g_object_ref0 (GTK_BOX (_tmp6_));
	box = _tmp7_;
	_tmp8_ = box;
	gtk_box_set_spacing (_tmp8_, 2);
	_tmp9_ = propbox;
	gtk_window_set_resizable ((GtkWindow*) _tmp9_, FALSE);
	_tmp10_ = propbox;
	g_signal_connect_object (_tmp10_, "response", (GCallback) _iagno_propbox_response_cb_gtk_dialog_response, self, 0);
	_tmp11_ = propbox;
	g_signal_connect_object ((GtkWidget*) _tmp11_, "delete-event", (GCallback) _iagno_propbox_close_cb_gtk_widget_delete_event, self, 0);
	_tmp12_ = (GtkNotebook*) gtk_notebook_new ();
	_tmp13_ = g_object_ref_sink (_tmp12_);
	notebook = _tmp13_;
	_tmp14_ = notebook;
	gtk_container_set_border_width ((GtkContainer*) _tmp14_, (guint) 5);
	_tmp15_ = box;
	_tmp16_ = notebook;
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = _ ("Game");
	_tmp18_ = (GtkLabel*) gtk_label_new (_tmp17_);
	_tmp19_ = g_object_ref_sink (_tmp18_);
	label = _tmp19_;
	_tmp20_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 18);
	_tmp21_ = g_object_ref_sink (_tmp20_);
	vbox = _tmp21_;
	_tmp22_ = vbox;
	gtk_container_set_border_width ((GtkContainer*) _tmp22_, (guint) 12);
	_tmp23_ = notebook;
	_tmp24_ = vbox;
	_tmp25_ = label;
	gtk_notebook_append_page (_tmp23_, (GtkWidget*) _tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = (GtkGrid*) gtk_grid_new ();
	_tmp27_ = g_object_ref_sink (_tmp26_);
	grid = _tmp27_;
	_tmp28_ = grid;
	gtk_grid_set_column_spacing (_tmp28_, (guint) 18);
	_tmp29_ = vbox;
	_tmp30_ = grid;
	gtk_box_pack_start (_tmp29_, (GtkWidget*) _tmp30_, FALSE, FALSE, (guint) 0);
	_tmp31_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	_tmp32_ = g_object_ref_sink (_tmp31_);
	vbox2 = _tmp32_;
	_tmp33_ = vbox;
	_tmp34_ = vbox2;
	gtk_box_pack_start (_tmp33_, (GtkWidget*) _tmp34_, FALSE, FALSE, (guint) 0);
	_tmp35_ = _ ("E_nable sounds");
	_tmp36_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp35_);
	_tmp37_ = g_object_ref_sink (_tmp36_);
	enable_sounds_button = _tmp37_;
	_tmp38_ = enable_sounds_button;
	_tmp39_ = self->priv->settings;
	_tmp40_ = g_settings_get_boolean (_tmp39_, "sound");
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp38_, _tmp40_);
	_tmp41_ = enable_sounds_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp41_, "toggled", (GCallback) _iagno_sound_select_gtk_toggle_button_toggled, self, 0);
	_tmp42_ = vbox2;
	_tmp43_ = enable_sounds_button;
	gtk_box_pack_start (_tmp42_, (GtkWidget*) _tmp43_, FALSE, FALSE, (guint) 0);
	_tmp44_ = _ ("Dark");
	_tmp45_ = games_frame_new (_tmp44_);
	_tmp46_ = g_object_ref_sink (_tmp45_);
	frame = _tmp46_;
	_tmp47_ = grid;
	_tmp48_ = frame;
	gtk_grid_attach (_tmp47_, (GtkWidget*) _tmp48_, 0, 0, 1, 1);
	_tmp49_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	_tmp50_ = g_object_ref_sink (_tmp49_);
	_g_object_unref0 (vbox);
	vbox = _tmp50_;
	_tmp51_ = frame;
	_tmp52_ = vbox;
	gtk_container_add ((GtkContainer*) _tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = _ ("Human");
	_tmp54_ = (GtkRadioButton*) gtk_radio_button_new_with_label (NULL, _tmp53_);
	_tmp55_ = g_object_ref_sink (_tmp54_);
	computer_button = _tmp55_;
	_tmp56_ = self->priv->settings;
	_tmp57_ = g_settings_get_int (_tmp56_, "black-level");
	if (_tmp57_ == 0) {
		GtkRadioButton* _tmp58_;
		_tmp58_ = computer_button;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp58_, TRUE);
	}
	_tmp59_ = computer_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp59_, "toggled", (GCallback) _iagno_dark_human_cb_gtk_toggle_button_toggled, self, 0);
	_tmp60_ = vbox;
	_tmp61_ = computer_button;
	gtk_box_pack_start (_tmp60_, (GtkWidget*) _tmp61_, FALSE, FALSE, (guint) 0);
	_tmp62_ = computer_button;
	_tmp63_ = gtk_radio_button_get_group (_tmp62_);
	_tmp64_ = _ ("Level one");
	_tmp65_ = (GtkRadioButton*) gtk_radio_button_new_with_label (_tmp63_, _tmp64_);
	_tmp66_ = g_object_ref_sink (_tmp65_);
	_g_object_unref0 (computer_button);
	computer_button = _tmp66_;
	_tmp67_ = self->priv->settings;
	_tmp68_ = g_settings_get_int (_tmp67_, "black-level");
	if (_tmp68_ == 1) {
		GtkRadioButton* _tmp69_;
		_tmp69_ = computer_button;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp69_, TRUE);
	}
	_tmp70_ = computer_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp70_, "toggled", (GCallback) _iagno_dark_level_one_cb_gtk_toggle_button_toggled, self, 0);
	_tmp71_ = vbox;
	_tmp72_ = computer_button;
	gtk_box_pack_start (_tmp71_, (GtkWidget*) _tmp72_, FALSE, FALSE, (guint) 0);
	_tmp73_ = computer_button;
	_tmp74_ = gtk_radio_button_get_group (_tmp73_);
	_tmp75_ = _ ("Level two");
	_tmp76_ = (GtkRadioButton*) gtk_radio_button_new_with_label (_tmp74_, _tmp75_);
	_tmp77_ = g_object_ref_sink (_tmp76_);
	_g_object_unref0 (computer_button);
	computer_button = _tmp77_;
	_tmp78_ = self->priv->settings;
	_tmp79_ = g_settings_get_int (_tmp78_, "black-level");
	if (_tmp79_ == 2) {
		GtkRadioButton* _tmp80_;
		_tmp80_ = computer_button;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp80_, TRUE);
	}
	_tmp81_ = computer_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp81_, "toggled", (GCallback) _iagno_dark_level_two_cb_gtk_toggle_button_toggled, self, 0);
	_tmp82_ = vbox;
	_tmp83_ = computer_button;
	gtk_box_pack_start (_tmp82_, (GtkWidget*) _tmp83_, FALSE, FALSE, (guint) 0);
	_tmp84_ = computer_button;
	_tmp85_ = gtk_radio_button_get_group (_tmp84_);
	_tmp86_ = _ ("Level three");
	_tmp87_ = (GtkRadioButton*) gtk_radio_button_new_with_label (_tmp85_, _tmp86_);
	_tmp88_ = g_object_ref_sink (_tmp87_);
	_g_object_unref0 (computer_button);
	computer_button = _tmp88_;
	_tmp89_ = self->priv->settings;
	_tmp90_ = g_settings_get_int (_tmp89_, "black-level");
	if (_tmp90_ == 3) {
		GtkRadioButton* _tmp91_;
		_tmp91_ = computer_button;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp91_, TRUE);
	}
	_tmp92_ = computer_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp92_, "toggled", (GCallback) _iagno_dark_level_three_cb_gtk_toggle_button_toggled, self, 0);
	_tmp93_ = vbox;
	_tmp94_ = computer_button;
	gtk_box_pack_start (_tmp93_, (GtkWidget*) _tmp94_, FALSE, FALSE, (guint) 0);
	_tmp95_ = _ ("Light");
	_tmp96_ = games_frame_new (_tmp95_);
	_tmp97_ = g_object_ref_sink (_tmp96_);
	_g_object_unref0 (frame);
	frame = _tmp97_;
	_tmp98_ = grid;
	_tmp99_ = frame;
	gtk_grid_attach (_tmp98_, (GtkWidget*) _tmp99_, 1, 0, 1, 1);
	_tmp100_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	_tmp101_ = g_object_ref_sink (_tmp100_);
	_g_object_unref0 (vbox);
	vbox = _tmp101_;
	_tmp102_ = frame;
	_tmp103_ = vbox;
	gtk_container_add ((GtkContainer*) _tmp102_, (GtkWidget*) _tmp103_);
	_tmp104_ = _ ("Human");
	_tmp105_ = (GtkRadioButton*) gtk_radio_button_new_with_label (NULL, _tmp104_);
	_tmp106_ = g_object_ref_sink (_tmp105_);
	_g_object_unref0 (computer_button);
	computer_button = _tmp106_;
	_tmp107_ = self->priv->settings;
	_tmp108_ = g_settings_get_int (_tmp107_, "white-level");
	if (_tmp108_ == 0) {
		GtkRadioButton* _tmp109_;
		_tmp109_ = computer_button;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp109_, TRUE);
	}
	_tmp110_ = computer_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp110_, "toggled", (GCallback) _iagno_light_human_cb_gtk_toggle_button_toggled, self, 0);
	_tmp111_ = vbox;
	_tmp112_ = computer_button;
	gtk_box_pack_start (_tmp111_, (GtkWidget*) _tmp112_, FALSE, FALSE, (guint) 0);
	_tmp113_ = computer_button;
	_tmp114_ = gtk_radio_button_get_group (_tmp113_);
	_tmp115_ = _ ("Level one");
	_tmp116_ = (GtkRadioButton*) gtk_radio_button_new_with_label (_tmp114_, _tmp115_);
	_tmp117_ = g_object_ref_sink (_tmp116_);
	_g_object_unref0 (computer_button);
	computer_button = _tmp117_;
	_tmp118_ = self->priv->settings;
	_tmp119_ = g_settings_get_int (_tmp118_, "white-level");
	if (_tmp119_ == 1) {
		GtkRadioButton* _tmp120_;
		_tmp120_ = computer_button;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp120_, TRUE);
	}
	_tmp121_ = computer_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp121_, "toggled", (GCallback) _iagno_light_level_one_cb_gtk_toggle_button_toggled, self, 0);
	_tmp122_ = vbox;
	_tmp123_ = computer_button;
	gtk_box_pack_start (_tmp122_, (GtkWidget*) _tmp123_, FALSE, FALSE, (guint) 0);
	_tmp124_ = computer_button;
	_tmp125_ = gtk_radio_button_get_group (_tmp124_);
	_tmp126_ = _ ("Level two");
	_tmp127_ = (GtkRadioButton*) gtk_radio_button_new_with_label (_tmp125_, _tmp126_);
	_tmp128_ = g_object_ref_sink (_tmp127_);
	_g_object_unref0 (computer_button);
	computer_button = _tmp128_;
	_tmp129_ = self->priv->settings;
	_tmp130_ = g_settings_get_int (_tmp129_, "white-level");
	if (_tmp130_ == 2) {
		GtkRadioButton* _tmp131_;
		_tmp131_ = computer_button;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp131_, TRUE);
	}
	_tmp132_ = computer_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp132_, "toggled", (GCallback) _iagno_light_level_two_cb_gtk_toggle_button_toggled, self, 0);
	_tmp133_ = vbox;
	_tmp134_ = computer_button;
	gtk_box_pack_start (_tmp133_, (GtkWidget*) _tmp134_, FALSE, FALSE, (guint) 0);
	_tmp135_ = computer_button;
	_tmp136_ = gtk_radio_button_get_group (_tmp135_);
	_tmp137_ = _ ("Level three");
	_tmp138_ = (GtkRadioButton*) gtk_radio_button_new_with_label (_tmp136_, _tmp137_);
	_tmp139_ = g_object_ref_sink (_tmp138_);
	_g_object_unref0 (computer_button);
	computer_button = _tmp139_;
	_tmp140_ = self->priv->settings;
	_tmp141_ = g_settings_get_int (_tmp140_, "white-level");
	if (_tmp141_ == 3) {
		GtkRadioButton* _tmp142_;
		_tmp142_ = computer_button;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp142_, TRUE);
	}
	_tmp143_ = computer_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp143_, "toggled", (GCallback) _iagno_light_level_three_cb_gtk_toggle_button_toggled, self, 0);
	_tmp144_ = vbox;
	_tmp145_ = computer_button;
	gtk_box_pack_start (_tmp144_, (GtkWidget*) _tmp145_, FALSE, FALSE, (guint) 0);
	_tmp146_ = _ ("Appearance");
	_tmp147_ = (GtkLabel*) gtk_label_new (_tmp146_);
	_tmp148_ = g_object_ref_sink (_tmp147_);
	_g_object_unref0 (label);
	label = _tmp148_;
	_tmp149_ = (GtkGrid*) gtk_grid_new ();
	_tmp150_ = g_object_ref_sink (_tmp149_);
	_g_object_unref0 (grid);
	grid = _tmp150_;
	_tmp151_ = grid;
	gtk_grid_set_column_spacing (_tmp151_, (guint) 18);
	_tmp152_ = grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp152_, (guint) 12);
	_tmp153_ = notebook;
	_tmp154_ = grid;
	_tmp155_ = label;
	gtk_notebook_append_page (_tmp153_, (GtkWidget*) _tmp154_, (GtkWidget*) _tmp155_);
	_tmp156_ = _ ("Options");
	_tmp157_ = games_frame_new (_tmp156_);
	_tmp158_ = g_object_ref_sink (_tmp157_);
	_g_object_unref0 (frame);
	frame = _tmp158_;
	_tmp159_ = grid;
	_tmp160_ = frame;
	gtk_grid_attach (_tmp159_, (GtkWidget*) _tmp160_, 0, 0, 1, 1);
	_tmp161_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	_tmp162_ = g_object_ref_sink (_tmp161_);
	_g_object_unref0 (vbox);
	vbox = _tmp162_;
	_tmp163_ = frame;
	_tmp164_ = vbox;
	gtk_container_add ((GtkContainer*) _tmp163_, (GtkWidget*) _tmp164_);
	_tmp165_ = _ ("S_how grid");
	_tmp166_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp165_);
	_tmp167_ = g_object_ref_sink (_tmp166_);
	grid_button = _tmp167_;
	_tmp168_ = self->priv->settings;
	_tmp169_ = g_settings_get_boolean (_tmp168_, "show-grid");
	gtk_toggle_button_set_active ((GtkToggleButton*) grid_button, _tmp169_);
	g_signal_connect_object ((GtkToggleButton*) grid_button, "toggled", (GCallback) _iagno_grid_toggled_cb_gtk_toggle_button_toggled, self, 0);
	_tmp170_ = vbox;
	gtk_box_pack_start (_tmp170_, (GtkWidget*) grid_button, FALSE, FALSE, (guint) 0);
	_tmp171_ = _ ("_Flip final results");
	_tmp172_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp171_);
	_tmp173_ = g_object_ref_sink (_tmp172_);
	flip_final_button = _tmp173_;
	_tmp174_ = self->priv->settings;
	_tmp175_ = g_settings_get_boolean (_tmp174_, "flip-final-results");
	gtk_toggle_button_set_active ((GtkToggleButton*) flip_final_button, _tmp175_);
	g_signal_connect_object ((GtkToggleButton*) flip_final_button, "toggled", (GCallback) _iagno_flip_final_toggled_cb_gtk_toggle_button_toggled, self, 0);
	_tmp176_ = vbox;
	gtk_box_pack_start (_tmp176_, (GtkWidget*) flip_final_button, FALSE, FALSE, (guint) 0);
	_tmp177_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	_tmp178_ = g_object_ref_sink (_tmp177_);
	hbox = _tmp178_;
	_tmp179_ = vbox;
	gtk_box_pack_start (_tmp179_, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
	_tmp180_ = _ ("_Tile set:");
	_tmp181_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp180_);
	_tmp182_ = g_object_ref_sink (_tmp181_);
	_g_object_unref0 (label);
	label = _tmp182_;
	_tmp183_ = label;
	gtk_box_pack_start (hbox, (GtkWidget*) _tmp183_, FALSE, FALSE, (guint) 0);
	_tmp184_ = g_build_filename (DATA_DIRECTORY, "themes", NULL);
	_tmp185_ = _tmp184_;
	_tmp186_ = games_file_list_new_images (_tmp185_, NULL, NULL);
	_g_object_unref0 (self->priv->theme_file_list);
	self->priv->theme_file_list = _tmp186_;
	_g_free0 (_tmp185_);
	_tmp187_ = self->priv->theme_file_list;
	games_file_list_transform_basename (_tmp187_);
	_tmp188_ = self->priv->theme_file_list;
	_tmp189_ = self->priv->settings;
	_tmp190_ = g_settings_get_string (_tmp189_, "tileset");
	_tmp191_ = _tmp190_;
	_tmp192_ = games_file_list_create_widget (_tmp188_, _tmp191_, (guint) (GAMES_FILE_LIST_REMOVE_EXTENSION | GAMES_FILE_LIST_REPLACE_UNDERSCORES));
	_tmp193_ = GTK_COMBO_BOX (_tmp192_);
	_g_free0 (_tmp191_);
	theme_combo = _tmp193_;
	_tmp194_ = label;
	gtk_label_set_mnemonic_widget (_tmp194_, (GtkWidget*) theme_combo);
	g_signal_connect_object (theme_combo, "changed", (GCallback) _iagno_theme_changed_cb_gtk_combo_box_changed, self, 0);
	gtk_box_pack_start (hbox, (GtkWidget*) theme_combo, TRUE, TRUE, (guint) 0);
	_tmp195_ = propbox;
	gtk_widget_show_all ((GtkWidget*) _tmp195_);
	_g_object_unref0 (theme_combo);
	_g_object_unref0 (hbox);
	_g_object_unref0 (flip_final_button);
	_g_object_unref0 (grid_button);
	_g_object_unref0 (computer_button);
	_g_object_unref0 (frame);
	_g_object_unref0 (enable_sounds_button);
	_g_object_unref0 (vbox2);
	_g_object_unref0 (grid);
	_g_object_unref0 (vbox);
	_g_object_unref0 (label);
	_g_object_unref0 (notebook);
	_g_object_unref0 (box);
	_g_object_unref0 (propbox);
}


gint iagno_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* _tmp0_;
	GOptionContext* context;
	GOptionContext* _tmp1_;
	GOptionContext* _tmp2_;
	GOptionGroup* _tmp3_ = NULL;
	const gchar* _tmp8_ = NULL;
	Iagno* _tmp9_;
	Iagno* app;
	Iagno* _tmp10_;
	gint _tmp11_ = 0;
	gint _result_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new ("");
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_set_translation_domain (_tmp1_, GETTEXT_PACKAGE);
	_tmp2_ = context;
	_tmp3_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp2_, _tmp3_);
	{
		GOptionContext* _tmp4_;
		_tmp4_ = context;
		g_option_context_parse (_tmp4_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp8_ = _ ("Iagno");
	g_set_application_name (_tmp8_);
	games_stock_init ();
	gtk_window_set_default_icon_name ("iagno");
	_tmp9_ = iagno_new ();
	app = _tmp9_;
	_tmp10_ = app;
	_tmp11_ = g_application_run ((GApplication*) _tmp10_, 0, NULL);
	_result_ = _tmp11_;
	result = _result_;
	_g_object_unref0 (app);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return iagno_main (argv, argc);
}


static void iagno_class_init (IagnoClass * klass) {
	iagno_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IagnoPrivate));
	G_APPLICATION_CLASS (klass)->startup = iagno_real_startup;
	G_APPLICATION_CLASS (klass)->activate = iagno_real_activate;
	G_OBJECT_CLASS (klass)->finalize = iagno_finalize;
}


static void iagno_instance_init (Iagno * self) {
	gchar* _tmp0_;
	self->priv = IAGNO_GET_PRIVATE (self);
	self->priv->light_computer = NULL;
	self->priv->dark_computer = NULL;
	self->priv->computer_timer = (guint) 0;
	self->priv->game = NULL;
	self->priv->was_pass = FALSE;
	self->priv->theme_file_list = NULL;
	_tmp0_ = g_strdup ("<ui>" "  <menubar name='MainMenu'>" "    <menu action='GameMenu'>" "      <menuitem action='NewGame'/>" "      <separator/>" "      <menuitem action='UndoMove'/>" "      <separator/>" "      <menuitem action='Quit'/>" "    </menu>" "    <menu action='SettingsMenu'>" "      <menuitem action='Preferences'/>" "    </menu>" "    <menu action='HelpMenu'>" "      <menuitem action='Contents'/>" "      <menuitem action='About'/>" "    </menu>" "  </menubar>" "</ui>");
	self->priv->ui_description = _tmp0_;
}


static void iagno_finalize (GObject* obj) {
	Iagno * self;
	self = IAGNO (obj);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->statusbar);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->dark_score_label);
	_g_object_unref0 (self->priv->light_score_label);
	_g_object_unref0 (self->priv->new_game_action);
	_g_object_unref0 (self->priv->undo_action);
	_computer_player_unref0 (self->priv->light_computer);
	_computer_player_unref0 (self->priv->dark_computer);
	_game_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->theme_file_list);
	_g_free0 (self->priv->ui_description);
	G_OBJECT_CLASS (iagno_parent_class)->finalize (obj);
}


GType iagno_get_type (void) {
	static volatile gsize iagno_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IagnoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) iagno_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Iagno), 0, (GInstanceInitFunc) iagno_instance_init, NULL };
		GType iagno_type_id;
		iagno_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Iagno", &g_define_type_info, 0);
		g_once_init_leave (&iagno_type_id__volatile, iagno_type_id);
	}
	return iagno_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



