/* chess-view-2d.c generated by valac 0.14.0, the Vala compiler
 * generated from chess-view-2d.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <math.h>
#include <float.h>
#include <librsvg/rsvg.h>
#include <config.h>
#include <stdio.h>
#include <librsvg/rsvg-cairo.h>


#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;
typedef struct _ChessViewPrivate ChessViewPrivate;

#define TYPE_CHESS_VIEW2_D (chess_view2_d_get_type ())
#define CHESS_VIEW2_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW2_D, ChessView2D))
#define CHESS_VIEW2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW2_D, ChessView2DClass))
#define IS_CHESS_VIEW2_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW2_D))
#define IS_CHESS_VIEW2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW2_D))
#define CHESS_VIEW2_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW2_D, ChessView2DClass))

typedef struct _ChessView2D ChessView2D;
typedef struct _ChessView2DClass ChessView2DClass;
typedef struct _ChessView2DPrivate ChessView2DPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
typedef struct _ChessModelPrivate ChessModelPrivate;

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;
#define _chess_model_unref0(var) ((var == NULL) ? NULL : (var = (chess_model_unref (var), NULL)))
#define _chess_piece_unref0(var) ((var == NULL) ? NULL : (var = (chess_piece_unref (var), NULL)))

#define TYPE_COLOR (color_get_type ())
typedef struct _ChessPiecePrivate ChessPiecePrivate;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_PIECE_TYPE (piece_type_get_type ())

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;

struct _ChessView {
	GtkDrawingArea parent_instance;
	ChessViewPrivate * priv;
};

struct _ChessViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _ChessView2D {
	ChessView parent_instance;
	ChessView2DPrivate * priv;
};

struct _ChessView2DClass {
	ChessViewClass parent_class;
};

struct _ChessView2DPrivate {
	gint border;
	gint square_size;
	gint selected_square_size;
	cairo_surface_t* model_surface;
	cairo_surface_t* selected_model_surface;
	gchar* loaded_theme_name;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};

struct _ChessModel {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessModelPrivate * priv;
	ChessPiece* piece;
	gdouble x;
	gdouble y;
	gdouble target_x;
	gdouble target_y;
	gboolean under_threat;
	gboolean is_selected;
};

struct _ChessModelClass {
	GTypeClass parent_class;
	void (*finalize) (ChessModel *self);
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GTypeClass parent_class;
	void (*finalize) (ChessPiece *self);
};


static gpointer chess_view2_d_parent_class = NULL;

GType chess_view_get_type (void) G_GNUC_CONST;
GType chess_view2_d_get_type (void) G_GNUC_CONST;
#define CHESS_VIEW2_D_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_VIEW2_D, ChessView2DPrivate))
enum  {
	CHESS_VIEW2_D_DUMMY_PROPERTY
};
ChessView2D* chess_view2_d_new (void);
ChessView2D* chess_view2_d_construct (GType object_type);
ChessView* chess_view_new (void);
ChessView* chess_view_construct (GType object_type);
static gboolean chess_view2_d_real_configure_event (GtkWidget* base, GdkEventConfigure* event);
static void chess_view2_d_render_piece (ChessView2D* self, cairo_t* c1, cairo_t* c2, const gchar* name, gint offset);
GType chess_scene_get_type (void) G_GNUC_CONST;
ChessScene* chess_view_get_scene (ChessView* self);
const gchar* chess_scene_get_theme_name (ChessScene* self);
static void chess_view2_d_load_theme (ChessView2D* self);
static gboolean chess_view2_d_real_draw (GtkWidget* base, cairo_t* c);
gdouble chess_scene_get_board_angle (ChessScene* self);
static gdouble chess_view2_d_get_border_size (ChessView2D* self);
gboolean chess_scene_get_show_numbering (ChessScene* self);
gpointer chess_model_ref (gpointer instance);
void chess_model_unref (gpointer instance);
GParamSpec* param_spec_chess_model (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_model (GValue* value, gpointer v_object);
void value_take_chess_model (GValue* value, gpointer v_object);
gpointer value_get_chess_model (const GValue* value);
GType chess_model_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
gboolean chess_scene_get_show_move_hints (ChessScene* self);
static void chess_view2_d_draw_piece (ChessView2D* self, cairo_t* c, cairo_surface_t* surface, ChessPiece* piece, gdouble alpha);
gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file);
ChessPiece* chess_scene_get_selected_piece (ChessScene* self);
const gchar* chess_scene_get_board_side (ChessScene* self);
GType color_get_type (void) G_GNUC_CONST;
Color chess_piece_get_color (ChessPiece* self);
GType chess_player_get_type (void) G_GNUC_CONST;
GType piece_type_get_type (void) G_GNUC_CONST;
static gboolean chess_view2_d_real_button_press_event (GtkWidget* base, GdkEventButton* event);
gpointer chess_game_ref (gpointer instance);
void chess_game_unref (gpointer instance);
GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_game (GValue* value, gpointer v_object);
void value_take_chess_game (GValue* value, gpointer v_object);
gpointer value_get_chess_game (const GValue* value);
GType chess_game_get_type (void) G_GNUC_CONST;
ChessGame* chess_scene_get_game (ChessScene* self);
void chess_scene_select_square (ChessScene* self, gint file, gint rank);
static void chess_view2_d_finalize (GObject* obj);
static void _vala_chess_view2_d_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


ChessView2D* chess_view2_d_construct (GType object_type) {
	ChessView2D * self = NULL;
	self = (ChessView2D*) chess_view_construct (object_type);
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_BUTTON_PRESS_MASK);
	return self;
}


ChessView2D* chess_view2_d_new (void) {
	return chess_view2_d_construct (TYPE_CHESS_VIEW2_D);
}


static gboolean chess_view2_d_real_configure_event (GtkWidget* base, GdkEventConfigure* event) {
	ChessView2D * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint short_edge;
	gint _tmp3_;
	gint _tmp4_;
	gdouble _tmp5_ = 0.0;
	gint _tmp6_;
	gdouble extra;
	gdouble _tmp7_;
	gint _tmp8_;
	gdouble _tmp9_;
	self = (ChessView2D*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp2_ = MIN (_tmp0_, _tmp1_);
	short_edge = _tmp2_;
	_tmp3_ = short_edge;
	_tmp4_ = self->priv->border;
	_tmp5_ = floor ((_tmp3_ - (2 * _tmp4_)) / 9.0);
	self->priv->square_size = (gint) _tmp5_;
	_tmp6_ = self->priv->square_size;
	extra = _tmp6_ * 0.1;
	_tmp7_ = extra;
	if (_tmp7_ < ((gdouble) 3)) {
		extra = (gdouble) 3;
	}
	_tmp8_ = self->priv->square_size;
	_tmp9_ = extra;
	self->priv->selected_square_size = _tmp8_ + (2 * ((gint) (_tmp9_ + 0.5)));
	result = TRUE;
	return result;
}


static void chess_view2_d_render_piece (ChessView2D* self, cairo_t* c1, cairo_t* c2, const gchar* name, gint offset) {
	RsvgHandle* handle = NULL;
	cairo_t* _tmp15_;
	cairo_t* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	cairo_t* _tmp19_;
	gint _tmp20_;
	RsvgHandle* _tmp21_;
	gint _tmp22_ = 0;
	gint _tmp23_;
	gint _tmp24_;
	RsvgHandle* _tmp25_;
	gint _tmp26_ = 0;
	gint _tmp27_;
	RsvgHandle* _tmp28_;
	cairo_t* _tmp29_;
	cairo_t* _tmp30_;
	cairo_t* _tmp31_;
	cairo_t* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	cairo_t* _tmp35_;
	gint _tmp36_;
	RsvgHandle* _tmp37_;
	gint _tmp38_ = 0;
	gint _tmp39_;
	gint _tmp40_;
	RsvgHandle* _tmp41_;
	gint _tmp42_ = 0;
	gint _tmp43_;
	RsvgHandle* _tmp44_;
	cairo_t* _tmp45_;
	cairo_t* _tmp46_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c1 != NULL);
	g_return_if_fail (c2 != NULL);
	g_return_if_fail (name != NULL);
	{
		ChessScene* _tmp0_;
		ChessScene* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		RsvgHandle* _tmp9_;
		RsvgHandle* _tmp10_;
		RsvgHandle* _tmp11_;
		_tmp0_ = chess_view_get_scene ((ChessView*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = chess_scene_get_theme_name (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = name;
		_tmp5_ = g_strconcat (_tmp4_, ".svg", NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_build_filename (PKGDATADIR, "pieces", _tmp3_, _tmp6_, NULL, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = rsvg_handle_new_from_file (_tmp8_, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
		_g_object_unref0 (handle);
		handle = _tmp11_;
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		FILE* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = stderr;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		fprintf (_tmp12_, "Failed to load piece svg: %s", _tmp14_);
		_g_error_free0 (e);
		_g_object_unref0 (handle);
		return;
	}
	__finally14:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (handle);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp15_ = c1;
	cairo_save (_tmp15_);
	_tmp16_ = c1;
	_tmp17_ = self->priv->square_size;
	_tmp18_ = offset;
	cairo_translate (_tmp16_, (gdouble) (_tmp17_ * _tmp18_), (gdouble) 0);
	_tmp19_ = c1;
	_tmp20_ = self->priv->square_size;
	_tmp21_ = handle;
	g_object_get (_tmp21_, "width", &_tmp22_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = self->priv->square_size;
	_tmp25_ = handle;
	g_object_get (_tmp25_, "height", &_tmp26_, NULL);
	_tmp27_ = _tmp26_;
	cairo_scale (_tmp19_, ((gdouble) _tmp20_) / _tmp23_, ((gdouble) _tmp24_) / _tmp27_);
	_tmp28_ = handle;
	_tmp29_ = c1;
	rsvg_handle_render_cairo (_tmp28_, _tmp29_);
	_tmp30_ = c1;
	cairo_restore (_tmp30_);
	_tmp31_ = c2;
	cairo_save (_tmp31_);
	_tmp32_ = c2;
	_tmp33_ = self->priv->selected_square_size;
	_tmp34_ = offset;
	cairo_translate (_tmp32_, (gdouble) (_tmp33_ * _tmp34_), (gdouble) 0);
	_tmp35_ = c2;
	_tmp36_ = self->priv->selected_square_size;
	_tmp37_ = handle;
	g_object_get (_tmp37_, "width", &_tmp38_, NULL);
	_tmp39_ = _tmp38_;
	_tmp40_ = self->priv->selected_square_size;
	_tmp41_ = handle;
	g_object_get (_tmp41_, "height", &_tmp42_, NULL);
	_tmp43_ = _tmp42_;
	cairo_scale (_tmp35_, ((gdouble) _tmp36_) / _tmp39_, ((gdouble) _tmp40_) / _tmp43_);
	_tmp44_ = handle;
	_tmp45_ = c2;
	rsvg_handle_render_cairo (_tmp44_, _tmp45_);
	_tmp46_ = c2;
	cairo_restore (_tmp46_);
	_g_object_unref0 (handle);
}


static void chess_view2_d_load_theme (ChessView2D* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessScene* _tmp2_;
	ChessScene* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp8_;
	gboolean _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	cairo_surface_t* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	cairo_surface_t* _tmp18_;
	cairo_surface_t* _tmp19_;
	cairo_t* _tmp20_;
	cairo_t* c1;
	cairo_surface_t* _tmp21_;
	cairo_t* _tmp22_;
	cairo_t* c2;
	cairo_t* _tmp23_;
	cairo_t* _tmp24_;
	cairo_t* _tmp25_;
	cairo_t* _tmp26_;
	cairo_t* _tmp27_;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
	cairo_t* _tmp30_;
	cairo_t* _tmp31_;
	cairo_t* _tmp32_;
	cairo_t* _tmp33_;
	cairo_t* _tmp34_;
	cairo_t* _tmp35_;
	cairo_t* _tmp36_;
	cairo_t* _tmp37_;
	cairo_t* _tmp38_;
	cairo_t* _tmp39_;
	cairo_t* _tmp40_;
	cairo_t* _tmp41_;
	cairo_t* _tmp42_;
	cairo_t* _tmp43_;
	cairo_t* _tmp44_;
	cairo_t* _tmp45_;
	cairo_t* _tmp46_;
	ChessScene* _tmp47_;
	ChessScene* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	g_return_if_fail (self != NULL);
	_tmp2_ = chess_view_get_scene ((ChessView*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = chess_scene_get_theme_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->loaded_theme_name;
	if (g_strcmp0 (_tmp5_, _tmp6_) == 0) {
		cairo_surface_t* _tmp7_;
		_tmp7_ = self->priv->model_surface;
		_tmp1_ = _tmp7_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp8_ = _tmp1_;
	if (_tmp8_) {
		gint _tmp9_;
		cairo_surface_t* _tmp10_;
		gint _tmp11_ = 0;
		_tmp9_ = self->priv->square_size;
		_tmp10_ = self->priv->model_surface;
		_tmp11_ = cairo_image_surface_get_height (_tmp10_);
		_tmp0_ = _tmp9_ == _tmp11_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp12_ = _tmp0_;
	if (_tmp12_) {
		return;
	}
	_tmp13_ = self->priv->square_size;
	_tmp14_ = self->priv->square_size;
	_tmp15_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 12 * _tmp13_, _tmp14_);
	_cairo_surface_destroy0 (self->priv->model_surface);
	self->priv->model_surface = _tmp15_;
	_tmp16_ = self->priv->selected_square_size;
	_tmp17_ = self->priv->selected_square_size;
	_tmp18_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 12 * _tmp16_, _tmp17_);
	_cairo_surface_destroy0 (self->priv->selected_model_surface);
	self->priv->selected_model_surface = _tmp18_;
	_tmp19_ = self->priv->model_surface;
	_tmp20_ = cairo_create (_tmp19_);
	c1 = _tmp20_;
	_tmp21_ = self->priv->selected_model_surface;
	_tmp22_ = cairo_create (_tmp21_);
	c2 = _tmp22_;
	_tmp23_ = c1;
	_tmp24_ = c2;
	chess_view2_d_render_piece (self, _tmp23_, _tmp24_, "whitePawn", 0);
	_tmp25_ = c1;
	_tmp26_ = c2;
	chess_view2_d_render_piece (self, _tmp25_, _tmp26_, "whiteRook", 1);
	_tmp27_ = c1;
	_tmp28_ = c2;
	chess_view2_d_render_piece (self, _tmp27_, _tmp28_, "whiteKnight", 2);
	_tmp29_ = c1;
	_tmp30_ = c2;
	chess_view2_d_render_piece (self, _tmp29_, _tmp30_, "whiteBishop", 3);
	_tmp31_ = c1;
	_tmp32_ = c2;
	chess_view2_d_render_piece (self, _tmp31_, _tmp32_, "whiteQueen", 4);
	_tmp33_ = c1;
	_tmp34_ = c2;
	chess_view2_d_render_piece (self, _tmp33_, _tmp34_, "whiteKing", 5);
	_tmp35_ = c1;
	_tmp36_ = c2;
	chess_view2_d_render_piece (self, _tmp35_, _tmp36_, "blackPawn", 6);
	_tmp37_ = c1;
	_tmp38_ = c2;
	chess_view2_d_render_piece (self, _tmp37_, _tmp38_, "blackRook", 7);
	_tmp39_ = c1;
	_tmp40_ = c2;
	chess_view2_d_render_piece (self, _tmp39_, _tmp40_, "blackKnight", 8);
	_tmp41_ = c1;
	_tmp42_ = c2;
	chess_view2_d_render_piece (self, _tmp41_, _tmp42_, "blackBishop", 9);
	_tmp43_ = c1;
	_tmp44_ = c2;
	chess_view2_d_render_piece (self, _tmp43_, _tmp44_, "blackQueen", 10);
	_tmp45_ = c1;
	_tmp46_ = c2;
	chess_view2_d_render_piece (self, _tmp45_, _tmp46_, "blackKing", 11);
	_tmp47_ = chess_view_get_scene ((ChessView*) self);
	_tmp48_ = _tmp47_;
	_tmp49_ = chess_scene_get_theme_name (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = g_strdup (_tmp50_);
	_g_free0 (self->priv->loaded_theme_name);
	self->priv->loaded_theme_name = _tmp51_;
	_cairo_destroy0 (c2);
	_cairo_destroy0 (c1);
}


static gpointer _chess_model_ref0 (gpointer self) {
	return self ? chess_model_ref (self) : NULL;
}


static gboolean chess_view2_d_real_draw (GtkWidget* base, cairo_t* c) {
	ChessView2D * self;
	gboolean result = FALSE;
	cairo_t* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	cairo_t* _tmp3_;
	ChessScene* _tmp4_;
	ChessScene* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gint _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_ = 0.0;
	gint board_size;
	cairo_t* _tmp12_;
	cairo_t* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	cairo_t* _tmp18_;
	ChessScene* _tmp41_;
	ChessScene* _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	ChessScene* _tmp159_;
	ChessScene* _tmp160_;
	GList* _tmp161_;
	self = (ChessView2D*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	chess_view2_d_load_theme (self);
	_tmp0_ = c;
	_tmp1_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp2_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	cairo_translate (_tmp0_, (gdouble) (_tmp1_ / 2), (gdouble) (_tmp2_ / 2));
	_tmp3_ = c;
	_tmp4_ = chess_view_get_scene ((ChessView*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = chess_scene_get_board_angle (_tmp5_);
	_tmp7_ = _tmp6_;
	cairo_rotate (_tmp3_, (G_PI * _tmp7_) / 180.0);
	_tmp8_ = self->priv->square_size;
	_tmp9_ = chess_view2_d_get_border_size (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = ceil ((_tmp8_ * 4) + _tmp10_);
	board_size = (gint) _tmp11_;
	_tmp12_ = c;
	cairo_set_source_rgb (_tmp12_, 0x2e / 255.0, 0x34 / 255.0, 0x36 / 255.0);
	_tmp13_ = c;
	_tmp14_ = board_size;
	_tmp15_ = board_size;
	_tmp16_ = board_size;
	_tmp17_ = board_size;
	cairo_rectangle (_tmp13_, (gdouble) (-_tmp14_), (gdouble) (-_tmp15_), (gdouble) (_tmp16_ * 2), (gdouble) (_tmp17_ * 2));
	_tmp18_ = c;
	cairo_fill (_tmp18_);
	{
		gint file;
		file = 0;
		{
			gboolean _tmp19_;
			_tmp19_ = TRUE;
			while (TRUE) {
				gboolean _tmp20_;
				gint _tmp22_;
				_tmp20_ = _tmp19_;
				if (!_tmp20_) {
					gint _tmp21_;
					_tmp21_ = file;
					file = _tmp21_ + 1;
				}
				_tmp19_ = FALSE;
				_tmp22_ = file;
				if (!(_tmp22_ < 8)) {
					break;
				}
				{
					gint rank;
					rank = 0;
					{
						gboolean _tmp23_;
						_tmp23_ = TRUE;
						while (TRUE) {
							gboolean _tmp24_;
							gint _tmp26_;
							gint _tmp27_;
							gint _tmp28_;
							gint x;
							gint _tmp29_;
							gint _tmp30_;
							gint y;
							cairo_t* _tmp31_;
							gint _tmp32_;
							gint _tmp33_;
							gint _tmp34_;
							gint _tmp35_;
							gint _tmp36_;
							gint _tmp37_;
							cairo_t* _tmp40_;
							_tmp24_ = _tmp23_;
							if (!_tmp24_) {
								gint _tmp25_;
								_tmp25_ = rank;
								rank = _tmp25_ + 1;
							}
							_tmp23_ = FALSE;
							_tmp26_ = rank;
							if (!(_tmp26_ < 8)) {
								break;
							}
							_tmp27_ = file;
							_tmp28_ = self->priv->square_size;
							x = (gint) ((_tmp27_ - 4) * _tmp28_);
							_tmp29_ = rank;
							_tmp30_ = self->priv->square_size;
							y = (gint) ((3 - _tmp29_) * _tmp30_);
							_tmp31_ = c;
							_tmp32_ = x;
							_tmp33_ = y;
							_tmp34_ = self->priv->square_size;
							_tmp35_ = self->priv->square_size;
							cairo_rectangle (_tmp31_, (gdouble) _tmp32_, (gdouble) _tmp33_, (gdouble) _tmp34_, (gdouble) _tmp35_);
							_tmp36_ = file;
							_tmp37_ = rank;
							if (((_tmp36_ + _tmp37_) % 2) == 0) {
								cairo_t* _tmp38_;
								_tmp38_ = c;
								cairo_set_source_rgb (_tmp38_, 0xba / 255.0, 0xbd / 255.0, 0xb6 / 255.0);
							} else {
								cairo_t* _tmp39_;
								_tmp39_ = c;
								cairo_set_source_rgb (_tmp39_, 0xee / 255.0, 0xee / 255.0, 0xec / 255.0);
							}
							_tmp40_ = c;
							cairo_fill (_tmp40_);
						}
					}
				}
			}
		}
	}
	_tmp41_ = chess_view_get_scene ((ChessView*) self);
	_tmp42_ = _tmp41_;
	_tmp43_ = chess_scene_get_show_numbering (_tmp42_);
	_tmp44_ = _tmp43_;
	if (_tmp44_) {
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar** _tmp53_ = NULL;
		gchar** files;
		gint files_length1;
		gint _files_size_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		gchar** _tmp62_ = NULL;
		gchar** ranks;
		gint ranks_length1;
		gint _ranks_size_;
		cairo_t* _tmp63_;
		cairo_t* _tmp64_;
		gdouble _tmp65_;
		gdouble _tmp66_;
		cairo_t* _tmp67_;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp68_;
		cairo_text_extents_t _tmp69_ = {0};
		gint _tmp70_;
		cairo_text_extents_t _tmp71_;
		gdouble _tmp72_;
		cairo_text_extents_t _tmp73_;
		gdouble _tmp74_;
		cairo_text_extents_t _tmp75_;
		gdouble _tmp76_;
		gdouble y_offset;
		gint _tmp77_;
		gdouble _tmp78_;
		gdouble top;
		gint _tmp79_;
		gdouble _tmp80_;
		gdouble _tmp81_;
		gdouble _tmp82_;
		gdouble bottom;
		gint _tmp83_;
		gdouble file_offset;
		gint _tmp84_;
		gdouble rank_offset;
		_tmp45_ = g_strdup ("a");
		_tmp46_ = g_strdup ("b");
		_tmp47_ = g_strdup ("c");
		_tmp48_ = g_strdup ("d");
		_tmp49_ = g_strdup ("e");
		_tmp50_ = g_strdup ("f");
		_tmp51_ = g_strdup ("g");
		_tmp52_ = g_strdup ("h");
		_tmp53_ = g_new0 (gchar*, 8 + 1);
		_tmp53_[0] = _tmp45_;
		_tmp53_[1] = _tmp46_;
		_tmp53_[2] = _tmp47_;
		_tmp53_[3] = _tmp48_;
		_tmp53_[4] = _tmp49_;
		_tmp53_[5] = _tmp50_;
		_tmp53_[6] = _tmp51_;
		_tmp53_[7] = _tmp52_;
		files = _tmp53_;
		files_length1 = 8;
		_files_size_ = files_length1;
		_tmp54_ = g_strdup ("8");
		_tmp55_ = g_strdup ("7");
		_tmp56_ = g_strdup ("6");
		_tmp57_ = g_strdup ("5");
		_tmp58_ = g_strdup ("4");
		_tmp59_ = g_strdup ("3");
		_tmp60_ = g_strdup ("2");
		_tmp61_ = g_strdup ("1");
		_tmp62_ = g_new0 (gchar*, 8 + 1);
		_tmp62_[0] = _tmp54_;
		_tmp62_[1] = _tmp55_;
		_tmp62_[2] = _tmp56_;
		_tmp62_[3] = _tmp57_;
		_tmp62_[4] = _tmp58_;
		_tmp62_[5] = _tmp59_;
		_tmp62_[6] = _tmp60_;
		_tmp62_[7] = _tmp61_;
		ranks = _tmp62_;
		ranks_length1 = 8;
		_ranks_size_ = ranks_length1;
		_tmp63_ = c;
		cairo_set_source_rgb (_tmp63_, 0x88 / 255.0, 0x8a / 255.0, 0x85 / 255.0);
		_tmp64_ = c;
		_tmp65_ = chess_view2_d_get_border_size (self);
		_tmp66_ = _tmp65_;
		cairo_set_font_size (_tmp64_, _tmp66_ * 0.6);
		_tmp67_ = c;
		cairo_select_font_face (_tmp67_, "sans-serif", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		_tmp68_ = c;
		cairo_text_extents (_tmp68_, "abcdefgh", &_tmp69_);
		extents = _tmp69_;
		_tmp70_ = self->priv->square_size;
		_tmp71_ = extents;
		_tmp72_ = _tmp71_.height;
		_tmp73_ = extents;
		_tmp74_ = _tmp73_.height;
		_tmp75_ = extents;
		_tmp76_ = _tmp75_.y_bearing;
		y_offset = ((((_tmp70_ / 2) - _tmp72_) / 2) + _tmp74_) + _tmp76_;
		_tmp77_ = self->priv->square_size;
		_tmp78_ = y_offset;
		top = -((_tmp77_ * 4) + _tmp78_);
		_tmp79_ = self->priv->square_size;
		_tmp80_ = chess_view2_d_get_border_size (self);
		_tmp81_ = _tmp80_;
		_tmp82_ = y_offset;
		bottom = ((_tmp79_ * 4) + _tmp81_) - _tmp82_;
		_tmp83_ = self->priv->square_size;
		file_offset = -(_tmp83_ * 3.5);
		_tmp84_ = self->priv->square_size;
		rank_offset = -(_tmp84_ * 3.5);
		{
			gint i;
			i = 0;
			{
				gboolean _tmp85_;
				_tmp85_ = TRUE;
				while (TRUE) {
					gboolean _tmp86_;
					gint _tmp88_;
					cairo_t* _tmp89_;
					gchar** _tmp90_;
					gint _tmp90__length1;
					gint _tmp91_;
					const gchar* _tmp92_;
					cairo_text_extents_t _tmp93_ = {0};
					cairo_t* _tmp94_;
					cairo_t* _tmp95_;
					gdouble _tmp96_;
					cairo_text_extents_t _tmp97_;
					gdouble _tmp98_;
					gdouble _tmp99_;
					cairo_t* _tmp100_;
					gchar** _tmp101_;
					gint _tmp101__length1;
					gint _tmp102_;
					const gchar* _tmp103_;
					cairo_t* _tmp104_;
					cairo_t* _tmp105_;
					cairo_t* _tmp106_;
					gdouble _tmp107_;
					cairo_text_extents_t _tmp108_;
					gdouble _tmp109_;
					gdouble _tmp110_;
					cairo_t* _tmp111_;
					gchar** _tmp112_;
					gint _tmp112__length1;
					gint _tmp113_;
					const gchar* _tmp114_;
					cairo_t* _tmp115_;
					cairo_t* _tmp116_;
					gchar** _tmp117_;
					gint _tmp117__length1;
					gint _tmp118_;
					const gchar* _tmp119_;
					cairo_text_extents_t _tmp120_ = {0};
					cairo_text_extents_t _tmp121_;
					gdouble _tmp122_;
					cairo_text_extents_t _tmp123_;
					gdouble _tmp124_;
					cairo_t* _tmp125_;
					cairo_t* _tmp126_;
					gint _tmp127_;
					gdouble _tmp128_;
					gdouble _tmp129_;
					gdouble _tmp130_;
					gdouble _tmp131_;
					cairo_text_extents_t _tmp132_;
					gdouble _tmp133_;
					gdouble _tmp134_;
					gdouble _tmp135_;
					cairo_t* _tmp136_;
					gchar** _tmp137_;
					gint _tmp137__length1;
					gint _tmp138_;
					const gchar* _tmp139_;
					cairo_t* _tmp140_;
					cairo_t* _tmp141_;
					cairo_t* _tmp142_;
					gint _tmp143_;
					gdouble _tmp144_;
					gdouble _tmp145_;
					cairo_text_extents_t _tmp146_;
					gdouble _tmp147_;
					gdouble _tmp148_;
					gdouble _tmp149_;
					cairo_t* _tmp150_;
					gchar** _tmp151_;
					gint _tmp151__length1;
					gint _tmp152_;
					const gchar* _tmp153_;
					cairo_t* _tmp154_;
					gdouble _tmp155_;
					gint _tmp156_;
					gdouble _tmp157_;
					gint _tmp158_;
					_tmp86_ = _tmp85_;
					if (!_tmp86_) {
						gint _tmp87_;
						_tmp87_ = i;
						i = _tmp87_ + 1;
					}
					_tmp85_ = FALSE;
					_tmp88_ = i;
					if (!(_tmp88_ < 8)) {
						break;
					}
					_tmp89_ = c;
					_tmp90_ = ranks;
					_tmp90__length1 = ranks_length1;
					_tmp91_ = i;
					_tmp92_ = _tmp90_[_tmp91_];
					cairo_text_extents (_tmp89_, _tmp92_, &_tmp93_);
					extents = _tmp93_;
					_tmp94_ = c;
					cairo_save (_tmp94_);
					_tmp95_ = c;
					_tmp96_ = file_offset;
					_tmp97_ = extents;
					_tmp98_ = _tmp97_.width;
					_tmp99_ = top;
					cairo_move_to (_tmp95_, _tmp96_ - (_tmp98_ / 2), _tmp99_);
					_tmp100_ = c;
					_tmp101_ = files;
					_tmp101__length1 = files_length1;
					_tmp102_ = i;
					_tmp103_ = _tmp101_[_tmp102_];
					cairo_show_text (_tmp100_, _tmp103_);
					_tmp104_ = c;
					cairo_restore (_tmp104_);
					_tmp105_ = c;
					cairo_save (_tmp105_);
					_tmp106_ = c;
					_tmp107_ = file_offset;
					_tmp108_ = extents;
					_tmp109_ = _tmp108_.width;
					_tmp110_ = bottom;
					cairo_move_to (_tmp106_, _tmp107_ - (_tmp109_ / 2), _tmp110_);
					_tmp111_ = c;
					_tmp112_ = files;
					_tmp112__length1 = files_length1;
					_tmp113_ = i;
					_tmp114_ = _tmp112_[_tmp113_];
					cairo_show_text (_tmp111_, _tmp114_);
					_tmp115_ = c;
					cairo_restore (_tmp115_);
					_tmp116_ = c;
					_tmp117_ = ranks;
					_tmp117__length1 = ranks_length1;
					_tmp118_ = i;
					_tmp119_ = _tmp117_[_tmp118_];
					cairo_text_extents (_tmp116_, _tmp119_, &_tmp120_);
					extents = _tmp120_;
					_tmp121_ = extents;
					_tmp122_ = _tmp121_.y_bearing;
					_tmp123_ = extents;
					_tmp124_ = _tmp123_.height;
					y_offset = -(_tmp122_ + (_tmp124_ / 2));
					_tmp125_ = c;
					cairo_save (_tmp125_);
					_tmp126_ = c;
					_tmp127_ = self->priv->square_size;
					_tmp128_ = chess_view2_d_get_border_size (self);
					_tmp129_ = _tmp128_;
					_tmp130_ = chess_view2_d_get_border_size (self);
					_tmp131_ = _tmp130_;
					_tmp132_ = extents;
					_tmp133_ = _tmp132_.width;
					_tmp134_ = rank_offset;
					_tmp135_ = y_offset;
					cairo_move_to (_tmp126_, -(((((gdouble) _tmp127_) * 4) + _tmp129_) - ((_tmp131_ - _tmp133_) / 2)), _tmp134_ + _tmp135_);
					_tmp136_ = c;
					_tmp137_ = ranks;
					_tmp137__length1 = ranks_length1;
					_tmp138_ = i;
					_tmp139_ = _tmp137_[_tmp138_];
					cairo_show_text (_tmp136_, _tmp139_);
					_tmp140_ = c;
					cairo_restore (_tmp140_);
					_tmp141_ = c;
					cairo_save (_tmp141_);
					_tmp142_ = c;
					_tmp143_ = self->priv->square_size;
					_tmp144_ = chess_view2_d_get_border_size (self);
					_tmp145_ = _tmp144_;
					_tmp146_ = extents;
					_tmp147_ = _tmp146_.width;
					_tmp148_ = rank_offset;
					_tmp149_ = y_offset;
					cairo_move_to (_tmp142_, (((gdouble) _tmp143_) * 4) + ((_tmp145_ - _tmp147_) / 2), _tmp148_ + _tmp149_);
					_tmp150_ = c;
					_tmp151_ = ranks;
					_tmp151__length1 = ranks_length1;
					_tmp152_ = i;
					_tmp153_ = _tmp151_[_tmp152_];
					cairo_show_text (_tmp150_, _tmp153_);
					_tmp154_ = c;
					cairo_restore (_tmp154_);
					_tmp155_ = file_offset;
					_tmp156_ = self->priv->square_size;
					file_offset = _tmp155_ + _tmp156_;
					_tmp157_ = rank_offset;
					_tmp158_ = self->priv->square_size;
					rank_offset = _tmp157_ + _tmp158_;
				}
			}
		}
		ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp159_ = chess_view_get_scene ((ChessView*) self);
	_tmp160_ = _tmp159_;
	_tmp161_ = _tmp160_->pieces;
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
		model_collection = _tmp161_;
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
			ChessModel* _tmp162_;
			ChessModel* model = NULL;
			_tmp162_ = _chess_model_ref0 ((ChessModel*) model_it->data);
			model = _tmp162_;
			{
				cairo_t* _tmp163_;
				cairo_t* _tmp164_;
				ChessModel* _tmp165_;
				gdouble _tmp166_;
				gint _tmp167_;
				ChessModel* _tmp168_;
				gdouble _tmp169_;
				gint _tmp170_;
				cairo_t* _tmp171_;
				gint _tmp172_;
				gint _tmp173_;
				cairo_t* _tmp174_;
				ChessScene* _tmp175_;
				ChessScene* _tmp176_;
				gdouble _tmp177_;
				gdouble _tmp178_;
				cairo_surface_t* _tmp179_ = NULL;
				ChessModel* _tmp180_;
				gboolean _tmp181_;
				gdouble _tmp184_ = 0.0;
				gboolean _tmp185_ = FALSE;
				ChessModel* _tmp186_;
				gboolean _tmp187_;
				gboolean _tmp192_;
				cairo_t* _tmp193_;
				cairo_surface_t* _tmp194_;
				ChessModel* _tmp195_;
				ChessPiece* _tmp196_;
				gdouble _tmp197_;
				cairo_t* _tmp198_;
				_tmp163_ = c;
				cairo_save (_tmp163_);
				_tmp164_ = c;
				_tmp165_ = model;
				_tmp166_ = _tmp165_->x;
				_tmp167_ = self->priv->square_size;
				_tmp168_ = model;
				_tmp169_ = _tmp168_->y;
				_tmp170_ = self->priv->square_size;
				cairo_translate (_tmp164_, (_tmp166_ - 4) * _tmp167_, (3 - _tmp169_) * _tmp170_);
				_tmp171_ = c;
				_tmp172_ = self->priv->square_size;
				_tmp173_ = self->priv->square_size;
				cairo_translate (_tmp171_, (gdouble) (_tmp172_ / 2), (gdouble) (_tmp173_ / 2));
				_tmp174_ = c;
				_tmp175_ = chess_view_get_scene ((ChessView*) self);
				_tmp176_ = _tmp175_;
				_tmp177_ = chess_scene_get_board_angle (_tmp176_);
				_tmp178_ = _tmp177_;
				cairo_rotate (_tmp174_, ((-G_PI) * _tmp178_) / 180.0);
				_tmp180_ = model;
				_tmp181_ = _tmp180_->is_selected;
				if (_tmp181_) {
					cairo_surface_t* _tmp182_;
					_tmp182_ = self->priv->selected_model_surface;
					_tmp179_ = _tmp182_;
				} else {
					cairo_surface_t* _tmp183_;
					_tmp183_ = self->priv->model_surface;
					_tmp179_ = _tmp183_;
				}
				_tmp186_ = model;
				_tmp187_ = _tmp186_->under_threat;
				if (_tmp187_) {
					ChessScene* _tmp188_;
					ChessScene* _tmp189_;
					gboolean _tmp190_;
					gboolean _tmp191_;
					_tmp188_ = chess_view_get_scene ((ChessView*) self);
					_tmp189_ = _tmp188_;
					_tmp190_ = chess_scene_get_show_move_hints (_tmp189_);
					_tmp191_ = _tmp190_;
					_tmp185_ = _tmp191_;
				} else {
					_tmp185_ = FALSE;
				}
				_tmp192_ = _tmp185_;
				if (_tmp192_) {
					_tmp184_ = 0.8;
				} else {
					_tmp184_ = 1.0;
				}
				_tmp193_ = c;
				_tmp194_ = _tmp179_;
				_tmp195_ = model;
				_tmp196_ = _tmp195_->piece;
				_tmp197_ = _tmp184_;
				chess_view2_d_draw_piece (self, _tmp193_, _tmp194_, _tmp196_, _tmp197_);
				_tmp198_ = c;
				cairo_restore (_tmp198_);
				_chess_model_unref0 (model);
			}
		}
	}
	{
		gint rank;
		rank = 0;
		{
			gboolean _tmp199_;
			_tmp199_ = TRUE;
			while (TRUE) {
				gboolean _tmp200_;
				gint _tmp202_;
				_tmp200_ = _tmp199_;
				if (!_tmp200_) {
					gint _tmp201_;
					_tmp201_ = rank;
					rank = _tmp201_ + 1;
				}
				_tmp199_ = FALSE;
				_tmp202_ = rank;
				if (!(_tmp202_ < 8)) {
					break;
				}
				{
					gint file;
					file = 0;
					{
						gboolean _tmp203_;
						_tmp203_ = TRUE;
						while (TRUE) {
							gboolean _tmp204_;
							gint _tmp206_;
							gboolean _tmp207_ = FALSE;
							ChessScene* _tmp208_;
							ChessScene* _tmp209_;
							gboolean _tmp210_;
							gboolean _tmp211_;
							gboolean _tmp217_;
							_tmp204_ = _tmp203_;
							if (!_tmp204_) {
								gint _tmp205_;
								_tmp205_ = file;
								file = _tmp205_ + 1;
							}
							_tmp203_ = FALSE;
							_tmp206_ = file;
							if (!(_tmp206_ < 8)) {
								break;
							}
							_tmp208_ = chess_view_get_scene ((ChessView*) self);
							_tmp209_ = _tmp208_;
							_tmp210_ = chess_scene_get_show_move_hints (_tmp209_);
							_tmp211_ = _tmp210_;
							if (_tmp211_) {
								ChessScene* _tmp212_;
								ChessScene* _tmp213_;
								gint _tmp214_;
								gint _tmp215_;
								gboolean _tmp216_ = FALSE;
								_tmp212_ = chess_view_get_scene ((ChessView*) self);
								_tmp213_ = _tmp212_;
								_tmp214_ = rank;
								_tmp215_ = file;
								_tmp216_ = chess_scene_can_move (_tmp213_, _tmp214_, _tmp215_);
								_tmp207_ = _tmp216_;
							} else {
								_tmp207_ = FALSE;
							}
							_tmp217_ = _tmp207_;
							if (_tmp217_) {
								cairo_t* _tmp218_;
								cairo_t* _tmp219_;
								gint _tmp220_;
								gint _tmp221_;
								gint _tmp222_;
								gint _tmp223_;
								cairo_t* _tmp224_;
								gint _tmp225_;
								gint _tmp226_;
								cairo_t* _tmp227_;
								ChessScene* _tmp228_;
								ChessScene* _tmp229_;
								gdouble _tmp230_;
								gdouble _tmp231_;
								cairo_t* _tmp232_;
								cairo_surface_t* _tmp233_;
								ChessScene* _tmp234_;
								ChessScene* _tmp235_;
								ChessPiece* _tmp236_ = NULL;
								ChessPiece* _tmp237_;
								cairo_t* _tmp238_;
								_tmp218_ = c;
								cairo_save (_tmp218_);
								_tmp219_ = c;
								_tmp220_ = file;
								_tmp221_ = self->priv->square_size;
								_tmp222_ = rank;
								_tmp223_ = self->priv->square_size;
								cairo_translate (_tmp219_, (gdouble) ((_tmp220_ - 4) * _tmp221_), (gdouble) ((3 - _tmp222_) * _tmp223_));
								_tmp224_ = c;
								_tmp225_ = self->priv->square_size;
								_tmp226_ = self->priv->square_size;
								cairo_translate (_tmp224_, (gdouble) (_tmp225_ / 2), (gdouble) (_tmp226_ / 2));
								_tmp227_ = c;
								_tmp228_ = chess_view_get_scene ((ChessView*) self);
								_tmp229_ = _tmp228_;
								_tmp230_ = chess_scene_get_board_angle (_tmp229_);
								_tmp231_ = _tmp230_;
								cairo_rotate (_tmp227_, ((-G_PI) * _tmp231_) / 180.0);
								_tmp232_ = c;
								_tmp233_ = self->priv->model_surface;
								_tmp234_ = chess_view_get_scene ((ChessView*) self);
								_tmp235_ = _tmp234_;
								_tmp236_ = chess_scene_get_selected_piece (_tmp235_);
								_tmp237_ = _tmp236_;
								chess_view2_d_draw_piece (self, _tmp232_, _tmp233_, _tmp237_, 0.1);
								_chess_piece_unref0 (_tmp237_);
								_tmp238_ = c;
								cairo_restore (_tmp238_);
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static void chess_view2_d_draw_piece (ChessView2D* self, cairo_t* c, cairo_surface_t* surface, ChessPiece* piece, gdouble alpha) {
	gboolean _tmp0_ = FALSE;
	ChessScene* _tmp1_;
	ChessScene* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp8_;
	cairo_surface_t* _tmp10_;
	gint _tmp11_ = 0;
	gint size;
	cairo_t* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	ChessPiece* _tmp15_;
	PieceType _tmp16_;
	gint offset;
	ChessPiece* _tmp17_;
	Color _tmp18_;
	Color _tmp19_;
	cairo_t* _tmp21_;
	cairo_surface_t* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	cairo_t* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
	gdouble _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (surface != NULL);
	g_return_if_fail (piece != NULL);
	_tmp1_ = chess_view_get_scene ((ChessView*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = chess_scene_get_board_side (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, "facetoface") == 0) {
		ChessPiece* _tmp5_;
		Color _tmp6_;
		Color _tmp7_;
		_tmp5_ = piece;
		_tmp6_ = chess_piece_get_color (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_ == COLOR_BLACK;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		cairo_t* _tmp9_;
		_tmp9_ = c;
		cairo_rotate (_tmp9_, G_PI);
	}
	_tmp10_ = surface;
	_tmp11_ = cairo_image_surface_get_height (_tmp10_);
	size = _tmp11_;
	_tmp12_ = c;
	_tmp13_ = size;
	_tmp14_ = size;
	cairo_translate (_tmp12_, (gdouble) ((-_tmp13_) / 2), (gdouble) ((-_tmp14_) / 2));
	_tmp15_ = piece;
	_tmp16_ = _tmp15_->type;
	offset = (gint) _tmp16_;
	_tmp17_ = piece;
	_tmp18_ = chess_piece_get_color (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ == COLOR_BLACK) {
		gint _tmp20_;
		_tmp20_ = offset;
		offset = _tmp20_ + 6;
	}
	_tmp21_ = c;
	_tmp22_ = surface;
	_tmp23_ = offset;
	_tmp24_ = size;
	cairo_set_source_surface (_tmp21_, _tmp22_, (gdouble) ((-_tmp23_) * _tmp24_), (gdouble) 0);
	_tmp25_ = c;
	_tmp26_ = size;
	_tmp27_ = size;
	cairo_rectangle (_tmp25_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp26_, (gdouble) _tmp27_);
	_tmp28_ = c;
	cairo_clip (_tmp28_);
	_tmp29_ = c;
	_tmp30_ = alpha;
	cairo_paint_with_alpha (_tmp29_, _tmp30_);
}


static gboolean chess_view2_d_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	ChessView2D * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessScene* _tmp1_;
	ChessScene* _tmp2_;
	ChessGame* _tmp3_;
	ChessGame* _tmp4_;
	gboolean _tmp7_;
	GdkEventButton _tmp8_;
	gdouble _tmp9_;
	gint _tmp10_ = 0;
	gint _tmp11_;
	gint _tmp12_;
	gdouble _tmp13_ = 0.0;
	gint file;
	GdkEventButton _tmp14_;
	gdouble _tmp15_;
	gint _tmp16_ = 0;
	gint _tmp17_;
	gint _tmp18_;
	gdouble _tmp19_ = 0.0;
	gint rank;
	ChessScene* _tmp20_;
	ChessScene* _tmp21_;
	gdouble _tmp22_;
	gdouble _tmp23_;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gint _tmp29_;
	gboolean _tmp31_;
	gboolean _tmp33_;
	gboolean _tmp35_;
	ChessScene* _tmp36_;
	ChessScene* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	self = (ChessView2D*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = chess_view_get_scene ((ChessView*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = chess_scene_get_game (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GdkEventButton _tmp5_;
		guint _tmp6_;
		_tmp5_ = *event;
		_tmp6_ = _tmp5_.button;
		_tmp0_ = _tmp6_ != ((guint) 1);
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = *event;
	_tmp9_ = _tmp8_.x;
	_tmp10_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp11_ = self->priv->square_size;
	_tmp12_ = self->priv->square_size;
	_tmp13_ = floor (((_tmp9_ - (0.5 * _tmp10_)) + (_tmp11_ * 4)) / _tmp12_);
	file = (gint) _tmp13_;
	_tmp14_ = *event;
	_tmp15_ = _tmp14_.y;
	_tmp16_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp17_ = self->priv->square_size;
	_tmp18_ = self->priv->square_size;
	_tmp19_ = floor (((_tmp15_ - (0.5 * _tmp16_)) + (_tmp17_ * 4)) / _tmp18_);
	rank = 7 - ((gint) _tmp19_);
	_tmp20_ = chess_view_get_scene ((ChessView*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = chess_scene_get_board_angle (_tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_ == 180.0) {
		gint _tmp24_;
		gint _tmp25_;
		_tmp24_ = rank;
		rank = 7 - _tmp24_;
		_tmp25_ = file;
		file = 7 - _tmp25_;
	}
	_tmp29_ = file;
	if (_tmp29_ < 0) {
		_tmp28_ = TRUE;
	} else {
		gint _tmp30_;
		_tmp30_ = file;
		_tmp28_ = _tmp30_ >= 8;
	}
	_tmp31_ = _tmp28_;
	if (_tmp31_) {
		_tmp27_ = TRUE;
	} else {
		gint _tmp32_;
		_tmp32_ = rank;
		_tmp27_ = _tmp32_ < 0;
	}
	_tmp33_ = _tmp27_;
	if (_tmp33_) {
		_tmp26_ = TRUE;
	} else {
		gint _tmp34_;
		_tmp34_ = rank;
		_tmp26_ = _tmp34_ >= 8;
	}
	_tmp35_ = _tmp26_;
	if (_tmp35_) {
		result = FALSE;
		return result;
	}
	_tmp36_ = chess_view_get_scene ((ChessView*) self);
	_tmp37_ = _tmp36_;
	_tmp38_ = file;
	_tmp39_ = rank;
	chess_scene_select_square (_tmp37_, _tmp38_, _tmp39_);
	result = TRUE;
	return result;
}


static gdouble chess_view2_d_get_border_size (ChessView2D* self) {
	gdouble result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->square_size;
	result = (gdouble) (_tmp0_ / 2);
	return result;
}


static void chess_view2_d_class_init (ChessView2DClass * klass) {
	chess_view2_d_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessView2DPrivate));
	GTK_WIDGET_CLASS (klass)->configure_event = chess_view2_d_real_configure_event;
	GTK_WIDGET_CLASS (klass)->draw = chess_view2_d_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = chess_view2_d_real_button_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_view2_d_get_property;
	G_OBJECT_CLASS (klass)->finalize = chess_view2_d_finalize;
}


static void chess_view2_d_instance_init (ChessView2D * self) {
	gchar* _tmp0_;
	self->priv = CHESS_VIEW2_D_GET_PRIVATE (self);
	self->priv->border = 6;
	_tmp0_ = g_strdup ("");
	self->priv->loaded_theme_name = _tmp0_;
}


static void chess_view2_d_finalize (GObject* obj) {
	ChessView2D * self;
	self = CHESS_VIEW2_D (obj);
	_cairo_surface_destroy0 (self->priv->model_surface);
	_cairo_surface_destroy0 (self->priv->selected_model_surface);
	_g_free0 (self->priv->loaded_theme_name);
	G_OBJECT_CLASS (chess_view2_d_parent_class)->finalize (obj);
}


GType chess_view2_d_get_type (void) {
	static volatile gsize chess_view2_d_type_id__volatile = 0;
	if (g_once_init_enter (&chess_view2_d_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessView2DClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_view2_d_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessView2D), 0, (GInstanceInitFunc) chess_view2_d_instance_init, NULL };
		GType chess_view2_d_type_id;
		chess_view2_d_type_id = g_type_register_static (TYPE_CHESS_VIEW, "ChessView2D", &g_define_type_info, 0);
		g_once_init_leave (&chess_view2_d_type_id__volatile, chess_view2_d_type_id);
	}
	return chess_view2_d_type_id__volatile;
}


static void _vala_chess_view2_d_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessView2D * self;
	self = CHESS_VIEW2_D (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



