/* rygel-media-export-generic-extractor.c generated by valac 0.34.7, the Vala compiler
 * generated from rygel-media-export-generic-extractor.vala, do not modify */

/*
 * Copyright (C) 2016 Jens Georg <mail@jensge.org>
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gst/pbutils/pbutils.h>
#include <libgupnp-dlna/gupnp-dlna.h>
#include <libmediaart/mediaart.h>
#include <gst/gst.h>
#include <libgupnp-dlna/gupnp-dlna-gst-utils.h>
#include <gst/tag/tag.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR (rygel_media_export_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))

typedef struct _RygelMediaExportExtractor RygelMediaExportExtractor;
typedef struct _RygelMediaExportExtractorClass RygelMediaExportExtractorClass;
typedef struct _RygelMediaExportExtractorPrivate RygelMediaExportExtractorPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR (rygel_media_export_generic_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractor))
#define RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_GENERIC_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_GENERIC_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractorClass))

typedef struct _RygelMediaExportGenericExtractor RygelMediaExportGenericExtractor;
typedef struct _RygelMediaExportGenericExtractorClass RygelMediaExportGenericExtractorClass;
typedef struct _RygelMediaExportGenericExtractorPrivate RygelMediaExportGenericExtractorPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _gst_date_time_unref0(var) ((var == NULL) ? NULL : (var = (gst_date_time_unref (var), NULL)))
#define _gst_sample_unref0(var) ((var == NULL) ? NULL : (var = (gst_sample_unref (var), NULL)))
#define _gst_tag_list_unref0(var) ((var == NULL) ? NULL : (var = (gst_tag_list_unref (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
typedef struct _RygelMediaExportGenericExtractorRunData RygelMediaExportGenericExtractorRunData;

struct _RygelMediaExportExtractor {
	GObject parent_instance;
	RygelMediaExportExtractorPrivate * priv;
	GVariantDict* serialized_info;
};

struct _RygelMediaExportExtractorClass {
	GObjectClass parent_class;
	void (*run) (RygelMediaExportExtractor* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelMediaExportExtractor* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportGenericExtractor {
	RygelMediaExportExtractor parent_instance;
	RygelMediaExportGenericExtractorPrivate * priv;
};

struct _RygelMediaExportGenericExtractorClass {
	RygelMediaExportExtractorClass parent_class;
};

struct _RygelMediaExportGenericExtractorPrivate {
	gchar* upnp_class;
	gchar* mime_type;
};

struct _Block1Data {
	int _ref_count_;
	RygelMediaExportGenericExtractor* self;
	GError* _error_;
	GstDiscovererInfo* info;
	gpointer _async_data_;
};

typedef enum  {
	EXTRACTOR_ERROR_GENERAL,
	EXTRACTOR_ERROR_INVALID
} ExtractorError;
#define EXTRACTOR_ERROR extractor_error_quark ()
struct _RygelMediaExportGenericExtractorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportGenericExtractor* self;
	Block1Data* _data1_;
	GstDiscoverer* _tmp0_;
	GError* _tmp1_;
	gulong id;
	GstDiscoverer* _tmp2_;
	gulong _tmp3_;
	gchar* path;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	gchar* uri;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GstDiscoverer* _tmp15_;
	const gchar* _tmp16_;
	GstDiscoverer* _tmp17_;
	gulong _tmp18_;
	GError* _tmp19_;
	GstDiscoverer* _tmp20_;
	GstDiscoverer* _tmp21_;
	GstDiscoverer* _tmp22_;
	GstDiscoverer* _tmp23_;
	GstDiscoverer* _tmp24_;
	GstDiscovererResult _result_;
	GstDiscovererInfo* _tmp25_;
	GstDiscovererResult _tmp26_;
	GstDiscovererResult _tmp27_;
	GFile* _tmp28_;
	GFile* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GstDiscovererResult _tmp32_;
	GFile* _tmp33_;
	GFile* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GError* _tmp37_;
	GError* _tmp38_;
	GList* audio_streams;
	GstDiscovererInfo* _tmp39_;
	GList* _tmp40_;
	GList* video_streams;
	GstDiscovererInfo* _tmp41_;
	GList* _tmp42_;
	gboolean _tmp43_;
	GList* _tmp44_;
	GList* _tmp45_;
	GFile* _tmp46_;
	GFile* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	GError* _tmp50_;
	gchar* _tmp51_;
	gboolean _tmp52_;
	GList* _tmp53_;
	GList* _tmp54_;
	gconstpointer _tmp55_;
	gboolean _tmp56_;
	gchar* _tmp57_;
	GList* _tmp58_;
	gchar* _tmp59_;
	GList* _tmp60_;
	gchar* _tmp61_;
	GVariantDict* _tmp62_;
	const gchar* _tmp63_;
	GUPnPDLNAInformation* dlna_info;
	GstDiscovererInfo* _tmp64_;
	GUPnPDLNAInformation* _tmp65_;
	GUPnPDLNAProfile* dlna;
	GUPnPDLNAProfileGuesser* _tmp66_;
	GUPnPDLNAInformation* _tmp67_;
	GUPnPDLNAProfile* _tmp68_;
	GUPnPDLNAProfile* _tmp69_;
	GUPnPDLNAProfile* _tmp70_;
	GVariantDict* _tmp71_;
	GUPnPDLNAProfile* _tmp72_;
	const gchar* _tmp73_;
	const gchar* _tmp74_;
	GVariantDict* _tmp75_;
	GUPnPDLNAProfile* _tmp76_;
	const gchar* _tmp77_;
	const gchar* _tmp78_;
	GVariantDict* _tmp79_;
	glong duration;
	GstDiscovererInfo* _tmp80_;
	GstClockTime _tmp81_;
	GstDiscovererInfo* _tmp82_;
	GstClockTime _tmp83_;
	GVariantDict* _tmp84_;
	glong _tmp85_;
	GstTagList* tags;
	GstDiscovererInfo* _tmp86_;
	GstTagList* _tmp87_;
	GstTagList* _tmp88_;
	GstTagList* _tmp89_;
	gchar* title;
	GstTagList* _tmp90_;
	gchar* _tmp91_;
	gboolean _tmp92_;
	gboolean _tmp93_;
	const gchar* _tmp94_;
	const gchar* _tmp95_;
	GVariantDict* _tmp96_;
	const gchar* _tmp97_;
	gchar* date;
	GstDateTime* dt;
	GstTagList* _tmp98_;
	GstDateTime* _tmp99_;
	gboolean _tmp100_;
	gboolean _tmp101_;
	GstDateTime* _tmp102_;
	gboolean _tmp103_;
	GstDateTime* _tmp104_;
	gboolean _tmp105_;
	gint _tmp106_;
	GstDateTime* _tmp107_;
	gboolean _tmp108_;
	GstDateTime* _tmp109_;
	gint _tmp110_;
	gint _tmp111_;
	GstDateTime* _tmp112_;
	gboolean _tmp113_;
	GstDateTime* _tmp114_;
	gint _tmp115_;
	GstDateTime* _tmp116_;
	gint _tmp117_;
	gchar* _tmp118_;
	GstDateTime* _tmp119_;
	gchar* _tmp120_;
	GVariantDict* _tmp121_;
	const gchar* _tmp122_;
	gboolean _tmp123_;
	GList* _tmp124_;
	GList* _tmp125_;
	gconstpointer _tmp126_;
	GstDiscovererVideoInfo* vinfo;
	GList* _tmp127_;
	gconstpointer _tmp128_;
	GstDiscovererVideoInfo* _tmp129_;
	GVariantDict* _tmp130_;
	GstDiscovererVideoInfo* _tmp131_;
	guint _tmp132_;
	GVariantDict* _tmp133_;
	GstDiscovererVideoInfo* _tmp134_;
	guint _tmp135_;
	guint _tmp136_;
	GstDiscovererVideoInfo* _tmp137_;
	guint _tmp138_;
	GstDiscovererVideoInfo* _tmp139_;
	guint _tmp140_;
	GVariantDict* _tmp141_;
	gboolean _tmp142_;
	GList* _tmp143_;
	GList* _tmp144_;
	gconstpointer _tmp145_;
	GstDiscovererAudioInfo* ainfo;
	GList* _tmp146_;
	gconstpointer _tmp147_;
	GstDiscovererAudioInfo* _tmp148_;
	GVariantDict* _tmp149_;
	GstDiscovererAudioInfo* _tmp150_;
	guint _tmp151_;
	GVariantDict* _tmp152_;
	GstDiscovererAudioInfo* _tmp153_;
	guint _tmp154_;
	GstTagList* atags;
	GstDiscovererAudioInfo* _tmp155_;
	GstTagList* _tmp156_;
	GstTagList* _tmp157_;
	GstTagList* _tmp158_;
	gchar* artist;
	gboolean _tmp159_;
	GstTagList* _tmp160_;
	gchar* _tmp161_;
	gboolean _tmp162_;
	const gchar* _tmp163_;
	GVariantDict* _tmp164_;
	const gchar* _tmp165_;
	gchar* album;
	GstTagList* _tmp166_;
	gchar* _tmp167_;
	gboolean _tmp168_;
	GVariantDict* _tmp169_;
	const gchar* _tmp170_;
	gchar* genre;
	GstTagList* _tmp171_;
	gchar* _tmp172_;
	gboolean _tmp173_;
	GVariantDict* _tmp174_;
	const gchar* _tmp175_;
	guint volume;
	GstTagList* _tmp176_;
	guint _tmp177_;
	gboolean _tmp178_;
	GVariantDict* _tmp179_;
	guint _tmp180_;
	guint track;
	GstTagList* _tmp181_;
	guint _tmp182_;
	gboolean _tmp183_;
	GVariantDict* _tmp184_;
	guint _tmp185_;
	guint bitrate;
	GstTagList* _tmp186_;
	guint _tmp187_;
	gboolean _tmp188_;
	GVariantDict* _tmp189_;
	guint _tmp190_;
	MediaArtProcess* _tmp191_;
	GstSample* sample;
	GstTagList* _tmp192_;
	GstSample* _tmp193_;
	GstSample* _tmp194_;
	GstTagList* _tmp195_;
	GstSample* _tmp196_;
	GstSample* _tmp197_;
	gboolean _tmp198_;
	const gchar* _tmp199_;
	const gchar* _tmp200_;
	MediaArtProcess* _tmp201_;
	GFile* _tmp202_;
	GFile* _tmp203_;
	const gchar* _tmp204_;
	const gchar* _tmp205_;
	GError* _error_;
	GError* _tmp206_;
	const gchar* _tmp207_;
	GstCaps* caps;
	GstSample* _tmp208_;
	GstCaps* _tmp209_;
	GstCaps* _tmp210_;
	GstStructure* structure;
	GstCaps* _tmp211_;
	GstStructure* _tmp212_;
	gint image_type;
	GstStructure* _tmp213_;
	gint _tmp214_;
	gboolean _tmp215_;
	gint _tmp216_;
	gint _tmp217_;
	GstMapInfo map_info;
	GstSample* _tmp218_;
	GstBuffer* _tmp219_;
	GstMapInfo _tmp220_;
	guint8* data;
	GstMapInfo _tmp221_;
	guint8* _tmp222_;
	gint _tmp222__length1;
	gint data_length1;
	gint _data_size_;
	GstMapInfo _tmp223_;
	gsize _tmp224_;
	gint _tmp225_;
	MediaArtProcess* _tmp226_;
	GFile* _tmp227_;
	GFile* _tmp228_;
	guint8* _tmp229_;
	gint _tmp229__length1;
	GstStructure* _tmp230_;
	const gchar* _tmp231_;
	const gchar* _tmp232_;
	const gchar* _tmp233_;
	GError* _vala1__error_;
	GError* _tmp234_;
	const gchar* _tmp235_;
	GstSample* _tmp236_;
	GstBuffer* _tmp237_;
	GstMapInfo _tmp238_;
	GError * _inner_error_;
};


static gpointer rygel_media_export_generic_extractor_parent_class = NULL;
static GstDiscoverer* rygel_media_export_generic_extractor_discoverer;
static GstDiscoverer* rygel_media_export_generic_extractor_discoverer = NULL;
static GUPnPDLNAProfileGuesser* rygel_media_export_generic_extractor_guesser;
static GUPnPDLNAProfileGuesser* rygel_media_export_generic_extractor_guesser = NULL;
static MediaArtProcess* rygel_media_export_generic_extractor_media_art;
static MediaArtProcess* rygel_media_export_generic_extractor_media_art = NULL;

GType rygel_media_export_extractor_get_type (void) G_GNUC_CONST;
GType rygel_media_export_generic_extractor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractorPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_DUMMY_PROPERTY
};
RygelMediaExportGenericExtractor* rygel_media_export_generic_extractor_new (GFile* file);
RygelMediaExportGenericExtractor* rygel_media_export_generic_extractor_construct (GType object_type, GFile* file);
static void rygel_media_export_generic_extractor_real_run_data_free (gpointer _data);
static void rygel_media_export_generic_extractor_real_run (RygelMediaExportExtractor* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_generic_extractor_real_run_co (RygelMediaExportGenericExtractorRunData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void rygel_media_export_extractor_run (RygelMediaExportExtractor* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_extractor_run_finish (RygelMediaExportExtractor* self, GAsyncResult* _res_, GError** error);
static void rygel_media_export_generic_extractor_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GQuark extractor_error_quark (void);
static void __lambda4_ (Block1Data* _data1_, GstDiscovererInfo* _info, GError* _error);
static void ___lambda4__gst_discoverer_discovered (GstDiscoverer* _sender, GstDiscovererInfo* info, GError* err, gpointer self);
GFile* rygel_media_export_extractor_get_file (RygelMediaExportExtractor* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define UPNP_CLASS_PHOTO "object.item.imageItem.photo"
#define UPNP_CLASS_VIDEO "object.item.videoItem"
#define UPNP_CLASS_MUSIC "object.item.audioItem.musicTrack"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS "UPnPClass"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_DLNA_PROFILE "DLNAProfile"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE "MimeType"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_DURATION "Duration"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_TITLE "Title"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_DATE "Date"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_WIDTH "VideoWidth"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_HEIGHT "VideoHeight"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_DEPTH "VideoDepth"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_CHANNELS "AudioChannels"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_RATE "AudioRate"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_ARTIST "Artist"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_ALBUM "Album"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_GENRE "Genre"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VOLUME_NUMBER "VolumeNumber"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_TRACK_NUMBER "TrackNumber"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_BITRATE "AudioBitrate"
static void rygel_media_export_generic_extractor_finalize (GObject* obj);


RygelMediaExportGenericExtractor* rygel_media_export_generic_extractor_construct (GType object_type, GFile* file) {
	RygelMediaExportGenericExtractor * self = NULL;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = file;
	self = (RygelMediaExportGenericExtractor*) g_object_new (object_type, "file", _tmp0_, NULL);
	return self;
}


RygelMediaExportGenericExtractor* rygel_media_export_generic_extractor_new (GFile* file) {
	return rygel_media_export_generic_extractor_construct (RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, file);
}


static void rygel_media_export_generic_extractor_real_run_data_free (gpointer _data) {
	RygelMediaExportGenericExtractorRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportGenericExtractorRunData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_media_export_generic_extractor_real_run (RygelMediaExportExtractor* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportGenericExtractor * self;
	RygelMediaExportGenericExtractorRunData* _data_;
	RygelMediaExportGenericExtractor* _tmp0_ = NULL;
	self = (RygelMediaExportGenericExtractor*) base;
	_data_ = g_slice_new0 (RygelMediaExportGenericExtractorRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_generic_extractor_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_generic_extractor_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_generic_extractor_real_run_co (_data_);
}


static void rygel_media_export_generic_extractor_real_run_finish (RygelMediaExportExtractor* base, GAsyncResult* _res_, GError** error) {
	RygelMediaExportGenericExtractorRunData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelMediaExportGenericExtractor* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->info);
		_g_error_free0 (_data1_->_error_);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void rygel_media_export_generic_extractor_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportGenericExtractorRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_generic_extractor_real_run_co (_data_);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void __lambda4_ (Block1Data* _data1_, GstDiscovererInfo* _info, GError* _error) {
	RygelMediaExportGenericExtractor* self;
	GstDiscovererInfo* _tmp0_ = NULL;
	GstDiscovererInfo* _tmp1_ = NULL;
	GError* _tmp2_ = NULL;
	GError* _tmp3_ = NULL;
	self = _data1_->self;
	g_return_if_fail (_info != NULL);
	_tmp0_ = _info;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data1_->info);
	_data1_->info = _tmp1_;
	_tmp2_ = _error;
	_tmp3_ = _g_error_copy0 (_tmp2_);
	_g_error_free0 (_data1_->_error_);
	_data1_->_error_ = _tmp3_;
	rygel_media_export_generic_extractor_real_run_co (_data1_->_async_data_);
}


static void ___lambda4__gst_discoverer_discovered (GstDiscoverer* _sender, GstDiscovererInfo* info, GError* err, gpointer self) {
	__lambda4_ (self, info, err);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gpointer _gst_tag_list_ref0 (gpointer self) {
	return self ? gst_tag_list_ref (self) : NULL;
}


static gpointer _gst_caps_ref0 (gpointer self) {
	return self ? gst_caps_ref (self) : NULL;
}


static gboolean rygel_media_export_generic_extractor_real_run_co (RygelMediaExportGenericExtractorRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_state_ = 1;
	RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS (rygel_media_export_generic_extractor_parent_class)->run (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor), rygel_media_export_generic_extractor_run_ready, _data_);
	return FALSE;
	_state_1:
	RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS (rygel_media_export_generic_extractor_parent_class)->run_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor), _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = rygel_media_export_generic_extractor_discoverer;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = g_error_new_literal (EXTRACTOR_ERROR, EXTRACTOR_ERROR_GENERAL, "Backend not avaliable");
		_data_->_inner_error_ = _data_->_tmp1_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_data1_->_error_ = NULL;
	_data_->_data1_->info = NULL;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = rygel_media_export_generic_extractor_discoverer;
	_data_->_tmp3_ = 0UL;
	_data_->_tmp3_ = g_signal_connect_data (_data_->_tmp2_, "discovered", (GCallback) ___lambda4__gst_discoverer_discovered, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
	_data_->id = _data_->_tmp3_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_file_get_path (_data_->_tmp5_);
	_data_->path = _data_->_tmp6_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = g_file_get_uri (_data_->_tmp8_);
	_data_->uri = _data_->_tmp9_;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->path;
	if (_data_->_tmp10_ != NULL) {
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->path;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = g_filename_to_uri (_data_->_tmp12_, NULL, &_data_->_inner_error_);
		_data_->_tmp11_ = _data_->_tmp13_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->uri);
			_g_free0 (_data_->path);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->_tmp11_;
		_data_->_tmp11_ = NULL;
		_g_free0 (_data_->uri);
		_data_->uri = _data_->_tmp14_;
		_g_free0 (_data_->_tmp11_);
	}
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = rygel_media_export_generic_extractor_discoverer;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->uri;
	gst_discoverer_discover_uri_async (_data_->_tmp15_, _data_->_tmp16_);
	_data_->_state_ = 2;
	return FALSE;
	_state_2:
	;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = rygel_media_export_generic_extractor_discoverer;
	_data_->_tmp18_ = 0UL;
	_data_->_tmp18_ = _data_->id;
	g_signal_handler_disconnect ((GObject*) _data_->_tmp17_, _data_->_tmp18_);
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->_data1_->_error_;
	if (_data_->_tmp19_ != NULL) {
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = rygel_media_export_generic_extractor_discoverer;
		gst_discoverer_stop (_data_->_tmp20_);
		_g_object_unref0 (rygel_media_export_generic_extractor_discoverer);
		rygel_media_export_generic_extractor_discoverer = NULL;
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = gst_discoverer_new ((GstClockTime) (10 * GST_SECOND), &_data_->_inner_error_);
		_data_->_tmp21_ = _data_->_tmp22_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->uri);
			_g_free0 (_data_->path);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->_tmp21_;
		_data_->_tmp21_ = NULL;
		_g_object_unref0 (rygel_media_export_generic_extractor_discoverer);
		rygel_media_export_generic_extractor_discoverer = _data_->_tmp23_;
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = rygel_media_export_generic_extractor_discoverer;
		gst_discoverer_start (_data_->_tmp24_);
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->_data1_->info;
		_data_->_tmp26_ = 0;
		_data_->_tmp26_ = gst_discoverer_info_get_result (_data_->_tmp25_);
		_data_->_result_ = _data_->_tmp26_;
		_data_->_tmp27_ = 0;
		_data_->_tmp27_ = _data_->_result_;
		if (_data_->_tmp27_ == GST_DISCOVERER_TIMEOUT) {
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = _data_->_tmp28_;
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = g_file_get_uri (_data_->_tmp29_);
			_data_->_tmp31_ = NULL;
			_data_->_tmp31_ = _data_->_tmp30_;
			g_debug ("rygel-media-export-generic-extractor.vala:93: Extraction timed out on " \
"%s", _data_->_tmp31_);
			_g_free0 (_data_->_tmp31_);
		} else {
			_data_->_tmp32_ = 0;
			_data_->_tmp32_ = _data_->_result_;
			if (_data_->_tmp32_ == GST_DISCOVERER_MISSING_PLUGINS) {
				_data_->_tmp33_ = NULL;
				_data_->_tmp33_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
				_data_->_tmp34_ = NULL;
				_data_->_tmp34_ = _data_->_tmp33_;
				_data_->_tmp35_ = NULL;
				_data_->_tmp35_ = g_file_get_uri (_data_->_tmp34_);
				_data_->_tmp36_ = NULL;
				_data_->_tmp36_ = _data_->_tmp35_;
				g_debug ("rygel-media-export-generic-extractor.vala:95: Plugins are missing for " \
"extraction of file %s", _data_->_tmp36_);
				_g_free0 (_data_->_tmp36_);
			}
		}
		_data_->_tmp37_ = NULL;
		_data_->_tmp37_ = _data_->_data1_->_error_;
		_data_->_tmp38_ = NULL;
		_data_->_tmp38_ = _g_error_copy0 (_data_->_tmp37_);
		_data_->_inner_error_ = _data_->_tmp38_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->_tmp21_);
		_g_free0 (_data_->uri);
		_g_free0 (_data_->path);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = _data_->_data1_->info;
	_data_->_tmp40_ = NULL;
	_data_->_tmp40_ = gst_discoverer_info_get_audio_streams (_data_->_tmp39_);
	_data_->audio_streams = (GList*) _data_->_tmp40_;
	_data_->_tmp41_ = NULL;
	_data_->_tmp41_ = _data_->_data1_->info;
	_data_->_tmp42_ = NULL;
	_data_->_tmp42_ = gst_discoverer_info_get_video_streams (_data_->_tmp41_);
	_data_->video_streams = (GList*) _data_->_tmp42_;
	_data_->_tmp44_ = NULL;
	_data_->_tmp44_ = _data_->audio_streams;
	if (_data_->_tmp44_ == NULL) {
		_data_->_tmp45_ = NULL;
		_data_->_tmp45_ = _data_->video_streams;
		_data_->_tmp43_ = _data_->_tmp45_ == NULL;
	} else {
		_data_->_tmp43_ = FALSE;
	}
	if (_data_->_tmp43_) {
		_data_->_tmp46_ = NULL;
		_data_->_tmp46_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
		_data_->_tmp47_ = NULL;
		_data_->_tmp47_ = _data_->_tmp46_;
		_data_->_tmp48_ = NULL;
		_data_->_tmp48_ = g_file_get_uri (_data_->_tmp47_);
		_data_->_tmp49_ = NULL;
		_data_->_tmp49_ = _data_->_tmp48_;
		g_debug ("rygel-media-export-generic-extractor.vala:108: %s had neither audio no" \
"r video/picture streams. Ignoring.", _data_->_tmp49_);
		_g_free0 (_data_->_tmp49_);
		_data_->_tmp50_ = NULL;
		_data_->_tmp50_ = g_error_new_literal (EXTRACTOR_ERROR, EXTRACTOR_ERROR_GENERAL, "No stream information");
		_data_->_inner_error_ = _data_->_tmp50_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		__g_list_free__g_object_unref0_0 (_data_->video_streams);
		__g_list_free__g_object_unref0_0 (_data_->audio_streams);
		_g_free0 (_data_->uri);
		_g_free0 (_data_->path);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp51_ = NULL;
	_data_->_tmp51_ = g_strdup ("object.item");
	_g_free0 (_data_->self->priv->upnp_class);
	_data_->self->priv->upnp_class = _data_->_tmp51_;
	_data_->_tmp53_ = NULL;
	_data_->_tmp53_ = _data_->audio_streams;
	if (_data_->_tmp53_ == NULL) {
		_data_->_tmp54_ = NULL;
		_data_->_tmp54_ = _data_->video_streams;
		_data_->_tmp55_ = NULL;
		_data_->_tmp55_ = _data_->_tmp54_->data;
		_data_->_tmp56_ = FALSE;
		_data_->_tmp56_ = gst_discoverer_video_info_is_image ((GstDiscovererVideoInfo*) _data_->_tmp55_);
		_data_->_tmp52_ = _data_->_tmp56_;
	} else {
		_data_->_tmp52_ = FALSE;
	}
	if (_data_->_tmp52_) {
		_data_->_tmp57_ = NULL;
		_data_->_tmp57_ = g_strdup (UPNP_CLASS_PHOTO);
		_g_free0 (_data_->self->priv->upnp_class);
		_data_->self->priv->upnp_class = _data_->_tmp57_;
	} else {
		_data_->_tmp58_ = NULL;
		_data_->_tmp58_ = _data_->video_streams;
		if (_data_->_tmp58_ != NULL) {
			_data_->_tmp59_ = NULL;
			_data_->_tmp59_ = g_strdup (UPNP_CLASS_VIDEO);
			_g_free0 (_data_->self->priv->upnp_class);
			_data_->self->priv->upnp_class = _data_->_tmp59_;
		} else {
			_data_->_tmp60_ = NULL;
			_data_->_tmp60_ = _data_->audio_streams;
			if (_data_->_tmp60_ != NULL) {
				_data_->_tmp61_ = NULL;
				_data_->_tmp61_ = g_strdup (UPNP_CLASS_MUSIC);
				_g_free0 (_data_->self->priv->upnp_class);
				_data_->self->priv->upnp_class = _data_->_tmp61_;
			}
		}
	}
	_data_->_tmp62_ = NULL;
	_data_->_tmp62_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
	_data_->_tmp63_ = NULL;
	_data_->_tmp63_ = _data_->self->priv->upnp_class;
	g_variant_dict_insert (_data_->_tmp62_, RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS, "s", _data_->_tmp63_, NULL);
	_data_->_tmp64_ = NULL;
	_data_->_tmp64_ = _data_->_data1_->info;
	_data_->_tmp65_ = NULL;
	_data_->_tmp65_ = gupnp_dlna_gst_utils_information_from_discoverer_info (_data_->_tmp64_);
	_data_->dlna_info = _data_->_tmp65_;
	_data_->_tmp66_ = NULL;
	_data_->_tmp66_ = rygel_media_export_generic_extractor_guesser;
	_data_->_tmp67_ = NULL;
	_data_->_tmp67_ = _data_->dlna_info;
	_data_->_tmp68_ = NULL;
	_data_->_tmp68_ = gupnp_dlna_profile_guesser_guess_profile_from_info (_data_->_tmp66_, _data_->_tmp67_);
	_data_->_tmp69_ = NULL;
	_data_->_tmp69_ = _g_object_ref0 (_data_->_tmp68_);
	_data_->dlna = _data_->_tmp69_;
	_data_->_tmp70_ = NULL;
	_data_->_tmp70_ = _data_->dlna;
	if (_data_->_tmp70_ != NULL) {
		_data_->_tmp71_ = NULL;
		_data_->_tmp71_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp72_ = NULL;
		_data_->_tmp72_ = _data_->dlna;
		_data_->_tmp73_ = NULL;
		_data_->_tmp73_ = gupnp_dlna_profile_get_name (_data_->_tmp72_);
		_data_->_tmp74_ = NULL;
		_data_->_tmp74_ = _data_->_tmp73_;
		g_variant_dict_insert (_data_->_tmp71_, RYGEL_MEDIA_EXPORT_SERIALIZER_DLNA_PROFILE, "s", _data_->_tmp74_, NULL);
		_data_->_tmp75_ = NULL;
		_data_->_tmp75_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp76_ = NULL;
		_data_->_tmp76_ = _data_->dlna;
		_data_->_tmp77_ = NULL;
		_data_->_tmp77_ = gupnp_dlna_profile_get_mime (_data_->_tmp76_);
		_data_->_tmp78_ = NULL;
		_data_->_tmp78_ = _data_->_tmp77_;
		g_variant_dict_insert (_data_->_tmp75_, RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE, "s", _data_->_tmp78_, NULL);
	}
	_data_->_tmp79_ = NULL;
	_data_->_tmp79_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
	g_variant_dict_lookup (_data_->_tmp79_, RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE, "s", &_data_->self->priv->mime_type, NULL);
	_data_->duration = (glong) -1;
	_data_->_tmp80_ = NULL;
	_data_->_tmp80_ = _data_->_data1_->info;
	_data_->_tmp81_ = 0ULL;
	_data_->_tmp81_ = gst_discoverer_info_get_duration (_data_->_tmp80_);
	if (_data_->_tmp81_ > ((GstClockTime) 0)) {
		_data_->_tmp82_ = NULL;
		_data_->_tmp82_ = _data_->_data1_->info;
		_data_->_tmp83_ = 0ULL;
		_data_->_tmp83_ = gst_discoverer_info_get_duration (_data_->_tmp82_);
		_data_->duration = (glong) (_data_->_tmp83_ / GST_SECOND);
		_data_->_tmp84_ = NULL;
		_data_->_tmp84_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp85_ = 0L;
		_data_->_tmp85_ = _data_->duration;
		g_variant_dict_insert (_data_->_tmp84_, RYGEL_MEDIA_EXPORT_SERIALIZER_DURATION, "i", _data_->_tmp85_, NULL);
	}
	_data_->_tmp86_ = NULL;
	_data_->_tmp86_ = _data_->_data1_->info;
	_data_->_tmp87_ = NULL;
	_data_->_tmp87_ = gst_discoverer_info_get_tags (_data_->_tmp86_);
	_data_->_tmp88_ = NULL;
	_data_->_tmp88_ = _gst_tag_list_ref0 (_data_->_tmp87_);
	_data_->tags = _data_->_tmp88_;
	_data_->_tmp89_ = NULL;
	_data_->_tmp89_ = _data_->tags;
	if (_data_->_tmp89_ != NULL) {
		_data_->title = NULL;
		_data_->_tmp90_ = NULL;
		_data_->_tmp90_ = _data_->tags;
		_data_->_tmp91_ = NULL;
		_data_->_tmp92_ = FALSE;
		_data_->_tmp92_ = gst_tag_list_get_string (_data_->_tmp90_, GST_TAG_TITLE, &_data_->_tmp91_);
		_g_free0 (_data_->title);
		_data_->title = _data_->_tmp91_;
		if (_data_->_tmp92_) {
			_data_->_tmp94_ = NULL;
			_data_->_tmp94_ = _data_->self->priv->mime_type;
			if (g_strcmp0 (_data_->_tmp94_, "video/x-msvideo") != 0) {
				_data_->_tmp95_ = NULL;
				_data_->_tmp95_ = _data_->title;
				_data_->_tmp93_ = _data_->_tmp95_ != NULL;
			} else {
				_data_->_tmp93_ = FALSE;
			}
			if (_data_->_tmp93_) {
				_data_->_tmp96_ = NULL;
				_data_->_tmp96_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				_data_->_tmp97_ = NULL;
				_data_->_tmp97_ = _data_->title;
				g_variant_dict_insert (_data_->_tmp96_, RYGEL_MEDIA_EXPORT_SERIALIZER_TITLE, "s", _data_->_tmp97_, NULL);
			}
		}
		_data_->date = NULL;
		_data_->dt = NULL;
		_data_->_tmp98_ = NULL;
		_data_->_tmp98_ = _data_->tags;
		_data_->_tmp99_ = NULL;
		_data_->_tmp100_ = FALSE;
		_data_->_tmp100_ = gst_tag_list_get_date_time (_data_->_tmp98_, GST_TAG_DATE_TIME, &_data_->_tmp99_);
		_gst_date_time_unref0 (_data_->dt);
		_data_->dt = _data_->_tmp99_;
		if (_data_->_tmp100_) {
			_data_->_tmp102_ = NULL;
			_data_->_tmp102_ = _data_->dt;
			_data_->_tmp103_ = FALSE;
			_data_->_tmp103_ = gst_date_time_has_day (_data_->_tmp102_);
			if (!_data_->_tmp103_) {
				_data_->_tmp101_ = TRUE;
			} else {
				_data_->_tmp104_ = NULL;
				_data_->_tmp104_ = _data_->dt;
				_data_->_tmp105_ = FALSE;
				_data_->_tmp105_ = gst_date_time_has_month (_data_->_tmp104_);
				_data_->_tmp101_ = !_data_->_tmp105_;
			}
			if (_data_->_tmp101_) {
				_data_->_tmp107_ = NULL;
				_data_->_tmp107_ = _data_->dt;
				_data_->_tmp108_ = FALSE;
				_data_->_tmp108_ = gst_date_time_has_month (_data_->_tmp107_);
				if (_data_->_tmp108_) {
					_data_->_tmp109_ = NULL;
					_data_->_tmp109_ = _data_->dt;
					_data_->_tmp110_ = 0;
					_data_->_tmp110_ = gst_date_time_get_month (_data_->_tmp109_);
					_data_->_tmp106_ = _data_->_tmp110_;
				} else {
					_data_->_tmp106_ = 1;
				}
				_data_->_tmp112_ = NULL;
				_data_->_tmp112_ = _data_->dt;
				_data_->_tmp113_ = FALSE;
				_data_->_tmp113_ = gst_date_time_has_day (_data_->_tmp112_);
				if (_data_->_tmp113_) {
					_data_->_tmp114_ = NULL;
					_data_->_tmp114_ = _data_->dt;
					_data_->_tmp115_ = 0;
					_data_->_tmp115_ = gst_date_time_get_day (_data_->_tmp114_);
					_data_->_tmp111_ = _data_->_tmp115_;
				} else {
					_data_->_tmp111_ = 1;
				}
				_data_->_tmp116_ = NULL;
				_data_->_tmp116_ = _data_->dt;
				_data_->_tmp117_ = 0;
				_data_->_tmp117_ = gst_date_time_get_year (_data_->_tmp116_);
				_data_->_tmp118_ = NULL;
				_data_->_tmp118_ = g_strdup_printf ("%d-%02d-%02d", _data_->_tmp117_, _data_->_tmp106_, _data_->_tmp111_);
				_g_free0 (_data_->date);
				_data_->date = _data_->_tmp118_;
			} else {
				_data_->_tmp119_ = NULL;
				_data_->_tmp119_ = _data_->dt;
				_data_->_tmp120_ = NULL;
				_data_->_tmp120_ = gst_date_time_to_iso8601_string (_data_->_tmp119_);
				_g_free0 (_data_->date);
				_data_->date = _data_->_tmp120_;
			}
			_data_->_tmp121_ = NULL;
			_data_->_tmp121_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
			_data_->_tmp122_ = NULL;
			_data_->_tmp122_ = _data_->date;
			g_variant_dict_insert (_data_->_tmp121_, RYGEL_MEDIA_EXPORT_SERIALIZER_DATE, "s", _data_->_tmp122_, NULL);
		}
		_gst_date_time_unref0 (_data_->dt);
		_g_free0 (_data_->date);
		_g_free0 (_data_->title);
	}
	_data_->_tmp124_ = NULL;
	_data_->_tmp124_ = _data_->video_streams;
	if (_data_->_tmp124_ != NULL) {
		_data_->_tmp125_ = NULL;
		_data_->_tmp125_ = _data_->video_streams;
		_data_->_tmp126_ = NULL;
		_data_->_tmp126_ = _data_->_tmp125_->data;
		_data_->_tmp123_ = ((GstDiscovererVideoInfo*) _data_->_tmp126_) != NULL;
	} else {
		_data_->_tmp123_ = FALSE;
	}
	if (_data_->_tmp123_) {
		_data_->_tmp127_ = NULL;
		_data_->_tmp127_ = _data_->video_streams;
		_data_->_tmp128_ = NULL;
		_data_->_tmp128_ = _data_->_tmp127_->data;
		_data_->_tmp129_ = NULL;
		_data_->_tmp129_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GstDiscovererVideoInfo*) _data_->_tmp128_, gst_discoverer_video_info_get_type (), GstDiscovererVideoInfo));
		_data_->vinfo = _data_->_tmp129_;
		_data_->_tmp130_ = NULL;
		_data_->_tmp130_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp131_ = NULL;
		_data_->_tmp131_ = _data_->vinfo;
		_data_->_tmp132_ = 0U;
		_data_->_tmp132_ = gst_discoverer_video_info_get_width (_data_->_tmp131_);
		g_variant_dict_insert (_data_->_tmp130_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_WIDTH, "i", (gint) _data_->_tmp132_, NULL);
		_data_->_tmp133_ = NULL;
		_data_->_tmp133_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp134_ = NULL;
		_data_->_tmp134_ = _data_->vinfo;
		_data_->_tmp135_ = 0U;
		_data_->_tmp135_ = gst_discoverer_video_info_get_height (_data_->_tmp134_);
		g_variant_dict_insert (_data_->_tmp133_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_HEIGHT, "i", (gint) _data_->_tmp135_, NULL);
		_data_->_tmp137_ = NULL;
		_data_->_tmp137_ = _data_->vinfo;
		_data_->_tmp138_ = 0U;
		_data_->_tmp138_ = gst_discoverer_video_info_get_depth (_data_->_tmp137_);
		if (_data_->_tmp138_ > ((guint) 0)) {
			_data_->_tmp139_ = NULL;
			_data_->_tmp139_ = _data_->vinfo;
			_data_->_tmp140_ = 0U;
			_data_->_tmp140_ = gst_discoverer_video_info_get_depth (_data_->_tmp139_);
			_data_->_tmp136_ = _data_->_tmp140_;
		} else {
			_data_->_tmp136_ = (guint) -1;
		}
		_data_->_tmp141_ = NULL;
		_data_->_tmp141_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		g_variant_dict_insert (_data_->_tmp141_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_DEPTH, "i", _data_->_tmp136_, NULL);
		_g_object_unref0 (_data_->vinfo);
	}
	_data_->_tmp143_ = NULL;
	_data_->_tmp143_ = _data_->audio_streams;
	if (_data_->_tmp143_ != NULL) {
		_data_->_tmp144_ = NULL;
		_data_->_tmp144_ = _data_->audio_streams;
		_data_->_tmp145_ = NULL;
		_data_->_tmp145_ = _data_->_tmp144_->data;
		_data_->_tmp142_ = ((GstDiscovererAudioInfo*) _data_->_tmp145_) != NULL;
	} else {
		_data_->_tmp142_ = FALSE;
	}
	if (_data_->_tmp142_) {
		_data_->_tmp146_ = NULL;
		_data_->_tmp146_ = _data_->audio_streams;
		_data_->_tmp147_ = NULL;
		_data_->_tmp147_ = _data_->_tmp146_->data;
		_data_->_tmp148_ = NULL;
		_data_->_tmp148_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GstDiscovererAudioInfo*) _data_->_tmp147_, gst_discoverer_audio_info_get_type (), GstDiscovererAudioInfo));
		_data_->ainfo = _data_->_tmp148_;
		_data_->_tmp149_ = NULL;
		_data_->_tmp149_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp150_ = NULL;
		_data_->_tmp150_ = _data_->ainfo;
		_data_->_tmp151_ = 0U;
		_data_->_tmp151_ = gst_discoverer_audio_info_get_channels (_data_->_tmp150_);
		g_variant_dict_insert (_data_->_tmp149_, RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_CHANNELS, "i", (gint) _data_->_tmp151_, NULL);
		_data_->_tmp152_ = NULL;
		_data_->_tmp152_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp153_ = NULL;
		_data_->_tmp153_ = _data_->ainfo;
		_data_->_tmp154_ = 0U;
		_data_->_tmp154_ = gst_discoverer_audio_info_get_sample_rate (_data_->_tmp153_);
		g_variant_dict_insert (_data_->_tmp152_, RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_RATE, "i", (gint) _data_->_tmp154_, NULL);
		_data_->_tmp155_ = NULL;
		_data_->_tmp155_ = _data_->ainfo;
		_data_->_tmp156_ = NULL;
		_data_->_tmp156_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _data_->_tmp155_);
		_data_->_tmp157_ = NULL;
		_data_->_tmp157_ = _gst_tag_list_ref0 (_data_->_tmp156_);
		_data_->atags = _data_->_tmp157_;
		_data_->_tmp158_ = NULL;
		_data_->_tmp158_ = _data_->atags;
		if (_data_->_tmp158_ != NULL) {
			_data_->artist = NULL;
			_data_->_tmp160_ = NULL;
			_data_->_tmp160_ = _data_->atags;
			_data_->_tmp161_ = NULL;
			_data_->_tmp162_ = FALSE;
			_data_->_tmp162_ = gst_tag_list_get_string (_data_->_tmp160_, GST_TAG_ARTIST, &_data_->_tmp161_);
			_g_free0 (_data_->artist);
			_data_->artist = _data_->_tmp161_;
			if (_data_->_tmp162_) {
				_data_->_tmp163_ = NULL;
				_data_->_tmp163_ = _data_->self->priv->mime_type;
				_data_->_tmp159_ = g_strcmp0 (_data_->_tmp163_, "video/x-msvideo") != 0;
			} else {
				_data_->_tmp159_ = FALSE;
			}
			if (_data_->_tmp159_) {
				_data_->_tmp164_ = NULL;
				_data_->_tmp164_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				_data_->_tmp165_ = NULL;
				_data_->_tmp165_ = _data_->artist;
				g_variant_dict_insert (_data_->_tmp164_, RYGEL_MEDIA_EXPORT_SERIALIZER_ARTIST, "s", _data_->_tmp165_, NULL);
			}
			_data_->album = NULL;
			_data_->_tmp166_ = NULL;
			_data_->_tmp166_ = _data_->atags;
			_data_->_tmp167_ = NULL;
			_data_->_tmp168_ = FALSE;
			_data_->_tmp168_ = gst_tag_list_get_string (_data_->_tmp166_, GST_TAG_ALBUM, &_data_->_tmp167_);
			_g_free0 (_data_->album);
			_data_->album = _data_->_tmp167_;
			if (_data_->_tmp168_) {
				_data_->_tmp169_ = NULL;
				_data_->_tmp169_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				_data_->_tmp170_ = NULL;
				_data_->_tmp170_ = _data_->album;
				g_variant_dict_insert (_data_->_tmp169_, RYGEL_MEDIA_EXPORT_SERIALIZER_ALBUM, "s", _data_->_tmp170_, NULL);
			}
			_data_->genre = NULL;
			_data_->_tmp171_ = NULL;
			_data_->_tmp171_ = _data_->atags;
			_data_->_tmp172_ = NULL;
			_data_->_tmp173_ = FALSE;
			_data_->_tmp173_ = gst_tag_list_get_string (_data_->_tmp171_, GST_TAG_GENRE, &_data_->_tmp172_);
			_g_free0 (_data_->genre);
			_data_->genre = _data_->_tmp172_;
			if (_data_->_tmp173_) {
				_data_->_tmp174_ = NULL;
				_data_->_tmp174_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				_data_->_tmp175_ = NULL;
				_data_->_tmp175_ = _data_->genre;
				g_variant_dict_insert (_data_->_tmp174_, RYGEL_MEDIA_EXPORT_SERIALIZER_GENRE, "s", _data_->_tmp175_, NULL);
			}
			_data_->volume = G_MAXUINT;
			_data_->_tmp176_ = NULL;
			_data_->_tmp176_ = _data_->atags;
			_data_->_tmp177_ = 0U;
			_data_->_tmp178_ = FALSE;
			_data_->_tmp178_ = gst_tag_list_get_uint (_data_->_tmp176_, GST_TAG_ALBUM_VOLUME_NUMBER, &_data_->_tmp177_);
			_data_->volume = _data_->_tmp177_;
			if (_data_->_tmp178_) {
				_data_->_tmp179_ = NULL;
				_data_->_tmp179_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				_data_->_tmp180_ = 0U;
				_data_->_tmp180_ = _data_->volume;
				g_variant_dict_insert (_data_->_tmp179_, RYGEL_MEDIA_EXPORT_SERIALIZER_VOLUME_NUMBER, "i", _data_->_tmp180_, NULL);
			}
			_data_->track = G_MAXUINT;
			_data_->_tmp181_ = NULL;
			_data_->_tmp181_ = _data_->atags;
			_data_->_tmp182_ = 0U;
			_data_->_tmp183_ = FALSE;
			_data_->_tmp183_ = gst_tag_list_get_uint (_data_->_tmp181_, GST_TAG_TRACK_NUMBER, &_data_->_tmp182_);
			_data_->track = _data_->_tmp182_;
			if (_data_->_tmp183_) {
				_data_->_tmp184_ = NULL;
				_data_->_tmp184_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				_data_->_tmp185_ = 0U;
				_data_->_tmp185_ = _data_->track;
				g_variant_dict_insert (_data_->_tmp184_, RYGEL_MEDIA_EXPORT_SERIALIZER_TRACK_NUMBER, "i", _data_->_tmp185_, NULL);
			}
			_data_->bitrate = G_MAXUINT;
			_data_->_tmp186_ = NULL;
			_data_->_tmp186_ = _data_->atags;
			_data_->_tmp187_ = 0U;
			_data_->_tmp188_ = FALSE;
			_data_->_tmp188_ = gst_tag_list_get_uint (_data_->_tmp186_, GST_TAG_BITRATE, &_data_->_tmp187_);
			_data_->bitrate = _data_->_tmp187_;
			if (_data_->_tmp188_) {
				_data_->_tmp189_ = NULL;
				_data_->_tmp189_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				_data_->_tmp190_ = 0U;
				_data_->_tmp190_ = _data_->bitrate;
				g_variant_dict_insert (_data_->_tmp189_, RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_BITRATE, "i", ((gint) _data_->_tmp190_) / 8, NULL);
			}
			_data_->_tmp191_ = NULL;
			_data_->_tmp191_ = rygel_media_export_generic_extractor_media_art;
			if (_data_->_tmp191_ != NULL) {
				_data_->_tmp192_ = NULL;
				_data_->_tmp192_ = _data_->atags;
				_data_->_tmp193_ = NULL;
				gst_tag_list_get_sample (_data_->_tmp192_, GST_TAG_IMAGE, &_data_->_tmp193_);
				_gst_sample_unref0 (_data_->sample);
				_data_->sample = _data_->_tmp193_;
				_data_->_tmp194_ = NULL;
				_data_->_tmp194_ = _data_->sample;
				if (_data_->_tmp194_ == NULL) {
					_data_->_tmp195_ = NULL;
					_data_->_tmp195_ = _data_->atags;
					_data_->_tmp196_ = NULL;
					gst_tag_list_get_sample (_data_->_tmp195_, GST_TAG_PREVIEW_IMAGE, &_data_->_tmp196_);
					_gst_sample_unref0 (_data_->sample);
					_data_->sample = _data_->_tmp196_;
				}
				_data_->_tmp197_ = NULL;
				_data_->_tmp197_ = _data_->sample;
				if (_data_->_tmp197_ == NULL) {
					{
						_data_->_tmp199_ = NULL;
						_data_->_tmp199_ = _data_->artist;
						if (_data_->_tmp199_ != NULL) {
							_data_->_tmp198_ = TRUE;
						} else {
							_data_->_tmp200_ = NULL;
							_data_->_tmp200_ = _data_->album;
							_data_->_tmp198_ = _data_->_tmp200_ != NULL;
						}
						if (_data_->_tmp198_) {
							_data_->_tmp201_ = NULL;
							_data_->_tmp201_ = rygel_media_export_generic_extractor_media_art;
							_data_->_tmp202_ = NULL;
							_data_->_tmp202_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
							_data_->_tmp203_ = NULL;
							_data_->_tmp203_ = _data_->_tmp202_;
							_data_->_tmp204_ = NULL;
							_data_->_tmp204_ = _data_->artist;
							_data_->_tmp205_ = NULL;
							_data_->_tmp205_ = _data_->album;
							media_art_process_file (_data_->_tmp201_, MEDIA_ART_ALBUM, MEDIA_ART_PROCESS_FLAGS_NONE, _data_->_tmp203_, _data_->_tmp204_, _data_->_tmp205_, NULL, &_data_->_inner_error_);
							if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
								goto __catch9_g_error;
							}
						}
					}
					goto __finally9;
					__catch9_g_error:
					{
						_data_->_error_ = _data_->_inner_error_;
						_data_->_inner_error_ = NULL;
						_data_->_tmp206_ = NULL;
						_data_->_tmp206_ = _data_->_error_;
						_data_->_tmp207_ = NULL;
						_data_->_tmp207_ = _data_->_tmp206_->message;
						g_debug ("rygel-media-export-generic-extractor.vala:243: Failed to add external " \
"media art: %s", _data_->_tmp207_);
						_g_error_free0 (_data_->_error_);
					}
					__finally9:
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
						g_error_free (_data_->_inner_error_);
						_gst_sample_unref0 (_data_->sample);
						_g_free0 (_data_->genre);
						_g_free0 (_data_->album);
						_g_free0 (_data_->artist);
						_gst_tag_list_unref0 (_data_->atags);
						_g_object_unref0 (_data_->ainfo);
						_gst_tag_list_unref0 (_data_->tags);
						_g_object_unref0 (_data_->dlna);
						_g_object_unref0 (_data_->dlna_info);
						__g_list_free__g_object_unref0_0 (_data_->video_streams);
						__g_list_free__g_object_unref0_0 (_data_->audio_streams);
						_g_free0 (_data_->uri);
						_g_free0 (_data_->path);
						block1_data_unref (_data_->_data1_);
						_data_->_data1_ = NULL;
						if (_data_->_state_ == 0) {
							g_simple_async_result_complete_in_idle (_data_->_async_result);
						} else {
							g_simple_async_result_complete (_data_->_async_result);
						}
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				} else {
					_data_->_tmp208_ = NULL;
					_data_->_tmp208_ = _data_->sample;
					_data_->_tmp209_ = NULL;
					_data_->_tmp209_ = gst_sample_get_caps (_data_->_tmp208_);
					_data_->_tmp210_ = NULL;
					_data_->_tmp210_ = _gst_caps_ref0 (_data_->_tmp209_);
					_data_->caps = _data_->_tmp210_;
					_data_->_tmp211_ = NULL;
					_data_->_tmp211_ = _data_->caps;
					_data_->_tmp212_ = NULL;
					_data_->_tmp212_ = gst_caps_get_structure (_data_->_tmp211_, (guint) 0);
					_data_->structure = _data_->_tmp212_;
					_data_->_tmp213_ = NULL;
					_data_->_tmp213_ = _data_->structure;
					_data_->_tmp214_ = 0;
					gst_structure_get_enum (_data_->_tmp213_, "image-type", gst_tag_image_type_get_type (), &_data_->_tmp214_);
					_data_->image_type = _data_->_tmp214_;
					_data_->_tmp216_ = 0;
					_data_->_tmp216_ = _data_->image_type;
					if (_data_->_tmp216_ == ((gint) GST_TAG_IMAGE_TYPE_UNDEFINED)) {
						_data_->_tmp215_ = TRUE;
					} else {
						_data_->_tmp217_ = 0;
						_data_->_tmp217_ = _data_->image_type;
						_data_->_tmp215_ = _data_->_tmp217_ == ((gint) GST_TAG_IMAGE_TYPE_FRONT_COVER);
					}
					if (_data_->_tmp215_) {
						_data_->_tmp218_ = NULL;
						_data_->_tmp218_ = _data_->sample;
						_data_->_tmp219_ = NULL;
						_data_->_tmp219_ = gst_sample_get_buffer (_data_->_tmp218_);
						memset (&_data_->_tmp220_, 0, sizeof (GstMapInfo));
						gst_buffer_map (_data_->_tmp219_, &_data_->_tmp220_, GST_MAP_READ);
						_data_->map_info = _data_->_tmp220_;
						memset (&_data_->_tmp221_, 0, sizeof (GstMapInfo));
						_data_->_tmp221_ = _data_->map_info;
						_data_->_tmp222_ = NULL;
						_data_->_tmp222__length1 = 0;
						_data_->_tmp222_ = _data_->_tmp221_.data;
						_data_->_tmp222__length1 = (gint) _data_->_tmp221_.size;
						_data_->data_length1 = 0;
						_data_->_data_size_ = 0;
						_data_->data = _data_->_tmp222_;
						_data_->data_length1 = _data_->_tmp222__length1;
						_data_->_data_size_ = _data_->data_length1;
						memset (&_data_->_tmp223_, 0, sizeof (GstMapInfo));
						_data_->_tmp223_ = _data_->map_info;
						_data_->_tmp224_ = 0UL;
						_data_->_tmp224_ = _data_->_tmp223_.size;
						_data_->data_length1 = (gint) _data_->_tmp224_;
						_data_->_tmp225_ = 0;
						_data_->_tmp225_ = _data_->data_length1;
						{
							_data_->_tmp226_ = NULL;
							_data_->_tmp226_ = rygel_media_export_generic_extractor_media_art;
							_data_->_tmp227_ = NULL;
							_data_->_tmp227_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
							_data_->_tmp228_ = NULL;
							_data_->_tmp228_ = _data_->_tmp227_;
							_data_->_tmp229_ = NULL;
							_data_->_tmp229__length1 = 0;
							_data_->_tmp229_ = _data_->data;
							_data_->_tmp229__length1 = _data_->data_length1;
							_data_->_tmp230_ = NULL;
							_data_->_tmp230_ = _data_->structure;
							_data_->_tmp231_ = NULL;
							_data_->_tmp231_ = gst_structure_get_name (_data_->_tmp230_);
							_data_->_tmp232_ = NULL;
							_data_->_tmp232_ = _data_->artist;
							_data_->_tmp233_ = NULL;
							_data_->_tmp233_ = _data_->album;
							media_art_process_buffer (_data_->_tmp226_, MEDIA_ART_ALBUM, MEDIA_ART_PROCESS_FLAGS_NONE, _data_->_tmp228_, _data_->_tmp229_, (gsize) _data_->_tmp229__length1, _data_->_tmp231_, _data_->_tmp232_, _data_->_tmp233_, NULL, &_data_->_inner_error_);
							if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
								goto __catch10_g_error;
							}
						}
						goto __finally10;
						__catch10_g_error:
						{
							_data_->_vala1__error_ = _data_->_inner_error_;
							_data_->_inner_error_ = NULL;
							_data_->_tmp234_ = NULL;
							_data_->_tmp234_ = _data_->_vala1__error_;
							_data_->_tmp235_ = NULL;
							_data_->_tmp235_ = _data_->_tmp234_->message;
							g_debug ("rygel-media-export-generic-extractor.vala:273: Failed to add media art" \
" to cache: %s", _data_->_tmp235_);
							_g_error_free0 (_data_->_vala1__error_);
						}
						__finally10:
						if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
							g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
							g_error_free (_data_->_inner_error_);
							_gst_caps_unref0 (_data_->caps);
							_gst_sample_unref0 (_data_->sample);
							_g_free0 (_data_->genre);
							_g_free0 (_data_->album);
							_g_free0 (_data_->artist);
							_gst_tag_list_unref0 (_data_->atags);
							_g_object_unref0 (_data_->ainfo);
							_gst_tag_list_unref0 (_data_->tags);
							_g_object_unref0 (_data_->dlna);
							_g_object_unref0 (_data_->dlna_info);
							__g_list_free__g_object_unref0_0 (_data_->video_streams);
							__g_list_free__g_object_unref0_0 (_data_->audio_streams);
							_g_free0 (_data_->uri);
							_g_free0 (_data_->path);
							block1_data_unref (_data_->_data1_);
							_data_->_data1_ = NULL;
							if (_data_->_state_ == 0) {
								g_simple_async_result_complete_in_idle (_data_->_async_result);
							} else {
								g_simple_async_result_complete (_data_->_async_result);
							}
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
						_data_->_tmp236_ = NULL;
						_data_->_tmp236_ = _data_->sample;
						_data_->_tmp237_ = NULL;
						_data_->_tmp237_ = gst_sample_get_buffer (_data_->_tmp236_);
						memset (&_data_->_tmp238_, 0, sizeof (GstMapInfo));
						_data_->_tmp238_ = _data_->map_info;
						gst_buffer_unmap (_data_->_tmp237_, &_data_->_tmp238_);
					}
					_gst_caps_unref0 (_data_->caps);
				}
				_gst_sample_unref0 (_data_->sample);
			}
			_g_free0 (_data_->genre);
			_g_free0 (_data_->album);
			_g_free0 (_data_->artist);
		}
		_gst_tag_list_unref0 (_data_->atags);
		_g_object_unref0 (_data_->ainfo);
	}
	_gst_tag_list_unref0 (_data_->tags);
	_g_object_unref0 (_data_->dlna);
	_g_object_unref0 (_data_->dlna_info);
	__g_list_free__g_object_unref0_0 (_data_->video_streams);
	__g_list_free__g_object_unref0_0 (_data_->audio_streams);
	_g_free0 (_data_->uri);
	_g_free0 (_data_->path);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_media_export_generic_extractor_class_init (RygelMediaExportGenericExtractorClass * klass) {
	GUPnPDLNAProfileGuesser* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	rygel_media_export_generic_extractor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportGenericExtractorPrivate));
	((RygelMediaExportExtractorClass *) klass)->run = (void (*)(RygelMediaExportExtractor*, GAsyncReadyCallback, gpointer)) rygel_media_export_generic_extractor_real_run;
	((RygelMediaExportExtractorClass *) klass)->run_finish = (void (*)(RygelMediaExportExtractor*, GAsyncResult*, GError**)) rygel_media_export_generic_extractor_real_run_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_generic_extractor_finalize;
	{
		GstDiscoverer* _tmp0_ = NULL;
		GstDiscoverer* _tmp1_ = NULL;
		GstDiscoverer* _tmp2_ = NULL;
		GstDiscoverer* _tmp3_ = NULL;
		_tmp1_ = gst_discoverer_new ((GstClockTime) (10 * GST_SECOND), &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch11_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (rygel_media_export_generic_extractor_discoverer);
		rygel_media_export_generic_extractor_discoverer = _tmp2_;
		_tmp3_ = rygel_media_export_generic_extractor_discoverer;
		gst_discoverer_start (_tmp3_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_debug ("rygel-media-export-generic-extractor.vala:43: Generic extractor unavai" \
"lable: %s", _tmp5_);
		_g_error_free0 (_error_);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp6_ = gupnp_dlna_profile_guesser_new (TRUE, TRUE);
	_g_object_unref0 (rygel_media_export_generic_extractor_guesser);
	rygel_media_export_generic_extractor_guesser = _tmp6_;
	{
		MediaArtProcess* _tmp7_ = NULL;
		MediaArtProcess* _tmp8_ = NULL;
		MediaArtProcess* _tmp9_ = NULL;
		_tmp8_ = media_art_process_new (&_inner_error_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch12_g_error;
		}
		_tmp9_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (rygel_media_export_generic_extractor_media_art);
		rygel_media_export_generic_extractor_media_art = _tmp9_;
		_g_object_unref0 (_tmp7_);
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = _ ("Failed to create media art extractor: %s");
		_tmp11_ = _error_;
		_tmp12_ = _tmp11_->message;
		g_warning (_tmp10_, _tmp12_);
		_g_error_free0 (_error_);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void rygel_media_export_generic_extractor_instance_init (RygelMediaExportGenericExtractor * self) {
	self->priv = RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_GET_PRIVATE (self);
}


static void rygel_media_export_generic_extractor_finalize (GObject* obj) {
	RygelMediaExportGenericExtractor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractor);
	_g_free0 (self->priv->upnp_class);
	_g_free0 (self->priv->mime_type);
	G_OBJECT_CLASS (rygel_media_export_generic_extractor_parent_class)->finalize (obj);
}


GType rygel_media_export_generic_extractor_get_type (void) {
	static volatile gsize rygel_media_export_generic_extractor_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_generic_extractor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportGenericExtractorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_generic_extractor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportGenericExtractor), 0, (GInstanceInitFunc) rygel_media_export_generic_extractor_instance_init, NULL };
		GType rygel_media_export_generic_extractor_type_id;
		rygel_media_export_generic_extractor_type_id = g_type_register_static (RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, "RygelMediaExportGenericExtractor", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_generic_extractor_type_id__volatile, rygel_media_export_generic_extractor_type_id);
	}
	return rygel_media_export_generic_extractor_type_id__volatile;
}



