/* chess-game.c generated by valac 0.37.1.6-1eaec, the Vala compiler
 * generated from chess-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2014 Robert Ancell
 * Copyright (C) 2015-2016 Sahil Sareen
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_CHESS_RESULT (chess_result_get_type ())

#define TYPE_CHESS_RULE (chess_rule_get_type ())

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;
typedef struct _ChessGamePrivate ChessGamePrivate;

#define TYPE_CHESS_STATE (chess_state_get_type ())
#define CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_STATE, ChessState))
#define CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_STATE, ChessStateClass))
#define IS_CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_STATE))
#define IS_CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_STATE))
#define CHESS_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_STATE, ChessStateClass))

typedef struct _ChessState ChessState;
typedef struct _ChessStateClass ChessStateClass;

#define TYPE_CHESS_CLOCK (chess_clock_get_type ())
#define CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_CLOCK, ChessClock))
#define CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_CLOCK, ChessClockClass))
#define IS_CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_CLOCK))
#define IS_CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_CLOCK))
#define CHESS_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_CLOCK, ChessClockClass))

typedef struct _ChessClock ChessClock;
typedef struct _ChessClockClass ChessClockClass;
enum  {
	CHESS_GAME_DUMMY_PROPERTY,
	CHESS_GAME_IS_PAUSED,
	CHESS_GAME_SHOULD_SHOW_PAUSED_OVERLAY,
	CHESS_GAME_CURRENT_STATE,
	CHESS_GAME_WHITE,
	CHESS_GAME_BLACK,
	CHESS_GAME_CURRENT_PLAYER,
	CHESS_GAME_OPPONENT,
	CHESS_GAME_CLOCK,
	CHESS_GAME_N_MOVES,
	CHESS_GAME_LAST_PROPERTY
};
static GParamSpec* chess_game_properties[CHESS_GAME_LAST_PROPERTY];
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;
typedef struct _ChessStatePrivate ChessStatePrivate;

#define TYPE_CHECK_STATE (check_state_get_type ())

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
typedef struct _ChessMovePrivate ChessMovePrivate;
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;

#define TYPE_COLOR (color_get_type ())
enum  {
	CHESS_GAME_TURN_STARTED_SIGNAL,
	CHESS_GAME_MOVED_SIGNAL,
	CHESS_GAME_PAUSED_SIGNAL,
	CHESS_GAME_UNPAUSED_SIGNAL,
	CHESS_GAME_UNDO_SIGNAL,
	CHESS_GAME_ENDED_SIGNAL,
	CHESS_GAME_LAST_SIGNAL
};
static guint chess_game_signals[CHESS_GAME_LAST_SIGNAL] = {0};

typedef enum  {
	CHESS_RESULT_IN_PROGRESS,
	CHESS_RESULT_WHITE_WON,
	CHESS_RESULT_BLACK_WON,
	CHESS_RESULT_DRAW,
	CHESS_RESULT_BUG
} ChessResult;

typedef enum  {
	CHESS_RULE_UNKNOWN,
	CHESS_RULE_CHECKMATE,
	CHESS_RULE_STALEMATE,
	CHESS_RULE_FIFTY_MOVES,
	CHESS_RULE_SEVENTY_FIVE_MOVES,
	CHESS_RULE_TIMEOUT,
	CHESS_RULE_THREE_FOLD_REPETITION,
	CHESS_RULE_FIVE_FOLD_REPETITION,
	CHESS_RULE_INSUFFICIENT_MATERIAL,
	CHESS_RULE_RESIGN,
	CHESS_RULE_ABANDONMENT,
	CHESS_RULE_DEATH,
	CHESS_RULE_BUG
} ChessRule;

struct _ChessGame {
	GObject parent_instance;
	ChessGamePrivate * priv;
	gboolean is_started;
	ChessResult result;
	ChessRule rule;
	GList* move_stack;
};

struct _ChessGameClass {
	GObjectClass parent_class;
};

struct _ChessGamePrivate {
	gint hold_count;
	gboolean _is_paused;
	gboolean _should_show_paused_overlay;
	ChessClock* _clock;
};

typedef enum  {
	PGN_ERROR_LOAD_ERROR
} PGNError;
#define PGN_ERROR pgn_error_quark ()
typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessState {
	GObject parent_instance;
	ChessStatePrivate * priv;
	gint number;
	ChessPlayer* players[2];
	ChessPlayer* current_player;
	gboolean can_castle_kingside[2];
	gboolean can_castle_queenside[2];
	gint en_passant_index;
	CheckState check_state;
	gint halfmove_clock;
	ChessPiece* board[64];
	ChessMove* last_move;
};

struct _ChessStateClass {
	GObjectClass parent_class;
};

struct _ChessMove {
	GObject parent_instance;
	ChessMovePrivate * priv;
	gint number;
	ChessPiece* piece;
	ChessPiece* promotion_piece;
	ChessPiece* moved_rook;
	ChessPiece* victim;
	gint r0;
	gint f0;
	gint r1;
	gint f1;
	gboolean ambiguous_rank;
	gboolean ambiguous_file;
	CheckState check_state;
};

struct _ChessMoveClass {
	GObjectClass parent_class;
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};


static gpointer chess_game_parent_class = NULL;

GType chess_result_get_type (void) G_GNUC_CONST;
GType chess_rule_get_type (void) G_GNUC_CONST;
GType chess_game_get_type (void) G_GNUC_CONST;
GType chess_state_get_type (void) G_GNUC_CONST;
GType chess_clock_get_type (void) G_GNUC_CONST;
#define CHESS_GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_GAME, ChessGamePrivate))
void chess_clock_stop (ChessClock* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
#define CHESS_GAME_STANDARD_SETUP "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1"
GQuark pgn_error_quark (void);
ChessGame* chess_game_new (const gchar* fen, gchar** moves, int moves_length1, GError** error);
ChessGame* chess_game_construct (GType object_type, const gchar* fen, gchar** moves, int moves_length1, GError** error);
ChessState* chess_state_new (const gchar* fen);
ChessState* chess_state_construct (GType object_type, const gchar* fen);
GType chess_player_get_type (void) G_GNUC_CONST;
static gboolean chess_game_do_move (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply);
ChessPlayer* chess_game_get_current_player (ChessGame* self);
ChessPlayer* chess_game_get_white (ChessGame* self);
static gboolean chess_game_move_cb (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply);
static gboolean _chess_game_move_cb_chess_player_do_move (ChessPlayer* _sender, const gchar* move, gboolean apply, gpointer self);
static void chess_game_undo_cb (ChessGame* self, ChessPlayer* player);
static void _chess_game_undo_cb_chess_player_do_undo (ChessPlayer* _sender, gpointer self);
static gboolean chess_game_resign_cb (ChessGame* self, ChessPlayer* player);
static gboolean _chess_game_resign_cb_chess_player_do_resign (ChessPlayer* _sender, gpointer self);
static void chess_game_claim_draw_cb (ChessGame* self);
static void _chess_game_claim_draw_cb_chess_player_do_claim_draw (ChessPlayer* _sender, gpointer self);
ChessPlayer* chess_game_get_black (ChessGame* self);
ChessState* chess_game_get_current_state (ChessGame* self);
ChessState* chess_state_copy (ChessState* self);
GType check_state_get_type (void) G_GNUC_CONST;
GType chess_piece_get_type (void) G_GNUC_CONST;
GType chess_move_get_type (void) G_GNUC_CONST;
gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply);
static void chess_game_complete_move (ChessGame* self);
void chess_game_add_hold (ChessGame* self);
void chess_game_remove_hold (ChessGame* self);
ChessResult chess_state_get_result (ChessState* self, ChessRule* rule);
void chess_game_stop (ChessGame* self, ChessResult _result_, ChessRule rule);
gboolean chess_game_is_five_fold_repeat (ChessGame* self);
gboolean chess_game_is_seventy_five_move_rule_fulfilled (ChessGame* self);
GType color_get_type (void) G_GNUC_CONST;
void chess_clock_set_active_color (ChessClock* self, Color value);
ChessPlayer* chess_game_get_opponent (ChessGame* self);
static gint chess_game_state_repeated_times (ChessGame* self, ChessState* s1);
gboolean chess_state_equals (ChessState* self, ChessState* state);
static gboolean chess_game_is_n_fold_repeat (ChessGame* self, gint n);
gboolean chess_game_is_three_fold_repeat (ChessGame* self);
gboolean chess_game_is_fifty_move_rule_fulfilled (ChessGame* self);
gboolean chess_game_can_claim_draw (ChessGame* self);
void chess_game_start (ChessGame* self);
static void chess_game_clock_expired_cb (ChessGame* self, ChessClock* clock);
static void _chess_game_clock_expired_cb_chess_clock_expired (ChessClock* _sender, gpointer self);
ChessPiece* chess_game_get_piece (ChessGame* self, gint rank, gint file, gint move_number);
gint chess_state_get_index (ChessState* self, gint rank, gint file);
void chess_game_pause (ChessGame* self, gboolean show_overlay);
ChessClock* chess_game_get_clock (ChessGame* self);
gboolean chess_game_get_is_paused (ChessGame* self);
void chess_clock_pause (ChessClock* self);
static void chess_game_set_is_paused (ChessGame* self, gboolean value);
static void chess_game_set_should_show_paused_overlay (ChessGame* self, gboolean value);
void chess_game_unpause (ChessGame* self);
void chess_clock_unpause (ChessClock* self);
gboolean chess_game_get_should_show_paused_overlay (ChessGame* self);
ChessPlayer* chess_state_get_opponent (ChessState* self);
void chess_game_set_clock (ChessGame* self, ChessClock* value);
guint chess_game_get_n_moves (ChessGame* self);
static void chess_game_finalize (GObject * obj);
static void _vala_chess_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType chess_result_get_type (void) {
	static volatile gsize chess_result_type_id__volatile = 0;
	if (g_once_init_enter (&chess_result_type_id__volatile)) {
		static const GEnumValue values[] = {{CHESS_RESULT_IN_PROGRESS, "CHESS_RESULT_IN_PROGRESS", "in-progress"}, {CHESS_RESULT_WHITE_WON, "CHESS_RESULT_WHITE_WON", "white-won"}, {CHESS_RESULT_BLACK_WON, "CHESS_RESULT_BLACK_WON", "black-won"}, {CHESS_RESULT_DRAW, "CHESS_RESULT_DRAW", "draw"}, {CHESS_RESULT_BUG, "CHESS_RESULT_BUG", "bug"}, {0, NULL, NULL}};
		GType chess_result_type_id;
		chess_result_type_id = g_enum_register_static ("ChessResult", values);
		g_once_init_leave (&chess_result_type_id__volatile, chess_result_type_id);
	}
	return chess_result_type_id__volatile;
}


GType chess_rule_get_type (void) {
	static volatile gsize chess_rule_type_id__volatile = 0;
	if (g_once_init_enter (&chess_rule_type_id__volatile)) {
		static const GEnumValue values[] = {{CHESS_RULE_UNKNOWN, "CHESS_RULE_UNKNOWN", "unknown"}, {CHESS_RULE_CHECKMATE, "CHESS_RULE_CHECKMATE", "checkmate"}, {CHESS_RULE_STALEMATE, "CHESS_RULE_STALEMATE", "stalemate"}, {CHESS_RULE_FIFTY_MOVES, "CHESS_RULE_FIFTY_MOVES", "fifty-moves"}, {CHESS_RULE_SEVENTY_FIVE_MOVES, "CHESS_RULE_SEVENTY_FIVE_MOVES", "seventy-five-moves"}, {CHESS_RULE_TIMEOUT, "CHESS_RULE_TIMEOUT", "timeout"}, {CHESS_RULE_THREE_FOLD_REPETITION, "CHESS_RULE_THREE_FOLD_REPETITION", "three-fold-repetition"}, {CHESS_RULE_FIVE_FOLD_REPETITION, "CHESS_RULE_FIVE_FOLD_REPETITION", "five-fold-repetition"}, {CHESS_RULE_INSUFFICIENT_MATERIAL, "CHESS_RULE_INSUFFICIENT_MATERIAL", "insufficient-material"}, {CHESS_RULE_RESIGN, "CHESS_RULE_RESIGN", "resign"}, {CHESS_RULE_ABANDONMENT, "CHESS_RULE_ABANDONMENT", "abandonment"}, {CHESS_RULE_DEATH, "CHESS_RULE_DEATH", "death"}, {CHESS_RULE_BUG, "CHESS_RULE_BUG", "bug"}, {0, NULL, NULL}};
		GType chess_rule_type_id;
		chess_rule_type_id = g_enum_register_static ("ChessRule", values);
		g_once_init_leave (&chess_rule_type_id__volatile, chess_rule_type_id);
	}
	return chess_rule_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


static gboolean _chess_game_move_cb_chess_player_do_move (ChessPlayer* _sender, const gchar* move, gboolean apply, gpointer self) {
	gboolean result;
	result = chess_game_move_cb ((ChessGame*) self, _sender, move, apply);
	return result;
}


static void _chess_game_undo_cb_chess_player_do_undo (ChessPlayer* _sender, gpointer self) {
	chess_game_undo_cb ((ChessGame*) self, _sender);
}


static gboolean _chess_game_resign_cb_chess_player_do_resign (ChessPlayer* _sender, gpointer self) {
	gboolean result;
	result = chess_game_resign_cb ((ChessGame*) self, _sender);
	return result;
}


static void _chess_game_claim_draw_cb_chess_player_do_claim_draw (ChessPlayer* _sender, gpointer self) {
	chess_game_claim_draw_cb ((ChessGame*) self);
}


ChessGame* chess_game_construct (GType object_type, const gchar* fen, gchar** moves, int moves_length1, GError** error) {
	ChessGame * self = NULL;
	const gchar* _tmp0_;
	ChessState* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	ChessPlayer* _tmp17_;
	ChessPlayer* _tmp18_;
	ChessPlayer* _tmp19_;
	ChessPlayer* _tmp20_;
	ChessPlayer* _tmp21_;
	ChessPlayer* _tmp22_;
	ChessPlayer* _tmp23_;
	ChessPlayer* _tmp24_;
	ChessPlayer* _tmp25_;
	ChessPlayer* _tmp26_;
	ChessPlayer* _tmp27_;
	ChessPlayer* _tmp28_;
	ChessPlayer* _tmp29_;
	ChessPlayer* _tmp30_;
	ChessPlayer* _tmp31_;
	ChessPlayer* _tmp32_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (fen != NULL, NULL);
	self = (ChessGame*) g_object_new (object_type, NULL);
	self->is_started = FALSE;
	_tmp0_ = fen;
	_tmp1_ = chess_state_new (_tmp0_);
	self->move_stack = g_list_prepend (self->move_stack, _tmp1_);
	self->result = CHESS_RESULT_IN_PROGRESS;
	_tmp2_ = moves;
	_tmp2__length1 = moves_length1;
	if (_tmp2_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					gint _tmp5_;
					gchar** _tmp6_;
					gint _tmp6__length1;
					ChessPlayer* _tmp7_;
					ChessPlayer* _tmp8_;
					gchar** _tmp9_;
					gint _tmp9__length1;
					gint _tmp10_;
					const gchar* _tmp11_;
					gboolean _tmp12_;
					if (!_tmp3_) {
						gint _tmp4_;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp5_ = i;
					_tmp6_ = moves;
					_tmp6__length1 = moves_length1;
					if (!(_tmp5_ < _tmp6__length1)) {
						break;
					}
					_tmp7_ = chess_game_get_current_player (self);
					_tmp8_ = _tmp7_;
					_tmp9_ = moves;
					_tmp9__length1 = moves_length1;
					_tmp10_ = i;
					_tmp11_ = _tmp9_[_tmp10_];
					_tmp12_ = chess_game_do_move (self, _tmp8_, _tmp11_, TRUE);
					if (!_tmp12_) {
						gchar** _tmp13_;
						gint _tmp13__length1;
						gint _tmp14_;
						const gchar* _tmp15_;
						GError* _tmp16_;
						_tmp13_ = moves;
						_tmp13__length1 = moves_length1;
						_tmp14_ = i;
						_tmp15_ = _tmp13_[_tmp14_];
						_tmp16_ = g_error_new (PGN_ERROR, PGN_ERROR_LOAD_ERROR, _ ("Failed to load PGN: move %s is invalid."), _tmp15_);
						_inner_error_ = _tmp16_;
						if (_inner_error_->domain == PGN_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (self);
							return NULL;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
			}
		}
	}
	_tmp17_ = chess_game_get_white (self);
	_tmp18_ = _tmp17_;
	g_signal_connect_object (_tmp18_, "do-move", (GCallback) _chess_game_move_cb_chess_player_do_move, self, 0);
	_tmp19_ = chess_game_get_white (self);
	_tmp20_ = _tmp19_;
	g_signal_connect_object (_tmp20_, "do-undo", (GCallback) _chess_game_undo_cb_chess_player_do_undo, self, 0);
	_tmp21_ = chess_game_get_white (self);
	_tmp22_ = _tmp21_;
	g_signal_connect_object (_tmp22_, "do-resign", (GCallback) _chess_game_resign_cb_chess_player_do_resign, self, 0);
	_tmp23_ = chess_game_get_white (self);
	_tmp24_ = _tmp23_;
	g_signal_connect_object (_tmp24_, "do-claim-draw", (GCallback) _chess_game_claim_draw_cb_chess_player_do_claim_draw, self, 0);
	_tmp25_ = chess_game_get_black (self);
	_tmp26_ = _tmp25_;
	g_signal_connect_object (_tmp26_, "do-move", (GCallback) _chess_game_move_cb_chess_player_do_move, self, 0);
	_tmp27_ = chess_game_get_black (self);
	_tmp28_ = _tmp27_;
	g_signal_connect_object (_tmp28_, "do-undo", (GCallback) _chess_game_undo_cb_chess_player_do_undo, self, 0);
	_tmp29_ = chess_game_get_black (self);
	_tmp30_ = _tmp29_;
	g_signal_connect_object (_tmp30_, "do-resign", (GCallback) _chess_game_resign_cb_chess_player_do_resign, self, 0);
	_tmp31_ = chess_game_get_black (self);
	_tmp32_ = _tmp31_;
	g_signal_connect_object (_tmp32_, "do-claim-draw", (GCallback) _chess_game_claim_draw_cb_chess_player_do_claim_draw, self, 0);
	return self;
}


ChessGame* chess_game_new (const gchar* fen, gchar** moves, int moves_length1, GError** error) {
	return chess_game_construct (TYPE_CHESS_GAME, fen, moves, moves_length1, error);
}


static gboolean chess_game_move_cb (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	ChessPlayer* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	g_return_val_if_fail (move != NULL, FALSE);
	_tmp0_ = self->is_started;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = player;
	_tmp2_ = move;
	_tmp3_ = apply;
	_tmp4_ = chess_game_do_move (self, _tmp1_, _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean chess_game_do_move (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_;
	ChessPlayer* _tmp1_;
	ChessPlayer* _tmp2_;
	ChessState* state = NULL;
	ChessState* _tmp3_;
	ChessState* _tmp4_;
	ChessState* _tmp5_;
	ChessState* _tmp6_;
	gint _tmp7_;
	ChessState* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	ChessState* _tmp13_;
	ChessState* _tmp14_;
	ChessState* _tmp15_;
	ChessMove* _tmp16_;
	ChessPiece* _tmp17_;
	ChessState* _tmp21_;
	ChessMove* _tmp22_;
	ChessPiece* _tmp23_;
	ChessState* _tmp24_;
	ChessMove* _tmp25_;
	ChessPiece* _tmp26_;
	ChessState* _tmp30_;
	ChessMove* _tmp31_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	_tmp0_ = player;
	_tmp1_ = chess_game_get_current_player (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ != _tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = chess_game_get_current_state (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = chess_state_copy (_tmp4_);
	state = _tmp5_;
	_tmp6_ = state;
	_tmp7_ = _tmp6_->number;
	_tmp6_->number = _tmp7_ + 1;
	_tmp8_ = state;
	_tmp9_ = move;
	_tmp10_ = apply;
	_tmp11_ = chess_state_move (_tmp8_, _tmp9_, _tmp10_);
	if (!_tmp11_) {
		result = FALSE;
		_g_object_unref0 (state);
		return result;
	}
	_tmp12_ = apply;
	if (!_tmp12_) {
		result = TRUE;
		_g_object_unref0 (state);
		return result;
	}
	_tmp13_ = state;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	self->move_stack = g_list_prepend (self->move_stack, _tmp14_);
	_tmp15_ = state;
	_tmp16_ = _tmp15_->last_move;
	_tmp17_ = _tmp16_->victim;
	if (_tmp17_ != NULL) {
		ChessState* _tmp18_;
		ChessMove* _tmp19_;
		ChessPiece* _tmp20_;
		_tmp18_ = state;
		_tmp19_ = _tmp18_->last_move;
		_tmp20_ = _tmp19_->victim;
		g_signal_emit_by_name (_tmp20_, "died");
	}
	_tmp21_ = state;
	_tmp22_ = _tmp21_->last_move;
	_tmp23_ = _tmp22_->piece;
	g_signal_emit_by_name (_tmp23_, "moved");
	_tmp24_ = state;
	_tmp25_ = _tmp24_->last_move;
	_tmp26_ = _tmp25_->moved_rook;
	if (_tmp26_ != NULL) {
		ChessState* _tmp27_;
		ChessMove* _tmp28_;
		ChessPiece* _tmp29_;
		_tmp27_ = state;
		_tmp28_ = _tmp27_->last_move;
		_tmp29_ = _tmp28_->moved_rook;
		g_signal_emit_by_name (_tmp29_, "moved");
	}
	_tmp30_ = state;
	_tmp31_ = _tmp30_->last_move;
	g_signal_emit (self, chess_game_signals[CHESS_GAME_MOVED_SIGNAL], 0, _tmp31_);
	chess_game_complete_move (self);
	result = TRUE;
	_g_object_unref0 (state);
	return result;
}


void chess_game_add_hold (ChessGame* self) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hold_count;
	self->priv->hold_count = _tmp0_ + 1;
}


void chess_game_remove_hold (ChessGame* self) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hold_count;
	g_return_if_fail (_tmp0_ > 0);
	_tmp1_ = self->priv->hold_count;
	self->priv->hold_count = _tmp1_ - 1;
	_tmp2_ = self->priv->hold_count;
	if (_tmp2_ == 0) {
		chess_game_complete_move (self);
	}
}


static void chess_game_complete_move (ChessGame* self) {
	gint _tmp0_;
	gboolean _tmp1_;
	ChessRule rule = 0;
	ChessResult _result_ = 0;
	ChessState* _tmp2_;
	ChessState* _tmp3_;
	ChessRule _tmp4_ = 0;
	ChessResult _tmp5_;
	ChessResult _tmp6_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	ChessClock* _tmp11_;
	ChessPlayer* _tmp16_;
	ChessPlayer* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hold_count;
	if (_tmp0_ > 0) {
		return;
	}
	_tmp1_ = self->is_started;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = chess_game_get_current_state (self);
	_tmp3_ = _tmp2_;
	_tmp5_ = chess_state_get_result (_tmp3_, &_tmp4_);
	rule = _tmp4_;
	_result_ = _tmp5_;
	_tmp6_ = _result_;
	if (_tmp6_ != CHESS_RESULT_IN_PROGRESS) {
		ChessResult _tmp7_;
		ChessRule _tmp8_;
		_tmp7_ = _result_;
		_tmp8_ = rule;
		chess_game_stop (self, _tmp7_, _tmp8_);
		return;
	}
	_tmp9_ = chess_game_is_five_fold_repeat (self);
	if (_tmp9_) {
		chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_FIVE_FOLD_REPETITION);
		return;
	}
	_tmp10_ = chess_game_is_seventy_five_move_rule_fulfilled (self);
	if (_tmp10_) {
		chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_SEVENTY_FIVE_MOVES);
		return;
	}
	_tmp11_ = self->priv->_clock;
	if (_tmp11_ != NULL) {
		ChessClock* _tmp12_;
		ChessPlayer* _tmp13_;
		ChessPlayer* _tmp14_;
		Color _tmp15_;
		_tmp12_ = self->priv->_clock;
		_tmp13_ = chess_game_get_current_player (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_->color;
		chess_clock_set_active_color (_tmp12_, _tmp15_);
	}
	_tmp16_ = chess_game_get_current_player (self);
	_tmp17_ = _tmp16_;
	g_signal_emit (self, chess_game_signals[CHESS_GAME_TURN_STARTED_SIGNAL], 0, _tmp17_);
}


static void chess_game_undo_cb (ChessGame* self, ChessPlayer* player) {
	ChessPlayer* _tmp0_;
	ChessPlayer* _tmp1_;
	ChessPlayer* _tmp2_;
	GList* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	_tmp0_ = player;
	_tmp1_ = chess_game_get_current_player (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ == _tmp2_) {
		ChessPlayer* _tmp3_;
		ChessPlayer* _tmp4_;
		_tmp3_ = chess_game_get_opponent (self);
		_tmp4_ = _tmp3_;
		chess_game_undo_cb (self, _tmp4_);
	}
	_tmp5_ = self->move_stack;
	_tmp6_ = _tmp5_->next;
	if (_tmp6_ == NULL) {
		return;
	}
	_tmp7_ = self->move_stack;
	self->move_stack = g_list_remove_link (self->move_stack, _tmp7_);
	g_signal_emit (self, chess_game_signals[CHESS_GAME_UNDO_SIGNAL], 0);
}


static gboolean chess_game_resign_cb (ChessGame* self, ChessPlayer* player) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	ChessPlayer* _tmp1_;
	Color _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	_tmp0_ = self->is_started;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = player;
	_tmp2_ = _tmp1_->color;
	if (_tmp2_ == COLOR_WHITE) {
		chess_game_stop (self, CHESS_RESULT_BLACK_WON, CHESS_RULE_RESIGN);
	} else {
		chess_game_stop (self, CHESS_RESULT_WHITE_WON, CHESS_RULE_RESIGN);
	}
	result = TRUE;
	return result;
}


static gint chess_game_state_repeated_times (ChessGame* self, ChessState* s1) {
	gint result = 0;
	gint count = 0;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (s1 != NULL, 0);
	count = 1;
	_tmp0_ = self->move_stack;
	{
		GList* s2_collection = NULL;
		GList* s2_it = NULL;
		s2_collection = _tmp0_;
		for (s2_it = s2_collection; s2_it != NULL; s2_it = s2_it->next) {
			ChessState* _tmp1_;
			ChessState* s2 = NULL;
			_tmp1_ = _g_object_ref0 ((ChessState*) s2_it->data);
			s2 = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				ChessState* _tmp3_;
				ChessState* _tmp4_;
				_tmp3_ = s1;
				_tmp4_ = s2;
				if (_tmp3_ != _tmp4_) {
					ChessState* _tmp5_;
					ChessState* _tmp6_;
					gboolean _tmp7_;
					_tmp5_ = s1;
					_tmp6_ = s2;
					_tmp7_ = chess_state_equals (_tmp5_, _tmp6_);
					_tmp2_ = _tmp7_;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					gint _tmp8_;
					_tmp8_ = count;
					count = _tmp8_ + 1;
				}
				_g_object_unref0 (s2);
			}
		}
	}
	result = count;
	return result;
}


static gboolean chess_game_is_n_fold_repeat (ChessGame* self, gint n) {
	gboolean result = FALSE;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->move_stack;
	{
		GList* state_collection = NULL;
		GList* state_it = NULL;
		state_collection = _tmp0_;
		for (state_it = state_collection; state_it != NULL; state_it = state_it->next) {
			ChessState* _tmp1_;
			ChessState* state = NULL;
			_tmp1_ = _g_object_ref0 ((ChessState*) state_it->data);
			state = _tmp1_;
			{
				ChessState* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				_tmp2_ = state;
				_tmp3_ = chess_game_state_repeated_times (self, _tmp2_);
				_tmp4_ = n;
				if (_tmp3_ >= _tmp4_) {
					result = TRUE;
					_g_object_unref0 (state);
					return result;
				}
				_g_object_unref0 (state);
			}
		}
	}
	result = FALSE;
	return result;
}


gboolean chess_game_is_three_fold_repeat (ChessGame* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = chess_game_is_n_fold_repeat (self, 3);
	result = _tmp0_;
	return result;
}


gboolean chess_game_is_five_fold_repeat (ChessGame* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = chess_game_is_n_fold_repeat (self, 5);
	result = _tmp0_;
	return result;
}


gboolean chess_game_is_fifty_move_rule_fulfilled (ChessGame* self) {
	gboolean result = FALSE;
	ChessState* _tmp0_;
	ChessState* _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = chess_game_get_current_state (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->halfmove_clock;
	result = _tmp2_ >= 100;
	return result;
}


gboolean chess_game_is_seventy_five_move_rule_fulfilled (ChessGame* self) {
	gboolean result = FALSE;
	ChessState* _tmp0_;
	ChessState* _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = chess_game_get_current_state (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->halfmove_clock;
	result = _tmp2_ >= 150;
	return result;
}


gboolean chess_game_can_claim_draw (ChessGame* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = chess_game_is_fifty_move_rule_fulfilled (self);
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = chess_game_is_three_fold_repeat (self);
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}


static void chess_game_claim_draw_cb (ChessGame* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_game_is_fifty_move_rule_fulfilled (self);
	if (_tmp0_) {
		chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_FIFTY_MOVES);
	} else {
		gboolean _tmp1_;
		_tmp1_ = chess_game_is_three_fold_repeat (self);
		if (_tmp1_) {
			chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_THREE_FOLD_REPETITION);
		}
	}
}


static void _chess_game_clock_expired_cb_chess_clock_expired (ChessClock* _sender, gpointer self) {
	chess_game_clock_expired_cb ((ChessGame*) self, _sender);
}


void chess_game_start (ChessGame* self) {
	ChessResult _tmp0_;
	gboolean _tmp1_;
	ChessClock* _tmp2_;
	ChessPlayer* _tmp8_;
	ChessPlayer* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->result;
	if (_tmp0_ != CHESS_RESULT_IN_PROGRESS) {
		return;
	}
	_tmp1_ = self->is_started;
	if (_tmp1_) {
		return;
	}
	self->is_started = TRUE;
	_tmp2_ = self->priv->_clock;
	if (_tmp2_ != NULL) {
		ChessClock* _tmp3_;
		ChessClock* _tmp4_;
		ChessPlayer* _tmp5_;
		ChessPlayer* _tmp6_;
		Color _tmp7_;
		_tmp3_ = self->priv->_clock;
		g_signal_connect_object (_tmp3_, "expired", (GCallback) _chess_game_clock_expired_cb_chess_clock_expired, self, 0);
		_tmp4_ = self->priv->_clock;
		_tmp5_ = chess_game_get_current_player (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_->color;
		chess_clock_set_active_color (_tmp4_, _tmp7_);
	}
	_tmp8_ = chess_game_get_current_player (self);
	_tmp9_ = _tmp8_;
	g_signal_emit (self, chess_game_signals[CHESS_GAME_TURN_STARTED_SIGNAL], 0, _tmp9_);
}


static void chess_game_clock_expired_cb (ChessGame* self, ChessClock* clock) {
	ChessPlayer* _tmp0_;
	ChessPlayer* _tmp1_;
	Color _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clock != NULL);
	_tmp0_ = chess_game_get_current_player (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->color;
	if (_tmp2_ == COLOR_WHITE) {
		chess_game_stop (self, CHESS_RESULT_BLACK_WON, CHESS_RULE_TIMEOUT);
	} else {
		chess_game_stop (self, CHESS_RESULT_WHITE_WON, CHESS_RULE_TIMEOUT);
	}
}


ChessPiece* chess_game_get_piece (ChessGame* self, gint rank, gint file, gint move_number) {
	ChessPiece* result = NULL;
	gint _tmp0_;
	ChessState* state = NULL;
	GList* _tmp4_;
	GList* _tmp5_;
	guint _tmp6_;
	gint _tmp7_;
	gconstpointer _tmp8_;
	ChessState* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	ChessPiece* _tmp13_;
	ChessPiece* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = move_number;
	if (_tmp0_ < 0) {
		gint _tmp1_;
		GList* _tmp2_;
		guint _tmp3_;
		_tmp1_ = move_number;
		_tmp2_ = self->move_stack;
		_tmp3_ = g_list_length (_tmp2_);
		move_number = _tmp1_ + ((gint) _tmp3_);
	}
	_tmp4_ = self->move_stack;
	_tmp5_ = self->move_stack;
	_tmp6_ = g_list_length (_tmp5_);
	_tmp7_ = move_number;
	_tmp8_ = g_list_nth_data (_tmp4_, (_tmp6_ - _tmp7_) - 1);
	_tmp9_ = _g_object_ref0 ((ChessState*) _tmp8_);
	state = _tmp9_;
	_tmp10_ = rank;
	_tmp11_ = file;
	_tmp12_ = chess_state_get_index (state, _tmp10_, _tmp11_);
	_tmp13_ = state->board[_tmp12_];
	_tmp14_ = _g_object_ref0 (_tmp13_);
	result = _tmp14_;
	_g_object_unref0 (state);
	return result;
}


void chess_game_pause (ChessGame* self, gboolean show_overlay) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessClock* _tmp2_;
	ChessClock* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp2_ = chess_game_get_clock (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ChessResult _tmp4_;
		_tmp4_ = self->result;
		_tmp1_ = _tmp4_ == CHESS_RESULT_IN_PROGRESS;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp5_;
		_tmp5_ = self->priv->_is_paused;
		_tmp0_ = !_tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ChessClock* _tmp6_;
		ChessClock* _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = chess_game_get_clock (self);
		_tmp7_ = _tmp6_;
		chess_clock_pause (_tmp7_);
		chess_game_set_is_paused (self, TRUE);
		_tmp8_ = show_overlay;
		chess_game_set_should_show_paused_overlay (self, _tmp8_);
		g_signal_emit (self, chess_game_signals[CHESS_GAME_PAUSED_SIGNAL], 0);
	}
}


void chess_game_unpause (ChessGame* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessClock* _tmp2_;
	ChessClock* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp2_ = chess_game_get_clock (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ChessResult _tmp4_;
		_tmp4_ = self->result;
		_tmp1_ = _tmp4_ == CHESS_RESULT_IN_PROGRESS;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp5_;
		_tmp5_ = self->priv->_is_paused;
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ChessClock* _tmp6_;
		ChessClock* _tmp7_;
		_tmp6_ = chess_game_get_clock (self);
		_tmp7_ = _tmp6_;
		chess_clock_unpause (_tmp7_);
		chess_game_set_is_paused (self, FALSE);
		chess_game_set_should_show_paused_overlay (self, FALSE);
		g_signal_emit (self, chess_game_signals[CHESS_GAME_UNPAUSED_SIGNAL], 0);
	}
}


void chess_game_stop (ChessGame* self, ChessResult _result_, ChessRule rule) {
	gboolean _tmp0_;
	ChessResult _tmp1_;
	ChessRule _tmp2_;
	ChessClock* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->is_started;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = _result_;
	self->result = _tmp1_;
	_tmp2_ = rule;
	self->rule = _tmp2_;
	self->is_started = FALSE;
	_tmp3_ = self->priv->_clock;
	if (_tmp3_ != NULL) {
		ChessClock* _tmp4_;
		_tmp4_ = self->priv->_clock;
		chess_clock_stop (_tmp4_);
	}
	g_signal_emit (self, chess_game_signals[CHESS_GAME_ENDED_SIGNAL], 0);
}


gboolean chess_game_get_is_paused (ChessGame* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_paused;
	result = _tmp0_;
	return result;
}


static void chess_game_set_is_paused (ChessGame* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (chess_game_get_is_paused (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_is_paused = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, chess_game_properties[CHESS_GAME_IS_PAUSED]);
	}
}


gboolean chess_game_get_should_show_paused_overlay (ChessGame* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_should_show_paused_overlay;
	result = _tmp0_;
	return result;
}


static void chess_game_set_should_show_paused_overlay (ChessGame* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (chess_game_get_should_show_paused_overlay (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_should_show_paused_overlay = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, chess_game_properties[CHESS_GAME_SHOULD_SHOW_PAUSED_OVERLAY]);
	}
}


ChessState* chess_game_get_current_state (ChessGame* self) {
	ChessState* result;
	GList* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->move_stack;
	_tmp1_ = _tmp0_->data;
	result = (ChessState*) _tmp1_;
	return result;
}


ChessPlayer* chess_game_get_white (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_;
	ChessState* _tmp1_;
	ChessPlayer* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_game_get_current_state (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->players[COLOR_WHITE];
	result = _tmp2_;
	return result;
}


ChessPlayer* chess_game_get_black (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_;
	ChessState* _tmp1_;
	ChessPlayer* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_game_get_current_state (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->players[COLOR_BLACK];
	result = _tmp2_;
	return result;
}


ChessPlayer* chess_game_get_current_player (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_;
	ChessState* _tmp1_;
	ChessPlayer* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_game_get_current_state (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->current_player;
	result = _tmp2_;
	return result;
}


ChessPlayer* chess_game_get_opponent (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_;
	ChessState* _tmp1_;
	ChessPlayer* _tmp2_;
	ChessPlayer* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_game_get_current_state (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_state_get_opponent (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}


ChessClock* chess_game_get_clock (ChessGame* self) {
	ChessClock* result;
	ChessClock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_clock;
	result = _tmp0_;
	return result;
}


void chess_game_set_clock (ChessGame* self, ChessClock* value) {
	gboolean _tmp0_;
	ChessClock* _tmp1_;
	ChessClock* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->is_started;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = value;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->_clock);
	self->priv->_clock = _tmp2_;
	g_object_notify_by_pspec ((GObject *) self, chess_game_properties[CHESS_GAME_CLOCK]);
}


guint chess_game_get_n_moves (ChessGame* self) {
	guint result;
	GList* _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->move_stack;
	_tmp1_ = g_list_length (_tmp0_);
	result = _tmp1_ - 1;
	return result;
}


static void chess_game_class_init (ChessGameClass * klass) {
	chess_game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessGamePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_IS_PAUSED, chess_game_properties[CHESS_GAME_IS_PAUSED] = g_param_spec_boolean ("is-paused", "is-paused", "is-paused", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_SHOULD_SHOW_PAUSED_OVERLAY, chess_game_properties[CHESS_GAME_SHOULD_SHOW_PAUSED_OVERLAY] = g_param_spec_boolean ("should-show-paused-overlay", "should-show-paused-overlay", "should-show-paused-overlay", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_CURRENT_STATE, chess_game_properties[CHESS_GAME_CURRENT_STATE] = g_param_spec_object ("current-state", "current-state", "current-state", TYPE_CHESS_STATE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_WHITE, chess_game_properties[CHESS_GAME_WHITE] = g_param_spec_object ("white", "white", "white", TYPE_CHESS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_BLACK, chess_game_properties[CHESS_GAME_BLACK] = g_param_spec_object ("black", "black", "black", TYPE_CHESS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_CURRENT_PLAYER, chess_game_properties[CHESS_GAME_CURRENT_PLAYER] = g_param_spec_object ("current-player", "current-player", "current-player", TYPE_CHESS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_OPPONENT, chess_game_properties[CHESS_GAME_OPPONENT] = g_param_spec_object ("opponent", "opponent", "opponent", TYPE_CHESS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_CLOCK, chess_game_properties[CHESS_GAME_CLOCK] = g_param_spec_object ("clock", "clock", "clock", TYPE_CHESS_CLOCK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_N_MOVES, chess_game_properties[CHESS_GAME_N_MOVES] = g_param_spec_uint ("n-moves", "n-moves", "n-moves", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	chess_game_signals[CHESS_GAME_TURN_STARTED_SIGNAL] = g_signal_new ("turn-started", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_CHESS_PLAYER);
	chess_game_signals[CHESS_GAME_MOVED_SIGNAL] = g_signal_new ("moved", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_CHESS_MOVE);
	chess_game_signals[CHESS_GAME_PAUSED_SIGNAL] = g_signal_new ("paused", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	chess_game_signals[CHESS_GAME_UNPAUSED_SIGNAL] = g_signal_new ("unpaused", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	chess_game_signals[CHESS_GAME_UNDO_SIGNAL] = g_signal_new ("undo", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	chess_game_signals[CHESS_GAME_ENDED_SIGNAL] = g_signal_new ("ended", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void chess_game_instance_init (ChessGame * self) {
	self->priv = CHESS_GAME_GET_PRIVATE (self);
	self->priv->hold_count = 0;
	self->priv->_is_paused = FALSE;
	self->priv->_should_show_paused_overlay = FALSE;
}


static void chess_game_finalize (GObject * obj) {
	ChessGame * self;
	ChessClock* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_GAME, ChessGame);
	_tmp0_ = self->priv->_clock;
	if (_tmp0_ != NULL) {
		ChessClock* _tmp1_;
		_tmp1_ = self->priv->_clock;
		chess_clock_stop (_tmp1_);
	}
	__g_list_free__g_object_unref0_0 (self->move_stack);
	_g_object_unref0 (self->priv->_clock);
	G_OBJECT_CLASS (chess_game_parent_class)->finalize (obj);
}


GType chess_game_get_type (void) {
	static volatile gsize chess_game_type_id__volatile = 0;
	if (g_once_init_enter (&chess_game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessGame), 0, (GInstanceInitFunc) chess_game_instance_init, NULL };
		GType chess_game_type_id;
		chess_game_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessGame", &g_define_type_info, 0);
		g_once_init_leave (&chess_game_type_id__volatile, chess_game_type_id);
	}
	return chess_game_type_id__volatile;
}


static void _vala_chess_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_GAME, ChessGame);
	switch (property_id) {
		case CHESS_GAME_IS_PAUSED:
		g_value_set_boolean (value, chess_game_get_is_paused (self));
		break;
		case CHESS_GAME_SHOULD_SHOW_PAUSED_OVERLAY:
		g_value_set_boolean (value, chess_game_get_should_show_paused_overlay (self));
		break;
		case CHESS_GAME_CURRENT_STATE:
		g_value_set_object (value, chess_game_get_current_state (self));
		break;
		case CHESS_GAME_WHITE:
		g_value_set_object (value, chess_game_get_white (self));
		break;
		case CHESS_GAME_BLACK:
		g_value_set_object (value, chess_game_get_black (self));
		break;
		case CHESS_GAME_CURRENT_PLAYER:
		g_value_set_object (value, chess_game_get_current_player (self));
		break;
		case CHESS_GAME_OPPONENT:
		g_value_set_object (value, chess_game_get_opponent (self));
		break;
		case CHESS_GAME_CLOCK:
		g_value_set_object (value, chess_game_get_clock (self));
		break;
		case CHESS_GAME_N_MOVES:
		g_value_set_uint (value, chess_game_get_n_moves (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_chess_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_GAME, ChessGame);
	switch (property_id) {
		case CHESS_GAME_IS_PAUSED:
		chess_game_set_is_paused (self, g_value_get_boolean (value));
		break;
		case CHESS_GAME_SHOULD_SHOW_PAUSED_OVERLAY:
		chess_game_set_should_show_paused_overlay (self, g_value_get_boolean (value));
		break;
		case CHESS_GAME_CLOCK:
		chess_game_set_clock (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



