/* rygel-simple-data-source.c generated by valac 0.34.4, the Vala compiler
 * generated from rygel-simple-data-source.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>


#define RYGEL_TYPE_SIMPLE_DATA_SOURCE (rygel_simple_data_source_get_type ())
#define RYGEL_SIMPLE_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSource))
#define RYGEL_SIMPLE_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSourceClass))
#define RYGEL_IS_SIMPLE_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SIMPLE_DATA_SOURCE))
#define RYGEL_IS_SIMPLE_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SIMPLE_DATA_SOURCE))
#define RYGEL_SIMPLE_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSourceClass))

typedef struct _RygelSimpleDataSource RygelSimpleDataSource;
typedef struct _RygelSimpleDataSourceClass RygelSimpleDataSourceClass;
typedef struct _RygelSimpleDataSourcePrivate RygelSimpleDataSourcePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelSimpleDataSource {
	GObject parent_instance;
	RygelSimpleDataSourcePrivate * priv;
};

struct _RygelSimpleDataSourceClass {
	GObjectClass parent_class;
};

struct _RygelSimpleDataSourcePrivate {
	gchar* uri;
	GThread* thread;
	GMutex mutex;
	GCond cond;
	off_t first_byte;
	off_t last_byte;
	gboolean frozen;
	gboolean stop_thread;
	GThreadPool* pool;
};

struct _Block1Data {
	int _ref_count_;
	RygelSimpleDataSource* self;
	guint8* slice;
	gint slice_length1;
	gint _slice_size_;
};


static gpointer rygel_simple_data_source_parent_class = NULL;
static RygelDataSourceIface* rygel_simple_data_source_rygel_data_source_parent_iface = NULL;

GType rygel_simple_data_source_get_type (void) G_GNUC_CONST;
#define RYGEL_SIMPLE_DATA_SOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSourcePrivate))
enum  {
	RYGEL_SIMPLE_DATA_SOURCE_DUMMY_PROPERTY
};
RygelSimpleDataSource* rygel_simple_data_source_new (GThreadPool* pool, const gchar* uri);
RygelSimpleDataSource* rygel_simple_data_source_construct (GType object_type, GThreadPool* pool, const gchar* uri);
static GeeList* rygel_simple_data_source_real_preroll (RygelDataSource* base, RygelHTTPSeekRequest* seek_request, RygelPlaySpeedRequest* playspeed_request, GError** error);
static void rygel_simple_data_source_real_start (RygelDataSource* base, GError** error);
static void* rygel_simple_data_source_thread_func (RygelSimpleDataSource* self);
static gpointer _rygel_simple_data_source_thread_func_gthread_func (gpointer self);
static void rygel_simple_data_source_real_freeze (RygelDataSource* base);
static void rygel_simple_data_source_real_thaw (RygelDataSource* base);
static void rygel_simple_data_source_real_stop (RygelDataSource* base);
void rygel_simple_data_source_pool_func (RygelSimpleDataSource* data);
static void rygel_simple_data_source_run (RygelSimpleDataSource* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ____lambda4_ (Block1Data* _data1_);
static gboolean _____lambda4__gsource_func (gpointer self);
static gboolean __lambda5_ (RygelSimpleDataSource* self);
static gboolean ___lambda5__gsource_func (gpointer self);
static void rygel_simple_data_source_finalize (GObject* obj);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);


RygelSimpleDataSource* rygel_simple_data_source_construct (GType object_type, GThreadPool* pool, const gchar* uri) {
	RygelSimpleDataSource * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GThreadPool* _tmp3_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (RygelSimpleDataSource*) g_object_new (object_type, NULL);
	_tmp0_ = uri;
	g_debug ("rygel-simple-data-source.vala:47: Creating new data source for %s", _tmp0_);
	_tmp1_ = uri;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->uri);
	self->priv->uri = _tmp2_;
	_tmp3_ = pool;
	self->priv->pool = _tmp3_;
	return self;
}


RygelSimpleDataSource* rygel_simple_data_source_new (GThreadPool* pool, const gchar* uri) {
	return rygel_simple_data_source_construct (RYGEL_TYPE_SIMPLE_DATA_SOURCE, pool, uri);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeeList* rygel_simple_data_source_real_preroll (RygelDataSource* base, RygelHTTPSeekRequest* seek_request, RygelPlaySpeedRequest* playspeed_request, GError** error) {
	RygelSimpleDataSource * self;
	GeeList* result = NULL;
	GeeArrayList* response_list = NULL;
	GeeArrayList* _tmp0_ = NULL;
	RygelHTTPSeekRequest* _tmp1_ = NULL;
	RygelPlaySpeedRequest* _tmp24_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelSimpleDataSource*) base;
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	response_list = _tmp0_;
	_tmp1_ = seek_request;
	if (_tmp1_ != NULL) {
		RygelHTTPSeekRequest* _tmp2_ = NULL;
		RygelHTTPByteSeekRequest* byte_seek = NULL;
		RygelHTTPSeekRequest* _tmp5_ = NULL;
		RygelHTTPByteSeekRequest* _tmp6_ = NULL;
		RygelHTTPByteSeekRequest* _tmp7_ = NULL;
		gint64 _tmp8_ = 0LL;
		gint64 _tmp9_ = 0LL;
		RygelHTTPByteSeekRequest* _tmp10_ = NULL;
		gint64 _tmp11_ = 0LL;
		gint64 _tmp12_ = 0LL;
		RygelHTTPByteSeekRequest* _tmp13_ = NULL;
		gint64 _tmp14_ = 0LL;
		gint64 _tmp15_ = 0LL;
		RygelHTTPByteSeekRequest* _tmp16_ = NULL;
		gint64 _tmp17_ = 0LL;
		gint64 _tmp18_ = 0LL;
		const gchar* _tmp19_ = NULL;
		RygelHTTPByteSeekResponse* seek_response = NULL;
		RygelHTTPByteSeekRequest* _tmp20_ = NULL;
		RygelHTTPByteSeekResponse* _tmp21_ = NULL;
		GeeArrayList* _tmp22_ = NULL;
		RygelHTTPByteSeekResponse* _tmp23_ = NULL;
		_tmp2_ = seek_request;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST)) {
			const gchar* _tmp3_ = NULL;
			GError* _tmp4_ = NULL;
			_tmp3_ = _ ("Only byte-based seek supported");
			_tmp4_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _tmp3_);
			_inner_error_ = _tmp4_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (response_list);
			return NULL;
		}
		_tmp5_ = seek_request;
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST) ? ((RygelHTTPByteSeekRequest*) _tmp5_) : NULL);
		byte_seek = _tmp6_;
		_tmp7_ = byte_seek;
		_tmp8_ = rygel_http_byte_seek_request_get_start_byte (_tmp7_);
		_tmp9_ = _tmp8_;
		self->priv->first_byte = (off_t) _tmp9_;
		_tmp10_ = byte_seek;
		_tmp11_ = rygel_http_byte_seek_request_get_end_byte (_tmp10_);
		_tmp12_ = _tmp11_;
		self->priv->last_byte = (off_t) (_tmp12_ + 1);
		_tmp13_ = byte_seek;
		_tmp14_ = rygel_http_byte_seek_request_get_start_byte (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = byte_seek;
		_tmp17_ = rygel_http_byte_seek_request_get_end_byte (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->uri;
		g_debug ("rygel-simple-data-source.vala:70: Processing byte seek request for byt" \
"es %lld-%lld of %s", _tmp15_, _tmp18_, _tmp19_);
		_tmp20_ = byte_seek;
		_tmp21_ = rygel_http_byte_seek_response_new_from_request (_tmp20_);
		seek_response = _tmp21_;
		_tmp22_ = response_list;
		_tmp23_ = seek_response;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, (RygelHTTPResponseElement*) _tmp23_);
		_g_object_unref0 (seek_response);
		_g_object_unref0 (byte_seek);
	} else {
		self->priv->first_byte = (off_t) 0;
		self->priv->last_byte = (off_t) 0;
	}
	_tmp24_ = playspeed_request;
	if (_tmp24_ != NULL) {
		const gchar* _tmp25_ = NULL;
		GError* _tmp26_ = NULL;
		_tmp25_ = _ ("Playspeed not supported");
		_tmp26_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_PLAYSPEED_FAILED, _tmp25_);
		_inner_error_ = _tmp26_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (response_list);
		return NULL;
	}
	result = (GeeList*) response_list;
	return result;
}


static gpointer _rygel_simple_data_source_thread_func_gthread_func (gpointer self) {
	gpointer result;
	result = rygel_simple_data_source_thread_func ((RygelSimpleDataSource*) self);
	g_object_unref (self);
	return result;
}


static void rygel_simple_data_source_real_start (RygelDataSource* base, GError** error) {
	RygelSimpleDataSource * self;
	const gchar* _tmp0_ = NULL;
	GThreadPool* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelSimpleDataSource*) base;
	_tmp0_ = self->priv->uri;
	g_debug ("rygel-simple-data-source.vala:91: Starting data source for uri %s", _tmp0_);
	_tmp1_ = self->priv->pool;
	if (_tmp1_ != NULL) {
		GThreadPool* _tmp2_ = NULL;
		RygelSimpleDataSource* _tmp3_ = NULL;
		_tmp2_ = self->priv->pool;
		_tmp3_ = _g_object_ref0 (self);
		g_thread_pool_push (_tmp2_, _tmp3_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	} else {
		GThread* _tmp4_ = NULL;
		_tmp4_ = g_thread_new ("Rygel Serving Thread", _rygel_simple_data_source_thread_func_gthread_func, g_object_ref (self));
		_g_thread_unref0 (self->priv->thread);
		self->priv->thread = _tmp4_;
	}
}


static void rygel_simple_data_source_real_freeze (RygelDataSource* base) {
	RygelSimpleDataSource * self;
	gboolean _tmp0_ = FALSE;
	self = (RygelSimpleDataSource*) base;
	g_mutex_lock (&self->priv->mutex);
	_tmp0_ = self->priv->frozen;
	if (!_tmp0_) {
		self->priv->frozen = TRUE;
	}
	g_mutex_unlock (&self->priv->mutex);
}


static void rygel_simple_data_source_real_thaw (RygelDataSource* base) {
	RygelSimpleDataSource * self;
	gboolean _tmp0_ = FALSE;
	self = (RygelSimpleDataSource*) base;
	g_mutex_lock (&self->priv->mutex);
	_tmp0_ = self->priv->frozen;
	if (_tmp0_) {
		self->priv->frozen = FALSE;
		g_cond_broadcast (&self->priv->cond);
	}
	g_mutex_unlock (&self->priv->mutex);
}


static void rygel_simple_data_source_real_stop (RygelDataSource* base) {
	RygelSimpleDataSource * self;
	gboolean _tmp0_ = FALSE;
	self = (RygelSimpleDataSource*) base;
	g_mutex_lock (&self->priv->mutex);
	_tmp0_ = self->priv->stop_thread;
	if (!_tmp0_) {
		self->priv->frozen = FALSE;
		self->priv->stop_thread = TRUE;
		g_cond_broadcast (&self->priv->cond);
	}
	g_mutex_unlock (&self->priv->mutex);
}


void rygel_simple_data_source_pool_func (RygelSimpleDataSource* data) {
	RygelSimpleDataSource* _tmp0_ = NULL;
	g_return_if_fail (data != NULL);
	_tmp0_ = data;
	rygel_simple_data_source_run (_tmp0_);
	_g_object_unref0 (data);
}


static void* rygel_simple_data_source_thread_func (RygelSimpleDataSource* self) {
	void* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	rygel_simple_data_source_run (self);
	result = NULL;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelSimpleDataSource* self;
		self = _data1_->self;
		_data1_->slice = (g_free (_data1_->slice), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean ____lambda4_ (Block1Data* _data1_) {
	RygelSimpleDataSource* self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self = _data1_->self;
	_tmp0_ = self->priv->stop_thread;
	if (!_tmp0_) {
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		_tmp1_ = _data1_->slice;
		_tmp1__length1 = _data1_->slice_length1;
		g_signal_emit_by_name ((RygelDataSource*) self, "data-available", _tmp1_, _tmp1__length1);
	}
	result = FALSE;
	return result;
}


static gboolean _____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda4_ (self);
	return result;
}


static gboolean __lambda5_ (RygelSimpleDataSource* self) {
	gboolean result = FALSE;
	g_signal_emit_by_name ((RygelDataSource*) self, "done");
	result = FALSE;
	return result;
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ ((RygelSimpleDataSource*) self);
	return result;
}


static void rygel_simple_data_source_run (RygelSimpleDataSource* self) {
	GFile* file = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint fd = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->uri;
	_tmp1_ = g_file_new_for_commandline_arg (_tmp0_);
	file = _tmp1_;
	_tmp2_ = self->priv->uri;
	g_debug ("rygel-simple-data-source.vala:142: Spawning new thread for streaming f" \
"ile %s", _tmp2_);
	fd = -1;
	{
		GFile* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		off_t _tmp15_ = {0};
		off_t _tmp19_ = {0};
		_tmp3_ = file;
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = open (_tmp5_, O_RDONLY, (mode_t) 0);
		fd = _tmp6_;
		_g_free0 (_tmp5_);
		_tmp7_ = fd;
		if (_tmp7_ < 0) {
			GFile* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			const gchar* _tmp12_ = NULL;
			GError* _tmp13_ = NULL;
			GError* _tmp14_ = NULL;
			_tmp8_ = file;
			_tmp9_ = g_file_get_path (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = errno;
			_tmp12_ = strerror (_tmp11_);
			_tmp13_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to open file '%s': %s", _tmp10_, _tmp12_);
			_tmp14_ = _tmp13_;
			_g_free0 (_tmp10_);
			_inner_error_ = _tmp14_;
			goto __catch1_g_error;
		}
		_tmp15_ = self->priv->last_byte;
		if (_tmp15_ == ((off_t) 0)) {
			gint _tmp16_ = 0;
			off_t _tmp17_ = {0};
			gint _tmp18_ = 0;
			_tmp16_ = fd;
			_tmp17_ = lseek (_tmp16_, (off_t) 0, SEEK_END);
			self->priv->last_byte = _tmp17_;
			_tmp18_ = fd;
			lseek (_tmp18_, (off_t) 0, SEEK_SET);
		}
		_tmp19_ = self->priv->first_byte;
		if (_tmp19_ != ((off_t) 0)) {
			gint _tmp20_ = 0;
			off_t _tmp21_ = {0};
			_tmp20_ = fd;
			_tmp21_ = self->priv->first_byte;
			lseek (_tmp20_, _tmp21_, SEEK_SET);
		}
		while (TRUE) {
			Block1Data* _data1_;
			gboolean exit = FALSE;
			gboolean _tmp23_ = FALSE;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			off_t start = {0};
			off_t _tmp28_ = {0};
			off_t stop = {0};
			off_t _tmp29_ = {0};
			off_t _tmp30_ = {0};
			off_t _tmp31_ = {0};
			off_t _tmp33_ = {0};
			off_t _tmp34_ = {0};
			guint8* _tmp35_ = NULL;
			gint len = 0;
			gint _tmp36_ = 0;
			guint8* _tmp37_ = NULL;
			gint _tmp37__length1 = 0;
			guint8* _tmp38_ = NULL;
			gint _tmp38__length1 = 0;
			gssize _tmp39_ = 0L;
			gint _tmp40_ = 0;
			gint _tmp48_ = 0;
			gint _tmp49_ = 0;
			off_t _tmp50_ = {0};
			_data1_ = g_slice_new0 (Block1Data);
			_data1_->_ref_count_ = 1;
			_data1_->self = g_object_ref (self);
			g_mutex_lock (&self->priv->mutex);
			while (TRUE) {
				gboolean _tmp22_ = FALSE;
				_tmp22_ = self->priv->frozen;
				if (!_tmp22_) {
					break;
				}
				g_cond_wait (&self->priv->cond, &self->priv->mutex);
			}
			_tmp23_ = self->priv->stop_thread;
			exit = _tmp23_;
			g_mutex_unlock (&self->priv->mutex);
			_tmp25_ = exit;
			if (_tmp25_) {
				_tmp24_ = TRUE;
			} else {
				off_t _tmp26_ = {0};
				off_t _tmp27_ = {0};
				_tmp26_ = self->priv->first_byte;
				_tmp27_ = self->priv->last_byte;
				_tmp24_ = _tmp26_ == _tmp27_;
			}
			if (_tmp24_) {
				g_debug ("rygel-simple-data-source.vala:172: Done streaming!");
				block1_data_unref (_data1_);
				_data1_ = NULL;
				break;
			}
			_tmp28_ = self->priv->first_byte;
			start = _tmp28_;
			_tmp29_ = start;
			stop = _tmp29_ + G_MAXUINT16;
			_tmp30_ = stop;
			_tmp31_ = self->priv->last_byte;
			if (_tmp30_ > _tmp31_) {
				off_t _tmp32_ = {0};
				_tmp32_ = self->priv->last_byte;
				stop = _tmp32_;
			}
			_tmp33_ = stop;
			_tmp34_ = start;
			_tmp35_ = g_new0 (guint8, _tmp33_ - _tmp34_);
			_data1_->slice = _tmp35_;
			_data1_->slice_length1 = _tmp33_ - _tmp34_;
			_data1_->_slice_size_ = _data1_->slice_length1;
			_tmp36_ = fd;
			_tmp37_ = _data1_->slice;
			_tmp37__length1 = _data1_->slice_length1;
			_tmp38_ = _data1_->slice;
			_tmp38__length1 = _data1_->slice_length1;
			_tmp39_ = read (_tmp36_, _tmp37_, (gsize) _tmp38__length1);
			len = (gint) _tmp39_;
			_tmp40_ = len;
			if (_tmp40_ < 0) {
				GFile* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				gint _tmp44_ = 0;
				const gchar* _tmp45_ = NULL;
				GError* _tmp46_ = NULL;
				GError* _tmp47_ = NULL;
				_tmp41_ = file;
				_tmp42_ = g_file_get_path (_tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = errno;
				_tmp45_ = strerror (_tmp44_);
				_tmp46_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to read file '%s': %s", _tmp43_, _tmp45_);
				_tmp47_ = _tmp46_;
				_g_free0 (_tmp43_);
				_inner_error_ = _tmp47_;
				block1_data_unref (_data1_);
				_data1_ = NULL;
				goto __catch1_g_error;
			}
			_tmp48_ = len;
			_data1_->slice_length1 = _tmp48_;
			_tmp49_ = _data1_->slice_length1;
			_tmp50_ = stop;
			self->priv->first_byte = _tmp50_;
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda4__gsource_func, block1_data_ref (_data1_), block1_data_unref);
			block1_data_unref (_data1_);
			_data1_ = NULL;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GFile* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		GError* _tmp54_ = NULL;
		const gchar* _tmp55_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp51_ = file;
		_tmp52_ = g_file_get_path (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = _error_;
		_tmp55_ = _tmp54_->message;
		g_warning ("rygel-simple-data-source.vala:204: Failed to stream file %s: %s", _tmp53_, _tmp55_);
		_g_free0 (_tmp53_);
		_g_error_free0 (_error_);
	}
	__finally1:
	{
		gint _tmp56_ = 0;
		_tmp56_ = fd;
		close (_tmp56_);
	}
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (file);
}


static void rygel_simple_data_source_class_init (RygelSimpleDataSourceClass * klass) {
	rygel_simple_data_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelSimpleDataSourcePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_simple_data_source_finalize;
}


static void rygel_simple_data_source_rygel_data_source_interface_init (RygelDataSourceIface * iface) {
	rygel_simple_data_source_rygel_data_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->preroll = (GeeList* (*)(RygelDataSource*, RygelHTTPSeekRequest*, RygelPlaySpeedRequest*, GError**)) rygel_simple_data_source_real_preroll;
	iface->start = (void (*)(RygelDataSource*, GError**)) rygel_simple_data_source_real_start;
	iface->freeze = (void (*)(RygelDataSource*)) rygel_simple_data_source_real_freeze;
	iface->thaw = (void (*)(RygelDataSource*)) rygel_simple_data_source_real_thaw;
	iface->stop = (void (*)(RygelDataSource*)) rygel_simple_data_source_real_stop;
}


static void rygel_simple_data_source_instance_init (RygelSimpleDataSource * self) {
	self->priv = RYGEL_SIMPLE_DATA_SOURCE_GET_PRIVATE (self);
	g_mutex_init (&self->priv->mutex);
	g_cond_init (&self->priv->cond);
	self->priv->first_byte = (off_t) 0;
	self->priv->last_byte = (off_t) 0;
	self->priv->frozen = FALSE;
	self->priv->stop_thread = FALSE;
}


static void rygel_simple_data_source_finalize (GObject* obj) {
	RygelSimpleDataSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSource);
	rygel_data_source_stop ((RygelDataSource*) self);
	_g_free0 (self->priv->uri);
	_g_thread_unref0 (self->priv->thread);
	_vala_clear_GMutex (&self->priv->mutex);
	_vala_clear_GCond (&self->priv->cond);
	G_OBJECT_CLASS (rygel_simple_data_source_parent_class)->finalize (obj);
}


/**
 * A simple data source for use with the simple media engine (RygelSimpleMediaEngine).
 *
 * This does not support time-base seeking with 
 * rygel_data_source_start() because it does not
 * use any multimedia framework. Therefore, calling start() with
 * RYGEL_HTTP_SEEK_TYPE_TIME will fail with a 
 * RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED GError code,
 */
GType rygel_simple_data_source_get_type (void) {
	static volatile gsize rygel_simple_data_source_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_simple_data_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSimpleDataSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_simple_data_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSimpleDataSource), 0, (GInstanceInitFunc) rygel_simple_data_source_instance_init, NULL };
		static const GInterfaceInfo rygel_data_source_info = { (GInterfaceInitFunc) rygel_simple_data_source_rygel_data_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_simple_data_source_type_id;
		rygel_simple_data_source_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSimpleDataSource", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_simple_data_source_type_id, RYGEL_TYPE_DATA_SOURCE, &rygel_data_source_info);
		g_once_init_leave (&rygel_simple_data_source_type_id__volatile, rygel_simple_data_source_type_id);
	}
	return rygel_simple_data_source_type_id__volatile;
}


static void _vala_clear_GMutex (GMutex * mutex) {
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}


static void _vala_clear_GRecMutex (GRecMutex * mutex) {
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}


static void _vala_clear_GRWLock (GRWLock * mutex) {
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}


static void _vala_clear_GCond (GCond * mutex) {
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}



