/* rygel-dtcp-cleartext-request.c generated by valac 0.34.4, the Vala compiler
 * generated from rygel-dtcp-cleartext-request.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;
typedef struct _RygelHTTPSeekRequestPrivate RygelHTTPSeekRequestPrivate;

#define RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST (rygel_dtcp_cleartext_request_get_type ())
#define RYGEL_DTCP_CLEARTEXT_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest))
#define RYGEL_DTCP_CLEARTEXT_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequestClass))
#define RYGEL_IS_DTCP_CLEARTEXT_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST))
#define RYGEL_IS_DTCP_CLEARTEXT_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST))
#define RYGEL_DTCP_CLEARTEXT_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequestClass))

typedef struct _RygelDTCPCleartextRequest RygelDTCPCleartextRequest;
typedef struct _RygelDTCPCleartextRequestClass RygelDTCPCleartextRequestClass;
typedef struct _RygelDTCPCleartextRequestPrivate RygelDTCPCleartextRequestPrivate;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;

#define RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER (rygel_http_media_resource_handler_get_type ())
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandler))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))

typedef struct _RygelHTTPMediaResourceHandler RygelHTTPMediaResourceHandler;
typedef struct _RygelHTTPMediaResourceHandlerClass RygelHTTPMediaResourceHandlerClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHTTPMediaResourceHandlerPrivate RygelHTTPMediaResourceHandlerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelHTTPSeekRequest {
	GObject parent_instance;
	RygelHTTPSeekRequestPrivate * priv;
};

struct _RygelHTTPSeekRequestClass {
	GObjectClass parent_class;
};

struct _RygelDTCPCleartextRequest {
	RygelHTTPSeekRequest parent_instance;
	RygelDTCPCleartextRequestPrivate * priv;
};

struct _RygelDTCPCleartextRequestClass {
	RygelHTTPSeekRequestClass parent_class;
};

struct _RygelDTCPCleartextRequestPrivate {
	gint64 _start_byte;
	gint64 _end_byte;
	gint64 _range_length;
	gint64 _total_size;
};

typedef enum  {
	RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekRequestError;
#define RYGEL_HTTP_SEEK_REQUEST_ERROR rygel_http_seek_request_error_quark ()
typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
	gchar* (*get_default_transfer_mode) (RygelHTTPGetHandler* self);
	gboolean (*supports_transfer_mode) (RygelHTTPGetHandler* self, const gchar* mode);
	gint64 (*get_resource_size) (RygelHTTPGetHandler* self);
	gint64 (*get_resource_duration) (RygelHTTPGetHandler* self);
	gboolean (*supports_byte_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_time_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_playspeed) (RygelHTTPGetHandler* self);
	RygelHTTPResponse* (*render_body) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
};

struct _RygelHTTPMediaResourceHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPMediaResourceHandlerPrivate * priv;
	RygelMediaResource* media_resource;
};

struct _RygelHTTPMediaResourceHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};


static gpointer rygel_dtcp_cleartext_request_parent_class = NULL;

GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_dtcp_cleartext_request_get_type (void) G_GNUC_CONST;
#define RYGEL_DTCP_CLEARTEXT_REQUEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequestPrivate))
enum  {
	RYGEL_DTCP_CLEARTEXT_REQUEST_DUMMY_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE,
	RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE,
	RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH,
	RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE
};
#define RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER "Range.dtcp.com"
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_request_error_quark (void);
GQuark rygel_http_request_error_quark (void);
RygelDTCPCleartextRequest* rygel_dtcp_cleartext_request_new (SoupMessage* message, RygelHTTPGetHandler* handler, GError** error);
RygelDTCPCleartextRequest* rygel_dtcp_cleartext_request_construct (GType object_type, SoupMessage* message, RygelHTTPGetHandler* handler, GError** error);
RygelHTTPSeekRequest* rygel_http_seek_request_construct (GType object_type);
GType rygel_http_media_resource_handler_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GType rygel_http_response_get_type (void) G_GNUC_CONST;
gint64 rygel_media_resource_get_cleartext_size (RygelMediaResource* self);
#define RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED ((gint64) -1)
static void rygel_dtcp_cleartext_request_set_start_byte (RygelDTCPCleartextRequest* self, gint64 value);
static void rygel_dtcp_cleartext_request_set_end_byte (RygelDTCPCleartextRequest* self, gint64 value);
static void rygel_dtcp_cleartext_request_set_range_length (RygelDTCPCleartextRequest* self, gint64 value);
static void rygel_dtcp_cleartext_request_set_total_size (RygelDTCPCleartextRequest* self, gint64 value);
gboolean rygel_dtcp_cleartext_request_supported (SoupMessage* message, RygelHTTPGetHandler* handler);
gboolean rygel_media_resource_is_cleartext_range_support_enabled (RygelMediaResource* self);
gboolean rygel_dtcp_cleartext_request_requested (SoupMessage* message);
gint64 rygel_dtcp_cleartext_request_get_start_byte (RygelDTCPCleartextRequest* self);
gint64 rygel_dtcp_cleartext_request_get_end_byte (RygelDTCPCleartextRequest* self);
gint64 rygel_dtcp_cleartext_request_get_range_length (RygelDTCPCleartextRequest* self);
gint64 rygel_dtcp_cleartext_request_get_total_size (RygelDTCPCleartextRequest* self);
static void rygel_dtcp_cleartext_request_finalize (GObject* obj);
static void _vala_rygel_dtcp_cleartext_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_dtcp_cleartext_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _vala_result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtoll (_tmp0_, &_tmp1_, (guint) 0);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


RygelDTCPCleartextRequest* rygel_dtcp_cleartext_request_construct (GType object_type, SoupMessage* message, RygelHTTPGetHandler* handler, GError** error) {
	RygelDTCPCleartextRequest * self = NULL;
	gint64 start = 0LL;
	gint64 end = 0LL;
	gint64 total_size = 0LL;
	RygelHTTPGetHandler* _tmp0_ = NULL;
	const gchar* range = NULL;
	SoupMessage* _tmp8_ = NULL;
	SoupMessageHeaders* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	gchar** range_tokens = NULL;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar** _tmp24_ = NULL;
	gchar** _tmp25_ = NULL;
	gchar** _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	gint range_tokens_length1 = 0;
	gint _range_tokens_size_ = 0;
	const gchar* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gboolean _tmp34_ = FALSE;
	const gchar* _tmp35_ = NULL;
	gint64 _tmp36_ = 0LL;
	gboolean _tmp37_ = FALSE;
	const gchar* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	gint _tmp45_ = 0;
	gboolean _tmp55_ = FALSE;
	gint64 _tmp56_ = 0LL;
	gboolean _tmp63_ = FALSE;
	gint64 _tmp64_ = 0LL;
	gboolean _tmp71_ = FALSE;
	gint64 _tmp72_ = 0LL;
	gint64 _tmp76_ = 0LL;
	gint64 _tmp77_ = 0LL;
	gint64 _tmp78_ = 0LL;
	gint64 _tmp79_ = 0LL;
	gint64 _tmp82_ = 0LL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (handler != NULL, NULL);
	self = (RygelDTCPCleartextRequest*) rygel_http_seek_request_construct (object_type);
	_tmp0_ = handler;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER)) {
		RygelMediaResource* resource = NULL;
		RygelHTTPGetHandler* _tmp1_ = NULL;
		RygelMediaResource* _tmp2_ = NULL;
		RygelMediaResource* _tmp3_ = NULL;
		RygelMediaResource* _tmp4_ = NULL;
		gint64 _tmp5_ = 0LL;
		gint64 _tmp6_ = 0LL;
		gint64 _tmp7_ = 0LL;
		_tmp1_ = handler;
		_tmp2_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER) ? ((RygelHTTPMediaResourceHandler*) _tmp1_) : NULL)->media_resource;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		resource = _tmp3_;
		_tmp4_ = resource;
		_tmp5_ = rygel_media_resource_get_cleartext_size (_tmp4_);
		_tmp6_ = _tmp5_;
		total_size = _tmp6_;
		_tmp7_ = total_size;
		if (_tmp7_ <= ((gint64) 0)) {
			total_size = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
		}
		_g_object_unref0 (resource);
	} else {
		total_size = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	}
	_tmp8_ = message;
	_tmp9_ = _tmp8_->request_headers;
	_tmp10_ = soup_message_headers_get_one (_tmp9_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER);
	range = _tmp10_;
	_tmp11_ = range;
	if (_tmp11_ == NULL) {
		gchar* msg = NULL;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		_tmp12_ = g_strdup ("%s request header not present");
		msg = _tmp12_;
		_tmp13_ = msg;
		_tmp14_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp13_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER);
		_inner_error_ = _tmp14_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (msg);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp15_ = range;
	_tmp16_ = g_str_has_prefix (_tmp15_, "bytes");
	if (!_tmp16_) {
		gchar* msg = NULL;
		gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		GError* _tmp20_ = NULL;
		_tmp17_ = g_strdup ("Invalid %s value (missing bytes field): '%s'");
		msg = _tmp17_;
		_tmp18_ = msg;
		_tmp19_ = range;
		_tmp20_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp18_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp19_);
		_inner_error_ = _tmp20_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (msg);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp21_ = range;
	_tmp22_ = string_substring (_tmp21_, (glong) 6, (glong) -1);
	_tmp23_ = _tmp22_;
	_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, "-", 2);
	_tmp26_ = _tmp25_;
	_tmp26__length1 = _vala_array_length (_tmp24_);
	_g_free0 (_tmp23_);
	range_tokens = _tmp26_;
	range_tokens_length1 = _tmp26__length1;
	_range_tokens_size_ = range_tokens_length1;
	_tmp27_ = range_tokens[0];
	_tmp28_ = strlen (_tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp29_ == 0) {
		gchar* msg = NULL;
		gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		GError* _tmp33_ = NULL;
		_tmp30_ = g_strdup ("No range start specified: '%s'");
		msg = _tmp30_;
		_tmp31_ = msg;
		_tmp32_ = range;
		_tmp33_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp31_, _tmp32_);
		_inner_error_ = _tmp33_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp35_ = range_tokens[0];
	_tmp37_ = int64_try_parse (_tmp35_, &_tmp36_);
	start = _tmp36_;
	if (!_tmp37_) {
		_tmp34_ = TRUE;
	} else {
		gint64 _tmp38_ = 0LL;
		_tmp38_ = start;
		_tmp34_ = _tmp38_ < ((gint64) 0);
	}
	if (_tmp34_) {
		gchar* msg = NULL;
		gchar* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
		GError* _tmp42_ = NULL;
		_tmp39_ = g_strdup ("Invalid %s range start: '%s'");
		msg = _tmp39_;
		_tmp40_ = msg;
		_tmp41_ = range;
		_tmp42_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp40_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp41_);
		_inner_error_ = _tmp42_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp43_ = range_tokens[1];
	_tmp44_ = strlen (_tmp43_);
	_tmp45_ = _tmp44_;
	if (_tmp45_ == 0) {
		end = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	} else {
		gboolean _tmp46_ = FALSE;
		const gchar* _tmp47_ = NULL;
		gint64 _tmp48_ = 0LL;
		gboolean _tmp49_ = FALSE;
		_tmp47_ = range_tokens[1];
		_tmp49_ = int64_try_parse (_tmp47_, &_tmp48_);
		end = _tmp48_;
		if (!_tmp49_) {
			_tmp46_ = TRUE;
		} else {
			gint64 _tmp50_ = 0LL;
			_tmp50_ = end;
			_tmp46_ = _tmp50_ <= ((gint64) 0);
		}
		if (_tmp46_) {
			gchar* msg = NULL;
			gchar* _tmp51_ = NULL;
			const gchar* _tmp52_ = NULL;
			const gchar* _tmp53_ = NULL;
			GError* _tmp54_ = NULL;
			_tmp51_ = g_strdup ("Invalid %s range end: '%s'");
			msg = _tmp51_;
			_tmp52_ = msg;
			_tmp53_ = range;
			_tmp54_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp52_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp53_);
			_inner_error_ = _tmp54_;
			if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (msg);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_free0 (msg);
		}
	}
	_tmp56_ = end;
	if (_tmp56_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		gint64 _tmp57_ = 0LL;
		gint64 _tmp58_ = 0LL;
		_tmp57_ = start;
		_tmp58_ = end;
		_tmp55_ = _tmp57_ > _tmp58_;
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		gchar* msg = NULL;
		gchar* _tmp59_ = NULL;
		const gchar* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		GError* _tmp62_ = NULL;
		_tmp59_ = g_strdup ("Invalid %s range - start > end: '%s'");
		msg = _tmp59_;
		_tmp60_ = msg;
		_tmp61_ = range;
		_tmp62_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp60_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp61_);
		_inner_error_ = _tmp62_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp64_ = total_size;
	if (_tmp64_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		gint64 _tmp65_ = 0LL;
		gint64 _tmp66_ = 0LL;
		_tmp65_ = start;
		_tmp66_ = total_size;
		_tmp63_ = _tmp65_ > (_tmp66_ - 1);
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gchar* msg = NULL;
		gchar* _tmp67_ = NULL;
		const gchar* _tmp68_ = NULL;
		const gchar* _tmp69_ = NULL;
		GError* _tmp70_ = NULL;
		_tmp67_ = g_strdup ("Invalid %s range - start > length: '%s'");
		msg = _tmp67_;
		_tmp68_ = msg;
		_tmp69_ = range;
		_tmp70_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE, _tmp68_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp69_);
		_inner_error_ = _tmp70_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp72_ = total_size;
	if (_tmp72_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		gint64 _tmp73_ = 0LL;
		gint64 _tmp74_ = 0LL;
		_tmp73_ = end;
		_tmp74_ = total_size;
		_tmp71_ = _tmp73_ > (_tmp74_ - 1);
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		gint64 _tmp75_ = 0LL;
		_tmp75_ = total_size;
		end = _tmp75_ - 1;
	}
	_tmp76_ = start;
	rygel_dtcp_cleartext_request_set_start_byte (self, _tmp76_);
	_tmp77_ = end;
	rygel_dtcp_cleartext_request_set_end_byte (self, _tmp77_);
	_tmp79_ = end;
	if (_tmp79_ == RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		_tmp78_ = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	} else {
		gint64 _tmp80_ = 0LL;
		gint64 _tmp81_ = 0LL;
		_tmp80_ = end;
		_tmp81_ = start;
		_tmp78_ = (_tmp80_ - _tmp81_) + 1;
	}
	rygel_dtcp_cleartext_request_set_range_length (self, _tmp78_);
	_tmp82_ = total_size;
	rygel_dtcp_cleartext_request_set_total_size (self, _tmp82_);
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


RygelDTCPCleartextRequest* rygel_dtcp_cleartext_request_new (SoupMessage* message, RygelHTTPGetHandler* handler, GError** error) {
	return rygel_dtcp_cleartext_request_construct (RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, message, handler, error);
}


gboolean rygel_dtcp_cleartext_request_supported (SoupMessage* message, RygelHTTPGetHandler* handler) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	RygelHTTPGetHandler* _tmp1_ = NULL;
	g_return_val_if_fail (message != NULL, FALSE);
	g_return_val_if_fail (handler != NULL, FALSE);
	_tmp1_ = handler;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER)) {
		RygelHTTPGetHandler* _tmp2_ = NULL;
		RygelMediaResource* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = handler;
		_tmp3_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER) ? ((RygelHTTPMediaResourceHandler*) _tmp2_) : NULL)->media_resource;
		_tmp4_ = rygel_media_resource_is_cleartext_range_support_enabled (_tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean rygel_dtcp_cleartext_request_requested (SoupMessage* message) {
	gboolean result = FALSE;
	SoupMessage* _tmp0_ = NULL;
	SoupMessageHeaders* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = message;
	_tmp1_ = _tmp0_->request_headers;
	_tmp2_ = soup_message_headers_get_one (_tmp1_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER);
	result = _tmp2_ != NULL;
	return result;
}


gint64 rygel_dtcp_cleartext_request_get_start_byte (RygelDTCPCleartextRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_start_byte;
	result = _tmp0_;
	return result;
}


static void rygel_dtcp_cleartext_request_set_start_byte (RygelDTCPCleartextRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_start_byte = _tmp0_;
	g_object_notify ((GObject *) self, "start-byte");
}


gint64 rygel_dtcp_cleartext_request_get_end_byte (RygelDTCPCleartextRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_end_byte;
	result = _tmp0_;
	return result;
}


static void rygel_dtcp_cleartext_request_set_end_byte (RygelDTCPCleartextRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_end_byte = _tmp0_;
	g_object_notify ((GObject *) self, "end-byte");
}


gint64 rygel_dtcp_cleartext_request_get_range_length (RygelDTCPCleartextRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_range_length;
	result = _tmp0_;
	return result;
}


static void rygel_dtcp_cleartext_request_set_range_length (RygelDTCPCleartextRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_range_length = _tmp0_;
	g_object_notify ((GObject *) self, "range-length");
}


gint64 rygel_dtcp_cleartext_request_get_total_size (RygelDTCPCleartextRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_total_size;
	result = _tmp0_;
	return result;
}


static void rygel_dtcp_cleartext_request_set_total_size (RygelDTCPCleartextRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_total_size = _tmp0_;
	g_object_notify ((GObject *) self, "total-size");
}


static void rygel_dtcp_cleartext_request_class_init (RygelDTCPCleartextRequestClass * klass) {
	rygel_dtcp_cleartext_request_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelDTCPCleartextRequestPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_dtcp_cleartext_request_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_dtcp_cleartext_request_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_dtcp_cleartext_request_finalize;
	/**
	     * The start of the cleartext range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE, g_param_spec_int64 ("start-byte", "start-byte", "start-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The end of the cleartext range in bytes (inclusive). May be
	     * HTTPSeekRequest.UNSPECIFIED
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE, g_param_spec_int64 ("end-byte", "end-byte", "end-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The length of the cleartext range in bytes. May be
	     * HTTPSeekRequest.UNSPECIFIED
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH, g_param_spec_int64 ("range-length", "range-length", "range-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The length of the cleartext resource in bytes. May be
	     * HTTPSeekRequest.UNSPECIFIED
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE, g_param_spec_int64 ("total-size", "total-size", "total-size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_dtcp_cleartext_request_instance_init (RygelDTCPCleartextRequest * self) {
	self->priv = RYGEL_DTCP_CLEARTEXT_REQUEST_GET_PRIVATE (self);
}


static void rygel_dtcp_cleartext_request_finalize (GObject* obj) {
	RygelDTCPCleartextRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest);
	G_OBJECT_CLASS (rygel_dtcp_cleartext_request_parent_class)->finalize (obj);
}


GType rygel_dtcp_cleartext_request_get_type (void) {
	static volatile gsize rygel_dtcp_cleartext_request_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_dtcp_cleartext_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDTCPCleartextRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_dtcp_cleartext_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDTCPCleartextRequest), 0, (GInstanceInitFunc) rygel_dtcp_cleartext_request_instance_init, NULL };
		GType rygel_dtcp_cleartext_request_type_id;
		rygel_dtcp_cleartext_request_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK_REQUEST, "RygelDTCPCleartextRequest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_dtcp_cleartext_request_type_id__volatile, rygel_dtcp_cleartext_request_type_id);
	}
	return rygel_dtcp_cleartext_request_type_id__volatile;
}


static void _vala_rygel_dtcp_cleartext_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelDTCPCleartextRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest);
	switch (property_id) {
		case RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE:
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_start_byte (self));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE:
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_end_byte (self));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH:
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_range_length (self));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE:
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_total_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_dtcp_cleartext_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelDTCPCleartextRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest);
	switch (property_id) {
		case RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE:
		rygel_dtcp_cleartext_request_set_start_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE:
		rygel_dtcp_cleartext_request_set_end_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH:
		rygel_dtcp_cleartext_request_set_range_length (self, g_value_get_int64 (value));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE:
		rygel_dtcp_cleartext_request_set_total_size (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



