// Generated by gmmproc 2.49.2 -- DO NOT MODIFY!
#ifndef _IDEMM_URI_H
#define _IDEMM_URI_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* uri.hg
 *
 * Copyright (C) 2016 Marcin Kolny <marcin.kolny@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <giomm/file.h>

#include <ide.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _IdeUri IdeUri; }
#endif

namespace Ide {

/** @addtogroup idemmEnums idemm Enums and Flags */

/** 
 *  @var UriParseFlags URI_PARSE_STRICT
 * Parse the URI strictly according to the RFC
 * 3986 grammar.
 * 
 *  @var UriParseFlags URI_PARSE_HTML5
 * Parse the URI according to the HTML5 web
 * address parsing rules.
 * 
 *  @var UriParseFlags URI_PARSE_NO_IRI
 * Disallow Internationalized URIs; return an
 * error if the URI contains non-ASCII characters.
 * 
 *  @var UriParseFlags URI_PARSE_PASSWORD
 * Split the userinfo into user and password,
 * separated by ':'.
 * 
 *  @var UriParseFlags URI_PARSE_AUTH_PARAMS
 * Split the userinfo into user/password and
 * parameters, separated by ';'.
 * 
 *  @var UriParseFlags URI_PARSE_NON_DNS
 * Do not parse the host as a DNS host/IP address.
 * (Eg, for smb URIs with NetBIOS hostnames).
 * 
 *  @var UriParseFlags URI_PARSE_DECODED
 * Decode even reserved %<!-- -->encoded
 * characters in the URI (unless this would result in non-UTF8
 * strings). Using this flag means that you cannot reliably
 * convert the parsed URI back to string form with
 * ide_uri_to_string().
 * 
 *  @var UriParseFlags URI_PARSE_UTF8_ONLY
 * Return an error if non-UTF8 characters are
 * encountered in the URI.
 * 
 *  @enum UriParseFlags
 * 
 * Flags that control how a URI string is parsed (or re-parsed).
 *
 * @ingroup idemmEnums
 * @par Bitwise operators:
 * <tt>%UriParseFlags operator|(UriParseFlags, UriParseFlags)</tt><br>
 * <tt>%UriParseFlags operator&(UriParseFlags, UriParseFlags)</tt><br>
 * <tt>%UriParseFlags operator^(UriParseFlags, UriParseFlags)</tt><br>
 * <tt>%UriParseFlags operator~(UriParseFlags)</tt><br>
 * <tt>%UriParseFlags& operator|=(UriParseFlags&, UriParseFlags)</tt><br>
 * <tt>%UriParseFlags& operator&=(UriParseFlags&, UriParseFlags)</tt><br>
 * <tt>%UriParseFlags& operator^=(UriParseFlags&, UriParseFlags)</tt><br>
 */
enum UriParseFlags
{
  URI_PARSE_STRICT = 1 << 0,
  URI_PARSE_HTML5 = 1 << 1,
  URI_PARSE_NO_IRI = 1 << 2,
  URI_PARSE_PASSWORD = 1 << 3,
  URI_PARSE_AUTH_PARAMS = 1 << 4,
  URI_PARSE_NON_DNS = 1 << 5,
  URI_PARSE_DECODED = 1 << 6,
  URI_PARSE_UTF8_ONLY = 1 << 7
};

/** @ingroup idemmEnums */
inline UriParseFlags operator|(UriParseFlags lhs, UriParseFlags rhs)
  { return static_cast<UriParseFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup idemmEnums */
inline UriParseFlags operator&(UriParseFlags lhs, UriParseFlags rhs)
  { return static_cast<UriParseFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup idemmEnums */
inline UriParseFlags operator^(UriParseFlags lhs, UriParseFlags rhs)
  { return static_cast<UriParseFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup idemmEnums */
inline UriParseFlags operator~(UriParseFlags flags)
  { return static_cast<UriParseFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup idemmEnums */
inline UriParseFlags& operator|=(UriParseFlags& lhs, UriParseFlags rhs)
  { return (lhs = static_cast<UriParseFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup idemmEnums */
inline UriParseFlags& operator&=(UriParseFlags& lhs, UriParseFlags rhs)
  { return (lhs = static_cast<UriParseFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup idemmEnums */
inline UriParseFlags& operator^=(UriParseFlags& lhs, UriParseFlags rhs)
  { return (lhs = static_cast<UriParseFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/** 
 *
 * @ingroup idemmEnums
 * @par Bitwise operators:
 * <tt>%UriToStringFlags operator|(UriToStringFlags, UriToStringFlags)</tt><br>
 * <tt>%UriToStringFlags operator&(UriToStringFlags, UriToStringFlags)</tt><br>
 * <tt>%UriToStringFlags operator^(UriToStringFlags, UriToStringFlags)</tt><br>
 * <tt>%UriToStringFlags operator~(UriToStringFlags)</tt><br>
 * <tt>%UriToStringFlags& operator|=(UriToStringFlags&, UriToStringFlags)</tt><br>
 * <tt>%UriToStringFlags& operator&=(UriToStringFlags&, UriToStringFlags)</tt><br>
 * <tt>%UriToStringFlags& operator^=(UriToStringFlags&, UriToStringFlags)</tt><br>
 */
enum UriToStringFlags
{
  URI_HIDE_AUTH_PARAMS = 1 << 0,
  URI_HIDE_FRAGMENT = 1 << 1
};

/** @ingroup idemmEnums */
inline UriToStringFlags operator|(UriToStringFlags lhs, UriToStringFlags rhs)
  { return static_cast<UriToStringFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup idemmEnums */
inline UriToStringFlags operator&(UriToStringFlags lhs, UriToStringFlags rhs)
  { return static_cast<UriToStringFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup idemmEnums */
inline UriToStringFlags operator^(UriToStringFlags lhs, UriToStringFlags rhs)
  { return static_cast<UriToStringFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup idemmEnums */
inline UriToStringFlags operator~(UriToStringFlags flags)
  { return static_cast<UriToStringFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup idemmEnums */
inline UriToStringFlags& operator|=(UriToStringFlags& lhs, UriToStringFlags rhs)
  { return (lhs = static_cast<UriToStringFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup idemmEnums */
inline UriToStringFlags& operator&=(UriToStringFlags& lhs, UriToStringFlags rhs)
  { return (lhs = static_cast<UriToStringFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup idemmEnums */
inline UriToStringFlags& operator^=(UriToStringFlags& lhs, UriToStringFlags rhs)
  { return (lhs = static_cast<UriToStringFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


class Uri
{
  // TODO: IdeUri defines ide_uri_ref as a copy method. why?
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = Uri;
  using BaseObjectType = IdeUri;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;

  Uri();

  explicit Uri(IdeUri* gobject, bool make_a_copy = true);

  Uri(const Uri& other);
  Uri& operator=(const Uri& other);

  Uri(Uri&& other) noexcept;
  Uri& operator=(Uri&& other) noexcept;

  ~Uri() noexcept;

  void swap(Uri& other) noexcept;

  ///Provides access to the underlying C instance.
  IdeUri*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const IdeUri* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  IdeUri* gobj_copy() const;

protected:
  IdeUri* gobject_;

private:


public:
  Uri(const Glib::ustring& uri_string, Ide::UriParseFlags flags);
  Uri(const Uri& base_uri, const Glib::ustring& uri_string, Ide::UriParseFlags flags);
  Uri(const Glib::RefPtr<Gio::File>& file);

  
  // todo operator string?
  
  /** Returns a string representing @a uri.
   * 
   * @param flags Flags describing how to convert @a uri.
   * @return A string representing @a uri, which the caller must free.
   */
  Glib::ustring to_string(Ide::UriToStringFlags flags) const;
  
  
  /** Gets @a uri's scheme.
   * 
   * @return  @a uri's scheme.
   */
  Glib::ustring get_scheme() const;
  
  /** Sets @a uri's scheme to @a scheme.
   * 
   * @param scheme The URI scheme.
   */
  void set_scheme(const Glib::ustring& scheme);
  
  
  /** Gets @a uri's user. If @a uri was parsed with Ide::URI_PARSE_PASSWORD or
   * Ide::URI_PARSE_AUTH_PARAMS, this is the string that appears before the
   * password and parameters in the userinfo. If not, then the entire
   * userinfo is considered the user.
   * 
   * @return  @a uri's user.
   */
  Glib::ustring get_user() const;
  
  /** Sets @a uri's user to @a user. See ide_uri_get_user() for a description
   * of how this interacts with various parsing flags.
   * 
   * @param user The username, or <tt>nullptr</tt>.
   */
  void set_user(const Glib::ustring& user);
  
  
  /** Gets @a uri's password. If @a uri was not parsed with
   * Ide::URI_PARSE_PASSWORD, this will always be <tt>nullptr</tt>.
   * 
   * @return  @a uri's password.
   */
  Glib::ustring get_password() const;
  
  /** Sets @a uri's password to @a password.
   * 
   * @param password The password, or <tt>nullptr</tt>.
   */
  void set_password(const Glib::ustring& password);
  
  
  /** Gets @a uri's authentication parameters. Depending on the URI scheme,
   * ide_uri_parse_params() may be useful for further parsing this
   * information.
   * 
   * @return  @a uri's authentication parameters.
   */
  Glib::ustring get_auth_params() const;
  
  /** Sets @a uri's authentication parameters to @a auth_params.
   * 
   * @param auth_params The authentication parameters, or <tt>nullptr</tt>.
   */
  void set_auth_params(const Glib::ustring& auth_params);
  
  
  /** Gets @a uri's host. If @a uri contained an IPv6 address literal, this
   * value will not include the brackets that are required by the URI
   * syntax.
   * 
   * @return  @a uri's host.
   */
  Glib::ustring get_host() const;
  
  /** Sets @a uri's host to @a host.
   * 
   * If @a host is an IPv6 IP address, it should not include the brackets
   * required by the URI syntax; they will be added automatically when
   * converting @a uri to a string.
   * 
   * @param host The hostname or IP address, or <tt>nullptr</tt>.
   */
  void set_host(const Glib::ustring& host);
  
  
  /** Gets @a uri's port.
   * 
   * @return  @a uri's port, or %0 if it was unset.
   */
  gushort get_port() const;
  
  /** Sets @a uri's port to @a port. If @a port is 0, it will not be output
   * when calling ide_uri_to_string().
   * 
   * @param port The port, or %0.
   */
  void set_port(gushort port);
  
  
  /** Gets @a uri's path, which may contain %<!-- -->-encoding, depending
   * on the flags with which @a uri was parsed.
   * 
   * @return  @a uri's path.
   */
  Glib::ustring get_path() const;
  
  /** Sets @a uri's path to @a path, which is assumed to have been
   * appropriately %<!-- -->-encoded. In particular, this means that if
   * you want to include a literal percent sign the path, you must write
   * it as "%<!-- -->25". That being said, if @a path contains an
   * unencoded '?' or '#' character, it will get encoded, since
   * otherwise converting @a uri to a string and then back to a Ide::Uri
   * again would give a different result.
   * 
   * @param path The (%<!-- -->-encoded) path.
   */
  void set_path(const Glib::ustring& path);
  
  
  /** Gets @a uri's query, which may contain %<!-- -->-encoding, depending
   * on the flags with which @a uri was parsed.
   * 
   * For queries consisting of a series of "name=value" parameters,
   * ide_uri_parse_params() may be useful.
   * 
   * @return  @a uri's query.
   */
  Glib::ustring get_query() const;
  
  /** Sets @a uri's query to @a query, which is assumed to have been
   * %<!-- -->-encoded by the caller. See ide_uri_set_path() for more
   * details.
   * 
   * @param query The (%<!-- -->-encoded) query.
   */
  void set_query(const Glib::ustring& query);
  
  
  /** Gets @a uri's fragment, which may contain %<!-- -->-encoding,
   * depending on the flags with which @a uri was parsed.
   * 
   * @return  @a uri's fragment.
   */
  Glib::ustring get_fragment() const;
  
  /** Sets @a uri's fragment to @a fragment, which is assumed to have been
   * %<!-- -->-encoded by the caller. See ide_uri_set_path() for more
   * details.
   * 
   * @param fragment The (%<!-- -->-encoded) fragment.
   */
  void set_fragment(const Glib::ustring& fragment);
  
  
  bool is_file(const Glib::RefPtr<Gio::File>& file) const;
  
  /** Creates a File that represents the resource @a uri.
   * 
   * @return A File or <tt>nullptr</tt> upon failure.
   */
  Glib::RefPtr<Gio::File> to_file() const;


};

}


namespace Ide
{

/** @relates Ide::Uri
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(Uri& lhs, Uri& rhs) noexcept
  { lhs.swap(rhs); }

} // namespace Ide

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Ide::Uri
 */
Ide::Uri wrap(IdeUri* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Ide::Uri> : public Glib::Value_Boxed<Ide::Uri>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _IDEMM_URI_H */

