/* gkr-item-properties.c generated by valac 0.28.0, the Vala compiler
 * generated from gkr-item-properties.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2006 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "seahorse-gkr.h"
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <libsecret/secret.h>
#include <gio/gio.h>
#include "seahorse-common.h"
#include <gdk/gdk.h>
#include <ui/gcr-ui.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _secret_value_unref0(var) ((var == NULL) ? NULL : (var = (secret_value_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;

struct _SeahorseGkrItemPropertiesPrivate {
	SeahorseGkrItem* _item;
	GtkBuilder* _builder;
	GtkEntry* _password_entry;
	GtkExpander* _password_expander;
	gboolean _password_changed;
	gboolean _updating_password;
	gboolean _updating_description;
};

struct _Block3Data {
	int _ref_count_;
	SeahorseGkrItemProperties* self;
	GtkEntry* description;
};

struct _Block4Data {
	int _ref_count_;
	SeahorseGkrItemProperties* self;
	GtkEntry* description;
	GtkCheckButton* check;
};


static gpointer seahorse_gkr_item_properties_parent_class = NULL;

#define SEAHORSE_GKR_ITEM_PROPERTIES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_GKR_TYPE_ITEM_PROPERTIES, SeahorseGkrItemPropertiesPrivate))
enum  {
	SEAHORSE_GKR_ITEM_PROPERTIES_DUMMY_PROPERTY,
	SEAHORSE_GKR_ITEM_PROPERTIES_ITEM
};
static void seahorse_gkr_item_properties_update_use (SeahorseGkrItemProperties* self);
static void seahorse_gkr_item_properties_update_type (SeahorseGkrItemProperties* self);
static void seahorse_gkr_item_properties_update_visibility (SeahorseGkrItemProperties* self);
static void seahorse_gkr_item_properties_update_server (SeahorseGkrItemProperties* self);
static void seahorse_gkr_item_properties_update_user (SeahorseGkrItemProperties* self);
static void seahorse_gkr_item_properties_update_details (SeahorseGkrItemProperties* self);
static void seahorse_gkr_item_properties_password_activate (SeahorseGkrItemProperties* self);
static void __lambda21_ (SeahorseGkrItemProperties* self, GObject* obj, GAsyncResult* res);
static void seahorse_gkr_item_properties_password_display (SeahorseGkrItemProperties* self);
static void ___lambda21__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void seahorse_gkr_item_properties_description_activate (SeahorseGkrItemProperties* self, GtkEntry* description);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda22_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res);
static void ___lambda22__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void seahorse_gkr_item_properties_expander_activate (SeahorseGkrItemProperties* self, GtkExpander* expander);
static GObject * seahorse_gkr_item_properties_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void _seahorse_gkr_item_properties___lambda23_ (SeahorseGkrItemProperties* self, gint response);
static void __seahorse_gkr_item_properties___lambda23__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void _seahorse_gkr_item_properties___lambda24_ (Block4Data* _data4_);
static void __seahorse_gkr_item_properties___lambda24__gtk_entry_activate (GtkEntry* _sender, gpointer self);
static gboolean _seahorse_gkr_item_properties___lambda25_ (Block4Data* _data4_);
static gboolean __seahorse_gkr_item_properties___lambda25__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void _seahorse_gkr_item_properties_expander_activate_gtk_expander_activate (GtkExpander* _sender, gpointer self);
static void _seahorse_gkr_item_properties___lambda26_ (Block4Data* _data4_);
static void __seahorse_gkr_item_properties___lambda26__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _seahorse_gkr_item_properties___lambda27_ (SeahorseGkrItemProperties* self, GParamSpec* pspec);
static void __seahorse_gkr_item_properties___lambda27__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _seahorse_gkr_item_properties_password_activate_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void _seahorse_gkr_item_properties___lambda28_ (SeahorseGkrItemProperties* self);
static void __seahorse_gkr_item_properties___lambda28__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static gboolean _seahorse_gkr_item_properties___lambda29_ (SeahorseGkrItemProperties* self);
static gboolean __seahorse_gkr_item_properties___lambda29__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void seahorse_gkr_item_properties_finalize (GObject* obj);
static void _vala_seahorse_gkr_item_properties_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_seahorse_gkr_item_properties_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


SeahorseGkrItemProperties* seahorse_gkr_item_properties_construct (GType object_type, SeahorseGkrItem* item, GtkWindow* parent) {
	SeahorseGkrItemProperties * self = NULL;
	SeahorseGkrItem* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	SeahorseGkrItem* _tmp2_ = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = parent;
	self = (SeahorseGkrItemProperties*) g_object_new (object_type, "item", _tmp0_, "transient-for", _tmp1_, NULL);
	_tmp2_ = item;
	seahorse_gkr_item_refresh (_tmp2_);
	return self;
}


SeahorseGkrItemProperties* seahorse_gkr_item_properties_new (SeahorseGkrItem* item, GtkWindow* parent) {
	return seahorse_gkr_item_properties_construct (SEAHORSE_GKR_TYPE_ITEM_PROPERTIES, item, parent);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void seahorse_gkr_item_properties_update_use (SeahorseGkrItemProperties* self) {
	GtkLabel* use = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	SeahorseGkrItem* _tmp3_ = NULL;
	SeahorseGkrUse _tmp4_ = 0;
	SeahorseGkrUse _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "use-field");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_label_get_type (), GtkLabel));
	use = _tmp2_;
	_tmp3_ = self->priv->_item;
	_tmp4_ = seahorse_gkr_item_get_use (_tmp3_);
	_tmp5_ = _tmp4_;
	switch (_tmp5_) {
		case SEAHORSE_GKR_USE_NETWORK:
		{
			GtkLabel* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			_tmp6_ = use;
			_tmp7_ = _ ("Access a network share or resource");
			gtk_label_set_label (_tmp6_, _tmp7_);
			break;
		}
		case SEAHORSE_GKR_USE_WEB:
		{
			GtkLabel* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			_tmp8_ = use;
			_tmp9_ = _ ("Access a website");
			gtk_label_set_label (_tmp8_, _tmp9_);
			break;
		}
		case SEAHORSE_GKR_USE_PGP:
		{
			GtkLabel* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			_tmp10_ = use;
			_tmp11_ = _ ("Unlocks a PGP key");
			gtk_label_set_label (_tmp10_, _tmp11_);
			break;
		}
		case SEAHORSE_GKR_USE_SSH:
		{
			GtkLabel* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			_tmp12_ = use;
			_tmp13_ = _ ("Unlocks a Secure Shell key");
			gtk_label_set_label (_tmp12_, _tmp13_);
			break;
		}
		case SEAHORSE_GKR_USE_OTHER:
		{
			GtkLabel* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			_tmp14_ = use;
			_tmp15_ = _ ("Saved password or login");
			gtk_label_set_label (_tmp14_, _tmp15_);
			break;
		}
		default:
		{
			GtkLabel* _tmp16_ = NULL;
			_tmp16_ = use;
			gtk_label_set_label (_tmp16_, "");
			break;
		}
	}
	_g_object_unref0 (use);
}


static void seahorse_gkr_item_properties_update_type (SeahorseGkrItemProperties* self) {
	GtkLabel* type = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	SeahorseGkrItem* _tmp3_ = NULL;
	SeahorseGkrUse _tmp4_ = 0;
	SeahorseGkrUse _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "type-field");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_label_get_type (), GtkLabel));
	type = _tmp2_;
	_tmp3_ = self->priv->_item;
	_tmp4_ = seahorse_gkr_item_get_use (_tmp3_);
	_tmp5_ = _tmp4_;
	switch (_tmp5_) {
		case SEAHORSE_GKR_USE_NETWORK:
		case SEAHORSE_GKR_USE_WEB:
		{
			GtkLabel* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			_tmp6_ = type;
			_tmp7_ = _ ("Network Credentials");
			gtk_label_set_label (_tmp6_, _tmp7_);
			break;
		}
		case SEAHORSE_GKR_USE_PGP:
		case SEAHORSE_GKR_USE_SSH:
		case SEAHORSE_GKR_USE_OTHER:
		{
			GtkLabel* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			_tmp8_ = type;
			_tmp9_ = _ ("Password");
			gtk_label_set_label (_tmp8_, _tmp9_);
			break;
		}
		default:
		{
			GtkLabel* _tmp10_ = NULL;
			_tmp10_ = type;
			gtk_label_set_label (_tmp10_, "");
			break;
		}
	}
	_g_object_unref0 (type);
}


static void seahorse_gkr_item_properties_update_visibility (SeahorseGkrItemProperties* self) {
	SeahorseGkrUse use = 0;
	SeahorseGkrItem* _tmp0_ = NULL;
	SeahorseGkrUse _tmp1_ = 0;
	SeahorseGkrUse _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	SeahorseGkrUse _tmp4_ = 0;
	gboolean visible = FALSE;
	GtkBuilder* _tmp6_ = NULL;
	GObject* _tmp7_ = NULL;
	GtkBuilder* _tmp8_ = NULL;
	GObject* _tmp9_ = NULL;
	GtkBuilder* _tmp10_ = NULL;
	GObject* _tmp11_ = NULL;
	GtkBuilder* _tmp12_ = NULL;
	GObject* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_item;
	_tmp1_ = seahorse_gkr_item_get_use (_tmp0_);
	_tmp2_ = _tmp1_;
	use = _tmp2_;
	_tmp4_ = use;
	if (_tmp4_ == SEAHORSE_GKR_USE_NETWORK) {
		_tmp3_ = TRUE;
	} else {
		SeahorseGkrUse _tmp5_ = 0;
		_tmp5_ = use;
		_tmp3_ = _tmp5_ == SEAHORSE_GKR_USE_WEB;
	}
	visible = _tmp3_;
	_tmp6_ = self->priv->_builder;
	_tmp7_ = gtk_builder_get_object (_tmp6_, "server-label");
	g_object_set (_tmp7_, "visible", visible, NULL);
	_tmp8_ = self->priv->_builder;
	_tmp9_ = gtk_builder_get_object (_tmp8_, "server-field");
	g_object_set (_tmp9_, "visible", visible, NULL);
	_tmp10_ = self->priv->_builder;
	_tmp11_ = gtk_builder_get_object (_tmp10_, "login-label");
	g_object_set (_tmp11_, "visible", visible, NULL);
	_tmp12_ = self->priv->_builder;
	_tmp13_ = gtk_builder_get_object (_tmp12_, "login-field");
	g_object_set (_tmp13_, "visible", visible, NULL);
}


static void seahorse_gkr_item_properties_update_server (SeahorseGkrItemProperties* self) {
	GtkLabel* server = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	gchar* value = NULL;
	SeahorseGkrItem* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "server-label");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_label_get_type (), GtkLabel));
	server = _tmp2_;
	_tmp3_ = self->priv->_item;
	_tmp4_ = seahorse_gkr_item_get_attribute (_tmp3_, "server");
	value = _tmp4_;
	_tmp5_ = value;
	if (_tmp5_ == NULL) {
		gchar* _tmp6_ = NULL;
		_tmp6_ = g_strdup ("");
		_g_free0 (value);
		value = _tmp6_;
	}
	_tmp7_ = server;
	_tmp8_ = value;
	gtk_label_set_label (_tmp7_, _tmp8_);
	_g_free0 (value);
	_g_object_unref0 (server);
}


static void seahorse_gkr_item_properties_update_user (SeahorseGkrItemProperties* self) {
	GtkLabel* login = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	gchar* value = NULL;
	SeahorseGkrItem* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "login-label");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_label_get_type (), GtkLabel));
	login = _tmp2_;
	_tmp3_ = self->priv->_item;
	_tmp4_ = seahorse_gkr_item_get_attribute (_tmp3_, "user");
	value = _tmp4_;
	_tmp5_ = value;
	if (_tmp5_ == NULL) {
		gchar* _tmp6_ = NULL;
		_tmp6_ = g_strdup ("");
		_g_free0 (value);
		value = _tmp6_;
	}
	_tmp7_ = login;
	_tmp8_ = value;
	gtk_label_set_label (_tmp7_, _tmp8_);
	_g_free0 (value);
	_g_object_unref0 (login);
}


static void seahorse_gkr_item_properties_update_details (SeahorseGkrItemProperties* self) {
	GString* contents = NULL;
	GString* _tmp0_ = NULL;
	GHashTable* attrs = NULL;
	SeahorseGkrItem* _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp4_ = NULL;
	gchar* key = NULL;
	gchar* value = NULL;
	GtkLabel* details = NULL;
	GtkBuilder* _tmp22_ = NULL;
	GObject* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	GString* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_string_new ("");
	contents = _tmp0_;
	_tmp1_ = self->priv->_item;
	g_object_get ((SecretItem*) _tmp1_, "attributes", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	attrs = _tmp3_;
	_tmp4_ = attrs;
	g_hash_table_iter_init (&iter, _tmp4_);
	while (TRUE) {
		gconstpointer _tmp5_ = NULL;
		gconstpointer _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		GString* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		_tmp7_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp5_), (gpointer*) (&_tmp6_));
		_g_free0 (key);
		_tmp8_ = g_strdup (_tmp5_);
		key = _tmp8_;
		_g_free0 (value);
		_tmp9_ = g_strdup (_tmp6_);
		value = _tmp9_;
		if (!_tmp7_) {
			break;
		}
		_tmp11_ = key;
		_tmp12_ = g_str_has_prefix (_tmp11_, "gkr:");
		if (_tmp12_) {
			_tmp10_ = TRUE;
		} else {
			const gchar* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			_tmp13_ = key;
			_tmp14_ = g_str_has_prefix (_tmp13_, "xdg:");
			_tmp10_ = _tmp14_;
		}
		if (_tmp10_) {
			continue;
		}
		_tmp15_ = contents;
		_tmp16_ = key;
		_tmp17_ = g_markup_escape_text (_tmp16_, (gssize) (-1));
		_tmp18_ = _tmp17_;
		_tmp19_ = value;
		_tmp20_ = g_markup_escape_text (_tmp19_, (gssize) (-1));
		_tmp21_ = _tmp20_;
		g_string_append_printf (_tmp15_, "<b>%s</b>: %s\n", _tmp18_, _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp18_);
	}
	_tmp22_ = self->priv->_builder;
	_tmp23_ = gtk_builder_get_object (_tmp22_, "details-box");
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_label_get_type (), GtkLabel));
	details = _tmp24_;
	gtk_label_set_use_markup (details, TRUE);
	_tmp25_ = contents;
	_tmp26_ = _tmp25_->str;
	gtk_label_set_label (details, _tmp26_);
	_g_object_unref0 (details);
	_g_free0 (value);
	_g_free0 (key);
	_g_hash_table_unref0 (attrs);
	_g_string_free0 (contents);
}


static void __lambda21_ (SeahorseGkrItemProperties* self, GObject* obj, GAsyncResult* res) {
	GtkExpander* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		SeahorseGkrItem* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = self->priv->_item;
		_tmp1_ = res;
		seahorse_gkr_item_set_secret_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
		seahorse_gkr_item_properties_password_display (self);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = err;
		g_dbus_error_strip_remote_error (_tmp2_);
		_tmp3_ = _ ("Couldn't change password.");
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		seahorse_util_show_error ((GtkWidget*) self, _tmp3_, _tmp5_);
		_g_error_free0 (err);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = self->priv->_password_expander;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, TRUE);
	self->priv->_updating_password = FALSE;
}


static void ___lambda21__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda21_ ((SeahorseGkrItemProperties*) self, source_object, res);
	g_object_unref (self);
}


static void seahorse_gkr_item_properties_password_activate (SeahorseGkrItemProperties* self) {
	GtkExpander* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GtkExpander* _tmp5_ = NULL;
	SecretValue* value = NULL;
	GtkEntry* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	SecretValue* _tmp9_ = NULL;
	SeahorseGkrItem* _tmp10_ = NULL;
	SecretValue* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_password_expander;
	_tmp1_ = gtk_expander_get_expanded (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->_password_changed;
	if (!_tmp3_) {
		return;
	}
	_tmp4_ = self->priv->_updating_password;
	if (_tmp4_) {
		return;
	}
	self->priv->_updating_password = TRUE;
	_tmp5_ = self->priv->_password_expander;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
	_tmp6_ = self->priv->_password_entry;
	_tmp7_ = gtk_entry_get_text (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = secret_value_new (_tmp8_, (gssize) (-1), "text/plain");
	value = _tmp9_;
	_tmp10_ = self->priv->_item;
	_tmp11_ = value;
	seahorse_gkr_item_set_secret (_tmp10_, _tmp11_, NULL, ___lambda21__gasync_ready_callback, g_object_ref (self));
	_secret_value_unref0 (value);
}


static void seahorse_gkr_item_properties_password_display (SeahorseGkrItemProperties* self) {
	GtkExpander* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkEntry* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_password_expander;
	_tmp1_ = gtk_expander_get_expanded (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		SecretValue* secret = NULL;
		SeahorseGkrItem* _tmp3_ = NULL;
		SecretValue* _tmp4_ = NULL;
		SecretValue* _tmp5_ = NULL;
		_tmp3_ = self->priv->_item;
		_tmp4_ = seahorse_gkr_item_get_secret (_tmp3_);
		secret = _tmp4_;
		_tmp5_ = secret;
		if (_tmp5_ != NULL) {
			const gchar* password = NULL;
			SecretValue* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			_tmp6_ = secret;
			_tmp7_ = secret_value_get_text (_tmp6_);
			password = _tmp7_;
			_tmp8_ = password;
			if (_tmp8_ != NULL) {
				GtkEntry* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				_tmp9_ = self->priv->_password_entry;
				_tmp10_ = password;
				gtk_entry_set_text (_tmp9_, _tmp10_);
				self->priv->_password_changed = FALSE;
				_secret_value_unref0 (secret);
				return;
			}
		}
		_secret_value_unref0 (secret);
	}
	_tmp11_ = self->priv->_password_entry;
	gtk_entry_set_text (_tmp11_, "");
	self->priv->_password_changed = FALSE;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		SeahorseGkrItemProperties* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->description);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda22_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res) {
	SeahorseGkrItemProperties* self;
	GtkEntry* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data3_->self;
	g_return_if_fail (res != NULL);
	{
		SeahorseGkrItem* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = self->priv->_item;
		_tmp1_ = res;
		secret_item_set_label_finish ((SecretItem*) _tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* err = NULL;
		GtkEntry* _tmp2_ = NULL;
		SeahorseGkrItem* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data3_->description;
		_tmp3_ = self->priv->_item;
		_tmp4_ = seahorse_gkr_item_get_label (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		gtk_entry_set_text (_tmp2_, _tmp6_);
		_g_free0 (_tmp6_);
		_tmp7_ = err;
		g_dbus_error_strip_remote_error (_tmp7_);
		_tmp8_ = _ ("Couldn't set description.");
		_tmp9_ = err;
		_tmp10_ = _tmp9_->message;
		seahorse_util_show_error ((GtkWidget*) self, _tmp8_, _tmp10_);
		_g_error_free0 (err);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp11_ = _data3_->description;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, TRUE);
	self->priv->_updating_description = FALSE;
}


static void ___lambda22__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda22_ (self, source_object, res);
	block3_data_unref (self);
}


static void seahorse_gkr_item_properties_description_activate (SeahorseGkrItemProperties* self, GtkEntry* description) {
	Block3Data* _data3_;
	GtkEntry* _tmp0_ = NULL;
	GtkEntry* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkEntry* _tmp3_ = NULL;
	SeahorseGkrItem* _tmp4_ = NULL;
	GtkEntry* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (description != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = description;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data3_->description);
	_data3_->description = _tmp1_;
	_tmp2_ = self->priv->_updating_description;
	if (_tmp2_) {
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	self->priv->_updating_description = TRUE;
	_tmp3_ = _data3_->description;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
	_tmp4_ = self->priv->_item;
	_tmp5_ = _data3_->description;
	_tmp6_ = gtk_entry_get_text (_tmp5_);
	_tmp7_ = _tmp6_;
	secret_item_set_label ((SecretItem*) _tmp4_, _tmp7_, NULL, ___lambda22__gasync_ready_callback, block3_data_ref (_data3_));
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void seahorse_gkr_item_properties_expander_activate (SeahorseGkrItemProperties* self, GtkExpander* expander) {
	GtkExpander* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkCheckButton* check = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GtkCheckButton* _tmp5_ = NULL;
	GtkCheckButton* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expander != NULL);
	_tmp0_ = expander;
	_tmp1_ = gtk_expander_get_expanded (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->_builder;
	_tmp4_ = gtk_builder_get_object (_tmp3_, "show-password-check");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_check_button_get_type (), GtkCheckButton));
	check = _tmp5_;
	_tmp6_ = check;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp6_, FALSE);
	seahorse_gkr_item_properties_password_display (self);
	_g_object_unref0 (check);
}


SeahorseGkrItem* seahorse_gkr_item_properties_get_item (SeahorseGkrItemProperties* self) {
	SeahorseGkrItem* result;
	SeahorseGkrItem* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_item;
	result = _tmp0_;
	return result;
}


static void seahorse_gkr_item_properties_set_item (SeahorseGkrItemProperties* self, SeahorseGkrItem* value) {
	SeahorseGkrItem* _tmp0_ = NULL;
	SeahorseGkrItem* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_item);
	self->priv->_item = _tmp1_;
	g_object_notify ((GObject *) self, "item");
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		SeahorseGkrItemProperties* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->check);
		_g_object_unref0 (_data4_->description);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void _seahorse_gkr_item_properties___lambda23_ (SeahorseGkrItemProperties* self, gint response) {
	gtk_widget_destroy ((GtkWidget*) self);
}


static void __seahorse_gkr_item_properties___lambda23__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	_seahorse_gkr_item_properties___lambda23_ ((SeahorseGkrItemProperties*) self, response_id);
}


static void _seahorse_gkr_item_properties___lambda24_ (Block4Data* _data4_) {
	SeahorseGkrItemProperties* self;
	GtkEntry* _tmp0_ = NULL;
	self = _data4_->self;
	_tmp0_ = _data4_->description;
	seahorse_gkr_item_properties_description_activate (self, _tmp0_);
}


static void __seahorse_gkr_item_properties___lambda24__gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	_seahorse_gkr_item_properties___lambda24_ (self);
}


static gboolean _seahorse_gkr_item_properties___lambda25_ (Block4Data* _data4_) {
	SeahorseGkrItemProperties* self;
	gboolean result = FALSE;
	GtkEntry* _tmp0_ = NULL;
	self = _data4_->self;
	_tmp0_ = _data4_->description;
	seahorse_gkr_item_properties_description_activate (self, _tmp0_);
	result = FALSE;
	return result;
}


static gboolean __seahorse_gkr_item_properties___lambda25__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = _seahorse_gkr_item_properties___lambda25_ (self);
	return result;
}


static void _seahorse_gkr_item_properties_expander_activate_gtk_expander_activate (GtkExpander* _sender, gpointer self) {
	seahorse_gkr_item_properties_expander_activate ((SeahorseGkrItemProperties*) self, _sender);
}


static void _seahorse_gkr_item_properties___lambda26_ (Block4Data* _data4_) {
	SeahorseGkrItemProperties* self;
	GtkEntry* _tmp0_ = NULL;
	GtkCheckButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	self = _data4_->self;
	_tmp0_ = self->priv->_password_entry;
	_tmp1_ = _data4_->check;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_entry_set_visibility (_tmp0_, _tmp3_);
}


static void __seahorse_gkr_item_properties___lambda26__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_seahorse_gkr_item_properties___lambda26_ (self);
}


static void _seahorse_gkr_item_properties___lambda27_ (SeahorseGkrItemProperties* self, GParamSpec* pspec) {
	GParamSpec* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = pspec;
	_tmp1_ = _tmp0_->name;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("use")))) {
		switch (0) {
			default:
			{
				seahorse_gkr_item_properties_update_use (self);
				seahorse_gkr_item_properties_update_type (self);
				seahorse_gkr_item_properties_update_visibility (self);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("attributes")))) {
		switch (0) {
			default:
			{
				seahorse_gkr_item_properties_update_details (self);
				seahorse_gkr_item_properties_update_server (self);
				seahorse_gkr_item_properties_update_user (self);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("has-secret")))) {
		switch (0) {
			default:
			{
				seahorse_gkr_item_properties_password_display (self);
				break;
			}
		}
	}
}


static void __seahorse_gkr_item_properties___lambda27__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_seahorse_gkr_item_properties___lambda27_ ((SeahorseGkrItemProperties*) self, pspec);
}


static void _seahorse_gkr_item_properties_password_activate_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	seahorse_gkr_item_properties_password_activate ((SeahorseGkrItemProperties*) self);
}


static void _seahorse_gkr_item_properties___lambda28_ (SeahorseGkrItemProperties* self) {
	self->priv->_password_changed = TRUE;
}


static void __seahorse_gkr_item_properties___lambda28__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	_seahorse_gkr_item_properties___lambda28_ ((SeahorseGkrItemProperties*) self);
}


static gboolean _seahorse_gkr_item_properties___lambda29_ (SeahorseGkrItemProperties* self) {
	gboolean result = FALSE;
	seahorse_gkr_item_properties_password_activate (self);
	result = FALSE;
	return result;
}


static gboolean __seahorse_gkr_item_properties___lambda29__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = _seahorse_gkr_item_properties___lambda29_ ((SeahorseGkrItemProperties*) self);
	return result;
}


static GObject * seahorse_gkr_item_properties_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseGkrItemProperties * self;
	Block4Data* _data4_;
	GtkBuilder* _tmp0_ = NULL;
	GtkWidget* content = NULL;
	GtkBuilder* _tmp6_ = NULL;
	GObject* _tmp7_ = NULL;
	GtkWidget* _tmp8_ = NULL;
	GtkBox* _tmp9_ = NULL;
	GtkWidget* _tmp10_ = NULL;
	GtkWidget* _tmp11_ = NULL;
	SeahorseGkrItem* _tmp12_ = NULL;
	GtkBuilder* _tmp13_ = NULL;
	GObject* _tmp14_ = NULL;
	GtkBuilder* _tmp15_ = NULL;
	GObject* _tmp16_ = NULL;
	GtkEntry* _tmp17_ = NULL;
	SeahorseGkrItem* _tmp18_ = NULL;
	GtkEntry* _tmp19_ = NULL;
	GtkEntry* _tmp20_ = NULL;
	GtkEntry* _tmp21_ = NULL;
	GtkBuilder* _tmp22_ = NULL;
	GObject* _tmp23_ = NULL;
	GtkExpander* _tmp24_ = NULL;
	GtkExpander* _tmp25_ = NULL;
	GtkBuilder* _tmp26_ = NULL;
	GObject* _tmp27_ = NULL;
	GtkCheckButton* _tmp28_ = NULL;
	GtkCheckButton* _tmp29_ = NULL;
	SeahorseGkrItem* _tmp30_ = NULL;
	SeahorseGkrItem* _tmp31_ = NULL;
	GcrSecureEntryBuffer* buffer = NULL;
	GcrSecureEntryBuffer* _tmp32_ = NULL;
	GcrSecureEntryBuffer* _tmp33_ = NULL;
	GtkEntry* _tmp34_ = NULL;
	GtkBox* box = NULL;
	GtkBuilder* _tmp35_ = NULL;
	GObject* _tmp36_ = NULL;
	GtkBox* _tmp37_ = NULL;
	GtkBox* _tmp38_ = NULL;
	GtkEntry* _tmp39_ = NULL;
	GtkEntry* _tmp40_ = NULL;
	GtkEntry* _tmp41_ = NULL;
	GtkEntry* _tmp42_ = NULL;
	GtkEntry* _tmp43_ = NULL;
	GtkEntry* _tmp44_ = NULL;
	SeahorseGkrItem* _tmp45_ = NULL;
	GtkEntry* _tmp46_ = NULL;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (seahorse_gkr_item_properties_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM_PROPERTIES, SeahorseGkrItemProperties);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->_builder);
	self->priv->_builder = _tmp0_;
	{
		gchar* path = NULL;
		gchar* _tmp1_ = NULL;
		GtkBuilder* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp1_ = g_strdup ("/org/gnome/Seahorse/seahorse-gkr-item-properties.xml");
		path = _tmp1_;
		_tmp2_ = self->priv->_builder;
		_tmp3_ = path;
		gtk_builder_add_from_resource (_tmp2_, _tmp3_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (path);
			goto __catch10_g_error;
		}
		_g_free0 (path);
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		g_critical ("gkr-item-properties.vala:39: %s", _tmp5_);
		_g_error_free0 (err);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_CLOSE, (gint) GTK_RESPONSE_CLOSE);
	_tmp6_ = self->priv->_builder;
	_tmp7_ = gtk_builder_get_object (_tmp6_, "gkr-item-properties");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	content = _tmp8_;
	_tmp9_ = (GtkBox*) gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp10_ = content;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_container_get_type (), GtkContainer), _tmp10_);
	_tmp11_ = content;
	gtk_widget_show (_tmp11_);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) __seahorse_gkr_item_properties___lambda23__gtk_dialog_response, self, 0);
	_tmp12_ = self->priv->_item;
	_tmp13_ = self->priv->_builder;
	_tmp14_ = gtk_builder_get_object (_tmp13_, "key-image");
	g_object_bind_property_with_closures ((GObject*) _tmp12_, "icon", _tmp14_, "gicon", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp15_ = self->priv->_builder;
	_tmp16_ = gtk_builder_get_object (_tmp15_, "description-field");
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_entry_get_type (), GtkEntry));
	_data4_->description = _tmp17_;
	_tmp18_ = self->priv->_item;
	_tmp19_ = _data4_->description;
	g_object_bind_property_with_closures ((GObject*) _tmp18_, "label", (GObject*) _tmp19_, "text", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp20_ = _data4_->description;
	g_signal_connect_data (_tmp20_, "activate", (GCallback) __seahorse_gkr_item_properties___lambda24__gtk_entry_activate, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp21_ = _data4_->description;
	g_signal_connect_data ((GtkWidget*) _tmp21_, "focus-out-event", (GCallback) __seahorse_gkr_item_properties___lambda25__gtk_widget_focus_out_event, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, G_CONNECT_AFTER);
	_tmp22_ = self->priv->_builder;
	_tmp23_ = gtk_builder_get_object (_tmp22_, "password-expander");
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_expander_get_type (), GtkExpander));
	_g_object_unref0 (self->priv->_password_expander);
	self->priv->_password_expander = _tmp24_;
	_tmp25_ = self->priv->_password_expander;
	g_signal_connect_object (_tmp25_, "activate", (GCallback) _seahorse_gkr_item_properties_expander_activate_gtk_expander_activate, self, G_CONNECT_AFTER);
	_tmp26_ = self->priv->_builder;
	_tmp27_ = gtk_builder_get_object (_tmp26_, "show-password-check");
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_check_button_get_type (), GtkCheckButton));
	_data4_->check = _tmp28_;
	_tmp29_ = _data4_->check;
	g_signal_connect_data ((GtkToggleButton*) _tmp29_, "toggled", (GCallback) __seahorse_gkr_item_properties___lambda26__gtk_toggle_button_toggled, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp30_ = self->priv->_item;
	g_object_bind_property_with_closures ((GObject*) _tmp30_, "label", (GObject*) self, "title", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp31_ = self->priv->_item;
	g_signal_connect_object ((GObject*) _tmp31_, "notify", (GCallback) __seahorse_gkr_item_properties___lambda27__g_object_notify, self, 0);
	_tmp32_ = (GcrSecureEntryBuffer*) gcr_secure_entry_buffer_new ();
	buffer = _tmp32_;
	_tmp33_ = buffer;
	_tmp34_ = (GtkEntry*) gtk_entry_new_with_buffer ((GtkEntryBuffer*) _tmp33_);
	g_object_ref_sink (_tmp34_);
	_g_object_unref0 (self->priv->_password_entry);
	self->priv->_password_entry = _tmp34_;
	_tmp35_ = self->priv->_builder;
	_tmp36_ = gtk_builder_get_object (_tmp35_, "password-box-area");
	_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_box_get_type (), GtkBox));
	box = _tmp37_;
	_tmp38_ = box;
	_tmp39_ = self->priv->_password_entry;
	gtk_container_add ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = self->priv->_password_entry;
	gtk_entry_set_visibility (_tmp40_, FALSE);
	_tmp41_ = self->priv->_password_entry;
	gtk_widget_show ((GtkWidget*) _tmp41_);
	self->priv->_password_changed = FALSE;
	self->priv->_updating_password = FALSE;
	_tmp42_ = self->priv->_password_entry;
	g_signal_connect_object (_tmp42_, "activate", (GCallback) _seahorse_gkr_item_properties_password_activate_gtk_entry_activate, self, 0);
	_tmp43_ = self->priv->_password_entry;
	g_signal_connect_object ((GtkEditable*) _tmp43_, "changed", (GCallback) __seahorse_gkr_item_properties___lambda28__gtk_editable_changed, self, 0);
	_tmp44_ = self->priv->_password_entry;
	g_signal_connect_object ((GtkWidget*) _tmp44_, "focus-out-event", (GCallback) __seahorse_gkr_item_properties___lambda29__gtk_widget_focus_out_event, self, G_CONNECT_AFTER);
	_tmp45_ = self->priv->_item;
	_tmp46_ = self->priv->_password_entry;
	g_object_bind_property_with_closures ((GObject*) _tmp45_, "has-secret", (GObject*) _tmp46_, "sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_g_object_unref0 (box);
	_g_object_unref0 (buffer);
	_g_object_unref0 (content);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return obj;
}


static void seahorse_gkr_item_properties_class_init (SeahorseGkrItemPropertiesClass * klass) {
	seahorse_gkr_item_properties_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SeahorseGkrItemPropertiesPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_gkr_item_properties_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_gkr_item_properties_set_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_gkr_item_properties_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_item_properties_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_PROPERTIES_ITEM, g_param_spec_object ("item", "item", "item", SEAHORSE_GKR_TYPE_ITEM, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void seahorse_gkr_item_properties_instance_init (SeahorseGkrItemProperties * self) {
	self->priv = SEAHORSE_GKR_ITEM_PROPERTIES_GET_PRIVATE (self);
}


static void seahorse_gkr_item_properties_finalize (GObject* obj) {
	SeahorseGkrItemProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM_PROPERTIES, SeahorseGkrItemProperties);
	_g_object_unref0 (self->priv->_item);
	_g_object_unref0 (self->priv->_builder);
	_g_object_unref0 (self->priv->_password_entry);
	_g_object_unref0 (self->priv->_password_expander);
	G_OBJECT_CLASS (seahorse_gkr_item_properties_parent_class)->finalize (obj);
}


GType seahorse_gkr_item_properties_get_type (void) {
	static volatile gsize seahorse_gkr_item_properties_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_item_properties_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrItemPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_item_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrItemProperties), 0, (GInstanceInitFunc) seahorse_gkr_item_properties_instance_init, NULL };
		GType seahorse_gkr_item_properties_type_id;
		seahorse_gkr_item_properties_type_id = g_type_register_static (gtk_dialog_get_type (), "SeahorseGkrItemProperties", &g_define_type_info, 0);
		g_once_init_leave (&seahorse_gkr_item_properties_type_id__volatile, seahorse_gkr_item_properties_type_id);
	}
	return seahorse_gkr_item_properties_type_id__volatile;
}


static void _vala_seahorse_gkr_item_properties_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SeahorseGkrItemProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_ITEM_PROPERTIES, SeahorseGkrItemProperties);
	switch (property_id) {
		case SEAHORSE_GKR_ITEM_PROPERTIES_ITEM:
		g_value_set_object (value, seahorse_gkr_item_properties_get_item (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_seahorse_gkr_item_properties_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SeahorseGkrItemProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_ITEM_PROPERTIES, SeahorseGkrItemProperties);
	switch (property_id) {
		case SEAHORSE_GKR_ITEM_PROPERTIES_ITEM:
		seahorse_gkr_item_properties_set_item (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



