/* sudoku-saver.c generated by valac 0.32.0.61-f103e, the Vala compiler
 * generated from sudoku-saver.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <json-glib/json-glib.h>
#include <float.h>
#include <math.h>
#include <gee.h>


#define TYPE_SUDOKU_SAVER (sudoku_saver_get_type ())
#define SUDOKU_SAVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_SAVER, SudokuSaver))
#define SUDOKU_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_SAVER, SudokuSaverClass))
#define IS_SUDOKU_SAVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_SAVER))
#define IS_SUDOKU_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_SAVER))
#define SUDOKU_SAVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_SAVER, SudokuSaverClass))

typedef struct _SudokuSaver SudokuSaver;
typedef struct _SudokuSaverClass SudokuSaverClass;
typedef struct _SudokuSaverPrivate SudokuSaverPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SUDOKU_GAME (sudoku_game_get_type ())
#define SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GAME, SudokuGame))
#define SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GAME, SudokuGameClass))
#define IS_SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GAME))
#define IS_SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GAME))
#define SUDOKU_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GAME, SudokuGameClass))

typedef struct _SudokuGame SudokuGame;
typedef struct _SudokuGameClass SudokuGameClass;
typedef struct _SudokuGamePrivate SudokuGamePrivate;

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;

#define TYPE_GAME_MODE (game_mode_get_type ())

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))

struct _SudokuSaver {
	GObject parent_instance;
	SudokuSaverPrivate * priv;
};

struct _SudokuSaverClass {
	GObjectClass parent_class;
};

typedef enum  {
	GAME_MODE_PLAY,
	GAME_MODE_CREATE
} GameMode;

struct _SudokuGame {
	GObject parent_instance;
	SudokuGamePrivate * priv;
	SudokuBoard* board;
	GameMode mode;
	GTimer* timer;
};

struct _SudokuGameClass {
	GObjectClass parent_class;
};

typedef enum  {
	DIFFICULTY_CATEGORY_UNKNOWN,
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD,
	DIFFICULTY_CATEGORY_CUSTOM
} DifficultyCategory;

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GObject parent_instance;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GObjectClass parent_class;
};


static gpointer sudoku_saver_parent_class = NULL;
static gchar* sudoku_saver__savegame_file;
static gchar* sudoku_saver__savegame_file = NULL;
static gchar* sudoku_saver__finishgame_dir;
static gchar* sudoku_saver__finishgame_dir = NULL;

GType sudoku_saver_get_type (void) G_GNUC_CONST;
enum  {
	SUDOKU_SAVER_DUMMY_PROPERTY
};
SudokuSaver* sudoku_saver_new (void);
SudokuSaver* sudoku_saver_construct (GType object_type);
const gchar* sudoku_saver_get_savegame_file (void);
static void sudoku_saver_set_savegame_file (const gchar* value);
const gchar* sudoku_saver_get_finishgame_dir (void);
static void sudoku_saver_set_finishgame_dir (const gchar* value);
GType sudoku_game_get_type (void) G_GNUC_CONST;
SudokuGame* sudoku_saver_get_savedgame (SudokuSaver* self);
static SudokuGame* sudoku_saver_parse_json_to_game (SudokuSaver* self, const gchar* file_path);
void sudoku_saver_save_game (SudokuSaver* self, SudokuGame* game);
static void sudoku_saver_create_file_for_game (SudokuSaver* self, SudokuGame* game, const gchar* file_name);
void sudoku_saver_add_game_to_finished (SudokuSaver* self, SudokuGame* game, gboolean delete_savegame);
GType sudoku_board_get_type (void) G_GNUC_CONST;
GType game_mode_get_type (void) G_GNUC_CONST;
gchar* sudoku_board_to_string (SudokuBoard* self, gboolean get_original_state);
static gchar* sudoku_saver_serialize_game_to_json (SudokuSaver* self, SudokuGame* game);
gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2);
GType difficulty_category_get_type (void) G_GNUC_CONST;
DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self);
gchar* difficulty_category_to_untranslated_string (DifficultyCategory self);
gdouble sudoku_game_get_total_time_played (SudokuGame* self);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
gint sudoku_board_get_max_val (SudokuBoard* self);
gboolean sudoku_board_is_earmark_enabled (SudokuBoard* self, gint row, gint column, gint digit);
static void _vala_array_add1 (gint** array, int* length, int* size, gint value);
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
static void _vala_JsonNode_free (JsonNode* self);
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
void sudoku_board_enable_earmark (SudokuBoard* self, gint row, gint column, gint digit);
void sudoku_board_set_previous_played_time (SudokuBoard* self, gdouble value);
DifficultyCategory difficulty_category_from_string (const gchar* input);
void sudoku_board_set_difficulty_category (SudokuBoard* self, DifficultyCategory value);
SudokuGame* sudoku_game_new (SudokuBoard* board);
SudokuGame* sudoku_game_construct (GType object_type, SudokuBoard* board);
static void sudoku_saver_finalize (GObject* obj);
static void _vala_sudoku_saver_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_saver_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


SudokuSaver* sudoku_saver_construct (GType object_type) {
	SudokuSaver * self = NULL;
	GError * _inner_error_ = NULL;
	self = (SudokuSaver*) g_object_new (object_type, NULL);
	{
		gchar* config_dir = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* sudoku_data_dir = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		GFile* file = NULL;
		const gchar* _tmp14_ = NULL;
		GFile* _tmp15_ = NULL;
		GFile* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		GFile* _tmp21_ = NULL;
		GFile* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		_tmp0_ = g_get_user_data_dir ();
		_tmp1_ = g_strdup (_tmp0_);
		config_dir = _tmp1_;
		_tmp2_ = config_dir;
		_tmp3_ = g_build_path (G_DIR_SEPARATOR_S, _tmp2_, "gnome-sudoku", NULL);
		sudoku_data_dir = _tmp3_;
		_tmp4_ = sudoku_saver_get_savegame_file ();
		_tmp5_ = _tmp4_;
		_tmp6_ = sudoku_data_dir;
		_tmp7_ = g_build_path (G_DIR_SEPARATOR_S, _tmp6_, "savefile", NULL);
		_tmp8_ = _tmp7_;
		sudoku_saver_set_savegame_file (_tmp8_);
		_g_free0 (_tmp8_);
		_tmp9_ = sudoku_saver_get_finishgame_dir ();
		_tmp10_ = _tmp9_;
		_tmp11_ = sudoku_data_dir;
		_tmp12_ = g_build_path (G_DIR_SEPARATOR_S, _tmp11_, "finished", NULL);
		_tmp13_ = _tmp12_;
		sudoku_saver_set_finishgame_dir (_tmp13_);
		_g_free0 (_tmp13_);
		_tmp14_ = sudoku_data_dir;
		_tmp15_ = g_file_new_for_path (_tmp14_);
		file = _tmp15_;
		_tmp16_ = file;
		_tmp17_ = g_file_query_exists (_tmp16_, NULL);
		if (!_tmp17_) {
			GFile* _tmp18_ = NULL;
			_tmp18_ = file;
			g_file_make_directory (_tmp18_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				_g_free0 (sudoku_data_dir);
				_g_free0 (config_dir);
				goto __catch0_g_error;
			}
		}
		_tmp19_ = sudoku_saver_get_finishgame_dir ();
		_tmp20_ = _tmp19_;
		_tmp21_ = g_file_new_for_path (_tmp20_);
		_g_object_unref0 (file);
		file = _tmp21_;
		_tmp22_ = file;
		_tmp23_ = g_file_query_exists (_tmp22_, NULL);
		if (!_tmp23_) {
			GFile* _tmp24_ = NULL;
			_tmp24_ = file;
			g_file_make_directory (_tmp24_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				_g_free0 (sudoku_data_dir);
				_g_free0 (config_dir);
				goto __catch0_g_error;
			}
		}
		_g_object_unref0 (file);
		_g_free0 (sudoku_data_dir);
		_g_free0 (config_dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		g_warning ("sudoku-saver.vala:48: %s", _tmp26_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


SudokuSaver* sudoku_saver_new (void) {
	return sudoku_saver_construct (TYPE_SUDOKU_SAVER);
}


SudokuGame* sudoku_saver_get_savedgame (SudokuSaver* self) {
	SudokuGame* result = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	SudokuGame* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sudoku_saver_get_savegame_file ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	file = _tmp2_;
	_tmp3_ = file;
	_tmp4_ = g_file_query_exists (_tmp3_, NULL);
	if (!_tmp4_) {
		result = NULL;
		_g_object_unref0 (file);
		return result;
	}
	_tmp5_ = sudoku_saver_get_savegame_file ();
	_tmp6_ = _tmp5_;
	_tmp7_ = sudoku_saver_parse_json_to_game (self, _tmp6_);
	result = _tmp7_;
	_g_object_unref0 (file);
	return result;
}


void sudoku_saver_save_game (SudokuSaver* self, SudokuGame* game) {
	SudokuGame* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = game;
	_tmp1_ = sudoku_saver_get_savegame_file ();
	_tmp2_ = _tmp1_;
	sudoku_saver_create_file_for_game (self, _tmp0_, _tmp2_);
}


void sudoku_saver_add_game_to_finished (SudokuSaver* self, SudokuGame* game, gboolean delete_savegame) {
	gchar* file_name = NULL;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* file_path = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	SudokuGame* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = game;
	_tmp1_ = _tmp0_->board;
	_tmp2_ = sudoku_board_to_string (_tmp1_, TRUE);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ".save", NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	file_name = _tmp5_;
	_tmp6_ = sudoku_saver_get_finishgame_dir ();
	_tmp7_ = _tmp6_;
	_tmp8_ = file_name;
	_tmp9_ = g_build_path (G_DIR_SEPARATOR_S, _tmp7_, _tmp8_, NULL);
	file_path = _tmp9_;
	_tmp10_ = game;
	_tmp11_ = file_path;
	sudoku_saver_create_file_for_game (self, _tmp10_, _tmp11_);
	_tmp12_ = delete_savegame;
	if (_tmp12_) {
		GFile* file = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GFile* _tmp15_ = NULL;
		GFile* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		_tmp13_ = sudoku_saver_get_savegame_file ();
		_tmp14_ = _tmp13_;
		_tmp15_ = g_file_new_for_path (_tmp14_);
		file = _tmp15_;
		_tmp16_ = file;
		_tmp17_ = g_file_query_exists (_tmp16_, NULL);
		if (_tmp17_) {
			{
				GFile* _tmp18_ = NULL;
				_tmp18_ = file;
				g_file_delete (_tmp18_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GFile* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				GError* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp19_ = file;
				_tmp20_ = g_file_get_uri (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = e;
				_tmp23_ = _tmp22_->message;
				g_warning ("sudoku-saver.vala:84: Failed to delete %s: %s", _tmp21_, _tmp23_);
				_g_free0 (_tmp21_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				_g_free0 (file_path);
				_g_free0 (file_name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (file);
	}
	_g_free0 (file_path);
	_g_free0 (file_name);
}


static void sudoku_saver_create_file_for_game (SudokuSaver* self, SudokuGame* game, const gchar* file_name) {
	gchar* json_str = NULL;
	SudokuGame* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (file_name != NULL);
	_tmp0_ = game;
	_tmp1_ = sudoku_saver_serialize_game_to_json (self, _tmp0_);
	json_str = _tmp1_;
	{
		const gchar* _tmp2_ = NULL;
		_tmp2_ = file_name;
		g_file_set_contents (_tmp2_, json_str, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("sudoku-saver.vala:100: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (json_str);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (json_str);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add1 (gint** array, int* length, int* size, gint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gchar* sudoku_saver_serialize_game_to_json (SudokuSaver* self, SudokuGame* game) {
	gchar* result = NULL;
	SudokuBoard* board = NULL;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	SudokuBoard* _tmp2_ = NULL;
	gint* board_cells = NULL;
	SudokuBoard* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint* _tmp6_ = NULL;
	gint board_cells_length1 = 0;
	gint board_cells_length2 = 0;
	JsonBuilder* builder = NULL;
	JsonBuilder* _tmp7_ = NULL;
	JsonBuilder* _tmp8_ = NULL;
	JsonBuilder* _tmp9_ = NULL;
	JsonBuilder* _tmp10_ = NULL;
	SudokuBoard* _tmp11_ = NULL;
	DifficultyCategory _tmp12_ = 0;
	DifficultyCategory _tmp13_ = 0;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	JsonBuilder* _tmp16_ = NULL;
	SudokuGame* _tmp17_ = NULL;
	GameMode _tmp18_ = 0;
	JsonBuilder* _tmp23_ = NULL;
	JsonBuilder* _tmp24_ = NULL;
	JsonBuilder* _tmp85_ = NULL;
	JsonBuilder* _tmp86_ = NULL;
	JsonGenerator* generator = NULL;
	JsonGenerator* _tmp87_ = NULL;
	JsonNode* root = NULL;
	JsonBuilder* _tmp88_ = NULL;
	JsonNode* _tmp89_ = NULL;
	gchar* _tmp90_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (game != NULL, NULL);
	_tmp0_ = game;
	_tmp1_ = _tmp0_->board;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	board = _tmp2_;
	_tmp3_ = board;
	_tmp6_ = sudoku_board_get_cells (_tmp3_, &_tmp4_, &_tmp5_);
	board_cells = _tmp6_;
	board_cells_length1 = _tmp4_;
	board_cells_length2 = _tmp5_;
	_tmp7_ = json_builder_new ();
	builder = _tmp7_;
	_tmp8_ = builder;
	json_builder_begin_object (_tmp8_);
	_tmp9_ = builder;
	json_builder_set_member_name (_tmp9_, "difficulty_category");
	_tmp10_ = builder;
	_tmp11_ = board;
	_tmp12_ = sudoku_board_get_difficulty_category (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = difficulty_category_to_untranslated_string (_tmp13_);
	_tmp15_ = _tmp14_;
	json_builder_add_string_value (_tmp10_, _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = builder;
	json_builder_set_member_name (_tmp16_, "time_elapsed");
	_tmp17_ = game;
	_tmp18_ = _tmp17_->mode;
	if (_tmp18_ == GAME_MODE_CREATE) {
		JsonBuilder* _tmp19_ = NULL;
		_tmp19_ = builder;
		json_builder_add_double_value (_tmp19_, (gdouble) 0);
	} else {
		JsonBuilder* _tmp20_ = NULL;
		SudokuGame* _tmp21_ = NULL;
		gdouble _tmp22_ = 0.0;
		_tmp20_ = builder;
		_tmp21_ = game;
		_tmp22_ = sudoku_game_get_total_time_played (_tmp21_);
		json_builder_add_double_value (_tmp20_, _tmp22_);
	}
	_tmp23_ = builder;
	json_builder_set_member_name (_tmp23_, "cells");
	_tmp24_ = builder;
	json_builder_begin_array (_tmp24_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp25_ = FALSE;
			_tmp25_ = TRUE;
			while (TRUE) {
				gint _tmp27_ = 0;
				SudokuBoard* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				if (!_tmp25_) {
					gint _tmp26_ = 0;
					_tmp26_ = i;
					i = _tmp26_ + 1;
				}
				_tmp25_ = FALSE;
				_tmp27_ = i;
				_tmp28_ = board;
				_tmp29_ = sudoku_board_get_rows (_tmp28_);
				_tmp30_ = _tmp29_;
				if (!(_tmp27_ < _tmp30_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp31_ = FALSE;
						_tmp31_ = TRUE;
						while (TRUE) {
							gint _tmp33_ = 0;
							SudokuBoard* _tmp34_ = NULL;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							gint* earmarks = NULL;
							gint* _tmp37_ = NULL;
							gint earmarks_length1 = 0;
							gint _earmarks_size_ = 0;
							gboolean _tmp51_ = FALSE;
							gint* _tmp52_ = NULL;
							gint _tmp52__length1 = 0;
							gint _tmp52__length2 = 0;
							gint _tmp53_ = 0;
							gint _tmp54_ = 0;
							gint _tmp55_ = 0;
							JsonBuilder* _tmp57_ = NULL;
							JsonBuilder* _tmp58_ = NULL;
							JsonBuilder* _tmp59_ = NULL;
							JsonBuilder* _tmp60_ = NULL;
							gint _tmp61_ = 0;
							JsonBuilder* _tmp62_ = NULL;
							gint _tmp63_ = 0;
							JsonBuilder* _tmp64_ = NULL;
							JsonBuilder* _tmp65_ = NULL;
							JsonBuilder* _tmp66_ = NULL;
							gint* _tmp67_ = NULL;
							gint _tmp67__length1 = 0;
							gint _tmp67__length2 = 0;
							gint _tmp68_ = 0;
							gint _tmp69_ = 0;
							gint _tmp70_ = 0;
							JsonBuilder* _tmp71_ = NULL;
							JsonBuilder* _tmp72_ = NULL;
							SudokuBoard* _tmp73_ = NULL;
							gboolean* _tmp74_ = NULL;
							gint _tmp74__length1 = 0;
							gint _tmp74__length2 = 0;
							gint _tmp75_ = 0;
							gint _tmp76_ = 0;
							gboolean _tmp77_ = FALSE;
							JsonBuilder* _tmp78_ = NULL;
							JsonBuilder* _tmp79_ = NULL;
							gint* _tmp80_ = NULL;
							gint _tmp80__length1 = 0;
							JsonBuilder* _tmp83_ = NULL;
							JsonBuilder* _tmp84_ = NULL;
							if (!_tmp31_) {
								gint _tmp32_ = 0;
								_tmp32_ = j;
								j = _tmp32_ + 1;
							}
							_tmp31_ = FALSE;
							_tmp33_ = j;
							_tmp34_ = board;
							_tmp35_ = sudoku_board_get_cols (_tmp34_);
							_tmp36_ = _tmp35_;
							if (!(_tmp33_ < _tmp36_)) {
								break;
							}
							_tmp37_ = g_new0 (gint, 0);
							earmarks = _tmp37_;
							earmarks_length1 = 0;
							_earmarks_size_ = earmarks_length1;
							{
								gint k = 0;
								k = 1;
								{
									gboolean _tmp38_ = FALSE;
									_tmp38_ = TRUE;
									while (TRUE) {
										gint _tmp40_ = 0;
										SudokuBoard* _tmp41_ = NULL;
										gint _tmp42_ = 0;
										gint _tmp43_ = 0;
										SudokuBoard* _tmp44_ = NULL;
										gint _tmp45_ = 0;
										gint _tmp46_ = 0;
										gint _tmp47_ = 0;
										gboolean _tmp48_ = FALSE;
										if (!_tmp38_) {
											gint _tmp39_ = 0;
											_tmp39_ = k;
											k = _tmp39_ + 1;
										}
										_tmp38_ = FALSE;
										_tmp40_ = k;
										_tmp41_ = board;
										_tmp42_ = sudoku_board_get_max_val (_tmp41_);
										_tmp43_ = _tmp42_;
										if (!(_tmp40_ <= _tmp43_)) {
											break;
										}
										_tmp44_ = board;
										_tmp45_ = i;
										_tmp46_ = j;
										_tmp47_ = k;
										_tmp48_ = sudoku_board_is_earmark_enabled (_tmp44_, _tmp45_, _tmp46_, _tmp47_);
										if (_tmp48_) {
											gint* _tmp49_ = NULL;
											gint _tmp49__length1 = 0;
											gint _tmp50_ = 0;
											_tmp49_ = earmarks;
											_tmp49__length1 = earmarks_length1;
											_tmp50_ = k;
											_vala_array_add1 (&earmarks, &earmarks_length1, &_earmarks_size_, _tmp50_);
										}
									}
								}
							}
							_tmp52_ = board_cells;
							_tmp52__length1 = board_cells_length1;
							_tmp52__length2 = board_cells_length2;
							_tmp53_ = i;
							_tmp54_ = j;
							_tmp55_ = _tmp52_[(_tmp53_ * _tmp52__length2) + _tmp54_];
							if (_tmp55_ == 0) {
								gint* _tmp56_ = NULL;
								gint _tmp56__length1 = 0;
								_tmp56_ = earmarks;
								_tmp56__length1 = earmarks_length1;
								_tmp51_ = _tmp56__length1 == 0;
							} else {
								_tmp51_ = FALSE;
							}
							if (_tmp51_) {
								earmarks = (g_free (earmarks), NULL);
								continue;
							}
							_tmp57_ = builder;
							json_builder_begin_object (_tmp57_);
							_tmp58_ = builder;
							json_builder_set_member_name (_tmp58_, "position");
							_tmp59_ = builder;
							json_builder_begin_array (_tmp59_);
							_tmp60_ = builder;
							_tmp61_ = i;
							json_builder_add_int_value (_tmp60_, (gint64) _tmp61_);
							_tmp62_ = builder;
							_tmp63_ = j;
							json_builder_add_int_value (_tmp62_, (gint64) _tmp63_);
							_tmp64_ = builder;
							json_builder_end_array (_tmp64_);
							_tmp65_ = builder;
							json_builder_set_member_name (_tmp65_, "value");
							_tmp66_ = builder;
							_tmp67_ = board_cells;
							_tmp67__length1 = board_cells_length1;
							_tmp67__length2 = board_cells_length2;
							_tmp68_ = i;
							_tmp69_ = j;
							_tmp70_ = _tmp67_[(_tmp68_ * _tmp67__length2) + _tmp69_];
							json_builder_add_int_value (_tmp66_, (gint64) _tmp70_);
							_tmp71_ = builder;
							json_builder_set_member_name (_tmp71_, "fixed");
							_tmp72_ = builder;
							_tmp73_ = board;
							_tmp74_ = _tmp73_->is_fixed;
							_tmp74__length1 = _tmp73_->is_fixed_length1;
							_tmp74__length2 = _tmp73_->is_fixed_length2;
							_tmp75_ = i;
							_tmp76_ = j;
							_tmp77_ = _tmp74_[(_tmp75_ * _tmp74__length2) + _tmp76_];
							json_builder_add_boolean_value (_tmp72_, _tmp77_);
							_tmp78_ = builder;
							json_builder_set_member_name (_tmp78_, "earmarks");
							_tmp79_ = builder;
							json_builder_begin_array (_tmp79_);
							_tmp80_ = earmarks;
							_tmp80__length1 = earmarks_length1;
							{
								gint* k_collection = NULL;
								gint k_collection_length1 = 0;
								gint _k_collection_size_ = 0;
								gint k_it = 0;
								k_collection = _tmp80_;
								k_collection_length1 = _tmp80__length1;
								for (k_it = 0; k_it < _tmp80__length1; k_it = k_it + 1) {
									gint k = 0;
									k = k_collection[k_it];
									{
										JsonBuilder* _tmp81_ = NULL;
										gint _tmp82_ = 0;
										_tmp81_ = builder;
										_tmp82_ = k;
										json_builder_add_int_value (_tmp81_, (gint64) _tmp82_);
									}
								}
							}
							_tmp83_ = builder;
							json_builder_end_array (_tmp83_);
							_tmp84_ = builder;
							json_builder_end_object (_tmp84_);
							earmarks = (g_free (earmarks), NULL);
						}
					}
				}
			}
		}
	}
	_tmp85_ = builder;
	json_builder_end_array (_tmp85_);
	_tmp86_ = builder;
	json_builder_end_object (_tmp86_);
	_tmp87_ = json_generator_new ();
	generator = _tmp87_;
	json_generator_set_pretty (generator, TRUE);
	_tmp88_ = builder;
	_tmp89_ = json_builder_get_root (_tmp88_);
	root = _tmp89_;
	json_generator_set_root (generator, root);
	_tmp90_ = json_generator_to_data (generator, NULL);
	result = _tmp90_;
	__vala_JsonNode_free0 (root);
	_g_object_unref0 (generator);
	_g_object_unref0 (builder);
	board_cells = (g_free (board_cells), NULL);
	_g_object_unref0 (board);
	return result;
}


static JsonNode* _vala_JsonNode_copy (JsonNode* self) {
	return g_boxed_copy (json_node_get_type (), self);
}


static gpointer __vala_JsonNode_copy0 (gpointer self) {
	return self ? _vala_JsonNode_copy (self) : NULL;
}


static SudokuGame* sudoku_saver_parse_json_to_game (SudokuSaver* self, const gchar* file_path) {
	SudokuGame* result = NULL;
	JsonParser* parser = NULL;
	JsonParser* _tmp0_ = NULL;
	SudokuBoard* board = NULL;
	SudokuBoard* _tmp3_ = NULL;
	JsonNode* node = NULL;
	JsonParser* _tmp4_ = NULL;
	JsonNode* _tmp5_ = NULL;
	JsonNode* _tmp6_ = NULL;
	JsonReader* reader = NULL;
	JsonNode* _tmp7_ = NULL;
	JsonReader* _tmp8_ = NULL;
	JsonReader* _tmp9_ = NULL;
	JsonReader* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	JsonReader* _tmp75_ = NULL;
	JsonReader* _tmp76_ = NULL;
	JsonReader* _tmp77_ = NULL;
	gboolean _tmp78_ = FALSE;
	SudokuBoard* _tmp79_ = NULL;
	JsonReader* _tmp80_ = NULL;
	gdouble _tmp81_ = 0.0;
	JsonReader* _tmp82_ = NULL;
	JsonReader* _tmp83_ = NULL;
	JsonReader* _tmp84_ = NULL;
	gboolean _tmp85_ = FALSE;
	SudokuBoard* _tmp86_ = NULL;
	JsonReader* _tmp87_ = NULL;
	const gchar* _tmp88_ = NULL;
	DifficultyCategory _tmp89_ = 0;
	JsonReader* _tmp90_ = NULL;
	SudokuBoard* _tmp91_ = NULL;
	SudokuGame* _tmp92_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file_path != NULL, NULL);
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	{
		JsonParser* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = parser;
		_tmp2_ = file_path;
		json_parser_load_from_file (_tmp1_, _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		return result;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp3_ = sudoku_board_new (3, 3);
	board = _tmp3_;
	_tmp4_ = parser;
	_tmp5_ = json_parser_get_root (_tmp4_);
	_tmp6_ = __vala_JsonNode_copy0 (_tmp5_);
	node = _tmp6_;
	_tmp7_ = node;
	_tmp8_ = json_reader_new (_tmp7_);
	reader = _tmp8_;
	_tmp9_ = reader;
	json_reader_read_member (_tmp9_, "cells");
	_tmp10_ = reader;
	_tmp11_ = json_reader_is_array (_tmp10_);
	g_return_val_if_fail (_tmp11_, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gint _tmp14_ = 0;
				JsonReader* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				JsonReader* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				JsonReader* _tmp19_ = NULL;
				JsonReader* _tmp20_ = NULL;
				gboolean _tmp21_ = FALSE;
				JsonReader* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				JsonReader* _tmp24_ = NULL;
				JsonReader* _tmp25_ = NULL;
				gboolean _tmp26_ = FALSE;
				gint row = 0;
				JsonReader* _tmp27_ = NULL;
				gint64 _tmp28_ = 0LL;
				JsonReader* _tmp29_ = NULL;
				JsonReader* _tmp30_ = NULL;
				JsonReader* _tmp31_ = NULL;
				gboolean _tmp32_ = FALSE;
				gint col = 0;
				JsonReader* _tmp33_ = NULL;
				gint64 _tmp34_ = 0LL;
				JsonReader* _tmp35_ = NULL;
				JsonReader* _tmp36_ = NULL;
				JsonReader* _tmp37_ = NULL;
				JsonReader* _tmp38_ = NULL;
				gboolean _tmp39_ = FALSE;
				gint val = 0;
				JsonReader* _tmp40_ = NULL;
				gint64 _tmp41_ = 0LL;
				JsonReader* _tmp42_ = NULL;
				JsonReader* _tmp43_ = NULL;
				JsonReader* _tmp44_ = NULL;
				gboolean _tmp45_ = FALSE;
				gboolean is_fixed = FALSE;
				JsonReader* _tmp46_ = NULL;
				gboolean _tmp47_ = FALSE;
				JsonReader* _tmp48_ = NULL;
				gint _tmp49_ = 0;
				JsonReader* _tmp55_ = NULL;
				JsonReader* _tmp56_ = NULL;
				gboolean _tmp57_ = FALSE;
				JsonReader* _tmp73_ = NULL;
				JsonReader* _tmp74_ = NULL;
				if (!_tmp12_) {
					gint _tmp13_ = 0;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = i;
				_tmp15_ = reader;
				_tmp16_ = json_reader_count_elements (_tmp15_);
				if (!(_tmp14_ < _tmp16_)) {
					break;
				}
				_tmp17_ = reader;
				_tmp18_ = i;
				json_reader_read_element (_tmp17_, (guint) _tmp18_);
				_tmp19_ = reader;
				json_reader_read_member (_tmp19_, "position");
				_tmp20_ = reader;
				_tmp21_ = json_reader_is_array (_tmp20_);
				g_return_val_if_fail (_tmp21_, NULL);
				_tmp22_ = reader;
				_tmp23_ = json_reader_count_elements (_tmp22_);
				g_return_val_if_fail (_tmp23_ == 2, NULL);
				_tmp24_ = reader;
				json_reader_read_element (_tmp24_, (guint) 0);
				_tmp25_ = reader;
				_tmp26_ = json_reader_is_value (_tmp25_);
				g_return_val_if_fail (_tmp26_, NULL);
				_tmp27_ = reader;
				_tmp28_ = json_reader_get_int_value (_tmp27_);
				row = (gint) _tmp28_;
				_tmp29_ = reader;
				json_reader_end_element (_tmp29_);
				_tmp30_ = reader;
				json_reader_read_element (_tmp30_, (guint) 1);
				_tmp31_ = reader;
				_tmp32_ = json_reader_is_value (_tmp31_);
				g_return_val_if_fail (_tmp32_, NULL);
				_tmp33_ = reader;
				_tmp34_ = json_reader_get_int_value (_tmp33_);
				col = (gint) _tmp34_;
				_tmp35_ = reader;
				json_reader_end_element (_tmp35_);
				_tmp36_ = reader;
				json_reader_end_member (_tmp36_);
				_tmp37_ = reader;
				json_reader_read_member (_tmp37_, "value");
				_tmp38_ = reader;
				_tmp39_ = json_reader_is_value (_tmp38_);
				g_return_val_if_fail (_tmp39_, NULL);
				_tmp40_ = reader;
				_tmp41_ = json_reader_get_int_value (_tmp40_);
				val = (gint) _tmp41_;
				_tmp42_ = reader;
				json_reader_end_member (_tmp42_);
				_tmp43_ = reader;
				json_reader_read_member (_tmp43_, "fixed");
				_tmp44_ = reader;
				_tmp45_ = json_reader_is_value (_tmp44_);
				g_return_val_if_fail (_tmp45_, NULL);
				_tmp46_ = reader;
				_tmp47_ = json_reader_get_boolean_value (_tmp46_);
				is_fixed = _tmp47_;
				_tmp48_ = reader;
				json_reader_end_member (_tmp48_);
				_tmp49_ = val;
				if (_tmp49_ != 0) {
					SudokuBoard* _tmp50_ = NULL;
					gint _tmp51_ = 0;
					gint _tmp52_ = 0;
					gint _tmp53_ = 0;
					gboolean _tmp54_ = FALSE;
					_tmp50_ = board;
					_tmp51_ = row;
					_tmp52_ = col;
					_tmp53_ = val;
					_tmp54_ = is_fixed;
					sudoku_board_insert (_tmp50_, _tmp51_, _tmp52_, _tmp53_, _tmp54_);
				}
				_tmp55_ = reader;
				json_reader_read_member (_tmp55_, "earmarks");
				_tmp56_ = reader;
				_tmp57_ = json_reader_is_array (_tmp56_);
				g_return_val_if_fail (_tmp57_, NULL);
				{
					gint k = 0;
					k = 0;
					{
						gboolean _tmp58_ = FALSE;
						_tmp58_ = TRUE;
						while (TRUE) {
							gint _tmp60_ = 0;
							JsonReader* _tmp61_ = NULL;
							gint _tmp62_ = 0;
							JsonReader* _tmp63_ = NULL;
							gint _tmp64_ = 0;
							JsonReader* _tmp65_ = NULL;
							gboolean _tmp66_ = FALSE;
							SudokuBoard* _tmp67_ = NULL;
							gint _tmp68_ = 0;
							gint _tmp69_ = 0;
							JsonReader* _tmp70_ = NULL;
							gint64 _tmp71_ = 0LL;
							JsonReader* _tmp72_ = NULL;
							if (!_tmp58_) {
								gint _tmp59_ = 0;
								_tmp59_ = k;
								k = _tmp59_ + 1;
							}
							_tmp58_ = FALSE;
							_tmp60_ = k;
							_tmp61_ = reader;
							_tmp62_ = json_reader_count_elements (_tmp61_);
							if (!(_tmp60_ < _tmp62_)) {
								break;
							}
							_tmp63_ = reader;
							_tmp64_ = k;
							json_reader_read_element (_tmp63_, (guint) _tmp64_);
							_tmp65_ = reader;
							_tmp66_ = json_reader_is_value (_tmp65_);
							g_return_val_if_fail (_tmp66_, NULL);
							_tmp67_ = board;
							_tmp68_ = row;
							_tmp69_ = col;
							_tmp70_ = reader;
							_tmp71_ = json_reader_get_int_value (_tmp70_);
							sudoku_board_enable_earmark (_tmp67_, _tmp68_, _tmp69_, (gint) _tmp71_);
							_tmp72_ = reader;
							json_reader_end_element (_tmp72_);
						}
					}
				}
				_tmp73_ = reader;
				json_reader_end_member (_tmp73_);
				_tmp74_ = reader;
				json_reader_end_element (_tmp74_);
			}
		}
	}
	_tmp75_ = reader;
	json_reader_end_member (_tmp75_);
	_tmp76_ = reader;
	json_reader_read_member (_tmp76_, "time_elapsed");
	_tmp77_ = reader;
	_tmp78_ = json_reader_is_value (_tmp77_);
	g_return_val_if_fail (_tmp78_, NULL);
	_tmp79_ = board;
	_tmp80_ = reader;
	_tmp81_ = json_reader_get_double_value (_tmp80_);
	sudoku_board_set_previous_played_time (_tmp79_, _tmp81_);
	_tmp82_ = reader;
	json_reader_end_member (_tmp82_);
	_tmp83_ = reader;
	json_reader_read_member (_tmp83_, "difficulty_category");
	_tmp84_ = reader;
	_tmp85_ = json_reader_is_value (_tmp84_);
	g_return_val_if_fail (_tmp85_, NULL);
	_tmp86_ = board;
	_tmp87_ = reader;
	_tmp88_ = json_reader_get_string_value (_tmp87_);
	_tmp89_ = difficulty_category_from_string (_tmp88_);
	sudoku_board_set_difficulty_category (_tmp86_, _tmp89_);
	_tmp90_ = reader;
	json_reader_end_member (_tmp90_);
	_tmp91_ = board;
	_tmp92_ = sudoku_game_new (_tmp91_);
	result = _tmp92_;
	_g_object_unref0 (reader);
	__vala_JsonNode_free0 (node);
	_g_object_unref0 (board);
	_g_object_unref0 (parser);
	return result;
}


const gchar* sudoku_saver_get_savegame_file (void) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = sudoku_saver__savegame_file;
	result = _tmp0_;
	return result;
}


static void sudoku_saver_set_savegame_file (const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (sudoku_saver__savegame_file);
	sudoku_saver__savegame_file = _tmp1_;
}


const gchar* sudoku_saver_get_finishgame_dir (void) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = sudoku_saver__finishgame_dir;
	result = _tmp0_;
	return result;
}


static void sudoku_saver_set_finishgame_dir (const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (sudoku_saver__finishgame_dir);
	sudoku_saver__finishgame_dir = _tmp1_;
}


static void sudoku_saver_class_init (SudokuSaverClass * klass) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	sudoku_saver_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_saver_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_saver_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_saver_finalize;
	_tmp0_ = g_strdup ("");
	sudoku_saver__savegame_file = _tmp0_;
	_tmp1_ = g_strdup ("");
	sudoku_saver__finishgame_dir = _tmp1_;
}


static void sudoku_saver_instance_init (SudokuSaver * self) {
}


static void sudoku_saver_finalize (GObject* obj) {
	SudokuSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_SAVER, SudokuSaver);
	G_OBJECT_CLASS (sudoku_saver_parent_class)->finalize (obj);
}


GType sudoku_saver_get_type (void) {
	static volatile gsize sudoku_saver_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_saver_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuSaverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_saver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuSaver), 0, (GInstanceInitFunc) sudoku_saver_instance_init, NULL };
		GType sudoku_saver_type_id;
		sudoku_saver_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuSaver", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_saver_type_id__volatile, sudoku_saver_type_id);
	}
	return sudoku_saver_type_id__volatile;
}


static void _vala_sudoku_saver_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_SAVER, SudokuSaver);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sudoku_saver_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_SAVER, SudokuSaver);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



