// Generated by gmmproc 2.49.2 -- DO NOT MODIFY!
#ifndef _IDEMM_CONTEXT_H
#define _IDEMM_CONTEXT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* context.hg
 *
 * Copyright (C) 2016 Marcin Kolny <marcin.kolny@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <idemm/backforwardlist.h>
#include <glibmm/object.h>
#include <giomm/file.h>
#include <gtkmm/recentmanager.h>

#include <ide.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Ide
{ class Context_Class; } // namespace Ide
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Ide {


class Context : public Glib::Object
{
protected:
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Context;
  using CppClassType = Context_Class;
  using BaseObjectType = IdeContext;
  using BaseClassType = IdeContextClass;

  // noncopyable
  Context(const Context&) = delete;
  Context& operator=(const Context&) = delete;

private:  friend class Context_Class;
  static CppClassType context_class_;

protected:
  explicit Context(const Glib::ConstructParams& construct_params);
  explicit Context(IdeContext* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Context(Context&& src) noexcept;
  Context& operator=(Context&& src) noexcept;

  ~Context() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  IdeContext*       gobj()       { return reinterpret_cast<IdeContext*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const IdeContext* gobj() const { return reinterpret_cast<IdeContext*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  IdeContext* gobj_copy();

private:

  
public:
  
  /** Retrieves the global back forward list for the Ide::Context.
   * 
   * Consumers of this should branch the Ide::BackForwardList and merge them
   * when there document stack is closed.
   * 
   * See ide_back_forward_list_branch() and ide_back_forward_list_merge() for
   * more information.
   * 
   * @return An Ide::BackForwardList.
   */
  Glib::RefPtr<Ide::BackForwardList> get_back_forward_list() const;
  
  /** Retrieves a File containing the project file that was used to load
   * the context.
   * 
   * @return A File.
   */
  Glib::RefPtr<Gio::File> get_project_file() const;

 
  /** Gets the IdeContext:recent-manager property. The recent manager is a GtkRecentManager instance
   * that should be used for the workbench.
   * 
   * @return A Gtk::RecentManager.
   */
  Glib::RefPtr<Gtk::RecentManager> get_recent_manager() const;

  
  /** Retrieves the "root-build-dir" for the context. This is the root directory
   * that will contain builds made for various devices.
   * 
   * @return A string containing the "root-build-dir" property.
   */
  Glib::ustring get_root_build_dir() const;
  
  /** Sets the "root-build-dir" property. This is the root directory that will
   * be used when building projects for projects that support building out of
   * tree.
   */
  void set_root_build_dir(const Glib::ustring& root_build_dir);
  
  /** Puts a hold on the Ide::Context, preventing the context from being unloaded
   * until a call to ide_context_release().
   * 
   * If ide_context_unload_async() is called while a hold is in progress, the
   * unload will be delayed until ide_context_release() has been called the
   * same number of times as ide_context_hold().
   */
  void hold();

 
  /** Adds a hold on @a self for the lifetime of @a instance.
   * 
   * @param instance A Object instance.
   */
  void hold_for_object(const Glib::RefPtr<Glib::Object>& instance);
  
  /** Releases a hold on the context previously created with ide_context_hold().
   * 
   * If a pending unload of the context has been requested, it will be dispatched
   * once the hold count reaches zero.
   */
  void release();;

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%loaded()</tt>
   *
   * This signal is emitted when loading of the context has completed.
   * Plugins and services might want to get notified of this to perform
   * work that requires subsystems that may not be loaded during context
   * startup.
   */

  Glib::SignalProxy< void > signal_loaded();


  /** Back/forward navigation history for the context.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Ide::BackForwardList> > property_back_forward_list() const;


  /** The project file for the context.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::File> > property_project_file() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

}


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Ide::Context
   */
  Glib::RefPtr<Ide::Context> wrap(IdeContext* object, bool take_copy = false);
}


#endif /* _IDEMM_CONTEXT_H */

