/* rygel-lms-category-container.c generated by valac 0.30.0.35-2c9e8, the Vala compiler
 * generated from rygel-lms-category-container.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>,
 *           (C) 2013 Intel Corporation.
 *
 * Author: Jussi Kukkonen <jussi.kukkonen@intel.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>
#include <rygel-db.h>
#include <gio/gio.h>


#define RYGEL_LMS_TYPE_CATEGORY_CONTAINER (rygel_lms_category_container_get_type ())
#define RYGEL_LMS_CATEGORY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainer))
#define RYGEL_LMS_CATEGORY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainerClass))
#define RYGEL_LMS_IS_CATEGORY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER))
#define RYGEL_LMS_IS_CATEGORY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_CATEGORY_CONTAINER))
#define RYGEL_LMS_CATEGORY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainerClass))

typedef struct _RygelLMSCategoryContainer RygelLMSCategoryContainer;
typedef struct _RygelLMSCategoryContainerClass RygelLMSCategoryContainerClass;
typedef struct _RygelLMSCategoryContainerPrivate RygelLMSCategoryContainerPrivate;

#define RYGEL_LMS_TYPE_DATABASE (rygel_lms_database_get_type ())
#define RYGEL_LMS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabase))
#define RYGEL_LMS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabaseClass))
#define RYGEL_LMS_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_DATABASE))
#define RYGEL_LMS_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_DATABASE))
#define RYGEL_LMS_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabaseClass))

typedef struct _RygelLMSDatabase RygelLMSDatabase;
typedef struct _RygelLMSDatabaseClass RygelLMSDatabaseClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
typedef struct _RygelLmsCategoryContainerSearchData RygelLmsCategoryContainerSearchData;
typedef struct _RygelLmsCategoryContainerGetChildrenData RygelLmsCategoryContainerGetChildrenData;
typedef struct _RygelLmsCategoryContainerFindObjectData RygelLmsCategoryContainerFindObjectData;
typedef struct _RygelLmsCategoryContainerAddChildData RygelLmsCategoryContainerAddChildData;
typedef struct _RygelLmsCategoryContainerRemoveChildData RygelLmsCategoryContainerRemoveChildData;

typedef enum  {
	RYGEL_LMS_CATEGORY_CONTAINER_ERROR_SQLITE_ERROR,
	RYGEL_LMS_CATEGORY_CONTAINER_ERROR_GENERAL_ERROR,
	RYGEL_LMS_CATEGORY_CONTAINER_ERROR_INVALID_TYPE,
	RYGEL_LMS_CATEGORY_CONTAINER_ERROR_UNSUPPORTED_SEARCH
} RygelLMSCategoryContainerError;
#define RYGEL_LMS_CATEGORY_CONTAINER_ERROR rygel_lms_category_container_error_quark ()
struct _RygelLMSCategoryContainer {
	RygelMediaContainer parent_instance;
	RygelLMSCategoryContainerPrivate * priv;
	sqlite3_stmt* stmt_all;
	sqlite3_stmt* stmt_find_object;
	sqlite3_stmt* stmt_added;
	sqlite3_stmt* stmt_removed;
	gchar* child_prefix;
	gchar* ref_prefix;
};

struct _RygelLMSCategoryContainerClass {
	RygelMediaContainerClass parent_class;
	RygelMediaObject* (*object_from_statement) (RygelLMSCategoryContainer* self, sqlite3_stmt* statement);
	gchar* (*get_sql_all_with_filter) (RygelLMSCategoryContainer* self, const gchar* filter);
	gchar* (*get_sql_count_with_filter) (RygelLMSCategoryContainer* self, const gchar* filter);
	guint (*get_child_count_with_filter) (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args);
	RygelMediaObjects* (*get_children_with_filter) (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args, const gchar* sort_criteria, guint offset, guint max_count);
};

struct _RygelLMSCategoryContainerPrivate {
	GeeArrayList* _search_classes;
	RygelLMSDatabase* _lms_db;
	gchar* _db_id;
	gchar* _sql_all;
	gchar* _sql_find_object;
	gchar* _sql_count;
	gchar* _sql_added;
	gchar* _sql_removed;
};

typedef enum  {
	RYGEL_LMS_DATABASE_ERROR_OPEN,
	RYGEL_LMS_DATABASE_ERROR_PREPARE,
	RYGEL_LMS_DATABASE_ERROR_BIND,
	RYGEL_LMS_DATABASE_ERROR_STEP,
	RYGEL_LMS_DATABASE_ERROR_NOT_FOUND
} RygelLMSDatabaseError;
#define RYGEL_LMS_DATABASE_ERROR rygel_lms_database_error_quark ()
struct _RygelLmsCategoryContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelLMSCategoryContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	GValueArray* args;
	GValueArray* _tmp0_;
	gchar* filter;
	RygelSearchExpression* _tmp1_;
	GValueArray* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GValueArray* _tmp5_;
	guint _tmp6_;
	RygelSearchExpression* _tmp7_;
	RygelSearchExpression* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	const gchar* _tmp14_;
	GValueArray* _tmp15_;
	const gchar* _tmp16_;
	guint _tmp17_;
	guint _tmp18_;
	RygelMediaObjects* _tmp19_;
	GError* e;
	GError* _tmp20_;
	const gchar* _tmp21_;
	RygelMediaObjects* _tmp22_;
	RygelSearchExpression* _tmp23_;
	guint _tmp24_;
	guint _tmp25_;
	const gchar* _tmp26_;
	GCancellable* _tmp27_;
	guint _tmp28_;
	RygelMediaObjects* _tmp29_;
	RygelMediaObjects* _tmp30_;
	GError * _inner_error_;
};

struct _RygelLmsCategoryContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelLMSCategoryContainer* self;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* retval;
	RygelMediaObjects* _tmp0_;
	sqlite3_stmt* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	sqlite3_stmt* _tmp6_;
	gboolean _tmp7_;
	RygelMediaObjects* _tmp8_;
	sqlite3_stmt* _tmp9_;
	RygelMediaObject* _tmp10_;
	RygelMediaObject* _tmp11_;
	GError * _inner_error_;
};

struct _RygelLmsCategoryContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelLMSCategoryContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	RygelMediaObject* object;
	gchar* real_id;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint index;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	const gchar* _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	sqlite3_stmt* _tmp15_;
	RygelMediaObject* child;
	sqlite3_stmt* _tmp16_;
	RygelMediaObject* _tmp17_;
	gint _tmp18_;
	RygelMediaObject* _tmp19_;
	RygelMediaObject* _tmp20_;
	RygelLMSCategoryContainer* container;
	RygelMediaObject* _tmp21_;
	RygelLMSCategoryContainer* _tmp22_;
	RygelMediaObject* _tmp23_;
	RygelLMSCategoryContainer* _tmp24_;
	const gchar* _tmp25_;
	GCancellable* _tmp26_;
	RygelMediaObject* _tmp27_;
	RygelMediaObject* _tmp28_;
	RygelMediaObject* _tmp29_;
	RygelMediaObject* _tmp30_;
	RygelMediaContainer* _tmp31_;
	RygelMediaContainer* _tmp32_;
	GError* e;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	GError* _tmp36_;
	const gchar* _tmp37_;
	GError * _inner_error_;
};

struct _RygelLmsCategoryContainerAddChildData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelLMSCategoryContainer* self;
	RygelMediaObject* object;
};

struct _RygelLmsCategoryContainerRemoveChildData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelLMSCategoryContainer* self;
	RygelMediaObject* object;
};


static gpointer rygel_lms_category_container_parent_class = NULL;
static RygelTrackableContainerIface* rygel_lms_category_container_rygel_trackable_container_parent_iface = NULL;
static RygelSearchableContainerIface* rygel_lms_category_container_rygel_searchable_container_parent_iface = NULL;

GQuark rygel_lms_category_container_error_quark (void);
GType rygel_lms_category_container_get_type (void) G_GNUC_CONST;
gpointer rygel_lms_database_ref (gpointer instance);
void rygel_lms_database_unref (gpointer instance);
GParamSpec* rygel_lms_param_spec_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_lms_value_set_database (GValue* value, gpointer v_object);
void rygel_lms_value_take_database (GValue* value, gpointer v_object);
gpointer rygel_lms_value_get_database (const GValue* value);
GType rygel_lms_database_get_type (void) G_GNUC_CONST;
#define RYGEL_LMS_CATEGORY_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainerPrivate))
enum  {
	RYGEL_LMS_CATEGORY_CONTAINER_DUMMY_PROPERTY,
	RYGEL_LMS_CATEGORY_CONTAINER_SEARCH_CLASSES,
	RYGEL_LMS_CATEGORY_CONTAINER_LMS_DB,
	RYGEL_LMS_CATEGORY_CONTAINER_DB_ID,
	RYGEL_LMS_CATEGORY_CONTAINER_SQL_ALL,
	RYGEL_LMS_CATEGORY_CONTAINER_SQL_FIND_OBJECT,
	RYGEL_LMS_CATEGORY_CONTAINER_SQL_COUNT,
	RYGEL_LMS_CATEGORY_CONTAINER_SQL_ADDED,
	RYGEL_LMS_CATEGORY_CONTAINER_SQL_REMOVED
};
RygelMediaObject* rygel_lms_category_container_object_from_statement (RygelLMSCategoryContainer* self, sqlite3_stmt* statement);
static RygelMediaObject* rygel_lms_category_container_real_object_from_statement (RygelLMSCategoryContainer* self, sqlite3_stmt* statement);
gchar* rygel_lms_category_container_get_sql_all_with_filter (RygelLMSCategoryContainer* self, const gchar* filter);
static gchar* rygel_lms_category_container_real_get_sql_all_with_filter (RygelLMSCategoryContainer* self, const gchar* filter);
const gchar* rygel_lms_category_container_get_sql_all (RygelLMSCategoryContainer* self);
gchar* rygel_lms_category_container_get_sql_count_with_filter (RygelLMSCategoryContainer* self, const gchar* filter);
static gchar* rygel_lms_category_container_real_get_sql_count_with_filter (RygelLMSCategoryContainer* self, const gchar* filter);
const gchar* rygel_lms_category_container_get_sql_count (RygelLMSCategoryContainer* self);
static gchar* rygel_lms_category_container_map_operand_to_column (const gchar* operand, gchar** collate, gboolean for_sort, GError** error);
static gchar* rygel_lms_category_container_relational_expression_to_sql (RygelRelationalExpression* exp, GValueArray* args, GError** error);
static void _vala_GValue_free (GValue* self);
static gchar* rygel_lms_category_container_logical_expression_to_sql (RygelLogicalExpression* expression, GValueArray* args, GError** error);
static gchar* rygel_lms_category_container_search_expression_to_sql (RygelSearchExpression* expression, GValueArray* args, GError** error);
guint rygel_lms_category_container_get_child_count_with_filter (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args);
static guint rygel_lms_category_container_real_get_child_count_with_filter (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args);
RygelLMSDatabase* rygel_lms_category_container_get_lms_db (RygelLMSCategoryContainer* self);
GQuark rygel_lms_database_error_quark (void);
sqlite3_stmt* rygel_lms_database_prepare_and_init (RygelLMSDatabase* self, const gchar* query, GValue* arguments, int arguments_length1, GError** error);
RygelMediaObjects* rygel_lms_category_container_get_children_with_filter (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args, const gchar* sort_criteria, guint offset, guint max_count);
static RygelMediaObjects* rygel_lms_category_container_real_get_children_with_filter (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args, const gchar* sort_criteria, guint offset, guint max_count);
gboolean rygel_lms_database_get_children_step (sqlite3_stmt* stmt, GError** error);
static void rygel_lms_category_container_real_search_data_free (gpointer _data);
static void rygel_lms_category_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_lms_category_container_real_search_co (RygelLmsCategoryContainerSearchData* _data_);
static void rygel_lms_category_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_lms_category_container_real_get_children_data_free (gpointer _data);
static void rygel_lms_category_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_lms_category_container_real_get_children_co (RygelLmsCategoryContainerGetChildrenData* _data_);
void rygel_lms_database_get_children_init (sqlite3_stmt* stmt, guint offset, guint max_count, const gchar* sort_criteria, GError** error);
static void rygel_lms_category_container_real_find_object_data_free (gpointer _data);
static void rygel_lms_category_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_lms_category_container_real_find_object_co (RygelLmsCategoryContainerFindObjectData* _data_);
void rygel_lms_database_find_object (const gchar* id, sqlite3_stmt* stmt, GError** error);
static void rygel_lms_category_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* rygel_lms_category_container_build_child_id (RygelLMSCategoryContainer* self, gint db_id);
gchar* rygel_lms_category_container_build_reference_id (RygelLMSCategoryContainer* self, gint db_id);
static void rygel_lms_category_container_real_add_child_data_free (gpointer _data);
static void rygel_lms_category_container_real_add_child (RygelTrackableContainer* base, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_lms_category_container_real_add_child_co (RygelLmsCategoryContainerAddChildData* _data_);
static void rygel_lms_category_container_real_remove_child_data_free (gpointer _data);
static void rygel_lms_category_container_real_remove_child (RygelTrackableContainer* base, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_lms_category_container_real_remove_child_co (RygelLmsCategoryContainerRemoveChildData* _data_);
static void rygel_lms_category_container_on_db_updated (RygelLMSCategoryContainer* self, guint64 old_id, guint64 new_id);
sqlite3_stmt* rygel_lms_database_prepare (RygelLMSDatabase* self, const gchar* query_string, GError** error);
void rygel_lms_database_get_children_with_update_id_init (sqlite3_stmt* stmt, guint64 old_id, guint64 new_id, GError** error);
RygelLMSCategoryContainer* rygel_lms_category_container_construct (GType object_type, const gchar* db_id, RygelMediaContainer* parent, const gchar* title, RygelLMSDatabase* lms_db, const gchar* sql_all, const gchar* sql_find_object, const gchar* sql_count, const gchar* sql_added, const gchar* sql_removed);
static void rygel_lms_category_container_set_lms_db (RygelLMSCategoryContainer* self, RygelLMSDatabase* value);
const gchar* rygel_lms_category_container_get_db_id (RygelLMSCategoryContainer* self);
static void rygel_lms_category_container_set_db_id (RygelLMSCategoryContainer* self, const gchar* value);
static void rygel_lms_category_container_set_sql_all (RygelLMSCategoryContainer* self, const gchar* value);
const gchar* rygel_lms_category_container_get_sql_find_object (RygelLMSCategoryContainer* self);
static void rygel_lms_category_container_set_sql_find_object (RygelLMSCategoryContainer* self, const gchar* value);
static void rygel_lms_category_container_set_sql_count (RygelLMSCategoryContainer* self, const gchar* value);
const gchar* rygel_lms_category_container_get_sql_added (RygelLMSCategoryContainer* self);
static void rygel_lms_category_container_set_sql_added (RygelLMSCategoryContainer* self, const gchar* value);
const gchar* rygel_lms_category_container_get_sql_removed (RygelLMSCategoryContainer* self);
static void rygel_lms_category_container_set_sql_removed (RygelLMSCategoryContainer* self, const gchar* value);
static GObject * rygel_lms_category_container_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _rygel_lms_category_container_on_db_updated_rygel_lms_database_db_updated (RygelLMSDatabase* _sender, guint64 old_update_id, guint64 new_update_id, gpointer self);
static void rygel_lms_category_container_finalize (GObject* obj);
static void _vala_rygel_lms_category_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_lms_category_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_lms_category_container_error_quark (void) {
	return g_quark_from_static_string ("rygel_lms_category_container_error-quark");
}


static RygelMediaObject* rygel_lms_category_container_real_object_from_statement (RygelLMSCategoryContainer* self, sqlite3_stmt* statement) {
	g_critical ("Type `%s' does not implement abstract method `rygel_lms_category_container_object_from_statement'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


RygelMediaObject* rygel_lms_category_container_object_from_statement (RygelLMSCategoryContainer* self, sqlite3_stmt* statement) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_LMS_CATEGORY_CONTAINER_GET_CLASS (self)->object_from_statement (self, statement);
}


static gchar* rygel_lms_category_container_real_get_sql_all_with_filter (RygelLMSCategoryContainer* self, const gchar* filter) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (filter != NULL, NULL);
	_tmp0_ = self->priv->_sql_all;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* rygel_lms_category_container_get_sql_all_with_filter (RygelLMSCategoryContainer* self, const gchar* filter) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_LMS_CATEGORY_CONTAINER_GET_CLASS (self)->get_sql_all_with_filter (self, filter);
}


static gchar* rygel_lms_category_container_real_get_sql_count_with_filter (RygelLMSCategoryContainer* self, const gchar* filter) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (filter != NULL, NULL);
	_tmp0_ = self->priv->_sql_count;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* rygel_lms_category_container_get_sql_count_with_filter (RygelLMSCategoryContainer* self, const gchar* filter) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_LMS_CATEGORY_CONTAINER_GET_CLASS (self)->get_sql_count_with_filter (self, filter);
}


static gchar* rygel_lms_category_container_map_operand_to_column (const gchar* operand, gchar** collate, gboolean for_sort, GError** error) {
	gchar* _vala_collate = NULL;
	gchar* result = NULL;
	gchar* column = NULL;
	gboolean use_collation = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	gboolean _tmp11_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (operand != NULL, NULL);
	column = NULL;
	use_collation = FALSE;
	_tmp0_ = operand;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("dc:title")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_ = NULL;
				_tmp4_ = g_strdup ("title");
				_g_free0 (column);
				column = _tmp4_;
				use_collation = TRUE;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("upnp:artist")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_ = NULL;
				_tmp5_ = g_strdup ("artist");
				_g_free0 (column);
				column = _tmp5_;
				use_collation = TRUE;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("dc:creator")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_ = NULL;
				_tmp6_ = g_strdup ("creator");
				_g_free0 (column);
				column = _tmp6_;
				use_collation = TRUE;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* message = NULL;
				const gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				GError* _tmp10_ = NULL;
				_tmp7_ = operand;
				_tmp8_ = g_strdup_printf ("Unsupported column %s", _tmp7_);
				message = _tmp8_;
				_tmp9_ = message;
				_tmp10_ = g_error_new_literal (RYGEL_LMS_CATEGORY_CONTAINER_ERROR, RYGEL_LMS_CATEGORY_CONTAINER_ERROR_UNSUPPORTED_SEARCH, _tmp9_);
				_inner_error_ = _tmp10_;
				g_propagate_error (error, _inner_error_);
				_g_free0 (message);
				_g_free0 (column);
				return NULL;
			}
		}
	}
	_tmp11_ = use_collation;
	if (_tmp11_) {
		gchar* _tmp12_ = NULL;
		_tmp12_ = g_strdup ("COLLATE CASEFOLD");
		_g_free0 (_vala_collate);
		_vala_collate = _tmp12_;
	} else {
		gchar* _tmp13_ = NULL;
		_tmp13_ = g_strdup ("");
		_g_free0 (_vala_collate);
		_vala_collate = _tmp13_;
	}
	result = column;
	if (collate) {
		*collate = _vala_collate;
	} else {
		_g_free0 (_vala_collate);
	}
	return result;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static gchar* rygel_lms_category_container_relational_expression_to_sql (RygelRelationalExpression* exp, GValueArray* args, GError** error) {
	gchar* result = NULL;
	GValue* v = NULL;
	gchar* collate = NULL;
	gchar* column = NULL;
	RygelRelationalExpression* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	RygelDatabaseSqlOperator* operator = NULL;
	RygelRelationalExpression* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	GValue* _tmp40_ = NULL;
	RygelDatabaseSqlOperator* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (exp != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	v = NULL;
	collate = NULL;
	_tmp0_ = exp;
	_tmp1_ = ((RygelSearchExpression*) _tmp0_)->operand1;
	_tmp3_ = rygel_lms_category_container_map_operand_to_column ((const gchar*) _tmp1_, &_tmp2_, FALSE, &_inner_error_);
	_g_free0 (collate);
	collate = _tmp2_;
	column = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (collate);
		__vala_GValue_free0 (v);
		return NULL;
	}
	_tmp4_ = exp;
	_tmp5_ = ((RygelSearchExpression*) _tmp4_)->op;
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp5_)) {
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
		{
			gchar* sql_function = NULL;
			RygelRelationalExpression* _tmp6_ = NULL;
			gconstpointer _tmp7_ = NULL;
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			_tmp6_ = exp;
			_tmp7_ = ((RygelSearchExpression*) _tmp6_)->operand2;
			if (g_strcmp0 ((const gchar*) _tmp7_, "true") == 0) {
				gchar* _tmp8_ = NULL;
				_tmp8_ = g_strdup ("%s IS NOT NULL AND %s != ''");
				_g_free0 (sql_function);
				sql_function = _tmp8_;
			} else {
				gchar* _tmp9_ = NULL;
				_tmp9_ = g_strdup ("%s IS NULL OR %s = ''");
				_g_free0 (sql_function);
				sql_function = _tmp9_;
			}
			_tmp10_ = sql_function;
			_tmp11_ = column;
			_tmp12_ = column;
			_tmp13_ = g_strdup_printf (_tmp10_, _tmp11_, _tmp12_);
			result = _tmp13_;
			_g_free0 (sql_function);
			_g_object_unref0 (operator);
			_g_free0 (column);
			_g_free0 (collate);
			__vala_GValue_free0 (v);
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
		{
			RygelRelationalExpression* _tmp14_ = NULL;
			gconstpointer _tmp15_ = NULL;
			GValue* _tmp16_ = NULL;
			RygelRelationalExpression* _tmp17_ = NULL;
			gconstpointer _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			RygelDatabaseSqlOperator* _tmp21_ = NULL;
			_tmp14_ = exp;
			_tmp15_ = ((RygelSearchExpression*) _tmp14_)->operand2;
			_tmp16_ = g_new0 (GValue, 1);
			g_value_init (_tmp16_, G_TYPE_STRING);
			g_value_set_string (_tmp16_, (const gchar*) _tmp15_);
			__vala_GValue_free0 (v);
			v = _tmp16_;
			_tmp17_ = exp;
			_tmp18_ = ((RygelSearchExpression*) _tmp17_)->op;
			_tmp19_ = column;
			_tmp20_ = collate;
			_tmp21_ = rygel_database_sql_operator_new_from_search_criteria_op ((GUPnPSearchCriteriaOp) ((gintptr) _tmp18_), _tmp19_, _tmp20_);
			_g_object_unref0 (operator);
			operator = _tmp21_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			const gchar* _tmp22_ = NULL;
			RygelDatabaseSqlFunction* _tmp23_ = NULL;
			RygelRelationalExpression* _tmp24_ = NULL;
			gconstpointer _tmp25_ = NULL;
			GValue* _tmp26_ = NULL;
			_tmp22_ = column;
			_tmp23_ = rygel_database_sql_function_new ("contains", _tmp22_);
			_g_object_unref0 (operator);
			operator = (RygelDatabaseSqlOperator*) _tmp23_;
			_tmp24_ = exp;
			_tmp25_ = ((RygelSearchExpression*) _tmp24_)->operand2;
			_tmp26_ = g_new0 (GValue, 1);
			g_value_init (_tmp26_, G_TYPE_STRING);
			g_value_set_string (_tmp26_, (const gchar*) _tmp25_);
			__vala_GValue_free0 (v);
			v = _tmp26_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_DOES_NOT_CONTAIN:
		{
			const gchar* _tmp27_ = NULL;
			RygelDatabaseSqlFunction* _tmp28_ = NULL;
			RygelRelationalExpression* _tmp29_ = NULL;
			gconstpointer _tmp30_ = NULL;
			GValue* _tmp31_ = NULL;
			_tmp27_ = column;
			_tmp28_ = rygel_database_sql_function_new ("NOT contains", _tmp27_);
			_g_object_unref0 (operator);
			operator = (RygelDatabaseSqlOperator*) _tmp28_;
			_tmp29_ = exp;
			_tmp30_ = ((RygelSearchExpression*) _tmp29_)->operand2;
			_tmp31_ = g_new0 (GValue, 1);
			g_value_init (_tmp31_, G_TYPE_STRING);
			g_value_set_string (_tmp31_, (const gchar*) _tmp30_);
			__vala_GValue_free0 (v);
			v = _tmp31_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
		{
			const gchar* _tmp32_ = NULL;
			RygelDatabaseSqlOperator* _tmp33_ = NULL;
			RygelRelationalExpression* _tmp34_ = NULL;
			gconstpointer _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			GValue* _tmp37_ = NULL;
			_tmp32_ = column;
			_tmp33_ = rygel_database_sql_operator_new ("LIKE", _tmp32_, "");
			_g_object_unref0 (operator);
			operator = _tmp33_;
			_tmp34_ = exp;
			_tmp35_ = ((RygelSearchExpression*) _tmp34_)->operand2;
			_tmp36_ = g_strdup_printf ("%s%%", (const gchar*) _tmp35_);
			_tmp37_ = g_new0 (GValue, 1);
			g_value_init (_tmp37_, G_TYPE_STRING);
			g_value_take_string (_tmp37_, _tmp36_);
			__vala_GValue_free0 (v);
			v = _tmp37_;
			break;
		}
		default:
		{
			RygelRelationalExpression* _tmp38_ = NULL;
			gconstpointer _tmp39_ = NULL;
			_tmp38_ = exp;
			_tmp39_ = ((RygelSearchExpression*) _tmp38_)->op;
			g_warning ("rygel-lms-category-container.vala:149: Unsupported op %d", (gint) ((GUPnPSearchCriteriaOp) ((gintptr) _tmp39_)));
			result = NULL;
			_g_object_unref0 (operator);
			_g_free0 (column);
			_g_free0 (collate);
			__vala_GValue_free0 (v);
			return result;
		}
	}
	_tmp40_ = v;
	if (_tmp40_ != NULL) {
		GValueArray* _tmp41_ = NULL;
		GValue* _tmp42_ = NULL;
		GValue _tmp43_ = {0};
		_tmp41_ = args;
		_tmp42_ = v;
		_tmp43_ = *_tmp42_;
		g_value_array_append (_tmp41_, &_tmp43_);
	}
	_tmp44_ = operator;
	_tmp45_ = rygel_database_sql_operator_to_string (_tmp44_);
	result = _tmp45_;
	_g_object_unref0 (operator);
	_g_free0 (column);
	_g_free0 (collate);
	__vala_GValue_free0 (v);
	return result;
}


static gchar* rygel_lms_category_container_logical_expression_to_sql (RygelLogicalExpression* expression, GValueArray* args, GError** error) {
	gchar* result = NULL;
	gchar* left_sql_string = NULL;
	RygelLogicalExpression* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GValueArray* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* right_sql_string = NULL;
	RygelLogicalExpression* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	GValueArray* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* operator_sql_string = NULL;
	RygelLogicalExpression* _tmp8_ = NULL;
	gconstpointer _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (expression != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = expression;
	_tmp1_ = ((RygelSearchExpression*) _tmp0_)->operand1;
	_tmp2_ = args;
	_tmp3_ = rygel_lms_category_container_search_expression_to_sql ((RygelSearchExpression*) _tmp1_, _tmp2_, &_inner_error_);
	left_sql_string = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp4_ = expression;
	_tmp5_ = ((RygelSearchExpression*) _tmp4_)->operand2;
	_tmp6_ = args;
	_tmp7_ = rygel_lms_category_container_search_expression_to_sql ((RygelSearchExpression*) _tmp5_, _tmp6_, &_inner_error_);
	right_sql_string = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (left_sql_string);
		return NULL;
	}
	operator_sql_string = "OR";
	_tmp8_ = expression;
	_tmp9_ = ((RygelSearchExpression*) _tmp8_)->op;
	if (((RygelLogicalOperator) ((gintptr) _tmp9_)) == RYGEL_LOGICAL_OPERATOR_AND) {
		operator_sql_string = "AND";
	}
	_tmp10_ = left_sql_string;
	_tmp11_ = operator_sql_string;
	_tmp12_ = right_sql_string;
	_tmp13_ = g_strdup_printf ("(%s %s %s)", _tmp10_, _tmp11_, _tmp12_);
	result = _tmp13_;
	_g_free0 (right_sql_string);
	_g_free0 (left_sql_string);
	return result;
}


static gchar* rygel_lms_category_container_search_expression_to_sql (RygelSearchExpression* expression, GValueArray* args, GError** error) {
	gchar* result = NULL;
	RygelSearchExpression* _tmp0_ = NULL;
	RygelSearchExpression* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = expression;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = expression;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_LOGICAL_EXPRESSION)) {
		gchar* _tmp3_ = NULL;
		RygelSearchExpression* _tmp4_ = NULL;
		GValueArray* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp4_ = expression;
		_tmp5_ = args;
		_tmp6_ = rygel_lms_category_container_logical_expression_to_sql (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_LOGICAL_EXPRESSION) ? ((RygelLogicalExpression*) _tmp4_) : NULL, _tmp5_, &_inner_error_);
		_tmp3_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		_tmp7_ = _tmp3_;
		_tmp3_ = NULL;
		result = _tmp7_;
		_g_free0 (_tmp3_);
		return result;
	} else {
		gchar* _tmp8_ = NULL;
		RygelSearchExpression* _tmp9_ = NULL;
		GValueArray* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp9_ = expression;
		_tmp10_ = args;
		_tmp11_ = rygel_lms_category_container_relational_expression_to_sql (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _tmp9_) : NULL, _tmp10_, &_inner_error_);
		_tmp8_ = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		_tmp12_ = _tmp8_;
		_tmp8_ = NULL;
		result = _tmp12_;
		_g_free0 (_tmp8_);
		return result;
	}
}


static guint rygel_lms_category_container_real_get_child_count_with_filter (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args) {
	guint result = 0U;
	gchar* query = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (where_filter != NULL, 0U);
	g_return_val_if_fail (args != NULL, 0U);
	_tmp0_ = where_filter;
	_tmp1_ = rygel_lms_category_container_get_sql_count_with_filter (self, _tmp0_);
	query = _tmp1_;
	{
		sqlite3_stmt* stmt = NULL;
		RygelLMSDatabase* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GValueArray* _tmp4_ = NULL;
		GValue* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		sqlite3_stmt* _tmp6_ = NULL;
		sqlite3_stmt* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		sqlite3_stmt* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		_tmp2_ = self->priv->_lms_db;
		_tmp3_ = query;
		_tmp4_ = args;
		_tmp5_ = _tmp4_->values;
		_tmp5__length1 = (gint) _tmp4_->n_values;
		_tmp6_ = rygel_lms_database_prepare_and_init (_tmp2_, _tmp3_, _tmp5_, _tmp5__length1, &_inner_error_);
		stmt = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
				goto __catch2_rygel_lms_database_error;
			}
			_g_free0 (query);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
		_tmp7_ = stmt;
		_tmp8_ = sqlite3_step (_tmp7_);
		if (_tmp8_ != SQLITE_ROW) {
			result = (guint) 0;
			_sqlite3_finalize0 (stmt);
			_g_free0 (query);
			return result;
		}
		_tmp9_ = stmt;
		_tmp10_ = sqlite3_column_int (_tmp9_, 0);
		result = (guint) _tmp10_;
		_sqlite3_finalize0 (stmt);
		_g_free0 (query);
		return result;
	}
	goto __finally2;
	__catch2_rygel_lms_database_error:
	{
		GError* e = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("rygel-lms-category-container.vala:211: Query failed: %s", _tmp12_);
		result = (guint) 0;
		_g_error_free0 (e);
		_g_free0 (query);
		return result;
	}
	__finally2:
	_g_free0 (query);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0U;
}


guint rygel_lms_category_container_get_child_count_with_filter (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args) {
	g_return_val_if_fail (self != NULL, 0U);
	return RYGEL_LMS_CATEGORY_CONTAINER_GET_CLASS (self)->get_child_count_with_filter (self, where_filter, args);
}


static RygelMediaObjects* rygel_lms_category_container_real_get_children_with_filter (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args, const gchar* sort_criteria, guint offset, guint max_count) {
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* children = NULL;
	RygelMediaObjects* _tmp0_ = NULL;
	GValue v = {0};
	guint _tmp1_ = 0U;
	GValue _tmp2_ = {0};
	GValueArray* _tmp3_ = NULL;
	GValue _tmp4_ = {0};
	guint _tmp5_ = 0U;
	GValue _tmp6_ = {0};
	GValueArray* _tmp7_ = NULL;
	GValue _tmp8_ = {0};
	gchar* query = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (where_filter != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = rygel_media_objects_new ();
	children = _tmp0_;
	_tmp1_ = max_count;
	g_value_init (&_tmp2_, G_TYPE_UINT);
	g_value_set_uint (&_tmp2_, _tmp1_);
	v = _tmp2_;
	_tmp3_ = args;
	_tmp4_ = v;
	g_value_array_append (_tmp3_, &_tmp4_);
	_tmp5_ = offset;
	g_value_init (&_tmp6_, G_TYPE_UINT);
	g_value_set_uint (&_tmp6_, _tmp5_);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	v = _tmp6_;
	_tmp7_ = args;
	_tmp8_ = v;
	g_value_array_append (_tmp7_, &_tmp8_);
	_tmp9_ = where_filter;
	_tmp10_ = rygel_lms_category_container_get_sql_all_with_filter (self, _tmp9_);
	query = _tmp10_;
	{
		sqlite3_stmt* stmt = NULL;
		RygelLMSDatabase* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GValueArray* _tmp13_ = NULL;
		GValue* _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		sqlite3_stmt* _tmp15_ = NULL;
		_tmp11_ = self->priv->_lms_db;
		_tmp12_ = query;
		_tmp13_ = args;
		_tmp14_ = _tmp13_->values;
		_tmp14__length1 = (gint) _tmp13_->n_values;
		_tmp15_ = rygel_lms_database_prepare_and_init (_tmp11_, _tmp12_, _tmp14_, _tmp14__length1, &_inner_error_);
		stmt = _tmp15_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
				goto __catch3_rygel_lms_database_error;
			}
			_g_free0 (query);
			G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
			_g_object_unref0 (children);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		while (TRUE) {
			gboolean _tmp16_ = FALSE;
			sqlite3_stmt* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
			RygelMediaObjects* _tmp19_ = NULL;
			sqlite3_stmt* _tmp20_ = NULL;
			RygelMediaObject* _tmp21_ = NULL;
			RygelMediaObject* _tmp22_ = NULL;
			_tmp17_ = stmt;
			_tmp18_ = rygel_lms_database_get_children_step (_tmp17_, &_inner_error_);
			_tmp16_ = _tmp18_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_sqlite3_finalize0 (stmt);
				if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
					goto __catch3_rygel_lms_database_error;
				}
				_sqlite3_finalize0 (stmt);
				_g_free0 (query);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				_g_object_unref0 (children);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			if (!_tmp16_) {
				break;
			}
			_tmp19_ = children;
			_tmp20_ = stmt;
			_tmp21_ = rygel_lms_category_container_object_from_statement (self, _tmp20_);
			_tmp22_ = _tmp21_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp22_);
			_g_object_unref0 (_tmp22_);
		}
		_sqlite3_finalize0 (stmt);
	}
	goto __finally3;
	__catch3_rygel_lms_database_error:
	{
		GError* e = NULL;
		GError* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		g_warning ("rygel-lms-category-container.vala:236: Query failed: %s", _tmp24_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (query);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		_g_object_unref0 (children);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = children;
	_g_free0 (query);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	return result;
}


RygelMediaObjects* rygel_lms_category_container_get_children_with_filter (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args, const gchar* sort_criteria, guint offset, guint max_count) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_LMS_CATEGORY_CONTAINER_GET_CLASS (self)->get_children_with_filter (self, where_filter, args, sort_criteria, offset, max_count);
}


static void rygel_lms_category_container_real_search_data_free (gpointer _data) {
	RygelLmsCategoryContainerSearchData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelLmsCategoryContainerSearchData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_lms_category_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelLMSCategoryContainer * self;
	RygelLmsCategoryContainerSearchData* _data_;
	RygelLMSCategoryContainer* _tmp0_ = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	RygelSearchExpression* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
	self = (RygelLMSCategoryContainer*) base;
	_data_ = g_slice_new0 (RygelLmsCategoryContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_lms_category_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_lms_category_container_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = expression;
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp2_;
	_tmp3_ = offset;
	_data_->offset = _tmp3_;
	_tmp4_ = max_count;
	_data_->max_count = _tmp4_;
	_tmp5_ = sort_criteria;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp6_;
	_tmp7_ = cancellable;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp8_;
	rygel_lms_category_container_real_search_co (_data_);
}


static RygelMediaObjects* rygel_lms_category_container_real_search_finish (RygelSearchableContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelLmsCategoryContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_lms_category_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelLmsCategoryContainerSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_lms_category_container_real_search_co (_data_);
}


static gboolean rygel_lms_category_container_real_search_co (RygelLmsCategoryContainerSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("rygel-lms-category-container.vala:249: search()");
	{
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = g_value_array_new ((guint) 0);
		_data_->args = _data_->_tmp0_;
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->expression;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->args;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = rygel_lms_category_container_search_expression_to_sql (_data_->_tmp1_, _data_->_tmp2_, &_data_->_inner_error_);
		_data_->filter = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_value_array_free0 (_data_->args);
			goto __catch4_g_error;
		}
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->filter;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->args;
		_data_->_tmp6_ = 0U;
		_data_->_tmp6_ = rygel_lms_category_container_get_child_count_with_filter (_data_->self, _data_->_tmp4_, _data_->_tmp5_);
		_data_->total_matches = _data_->_tmp6_;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->expression;
		if (_data_->_tmp7_ != NULL) {
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _data_->expression;
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = rygel_search_expression_to_string (_data_->_tmp8_);
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = _data_->_tmp9_;
			g_debug ("rygel-lms-category-container.vala:257:   Original search: %s", _data_->_tmp10_);
			_g_free0 (_data_->_tmp10_);
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _data_->filter;
			g_debug ("rygel-lms-category-container.vala:258:   Parsed search expression: %s", _data_->_tmp11_);
			_data_->_tmp12_ = 0U;
			_data_->_tmp12_ = _data_->total_matches;
			g_debug ("rygel-lms-category-container.vala:259:   Filtered cild count is %u", _data_->_tmp12_);
		}
		_data_->_tmp13_ = 0U;
		_data_->_tmp13_ = _data_->max_count;
		if (_data_->_tmp13_ == ((guint) 0)) {
			_data_->max_count = G_MAXUINT;
		}
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->filter;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->args;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->sort_criteria;
		_data_->_tmp17_ = 0U;
		_data_->_tmp17_ = _data_->offset;
		_data_->_tmp18_ = 0U;
		_data_->_tmp18_ = _data_->max_count;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = rygel_lms_category_container_get_children_with_filter (_data_->self, _data_->_tmp14_, _data_->_tmp15_, _data_->_tmp16_, _data_->_tmp17_, _data_->_tmp18_);
		_data_->result = _data_->_tmp19_;
		_g_free0 (_data_->filter);
		_g_value_array_free0 (_data_->args);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally4;
	__catch4_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->e;
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->_tmp20_->message;
		g_debug ("rygel-lms-category-container.vala:272:   Falling back to simple_search" \
"(): %s", _data_->_tmp21_);
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->expression;
		_data_->_tmp24_ = 0U;
		_data_->_tmp24_ = _data_->offset;
		_data_->_tmp25_ = 0U;
		_data_->_tmp25_ = _data_->max_count;
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->sort_criteria;
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->cancellable;
		_data_->_tmp28_ = 0U;
		_data_->_state_ = 1;
		rygel_searchable_container_simple_search ((RygelSearchableContainer*) _data_->self, _data_->_tmp23_, _data_->_tmp24_, _data_->_tmp25_, _data_->_tmp26_, _data_->_tmp27_, rygel_lms_category_container_search_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp28_, &_data_->_inner_error_);
		_data_->total_matches = _data_->_tmp28_;
		_data_->_tmp22_ = _data_->_tmp29_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_error_free0 (_data_->e);
			goto __finally4;
		}
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = _data_->_tmp22_;
		_data_->_tmp22_ = NULL;
		_data_->result = _data_->_tmp30_;
		_g_object_unref0 (_data_->_tmp22_);
		_g_error_free0 (_data_->e);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally4:
	g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
	g_error_free (_data_->_inner_error_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_lms_category_container_real_get_children_data_free (gpointer _data) {
	RygelLmsCategoryContainerGetChildrenData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelLmsCategoryContainerGetChildrenData, _data_);
}


static void rygel_lms_category_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelLMSCategoryContainer * self;
	RygelLmsCategoryContainerGetChildrenData* _data_;
	RygelLMSCategoryContainer* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
	GCancellable* _tmp6_ = NULL;
	self = (RygelLMSCategoryContainer*) base;
	_data_ = g_slice_new0 (RygelLmsCategoryContainerGetChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_lms_category_container_real_get_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_lms_category_container_real_get_children_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = offset;
	_data_->offset = _tmp1_;
	_tmp2_ = max_count;
	_data_->max_count = _tmp2_;
	_tmp3_ = sort_criteria;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp4_;
	_tmp5_ = cancellable;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp6_;
	rygel_lms_category_container_real_get_children_co (_data_);
}


static RygelMediaObjects* rygel_lms_category_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelLmsCategoryContainerGetChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean rygel_lms_category_container_real_get_children_co (RygelLmsCategoryContainerGetChildrenData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = rygel_media_objects_new ();
	_data_->retval = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->stmt_all;
	_data_->_tmp2_ = 0U;
	_data_->_tmp2_ = _data_->offset;
	_data_->_tmp3_ = 0U;
	_data_->_tmp3_ = _data_->max_count;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->sort_criteria;
	rygel_lms_database_get_children_init (_data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->retval);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	while (TRUE) {
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->self->stmt_all;
		_data_->_tmp7_ = FALSE;
		_data_->_tmp7_ = rygel_lms_database_get_children_step (_data_->_tmp6_, &_data_->_inner_error_);
		_data_->_tmp5_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->retval);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		if (!_data_->_tmp5_) {
			break;
		}
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->retval;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->self->stmt_all;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = rygel_lms_category_container_object_from_statement (_data_->self, _data_->_tmp9_);
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->_tmp10_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp8_, _data_->_tmp11_);
		_g_object_unref0 (_data_->_tmp11_);
	}
	_data_->result = _data_->retval;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->retval);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_lms_category_container_real_find_object_data_free (gpointer _data) {
	RygelLmsCategoryContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelLmsCategoryContainerFindObjectData, _data_);
}


static void rygel_lms_category_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelLMSCategoryContainer * self;
	RygelLmsCategoryContainerFindObjectData* _data_;
	RygelLMSCategoryContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	self = (RygelLMSCategoryContainer*) base;
	_data_ = g_slice_new0 (RygelLmsCategoryContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_lms_category_container_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_lms_category_container_real_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_lms_category_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_lms_category_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelLmsCategoryContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static void rygel_lms_category_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelLmsCategoryContainerFindObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_lms_category_container_real_find_object_co (_data_);
}


static gboolean rygel_lms_category_container_real_find_object_co (RygelLmsCategoryContainerFindObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->id;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->child_prefix;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = g_str_has_prefix (_data_->_tmp0_, _data_->_tmp1_);
	if (!_data_->_tmp2_) {
		_data_->result = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->object = NULL;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->id;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->self->child_prefix;
	_data_->_tmp5_ = 0;
	_data_->_tmp5_ = strlen (_data_->_tmp4_);
	_data_->_tmp6_ = 0;
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = string_substring (_data_->_tmp3_, (glong) _data_->_tmp6_, (glong) -1);
	_data_->real_id = _data_->_tmp7_;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->real_id;
	_data_->_tmp9_ = 0;
	_data_->_tmp9_ = string_index_of_char (_data_->_tmp8_, (gunichar) ':', 0);
	_data_->index = _data_->_tmp9_;
	_data_->_tmp10_ = 0;
	_data_->_tmp10_ = _data_->index;
	if (_data_->_tmp10_ > 0) {
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->real_id;
		_data_->_tmp12_ = 0;
		_data_->_tmp12_ = _data_->index;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = string_slice (_data_->_tmp11_, (glong) 0, (glong) _data_->_tmp12_);
		_g_free0 (_data_->real_id);
		_data_->real_id = _data_->_tmp13_;
	}
	{
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->real_id;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->self->stmt_find_object;
		rygel_lms_database_find_object (_data_->_tmp14_, _data_->_tmp15_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (_data_->_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
				goto __catch5_rygel_lms_database_error;
			}
			_g_free0 (_data_->real_id);
			_g_object_unref0 (_data_->object);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->self->stmt_find_object;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = rygel_lms_category_container_object_from_statement (_data_->self, _data_->_tmp16_);
		_data_->child = _data_->_tmp17_;
		_data_->_tmp18_ = 0;
		_data_->_tmp18_ = _data_->index;
		if (_data_->_tmp18_ < 0) {
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->child;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _g_object_ref0 (_data_->_tmp19_);
			_g_object_unref0 (_data_->object);
			_data_->object = _data_->_tmp20_;
		} else {
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->child;
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp21_, RYGEL_LMS_TYPE_CATEGORY_CONTAINER) ? ((RygelLMSCategoryContainer*) _data_->_tmp21_) : NULL);
			_data_->container = _data_->_tmp22_;
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = _data_->container;
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _data_->id;
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = _data_->cancellable;
			_data_->_state_ = 1;
			rygel_media_container_find_object ((RygelMediaContainer*) _data_->_tmp24_, _data_->_tmp25_, _data_->_tmp26_, rygel_lms_category_container_find_object_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = rygel_media_container_find_object_finish ((RygelMediaContainer*) _data_->_tmp24_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp23_ = _data_->_tmp27_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_object_unref0 (_data_->container);
				_g_object_unref0 (_data_->child);
				if (_data_->_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
					goto __catch5_rygel_lms_database_error;
				}
				goto __finally5;
			}
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = _data_->_tmp23_;
			_data_->_tmp23_ = NULL;
			_g_object_unref0 (_data_->object);
			_data_->object = _data_->_tmp28_;
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = _data_->object;
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = _data_->object;
			_data_->_tmp31_ = NULL;
			_data_->_tmp31_ = rygel_media_object_get_parent (_data_->_tmp30_);
			_data_->_tmp32_ = NULL;
			_data_->_tmp32_ = _data_->_tmp31_;
			rygel_media_object_set_parent_ref (_data_->_tmp29_, _data_->_tmp32_);
			_g_object_unref0 (_data_->_tmp23_);
			_g_object_unref0 (_data_->container);
		}
		_g_object_unref0 (_data_->child);
	}
	goto __finally5;
	__catch5_rygel_lms_database_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = _data_->id;
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->self);
		_data_->_tmp35_ = NULL;
		_data_->_tmp35_ = _data_->_tmp34_;
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = _data_->e;
		_data_->_tmp37_ = NULL;
		_data_->_tmp37_ = _data_->_tmp36_->message;
		g_debug ("rygel-lms-category-container.vala:334: find_object %s in %s: %s", _data_->_tmp33_, _data_->_tmp35_, _data_->_tmp37_);
		_g_error_free0 (_data_->e);
	}
	__finally5:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_free0 (_data_->real_id);
		_g_object_unref0 (_data_->object);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->object;
	_g_free0 (_data_->real_id);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_free0 (_data_->real_id);
	_g_object_unref0 (_data_->object);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


gchar* rygel_lms_category_container_build_child_id (RygelLMSCategoryContainer* self, gint db_id) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->child_prefix;
	_tmp1_ = db_id;
	_tmp2_ = g_strdup_printf ("%s%d", _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


gchar* rygel_lms_category_container_build_reference_id (RygelLMSCategoryContainer* self, gint db_id) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->ref_prefix;
	_tmp1_ = db_id;
	_tmp2_ = g_strdup_printf ("%s%d", _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static void rygel_lms_category_container_real_add_child_data_free (gpointer _data) {
	RygelLmsCategoryContainerAddChildData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->object);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelLmsCategoryContainerAddChildData, _data_);
}


static void rygel_lms_category_container_real_add_child (RygelTrackableContainer* base, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelLMSCategoryContainer * self;
	RygelLmsCategoryContainerAddChildData* _data_;
	RygelLMSCategoryContainer* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaObject* _tmp2_ = NULL;
	self = (RygelLMSCategoryContainer*) base;
	_data_ = g_slice_new0 (RygelLmsCategoryContainerAddChildData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_lms_category_container_real_add_child);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_lms_category_container_real_add_child_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = object;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->object);
	_data_->object = _tmp2_;
	rygel_lms_category_container_real_add_child_co (_data_);
}


static void rygel_lms_category_container_real_add_child_finish (RygelTrackableContainer* base, GAsyncResult* _res_) {
	RygelLmsCategoryContainerAddChildData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean rygel_lms_category_container_real_add_child_co (RygelLmsCategoryContainerAddChildData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_lms_category_container_real_remove_child_data_free (gpointer _data) {
	RygelLmsCategoryContainerRemoveChildData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->object);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelLmsCategoryContainerRemoveChildData, _data_);
}


static void rygel_lms_category_container_real_remove_child (RygelTrackableContainer* base, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelLMSCategoryContainer * self;
	RygelLmsCategoryContainerRemoveChildData* _data_;
	RygelLMSCategoryContainer* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaObject* _tmp2_ = NULL;
	self = (RygelLMSCategoryContainer*) base;
	_data_ = g_slice_new0 (RygelLmsCategoryContainerRemoveChildData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_lms_category_container_real_remove_child);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_lms_category_container_real_remove_child_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = object;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->object);
	_data_->object = _tmp2_;
	rygel_lms_category_container_real_remove_child_co (_data_);
}


static void rygel_lms_category_container_real_remove_child_finish (RygelTrackableContainer* base, GAsyncResult* _res_) {
	RygelLmsCategoryContainerRemoveChildData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean rygel_lms_category_container_real_remove_child_co (RygelLmsCategoryContainerRemoveChildData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_lms_category_container_on_db_updated (RygelLMSCategoryContainer* self, guint64 old_id, guint64 new_id) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		sqlite3_stmt* stmt_count = NULL;
		RygelLMSDatabase* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		sqlite3_stmt* _tmp2_ = NULL;
		sqlite3_stmt* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		sqlite3_stmt* _tmp7_ = NULL;
		guint64 _tmp8_ = 0ULL;
		guint64 _tmp9_ = 0ULL;
		sqlite3_stmt* _tmp16_ = NULL;
		guint64 _tmp17_ = 0ULL;
		guint64 _tmp18_ = 0ULL;
		_tmp0_ = self->priv->_lms_db;
		_tmp1_ = self->priv->_sql_count;
		_tmp2_ = rygel_lms_database_prepare (_tmp0_, _tmp1_, &_inner_error_);
		stmt_count = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
				goto __catch6_rygel_lms_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = stmt_count;
		_tmp4_ = sqlite3_step (_tmp3_);
		if (_tmp4_ == SQLITE_ROW) {
			sqlite3_stmt* _tmp5_ = NULL;
			gint _tmp6_ = 0;
			_tmp5_ = stmt_count;
			_tmp6_ = sqlite3_column_int (_tmp5_, 0);
			rygel_media_container_set_child_count ((RygelMediaContainer*) self, _tmp6_);
		}
		_tmp7_ = self->stmt_added;
		_tmp8_ = old_id;
		_tmp9_ = new_id;
		rygel_lms_database_get_children_with_update_id_init (_tmp7_, _tmp8_, _tmp9_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_sqlite3_finalize0 (stmt_count);
			if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
				goto __catch6_rygel_lms_database_error;
			}
			_sqlite3_finalize0 (stmt_count);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		while (TRUE) {
			gboolean _tmp10_ = FALSE;
			sqlite3_stmt* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			RygelMediaObject* object = NULL;
			sqlite3_stmt* _tmp13_ = NULL;
			RygelMediaObject* _tmp14_ = NULL;
			RygelMediaObject* _tmp15_ = NULL;
			_tmp11_ = self->stmt_added;
			_tmp12_ = rygel_lms_database_get_children_step (_tmp11_, &_inner_error_);
			_tmp10_ = _tmp12_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_sqlite3_finalize0 (stmt_count);
				if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
					goto __catch6_rygel_lms_database_error;
				}
				_sqlite3_finalize0 (stmt_count);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			if (!_tmp10_) {
				break;
			}
			_tmp13_ = self->stmt_added;
			_tmp14_ = rygel_lms_category_container_object_from_statement (self, _tmp13_);
			object = _tmp14_;
			_tmp15_ = object;
			rygel_trackable_container_add_child_tracked ((RygelTrackableContainer*) self, _tmp15_, NULL, NULL);
			_g_object_unref0 (object);
		}
		_tmp16_ = self->stmt_removed;
		_tmp17_ = old_id;
		_tmp18_ = new_id;
		rygel_lms_database_get_children_with_update_id_init (_tmp16_, _tmp17_, _tmp18_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_sqlite3_finalize0 (stmt_count);
			if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
				goto __catch6_rygel_lms_database_error;
			}
			_sqlite3_finalize0 (stmt_count);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		while (TRUE) {
			gboolean _tmp19_ = FALSE;
			sqlite3_stmt* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
			RygelMediaObject* object = NULL;
			sqlite3_stmt* _tmp22_ = NULL;
			RygelMediaObject* _tmp23_ = NULL;
			RygelMediaObject* _tmp24_ = NULL;
			_tmp20_ = self->stmt_removed;
			_tmp21_ = rygel_lms_database_get_children_step (_tmp20_, &_inner_error_);
			_tmp19_ = _tmp21_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_sqlite3_finalize0 (stmt_count);
				if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
					goto __catch6_rygel_lms_database_error;
				}
				_sqlite3_finalize0 (stmt_count);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			if (!_tmp19_) {
				break;
			}
			_tmp22_ = self->stmt_removed;
			_tmp23_ = rygel_lms_category_container_object_from_statement (self, _tmp22_);
			object = _tmp23_;
			_tmp24_ = object;
			rygel_trackable_container_remove_child_tracked ((RygelTrackableContainer*) self, _tmp24_, NULL, NULL);
			_g_object_unref0 (object);
		}
		_sqlite3_finalize0 (stmt_count);
	}
	goto __finally6;
	__catch6_rygel_lms_database_error:
	{
		GError* e = NULL;
		GError* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		g_warning ("rygel-lms-category-container.vala:380: Can't perform container update:" \
" %s", _tmp26_);
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


RygelLMSCategoryContainer* rygel_lms_category_container_construct (GType object_type, const gchar* db_id, RygelMediaContainer* parent, const gchar* title, RygelLMSDatabase* lms_db, const gchar* sql_all, const gchar* sql_find_object, const gchar* sql_count, const gchar* sql_added, const gchar* sql_removed) {
	RygelLMSCategoryContainer * self = NULL;
	RygelMediaContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	RygelMediaContainer* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	RygelLMSDatabase* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	g_return_val_if_fail (db_id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (lms_db != NULL, NULL);
	g_return_val_if_fail (sql_all != NULL, NULL);
	g_return_val_if_fail (sql_find_object != NULL, NULL);
	g_return_val_if_fail (sql_count != NULL, NULL);
	_tmp0_ = parent;
	_tmp1_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = db_id;
	_tmp4_ = g_strdup_printf ("%s:%s", _tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = db_id;
	_tmp7_ = parent;
	_tmp8_ = title;
	_tmp9_ = lms_db;
	_tmp10_ = sql_all;
	_tmp11_ = sql_find_object;
	_tmp12_ = sql_count;
	_tmp13_ = sql_added;
	_tmp14_ = sql_removed;
	self = (RygelLMSCategoryContainer*) g_object_new (object_type, "id", _tmp5_, "db-id", _tmp6_, "parent", _tmp7_, "title", _tmp8_, "lms-db", _tmp9_, "sql-all", _tmp10_, "sql-find-object", _tmp11_, "sql-count", _tmp12_, "sql-added", _tmp13_, "sql-removed", _tmp14_, NULL);
	_g_free0 (_tmp5_);
	return self;
}


static GeeArrayList* rygel_lms_category_container_real_get_search_classes (RygelSearchableContainer* base) {
	GeeArrayList* result;
	RygelLMSCategoryContainer* self;
	GeeArrayList* _tmp0_ = NULL;
	self = (RygelLMSCategoryContainer*) base;
	_tmp0_ = self->priv->_search_classes;
	result = _tmp0_;
	return result;
}


static void rygel_lms_category_container_real_set_search_classes (RygelSearchableContainer* base, GeeArrayList* value) {
	RygelLMSCategoryContainer* self;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	self = (RygelLMSCategoryContainer*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_search_classes);
	self->priv->_search_classes = _tmp1_;
	g_object_notify ((GObject *) self, "search-classes");
}


RygelLMSDatabase* rygel_lms_category_container_get_lms_db (RygelLMSCategoryContainer* self) {
	RygelLMSDatabase* result;
	RygelLMSDatabase* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_lms_db;
	result = _tmp0_;
	return result;
}


static void rygel_lms_category_container_set_lms_db (RygelLMSCategoryContainer* self, RygelLMSDatabase* value) {
	RygelLMSDatabase* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_lms_db = _tmp0_;
	g_object_notify ((GObject *) self, "lms-db");
}


const gchar* rygel_lms_category_container_get_db_id (RygelLMSCategoryContainer* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_db_id;
	result = _tmp0_;
	return result;
}


static void rygel_lms_category_container_set_db_id (RygelLMSCategoryContainer* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_db_id);
	self->priv->_db_id = _tmp1_;
	g_object_notify ((GObject *) self, "db-id");
}


const gchar* rygel_lms_category_container_get_sql_all (RygelLMSCategoryContainer* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sql_all;
	result = _tmp0_;
	return result;
}


static void rygel_lms_category_container_set_sql_all (RygelLMSCategoryContainer* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_sql_all);
	self->priv->_sql_all = _tmp1_;
	g_object_notify ((GObject *) self, "sql-all");
}


const gchar* rygel_lms_category_container_get_sql_find_object (RygelLMSCategoryContainer* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sql_find_object;
	result = _tmp0_;
	return result;
}


static void rygel_lms_category_container_set_sql_find_object (RygelLMSCategoryContainer* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_sql_find_object);
	self->priv->_sql_find_object = _tmp1_;
	g_object_notify ((GObject *) self, "sql-find-object");
}


const gchar* rygel_lms_category_container_get_sql_count (RygelLMSCategoryContainer* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sql_count;
	result = _tmp0_;
	return result;
}


static void rygel_lms_category_container_set_sql_count (RygelLMSCategoryContainer* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_sql_count);
	self->priv->_sql_count = _tmp1_;
	g_object_notify ((GObject *) self, "sql-count");
}


const gchar* rygel_lms_category_container_get_sql_added (RygelLMSCategoryContainer* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sql_added;
	result = _tmp0_;
	return result;
}


static void rygel_lms_category_container_set_sql_added (RygelLMSCategoryContainer* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_sql_added);
	self->priv->_sql_added = _tmp1_;
	g_object_notify ((GObject *) self, "sql-added");
}


const gchar* rygel_lms_category_container_get_sql_removed (RygelLMSCategoryContainer* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sql_removed;
	result = _tmp0_;
	return result;
}


static void rygel_lms_category_container_set_sql_removed (RygelLMSCategoryContainer* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_sql_removed);
	self->priv->_sql_removed = _tmp1_;
	g_object_notify ((GObject *) self, "sql-removed");
}


static void _rygel_lms_category_container_on_db_updated_rygel_lms_database_db_updated (RygelLMSDatabase* _sender, guint64 old_update_id, guint64 new_update_id, gpointer self) {
	rygel_lms_category_container_on_db_updated ((RygelLMSCategoryContainer*) self, old_update_id, new_update_id);
}


static GObject * rygel_lms_category_container_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RygelLMSCategoryContainer * self;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gint index = 0;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (rygel_lms_category_container_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainer);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s:", _tmp3_);
	_g_free0 (self->child_prefix);
	self->child_prefix = _tmp4_;
	_tmp5_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = string_index_of_char (_tmp6_, (gunichar) ':', 0);
	index = _tmp7_;
	_tmp8_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = index;
	_tmp11_ = string_slice (_tmp9_, (glong) 0, (glong) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp12_, ":all:", NULL);
	_g_free0 (self->ref_prefix);
	self->ref_prefix = _tmp13_;
	_g_free0 (_tmp12_);
	{
		sqlite3_stmt* _tmp14_ = NULL;
		RygelLMSDatabase* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		sqlite3_stmt* _tmp17_ = NULL;
		sqlite3_stmt* _tmp18_ = NULL;
		sqlite3_stmt* _tmp19_ = NULL;
		RygelLMSDatabase* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		sqlite3_stmt* _tmp22_ = NULL;
		sqlite3_stmt* _tmp23_ = NULL;
		sqlite3_stmt* stmt_count = NULL;
		RygelLMSDatabase* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		sqlite3_stmt* _tmp26_ = NULL;
		sqlite3_stmt* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gboolean _tmp31_ = FALSE;
		const gchar* _tmp32_ = NULL;
		_tmp15_ = self->priv->_lms_db;
		_tmp16_ = self->priv->_sql_all;
		_tmp17_ = rygel_lms_database_prepare (_tmp15_, _tmp16_, &_inner_error_);
		_tmp14_ = _tmp17_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
				goto __catch7_rygel_lms_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp18_ = _tmp14_;
		_tmp14_ = NULL;
		_sqlite3_finalize0 (self->stmt_all);
		self->stmt_all = _tmp18_;
		_tmp20_ = self->priv->_lms_db;
		_tmp21_ = self->priv->_sql_find_object;
		_tmp22_ = rygel_lms_database_prepare (_tmp20_, _tmp21_, &_inner_error_);
		_tmp19_ = _tmp22_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_sqlite3_finalize0 (_tmp14_);
			if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
				goto __catch7_rygel_lms_database_error;
			}
			_sqlite3_finalize0 (_tmp14_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp23_ = _tmp19_;
		_tmp19_ = NULL;
		_sqlite3_finalize0 (self->stmt_find_object);
		self->stmt_find_object = _tmp23_;
		_tmp24_ = self->priv->_lms_db;
		_tmp25_ = self->priv->_sql_count;
		_tmp26_ = rygel_lms_database_prepare (_tmp24_, _tmp25_, &_inner_error_);
		stmt_count = _tmp26_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_sqlite3_finalize0 (_tmp19_);
			_sqlite3_finalize0 (_tmp14_);
			if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
				goto __catch7_rygel_lms_database_error;
			}
			_sqlite3_finalize0 (_tmp19_);
			_sqlite3_finalize0 (_tmp14_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp27_ = stmt_count;
		_tmp28_ = sqlite3_step (_tmp27_);
		if (_tmp28_ == SQLITE_ROW) {
			sqlite3_stmt* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			_tmp29_ = stmt_count;
			_tmp30_ = sqlite3_column_int (_tmp29_, 0);
			rygel_media_container_set_child_count ((RygelMediaContainer*) self, _tmp30_);
		}
		_tmp32_ = self->priv->_sql_added;
		if (_tmp32_ != NULL) {
			const gchar* _tmp33_ = NULL;
			_tmp33_ = self->priv->_sql_removed;
			_tmp31_ = _tmp33_ != NULL;
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			sqlite3_stmt* _tmp34_ = NULL;
			RygelLMSDatabase* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			sqlite3_stmt* _tmp37_ = NULL;
			sqlite3_stmt* _tmp38_ = NULL;
			sqlite3_stmt* _tmp39_ = NULL;
			RygelLMSDatabase* _tmp40_ = NULL;
			const gchar* _tmp41_ = NULL;
			sqlite3_stmt* _tmp42_ = NULL;
			sqlite3_stmt* _tmp43_ = NULL;
			RygelLMSDatabase* _tmp44_ = NULL;
			_tmp35_ = self->priv->_lms_db;
			_tmp36_ = self->priv->_sql_added;
			_tmp37_ = rygel_lms_database_prepare (_tmp35_, _tmp36_, &_inner_error_);
			_tmp34_ = _tmp37_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_sqlite3_finalize0 (stmt_count);
				_sqlite3_finalize0 (_tmp19_);
				_sqlite3_finalize0 (_tmp14_);
				if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
					goto __catch7_rygel_lms_database_error;
				}
				_sqlite3_finalize0 (stmt_count);
				_sqlite3_finalize0 (_tmp19_);
				_sqlite3_finalize0 (_tmp14_);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp38_ = _tmp34_;
			_tmp34_ = NULL;
			_sqlite3_finalize0 (self->stmt_added);
			self->stmt_added = _tmp38_;
			_tmp40_ = self->priv->_lms_db;
			_tmp41_ = self->priv->_sql_removed;
			_tmp42_ = rygel_lms_database_prepare (_tmp40_, _tmp41_, &_inner_error_);
			_tmp39_ = _tmp42_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_sqlite3_finalize0 (_tmp34_);
				_sqlite3_finalize0 (stmt_count);
				_sqlite3_finalize0 (_tmp19_);
				_sqlite3_finalize0 (_tmp14_);
				if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
					goto __catch7_rygel_lms_database_error;
				}
				_sqlite3_finalize0 (_tmp34_);
				_sqlite3_finalize0 (stmt_count);
				_sqlite3_finalize0 (_tmp19_);
				_sqlite3_finalize0 (_tmp14_);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp43_ = _tmp39_;
			_tmp39_ = NULL;
			_sqlite3_finalize0 (self->stmt_removed);
			self->stmt_removed = _tmp43_;
			_tmp44_ = self->priv->_lms_db;
			g_signal_connect_object (_tmp44_, "db-updated", (GCallback) _rygel_lms_category_container_on_db_updated_rygel_lms_database_db_updated, self, 0);
			_sqlite3_finalize0 (_tmp39_);
			_sqlite3_finalize0 (_tmp34_);
		}
		_sqlite3_finalize0 (stmt_count);
		_sqlite3_finalize0 (_tmp19_);
		_sqlite3_finalize0 (_tmp14_);
	}
	goto __finally7;
	__catch7_rygel_lms_database_error:
	{
		GError* e = NULL;
		const gchar* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		GError* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp45_ = rygel_media_object_get_title ((RygelMediaObject*) self);
		_tmp46_ = _tmp45_;
		_tmp47_ = e;
		_tmp48_ = _tmp47_->message;
		g_warning ("rygel-lms-category-container.vala:432: Container %s: %s", _tmp46_, _tmp48_);
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void rygel_lms_category_container_class_init (RygelLMSCategoryContainerClass * klass) {
	rygel_lms_category_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelLMSCategoryContainerPrivate));
	((RygelLMSCategoryContainerClass *) klass)->object_from_statement = rygel_lms_category_container_real_object_from_statement;
	((RygelLMSCategoryContainerClass *) klass)->get_sql_all_with_filter = rygel_lms_category_container_real_get_sql_all_with_filter;
	((RygelLMSCategoryContainerClass *) klass)->get_sql_count_with_filter = rygel_lms_category_container_real_get_sql_count_with_filter;
	((RygelLMSCategoryContainerClass *) klass)->get_child_count_with_filter = rygel_lms_category_container_real_get_child_count_with_filter;
	((RygelLMSCategoryContainerClass *) klass)->get_children_with_filter = rygel_lms_category_container_real_get_children_with_filter;
	((RygelMediaContainerClass *) klass)->get_children = rygel_lms_category_container_real_get_children;
	((RygelMediaContainerClass *) klass)->get_children_finish = rygel_lms_category_container_real_get_children_finish;
	((RygelMediaContainerClass *) klass)->find_object = rygel_lms_category_container_real_find_object;
	((RygelMediaContainerClass *) klass)->find_object_finish = rygel_lms_category_container_real_find_object_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_lms_category_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_lms_category_container_set_property;
	G_OBJECT_CLASS (klass)->constructor = rygel_lms_category_container_constructor;
	G_OBJECT_CLASS (klass)->finalize = rygel_lms_category_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_LMS_CATEGORY_CONTAINER_SEARCH_CLASSES, g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_LMS_CATEGORY_CONTAINER_LMS_DB, rygel_lms_param_spec_database ("lms-db", "lms-db", "lms-db", RYGEL_LMS_TYPE_DATABASE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_LMS_CATEGORY_CONTAINER_DB_ID, g_param_spec_string ("db-id", "db-id", "db-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_LMS_CATEGORY_CONTAINER_SQL_ALL, g_param_spec_string ("sql-all", "sql-all", "sql-all", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_LMS_CATEGORY_CONTAINER_SQL_FIND_OBJECT, g_param_spec_string ("sql-find-object", "sql-find-object", "sql-find-object", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_LMS_CATEGORY_CONTAINER_SQL_COUNT, g_param_spec_string ("sql-count", "sql-count", "sql-count", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_LMS_CATEGORY_CONTAINER_SQL_ADDED, g_param_spec_string ("sql-added", "sql-added", "sql-added", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_LMS_CATEGORY_CONTAINER_SQL_REMOVED, g_param_spec_string ("sql-removed", "sql-removed", "sql-removed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void rygel_lms_category_container_rygel_trackable_container_interface_init (RygelTrackableContainerIface * iface) {
	rygel_lms_category_container_rygel_trackable_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_child = (void (*)(RygelTrackableContainer*, RygelMediaObject*)) rygel_lms_category_container_real_add_child;
	iface->add_child_finish = rygel_lms_category_container_real_add_child_finish;
	iface->remove_child = (void (*)(RygelTrackableContainer*, RygelMediaObject*)) rygel_lms_category_container_real_remove_child;
	iface->remove_child_finish = rygel_lms_category_container_real_remove_child_finish;
}


static void rygel_lms_category_container_rygel_searchable_container_interface_init (RygelSearchableContainerIface * iface) {
	rygel_lms_category_container_rygel_searchable_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (RygelMediaObjects* (*)(RygelSearchableContainer*, RygelSearchExpression*, guint, guint, guint*, const gchar*, GCancellable*, GError**)) rygel_lms_category_container_real_search;
	iface->search_finish = rygel_lms_category_container_real_search_finish;
	iface->get_search_classes = rygel_lms_category_container_real_get_search_classes;
	iface->set_search_classes = rygel_lms_category_container_real_set_search_classes;
}


static void rygel_lms_category_container_instance_init (RygelLMSCategoryContainer * self) {
	self->priv = RYGEL_LMS_CATEGORY_CONTAINER_GET_PRIVATE (self);
}


static void rygel_lms_category_container_finalize (GObject* obj) {
	RygelLMSCategoryContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainer);
	_g_object_unref0 (self->priv->_search_classes);
	_g_free0 (self->priv->_db_id);
	_g_free0 (self->priv->_sql_all);
	_g_free0 (self->priv->_sql_find_object);
	_g_free0 (self->priv->_sql_count);
	_g_free0 (self->priv->_sql_added);
	_g_free0 (self->priv->_sql_removed);
	_sqlite3_finalize0 (self->stmt_all);
	_sqlite3_finalize0 (self->stmt_find_object);
	_sqlite3_finalize0 (self->stmt_added);
	_sqlite3_finalize0 (self->stmt_removed);
	_g_free0 (self->child_prefix);
	_g_free0 (self->ref_prefix);
	G_OBJECT_CLASS (rygel_lms_category_container_parent_class)->finalize (obj);
}


GType rygel_lms_category_container_get_type (void) {
	static volatile gsize rygel_lms_category_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_lms_category_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelLMSCategoryContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_lms_category_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLMSCategoryContainer), 0, (GInstanceInitFunc) rygel_lms_category_container_instance_init, NULL };
		static const GInterfaceInfo rygel_trackable_container_info = { (GInterfaceInitFunc) rygel_lms_category_container_rygel_trackable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo rygel_searchable_container_info = { (GInterfaceInitFunc) rygel_lms_category_container_rygel_searchable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_lms_category_container_type_id;
		rygel_lms_category_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelLMSCategoryContainer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (rygel_lms_category_container_type_id, RYGEL_TYPE_TRACKABLE_CONTAINER, &rygel_trackable_container_info);
		g_type_add_interface_static (rygel_lms_category_container_type_id, RYGEL_TYPE_SEARCHABLE_CONTAINER, &rygel_searchable_container_info);
		g_once_init_leave (&rygel_lms_category_container_type_id__volatile, rygel_lms_category_container_type_id);
	}
	return rygel_lms_category_container_type_id__volatile;
}


static void _vala_rygel_lms_category_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelLMSCategoryContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainer);
	switch (property_id) {
		case RYGEL_LMS_CATEGORY_CONTAINER_SEARCH_CLASSES:
		g_value_set_object (value, rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_LMS_DB:
		rygel_lms_value_set_database (value, rygel_lms_category_container_get_lms_db (self));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_DB_ID:
		g_value_set_string (value, rygel_lms_category_container_get_db_id (self));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_ALL:
		g_value_set_string (value, rygel_lms_category_container_get_sql_all (self));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_FIND_OBJECT:
		g_value_set_string (value, rygel_lms_category_container_get_sql_find_object (self));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_COUNT:
		g_value_set_string (value, rygel_lms_category_container_get_sql_count (self));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_ADDED:
		g_value_set_string (value, rygel_lms_category_container_get_sql_added (self));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_REMOVED:
		g_value_set_string (value, rygel_lms_category_container_get_sql_removed (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_lms_category_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelLMSCategoryContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainer);
	switch (property_id) {
		case RYGEL_LMS_CATEGORY_CONTAINER_SEARCH_CLASSES:
		rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, g_value_get_object (value));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_LMS_DB:
		rygel_lms_category_container_set_lms_db (self, rygel_lms_value_get_database (value));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_DB_ID:
		rygel_lms_category_container_set_db_id (self, g_value_get_string (value));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_ALL:
		rygel_lms_category_container_set_sql_all (self, g_value_get_string (value));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_FIND_OBJECT:
		rygel_lms_category_container_set_sql_find_object (self, g_value_get_string (value));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_COUNT:
		rygel_lms_category_container_set_sql_count (self, g_value_get_string (value));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_ADDED:
		rygel_lms_category_container_set_sql_added (self, g_value_get_string (value));
		break;
		case RYGEL_LMS_CATEGORY_CONTAINER_SQL_REMOVED:
		rygel_lms_category_container_set_sql_removed (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



