/* rygel-media-export-extract.c generated by valac 0.28.0, the Vala compiler
 * generated from rygel-media-export-extract.vala, do not modify */

/*
 * Copyright (C) 2015 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>
#include <gio/gio.h>
#include <libmediaart/mediaart.h>
#include <gst/pbutils/pbutils.h>
#include <libgupnp-dlna/gupnp-dlna.h>
#include <unistd.h>
#include <glib/gi18n-lib.h>
#include <gst/gst.h>
#include <libgupnp-dlna/gupnp-dlna-gst-utils.h>
#include <signal.h>
#include <gio/gunixinputstream.h>
#include <gio/gunixoutputstream.h>


#define TYPE_URI_BUFFER (uri_buffer_get_type ())
typedef struct _UriBuffer UriBuffer;

#define RYGEL_TYPE_INFO_SERIALIZER (rygel_info_serializer_get_type ())
#define RYGEL_INFO_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_INFO_SERIALIZER, RygelInfoSerializer))
#define RYGEL_INFO_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_INFO_SERIALIZER, RygelInfoSerializerClass))
#define RYGEL_IS_INFO_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_INFO_SERIALIZER))
#define RYGEL_IS_INFO_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_INFO_SERIALIZER))
#define RYGEL_INFO_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_INFO_SERIALIZER, RygelInfoSerializerClass))

typedef struct _RygelInfoSerializer RygelInfoSerializer;
typedef struct _RygelInfoSerializerClass RygelInfoSerializerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RunData RunData;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef struct _ProcessMetaDataData ProcessMetaDataData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _ExtractBasicInformationData ExtractBasicInformationData;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

struct _UriBuffer {
	guint8 data[4096];
	gsize length;
};

typedef enum  {
	METADATA_EXTRACTOR_ERROR_GENERAL
} MetadataExtractorError;
#define METADATA_EXTRACTOR_ERROR metadata_extractor_error_quark ()
struct _RunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* line;
	GDataInputStream* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	gchar* data;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** parts;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	GstDiscovererInfo* info;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	UriBuffer _tmp20_;
	UriBuffer _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	const gchar* _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	const gchar* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gboolean is_text;
	gchar** _tmp28_;
	gint _tmp28__length1;
	const gchar* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	GstDiscovererInfo* _tmp34_;
	GstDiscoverer* _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	const gchar* _tmp37_;
	GstDiscovererInfo* _tmp38_;
	GstDiscovererInfo* _tmp39_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	const gchar* _tmp41_;
	gchar** _tmp42_;
	gint _tmp42__length1;
	const gchar* _tmp43_;
	GstDiscovererInfo* _tmp44_;
	GError* _error_;
	const gchar* _tmp45_;
	gchar** _tmp46_;
	gint _tmp46__length1;
	const gchar* _tmp47_;
	GError* _tmp48_;
	const gchar* _tmp49_;
	gchar** _tmp50_;
	gint _tmp50__length1;
	const gchar* _tmp51_;
	GFile* _tmp52_;
	GFile* _tmp53_;
	GError* _tmp54_;
	GstDiscoverer* _tmp55_;
	GstDiscoverer* _tmp56_;
	GstDiscoverer* _tmp57_;
	const gchar* _tmp58_;
	gboolean _tmp59_;
	gchar* command;
	const gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	const gchar* _tmp65_;
	gboolean _tmp66_;
	const gchar* _tmp67_;
	gboolean _tmp68_;
	const gchar* _tmp69_;
	gboolean _tmp70_;
	GError* _vala1__error_;
	const gchar* _tmp71_;
	GError* _tmp72_;
	const gchar* _tmp73_;
	GMainLoop* _tmp74_;
	GError * _inner_error_;
};

struct _ProcessMetaDataData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* uri;
	GstDiscovererInfo* info;
	const gchar* _tmp0_;
	GFile* file;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GstDiscovererInfo* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GstDiscovererInfo* _tmp6_;
	GstDiscovererResult _tmp7_;
	GstDiscovererInfo* _tmp8_;
	GstDiscovererResult _tmp9_;
	GstDiscovererInfo* _tmp10_;
	GstDiscovererResult _tmp11_;
	GstDiscovererInfo* _tmp12_;
	GstDiscovererResult _tmp13_;
	GstDiscovererInfo* _tmp14_;
	const gchar* _tmp15_;
	GFile* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GFile* _tmp19_;
	GUPnPDLNAInformation* dlna_info;
	GstDiscovererInfo* _tmp20_;
	GUPnPDLNAInformation* _tmp21_;
	GUPnPDLNAProfile* dlna;
	GUPnPDLNAProfileGuesser* _tmp22_;
	GUPnPDLNAInformation* _tmp23_;
	GUPnPDLNAProfile* _tmp24_;
	GUPnPDLNAProfile* _tmp25_;
	GFile* _tmp26_;
	GstDiscovererInfo* _tmp27_;
	GUPnPDLNAProfile* _tmp28_;
	GFile* _tmp29_;
};

struct _ExtractBasicInformationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GFile* file;
	GstDiscovererInfo* info;
	GUPnPDLNAProfile* dlna;
	GFileInfo* file_info;
	GFileInfo* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* _tmp2_;
	GFileInfo* _tmp3_;
	GError* _error_;
	gchar* uri;
	GFile* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	GError* _tmp11_;
	GVariant* _tmp12_;
	RygelInfoSerializer* _tmp13_;
	GFile* _tmp14_;
	GFileInfo* _tmp15_;
	GstDiscovererInfo* _tmp16_;
	GUPnPDLNAProfile* _tmp17_;
	GVariant* _tmp18_;
	GFile* _tmp19_;
	GError* _vala1__error_;
	GFile* _tmp20_;
	GError* _tmp21_;
	GError * _inner_error_;
};


extern gint in_fd;
gint in_fd = 0;
extern gint out_fd;
gint out_fd = 1;
extern gint err_fd;
gint err_fd = 2;
extern gboolean metadata;
gboolean metadata = FALSE;
extern GMainLoop* loop;
GMainLoop* loop = NULL;
extern GDataInputStream* input_stream;
GDataInputStream* input_stream = NULL;
extern GOutputStream* output_stream;
GOutputStream* output_stream = NULL;
extern GOutputStream* error_stream;
GOutputStream* error_stream = NULL;
extern RygelInfoSerializer* serializer;
RygelInfoSerializer* serializer = NULL;
extern MediaArtProcess* media_art;
MediaArtProcess* media_art = NULL;
extern GstDiscoverer* discoverer;
GstDiscoverer* discoverer = NULL;
extern GUPnPDLNAProfileGuesser* guesser;
GUPnPDLNAProfileGuesser* guesser = NULL;
extern UriBuffer last_uri;
UriBuffer last_uri = {0};

GType uri_buffer_get_type (void) G_GNUC_CONST;
UriBuffer* uri_buffer_dup (const UriBuffer* self);
void uri_buffer_free (UriBuffer* self);
#define UPNP_CLASS_PHOTO "object.item.imageItem.photo"
#define UPNP_CLASS_MUSIC "object.item.audioItem.musicTrack"
#define UPNP_CLASS_VIDEO "object.item.videoItem"
#define UPNP_CLASS_PLAYLIST "object.item.playlistItem"
#define STATUS_LINE_TEMPLATE "RESULT|%s|%" G_GSIZE_FORMAT "|%s\n"
#define ERROR_LINE_TEMPLATE "ERROR|%s|%d|%s\n"
#define FATAL_ERROR_PREFIX "FATAL_ERROR|"
#define FATAL_ERROR_SUFFIX "\n"
GType rygel_info_serializer_get_type (void) G_GNUC_CONST;
GQuark metadata_extractor_error_quark (void);
void segv_handler (gint signal);
static void run_data_free (gpointer _data);
void run (GAsyncReadyCallback _callback_, gpointer _user_data_);
void run_finish (GAsyncResult* _res_);
static gboolean run_co (RunData* _data_);
static void run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void process_meta_data (const gchar* uri, GstDiscovererInfo* info, GAsyncReadyCallback _callback_, gpointer _user_data_);
void process_meta_data_finish (GAsyncResult* _res_);
void send_error (GFile* file, GError* err);
void send_extraction_done (GFile* file, GVariant* v, GError** error);
static void process_meta_data_data_free (gpointer _data);
static gboolean process_meta_data_co (ProcessMetaDataData* _data_);
void extract_basic_information (GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* dlna, GAsyncReadyCallback _callback_, gpointer _user_data_);
void extract_basic_information_finish (GAsyncResult* _res_);
static void process_meta_data_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void extract_basic_information_data_free (gpointer _data);
static gboolean extract_basic_information_co (ExtractBasicInformationData* _data_);
static void extract_basic_information_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GVariant* rygel_info_serializer_serialize (RygelInfoSerializer* self, GFile* file, GFileInfo* file_info, GstDiscovererInfo* info, GUPnPDLNAProfile* dlna_profile, GError** error);
gint _vala_main (gchar** args, int args_length1);
RygelInfoSerializer* rygel_info_serializer_new (MediaArtProcess* media_art);
RygelInfoSerializer* rygel_info_serializer_construct (GType object_type, MediaArtProcess* media_art);
static void _segv_handler_sighandler_t (gint signal);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[5] = {{"input-fd", 'i', 0, G_OPTION_ARG_INT, &in_fd, "File descriptor used for input", NULL}, {"output-fd", 'o', 0, G_OPTION_ARG_INT, &out_fd, "File descriptor used for output", NULL}, {"error-fd", 'e', 0, G_OPTION_ARG_INT, &err_fd, "File descriptor used for severe errors", NULL}, {"extract-metadata", 'm', 0, G_OPTION_ARG_NONE, &metadata, "Whether to extract all metadata from the files or just basic informati" \
"on", NULL}, {NULL}};

UriBuffer* uri_buffer_dup (const UriBuffer* self) {
	UriBuffer* dup;
	dup = g_new0 (UriBuffer, 1);
	memcpy (dup, self, sizeof (UriBuffer));
	return dup;
}


void uri_buffer_free (UriBuffer* self) {
	g_free (self);
}


GType uri_buffer_get_type (void) {
	static volatile gsize uri_buffer_type_id__volatile = 0;
	if (g_once_init_enter (&uri_buffer_type_id__volatile)) {
		GType uri_buffer_type_id;
		uri_buffer_type_id = g_boxed_type_register_static ("UriBuffer", (GBoxedCopyFunc) uri_buffer_dup, (GBoxedFreeFunc) uri_buffer_free);
		g_once_init_leave (&uri_buffer_type_id__volatile, uri_buffer_type_id);
	}
	return uri_buffer_type_id__volatile;
}


GQuark metadata_extractor_error_quark (void) {
	return g_quark_from_static_string ("metadata_extractor_error-quark");
}


void segv_handler (gint signal) {
	gint _tmp0_ = 0;
	UriBuffer _tmp1_ = {0};
	UriBuffer _tmp2_ = {0};
	gsize _tmp3_ = 0UL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	_tmp0_ = err_fd;
	_tmp1_ = last_uri;
	_tmp2_ = last_uri;
	_tmp3_ = _tmp2_.length;
	write (_tmp0_, (void*) _tmp1_.data, _tmp3_);
	_tmp4_ = err_fd;
	write (_tmp4_, (void*) FATAL_ERROR_SUFFIX, (gsize) 1);
	_tmp5_ = err_fd;
	fsync (_tmp5_);
	exit (-1);
}


static void run_data_free (gpointer _data) {
	RunData* _data_;
	_data_ = _data;
	g_slice_free (RunData, _data_);
}


void run (GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RunData* _data_;
	_data_ = g_slice_new0 (RunData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, run_data_free);
	run_co (_data_);
}


void run_finish (GAsyncResult* _res_) {
	RunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	run_co (_data_);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean bool_parse (const gchar* str) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean run_co (RunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	while (TRUE) {
		{
			_data_->_tmp0_ = NULL;
			_data_->_tmp0_ = input_stream;
			_data_->_state_ = 1;
			g_data_input_stream_read_line_async (_data_->_tmp0_, G_PRIORITY_DEFAULT, NULL, run_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp1_ = NULL;
			_data_->_tmp1_ = g_data_input_stream_read_line_finish (_data_->_tmp0_, _data_->_res_, NULL, &_data_->_inner_error_);
			_data_->line = _data_->_tmp1_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp2_ = NULL;
			_data_->_tmp2_ = _data_->line;
			if (_data_->_tmp2_ == NULL) {
				_g_free0 (_data_->line);
				break;
			}
			_data_->_tmp3_ = NULL;
			_data_->_tmp3_ = _data_->line;
			_data_->_tmp4_ = FALSE;
			_data_->_tmp4_ = g_str_has_prefix (_data_->_tmp3_, "EXTRACT ");
			if (_data_->_tmp4_) {
				_data_->_tmp5_ = NULL;
				_data_->_tmp5_ = _data_->line;
				g_debug ("rygel-media-export-extract.vala:87: Got command to extract file: %s", _data_->_tmp5_);
				_data_->_tmp6_ = NULL;
				_data_->_tmp6_ = _data_->line;
				_data_->_tmp7_ = NULL;
				_data_->_tmp7_ = string_replace (_data_->_tmp6_, "EXTRACT ", "");
				_data_->_tmp8_ = NULL;
				_data_->_tmp8_ = _data_->_tmp7_;
				_data_->_tmp9_ = NULL;
				_data_->_tmp9_ = string_strip (_data_->_tmp8_);
				_data_->_tmp10_ = NULL;
				_data_->_tmp10_ = _data_->_tmp9_;
				_g_free0 (_data_->_tmp8_);
				_data_->data = _data_->_tmp10_;
				_data_->_tmp11_ = NULL;
				_data_->_tmp11_ = _data_->data;
				_data_->_tmp12_ = NULL;
				_data_->_tmp13_ = NULL;
				_data_->_tmp13_ = _data_->_tmp12_ = g_strsplit (_data_->_tmp11_, "|", 0);
				_data_->parts_length1 = 0;
				_data_->_parts_size_ = 0;
				_data_->parts = _data_->_tmp13_;
				_data_->parts_length1 = _vala_array_length (_data_->_tmp12_);
				_data_->_parts_size_ = _data_->parts_length1;
				_data_->_tmp14_ = NULL;
				_data_->_tmp14__length1 = 0;
				_data_->_tmp14_ = _data_->parts;
				_data_->_tmp14__length1 = _data_->parts_length1;
				if (_data_->_tmp14__length1 != 2) {
					_data_->_tmp15_ = NULL;
					_data_->_tmp15_ = _ ("Invalid command received, ignoring");
					g_warning ("rygel-media-export-extract.vala:91: %s", _data_->_tmp15_);
					_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->data);
					_g_free0 (_data_->line);
					continue;
				}
				_data_->info = NULL;
				{
					_data_->_tmp16_ = NULL;
					_data_->_tmp16__length1 = 0;
					_data_->_tmp16_ = _data_->parts;
					_data_->_tmp16__length1 = _data_->parts_length1;
					_data_->_tmp17_ = NULL;
					_data_->_tmp17_ = _data_->_tmp16_[0];
					_data_->_tmp18_ = 0;
					_data_->_tmp18_ = strlen (_data_->_tmp17_);
					_data_->_tmp19_ = 0;
					_data_->_tmp19_ = _data_->_tmp18_;
					last_uri.length = (gsize) _data_->_tmp19_;
					memset (&_data_->_tmp20_, 0, sizeof (UriBuffer));
					_data_->_tmp20_ = last_uri;
					memset (_data_->_tmp20_.data, 0, (gsize) 4096);
					memset (&_data_->_tmp21_, 0, sizeof (UriBuffer));
					_data_->_tmp21_ = last_uri;
					_data_->_tmp22_ = NULL;
					_data_->_tmp22__length1 = 0;
					_data_->_tmp22_ = _data_->parts;
					_data_->_tmp22__length1 = _data_->parts_length1;
					_data_->_tmp23_ = NULL;
					_data_->_tmp23_ = _data_->_tmp22_[0];
					_data_->_tmp24_ = NULL;
					_data_->_tmp24__length1 = 0;
					_data_->_tmp24_ = _data_->parts;
					_data_->_tmp24__length1 = _data_->parts_length1;
					_data_->_tmp25_ = NULL;
					_data_->_tmp25_ = _data_->_tmp24_[0];
					_data_->_tmp26_ = 0;
					_data_->_tmp26_ = strlen (_data_->_tmp25_);
					_data_->_tmp27_ = 0;
					_data_->_tmp27_ = _data_->_tmp26_;
					memcpy (_data_->_tmp21_.data, (void*) _data_->_tmp23_, (gsize) _data_->_tmp27_);
					_data_->_tmp28_ = NULL;
					_data_->_tmp28__length1 = 0;
					_data_->_tmp28_ = _data_->parts;
					_data_->_tmp28__length1 = _data_->parts_length1;
					_data_->_tmp29_ = NULL;
					_data_->_tmp29_ = _data_->_tmp28_[1];
					_data_->_tmp30_ = FALSE;
					_data_->_tmp30_ = g_str_has_prefix (_data_->_tmp29_, "text/");
					_data_->is_text = _data_->_tmp30_;
					_data_->_tmp32_ = FALSE;
					_data_->_tmp32_ = metadata;
					if (_data_->_tmp32_) {
						_data_->_tmp33_ = FALSE;
						_data_->_tmp33_ = _data_->is_text;
						_data_->_tmp31_ = !_data_->_tmp33_;
					} else {
						_data_->_tmp31_ = FALSE;
					}
					if (_data_->_tmp31_) {
						_data_->_tmp35_ = NULL;
						_data_->_tmp35_ = discoverer;
						_data_->_tmp36_ = NULL;
						_data_->_tmp36__length1 = 0;
						_data_->_tmp36_ = _data_->parts;
						_data_->_tmp36__length1 = _data_->parts_length1;
						_data_->_tmp37_ = NULL;
						_data_->_tmp37_ = _data_->_tmp36_[0];
						_data_->_tmp38_ = NULL;
						_data_->_tmp38_ = gst_discoverer_discover_uri (_data_->_tmp35_, _data_->_tmp37_, &_data_->_inner_error_);
						_data_->_tmp34_ = _data_->_tmp38_;
						if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
							goto __catch2_g_error;
						}
						_data_->_tmp39_ = NULL;
						_data_->_tmp39_ = _data_->_tmp34_;
						_data_->_tmp34_ = NULL;
						_g_object_unref0 (_data_->info);
						_data_->info = _data_->_tmp39_;
						_data_->_tmp40_ = NULL;
						_data_->_tmp40__length1 = 0;
						_data_->_tmp40_ = _data_->parts;
						_data_->_tmp40__length1 = _data_->parts_length1;
						_data_->_tmp41_ = NULL;
						_data_->_tmp41_ = _data_->_tmp40_[0];
						g_debug ("rygel-media-export-extract.vala:108: Finished discover on URI %s", _data_->_tmp41_);
						_g_object_unref0 (_data_->_tmp34_);
					}
					_data_->_tmp42_ = NULL;
					_data_->_tmp42__length1 = 0;
					_data_->_tmp42_ = _data_->parts;
					_data_->_tmp42__length1 = _data_->parts_length1;
					_data_->_tmp43_ = NULL;
					_data_->_tmp43_ = _data_->_tmp42_[0];
					_data_->_tmp44_ = NULL;
					_data_->_tmp44_ = _data_->info;
					_data_->_state_ = 2;
					process_meta_data (_data_->_tmp43_, _data_->_tmp44_, run_ready, _data_);
					return FALSE;
					_state_2:
					process_meta_data_finish (_data_->_res_);
				}
				goto __finally2;
				__catch2_g_error:
				{
					_data_->_error_ = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_data_->_tmp45_ = NULL;
					_data_->_tmp45_ = _ ("Failed to discover URI %s: %s");
					_data_->_tmp46_ = NULL;
					_data_->_tmp46__length1 = 0;
					_data_->_tmp46_ = _data_->parts;
					_data_->_tmp46__length1 = _data_->parts_length1;
					_data_->_tmp47_ = NULL;
					_data_->_tmp47_ = _data_->_tmp46_[0];
					_data_->_tmp48_ = NULL;
					_data_->_tmp48_ = _data_->_error_;
					_data_->_tmp49_ = NULL;
					_data_->_tmp49_ = _data_->_tmp48_->message;
					g_warning (_data_->_tmp45_, _data_->_tmp47_, _data_->_tmp49_);
					_data_->_tmp50_ = NULL;
					_data_->_tmp50__length1 = 0;
					_data_->_tmp50_ = _data_->parts;
					_data_->_tmp50__length1 = _data_->parts_length1;
					_data_->_tmp51_ = NULL;
					_data_->_tmp51_ = _data_->_tmp50_[0];
					_data_->_tmp52_ = NULL;
					_data_->_tmp52_ = g_file_new_for_uri (_data_->_tmp51_);
					_data_->_tmp53_ = NULL;
					_data_->_tmp53_ = _data_->_tmp52_;
					_data_->_tmp54_ = NULL;
					_data_->_tmp54_ = _data_->_error_;
					send_error (_data_->_tmp53_, _data_->_tmp54_);
					_g_object_unref0 (_data_->_tmp53_);
					_data_->_tmp56_ = NULL;
					_data_->_tmp56_ = gst_discoverer_new ((GstClockTime) (10 * GST_SECOND), &_data_->_inner_error_);
					_data_->_tmp55_ = _data_->_tmp56_;
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						_g_error_free0 (_data_->_error_);
						goto __finally2;
					}
					_data_->_tmp57_ = NULL;
					_data_->_tmp57_ = _data_->_tmp55_;
					_data_->_tmp55_ = NULL;
					_g_object_unref0 (discoverer);
					discoverer = _data_->_tmp57_;
					_g_object_unref0 (_data_->_tmp55_);
					_g_error_free0 (_data_->_error_);
				}
				__finally2:
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->info);
					_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->data);
					_g_free0 (_data_->line);
					goto __catch0_g_error;
				}
				_g_object_unref0 (_data_->info);
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->data);
			} else {
				_data_->_tmp58_ = NULL;
				_data_->_tmp58_ = _data_->line;
				_data_->_tmp59_ = FALSE;
				_data_->_tmp59_ = g_str_has_prefix (_data_->_tmp58_, "METADATA ");
				if (_data_->_tmp59_) {
					_data_->_tmp60_ = NULL;
					_data_->_tmp60_ = _data_->line;
					_data_->_tmp61_ = NULL;
					_data_->_tmp61_ = string_replace (_data_->_tmp60_, "METADATA ", "");
					_data_->_tmp62_ = NULL;
					_data_->_tmp62_ = _data_->_tmp61_;
					_data_->_tmp63_ = NULL;
					_data_->_tmp63_ = string_strip (_data_->_tmp62_);
					_data_->_tmp64_ = NULL;
					_data_->_tmp64_ = _data_->_tmp63_;
					_g_free0 (_data_->_tmp62_);
					_data_->command = _data_->_tmp64_;
					_data_->_tmp65_ = NULL;
					_data_->_tmp65_ = _data_->command;
					_data_->_tmp66_ = FALSE;
					_data_->_tmp66_ = bool_parse (_data_->_tmp65_);
					metadata = _data_->_tmp66_;
					_data_->_tmp68_ = FALSE;
					_data_->_tmp68_ = metadata;
					if (_data_->_tmp68_) {
						_data_->_tmp67_ = "enabled";
					} else {
						_data_->_tmp67_ = "disabled";
					}
					g_debug ("rygel-media-export-extract.vala:124: Meta-data extraction was %s", _data_->_tmp67_);
					_g_free0 (_data_->command);
				} else {
					_data_->_tmp69_ = NULL;
					_data_->_tmp69_ = _data_->line;
					_data_->_tmp70_ = FALSE;
					_data_->_tmp70_ = g_str_has_prefix (_data_->_tmp69_, "QUIT");
					if (_data_->_tmp70_) {
						_g_free0 (_data_->line);
						break;
					}
				}
			}
			_g_free0 (_data_->line);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->_vala1__error_ = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp71_ = NULL;
			_data_->_tmp71_ = _ ("Failed to read from pipe: %s");
			_data_->_tmp72_ = NULL;
			_data_->_tmp72_ = _data_->_vala1__error_;
			_data_->_tmp73_ = NULL;
			_data_->_tmp73_ = _data_->_tmp72_->message;
			g_warning (_data_->_tmp71_, _data_->_tmp73_);
			_g_error_free0 (_data_->_vala1__error_);
			break;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp74_ = NULL;
	_data_->_tmp74_ = loop;
	g_main_loop_quit (_data_->_tmp74_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


void send_extraction_done (GFile* file, GVariant* v, GError** error) {
	GBytes* data = NULL;
	GVariant* _tmp0_ = NULL;
	GBytes* _tmp1_ = NULL;
	gsize bytes_written = 0UL;
	gchar* status = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GBytes* _tmp5_ = NULL;
	gsize _tmp6_ = 0UL;
	GFile* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GOutputStream* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	guint8* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	guint8* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gsize _tmp16_ = 0UL;
	GOutputStream* _tmp17_ = NULL;
	GBytes* _tmp18_ = NULL;
	gsize _tmp19_;
	guint8* _tmp20_ = NULL;
	gsize _tmp21_ = 0UL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (file != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	_tmp1_ = g_variant_get_data_as_bytes (_tmp0_);
	data = _tmp1_;
	bytes_written = (gsize) 0;
	_tmp2_ = file;
	_tmp3_ = g_file_get_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = data;
	_tmp6_ = g_bytes_get_size (_tmp5_);
	_tmp7_ = file;
	_tmp8_ = g_file_get_uri (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf (STATUS_LINE_TEMPLATE, _tmp4_, _tmp6_, _tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp4_);
	status = _tmp11_;
	_tmp12_ = output_stream;
	_tmp13_ = status;
	_tmp14_ = string_get_data (_tmp13_, &_tmp14__length1);
	_tmp15_ = _tmp14_;
	_tmp15__length1 = _tmp14__length1;
	g_output_stream_write_all (_tmp12_, _tmp15_, (gsize) _tmp15__length1, &_tmp16_, NULL, &_inner_error_);
	bytes_written = _tmp16_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (status);
		_g_bytes_unref0 (data);
		return;
	}
	_tmp17_ = output_stream;
	_tmp18_ = data;
	_tmp20_ = g_bytes_get_data (_tmp18_, &_tmp19_);
	g_output_stream_write_all (_tmp17_, _tmp20_, (gsize) _tmp19_, &_tmp21_, NULL, &_inner_error_);
	bytes_written = _tmp21_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (status);
		_g_bytes_unref0 (data);
		return;
	}
	_g_free0 (status);
	_g_bytes_unref0 (data);
}


void send_error (GFile* file, GError* err) {
	gsize bytes_written = 0UL;
	gchar* status = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GError* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GError* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (file != NULL);
	bytes_written = (gsize) 0;
	_tmp0_ = file;
	_tmp1_ = g_file_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = err;
	_tmp4_ = _tmp3_->code;
	_tmp5_ = err;
	_tmp6_ = _tmp5_->message;
	_tmp7_ = g_strdup_printf (ERROR_LINE_TEMPLATE, _tmp2_, _tmp4_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp2_);
	status = _tmp8_;
	{
		GOutputStream* _tmp9_ = NULL;
		guint8* _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		guint8* _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gsize _tmp12_ = 0UL;
		_tmp9_ = output_stream;
		_tmp10_ = string_get_data (status, &_tmp10__length1);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = _tmp10__length1;
		g_output_stream_write_all (_tmp9_, _tmp11_, (gsize) _tmp11__length1, &_tmp12_, NULL, &_inner_error_);
		bytes_written = _tmp12_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = _ ("Failed to send error to parent: %s");
		_tmp14_ = _error_;
		_tmp15_ = _tmp14_->message;
		g_warning (_tmp13_, _tmp15_);
		_g_error_free0 (_error_);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (status);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (status);
}


static void process_meta_data_data_free (gpointer _data) {
	ProcessMetaDataData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_object_unref0 (_data_->info);
	g_slice_free (ProcessMetaDataData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void process_meta_data (const gchar* uri, GstDiscovererInfo* info, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ProcessMetaDataData* _data_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GstDiscovererInfo* _tmp2_ = NULL;
	GstDiscovererInfo* _tmp3_ = NULL;
	_data_ = g_slice_new0 (ProcessMetaDataData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, process_meta_data);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, process_meta_data_data_free);
	_tmp0_ = uri;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	_tmp2_ = info;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->info);
	_data_->info = _tmp3_;
	process_meta_data_co (_data_);
}


void process_meta_data_finish (GAsyncResult* _res_) {
	ProcessMetaDataData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void process_meta_data_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ProcessMetaDataData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	process_meta_data_co (_data_);
}


static gboolean process_meta_data_co (ProcessMetaDataData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->uri;
	g_debug ("rygel-media-export-extract.vala:163: Discovered %s", _data_->_tmp0_);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->uri;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_file_new_for_uri (_data_->_tmp1_);
	_data_->file = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->info;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->info;
		_data_->_tmp7_ = 0;
		_data_->_tmp7_ = gst_discoverer_info_get_result (_data_->_tmp6_);
		if (_data_->_tmp7_ == GST_DISCOVERER_TIMEOUT) {
			_data_->_tmp5_ = TRUE;
		} else {
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _data_->info;
			_data_->_tmp9_ = 0;
			_data_->_tmp9_ = gst_discoverer_info_get_result (_data_->_tmp8_);
			_data_->_tmp5_ = _data_->_tmp9_ == GST_DISCOVERER_BUSY;
		}
		if (_data_->_tmp5_) {
			_data_->_tmp4_ = TRUE;
		} else {
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = _data_->info;
			_data_->_tmp11_ = 0;
			_data_->_tmp11_ = gst_discoverer_info_get_result (_data_->_tmp10_);
			_data_->_tmp4_ = _data_->_tmp11_ == GST_DISCOVERER_MISSING_PLUGINS;
		}
		if (_data_->_tmp4_) {
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->info;
			_data_->_tmp13_ = 0;
			_data_->_tmp13_ = gst_discoverer_info_get_result (_data_->_tmp12_);
			if (_data_->_tmp13_ == GST_DISCOVERER_MISSING_PLUGINS) {
				_data_->_tmp14_ = NULL;
				_data_->_tmp14_ = _data_->info;
				_data_->_tmp15_ = NULL;
				_data_->_tmp15_ = gst_discoverer_info_get_uri (_data_->_tmp14_);
				g_debug ("rygel-media-export-extract.vala:170: Plugins are missing for extractio" \
"n of file %s", _data_->_tmp15_);
			} else {
				_data_->_tmp16_ = NULL;
				_data_->_tmp16_ = _data_->file;
				_data_->_tmp17_ = NULL;
				_data_->_tmp17_ = g_file_get_uri (_data_->_tmp16_);
				_data_->_tmp18_ = NULL;
				_data_->_tmp18_ = _data_->_tmp17_;
				g_debug ("rygel-media-export-extract.vala:173: Extraction timed out on %s", _data_->_tmp18_);
				_g_free0 (_data_->_tmp18_);
			}
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->file;
			_data_->_state_ = 1;
			extract_basic_information (_data_->_tmp19_, NULL, NULL, process_meta_data_ready, _data_);
			return FALSE;
			_state_1:
			extract_basic_information_finish (_data_->_res_);
			_g_object_unref0 (_data_->file);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->info;
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = gupnp_dlna_gst_utils_information_from_discoverer_info (_data_->_tmp20_);
		_data_->dlna_info = _data_->_tmp21_;
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = guesser;
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->dlna_info;
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = gupnp_dlna_profile_guesser_guess_profile_from_info (_data_->_tmp22_, _data_->_tmp23_);
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _g_object_ref0 (_data_->_tmp24_);
		_data_->dlna = _data_->_tmp25_;
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->file;
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->info;
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _data_->dlna;
		_data_->_state_ = 2;
		extract_basic_information (_data_->_tmp26_, _data_->_tmp27_, _data_->_tmp28_, process_meta_data_ready, _data_);
		return FALSE;
		_state_2:
		extract_basic_information_finish (_data_->_res_);
		_g_object_unref0 (_data_->dlna);
		_g_object_unref0 (_data_->dlna_info);
	} else {
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = _data_->file;
		_data_->_state_ = 3;
		extract_basic_information (_data_->_tmp29_, NULL, NULL, process_meta_data_ready, _data_);
		return FALSE;
		_state_3:
		extract_basic_information_finish (_data_->_res_);
	}
	_g_object_unref0 (_data_->file);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void extract_basic_information_data_free (gpointer _data) {
	ExtractBasicInformationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->info);
	_g_object_unref0 (_data_->dlna);
	g_slice_free (ExtractBasicInformationData, _data_);
}


void extract_basic_information (GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* dlna, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ExtractBasicInformationData* _data_;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GstDiscovererInfo* _tmp2_ = NULL;
	GstDiscovererInfo* _tmp3_ = NULL;
	GUPnPDLNAProfile* _tmp4_ = NULL;
	GUPnPDLNAProfile* _tmp5_ = NULL;
	_data_ = g_slice_new0 (ExtractBasicInformationData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, extract_basic_information);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, extract_basic_information_data_free);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	_tmp2_ = info;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->info);
	_data_->info = _tmp3_;
	_tmp4_ = dlna;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (_data_->dlna);
	_data_->dlna = _tmp5_;
	extract_basic_information_co (_data_);
}


void extract_basic_information_finish (GAsyncResult* _res_) {
	ExtractBasicInformationData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void extract_basic_information_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ExtractBasicInformationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	extract_basic_information_co (_data_);
}


static gboolean extract_basic_information_co (ExtractBasicInformationData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->file;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->_tmp1_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, extract_basic_information_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = g_file_query_info_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp0_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->file_info);
		_data_->file_info = _data_->_tmp3_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->file;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = g_file_get_uri (_data_->_tmp4_);
		_data_->uri = _data_->_tmp5_;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _ ("Failed to extract basic metadata from %s: %s");
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->uri;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->_error_;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		g_warning (_data_->_tmp6_, _data_->_tmp7_, _data_->_tmp9_);
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->file;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->_error_;
		send_error (_data_->_tmp10_, _data_->_tmp11_);
		_g_free0 (_data_->uri);
		_g_error_free0 (_data_->_error_);
		_g_object_unref0 (_data_->file_info);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally4:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->file_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	{
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = serializer;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->file;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->file_info;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->info;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->dlna;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = rygel_info_serializer_serialize (_data_->_tmp13_, _data_->_tmp14_, _data_->_tmp15_, _data_->_tmp16_, _data_->_tmp17_, &_data_->_inner_error_);
		_data_->_tmp12_ = _data_->_tmp18_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->file;
		send_extraction_done (_data_->_tmp19_, _data_->_tmp12_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_variant_unref0 (_data_->_tmp12_);
			goto __catch5_g_error;
		}
		_g_variant_unref0 (_data_->_tmp12_);
	}
	goto __finally5;
	__catch5_g_error:
	{
		_data_->_vala1__error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->file;
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->_vala1__error_;
		send_error (_data_->_tmp20_, _data_->_tmp21_);
		_g_error_free0 (_data_->_vala1__error_);
	}
	__finally5:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->file_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (_data_->file_info);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _segv_handler_sighandler_t (gint signal) {
	segv_handler (signal);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* ctx = NULL;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionGroup* _tmp4_ = NULL;
	MediaArtProcess* _tmp15_ = NULL;
	RygelInfoSerializer* _tmp16_ = NULL;
	struct sigaction action = {0};
	struct sigaction _tmp17_ = {0};
	struct sigaction _tmp18_ = {0};
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	GUnixInputStream* _tmp23_ = NULL;
	GUnixInputStream* _tmp24_ = NULL;
	GDataInputStream* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	GUnixOutputStream* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	GUnixOutputStream* _tmp29_ = NULL;
	GMainLoop* _tmp30_ = NULL;
	GUPnPDLNAProfileGuesser* _tmp37_ = NULL;
	GMainLoop* _tmp38_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = _ ("- helper binary for Rygel to extract metadata");
	_tmp1_ = g_option_context_new (_tmp0_);
	ctx = _tmp1_;
	_tmp2_ = ctx;
	g_option_context_add_main_entries (_tmp2_, options, NULL);
	_tmp3_ = ctx;
	_tmp4_ = gst_init_get_option_group ();
	g_option_context_add_group (_tmp3_, _tmp4_);
	{
		GOptionContext* _tmp5_ = NULL;
		_tmp5_ = ctx;
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = _ ("Failed to parse commandline args: %s");
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_warning (_tmp6_, _tmp8_);
		result = EXIT_FAILURE;
		_g_error_free0 (_error_);
		_g_option_context_free0 (ctx);
		return result;
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (ctx);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	{
		MediaArtProcess* _tmp9_ = NULL;
		MediaArtProcess* _tmp10_ = NULL;
		MediaArtProcess* _tmp11_ = NULL;
		_tmp10_ = media_art_process_new (&_inner_error_);
		_tmp9_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
		_tmp11_ = _tmp9_;
		_tmp9_ = NULL;
		_g_object_unref0 (media_art);
		media_art = _tmp11_;
		_g_object_unref0 (_tmp9_);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = _ ("Failed to create media art extractor: %s");
		_tmp13_ = _error_;
		_tmp14_ = _tmp13_->message;
		g_warning (_tmp12_, _tmp14_);
		_g_error_free0 (_error_);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (ctx);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp15_ = media_art;
	_tmp16_ = rygel_info_serializer_new (_tmp15_);
	_g_object_unref0 (serializer);
	serializer = _tmp16_;
	nice (19);
	memset (&action, 0, sizeof (struct sigaction));
	action.sa_handler = _segv_handler_sighandler_t;
	_tmp17_ = action;
	sigaction (SIGSEGV, &_tmp17_, NULL);
	_tmp18_ = action;
	sigaction (SIGABRT, &_tmp18_, NULL);
	_tmp19_ = in_fd;
	_tmp20_ = out_fd;
	_tmp21_ = err_fd;
	g_message ("rygel-media-export-extract.vala:248: Started with descriptors %d %d %d", _tmp19_, _tmp20_, _tmp21_);
	_tmp22_ = in_fd;
	_tmp23_ = (GUnixInputStream*) g_unix_input_stream_new (_tmp22_, TRUE);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_data_input_stream_new ((GInputStream*) _tmp24_);
	_g_object_unref0 (input_stream);
	input_stream = _tmp25_;
	_g_object_unref0 (_tmp24_);
	_tmp26_ = out_fd;
	_tmp27_ = (GUnixOutputStream*) g_unix_output_stream_new (_tmp26_, TRUE);
	_g_object_unref0 (output_stream);
	output_stream = (GOutputStream*) _tmp27_;
	_tmp28_ = err_fd;
	_tmp29_ = (GUnixOutputStream*) g_unix_output_stream_new (_tmp28_, TRUE);
	_g_object_unref0 (error_stream);
	error_stream = (GOutputStream*) _tmp29_;
	_tmp30_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (loop);
	loop = _tmp30_;
	{
		GstDiscoverer* _tmp31_ = NULL;
		GstDiscoverer* _tmp32_ = NULL;
		GstDiscoverer* _tmp33_ = NULL;
		_tmp32_ = gst_discoverer_new ((GstClockTime) (10 * GST_SECOND), &_inner_error_);
		_tmp31_ = _tmp32_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
		_tmp33_ = _tmp31_;
		_tmp31_ = NULL;
		_g_object_unref0 (discoverer);
		discoverer = _tmp33_;
		_g_object_unref0 (_tmp31_);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp34_ = NULL;
		GError* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp34_ = _ ("Failed to start metadata discoverer: %s");
		_tmp35_ = _error_;
		_tmp36_ = _tmp35_->message;
		g_warning (_tmp34_, _tmp36_);
		_g_error_free0 (_error_);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (ctx);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp37_ = gupnp_dlna_profile_guesser_new (TRUE, TRUE);
	_g_object_unref0 (guesser);
	guesser = _tmp37_;
	run (NULL, NULL);
	_tmp38_ = loop;
	g_main_loop_run (_tmp38_);
	result = 0;
	_g_option_context_free0 (ctx);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



