/* game.c generated by valac 0.28.0.14-080be, the Vala compiler
 * generated from game.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
typedef struct _TilePrivate TilePrivate;

#define TYPE_SLOT (slot_get_type ())
#define SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLOT, Slot))
#define SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLOT, SlotClass))
#define IS_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLOT))
#define IS_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLOT))
#define SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLOT, SlotClass))

typedef struct _Slot Slot;
typedef struct _SlotClass SlotClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MATCH (match_get_type ())
#define MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATCH, Match))
#define MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATCH, MatchClass))
#define IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATCH))
#define IS_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATCH))
#define MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATCH, MatchClass))

typedef struct _Match Match;
typedef struct _MatchClass MatchClass;
typedef struct _MatchPrivate MatchPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;

#define TYPE_MAP (map_get_type ())
#define MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP, Map))
#define MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP, MapClass))
#define IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP))
#define IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP))
#define MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP, MapClass))

typedef struct _Map Map;
typedef struct _MapClass MapClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _MapPrivate MapPrivate;
typedef struct _SlotPrivate SlotPrivate;

struct _Tile {
	GObject parent_instance;
	TilePrivate * priv;
	gint number;
	Slot* slot;
	gboolean visible;
	gint move_number;
};

struct _TileClass {
	GObjectClass parent_class;
};

struct _Match {
	GObject parent_instance;
	MatchPrivate * priv;
	Tile* tile0;
	Tile* tile1;
};

struct _MatchClass {
	GObjectClass parent_class;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Map* map;
	GList* tiles;
	Tile* hint_tiles[2];
	gint move_number;
	guint hint_blink_counter;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GamePrivate {
	guint hint_timout;
	gdouble clock_elapsed;
	GTimer* clock;
	guint clock_timeout;
	gboolean _paused;
	Tile* _selected_tile;
};

struct _Map {
	GObject parent_instance;
	MapPrivate * priv;
	gchar* name;
	gchar* score_name;
	GList* slots;
};

struct _MapClass {
	GObjectClass parent_class;
};

struct _Slot {
	GObject parent_instance;
	SlotPrivate * priv;
	gint x;
	gint y;
	gint layer;
};

struct _SlotClass {
	GObjectClass parent_class;
};


static gpointer tile_parent_class = NULL;
static gpointer match_parent_class = NULL;
static gpointer game_parent_class = NULL;

GType tile_get_type (void) G_GNUC_CONST;
GType slot_get_type (void) G_GNUC_CONST;
enum  {
	TILE_DUMMY_PROPERTY,
	TILE_SET
};
Tile* tile_new (Slot* slot);
Tile* tile_construct (GType object_type, Slot* slot);
gboolean tile_matches (Tile* self, Tile* tile);
gint tile_get_set (Tile* self);
static void tile_finalize (GObject* obj);
static void _vala_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
gint compare_tiles (Tile* a, Tile* b);
gint compare_slots (Slot* a, Slot* b);
gboolean switch_tiles (Tile* a, Tile* b);
GType match_get_type (void) G_GNUC_CONST;
enum  {
	MATCH_DUMMY_PROPERTY
};
Match* match_new (Tile* tile0, Tile* tile1);
Match* match_construct (GType object_type, Tile* tile0, Tile* tile1);
static void match_finalize (GObject* obj);
GType game_get_type (void) G_GNUC_CONST;
GType map_get_type (void) G_GNUC_CONST;
#define GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME, GamePrivate))
enum  {
	GAME_DUMMY_PROPERTY,
	GAME_STARTED,
	GAME_ELAPSED,
	GAME_PAUSED,
	GAME_SELECTED_TILE,
	GAME_VISIBLE_TILES,
	GAME_MOVES_LEFT,
	GAME_COMPLETE,
	GAME_CAN_MOVE,
	GAME_CAN_UNDO,
	GAME_CAN_REDO
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
Game* game_new (Map* map);
Game* game_construct (GType object_type, Map* map);
static gint _compare_tiles_gcompare_func (gconstpointer a, gconstpointer b);
static gboolean game_shuffle (Game* self, gint* numbers, int numbers_length1, gint depth);
void game_reset (Game* self);
void game_shuffle_remaining (Game* self, gboolean redraw);
gboolean game_get_can_move (Game* self);
gint game_get_visible_tiles (Game* self);
GList* game_find_matches (Game* self, Tile* tile);
void game_redraw_all_tiles (Game* self);
static void game_reset_clock (Game* self);
void game_set_selected_tile (Game* self, Tile* value);
void game_set_hint (Game* self, Tile* tile0, Tile* tile1);
static gboolean game_hint_timeout_cb (Game* self);
static gboolean _game_hint_timeout_cb_gsource_func (gpointer self);
static void game_start_clock (Game* self);
gboolean game_tile_can_move (Game* self, Tile* tile);
gint game_number_of_movable_tiles (Game* self);
gboolean game_remove_pair (Game* self, Tile* tile0, Tile* tile1);
gboolean game_get_complete (Game* self);
static void game_stop_clock (Game* self);
static gboolean game_timeout_cb (Game* self);
static void game_continue_clock (Game* self);
static gboolean _game_timeout_cb_gsource_func (gpointer self);
void game_undo (Game* self);
gboolean game_get_can_undo (Game* self);
void game_redo (Game* self);
gboolean game_get_can_redo (Game* self);
gboolean game_get_started (Game* self);
gdouble game_get_elapsed (Game* self);
gboolean game_get_paused (Game* self);
void game_set_paused (Game* self, gboolean value);
Tile* game_get_selected_tile (Game* self);
guint game_get_moves_left (Game* self);
static void game_finalize (GObject* obj);
static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return self ? g_object_ref (self) : NULL;
#line 241 "game.c"
}


Tile* tile_construct (GType object_type, Slot* slot) {
	Tile * self = NULL;
	Slot* _tmp0_ = NULL;
	Slot* _tmp1_ = NULL;
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (slot != NULL, NULL);
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self = (Tile*) g_object_new (object_type, NULL);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = slot;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_g_object_unref0 (self->slot);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->slot = _tmp1_;
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return self;
#line 263 "game.c"
}


Tile* tile_new (Slot* slot) {
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return tile_construct (TYPE_TILE, slot);
#line 270 "game.c"
}


gboolean tile_matches (Tile* self, Tile* tile) {
	gboolean result = FALSE;
	Tile* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (tile != NULL, FALSE);
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = tile;
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp1_ = tile_get_set (_tmp0_);
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp2_ = _tmp1_;
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp3_ = tile_get_set (self);
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp4_ = _tmp3_;
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = _tmp2_ == _tmp4_;
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 299 "game.c"
}


gint tile_get_set (Tile* self) {
	gint result;
	gint _tmp0_ = 0;
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = self->number;
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = _tmp0_ / 4;
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 314 "game.c"
}


static void tile_class_init (TileClass * klass) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	tile_parent_class = g_type_class_peek_parent (klass);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tile_get_property;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	G_OBJECT_CLASS (klass)->finalize = tile_finalize;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TILE_SET, g_param_spec_int ("set", "set", "set", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 327 "game.c"
}


static void tile_instance_init (Tile * self) {
#line 15 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->visible = TRUE;
#line 334 "game.c"
}


static void tile_finalize (GObject* obj) {
	Tile * self;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TILE, Tile);
#line 14 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_g_object_unref0 (self->slot);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	G_OBJECT_CLASS (tile_parent_class)->finalize (obj);
#line 346 "game.c"
}


GType tile_get_type (void) {
	static volatile gsize tile_type_id__volatile = 0;
	if (g_once_init_enter (&tile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Tile), 0, (GInstanceInitFunc) tile_instance_init, NULL };
		GType tile_type_id;
		tile_type_id = g_type_register_static (G_TYPE_OBJECT, "Tile", &g_define_type_info, 0);
		g_once_init_leave (&tile_type_id__volatile, tile_type_id);
	}
	return tile_type_id__volatile;
}


static void _vala_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Tile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TILE, Tile);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	switch (property_id) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		case TILE_SET:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_value_set_int (value, tile_get_set (self));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		break;
#line 373 "game.c"
		default:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		break;
#line 379 "game.c"
	}
}


gint compare_tiles (Tile* a, Tile* b) {
	gint result = 0;
	Tile* _tmp0_ = NULL;
	Slot* _tmp1_ = NULL;
	Tile* _tmp2_ = NULL;
	Slot* _tmp3_ = NULL;
	gint _tmp4_ = 0;
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = a;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp1_ = _tmp0_->slot;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp2_ = b;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp3_ = _tmp2_->slot;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp4_ = compare_slots (_tmp1_, _tmp3_);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = _tmp4_;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 409 "game.c"
}


gboolean switch_tiles (Tile* a, Tile* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Tile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp1_ = a;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp2_ = _tmp1_->visible;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp2_) {
#line 428 "game.c"
		Tile* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp3_ = b;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp4_ = _tmp3_->visible;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp0_ = _tmp4_;
#line 437 "game.c"
	} else {
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp0_ = FALSE;
#line 441 "game.c"
	}
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp0_) {
#line 445 "game.c"
		Slot* h = NULL;
		Tile* _tmp5_ = NULL;
		Slot* _tmp6_ = NULL;
		Slot* _tmp7_ = NULL;
		Tile* _tmp8_ = NULL;
		Tile* _tmp9_ = NULL;
		Slot* _tmp10_ = NULL;
		Slot* _tmp11_ = NULL;
		Tile* _tmp12_ = NULL;
		Slot* _tmp13_ = NULL;
		Slot* _tmp14_ = NULL;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp5_ = a;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp6_ = _tmp5_->slot;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		h = _tmp7_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp8_ = a;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp9_ = b;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp10_ = _tmp9_->slot;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp11_ = _g_object_ref0 (_tmp10_);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_g_object_unref0 (_tmp8_->slot);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp8_->slot = _tmp11_;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp12_ = b;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp13_ = h;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp14_ = _g_object_ref0 (_tmp13_);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_g_object_unref0 (_tmp12_->slot);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp12_->slot = _tmp14_;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		result = TRUE;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_g_object_unref0 (h);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		return result;
#line 493 "game.c"
	}
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = FALSE;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 499 "game.c"
}


Match* match_construct (GType object_type, Tile* tile0, Tile* tile1) {
	Match * self = NULL;
	Tile* _tmp0_ = NULL;
	Tile* _tmp1_ = NULL;
	Tile* _tmp2_ = NULL;
	Tile* _tmp3_ = NULL;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (tile0 != NULL, NULL);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (tile1 != NULL, NULL);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self = (Match*) g_object_new (object_type, NULL);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = tile0;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_g_object_unref0 (self->tile0);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->tile0 = _tmp1_;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp2_ = tile1;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_g_object_unref0 (self->tile1);
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->tile1 = _tmp3_;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return self;
#line 533 "game.c"
}


Match* match_new (Tile* tile0, Tile* tile1) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return match_construct (TYPE_MATCH, tile0, tile1);
#line 540 "game.c"
}


static void match_class_init (MatchClass * klass) {
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	match_parent_class = g_type_class_peek_parent (klass);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	G_OBJECT_CLASS (klass)->finalize = match_finalize;
#line 549 "game.c"
}


static void match_instance_init (Match * self) {
}


static void match_finalize (GObject* obj) {
	Match * self;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATCH, Match);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_g_object_unref0 (self->tile0);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_g_object_unref0 (self->tile1);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	G_OBJECT_CLASS (match_parent_class)->finalize (obj);
#line 567 "game.c"
}


GType match_get_type (void) {
	static volatile gsize match_type_id__volatile = 0;
	if (g_once_init_enter (&match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Match), 0, (GInstanceInitFunc) match_instance_init, NULL };
		GType match_type_id;
		match_type_id = g_type_register_static (G_TYPE_OBJECT, "Match", &g_define_type_info, 0);
		g_once_init_leave (&match_type_id__volatile, match_type_id);
	}
	return match_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 586 "game.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_list_free (self);
#line 595 "game.c"
}


static gint _compare_tiles_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = compare_tiles ((Tile*) a, (Tile*) b);
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 604 "game.c"
}


Game* game_construct (GType object_type, Map* map) {
	Game * self = NULL;
	Map* _tmp0_ = NULL;
	Map* _tmp1_ = NULL;
	Map* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	gint n_pairs = 0;
	GList* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	gint* numbers = NULL;
	gint _tmp12_ = 0;
	gint* _tmp13_ = NULL;
	gint numbers_length1 = 0;
	gint _numbers_size_ = 0;
	gint* _tmp42_ = NULL;
	gint _tmp42__length1 = 0;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (map != NULL, NULL);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self = (Game*) g_object_new (object_type, NULL);
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = map;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_g_object_unref0 (self->map);
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->map = _tmp1_;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->move_number = 1;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp2_ = map;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp3_ = _tmp2_->slots;
#line 642 "game.c"
	{
		GList* slot_collection = NULL;
		GList* slot_it = NULL;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		slot_collection = _tmp3_;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		for (slot_it = slot_collection; slot_it != NULL; slot_it = slot_it->next) {
#line 650 "game.c"
			Slot* _tmp4_ = NULL;
			Slot* slot = NULL;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			_tmp4_ = _g_object_ref0 ((Slot*) slot_it->data);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			slot = _tmp4_;
#line 657 "game.c"
			{
				Tile* tile = NULL;
				Slot* _tmp5_ = NULL;
				Tile* _tmp6_ = NULL;
				Tile* _tmp7_ = NULL;
				Tile* _tmp8_ = NULL;
				Tile* _tmp9_ = NULL;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp5_ = slot;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp6_ = tile_new (_tmp5_);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				tile = _tmp6_;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp7_ = tile;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp7_->number = 0;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp8_ = tile;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp9_ = _g_object_ref0 (_tmp8_);
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				self->tiles = g_list_insert_sorted (self->tiles, _tmp9_, _compare_tiles_gcompare_func);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_g_object_unref0 (tile);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_g_object_unref0 (slot);
#line 685 "game.c"
			}
		}
	}
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp10_ = self->tiles;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp11_ = g_list_length (_tmp10_);
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	n_pairs = ((gint) _tmp11_) / 2;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp12_ = n_pairs;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp13_ = g_new0 (gint, _tmp12_);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	numbers = _tmp13_;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	numbers_length1 = _tmp12_;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_numbers_size_ = numbers_length1;
#line 705 "game.c"
	{
		gint i = 0;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		i = 0;
#line 710 "game.c"
		{
			gboolean _tmp14_ = FALSE;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			_tmp14_ = TRUE;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			while (TRUE) {
#line 717 "game.c"
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				gint* _tmp18_ = NULL;
				gint _tmp18__length1 = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (!_tmp14_) {
#line 727 "game.c"
					gint _tmp15_ = 0;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp15_ = i;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					i = _tmp15_ + 1;
#line 733 "game.c"
				}
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp14_ = FALSE;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp16_ = i;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp17_ = n_pairs;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (!(_tmp16_ < _tmp17_)) {
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					break;
#line 745 "game.c"
				}
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp18_ = numbers;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp18__length1 = numbers_length1;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp19_ = i;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp20_ = i;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp18_[_tmp19_] = _tmp20_ * 2;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp21_ = _tmp18_[_tmp19_];
#line 759 "game.c"
			}
		}
	}
	{
		gint i = 0;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		i = 0;
#line 767 "game.c"
		{
			gboolean _tmp22_ = FALSE;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			_tmp22_ = TRUE;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			while (TRUE) {
#line 774 "game.c"
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gint32 n = 0;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				gint32 _tmp28_ = 0;
				gint t = 0;
				gint* _tmp29_ = NULL;
				gint _tmp29__length1 = 0;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				gint* _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				gint _tmp33_ = 0;
				gint* _tmp34_ = NULL;
				gint _tmp34__length1 = 0;
				gint32 _tmp35_ = 0;
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				gint* _tmp38_ = NULL;
				gint _tmp38__length1 = 0;
				gint32 _tmp39_ = 0;
				gint _tmp40_ = 0;
				gint _tmp41_ = 0;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (!_tmp22_) {
#line 801 "game.c"
					gint _tmp23_ = 0;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp23_ = i;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					i = _tmp23_ + 1;
#line 807 "game.c"
				}
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp22_ = FALSE;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp24_ = i;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp25_ = n_pairs;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (!(_tmp24_ < _tmp25_)) {
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					break;
#line 819 "game.c"
				}
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp26_ = i;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp27_ = n_pairs;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp28_ = g_random_int_range ((gint32) _tmp26_, (gint32) _tmp27_);
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				n = _tmp28_;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp29_ = numbers;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp29__length1 = numbers_length1;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp30_ = i;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp31_ = _tmp29_[_tmp30_];
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				t = _tmp31_;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp32_ = numbers;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp32__length1 = numbers_length1;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp33_ = i;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp34_ = numbers;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp34__length1 = numbers_length1;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp35_ = n;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp36_ = _tmp34_[_tmp35_];
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp32_[_tmp33_] = _tmp36_;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp37_ = _tmp32_[_tmp33_];
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp38_ = numbers;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp38__length1 = numbers_length1;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp39_ = n;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp40_ = t;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp38_[_tmp39_] = _tmp40_;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp41_ = _tmp38_[_tmp39_];
#line 869 "game.c"
			}
		}
	}
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp42_ = numbers;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp42__length1 = numbers_length1;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	game_shuffle (self, _tmp42_, _tmp42__length1, 0);
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	game_reset (self);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	numbers = (g_free (numbers), NULL);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return self;
#line 885 "game.c"
}


Game* game_new (Map* map) {
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return game_construct (TYPE_GAME, map);
#line 892 "game.c"
}


void game_shuffle_remaining (Game* self, gboolean redraw) {
	guint n = 0U;
	GList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gboolean _tmp25_ = FALSE;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_if_fail (self != NULL);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = self->tiles;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp1_ = g_list_length (_tmp0_);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	n = _tmp1_;
#line 909 "game.c"
	{
		gboolean _tmp2_ = FALSE;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp2_ = TRUE;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		while (TRUE) {
#line 916 "game.c"
			GList* _tmp20_ = NULL;
			GList* _tmp23_ = NULL;
			GList* _tmp24_ = NULL;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			if (!_tmp2_) {
#line 922 "game.c"
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp4_ = game_get_can_move (self);
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp5_ = _tmp4_;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (!_tmp5_) {
#line 932 "game.c"
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp6_ = game_get_visible_tiles (self);
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp7_ = _tmp6_;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp3_ = _tmp7_ > 1;
#line 941 "game.c"
				} else {
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp3_ = FALSE;
#line 945 "game.c"
				}
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (!_tmp3_) {
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					break;
#line 951 "game.c"
				}
			}
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			_tmp2_ = FALSE;
#line 956 "game.c"
			{
				guint i = 0U;
				guint _tmp8_ = 0U;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp8_ = n;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				i = _tmp8_ - 1;
#line 964 "game.c"
				{
					gboolean _tmp9_ = FALSE;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp9_ = TRUE;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					while (TRUE) {
#line 971 "game.c"
						guint _tmp11_ = 0U;
						gint j = 0;
						guint _tmp12_ = 0U;
						gint32 _tmp13_ = 0;
						GList* _tmp14_ = NULL;
						gint _tmp15_ = 0;
						gconstpointer _tmp16_ = NULL;
						GList* _tmp17_ = NULL;
						guint _tmp18_ = 0U;
						gconstpointer _tmp19_ = NULL;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						if (!_tmp9_) {
#line 984 "game.c"
							guint _tmp10_ = 0U;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
							_tmp10_ = i;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
							i = _tmp10_ - 1;
#line 990 "game.c"
						}
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp9_ = FALSE;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp11_ = i;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						if (!(_tmp11_ > ((guint) 0))) {
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
							break;
#line 1000 "game.c"
						}
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp12_ = i;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp13_ = g_random_int_range ((gint32) 0, (gint32) (((gint) _tmp12_) + 1));
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						j = (gint) _tmp13_;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp14_ = self->tiles;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp15_ = j;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp16_ = g_list_nth_data (_tmp14_, (guint) _tmp15_);
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp17_ = self->tiles;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp18_ = i;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp19_ = g_list_nth_data (_tmp17_, _tmp18_);
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						switch_tiles ((Tile*) _tmp16_, (Tile*) _tmp19_);
#line 1022 "game.c"
					}
				}
			}
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			self->tiles = g_list_sort (self->tiles, _compare_tiles_gcompare_func);
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			self->move_number = 1;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			_tmp20_ = self->tiles;
#line 1032 "game.c"
			{
				GList* tile_collection = NULL;
				GList* tile_it = NULL;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				tile_collection = _tmp20_;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
#line 1040 "game.c"
					Tile* _tmp21_ = NULL;
					Tile* tile = NULL;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp21_ = _g_object_ref0 ((Tile*) tile_it->data);
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					tile = _tmp21_;
#line 1047 "game.c"
					{
						Tile* _tmp22_ = NULL;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp22_ = tile;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp22_->move_number = 0;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_g_object_unref0 (tile);
#line 1056 "game.c"
					}
				}
			}
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			_tmp23_ = game_find_matches (self, NULL);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			_tmp24_ = _tmp23_;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			__g_list_free__g_object_unref0_0 (_tmp24_);
#line 1066 "game.c"
		}
	}
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_signal_emit_by_name (self, "moved");
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp25_ = redraw;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp25_) {
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		game_redraw_all_tiles (self);
#line 1077 "game.c"
	}
}


void game_redraw_all_tiles (Game* self) {
	GList* _tmp0_ = NULL;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_if_fail (self != NULL);
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = self->tiles;
#line 1088 "game.c"
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		tile_collection = _tmp0_;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
#line 1096 "game.c"
			Tile* _tmp1_ = NULL;
			Tile* tile = NULL;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			_tmp1_ = _g_object_ref0 ((Tile*) tile_it->data);
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			tile = _tmp1_;
#line 1103 "game.c"
			{
				Tile* _tmp2_ = NULL;
				gboolean _tmp3_ = FALSE;
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp2_ = tile;
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp3_ = _tmp2_->visible;
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (_tmp3_) {
#line 1113 "game.c"
					Tile* _tmp4_ = NULL;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp4_ = tile;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					g_signal_emit_by_name (self, "redraw-tile", _tmp4_);
#line 1119 "game.c"
				}
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_g_object_unref0 (tile);
#line 1123 "game.c"
			}
		}
	}
}


static gboolean game_shuffle (Game* self, gint* numbers, int numbers_length1, gint depth) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GList* matches = NULL;
	GList* _tmp3_ = NULL;
	guint n_matches = 0U;
	GList* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	gint32 n = 0;
	guint _tmp7_ = 0U;
	gint32 _tmp8_ = 0;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = depth;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp1_ = self->tiles;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp2_ = g_list_length (_tmp1_);
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (((guint) _tmp0_) == (_tmp2_ / 2)) {
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		result = TRUE;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		return result;
#line 1158 "game.c"
	}
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp3_ = game_find_matches (self, NULL);
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	matches = _tmp3_;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp4_ = matches;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp5_ = g_list_length (_tmp4_);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	n_matches = _tmp5_;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp6_ = n_matches;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp6_ == ((guint) 0)) {
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		result = FALSE;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		__g_list_free__g_object_unref0_0 (matches);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		return result;
#line 1180 "game.c"
	}
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp7_ = n_matches;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp8_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp7_));
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	n = _tmp8_;
#line 1188 "game.c"
	{
		gint i = 0;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		i = 0;
#line 1193 "game.c"
		{
			gboolean _tmp9_ = FALSE;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			_tmp9_ = TRUE;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			while (TRUE) {
#line 1200 "game.c"
				gint _tmp11_ = 0;
				guint _tmp12_ = 0U;
				Match* match = NULL;
				GList* _tmp13_ = NULL;
				gint32 _tmp14_ = 0;
				gint _tmp15_ = 0;
				guint _tmp16_ = 0U;
				gconstpointer _tmp17_ = NULL;
				Match* _tmp18_ = NULL;
				Match* _tmp19_ = NULL;
				Tile* _tmp20_ = NULL;
				gint* _tmp21_ = NULL;
				gint _tmp21__length1 = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				Match* _tmp24_ = NULL;
				Tile* _tmp25_ = NULL;
				Match* _tmp26_ = NULL;
				Tile* _tmp27_ = NULL;
				gint* _tmp28_ = NULL;
				gint _tmp28__length1 = 0;
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				Match* _tmp31_ = NULL;
				Tile* _tmp32_ = NULL;
				gint* _tmp33_ = NULL;
				gint _tmp33__length1 = 0;
				gint _tmp34_ = 0;
				gboolean _tmp35_ = FALSE;
				Match* _tmp36_ = NULL;
				Tile* _tmp37_ = NULL;
				Match* _tmp38_ = NULL;
				Tile* _tmp39_ = NULL;
				Match* _tmp40_ = NULL;
				Tile* _tmp41_ = NULL;
				Match* _tmp42_ = NULL;
				Tile* _tmp43_ = NULL;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (!_tmp9_) {
#line 1240 "game.c"
					gint _tmp10_ = 0;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp10_ = i;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					i = _tmp10_ + 1;
#line 1246 "game.c"
				}
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp9_ = FALSE;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp11_ = i;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp12_ = n_matches;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (!(((guint) _tmp11_) < _tmp12_)) {
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					break;
#line 1258 "game.c"
				}
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp13_ = matches;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp14_ = n;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp15_ = i;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp16_ = n_matches;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp17_ = g_list_nth_data (_tmp13_, (_tmp14_ + _tmp15_) % _tmp16_);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp18_ = _g_object_ref0 ((Match*) _tmp17_);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				match = _tmp18_;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp19_ = match;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp20_ = _tmp19_->tile0;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp21_ = numbers;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp21__length1 = numbers_length1;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp22_ = depth;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp23_ = _tmp21_[_tmp22_];
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp20_->number = _tmp23_;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp24_ = match;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp25_ = _tmp24_->tile0;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp25_->visible = FALSE;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp26_ = match;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp27_ = _tmp26_->tile1;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp28_ = numbers;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp28__length1 = numbers_length1;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp29_ = depth;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp30_ = _tmp28_[_tmp29_];
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp27_->number = _tmp30_ + 1;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp31_ = match;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp32_ = _tmp31_->tile1;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp32_->visible = FALSE;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp33_ = numbers;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp33__length1 = numbers_length1;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp34_ = depth;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp35_ = game_shuffle (self, _tmp33_, _tmp33__length1, _tmp34_ + 1);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (_tmp35_) {
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					result = TRUE;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_g_object_unref0 (match);
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					__g_list_free__g_object_unref0_0 (matches);
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					return result;
#line 1332 "game.c"
				}
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp36_ = match;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp37_ = _tmp36_->tile0;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp37_->number = 0;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp38_ = match;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp39_ = _tmp38_->tile0;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp39_->visible = TRUE;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp40_ = match;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp41_ = _tmp40_->tile1;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp41_->number = 0;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp42_ = match;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp43_ = _tmp42_->tile1;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp43_->visible = TRUE;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_g_object_unref0 (match);
#line 1360 "game.c"
			}
		}
	}
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = FALSE;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	__g_list_free__g_object_unref0_0 (matches);
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 1370 "game.c"
}


void game_reset (Game* self) {
	GList* _tmp0_ = NULL;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_if_fail (self != NULL);
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	game_reset_clock (self);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->move_number = 1;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	game_set_selected_tile (self, NULL);
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	game_set_hint (self, NULL, NULL);
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = self->tiles;
#line 1388 "game.c"
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		tile_collection = _tmp0_;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
#line 1396 "game.c"
			Tile* _tmp1_ = NULL;
			Tile* tile = NULL;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			_tmp1_ = _g_object_ref0 ((Tile*) tile_it->data);
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			tile = _tmp1_;
#line 1403 "game.c"
			{
				Tile* _tmp2_ = NULL;
				Tile* _tmp3_ = NULL;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp2_ = tile;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp2_->visible = TRUE;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp3_ = tile;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp3_->move_number = 0;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_g_object_unref0 (tile);
#line 1417 "game.c"
			}
		}
	}
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	game_redraw_all_tiles (self);
#line 1423 "game.c"
}


static gboolean _game_hint_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = game_hint_timeout_cb ((Game*) self);
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 1432 "game.c"
}


void game_set_hint (Game* self, Tile* tile0, Tile* tile1) {
	Tile* _tmp0_ = NULL;
	Tile* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
	Tile* _tmp5_ = NULL;
	Tile* _tmp7_ = NULL;
	Tile* _tmp8_ = NULL;
	Tile* _tmp9_ = NULL;
	Tile* _tmp10_ = NULL;
	Tile* _tmp11_ = NULL;
	Tile* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	guint _tmp15_ = 0U;
	gdouble _tmp16_ = 0.0;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_if_fail (self != NULL);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = self->hint_tiles[0];
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp0_ != NULL) {
#line 1456 "game.c"
		Tile* _tmp1_ = NULL;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp1_ = self->hint_tiles[0];
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_signal_emit_by_name (self, "redraw-tile", _tmp1_);
#line 1462 "game.c"
	}
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp2_ = self->hint_tiles[1];
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp2_ != NULL) {
#line 1468 "game.c"
		Tile* _tmp3_ = NULL;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp3_ = self->hint_tiles[1];
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_signal_emit_by_name (self, "redraw-tile", _tmp3_);
#line 1474 "game.c"
	}
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp5_ = tile0;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp5_ == NULL) {
#line 1480 "game.c"
		Tile* _tmp6_ = NULL;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp6_ = tile1;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp4_ = _tmp6_ == NULL;
#line 1486 "game.c"
	} else {
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp4_ = FALSE;
#line 1490 "game.c"
	}
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp4_) {
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		self->hint_blink_counter = (guint) 0;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		game_hint_timeout_cb (self);
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		return;
#line 1500 "game.c"
	}
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp7_ = tile0;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_g_object_unref0 (self->hint_tiles[0]);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->hint_tiles[0] = _tmp8_;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp9_ = self->hint_tiles[0];
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp10_ = tile1;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp11_ = _g_object_ref0 (_tmp10_);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_g_object_unref0 (self->hint_tiles[1]);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->hint_tiles[1] = _tmp11_;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp12_ = self->hint_tiles[1];
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->hint_blink_counter = (guint) 6;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp13_ = self->priv->hint_timout;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp13_ != ((guint) 0)) {
#line 1528 "game.c"
		guint _tmp14_ = 0U;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp14_ = self->priv->hint_timout;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_source_remove (_tmp14_);
#line 1534 "game.c"
	}
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp15_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _game_hint_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->priv->hint_timout = _tmp15_;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	game_hint_timeout_cb (self);
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	game_start_clock (self);
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp16_ = self->priv->clock_elapsed;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->priv->clock_elapsed = _tmp16_ + 30.0;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_signal_emit_by_name (self, "tick");
#line 1550 "game.c"
}


static gboolean game_hint_timeout_cb (Game* self) {
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint _tmp3_ = 0U;
	Tile* _tmp4_ = NULL;
	Tile* _tmp6_ = NULL;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = self->hint_blink_counter;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp0_ == ((guint) 0)) {
#line 1566 "game.c"
		guint _tmp1_ = 0U;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp1_ = self->priv->hint_timout;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		if (_tmp1_ != ((guint) 0)) {
#line 1572 "game.c"
			guint _tmp2_ = 0U;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			_tmp2_ = self->priv->hint_timout;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			g_source_remove (_tmp2_);
#line 1578 "game.c"
		}
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		self->priv->hint_timout = (guint) 0;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		result = FALSE;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		return result;
#line 1586 "game.c"
	}
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp3_ = self->hint_blink_counter;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->hint_blink_counter = _tmp3_ - 1;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp4_ = self->hint_tiles[0];
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp4_ != NULL) {
#line 1596 "game.c"
		Tile* _tmp5_ = NULL;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp5_ = self->hint_tiles[0];
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_signal_emit_by_name (self, "redraw-tile", _tmp5_);
#line 1602 "game.c"
	}
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp6_ = self->hint_tiles[1];
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp6_ != NULL) {
#line 1608 "game.c"
		Tile* _tmp7_ = NULL;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp7_ = self->hint_tiles[1];
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_signal_emit_by_name (self, "redraw-tile", _tmp7_);
#line 1614 "game.c"
	}
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = TRUE;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 1620 "game.c"
}


gboolean game_tile_can_move (Game* self, Tile* tile) {
	gboolean result = FALSE;
	Tile* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean blocked_left = FALSE;
	gboolean blocked_right = FALSE;
	Slot* slot = NULL;
	Tile* _tmp2_ = NULL;
	Slot* _tmp3_ = NULL;
	Slot* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (tile != NULL, FALSE);
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = tile;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp1_ = _tmp0_->visible;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (!_tmp1_) {
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		result = FALSE;
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		return result;
#line 1649 "game.c"
	}
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	blocked_left = FALSE;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	blocked_right = FALSE;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp2_ = tile;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp3_ = _tmp2_->slot;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	slot = _tmp4_;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp5_ = self->tiles;
#line 1665 "game.c"
	{
		GList* t_collection = NULL;
		GList* t_it = NULL;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		t_collection = _tmp5_;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		for (t_it = t_collection; t_it != NULL; t_it = t_it->next) {
#line 1673 "game.c"
			Tile* _tmp6_ = NULL;
			Tile* t = NULL;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			_tmp6_ = _g_object_ref0 ((Tile*) t_it->data);
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			t = _tmp6_;
#line 1680 "game.c"
			{
				gboolean _tmp7_ = FALSE;
				Tile* _tmp8_ = NULL;
				Tile* _tmp9_ = NULL;
				Slot* s = NULL;
				Tile* _tmp12_ = NULL;
				Slot* _tmp13_ = NULL;
				Slot* _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
				gboolean _tmp16_ = FALSE;
				Slot* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				Slot* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				gboolean _tmp39_ = FALSE;
				Slot* _tmp40_ = NULL;
				gint _tmp41_ = 0;
				Slot* _tmp42_ = NULL;
				gint _tmp43_ = 0;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp8_ = t;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp9_ = tile;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (_tmp8_ == _tmp9_) {
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp7_ = TRUE;
#line 1708 "game.c"
				} else {
					Tile* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp10_ = t;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp11_ = _tmp10_->visible;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp7_ = !_tmp11_;
#line 1718 "game.c"
				}
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (_tmp7_) {
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_g_object_unref0 (t);
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					continue;
#line 1726 "game.c"
				}
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp12_ = t;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp13_ = _tmp12_->slot;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp14_ = _g_object_ref0 (_tmp13_);
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				s = _tmp14_;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp17_ = s;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp18_ = _tmp17_->layer;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp19_ = slot;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp20_ = _tmp19_->layer;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (_tmp18_ == (_tmp20_ + 1)) {
#line 1746 "game.c"
					gboolean _tmp21_ = FALSE;
					Slot* _tmp22_ = NULL;
					gint _tmp23_ = 0;
					Slot* _tmp24_ = NULL;
					gint _tmp25_ = 0;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp22_ = s;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp23_ = _tmp22_->x;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp24_ = slot;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp25_ = _tmp24_->x;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					if (_tmp23_ >= (_tmp25_ - 1)) {
#line 1762 "game.c"
						Slot* _tmp26_ = NULL;
						gint _tmp27_ = 0;
						Slot* _tmp28_ = NULL;
						gint _tmp29_ = 0;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp26_ = s;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp27_ = _tmp26_->x;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp28_ = slot;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp29_ = _tmp28_->x;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp21_ = _tmp27_ <= (_tmp29_ + 1);
#line 1777 "game.c"
					} else {
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp21_ = FALSE;
#line 1781 "game.c"
					}
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp16_ = _tmp21_;
#line 1785 "game.c"
				} else {
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp16_ = FALSE;
#line 1789 "game.c"
				}
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (_tmp16_) {
#line 1793 "game.c"
					gboolean _tmp30_ = FALSE;
					Slot* _tmp31_ = NULL;
					gint _tmp32_ = 0;
					Slot* _tmp33_ = NULL;
					gint _tmp34_ = 0;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp31_ = s;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp32_ = _tmp31_->y;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp33_ = slot;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp34_ = _tmp33_->y;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					if (_tmp32_ >= (_tmp34_ - 1)) {
#line 1809 "game.c"
						Slot* _tmp35_ = NULL;
						gint _tmp36_ = 0;
						Slot* _tmp37_ = NULL;
						gint _tmp38_ = 0;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp35_ = s;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp36_ = _tmp35_->y;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp37_ = slot;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp38_ = _tmp37_->y;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp30_ = _tmp36_ <= (_tmp38_ + 1);
#line 1824 "game.c"
					} else {
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp30_ = FALSE;
#line 1828 "game.c"
					}
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp15_ = _tmp30_;
#line 1832 "game.c"
				} else {
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp15_ = FALSE;
#line 1836 "game.c"
				}
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (_tmp15_) {
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					result = FALSE;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_g_object_unref0 (s);
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_g_object_unref0 (t);
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_g_object_unref0 (slot);
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					return result;
#line 1850 "game.c"
				}
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp40_ = s;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp41_ = _tmp40_->layer;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp42_ = slot;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp43_ = _tmp42_->layer;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (_tmp41_ == _tmp43_) {
#line 1862 "game.c"
					gboolean _tmp44_ = FALSE;
					Slot* _tmp45_ = NULL;
					gint _tmp46_ = 0;
					Slot* _tmp47_ = NULL;
					gint _tmp48_ = 0;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp45_ = s;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp46_ = _tmp45_->y;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp47_ = slot;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp48_ = _tmp47_->y;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					if (_tmp46_ >= (_tmp48_ - 1)) {
#line 1878 "game.c"
						Slot* _tmp49_ = NULL;
						gint _tmp50_ = 0;
						Slot* _tmp51_ = NULL;
						gint _tmp52_ = 0;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp49_ = s;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp50_ = _tmp49_->y;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp51_ = slot;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp52_ = _tmp51_->y;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp44_ = _tmp50_ <= (_tmp52_ + 1);
#line 1893 "game.c"
					} else {
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp44_ = FALSE;
#line 1897 "game.c"
					}
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp39_ = _tmp44_;
#line 1901 "game.c"
				} else {
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp39_ = FALSE;
#line 1905 "game.c"
				}
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (_tmp39_) {
#line 1909 "game.c"
					Slot* _tmp53_ = NULL;
					gint _tmp54_ = 0;
					Slot* _tmp55_ = NULL;
					gint _tmp56_ = 0;
					Slot* _tmp57_ = NULL;
					gint _tmp58_ = 0;
					Slot* _tmp59_ = NULL;
					gint _tmp60_ = 0;
					gboolean _tmp61_ = FALSE;
					gboolean _tmp62_ = FALSE;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp53_ = s;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp54_ = _tmp53_->x;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp55_ = slot;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp56_ = _tmp55_->x;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					if (_tmp54_ == (_tmp56_ - 2)) {
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						blocked_left = TRUE;
#line 1932 "game.c"
					}
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp57_ = s;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp58_ = _tmp57_->x;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp59_ = slot;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp60_ = _tmp59_->x;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					if (_tmp58_ == (_tmp60_ + 2)) {
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						blocked_right = TRUE;
#line 1946 "game.c"
					}
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp62_ = blocked_left;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					if (_tmp62_) {
#line 1952 "game.c"
						gboolean _tmp63_ = FALSE;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp63_ = blocked_right;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp61_ = _tmp63_;
#line 1958 "game.c"
					} else {
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp61_ = FALSE;
#line 1962 "game.c"
					}
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					if (_tmp61_) {
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						result = FALSE;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_g_object_unref0 (s);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_g_object_unref0 (t);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_g_object_unref0 (slot);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						return result;
#line 1976 "game.c"
					}
				}
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_g_object_unref0 (s);
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_g_object_unref0 (t);
#line 1983 "game.c"
			}
		}
	}
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = TRUE;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_g_object_unref0 (slot);
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 1993 "game.c"
}


gint game_number_of_movable_tiles (Game* self) {
	gint result = 0;
	gint count = 0;
	GList* _tmp0_ = NULL;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	count = 0;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = self->tiles;
#line 2007 "game.c"
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		tile_collection = _tmp0_;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
#line 2015 "game.c"
			Tile* _tmp1_ = NULL;
			Tile* tile = NULL;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			_tmp1_ = _g_object_ref0 ((Tile*) tile_it->data);
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			tile = _tmp1_;
#line 2022 "game.c"
			{
				Tile* _tmp2_ = NULL;
				gboolean _tmp3_ = FALSE;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp2_ = tile;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp3_ = game_tile_can_move (self, _tmp2_);
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (_tmp3_) {
#line 2032 "game.c"
					gint _tmp4_ = 0;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp4_ = count;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					count = _tmp4_ + 1;
#line 2038 "game.c"
				}
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_g_object_unref0 (tile);
#line 2042 "game.c"
			}
		}
	}
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = count;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 2050 "game.c"
}


GList* game_find_matches (Game* self, Tile* tile) {
	GList* result = NULL;
	GList* matches = NULL;
	gboolean _tmp0_ = FALSE;
	Tile* _tmp1_ = NULL;
	Tile* _tmp4_ = NULL;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	matches = NULL;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp1_ = tile;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp1_ != NULL) {
#line 2068 "game.c"
		Tile* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp2_ = tile;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp3_ = game_tile_can_move (self, _tmp2_);
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp0_ = !_tmp3_;
#line 2077 "game.c"
	} else {
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp0_ = FALSE;
#line 2081 "game.c"
	}
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp0_) {
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		result = matches;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		return result;
#line 2089 "game.c"
	}
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp4_ = tile;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp4_ == NULL) {
#line 2095 "game.c"
		GList* _tmp5_ = NULL;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp5_ = self->tiles;
#line 2099 "game.c"
		{
			GList* t_collection = NULL;
			GList* t_it = NULL;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			t_collection = _tmp5_;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			for (t_it = t_collection; t_it != NULL; t_it = t_it->next) {
#line 2107 "game.c"
				Tile* _tmp6_ = NULL;
				Tile* t = NULL;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp6_ = _g_object_ref0 ((Tile*) t_it->data);
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				t = _tmp6_;
#line 2114 "game.c"
				{
					Tile* _tmp7_ = NULL;
					GList* _tmp8_ = NULL;
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp7_ = t;
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp8_ = game_find_matches (self, _tmp7_);
#line 2122 "game.c"
					{
						GList* match_collection = NULL;
						GList* match_it = NULL;
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						match_collection = _tmp8_;
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						for (match_it = match_collection; match_it != NULL; match_it = match_it->next) {
#line 2130 "game.c"
							Match* _tmp9_ = NULL;
							Match* match = NULL;
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
							_tmp9_ = _g_object_ref0 ((Match*) match_it->data);
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
							match = _tmp9_;
#line 2137 "game.c"
							{
								gboolean already_matched = FALSE;
								GList* _tmp10_ = NULL;
								gboolean _tmp21_ = FALSE;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
								already_matched = FALSE;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
								_tmp10_ = matches;
#line 2146 "game.c"
								{
									GList* existing_match_collection = NULL;
									GList* existing_match_it = NULL;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
									existing_match_collection = _tmp10_;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
									for (existing_match_it = existing_match_collection; existing_match_it != NULL; existing_match_it = existing_match_it->next) {
#line 2154 "game.c"
										Match* _tmp11_ = NULL;
										Match* existing_match = NULL;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
										_tmp11_ = _g_object_ref0 ((Match*) existing_match_it->data);
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
										existing_match = _tmp11_;
#line 2161 "game.c"
										{
											gboolean _tmp12_ = FALSE;
											Match* _tmp13_ = NULL;
											Tile* _tmp14_ = NULL;
											Match* _tmp15_ = NULL;
											Tile* _tmp16_ = NULL;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
											_tmp13_ = existing_match;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
											_tmp14_ = _tmp13_->tile0;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
											_tmp15_ = match;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
											_tmp16_ = _tmp15_->tile1;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
											if (_tmp14_ == _tmp16_) {
#line 2178 "game.c"
												Match* _tmp17_ = NULL;
												Tile* _tmp18_ = NULL;
												Match* _tmp19_ = NULL;
												Tile* _tmp20_ = NULL;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
												_tmp17_ = existing_match;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
												_tmp18_ = _tmp17_->tile1;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
												_tmp19_ = match;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
												_tmp20_ = _tmp19_->tile0;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
												_tmp12_ = _tmp18_ == _tmp20_;
#line 2193 "game.c"
											} else {
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
												_tmp12_ = FALSE;
#line 2197 "game.c"
											}
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
											if (_tmp12_) {
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
												already_matched = TRUE;
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
												_g_object_unref0 (existing_match);
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
												break;
#line 2207 "game.c"
											}
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
											_g_object_unref0 (existing_match);
#line 2211 "game.c"
										}
									}
								}
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
								_tmp21_ = already_matched;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
								if (!_tmp21_) {
#line 2219 "game.c"
									Match* _tmp22_ = NULL;
									Match* _tmp23_ = NULL;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
									_tmp22_ = match;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
									_tmp23_ = _g_object_ref0 (_tmp22_);
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
									matches = g_list_append (matches, _tmp23_);
#line 2228 "game.c"
								}
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
								_g_object_unref0 (match);
#line 2232 "game.c"
							}
						}
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						__g_list_free__g_object_unref0_0 (match_collection);
#line 2237 "game.c"
					}
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_g_object_unref0 (t);
#line 2241 "game.c"
				}
			}
		}
	} else {
		GList* _tmp24_ = NULL;
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp24_ = self->tiles;
#line 2249 "game.c"
		{
			GList* t_collection = NULL;
			GList* t_it = NULL;
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			t_collection = _tmp24_;
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			for (t_it = t_collection; t_it != NULL; t_it = t_it->next) {
#line 2257 "game.c"
				Tile* _tmp25_ = NULL;
				Tile* t = NULL;
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp25_ = _g_object_ref0 ((Tile*) t_it->data);
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				t = _tmp25_;
#line 2264 "game.c"
				{
					gboolean _tmp26_ = FALSE;
					Tile* _tmp27_ = NULL;
					Tile* _tmp28_ = NULL;
					Tile* _tmp31_ = NULL;
					Tile* _tmp32_ = NULL;
					gboolean _tmp33_ = FALSE;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp27_ = t;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp28_ = tile;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					if (_tmp27_ == _tmp28_) {
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp26_ = TRUE;
#line 2280 "game.c"
					} else {
						Tile* _tmp29_ = NULL;
						gboolean _tmp30_ = FALSE;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp29_ = t;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp30_ = game_tile_can_move (self, _tmp29_);
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp26_ = !_tmp30_;
#line 2290 "game.c"
					}
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					if (_tmp26_) {
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_g_object_unref0 (t);
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						continue;
#line 2298 "game.c"
					}
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp31_ = t;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp32_ = tile;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp33_ = tile_matches (_tmp31_, _tmp32_);
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					if (_tmp33_) {
#line 2308 "game.c"
						Tile* _tmp34_ = NULL;
						Tile* _tmp35_ = NULL;
						Match* _tmp36_ = NULL;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp34_ = t;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp35_ = tile;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						_tmp36_ = match_new (_tmp34_, _tmp35_);
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
						matches = g_list_append (matches, _tmp36_);
#line 2320 "game.c"
					}
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_g_object_unref0 (t);
#line 2324 "game.c"
				}
			}
		}
	}
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = matches;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 2333 "game.c"
}


gboolean game_remove_pair (Game* self, Tile* tile0, Tile* tile1) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Tile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Tile* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	Tile* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GList* _tmp11_ = NULL;
	Tile* _tmp17_ = NULL;
	Tile* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	Tile* _tmp20_ = NULL;
	Tile* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	Tile* _tmp24_ = NULL;
	Tile* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (tile0 != NULL, FALSE);
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (tile1 != NULL, FALSE);
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp1_ = tile0;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp2_ = _tmp1_->visible;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (!_tmp2_) {
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp0_ = TRUE;
#line 2374 "game.c"
	} else {
		Tile* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp3_ = tile1;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp4_ = _tmp3_->visible;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp0_ = !_tmp4_;
#line 2384 "game.c"
	}
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp0_) {
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		result = FALSE;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		return result;
#line 2392 "game.c"
	}
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp5_ = tile0;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp6_ = tile_get_set (_tmp5_);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp7_ = _tmp6_;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp8_ = tile1;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp9_ = tile_get_set (_tmp8_);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp10_ = _tmp9_;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp7_ != _tmp10_) {
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		result = FALSE;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		return result;
#line 2412 "game.c"
	}
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	game_set_selected_tile (self, NULL);
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	game_set_hint (self, NULL, NULL);
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp11_ = self->tiles;
#line 2420 "game.c"
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		tile_collection = _tmp11_;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
#line 2428 "game.c"
			Tile* _tmp12_ = NULL;
			Tile* tile = NULL;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			_tmp12_ = _g_object_ref0 ((Tile*) tile_it->data);
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			tile = _tmp12_;
#line 2435 "game.c"
			{
				Tile* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp13_ = tile;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp14_ = _tmp13_->move_number;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp15_ = self->move_number;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (_tmp14_ >= _tmp15_) {
#line 2448 "game.c"
					Tile* _tmp16_ = NULL;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp16_ = tile;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp16_->move_number = 0;
#line 2454 "game.c"
				}
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_g_object_unref0 (tile);
#line 2458 "game.c"
			}
		}
	}
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp17_ = tile0;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp17_->visible = FALSE;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp18_ = tile0;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp19_ = self->move_number;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp18_->move_number = _tmp19_;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp20_ = tile1;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp20_->visible = FALSE;
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp21_ = tile1;
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp22_ = self->move_number;
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp21_->move_number = _tmp22_;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp23_ = self->move_number;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->move_number = _tmp23_ + 1;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp24_ = tile0;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_signal_emit_by_name (self, "redraw-tile", _tmp24_);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp25_ = tile1;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_signal_emit_by_name (self, "redraw-tile", _tmp25_);
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp26_ = game_get_complete (self);
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp27_ = _tmp26_;
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp27_) {
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		game_stop_clock (self);
#line 2502 "game.c"
	} else {
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		game_start_clock (self);
#line 2506 "game.c"
	}
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_signal_emit_by_name (self, "moved");
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = TRUE;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 2514 "game.c"
}


static void game_start_clock (Game* self) {
	GTimer* _tmp0_ = NULL;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_if_fail (self != NULL);
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = self->priv->clock;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp0_ == NULL) {
#line 2526 "game.c"
		GTimer* _tmp1_ = NULL;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp1_ = g_timer_new ();
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_g_timer_destroy0 (self->priv->clock);
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		self->priv->clock = _tmp1_;
#line 2534 "game.c"
	}
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	game_timeout_cb (self);
#line 2538 "game.c"
}


static void game_stop_clock (Game* self) {
	GTimer* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GTimer* _tmp3_ = NULL;
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_if_fail (self != NULL);
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = self->priv->clock;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp0_ == NULL) {
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		return;
#line 2554 "game.c"
	}
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp1_ = self->priv->clock_timeout;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 2560 "game.c"
		guint _tmp2_ = 0U;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp2_ = self->priv->clock_timeout;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_source_remove (_tmp2_);
#line 2566 "game.c"
	}
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->priv->clock_timeout = (guint) 0;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp3_ = self->priv->clock;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_timer_stop (_tmp3_);
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_signal_emit_by_name (self, "tick");
#line 2576 "game.c"
}


static void game_continue_clock (Game* self) {
	GTimer* _tmp0_ = NULL;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_if_fail (self != NULL);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = self->priv->clock;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp0_ == NULL) {
#line 2588 "game.c"
		GTimer* _tmp1_ = NULL;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp1_ = g_timer_new ();
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_g_timer_destroy0 (self->priv->clock);
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		self->priv->clock = _tmp1_;
#line 2596 "game.c"
	} else {
		GTimer* _tmp2_ = NULL;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp2_ = self->priv->clock;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_timer_continue (_tmp2_);
#line 2603 "game.c"
	}
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	game_timeout_cb (self);
#line 2607 "game.c"
}


static void game_reset_clock (Game* self) {
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_if_fail (self != NULL);
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	game_stop_clock (self);
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_g_timer_destroy0 (self->priv->clock);
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->priv->clock = NULL;
#line 477 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->priv->clock_elapsed = 0.0;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_signal_emit_by_name (self, "tick");
#line 2624 "game.c"
}


static gboolean _game_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = game_timeout_cb ((Game*) self);
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 2633 "game.c"
}


static gboolean game_timeout_cb (Game* self) {
	gboolean result = FALSE;
	GTimer* _tmp0_ = NULL;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = self->priv->clock;
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp0_ != NULL) {
#line 2646 "game.c"
		gdouble elapsed = 0.0;
		GTimer* _tmp1_ = NULL;
		gdouble _tmp2_ = 0.0;
		gint next = 0;
		gdouble _tmp3_ = 0.0;
		gdouble wait = 0.0;
		gint _tmp4_ = 0;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		guint _tmp7_ = 0U;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp1_ = self->priv->clock;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp2_ = g_timer_elapsed (_tmp1_, NULL);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		elapsed = _tmp2_;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp3_ = elapsed;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		next = (gint) (_tmp3_ + 1.0);
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp4_ = next;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp5_ = elapsed;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		wait = _tmp4_ - _tmp5_;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp6_ = wait;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp7_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) ((gint) (_tmp6_ * 1000)), _game_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		self->priv->clock_timeout = _tmp7_;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_signal_emit_by_name (self, "tick");
#line 2681 "game.c"
	}
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = FALSE;
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 2687 "game.c"
}


void game_undo (Game* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	GList* _tmp3_ = NULL;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_if_fail (self != NULL);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = game_get_can_undo (self);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp1_ = _tmp0_;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (!_tmp1_) {
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		return;
#line 2706 "game.c"
	}
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	game_set_selected_tile (self, NULL);
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	game_set_hint (self, NULL, NULL);
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp2_ = self->move_number;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->move_number = _tmp2_ - 1;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp3_ = self->tiles;
#line 2718 "game.c"
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		tile_collection = _tmp3_;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
#line 2726 "game.c"
			Tile* _tmp4_ = NULL;
			Tile* tile = NULL;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			_tmp4_ = _g_object_ref0 ((Tile*) tile_it->data);
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			tile = _tmp4_;
#line 2733 "game.c"
			{
				Tile* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp5_ = tile;
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp6_ = _tmp5_->move_number;
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp7_ = self->move_number;
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (_tmp6_ == _tmp7_) {
#line 2746 "game.c"
					Tile* _tmp8_ = NULL;
					Tile* _tmp9_ = NULL;
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp8_ = tile;
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp8_->visible = TRUE;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp9_ = tile;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					g_signal_emit_by_name (self, "redraw-tile", _tmp9_);
#line 2757 "game.c"
				}
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_g_object_unref0 (tile);
#line 2761 "game.c"
			}
		}
	}
}


void game_redo (Game* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GList* _tmp2_ = NULL;
	gint _tmp9_ = 0;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_if_fail (self != NULL);
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = game_get_can_redo (self);
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp1_ = _tmp0_;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (!_tmp1_) {
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		return;
#line 2783 "game.c"
	}
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	game_set_selected_tile (self, NULL);
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	game_set_hint (self, NULL, NULL);
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp2_ = self->tiles;
#line 2791 "game.c"
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		tile_collection = _tmp2_;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
#line 2799 "game.c"
			Tile* _tmp3_ = NULL;
			Tile* tile = NULL;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			_tmp3_ = _g_object_ref0 ((Tile*) tile_it->data);
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			tile = _tmp3_;
#line 2806 "game.c"
			{
				Tile* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp4_ = tile;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp5_ = _tmp4_->move_number;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp6_ = self->move_number;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (_tmp5_ == _tmp6_) {
#line 2819 "game.c"
					Tile* _tmp7_ = NULL;
					Tile* _tmp8_ = NULL;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp7_ = tile;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp7_->visible = FALSE;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp8_ = tile;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					g_signal_emit_by_name (self, "redraw-tile", _tmp8_);
#line 2830 "game.c"
				}
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_g_object_unref0 (tile);
#line 2834 "game.c"
			}
		}
	}
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp9_ = self->move_number;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->move_number = _tmp9_ + 1;
#line 2842 "game.c"
}


gboolean game_get_started (Game* self) {
	gboolean result;
	GTimer* _tmp0_ = NULL;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = self->priv->clock;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = _tmp0_ != NULL;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 2857 "game.c"
}


gdouble game_get_elapsed (Game* self) {
	gdouble result;
	GTimer* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GTimer* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = self->priv->clock;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp0_ == NULL) {
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		result = 0.0;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		return result;
#line 2877 "game.c"
	}
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp1_ = self->priv->clock_elapsed;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp2_ = self->priv->clock;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp3_ = g_timer_elapsed (_tmp2_, NULL);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = _tmp1_ + _tmp3_;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 2889 "game.c"
}


gboolean game_get_paused (Game* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = self->priv->_paused;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = _tmp0_;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 2904 "game.c"
}


void game_set_paused (Game* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	GTimer* _tmp1_ = NULL;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_if_fail (self != NULL);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = value;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->priv->_paused = _tmp0_;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp1_ = self->priv->clock;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp1_ != NULL) {
#line 2921 "game.c"
		gboolean _tmp2_ = FALSE;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp2_ = value;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		if (_tmp2_) {
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			game_stop_clock (self);
#line 2929 "game.c"
		} else {
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			game_continue_clock (self);
#line 2933 "game.c"
		}
	}
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_signal_emit_by_name (self, "paused-changed");
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_object_notify ((GObject *) self, "paused");
#line 2940 "game.c"
}


Tile* game_get_selected_tile (Game* self) {
	Tile* result;
	Tile* _tmp0_ = NULL;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = self->priv->_selected_tile;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = _tmp0_;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 2955 "game.c"
}


void game_set_selected_tile (Game* self, Tile* value) {
	Tile* _tmp0_ = NULL;
	Tile* _tmp2_ = NULL;
	Tile* _tmp3_ = NULL;
	Tile* _tmp4_ = NULL;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_if_fail (self != NULL);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = self->priv->_selected_tile;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp0_ != NULL) {
#line 2970 "game.c"
		Tile* _tmp1_ = NULL;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp1_ = self->priv->_selected_tile;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_signal_emit_by_name (self, "redraw-tile", _tmp1_);
#line 2976 "game.c"
	}
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp2_ = value;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_g_object_unref0 (self->priv->_selected_tile);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->priv->_selected_tile = _tmp3_;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp4_ = value;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	if (_tmp4_ != NULL) {
#line 2990 "game.c"
		Tile* _tmp5_ = NULL;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		_tmp5_ = value;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_signal_emit_by_name (self, "redraw-tile", _tmp5_);
#line 2996 "game.c"
	}
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_object_notify ((GObject *) self, "selected-tile");
#line 3000 "game.c"
}


gint game_get_visible_tiles (Game* self) {
	gint result;
	gint n = 0;
	GList* _tmp0_ = NULL;
	gint _tmp5_ = 0;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	n = 0;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = self->tiles;
#line 3015 "game.c"
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		tile_collection = _tmp0_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
#line 3023 "game.c"
			Tile* _tmp1_ = NULL;
			Tile* tile = NULL;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			_tmp1_ = _g_object_ref0 ((Tile*) tile_it->data);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			tile = _tmp1_;
#line 3030 "game.c"
			{
				Tile* _tmp2_ = NULL;
				gboolean _tmp3_ = FALSE;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp2_ = tile;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp3_ = _tmp2_->visible;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (_tmp3_) {
#line 3040 "game.c"
					gint _tmp4_ = 0;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_tmp4_ = n;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					n = _tmp4_ + 1;
#line 3046 "game.c"
				}
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_g_object_unref0 (tile);
#line 3050 "game.c"
			}
		}
	}
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp5_ = n;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = _tmp5_;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 3060 "game.c"
}


guint game_get_moves_left (Game* self) {
	guint result;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = game_find_matches (self, NULL);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp1_ = _tmp0_;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp2_ = g_list_length (_tmp1_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp3_ = _tmp2_;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	__g_list_free__g_object_unref0_0 (_tmp1_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = _tmp3_;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 3086 "game.c"
}


gboolean game_get_complete (Game* self) {
	gboolean result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = game_get_visible_tiles (self);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp1_ = _tmp0_;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = _tmp1_ == 0;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 3104 "game.c"
}


gboolean game_get_can_move (Game* self) {
	gboolean result;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = game_get_moves_left (self);
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp1_ = _tmp0_;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = _tmp1_ != ((guint) 0);
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 3122 "game.c"
}


gboolean game_get_can_undo (Game* self) {
	gboolean result;
	gint _tmp0_ = 0;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = self->move_number;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = _tmp0_ > 1;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 3137 "game.c"
}


gboolean game_get_can_redo (Game* self) {
	gboolean result;
	GList* _tmp0_ = NULL;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_tmp0_ = self->tiles;
#line 3148 "game.c"
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		tile_collection = _tmp0_;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
#line 3156 "game.c"
			Tile* _tmp1_ = NULL;
			Tile* tile = NULL;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			_tmp1_ = _g_object_ref0 ((Tile*) tile_it->data);
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
			tile = _tmp1_;
#line 3163 "game.c"
			{
				Tile* _tmp2_ = NULL;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp2_ = tile;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp3_ = _tmp2_->move_number;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_tmp4_ = self->move_number;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				if (_tmp3_ >= _tmp4_) {
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					result = TRUE;
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					_g_object_unref0 (tile);
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
					return result;
#line 3182 "game.c"
				}
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
				_g_object_unref0 (tile);
#line 3186 "game.c"
			}
		}
	}
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	result = FALSE;
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	return result;
#line 3194 "game.c"
}


static void game_class_init (GameClass * klass) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	game_parent_class = g_type_class_peek_parent (klass);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_type_class_add_private (klass, sizeof (GamePrivate));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_STARTED, g_param_spec_boolean ("started", "started", "started", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_ELAPSED, g_param_spec_double ("elapsed", "elapsed", "elapsed", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_PAUSED, g_param_spec_boolean ("paused", "paused", "paused", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SELECTED_TILE, g_param_spec_object ("selected-tile", "selected-tile", "selected-tile", TYPE_TILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VISIBLE_TILES, g_param_spec_int ("visible-tiles", "visible-tiles", "visible-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_MOVES_LEFT, g_param_spec_uint ("moves-left", "moves-left", "moves-left", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_COMPLETE, g_param_spec_boolean ("complete", "complete", "complete", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_CAN_MOVE, g_param_spec_boolean ("can-move", "can-move", "can-move", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_CAN_UNDO, g_param_spec_boolean ("can-undo", "can-undo", "can-undo", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_CAN_REDO, g_param_spec_boolean ("can-redo", "can-redo", "can-redo", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_signal_new ("redraw_tile", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_TILE);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_signal_new ("moved", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_signal_new ("paused_changed", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	g_signal_new ("tick", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 3237 "game.c"
}


static void game_instance_init (Game * self) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->priv = GAME_GET_PRIVATE (self);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->tiles = NULL;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->priv->hint_timout = (guint) 0;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->hint_blink_counter = (guint) 0;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->priv->_paused = FALSE;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self->priv->_selected_tile = NULL;
#line 3254 "game.c"
}


static void game_finalize (GObject* obj) {
	Game * self;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_g_object_unref0 (self->map);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	__g_list_free__g_object_unref0_0 (self->tiles);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_vala_array_destroy (self->hint_tiles, 2, (GDestroyNotify) g_object_unref);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_g_timer_destroy0 (self->priv->clock);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	_g_object_unref0 (self->priv->_selected_tile);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
#line 3274 "game.c"
}


GType game_get_type (void) {
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
		GType game_type_id;
		game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}


static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	switch (property_id) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		case GAME_STARTED:
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_value_set_boolean (value, game_get_started (self));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		break;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		case GAME_ELAPSED:
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_value_set_double (value, game_get_elapsed (self));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		break;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		case GAME_PAUSED:
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_value_set_boolean (value, game_get_paused (self));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		break;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		case GAME_SELECTED_TILE:
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_value_set_object (value, game_get_selected_tile (self));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		break;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		case GAME_VISIBLE_TILES:
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_value_set_int (value, game_get_visible_tiles (self));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		break;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		case GAME_MOVES_LEFT:
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_value_set_uint (value, game_get_moves_left (self));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		break;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		case GAME_COMPLETE:
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_value_set_boolean (value, game_get_complete (self));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		break;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		case GAME_CAN_MOVE:
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_value_set_boolean (value, game_get_can_move (self));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		break;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		case GAME_CAN_UNDO:
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_value_set_boolean (value, game_get_can_undo (self));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		break;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		case GAME_CAN_REDO:
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		g_value_set_boolean (value, game_get_can_redo (self));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		break;
#line 3355 "game.c"
		default:
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		break;
#line 3361 "game.c"
	}
}


static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
	switch (property_id) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		case GAME_PAUSED:
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		game_set_paused (self, g_value_get_boolean (value));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		break;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		case GAME_SELECTED_TILE:
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		game_set_selected_tile (self, g_value_get_object (value));
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		break;
#line 3383 "game.c"
		default:
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game.vala"
		break;
#line 3389 "game.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



