/* iagno.c generated by valac 0.28.0.2-022b, the Vala compiler
 * generated from iagno.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This file is part of Iagno.
 *
 * Iagno is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Iagno is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Iagno. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <canberra-gtk.h>
#include <canberra.h>


#define TYPE_IAGNO (iagno_get_type ())
#define IAGNO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IAGNO, Iagno))
#define IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IAGNO, IagnoClass))
#define IS_IAGNO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IAGNO))
#define IS_IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IAGNO))
#define IAGNO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IAGNO, IagnoClass))

typedef struct _Iagno Iagno;
typedef struct _IagnoClass IagnoClass;
typedef struct _IagnoPrivate IagnoPrivate;

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;

#define TYPE_THEMES_DIALOG (themes_dialog_get_type ())
#define THEMES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEMES_DIALOG, ThemesDialog))
#define THEMES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEMES_DIALOG, ThemesDialogClass))
#define IS_THEMES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEMES_DIALOG))
#define IS_THEMES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEMES_DIALOG))
#define THEMES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEMES_DIALOG, ThemesDialogClass))

typedef struct _ThemesDialog ThemesDialog;
typedef struct _ThemesDialogClass ThemesDialogClass;

#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;

#define TYPE_PLAYER (player_get_type ())

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define IAGNO_TYPE_SOUND (iagno_sound_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef struct _Block3Data Block3Data;

#define TYPE_GAME_WINDOW_FLAGS (game_window_flags_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GameWindowPrivate GameWindowPrivate;

struct _Iagno {
	GtkApplication parent_instance;
	IagnoPrivate * priv;
};

struct _IagnoClass {
	GtkApplicationClass parent_class;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

struct _IagnoPrivate {
	GSettings* settings;
	GameWindow* window;
	GameView* view;
	GtkLabel* dark_score_label;
	GtkLabel* light_score_label;
	ThemesDialog* themes_dialog;
	ComputerPlayer* computer;
	Player player_one;
	Game* game;
};

typedef enum  {
	IAGNO_SOUND_FLIP,
	IAGNO_SOUND_GAMEOVER
} IagnoSound;

struct _Block3Data {
	int _ref_count_;
	Iagno* self;
	GtkBox* level_box;
	GtkBox* color_box;
};

typedef enum  {
	GAME_WINDOW_FLAGS_SHOW_UNDO = 1 << 0,
	GAME_WINDOW_FLAGS_SHOW_REDO = 1 << 1,
	GAME_WINDOW_FLAGS_SHOW_HINT = 1 << 2
} GameWindowFlags;

struct _GameWindow {
	GtkApplicationWindow parent_instance;
	GameWindowPrivate * priv;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
};

struct _GameWindowClass {
	GtkApplicationWindowClass parent_class;
};


static gpointer iagno_parent_class = NULL;
static gboolean iagno_fast_mode;
static gboolean iagno_fast_mode = FALSE;
static gboolean iagno_alternative_start;
static gboolean iagno_alternative_start = FALSE;
static gchar* iagno_level;
static gchar* iagno_level = NULL;
static gint iagno_size;
static gint iagno_size = 8;
static gboolean* iagno_sound;
static gboolean* iagno_sound = NULL;
static gboolean iagno_two_players;
static gboolean iagno_two_players = FALSE;
static gboolean* iagno_play_first;
static gboolean* iagno_play_first = NULL;

GType iagno_get_type (void) G_GNUC_CONST;
GType game_window_get_type (void) G_GNUC_CONST;
GType game_view_get_type (void) G_GNUC_CONST;
GType themes_dialog_get_type (void) G_GNUC_CONST;
GType computer_player_get_type (void) G_GNUC_CONST;
GType player_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define IAGNO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IAGNO, IagnoPrivate))
enum  {
	IAGNO_DUMMY_PROPERTY
};
static GType iagno_sound_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define IAGNO_QUICK_MOVE_DELAY 0.4
#define IAGNO_MODERATE_MOVE_DELAY 1.0
#define IAGNO_SLOW_MOVE_DELAY 2.0
static void iagno_theme_cb (Iagno* self);
static void _iagno_theme_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_help_cb (Iagno* self);
static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_about_cb (Iagno* self);
static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
gint iagno_main (gchar** args, int args_length1);
static Iagno* iagno_new (void);
static Iagno* iagno_construct (GType object_type);
static gint iagno_real_handle_local_options (GApplication* base, GVariantDict* options);
static gboolean* _bool_dup (gboolean* self);
static void iagno_real_startup (GApplication* base);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void iagno_player_move_cb (Iagno* self, gint x, gint y);
static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self);
void game_view_set_scoreboard (GameView* self, GtkDrawingArea* value);
void game_view_set_theme (GameView* self, const gchar* value);
GType game_window_flags_get_type (void) G_GNUC_CONST;
GameWindow* game_window_new (const gchar* css_resource, const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view);
GameWindow* game_window_construct (GType object_type, const gchar* css_resource, const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view);
void game_window_add_to_sidebox (GameWindow* self, GtkWidget* widget);
static void iagno_start_game (Iagno* self);
static void _iagno_start_game_game_window_play (GameWindow* _sender, gpointer self);
static void iagno_wait_cb (Iagno* self);
static void _iagno_wait_cb_game_window_wait (GameWindow* _sender, gpointer self);
static void iagno_back_cb (Iagno* self);
static void _iagno_back_cb_game_window_back (GameWindow* _sender, gpointer self);
static void iagno_undo_cb (Iagno* self);
static void _iagno_undo_cb_game_window_undo (GameWindow* _sender, gpointer self);
static void __lambda8_ (Block3Data* _data3_);
static void ___lambda8__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void iagno_real_activate (GApplication* base);
static void iagno_real_shutdown (GApplication* base);
void game_window_shutdown (GameWindow* self, GSettings* settings);
ThemesDialog* themes_dialog_new (GSettings* settings, GameView* view);
ThemesDialog* themes_dialog_construct (GType object_type, GSettings* settings, GameView* view);
Player game_get_current_color (Game* self);
gboolean game_get_is_complete (Game* self);
void computer_player_move_async (ComputerPlayer* self, gdouble delay_seconds, GAsyncReadyCallback _callback_, gpointer _user_data_);
void computer_player_move_finish (ComputerPlayer* self, GAsyncResult* _res_);
static void iagno_game_complete (Iagno* self, gboolean play_gameover_sound);
void computer_player_cancel_move (ComputerPlayer* self);
Game* game_new (gboolean alternative_start, gint tmp_size);
Game* game_construct (GType object_type, gboolean alternative_start, gint tmp_size);
static void iagno_turn_ended_cb (Iagno* self);
static void _iagno_turn_ended_cb_game_turn_ended (Game* _sender, gpointer self);
void game_view_set_game (GameView* self, Game* value);
ComputerPlayer* computer_player_new (Game* game, gint difficulty_level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint difficulty_level);
static void iagno_update_ui (Iagno* self);
void game_window_set_subtitle (GameWindow* self, const gchar* subtitle);
gint game_get_number_of_moves (Game* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
void game_undo (Game* self, gint count);
gboolean game_get_current_player_can_move (Game* self);
static void iagno_play_sound (Iagno* self, IagnoSound sound);
void game_view_update_scoreboard (GameView* self);
static void iagno_prepare_move (Iagno* self);
static void iagno_pass (Iagno* self);
void game_pass (Game* self);
void game_window_finish_game (GameWindow* self);
gint game_place_tile (Game* self, gint x, gint y, gboolean apply);
const gchar* game_view_get_sound_flip (GameView* self);
const gchar* game_view_get_sound_gameover (GameView* self);
static void iagno_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry IAGNO_option_entries[11] = {{"alternative-start", (gchar) 0, 0, G_OPTION_ARG_NONE, &iagno_alternative_start, "Start with an alternative position", NULL}, {"fast-mode", 'f', 0, G_OPTION_ARG_NONE, &iagno_fast_mode, "Reduce delay before AI moves", NULL}, {"first", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Play first", NULL}, {"level", 'l', 0, G_OPTION_ARG_STRING, &iagno_level, "Set the level of the computer's AI", "LEVEL"}, {"mute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn off the sound", NULL}, {"second", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Play second", NULL}, {"size", 's', 0, G_OPTION_ARG_INT, &iagno_size, "Size of the board (debug only)", "SIZE"}, {"two-players", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Two-players mode", NULL}, {"unmute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn on the sound", NULL}, {"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Print release version and exit", NULL}, {NULL}};
static const GActionEntry IAGNO_app_actions[4] = {{"theme", _iagno_theme_cb_gsimple_action_activate_callback}, {"help", _iagno_help_cb_gsimple_action_activate_callback}, {"about", _iagno_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};

static GType iagno_sound_get_type (void) {
	static volatile gsize iagno_sound_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_sound_type_id__volatile)) {
		static const GEnumValue values[] = {{IAGNO_SOUND_FLIP, "IAGNO_SOUND_FLIP", "flip"}, {IAGNO_SOUND_GAMEOVER, "IAGNO_SOUND_GAMEOVER", "gameover"}, {0, NULL, NULL}};
		GType iagno_sound_type_id;
		iagno_sound_type_id = g_enum_register_static ("IagnoSound", values);
		g_once_init_leave (&iagno_sound_type_id__volatile, iagno_sound_type_id);
	}
	return iagno_sound_type_id__volatile;
}


static void _iagno_theme_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_theme_cb ((Iagno*) self);
#line 291 "iagno.c"
}


static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_help_cb ((Iagno*) self);
#line 298 "iagno.c"
}


static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_about_cb ((Iagno*) self);
#line 305 "iagno.c"
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_application_quit ((GApplication*) self);
#line 312 "iagno.c"
}


gint iagno_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	Iagno* _tmp1_ = NULL;
	Iagno* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	setlocale (LC_ALL, "");
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 83 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	textdomain (GETTEXT_PACKAGE);
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = _ ("Iagno");
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_set_application_name (_tmp0_);
#line 87 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_window_set_default_icon_name ("iagno");
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = iagno_new ();
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = _tmp1_;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = args;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3__length1 = args_length1;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = g_application_run ((GApplication*) _tmp2_, _tmp3__length1, _tmp3_);
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = _tmp4_;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp2_);
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	result = _tmp5_;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return result;
#line 357 "iagno.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return iagno_main (argv, argc);
#line 367 "iagno.c"
}


static Iagno* iagno_construct (GType object_type) {
	Iagno * self = NULL;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) g_object_new (object_type, "application-id", "org.gnome.iagno", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_application_add_main_option_entries ((GApplication*) self, IAGNO_option_entries);
#line 92 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return self;
#line 379 "iagno.c"
}


static Iagno* iagno_new (void) {
#line 92 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return iagno_construct (TYPE_IAGNO);
#line 386 "iagno.c"
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	dup = g_new0 (gboolean, 1);
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	memcpy (dup, self, sizeof (gboolean));
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return dup;
#line 398 "iagno.c"
}


static gpointer __bool_dup0 (gpointer self) {
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return self ? _bool_dup (self) : NULL;
#line 405 "iagno.c"
}


static gint iagno_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Iagno * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gint _tmp3_ = 0;
	GVariantDict* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GVariantDict* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
#line 99 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 99 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = options;
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 429 "iagno.c"
		FILE* _tmp2_ = NULL;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = stderr;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		fprintf (_tmp2_, "%1$s %2$s\n", "iagno", VERSION);
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		result = EXIT_SUCCESS;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return result;
#line 439 "iagno.c"
	}
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = iagno_size;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp3_ < 4) {
#line 445 "iagno.c"
		FILE* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = stderr;
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = _ ("Size must be at least 4.");
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		fprintf (_tmp4_, "%s\n", _tmp5_);
#line 112 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		result = EXIT_FAILURE;
#line 112 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return result;
#line 458 "iagno.c"
	}
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = options;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp7_ = g_variant_dict_contains (_tmp6_, "mute");
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp7_) {
#line 466 "iagno.c"
		gboolean _tmp8_ = FALSE;
		gboolean* _tmp9_ = NULL;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = FALSE;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = __bool_dup0 (&_tmp8_);
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_free0 (iagno_sound);
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_sound = _tmp9_;
#line 477 "iagno.c"
	} else {
		GVariantDict* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = options;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp11_ = g_variant_dict_contains (_tmp10_, "unmute");
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp11_) {
#line 487 "iagno.c"
			gboolean _tmp12_ = FALSE;
			gboolean* _tmp13_ = NULL;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp12_ = TRUE;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp13_ = __bool_dup0 (&_tmp12_);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (iagno_sound);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_sound = _tmp13_;
#line 498 "iagno.c"
		}
	}
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp14_ = options;
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp15_ = g_variant_dict_contains (_tmp14_, "two-players");
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp15_) {
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_two_players = TRUE;
#line 509 "iagno.c"
	} else {
		GVariantDict* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp16_ = options;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp17_ = g_variant_dict_contains (_tmp16_, "first");
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp17_) {
#line 519 "iagno.c"
			gboolean _tmp18_ = FALSE;
			gboolean* _tmp19_ = NULL;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp18_ = TRUE;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp19_ = __bool_dup0 (&_tmp18_);
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (iagno_play_first);
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_play_first = _tmp19_;
#line 530 "iagno.c"
		} else {
			GVariantDict* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp20_ = options;
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp21_ = g_variant_dict_contains (_tmp20_, "second");
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			if (_tmp21_) {
#line 540 "iagno.c"
				gboolean _tmp22_ = FALSE;
				gboolean* _tmp23_ = NULL;
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				_tmp22_ = FALSE;
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				_tmp23_ = __bool_dup0 (&_tmp22_);
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				_g_free0 (iagno_play_first);
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				iagno_play_first = _tmp23_;
#line 551 "iagno.c"
			}
		}
	}
#line 128 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	result = -1;
#line 128 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return result;
#line 559 "iagno.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return _data3_;
#line 568 "iagno.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 577 "iagno.c"
		Iagno* self;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self = _data3_->self;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (_data3_->color_box);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (_data3_->level_box);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (self);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_slice_free (Block3Data, _data3_);
#line 589 "iagno.c"
	}
}


static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self) {
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_player_move_cb ((Iagno*) self, x, y);
#line 597 "iagno.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return self ? g_object_ref (self) : NULL;
#line 604 "iagno.c"
}


static void _iagno_start_game_game_window_play (GameWindow* _sender, gpointer self) {
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_start_game ((Iagno*) self);
#line 611 "iagno.c"
}


static void _iagno_wait_cb_game_window_wait (GameWindow* _sender, gpointer self) {
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_wait_cb ((Iagno*) self);
#line 618 "iagno.c"
}


static void _iagno_back_cb_game_window_back (GameWindow* _sender, gpointer self) {
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_back_cb ((Iagno*) self);
#line 625 "iagno.c"
}


static void _iagno_undo_cb_game_window_undo (GameWindow* _sender, gpointer self) {
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_undo_cb ((Iagno*) self);
#line 632 "iagno.c"
}


static void __lambda8_ (Block3Data* _data3_) {
	Iagno* self;
	gboolean solo = FALSE;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GtkBox* _tmp2_ = NULL;
	GtkBox* _tmp3_ = NULL;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = _data3_->self;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->settings;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = g_settings_get_int (_tmp0_, "num-players");
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	solo = _tmp1_ == 1;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = _data3_->level_box;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, solo);
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = _data3_->color_box;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, solo);
#line 659 "iagno.c"
}


static void ___lambda8__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	__lambda8_ (self);
#line 666 "iagno.c"
}


static void iagno_real_startup (GApplication* base) {
	Iagno * self;
	Block3Data* _data3_;
	GSettings* _tmp0_ = NULL;
	gboolean* _tmp1_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean start_now = FALSE;
	gboolean _tmp7_ = FALSE;
	gchar* color = NULL;
	gboolean* _tmp13_ = NULL;
	gint computer_level = 0;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	const gchar* _tmp23_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp35_ = NULL;
	GameView* _tmp36_ = NULL;
	GameView* _tmp37_ = NULL;
	GtkDrawingArea* scoredrawing = NULL;
	GtkBuilder* _tmp38_ = NULL;
	GObject* _tmp39_ = NULL;
	GtkDrawingArea* _tmp40_ = NULL;
	GameView* _tmp41_ = NULL;
	GtkDrawingArea* _tmp42_ = NULL;
	GameView* _tmp43_ = NULL;
	GSettings* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	GSettings* _tmp48_ = NULL;
	gint _tmp49_ = 0;
	GSettings* _tmp50_ = NULL;
	gint _tmp51_ = 0;
	GSettings* _tmp52_ = NULL;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp54_ = FALSE;
	GtkBuilder* _tmp55_ = NULL;
	GObject* _tmp56_ = NULL;
	GameView* _tmp57_ = NULL;
	GameWindow* _tmp58_ = NULL;
	GtkWidget* scoregrid = NULL;
	GtkBuilder* _tmp59_ = NULL;
	GObject* _tmp60_ = NULL;
	GtkWidget* _tmp61_ = NULL;
	GameWindow* _tmp62_ = NULL;
	GtkWidget* _tmp63_ = NULL;
	GameWindow* _tmp64_ = NULL;
	GameWindow* _tmp65_ = NULL;
	GameWindow* _tmp66_ = NULL;
	GameWindow* _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
	gchar** _tmp69_ = NULL;
	gchar** _tmp70_ = NULL;
	gint _tmp70__length1 = 0;
	gchar* _tmp71_ = NULL;
	gchar** _tmp72_ = NULL;
	gchar** _tmp73_ = NULL;
	gint _tmp73__length1 = 0;
	gchar* _tmp74_ = NULL;
	gchar** _tmp75_ = NULL;
	gchar** _tmp76_ = NULL;
	gint _tmp76__length1 = 0;
	gchar* _tmp77_ = NULL;
	gchar** _tmp78_ = NULL;
	gchar** _tmp79_ = NULL;
	gint _tmp79__length1 = 0;
	gchar* _tmp80_ = NULL;
	gchar** _tmp81_ = NULL;
	gchar** _tmp82_ = NULL;
	gint _tmp82__length1 = 0;
	GSettings* _tmp83_ = NULL;
	GAction* _tmp84_ = NULL;
	GAction* _tmp85_ = NULL;
	GSettings* _tmp86_ = NULL;
	GAction* _tmp87_ = NULL;
	GAction* _tmp88_ = NULL;
	GSettings* _tmp89_ = NULL;
	GAction* _tmp90_ = NULL;
	GAction* _tmp91_ = NULL;
	GSettings* _tmp92_ = NULL;
	GAction* _tmp93_ = NULL;
	GAction* _tmp94_ = NULL;
	GtkBuilder* _tmp95_ = NULL;
	GObject* _tmp96_ = NULL;
	GtkBox* _tmp97_ = NULL;
	GtkBuilder* _tmp98_ = NULL;
	GObject* _tmp99_ = NULL;
	GtkBox* _tmp100_ = NULL;
	GSettings* _tmp101_ = NULL;
	gboolean solo = FALSE;
	GSettings* _tmp102_ = NULL;
	gint _tmp103_ = 0;
	GtkBox* _tmp104_ = NULL;
	gboolean _tmp105_ = FALSE;
	GtkBox* _tmp106_ = NULL;
	gboolean _tmp107_ = FALSE;
	GtkBuilder* _tmp108_ = NULL;
	GObject* _tmp109_ = NULL;
	GtkLabel* _tmp110_ = NULL;
	GtkBuilder* _tmp111_ = NULL;
	GObject* _tmp112_ = NULL;
	GtkLabel* _tmp113_ = NULL;
	gboolean _tmp114_ = FALSE;
	GameWindow* _tmp115_ = NULL;
	GSettings* _tmp116_ = NULL;
	const gchar* _tmp117_ = NULL;
	GSettings* _tmp118_ = NULL;
	gint _tmp119_ = 0;
	gint _tmp120_ = 0;
	gboolean _tmp121_ = FALSE;
	GSettings* _tmp122_ = NULL;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_->_ref_count_ = 1;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_->self = g_object_ref (self);
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	G_APPLICATION_CLASS (iagno_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = g_settings_new ("org.gnome.iagno");
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->settings);
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->settings = _tmp0_;
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = iagno_sound;
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_ != NULL) {
#line 802 "iagno.c"
		GSettings* _tmp2_ = NULL;
		gboolean* _tmp3_ = NULL;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = self->priv->settings;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = iagno_sound;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_settings_set_boolean (_tmp2_, "sound", *_tmp3_);
#line 811 "iagno.c"
	}
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = iagno_two_players;
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp5_ == TRUE) {
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = TRUE;
#line 819 "iagno.c"
	} else {
		gboolean* _tmp6_ = NULL;
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = iagno_play_first;
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = _tmp6_ != NULL;
#line 826 "iagno.c"
	}
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	start_now = _tmp4_;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp7_ = start_now;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp7_) {
#line 834 "iagno.c"
		gint _tmp8_ = 0;
		gboolean _tmp9_ = FALSE;
		GSettings* _tmp10_ = NULL;
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = iagno_two_players;
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp9_) {
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp8_ = 2;
#line 844 "iagno.c"
		} else {
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp8_ = 1;
#line 848 "iagno.c"
		}
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = self->priv->settings;
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_settings_set_int (_tmp10_, "num-players", _tmp8_);
#line 854 "iagno.c"
	} else {
		GSettings* _tmp11_ = NULL;
		gint _tmp12_ = 0;
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp11_ = self->priv->settings;
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = g_settings_get_int (_tmp11_, "num-players");
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_two_players = _tmp12_ == 2;
#line 864 "iagno.c"
	}
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp13_ = iagno_play_first;
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp13_ != NULL) {
#line 870 "iagno.c"
		const gchar* _tmp14_ = NULL;
		gboolean* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		GSettings* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp15_ = iagno_play_first;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (*_tmp15_) {
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp14_ = "dark";
#line 882 "iagno.c"
		} else {
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp14_ = "light";
#line 886 "iagno.c"
		}
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp16_ = g_strdup (_tmp14_);
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_free0 (color);
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		color = _tmp16_;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp17_ = self->priv->settings;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp18_ = color;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_settings_set_string (_tmp17_, "color", _tmp18_);
#line 900 "iagno.c"
	} else {
		GSettings* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp19_ = self->priv->settings;
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp20_ = g_settings_get_string (_tmp19_, "color");
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_free0 (color);
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		color = _tmp20_;
#line 912 "iagno.c"
	}
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp23_ = iagno_level;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (g_strcmp0 (_tmp23_, "1") == 0) {
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp22_ = TRUE;
#line 920 "iagno.c"
	} else {
		const gchar* _tmp24_ = NULL;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp24_ = iagno_level;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp22_ = g_strcmp0 (_tmp24_, "2") == 0;
#line 927 "iagno.c"
	}
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp22_) {
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp21_ = TRUE;
#line 933 "iagno.c"
	} else {
		const gchar* _tmp25_ = NULL;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp25_ = iagno_level;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp21_ = g_strcmp0 (_tmp25_, "3") == 0;
#line 940 "iagno.c"
	}
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp21_) {
#line 944 "iagno.c"
		const gchar* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		GSettings* _tmp28_ = NULL;
		gint _tmp29_ = 0;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp26_ = iagno_level;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp27_ = atoi (_tmp26_);
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_level = _tmp27_;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp28_ = self->priv->settings;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp29_ = computer_level;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_settings_set_int (_tmp28_, "computer-level", _tmp29_);
#line 961 "iagno.c"
	} else {
		const gchar* _tmp30_ = NULL;
		GSettings* _tmp33_ = NULL;
		gint _tmp34_ = 0;
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp30_ = iagno_level;
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp30_ != NULL) {
#line 970 "iagno.c"
			FILE* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp31_ = stderr;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp32_ = _ ("Level should be between 1 (easy) and 3 (hard). Settings unchanged.");
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			fprintf (_tmp31_, "%s\n", _tmp32_);
#line 979 "iagno.c"
		}
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp33_ = self->priv->settings;
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp34_ = g_settings_get_int (_tmp33_, "computer-level");
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_level = _tmp34_;
#line 987 "iagno.c"
	}
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp35_ = gtk_builder_new_from_resource ("/org/gnome/iagno/ui/iagno-screens.ui");
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	builder = _tmp35_;
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp36_ = game_view_new ();
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp36_);
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->view);
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->view = _tmp36_;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp37_ = self->priv->view;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp37_, "move", (GCallback) _iagno_player_move_cb_game_view_move, self, 0);
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp38_ = builder;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp39_ = gtk_builder_get_object (_tmp38_, "scoredrawing");
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_drawing_area_get_type (), GtkDrawingArea));
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	scoredrawing = _tmp40_;
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp41_ = self->priv->view;
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp42_ = scoredrawing;
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_set_scoreboard (_tmp41_, _tmp42_);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp43_ = self->priv->view;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp44_ = self->priv->settings;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp45_ = g_settings_get_string (_tmp44_, "theme");
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp46_ = _tmp45_;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_set_theme (_tmp43_, _tmp46_);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (_tmp46_);
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp47_ = _ ("Iagno");
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp48_ = self->priv->settings;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp49_ = g_settings_get_int (_tmp48_, "window-width");
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp50_ = self->priv->settings;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp51_ = g_settings_get_int (_tmp50_, "window-height");
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp52_ = self->priv->settings;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp53_ = g_settings_get_boolean (_tmp52_, "window-is-maximized");
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp54_ = start_now;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp55_ = builder;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp56_ = gtk_builder_get_object (_tmp55_, "new-game-screen");
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp57_ = self->priv->view;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp58_ = game_window_new ("/org/gnome/iagno/ui/iagno.css", _tmp47_, _tmp49_, _tmp51_, _tmp53_, _tmp54_, GAME_WINDOW_FLAGS_SHOW_UNDO, G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gtk_box_get_type (), GtkBox), (GtkWidget*) _tmp57_);
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp58_);
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->window);
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->window = _tmp58_;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp59_ = builder;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp60_ = gtk_builder_get_object (_tmp59_, "scoregrid");
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp61_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, gtk_widget_get_type (), GtkWidget));
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	scoregrid = _tmp61_;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp62_ = self->priv->window;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp63_ = scoregrid;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_window_add_to_sidebox (_tmp62_, _tmp63_);
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp64_ = self->priv->window;
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp64_, "play", (GCallback) _iagno_start_game_game_window_play, self, 0);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp65_ = self->priv->window;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp65_, "wait", (GCallback) _iagno_wait_cb_game_window_wait, self, 0);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp66_ = self->priv->window;
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp66_, "back", (GCallback) _iagno_back_cb_game_window_back, self, 0);
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp67_ = self->priv->window;
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp67_, "undo", (GCallback) _iagno_undo_cb_game_window_undo, self, 0);
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action_entries ((GActionMap*) self, IAGNO_app_actions, G_N_ELEMENTS (IAGNO_app_actions), self);
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp68_ = g_strdup ("<Primary>n");
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp69_ = g_new0 (gchar*, 1 + 1);
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp69_[0] = _tmp68_;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp70_ = _tmp69_;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp70__length1 = 1;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.new-game", _tmp70_);
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp70_ = (_vala_array_free (_tmp70_, _tmp70__length1, (GDestroyNotify) g_free), NULL);
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp71_ = g_strdup ("<Primary><Shift>n");
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp72_ = g_new0 (gchar*, 1 + 1);
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp72_[0] = _tmp71_;
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp73_ = _tmp72_;
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp73__length1 = 1;
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.start-game", _tmp73_);
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp73_ = (_vala_array_free (_tmp73_, _tmp73__length1, (GDestroyNotify) g_free), NULL);
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp74_ = g_strdup ("<Primary>z");
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp75_ = g_new0 (gchar*, 1 + 1);
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp75_[0] = _tmp74_;
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp76_ = _tmp75_;
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp76__length1 = 1;
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.undo", _tmp76_);
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp76_ = (_vala_array_free (_tmp76_, _tmp76__length1, (GDestroyNotify) g_free), NULL);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp77_ = g_strdup ("<Primary><Shift>z");
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp78_ = g_new0 (gchar*, 1 + 1);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp78_[0] = _tmp77_;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp79_ = _tmp78_;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp79__length1 = 1;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.redo", _tmp79_);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp79_ = (_vala_array_free (_tmp79_, _tmp79__length1, (GDestroyNotify) g_free), NULL);
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp80_ = g_strdup ("Escape");
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp81_ = g_new0 (gchar*, 1 + 1);
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp81_[0] = _tmp80_;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp82_ = _tmp81_;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp82__length1 = 1;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.back", _tmp82_);
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp82_ = (_vala_array_free (_tmp82_, _tmp82__length1, (GDestroyNotify) g_free), NULL);
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp83_ = self->priv->settings;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp84_ = g_settings_create_action (_tmp83_, "sound");
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp85_ = _tmp84_;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp85_);
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp85_);
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp86_ = self->priv->settings;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp87_ = g_settings_create_action (_tmp86_, "color");
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp88_ = _tmp87_;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp88_);
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp88_);
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp89_ = self->priv->settings;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp90_ = g_settings_create_action (_tmp89_, "num-players");
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp91_ = _tmp90_;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp91_);
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp91_);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp92_ = self->priv->settings;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp93_ = g_settings_create_action (_tmp92_, "computer-level");
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp94_ = _tmp93_;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp94_);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp94_);
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp95_ = builder;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp96_ = gtk_builder_get_object (_tmp95_, "difficulty-box");
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp97_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, gtk_box_get_type (), GtkBox));
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_->level_box = _tmp97_;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp98_ = builder;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp99_ = gtk_builder_get_object (_tmp98_, "color-box");
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp100_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, gtk_box_get_type (), GtkBox));
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_->color_box = _tmp100_;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp101_ = self->priv->settings;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_data (_tmp101_, "changed::num-players", (GCallback) ___lambda8__g_settings_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp102_ = self->priv->settings;
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp103_ = g_settings_get_int (_tmp102_, "num-players");
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	solo = _tmp103_ == 1;
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp104_ = _data3_->level_box;
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp105_ = solo;
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp104_, _tmp105_);
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp106_ = _data3_->color_box;
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp107_ = solo;
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp106_, _tmp107_);
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp108_ = builder;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp109_ = gtk_builder_get_object (_tmp108_, "light-score-label");
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp110_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, gtk_label_get_type (), GtkLabel));
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->light_score_label);
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->light_score_label = _tmp110_;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp111_ = builder;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp112_ = gtk_builder_get_object (_tmp111_, "dark-score-label");
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp113_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp112_, gtk_label_get_type (), GtkLabel));
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->dark_score_label);
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->dark_score_label = _tmp113_;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp114_ = start_now;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp114_) {
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_start_game (self);
#line 1267 "iagno.c"
	}
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp115_ = self->priv->window;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp115_);
#line 236 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_settings_sync ();
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp116_ = self->priv->settings;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp117_ = color;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_settings_set_string (_tmp116_, "color", _tmp117_);
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp118_ = self->priv->settings;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp119_ = computer_level;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_settings_set_int (_tmp118_, "computer-level", _tmp119_);
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp121_ = iagno_two_players;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp121_) {
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp120_ = 2;
#line 1293 "iagno.c"
	} else {
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp120_ = 1;
#line 1297 "iagno.c"
	}
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp122_ = self->priv->settings;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_settings_set_int (_tmp122_, "num-players", _tmp120_);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (scoregrid);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (scoredrawing);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (builder);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (color);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	block3_data_unref (_data3_);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_ = NULL;
#line 1315 "iagno.c"
}


static void iagno_real_activate (GApplication* base) {
	Iagno * self;
	GameWindow* _tmp0_ = NULL;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 244 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->window;
#line 244 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 1328 "iagno.c"
}


static void iagno_real_shutdown (GApplication* base) {
	Iagno * self;
	GameWindow* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->window;
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->settings;
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_window_shutdown (_tmp0_, _tmp1_);
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	G_APPLICATION_CLASS (iagno_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 1346 "iagno.c"
}


static void iagno_theme_cb (Iagno* self) {
	ThemesDialog* _tmp0_ = NULL;
	ThemesDialog* _tmp6_ = NULL;
#line 257 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->themes_dialog;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_ == NULL) {
#line 1359 "iagno.c"
		GSettings* _tmp1_ = NULL;
		GameView* _tmp2_ = NULL;
		ThemesDialog* _tmp3_ = NULL;
		ThemesDialog* _tmp4_ = NULL;
		GameWindow* _tmp5_ = NULL;
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = self->priv->settings;
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = self->priv->view;
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = themes_dialog_new (_tmp1_, _tmp2_);
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_object_ref_sink (_tmp3_);
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (self->priv->themes_dialog);
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->themes_dialog = _tmp3_;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = self->priv->themes_dialog;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = self->priv->window;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		gtk_window_set_transient_for ((GtkWindow*) _tmp4_, (GtkWindow*) _tmp5_);
#line 1383 "iagno.c"
	}
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = self->priv->themes_dialog;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_window_present ((GtkWindow*) _tmp6_);
#line 1389 "iagno.c"
}


static void iagno_help_cb (Iagno* self) {
	GError * _inner_error_ = NULL;
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 1397 "iagno.c"
	{
		GameWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = self->priv->window;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		gtk_show_uri (_tmp1_, "help:iagno", _tmp2_, &_inner_error_);
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1412 "iagno.c"
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		e = _inner_error_;
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_inner_error_ = NULL;
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = e;
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = _tmp3_->message;
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_warning ("iagno.vala:276: Failed to show help: %s", _tmp4_);
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_error_free0 (e);
#line 1434 "iagno.c"
	}
	__finally5:
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_clear_error (&_inner_error_);
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return;
#line 1445 "iagno.c"
	}
}


static void iagno_about_cb (Iagno* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	GameWindow* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = g_strdup ("Ian Peters");
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = g_strdup ("Robert Ancell");
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = g_new0 (gchar*, 3 + 1);
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_[0] = _tmp0_;
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_[1] = _tmp1_;
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_[2] = NULL;
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	authors = _tmp2_;
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	authors_length1 = 3;
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_authors_size_ = authors_length1;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = g_strdup ("Tiffany Antopolski");
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = g_new0 (gchar*, 2 + 1);
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_[0] = _tmp3_;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_[1] = NULL;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	documenters = _tmp4_;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	documenters_length1 = 2;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_documenters_size_ = documenters_length1;
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = self->priv->window;
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = _ ("Iagno");
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp7_ = _ ("A disk flipping game derived from Reversi");
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp8_ = _ ("translator-credits");
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp5_, "name", _tmp6_, "version", VERSION, "copyright", "Copyright © 1998–2008 Ian Peters\n" "Copyright © 2013–2015 Michael Catanzaro\n" "Copyright © 2014–2015 Arnaud Bonatti", "license-type", GTK_LICENSE_GPL_3_0, "comments", _tmp7_, "authors", authors, "documenters", documenters, "translator-credits", _tmp8_, "logo-icon-name", "iagno", "website", "https://wiki.gnome.org/Apps/Iagno", NULL, NULL);
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 1514 "iagno.c"
}


static void iagno_back_cb (Iagno* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	Player _tmp5_ = 0;
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->game;
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = game_get_current_color (_tmp2_);
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = self->priv->player_one;
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp4_ != _tmp5_) {
#line 1537 "iagno.c"
		ComputerPlayer* _tmp6_ = NULL;
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->computer;
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = _tmp6_ != NULL;
#line 1543 "iagno.c"
	} else {
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = FALSE;
#line 1547 "iagno.c"
	}
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 1551 "iagno.c"
		Game* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->game;
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = game_get_is_complete (_tmp7_);
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = _tmp8_;
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = !_tmp9_;
#line 1563 "iagno.c"
	} else {
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = FALSE;
#line 1567 "iagno.c"
	}
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_) {
#line 1571 "iagno.c"
		ComputerPlayer* _tmp10_ = NULL;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = self->priv->computer;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_move_async (_tmp10_, IAGNO_SLOW_MOVE_DELAY, NULL, NULL);
#line 1577 "iagno.c"
	} else {
		Game* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp11_ = self->priv->game;
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = game_get_is_complete (_tmp11_);
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = _tmp12_;
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp13_) {
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_game_complete (self, FALSE);
#line 1592 "iagno.c"
		}
	}
}


static void iagno_wait_cb (Iagno* self) {
	ComputerPlayer* _tmp0_ = NULL;
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->computer;
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_ != NULL) {
#line 1606 "iagno.c"
		ComputerPlayer* _tmp1_ = NULL;
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = self->priv->computer;
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_cancel_move (_tmp1_);
#line 1612 "iagno.c"
	}
}


static void _iagno_turn_ended_cb_game_turn_ended (Game* _sender, gpointer self) {
#line 330 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_turn_ended_cb ((Iagno*) self);
#line 1620 "iagno.c"
}


static void iagno_start_game (Iagno* self) {
	Game* _tmp0_ = NULL;
	ComputerPlayer* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	Game* _tmp6_ = NULL;
	Game* _tmp7_ = NULL;
	GameView* _tmp8_ = NULL;
	Game* _tmp9_ = NULL;
	GSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GSettings* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gboolean _tmp18_ = FALSE;
	Player _tmp19_ = 0;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_ != NULL) {
#line 1645 "iagno.c"
		Game* _tmp1_ = NULL;
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = self->priv->game;
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 1651 "iagno.c"
	}
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->computer;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp2_ != NULL) {
#line 1657 "iagno.c"
		ComputerPlayer* _tmp3_ = NULL;
#line 327 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = self->priv->computer;
#line 327 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_cancel_move (_tmp3_);
#line 1663 "iagno.c"
	}
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = iagno_alternative_start;
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = iagno_size;
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = game_new (_tmp4_, _tmp5_);
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->game);
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->game = _tmp6_;
#line 330 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp7_ = self->priv->game;
#line 330 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp7_, "turn-ended", (GCallback) _iagno_turn_ended_cb_game_turn_ended, self, 0);
#line 331 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp8_ = self->priv->view;
#line 331 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp9_ = self->priv->game;
#line 331 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_set_game (_tmp8_, _tmp9_);
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp10_ = self->priv->settings;
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp11_ = g_settings_get_int (_tmp10_, "num-players");
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp11_ == 2) {
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (self->priv->computer);
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->computer = NULL;
#line 1695 "iagno.c"
	} else {
		Game* _tmp12_ = NULL;
		GSettings* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		ComputerPlayer* _tmp15_ = NULL;
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = self->priv->game;
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = self->priv->settings;
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp14_ = g_settings_get_int (_tmp13_, "computer-level");
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp15_ = computer_player_new (_tmp12_, _tmp14_);
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (self->priv->computer);
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->computer = _tmp15_;
#line 1713 "iagno.c"
	}
#line 338 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp16_ = self->priv->settings;
#line 338 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp17_ = g_settings_get_enum (_tmp16_, "color");
#line 338 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp17_ == 1) {
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->player_one = PLAYER_LIGHT;
#line 1723 "iagno.c"
	} else {
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->player_one = PLAYER_DARK;
#line 1727 "iagno.c"
	}
#line 343 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 345 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp19_ = self->priv->player_one;
#line 345 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp19_ != PLAYER_DARK) {
#line 1735 "iagno.c"
		ComputerPlayer* _tmp20_ = NULL;
#line 345 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp20_ = self->priv->computer;
#line 345 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp18_ = _tmp20_ != NULL;
#line 1741 "iagno.c"
	} else {
#line 345 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp18_ = FALSE;
#line 1745 "iagno.c"
	}
#line 345 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp18_) {
#line 1749 "iagno.c"
		ComputerPlayer* _tmp21_ = NULL;
#line 346 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp21_ = self->priv->computer;
#line 346 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_move_async (_tmp21_, IAGNO_MODERATE_MOVE_DELAY, NULL, NULL);
#line 1755 "iagno.c"
	}
}


static void iagno_update_ui (Iagno* self) {
	GameWindow* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Player _tmp2_ = 0;
	GtkLabel* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	Game* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	Game* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->window;
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_window_set_subtitle (_tmp0_, NULL);
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->player_one;
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp2_ == PLAYER_DARK) {
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = TRUE;
#line 1790 "iagno.c"
	} else {
		ComputerPlayer* _tmp3_ = NULL;
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = self->priv->computer;
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = _tmp3_ == NULL;
#line 1797 "iagno.c"
	}
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 1801 "iagno.c"
		GameWindow* _tmp4_ = NULL;
		GSimpleAction* _tmp5_ = NULL;
		Game* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = self->priv->window;
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = _tmp4_->undo_action;
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->game;
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = game_get_number_of_moves (_tmp6_);
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = _tmp7_;
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_simple_action_set_enabled (_tmp5_, _tmp8_ >= 1);
#line 1819 "iagno.c"
	} else {
		GameWindow* _tmp9_ = NULL;
		GSimpleAction* _tmp10_ = NULL;
		Game* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = self->priv->window;
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = _tmp9_->undo_action;
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp11_ = self->priv->game;
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = game_get_number_of_moves (_tmp11_);
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = _tmp12_;
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_simple_action_set_enabled (_tmp10_, _tmp13_ >= 2);
#line 1838 "iagno.c"
	}
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp14_ = self->priv->dark_score_label;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp15_ = _ ("%.2d");
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp16_ = self->priv->game;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp17_ = game_get_n_dark_tiles (_tmp16_);
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp18_ = _tmp17_;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp19_ = g_strdup_printf (_tmp15_, _tmp18_);
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp20_ = _tmp19_;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_label_set_text (_tmp14_, _tmp20_);
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (_tmp20_);
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp21_ = self->priv->light_score_label;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp22_ = _ ("%.2d");
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp23_ = self->priv->game;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp24_ = game_get_n_light_tiles (_tmp23_);
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp25_ = _tmp24_;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp26_ = g_strdup_printf (_tmp22_, _tmp25_);
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp27_ = _tmp26_;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_label_set_text (_tmp21_, _tmp27_);
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (_tmp27_);
#line 1876 "iagno.c"
}


static void iagno_undo_cb (Iagno* self) {
	ComputerPlayer* _tmp0_ = NULL;
	GameView* _tmp17_ = NULL;
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 365 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->computer;
#line 365 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_ == NULL) {
#line 1889 "iagno.c"
		Game* _tmp1_ = NULL;
		Game* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 367 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = self->priv->game;
#line 367 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		game_undo (_tmp1_, 1);
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = self->priv->game;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = game_get_current_player_can_move (_tmp2_);
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = _tmp3_;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (!_tmp4_) {
#line 1906 "iagno.c"
			Game* _tmp5_ = NULL;
#line 369 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp5_ = self->priv->game;
#line 369 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_undo (_tmp5_, 1);
#line 1912 "iagno.c"
		}
	} else {
		ComputerPlayer* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
		Player _tmp8_ = 0;
		Player _tmp9_ = 0;
		Player _tmp10_ = 0;
#line 373 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->computer;
#line 373 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_cancel_move (_tmp6_);
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->game;
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = game_get_current_color (_tmp7_);
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = _tmp8_;
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = self->priv->player_one;
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp9_ != _tmp10_) {
#line 1934 "iagno.c"
			Game* _tmp11_ = NULL;
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp11_ = self->priv->game;
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_undo (_tmp11_, 1);
#line 1940 "iagno.c"
		} else {
			Game* _tmp12_ = NULL;
#line 379 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp12_ = self->priv->game;
#line 379 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_undo (_tmp12_, 2);
#line 1947 "iagno.c"
		}
#line 382 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		while (TRUE) {
#line 1951 "iagno.c"
			Game* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			Game* _tmp16_ = NULL;
#line 382 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp13_ = self->priv->game;
#line 382 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp14_ = game_get_current_player_can_move (_tmp13_);
#line 382 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp15_ = _tmp14_;
#line 382 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			if (!(!_tmp15_)) {
#line 382 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				break;
#line 1966 "iagno.c"
			}
#line 383 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp16_ = self->priv->game;
#line 383 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_undo (_tmp16_, 2);
#line 1972 "iagno.c"
		}
	}
#line 386 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 387 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_play_sound (self, IAGNO_SOUND_FLIP);
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp17_ = self->priv->view;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_update_scoreboard (_tmp17_);
#line 1983 "iagno.c"
}


static void iagno_turn_ended_cb (Iagno* self) {
	Game* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 393 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = game_get_current_player_can_move (_tmp0_);
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = _tmp1_;
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp2_) {
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_prepare_move (self);
#line 2005 "iagno.c"
	} else {
		Game* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 396 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = self->priv->game;
#line 396 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = game_get_is_complete (_tmp3_);
#line 396 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = _tmp4_;
#line 396 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp5_) {
#line 397 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_game_complete (self, TRUE);
#line 2020 "iagno.c"
		} else {
#line 399 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_pass (self);
#line 2024 "iagno.c"
		}
	}
}


static void iagno_prepare_move (Iagno* self) {
	GameView* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	Player _tmp5_ = 0;
#line 402 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 405 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_play_sound (self, IAGNO_SOUND_FLIP);
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->view;
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_update_scoreboard (_tmp0_);
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->game;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = game_get_current_color (_tmp2_);
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = self->priv->player_one;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp4_ != _tmp5_) {
#line 2055 "iagno.c"
		ComputerPlayer* _tmp6_ = NULL;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->computer;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = _tmp6_ != NULL;
#line 2061 "iagno.c"
	} else {
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = FALSE;
#line 2065 "iagno.c"
	}
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 2069 "iagno.c"
		gboolean _tmp7_ = FALSE;
#line 415 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = iagno_fast_mode;
#line 415 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp7_) {
#line 2075 "iagno.c"
			ComputerPlayer* _tmp8_ = NULL;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp8_ = self->priv->computer;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			computer_player_move_async (_tmp8_, IAGNO_QUICK_MOVE_DELAY, NULL, NULL);
#line 2081 "iagno.c"
		} else {
			ComputerPlayer* _tmp9_ = NULL;
#line 418 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp9_ = self->priv->computer;
#line 418 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			computer_player_move_async (_tmp9_, IAGNO_SLOW_MOVE_DELAY, NULL, NULL);
#line 2088 "iagno.c"
		}
	}
}


static void iagno_pass (Iagno* self) {
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
#line 422 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 425 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_play_sound (self, IAGNO_SOUND_FLIP);
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->view;
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_update_scoreboard (_tmp0_);
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->game;
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_pass (_tmp1_);
#line 429 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->game;
#line 429 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = game_get_current_color (_tmp2_);
#line 429 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 429 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp4_ == PLAYER_DARK) {
#line 2120 "iagno.c"
		GameWindow* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 432 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = self->priv->window;
#line 432 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = _ ("Light must pass, Dark’s move");
#line 432 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		game_window_set_subtitle (_tmp5_, _tmp6_);
#line 2129 "iagno.c"
	} else {
		GameWindow* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->window;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = _ ("Dark must pass, Light’s move");
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		game_window_set_subtitle (_tmp7_, _tmp8_);
#line 2139 "iagno.c"
	}
}


static void iagno_game_complete (Iagno* self, gboolean play_gameover_sound) {
	GameWindow* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Game* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp19_ = FALSE;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 443 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->window;
#line 443 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_window_finish_game (_tmp0_);
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->game;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = game_get_n_light_tiles (_tmp1_);
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = _tmp2_;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = self->priv->game;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = game_get_n_dark_tiles (_tmp4_);
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = _tmp5_;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp3_ > _tmp6_) {
#line 2173 "iagno.c"
		GameWindow* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 448 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->window;
#line 448 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = _ ("Light wins!");
#line 448 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		game_window_set_subtitle (_tmp7_, _tmp8_);
#line 2182 "iagno.c"
	} else {
		Game* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		Game* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = self->priv->game;
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = game_get_n_dark_tiles (_tmp9_);
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp11_ = _tmp10_;
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = self->priv->game;
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = game_get_n_light_tiles (_tmp12_);
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp14_ = _tmp13_;
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp11_ > _tmp14_) {
#line 2204 "iagno.c"
			GameWindow* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
#line 453 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp15_ = self->priv->window;
#line 453 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp16_ = _ ("Dark wins!");
#line 453 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_window_set_subtitle (_tmp15_, _tmp16_);
#line 2213 "iagno.c"
		} else {
			GameWindow* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
#line 458 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp17_ = self->priv->window;
#line 458 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp18_ = _ ("The game is draw.");
#line 458 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_window_set_subtitle (_tmp17_, _tmp18_);
#line 2223 "iagno.c"
		}
	}
#line 461 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp19_ = play_gameover_sound;
#line 461 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp19_) {
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_play_sound (self, IAGNO_SOUND_GAMEOVER);
#line 2232 "iagno.c"
	}
}


static void iagno_player_move_cb (Iagno* self, gint x, gint y) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	Player _tmp5_ = 0;
	Game* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->game;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = game_get_current_color (_tmp2_);
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = self->priv->player_one;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp4_ != _tmp5_) {
#line 2260 "iagno.c"
		ComputerPlayer* _tmp6_ = NULL;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->computer;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = _tmp6_ != NULL;
#line 2266 "iagno.c"
	} else {
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = FALSE;
#line 2270 "iagno.c"
	}
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = TRUE;
#line 2276 "iagno.c"
	} else {
		Game* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->game;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = game_get_current_player_can_move (_tmp7_);
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = _tmp8_;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = !_tmp9_;
#line 2289 "iagno.c"
	}
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_) {
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return;
#line 2295 "iagno.c"
	}
#line 471 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp10_ = self->priv->game;
#line 471 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp11_ = x;
#line 471 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp12_ = y;
#line 471 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp13_ = game_place_tile (_tmp10_, _tmp11_, _tmp12_, TRUE);
#line 471 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp13_ == 0) {
#line 2307 "iagno.c"
		GameWindow* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 474 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp14_ = self->priv->window;
#line 474 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp15_ = _ ("You can’t move there!");
#line 474 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		game_window_set_subtitle (_tmp14_, _tmp15_);
#line 2316 "iagno.c"
	}
}


static void iagno_play_sound (Iagno* self, IagnoSound sound) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* name = NULL;
	IagnoSound _tmp2_ = 0;
	gchar* path = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gint r = 0;
	GameView* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
#line 488 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->settings;
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "sound");
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (!_tmp1_) {
#line 491 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return;
#line 2345 "iagno.c"
	}
#line 494 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = sound;
#line 494 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	switch (_tmp2_) {
#line 494 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		case IAGNO_SOUND_FLIP:
#line 2353 "iagno.c"
		{
			GameView* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
#line 497 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp3_ = self->priv->view;
#line 497 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp4_ = game_view_get_sound_flip (_tmp3_);
#line 497 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp5_ = _tmp4_;
#line 497 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp6_ = g_strdup (_tmp5_);
#line 497 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (name);
#line 497 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			name = _tmp6_;
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			break;
#line 2373 "iagno.c"
		}
#line 494 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		case IAGNO_SOUND_GAMEOVER:
#line 2377 "iagno.c"
		{
			GameView* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp7_ = self->priv->view;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp8_ = game_view_get_sound_gameover (_tmp7_);
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp9_ = _tmp8_;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp10_ = g_strdup (_tmp9_);
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (name);
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			name = _tmp10_;
#line 501 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			break;
#line 2397 "iagno.c"
		}
		default:
		{
#line 503 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (name);
#line 503 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			return;
#line 2405 "iagno.c"
		}
	}
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp11_ = name;
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp12_ = g_build_filename (SOUND_DIRECTORY, _tmp11_, NULL);
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	path = _tmp12_;
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp13_ = self->priv->view;
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp14_ = name;
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp15_ = path;
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp16_ = ca_gtk_play_for_widget ((GtkWidget*) _tmp13_, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp14_, CA_PROP_MEDIA_FILENAME, _tmp15_, NULL);
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	r = _tmp16_;
#line 509 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp17_ = r;
#line 509 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp17_ != 0) {
#line 2428 "iagno.c"
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 510 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp18_ = name;
#line 510 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp19_ = path;
#line 510 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_warning ("iagno.vala:510: Error playing file: %s\nfilepath should be:%s\n", _tmp18_, _tmp19_);
#line 2437 "iagno.c"
	}
#line 488 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (path);
#line 488 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (name);
#line 2443 "iagno.c"
}


static void iagno_class_init (IagnoClass * klass) {
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_parent_class = g_type_class_peek_parent (klass);
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_type_class_add_private (klass, sizeof (IagnoPrivate));
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->handle_local_options = iagno_real_handle_local_options;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->startup = iagno_real_startup;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->activate = iagno_real_activate;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->shutdown = iagno_real_shutdown;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	G_OBJECT_CLASS (klass)->finalize = iagno_finalize;
#line 2462 "iagno.c"
}


static void iagno_instance_init (Iagno * self) {
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv = IAGNO_GET_PRIVATE (self);
#line 48 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->computer = NULL;
#line 54 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->game = NULL;
#line 2473 "iagno.c"
}


static void iagno_finalize (GObject* obj) {
	Iagno * self;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IAGNO, Iagno);
#line 26 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->settings);
#line 41 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->window);
#line 42 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->view);
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->dark_score_label);
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->light_score_label);
#line 45 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->themes_dialog);
#line 48 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->computer);
#line 54 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->game);
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	G_OBJECT_CLASS (iagno_parent_class)->finalize (obj);
#line 2499 "iagno.c"
}


GType iagno_get_type (void) {
	static volatile gsize iagno_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IagnoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) iagno_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Iagno), 0, (GInstanceInitFunc) iagno_instance_init, NULL };
		GType iagno_type_id;
		iagno_type_id = g_type_register_static (gtk_application_get_type (), "Iagno", &g_define_type_info, 0);
		g_once_init_leave (&iagno_type_id__volatile, iagno_type_id);
	}
	return iagno_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



