/* gnome-chess.c generated by valac 0.27.1.7-1a9de, the Vala compiler
 * generated from gnome-chess.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2014 Michael Catanzaro
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "libchess.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <glib/gstdio.h>
#include <librsvg/rsvg.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>


#define TYPE_CHESS_APPLICATION (chess_application_get_type ())
#define CHESS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_APPLICATION, ChessApplication))
#define CHESS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_APPLICATION, ChessApplicationClass))
#define IS_CHESS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_APPLICATION))
#define IS_CHESS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_APPLICATION))
#define CHESS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_APPLICATION, ChessApplicationClass))

typedef struct _ChessApplication ChessApplication;
typedef struct _ChessApplicationClass ChessApplicationClass;
typedef struct _ChessApplicationPrivate ChessApplicationPrivate;

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;

#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;

#define TYPE_AI_PROFILE (ai_profile_get_type ())
#define AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AI_PROFILE, AIProfile))
#define AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AI_PROFILE, AIProfileClass))
#define IS_AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AI_PROFILE))
#define IS_AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AI_PROFILE))
#define AI_PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AI_PROFILE, AIProfileClass))

typedef struct _AIProfile AIProfile;
typedef struct _AIProfileClass AIProfileClass;

#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;

#define CHESS_APPLICATION_TYPE_PROMOTION_TYPE_SELECTED (chess_application_promotion_type_selected_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define TYPE_CHESS_ENGINE_CECP (chess_engine_cecp_get_type ())
#define CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECP))
#define CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))
#define IS_CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_CECP))
#define IS_CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_CECP))
#define CHESS_ENGINE_CECP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))

typedef struct _ChessEngineCECP ChessEngineCECP;
typedef struct _ChessEngineCECPClass ChessEngineCECPClass;

#define TYPE_CHESS_ENGINE_UCI (chess_engine_uci_get_type ())
#define CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCI))
#define CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))
#define IS_CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_UCI))
#define IS_CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_UCI))
#define CHESS_ENGINE_UCI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))

typedef struct _ChessEngineUCI ChessEngineUCI;
typedef struct _ChessEngineUCIClass ChessEngineUCIClass;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ChessApplication {
	GtkApplication parent_instance;
	ChessApplicationPrivate * priv;
};

struct _ChessApplicationClass {
	GtkApplicationClass parent_class;
};

struct _ChessApplicationPrivate {
	GSettings* settings;
	GtkBuilder* builder;
	GtkBuilder* preferences_builder;
	GtkApplicationWindow* window;
	GtkContainer* view_container;
	ChessScene* scene;
	ChessView* view;
	GtkButton* pause_resume_button;
	GtkWidget* first_move_button;
	GtkWidget* prev_move_button;
	GtkWidget* next_move_button;
	GtkWidget* last_move_button;
	GtkComboBox* history_combo;
	GtkWidget* white_time_label;
	GtkWidget* black_time_label;
	GtkWidget* timer_increment_label;
	GtkHeaderBar* headerbar;
	GtkDialog* preferences_dialog;
	GtkComboBox* side_combo;
	GtkComboBox* difficulty_combo;
	GtkComboBox* duration_combo;
	GtkComboBox* clock_type_combo;
	GtkAdjustment* duration_adjustment;
	GtkAdjustment* timer_increment_adjustment;
	GtkBox* custom_duration_box;
	GtkBox* timer_increment_box;
	GtkComboBox* timer_increment_units_combo;
	GtkComboBox* custom_duration_units_combo;
	guint save_duration_timeout;
	GtkFileChooserDialog* open_dialog;
	GtkInfoBar* open_dialog_info_bar;
	GtkLabel* open_dialog_error_label;
	GtkFileChooserDialog* save_dialog;
	GtkInfoBar* save_dialog_info_bar;
	GtkLabel* save_dialog_error_label;
	GtkAboutDialog* about_dialog;
	PGNGame* pgn_game;
	ChessGame* game;
	gchar* autosave_filename;
	GFile* game_file;
	gboolean game_needs_saving;
	gboolean allow_claim_draw_dialog;
	gboolean starting;
	GList* ai_profiles;
	ChessPlayer* opponent;
	ChessPlayer* human_player;
	ChessEngine* opponent_engine;
};

typedef enum  {
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN,
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT,
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK,
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP
} ChessApplicationPromotionTypeSelected;

struct _Block1Data {
	int _ref_count_;
	ChessApplication* self;
	gchar* move;
};

struct _Block2Data {
	int _ref_count_;
	ChessApplication* self;
	ChessGame* original_game;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};


static gpointer chess_application_parent_class = NULL;

GType chess_application_get_type (void) G_GNUC_CONST;
GType chess_scene_get_type (void) G_GNUC_CONST;
GType chess_view_get_type (void) G_GNUC_CONST;
GType ai_profile_get_type (void) G_GNUC_CONST;
GType chess_engine_get_type (void) G_GNUC_CONST;
#define CHESS_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_APPLICATION, ChessApplicationPrivate))
enum  {
	CHESS_APPLICATION_DUMMY_PROPERTY
};
static GType chess_application_promotion_type_selected_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void chess_application_preferences_cb (ChessApplication* self);
static void _chess_application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_help_cb (ChessApplication* self);
static void _chess_application_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_about_cb (ChessApplication* self);
static void _chess_application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_quit_cb (ChessApplication* self);
static void _chess_application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
#define CHESS_APPLICATION_NEW_GAME_ACTION_NAME "new"
#define CHESS_APPLICATION_OPEN_GAME_ACTION_NAME "open"
#define CHESS_APPLICATION_SAVE_GAME_ACTION_NAME "save"
#define CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME "save-as"
#define CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME "undo"
#define CHESS_APPLICATION_RESIGN_ACTION_NAME "resign"
#define CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME "pause-resume"
void chess_application_new_game_cb (ChessApplication* self);
static void _chess_application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_open_game_cb (ChessApplication* self);
static void _chess_application_open_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_save_game_cb (ChessApplication* self);
static void _chess_application_save_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_save_game_as_cb (ChessApplication* self);
static void _chess_application_save_game_as_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_undo_move_cb (ChessApplication* self);
static void _chess_application_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_resign_cb (ChessApplication* self);
static void _chess_application_resign_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_pause_resume_cb (ChessApplication* self);
static void _chess_application_pause_resume_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static ChessApplication* chess_application_new (void);
static ChessApplication* chess_application_construct (GType object_type);
static gint chess_application_real_handle_local_options (GApplication* base, GVariantDict* options);
static void chess_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint);
static void chess_application_real_startup (GApplication* base);
static void chess_application_real_shutdown (GApplication* base);
void chess_engine_stop (ChessEngine* self);
static void chess_application_real_activate (GApplication* base);
static void chess_application_update_pause_resume_button (ChessApplication* self);
ChessScene* chess_scene_new (void);
ChessScene* chess_scene_construct (GType object_type);
static gboolean __lambda10_ (ChessApplication* self, ChessPlayer* p);
static gboolean ___lambda10__chess_scene_is_human (ChessScene* _sender, ChessPlayer* player, gpointer self);
static void chess_application_scene_changed_cb (ChessApplication* self, ChessScene* scene);
static void _chess_application_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self);
PieceType* chess_application_show_promotion_type_selector (ChessApplication* self);
static PieceType* _chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type (ChessScene* _sender, gpointer self);
ChessView* chess_view_new (void);
ChessView* chess_view_construct (GType object_type);
void chess_view_set_scene (ChessView* self, ChessScene* value);
GList* ai_profile_load_ai_profiles (const gchar* filename);
const gchar* ai_profile_get_name (AIProfile* self);
const gchar* ai_profile_get_path (AIProfile* self);
static void chess_application_start_new_game (ChessApplication* self);
static void chess_application_load_game (ChessApplication* self, GFile* file, GError** error);
static void chess_application_add_accelerators (ChessApplication* self);
void chess_application_show (ChessApplication* self);
const gchar* chess_scene_get_theme_name (ChessScene* self);
static void chess_application_set_piece_image (ChessApplication* self, GtkImage* image, const gchar* filename);
static PieceType* _piece_type_dup (PieceType* self);
void chess_application_quit_game (ChessApplication* self);
static gboolean chess_application_save_duration_cb (ChessApplication* self);
static void chess_application_autosave (ChessApplication* self);
static void chess_application_update_pgn_time_remaining (ChessApplication* self);
static void chess_application_update_history_panel (ChessApplication* self);
gint chess_scene_get_move_number (ChessScene* self);
static void chess_application_set_move_text (ChessApplication* self, GtkTreeIter* iter, ChessMove* move);
static void chess_application_start_game (ChessApplication* self);
static void chess_application_game_turn_cb (ChessApplication* self, ChessGame* game, ChessPlayer* player);
static void _chess_application_game_turn_cb_chess_game_turn_started (ChessGame* _sender, ChessPlayer* player, gpointer self);
static void chess_application_game_move_cb (ChessApplication* self, ChessGame* game, ChessMove* move);
static void _chess_application_game_move_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self);
static void chess_application_game_undo_cb (ChessApplication* self, ChessGame* game);
static void _chess_application_game_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self);
static void chess_application_game_end_cb (ChessApplication* self, ChessGame* game);
static void _chess_application_game_end_cb_chess_game_ended (ChessGame* _sender, gpointer self);
static void chess_application_game_clock_tick_cb (ChessApplication* self, ChessClock* clock);
static void _chess_application_game_clock_tick_cb_chess_clock_tick (ChessClock* _sender, gpointer self);
void chess_scene_set_game (ChessScene* self, ChessGame* value);
static void chess_application_engine_ready_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_ready_cb_chess_engine_ready_changed (ChessEngine* _sender, gpointer self);
static void chess_application_engine_move_cb (ChessApplication* self, ChessEngine* engine, const gchar* move);
static void _chess_application_engine_move_cb_chess_engine_moved (ChessEngine* _sender, const gchar* move, gpointer self);
static void chess_application_engine_resigned_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_resigned_cb_chess_engine_resigned (ChessEngine* _sender, gpointer self);
static void chess_application_engine_stopped_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_stopped_cb_chess_engine_stopped (ChessEngine* _sender, gpointer self);
static void chess_application_engine_error_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_error_cb_chess_engine_error (ChessEngine* _sender, gpointer self);
static void chess_application_engine_claim_draw_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_claim_draw_cb_chess_engine_claim_draw (ChessEngine* _sender, gpointer self);
static void chess_application_engine_offer_draw_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_offer_draw_cb_chess_engine_offer_draw (ChessEngine* _sender, gpointer self);
static ChessEngine* chess_application_get_engine (ChessApplication* self, const gchar* name, const gchar* difficulty);
gboolean chess_engine_start (ChessEngine* self);
static void chess_application_disable_window_action (ChessApplication* self, const gchar* name);
static void chess_application_enable_window_action (ChessApplication* self, const gchar* name);
void chess_engine_start_game (ChessEngine* self);
static void chess_application_update_action_status (ChessApplication* self);
static void chess_application_update_headerbar_title (ChessApplication* self);
void chess_engine_move (ChessEngine* self);
gchar** ai_profile_get_easy_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
gchar** ai_profile_get_easy_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
gchar** ai_profile_get_easy_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup3 (gchar** self, int length);
gchar** ai_profile_get_hard_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup4 (gchar** self, int length);
gchar** ai_profile_get_hard_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup5 (gchar** self, int length);
gchar** ai_profile_get_hard_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup6 (gchar** self, int length);
gchar** ai_profile_get_normal_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup7 (gchar** self, int length);
gchar** ai_profile_get_normal_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup8 (gchar** self, int length);
gchar** ai_profile_get_normal_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup9 (gchar** self, int length);
const gchar* ai_profile_get_protocol (AIProfile* self);
const gchar* ai_profile_get_binary (AIProfile* self);
guint ai_profile_get_delay_seconds (AIProfile* self);
ChessEngineCECP* chess_engine_cecp_new (const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1);
ChessEngineCECP* chess_engine_cecp_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1);
GType chess_engine_cecp_get_type (void) G_GNUC_CONST;
ChessEngineUCI* chess_engine_uci_new (const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
ChessEngineUCI* chess_engine_uci_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
GType chess_engine_uci_get_type (void) G_GNUC_CONST;
gboolean chess_engine_get_ready (ChessEngine* self);
static void chess_application_do_engine_move (ChessApplication* self, const gchar* move);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ___lambda7_ (Block1Data* _data1_);
static gboolean ____lambda7__gsource_func (gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda8_ (Block2Data* _data2_);
static gboolean ___lambda8__gsource_func (gpointer self);
static void chess_application_present_claim_draw_dialog (ChessApplication* self);
const gchar* chess_scene_get_move_format (ChessScene* self);
void chess_scene_set_move_number (ChessScene* self, gint value);
void chess_engine_report_move (ChessEngine* self, ChessMove* move);
void chess_engine_undo (ChessEngine* self);
gboolean G_MODULE_EXPORT gnome_chess_app_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self);
gboolean G_MODULE_EXPORT gnome_chess_app_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, ChessApplication* self);
gboolean G_MODULE_EXPORT gnome_chess_app_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, ChessApplication* self);
static gboolean chess_application_prompt_save_game (ChessApplication* self, const gchar* prompt_text);
static void chess_application_present_save_dialog (ChessApplication* self, const gchar* cancel_button_label, const gchar* save_button_label);
GType chess_model_get_type (void) G_GNUC_CONST;
gboolean G_MODULE_EXPORT white_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self);
static void chess_application_draw_time (ChessApplication* self, GtkWidget* widget, cairo_t* c, const gchar* text, gdouble* fg, int fg_length1, gdouble* bg, int bg_length1);
static gchar* chess_application_make_clock_text (ChessApplication* self, ChessClock* clock, Color color);
gboolean G_MODULE_EXPORT black_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self);
static gint chess_application_compute_time_label_width_request (ChessApplication* self, cairo_t* c);
void G_MODULE_EXPORT history_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT history_latest_clicked_cb (GtkWidget* widget, ChessApplication* self);
void G_MODULE_EXPORT history_next_clicked_cb (GtkWidget* widget, ChessApplication* self);
void G_MODULE_EXPORT history_previous_clicked_cb (GtkWidget* widget, ChessApplication* self);
void G_MODULE_EXPORT history_start_clicked_cb (GtkWidget* widget, ChessApplication* self);
static void chess_application_set_combo (ChessApplication* self, GtkComboBox* combo, gint value_index, const gchar* value);
static void chess_application_set_duration (ChessApplication* self, gint duration, gboolean simplify);
static void chess_application_set_clock_type (ChessApplication* self, gint clock_type);
static void chess_application_set_timer_increment (ChessApplication* self, gint timer_increment);
static gchar* chess_application_get_combo (ChessApplication* self, GtkComboBox* combo, gint value_index);
void G_MODULE_EXPORT side_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT opponent_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT difficulty_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT clock_type_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT timer_increment_units_changed_cb (GtkWidget* widget, ChessApplication* self);
static gint chess_application_get_duration (ChessApplication* self);
void G_MODULE_EXPORT duration_changed_cb (GtkAdjustment* adjustment, ChessApplication* self);
static void chess_application_save_duration (ChessApplication* self);
void G_MODULE_EXPORT duration_units_changed_cb (GtkWidget* widget, ChessApplication* self);
static gboolean _chess_application_save_duration_cb_gsource_func (gpointer self);
void G_MODULE_EXPORT duration_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT preferences_response_cb (GtkWidget* widget, gint response_id, ChessApplication* self);
gboolean G_MODULE_EXPORT preferences_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self);
void G_MODULE_EXPORT piece_style_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT move_format_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT orientation_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
static void chess_application_about_response_cb (ChessApplication* self, gint response_id);
static void _chess_application_about_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void chess_application_add_info_bar_to_dialog (ChessApplication* self, GtkDialog* dialog, GtkInfoBar** info_bar, GtkLabel** label);
static void chess_application_save_dialog_cb (ChessApplication* self, gint response_id);
static void __lambda6_ (ChessApplication* self);
static void ___lambda6__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self);
static void _chess_application_save_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void __lambda9_ (ChessApplication* self);
static void chess_application_open_dialog_cb (ChessApplication* self, gint response_id);
static void ___lambda9__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self);
static void _chess_application_open_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
gint chess_application_main (gchar** args, int args_length1);
static void chess_application_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry CHESS_APPLICATION_app_entries[4] = {{"preferences", _chess_application_preferences_cb_gsimple_action_activate_callback}, {"help", _chess_application_help_cb_gsimple_action_activate_callback}, {"about", _chess_application_about_cb_gsimple_action_activate_callback}, {"quit", _chess_application_quit_cb_gsimple_action_activate_callback}};
static const GActionEntry CHESS_APPLICATION_window_entries[7] = {{CHESS_APPLICATION_NEW_GAME_ACTION_NAME, _chess_application_new_game_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_OPEN_GAME_ACTION_NAME, _chess_application_open_game_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_SAVE_GAME_ACTION_NAME, _chess_application_save_game_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME, _chess_application_save_game_as_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME, _chess_application_undo_move_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_RESIGN_ACTION_NAME, _chess_application_resign_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME, _chess_application_pause_resume_cb_gsimple_action_activate_callback}};
static const GOptionEntry CHESS_APPLICATION_option_entries[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Show release version", NULL}, {NULL}};
static const gchar* CHESS_APPLICATION_authors[2] = {"Robert Ancell <robert.ancell@gmail.com>", NULL};
static const gchar* CHESS_APPLICATION_artists[3] = {"Max Froumentin (pieces)", "Jakub Steiner (icon)", NULL};

static GType chess_application_promotion_type_selected_get_type (void) {
	static volatile gsize chess_application_promotion_type_selected_type_id__volatile = 0;
	if (g_once_init_enter (&chess_application_promotion_type_selected_type_id__volatile)) {
		static const GEnumValue values[] = {{CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN", "queen"}, {CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT", "knight"}, {CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK", "rook"}, {CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP", "bishop"}, {0, NULL, NULL}};
		GType chess_application_promotion_type_selected_type_id;
		chess_application_promotion_type_selected_type_id = g_enum_register_static ("ChessApplicationPromotionTypeSelected", values);
		g_once_init_leave (&chess_application_promotion_type_selected_type_id__volatile, chess_application_promotion_type_selected_type_id);
	}
	return chess_application_promotion_type_selected_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _chess_application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_preferences_cb ((ChessApplication*) self);
}


static void _chess_application_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_help_cb ((ChessApplication*) self);
}


static void _chess_application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_about_cb ((ChessApplication*) self);
}


static void _chess_application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_quit_cb ((ChessApplication*) self);
}


static void _chess_application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_new_game_cb ((ChessApplication*) self);
}


static void _chess_application_open_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_open_game_cb ((ChessApplication*) self);
}


static void _chess_application_save_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_save_game_cb ((ChessApplication*) self);
}


static void _chess_application_save_game_as_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_save_game_as_cb ((ChessApplication*) self);
}


static void _chess_application_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_undo_move_cb ((ChessApplication*) self);
}


static void _chess_application_resign_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_resign_cb ((ChessApplication*) self);
}


static void _chess_application_pause_resume_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_pause_resume_cb ((ChessApplication*) self);
}


static ChessApplication* chess_application_construct (GType object_type) {
	ChessApplication * self = NULL;
	self = (ChessApplication*) g_object_new (object_type, "application-id", "org.gnome.gnome-chess", "flags", G_APPLICATION_HANDLES_OPEN, NULL);
	g_application_add_main_option_entries ((GApplication*) self, CHESS_APPLICATION_option_entries);
	return self;
}


static ChessApplication* chess_application_new (void) {
	return chess_application_construct (TYPE_CHESS_APPLICATION);
}


static gint chess_application_real_handle_local_options (GApplication* base, GVariantDict* options) {
	ChessApplication * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (ChessApplication*) base;
	g_return_val_if_fail (options != NULL, 0);
	_tmp0_ = options;
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
	if (_tmp1_) {
		FILE* _tmp2_ = NULL;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "gnome-chess %s\n", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	result = -1;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void chess_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint) {
	ChessApplication * self;
	GFile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GFile** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	self = (ChessApplication*) base;
	g_return_if_fail (hint != NULL);
	_tmp0_ = files;
	_tmp0__length1 = files_length1;
	if (_tmp0__length1 != 1) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("GNOME Chess can only open one PGN at a time.");
		g_warning ("gnome-chess.vala:125: %s", _tmp1_);
	}
	_tmp2_ = files;
	_tmp2__length1 = files_length1;
	_tmp3_ = _tmp2_[0];
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->game_file);
	self->priv->game_file = _tmp4_;
	g_application_activate ((GApplication*) self);
}


static void chess_application_real_startup (GApplication* base) {
	ChessApplication * self;
	const gchar* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	self = (ChessApplication*) base;
	G_APPLICATION_CLASS (chess_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = _ ("Chess");
	g_set_application_name (_tmp0_);
	gtk_window_set_default_icon_name ("gnome-chess");
	_tmp1_ = g_settings_new ("org.gnome.chess");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	g_action_map_add_action_entries ((GActionMap*) self, CHESS_APPLICATION_app_entries, G_N_ELEMENTS (CHESS_APPLICATION_app_entries), self);
}


static void chess_application_real_shutdown (GApplication* base) {
	ChessApplication * self;
	ChessEngine* _tmp0_ = NULL;
	self = (ChessApplication*) base;
	_tmp0_ = self->priv->opponent_engine;
	if (_tmp0_ != NULL) {
		ChessEngine* _tmp1_ = NULL;
		_tmp1_ = self->priv->opponent_engine;
		chess_engine_stop (_tmp1_);
	}
	G_APPLICATION_CLASS (chess_application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}


static gboolean __lambda10_ (ChessApplication* self, ChessPlayer* p) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = p;
	_tmp1_ = self->priv->human_player;
	result = _tmp0_ == _tmp1_;
	return result;
}


static gboolean ___lambda10__chess_scene_is_human (ChessScene* _sender, ChessPlayer* player, gpointer self) {
	gboolean result;
	result = __lambda10_ ((ChessApplication*) self, player);
	return result;
}


static void _chess_application_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self) {
	chess_application_scene_changed_cb ((ChessApplication*) self, _sender);
}


static PieceType* _chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type (ChessScene* _sender, gpointer self) {
	PieceType* result;
	result = chess_application_show_promotion_type_selector ((ChessApplication*) self);
	return result;
}


static void chess_application_real_activate (GApplication* base) {
	ChessApplication * self;
	GFile* data_dir = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GtkBuilder* _tmp7_ = NULL;
	GMenu* app_menu = NULL;
	GtkBuilder* _tmp12_ = NULL;
	GObject* _tmp13_ = NULL;
	GMenu* _tmp14_ = NULL;
	GtkBuilder* _tmp20_ = NULL;
	GObject* _tmp21_ = NULL;
	GtkApplicationWindow* _tmp22_ = NULL;
	GtkBuilder* _tmp23_ = NULL;
	GObject* _tmp24_ = NULL;
	GtkButton* _tmp25_ = NULL;
	GtkBuilder* _tmp26_ = NULL;
	GObject* _tmp27_ = NULL;
	GtkWidget* _tmp28_ = NULL;
	GtkBuilder* _tmp29_ = NULL;
	GObject* _tmp30_ = NULL;
	GtkWidget* _tmp31_ = NULL;
	GtkBuilder* _tmp32_ = NULL;
	GObject* _tmp33_ = NULL;
	GtkWidget* _tmp34_ = NULL;
	GtkBuilder* _tmp35_ = NULL;
	GObject* _tmp36_ = NULL;
	GtkWidget* _tmp37_ = NULL;
	GtkBuilder* _tmp38_ = NULL;
	GObject* _tmp39_ = NULL;
	GtkComboBox* _tmp40_ = NULL;
	GtkBuilder* _tmp41_ = NULL;
	GObject* _tmp42_ = NULL;
	GtkWidget* _tmp43_ = NULL;
	GtkBuilder* _tmp44_ = NULL;
	GObject* _tmp45_ = NULL;
	GtkWidget* _tmp46_ = NULL;
	GtkBuilder* _tmp47_ = NULL;
	GObject* _tmp48_ = NULL;
	GtkContainer* _tmp49_ = NULL;
	GtkBuilder* _tmp50_ = NULL;
	GObject* _tmp51_ = NULL;
	GtkHeaderBar* _tmp52_ = NULL;
	GtkBuilder* _tmp53_ = NULL;
	GtkApplicationWindow* _tmp54_ = NULL;
	GtkApplicationWindow* _tmp55_ = NULL;
	ChessScene* _tmp56_ = NULL;
	ChessScene* _tmp57_ = NULL;
	ChessScene* _tmp58_ = NULL;
	ChessScene* _tmp59_ = NULL;
	GSettings* _tmp60_ = NULL;
	ChessScene* _tmp61_ = NULL;
	GSettings* _tmp62_ = NULL;
	ChessScene* _tmp63_ = NULL;
	GSettings* _tmp64_ = NULL;
	ChessScene* _tmp65_ = NULL;
	GSettings* _tmp66_ = NULL;
	ChessScene* _tmp67_ = NULL;
	GSettings* _tmp68_ = NULL;
	ChessScene* _tmp69_ = NULL;
	ChessView* _tmp70_ = NULL;
	ChessView* _tmp71_ = NULL;
	ChessView* _tmp72_ = NULL;
	ChessScene* _tmp73_ = NULL;
	GtkContainer* _tmp74_ = NULL;
	ChessView* _tmp75_ = NULL;
	ChessView* _tmp76_ = NULL;
	gchar* system_engine_cfg = NULL;
	gchar* _tmp77_ = NULL;
	gchar* user_engine_cfg = NULL;
	const gchar* _tmp78_ = NULL;
	gchar* _tmp79_ = NULL;
	const gchar* _tmp80_ = NULL;
	gboolean _tmp81_ = FALSE;
	GList* _tmp88_ = NULL;
	gchar* _tmp96_ = NULL;
	gchar* _tmp97_ = NULL;
	gchar* _tmp98_ = NULL;
	GFile* _tmp99_ = NULL;
	GFile* _tmp105_ = NULL;
	GtkApplicationWindow* _tmp113_ = NULL;
	GSettings* _tmp114_ = NULL;
	gint _tmp115_ = 0;
	GSettings* _tmp116_ = NULL;
	gint _tmp117_ = 0;
	GSettings* _tmp118_ = NULL;
	gboolean _tmp119_ = FALSE;
	GtkApplicationWindow* _tmp121_ = NULL;
	GError * _inner_error_ = NULL;
	self = (ChessApplication*) base;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-chess", NULL, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	data_dir = _tmp4_;
	_tmp5_ = g_file_get_path (data_dir);
	_tmp6_ = _tmp5_;
	g_mkdir_with_parents (_tmp6_, 0755);
	_g_free0 (_tmp6_);
	_tmp7_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->builder);
	self->priv->builder = _tmp7_;
	{
		GtkBuilder* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp8_ = self->priv->builder;
		_tmp9_ = g_build_filename (PKGDATADIR, "menu.ui", NULL, NULL);
		_tmp10_ = _tmp9_;
		gtk_builder_add_from_file (_tmp8_, _tmp10_, &_inner_error_);
		_g_free0 (_tmp10_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e->message;
		g_error ("gnome-chess.vala:170: Error loading menu UI: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (data_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp12_ = self->priv->builder;
	_tmp13_ = gtk_builder_get_object (_tmp12_, "appmenu");
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_menu_get_type (), GMenu));
	app_menu = _tmp14_;
	gtk_application_set_app_menu ((GtkApplication*) self, (GMenuModel*) app_menu);
	{
		GtkBuilder* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		_tmp15_ = self->priv->builder;
		_tmp16_ = g_build_filename (PKGDATADIR, "gnome-chess.ui", NULL, NULL);
		_tmp17_ = _tmp16_;
		gtk_builder_add_from_file (_tmp15_, _tmp17_, &_inner_error_);
		_g_free0 (_tmp17_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_warning ("gnome-chess.vala:182: Could not load UI: %s", _tmp19_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (app_menu);
		_g_object_unref0 (data_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp20_ = self->priv->builder;
	_tmp21_ = gtk_builder_get_object (_tmp20_, "gnome_chess_app");
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_application_window_get_type (), GtkApplicationWindow));
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp22_;
	_tmp23_ = self->priv->builder;
	_tmp24_ = gtk_builder_get_object (_tmp23_, "pause_button");
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->pause_resume_button);
	self->priv->pause_resume_button = _tmp25_;
	_tmp26_ = self->priv->builder;
	_tmp27_ = gtk_builder_get_object (_tmp26_, "first_move_button");
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->first_move_button);
	self->priv->first_move_button = _tmp28_;
	_tmp29_ = self->priv->builder;
	_tmp30_ = gtk_builder_get_object (_tmp29_, "prev_move_button");
	_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->prev_move_button);
	self->priv->prev_move_button = _tmp31_;
	_tmp32_ = self->priv->builder;
	_tmp33_ = gtk_builder_get_object (_tmp32_, "next_move_button");
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->next_move_button);
	self->priv->next_move_button = _tmp34_;
	_tmp35_ = self->priv->builder;
	_tmp36_ = gtk_builder_get_object (_tmp35_, "last_move_button");
	_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->last_move_button);
	self->priv->last_move_button = _tmp37_;
	_tmp38_ = self->priv->builder;
	_tmp39_ = gtk_builder_get_object (_tmp38_, "history_combo");
	_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->history_combo);
	self->priv->history_combo = _tmp40_;
	_tmp41_ = self->priv->builder;
	_tmp42_ = gtk_builder_get_object (_tmp41_, "white_time_label");
	_tmp43_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->white_time_label);
	self->priv->white_time_label = _tmp43_;
	_tmp44_ = self->priv->builder;
	_tmp45_ = gtk_builder_get_object (_tmp44_, "black_time_label");
	_tmp46_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->black_time_label);
	self->priv->black_time_label = _tmp46_;
	_tmp47_ = self->priv->builder;
	_tmp48_ = gtk_builder_get_object (_tmp47_, "view_container");
	_tmp49_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gtk_container_get_type (), GtkContainer));
	_g_object_unref0 (self->priv->view_container);
	self->priv->view_container = _tmp49_;
	_tmp50_ = self->priv->builder;
	_tmp51_ = gtk_builder_get_object (_tmp50_, "headerbar");
	_tmp52_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, gtk_header_bar_get_type (), GtkHeaderBar));
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp52_;
	_tmp53_ = self->priv->builder;
	gtk_builder_connect_signals (_tmp53_, self);
	chess_application_update_pause_resume_button (self);
	_tmp54_ = self->priv->window;
	g_action_map_add_action_entries ((GActionMap*) _tmp54_, CHESS_APPLICATION_window_entries, G_N_ELEMENTS (CHESS_APPLICATION_window_entries), self);
	_tmp55_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp55_);
	_tmp56_ = chess_scene_new ();
	_g_object_unref0 (self->priv->scene);
	self->priv->scene = _tmp56_;
	_tmp57_ = self->priv->scene;
	g_signal_connect_object (_tmp57_, "is-human", (GCallback) ___lambda10__chess_scene_is_human, self, 0);
	_tmp58_ = self->priv->scene;
	g_signal_connect_object (_tmp58_, "changed", (GCallback) _chess_application_scene_changed_cb_chess_scene_changed, self, 0);
	_tmp59_ = self->priv->scene;
	g_signal_connect_object (_tmp59_, "choose-promotion-type", (GCallback) _chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type, self, 0);
	_tmp60_ = self->priv->settings;
	_tmp61_ = self->priv->scene;
	g_settings_bind (_tmp60_, "show-move-hints", (GObject*) _tmp61_, "show-move-hints", G_SETTINGS_BIND_GET);
	_tmp62_ = self->priv->settings;
	_tmp63_ = self->priv->scene;
	g_settings_bind (_tmp62_, "show-numbering", (GObject*) _tmp63_, "show-numbering", G_SETTINGS_BIND_GET);
	_tmp64_ = self->priv->settings;
	_tmp65_ = self->priv->scene;
	g_settings_bind (_tmp64_, "piece-theme", (GObject*) _tmp65_, "theme-name", G_SETTINGS_BIND_GET);
	_tmp66_ = self->priv->settings;
	_tmp67_ = self->priv->scene;
	g_settings_bind (_tmp66_, "move-format", (GObject*) _tmp67_, "move-format", G_SETTINGS_BIND_GET);
	_tmp68_ = self->priv->settings;
	_tmp69_ = self->priv->scene;
	g_settings_bind (_tmp68_, "board-side", (GObject*) _tmp69_, "board-side", G_SETTINGS_BIND_GET);
	_tmp70_ = chess_view_new ();
	g_object_ref_sink (_tmp70_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp70_;
	_tmp71_ = self->priv->view;
	gtk_widget_set_size_request ((GtkWidget*) _tmp71_, 400, 400);
	_tmp72_ = self->priv->view;
	_tmp73_ = self->priv->scene;
	chess_view_set_scene (_tmp72_, _tmp73_);
	_tmp74_ = self->priv->view_container;
	_tmp75_ = self->priv->view;
	gtk_container_add (_tmp74_, (GtkWidget*) _tmp75_);
	_tmp76_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp76_);
	_tmp77_ = g_build_filename (SYSCONFDIR, "gnome-chess", "engines.conf", NULL, NULL);
	system_engine_cfg = _tmp77_;
	_tmp78_ = g_get_user_config_dir ();
	_tmp79_ = g_build_filename (_tmp78_, "gnome-chess", "engines.conf", NULL, NULL);
	user_engine_cfg = _tmp79_;
	_tmp80_ = user_engine_cfg;
	_tmp81_ = g_file_test (_tmp80_, G_FILE_TEST_EXISTS);
	if (_tmp81_) {
		const gchar* _tmp82_ = NULL;
		GList* _tmp83_ = NULL;
		_tmp82_ = user_engine_cfg;
		_tmp83_ = ai_profile_load_ai_profiles (_tmp82_);
		__g_list_free__g_object_unref0_0 (self->priv->ai_profiles);
		self->priv->ai_profiles = _tmp83_;
	} else {
		const gchar* _tmp84_ = NULL;
		gboolean _tmp85_ = FALSE;
		_tmp84_ = system_engine_cfg;
		_tmp85_ = g_file_test (_tmp84_, G_FILE_TEST_EXISTS);
		if (_tmp85_) {
			const gchar* _tmp86_ = NULL;
			GList* _tmp87_ = NULL;
			_tmp86_ = system_engine_cfg;
			_tmp87_ = ai_profile_load_ai_profiles (_tmp86_);
			__g_list_free__g_object_unref0_0 (self->priv->ai_profiles);
			self->priv->ai_profiles = _tmp87_;
		} else {
			g_warning ("gnome-chess.vala:227: engines.conf not found");
		}
	}
	_tmp88_ = self->priv->ai_profiles;
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
		profile_collection = _tmp88_;
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
			AIProfile* _tmp89_ = NULL;
			AIProfile* profile = NULL;
			_tmp89_ = _g_object_ref0 ((AIProfile*) profile_it->data);
			profile = _tmp89_;
			{
				AIProfile* _tmp90_ = NULL;
				const gchar* _tmp91_ = NULL;
				const gchar* _tmp92_ = NULL;
				AIProfile* _tmp93_ = NULL;
				const gchar* _tmp94_ = NULL;
				const gchar* _tmp95_ = NULL;
				_tmp90_ = profile;
				_tmp91_ = ai_profile_get_name (_tmp90_);
				_tmp92_ = _tmp91_;
				_tmp93_ = profile;
				_tmp94_ = ai_profile_get_path (_tmp93_);
				_tmp95_ = _tmp94_;
				g_debug ("gnome-chess.vala:230: Detected AI profile %s in %s", _tmp92_, _tmp95_);
				_g_object_unref0 (profile);
			}
		}
	}
	_tmp96_ = g_file_get_path (data_dir);
	_tmp97_ = _tmp96_;
	_tmp98_ = g_strconcat (_tmp97_, "/autosave.pgn", NULL);
	_g_free0 (self->priv->autosave_filename);
	self->priv->autosave_filename = _tmp98_;
	_g_free0 (_tmp97_);
	_tmp99_ = self->priv->game_file;
	if (_tmp99_ == NULL) {
		const gchar* _tmp100_ = NULL;
		gboolean _tmp101_ = FALSE;
		GFile* _tmp104_ = NULL;
		_tmp100_ = self->priv->autosave_filename;
		_tmp101_ = g_file_test (_tmp100_, G_FILE_TEST_EXISTS);
		if (_tmp101_) {
			const gchar* _tmp102_ = NULL;
			GFile* _tmp103_ = NULL;
			_tmp102_ = self->priv->autosave_filename;
			_tmp103_ = g_file_new_for_path (_tmp102_);
			_g_object_unref0 (self->priv->game_file);
			self->priv->game_file = _tmp103_;
		}
		_tmp104_ = self->priv->game_file;
		if (_tmp104_ == NULL) {
			chess_application_start_new_game (self);
		}
	}
	_tmp105_ = self->priv->game_file;
	if (_tmp105_ != NULL) {
		{
			GFile* _tmp106_ = NULL;
			_tmp106_ = self->priv->game_file;
			chess_application_load_game (self, _tmp106_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			FILE* _tmp107_ = NULL;
			GFile* _tmp108_ = NULL;
			gchar* _tmp109_ = NULL;
			gchar* _tmp110_ = NULL;
			GError* _tmp111_ = NULL;
			const gchar* _tmp112_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp107_ = stderr;
			_tmp108_ = self->priv->game_file;
			_tmp109_ = g_file_get_path (_tmp108_);
			_tmp110_ = _tmp109_;
			_tmp111_ = e;
			_tmp112_ = _tmp111_->message;
			fprintf (_tmp107_, "Failed to load %s: %s\n", _tmp110_, _tmp112_);
			_g_free0 (_tmp110_);
			g_application_quit ((GApplication*) self);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (user_engine_cfg);
			_g_free0 (system_engine_cfg);
			_g_object_unref0 (app_menu);
			_g_object_unref0 (data_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp113_ = self->priv->window;
	_tmp114_ = self->priv->settings;
	_tmp115_ = g_settings_get_int (_tmp114_, "width");
	_tmp116_ = self->priv->settings;
	_tmp117_ = g_settings_get_int (_tmp116_, "height");
	gtk_window_set_default_size ((GtkWindow*) _tmp113_, _tmp115_, _tmp117_);
	_tmp118_ = self->priv->settings;
	_tmp119_ = g_settings_get_boolean (_tmp118_, "maximized");
	if (_tmp119_) {
		GtkApplicationWindow* _tmp120_ = NULL;
		_tmp120_ = self->priv->window;
		gtk_window_maximize ((GtkWindow*) _tmp120_);
	}
	chess_application_add_accelerators (self);
	chess_application_show (self);
	_tmp121_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp121_);
	_g_free0 (user_engine_cfg);
	_g_free0 (system_engine_cfg);
	_g_object_unref0 (app_menu);
	_g_object_unref0 (data_dir);
}


static PieceType* _piece_type_dup (PieceType* self) {
	PieceType* dup;
	dup = g_new0 (PieceType, 1);
	memcpy (dup, self, sizeof (PieceType));
	return dup;
}


static gpointer __piece_type_dup0 (gpointer self) {
	return self ? _piece_type_dup (self) : NULL;
}


PieceType* chess_application_show_promotion_type_selector (ChessApplication* self) {
	PieceType* result = NULL;
	GtkBuilder* promotion_type_selector_builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GtkDialog* promotion_type_selector_dialog = NULL;
	GtkBuilder* _tmp6_ = NULL;
	GObject* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	GtkDialog* _tmp9_ = NULL;
	GtkApplicationWindow* _tmp10_ = NULL;
	gchar* color = NULL;
	ChessGame* _tmp11_ = NULL;
	ChessPlayer* _tmp12_ = NULL;
	ChessPlayer* _tmp13_ = NULL;
	Color _tmp14_ = 0;
	gchar* filename = NULL;
	ChessScene* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	GtkBuilder* _tmp25_ = NULL;
	GObject* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	ChessScene* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	GtkBuilder* _tmp35_ = NULL;
	GObject* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	ChessScene* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	GtkBuilder* _tmp45_ = NULL;
	GObject* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	ChessScene* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	GtkBuilder* _tmp55_ = NULL;
	GObject* _tmp56_ = NULL;
	const gchar* _tmp57_ = NULL;
	GtkBuilder* _tmp58_ = NULL;
	PieceType* selection = NULL;
	gint choice = 0;
	GtkDialog* _tmp59_ = NULL;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	GtkDialog* _tmp70_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_builder_new ();
	_g_object_unref0 (promotion_type_selector_builder);
	promotion_type_selector_builder = _tmp0_;
	{
		GtkBuilder* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp1_ = promotion_type_selector_builder;
		_tmp2_ = g_build_filename (PKGDATADIR, "promotion-type-selector.ui", NULL, NULL);
		_tmp3_ = _tmp2_;
		gtk_builder_add_from_file (_tmp1_, _tmp3_, &_inner_error_);
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("gnome-chess.vala:280: Could not load promotion type selector UI: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (promotion_type_selector_builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp6_ = promotion_type_selector_builder;
	_tmp7_ = gtk_builder_get_object (_tmp6_, "dialog_promotion_type_selector");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp7_) : NULL);
	promotion_type_selector_dialog = _tmp8_;
	_tmp9_ = promotion_type_selector_dialog;
	_tmp10_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp9_, (GtkWindow*) _tmp10_);
	_tmp11_ = self->priv->game;
	_tmp12_ = chess_game_get_current_player (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_->color;
	if (_tmp14_ == COLOR_WHITE) {
		gchar* _tmp15_ = NULL;
		_tmp15_ = g_strdup ("white");
		_g_free0 (color);
		color = _tmp15_;
	} else {
		gchar* _tmp16_ = NULL;
		_tmp16_ = g_strdup ("black");
		_g_free0 (color);
		color = _tmp16_;
	}
	_tmp17_ = self->priv->scene;
	_tmp18_ = chess_scene_get_theme_name (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = color;
	_tmp21_ = g_strdup_printf ("%sQueen.svg", _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_build_filename (PKGDATADIR, "pieces", _tmp19_, _tmp22_, NULL);
	_tmp24_ = _tmp23_;
	_g_free0 (_tmp22_);
	filename = _tmp24_;
	_tmp25_ = promotion_type_selector_builder;
	_tmp26_ = gtk_builder_get_object (_tmp25_, "image_queen");
	_tmp27_ = filename;
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, gtk_image_get_type ()) ? ((GtkImage*) _tmp26_) : NULL, _tmp27_);
	_tmp28_ = self->priv->scene;
	_tmp29_ = chess_scene_get_theme_name (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = color;
	_tmp32_ = g_strdup_printf ("%sKnight.svg", _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_build_filename (PKGDATADIR, "pieces", _tmp30_, _tmp33_, NULL);
	_g_free0 (filename);
	filename = _tmp34_;
	_g_free0 (_tmp33_);
	_tmp35_ = promotion_type_selector_builder;
	_tmp36_ = gtk_builder_get_object (_tmp35_, "image_knight");
	_tmp37_ = filename;
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, gtk_image_get_type ()) ? ((GtkImage*) _tmp36_) : NULL, _tmp37_);
	_tmp38_ = self->priv->scene;
	_tmp39_ = chess_scene_get_theme_name (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = color;
	_tmp42_ = g_strdup_printf ("%sRook.svg", _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_build_filename (PKGDATADIR, "pieces", _tmp40_, _tmp43_, NULL);
	_g_free0 (filename);
	filename = _tmp44_;
	_g_free0 (_tmp43_);
	_tmp45_ = promotion_type_selector_builder;
	_tmp46_ = gtk_builder_get_object (_tmp45_, "image_rook");
	_tmp47_ = filename;
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, gtk_image_get_type ()) ? ((GtkImage*) _tmp46_) : NULL, _tmp47_);
	_tmp48_ = self->priv->scene;
	_tmp49_ = chess_scene_get_theme_name (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = color;
	_tmp52_ = g_strdup_printf ("%sBishop.svg", _tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = g_build_filename (PKGDATADIR, "pieces", _tmp50_, _tmp53_, NULL);
	_g_free0 (filename);
	filename = _tmp54_;
	_g_free0 (_tmp53_);
	_tmp55_ = promotion_type_selector_builder;
	_tmp56_ = gtk_builder_get_object (_tmp55_, "image_bishop");
	_tmp57_ = filename;
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, gtk_image_get_type ()) ? ((GtkImage*) _tmp56_) : NULL, _tmp57_);
	_tmp58_ = promotion_type_selector_builder;
	gtk_builder_connect_signals (_tmp58_, self);
	selection = NULL;
	_tmp59_ = promotion_type_selector_dialog;
	_tmp60_ = gtk_dialog_run (_tmp59_);
	choice = _tmp60_;
	_tmp61_ = choice;
	switch (_tmp61_) {
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN:
		{
			PieceType _tmp62_ = 0;
			PieceType* _tmp63_ = NULL;
			_tmp62_ = PIECE_TYPE_QUEEN;
			_tmp63_ = __piece_type_dup0 (&_tmp62_);
			_g_free0 (selection);
			selection = _tmp63_;
			break;
		}
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT:
		{
			PieceType _tmp64_ = 0;
			PieceType* _tmp65_ = NULL;
			_tmp64_ = PIECE_TYPE_KNIGHT;
			_tmp65_ = __piece_type_dup0 (&_tmp64_);
			_g_free0 (selection);
			selection = _tmp65_;
			break;
		}
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK:
		{
			PieceType _tmp66_ = 0;
			PieceType* _tmp67_ = NULL;
			_tmp66_ = PIECE_TYPE_ROOK;
			_tmp67_ = __piece_type_dup0 (&_tmp66_);
			_g_free0 (selection);
			selection = _tmp67_;
			break;
		}
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP:
		{
			PieceType _tmp68_ = 0;
			PieceType* _tmp69_ = NULL;
			_tmp68_ = PIECE_TYPE_BISHOP;
			_tmp69_ = __piece_type_dup0 (&_tmp68_);
			_g_free0 (selection);
			selection = _tmp69_;
			break;
		}
		default:
		break;
	}
	_tmp70_ = promotion_type_selector_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp70_);
	result = selection;
	_g_free0 (filename);
	_g_free0 (color);
	_g_object_unref0 (promotion_type_selector_dialog);
	_g_object_unref0 (promotion_type_selector_builder);
	return result;
}


static void chess_application_set_piece_image (ChessApplication* self, GtkImage* image, const gchar* filename) {
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	g_return_if_fail (filename != NULL);
	_tmp2_ = gtk_icon_size_lookup (GTK_ICON_SIZE_DIALOG, &_tmp0_, &_tmp1_);
	width = _tmp0_;
	height = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	{
		RsvgHandle* h = NULL;
		const gchar* _tmp3_ = NULL;
		RsvgHandle* _tmp4_ = NULL;
		cairo_surface_t* s = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		cairo_surface_t* _tmp7_ = NULL;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp8_ = NULL;
		cairo_t* _tmp9_ = NULL;
		cairo_matrix_t m = {0};
		gint _tmp10_ = 0;
		RsvgHandle* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		RsvgHandle* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		cairo_t* _tmp18_ = NULL;
		cairo_matrix_t _tmp19_ = {0};
		RsvgHandle* _tmp20_ = NULL;
		cairo_t* _tmp21_ = NULL;
		GdkPixbuf* p = NULL;
		cairo_surface_t* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		GdkPixbuf* _tmp25_ = NULL;
		GtkImage* _tmp26_ = NULL;
		GdkPixbuf* _tmp27_ = NULL;
		_tmp3_ = filename;
		_tmp4_ = rsvg_handle_new_from_file (_tmp3_, &_inner_error_);
		h = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp5_ = width;
		_tmp6_ = height;
		_tmp7_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp5_, _tmp6_);
		s = _tmp7_;
		_tmp8_ = s;
		_tmp9_ = cairo_create (_tmp8_);
		c = _tmp9_;
		cairo_matrix_init_identity (&m);
		_tmp10_ = width;
		_tmp11_ = h;
		g_object_get (_tmp11_, "width", &_tmp12_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = height;
		_tmp15_ = h;
		g_object_get (_tmp15_, "height", &_tmp16_, NULL);
		_tmp17_ = _tmp16_;
		cairo_matrix_scale (&m, ((gdouble) _tmp10_) / _tmp13_, ((gdouble) _tmp14_) / _tmp17_);
		_tmp18_ = c;
		_tmp19_ = m;
		cairo_set_matrix (_tmp18_, &_tmp19_);
		_tmp20_ = h;
		_tmp21_ = c;
		rsvg_handle_render_cairo (_tmp20_, _tmp21_);
		_tmp22_ = s;
		_tmp23_ = width;
		_tmp24_ = height;
		_tmp25_ = gdk_pixbuf_get_from_surface (_tmp22_, 0, 0, _tmp23_, _tmp24_);
		p = _tmp25_;
		_tmp26_ = image;
		_tmp27_ = p;
		gtk_image_set_from_pixbuf (_tmp26_, _tmp27_);
		_g_object_unref0 (p);
		_cairo_destroy0 (c);
		_cairo_surface_destroy0 (s);
		_g_object_unref0 (h);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp28_ = NULL;
		GError* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp28_ = filename;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		g_warning ("gnome-chess.vala:350: Failed to load image %s: %s", _tmp28_, _tmp30_);
		_g_error_free0 (e);
		return;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void chess_application_quit_game (ChessApplication* self) {
	guint _tmp0_ = 0U;
	GtkApplicationWindow* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->save_duration_timeout;
	if (_tmp0_ != ((guint) 0)) {
		chess_application_save_duration_cb (self);
	}
	chess_application_autosave (self);
	_tmp1_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
}


static void chess_application_autosave (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_needs_saving;
	if (!_tmp0_) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = self->priv->autosave_filename;
		g_remove (_tmp1_);
		return;
	}
	{
		GFile* autosave_file = NULL;
		const gchar* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		PGNGame* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		_tmp2_ = self->priv->autosave_filename;
		_tmp3_ = g_file_new_for_path (_tmp2_);
		autosave_file = _tmp3_;
		_tmp4_ = autosave_file;
		_tmp5_ = g_file_get_path (_tmp4_);
		_tmp6_ = _tmp5_;
		g_debug ("gnome-chess.vala:384: Writing current game to %s", _tmp6_);
		_g_free0 (_tmp6_);
		chess_application_update_pgn_time_remaining (self);
		_tmp7_ = self->priv->pgn_game;
		_tmp8_ = autosave_file;
		pgn_game_write (_tmp7_, _tmp8_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (autosave_file);
			goto __catch5_g_error;
		}
		_g_object_unref0 (autosave_file);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("gnome-chess.vala:390: Failed to autosave: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void chess_application_update_history_panel (ChessApplication* self) {
	ChessGame* _tmp0_ = NULL;
	gint move_number = 0;
	ChessScene* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint n_moves = 0;
	ChessGame* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	gint _tmp7_ = 0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_ = 0;
	GtkWidget* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gint _tmp19_ = 0;
	GtkWidget* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	GtkWidget* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gint _tmp33_ = 0;
	GtkWidget* _tmp39_ = NULL;
	GtkComboBox* _tmp40_ = NULL;
	ChessGame* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_ = FALSE;
	gint i = 0;
	gint _tmp44_ = 0;
	ChessGame* _tmp45_ = NULL;
	GList* _tmp46_ = NULL;
	GtkComboBox* _tmp60_ = NULL;
	gint _tmp61_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->scene;
	_tmp2_ = chess_scene_get_move_number (_tmp1_);
	_tmp3_ = _tmp2_;
	move_number = _tmp3_;
	_tmp4_ = self->priv->game;
	_tmp5_ = chess_game_get_n_moves (_tmp4_);
	_tmp6_ = _tmp5_;
	n_moves = (gint) _tmp6_;
	_tmp7_ = move_number;
	if (_tmp7_ < 0) {
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp8_ = move_number;
		_tmp9_ = n_moves;
		move_number = _tmp8_ + (1 + _tmp9_);
	}
	_tmp12_ = n_moves;
	if (_tmp12_ > 0) {
		gint _tmp13_ = 0;
		_tmp13_ = move_number;
		_tmp11_ = _tmp13_ != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ChessGame* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		_tmp14_ = self->priv->game;
		_tmp15_ = chess_game_get_is_paused (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp10_ = !_tmp16_;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp17_ = self->priv->first_move_button;
	gtk_widget_set_sensitive (_tmp17_, _tmp10_);
	_tmp19_ = move_number;
	if (_tmp19_ > 0) {
		ChessGame* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		_tmp20_ = self->priv->game;
		_tmp21_ = chess_game_get_is_paused (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp18_ = !_tmp22_;
	} else {
		_tmp18_ = FALSE;
	}
	_tmp23_ = self->priv->prev_move_button;
	gtk_widget_set_sensitive (_tmp23_, _tmp18_);
	_tmp25_ = move_number;
	_tmp26_ = n_moves;
	if (_tmp25_ < _tmp26_) {
		ChessGame* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		_tmp27_ = self->priv->game;
		_tmp28_ = chess_game_get_is_paused (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp24_ = !_tmp29_;
	} else {
		_tmp24_ = FALSE;
	}
	_tmp30_ = self->priv->next_move_button;
	gtk_widget_set_sensitive (_tmp30_, _tmp24_);
	_tmp33_ = n_moves;
	if (_tmp33_ > 0) {
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		_tmp34_ = move_number;
		_tmp35_ = n_moves;
		_tmp32_ = _tmp34_ != _tmp35_;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		ChessGame* _tmp36_ = NULL;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		_tmp36_ = self->priv->game;
		_tmp37_ = chess_game_get_is_paused (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp31_ = !_tmp38_;
	} else {
		_tmp31_ = FALSE;
	}
	_tmp39_ = self->priv->last_move_button;
	gtk_widget_set_sensitive (_tmp39_, _tmp31_);
	_tmp40_ = self->priv->history_combo;
	_tmp41_ = self->priv->game;
	_tmp42_ = chess_game_get_is_paused (_tmp41_);
	_tmp43_ = _tmp42_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp40_, !_tmp43_);
	_tmp44_ = n_moves;
	i = _tmp44_;
	_tmp45_ = self->priv->game;
	_tmp46_ = _tmp45_->move_stack;
	{
		GList* state_collection = NULL;
		GList* state_it = NULL;
		state_collection = _tmp46_;
		for (state_it = state_collection; state_it != NULL; state_it = state_it->next) {
			ChessState* _tmp47_ = NULL;
			ChessState* state = NULL;
			_tmp47_ = _g_object_ref0 ((ChessState*) state_it->data);
			state = _tmp47_;
			{
				ChessState* _tmp48_ = NULL;
				ChessMove* _tmp49_ = NULL;
				gint _tmp59_ = 0;
				_tmp48_ = state;
				_tmp49_ = _tmp48_->last_move;
				if (_tmp49_ != NULL) {
					GtkTreeIter iter = {0};
					GtkComboBox* _tmp50_ = NULL;
					GtkTreeModel* _tmp51_ = NULL;
					GtkTreeModel* _tmp52_ = NULL;
					gint _tmp53_ = 0;
					GtkTreeIter _tmp54_ = {0};
					gboolean _tmp55_ = FALSE;
					_tmp50_ = self->priv->history_combo;
					_tmp51_ = gtk_combo_box_get_model (_tmp50_);
					_tmp52_ = _tmp51_;
					_tmp53_ = i;
					_tmp55_ = gtk_tree_model_iter_nth_child (_tmp52_, &_tmp54_, NULL, _tmp53_);
					iter = _tmp54_;
					if (_tmp55_) {
						GtkTreeIter _tmp56_ = {0};
						ChessState* _tmp57_ = NULL;
						ChessMove* _tmp58_ = NULL;
						_tmp56_ = iter;
						_tmp57_ = state;
						_tmp58_ = _tmp57_->last_move;
						chess_application_set_move_text (self, &_tmp56_, _tmp58_);
					}
				}
				_tmp59_ = i;
				i = _tmp59_ - 1;
				_g_object_unref0 (state);
			}
		}
	}
	_tmp60_ = self->priv->history_combo;
	_tmp61_ = move_number;
	gtk_combo_box_set_active (_tmp60_, _tmp61_);
}


static void chess_application_scene_changed_cb (ChessApplication* self, ChessScene* scene) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (scene != NULL);
	chess_application_update_history_panel (self);
}


static void _chess_application_game_turn_cb_chess_game_turn_started (ChessGame* _sender, ChessPlayer* player, gpointer self) {
	chess_application_game_turn_cb ((ChessApplication*) self, _sender, player);
}


static void _chess_application_game_move_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self) {
	chess_application_game_move_cb ((ChessApplication*) self, _sender, move);
}


static void _chess_application_game_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self) {
	chess_application_game_undo_cb ((ChessApplication*) self, _sender);
}


static void _chess_application_game_end_cb_chess_game_ended (ChessGame* _sender, gpointer self) {
	chess_application_game_end_cb ((ChessApplication*) self, _sender);
}


static void _chess_application_game_clock_tick_cb_chess_clock_tick (ChessClock* _sender, gpointer self) {
	chess_application_game_clock_tick_cb ((ChessApplication*) self, _sender);
}


static void _chess_application_engine_ready_cb_chess_engine_ready_changed (ChessEngine* _sender, gpointer self) {
	chess_application_engine_ready_cb ((ChessApplication*) self, _sender);
}


static void _chess_application_engine_move_cb_chess_engine_moved (ChessEngine* _sender, const gchar* move, gpointer self) {
	chess_application_engine_move_cb ((ChessApplication*) self, _sender, move);
}


static void _chess_application_engine_resigned_cb_chess_engine_resigned (ChessEngine* _sender, gpointer self) {
	chess_application_engine_resigned_cb ((ChessApplication*) self, _sender);
}


static void _chess_application_engine_stopped_cb_chess_engine_stopped (ChessEngine* _sender, gpointer self) {
	chess_application_engine_stopped_cb ((ChessApplication*) self, _sender);
}


static void _chess_application_engine_error_cb_chess_engine_error (ChessEngine* _sender, gpointer self) {
	chess_application_engine_error_cb ((ChessApplication*) self, _sender);
}


static void _chess_application_engine_claim_draw_cb_chess_engine_claim_draw (ChessEngine* _sender, gpointer self) {
	chess_application_engine_claim_draw_cb ((ChessApplication*) self, _sender);
}


static void _chess_application_engine_offer_draw_cb_chess_engine_offer_draw (ChessEngine* _sender, gpointer self) {
	chess_application_engine_offer_draw_cb ((ChessApplication*) self, _sender);
}


static void chess_application_start_game (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_ = NULL;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp11_ = NULL;
	GtkTreeModel* _tmp12_ = NULL;
	GtkTreeModel* _tmp13_ = NULL;
	GtkListStore* _tmp14_ = NULL;
	GtkListStore* _tmp15_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp16_ = NULL;
	GtkTreeIter _tmp17_ = {0};
	GtkListStore* _tmp18_ = NULL;
	GtkTreeIter _tmp19_ = {0};
	const gchar* _tmp20_ = NULL;
	GtkComboBox* _tmp21_ = NULL;
	GtkTreeIter _tmp22_ = {0};
	gchar* fen = NULL;
	gchar* _tmp23_ = NULL;
	gchar** moves = NULL;
	PGNGame* _tmp24_ = NULL;
	GList* _tmp25_ = NULL;
	guint _tmp26_ = 0U;
	gchar** _tmp27_ = NULL;
	gint moves_length1 = 0;
	gint _moves_size_ = 0;
	gint i = 0;
	PGNGame* _tmp28_ = NULL;
	GList* _tmp29_ = NULL;
	PGNGame* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	const gchar* _tmp46_ = NULL;
	gchar** _tmp47_ = NULL;
	gint _tmp47__length1 = 0;
	ChessGame* _tmp48_ = NULL;
	gboolean _tmp49_ = FALSE;
	PGNGame* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	ChessGame* _tmp80_ = NULL;
	ChessGame* _tmp81_ = NULL;
	ChessGame* _tmp82_ = NULL;
	ChessGame* _tmp83_ = NULL;
	ChessGame* _tmp84_ = NULL;
	ChessClock* _tmp85_ = NULL;
	ChessClock* _tmp86_ = NULL;
	ChessScene* _tmp90_ = NULL;
	ChessGame* _tmp91_ = NULL;
	gchar* white_engine = NULL;
	PGNGame* _tmp92_ = NULL;
	const gchar* _tmp93_ = NULL;
	const gchar* _tmp94_ = NULL;
	gchar* _tmp95_ = NULL;
	gchar* white_level = NULL;
	PGNGame* _tmp96_ = NULL;
	const gchar* _tmp97_ = NULL;
	const gchar* _tmp98_ = NULL;
	gchar* _tmp99_ = NULL;
	const gchar* _tmp100_ = NULL;
	gchar* black_engine = NULL;
	PGNGame* _tmp102_ = NULL;
	const gchar* _tmp103_ = NULL;
	const gchar* _tmp104_ = NULL;
	gchar* _tmp105_ = NULL;
	gchar* black_level = NULL;
	PGNGame* _tmp106_ = NULL;
	const gchar* _tmp107_ = NULL;
	const gchar* _tmp108_ = NULL;
	gchar* _tmp109_ = NULL;
	const gchar* _tmp110_ = NULL;
	ChessEngine* _tmp112_ = NULL;
	const gchar* _tmp128_ = NULL;
	ChessEngine* _tmp156_ = NULL;
	gboolean _tmp189_ = FALSE;
	GFile* _tmp190_ = NULL;
	ChessGame* _tmp195_ = NULL;
	gint timer_increment_adj_value = 0;
	PGNGame* _tmp196_ = NULL;
	const gchar* _tmp197_ = NULL;
	const gchar* _tmp198_ = NULL;
	ClockType clock_type = 0;
	PGNGame* _tmp209_ = NULL;
	const gchar* _tmp210_ = NULL;
	const gchar* _tmp211_ = NULL;
	ChessGame* _tmp224_ = NULL;
	ChessClock* _tmp225_ = NULL;
	ChessClock* _tmp226_ = NULL;
	PGNGame* _tmp235_ = NULL;
	const gchar* _tmp236_ = NULL;
	const gchar* _tmp237_ = NULL;
	const gchar* _tmp238_ = NULL;
	ChessEngine* _tmp250_ = NULL;
	gboolean _tmp252_ = FALSE;
	gchar** _tmp253_ = NULL;
	gint _tmp253__length1 = 0;
	GtkWidget* _tmp260_ = NULL;
	GtkWidget* _tmp261_ = NULL;
	gboolean _tmp262_ = FALSE;
	gboolean _tmp263_ = FALSE;
	const gchar* _tmp264_ = NULL;
	ChessGame* _tmp277_ = NULL;
	ChessResult _tmp278_ = 0;
	g_return_if_fail (self != NULL);
	self->priv->starting = TRUE;
	_tmp1_ = self->priv->game_file;
	if (_tmp1_ != NULL) {
		GFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp2_ = self->priv->game_file;
		_tmp3_ = g_file_get_path (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->autosave_filename;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp5_) != 0;
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkHeaderBar* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp6_ = self->priv->headerbar;
		_tmp7_ = self->priv->game_file;
		_tmp8_ = g_file_get_basename (_tmp7_);
		_tmp9_ = _tmp8_;
		gtk_header_bar_set_subtitle (_tmp6_, _tmp9_);
		_g_free0 (_tmp9_);
	} else {
		GtkHeaderBar* _tmp10_ = NULL;
		_tmp10_ = self->priv->headerbar;
		gtk_header_bar_set_subtitle (_tmp10_, NULL);
	}
	_tmp11_ = self->priv->history_combo;
	_tmp12_ = gtk_combo_box_get_model (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp14_;
	_tmp15_ = model;
	gtk_list_store_clear (_tmp15_);
	_tmp16_ = model;
	gtk_list_store_append (_tmp16_, &_tmp17_);
	iter = _tmp17_;
	_tmp18_ = model;
	_tmp19_ = iter;
	_tmp20_ = _ ("Game Start");
	gtk_list_store_set (_tmp18_, &_tmp19_, 0, _tmp20_, 1, 0, -1, -1);
	_tmp21_ = self->priv->history_combo;
	_tmp22_ = iter;
	gtk_combo_box_set_active_iter (_tmp21_, &_tmp22_);
	_tmp23_ = g_strdup (CHESS_GAME_STANDARD_SETUP);
	fen = _tmp23_;
	_tmp24_ = self->priv->pgn_game;
	_tmp25_ = _tmp24_->moves;
	_tmp26_ = g_list_length (_tmp25_);
	_tmp27_ = g_new0 (gchar*, _tmp26_ + 1);
	moves = _tmp27_;
	moves_length1 = _tmp26_;
	_moves_size_ = moves_length1;
	i = 0;
	_tmp28_ = self->priv->pgn_game;
	_tmp29_ = _tmp28_->moves;
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
		move_collection = _tmp29_;
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
			gchar* _tmp30_ = NULL;
			gchar* move = NULL;
			_tmp30_ = g_strdup ((const gchar*) move_it->data);
			move = _tmp30_;
			{
				gchar** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gint _tmp32_ = 0;
				const gchar* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				_tmp31_ = moves;
				_tmp31__length1 = moves_length1;
				_tmp32_ = i;
				i = _tmp32_ + 1;
				_tmp33_ = move;
				_tmp34_ = g_strdup (_tmp33_);
				_g_free0 (_tmp31_[_tmp32_]);
				_tmp31_[_tmp32_] = _tmp34_;
				_tmp35_ = _tmp31_[_tmp32_];
				_g_free0 (move);
			}
		}
	}
	_tmp36_ = self->priv->pgn_game;
	_tmp37_ = pgn_game_get_set_up (_tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_) {
		PGNGame* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
		_tmp39_ = self->priv->pgn_game;
		_tmp40_ = pgn_game_get_fen (_tmp39_);
		_tmp41_ = _tmp40_;
		if (_tmp41_ != NULL) {
			PGNGame* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
			_tmp42_ = self->priv->pgn_game;
			_tmp43_ = pgn_game_get_fen (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = g_strdup (_tmp44_);
			_g_free0 (fen);
			fen = _tmp45_;
		} else {
			g_warning ("gnome-chess.vala:460: Chess game has SetUp tag but no FEN tag");
		}
	}
	_tmp46_ = fen;
	_tmp47_ = moves;
	_tmp47__length1 = moves_length1;
	_tmp48_ = chess_game_new (_tmp46_, _tmp47_, _tmp47__length1);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp48_;
	_tmp50_ = self->priv->pgn_game;
	_tmp51_ = pgn_game_get_time_control (_tmp50_);
	_tmp52_ = _tmp51_;
	if (_tmp52_ != NULL) {
		PGNGame* _tmp53_ = NULL;
		const gchar* _tmp54_ = NULL;
		const gchar* _tmp55_ = NULL;
		gint _tmp56_ = 0;
		_tmp53_ = self->priv->pgn_game;
		_tmp54_ = pgn_game_get_time_control (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = atoi (_tmp55_);
		_tmp49_ = _tmp56_ != 0;
	} else {
		_tmp49_ = FALSE;
	}
	if (_tmp49_) {
		gboolean _tmp57_ = FALSE;
		PGNGame* _tmp58_ = NULL;
		const gchar* _tmp59_ = NULL;
		const gchar* _tmp60_ = NULL;
		_tmp58_ = self->priv->pgn_game;
		_tmp59_ = pgn_game_get_white_time_left (_tmp58_);
		_tmp60_ = _tmp59_;
		if (_tmp60_ != NULL) {
			PGNGame* _tmp61_ = NULL;
			const gchar* _tmp62_ = NULL;
			const gchar* _tmp63_ = NULL;
			_tmp61_ = self->priv->pgn_game;
			_tmp62_ = pgn_game_get_black_time_left (_tmp61_);
			_tmp63_ = _tmp62_;
			_tmp57_ = _tmp63_ != NULL;
		} else {
			_tmp57_ = FALSE;
		}
		if (_tmp57_) {
			gint white_seconds = 0;
			PGNGame* _tmp64_ = NULL;
			const gchar* _tmp65_ = NULL;
			const gchar* _tmp66_ = NULL;
			gint _tmp67_ = 0;
			gint black_seconds = 0;
			PGNGame* _tmp68_ = NULL;
			const gchar* _tmp69_ = NULL;
			const gchar* _tmp70_ = NULL;
			gint _tmp71_ = 0;
			gboolean _tmp72_ = FALSE;
			gint _tmp73_ = 0;
			_tmp64_ = self->priv->pgn_game;
			_tmp65_ = pgn_game_get_white_time_left (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = atoi (_tmp66_);
			white_seconds = _tmp67_;
			_tmp68_ = self->priv->pgn_game;
			_tmp69_ = pgn_game_get_black_time_left (_tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = atoi (_tmp70_);
			black_seconds = _tmp71_;
			_tmp73_ = white_seconds;
			if (_tmp73_ >= 0) {
				gint _tmp74_ = 0;
				_tmp74_ = black_seconds;
				_tmp72_ = _tmp74_ >= 0;
			} else {
				_tmp72_ = FALSE;
			}
			if (_tmp72_) {
				ChessGame* _tmp75_ = NULL;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
				ChessClock* _tmp78_ = NULL;
				ChessClock* _tmp79_ = NULL;
				_tmp75_ = self->priv->game;
				_tmp76_ = white_seconds;
				_tmp77_ = black_seconds;
				_tmp78_ = chess_clock_new (_tmp76_, _tmp77_);
				_tmp79_ = _tmp78_;
				chess_game_set_clock (_tmp75_, _tmp79_);
				_g_object_unref0 (_tmp79_);
			}
		}
	}
	_tmp80_ = self->priv->game;
	g_signal_connect_object (_tmp80_, "turn-started", (GCallback) _chess_application_game_turn_cb_chess_game_turn_started, self, 0);
	_tmp81_ = self->priv->game;
	g_signal_connect_object (_tmp81_, "moved", (GCallback) _chess_application_game_move_cb_chess_game_moved, self, 0);
	_tmp82_ = self->priv->game;
	g_signal_connect_object (_tmp82_, "undo", (GCallback) _chess_application_game_undo_cb_chess_game_undo, self, 0);
	_tmp83_ = self->priv->game;
	g_signal_connect_object (_tmp83_, "ended", (GCallback) _chess_application_game_end_cb_chess_game_ended, self, 0);
	_tmp84_ = self->priv->game;
	_tmp85_ = chess_game_get_clock (_tmp84_);
	_tmp86_ = _tmp85_;
	if (_tmp86_ != NULL) {
		ChessGame* _tmp87_ = NULL;
		ChessClock* _tmp88_ = NULL;
		ChessClock* _tmp89_ = NULL;
		_tmp87_ = self->priv->game;
		_tmp88_ = chess_game_get_clock (_tmp87_);
		_tmp89_ = _tmp88_;
		g_signal_connect_object (_tmp89_, "tick", (GCallback) _chess_application_game_clock_tick_cb_chess_clock_tick, self, 0);
	}
	_tmp90_ = self->priv->scene;
	_tmp91_ = self->priv->game;
	chess_scene_set_game (_tmp90_, _tmp91_);
	_tmp92_ = self->priv->pgn_game;
	_tmp93_ = pgn_game_get_white_ai (_tmp92_);
	_tmp94_ = _tmp93_;
	_tmp95_ = g_strdup (_tmp94_);
	white_engine = _tmp95_;
	_tmp96_ = self->priv->pgn_game;
	_tmp97_ = pgn_game_get_white_level (_tmp96_);
	_tmp98_ = _tmp97_;
	_tmp99_ = g_strdup (_tmp98_);
	white_level = _tmp99_;
	_tmp100_ = white_level;
	if (_tmp100_ == NULL) {
		gchar* _tmp101_ = NULL;
		_tmp101_ = g_strdup ("normal");
		_g_free0 (white_level);
		white_level = _tmp101_;
	}
	_tmp102_ = self->priv->pgn_game;
	_tmp103_ = pgn_game_get_black_ai (_tmp102_);
	_tmp104_ = _tmp103_;
	_tmp105_ = g_strdup (_tmp104_);
	black_engine = _tmp105_;
	_tmp106_ = self->priv->pgn_game;
	_tmp107_ = pgn_game_get_black_level (_tmp106_);
	_tmp108_ = _tmp107_;
	_tmp109_ = g_strdup (_tmp108_);
	black_level = _tmp109_;
	_tmp110_ = black_level;
	if (_tmp110_ == NULL) {
		gchar* _tmp111_ = NULL;
		_tmp111_ = g_strdup ("normal");
		_g_free0 (black_level);
		black_level = _tmp111_;
	}
	_g_object_unref0 (self->priv->human_player);
	self->priv->human_player = NULL;
	_g_object_unref0 (self->priv->opponent);
	self->priv->opponent = NULL;
	_tmp112_ = self->priv->opponent_engine;
	if (_tmp112_ != NULL) {
		ChessEngine* _tmp113_ = NULL;
		ChessEngine* _tmp114_ = NULL;
		guint _tmp115_ = 0U;
		ChessEngine* _tmp116_ = NULL;
		guint _tmp117_ = 0U;
		ChessEngine* _tmp118_ = NULL;
		guint _tmp119_ = 0U;
		ChessEngine* _tmp120_ = NULL;
		guint _tmp121_ = 0U;
		ChessEngine* _tmp122_ = NULL;
		guint _tmp123_ = 0U;
		ChessEngine* _tmp124_ = NULL;
		guint _tmp125_ = 0U;
		ChessEngine* _tmp126_ = NULL;
		guint _tmp127_ = 0U;
		_tmp113_ = self->priv->opponent_engine;
		chess_engine_stop (_tmp113_);
		_tmp114_ = self->priv->opponent_engine;
		g_signal_parse_name ("ready-changed", TYPE_CHESS_ENGINE, &_tmp115_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp114_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp115_, 0, NULL, (GCallback) _chess_application_engine_ready_cb_chess_engine_ready_changed, self);
		_tmp116_ = self->priv->opponent_engine;
		g_signal_parse_name ("moved", TYPE_CHESS_ENGINE, &_tmp117_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp116_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp117_, 0, NULL, (GCallback) _chess_application_engine_move_cb_chess_engine_moved, self);
		_tmp118_ = self->priv->opponent_engine;
		g_signal_parse_name ("resigned", TYPE_CHESS_ENGINE, &_tmp119_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp118_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp119_, 0, NULL, (GCallback) _chess_application_engine_resigned_cb_chess_engine_resigned, self);
		_tmp120_ = self->priv->opponent_engine;
		g_signal_parse_name ("stopped", TYPE_CHESS_ENGINE, &_tmp121_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp120_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp121_, 0, NULL, (GCallback) _chess_application_engine_stopped_cb_chess_engine_stopped, self);
		_tmp122_ = self->priv->opponent_engine;
		g_signal_parse_name ("error", TYPE_CHESS_ENGINE, &_tmp123_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp122_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp123_, 0, NULL, (GCallback) _chess_application_engine_error_cb_chess_engine_error, self);
		_tmp124_ = self->priv->opponent_engine;
		g_signal_parse_name ("claim-draw", TYPE_CHESS_ENGINE, &_tmp125_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp124_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp125_, 0, NULL, (GCallback) _chess_application_engine_claim_draw_cb_chess_engine_claim_draw, self);
		_tmp126_ = self->priv->opponent_engine;
		g_signal_parse_name ("offer-draw", TYPE_CHESS_ENGINE, &_tmp127_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp126_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp127_, 0, NULL, (GCallback) _chess_application_engine_offer_draw_cb_chess_engine_offer_draw, self);
		_g_object_unref0 (self->priv->opponent_engine);
		self->priv->opponent_engine = NULL;
	}
	_tmp128_ = white_engine;
	if (_tmp128_ != NULL) {
		ChessGame* _tmp129_ = NULL;
		ChessPlayer* _tmp130_ = NULL;
		ChessPlayer* _tmp131_ = NULL;
		ChessPlayer* _tmp132_ = NULL;
		ChessGame* _tmp133_ = NULL;
		ChessPlayer* _tmp134_ = NULL;
		ChessPlayer* _tmp135_ = NULL;
		ChessPlayer* _tmp136_ = NULL;
		const gchar* _tmp137_ = NULL;
		const gchar* _tmp138_ = NULL;
		ChessEngine* _tmp139_ = NULL;
		ChessPlayer* _tmp140_ = NULL;
		ChessPlayer* _tmp141_ = NULL;
		_tmp129_ = self->priv->game;
		_tmp130_ = chess_game_get_white (_tmp129_);
		_tmp131_ = _tmp130_;
		_tmp132_ = _g_object_ref0 (_tmp131_);
		_g_object_unref0 (self->priv->opponent);
		self->priv->opponent = _tmp132_;
		_tmp133_ = self->priv->game;
		_tmp134_ = chess_game_get_black (_tmp133_);
		_tmp135_ = _tmp134_;
		_tmp136_ = _g_object_ref0 (_tmp135_);
		_g_object_unref0 (self->priv->human_player);
		self->priv->human_player = _tmp136_;
		_tmp137_ = white_engine;
		_tmp138_ = white_level;
		_tmp139_ = chess_application_get_engine (self, _tmp137_, _tmp138_);
		_g_object_unref0 (self->priv->opponent_engine);
		self->priv->opponent_engine = _tmp139_;
		_tmp140_ = self->priv->opponent;
		chess_player_set_local_human (_tmp140_, FALSE);
		_tmp141_ = self->priv->human_player;
		chess_player_set_local_human (_tmp141_, TRUE);
	} else {
		const gchar* _tmp142_ = NULL;
		_tmp142_ = black_engine;
		if (_tmp142_ != NULL) {
			ChessGame* _tmp143_ = NULL;
			ChessPlayer* _tmp144_ = NULL;
			ChessPlayer* _tmp145_ = NULL;
			ChessPlayer* _tmp146_ = NULL;
			ChessGame* _tmp147_ = NULL;
			ChessPlayer* _tmp148_ = NULL;
			ChessPlayer* _tmp149_ = NULL;
			ChessPlayer* _tmp150_ = NULL;
			const gchar* _tmp151_ = NULL;
			const gchar* _tmp152_ = NULL;
			ChessEngine* _tmp153_ = NULL;
			ChessPlayer* _tmp154_ = NULL;
			ChessPlayer* _tmp155_ = NULL;
			_tmp143_ = self->priv->game;
			_tmp144_ = chess_game_get_black (_tmp143_);
			_tmp145_ = _tmp144_;
			_tmp146_ = _g_object_ref0 (_tmp145_);
			_g_object_unref0 (self->priv->opponent);
			self->priv->opponent = _tmp146_;
			_tmp147_ = self->priv->game;
			_tmp148_ = chess_game_get_white (_tmp147_);
			_tmp149_ = _tmp148_;
			_tmp150_ = _g_object_ref0 (_tmp149_);
			_g_object_unref0 (self->priv->human_player);
			self->priv->human_player = _tmp150_;
			_tmp151_ = black_engine;
			_tmp152_ = black_level;
			_tmp153_ = chess_application_get_engine (self, _tmp151_, _tmp152_);
			_g_object_unref0 (self->priv->opponent_engine);
			self->priv->opponent_engine = _tmp153_;
			_tmp154_ = self->priv->opponent;
			chess_player_set_local_human (_tmp154_, FALSE);
			_tmp155_ = self->priv->human_player;
			chess_player_set_local_human (_tmp155_, TRUE);
		}
	}
	_tmp156_ = self->priv->opponent_engine;
	if (_tmp156_ == NULL) {
		ChessGame* _tmp157_ = NULL;
		ChessPlayer* _tmp158_ = NULL;
		ChessPlayer* _tmp159_ = NULL;
		ChessGame* _tmp160_ = NULL;
		ChessPlayer* _tmp161_ = NULL;
		ChessPlayer* _tmp162_ = NULL;
		_tmp157_ = self->priv->game;
		_tmp158_ = chess_game_get_black (_tmp157_);
		_tmp159_ = _tmp158_;
		chess_player_set_local_human (_tmp159_, TRUE);
		_tmp160_ = self->priv->game;
		_tmp161_ = chess_game_get_white (_tmp160_);
		_tmp162_ = _tmp161_;
		chess_player_set_local_human (_tmp162_, TRUE);
		_g_object_unref0 (self->priv->human_player);
		self->priv->human_player = NULL;
	} else {
		ChessEngine* _tmp163_ = NULL;
		ChessEngine* _tmp164_ = NULL;
		ChessEngine* _tmp165_ = NULL;
		ChessEngine* _tmp166_ = NULL;
		ChessEngine* _tmp167_ = NULL;
		ChessEngine* _tmp168_ = NULL;
		ChessEngine* _tmp169_ = NULL;
		ChessEngine* _tmp170_ = NULL;
		gboolean _tmp171_ = FALSE;
		_tmp163_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp163_, "ready-changed", (GCallback) _chess_application_engine_ready_cb_chess_engine_ready_changed, self, 0);
		_tmp164_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp164_, "moved", (GCallback) _chess_application_engine_move_cb_chess_engine_moved, self, 0);
		_tmp165_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp165_, "resigned", (GCallback) _chess_application_engine_resigned_cb_chess_engine_resigned, self, 0);
		_tmp166_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp166_, "stopped", (GCallback) _chess_application_engine_stopped_cb_chess_engine_stopped, self, 0);
		_tmp167_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp167_, "error", (GCallback) _chess_application_engine_error_cb_chess_engine_error, self, 0);
		_tmp168_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp168_, "claim-draw", (GCallback) _chess_application_engine_claim_draw_cb_chess_engine_claim_draw, self, 0);
		_tmp169_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp169_, "offer-draw", (GCallback) _chess_application_engine_offer_draw_cb_chess_engine_offer_draw, self, 0);
		_tmp170_ = self->priv->opponent_engine;
		_tmp171_ = chess_engine_start (_tmp170_);
		if (!_tmp171_) {
			ChessGame* _tmp172_ = NULL;
			ChessGame* _tmp173_ = NULL;
			ChessGame* _tmp174_ = NULL;
			chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
			_tmp172_ = self->priv->game;
			_tmp172_->result = CHESS_RESULT_BUG;
			_tmp173_ = self->priv->game;
			_tmp173_->rule = CHESS_RULE_BUG;
			_tmp174_ = self->priv->game;
			chess_application_game_end_cb (self, _tmp174_);
			_g_free0 (black_level);
			_g_free0 (black_engine);
			_g_free0 (white_level);
			_g_free0 (white_engine);
			moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (fen);
			_g_object_unref0 (model);
			return;
		}
	}
	{
		gint j = 0;
		ChessGame* _tmp175_ = NULL;
		GList* _tmp176_ = NULL;
		guint _tmp177_ = 0U;
		_tmp175_ = self->priv->game;
		_tmp176_ = _tmp175_->move_stack;
		_tmp177_ = g_list_length (_tmp176_);
		j = ((gint) _tmp177_) - 2;
		{
			gboolean _tmp178_ = FALSE;
			_tmp178_ = TRUE;
			while (TRUE) {
				gint _tmp180_ = 0;
				ChessState* state = NULL;
				ChessGame* _tmp181_ = NULL;
				GList* _tmp182_ = NULL;
				gint _tmp183_ = 0;
				gconstpointer _tmp184_ = NULL;
				ChessState* _tmp185_ = NULL;
				ChessGame* _tmp186_ = NULL;
				ChessState* _tmp187_ = NULL;
				ChessMove* _tmp188_ = NULL;
				if (!_tmp178_) {
					gint _tmp179_ = 0;
					_tmp179_ = j;
					j = _tmp179_ - 1;
				}
				_tmp178_ = FALSE;
				_tmp180_ = j;
				if (!(_tmp180_ >= 0)) {
					break;
				}
				_tmp181_ = self->priv->game;
				_tmp182_ = _tmp181_->move_stack;
				_tmp183_ = j;
				_tmp184_ = g_list_nth_data (_tmp182_, (guint) _tmp183_);
				_tmp185_ = _g_object_ref0 ((ChessState*) _tmp184_);
				state = _tmp185_;
				_tmp186_ = self->priv->game;
				_tmp187_ = state;
				_tmp188_ = _tmp187_->last_move;
				chess_application_game_move_cb (self, _tmp186_, _tmp188_);
				_g_object_unref0 (state);
			}
		}
	}
	_tmp190_ = self->priv->game_file;
	if (_tmp190_ != NULL) {
		GFile* _tmp191_ = NULL;
		gchar* _tmp192_ = NULL;
		gchar* _tmp193_ = NULL;
		const gchar* _tmp194_ = NULL;
		_tmp191_ = self->priv->game_file;
		_tmp192_ = g_file_get_path (_tmp191_);
		_tmp193_ = _tmp192_;
		_tmp194_ = self->priv->autosave_filename;
		_tmp189_ = g_strcmp0 (_tmp193_, _tmp194_) == 0;
		_g_free0 (_tmp193_);
	} else {
		_tmp189_ = FALSE;
	}
	if (_tmp189_) {
		self->priv->game_needs_saving = TRUE;
		chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
	} else {
		self->priv->game_needs_saving = FALSE;
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
	}
	_tmp195_ = self->priv->game;
	chess_game_start (_tmp195_);
	timer_increment_adj_value = 0;
	_tmp196_ = self->priv->pgn_game;
	_tmp197_ = pgn_game_get_timer_increment (_tmp196_);
	_tmp198_ = _tmp197_;
	if (_tmp198_ != NULL) {
		PGNGame* _tmp199_ = NULL;
		const gchar* _tmp200_ = NULL;
		const gchar* _tmp201_ = NULL;
		gint _tmp202_ = 0;
		_tmp199_ = self->priv->pgn_game;
		_tmp200_ = pgn_game_get_timer_increment (_tmp199_);
		_tmp201_ = _tmp200_;
		_tmp202_ = atoi (_tmp201_);
		timer_increment_adj_value = _tmp202_;
	} else {
		GSettings* _tmp203_ = NULL;
		gint _tmp204_ = 0;
		PGNGame* _tmp205_ = NULL;
		gint _tmp206_ = 0;
		gchar* _tmp207_ = NULL;
		gchar* _tmp208_ = NULL;
		_tmp203_ = self->priv->settings;
		_tmp204_ = g_settings_get_int (_tmp203_, "timer-increment");
		timer_increment_adj_value = _tmp204_;
		_tmp205_ = self->priv->pgn_game;
		_tmp206_ = timer_increment_adj_value;
		_tmp207_ = g_strdup_printf ("%i", _tmp206_);
		_tmp208_ = _tmp207_;
		pgn_game_set_timer_increment (_tmp205_, _tmp208_);
		_g_free0 (_tmp208_);
	}
	clock_type = CLOCK_TYPE_SIMPLE;
	_tmp209_ = self->priv->pgn_game;
	_tmp210_ = pgn_game_get_clock_type (_tmp209_);
	_tmp211_ = _tmp210_;
	if (_tmp211_ != NULL) {
		PGNGame* _tmp212_ = NULL;
		const gchar* _tmp213_ = NULL;
		const gchar* _tmp214_ = NULL;
		ClockType _tmp215_ = 0;
		_tmp212_ = self->priv->pgn_game;
		_tmp213_ = pgn_game_get_clock_type (_tmp212_);
		_tmp214_ = _tmp213_;
		_tmp215_ = clock_type_string_to_enum (_tmp214_);
		clock_type = _tmp215_;
	} else {
		GSettings* _tmp216_ = NULL;
		gchar* _tmp217_ = NULL;
		gchar* _tmp218_ = NULL;
		ClockType _tmp219_ = 0;
		PGNGame* _tmp220_ = NULL;
		ClockType _tmp221_ = 0;
		gchar* _tmp222_ = NULL;
		gchar* _tmp223_ = NULL;
		_tmp216_ = self->priv->settings;
		_tmp217_ = g_settings_get_string (_tmp216_, "clock-type");
		_tmp218_ = _tmp217_;
		_tmp219_ = clock_type_string_to_enum (_tmp218_);
		clock_type = _tmp219_;
		_g_free0 (_tmp218_);
		_tmp220_ = self->priv->pgn_game;
		_tmp221_ = clock_type;
		_tmp222_ = clock_type_to_string (_tmp221_);
		_tmp223_ = _tmp222_;
		pgn_game_set_clock_type (_tmp220_, _tmp223_);
		_g_free0 (_tmp223_);
	}
	_tmp224_ = self->priv->game;
	_tmp225_ = chess_game_get_clock (_tmp224_);
	_tmp226_ = _tmp225_;
	if (_tmp226_ != NULL) {
		ChessGame* _tmp227_ = NULL;
		ChessClock* _tmp228_ = NULL;
		ChessClock* _tmp229_ = NULL;
		gint _tmp230_ = 0;
		ChessGame* _tmp231_ = NULL;
		ChessClock* _tmp232_ = NULL;
		ChessClock* _tmp233_ = NULL;
		ClockType _tmp234_ = 0;
		_tmp227_ = self->priv->game;
		_tmp228_ = chess_game_get_clock (_tmp227_);
		_tmp229_ = _tmp228_;
		_tmp230_ = timer_increment_adj_value;
		chess_clock_set_extra_seconds (_tmp229_, (gint) _tmp230_);
		_tmp231_ = self->priv->game;
		_tmp232_ = chess_game_get_clock (_tmp231_);
		_tmp233_ = _tmp232_;
		_tmp234_ = clock_type;
		chess_clock_set_clock_type (_tmp233_, _tmp234_);
	}
	_tmp235_ = self->priv->pgn_game;
	_tmp236_ = pgn_game_get_result (_tmp235_);
	_tmp237_ = _tmp236_;
	_tmp238_ = pgn_game_RESULT_WHITE;
	if (g_strcmp0 (_tmp237_, _tmp238_) == 0) {
		ChessGame* _tmp239_ = NULL;
		_tmp239_ = self->priv->game;
		_tmp239_->result = CHESS_RESULT_WHITE_WON;
	} else {
		PGNGame* _tmp240_ = NULL;
		const gchar* _tmp241_ = NULL;
		const gchar* _tmp242_ = NULL;
		const gchar* _tmp243_ = NULL;
		_tmp240_ = self->priv->pgn_game;
		_tmp241_ = pgn_game_get_result (_tmp240_);
		_tmp242_ = _tmp241_;
		_tmp243_ = pgn_game_RESULT_BLACK;
		if (g_strcmp0 (_tmp242_, _tmp243_) == 0) {
			ChessGame* _tmp244_ = NULL;
			_tmp244_ = self->priv->game;
			_tmp244_->result = CHESS_RESULT_BLACK_WON;
		} else {
			PGNGame* _tmp245_ = NULL;
			const gchar* _tmp246_ = NULL;
			const gchar* _tmp247_ = NULL;
			const gchar* _tmp248_ = NULL;
			_tmp245_ = self->priv->pgn_game;
			_tmp246_ = pgn_game_get_result (_tmp245_);
			_tmp247_ = _tmp246_;
			_tmp248_ = pgn_game_RESULT_DRAW;
			if (g_strcmp0 (_tmp247_, _tmp248_) == 0) {
				ChessGame* _tmp249_ = NULL;
				_tmp249_ = self->priv->game;
				_tmp249_->result = CHESS_RESULT_DRAW;
			}
		}
	}
	_tmp250_ = self->priv->opponent_engine;
	if (_tmp250_ != NULL) {
		ChessEngine* _tmp251_ = NULL;
		_tmp251_ = self->priv->opponent_engine;
		chess_engine_start_game (_tmp251_);
	}
	_tmp253_ = moves;
	_tmp253__length1 = moves_length1;
	if (_tmp253__length1 > 0) {
		ChessGame* _tmp254_ = NULL;
		ChessClock* _tmp255_ = NULL;
		ChessClock* _tmp256_ = NULL;
		_tmp254_ = self->priv->game;
		_tmp255_ = chess_game_get_clock (_tmp254_);
		_tmp256_ = _tmp255_;
		_tmp252_ = _tmp256_ != NULL;
	} else {
		_tmp252_ = FALSE;
	}
	if (_tmp252_) {
		ChessGame* _tmp257_ = NULL;
		ChessClock* _tmp258_ = NULL;
		ChessClock* _tmp259_ = NULL;
		_tmp257_ = self->priv->game;
		_tmp258_ = chess_game_get_clock (_tmp257_);
		_tmp259_ = _tmp258_;
		chess_clock_start (_tmp259_);
		chess_application_enable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
	} else {
		chess_application_disable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
	}
	chess_application_update_history_panel (self);
	chess_application_update_action_status (self);
	chess_application_update_pause_resume_button (self);
	chess_application_update_headerbar_title (self);
	_tmp260_ = self->priv->white_time_label;
	gtk_widget_queue_draw (_tmp260_);
	_tmp261_ = self->priv->black_time_label;
	gtk_widget_queue_draw (_tmp261_);
	self->priv->starting = FALSE;
	_tmp264_ = white_engine;
	if (_tmp264_ != NULL) {
		ChessGame* _tmp265_ = NULL;
		ChessPlayer* _tmp266_ = NULL;
		ChessPlayer* _tmp267_ = NULL;
		Color _tmp268_ = 0;
		_tmp265_ = self->priv->game;
		_tmp266_ = chess_game_get_current_player (_tmp265_);
		_tmp267_ = _tmp266_;
		_tmp268_ = _tmp267_->color;
		_tmp263_ = _tmp268_ == COLOR_WHITE;
	} else {
		_tmp263_ = FALSE;
	}
	if (_tmp263_) {
		_tmp262_ = TRUE;
	} else {
		gboolean _tmp269_ = FALSE;
		const gchar* _tmp270_ = NULL;
		_tmp270_ = black_engine;
		if (_tmp270_ != NULL) {
			ChessGame* _tmp271_ = NULL;
			ChessPlayer* _tmp272_ = NULL;
			ChessPlayer* _tmp273_ = NULL;
			Color _tmp274_ = 0;
			_tmp271_ = self->priv->game;
			_tmp272_ = chess_game_get_current_player (_tmp271_);
			_tmp273_ = _tmp272_;
			_tmp274_ = _tmp273_->color;
			_tmp269_ = _tmp274_ == COLOR_BLACK;
		} else {
			_tmp269_ = FALSE;
		}
		_tmp262_ = _tmp269_;
	}
	if (_tmp262_) {
		ChessEngine* _tmp275_ = NULL;
		ChessEngine* _tmp276_ = NULL;
		_tmp275_ = self->priv->opponent_engine;
		_vala_assert (_tmp275_ != NULL, "opponent_engine != null");
		_tmp276_ = self->priv->opponent_engine;
		chess_engine_move (_tmp276_);
	}
	_tmp277_ = self->priv->game;
	_tmp278_ = _tmp277_->result;
	if (_tmp278_ != CHESS_RESULT_IN_PROGRESS) {
		ChessGame* _tmp279_ = NULL;
		ChessGame* _tmp280_ = NULL;
		ChessResult _tmp281_ = 0;
		_tmp279_ = self->priv->game;
		_tmp280_ = self->priv->game;
		_tmp281_ = _tmp280_->result;
		chess_game_stop (_tmp279_, _tmp281_, CHESS_RULE_UNKNOWN);
	}
	_g_free0 (black_level);
	_g_free0 (black_engine);
	_g_free0 (white_level);
	_g_free0 (white_engine);
	moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (fen);
	_g_object_unref0 (model);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup8 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup9 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static ChessEngine* chess_application_get_engine (ChessApplication* self, const gchar* name, const gchar* difficulty) {
	ChessEngine* result = NULL;
	ChessEngine* engine = NULL;
	AIProfile* profile = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	AIProfile* _tmp12_ = NULL;
	gchar** options = NULL;
	gint options_length1 = 0;
	gint _options_size_ = 0;
	gchar** uci_go_options = NULL;
	gint uci_go_options_length1 = 0;
	gint _uci_go_options_size_ = 0;
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GQuark _tmp21_ = 0U;
	static GQuark _tmp20_label0 = 0;
	static GQuark _tmp20_label1 = 0;
	AIProfile* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (difficulty != NULL, NULL);
	profile = NULL;
	_tmp0_ = name;
	if (g_strcmp0 (_tmp0_, "human") == 0) {
		result = NULL;
		_g_object_unref0 (profile);
		_g_object_unref0 (engine);
		return result;
	}
	_tmp1_ = name;
	if (g_strcmp0 (_tmp1_, "GNUchess") == 0) {
		name = "GNU Chess";
	}
	_tmp2_ = self->priv->ai_profiles;
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
		p_collection = _tmp2_;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			AIProfile* _tmp3_ = NULL;
			AIProfile* p = NULL;
			_tmp3_ = _g_object_ref0 ((AIProfile*) p_it->data);
			p = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				const gchar* _tmp5_ = NULL;
				_tmp5_ = name;
				if (g_strcmp0 (_tmp5_, "") == 0) {
					_tmp4_ = TRUE;
				} else {
					AIProfile* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					_tmp6_ = p;
					_tmp7_ = ai_profile_get_name (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = name;
					_tmp4_ = g_strcmp0 (_tmp8_, _tmp9_) == 0;
				}
				if (_tmp4_) {
					AIProfile* _tmp10_ = NULL;
					AIProfile* _tmp11_ = NULL;
					_tmp10_ = p;
					_tmp11_ = _g_object_ref0 (_tmp10_);
					_g_object_unref0 (profile);
					profile = _tmp11_;
					_g_object_unref0 (p);
					break;
				}
				_g_object_unref0 (p);
			}
		}
	}
	_tmp12_ = profile;
	if (_tmp12_ == NULL) {
		const gchar* _tmp13_ = NULL;
		GList* _tmp14_ = NULL;
		GList* _tmp15_ = NULL;
		gconstpointer _tmp16_ = NULL;
		AIProfile* _tmp17_ = NULL;
		_tmp13_ = name;
		g_warning ("gnome-chess.vala:667: Unknown AI profile %s", _tmp13_);
		_tmp14_ = self->priv->ai_profiles;
		if (_tmp14_ == NULL) {
			result = NULL;
			_g_object_unref0 (profile);
			_g_object_unref0 (engine);
			return result;
		}
		_tmp15_ = self->priv->ai_profiles;
		_tmp16_ = _tmp15_->data;
		_tmp17_ = _g_object_ref0 ((AIProfile*) _tmp16_);
		_g_object_unref0 (profile);
		profile = _tmp17_;
	}
	_tmp18_ = difficulty;
	_tmp19_ = _tmp18_;
	_tmp21_ = (NULL == _tmp19_) ? 0 : g_quark_from_string (_tmp19_);
	if (_tmp21_ == ((0 != _tmp20_label0) ? _tmp20_label0 : (_tmp20_label0 = g_quark_from_static_string ("easy")))) {
		switch (0) {
			default:
			{
				AIProfile* _tmp22_ = NULL;
				gchar** _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				gchar** _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				gchar** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				AIProfile* _tmp26_ = NULL;
				gchar** _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				gchar** _tmp28_ = NULL;
				gint _tmp28__length1 = 0;
				gchar** _tmp29_ = NULL;
				gint _tmp29__length1 = 0;
				AIProfile* _tmp30_ = NULL;
				gchar** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gchar** _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				gchar** _tmp33_ = NULL;
				gint _tmp33__length1 = 0;
				_tmp22_ = profile;
				_tmp23_ = ai_profile_get_easy_options (_tmp22_, &_tmp23__length1);
				_tmp24_ = _tmp23_;
				_tmp24__length1 = _tmp23__length1;
				_tmp25_ = (_tmp24_ != NULL) ? _vala_array_dup1 (_tmp24_, _tmp24__length1) : ((gpointer) _tmp24_);
				_tmp25__length1 = _tmp24__length1;
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp25_;
				options_length1 = _tmp25__length1;
				_options_size_ = options_length1;
				_tmp26_ = profile;
				_tmp27_ = ai_profile_get_easy_uci_go_options (_tmp26_, &_tmp27__length1);
				_tmp28_ = _tmp27_;
				_tmp28__length1 = _tmp27__length1;
				_tmp29_ = (_tmp28_ != NULL) ? _vala_array_dup2 (_tmp28_, _tmp28__length1) : ((gpointer) _tmp28_);
				_tmp29__length1 = _tmp28__length1;
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
				uci_go_options = _tmp29_;
				uci_go_options_length1 = _tmp29__length1;
				_uci_go_options_size_ = uci_go_options_length1;
				_tmp30_ = profile;
				_tmp31_ = ai_profile_get_easy_args (_tmp30_, &_tmp31__length1);
				_tmp32_ = _tmp31_;
				_tmp32__length1 = _tmp31__length1;
				_tmp33_ = (_tmp32_ != NULL) ? _vala_array_dup3 (_tmp32_, _tmp32__length1) : ((gpointer) _tmp32_);
				_tmp33__length1 = _tmp32__length1;
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				args = _tmp33_;
				args_length1 = _tmp33__length1;
				_args_size_ = args_length1;
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label1) ? _tmp20_label1 : (_tmp20_label1 = g_quark_from_static_string ("hard")))) {
		switch (0) {
			default:
			{
				AIProfile* _tmp34_ = NULL;
				gchar** _tmp35_ = NULL;
				gint _tmp35__length1 = 0;
				gchar** _tmp36_ = NULL;
				gint _tmp36__length1 = 0;
				gchar** _tmp37_ = NULL;
				gint _tmp37__length1 = 0;
				AIProfile* _tmp38_ = NULL;
				gchar** _tmp39_ = NULL;
				gint _tmp39__length1 = 0;
				gchar** _tmp40_ = NULL;
				gint _tmp40__length1 = 0;
				gchar** _tmp41_ = NULL;
				gint _tmp41__length1 = 0;
				AIProfile* _tmp42_ = NULL;
				gchar** _tmp43_ = NULL;
				gint _tmp43__length1 = 0;
				gchar** _tmp44_ = NULL;
				gint _tmp44__length1 = 0;
				gchar** _tmp45_ = NULL;
				gint _tmp45__length1 = 0;
				_tmp34_ = profile;
				_tmp35_ = ai_profile_get_hard_options (_tmp34_, &_tmp35__length1);
				_tmp36_ = _tmp35_;
				_tmp36__length1 = _tmp35__length1;
				_tmp37_ = (_tmp36_ != NULL) ? _vala_array_dup4 (_tmp36_, _tmp36__length1) : ((gpointer) _tmp36_);
				_tmp37__length1 = _tmp36__length1;
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp37_;
				options_length1 = _tmp37__length1;
				_options_size_ = options_length1;
				_tmp38_ = profile;
				_tmp39_ = ai_profile_get_hard_uci_go_options (_tmp38_, &_tmp39__length1);
				_tmp40_ = _tmp39_;
				_tmp40__length1 = _tmp39__length1;
				_tmp41_ = (_tmp40_ != NULL) ? _vala_array_dup5 (_tmp40_, _tmp40__length1) : ((gpointer) _tmp40_);
				_tmp41__length1 = _tmp40__length1;
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
				uci_go_options = _tmp41_;
				uci_go_options_length1 = _tmp41__length1;
				_uci_go_options_size_ = uci_go_options_length1;
				_tmp42_ = profile;
				_tmp43_ = ai_profile_get_hard_args (_tmp42_, &_tmp43__length1);
				_tmp44_ = _tmp43_;
				_tmp44__length1 = _tmp43__length1;
				_tmp45_ = (_tmp44_ != NULL) ? _vala_array_dup6 (_tmp44_, _tmp44__length1) : ((gpointer) _tmp44_);
				_tmp45__length1 = _tmp44__length1;
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				args = _tmp45_;
				args_length1 = _tmp45__length1;
				_args_size_ = args_length1;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				AIProfile* _tmp46_ = NULL;
				gchar** _tmp47_ = NULL;
				gint _tmp47__length1 = 0;
				gchar** _tmp48_ = NULL;
				gint _tmp48__length1 = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				AIProfile* _tmp50_ = NULL;
				gchar** _tmp51_ = NULL;
				gint _tmp51__length1 = 0;
				gchar** _tmp52_ = NULL;
				gint _tmp52__length1 = 0;
				gchar** _tmp53_ = NULL;
				gint _tmp53__length1 = 0;
				AIProfile* _tmp54_ = NULL;
				gchar** _tmp55_ = NULL;
				gint _tmp55__length1 = 0;
				gchar** _tmp56_ = NULL;
				gint _tmp56__length1 = 0;
				gchar** _tmp57_ = NULL;
				gint _tmp57__length1 = 0;
				_tmp46_ = profile;
				_tmp47_ = ai_profile_get_normal_options (_tmp46_, &_tmp47__length1);
				_tmp48_ = _tmp47_;
				_tmp48__length1 = _tmp47__length1;
				_tmp49_ = (_tmp48_ != NULL) ? _vala_array_dup7 (_tmp48_, _tmp48__length1) : ((gpointer) _tmp48_);
				_tmp49__length1 = _tmp48__length1;
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp49_;
				options_length1 = _tmp49__length1;
				_options_size_ = options_length1;
				_tmp50_ = profile;
				_tmp51_ = ai_profile_get_normal_uci_go_options (_tmp50_, &_tmp51__length1);
				_tmp52_ = _tmp51_;
				_tmp52__length1 = _tmp51__length1;
				_tmp53_ = (_tmp52_ != NULL) ? _vala_array_dup8 (_tmp52_, _tmp52__length1) : ((gpointer) _tmp52_);
				_tmp53__length1 = _tmp52__length1;
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
				uci_go_options = _tmp53_;
				uci_go_options_length1 = _tmp53__length1;
				_uci_go_options_size_ = uci_go_options_length1;
				_tmp54_ = profile;
				_tmp55_ = ai_profile_get_normal_args (_tmp54_, &_tmp55__length1);
				_tmp56_ = _tmp55_;
				_tmp56__length1 = _tmp55__length1;
				_tmp57_ = (_tmp56_ != NULL) ? _vala_array_dup9 (_tmp56_, _tmp56__length1) : ((gpointer) _tmp56_);
				_tmp57__length1 = _tmp56__length1;
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				args = _tmp57_;
				args_length1 = _tmp57__length1;
				_args_size_ = args_length1;
				break;
			}
		}
	}
	_tmp58_ = profile;
	_tmp59_ = ai_profile_get_protocol (_tmp58_);
	_tmp60_ = _tmp59_;
	if (g_strcmp0 (_tmp60_, "cecp") == 0) {
		gchar** _tmp61_ = NULL;
		gint _tmp61__length1 = 0;
		AIProfile* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		const gchar* _tmp64_ = NULL;
		gchar** _tmp65_ = NULL;
		gint _tmp65__length1 = 0;
		AIProfile* _tmp66_ = NULL;
		guint _tmp67_ = 0U;
		guint _tmp68_ = 0U;
		gchar** _tmp69_ = NULL;
		gint _tmp69__length1 = 0;
		ChessEngineCECP* _tmp70_ = NULL;
		_tmp61_ = uci_go_options;
		_tmp61__length1 = uci_go_options_length1;
		g_warn_if_fail (_tmp61__length1 == 0);
		_tmp62_ = profile;
		_tmp63_ = ai_profile_get_binary (_tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = args;
		_tmp65__length1 = args_length1;
		_tmp66_ = profile;
		_tmp67_ = ai_profile_get_delay_seconds (_tmp66_);
		_tmp68_ = _tmp67_;
		_tmp69_ = options;
		_tmp69__length1 = options_length1;
		_tmp70_ = chess_engine_cecp_new (_tmp64_, _tmp65_, _tmp65__length1, _tmp68_, _tmp69_, _tmp69__length1);
		_g_object_unref0 (engine);
		engine = (ChessEngine*) _tmp70_;
	} else {
		AIProfile* _tmp71_ = NULL;
		const gchar* _tmp72_ = NULL;
		const gchar* _tmp73_ = NULL;
		_tmp71_ = profile;
		_tmp72_ = ai_profile_get_protocol (_tmp71_);
		_tmp73_ = _tmp72_;
		if (g_strcmp0 (_tmp73_, "uci") == 0) {
			AIProfile* _tmp74_ = NULL;
			const gchar* _tmp75_ = NULL;
			const gchar* _tmp76_ = NULL;
			gchar** _tmp77_ = NULL;
			gint _tmp77__length1 = 0;
			AIProfile* _tmp78_ = NULL;
			guint _tmp79_ = 0U;
			guint _tmp80_ = 0U;
			gchar** _tmp81_ = NULL;
			gint _tmp81__length1 = 0;
			gchar** _tmp82_ = NULL;
			gint _tmp82__length1 = 0;
			ChessEngineUCI* _tmp83_ = NULL;
			_tmp74_ = profile;
			_tmp75_ = ai_profile_get_binary (_tmp74_);
			_tmp76_ = _tmp75_;
			_tmp77_ = args;
			_tmp77__length1 = args_length1;
			_tmp78_ = profile;
			_tmp79_ = ai_profile_get_delay_seconds (_tmp78_);
			_tmp80_ = _tmp79_;
			_tmp81_ = options;
			_tmp81__length1 = options_length1;
			_tmp82_ = uci_go_options;
			_tmp82__length1 = uci_go_options_length1;
			_tmp83_ = chess_engine_uci_new (_tmp76_, _tmp77_, _tmp77__length1, _tmp80_, _tmp81_, _tmp81__length1, _tmp82_, _tmp82__length1);
			_g_object_unref0 (engine);
			engine = (ChessEngine*) _tmp83_;
		} else {
			AIProfile* _tmp84_ = NULL;
			const gchar* _tmp85_ = NULL;
			const gchar* _tmp86_ = NULL;
			_tmp84_ = profile;
			_tmp85_ = ai_profile_get_protocol (_tmp84_);
			_tmp86_ = _tmp85_;
			g_warning ("gnome-chess.vala:705: Unknown AI protocol %s", _tmp86_);
			result = NULL;
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
			options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (profile);
			_g_object_unref0 (engine);
			return result;
		}
	}
	result = engine;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (profile);
	return result;
}


static void chess_application_engine_ready_cb (ChessApplication* self, ChessEngine* engine) {
	ChessEngine* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->opponent_engine;
	_tmp1_ = chess_engine_get_ready (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ChessView* _tmp3_ = NULL;
		_tmp3_ = self->priv->view;
		gtk_widget_queue_draw ((GtkWidget*) _tmp3_);
	}
}


static void chess_application_do_engine_move (ChessApplication* self, const gchar* move) {
	ChessPlayer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (move != NULL);
	_tmp0_ = self->priv->opponent;
	_tmp1_ = move;
	_tmp2_ = chess_player_move (_tmp0_, _tmp1_, TRUE);
	if (!_tmp2_) {
		const gchar* _tmp3_ = NULL;
		ChessGame* _tmp4_ = NULL;
		_tmp3_ = move;
		g_warning ("gnome-chess.vala:724: Engine's move %s is illegal! Engine desync?", _tmp3_);
		_tmp4_ = self->priv->game;
		chess_game_stop (_tmp4_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ChessApplication* self;
		self = _data1_->self;
		_g_free0 (_data1_->move);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean ___lambda7_ (Block1Data* _data1_) {
	ChessApplication* self;
	gboolean result = FALSE;
	ChessGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	self = _data1_->self;
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		result = G_SOURCE_CONTINUE;
		return result;
	} else {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = _data1_->move;
		chess_application_do_engine_move (self, _tmp3_);
		result = G_SOURCE_REMOVE;
		return result;
	}
}


static gboolean ____lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda7_ (self);
	return result;
}


static void chess_application_engine_move_cb (ChessApplication* self, ChessEngine* engine, const gchar* move) {
	Block1Data* _data1_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	ChessGame* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	g_return_if_fail (move != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = move;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data1_->move);
	_data1_->move = _tmp1_;
	_tmp2_ = self->priv->game;
	_tmp3_ = chess_game_get_is_paused (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = _data1_->move;
		chess_application_do_engine_move (self, _tmp5_);
	} else {
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda7__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void chess_application_engine_resigned_cb (ChessApplication* self, ChessEngine* engine) {
	ChessPlayer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->opponent;
	chess_player_resign (_tmp0_);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ChessApplication* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->original_game);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean __lambda8_ (Block2Data* _data2_) {
	ChessApplication* self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_ = NULL;
	self = _data2_->self;
	_tmp1_ = self->priv->game;
	if (_tmp1_ == _data2_->original_game) {
		ChessGame* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->game;
		_tmp3_ = _tmp2_->is_started;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ChessGame* _tmp4_ = NULL;
		_tmp4_ = self->priv->game;
		chess_game_stop (_tmp4_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
	}
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ___lambda8__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda8_ (self);
	return result;
}


static void chess_application_engine_stopped_cb (ChessApplication* self, ChessEngine* engine) {
	Block2Data* _data2_;
	ChessGame* _tmp0_ = NULL;
	ChessGame* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = self->priv->game;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data2_->original_game = _tmp1_;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, ___lambda8__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void chess_application_engine_error_cb (ChessApplication* self, ChessEngine* engine) {
	ChessGame* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->game;
	chess_game_stop (_tmp0_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
}


static void chess_application_engine_claim_draw_cb (ChessApplication* self, ChessEngine* engine) {
	ChessGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_can_claim_draw (_tmp0_);
	if (!_tmp1_) {
		ChessGame* _tmp2_ = NULL;
		_tmp2_ = self->priv->game;
		chess_game_stop (_tmp2_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
	}
}


static void chess_application_engine_offer_draw_cb (ChessApplication* self, ChessEngine* engine) {
	ChessPlayer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->opponent;
	chess_player_claim_draw (_tmp0_);
}


static void chess_application_game_clock_tick_cb (ChessApplication* self, ChessClock* clock) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clock != NULL);
	_tmp0_ = self->priv->white_time_label;
	gtk_widget_queue_draw (_tmp0_);
	_tmp1_ = self->priv->black_time_label;
	gtk_widget_queue_draw (_tmp1_);
}


static void chess_application_game_turn_cb (ChessApplication* self, ChessGame* game, ChessPlayer* player) {
	ChessGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	ChessGame* _tmp2_ = NULL;
	ChessClock* _tmp3_ = NULL;
	ChessClock* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	ChessGame* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (player != NULL);
	_tmp0_ = game;
	_tmp1_ = _tmp0_->is_started;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = game;
	_tmp3_ = chess_game_get_clock (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		chess_application_enable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
	}
	_tmp6_ = game;
	_tmp7_ = chess_game_can_claim_draw (_tmp6_);
	if (_tmp7_) {
		gboolean _tmp8_ = FALSE;
		_tmp8_ = self->priv->allow_claim_draw_dialog;
		_tmp5_ = _tmp8_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		chess_application_present_claim_draw_dialog (self);
	}
}


static void chess_application_set_move_text (ChessApplication* self, GtkTreeIter* iter, ChessMove* move) {
	static const gchar* human_descriptions[] = {"White pawn moves from %1$s to %2$s", "White pawn at %1$s takes the black pawn at %2$s", "White pawn at %1$s takes the black rook at %2$s", "White pawn at %1$s takes the black knight at %2$s", "White pawn at %1$s takes the black bishop at %2$s", "White pawn at %1$s takes the black queen at %2$s", "White rook moves from %1$s to %2$s", "White rook at %1$s takes the black pawn at %2$s", "White rook at %1$s takes the black rook at %2$s", "White rook at %1$s takes the black knight at %2$s", "White rook at %1$s takes the black bishop at %2$s", "White rook at %1$s takes the black queen at %2$s", "White knight moves from %1$s to %2$s", "White knight at %1$s takes the black pawn at %2$s", "White knight at %1$s takes the black rook at %2$s", "White knight at %1$s takes the black knight at %2$s", "White knight at %1$s takes the black bishop at %2$s", "White knight at %1$s takes the black queen at %2$s", "White bishop moves from %1$s to %2$s", "White bishop at %1$s takes the black pawn at %2$s", "White bishop at %1$s takes the black rook at %2$s", "White bishop at %1$s takes the black knight at %2$s", "White bishop at %1$s takes the black bishop at %2$s", "White bishop at %1$s takes the black queen at %2$s", "White queen moves from %1$s to %2$s", "White queen at %1$s takes the black pawn at %2$s", "White queen at %1$s takes the black rook at %2$s", "White queen at %1$s takes the black knight at %2$s", "White queen at %1$s takes the black bishop at %2$s", "White queen at %1$s takes the black queen at %2$s", "White king moves from %1$s to %2$s", "White king at %1$s takes the black pawn at %2$s", "White king at %1$s takes the black rook at %2$s", "White king at %1$s takes the black knight at %2$s", "White king at %1$s takes the black bishop at %2$s", "White king at %1$s takes the black queen at %2$s", "Black pawn moves from %1$s to %2$s", "Black pawn at %1$s takes the white pawn at %2$s", "Black pawn at %1$s takes the white rook at %2$s", "Black pawn at %1$s takes the white knight at %2$s", "Black pawn at %1$s takes the white bishop at %2$s", "Black pawn at %1$s takes the white queen at %2$s", "Black rook moves from %1$s to %2$s", "Black rook at %1$s takes the white pawn at %2$s", "Black rook at %1$s takes the white rook at %2$s", "Black rook at %1$s takes the white knight at %2$s", "Black rook at %1$s takes the white bishop at %2$s", "Black rook at %1$s takes the white queen at %2$s", "Black knight moves from %1$s to %2$s", "Black knight at %1$s takes the white pawn at %2$s", "Black knight at %1$s takes the white rook at %2$s", "Black knight at %1$s takes the white knight at %2$s", "Black knight at %1$s takes the white bishop at %2$s", "Black knight at %1$s takes the white queen at %2$s", "Black bishop moves from %1$s to %2$s", "Black bishop at %1$s takes the white pawn at %2$s", "Black bishop at %1$s takes the white rook at %2$s", "Black bishop at %1$s takes the white knight at %2$s", "Black bishop at %1$s takes the white bishop at %2$s", "Black bishop at %1$s takes the white queen at %2$s", "Black queen moves from %1$s to %2$s", "Black queen at %1$s takes the white pawn at %2$s", "Black queen at %1$s takes the white rook at %2$s", "Black queen at %1$s takes the white knight at %2$s", "Black queen at %1$s takes the white bishop at %2$s", "Black queen at %1$s takes the white queen at %2$s", "Black king moves from %1$s to %2$s", "Black king at %1$s takes the white pawn at %2$s", "Black king at %1$s takes the white rook at %2$s", "Black king at %1$s takes the white knight at %2$s", "Black king at %1$s takes the white bishop at %2$s", "Black king at %1$s takes the white queen at %2$s"};
	gchar* move_text = NULL;
	gchar* _tmp0_ = NULL;
	ChessScene* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp81_ = NULL;
	GtkTreeModel* _tmp82_ = NULL;
	GtkTreeModel* _tmp83_ = NULL;
	GtkListStore* _tmp84_ = NULL;
	gchar _tmp85_ = '\0';
	ChessMove* _tmp86_ = NULL;
	gint _tmp87_ = 0;
	gchar* label = NULL;
	ChessMove* _tmp88_ = NULL;
	gint _tmp89_ = 0;
	const gchar* _tmp90_ = NULL;
	gchar* _tmp91_ = NULL;
	GtkListStore* _tmp92_ = NULL;
	GtkTreeIter _tmp93_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (move != NULL);
	_tmp0_ = g_strdup ("");
	move_text = _tmp0_;
	_tmp1_ = self->priv->scene;
	_tmp2_ = chess_scene_get_move_format (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("human")))) {
		switch (0) {
			default:
			{
				ChessMove* _tmp7_ = NULL;
				ChessPiece* _tmp8_ = NULL;
				_tmp7_ = move;
				_tmp8_ = _tmp7_->moved_rook;
				if (_tmp8_ == NULL) {
					gint index = 0;
					ChessMove* _tmp9_ = NULL;
					ChessPiece* _tmp10_ = NULL;
					gint _tmp14_ = 0;
					ChessMove* _tmp15_ = NULL;
					ChessPiece* _tmp16_ = NULL;
					PieceType _tmp17_ = 0;
					ChessMove* _tmp18_ = NULL;
					ChessPiece* _tmp19_ = NULL;
					ChessPlayer* _tmp20_ = NULL;
					Color _tmp21_ = 0;
					gchar* start = NULL;
					ChessMove* _tmp23_ = NULL;
					gint _tmp24_ = 0;
					ChessMove* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					gchar* _tmp27_ = NULL;
					gchar* end = NULL;
					ChessMove* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					ChessMove* _tmp30_ = NULL;
					gint _tmp31_ = 0;
					gchar* _tmp32_ = NULL;
					gint _tmp33_ = 0;
					const gchar* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					gchar* _tmp38_ = NULL;
					_tmp9_ = move;
					_tmp10_ = _tmp9_->victim;
					if (_tmp10_ == NULL) {
						index = 0;
					} else {
						ChessMove* _tmp11_ = NULL;
						ChessPiece* _tmp12_ = NULL;
						PieceType _tmp13_ = 0;
						_tmp11_ = move;
						_tmp12_ = _tmp11_->victim;
						_tmp13_ = _tmp12_->type;
						index = (gint) (_tmp13_ + 1);
					}
					_tmp14_ = index;
					_tmp15_ = move;
					_tmp16_ = _tmp15_->piece;
					_tmp17_ = _tmp16_->type;
					index = _tmp14_ + (_tmp17_ * 6);
					_tmp18_ = move;
					_tmp19_ = _tmp18_->piece;
					_tmp20_ = _tmp19_->player;
					_tmp21_ = _tmp20_->color;
					if (_tmp21_ == COLOR_BLACK) {
						gint _tmp22_ = 0;
						_tmp22_ = index;
						index = _tmp22_ + 36;
					}
					_tmp23_ = move;
					_tmp24_ = _tmp23_->f0;
					_tmp25_ = move;
					_tmp26_ = _tmp25_->r0;
					_tmp27_ = g_strdup_printf ("%c%d", 'a' + _tmp24_, _tmp26_ + 1);
					start = _tmp27_;
					_tmp28_ = move;
					_tmp29_ = _tmp28_->f1;
					_tmp30_ = move;
					_tmp31_ = _tmp30_->r1;
					_tmp32_ = g_strdup_printf ("%c%d", 'a' + _tmp29_, _tmp31_ + 1);
					end = _tmp32_;
					_tmp33_ = index;
					_tmp34_ = human_descriptions[_tmp33_];
					_tmp35_ = _ (_tmp34_);
					_tmp36_ = start;
					_tmp37_ = end;
					_tmp38_ = g_strdup_printf (_tmp35_, _tmp36_, _tmp37_);
					_g_free0 (move_text);
					move_text = _tmp38_;
					_g_free0 (end);
					_g_free0 (start);
				} else {
					gboolean _tmp39_ = FALSE;
					ChessMove* _tmp40_ = NULL;
					gint _tmp41_ = 0;
					ChessMove* _tmp42_ = NULL;
					gint _tmp43_ = 0;
					_tmp40_ = move;
					_tmp41_ = _tmp40_->f0;
					_tmp42_ = move;
					_tmp43_ = _tmp42_->f1;
					if (_tmp41_ < _tmp43_) {
						ChessMove* _tmp44_ = NULL;
						gint _tmp45_ = 0;
						_tmp44_ = move;
						_tmp45_ = _tmp44_->r0;
						_tmp39_ = _tmp45_ == 0;
					} else {
						_tmp39_ = FALSE;
					}
					if (_tmp39_) {
						const gchar* _tmp46_ = NULL;
						gchar* _tmp47_ = NULL;
						_tmp46_ = _ ("White castles kingside");
						_tmp47_ = g_strdup (_tmp46_);
						_g_free0 (move_text);
						move_text = _tmp47_;
					} else {
						gboolean _tmp48_ = FALSE;
						ChessMove* _tmp49_ = NULL;
						gint _tmp50_ = 0;
						ChessMove* _tmp51_ = NULL;
						gint _tmp52_ = 0;
						_tmp49_ = move;
						_tmp50_ = _tmp49_->f1;
						_tmp51_ = move;
						_tmp52_ = _tmp51_->f0;
						if (_tmp50_ < _tmp52_) {
							ChessMove* _tmp53_ = NULL;
							gint _tmp54_ = 0;
							_tmp53_ = move;
							_tmp54_ = _tmp53_->r0;
							_tmp48_ = _tmp54_ == 0;
						} else {
							_tmp48_ = FALSE;
						}
						if (_tmp48_) {
							const gchar* _tmp55_ = NULL;
							gchar* _tmp56_ = NULL;
							_tmp55_ = _ ("White castles queenside");
							_tmp56_ = g_strdup (_tmp55_);
							_g_free0 (move_text);
							move_text = _tmp56_;
						} else {
							gboolean _tmp57_ = FALSE;
							ChessMove* _tmp58_ = NULL;
							gint _tmp59_ = 0;
							ChessMove* _tmp60_ = NULL;
							gint _tmp61_ = 0;
							_tmp58_ = move;
							_tmp59_ = _tmp58_->f0;
							_tmp60_ = move;
							_tmp61_ = _tmp60_->f1;
							if (_tmp59_ < _tmp61_) {
								ChessMove* _tmp62_ = NULL;
								gint _tmp63_ = 0;
								_tmp62_ = move;
								_tmp63_ = _tmp62_->r0;
								_tmp57_ = _tmp63_ == 7;
							} else {
								_tmp57_ = FALSE;
							}
							if (_tmp57_) {
								const gchar* _tmp64_ = NULL;
								gchar* _tmp65_ = NULL;
								_tmp64_ = _ ("Black castles kingside");
								_tmp65_ = g_strdup (_tmp64_);
								_g_free0 (move_text);
								move_text = _tmp65_;
							} else {
								gboolean _tmp66_ = FALSE;
								ChessMove* _tmp67_ = NULL;
								gint _tmp68_ = 0;
								ChessMove* _tmp69_ = NULL;
								gint _tmp70_ = 0;
								_tmp67_ = move;
								_tmp68_ = _tmp67_->f1;
								_tmp69_ = move;
								_tmp70_ = _tmp69_->f0;
								if (_tmp68_ < _tmp70_) {
									ChessMove* _tmp71_ = NULL;
									gint _tmp72_ = 0;
									_tmp71_ = move;
									_tmp72_ = _tmp71_->r0;
									_tmp66_ = _tmp72_ == 7;
								} else {
									_tmp66_ = FALSE;
								}
								if (_tmp66_) {
									const gchar* _tmp73_ = NULL;
									gchar* _tmp74_ = NULL;
									_tmp73_ = _ ("Black castles queenside");
									_tmp74_ = g_strdup (_tmp73_);
									_g_free0 (move_text);
									move_text = _tmp74_;
								} else {
									g_assert_not_reached ();
								}
							}
						}
					}
				}
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("san")))) {
		switch (0) {
			default:
			{
				ChessMove* _tmp75_ = NULL;
				gchar* _tmp76_ = NULL;
				_tmp75_ = move;
				_tmp76_ = chess_move_get_san (_tmp75_);
				_g_free0 (move_text);
				move_text = _tmp76_;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("fan")))) {
		switch (0) {
			default:
			{
				ChessMove* _tmp77_ = NULL;
				gchar* _tmp78_ = NULL;
				_tmp77_ = move;
				_tmp78_ = chess_move_get_fan (_tmp77_);
				_g_free0 (move_text);
				move_text = _tmp78_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				ChessMove* _tmp79_ = NULL;
				gchar* _tmp80_ = NULL;
				_tmp79_ = move;
				_tmp80_ = chess_move_get_lan (_tmp79_);
				_g_free0 (move_text);
				move_text = _tmp80_;
				break;
			}
		}
	}
	_tmp81_ = self->priv->history_combo;
	_tmp82_ = gtk_combo_box_get_model (_tmp81_);
	_tmp83_ = _tmp82_;
	_tmp84_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp84_;
	_tmp86_ = move;
	_tmp87_ = _tmp86_->number;
	if ((_tmp87_ % 2) == 0) {
		_tmp85_ = 'b';
	} else {
		_tmp85_ = 'a';
	}
	_tmp88_ = move;
	_tmp89_ = _tmp88_->number;
	_tmp90_ = move_text;
	_tmp91_ = g_strdup_printf ("%u%c. %s", (guint) ((_tmp89_ + 1) / 2), (gint) _tmp85_, _tmp90_);
	label = _tmp91_;
	_tmp92_ = model;
	_tmp93_ = *iter;
	gtk_list_store_set (_tmp92_, &_tmp93_, 0, label, -1, -1);
	_g_free0 (label);
	_g_object_unref0 (model);
	_g_free0 (move_text);
}


static void chess_application_game_move_cb (ChessApplication* self, ChessGame* game, ChessMove* move) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessMove* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	ChessMove* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	PGNGame* _tmp9_ = NULL;
	GList* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	ChessScene* _tmp15_ = NULL;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp16_ = NULL;
	GtkTreeModel* _tmp17_ = NULL;
	GtkTreeModel* _tmp18_ = NULL;
	GtkListStore* _tmp19_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp20_ = NULL;
	GtkTreeIter _tmp21_ = {0};
	GtkListStore* _tmp22_ = NULL;
	GtkTreeIter _tmp23_ = {0};
	ChessMove* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GtkTreeIter _tmp26_ = {0};
	ChessMove* _tmp27_ = NULL;
	ChessMove* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	ChessGame* _tmp30_ = NULL;
	guint _tmp31_ = 0U;
	guint _tmp32_ = 0U;
	ChessView* _tmp35_ = NULL;
	ChessEngine* _tmp36_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (move != NULL);
	chess_application_enable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
	self->priv->game_needs_saving = TRUE;
	_tmp2_ = move;
	_tmp3_ = _tmp2_->number;
	if (_tmp3_ == 1) {
		ChessPlayer* _tmp4_ = NULL;
		_tmp4_ = self->priv->opponent;
		_tmp1_ = _tmp4_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ChessPlayer* _tmp5_ = NULL;
		Color _tmp6_ = 0;
		_tmp5_ = self->priv->opponent;
		_tmp6_ = _tmp5_->color;
		_tmp0_ = _tmp6_ == COLOR_WHITE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->game_needs_saving = FALSE;
	}
	_tmp7_ = move;
	_tmp8_ = _tmp7_->number;
	_tmp9_ = self->priv->pgn_game;
	_tmp10_ = _tmp9_->moves;
	_tmp11_ = g_list_length (_tmp10_);
	if (((guint) _tmp8_) > _tmp11_) {
		PGNGame* _tmp12_ = NULL;
		ChessMove* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp12_ = self->priv->pgn_game;
		_tmp13_ = move;
		_tmp14_ = chess_move_get_san (_tmp13_);
		_tmp12_->moves = g_list_append (_tmp12_->moves, _tmp14_);
	}
	_tmp15_ = self->priv->scene;
	chess_scene_set_move_number (_tmp15_, -1);
	_tmp16_ = self->priv->history_combo;
	_tmp17_ = gtk_combo_box_get_model (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp19_;
	_tmp20_ = model;
	gtk_list_store_append (_tmp20_, &_tmp21_);
	iter = _tmp21_;
	_tmp22_ = model;
	_tmp23_ = iter;
	_tmp24_ = move;
	_tmp25_ = _tmp24_->number;
	gtk_list_store_set (_tmp22_, &_tmp23_, 1, _tmp25_, -1, -1);
	_tmp26_ = iter;
	_tmp27_ = move;
	chess_application_set_move_text (self, &_tmp26_, _tmp27_);
	_tmp28_ = move;
	_tmp29_ = _tmp28_->number;
	_tmp30_ = game;
	_tmp31_ = chess_game_get_n_moves (_tmp30_);
	_tmp32_ = _tmp31_;
	if (((guint) _tmp29_) == _tmp32_) {
		GtkComboBox* _tmp33_ = NULL;
		GtkTreeIter _tmp34_ = {0};
		_tmp33_ = self->priv->history_combo;
		_tmp34_ = iter;
		gtk_combo_box_set_active_iter (_tmp33_, &_tmp34_);
	}
	chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
	chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
	chess_application_update_history_panel (self);
	chess_application_update_action_status (self);
	chess_application_update_headerbar_title (self);
	_tmp35_ = self->priv->view;
	gtk_widget_queue_draw ((GtkWidget*) _tmp35_);
	_tmp36_ = self->priv->opponent_engine;
	if (_tmp36_ != NULL) {
		ChessEngine* _tmp37_ = NULL;
		ChessMove* _tmp38_ = NULL;
		gboolean _tmp39_ = FALSE;
		ChessMove* _tmp40_ = NULL;
		ChessPiece* _tmp41_ = NULL;
		Color _tmp42_ = 0;
		Color _tmp43_ = 0;
		ChessPlayer* _tmp44_ = NULL;
		Color _tmp45_ = 0;
		_tmp37_ = self->priv->opponent_engine;
		_tmp38_ = move;
		chess_engine_report_move (_tmp37_, _tmp38_);
		_tmp40_ = move;
		_tmp41_ = _tmp40_->piece;
		_tmp42_ = chess_piece_get_color (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = self->priv->opponent;
		_tmp45_ = _tmp44_->color;
		if (_tmp43_ != _tmp45_) {
			gboolean _tmp46_ = FALSE;
			_tmp46_ = self->priv->starting;
			_tmp39_ = !_tmp46_;
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			ChessEngine* _tmp47_ = NULL;
			_tmp47_ = self->priv->opponent_engine;
			chess_engine_move (_tmp47_);
		}
	}
	_g_object_unref0 (model);
}


static void chess_application_game_undo_cb (ChessApplication* self, ChessGame* game) {
	ChessEngine* _tmp0_ = NULL;
	PGNGame* _tmp2_ = NULL;
	PGNGame* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkTreeModel* _tmp8_ = NULL;
	GtkListStore* _tmp9_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp10_ = NULL;
	GtkListStore* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GtkTreeIter _tmp13_ = {0};
	GtkListStore* _tmp14_ = NULL;
	GtkTreeIter _tmp15_ = {0};
	ChessScene* _tmp16_ = NULL;
	GtkListStore* _tmp17_ = NULL;
	GtkListStore* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	GtkTreeIter _tmp20_ = {0};
	GtkComboBox* _tmp21_ = NULL;
	GtkTreeIter _tmp22_ = {0};
	ChessView* _tmp23_ = NULL;
	ChessGame* _tmp24_ = NULL;
	guint _tmp25_ = 0U;
	guint _tmp26_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = self->priv->opponent_engine;
	if (_tmp0_ != NULL) {
		ChessEngine* _tmp1_ = NULL;
		_tmp1_ = self->priv->opponent_engine;
		chess_engine_undo (_tmp1_);
	}
	_tmp2_ = self->priv->pgn_game;
	_tmp3_ = self->priv->pgn_game;
	_tmp4_ = _tmp3_->moves;
	_tmp5_ = g_list_last (_tmp4_);
	_tmp2_->moves = g_list_remove_link (_tmp2_->moves, _tmp5_);
	_tmp6_ = self->priv->history_combo;
	_tmp7_ = gtk_combo_box_get_model (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp9_;
	_tmp10_ = model;
	_tmp11_ = model;
	_tmp12_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp11_, NULL);
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp10_, &_tmp13_, NULL, _tmp12_ - 1);
	iter = _tmp13_;
	_tmp14_ = model;
	_tmp15_ = iter;
	gtk_list_store_remove (_tmp14_, &_tmp15_);
	_tmp16_ = self->priv->scene;
	chess_scene_set_move_number (_tmp16_, -1);
	_tmp17_ = model;
	_tmp18_ = model;
	_tmp19_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp18_, NULL);
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp17_, &_tmp20_, NULL, _tmp19_ - 1);
	iter = _tmp20_;
	_tmp21_ = self->priv->history_combo;
	_tmp22_ = iter;
	gtk_combo_box_set_active_iter (_tmp21_, &_tmp22_);
	_tmp23_ = self->priv->view;
	gtk_widget_queue_draw ((GtkWidget*) _tmp23_);
	_tmp24_ = game;
	_tmp25_ = chess_game_get_n_moves (_tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ > ((guint) 0)) {
		self->priv->game_needs_saving = TRUE;
		chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
		chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
	} else {
		self->priv->game_needs_saving = FALSE;
		chess_application_disable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
	}
	chess_application_update_history_panel (self);
	chess_application_update_action_status (self);
	chess_application_update_headerbar_title (self);
	_g_object_unref0 (model);
}


static void chess_application_update_action_status (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gboolean can_resign = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	ChessGame* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	gboolean can_undo = FALSE;
	gboolean _tmp15_ = FALSE;
	ChessPlayer* _tmp16_ = NULL;
	gboolean _tmp26_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game;
	_tmp2_ = chess_game_get_n_moves (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > ((guint) 0)) {
		ChessGame* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = self->priv->game;
		_tmp5_ = chess_game_get_is_paused (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = !_tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	can_resign = _tmp0_;
	_tmp7_ = can_resign;
	if (_tmp7_) {
		chess_application_enable_window_action (self, CHESS_APPLICATION_RESIGN_ACTION_NAME);
	} else {
		chess_application_disable_window_action (self, CHESS_APPLICATION_RESIGN_ACTION_NAME);
	}
	_tmp9_ = self->priv->game;
	_tmp10_ = chess_game_get_n_moves (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ > ((guint) 0)) {
		ChessGame* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		_tmp12_ = self->priv->game;
		_tmp13_ = chess_game_get_is_paused (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp8_ = !_tmp14_;
	} else {
		_tmp8_ = FALSE;
	}
	can_undo = _tmp8_;
	_tmp16_ = self->priv->opponent;
	if (_tmp16_ != NULL) {
		ChessPlayer* _tmp17_ = NULL;
		Color _tmp18_ = 0;
		_tmp17_ = self->priv->opponent;
		_tmp18_ = _tmp17_->color;
		_tmp15_ = _tmp18_ == COLOR_WHITE;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		gboolean _tmp19_ = FALSE;
		ChessGame* _tmp20_ = NULL;
		guint _tmp21_ = 0U;
		guint _tmp22_ = 0U;
		_tmp20_ = self->priv->game;
		_tmp21_ = chess_game_get_n_moves (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_ > ((guint) 1)) {
			ChessGame* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			_tmp23_ = self->priv->game;
			_tmp24_ = chess_game_get_is_paused (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp19_ = !_tmp25_;
		} else {
			_tmp19_ = FALSE;
		}
		can_undo = _tmp19_;
	}
	_tmp26_ = can_undo;
	if (_tmp26_) {
		chess_application_enable_window_action (self, CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME);
	} else {
		chess_application_disable_window_action (self, CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME);
	}
}


static void chess_application_update_headerbar_title (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessPlayer* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->human_player;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ChessPlayer* _tmp3_ = NULL;
		Color _tmp4_ = 0;
		ChessGame* _tmp5_ = NULL;
		ChessPlayer* _tmp6_ = NULL;
		ChessPlayer* _tmp7_ = NULL;
		Color _tmp8_ = 0;
		_tmp3_ = self->priv->human_player;
		_tmp4_ = _tmp3_->color;
		_tmp5_ = self->priv->game;
		_tmp6_ = chess_game_get_current_player (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_->color;
		_tmp1_ = _tmp4_ == _tmp8_;
	}
	if (_tmp1_) {
		ChessGame* _tmp9_ = NULL;
		ChessState* _tmp10_ = NULL;
		ChessState* _tmp11_ = NULL;
		ChessGame* _tmp12_ = NULL;
		ChessPlayer* _tmp13_ = NULL;
		ChessPlayer* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp9_ = self->priv->game;
		_tmp10_ = chess_game_get_current_state (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = self->priv->game;
		_tmp13_ = chess_game_get_current_player (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = chess_state_is_in_check (_tmp11_, _tmp14_);
		_tmp0_ = _tmp15_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ChessGame* _tmp16_ = NULL;
		ChessPlayer* _tmp17_ = NULL;
		ChessPlayer* _tmp18_ = NULL;
		Color _tmp19_ = 0;
		_tmp16_ = self->priv->game;
		_tmp17_ = chess_game_get_current_player (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_->color;
		if (_tmp19_ == COLOR_WHITE) {
			GtkHeaderBar* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			_tmp20_ = self->priv->headerbar;
			_tmp21_ = _ ("White is in Check");
			gtk_header_bar_set_title (_tmp20_, _tmp21_);
		} else {
			GtkHeaderBar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			_tmp22_ = self->priv->headerbar;
			_tmp23_ = _ ("Black is in Check");
			gtk_header_bar_set_title (_tmp22_, _tmp23_);
		}
	} else {
		ChessGame* _tmp24_ = NULL;
		ChessPlayer* _tmp25_ = NULL;
		ChessPlayer* _tmp26_ = NULL;
		Color _tmp27_ = 0;
		_tmp24_ = self->priv->game;
		_tmp25_ = chess_game_get_current_player (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_->color;
		if (_tmp27_ == COLOR_WHITE) {
			gboolean _tmp28_ = FALSE;
			ChessPlayer* _tmp29_ = NULL;
			_tmp29_ = self->priv->human_player;
			if (_tmp29_ == NULL) {
				_tmp28_ = TRUE;
			} else {
				ChessPlayer* _tmp30_ = NULL;
				Color _tmp31_ = 0;
				_tmp30_ = self->priv->human_player;
				_tmp31_ = _tmp30_->color;
				_tmp28_ = _tmp31_ == COLOR_WHITE;
			}
			if (_tmp28_) {
				GtkHeaderBar* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				_tmp32_ = self->priv->headerbar;
				_tmp33_ = _ ("White to Move");
				gtk_header_bar_set_title (_tmp32_, _tmp33_);
			} else {
				GtkHeaderBar* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				_tmp34_ = self->priv->headerbar;
				_tmp35_ = _ ("White is Thinking…");
				gtk_header_bar_set_title (_tmp34_, _tmp35_);
			}
		} else {
			gboolean _tmp36_ = FALSE;
			ChessPlayer* _tmp37_ = NULL;
			_tmp37_ = self->priv->human_player;
			if (_tmp37_ == NULL) {
				_tmp36_ = TRUE;
			} else {
				ChessPlayer* _tmp38_ = NULL;
				Color _tmp39_ = 0;
				_tmp38_ = self->priv->human_player;
				_tmp39_ = _tmp38_->color;
				_tmp36_ = _tmp39_ == COLOR_BLACK;
			}
			if (_tmp36_) {
				GtkHeaderBar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				_tmp40_ = self->priv->headerbar;
				_tmp41_ = _ ("Black to Move");
				gtk_header_bar_set_title (_tmp40_, _tmp41_);
			} else {
				GtkHeaderBar* _tmp42_ = NULL;
				const gchar* _tmp43_ = NULL;
				_tmp42_ = self->priv->headerbar;
				_tmp43_ = _ ("Black is Thinking…");
				gtk_header_bar_set_title (_tmp42_, _tmp43_);
			}
		}
	}
}


static void chess_application_add_accelerators (ChessApplication* self) {
	gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gchar* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gchar** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("<Primary>N");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_NEW_GAME_ACTION_NAME, _tmp2_);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	_tmp3_ = g_strdup ("<Primary>O");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_OPEN_GAME_ACTION_NAME, _tmp5_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = g_strdup ("<Primary>S");
	_tmp7_ = g_new0 (gchar*, 1 + 1);
	_tmp7_[0] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_SAVE_GAME_ACTION_NAME, _tmp8_);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	_tmp9_ = g_strdup ("<Shift><Primary>S");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME, _tmp11_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = g_strdup ("<Primary>Z");
	_tmp13_ = g_new0 (gchar*, 1 + 1);
	_tmp13_[0] = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME, _tmp14_);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp15_ = g_strdup ("Pause");
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME, _tmp17_);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
}


static void chess_application_update_pause_resume_button (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_ = NULL;
	gboolean _tmp7_ = FALSE;
	ChessGame* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game;
	if (_tmp1_ != NULL) {
		ChessGame* _tmp2_ = NULL;
		ChessClock* _tmp3_ = NULL;
		ChessClock* _tmp4_ = NULL;
		_tmp2_ = self->priv->game;
		_tmp3_ = chess_game_get_clock (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkButton* _tmp5_ = NULL;
		_tmp5_ = self->priv->pause_resume_button;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
	} else {
		GtkButton* _tmp6_ = NULL;
		_tmp6_ = self->priv->pause_resume_button;
		gtk_widget_show ((GtkWidget*) _tmp6_);
	}
	_tmp8_ = self->priv->game;
	if (_tmp8_ != NULL) {
		ChessGame* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		_tmp9_ = self->priv->game;
		_tmp10_ = chess_game_get_is_paused (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp7_ = _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GtkButton* _tmp12_ = NULL;
		GtkImage* _tmp13_ = NULL;
		GtkImage* _tmp14_ = NULL;
		GtkButton* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		_tmp12_ = self->priv->pause_resume_button;
		_tmp13_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playback-start-symbolic", GTK_ICON_SIZE_BUTTON);
		g_object_ref_sink (_tmp13_);
		_tmp14_ = _tmp13_;
		gtk_button_set_image (_tmp12_, (GtkWidget*) _tmp14_);
		_g_object_unref0 (_tmp14_);
		_tmp15_ = self->priv->pause_resume_button;
		_tmp16_ = _ ("Unpause the game");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp15_, _tmp16_);
	} else {
		GtkButton* _tmp17_ = NULL;
		GtkImage* _tmp18_ = NULL;
		GtkImage* _tmp19_ = NULL;
		GtkButton* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		_tmp17_ = self->priv->pause_resume_button;
		_tmp18_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playback-pause-symbolic", GTK_ICON_SIZE_BUTTON);
		g_object_ref_sink (_tmp18_);
		_tmp19_ = _tmp18_;
		gtk_button_set_image (_tmp17_, (GtkWidget*) _tmp19_);
		_g_object_unref0 (_tmp19_);
		_tmp20_ = self->priv->pause_resume_button;
		_tmp21_ = _ ("Pause the game");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp20_, _tmp21_);
	}
}


static void chess_application_game_end_cb (ChessApplication* self, ChessGame* game) {
	ChessEngine* _tmp0_ = NULL;
	gchar* title = NULL;
	gchar* _tmp2_ = NULL;
	ChessGame* _tmp3_ = NULL;
	ChessResult _tmp4_ = 0;
	gchar* reason = NULL;
	gchar* _tmp19_ = NULL;
	ChessGame* _tmp20_ = NULL;
	ChessRule _tmp21_ = 0;
	GtkHeaderBar* _tmp66_ = NULL;
	const gchar* _tmp67_ = NULL;
	GtkHeaderBar* _tmp68_ = NULL;
	const gchar* _tmp69_ = NULL;
	GtkWidget* _tmp70_ = NULL;
	GtkWidget* _tmp71_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	chess_application_disable_window_action (self, CHESS_APPLICATION_RESIGN_ACTION_NAME);
	chess_application_disable_window_action (self, CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME);
	chess_application_disable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
	chess_application_enable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
	self->priv->game_needs_saving = FALSE;
	_tmp0_ = self->priv->opponent_engine;
	if (_tmp0_ != NULL) {
		ChessEngine* _tmp1_ = NULL;
		_tmp1_ = self->priv->opponent_engine;
		chess_engine_stop (_tmp1_);
	}
	_tmp2_ = g_strdup ("");
	title = _tmp2_;
	_tmp3_ = game;
	_tmp4_ = _tmp3_->result;
	switch (_tmp4_) {
		case CHESS_RESULT_WHITE_WON:
		{
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			PGNGame* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			_tmp5_ = _ ("White Wins");
			_tmp6_ = g_strdup (_tmp5_);
			_g_free0 (title);
			title = _tmp6_;
			_tmp7_ = self->priv->pgn_game;
			_tmp8_ = pgn_game_RESULT_WHITE;
			pgn_game_set_result (_tmp7_, _tmp8_);
			break;
		}
		case CHESS_RESULT_BLACK_WON:
		{
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			PGNGame* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			_tmp9_ = _ ("Black Wins");
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (title);
			title = _tmp10_;
			_tmp11_ = self->priv->pgn_game;
			_tmp12_ = pgn_game_RESULT_BLACK;
			pgn_game_set_result (_tmp11_, _tmp12_);
			break;
		}
		case CHESS_RESULT_DRAW:
		{
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			PGNGame* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			_tmp13_ = _ ("Game is Drawn");
			_tmp14_ = g_strdup (_tmp13_);
			_g_free0 (title);
			title = _tmp14_;
			_tmp15_ = self->priv->pgn_game;
			_tmp16_ = pgn_game_RESULT_DRAW;
			pgn_game_set_result (_tmp15_, _tmp16_);
			break;
		}
		case CHESS_RESULT_BUG:
		{
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			_tmp17_ = _ ("Oops! Something has gone wrong.");
			_tmp18_ = g_strdup (_tmp17_);
			_g_free0 (title);
			title = _tmp18_;
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp19_ = g_strdup ("");
	reason = _tmp19_;
	_tmp20_ = game;
	_tmp21_ = _tmp20_->rule;
	switch (_tmp21_) {
		case CHESS_RULE_CHECKMATE:
		{
			ChessGame* _tmp22_ = NULL;
			ChessResult _tmp23_ = 0;
			_tmp22_ = game;
			_tmp23_ = _tmp22_->result;
			if (_tmp23_ == CHESS_RESULT_WHITE_WON) {
				const gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				_tmp24_ = _ ("Black is in check and cannot move.");
				_tmp25_ = g_strdup (_tmp24_);
				_g_free0 (reason);
				reason = _tmp25_;
			} else {
				ChessGame* _tmp26_ = NULL;
				ChessResult _tmp27_ = 0;
				_tmp26_ = game;
				_tmp27_ = _tmp26_->result;
				if (_tmp27_ == CHESS_RESULT_BLACK_WON) {
					const gchar* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
					_tmp28_ = _ ("White is in check and cannot move.");
					_tmp29_ = g_strdup (_tmp28_);
					_g_free0 (reason);
					reason = _tmp29_;
				} else {
					g_assert_not_reached ();
				}
			}
			break;
		}
		case CHESS_RULE_STALEMATE:
		{
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			_tmp30_ = _ ("Opponent cannot move.");
			_tmp31_ = g_strdup (_tmp30_);
			_g_free0 (reason);
			reason = _tmp31_;
			break;
		}
		case CHESS_RULE_FIFTY_MOVES:
		{
			const gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			_tmp32_ = _ ("No piece was taken or pawn moved in fifty moves.");
			_tmp33_ = g_strdup (_tmp32_);
			_g_free0 (reason);
			reason = _tmp33_;
			break;
		}
		case CHESS_RULE_TIMEOUT:
		{
			ChessGame* _tmp34_ = NULL;
			ChessResult _tmp35_ = 0;
			_tmp34_ = game;
			_tmp35_ = _tmp34_->result;
			if (_tmp35_ == CHESS_RESULT_WHITE_WON) {
				const gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				_tmp36_ = _ ("Black has run out of time.");
				_tmp37_ = g_strdup (_tmp36_);
				_g_free0 (reason);
				reason = _tmp37_;
			} else {
				ChessGame* _tmp38_ = NULL;
				ChessResult _tmp39_ = 0;
				_tmp38_ = game;
				_tmp39_ = _tmp38_->result;
				if (_tmp39_ == CHESS_RESULT_BLACK_WON) {
					const gchar* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
					_tmp40_ = _ ("White has run out of time.");
					_tmp41_ = g_strdup (_tmp40_);
					_g_free0 (reason);
					reason = _tmp41_;
				} else {
					g_assert_not_reached ();
				}
			}
			break;
		}
		case CHESS_RULE_THREE_FOLD_REPETITION:
		{
			const gchar* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
			_tmp42_ = _ ("The same board state has occurred three times.");
			_tmp43_ = g_strdup (_tmp42_);
			_g_free0 (reason);
			reason = _tmp43_;
			break;
		}
		case CHESS_RULE_INSUFFICIENT_MATERIAL:
		{
			const gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
			_tmp44_ = _ ("Neither player can checkmate.");
			_tmp45_ = g_strdup (_tmp44_);
			_g_free0 (reason);
			reason = _tmp45_;
			break;
		}
		case CHESS_RULE_RESIGN:
		{
			ChessGame* _tmp46_ = NULL;
			ChessResult _tmp47_ = 0;
			_tmp46_ = game;
			_tmp47_ = _tmp46_->result;
			if (_tmp47_ == CHESS_RESULT_WHITE_WON) {
				const gchar* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
				_tmp48_ = _ ("Black has resigned.");
				_tmp49_ = g_strdup (_tmp48_);
				_g_free0 (reason);
				reason = _tmp49_;
			} else {
				ChessGame* _tmp50_ = NULL;
				ChessResult _tmp51_ = 0;
				_tmp50_ = game;
				_tmp51_ = _tmp50_->result;
				if (_tmp51_ == CHESS_RESULT_BLACK_WON) {
					const gchar* _tmp52_ = NULL;
					gchar* _tmp53_ = NULL;
					_tmp52_ = _ ("White has resigned.");
					_tmp53_ = g_strdup (_tmp52_);
					_g_free0 (reason);
					reason = _tmp53_;
				} else {
					g_assert_not_reached ();
				}
			}
			break;
		}
		case CHESS_RULE_ABANDONMENT:
		{
			const gchar* _tmp54_ = NULL;
			gchar* _tmp55_ = NULL;
			PGNGame* _tmp56_ = NULL;
			const gchar* _tmp57_ = NULL;
			_tmp54_ = _ ("The game has been abandoned.");
			_tmp55_ = g_strdup (_tmp54_);
			_g_free0 (reason);
			reason = _tmp55_;
			_tmp56_ = self->priv->pgn_game;
			_tmp57_ = pgn_game_TERMINATE_ABANDONED;
			pgn_game_set_termination (_tmp56_, _tmp57_);
			break;
		}
		case CHESS_RULE_DEATH:
		{
			const gchar* _tmp58_ = NULL;
			gchar* _tmp59_ = NULL;
			PGNGame* _tmp60_ = NULL;
			const gchar* _tmp61_ = NULL;
			_tmp58_ = _ ("The game log says a player died!");
			_tmp59_ = g_strdup (_tmp58_);
			_g_free0 (reason);
			reason = _tmp59_;
			_tmp60_ = self->priv->pgn_game;
			_tmp61_ = pgn_game_TERMINATE_DEATH;
			pgn_game_set_termination (_tmp60_, _tmp61_);
			break;
		}
		case CHESS_RULE_BUG:
		{
			const gchar* _tmp62_ = NULL;
			gchar* _tmp63_ = NULL;
			_tmp62_ = _ ("The computer player is confused. The game cannot continue.");
			_tmp63_ = g_strdup (_tmp62_);
			_g_free0 (reason);
			reason = _tmp63_;
			break;
		}
		case CHESS_RULE_UNKNOWN:
		{
			GFile* _tmp64_ = NULL;
			gchar* _tmp65_ = NULL;
			_tmp64_ = self->priv->game_file;
			_tmp65_ = g_file_get_basename (_tmp64_);
			_g_free0 (reason);
			reason = _tmp65_;
			break;
		}
		default:
		break;
	}
	_tmp66_ = self->priv->headerbar;
	_tmp67_ = title;
	gtk_header_bar_set_title (_tmp66_, _tmp67_);
	_tmp68_ = self->priv->headerbar;
	_tmp69_ = reason;
	gtk_header_bar_set_subtitle (_tmp68_, _tmp69_);
	_tmp70_ = self->priv->white_time_label;
	gtk_widget_queue_draw (_tmp70_);
	_tmp71_ = self->priv->black_time_label;
	gtk_widget_queue_draw (_tmp71_);
	_g_free0 (reason);
	_g_free0 (title);
}


void chess_application_show (ChessApplication* self) {
	GtkApplicationWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}


gboolean G_MODULE_EXPORT gnome_chess_app_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	chess_application_quit_game (self);
	result = FALSE;
	return result;
}


gboolean G_MODULE_EXPORT gnome_chess_app_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, ChessApplication* self) {
	gboolean result = FALSE;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "maximized");
	if (!_tmp1_) {
		GSettings* _tmp2_ = NULL;
		GdkEventConfigure* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		GSettings* _tmp5_ = NULL;
		GdkEventConfigure* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		_tmp2_ = self->priv->settings;
		_tmp3_ = event;
		_tmp4_ = _tmp3_->width;
		g_settings_set_int (_tmp2_, "width", _tmp4_);
		_tmp5_ = self->priv->settings;
		_tmp6_ = event;
		_tmp7_ = _tmp6_->height;
		g_settings_set_int (_tmp5_, "height", _tmp7_);
	}
	result = FALSE;
	return result;
}


gboolean G_MODULE_EXPORT gnome_chess_app_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, ChessApplication* self) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		gboolean is_maximized = FALSE;
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
		GSettings* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->new_window_state;
		is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
		_tmp4_ = self->priv->settings;
		_tmp5_ = is_maximized;
		g_settings_set_boolean (_tmp4_, "maximized", _tmp5_);
	}
	result = FALSE;
	return result;
}


static gboolean chess_application_prompt_save_game (ChessApplication* self, const gchar* prompt_text) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GtkMessageDialog* dialog = NULL;
	GtkApplicationWindow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkMessageDialog* _tmp3_ = NULL;
	GtkMessageDialog* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	ChessGame* _tmp6_ = NULL;
	ChessResult _tmp7_ = 0;
	gint _result_ = 0;
	GtkMessageDialog* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	GtkMessageDialog* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gint _tmp20_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (prompt_text != NULL, FALSE);
	_tmp0_ = self->priv->game_needs_saving;
	if (!_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->window;
	_tmp2_ = prompt_text;
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp1_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp2_);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	_tmp4_ = dialog;
	_tmp5_ = _ ("_Cancel");
	gtk_dialog_add_button ((GtkDialog*) _tmp4_, _tmp5_, (gint) GTK_RESPONSE_CANCEL);
	_tmp6_ = self->priv->game;
	_tmp7_ = _tmp6_->result;
	if (_tmp7_ == CHESS_RESULT_IN_PROGRESS) {
		GtkMessageDialog* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GtkMessageDialog* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_tmp8_ = dialog;
		_tmp9_ = _ ("_Abandon game");
		gtk_dialog_add_button ((GtkDialog*) _tmp8_, _tmp9_, (gint) GTK_RESPONSE_NO);
		_tmp10_ = dialog;
		_tmp11_ = _ ("_Save game for later");
		gtk_dialog_add_button ((GtkDialog*) _tmp10_, _tmp11_, (gint) GTK_RESPONSE_YES);
	} else {
		GtkMessageDialog* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GtkMessageDialog* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		_tmp12_ = dialog;
		_tmp13_ = _ ("_Discard game");
		gtk_dialog_add_button ((GtkDialog*) _tmp12_, _tmp13_, (gint) GTK_RESPONSE_NO);
		_tmp14_ = dialog;
		_tmp15_ = _ ("_Save game log");
		gtk_dialog_add_button ((GtkDialog*) _tmp14_, _tmp15_, (gint) GTK_RESPONSE_YES);
	}
	_tmp16_ = dialog;
	_tmp17_ = gtk_dialog_run ((GtkDialog*) _tmp16_);
	_result_ = _tmp17_;
	_tmp18_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp18_);
	_tmp20_ = _result_;
	if (_tmp20_ == ((gint) GTK_RESPONSE_CANCEL)) {
		_tmp19_ = TRUE;
	} else {
		gint _tmp21_ = 0;
		_tmp21_ = _result_;
		_tmp19_ = _tmp21_ == ((gint) GTK_RESPONSE_DELETE_EVENT);
	}
	if (_tmp19_) {
		result = FALSE;
		_g_object_unref0 (dialog);
		return result;
	} else {
		gint _tmp22_ = 0;
		_tmp22_ = _result_;
		if (_tmp22_ == ((gint) GTK_RESPONSE_YES)) {
			const gchar* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			_tmp23_ = _ ("_Discard");
			_tmp24_ = _ ("_Save");
			chess_application_present_save_dialog (self, _tmp23_, _tmp24_);
		} else {
			gint _tmp25_ = 0;
			_tmp25_ = _result_;
			g_warn_if_fail (_tmp25_ == ((gint) GTK_RESPONSE_NO));
			self->priv->game_needs_saving = FALSE;
			chess_application_autosave (self);
		}
	}
	result = TRUE;
	_g_object_unref0 (dialog);
	return result;
}


static void chess_application_present_claim_draw_dialog (ChessApplication* self) {
	ChessGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	ChessGame* _tmp2_ = NULL;
	GtkMessageDialog* dialog = NULL;
	GtkApplicationWindow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkMessageDialog* _tmp5_ = NULL;
	gchar* reason = NULL;
	ChessGame* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GtkMessageDialog* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkMessageDialog* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gint response = 0;
	GtkMessageDialog* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	GtkMessageDialog* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_can_claim_draw (_tmp0_);
	_vala_return_if_fail (_tmp1_, "game.can_claim_draw ()");
	_tmp2_ = self->priv->game;
	chess_game_pause (_tmp2_, FALSE);
	_tmp3_ = self->priv->window;
	_tmp4_ = _ ("Would you like to claim a draw?");
	_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp3_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp4_);
	g_object_ref_sink (_tmp5_);
	dialog = _tmp5_;
	_tmp6_ = self->priv->game;
	_tmp7_ = chess_game_is_fifty_move_rule_fulfilled (_tmp6_);
	if (_tmp7_) {
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp8_ = _ ("Fifty moves have passed without a capture or pawn advancement.");
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (reason);
		reason = _tmp9_;
	} else {
		ChessGame* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		_tmp10_ = self->priv->game;
		_tmp11_ = chess_game_is_three_fold_repeat (_tmp10_);
		if (_tmp11_) {
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			_tmp12_ = _ ("The current board position has occurred three times.");
			_tmp13_ = g_strdup (_tmp12_);
			_g_free0 (reason);
			reason = _tmp13_;
		} else {
			g_assert_not_reached ();
		}
	}
	_tmp14_ = dialog;
	_tmp15_ = reason;
	_tmp16_ = _ ("(You will not be offered this choice again.)");
	gtk_message_dialog_format_secondary_text (_tmp14_, "%s\n%s", _tmp15_, _tmp16_);
	_tmp17_ = dialog;
	_tmp18_ = _ ("_Keep Playing");
	_tmp19_ = _ ("_Claim Draw");
	gtk_dialog_add_buttons ((GtkDialog*) _tmp17_, _tmp18_, GTK_RESPONSE_REJECT, _tmp19_, GTK_RESPONSE_ACCEPT, NULL, NULL);
	_tmp20_ = dialog;
	_tmp21_ = gtk_dialog_run ((GtkDialog*) _tmp20_);
	response = _tmp21_;
	_tmp22_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp22_);
	_tmp23_ = response;
	if (_tmp23_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		ChessGame* _tmp24_ = NULL;
		ChessPlayer* _tmp25_ = NULL;
		ChessPlayer* _tmp26_ = NULL;
		_tmp24_ = self->priv->game;
		_tmp25_ = chess_game_get_current_player (_tmp24_);
		_tmp26_ = _tmp25_;
		chess_player_claim_draw (_tmp26_);
	} else {
		ChessGame* _tmp27_ = NULL;
		self->priv->allow_claim_draw_dialog = FALSE;
		_tmp27_ = self->priv->game;
		chess_game_unpause (_tmp27_);
	}
	_g_free0 (reason);
	_g_object_unref0 (dialog);
}


void chess_application_new_game_cb (ChessApplication* self) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Save this game before starting a new one?");
	_tmp1_ = chess_application_prompt_save_game (self, _tmp0_);
	if (_tmp1_) {
		chess_application_start_new_game (self);
	}
}


void chess_application_resign_cb (ChessApplication* self) {
	ChessGame* _tmp0_ = NULL;
	GtkMessageDialog* dialog = NULL;
	GtkApplicationWindow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkMessageDialog* _tmp3_ = NULL;
	GtkMessageDialog* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkMessageDialog* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gint response = 0;
	GtkMessageDialog* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GtkMessageDialog* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	chess_game_pause (_tmp0_, FALSE);
	_tmp1_ = self->priv->window;
	_tmp2_ = _ ("Are you sure you want to resign?");
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp1_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp2_);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	_tmp4_ = dialog;
	_tmp5_ = _ ("This makes sense if you plan to save the game as a record of your loss" \
".");
	gtk_message_dialog_format_secondary_text (_tmp4_, "%s", _tmp5_);
	_tmp6_ = dialog;
	_tmp7_ = _ ("_Keep Playing");
	_tmp8_ = _ ("_Resign");
	gtk_dialog_add_buttons ((GtkDialog*) _tmp6_, _tmp7_, GTK_RESPONSE_REJECT, _tmp8_, GTK_RESPONSE_ACCEPT, NULL, NULL);
	_tmp9_ = dialog;
	_tmp10_ = gtk_dialog_run ((GtkDialog*) _tmp9_);
	response = _tmp10_;
	_tmp11_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp11_);
	_tmp12_ = response;
	if (_tmp12_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		ChessPlayer* _tmp13_ = NULL;
		_tmp13_ = self->priv->human_player;
		if (_tmp13_ != NULL) {
			ChessPlayer* _tmp14_ = NULL;
			_tmp14_ = self->priv->human_player;
			chess_player_resign (_tmp14_);
		} else {
			ChessGame* _tmp15_ = NULL;
			ChessPlayer* _tmp16_ = NULL;
			ChessPlayer* _tmp17_ = NULL;
			_tmp15_ = self->priv->game;
			_tmp16_ = chess_game_get_current_player (_tmp15_);
			_tmp17_ = _tmp16_;
			chess_player_resign (_tmp17_);
		}
	} else {
		ChessGame* _tmp18_ = NULL;
		_tmp18_ = self->priv->game;
		chess_game_unpause (_tmp18_);
	}
	_g_object_unref0 (dialog);
}


void chess_application_undo_move_cb (ChessApplication* self) {
	ChessScene* _tmp0_ = NULL;
	ChessScene* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scene;
	_tmp0_->selected_rank = -1;
	_tmp1_ = self->priv->scene;
	_tmp1_->selected_file = -1;
	_tmp2_ = self->priv->opponent;
	if (_tmp2_ != NULL) {
		ChessPlayer* _tmp3_ = NULL;
		_tmp3_ = self->priv->human_player;
		chess_player_undo (_tmp3_);
	} else {
		ChessGame* _tmp4_ = NULL;
		ChessPlayer* _tmp5_ = NULL;
		ChessPlayer* _tmp6_ = NULL;
		_tmp4_ = self->priv->game;
		_tmp5_ = chess_game_get_opponent (_tmp4_);
		_tmp6_ = _tmp5_;
		chess_player_undo (_tmp6_);
	}
}


void chess_application_pause_resume_cb (ChessApplication* self) {
	ChessGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ChessGame* _tmp3_ = NULL;
		_tmp3_ = self->priv->game;
		chess_game_unpause (_tmp3_);
	} else {
		ChessGame* _tmp4_ = NULL;
		_tmp4_ = self->priv->game;
		chess_game_pause (_tmp4_, TRUE);
	}
	chess_application_update_pause_resume_button (self);
	chess_application_update_history_panel (self);
	chess_application_update_action_status (self);
}


void chess_application_quit_cb (ChessApplication* self) {
	g_return_if_fail (self != NULL);
	chess_application_quit_game (self);
}


gboolean G_MODULE_EXPORT white_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self) {
	gboolean result = FALSE;
	gdouble fg[3] = {0};
	gdouble _tmp0_[3] = {0};
	gdouble bg[3] = {0};
	gdouble _tmp1_[3] = {0};
	GtkWidget* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	ChessGame* _tmp4_ = NULL;
	ChessClock* _tmp5_ = NULL;
	ChessClock* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_[0] = 0.0;
	_tmp0_[1] = 0.0;
	_tmp0_[2] = 0.0;
	memcpy (fg, _tmp0_, 3 * sizeof (gdouble));
	_tmp1_[0] = 1.0;
	_tmp1_[1] = 1.0;
	_tmp1_[2] = 1.0;
	memcpy (bg, _tmp1_, 3 * sizeof (gdouble));
	_tmp2_ = widget;
	_tmp3_ = c;
	_tmp4_ = self->priv->game;
	_tmp5_ = chess_game_get_clock (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = chess_application_make_clock_text (self, _tmp6_, COLOR_WHITE);
	_tmp8_ = _tmp7_;
	chess_application_draw_time (self, _tmp2_, _tmp3_, _tmp8_, fg, 3, bg, 3);
	_g_free0 (_tmp8_);
	result = FALSE;
	return result;
}


gboolean G_MODULE_EXPORT black_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self) {
	gboolean result = FALSE;
	gdouble fg[3] = {0};
	gdouble _tmp0_[3] = {0};
	gdouble bg[3] = {0};
	gdouble _tmp1_[3] = {0};
	GtkWidget* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	ChessGame* _tmp4_ = NULL;
	ChessClock* _tmp5_ = NULL;
	ChessClock* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_[0] = 1.0;
	_tmp0_[1] = 1.0;
	_tmp0_[2] = 1.0;
	memcpy (fg, _tmp0_, 3 * sizeof (gdouble));
	_tmp1_[0] = 0.0;
	_tmp1_[1] = 0.0;
	_tmp1_[2] = 0.0;
	memcpy (bg, _tmp1_, 3 * sizeof (gdouble));
	_tmp2_ = widget;
	_tmp3_ = c;
	_tmp4_ = self->priv->game;
	_tmp5_ = chess_game_get_clock (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = chess_application_make_clock_text (self, _tmp6_, COLOR_BLACK);
	_tmp8_ = _tmp7_;
	chess_application_draw_time (self, _tmp2_, _tmp3_, _tmp8_, fg, 3, bg, 3);
	_g_free0 (_tmp8_);
	result = FALSE;
	return result;
}


static gchar* chess_application_make_clock_text (ChessApplication* self, ChessClock* clock, Color color) {
	gchar* result = NULL;
	ChessClock* _tmp0_ = NULL;
	gint time = 0;
	Color _tmp2_ = 0;
	gint _tmp33_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clock;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("∞");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = color;
	if (_tmp2_ == COLOR_WHITE) {
		ChessGame* _tmp3_ = NULL;
		ChessClock* _tmp4_ = NULL;
		ChessClock* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		ChessGame* _tmp8_ = NULL;
		ChessClock* _tmp9_ = NULL;
		ChessClock* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		ChessGame* _tmp13_ = NULL;
		ChessClock* _tmp14_ = NULL;
		ChessClock* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		_tmp3_ = self->priv->game;
		_tmp4_ = chess_game_get_clock (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = chess_clock_get_white_initial_seconds (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->game;
		_tmp9_ = chess_game_get_clock (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = chess_clock_get_white_seconds_used (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = self->priv->game;
		_tmp14_ = chess_game_get_clock (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = chess_clock_get_white_extra_seconds (_tmp15_);
		_tmp17_ = _tmp16_;
		time = (_tmp7_ - _tmp12_) + _tmp17_;
	} else {
		ChessGame* _tmp18_ = NULL;
		ChessClock* _tmp19_ = NULL;
		ChessClock* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		ChessGame* _tmp23_ = NULL;
		ChessClock* _tmp24_ = NULL;
		ChessClock* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		ChessGame* _tmp28_ = NULL;
		ChessClock* _tmp29_ = NULL;
		ChessClock* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		_tmp18_ = self->priv->game;
		_tmp19_ = chess_game_get_clock (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = chess_clock_get_black_initial_seconds (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = self->priv->game;
		_tmp24_ = chess_game_get_clock (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = chess_clock_get_black_seconds_used (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = self->priv->game;
		_tmp29_ = chess_game_get_clock (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = chess_clock_get_black_extra_seconds (_tmp30_);
		_tmp32_ = _tmp31_;
		time = (_tmp22_ - _tmp27_) + _tmp32_;
	}
	_tmp33_ = time;
	if (_tmp33_ >= 60) {
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		gchar* _tmp36_ = NULL;
		_tmp34_ = time;
		_tmp35_ = time;
		_tmp36_ = g_strdup_printf ("%d∶\xE2\x80\x8E%02d", _tmp34_ / 60, _tmp35_ % 60);
		result = _tmp36_;
		return result;
	} else {
		gint _tmp37_ = 0;
		gchar* _tmp38_ = NULL;
		_tmp37_ = time;
		_tmp38_ = g_strdup_printf ("∶\xE2\x80\x8E%02d", _tmp37_);
		result = _tmp38_;
		return result;
	}
}


static gint chess_application_compute_time_label_width_request (ChessApplication* self, cairo_t* c) {
	gint result = 0;
	cairo_text_extents_t extents = {0};
	gdouble max = 0.0;
	cairo_t* _tmp0_ = NULL;
	cairo_text_extents_t _tmp1_ = {0};
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	cairo_text_extents_t _tmp4_ = {0};
	gdouble _tmp5_ = 0.0;
	cairo_t* _tmp9_ = NULL;
	cairo_text_extents_t _tmp10_ = {0};
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	cairo_text_extents_t _tmp13_ = {0};
	gdouble _tmp14_ = 0.0;
	cairo_t* _tmp18_ = NULL;
	cairo_text_extents_t _tmp19_ = {0};
	gdouble _tmp20_ = 0.0;
	gdouble _tmp21_ = 0.0;
	cairo_text_extents_t _tmp22_ = {0};
	gdouble _tmp23_ = 0.0;
	cairo_t* _tmp27_ = NULL;
	cairo_text_extents_t _tmp28_ = {0};
	gdouble _tmp29_ = 0.0;
	gdouble _tmp30_ = 0.0;
	cairo_text_extents_t _tmp31_ = {0};
	gdouble _tmp32_ = 0.0;
	cairo_t* _tmp36_ = NULL;
	cairo_text_extents_t _tmp37_ = {0};
	gdouble _tmp38_ = 0.0;
	gdouble _tmp39_ = 0.0;
	cairo_text_extents_t _tmp40_ = {0};
	gdouble _tmp41_ = 0.0;
	cairo_t* _tmp45_ = NULL;
	cairo_text_extents_t _tmp46_ = {0};
	gdouble _tmp47_ = 0.0;
	gdouble _tmp48_ = 0.0;
	cairo_text_extents_t _tmp49_ = {0};
	gdouble _tmp50_ = 0.0;
	cairo_t* _tmp54_ = NULL;
	cairo_text_extents_t _tmp55_ = {0};
	gdouble _tmp56_ = 0.0;
	gdouble _tmp57_ = 0.0;
	cairo_text_extents_t _tmp58_ = {0};
	gdouble _tmp59_ = 0.0;
	cairo_t* _tmp63_ = NULL;
	cairo_text_extents_t _tmp64_ = {0};
	gdouble _tmp65_ = 0.0;
	gdouble _tmp66_ = 0.0;
	cairo_text_extents_t _tmp67_ = {0};
	gdouble _tmp68_ = 0.0;
	cairo_t* _tmp72_ = NULL;
	cairo_text_extents_t _tmp73_ = {0};
	gdouble _tmp74_ = 0.0;
	gdouble _tmp75_ = 0.0;
	cairo_text_extents_t _tmp76_ = {0};
	gdouble _tmp77_ = 0.0;
	cairo_t* _tmp81_ = NULL;
	cairo_text_extents_t _tmp82_ = {0};
	gdouble _tmp83_ = 0.0;
	gdouble _tmp84_ = 0.0;
	cairo_text_extents_t _tmp85_ = {0};
	gdouble _tmp86_ = 0.0;
	gdouble _tmp90_ = 0.0;
	gdouble _tmp91_ = 0.0;
	gint _tmp92_ = 0;
	gint _tmp93_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (c != NULL, 0);
	max = (gdouble) 0;
	_tmp0_ = c;
	cairo_text_extents (_tmp0_, "000∶00", &_tmp1_);
	extents = _tmp1_;
	_tmp3_ = max;
	_tmp4_ = extents;
	_tmp5_ = _tmp4_.width;
	if (_tmp3_ > _tmp5_) {
		gdouble _tmp6_ = 0.0;
		_tmp6_ = max;
		_tmp2_ = _tmp6_;
	} else {
		cairo_text_extents_t _tmp7_ = {0};
		gdouble _tmp8_ = 0.0;
		_tmp7_ = extents;
		_tmp8_ = _tmp7_.width;
		_tmp2_ = _tmp8_;
	}
	max = _tmp2_;
	_tmp9_ = c;
	cairo_text_extents (_tmp9_, "111∶11", &_tmp10_);
	extents = _tmp10_;
	_tmp12_ = max;
	_tmp13_ = extents;
	_tmp14_ = _tmp13_.width;
	if (_tmp12_ > _tmp14_) {
		gdouble _tmp15_ = 0.0;
		_tmp15_ = max;
		_tmp11_ = _tmp15_;
	} else {
		cairo_text_extents_t _tmp16_ = {0};
		gdouble _tmp17_ = 0.0;
		_tmp16_ = extents;
		_tmp17_ = _tmp16_.width;
		_tmp11_ = _tmp17_;
	}
	max = _tmp11_;
	_tmp18_ = c;
	cairo_text_extents (_tmp18_, "222∶22", &_tmp19_);
	extents = _tmp19_;
	_tmp21_ = max;
	_tmp22_ = extents;
	_tmp23_ = _tmp22_.width;
	if (_tmp21_ > _tmp23_) {
		gdouble _tmp24_ = 0.0;
		_tmp24_ = max;
		_tmp20_ = _tmp24_;
	} else {
		cairo_text_extents_t _tmp25_ = {0};
		gdouble _tmp26_ = 0.0;
		_tmp25_ = extents;
		_tmp26_ = _tmp25_.width;
		_tmp20_ = _tmp26_;
	}
	max = _tmp20_;
	_tmp27_ = c;
	cairo_text_extents (_tmp27_, "333∶33", &_tmp28_);
	extents = _tmp28_;
	_tmp30_ = max;
	_tmp31_ = extents;
	_tmp32_ = _tmp31_.width;
	if (_tmp30_ > _tmp32_) {
		gdouble _tmp33_ = 0.0;
		_tmp33_ = max;
		_tmp29_ = _tmp33_;
	} else {
		cairo_text_extents_t _tmp34_ = {0};
		gdouble _tmp35_ = 0.0;
		_tmp34_ = extents;
		_tmp35_ = _tmp34_.width;
		_tmp29_ = _tmp35_;
	}
	max = _tmp29_;
	_tmp36_ = c;
	cairo_text_extents (_tmp36_, "444∶44", &_tmp37_);
	extents = _tmp37_;
	_tmp39_ = max;
	_tmp40_ = extents;
	_tmp41_ = _tmp40_.width;
	if (_tmp39_ > _tmp41_) {
		gdouble _tmp42_ = 0.0;
		_tmp42_ = max;
		_tmp38_ = _tmp42_;
	} else {
		cairo_text_extents_t _tmp43_ = {0};
		gdouble _tmp44_ = 0.0;
		_tmp43_ = extents;
		_tmp44_ = _tmp43_.width;
		_tmp38_ = _tmp44_;
	}
	max = _tmp38_;
	_tmp45_ = c;
	cairo_text_extents (_tmp45_, "555∶55", &_tmp46_);
	extents = _tmp46_;
	_tmp48_ = max;
	_tmp49_ = extents;
	_tmp50_ = _tmp49_.width;
	if (_tmp48_ > _tmp50_) {
		gdouble _tmp51_ = 0.0;
		_tmp51_ = max;
		_tmp47_ = _tmp51_;
	} else {
		cairo_text_extents_t _tmp52_ = {0};
		gdouble _tmp53_ = 0.0;
		_tmp52_ = extents;
		_tmp53_ = _tmp52_.width;
		_tmp47_ = _tmp53_;
	}
	max = _tmp47_;
	_tmp54_ = c;
	cairo_text_extents (_tmp54_, "666∶66", &_tmp55_);
	extents = _tmp55_;
	_tmp57_ = max;
	_tmp58_ = extents;
	_tmp59_ = _tmp58_.width;
	if (_tmp57_ > _tmp59_) {
		gdouble _tmp60_ = 0.0;
		_tmp60_ = max;
		_tmp56_ = _tmp60_;
	} else {
		cairo_text_extents_t _tmp61_ = {0};
		gdouble _tmp62_ = 0.0;
		_tmp61_ = extents;
		_tmp62_ = _tmp61_.width;
		_tmp56_ = _tmp62_;
	}
	max = _tmp56_;
	_tmp63_ = c;
	cairo_text_extents (_tmp63_, "777∶77", &_tmp64_);
	extents = _tmp64_;
	_tmp66_ = max;
	_tmp67_ = extents;
	_tmp68_ = _tmp67_.width;
	if (_tmp66_ > _tmp68_) {
		gdouble _tmp69_ = 0.0;
		_tmp69_ = max;
		_tmp65_ = _tmp69_;
	} else {
		cairo_text_extents_t _tmp70_ = {0};
		gdouble _tmp71_ = 0.0;
		_tmp70_ = extents;
		_tmp71_ = _tmp70_.width;
		_tmp65_ = _tmp71_;
	}
	max = _tmp65_;
	_tmp72_ = c;
	cairo_text_extents (_tmp72_, "888∶88", &_tmp73_);
	extents = _tmp73_;
	_tmp75_ = max;
	_tmp76_ = extents;
	_tmp77_ = _tmp76_.width;
	if (_tmp75_ > _tmp77_) {
		gdouble _tmp78_ = 0.0;
		_tmp78_ = max;
		_tmp74_ = _tmp78_;
	} else {
		cairo_text_extents_t _tmp79_ = {0};
		gdouble _tmp80_ = 0.0;
		_tmp79_ = extents;
		_tmp80_ = _tmp79_.width;
		_tmp74_ = _tmp80_;
	}
	max = _tmp74_;
	_tmp81_ = c;
	cairo_text_extents (_tmp81_, "999∶99", &_tmp82_);
	extents = _tmp82_;
	_tmp84_ = max;
	_tmp85_ = extents;
	_tmp86_ = _tmp85_.width;
	if (_tmp84_ > _tmp86_) {
		gdouble _tmp87_ = 0.0;
		_tmp87_ = max;
		_tmp83_ = _tmp87_;
	} else {
		cairo_text_extents_t _tmp88_ = {0};
		gdouble _tmp89_ = 0.0;
		_tmp88_ = extents;
		_tmp89_ = _tmp88_.width;
		_tmp83_ = _tmp89_;
	}
	max = _tmp83_;
	_tmp90_ = max;
	_tmp91_ = ceil (_tmp90_);
	result = ((gint) _tmp91_) + 6;
	_tmp92_ = result;
	_vala_warn_if_fail (_tmp92_ > 0, "result > 0");
	return result;
}


static void chess_application_draw_time (ChessApplication* self, GtkWidget* widget, cairo_t* c, const gchar* text, gdouble* fg, int fg_length1, gdouble* bg, int bg_length1) {
	gdouble alpha = 0.0;
	GtkWidget* _tmp0_ = NULL;
	GtkStateFlags _tmp1_ = 0;
	cairo_t* _tmp2_ = NULL;
	gdouble* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gdouble _tmp4_ = 0.0;
	gdouble* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gdouble _tmp6_ = 0.0;
	gdouble* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	cairo_t* _tmp10_ = NULL;
	cairo_t* _tmp11_ = NULL;
	gdouble* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gdouble _tmp13_ = 0.0;
	gdouble* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gdouble _tmp15_ = 0.0;
	gdouble* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gdouble _tmp17_ = 0.0;
	gdouble _tmp18_ = 0.0;
	cairo_t* _tmp19_ = NULL;
	cairo_t* _tmp20_ = NULL;
	GtkWidget* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	cairo_text_extents_t extents = {0};
	cairo_t* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	cairo_text_extents_t _tmp25_ = {0};
	cairo_t* _tmp26_ = NULL;
	GtkWidget* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	cairo_text_extents_t _tmp29_ = {0};
	gdouble _tmp30_ = 0.0;
	cairo_text_extents_t _tmp31_ = {0};
	gdouble _tmp32_ = 0.0;
	GtkWidget* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	cairo_text_extents_t _tmp35_ = {0};
	gdouble _tmp36_ = 0.0;
	cairo_text_extents_t _tmp37_ = {0};
	gdouble _tmp38_ = 0.0;
	cairo_t* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	gint width = 0;
	GtkWidget* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (text != NULL);
	alpha = 1.0;
	_tmp0_ = widget;
	_tmp1_ = gtk_widget_get_state_flags (_tmp0_);
	if ((_tmp1_ & GTK_STATE_FLAG_INSENSITIVE) != 0) {
		alpha = 0.5;
	}
	_tmp2_ = c;
	_tmp3_ = bg;
	_tmp3__length1 = bg_length1;
	_tmp4_ = _tmp3_[0];
	_tmp5_ = bg;
	_tmp5__length1 = bg_length1;
	_tmp6_ = _tmp5_[1];
	_tmp7_ = bg;
	_tmp7__length1 = bg_length1;
	_tmp8_ = _tmp7_[2];
	_tmp9_ = alpha;
	cairo_set_source_rgba (_tmp2_, _tmp4_, _tmp6_, _tmp8_, _tmp9_);
	_tmp10_ = c;
	cairo_paint (_tmp10_);
	_tmp11_ = c;
	_tmp12_ = fg;
	_tmp12__length1 = fg_length1;
	_tmp13_ = _tmp12_[0];
	_tmp14_ = fg;
	_tmp14__length1 = fg_length1;
	_tmp15_ = _tmp14_[1];
	_tmp16_ = fg;
	_tmp16__length1 = fg_length1;
	_tmp17_ = _tmp16_[2];
	_tmp18_ = alpha;
	cairo_set_source_rgba (_tmp11_, _tmp13_, _tmp15_, _tmp17_, _tmp18_);
	_tmp19_ = c;
	cairo_select_font_face (_tmp19_, "fixed", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
	_tmp20_ = c;
	_tmp21_ = widget;
	_tmp22_ = gtk_widget_get_allocated_height (_tmp21_);
	cairo_set_font_size (_tmp20_, 0.6 * _tmp22_);
	_tmp23_ = c;
	_tmp24_ = text;
	cairo_text_extents (_tmp23_, _tmp24_, &_tmp25_);
	extents = _tmp25_;
	_tmp26_ = c;
	_tmp27_ = widget;
	_tmp28_ = gtk_widget_get_allocated_width (_tmp27_);
	_tmp29_ = extents;
	_tmp30_ = _tmp29_.width;
	_tmp31_ = extents;
	_tmp32_ = _tmp31_.x_bearing;
	_tmp33_ = widget;
	_tmp34_ = gtk_widget_get_allocated_height (_tmp33_);
	_tmp35_ = extents;
	_tmp36_ = _tmp35_.height;
	_tmp37_ = extents;
	_tmp38_ = _tmp37_.y_bearing;
	cairo_move_to (_tmp26_, ((_tmp28_ - _tmp30_) / 2) - _tmp32_, ((_tmp34_ - _tmp36_) / 2) - _tmp38_);
	_tmp39_ = c;
	_tmp40_ = text;
	cairo_show_text (_tmp39_, _tmp40_);
	_tmp41_ = widget;
	gtk_widget_get_size_request (_tmp41_, &_tmp42_, NULL);
	width = _tmp42_;
	_tmp43_ = width;
	if (_tmp43_ == (-1)) {
		GtkWidget* _tmp44_ = NULL;
		cairo_t* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		_tmp44_ = widget;
		_tmp45_ = c;
		_tmp46_ = chess_application_compute_time_label_width_request (self, _tmp45_);
		gtk_widget_set_size_request (_tmp44_, _tmp46_, -1);
	}
}


void G_MODULE_EXPORT history_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint move_number = 0;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	ChessGame* _tmp8_ = NULL;
	ChessScene* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &move_number, -1, -1);
	_tmp8_ = self->priv->game;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		gint _tmp9_ = 0;
		ChessGame* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		guint _tmp12_ = 0U;
		_tmp9_ = move_number;
		_tmp10_ = self->priv->game;
		_tmp11_ = chess_game_get_n_moves (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp7_ = ((guint) _tmp9_) == _tmp12_;
	}
	if (_tmp7_) {
		move_number = -1;
	}
	_tmp13_ = self->priv->scene;
	_tmp14_ = move_number;
	chess_scene_set_move_number (_tmp13_, _tmp14_);
}


void G_MODULE_EXPORT history_latest_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scene;
	chess_scene_set_move_number (_tmp0_, -1);
}


void G_MODULE_EXPORT history_next_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint move_number = 0;
	ChessScene* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	ChessGame* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scene;
	_tmp1_ = chess_scene_get_move_number (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == (-1)) {
		return;
	}
	_tmp3_ = self->priv->scene;
	_tmp4_ = chess_scene_get_move_number (_tmp3_);
	_tmp5_ = _tmp4_;
	move_number = _tmp5_ + 1;
	_tmp6_ = move_number;
	_tmp7_ = self->priv->game;
	_tmp8_ = chess_game_get_n_moves (_tmp7_);
	_tmp9_ = _tmp8_;
	if (((guint) _tmp6_) >= _tmp9_) {
		ChessScene* _tmp10_ = NULL;
		_tmp10_ = self->priv->scene;
		chess_scene_set_move_number (_tmp10_, -1);
	} else {
		ChessScene* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		_tmp11_ = self->priv->scene;
		_tmp12_ = move_number;
		chess_scene_set_move_number (_tmp11_, _tmp12_);
	}
}


void G_MODULE_EXPORT history_previous_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ChessScene* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scene;
	_tmp1_ = chess_scene_get_move_number (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		return;
	}
	_tmp3_ = self->priv->scene;
	_tmp4_ = chess_scene_get_move_number (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == (-1)) {
		ChessScene* _tmp6_ = NULL;
		ChessGame* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
		_tmp6_ = self->priv->scene;
		_tmp7_ = self->priv->game;
		_tmp8_ = chess_game_get_n_moves (_tmp7_);
		_tmp9_ = _tmp8_;
		chess_scene_set_move_number (_tmp6_, ((gint) _tmp9_) - 1);
	} else {
		ChessScene* _tmp10_ = NULL;
		ChessScene* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		_tmp10_ = self->priv->scene;
		_tmp11_ = self->priv->scene;
		_tmp12_ = chess_scene_get_move_number (_tmp11_);
		_tmp13_ = _tmp12_;
		chess_scene_set_move_number (_tmp10_, _tmp13_ - 1);
	}
}


void G_MODULE_EXPORT history_start_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scene;
	chess_scene_set_move_number (_tmp0_, 0);
}


void chess_application_preferences_cb (ChessApplication* self) {
	GtkDialog* _tmp0_ = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GtkBuilder* _tmp8_ = NULL;
	GObject* _tmp9_ = NULL;
	GtkDialog* _tmp10_ = NULL;
	GtkDialog* _tmp11_ = NULL;
	GtkApplicationWindow* _tmp12_ = NULL;
	GSettings* _tmp13_ = NULL;
	GtkBuilder* _tmp14_ = NULL;
	GObject* _tmp15_ = NULL;
	GSettings* _tmp16_ = NULL;
	GtkBuilder* _tmp17_ = NULL;
	GObject* _tmp18_ = NULL;
	GtkBuilder* _tmp19_ = NULL;
	GObject* _tmp20_ = NULL;
	GtkComboBox* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	GSettings* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	GtkComboBox* _tmp25_ = NULL;
	GtkComboBox* ai_combo = NULL;
	GtkBuilder* _tmp26_ = NULL;
	GObject* _tmp27_ = NULL;
	GtkComboBox* _tmp28_ = NULL;
	GtkListStore* ai_model = NULL;
	GtkComboBox* _tmp29_ = NULL;
	GtkTreeModel* _tmp30_ = NULL;
	GtkTreeModel* _tmp31_ = NULL;
	GtkListStore* _tmp32_ = NULL;
	gchar* opponent_name = NULL;
	GSettings* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	GList* _tmp37_ = NULL;
	GtkComboBox* _tmp60_ = NULL;
	gint _tmp61_ = 0;
	GtkBuilder* _tmp64_ = NULL;
	GObject* _tmp65_ = NULL;
	GtkComboBox* _tmp66_ = NULL;
	GtkComboBox* _tmp67_ = NULL;
	GSettings* _tmp68_ = NULL;
	gchar* _tmp69_ = NULL;
	gchar* _tmp70_ = NULL;
	GtkBuilder* _tmp71_ = NULL;
	GObject* _tmp72_ = NULL;
	GtkComboBox* _tmp73_ = NULL;
	GtkBuilder* _tmp74_ = NULL;
	GObject* _tmp75_ = NULL;
	GtkComboBox* _tmp76_ = NULL;
	GtkBuilder* _tmp77_ = NULL;
	GObject* _tmp78_ = NULL;
	GtkAdjustment* _tmp79_ = NULL;
	GtkBuilder* _tmp80_ = NULL;
	GObject* _tmp81_ = NULL;
	GtkAdjustment* _tmp82_ = NULL;
	GtkBuilder* _tmp83_ = NULL;
	GObject* _tmp84_ = NULL;
	GtkBox* _tmp85_ = NULL;
	GtkBuilder* _tmp86_ = NULL;
	GObject* _tmp87_ = NULL;
	GtkBox* _tmp88_ = NULL;
	GtkBuilder* _tmp89_ = NULL;
	GObject* _tmp90_ = NULL;
	GtkComboBox* _tmp91_ = NULL;
	GSettings* _tmp92_ = NULL;
	gint _tmp93_ = 0;
	GtkBuilder* _tmp94_ = NULL;
	GObject* _tmp95_ = NULL;
	GtkWidget* _tmp96_ = NULL;
	GtkBuilder* _tmp97_ = NULL;
	GObject* _tmp98_ = NULL;
	GtkComboBox* _tmp99_ = NULL;
	PGNGame* _tmp100_ = NULL;
	const gchar* _tmp101_ = NULL;
	const gchar* _tmp102_ = NULL;
	PGNGame* _tmp111_ = NULL;
	const gchar* _tmp112_ = NULL;
	const gchar* _tmp113_ = NULL;
	GtkComboBox* orientation_combo = NULL;
	GtkBuilder* _tmp120_ = NULL;
	GObject* _tmp121_ = NULL;
	GtkComboBox* _tmp122_ = NULL;
	GtkComboBox* _tmp123_ = NULL;
	GSettings* _tmp124_ = NULL;
	gchar* _tmp125_ = NULL;
	gchar* _tmp126_ = NULL;
	GtkComboBox* move_combo = NULL;
	GtkBuilder* _tmp127_ = NULL;
	GObject* _tmp128_ = NULL;
	GtkComboBox* _tmp129_ = NULL;
	GtkComboBox* _tmp130_ = NULL;
	GSettings* _tmp131_ = NULL;
	gchar* _tmp132_ = NULL;
	gchar* _tmp133_ = NULL;
	GtkComboBox* theme_combo = NULL;
	GtkBuilder* _tmp134_ = NULL;
	GObject* _tmp135_ = NULL;
	GtkComboBox* _tmp136_ = NULL;
	GtkComboBox* _tmp137_ = NULL;
	GSettings* _tmp138_ = NULL;
	gchar* _tmp139_ = NULL;
	gchar* _tmp140_ = NULL;
	GtkBuilder* _tmp141_ = NULL;
	GtkComboBox* _tmp142_ = NULL;
	gint _tmp143_ = 0;
	GtkDialog* _tmp146_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	if (_tmp0_ != NULL) {
		GtkDialog* _tmp1_ = NULL;
		_tmp1_ = self->priv->preferences_dialog;
		gtk_window_present ((GtkWindow*) _tmp1_);
		return;
	}
	_tmp2_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->preferences_builder);
	self->priv->preferences_builder = _tmp2_;
	{
		GtkBuilder* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp3_ = self->priv->preferences_builder;
		_tmp4_ = g_build_filename (PKGDATADIR, "preferences.ui", NULL, NULL);
		_tmp5_ = _tmp4_;
		gtk_builder_add_from_file (_tmp3_, _tmp5_, &_inner_error_);
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("gnome-chess.vala:1702: Could not load preferences UI: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = self->priv->preferences_builder;
	_tmp9_ = gtk_builder_get_object (_tmp8_, "preferences");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_dialog_get_type (), GtkDialog));
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = _tmp10_;
	_tmp11_ = self->priv->preferences_dialog;
	_tmp12_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp11_, (GtkWindow*) _tmp12_);
	_tmp13_ = self->priv->settings;
	_tmp14_ = self->priv->preferences_builder;
	_tmp15_ = gtk_builder_get_object (_tmp14_, "show_numbering_check");
	g_settings_bind (_tmp13_, "show-numbering", _tmp15_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp16_ = self->priv->settings;
	_tmp17_ = self->priv->preferences_builder;
	_tmp18_ = gtk_builder_get_object (_tmp17_, "show_move_hints_check");
	g_settings_bind (_tmp16_, "show-move-hints", _tmp18_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp19_ = self->priv->preferences_builder;
	_tmp20_ = gtk_builder_get_object (_tmp19_, "side_combo");
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->side_combo);
	self->priv->side_combo = _tmp21_;
	_tmp23_ = self->priv->settings;
	_tmp24_ = g_settings_get_boolean (_tmp23_, "play-as-white");
	if (_tmp24_) {
		_tmp22_ = 0;
	} else {
		_tmp22_ = 1;
	}
	_tmp25_ = self->priv->side_combo;
	gtk_combo_box_set_active (_tmp25_, _tmp22_);
	_tmp26_ = self->priv->preferences_builder;
	_tmp27_ = gtk_builder_get_object (_tmp26_, "opponent_combo");
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_combo_box_get_type (), GtkComboBox));
	ai_combo = _tmp28_;
	_tmp29_ = ai_combo;
	_tmp30_ = gtk_combo_box_get_model (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_list_store_get_type (), GtkListStore));
	ai_model = _tmp32_;
	_tmp33_ = self->priv->settings;
	_tmp34_ = g_settings_get_string (_tmp33_, "opponent");
	opponent_name = _tmp34_;
	_tmp35_ = opponent_name;
	if (g_strcmp0 (_tmp35_, "human") == 0) {
		GtkComboBox* _tmp36_ = NULL;
		_tmp36_ = ai_combo;
		gtk_combo_box_set_active (_tmp36_, 0);
	}
	_tmp37_ = self->priv->ai_profiles;
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
		p_collection = _tmp37_;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			AIProfile* _tmp38_ = NULL;
			AIProfile* p = NULL;
			_tmp38_ = _g_object_ref0 ((AIProfile*) p_it->data);
			p = _tmp38_;
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp39_ = NULL;
				GtkTreeIter _tmp40_ = {0};
				GtkListStore* _tmp41_ = NULL;
				GtkTreeIter _tmp42_ = {0};
				AIProfile* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
				const gchar* _tmp45_ = NULL;
				AIProfile* _tmp46_ = NULL;
				const gchar* _tmp47_ = NULL;
				const gchar* _tmp48_ = NULL;
				gboolean _tmp49_ = FALSE;
				AIProfile* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				const gchar* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				_tmp39_ = ai_model;
				gtk_list_store_append (_tmp39_, &_tmp40_);
				iter = _tmp40_;
				_tmp41_ = ai_model;
				_tmp42_ = iter;
				_tmp43_ = p;
				_tmp44_ = ai_profile_get_name (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = p;
				_tmp47_ = ai_profile_get_name (_tmp46_);
				_tmp48_ = _tmp47_;
				gtk_list_store_set (_tmp41_, &_tmp42_, 0, _tmp45_, 1, _tmp48_, -1, -1);
				_tmp50_ = p;
				_tmp51_ = ai_profile_get_name (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = opponent_name;
				if (g_strcmp0 (_tmp52_, _tmp53_) == 0) {
					_tmp49_ = TRUE;
				} else {
					gboolean _tmp54_ = FALSE;
					const gchar* _tmp55_ = NULL;
					_tmp55_ = opponent_name;
					if (g_strcmp0 (_tmp55_, "") == 0) {
						GtkComboBox* _tmp56_ = NULL;
						gint _tmp57_ = 0;
						_tmp56_ = ai_combo;
						_tmp57_ = gtk_combo_box_get_active (_tmp56_);
						_tmp54_ = _tmp57_ == (-1);
					} else {
						_tmp54_ = FALSE;
					}
					_tmp49_ = _tmp54_;
				}
				if (_tmp49_) {
					GtkComboBox* _tmp58_ = NULL;
					GtkTreeIter _tmp59_ = {0};
					_tmp58_ = ai_combo;
					_tmp59_ = iter;
					gtk_combo_box_set_active_iter (_tmp58_, &_tmp59_);
				}
				_g_object_unref0 (p);
			}
		}
	}
	_tmp60_ = ai_combo;
	_tmp61_ = gtk_combo_box_get_active (_tmp60_);
	if (_tmp61_ == (-1)) {
		GtkComboBox* _tmp62_ = NULL;
		GSettings* _tmp63_ = NULL;
		_tmp62_ = ai_combo;
		gtk_combo_box_set_active (_tmp62_, 0);
		_tmp63_ = self->priv->settings;
		g_settings_set_string (_tmp63_, "opponent", "human");
	}
	_tmp64_ = self->priv->preferences_builder;
	_tmp65_ = gtk_builder_get_object (_tmp64_, "difficulty_combo");
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->difficulty_combo);
	self->priv->difficulty_combo = _tmp66_;
	_tmp67_ = self->priv->difficulty_combo;
	_tmp68_ = self->priv->settings;
	_tmp69_ = g_settings_get_string (_tmp68_, "difficulty");
	_tmp70_ = _tmp69_;
	chess_application_set_combo (self, _tmp67_, 1, _tmp70_);
	_g_free0 (_tmp70_);
	_tmp71_ = self->priv->preferences_builder;
	_tmp72_ = gtk_builder_get_object (_tmp71_, "duration_combo");
	_tmp73_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->duration_combo);
	self->priv->duration_combo = _tmp73_;
	_tmp74_ = self->priv->preferences_builder;
	_tmp75_ = gtk_builder_get_object (_tmp74_, "clock_type_combo");
	_tmp76_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->clock_type_combo);
	self->priv->clock_type_combo = _tmp76_;
	_tmp77_ = self->priv->preferences_builder;
	_tmp78_ = gtk_builder_get_object (_tmp77_, "duration_adjustment");
	_tmp79_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, gtk_adjustment_get_type (), GtkAdjustment));
	_g_object_unref0 (self->priv->duration_adjustment);
	self->priv->duration_adjustment = _tmp79_;
	_tmp80_ = self->priv->preferences_builder;
	_tmp81_ = gtk_builder_get_object (_tmp80_, "timer_increment_adjustment");
	_tmp82_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, gtk_adjustment_get_type (), GtkAdjustment));
	_g_object_unref0 (self->priv->timer_increment_adjustment);
	self->priv->timer_increment_adjustment = _tmp82_;
	_tmp83_ = self->priv->preferences_builder;
	_tmp84_ = gtk_builder_get_object (_tmp83_, "custom_duration_box");
	_tmp85_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->custom_duration_box);
	self->priv->custom_duration_box = _tmp85_;
	_tmp86_ = self->priv->preferences_builder;
	_tmp87_ = gtk_builder_get_object (_tmp86_, "timer_increment_box");
	_tmp88_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->timer_increment_box);
	self->priv->timer_increment_box = _tmp88_;
	_tmp89_ = self->priv->preferences_builder;
	_tmp90_ = gtk_builder_get_object (_tmp89_, "custom_duration_units_combo");
	_tmp91_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->custom_duration_units_combo);
	self->priv->custom_duration_units_combo = _tmp91_;
	_tmp92_ = self->priv->settings;
	_tmp93_ = g_settings_get_int (_tmp92_, "duration");
	chess_application_set_duration (self, _tmp93_, TRUE);
	_tmp94_ = self->priv->preferences_builder;
	_tmp95_ = gtk_builder_get_object (_tmp94_, "timer_increment_label");
	_tmp96_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->timer_increment_label);
	self->priv->timer_increment_label = _tmp96_;
	_tmp97_ = self->priv->preferences_builder;
	_tmp98_ = gtk_builder_get_object (_tmp97_, "timer_increment_units_combo");
	_tmp99_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->timer_increment_units_combo);
	self->priv->timer_increment_units_combo = _tmp99_;
	_tmp100_ = self->priv->pgn_game;
	_tmp101_ = pgn_game_get_clock_type (_tmp100_);
	_tmp102_ = _tmp101_;
	if (_tmp102_ != NULL) {
		PGNGame* _tmp103_ = NULL;
		const gchar* _tmp104_ = NULL;
		const gchar* _tmp105_ = NULL;
		ClockType _tmp106_ = 0;
		_tmp103_ = self->priv->pgn_game;
		_tmp104_ = pgn_game_get_clock_type (_tmp103_);
		_tmp105_ = _tmp104_;
		_tmp106_ = clock_type_string_to_enum (_tmp105_);
		chess_application_set_clock_type (self, (gint) _tmp106_);
	} else {
		GSettings* _tmp107_ = NULL;
		gchar* _tmp108_ = NULL;
		gchar* _tmp109_ = NULL;
		ClockType _tmp110_ = 0;
		_tmp107_ = self->priv->settings;
		_tmp108_ = g_settings_get_string (_tmp107_, "clock-type");
		_tmp109_ = _tmp108_;
		_tmp110_ = clock_type_string_to_enum (_tmp109_);
		chess_application_set_clock_type (self, (gint) _tmp110_);
		_g_free0 (_tmp109_);
	}
	_tmp111_ = self->priv->pgn_game;
	_tmp112_ = pgn_game_get_timer_increment (_tmp111_);
	_tmp113_ = _tmp112_;
	if (_tmp113_ != NULL) {
		PGNGame* _tmp114_ = NULL;
		const gchar* _tmp115_ = NULL;
		const gchar* _tmp116_ = NULL;
		gint _tmp117_ = 0;
		_tmp114_ = self->priv->pgn_game;
		_tmp115_ = pgn_game_get_timer_increment (_tmp114_);
		_tmp116_ = _tmp115_;
		_tmp117_ = atoi (_tmp116_);
		chess_application_set_timer_increment (self, _tmp117_);
	} else {
		GSettings* _tmp118_ = NULL;
		gint _tmp119_ = 0;
		_tmp118_ = self->priv->settings;
		_tmp119_ = g_settings_get_int (_tmp118_, "timer-increment");
		chess_application_set_timer_increment (self, _tmp119_);
	}
	_tmp120_ = self->priv->preferences_builder;
	_tmp121_ = gtk_builder_get_object (_tmp120_, "orientation_combo");
	_tmp122_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, gtk_combo_box_get_type (), GtkComboBox));
	orientation_combo = _tmp122_;
	_tmp123_ = orientation_combo;
	_tmp124_ = self->priv->settings;
	_tmp125_ = g_settings_get_string (_tmp124_, "board-side");
	_tmp126_ = _tmp125_;
	chess_application_set_combo (self, _tmp123_, 1, _tmp126_);
	_g_free0 (_tmp126_);
	_tmp127_ = self->priv->preferences_builder;
	_tmp128_ = gtk_builder_get_object (_tmp127_, "move_format_combo");
	_tmp129_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp128_, gtk_combo_box_get_type (), GtkComboBox));
	move_combo = _tmp129_;
	_tmp130_ = move_combo;
	_tmp131_ = self->priv->settings;
	_tmp132_ = g_settings_get_string (_tmp131_, "move-format");
	_tmp133_ = _tmp132_;
	chess_application_set_combo (self, _tmp130_, 1, _tmp133_);
	_g_free0 (_tmp133_);
	_tmp134_ = self->priv->preferences_builder;
	_tmp135_ = gtk_builder_get_object (_tmp134_, "piece_style_combo");
	_tmp136_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp135_, gtk_combo_box_get_type (), GtkComboBox));
	theme_combo = _tmp136_;
	_tmp137_ = theme_combo;
	_tmp138_ = self->priv->settings;
	_tmp139_ = g_settings_get_string (_tmp138_, "piece-theme");
	_tmp140_ = _tmp139_;
	chess_application_set_combo (self, _tmp137_, 1, _tmp140_);
	_g_free0 (_tmp140_);
	_tmp141_ = self->priv->preferences_builder;
	gtk_builder_connect_signals (_tmp141_, self);
	_tmp142_ = ai_combo;
	_tmp143_ = gtk_combo_box_get_active (_tmp142_);
	if (_tmp143_ == 0) {
		GtkComboBox* _tmp144_ = NULL;
		GtkComboBox* _tmp145_ = NULL;
		_tmp144_ = self->priv->side_combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp144_, FALSE);
		_tmp145_ = self->priv->difficulty_combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp145_, FALSE);
	}
	_tmp146_ = self->priv->preferences_dialog;
	gtk_window_present ((GtkWindow*) _tmp146_);
	_g_object_unref0 (theme_combo);
	_g_object_unref0 (move_combo);
	_g_object_unref0 (orientation_combo);
	_g_free0 (opponent_name);
	_g_object_unref0 (ai_model);
	_g_object_unref0 (ai_combo);
}


static void chess_application_set_combo (ChessApplication* self, GtkComboBox* combo, gint value_index, const gchar* value) {
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	model = _tmp3_;
	_tmp4_ = model;
	_tmp6_ = gtk_tree_model_get_iter_first (_tmp4_, &_tmp5_);
	iter = _tmp5_;
	if (!_tmp6_) {
		_g_object_unref0 (model);
		return;
	}
	{
		gboolean _tmp7_ = FALSE;
		_tmp7_ = TRUE;
		while (TRUE) {
			gchar* v = NULL;
			GtkTreeModel* _tmp10_ = NULL;
			GtkTreeIter _tmp11_ = {0};
			gint _tmp12_ = 0;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			if (!_tmp7_) {
				GtkTreeModel* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
				_tmp8_ = model;
				_tmp9_ = gtk_tree_model_iter_next (_tmp8_, &iter);
				if (!_tmp9_) {
					break;
				}
			}
			_tmp7_ = FALSE;
			_tmp10_ = model;
			_tmp11_ = iter;
			_tmp12_ = value_index;
			gtk_tree_model_get (_tmp10_, &_tmp11_, _tmp12_, &v, -1, -1);
			_tmp13_ = v;
			_tmp14_ = value;
			if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
				GtkComboBox* _tmp15_ = NULL;
				GtkTreeIter _tmp16_ = {0};
				_tmp15_ = combo;
				_tmp16_ = iter;
				gtk_combo_box_set_active_iter (_tmp15_, &_tmp16_);
				_g_free0 (v);
				_g_object_unref0 (model);
				return;
			}
			_g_free0 (v);
		}
	}
	_g_object_unref0 (model);
}


static gchar* chess_application_get_combo (ChessApplication* self, GtkComboBox* combo, gint value_index) {
	gchar* result = NULL;
	gchar* value = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gint _tmp7_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (combo != NULL, NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		result = NULL;
		_g_free0 (value);
		return result;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	_tmp7_ = value_index;
	gtk_tree_model_get (_tmp5_, &_tmp6_, _tmp7_, &value, -1, -1);
	result = value;
	return result;
}


void G_MODULE_EXPORT side_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gboolean play_as_white = FALSE;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GSettings* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &play_as_white, -1, -1);
	_tmp7_ = self->priv->settings;
	_tmp8_ = play_as_white;
	g_settings_set_boolean (_tmp7_, "play-as-white", _tmp8_);
}


void G_MODULE_EXPORT opponent_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gchar* opponent = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GSettings* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean vs_human = FALSE;
	GtkComboBox* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GtkComboBox* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GtkComboBox* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &opponent, -1, -1);
	_tmp7_ = self->priv->settings;
	_tmp8_ = opponent;
	g_settings_set_string (_tmp7_, "opponent", _tmp8_);
	_tmp9_ = combo;
	_tmp10_ = gtk_combo_box_get_active (_tmp9_);
	vs_human = _tmp10_ == 0;
	_tmp11_ = self->priv->side_combo;
	_tmp12_ = vs_human;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, !_tmp12_);
	_tmp13_ = self->priv->difficulty_combo;
	_tmp14_ = vs_human;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, !_tmp14_);
	_g_free0 (opponent);
}


void G_MODULE_EXPORT difficulty_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gchar* difficulty = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GSettings* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &difficulty, -1, -1);
	_tmp7_ = self->priv->settings;
	_tmp8_ = difficulty;
	g_settings_set_string (_tmp7_, "difficulty", _tmp8_);
	_g_free0 (difficulty);
}


static void chess_application_set_clock_type (ChessApplication* self, gint clock_type) {
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeIter active_iter_clock_type = {0};
	GtkTreeIter _tmp4_ = {0};
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	GtkComboBox* _tmp16_ = NULL;
	GtkTreeIter _tmp17_ = {0};
	GtkComboBox* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock_type_combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	model = _tmp3_;
	active_iter_clock_type = _tmp4_;
	_tmp5_ = model;
	_tmp7_ = gtk_tree_model_get_iter_first (_tmp5_, &_tmp6_);
	iter = _tmp6_;
	if (_tmp7_) {
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint type = 0;
				GtkTreeModel* _tmp11_ = NULL;
				GtkTreeIter _tmp12_ = {0};
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				if (!_tmp8_) {
					GtkTreeModel* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
					_tmp9_ = model;
					_tmp10_ = gtk_tree_model_iter_next (_tmp9_, &iter);
					if (!_tmp10_) {
						break;
					}
				}
				_tmp8_ = FALSE;
				_tmp11_ = model;
				_tmp12_ = iter;
				gtk_tree_model_get (_tmp11_, &_tmp12_, 1, &type, -1, -1);
				_tmp13_ = type;
				_tmp14_ = clock_type;
				if (_tmp13_ == _tmp14_) {
					GtkTreeIter _tmp15_ = {0};
					_tmp15_ = iter;
					active_iter_clock_type = _tmp15_;
				}
			}
		}
	}
	_tmp16_ = self->priv->clock_type_combo;
	_tmp17_ = active_iter_clock_type;
	gtk_combo_box_set_active_iter (_tmp16_, &_tmp17_);
	_tmp18_ = self->priv->clock_type_combo;
	G_MODULE_EXPORT clock_type_changed_cb (_tmp18_, self);
	_g_object_unref0 (model);
}


static void chess_application_set_timer_increment (ChessApplication* self, gint timer_increment) {
	gint timer_increment_multiplier = 0;
	gint _tmp0_ = 0;
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkTreeModel* _tmp8_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeIter reqd_iter = {0};
	GtkTreeIter _tmp9_ = {0};
	GtkTreeModel* _tmp10_ = NULL;
	GtkTreeIter _tmp11_ = {0};
	gboolean _tmp12_ = FALSE;
	GtkComboBox* _tmp21_ = NULL;
	GtkTreeIter _tmp22_ = {0};
	GtkComboBox* _tmp23_ = NULL;
	g_return_if_fail (self != NULL);
	timer_increment_multiplier = 1;
	_tmp0_ = timer_increment;
	if (_tmp0_ >= 60) {
		GtkAdjustment* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp1_ = self->priv->timer_increment_adjustment;
		_tmp2_ = timer_increment;
		gtk_adjustment_set_value (_tmp1_, (gdouble) (_tmp2_ / 60));
		timer_increment_multiplier = 60;
	} else {
		GtkAdjustment* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp3_ = self->priv->timer_increment_adjustment;
		_tmp4_ = timer_increment;
		gtk_adjustment_set_value (_tmp3_, (gdouble) _tmp4_);
	}
	_tmp5_ = self->priv->timer_increment_units_combo;
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	model = _tmp8_;
	reqd_iter = _tmp9_;
	_tmp10_ = model;
	_tmp12_ = gtk_tree_model_get_iter_first (_tmp10_, &_tmp11_);
	iter = _tmp11_;
	if (_tmp12_) {
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				gint multiplier = 0;
				GtkTreeModel* _tmp16_ = NULL;
				GtkTreeIter _tmp17_ = {0};
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				if (!_tmp13_) {
					GtkTreeModel* _tmp14_ = NULL;
					gboolean _tmp15_ = FALSE;
					_tmp14_ = model;
					_tmp15_ = gtk_tree_model_iter_next (_tmp14_, &iter);
					if (!_tmp15_) {
						break;
					}
				}
				_tmp13_ = FALSE;
				_tmp16_ = model;
				_tmp17_ = iter;
				gtk_tree_model_get (_tmp16_, &_tmp17_, 1, &multiplier, -1, -1);
				_tmp18_ = multiplier;
				_tmp19_ = timer_increment_multiplier;
				if (_tmp18_ == _tmp19_) {
					GtkTreeIter _tmp20_ = {0};
					_tmp20_ = iter;
					reqd_iter = _tmp20_;
				}
			}
		}
	}
	_tmp21_ = self->priv->timer_increment_units_combo;
	_tmp22_ = reqd_iter;
	gtk_combo_box_set_active_iter (_tmp21_, &_tmp22_);
	_tmp23_ = self->priv->timer_increment_units_combo;
	G_MODULE_EXPORT timer_increment_units_changed_cb ((GtkWidget*) _tmp23_, self);
	_g_object_unref0 (model);
}


static void chess_application_set_duration (ChessApplication* self, gint duration, gboolean simplify) {
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeIter max_iter = {0};
	GtkTreeIter _tmp4_ = {0};
	gint max_multiplier = 0;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	gint value = 0;
	gint _tmp20_ = 0;
	gboolean _tmp27_ = FALSE;
	GtkComboBox* _tmp28_ = NULL;
	GtkTreeModel* _tmp29_ = NULL;
	GtkTreeModel* _tmp30_ = NULL;
	GtkTreeModel* _tmp31_ = NULL;
	GtkTreeModel* _tmp32_ = NULL;
	GtkTreeIter _tmp33_ = {0};
	gboolean _tmp34_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->custom_duration_units_combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	model = _tmp3_;
	max_iter = _tmp4_;
	max_multiplier = 0;
	_tmp5_ = model;
	_tmp7_ = gtk_tree_model_get_iter_first (_tmp5_, &_tmp6_);
	iter = _tmp6_;
	if (_tmp7_) {
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint multiplier = 0;
				GtkTreeModel* _tmp11_ = NULL;
				GtkTreeIter _tmp12_ = {0};
				gboolean _tmp13_ = FALSE;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				if (!_tmp8_) {
					GtkTreeModel* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
					_tmp9_ = model;
					_tmp10_ = gtk_tree_model_iter_next (_tmp9_, &iter);
					if (!_tmp10_) {
						break;
					}
				}
				_tmp8_ = FALSE;
				_tmp11_ = model;
				_tmp12_ = iter;
				gtk_tree_model_get (_tmp11_, &_tmp12_, 1, &multiplier, -1, -1);
				_tmp14_ = multiplier;
				_tmp15_ = max_multiplier;
				if (_tmp14_ > _tmp15_) {
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
					_tmp16_ = duration;
					_tmp17_ = multiplier;
					_tmp13_ = (_tmp16_ % _tmp17_) == 0;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					gint _tmp18_ = 0;
					GtkTreeIter _tmp19_ = {0};
					_tmp18_ = multiplier;
					max_multiplier = _tmp18_;
					_tmp19_ = iter;
					max_iter = _tmp19_;
				}
			}
		}
	}
	value = 0;
	_tmp20_ = max_multiplier;
	if (_tmp20_ > 0) {
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		GtkAdjustment* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		GtkComboBox* _tmp25_ = NULL;
		GtkTreeIter _tmp26_ = {0};
		_tmp21_ = duration;
		_tmp22_ = max_multiplier;
		value = _tmp21_ / _tmp22_;
		_tmp23_ = self->priv->duration_adjustment;
		_tmp24_ = value;
		gtk_adjustment_set_value (_tmp23_, (gdouble) _tmp24_);
		_tmp25_ = self->priv->custom_duration_units_combo;
		_tmp26_ = max_iter;
		gtk_combo_box_set_active_iter (_tmp25_, &_tmp26_);
	}
	_tmp27_ = simplify;
	if (!_tmp27_) {
		_g_object_unref0 (model);
		return;
	}
	_tmp28_ = self->priv->duration_combo;
	_tmp29_ = gtk_combo_box_get_model (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = _g_object_ref0 (_tmp30_);
	_g_object_unref0 (model);
	model = _tmp31_;
	_tmp32_ = model;
	_tmp34_ = gtk_tree_model_get_iter_first (_tmp32_, &_tmp33_);
	iter = _tmp33_;
	if (!_tmp34_) {
		_g_object_unref0 (model);
		return;
	}
	{
		gboolean _tmp35_ = FALSE;
		_tmp35_ = TRUE;
		while (TRUE) {
			gint v = 0;
			GtkTreeModel* _tmp38_ = NULL;
			GtkTreeIter _tmp39_ = {0};
			gboolean _tmp40_ = FALSE;
			gint _tmp41_ = 0;
			gint _tmp42_ = 0;
			if (!_tmp35_) {
				GtkTreeModel* _tmp36_ = NULL;
				gboolean _tmp37_ = FALSE;
				_tmp36_ = model;
				_tmp37_ = gtk_tree_model_iter_next (_tmp36_, &iter);
				if (!_tmp37_) {
					break;
				}
			}
			_tmp35_ = FALSE;
			_tmp38_ = model;
			_tmp39_ = iter;
			gtk_tree_model_get (_tmp38_, &_tmp39_, 1, &v, -1, -1);
			_tmp41_ = v;
			_tmp42_ = duration;
			if (_tmp41_ == _tmp42_) {
				_tmp40_ = TRUE;
			} else {
				gint _tmp43_ = 0;
				_tmp43_ = v;
				_tmp40_ = _tmp43_ == (-1);
			}
			if (_tmp40_) {
				GtkComboBox* _tmp44_ = NULL;
				GtkTreeIter _tmp45_ = {0};
				GtkBox* _tmp46_ = NULL;
				gint _tmp47_ = 0;
				_tmp44_ = self->priv->duration_combo;
				_tmp45_ = iter;
				gtk_combo_box_set_active_iter (_tmp44_, &_tmp45_);
				_tmp46_ = self->priv->custom_duration_box;
				_tmp47_ = v;
				gtk_widget_set_visible ((GtkWidget*) _tmp46_, _tmp47_ == (-1));
				_g_object_unref0 (model);
				return;
			}
		}
	}
	_g_object_unref0 (model);
}


static gint chess_application_get_duration (ChessApplication* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint magnitude = 0;
	GtkAdjustment* _tmp8_ = NULL;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gint multiplier = 0;
	GtkComboBox* _tmp11_ = NULL;
	GtkTreeIter _tmp12_ = {0};
	gboolean _tmp13_ = FALSE;
	gint _tmp18_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->duration_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		gint duration = 0;
		GtkComboBox* _tmp3_ = NULL;
		GtkTreeModel* _tmp4_ = NULL;
		GtkTreeModel* _tmp5_ = NULL;
		GtkTreeIter _tmp6_ = {0};
		gint _tmp7_ = 0;
		_tmp3_ = self->priv->duration_combo;
		_tmp4_ = gtk_combo_box_get_model (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = iter;
		gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &duration, -1, -1);
		_tmp7_ = duration;
		if (_tmp7_ >= 0) {
			result = duration;
			return result;
		}
	}
	_tmp8_ = self->priv->duration_adjustment;
	_tmp9_ = gtk_adjustment_get_value (_tmp8_);
	_tmp10_ = _tmp9_;
	magnitude = (gint) _tmp10_;
	multiplier = 1;
	_tmp11_ = self->priv->custom_duration_units_combo;
	_tmp13_ = gtk_combo_box_get_active_iter (_tmp11_, &_tmp12_);
	iter = _tmp12_;
	if (_tmp13_) {
		GtkComboBox* _tmp14_ = NULL;
		GtkTreeModel* _tmp15_ = NULL;
		GtkTreeModel* _tmp16_ = NULL;
		GtkTreeIter _tmp17_ = {0};
		_tmp14_ = self->priv->custom_duration_units_combo;
		_tmp15_ = gtk_combo_box_get_model (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = iter;
		gtk_tree_model_get (_tmp16_, &_tmp17_, 1, &multiplier, -1, -1);
	}
	_tmp18_ = multiplier;
	switch (_tmp18_) {
		case 60:
		{
			GtkAdjustment* _tmp19_ = NULL;
			gdouble _tmp20_ = 0.0;
			_tmp19_ = self->priv->duration_adjustment;
			_tmp20_ = gtk_adjustment_get_upper (_tmp19_);
			if (_tmp20_ != ((gdouble) 600)) {
				GtkAdjustment* _tmp21_ = NULL;
				_tmp21_ = self->priv->duration_adjustment;
				gtk_adjustment_set_upper (_tmp21_, (gdouble) 600);
			}
			break;
		}
		case 3600:
		{
			GtkAdjustment* _tmp22_ = NULL;
			gdouble _tmp23_ = 0.0;
			_tmp22_ = self->priv->duration_adjustment;
			_tmp23_ = gtk_adjustment_get_upper (_tmp22_);
			if (_tmp23_ != ((gdouble) 10)) {
				GtkAdjustment* _tmp24_ = NULL;
				GtkAdjustment* _tmp25_ = NULL;
				gdouble _tmp26_ = 0.0;
				gdouble _tmp27_ = 0.0;
				_tmp24_ = self->priv->duration_adjustment;
				gtk_adjustment_set_upper (_tmp24_, (gdouble) 10);
				_tmp25_ = self->priv->duration_adjustment;
				_tmp26_ = gtk_adjustment_get_value (_tmp25_);
				_tmp27_ = _tmp26_;
				if (_tmp27_ > ((gdouble) 10)) {
					GtkAdjustment* _tmp28_ = NULL;
					_tmp28_ = self->priv->duration_adjustment;
					gtk_adjustment_set_value (_tmp28_, (gdouble) 10);
					magnitude = 10;
				}
			}
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp29_ = magnitude;
	_tmp30_ = multiplier;
	result = _tmp29_ * _tmp30_;
	return result;
}


static gboolean chess_application_save_duration_cb (ChessApplication* self) {
	gboolean result = FALSE;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	guint _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->settings;
	_tmp1_ = chess_application_get_duration (self);
	g_settings_set_int (_tmp0_, "duration", _tmp1_);
	_tmp2_ = self->priv->save_duration_timeout;
	g_source_remove (_tmp2_);
	self->priv->save_duration_timeout = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}


void G_MODULE_EXPORT duration_changed_cb (GtkAdjustment* adjustment, ChessApplication* self) {
	GtkListStore* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkListStore* _tmp3_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->custom_duration_units_combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp3_;
	_tmp4_ = model;
	_tmp6_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp4_, &_tmp5_);
	iter = _tmp5_;
	if (_tmp6_) {
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint multiplier = 0;
				GtkListStore* _tmp10_ = NULL;
				GtkTreeIter _tmp11_ = {0};
				gint _tmp12_ = 0;
				if (!_tmp7_) {
					GtkListStore* _tmp8_ = NULL;
					gboolean _tmp9_ = FALSE;
					_tmp8_ = model;
					_tmp9_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp8_, &iter);
					if (!_tmp9_) {
						break;
					}
				}
				_tmp7_ = FALSE;
				_tmp10_ = model;
				_tmp11_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 1, &multiplier, -1, -1);
				_tmp12_ = multiplier;
				switch (_tmp12_) {
					case 60:
					{
						GtkListStore* _tmp13_ = NULL;
						GtkTreeIter _tmp14_ = {0};
						GtkAdjustment* _tmp15_ = NULL;
						gdouble _tmp16_ = 0.0;
						gdouble _tmp17_ = 0.0;
						const gchar* _tmp18_ = NULL;
						_tmp13_ = model;
						_tmp14_ = iter;
						_tmp15_ = adjustment;
						_tmp16_ = gtk_adjustment_get_value (_tmp15_);
						_tmp17_ = _tmp16_;
						_tmp18_ = ngettext ("minute", "minutes", (gulong) _tmp17_);
						gtk_list_store_set (_tmp13_, &_tmp14_, 0, _tmp18_, -1, -1);
						break;
					}
					case 3600:
					{
						GtkListStore* _tmp19_ = NULL;
						GtkTreeIter _tmp20_ = {0};
						GtkAdjustment* _tmp21_ = NULL;
						gdouble _tmp22_ = 0.0;
						gdouble _tmp23_ = 0.0;
						const gchar* _tmp24_ = NULL;
						_tmp19_ = model;
						_tmp20_ = iter;
						_tmp21_ = adjustment;
						_tmp22_ = gtk_adjustment_get_value (_tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = ngettext ("hour", "hours", (gulong) _tmp23_);
						gtk_list_store_set (_tmp19_, &_tmp20_, 0, _tmp24_, -1, -1);
						break;
					}
					default:
					{
						g_assert_not_reached ();
					}
				}
			}
		}
	}
	chess_application_save_duration (self);
	_g_object_unref0 (model);
}


void G_MODULE_EXPORT duration_units_changed_cb (GtkWidget* widget, ChessApplication* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	chess_application_save_duration (self);
}


void G_MODULE_EXPORT timer_increment_units_changed_cb (GtkWidget* widget, ChessApplication* self) {
	GtkListStore* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkListStore* _tmp3_ = NULL;
	GtkTreeIter iter = {0};
	gint multiplier = 0;
	GtkListStore* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	GtkComboBox* _tmp25_ = NULL;
	GtkTreeIter _tmp26_ = {0};
	gboolean _tmp27_ = FALSE;
	gint _tmp32_ = 0;
	GSettings* _tmp43_ = NULL;
	GtkAdjustment* _tmp44_ = NULL;
	gdouble _tmp45_ = 0.0;
	gdouble _tmp46_ = 0.0;
	gint _tmp47_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->timer_increment_units_combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp3_;
	multiplier = 0;
	_tmp4_ = model;
	_tmp6_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp4_, &_tmp5_);
	iter = _tmp5_;
	if (_tmp6_) {
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				GtkListStore* _tmp10_ = NULL;
				GtkTreeIter _tmp11_ = {0};
				gint _tmp12_ = 0;
				if (!_tmp7_) {
					GtkListStore* _tmp8_ = NULL;
					gboolean _tmp9_ = FALSE;
					_tmp8_ = model;
					_tmp9_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp8_, &iter);
					if (!_tmp9_) {
						break;
					}
				}
				_tmp7_ = FALSE;
				_tmp10_ = model;
				_tmp11_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 1, &multiplier, -1, -1);
				_tmp12_ = multiplier;
				switch (_tmp12_) {
					case 1:
					{
						GtkListStore* _tmp13_ = NULL;
						GtkTreeIter _tmp14_ = {0};
						GtkAdjustment* _tmp15_ = NULL;
						gdouble _tmp16_ = 0.0;
						gdouble _tmp17_ = 0.0;
						const gchar* _tmp18_ = NULL;
						_tmp13_ = model;
						_tmp14_ = iter;
						_tmp15_ = self->priv->timer_increment_adjustment;
						_tmp16_ = gtk_adjustment_get_value (_tmp15_);
						_tmp17_ = _tmp16_;
						_tmp18_ = ngettext ("second", "seconds", (gulong) _tmp17_);
						gtk_list_store_set (_tmp13_, &_tmp14_, 0, _tmp18_, -1, -1);
						break;
					}
					case 60:
					{
						GtkListStore* _tmp19_ = NULL;
						GtkTreeIter _tmp20_ = {0};
						GtkAdjustment* _tmp21_ = NULL;
						gdouble _tmp22_ = 0.0;
						gdouble _tmp23_ = 0.0;
						const gchar* _tmp24_ = NULL;
						_tmp19_ = model;
						_tmp20_ = iter;
						_tmp21_ = self->priv->timer_increment_adjustment;
						_tmp22_ = gtk_adjustment_get_value (_tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = ngettext ("minute", "minutes", (gulong) _tmp23_);
						gtk_list_store_set (_tmp19_, &_tmp20_, 0, _tmp24_, -1, -1);
						break;
					}
					default:
					{
						g_assert_not_reached ();
					}
				}
			}
		}
	}
	_tmp25_ = self->priv->timer_increment_units_combo;
	_tmp27_ = gtk_combo_box_get_active_iter (_tmp25_, &_tmp26_);
	iter = _tmp26_;
	if (_tmp27_) {
		GtkComboBox* _tmp28_ = NULL;
		GtkTreeModel* _tmp29_ = NULL;
		GtkTreeModel* _tmp30_ = NULL;
		GtkTreeIter _tmp31_ = {0};
		_tmp28_ = self->priv->timer_increment_units_combo;
		_tmp29_ = gtk_combo_box_get_model (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = iter;
		gtk_tree_model_get (_tmp30_, &_tmp31_, 1, &multiplier, -1, -1);
	}
	_tmp32_ = multiplier;
	switch (_tmp32_) {
		case 1:
		{
			GtkAdjustment* _tmp33_ = NULL;
			gdouble _tmp34_ = 0.0;
			_tmp33_ = self->priv->timer_increment_adjustment;
			_tmp34_ = gtk_adjustment_get_upper (_tmp33_);
			if (_tmp34_ != ((gdouble) 59)) {
				GtkAdjustment* _tmp35_ = NULL;
				_tmp35_ = self->priv->timer_increment_adjustment;
				gtk_adjustment_set_upper (_tmp35_, (gdouble) 59);
			}
			break;
		}
		case 60:
		{
			GtkAdjustment* _tmp36_ = NULL;
			gdouble _tmp37_ = 0.0;
			_tmp36_ = self->priv->timer_increment_adjustment;
			_tmp37_ = gtk_adjustment_get_upper (_tmp36_);
			if (_tmp37_ != ((gdouble) 10)) {
				GtkAdjustment* _tmp38_ = NULL;
				GtkAdjustment* _tmp39_ = NULL;
				gdouble _tmp40_ = 0.0;
				gdouble _tmp41_ = 0.0;
				_tmp38_ = self->priv->timer_increment_adjustment;
				gtk_adjustment_set_upper (_tmp38_, (gdouble) 10);
				_tmp39_ = self->priv->timer_increment_adjustment;
				_tmp40_ = gtk_adjustment_get_value (_tmp39_);
				_tmp41_ = _tmp40_;
				if (_tmp41_ > ((gdouble) 10)) {
					GtkAdjustment* _tmp42_ = NULL;
					_tmp42_ = self->priv->timer_increment_adjustment;
					gtk_adjustment_set_value (_tmp42_, (gdouble) 10);
				}
			}
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp43_ = self->priv->settings;
	_tmp44_ = self->priv->timer_increment_adjustment;
	_tmp45_ = gtk_adjustment_get_value (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = multiplier;
	g_settings_set_int (_tmp43_, "timer-increment", ((gint) _tmp46_) * _tmp47_);
	_g_object_unref0 (model);
}


static gboolean _chess_application_save_duration_cb_gsource_func (gpointer self) {
	gboolean result;
	result = chess_application_save_duration_cb ((ChessApplication*) self);
	return result;
}


static void chess_application_save_duration (ChessApplication* self) {
	guint _tmp0_ = 0U;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->save_duration_timeout;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->save_duration_timeout;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _chess_application_save_duration_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->save_duration_timeout = _tmp2_;
}


void G_MODULE_EXPORT duration_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint duration = 0;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GtkBox* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	GtkComboBox* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &duration, -1, -1);
	_tmp7_ = self->priv->custom_duration_box;
	_tmp8_ = duration;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, _tmp8_ < 0);
	_tmp9_ = self->priv->clock_type_combo;
	_tmp10_ = duration;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, _tmp10_ != 0);
	_tmp11_ = duration;
	if (_tmp11_ == 0) {
		chess_application_set_clock_type (self, (gint) CLOCK_TYPE_SIMPLE);
	}
	_tmp12_ = duration;
	if (_tmp12_ >= 0) {
		gint _tmp13_ = 0;
		_tmp13_ = duration;
		chess_application_set_duration (self, _tmp13_, FALSE);
	} else {
		gint _tmp14_ = 0;
		_tmp14_ = chess_application_get_duration (self);
		if (_tmp14_ <= 0) {
			chess_application_set_duration (self, 60 * 60, FALSE);
		}
	}
	chess_application_save_duration (self);
}


void G_MODULE_EXPORT clock_type_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	ClockType clock_type = 0;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GtkBox* _tmp7_ = NULL;
	ClockType _tmp8_ = 0;
	GtkWidget* _tmp9_ = NULL;
	ClockType _tmp10_ = 0;
	GSettings* _tmp11_ = NULL;
	ClockType _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &clock_type, -1, -1);
	_tmp7_ = self->priv->timer_increment_box;
	_tmp8_ = clock_type;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, _tmp8_ > 0);
	_tmp9_ = self->priv->timer_increment_label;
	_tmp10_ = clock_type;
	gtk_widget_set_visible (_tmp9_, _tmp10_ > 0);
	_tmp11_ = self->priv->settings;
	_tmp12_ = clock_type;
	_tmp13_ = clock_type_to_string (_tmp12_);
	_tmp14_ = _tmp13_;
	g_settings_set_string (_tmp11_, "clock-type", _tmp14_);
	_g_free0 (_tmp14_);
}


void G_MODULE_EXPORT preferences_response_cb (GtkWidget* widget, gint response_id, ChessApplication* self) {
	GtkDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


gboolean G_MODULE_EXPORT preferences_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = widget;
	G_MODULE_EXPORT preferences_response_cb (_tmp0_, (gint) GTK_RESPONSE_CANCEL, self);
	result = TRUE;
	return result;
}


void G_MODULE_EXPORT piece_style_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GSettings* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = combo;
	_tmp2_ = chess_application_get_combo (self, _tmp1_, 1);
	_tmp3_ = _tmp2_;
	g_settings_set_string (_tmp0_, "piece-theme", _tmp3_);
	_g_free0 (_tmp3_);
}


void G_MODULE_EXPORT move_format_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GSettings* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = combo;
	_tmp2_ = chess_application_get_combo (self, _tmp1_, 1);
	_tmp3_ = _tmp2_;
	g_settings_set_string (_tmp0_, "move-format", _tmp3_);
	_g_free0 (_tmp3_);
}


void G_MODULE_EXPORT orientation_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GSettings* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = combo;
	_tmp2_ = chess_application_get_combo (self, _tmp1_, 1);
	_tmp3_ = _tmp2_;
	g_settings_set_string (_tmp0_, "board-side", _tmp3_);
	_g_free0 (_tmp3_);
}


void chess_application_help_cb (ChessApplication* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkApplicationWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-chess", _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("gnome-chess.vala:2167: Unable to open help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _chess_application_about_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	chess_application_about_response_cb ((ChessApplication*) self, response_id);
}


void chess_application_about_cb (ChessApplication* self) {
	GtkAboutDialog* _tmp0_ = NULL;
	GtkAboutDialog* _tmp2_ = NULL;
	GtkAboutDialog* _tmp3_ = NULL;
	GtkApplicationWindow* _tmp4_ = NULL;
	GtkAboutDialog* _tmp5_ = NULL;
	GtkAboutDialog* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkAboutDialog* _tmp8_ = NULL;
	GtkAboutDialog* _tmp9_ = NULL;
	GtkAboutDialog* _tmp10_ = NULL;
	GtkAboutDialog* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GtkAboutDialog* _tmp13_ = NULL;
	GtkAboutDialog* _tmp14_ = NULL;
	GtkAboutDialog* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkAboutDialog* _tmp17_ = NULL;
	GtkAboutDialog* _tmp18_ = NULL;
	GtkAboutDialog* _tmp19_ = NULL;
	GtkAboutDialog* _tmp20_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->about_dialog;
	if (_tmp0_ != NULL) {
		GtkAboutDialog* _tmp1_ = NULL;
		_tmp1_ = self->priv->about_dialog;
		gtk_window_present ((GtkWindow*) _tmp1_);
		return;
	}
	_tmp2_ = (GtkAboutDialog*) gtk_about_dialog_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->about_dialog);
	self->priv->about_dialog = _tmp2_;
	_tmp3_ = self->priv->about_dialog;
	_tmp4_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, (GtkWindow*) _tmp4_);
	_tmp5_ = self->priv->about_dialog;
	gtk_window_set_modal ((GtkWindow*) _tmp5_, TRUE);
	_tmp6_ = self->priv->about_dialog;
	_tmp7_ = _ ("Chess");
	gtk_about_dialog_set_program_name (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->about_dialog;
	gtk_about_dialog_set_version (_tmp8_, VERSION);
	_tmp9_ = self->priv->about_dialog;
	gtk_about_dialog_set_copyright (_tmp9_, "Copyright © 2010–2013 Robert Ancell\n" \
"Copyright © 2013–2014 Michael Catanzaro");
	_tmp10_ = self->priv->about_dialog;
	gtk_about_dialog_set_license_type (_tmp10_, GTK_LICENSE_GPL_2_0);
	_tmp11_ = self->priv->about_dialog;
	_tmp12_ = _ ("A classic game of positional strategy");
	gtk_about_dialog_set_comments (_tmp11_, _tmp12_);
	_tmp13_ = self->priv->about_dialog;
	gtk_about_dialog_set_authors (_tmp13_, CHESS_APPLICATION_authors);
	_tmp14_ = self->priv->about_dialog;
	gtk_about_dialog_set_artists (_tmp14_, CHESS_APPLICATION_artists);
	_tmp15_ = self->priv->about_dialog;
	_tmp16_ = _ ("translator-credits");
	gtk_about_dialog_set_translator_credits (_tmp15_, _tmp16_);
	_tmp17_ = self->priv->about_dialog;
	gtk_about_dialog_set_website (_tmp17_, "https://wiki.gnome.org/Apps/Chess");
	_tmp18_ = self->priv->about_dialog;
	gtk_about_dialog_set_logo_icon_name (_tmp18_, "gnome-chess");
	_tmp19_ = self->priv->about_dialog;
	g_signal_connect_object ((GtkDialog*) _tmp19_, "response", (GCallback) _chess_application_about_response_cb_gtk_dialog_response, self, 0);
	_tmp20_ = self->priv->about_dialog;
	gtk_widget_show ((GtkWidget*) _tmp20_);
}


static void chess_application_about_response_cb (ChessApplication* self, gint response_id) {
	GtkAboutDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->about_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	_g_object_unref0 (self->priv->about_dialog);
	self->priv->about_dialog = NULL;
}


static void chess_application_add_info_bar_to_dialog (ChessApplication* self, GtkDialog* dialog, GtkInfoBar** info_bar, GtkLabel** label) {
	GtkInfoBar* _vala_info_bar = NULL;
	GtkLabel* _vala_label = NULL;
	GtkBox* vbox = NULL;
	GtkBox* _tmp0_ = NULL;
	GtkInfoBar* _tmp1_ = NULL;
	GtkContainer* content_area = NULL;
	GtkContainer* _tmp2_ = NULL;
	GtkContainer* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkContainer* child = NULL;
	GtkDialog* _tmp5_ = NULL;
	GtkWidget* _tmp6_ = NULL;
	GtkContainer* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	GtkDialog* _tmp11_ = NULL;
	GtkDialog* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp0_);
	vbox = _tmp0_;
	gtk_widget_show ((GtkWidget*) vbox);
	_tmp1_ = (GtkInfoBar*) gtk_info_bar_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (_vala_info_bar);
	_vala_info_bar = _tmp1_;
	_tmp2_ = gtk_info_bar_get_content_area (_vala_info_bar);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_container_get_type (), GtkContainer));
	content_area = _tmp3_;
	gtk_box_pack_start (vbox, (GtkWidget*) _vala_info_bar, FALSE, TRUE, (guint) 0);
	_tmp4_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (_vala_label);
	_vala_label = _tmp4_;
	gtk_container_add (content_area, (GtkWidget*) _vala_label);
	gtk_widget_show ((GtkWidget*) _vala_label);
	_tmp5_ = dialog;
	_tmp6_ = gtk_bin_get_child ((GtkBin*) _tmp5_);
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_container_get_type (), GtkContainer));
	child = _tmp7_;
	gtk_widget_reparent ((GtkWidget*) child, (GtkWidget*) vbox);
	_tmp8_ = dialog;
	_tmp9_ = gtk_container_get_border_width ((GtkContainer*) _tmp8_);
	_tmp10_ = _tmp9_;
	gtk_container_set_border_width (child, _tmp10_);
	_tmp11_ = dialog;
	gtk_container_set_border_width ((GtkContainer*) _tmp11_, (guint) 0);
	gtk_box_set_child_packing (vbox, (GtkWidget*) child, TRUE, TRUE, (guint) 0, GTK_PACK_START);
	_tmp12_ = dialog;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) vbox);
	_g_object_unref0 (child);
	_g_object_unref0 (content_area);
	_g_object_unref0 (vbox);
	if (info_bar) {
		*info_bar = _vala_info_bar;
	} else {
		_g_object_unref0 (_vala_info_bar);
	}
	if (label) {
		*label = _vala_label;
	} else {
		_g_object_unref0 (_vala_label);
	}
}


static void chess_application_update_pgn_time_remaining (ChessApplication* self) {
	ChessGame* _tmp0_ = NULL;
	ChessClock* _tmp1_ = NULL;
	ChessClock* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_clock (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		guint white_initial_time = 0U;
		PGNGame* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		guint black_initial_time = 0U;
		PGNGame* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		guint white_used = 0U;
		ChessGame* _tmp11_ = NULL;
		ChessClock* _tmp12_ = NULL;
		ChessClock* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		guint black_used = 0U;
		ChessGame* _tmp16_ = NULL;
		ChessClock* _tmp17_ = NULL;
		ChessClock* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		guint white_extra = 0U;
		ChessGame* _tmp21_ = NULL;
		ChessClock* _tmp22_ = NULL;
		ChessClock* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		guint black_extra = 0U;
		ChessGame* _tmp26_ = NULL;
		ChessClock* _tmp27_ = NULL;
		ChessClock* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		PGNGame* _tmp31_ = NULL;
		guint _tmp32_ = 0U;
		guint _tmp33_ = 0U;
		guint _tmp34_ = 0U;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		PGNGame* _tmp37_ = NULL;
		guint _tmp38_ = 0U;
		guint _tmp39_ = 0U;
		guint _tmp40_ = 0U;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		_tmp3_ = self->priv->pgn_game;
		_tmp4_ = pgn_game_get_white_time_left (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = atoi (_tmp5_);
		white_initial_time = (guint) _tmp6_;
		_tmp7_ = self->priv->pgn_game;
		_tmp8_ = pgn_game_get_black_time_left (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = atoi (_tmp9_);
		black_initial_time = (guint) _tmp10_;
		_tmp11_ = self->priv->game;
		_tmp12_ = chess_game_get_clock (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = chess_clock_get_white_seconds_used (_tmp13_);
		_tmp15_ = _tmp14_;
		white_used = (guint) _tmp15_;
		_tmp16_ = self->priv->game;
		_tmp17_ = chess_game_get_clock (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = chess_clock_get_black_seconds_used (_tmp18_);
		_tmp20_ = _tmp19_;
		black_used = (guint) _tmp20_;
		_tmp21_ = self->priv->game;
		_tmp22_ = chess_game_get_clock (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = chess_clock_get_white_extra_seconds (_tmp23_);
		_tmp25_ = _tmp24_;
		white_extra = (guint) _tmp25_;
		_tmp26_ = self->priv->game;
		_tmp27_ = chess_game_get_clock (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = chess_clock_get_black_extra_seconds (_tmp28_);
		_tmp30_ = _tmp29_;
		black_extra = (guint) _tmp30_;
		_tmp31_ = self->priv->pgn_game;
		_tmp32_ = white_initial_time;
		_tmp33_ = white_used;
		_tmp34_ = white_extra;
		_tmp35_ = g_strdup_printf ("%u", (_tmp32_ - _tmp33_) + _tmp34_);
		_tmp36_ = _tmp35_;
		pgn_game_set_white_time_left (_tmp31_, _tmp36_);
		_g_free0 (_tmp36_);
		_tmp37_ = self->priv->pgn_game;
		_tmp38_ = black_initial_time;
		_tmp39_ = black_used;
		_tmp40_ = black_extra;
		_tmp41_ = g_strdup_printf ("%u", (_tmp38_ - _tmp39_) + _tmp40_);
		_tmp42_ = _tmp41_;
		pgn_game_set_black_time_left (_tmp37_, _tmp42_);
		_g_free0 (_tmp42_);
	}
}


static void chess_application_save_dialog_cb (ChessApplication* self, gint response_id) {
	gint _tmp0_ = 0;
	GtkFileChooserDialog* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		chess_application_update_pgn_time_remaining (self);
		{
			GtkFileChooserDialog* _tmp1_ = NULL;
			GFile* _tmp2_ = NULL;
			PGNGame* _tmp3_ = NULL;
			GFile* _tmp4_ = NULL;
			GtkHeaderBar* _tmp5_ = NULL;
			GFile* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			_tmp1_ = self->priv->save_dialog;
			_tmp2_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp1_);
			_g_object_unref0 (self->priv->game_file);
			self->priv->game_file = _tmp2_;
			_tmp3_ = self->priv->pgn_game;
			_tmp4_ = self->priv->game_file;
			pgn_game_write (_tmp3_, _tmp4_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch8_g_error;
			}
			_tmp5_ = self->priv->headerbar;
			_tmp6_ = self->priv->game_file;
			_tmp7_ = g_file_get_basename (_tmp6_);
			_tmp8_ = _tmp7_;
			gtk_header_bar_set_subtitle (_tmp5_, _tmp8_);
			_g_free0 (_tmp8_);
			chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
			self->priv->game_needs_saving = FALSE;
		}
		goto __finally8;
		__catch8_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			GtkLabel* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			GtkInfoBar* _tmp13_ = NULL;
			GtkInfoBar* _tmp14_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_warning ("gnome-chess.vala:2262: Failed to save game: %s", _tmp10_);
			_tmp11_ = self->priv->save_dialog_error_label;
			_tmp12_ = _ ("Failed to save game");
			gtk_label_set_text (_tmp11_, _tmp12_);
			_tmp13_ = self->priv->save_dialog_info_bar;
			gtk_info_bar_set_message_type (_tmp13_, GTK_MESSAGE_ERROR);
			_tmp14_ = self->priv->save_dialog_info_bar;
			gtk_widget_show ((GtkWidget*) _tmp14_);
			_g_error_free0 (e);
			return;
		}
		__finally8:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp15_ = self->priv->save_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp15_);
	_g_object_unref0 (self->priv->save_dialog);
	self->priv->save_dialog = NULL;
	_g_object_unref0 (self->priv->save_dialog_info_bar);
	self->priv->save_dialog_info_bar = NULL;
	_g_object_unref0 (self->priv->save_dialog_error_label);
	self->priv->save_dialog_error_label = NULL;
}


static void __lambda6_ (ChessApplication* self) {
	chess_application_save_dialog_cb (self, (gint) GTK_RESPONSE_OK);
}


static void ___lambda6__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self) {
	__lambda6_ ((ChessApplication*) self);
}


static void _chess_application_save_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	chess_application_save_dialog_cb ((ChessApplication*) self, response_id);
}


static void chess_application_present_save_dialog (ChessApplication* self, const gchar* cancel_button_label, const gchar* save_button_label) {
	GtkFileChooserDialog* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkApplicationWindow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkFileChooserDialog* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_ = NULL;
	GtkInfoBar* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkFileChooserDialog* _tmp12_ = NULL;
	GtkFileChooserDialog* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	GFile* _tmp15_ = NULL;
	GtkFileFilter* pgn_filter = NULL;
	GtkFileFilter* _tmp28_ = NULL;
	GtkFileFilter* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	GtkFileFilter* _tmp31_ = NULL;
	GtkFileChooserDialog* _tmp32_ = NULL;
	GtkFileFilter* _tmp33_ = NULL;
	GtkFileFilter* _tmp34_ = NULL;
	GtkFileFilter* all_filter = NULL;
	GtkFileFilter* _tmp35_ = NULL;
	GtkFileFilter* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	GtkFileFilter* _tmp38_ = NULL;
	GtkFileChooserDialog* _tmp39_ = NULL;
	GtkFileFilter* _tmp40_ = NULL;
	GtkFileFilter* _tmp41_ = NULL;
	GtkFileChooserDialog* _tmp42_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cancel_button_label != NULL);
	g_return_if_fail (save_button_label != NULL);
	_tmp0_ = self->priv->save_dialog;
	if (_tmp0_ != NULL) {
		GtkFileChooserDialog* _tmp1_ = NULL;
		_tmp1_ = self->priv->save_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp1_);
		return;
	}
	_tmp2_ = _ ("Save Chess Game");
	_tmp3_ = self->priv->window;
	_tmp4_ = cancel_button_label;
	_tmp5_ = _ (_tmp4_);
	_tmp6_ = save_button_label;
	_tmp7_ = _ (_tmp6_);
	_tmp8_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp2_, (GtkWindow*) _tmp3_, GTK_FILE_CHOOSER_ACTION_SAVE, _tmp5_, GTK_RESPONSE_CANCEL, _tmp7_, GTK_RESPONSE_OK, NULL, NULL);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->save_dialog);
	self->priv->save_dialog = _tmp8_;
	_tmp9_ = self->priv->save_dialog;
	chess_application_add_info_bar_to_dialog (self, (GtkDialog*) _tmp9_, &_tmp10_, &_tmp11_);
	_g_object_unref0 (self->priv->save_dialog_info_bar);
	self->priv->save_dialog_info_bar = _tmp10_;
	_g_object_unref0 (self->priv->save_dialog_error_label);
	self->priv->save_dialog_error_label = _tmp11_;
	_tmp12_ = self->priv->save_dialog;
	g_signal_connect_object ((GtkFileChooser*) _tmp12_, "file-activated", (GCallback) ___lambda6__gtk_file_chooser_file_activated, self, 0);
	_tmp13_ = self->priv->save_dialog;
	g_signal_connect_object ((GtkDialog*) _tmp13_, "response", (GCallback) _chess_application_save_dialog_cb_gtk_dialog_response, self, 0);
	_tmp15_ = self->priv->game_file;
	if (_tmp15_ != NULL) {
		GFile* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		_tmp16_ = self->priv->game_file;
		_tmp17_ = g_file_get_path (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->autosave_filename;
		_tmp14_ = g_strcmp0 (_tmp18_, _tmp19_) != 0;
		_g_free0 (_tmp18_);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		GtkFileChooserDialog* _tmp20_ = NULL;
		GFile* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		_tmp20_ = self->priv->save_dialog;
		_tmp21_ = self->priv->game_file;
		_tmp22_ = g_file_get_path (_tmp21_);
		_tmp23_ = _tmp22_;
		gtk_file_chooser_set_filename ((GtkFileChooser*) _tmp20_, _tmp23_);
		_g_free0 (_tmp23_);
	} else {
		GtkFileChooserDialog* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		_tmp24_ = self->priv->save_dialog;
		_tmp25_ = _ ("Untitled Chess Game");
		_tmp26_ = g_strconcat (_tmp25_, ".pgn", NULL);
		_tmp27_ = _tmp26_;
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp24_, _tmp27_);
		_g_free0 (_tmp27_);
	}
	_tmp28_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp28_);
	pgn_filter = _tmp28_;
	_tmp29_ = pgn_filter;
	_tmp30_ = _ ("PGN files");
	gtk_file_filter_set_name (_tmp29_, _tmp30_);
	_tmp31_ = pgn_filter;
	gtk_file_filter_add_pattern (_tmp31_, "*.pgn");
	_tmp32_ = self->priv->save_dialog;
	_tmp33_ = pgn_filter;
	_tmp34_ = _g_object_ref0 (_tmp33_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp32_, _tmp34_);
	_tmp35_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp35_);
	all_filter = _tmp35_;
	_tmp36_ = all_filter;
	_tmp37_ = _ ("All files");
	gtk_file_filter_set_name (_tmp36_, _tmp37_);
	_tmp38_ = all_filter;
	gtk_file_filter_add_pattern (_tmp38_, "*");
	_tmp39_ = self->priv->save_dialog;
	_tmp40_ = all_filter;
	_tmp41_ = _g_object_ref0 (_tmp40_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp39_, _tmp41_);
	_tmp42_ = self->priv->save_dialog;
	gtk_dialog_run ((GtkDialog*) _tmp42_);
	_g_object_unref0 (all_filter);
	_g_object_unref0 (pgn_filter);
}


void chess_application_save_game_cb (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game_file;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp2_ = self->priv->game_file;
		_tmp3_ = g_file_get_path (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->autosave_filename;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp5_) == 0;
		_g_free0 (_tmp4_);
	}
	if (_tmp0_) {
		chess_application_present_save_dialog (self, "_Cancel", "_Save");
		return;
	}
	chess_application_update_pgn_time_remaining (self);
	{
		PGNGame* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		_tmp6_ = self->priv->pgn_game;
		_tmp7_ = self->priv->game_file;
		pgn_game_write (_tmp6_, _tmp7_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		chess_application_present_save_dialog (self, "_Cancel", "_Save");
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void chess_application_save_game_as_cb (ChessApplication* self) {
	g_return_if_fail (self != NULL);
	chess_application_present_save_dialog (self, "_Cancel", "_Save");
}


static void __lambda9_ (ChessApplication* self) {
	chess_application_open_dialog_cb (self, (gint) GTK_RESPONSE_OK);
}


static void ___lambda9__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self) {
	__lambda9_ ((ChessApplication*) self);
}


static void _chess_application_open_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	chess_application_open_dialog_cb ((ChessApplication*) self, response_id);
}


void chess_application_open_game_cb (ChessApplication* self) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkFileChooserDialog* _tmp2_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkApplicationWindow* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkFileChooserDialog* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_ = NULL;
	GtkInfoBar* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkFileChooserDialog* _tmp12_ = NULL;
	GtkFileChooserDialog* _tmp13_ = NULL;
	GtkFileFilter* pgn_filter = NULL;
	GtkFileFilter* _tmp14_ = NULL;
	GtkFileFilter* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkFileFilter* _tmp17_ = NULL;
	GtkFileChooserDialog* _tmp18_ = NULL;
	GtkFileFilter* _tmp19_ = NULL;
	GtkFileFilter* _tmp20_ = NULL;
	GtkFileFilter* all_filter = NULL;
	GtkFileFilter* _tmp21_ = NULL;
	GtkFileFilter* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GtkFileFilter* _tmp24_ = NULL;
	GtkFileChooserDialog* _tmp25_ = NULL;
	GtkFileFilter* _tmp26_ = NULL;
	GtkFileFilter* _tmp27_ = NULL;
	GtkFileChooserDialog* _tmp28_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Save this game before loading another one?");
	_tmp1_ = chess_application_prompt_save_game (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->open_dialog;
	if (_tmp2_ != NULL) {
		GtkFileChooserDialog* _tmp3_ = NULL;
		_tmp3_ = self->priv->open_dialog;
		gtk_window_present ((GtkWindow*) _tmp3_);
		return;
	}
	_tmp4_ = _ ("Load Chess Game");
	_tmp5_ = self->priv->window;
	_tmp6_ = _ ("_Cancel");
	_tmp7_ = _ ("_Open");
	_tmp8_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp4_, (GtkWindow*) _tmp5_, GTK_FILE_CHOOSER_ACTION_OPEN, _tmp6_, GTK_RESPONSE_CANCEL, _tmp7_, GTK_RESPONSE_OK, NULL, NULL);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->open_dialog);
	self->priv->open_dialog = _tmp8_;
	_tmp9_ = self->priv->open_dialog;
	chess_application_add_info_bar_to_dialog (self, (GtkDialog*) _tmp9_, &_tmp10_, &_tmp11_);
	_g_object_unref0 (self->priv->open_dialog_info_bar);
	self->priv->open_dialog_info_bar = _tmp10_;
	_g_object_unref0 (self->priv->open_dialog_error_label);
	self->priv->open_dialog_error_label = _tmp11_;
	_tmp12_ = self->priv->open_dialog;
	g_signal_connect_object ((GtkFileChooser*) _tmp12_, "file-activated", (GCallback) ___lambda9__gtk_file_chooser_file_activated, self, 0);
	_tmp13_ = self->priv->open_dialog;
	g_signal_connect_object ((GtkDialog*) _tmp13_, "response", (GCallback) _chess_application_open_dialog_cb_gtk_dialog_response, self, 0);
	_tmp14_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp14_);
	pgn_filter = _tmp14_;
	_tmp15_ = pgn_filter;
	_tmp16_ = _ ("PGN files");
	gtk_file_filter_set_name (_tmp15_, _tmp16_);
	_tmp17_ = pgn_filter;
	gtk_file_filter_add_pattern (_tmp17_, "*.pgn");
	_tmp18_ = self->priv->open_dialog;
	_tmp19_ = pgn_filter;
	_tmp20_ = _g_object_ref0 (_tmp19_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp18_, _tmp20_);
	_tmp21_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp21_);
	all_filter = _tmp21_;
	_tmp22_ = all_filter;
	_tmp23_ = _ ("All files");
	gtk_file_filter_set_name (_tmp22_, _tmp23_);
	_tmp24_ = all_filter;
	gtk_file_filter_add_pattern (_tmp24_, "*");
	_tmp25_ = self->priv->open_dialog;
	_tmp26_ = all_filter;
	_tmp27_ = _g_object_ref0 (_tmp26_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp25_, _tmp27_);
	_tmp28_ = self->priv->open_dialog;
	gtk_window_present ((GtkWindow*) _tmp28_);
	_g_object_unref0 (all_filter);
	_g_object_unref0 (pgn_filter);
}


static void chess_application_open_dialog_cb (ChessApplication* self, gint response_id) {
	gint _tmp0_ = 0;
	GtkFileChooserDialog* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		{
			GtkFileChooserDialog* _tmp1_ = NULL;
			GFile* _tmp2_ = NULL;
			GFile* _tmp3_ = NULL;
			_tmp1_ = self->priv->open_dialog;
			_tmp2_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp1_);
			_g_object_unref0 (self->priv->game_file);
			self->priv->game_file = _tmp2_;
			_tmp3_ = self->priv->game_file;
			chess_application_load_game (self, _tmp3_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch10_g_error;
			}
		}
		goto __finally10;
		__catch10_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			GtkLabel* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			GtkInfoBar* _tmp8_ = NULL;
			GtkInfoBar* _tmp9_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_warning ("gnome-chess.vala:2393: Failed to open game: %s", _tmp5_);
			_tmp6_ = self->priv->open_dialog_error_label;
			_tmp7_ = _ ("Failed to open game");
			gtk_label_set_text (_tmp6_, _tmp7_);
			_tmp8_ = self->priv->open_dialog_info_bar;
			gtk_info_bar_set_message_type (_tmp8_, GTK_MESSAGE_ERROR);
			_tmp9_ = self->priv->open_dialog_info_bar;
			gtk_widget_show ((GtkWidget*) _tmp9_);
			_g_error_free0 (e);
			return;
		}
		__finally10:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp10_ = self->priv->open_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp10_);
	_g_object_unref0 (self->priv->open_dialog);
	self->priv->open_dialog = NULL;
	_g_object_unref0 (self->priv->open_dialog_info_bar);
	self->priv->open_dialog_info_bar = NULL;
	_g_object_unref0 (self->priv->open_dialog_error_label);
	self->priv->open_dialog_error_label = NULL;
}


static void chess_application_start_new_game (ChessApplication* self) {
	PGNGame* _tmp0_ = NULL;
	GDateTime* now = NULL;
	GDateTime* _tmp1_ = NULL;
	PGNGame* _tmp2_ = NULL;
	GDateTime* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	PGNGame* _tmp6_ = NULL;
	GDateTime* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gint duration = 0;
	GSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gchar* engine_name = NULL;
	GSettings* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	gchar* engine_level = NULL;
	GSettings* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	const gchar* _tmp38_ = NULL;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->game_file);
	self->priv->game_file = NULL;
	self->priv->allow_claim_draw_dialog = TRUE;
	chess_application_disable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
	chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
	_tmp0_ = pgn_game_new ();
	_g_object_unref0 (self->priv->pgn_game);
	self->priv->pgn_game = _tmp0_;
	_tmp1_ = g_date_time_new_now_local ();
	now = _tmp1_;
	_tmp2_ = self->priv->pgn_game;
	_tmp3_ = now;
	_tmp4_ = g_date_time_format (_tmp3_, "%Y.%m.%d");
	_tmp5_ = _tmp4_;
	pgn_game_set_date (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->pgn_game;
	_tmp7_ = now;
	_tmp8_ = g_date_time_format (_tmp7_, "%H:%M:%S");
	_tmp9_ = _tmp8_;
	pgn_game_set_time (_tmp6_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->settings;
	_tmp11_ = g_settings_get_int (_tmp10_, "duration");
	duration = _tmp11_;
	_tmp12_ = duration;
	if (_tmp12_ > 0) {
		PGNGame* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		PGNGame* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		PGNGame* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		_tmp13_ = self->priv->pgn_game;
		_tmp14_ = duration;
		_tmp15_ = g_strdup_printf ("%i", _tmp14_);
		_tmp16_ = _tmp15_;
		pgn_game_set_time_control (_tmp13_, _tmp16_);
		_g_free0 (_tmp16_);
		_tmp17_ = self->priv->pgn_game;
		_tmp18_ = duration;
		_tmp19_ = g_strdup_printf ("%i", _tmp18_);
		_tmp20_ = _tmp19_;
		pgn_game_set_white_time_left (_tmp17_, _tmp20_);
		_g_free0 (_tmp20_);
		_tmp21_ = self->priv->pgn_game;
		_tmp22_ = duration;
		_tmp23_ = g_strdup_printf ("%i", _tmp22_);
		_tmp24_ = _tmp23_;
		pgn_game_set_black_time_left (_tmp21_, _tmp24_);
		_g_free0 (_tmp24_);
	}
	_tmp25_ = self->priv->settings;
	_tmp26_ = g_settings_get_string (_tmp25_, "opponent");
	engine_name = _tmp26_;
	_tmp27_ = engine_name;
	if (g_strcmp0 (_tmp27_, "") == 0) {
		GList* _tmp28_ = NULL;
		_tmp28_ = self->priv->ai_profiles;
		if (_tmp28_ != NULL) {
			GList* _tmp29_ = NULL;
			gconstpointer _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			_tmp29_ = self->priv->ai_profiles;
			_tmp30_ = _tmp29_->data;
			_tmp31_ = ai_profile_get_name ((AIProfile*) _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strdup (_tmp32_);
			_g_free0 (engine_name);
			engine_name = _tmp33_;
		} else {
			gchar* _tmp34_ = NULL;
			_tmp34_ = g_strdup ("human");
			_g_free0 (engine_name);
			engine_name = _tmp34_;
		}
	}
	_tmp35_ = self->priv->settings;
	_tmp36_ = g_settings_get_string (_tmp35_, "difficulty");
	engine_level = _tmp36_;
	_tmp38_ = engine_name;
	if (_tmp38_ != NULL) {
		const gchar* _tmp39_ = NULL;
		_tmp39_ = engine_name;
		_tmp37_ = g_strcmp0 (_tmp39_, "human") != 0;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		GSettings* _tmp40_ = NULL;
		gboolean _tmp41_ = FALSE;
		_tmp40_ = self->priv->settings;
		_tmp41_ = g_settings_get_boolean (_tmp40_, "play-as-white");
		if (_tmp41_) {
			PGNGame* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			PGNGame* _tmp44_ = NULL;
			const gchar* _tmp45_ = NULL;
			_tmp42_ = self->priv->pgn_game;
			_tmp43_ = engine_name;
			pgn_game_set_black_ai (_tmp42_, _tmp43_);
			_tmp44_ = self->priv->pgn_game;
			_tmp45_ = engine_level;
			pgn_game_set_black_level (_tmp44_, _tmp45_);
		} else {
			PGNGame* _tmp46_ = NULL;
			const gchar* _tmp47_ = NULL;
			PGNGame* _tmp48_ = NULL;
			const gchar* _tmp49_ = NULL;
			_tmp46_ = self->priv->pgn_game;
			_tmp47_ = engine_name;
			pgn_game_set_white_ai (_tmp46_, _tmp47_);
			_tmp48_ = self->priv->pgn_game;
			_tmp49_ = engine_level;
			pgn_game_set_white_level (_tmp48_, _tmp49_);
		}
	}
	chess_application_start_game (self);
	_g_free0 (engine_level);
	_g_free0 (engine_name);
	_g_date_time_unref0 (now);
}


static void chess_application_load_game (ChessApplication* self, GFile* file, GError** error) {
	PGN* pgn = NULL;
	GFile* _tmp0_ = NULL;
	PGN* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	PGNGame* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	chess_application_enable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
	_tmp0_ = file;
	_tmp1_ = pgn_new_from_file (_tmp0_, &_inner_error_);
	pgn = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = pgn->games;
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
	_tmp4_ = _g_object_ref0 ((PGNGame*) _tmp3_);
	_g_object_unref0 (self->priv->pgn_game);
	self->priv->pgn_game = _tmp4_;
	_tmp5_ = file;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->game_file);
	self->priv->game_file = _tmp6_;
	chess_application_start_game (self);
	_g_object_unref0 (pgn);
}


static void chess_application_enable_window_action (ChessApplication* self, const gchar* name) {
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = name;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp0_, _tmp1_);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_simple_action_get_type (), GSimpleAction), TRUE);
}


static void chess_application_disable_window_action (ChessApplication* self, const gchar* name) {
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = name;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp0_, _tmp1_);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_simple_action_get_type (), GSimpleAction), FALSE);
}


gint chess_application_main (gchar** args, int args_length1) {
	gint result = 0;
	ChessApplication* _tmp0_ = NULL;
	ChessApplication* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	_tmp0_ = chess_application_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = args;
	_tmp2__length1 = args_length1;
	_tmp3_ = g_application_run ((GApplication*) _tmp1_, _tmp2__length1, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return chess_application_main (argv, argc);
}


static void chess_application_class_init (ChessApplicationClass * klass) {
	chess_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessApplicationPrivate));
	((GApplicationClass *) klass)->handle_local_options = chess_application_real_handle_local_options;
	((GApplicationClass *) klass)->open = chess_application_real_open;
	((GApplicationClass *) klass)->startup = chess_application_real_startup;
	((GApplicationClass *) klass)->shutdown = chess_application_real_shutdown;
	((GApplicationClass *) klass)->activate = chess_application_real_activate;
	G_OBJECT_CLASS (klass)->finalize = chess_application_finalize;
}


static void chess_application_instance_init (ChessApplication * self) {
	self->priv = CHESS_APPLICATION_GET_PRIVATE (self);
	self->priv->preferences_dialog = NULL;
	self->priv->save_duration_timeout = (guint) 0;
	self->priv->open_dialog = NULL;
	self->priv->open_dialog_info_bar = NULL;
	self->priv->open_dialog_error_label = NULL;
	self->priv->save_dialog = NULL;
	self->priv->save_dialog_info_bar = NULL;
	self->priv->save_dialog_error_label = NULL;
	self->priv->about_dialog = NULL;
	self->priv->game_needs_saving = FALSE;
	self->priv->allow_claim_draw_dialog = TRUE;
	self->priv->starting = TRUE;
	self->priv->opponent = NULL;
	self->priv->human_player = NULL;
	self->priv->opponent_engine = NULL;
}


static void chess_application_finalize (GObject* obj) {
	ChessApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_APPLICATION, ChessApplication);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->builder);
	_g_object_unref0 (self->priv->preferences_builder);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->view_container);
	_g_object_unref0 (self->priv->scene);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->pause_resume_button);
	_g_object_unref0 (self->priv->first_move_button);
	_g_object_unref0 (self->priv->prev_move_button);
	_g_object_unref0 (self->priv->next_move_button);
	_g_object_unref0 (self->priv->last_move_button);
	_g_object_unref0 (self->priv->history_combo);
	_g_object_unref0 (self->priv->white_time_label);
	_g_object_unref0 (self->priv->black_time_label);
	_g_object_unref0 (self->priv->timer_increment_label);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->side_combo);
	_g_object_unref0 (self->priv->difficulty_combo);
	_g_object_unref0 (self->priv->duration_combo);
	_g_object_unref0 (self->priv->clock_type_combo);
	_g_object_unref0 (self->priv->duration_adjustment);
	_g_object_unref0 (self->priv->timer_increment_adjustment);
	_g_object_unref0 (self->priv->custom_duration_box);
	_g_object_unref0 (self->priv->timer_increment_box);
	_g_object_unref0 (self->priv->timer_increment_units_combo);
	_g_object_unref0 (self->priv->custom_duration_units_combo);
	_g_object_unref0 (self->priv->open_dialog);
	_g_object_unref0 (self->priv->open_dialog_info_bar);
	_g_object_unref0 (self->priv->open_dialog_error_label);
	_g_object_unref0 (self->priv->save_dialog);
	_g_object_unref0 (self->priv->save_dialog_info_bar);
	_g_object_unref0 (self->priv->save_dialog_error_label);
	_g_object_unref0 (self->priv->about_dialog);
	_g_object_unref0 (self->priv->pgn_game);
	_g_object_unref0 (self->priv->game);
	_g_free0 (self->priv->autosave_filename);
	_g_object_unref0 (self->priv->game_file);
	__g_list_free__g_object_unref0_0 (self->priv->ai_profiles);
	_g_object_unref0 (self->priv->opponent);
	_g_object_unref0 (self->priv->human_player);
	_g_object_unref0 (self->priv->opponent_engine);
	G_OBJECT_CLASS (chess_application_parent_class)->finalize (obj);
}


GType chess_application_get_type (void) {
	static volatile gsize chess_application_type_id__volatile = 0;
	if (g_once_init_enter (&chess_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessApplication), 0, (GInstanceInitFunc) chess_application_instance_init, NULL };
		GType chess_application_type_id;
		chess_application_type_id = g_type_register_static (gtk_application_get_type (), "ChessApplication", &g_define_type_info, 0);
		g_once_init_leave (&chess_application_type_id__volatile, chess_application_type_id);
	}
	return chess_application_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



