/* taquin-game.c generated by valac 0.27.1.3-6129, the Vala compiler
 * generated from taquin-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2014 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of Taquin.
 *
 * Taquin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Taquin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Taquin. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>


#define TYPE_GAME_TYPE (game_type_get_type ())

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;

#define GAME_TYPE_UNDO_ITEM (game_undo_item_get_type ())
typedef struct _GameUndoItem GameUndoItem;
#define _game_undo_item_free0(var) ((var == NULL) ? NULL : (var = (game_undo_item_free (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	GAME_TYPE_FIFTEEN,
	GAME_TYPE_SIXTEEN
} GameType;

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GameUndoItem {
	gint x;
	gint y;
	GameUndoItem* next;
	GameUndoItem* previous;
};

struct _GamePrivate {
	gint* _tiles;
	gint _tiles_length1;
	gint _tiles_length2;
	gint _size;
	GameType _game_type;
	GameUndoItem* state;
	GameUndoItem* previous_state;
	gint x_gap;
	gint y_gap;
};


static gpointer game_parent_class = NULL;

GType game_type_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
static GType game_undo_item_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GameUndoItem* game_undo_item_dup (const GameUndoItem* self);
static void game_undo_item_free (GameUndoItem* self);
static void game_undo_item_copy (const GameUndoItem* self, GameUndoItem* dest);
static void game_undo_item_destroy (GameUndoItem* self);
#define GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME, GamePrivate))
enum  {
	GAME_DUMMY_PROPERTY,
	GAME_SIZE,
	GAME_GAME_TYPE
};
Game* game_new (GameType game_type, gint size);
Game* game_construct (GType object_type, GameType game_type, gint size);
static void game_set_size (Game* self, gint value);
static void game_set_game_type (Game* self, GameType value);
static void game_set_tiles (Game* self, gint* value, int value_length1, int value_length2);
static gint* _int_dup (gint* self);
gint* game_get_tiles (Game* self, int* result_length1, int* result_length2);
gchar* game_to_string (Game* self);
gint game_get_size (Game* self);
void game_request_move (Game* self, gint x, gint y);
GameType game_get_game_type (Game* self);
static void game_fifteen_move (Game* self, gint x, gint y, gboolean undoing);
static void game_sixteen_move (Game* self, gint x, gint y, gboolean undoing);
static void game_add_move (Game* self, gint x_gap, gint y_gap);
static void game_check_complete (Game* self);
void game_undo (Game* self);
static gint* _vala_array_dup1 (gint* self, int length);
static void g_cclosure_user_marshal_VOID__BOOLEAN_INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void game_finalize (GObject* obj);
static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType game_type_get_type (void) {
	static volatile gsize game_type_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_type_id__volatile)) {
		static const GEnumValue values[] = {{GAME_TYPE_FIFTEEN, "GAME_TYPE_FIFTEEN", "fifteen"}, {GAME_TYPE_SIXTEEN, "GAME_TYPE_SIXTEEN", "sixteen"}, {0, NULL, NULL}};
		GType game_type_type_id;
		game_type_type_id = g_enum_register_static ("GameType", values);
		g_once_init_leave (&game_type_type_id__volatile, game_type_type_id);
	}
	return game_type_type_id__volatile;
}


static gint* _int_dup (gint* self) {
	gint* dup;
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	dup = g_new0 (gint, 1);
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	memcpy (dup, self, sizeof (gint));
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return dup;
#line 148 "taquin-game.c"
}


static gpointer __int_dup0 (gpointer self) {
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return self ? _int_dup (self) : NULL;
#line 155 "taquin-game.c"
}


Game* game_construct (GType object_type, GameType game_type, gint size) {
	Game * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GameType _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint* _tmp5_ = NULL;
	gint* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp6__length2 = 0;
	gint ntiles = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint** line = NULL;
	gint _tmp9_ = 0;
	gint** _tmp10_ = NULL;
	gint line_length1 = 0;
	gint _line_size_ = 0;
	gint i = 0;
	GameType _tmp26_ = 0;
	gboolean parity_grid = FALSE;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gboolean parity_game = FALSE;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
#line 53 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = size;
#line 53 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_vala_return_val_if_fail (_tmp0_ >= 2, "size >= 2", NULL);
#line 53 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self = (Game*) g_object_new (object_type, NULL);
#line 56 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1_ = size;
#line 56 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	game_set_size (self, _tmp1_);
#line 57 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp2_ = game_type;
#line 57 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	game_set_game_type (self, _tmp2_);
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp3_ = size;
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp4_ = size;
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp5_ = g_new0 (gint, _tmp3_ * _tmp4_);
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp6_ = _tmp5_;
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp6__length1 = _tmp3_;
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp6__length2 = _tmp4_;
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	game_set_tiles (self, _tmp6_, _tmp3_, _tmp4_);
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp6_ = (g_free (_tmp6_), NULL);
#line 60 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp7_ = size;
#line 60 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp8_ = size;
#line 60 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	ntiles = _tmp7_ * _tmp8_;
#line 61 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp9_ = ntiles;
#line 61 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp10_ = g_new0 (gint*, _tmp9_);
#line 61 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	line = _tmp10_;
#line 61 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	line_length1 = _tmp9_;
#line 61 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_line_size_ = line_length1;
#line 62 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	i = 0;
#line 234 "taquin-game.c"
	{
		gint n = 0;
		gint _tmp11_ = 0;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp11_ = ntiles;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		n = _tmp11_ - 1;
#line 242 "taquin-game.c"
		{
			gboolean _tmp12_ = FALSE;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp12_ = TRUE;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			while (TRUE) {
#line 249 "taquin-game.c"
				gint _tmp14_ = 0;
				gint** _tmp21_ = NULL;
				gint _tmp21__length1 = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				gint* _tmp24_ = NULL;
				gint* _tmp25_ = NULL;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!_tmp12_) {
#line 259 "taquin-game.c"
					gint _tmp13_ = 0;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp13_ = n;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					n = _tmp13_ - 1;
#line 265 "taquin-game.c"
				}
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp12_ = FALSE;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp14_ = n;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!(_tmp14_ >= 0)) {
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					break;
#line 275 "taquin-game.c"
				}
				{
					gboolean _tmp15_ = FALSE;
#line 65 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp15_ = TRUE;
#line 65 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					while (TRUE) {
#line 283 "taquin-game.c"
						gint _tmp19_ = 0;
						gint32 _tmp20_ = 0;
#line 65 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!_tmp15_) {
#line 288 "taquin-game.c"
							gint** _tmp16_ = NULL;
							gint _tmp16__length1 = 0;
							gint _tmp17_ = 0;
							gint* _tmp18_ = NULL;
#line 65 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp16_ = line;
#line 65 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp16__length1 = line_length1;
#line 65 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp17_ = i;
#line 65 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp18_ = _tmp16_[_tmp17_];
#line 65 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							if (!(_tmp18_ != NULL)) {
#line 65 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
								break;
#line 305 "taquin-game.c"
							}
						}
#line 65 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp15_ = FALSE;
#line 65 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp19_ = ntiles;
#line 65 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp20_ = g_random_int_range ((gint32) 0, (gint32) _tmp19_);
#line 65 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						i = (gint) _tmp20_;
#line 316 "taquin-game.c"
					}
				}
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp21_ = line;
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp21__length1 = line_length1;
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp22_ = i;
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp23_ = n;
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp24_ = __int_dup0 (&_tmp23_);
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_g_free0 (_tmp21_[_tmp22_]);
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp21_[_tmp22_] = _tmp24_;
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp25_ = _tmp21_[_tmp22_];
#line 335 "taquin-game.c"
			}
		}
	}
#line 69 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp26_ = game_type;
#line 69 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp26_ == GAME_TYPE_FIFTEEN) {
#line 343 "taquin-game.c"
		gint** _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		gint _tmp28_ = 0;
		gint** _tmp29_ = NULL;
		gint _tmp29__length1 = 0;
		gint* _tmp30_ = NULL;
		gint* _tmp31_ = NULL;
		gint* _tmp32_ = NULL;
		gint** _tmp33_ = NULL;
		gint _tmp33__length1 = 0;
		gint _tmp34_ = 0;
		gint* _tmp35_ = NULL;
		gint* _tmp36_ = NULL;
#line 72 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp27_ = line;
#line 72 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp27__length1 = line_length1;
#line 72 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp28_ = i;
#line 72 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp29_ = line;
#line 72 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp29__length1 = line_length1;
#line 72 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp30_ = _tmp29_[0];
#line 72 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp31_ = __int_dup0 (_tmp30_);
#line 72 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_g_free0 (_tmp27_[_tmp28_]);
#line 72 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp27_[_tmp28_] = _tmp31_;
#line 72 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp32_ = _tmp27_[_tmp28_];
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp33_ = line;
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp33__length1 = line_length1;
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp34_ = -1;
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp35_ = __int_dup0 (&_tmp34_);
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_g_free0 (_tmp33_[0]);
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp33_[0] = _tmp35_;
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp36_ = _tmp33_[0];
#line 74 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		self->priv->x_gap = 0;
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		self->priv->y_gap = 0;
#line 395 "taquin-game.c"
	}
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp37_ = size;
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp38_ = size;
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	parity_grid = ((gboolean) ((_tmp37_ % 2) ^ (_tmp38_ % 2))) & (1 == 0);
#line 80 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	parity_game = FALSE;
#line 405 "taquin-game.c"
	{
		gint j = 0;
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		j = 0;
#line 410 "taquin-game.c"
		{
			gboolean _tmp39_ = FALSE;
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp39_ = TRUE;
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			while (TRUE) {
#line 417 "taquin-game.c"
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!_tmp39_) {
#line 422 "taquin-game.c"
					gint _tmp40_ = 0;
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp40_ = j;
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					j = _tmp40_ + 1;
#line 428 "taquin-game.c"
				}
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp39_ = FALSE;
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp41_ = j;
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp42_ = ntiles;
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!(_tmp41_ < (_tmp42_ - 1))) {
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					break;
#line 440 "taquin-game.c"
				}
				{
					gint k = 0;
					gint _tmp43_ = 0;
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp43_ = j;
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					k = _tmp43_ + 1;
#line 449 "taquin-game.c"
					{
						gboolean _tmp44_ = FALSE;
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp44_ = TRUE;
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						while (TRUE) {
#line 456 "taquin-game.c"
							gint _tmp46_ = 0;
							gint _tmp47_ = 0;
							gint** _tmp48_ = NULL;
							gint _tmp48__length1 = 0;
							gint _tmp49_ = 0;
							gint* _tmp50_ = NULL;
							gint** _tmp51_ = NULL;
							gint _tmp51__length1 = 0;
							gint _tmp52_ = 0;
							gint* _tmp53_ = NULL;
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							if (!_tmp44_) {
#line 469 "taquin-game.c"
								gint _tmp45_ = 0;
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
								_tmp45_ = k;
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
								k = _tmp45_ + 1;
#line 475 "taquin-game.c"
							}
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp44_ = FALSE;
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp46_ = k;
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp47_ = ntiles;
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							if (!(_tmp46_ < _tmp47_)) {
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
								break;
#line 487 "taquin-game.c"
							}
#line 83 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp48_ = line;
#line 83 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp48__length1 = line_length1;
#line 83 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp49_ = j;
#line 83 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp50_ = _tmp48_[_tmp49_];
#line 83 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp51_ = line;
#line 83 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp51__length1 = line_length1;
#line 83 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp52_ = k;
#line 83 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp53_ = _tmp51_[_tmp52_];
#line 83 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							if ((*_tmp50_) > (*_tmp53_)) {
#line 507 "taquin-game.c"
								gboolean _tmp54_ = FALSE;
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
								_tmp54_ = parity_game;
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
								parity_game = !_tmp54_;
#line 513 "taquin-game.c"
							}
						}
					}
				}
			}
		}
	}
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp55_ = parity_game;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp56_ = parity_grid;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp55_ != _tmp56_) {
#line 527 "taquin-game.c"
		gint* save = NULL;
		gint** _tmp57_ = NULL;
		gint _tmp57__length1 = 0;
		gint* _tmp58_ = NULL;
		gint* _tmp59_ = NULL;
		gint** _tmp60_ = NULL;
		gint _tmp60__length1 = 0;
		gint** _tmp61_ = NULL;
		gint _tmp61__length1 = 0;
		gint _tmp62_ = 0;
		gint* _tmp63_ = NULL;
		gint* _tmp64_ = NULL;
		gint* _tmp65_ = NULL;
		gint** _tmp66_ = NULL;
		gint _tmp66__length1 = 0;
		gint _tmp67_ = 0;
		gint* _tmp68_ = NULL;
		gint* _tmp69_ = NULL;
		gint* _tmp70_ = NULL;
#line 88 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp57_ = line;
#line 88 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp57__length1 = line_length1;
#line 88 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp58_ = _tmp57_[1];
#line 88 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp59_ = __int_dup0 (_tmp58_);
#line 88 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		save = _tmp59_;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp60_ = line;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp60__length1 = line_length1;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp61_ = line;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp61__length1 = line_length1;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp62_ = size;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp63_ = _tmp61_[_tmp62_ + 1];
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp64_ = __int_dup0 (_tmp63_);
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_g_free0 (_tmp60_[1]);
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp60_[1] = _tmp64_;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp65_ = _tmp60_[1];
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp66_ = line;
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp66__length1 = line_length1;
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp67_ = size;
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp68_ = save;
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp69_ = __int_dup0 (_tmp68_);
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_g_free0 (_tmp66_[_tmp67_ + 1]);
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp66_[_tmp67_ + 1] = _tmp69_;
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp70_ = _tmp66_[_tmp67_ + 1];
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_g_free0 (save);
#line 595 "taquin-game.c"
	}
	{
		gint j = 0;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		j = 0;
#line 601 "taquin-game.c"
		{
			gboolean _tmp71_ = FALSE;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp71_ = TRUE;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			while (TRUE) {
#line 608 "taquin-game.c"
				gint _tmp73_ = 0;
				gint _tmp74_ = 0;
				gint* _tmp75_ = NULL;
				gint _tmp75__length1 = 0;
				gint _tmp75__length2 = 0;
				gint* _tmp76_ = NULL;
				gint _tmp76__length1 = 0;
				gint _tmp76__length2 = 0;
				gint _tmp77_ = 0;
				gint _tmp78_ = 0;
				gint _tmp79_ = 0;
				gint _tmp80_ = 0;
				gint** _tmp81_ = NULL;
				gint _tmp81__length1 = 0;
				gint _tmp82_ = 0;
				gint* _tmp83_ = NULL;
				gint _tmp84_ = 0;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!_tmp71_) {
#line 628 "taquin-game.c"
					gint _tmp72_ = 0;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp72_ = j;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					j = _tmp72_ + 1;
#line 634 "taquin-game.c"
				}
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp71_ = FALSE;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp73_ = j;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp74_ = ntiles;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!(_tmp73_ < _tmp74_)) {
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					break;
#line 646 "taquin-game.c"
				}
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp75_ = game_get_tiles (self, &_tmp75__length1, &_tmp75__length2);
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp76_ = _tmp75_;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp76__length1 = _tmp75__length1;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp76__length2 = _tmp75__length2;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp77_ = j;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp78_ = size;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp79_ = j;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp80_ = size;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp81_ = line;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp81__length1 = line_length1;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp82_ = j;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp83_ = _tmp81_[_tmp82_];
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp76_[((_tmp77_ % _tmp78_) * _tmp76__length2) + (_tmp79_ / _tmp80_)] = *_tmp83_;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp84_ = _tmp76_[((_tmp77_ % _tmp78_) * _tmp76__length2) + (_tmp79_ / _tmp80_)];
#line 676 "taquin-game.c"
			}
		}
	}
#line 53 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	line = (_vala_array_free (line, line_length1, (GDestroyNotify) g_free), NULL);
#line 53 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return self;
#line 684 "taquin-game.c"
}


Game* game_new (GameType game_type, gint size) {
#line 53 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return game_construct (TYPE_GAME, game_type, size);
#line 691 "taquin-game.c"
}


gchar* game_to_string (Game* self) {
	gchar* result = NULL;
	gchar* s = NULL;
	gchar* _tmp0_ = NULL;
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = g_strdup ("\n");
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	s = _tmp0_;
#line 705 "taquin-game.c"
	{
		gint x = 0;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		x = 0;
#line 710 "taquin-game.c"
		{
			gboolean _tmp1_ = FALSE;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp1_ = TRUE;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			while (TRUE) {
#line 717 "taquin-game.c"
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!_tmp1_) {
#line 724 "taquin-game.c"
					gint _tmp2_ = 0;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp2_ = x;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					x = _tmp2_ + 1;
#line 730 "taquin-game.c"
				}
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp1_ = FALSE;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp3_ = x;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp4_ = self->priv->_size;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!(_tmp3_ < _tmp4_)) {
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					break;
#line 742 "taquin-game.c"
				}
				{
					gint y = 0;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					y = 0;
#line 748 "taquin-game.c"
					{
						gboolean _tmp5_ = FALSE;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp5_ = TRUE;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						while (TRUE) {
#line 755 "taquin-game.c"
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							const gchar* _tmp9_ = NULL;
							gint* _tmp10_ = NULL;
							gint _tmp10__length1 = 0;
							gint _tmp10__length2 = 0;
							gint* _tmp11_ = NULL;
							gint _tmp11__length1 = 0;
							gint _tmp11__length2 = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gchar* _tmp15_ = NULL;
							gchar* _tmp16_ = NULL;
							gchar* _tmp17_ = NULL;
							gchar* _tmp18_ = NULL;
							gchar* _tmp19_ = NULL;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							if (!_tmp5_) {
#line 775 "taquin-game.c"
								gint _tmp6_ = 0;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
								_tmp6_ = y;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
								y = _tmp6_ + 1;
#line 781 "taquin-game.c"
							}
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp5_ = FALSE;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp7_ = y;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp8_ = self->priv->_size;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							if (!(_tmp7_ < _tmp8_)) {
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
								break;
#line 793 "taquin-game.c"
							}
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp9_ = s;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp10_ = game_get_tiles (self, &_tmp10__length1, &_tmp10__length2);
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp11_ = _tmp10_;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp11__length1 = _tmp10__length1;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp11__length2 = _tmp10__length2;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp12_ = y;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp13_ = x;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp14_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp15_ = g_strdup_printf ("%i", _tmp14_ + 1);
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp16_ = _tmp15_;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp17_ = g_strconcat (" ", _tmp16_, NULL);
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp18_ = _tmp17_;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp19_ = g_strconcat (_tmp9_, _tmp18_, NULL);
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_g_free0 (s);
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							s = _tmp19_;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_g_free0 (_tmp18_);
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_g_free0 (_tmp16_);
#line 829 "taquin-game.c"
						}
					}
				}
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp20_ = s;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp21_ = g_strconcat (_tmp20_, "\n", NULL);
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_g_free0 (s);
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				s = _tmp21_;
#line 841 "taquin-game.c"
			}
		}
	}
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	result = s;
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return result;
#line 849 "taquin-game.c"
}


void game_request_move (Game* self, gint x, gint y) {
	GameType _tmp0_ = 0;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (self != NULL);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = self->priv->_game_type;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp0_ == GAME_TYPE_FIFTEEN) {
#line 861 "taquin-game.c"
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp1_ = x;
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp2_ = y;
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		game_fifteen_move (self, _tmp1_, _tmp2_, FALSE);
#line 870 "taquin-game.c"
	} else {
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp3_ = x;
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp4_ = y;
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		game_sixteen_move (self, _tmp3_, _tmp4_, FALSE);
#line 880 "taquin-game.c"
	}
}


static void game_fifteen_move (Game* self, gint x, gint y, gboolean undoing) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gboolean move_x_axis = FALSE;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gboolean _tmp24_ = FALSE;
	gint move_number = 0;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gint* _tmp93_ = NULL;
	gint _tmp93__length1 = 0;
	gint _tmp93__length2 = 0;
	gint* _tmp94_ = NULL;
	gint _tmp94__length1 = 0;
	gint _tmp94__length2 = 0;
	gint _tmp95_ = 0;
	gint _tmp96_ = 0;
	gint _tmp97_ = 0;
	gboolean _tmp98_ = FALSE;
	gint _tmp99_ = 0;
	gint _tmp100_ = 0;
	gint _tmp101_ = 0;
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (self != NULL);
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp3_ = x;
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp3_ < 0) {
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp2_ = TRUE;
#line 925 "taquin-game.c"
	} else {
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp4_ = x;
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp5_ = self->priv->_size;
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp2_ = _tmp4_ >= _tmp5_;
#line 935 "taquin-game.c"
	}
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp2_) {
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp1_ = TRUE;
#line 941 "taquin-game.c"
	} else {
		gint _tmp6_ = 0;
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp6_ = y;
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp1_ = _tmp6_ < 0;
#line 948 "taquin-game.c"
	}
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp1_) {
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp0_ = TRUE;
#line 954 "taquin-game.c"
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp7_ = y;
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp8_ = self->priv->_size;
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp0_ = _tmp7_ >= _tmp8_;
#line 964 "taquin-game.c"
	}
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp0_) {
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		return;
#line 970 "taquin-game.c"
	}
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp10_ = x;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp11_ = self->priv->x_gap;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp10_ == _tmp11_) {
#line 978 "taquin-game.c"
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp12_ = y;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp13_ = self->priv->y_gap;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp9_ = _tmp12_ == _tmp13_;
#line 987 "taquin-game.c"
	} else {
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp9_ = FALSE;
#line 991 "taquin-game.c"
	}
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp9_) {
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		g_signal_emit_by_name (self, "empty-tile");
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		return;
#line 999 "taquin-game.c"
	}
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp15_ = x;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp16_ = self->priv->x_gap;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp15_ != _tmp16_) {
#line 1007 "taquin-game.c"
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp17_ = y;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp18_ = self->priv->y_gap;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp14_ = _tmp17_ != _tmp18_;
#line 1016 "taquin-game.c"
	} else {
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp14_ = FALSE;
#line 1020 "taquin-game.c"
	}
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp14_) {
#line 1024 "taquin-game.c"
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp19_ = x;
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp20_ = y;
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		g_signal_emit_by_name (self, "cannot-move", _tmp19_, _tmp20_);
#line 137 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		return;
#line 1035 "taquin-game.c"
	}
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp21_ = x;
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp22_ = self->priv->x_gap;
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	move_x_axis = _tmp21_ != _tmp22_;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp24_ = move_x_axis;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp24_) {
#line 1047 "taquin-game.c"
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp25_ = self->priv->x_gap;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp26_ = x;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp23_ = _tmp25_ - _tmp26_;
#line 1056 "taquin-game.c"
	} else {
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp27_ = self->priv->y_gap;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp28_ = y;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp23_ = _tmp27_ - _tmp28_;
#line 1066 "taquin-game.c"
	}
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	move_number = _tmp23_;
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp29_ = undoing;
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (!_tmp29_) {
#line 1074 "taquin-game.c"
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp30_ = self->priv->x_gap;
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp31_ = self->priv->y_gap;
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		game_add_move (self, _tmp30_, _tmp31_);
#line 1083 "taquin-game.c"
	}
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp32_ = move_x_axis;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp32_) {
#line 1089 "taquin-game.c"
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp33_ = x;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp34_ = self->priv->x_gap;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp33_ < _tmp34_) {
#line 1098 "taquin-game.c"
			{
				gboolean _tmp35_ = FALSE;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp35_ = TRUE;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				while (TRUE) {
#line 1105 "taquin-game.c"
					gint* _tmp38_ = NULL;
					gint _tmp38__length1 = 0;
					gint _tmp38__length2 = 0;
					gint* _tmp39_ = NULL;
					gint _tmp39__length1 = 0;
					gint _tmp39__length2 = 0;
					gint _tmp40_ = 0;
					gint _tmp41_ = 0;
					gint* _tmp42_ = NULL;
					gint _tmp42__length1 = 0;
					gint _tmp42__length2 = 0;
					gint* _tmp43_ = NULL;
					gint _tmp43__length1 = 0;
					gint _tmp43__length2 = 0;
					gint _tmp44_ = 0;
					gint _tmp45_ = 0;
					gint _tmp46_ = 0;
					gint _tmp47_ = 0;
					gint _tmp48_ = 0;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					if (!_tmp35_) {
#line 1127 "taquin-game.c"
						gint _tmp36_ = 0;
						gint _tmp37_ = 0;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp36_ = self->priv->x_gap;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp37_ = x;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!(_tmp36_ != _tmp37_)) {
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							break;
#line 1138 "taquin-game.c"
						}
					}
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp35_ = FALSE;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp38_ = game_get_tiles (self, &_tmp38__length1, &_tmp38__length2);
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp39_ = _tmp38_;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp39__length1 = _tmp38__length1;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp39__length2 = _tmp38__length2;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp40_ = self->priv->x_gap;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp41_ = y;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp42_ = game_get_tiles (self, &_tmp42__length1, &_tmp42__length2);
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp43_ = _tmp42_;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp43__length1 = _tmp42__length1;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp43__length2 = _tmp42__length2;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp44_ = self->priv->x_gap;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp45_ = y;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp46_ = _tmp43_[((_tmp44_ - 1) * _tmp43__length2) + _tmp45_];
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp39_[(_tmp40_ * _tmp39__length2) + _tmp41_] = _tmp46_;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp47_ = _tmp39_[(_tmp40_ * _tmp39__length2) + _tmp41_];
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp48_ = self->priv->x_gap;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					self->priv->x_gap = _tmp48_ - 1;
#line 1177 "taquin-game.c"
				}
			}
		} else {
			{
				gboolean _tmp49_ = FALSE;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp49_ = TRUE;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				while (TRUE) {
#line 1187 "taquin-game.c"
					gint* _tmp52_ = NULL;
					gint _tmp52__length1 = 0;
					gint _tmp52__length2 = 0;
					gint* _tmp53_ = NULL;
					gint _tmp53__length1 = 0;
					gint _tmp53__length2 = 0;
					gint _tmp54_ = 0;
					gint _tmp55_ = 0;
					gint* _tmp56_ = NULL;
					gint _tmp56__length1 = 0;
					gint _tmp56__length2 = 0;
					gint* _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp57__length2 = 0;
					gint _tmp58_ = 0;
					gint _tmp59_ = 0;
					gint _tmp60_ = 0;
					gint _tmp61_ = 0;
					gint _tmp62_ = 0;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					if (!_tmp49_) {
#line 1209 "taquin-game.c"
						gint _tmp50_ = 0;
						gint _tmp51_ = 0;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp50_ = self->priv->x_gap;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp51_ = x;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!(_tmp50_ != _tmp51_)) {
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							break;
#line 1220 "taquin-game.c"
						}
					}
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp49_ = FALSE;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp52_ = game_get_tiles (self, &_tmp52__length1, &_tmp52__length2);
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp53_ = _tmp52_;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp53__length1 = _tmp52__length1;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp53__length2 = _tmp52__length2;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp54_ = self->priv->x_gap;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp55_ = y;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp56_ = game_get_tiles (self, &_tmp56__length1, &_tmp56__length2);
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp57_ = _tmp56_;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp57__length1 = _tmp56__length1;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp57__length2 = _tmp56__length2;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp58_ = self->priv->x_gap;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp59_ = y;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp60_ = _tmp57_[((_tmp58_ + 1) * _tmp57__length2) + _tmp59_];
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp53_[(_tmp54_ * _tmp53__length2) + _tmp55_] = _tmp60_;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp61_ = _tmp53_[(_tmp54_ * _tmp53__length2) + _tmp55_];
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp62_ = self->priv->x_gap;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					self->priv->x_gap = _tmp62_ + 1;
#line 1259 "taquin-game.c"
				}
			}
		}
	} else {
		gint _tmp63_ = 0;
		gint _tmp64_ = 0;
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp63_ = y;
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp64_ = self->priv->y_gap;
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp63_ < _tmp64_) {
#line 1272 "taquin-game.c"
			{
				gboolean _tmp65_ = FALSE;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp65_ = TRUE;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				while (TRUE) {
#line 1279 "taquin-game.c"
					gint* _tmp68_ = NULL;
					gint _tmp68__length1 = 0;
					gint _tmp68__length2 = 0;
					gint* _tmp69_ = NULL;
					gint _tmp69__length1 = 0;
					gint _tmp69__length2 = 0;
					gint _tmp70_ = 0;
					gint _tmp71_ = 0;
					gint* _tmp72_ = NULL;
					gint _tmp72__length1 = 0;
					gint _tmp72__length2 = 0;
					gint* _tmp73_ = NULL;
					gint _tmp73__length1 = 0;
					gint _tmp73__length2 = 0;
					gint _tmp74_ = 0;
					gint _tmp75_ = 0;
					gint _tmp76_ = 0;
					gint _tmp77_ = 0;
					gint _tmp78_ = 0;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					if (!_tmp65_) {
#line 1301 "taquin-game.c"
						gint _tmp66_ = 0;
						gint _tmp67_ = 0;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp66_ = self->priv->y_gap;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp67_ = y;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!(_tmp66_ != _tmp67_)) {
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							break;
#line 1312 "taquin-game.c"
						}
					}
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp65_ = FALSE;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp68_ = game_get_tiles (self, &_tmp68__length1, &_tmp68__length2);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp69_ = _tmp68_;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp69__length1 = _tmp68__length1;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp69__length2 = _tmp68__length2;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp70_ = x;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp71_ = self->priv->y_gap;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp72_ = game_get_tiles (self, &_tmp72__length1, &_tmp72__length2);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp73_ = _tmp72_;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp73__length1 = _tmp72__length1;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp73__length2 = _tmp72__length2;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp74_ = x;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp75_ = self->priv->y_gap;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp76_ = _tmp73_[(_tmp74_ * _tmp73__length2) + (_tmp75_ - 1)];
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp69_[(_tmp70_ * _tmp69__length2) + _tmp71_] = _tmp76_;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp77_ = _tmp69_[(_tmp70_ * _tmp69__length2) + _tmp71_];
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp78_ = self->priv->y_gap;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					self->priv->y_gap = _tmp78_ - 1;
#line 1351 "taquin-game.c"
				}
			}
		} else {
			{
				gboolean _tmp79_ = FALSE;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp79_ = TRUE;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				while (TRUE) {
#line 1361 "taquin-game.c"
					gint* _tmp82_ = NULL;
					gint _tmp82__length1 = 0;
					gint _tmp82__length2 = 0;
					gint* _tmp83_ = NULL;
					gint _tmp83__length1 = 0;
					gint _tmp83__length2 = 0;
					gint _tmp84_ = 0;
					gint _tmp85_ = 0;
					gint* _tmp86_ = NULL;
					gint _tmp86__length1 = 0;
					gint _tmp86__length2 = 0;
					gint* _tmp87_ = NULL;
					gint _tmp87__length1 = 0;
					gint _tmp87__length2 = 0;
					gint _tmp88_ = 0;
					gint _tmp89_ = 0;
					gint _tmp90_ = 0;
					gint _tmp91_ = 0;
					gint _tmp92_ = 0;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					if (!_tmp79_) {
#line 1383 "taquin-game.c"
						gint _tmp80_ = 0;
						gint _tmp81_ = 0;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp80_ = self->priv->y_gap;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp81_ = y;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!(_tmp80_ != _tmp81_)) {
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							break;
#line 1394 "taquin-game.c"
						}
					}
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp79_ = FALSE;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp82_ = game_get_tiles (self, &_tmp82__length1, &_tmp82__length2);
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp83_ = _tmp82_;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp83__length1 = _tmp82__length1;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp83__length2 = _tmp82__length2;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp84_ = x;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp85_ = self->priv->y_gap;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp86_ = game_get_tiles (self, &_tmp86__length1, &_tmp86__length2);
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp87_ = _tmp86_;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp87__length1 = _tmp86__length1;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp87__length2 = _tmp86__length2;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp88_ = x;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp89_ = self->priv->y_gap;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp90_ = _tmp87_[(_tmp88_ * _tmp87__length2) + (_tmp89_ + 1)];
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp83_[(_tmp84_ * _tmp83__length2) + _tmp85_] = _tmp90_;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp91_ = _tmp83_[(_tmp84_ * _tmp83__length2) + _tmp85_];
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp92_ = self->priv->y_gap;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					self->priv->y_gap = _tmp92_ + 1;
#line 1433 "taquin-game.c"
				}
			}
		}
	}
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp93_ = game_get_tiles (self, &_tmp93__length1, &_tmp93__length2);
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp94_ = _tmp93_;
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp94__length1 = _tmp93__length1;
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp94__length2 = _tmp93__length2;
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp95_ = self->priv->x_gap;
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp96_ = self->priv->y_gap;
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp94_[(_tmp95_ * _tmp94__length2) + _tmp96_] = -1;
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp97_ = _tmp94_[(_tmp95_ * _tmp94__length2) + _tmp96_];
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp98_ = move_x_axis;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp99_ = move_number;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp100_ = self->priv->x_gap;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp101_ = self->priv->y_gap;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_signal_emit_by_name (self, "move", _tmp98_, _tmp99_, _tmp100_, _tmp101_);
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	game_check_complete (self);
#line 1466 "taquin-game.c"
}


static void game_sixteen_move (Game* self, gint x, gint y, gboolean undoing) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gboolean move_x_axis = FALSE;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_ = 0;
	gint new_coord = 0;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp122_ = FALSE;
	gint _tmp135_ = 0;
	gint _tmp136_ = 0;
	gint _tmp139_ = 0;
	gboolean _tmp140_ = FALSE;
	gint _tmp143_ = 0;
	gboolean _tmp144_ = FALSE;
	gboolean _tmp147_ = FALSE;
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (self != NULL);
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp3_ = x;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp3_ >= 0) {
#line 1494 "taquin-game.c"
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp4_ = x;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp5_ = self->priv->_size;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp2_ = _tmp4_ < _tmp5_;
#line 1503 "taquin-game.c"
	} else {
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp2_ = FALSE;
#line 1507 "taquin-game.c"
	}
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp2_) {
#line 1511 "taquin-game.c"
		gint _tmp6_ = 0;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp6_ = y;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp1_ = _tmp6_ >= 0;
#line 1517 "taquin-game.c"
	} else {
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp1_ = FALSE;
#line 1521 "taquin-game.c"
	}
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp1_) {
#line 1525 "taquin-game.c"
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp7_ = y;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp8_ = self->priv->_size;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp0_ = _tmp7_ < _tmp8_;
#line 1534 "taquin-game.c"
	} else {
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp0_ = FALSE;
#line 1538 "taquin-game.c"
	}
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp0_) {
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		return;
#line 1544 "taquin-game.c"
	}
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	move_x_axis = FALSE;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp10_ = x;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp10_ < 0) {
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp9_ = TRUE;
#line 1554 "taquin-game.c"
	} else {
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp11_ = x;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp12_ = self->priv->_size;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp9_ = _tmp11_ >= _tmp12_;
#line 1564 "taquin-game.c"
	}
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp9_) {
#line 1568 "taquin-game.c"
		gboolean _tmp13_ = FALSE;
		gint _tmp14_ = 0;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp14_ = y;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp14_ < 0) {
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp13_ = TRUE;
#line 1577 "taquin-game.c"
		} else {
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp15_ = y;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp16_ = self->priv->_size;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp13_ = _tmp15_ >= _tmp16_;
#line 1587 "taquin-game.c"
		}
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp13_) {
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			return;
#line 1593 "taquin-game.c"
		} else {
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			move_x_axis = TRUE;
#line 1597 "taquin-game.c"
		}
	} else {
		gboolean _tmp17_ = FALSE;
		gint _tmp18_ = 0;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp18_ = y;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp18_ >= 0) {
#line 1606 "taquin-game.c"
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp19_ = y;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp20_ = self->priv->_size;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp17_ = _tmp19_ < _tmp20_;
#line 1615 "taquin-game.c"
		} else {
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp17_ = FALSE;
#line 1619 "taquin-game.c"
		}
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp17_) {
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			return;
#line 1625 "taquin-game.c"
		}
	}
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	new_coord = 0;
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp21_ = move_x_axis;
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp21_) {
#line 1634 "taquin-game.c"
		gint _tmp22_ = 0;
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp22_ = x;
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp22_ < 0) {
#line 1640 "taquin-game.c"
			gint tmp = 0;
			gint* _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			gint _tmp23__length2 = 0;
			gint* _tmp24_ = NULL;
			gint _tmp24__length1 = 0;
			gint _tmp24__length2 = 0;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			gint* _tmp41_ = NULL;
			gint _tmp41__length1 = 0;
			gint _tmp41__length2 = 0;
			gint* _tmp42_ = NULL;
			gint _tmp42__length1 = 0;
			gint _tmp42__length2 = 0;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			gint _tmp45_ = 0;
			gint _tmp46_ = 0;
			gint _tmp47_ = 0;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp23_ = game_get_tiles (self, &_tmp23__length1, &_tmp23__length2);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp24_ = _tmp23_;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp24__length1 = _tmp23__length1;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp24__length2 = _tmp23__length2;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp25_ = y;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp26_ = _tmp24_[(0 * _tmp24__length2) + _tmp25_];
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			tmp = _tmp26_;
#line 1675 "taquin-game.c"
			{
				gint i = 0;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				i = 0;
#line 1680 "taquin-game.c"
				{
					gboolean _tmp27_ = FALSE;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp27_ = TRUE;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					while (TRUE) {
#line 1687 "taquin-game.c"
						gint _tmp29_ = 0;
						gint _tmp30_ = 0;
						gint* _tmp31_ = NULL;
						gint _tmp31__length1 = 0;
						gint _tmp31__length2 = 0;
						gint* _tmp32_ = NULL;
						gint _tmp32__length1 = 0;
						gint _tmp32__length2 = 0;
						gint _tmp33_ = 0;
						gint _tmp34_ = 0;
						gint* _tmp35_ = NULL;
						gint _tmp35__length1 = 0;
						gint _tmp35__length2 = 0;
						gint* _tmp36_ = NULL;
						gint _tmp36__length1 = 0;
						gint _tmp36__length2 = 0;
						gint _tmp37_ = 0;
						gint _tmp38_ = 0;
						gint _tmp39_ = 0;
						gint _tmp40_ = 0;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!_tmp27_) {
#line 1710 "taquin-game.c"
							gint _tmp28_ = 0;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp28_ = i;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							i = _tmp28_ + 1;
#line 1716 "taquin-game.c"
						}
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp27_ = FALSE;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp29_ = i;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp30_ = self->priv->_size;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!(_tmp29_ < (_tmp30_ - 1))) {
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							break;
#line 1728 "taquin-game.c"
						}
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp31_ = game_get_tiles (self, &_tmp31__length1, &_tmp31__length2);
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp32_ = _tmp31_;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp32__length1 = _tmp31__length1;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp32__length2 = _tmp31__length2;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp33_ = i;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp34_ = y;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp35_ = game_get_tiles (self, &_tmp35__length1, &_tmp35__length2);
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp36_ = _tmp35_;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp36__length1 = _tmp35__length1;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp36__length2 = _tmp35__length2;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp37_ = i;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp38_ = y;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp39_ = _tmp36_[((_tmp37_ + 1) * _tmp36__length2) + _tmp38_];
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_] = _tmp39_;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp40_ = _tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_];
#line 1760 "taquin-game.c"
					}
				}
			}
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp41_ = game_get_tiles (self, &_tmp41__length1, &_tmp41__length2);
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp42_ = _tmp41_;
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp42__length1 = _tmp41__length1;
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp42__length2 = _tmp41__length2;
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp43_ = self->priv->_size;
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp44_ = y;
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp45_ = tmp;
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp42_[((_tmp43_ - 1) * _tmp42__length2) + _tmp44_] = _tmp45_;
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp46_ = _tmp42_[((_tmp43_ - 1) * _tmp42__length2) + _tmp44_];
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp47_ = self->priv->_size;
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			new_coord = _tmp47_ - 1;
#line 1786 "taquin-game.c"
		} else {
			gint tmp = 0;
			gint* _tmp48_ = NULL;
			gint _tmp48__length1 = 0;
			gint _tmp48__length2 = 0;
			gint* _tmp49_ = NULL;
			gint _tmp49__length1 = 0;
			gint _tmp49__length2 = 0;
			gint _tmp50_ = 0;
			gint _tmp51_ = 0;
			gint _tmp52_ = 0;
			gint* _tmp67_ = NULL;
			gint _tmp67__length1 = 0;
			gint _tmp67__length2 = 0;
			gint* _tmp68_ = NULL;
			gint _tmp68__length1 = 0;
			gint _tmp68__length2 = 0;
			gint _tmp69_ = 0;
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp48_ = game_get_tiles (self, &_tmp48__length1, &_tmp48__length2);
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp49_ = _tmp48_;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp49__length1 = _tmp48__length1;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp49__length2 = _tmp48__length2;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp50_ = self->priv->_size;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp51_ = y;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp52_ = _tmp49_[((_tmp50_ - 1) * _tmp49__length2) + _tmp51_];
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			tmp = _tmp52_;
#line 1823 "taquin-game.c"
			{
				gint i = 0;
				gint _tmp53_ = 0;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp53_ = self->priv->_size;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				i = _tmp53_ - 1;
#line 1831 "taquin-game.c"
				{
					gboolean _tmp54_ = FALSE;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp54_ = TRUE;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					while (TRUE) {
#line 1838 "taquin-game.c"
						gint _tmp56_ = 0;
						gint* _tmp57_ = NULL;
						gint _tmp57__length1 = 0;
						gint _tmp57__length2 = 0;
						gint* _tmp58_ = NULL;
						gint _tmp58__length1 = 0;
						gint _tmp58__length2 = 0;
						gint _tmp59_ = 0;
						gint _tmp60_ = 0;
						gint* _tmp61_ = NULL;
						gint _tmp61__length1 = 0;
						gint _tmp61__length2 = 0;
						gint* _tmp62_ = NULL;
						gint _tmp62__length1 = 0;
						gint _tmp62__length2 = 0;
						gint _tmp63_ = 0;
						gint _tmp64_ = 0;
						gint _tmp65_ = 0;
						gint _tmp66_ = 0;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!_tmp54_) {
#line 1860 "taquin-game.c"
							gint _tmp55_ = 0;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp55_ = i;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							i = _tmp55_ - 1;
#line 1866 "taquin-game.c"
						}
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp54_ = FALSE;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp56_ = i;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!(_tmp56_ > 0)) {
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							break;
#line 1876 "taquin-game.c"
						}
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp57_ = game_get_tiles (self, &_tmp57__length1, &_tmp57__length2);
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp58_ = _tmp57_;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp58__length1 = _tmp57__length1;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp58__length2 = _tmp57__length2;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp59_ = i;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp60_ = y;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp61_ = game_get_tiles (self, &_tmp61__length1, &_tmp61__length2);
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp62_ = _tmp61_;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp62__length1 = _tmp61__length1;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp62__length2 = _tmp61__length2;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp63_ = i;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp64_ = y;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp65_ = _tmp62_[((_tmp63_ - 1) * _tmp62__length2) + _tmp64_];
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp58_[(_tmp59_ * _tmp58__length2) + _tmp60_] = _tmp65_;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp66_ = _tmp58_[(_tmp59_ * _tmp58__length2) + _tmp60_];
#line 1908 "taquin-game.c"
					}
				}
			}
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp67_ = game_get_tiles (self, &_tmp67__length1, &_tmp67__length2);
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp68_ = _tmp67_;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp68__length1 = _tmp67__length1;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp68__length2 = _tmp67__length2;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp69_ = y;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp70_ = tmp;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp68_[(0 * _tmp68__length2) + _tmp69_] = _tmp70_;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp71_ = _tmp68_[(0 * _tmp68__length2) + _tmp69_];
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			new_coord = 0;
#line 1930 "taquin-game.c"
		}
	} else {
		gint _tmp72_ = 0;
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp72_ = y;
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp72_ < 0) {
#line 1938 "taquin-game.c"
			gint tmp = 0;
			gint* _tmp73_ = NULL;
			gint _tmp73__length1 = 0;
			gint _tmp73__length2 = 0;
			gint* _tmp74_ = NULL;
			gint _tmp74__length1 = 0;
			gint _tmp74__length2 = 0;
			gint _tmp75_ = 0;
			gint _tmp76_ = 0;
			gint* _tmp91_ = NULL;
			gint _tmp91__length1 = 0;
			gint _tmp91__length2 = 0;
			gint* _tmp92_ = NULL;
			gint _tmp92__length1 = 0;
			gint _tmp92__length2 = 0;
			gint _tmp93_ = 0;
			gint _tmp94_ = 0;
			gint _tmp95_ = 0;
			gint _tmp96_ = 0;
			gint _tmp97_ = 0;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp73_ = game_get_tiles (self, &_tmp73__length1, &_tmp73__length2);
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp74_ = _tmp73_;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp74__length1 = _tmp73__length1;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp74__length2 = _tmp73__length2;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp75_ = x;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp76_ = _tmp74_[(_tmp75_ * _tmp74__length2) + 0];
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			tmp = _tmp76_;
#line 1973 "taquin-game.c"
			{
				gint i = 0;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				i = 0;
#line 1978 "taquin-game.c"
				{
					gboolean _tmp77_ = FALSE;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp77_ = TRUE;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					while (TRUE) {
#line 1985 "taquin-game.c"
						gint _tmp79_ = 0;
						gint _tmp80_ = 0;
						gint* _tmp81_ = NULL;
						gint _tmp81__length1 = 0;
						gint _tmp81__length2 = 0;
						gint* _tmp82_ = NULL;
						gint _tmp82__length1 = 0;
						gint _tmp82__length2 = 0;
						gint _tmp83_ = 0;
						gint _tmp84_ = 0;
						gint* _tmp85_ = NULL;
						gint _tmp85__length1 = 0;
						gint _tmp85__length2 = 0;
						gint* _tmp86_ = NULL;
						gint _tmp86__length1 = 0;
						gint _tmp86__length2 = 0;
						gint _tmp87_ = 0;
						gint _tmp88_ = 0;
						gint _tmp89_ = 0;
						gint _tmp90_ = 0;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!_tmp77_) {
#line 2008 "taquin-game.c"
							gint _tmp78_ = 0;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp78_ = i;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							i = _tmp78_ + 1;
#line 2014 "taquin-game.c"
						}
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp77_ = FALSE;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp79_ = i;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp80_ = self->priv->_size;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!(_tmp79_ < (_tmp80_ - 1))) {
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							break;
#line 2026 "taquin-game.c"
						}
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp81_ = game_get_tiles (self, &_tmp81__length1, &_tmp81__length2);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp82_ = _tmp81_;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp82__length1 = _tmp81__length1;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp82__length2 = _tmp81__length2;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp83_ = x;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp84_ = i;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp85_ = game_get_tiles (self, &_tmp85__length1, &_tmp85__length2);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp86_ = _tmp85_;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp86__length1 = _tmp85__length1;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp86__length2 = _tmp85__length2;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp87_ = x;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp88_ = i;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp89_ = _tmp86_[(_tmp87_ * _tmp86__length2) + (_tmp88_ + 1)];
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp82_[(_tmp83_ * _tmp82__length2) + _tmp84_] = _tmp89_;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp90_ = _tmp82_[(_tmp83_ * _tmp82__length2) + _tmp84_];
#line 2058 "taquin-game.c"
					}
				}
			}
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp91_ = game_get_tiles (self, &_tmp91__length1, &_tmp91__length2);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp92_ = _tmp91_;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp92__length1 = _tmp91__length1;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp92__length2 = _tmp91__length2;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp93_ = x;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp94_ = self->priv->_size;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp95_ = tmp;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp92_[(_tmp93_ * _tmp92__length2) + (_tmp94_ - 1)] = _tmp95_;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp96_ = _tmp92_[(_tmp93_ * _tmp92__length2) + (_tmp94_ - 1)];
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp97_ = self->priv->_size;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			new_coord = _tmp97_ - 1;
#line 2084 "taquin-game.c"
		} else {
			gint tmp = 0;
			gint* _tmp98_ = NULL;
			gint _tmp98__length1 = 0;
			gint _tmp98__length2 = 0;
			gint* _tmp99_ = NULL;
			gint _tmp99__length1 = 0;
			gint _tmp99__length2 = 0;
			gint _tmp100_ = 0;
			gint _tmp101_ = 0;
			gint _tmp102_ = 0;
			gint* _tmp117_ = NULL;
			gint _tmp117__length1 = 0;
			gint _tmp117__length2 = 0;
			gint* _tmp118_ = NULL;
			gint _tmp118__length1 = 0;
			gint _tmp118__length2 = 0;
			gint _tmp119_ = 0;
			gint _tmp120_ = 0;
			gint _tmp121_ = 0;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp98_ = game_get_tiles (self, &_tmp98__length1, &_tmp98__length2);
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp99_ = _tmp98_;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp99__length1 = _tmp98__length1;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp99__length2 = _tmp98__length2;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp100_ = x;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp101_ = self->priv->_size;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp102_ = _tmp99_[(_tmp100_ * _tmp99__length2) + (_tmp101_ - 1)];
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			tmp = _tmp102_;
#line 2121 "taquin-game.c"
			{
				gint i = 0;
				gint _tmp103_ = 0;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp103_ = self->priv->_size;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				i = _tmp103_ - 1;
#line 2129 "taquin-game.c"
				{
					gboolean _tmp104_ = FALSE;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp104_ = TRUE;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					while (TRUE) {
#line 2136 "taquin-game.c"
						gint _tmp106_ = 0;
						gint* _tmp107_ = NULL;
						gint _tmp107__length1 = 0;
						gint _tmp107__length2 = 0;
						gint* _tmp108_ = NULL;
						gint _tmp108__length1 = 0;
						gint _tmp108__length2 = 0;
						gint _tmp109_ = 0;
						gint _tmp110_ = 0;
						gint* _tmp111_ = NULL;
						gint _tmp111__length1 = 0;
						gint _tmp111__length2 = 0;
						gint* _tmp112_ = NULL;
						gint _tmp112__length1 = 0;
						gint _tmp112__length2 = 0;
						gint _tmp113_ = 0;
						gint _tmp114_ = 0;
						gint _tmp115_ = 0;
						gint _tmp116_ = 0;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!_tmp104_) {
#line 2158 "taquin-game.c"
							gint _tmp105_ = 0;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp105_ = i;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							i = _tmp105_ - 1;
#line 2164 "taquin-game.c"
						}
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp104_ = FALSE;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp106_ = i;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!(_tmp106_ > 0)) {
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							break;
#line 2174 "taquin-game.c"
						}
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp107_ = game_get_tiles (self, &_tmp107__length1, &_tmp107__length2);
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp108_ = _tmp107_;
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp108__length1 = _tmp107__length1;
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp108__length2 = _tmp107__length2;
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp109_ = x;
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp110_ = i;
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp111_ = game_get_tiles (self, &_tmp111__length1, &_tmp111__length2);
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp112_ = _tmp111_;
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp112__length1 = _tmp111__length1;
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp112__length2 = _tmp111__length2;
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp113_ = x;
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp114_ = i;
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp115_ = _tmp112_[(_tmp113_ * _tmp112__length2) + (_tmp114_ - 1)];
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp108_[(_tmp109_ * _tmp108__length2) + _tmp110_] = _tmp115_;
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp116_ = _tmp108_[(_tmp109_ * _tmp108__length2) + _tmp110_];
#line 2206 "taquin-game.c"
					}
				}
			}
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp117_ = game_get_tiles (self, &_tmp117__length1, &_tmp117__length2);
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp118_ = _tmp117_;
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp118__length1 = _tmp117__length1;
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp118__length2 = _tmp117__length2;
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp119_ = x;
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp120_ = tmp;
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp118_[(_tmp119_ * _tmp118__length2) + 0] = _tmp120_;
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp121_ = _tmp118_[(_tmp119_ * _tmp118__length2) + 0];
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			new_coord = 0;
#line 2228 "taquin-game.c"
		}
	}
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp122_ = undoing;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (!_tmp122_) {
#line 2235 "taquin-game.c"
		gint _tmp123_ = 0;
		gboolean _tmp124_ = FALSE;
		gint _tmp129_ = 0;
		gboolean _tmp130_ = FALSE;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp124_ = move_x_axis;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp124_) {
#line 2244 "taquin-game.c"
			gint _tmp125_ = 0;
			gint _tmp126_ = 0;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp126_ = new_coord;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			if (_tmp126_ == 0) {
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp125_ = -1;
#line 2253 "taquin-game.c"
			} else {
				gint _tmp127_ = 0;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp127_ = self->priv->_size;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp125_ = _tmp127_;
#line 2260 "taquin-game.c"
			}
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp123_ = _tmp125_;
#line 2264 "taquin-game.c"
		} else {
			gint _tmp128_ = 0;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp128_ = x;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp123_ = _tmp128_;
#line 2271 "taquin-game.c"
		}
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp130_ = move_x_axis;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp130_) {
#line 2277 "taquin-game.c"
			gint _tmp131_ = 0;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp131_ = y;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp129_ = _tmp131_;
#line 2283 "taquin-game.c"
		} else {
			gint _tmp132_ = 0;
			gint _tmp133_ = 0;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp133_ = new_coord;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			if (_tmp133_ == 0) {
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp132_ = -1;
#line 2293 "taquin-game.c"
			} else {
				gint _tmp134_ = 0;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp134_ = self->priv->_size;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp132_ = _tmp134_;
#line 2300 "taquin-game.c"
			}
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp129_ = _tmp132_;
#line 2304 "taquin-game.c"
		}
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		game_add_move (self, _tmp123_, _tmp129_);
#line 2308 "taquin-game.c"
	}
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp136_ = new_coord;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp136_ == 0) {
#line 2314 "taquin-game.c"
		gint _tmp137_ = 0;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp137_ = self->priv->_size;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp135_ = _tmp137_ - 1;
#line 2320 "taquin-game.c"
	} else {
		gint _tmp138_ = 0;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp138_ = self->priv->_size;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp135_ = 1 - _tmp138_;
#line 2327 "taquin-game.c"
	}
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp140_ = move_x_axis;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp140_) {
#line 2333 "taquin-game.c"
		gint _tmp141_ = 0;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp141_ = new_coord;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp139_ = _tmp141_;
#line 2339 "taquin-game.c"
	} else {
		gint _tmp142_ = 0;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp142_ = x;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp139_ = _tmp142_;
#line 2346 "taquin-game.c"
	}
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp144_ = move_x_axis;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp144_) {
#line 2352 "taquin-game.c"
		gint _tmp145_ = 0;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp145_ = y;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp143_ = _tmp145_;
#line 2358 "taquin-game.c"
	} else {
		gint _tmp146_ = 0;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp146_ = new_coord;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp143_ = _tmp146_;
#line 2365 "taquin-game.c"
	}
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp147_ = move_x_axis;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_signal_emit_by_name (self, "move", _tmp147_, _tmp135_, _tmp139_, _tmp143_);
#line 227 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	game_check_complete (self);
#line 2373 "taquin-game.c"
}


static void game_check_complete (Game* self) {
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (self != NULL);
#line 2380 "taquin-game.c"
	{
		gint i = 0;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		i = 1;
#line 2385 "taquin-game.c"
		{
			gboolean _tmp0_ = FALSE;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp0_ = TRUE;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			while (TRUE) {
#line 2392 "taquin-game.c"
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gint* _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp6__length2 = 0;
				gint* _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gint _tmp7__length2 = 0;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!_tmp0_) {
#line 2410 "taquin-game.c"
					gint _tmp1_ = 0;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp1_ = i;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					i = _tmp1_ + 1;
#line 2416 "taquin-game.c"
				}
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp0_ = FALSE;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp2_ = i;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp3_ = self->priv->_size;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp4_ = self->priv->_size;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!(_tmp2_ < (_tmp3_ * _tmp4_))) {
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					break;
#line 2430 "taquin-game.c"
				}
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp5_ = i;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp6_ = game_get_tiles (self, &_tmp6__length1, &_tmp6__length2);
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp7_ = _tmp6_;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp7__length1 = _tmp6__length1;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp7__length2 = _tmp6__length2;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp8_ = i;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp9_ = self->priv->_size;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp10_ = i;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp11_ = self->priv->_size;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp12_ = _tmp7_[((_tmp8_ % _tmp9_) * _tmp7__length2) + (_tmp10_ / _tmp11_)];
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (_tmp5_ != _tmp12_) {
#line 234 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					return;
#line 2456 "taquin-game.c"
				}
			}
		}
	}
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_signal_emit_by_name (self, "complete");
#line 2463 "taquin-game.c"
}


static gpointer _game_undo_item_dup0 (gpointer self) {
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return self ? game_undo_item_dup (self) : NULL;
#line 2470 "taquin-game.c"
}


void game_undo (Game* self) {
	GameUndoItem* _tmp0_ = NULL;
	GameType _tmp1_ = 0;
	GameUndoItem* _tmp10_ = NULL;
	GameUndoItem* _tmp11_ = NULL;
	GameUndoItem* _tmp12_ = NULL;
	GameUndoItem* _tmp13_ = NULL;
	GameUndoItem* _tmp16_ = NULL;
	GameUndoItem* _tmp17_ = NULL;
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (self != NULL);
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = self->priv->state;
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp0_ == NULL) {
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		return;
#line 2491 "taquin-game.c"
	}
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1_ = self->priv->_game_type;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp1_ == GAME_TYPE_FIFTEEN) {
#line 2497 "taquin-game.c"
		GameUndoItem* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		GameUndoItem* _tmp4_ = NULL;
		gint _tmp5_ = 0;
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp2_ = self->priv->state;
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp3_ = (*_tmp2_).x;
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp4_ = self->priv->state;
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp5_ = (*_tmp4_).y;
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		game_fifteen_move (self, _tmp3_, _tmp5_, TRUE);
#line 2512 "taquin-game.c"
	} else {
		GameUndoItem* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		GameUndoItem* _tmp8_ = NULL;
		gint _tmp9_ = 0;
#line 258 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp6_ = self->priv->state;
#line 258 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp7_ = (*_tmp6_).x;
#line 258 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp8_ = self->priv->state;
#line 258 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp9_ = (*_tmp8_).y;
#line 258 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		game_sixteen_move (self, _tmp7_, _tmp9_, TRUE);
#line 2528 "taquin-game.c"
	}
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp10_ = self->priv->previous_state;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp11_ = _game_undo_item_dup0 (_tmp10_);
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 (self->priv->state);
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->state = _tmp11_;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp13_ = self->priv->state;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp13_ == NULL) {
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp12_ = NULL;
#line 2544 "taquin-game.c"
	} else {
		GameUndoItem* _tmp14_ = NULL;
		GameUndoItem* _tmp15_ = NULL;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp14_ = self->priv->state;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp15_ = (*_tmp14_).previous;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp12_ = _tmp15_;
#line 2554 "taquin-game.c"
	}
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp16_ = _game_undo_item_dup0 (_tmp12_);
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 (self->priv->previous_state);
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->previous_state = _tmp16_;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp17_ = self->priv->state;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp17_ == NULL) {
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		g_signal_emit_by_name (self, "cannot-undo-more");
#line 2568 "taquin-game.c"
	}
}


static void game_add_move (Game* self, gint x_gap, gint y_gap) {
	GameUndoItem* _tmp0_ = NULL;
	GameUndoItem* _tmp1_ = NULL;
	GameUndoItem* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GameUndoItem* _tmp6_ = NULL;
	GameUndoItem* _tmp7_ = NULL;
	GameUndoItem _tmp8_ = {0};
	GameUndoItem _tmp9_ = {0};
	GameUndoItem* _tmp10_ = NULL;
	GameUndoItem* _tmp11_ = NULL;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (self != NULL);
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1_ = self->priv->state;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp1_ == NULL) {
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp0_ = NULL;
#line 2593 "taquin-game.c"
	} else {
		GameUndoItem* _tmp2_ = NULL;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp2_ = self->priv->state;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp0_ = _tmp2_;
#line 2600 "taquin-game.c"
	}
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp3_ = _game_undo_item_dup0 (_tmp0_);
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 (self->priv->previous_state);
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->previous_state = _tmp3_;
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp4_ = x_gap;
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp5_ = y_gap;
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp6_ = self->priv->previous_state;
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp7_ = _game_undo_item_dup0 (_tmp6_);
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	memset (&_tmp8_, 0, sizeof (GameUndoItem));
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp8_.x = _tmp4_;
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp8_.y = _tmp5_;
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 (_tmp8_.next);
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp8_.next = NULL;
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 (_tmp8_.previous);
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp8_.previous = _tmp7_;
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp9_ = _tmp8_;
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp10_ = _game_undo_item_dup0 (&_tmp9_);
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 (self->priv->state);
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->state = _tmp10_;
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	game_undo_item_destroy (&_tmp9_);
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp11_ = self->priv->previous_state;
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp11_ != NULL) {
#line 2644 "taquin-game.c"
		GameUndoItem* _tmp12_ = NULL;
		GameUndoItem* _tmp13_ = NULL;
		GameUndoItem* _tmp14_ = NULL;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp12_ = self->priv->previous_state;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp13_ = self->priv->state;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp14_ = _game_undo_item_dup0 (_tmp13_);
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_game_undo_item_free0 ((*_tmp12_).next);
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		(*_tmp12_).next = _tmp14_;
#line 2658 "taquin-game.c"
	}
}


gint* game_get_tiles (Game* self, int* result_length1, int* result_length2) {
	gint* result;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp1__length2 = 0;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = self->priv->_tiles;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0__length1 = self->priv->_tiles_length1;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0__length2 = self->priv->_tiles_length2;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1_ = _tmp0_;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1__length1 = _tmp0__length1;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1__length2 = _tmp0__length2;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (result_length1) {
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		*result_length1 = _tmp1__length1;
#line 2689 "taquin-game.c"
	}
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (result_length2) {
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		*result_length2 = _tmp1__length2;
#line 2695 "taquin-game.c"
	}
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	result = _tmp1_;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return result;
#line 2701 "taquin-game.c"
}


static gint* _vala_array_dup1 (gint* self, int length) {
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return g_memdup (self, length * sizeof (gint));
#line 2708 "taquin-game.c"
}


static void game_set_tiles (Game* self, gint* value, int value_length1, int value_length2) {
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp1__length2 = 0;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (self != NULL);
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = value;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0__length1 = value_length1;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0__length2 = value_length2;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1 * _tmp0__length2) : ((gpointer) _tmp0_);
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1__length1 = _tmp0__length1;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1__length2 = _tmp0__length2;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->_tiles = (g_free (self->priv->_tiles), NULL);
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->_tiles = _tmp1_;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->_tiles_length1 = _tmp1__length1;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->_tiles_length2 = _tmp1__length2;
#line 2741 "taquin-game.c"
}


gint game_get_size (Game* self) {
	gint result;
	gint _tmp0_ = 0;
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = self->priv->_size;
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	result = _tmp0_;
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return result;
#line 2756 "taquin-game.c"
}


static void game_set_size (Game* self, gint value) {
	gint _tmp0_ = 0;
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (self != NULL);
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = value;
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->_size = _tmp0_;
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_object_notify ((GObject *) self, "size");
#line 2770 "taquin-game.c"
}


GameType game_get_game_type (Game* self) {
	GameType result;
	GameType _tmp0_ = 0;
#line 32 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 32 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = self->priv->_game_type;
#line 32 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	result = _tmp0_;
#line 32 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return result;
#line 2785 "taquin-game.c"
}


static void game_set_game_type (Game* self, GameType value) {
	GameType _tmp0_ = 0;
#line 32 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (self != NULL);
#line 32 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = value;
#line 32 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->_game_type = _tmp0_;
#line 32 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_object_notify ((GObject *) self, "game-type");
#line 2799 "taquin-game.c"
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_INT_INT_INT) (gpointer data1, gboolean arg_1, gint arg_2, gint arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (n_param_values == 5);
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		data1 = closure->data;
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		data2 = param_values->data[0].v_pointer;
#line 2818 "taquin-game.c"
	} else {
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		data1 = param_values->data[0].v_pointer;
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		data2 = closure->data;
#line 2824 "taquin-game.c"
	}
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	callback = (GMarshalFunc_VOID__BOOLEAN_INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), data2);
#line 2830 "taquin-game.c"
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (n_param_values == 3);
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		data1 = closure->data;
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		data2 = param_values->data[0].v_pointer;
#line 2849 "taquin-game.c"
	} else {
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		data1 = param_values->data[0].v_pointer;
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		data2 = closure->data;
#line 2855 "taquin-game.c"
	}
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
#line 2861 "taquin-game.c"
}


static void game_undo_item_copy (const GameUndoItem* self, GameUndoItem* dest) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GameUndoItem* _tmp2_ = NULL;
	GameUndoItem* _tmp3_ = NULL;
	GameUndoItem* _tmp4_ = NULL;
	GameUndoItem* _tmp5_ = NULL;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = (*self).x;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	(*dest).x = _tmp0_;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1_ = (*self).y;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	(*dest).y = _tmp1_;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp2_ = (*self).next;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp3_ = _game_undo_item_dup0 (_tmp2_);
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 ((*dest).next);
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	(*dest).next = _tmp3_;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp4_ = (*self).previous;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp5_ = _game_undo_item_dup0 (_tmp4_);
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 ((*dest).previous);
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	(*dest).previous = _tmp5_;
#line 2896 "taquin-game.c"
}


static void game_undo_item_destroy (GameUndoItem* self) {
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 ((*self).next);
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 ((*self).previous);
#line 2905 "taquin-game.c"
}


static GameUndoItem* game_undo_item_dup (const GameUndoItem* self) {
	GameUndoItem* dup;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	dup = g_new0 (GameUndoItem, 1);
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	game_undo_item_copy (self, dup);
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return dup;
#line 2917 "taquin-game.c"
}


static void game_undo_item_free (GameUndoItem* self) {
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	game_undo_item_destroy (self);
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_free (self);
#line 2926 "taquin-game.c"
}


static GType game_undo_item_get_type (void) {
	static volatile gsize game_undo_item_type_id__volatile = 0;
	if (g_once_init_enter (&game_undo_item_type_id__volatile)) {
		GType game_undo_item_type_id;
		game_undo_item_type_id = g_boxed_type_register_static ("GameUndoItem", (GBoxedCopyFunc) game_undo_item_dup, (GBoxedFreeFunc) game_undo_item_free);
		g_once_init_leave (&game_undo_item_type_id__volatile, game_undo_item_type_id);
	}
	return game_undo_item_type_id__volatile;
}


static void game_class_init (GameClass * klass) {
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	game_parent_class = g_type_class_peek_parent (klass);
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_type_class_add_private (klass, sizeof (GamePrivate));
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_GAME_TYPE, g_param_spec_enum ("game-type", "game-type", "game-type", TYPE_GAME_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_signal_new ("complete", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_signal_new ("move", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_INT_INT_INT, G_TYPE_NONE, 4, G_TYPE_BOOLEAN, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_signal_new ("empty_tile", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_signal_new ("cannot_move", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_signal_new ("cannot_undo_more", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 2966 "taquin-game.c"
}


static void game_instance_init (Game * self) {
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv = GAME_GET_PRIVATE (self);
#line 35 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->state = NULL;
#line 36 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->previous_state = NULL;
#line 39 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->x_gap = 0;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->y_gap = 0;
#line 2981 "taquin-game.c"
}


static void game_finalize (GObject* obj) {
	Game * self;
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->_tiles = (g_free (self->priv->_tiles), NULL);
#line 35 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 (self->priv->state);
#line 36 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 (self->priv->previous_state);
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
#line 2997 "taquin-game.c"
}


GType game_get_type (void) {
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
		GType game_type_id;
		game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}


static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	switch (property_id) {
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		case GAME_SIZE:
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		g_value_set_int (value, game_get_size (self));
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		break;
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		case GAME_GAME_TYPE:
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		g_value_set_enum (value, game_get_game_type (self));
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		break;
#line 3030 "taquin-game.c"
		default:
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		break;
#line 3036 "taquin-game.c"
	}
}


static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	switch (property_id) {
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		case GAME_SIZE:
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		game_set_size (self, g_value_get_int (value));
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		break;
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		case GAME_GAME_TYPE:
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		game_set_game_type (self, g_value_get_enum (value));
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		break;
#line 3058 "taquin-game.c"
		default:
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 27 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		break;
#line 3064 "taquin-game.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



