/* gnome-mines.c generated by valac 0.26.1, the Vala compiler
 * generated from gnome-mines.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <locale.h>


#define TYPE_MINES (mines_get_type ())
#define MINES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINES, Mines))
#define MINES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINES, MinesClass))
#define IS_MINES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINES))
#define IS_MINES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINES))
#define MINES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINES, MinesClass))

typedef struct _Mines Mines;
typedef struct _MinesClass MinesClass;
typedef struct _MinesPrivate MinesPrivate;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;

#define TYPE_MINEFIELD (minefield_get_type ())
#define MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD, Minefield))
#define MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD, MinefieldClass))
#define IS_MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD))
#define IS_MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD))
#define MINEFIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD, MinefieldClass))

typedef struct _Minefield Minefield;
typedef struct _MinefieldClass MinefieldClass;

#define TYPE_MINEFIELD_VIEW (minefield_view_get_type ())
#define MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD_VIEW, MinefieldView))
#define MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD_VIEW, MinefieldViewClass))
#define IS_MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD_VIEW))
#define IS_MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD_VIEW))
#define MINEFIELD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD_VIEW, MinefieldViewClass))

typedef struct _MinefieldView MinefieldView;
typedef struct _MinefieldViewClass MinefieldViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MinefieldPrivate MinefieldPrivate;

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;

#define TYPE_SCORE_DIALOG (score_dialog_get_type ())
#define SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_DIALOG, ScoreDialog))
#define SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_DIALOG, ScoreDialogClass))
#define IS_SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_DIALOG))
#define IS_SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_DIALOG))
#define SCORE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_DIALOG, ScoreDialogClass))

typedef struct _ScoreDialog ScoreDialog;
typedef struct _ScoreDialogClass ScoreDialogClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _Mines {
	GtkApplication parent_instance;
	MinesPrivate * priv;
};

struct _MinesClass {
	GtkApplicationClass parent_class;
};

struct _MinesPrivate {
	GSettings* settings;
	GtkWidget* main_screen;
	GtkButton* play_pause_button;
	GtkLabel* play_pause_label;
	GtkButton* replay_button;
	GtkButton* high_scores_button;
	GtkButton* new_game_button;
	GtkAspectFrame* minefield_aspect;
	GtkOverlay* minefield_overlay;
	GtkBox* paused_box;
	GtkScrolledWindow* scrolled;
	GtkStack* stack;
	GtkLabel* clock_label;
	GMenu* app_main_menu;
	GtkWindow* window;
	gint window_width;
	gint window_height;
	gboolean is_maximized;
	gboolean pause_requested;
	gboolean window_skip_configure;
	History* history;
	Minefield* minefield;
	MinefieldView* minefield_view;
	GtkLabel* flag_label;
	GtkSpinButton* mines_spin;
	GSimpleAction* new_game_action;
	GSimpleAction* repeat_size_action;
	GSimpleAction* pause_action;
	GtkAspectFrame* new_game_screen;
	GtkAspectFrame* custom_game_screen;
};

struct _Minefield {
	GObject parent_instance;
	MinefieldPrivate * priv;
	guint width;
	guint height;
	guint n_mines;
	gboolean exploded;
};

struct _MinefieldClass {
	GObjectClass parent_class;
};


static gpointer mines_parent_class = NULL;
static gint mines_game_mode;
static gint mines_game_mode = 0;

GType mines_get_type (void) G_GNUC_CONST;
GType history_get_type (void) G_GNUC_CONST;
GType minefield_get_type (void) G_GNUC_CONST;
GType minefield_view_get_type (void) G_GNUC_CONST;
#define MINES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MINES, MinesPrivate))
enum  {
	MINES_DUMMY_PROPERTY
};
#define MINES_KEY_XSIZE "xsize"
#define MINES_XSIZE_MIN 4
#define MINES_XSIZE_MAX 100
#define MINES_KEY_YSIZE "ysize"
#define MINES_YSIZE_MIN 4
#define MINES_YSIZE_MAX 100
#define MINES_KEY_NMINES "nmines"
#define MINES_KEY_MODE "mode"
#define MINES_KEY_USE_QUESTION_MARKS "use-question-marks"
#define MINES_KEY_USE_OVERMINE_WARNING "use-overmine-warning"
#define MINES_KEY_USE_AUTOFLAG "use-autoflag"
static void mines_new_game_cb (Mines* self);
static void _mines_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_repeat_size_cb (Mines* self);
static void _mines_repeat_size_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_toggle_pause_cb (Mines* self);
static void _mines_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_scores_cb (Mines* self);
static void _mines_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_quit_cb (Mines* self);
static void _mines_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_help_cb (Mines* self);
static void _mines_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_about_cb (Mines* self);
static void _mines_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Mines* mines_new (void);
Mines* mines_construct (GType object_type);
static void mines_real_startup (GApplication* base);
static gboolean mines_window_configure_event_cb (Mines* self, GdkEventConfigure* event);
static gboolean _mines_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean mines_window_state_event_cb (Mines* self, GdkEventWindowState* event);
static gboolean _mines_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static gboolean mines_window_focus_out_event_cb (Mines* self, GdkEventFocus* event);
static gboolean _mines_window_focus_out_event_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean mines_window_focus_in_event_cb (Mines* self, GdkEventFocus* event);
static gboolean _mines_window_focus_in_event_cb_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
MinefieldView* minefield_view_new (GSettings* settings);
MinefieldView* minefield_view_construct (GType object_type, GSettings* settings);
static gboolean mines_view_button_press_event (Mines* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _mines_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void mines_startup_new_game_screen (Mines* self, GtkBuilder* builder);
static void mines_startup_custom_game_screen (Mines* self, GtkBuilder* builder);
History* history_new (const gchar* filename);
History* history_construct (GType object_type, const gchar* filename);
void history_load (History* self);
static void mines_start_game (Mines* self);
static void mines_small_size_clicked_cb (Mines* self);
static void _mines_small_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gchar* mines_make_minefield_description (Mines* self, gint width, gint height, gint n_mines);
static void mines_medium_size_clicked_cb (Mines* self);
static void _mines_medium_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void mines_large_size_clicked_cb (Mines* self);
static void _mines_large_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void mines_show_custom_game_screen (Mines* self);
static void _mines_show_custom_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void mines_xsize_spin_cb (Mines* self, GtkSpinButton* spin);
static void _mines_xsize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void mines_ysize_spin_cb (Mines* self, GtkSpinButton* spin);
static void _mines_ysize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void mines_mines_spin_cb (Mines* self, GtkSpinButton* spin);
static void _mines_mines_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void mines_set_mines_limit (Mines* self);
static void mines_show_new_game_screen (Mines* self);
static void _mines_show_new_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void mines_custom_size_clicked_cb (Mines* self);
static void _mines_custom_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
gboolean minefield_is_clock_started (Minefield* self);
void minefield_set_paused (Minefield* self, gboolean value);
void mines_start (Mines* self);
static void mines_real_shutdown (GApplication* base);
static gint mines_real_handle_local_options (GApplication* base, GVariantDict* options);
static void mines_real_activate (GApplication* base);
gboolean minefield_get_paused (Minefield* self);
static void mines_update_flag_label (Mines* self);
guint minefield_get_n_flags (Minefield* self);
GType history_entry_get_type (void) G_GNUC_CONST;
static gint mines_show_scores (Mines* self, HistoryEntry* selected_entry, gboolean show_close);
GType score_dialog_get_type (void) G_GNUC_CONST;
ScoreDialog* score_dialog_new (History* history, HistoryEntry* selected_entry, gboolean show_close);
ScoreDialog* score_dialog_construct (GType object_type, History* history, HistoryEntry* selected_entry, gboolean show_close);
static gboolean mines_can_start_new_game (Mines* self);
guint minefield_get_n_cleared (Minefield* self);
gboolean minefield_get_is_complete (Minefield* self);
static void mines_tick_cb (Mines* self);
Minefield* minefield_new (guint width, guint height, guint n_mines);
Minefield* minefield_construct (GType object_type, guint width, guint height, guint n_mines);
static void mines_marks_changed_cb (Mines* self, Minefield* minefield);
static void _mines_marks_changed_cb_minefield_marks_changed (Minefield* _sender, gpointer self);
static void mines_explode_cb (Mines* self, Minefield* minefield);
static void _mines_explode_cb_minefield_explode (Minefield* _sender, gpointer self);
static void mines_cleared_cb (Mines* self, Minefield* minefield);
static void _mines_cleared_cb_minefield_cleared (Minefield* _sender, gpointer self);
static void _mines_tick_cb_minefield_tick (Minefield* _sender, gpointer self);
static void mines_paused_changed_cb (Mines* self);
static void _mines_paused_changed_cb_minefield_paused_changed (Minefield* _sender, gpointer self);
static void mines_clock_started_cb (Mines* self);
static void _mines_clock_started_cb_minefield_clock_started (Minefield* _sender, gpointer self);
void minefield_view_set_minefield (MinefieldView* self, Minefield* value);
static void mines_display_unpause_button (Mines* self);
gdouble minefield_get_elapsed (Minefield* self);
static void mines_display_pause_button (Mines* self);
HistoryEntry* history_entry_new (GDateTime* date, guint width, guint height, guint n_mines, guint duration);
HistoryEntry* history_entry_construct (GType object_type, GDateTime* date, guint width, guint height, guint n_mines, guint duration);
void history_add (History* self, HistoryEntry* entry);
void history_save (History* self);
static gfloat mines_percent_mines (Mines* self);
static void mines_set_mode (Mines* self, gint mode);
gint mines_main (gchar** args, int args_length1);
static void mines_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry MINES_option_entries[5] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Print release version and exit", NULL}, {"small", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Small game", NULL}, {"medium", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Medium game", NULL}, {"big", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Big game", NULL}, {NULL}};
static const GActionEntry MINES_action_entries[7] = {{"new-game", _mines_new_game_cb_gsimple_action_activate_callback}, {"repeat-size", _mines_repeat_size_cb_gsimple_action_activate_callback}, {"pause", _mines_toggle_pause_cb_gsimple_action_activate_callback}, {"scores", _mines_scores_cb_gsimple_action_activate_callback}, {"quit", _mines_quit_cb_gsimple_action_activate_callback}, {"help", _mines_help_cb_gsimple_action_activate_callback}, {"about", _mines_about_cb_gsimple_action_activate_callback}};

static void _mines_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_new_game_cb ((Mines*) self);
}


static void _mines_repeat_size_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_repeat_size_cb ((Mines*) self);
}


static void _mines_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_toggle_pause_cb ((Mines*) self);
}


static void _mines_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_scores_cb ((Mines*) self);
}


static void _mines_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_quit_cb ((Mines*) self);
}


static void _mines_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_help_cb ((Mines*) self);
}


static void _mines_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_about_cb ((Mines*) self);
}


Mines* mines_construct (GType object_type) {
	Mines * self = NULL;
	self = (Mines*) g_object_new (object_type, "application-id", "org.gnome.mines", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, MINES_option_entries);
	return self;
}


Mines* mines_new (void) {
	return mines_construct (TYPE_MINES);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _mines_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = mines_window_configure_event_cb ((Mines*) self, event);
	return result;
}


static gboolean _mines_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = mines_window_state_event_cb ((Mines*) self, event);
	return result;
}


static gboolean _mines_window_focus_out_event_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = mines_window_focus_out_event_cb ((Mines*) self, event);
	return result;
}


static gboolean _mines_window_focus_in_event_cb_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = mines_window_focus_in_event_cb ((Mines*) self, event);
	return result;
}


static gboolean _mines_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = mines_view_button_press_event ((Mines*) self, _sender, event);
	return result;
}


static void mines_real_startup (GApplication* base) {
	Mines * self;
	const gchar* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp6_ = NULL;
	gchar* css_path = NULL;
	gchar* _tmp7_ = NULL;
	GdkScreen* _tmp10_ = NULL;
	GtkBuilder* ui_builder = NULL;
	GtkBuilder* _tmp11_ = NULL;
	GtkIconTheme* _tmp16_ = NULL;
	GAction* _tmp17_ = NULL;
	GSimpleAction* _tmp18_ = NULL;
	GSimpleAction* _tmp19_ = NULL;
	GAction* _tmp20_ = NULL;
	GSimpleAction* _tmp21_ = NULL;
	GSimpleAction* _tmp22_ = NULL;
	GAction* _tmp23_ = NULL;
	GSimpleAction* _tmp24_ = NULL;
	GSimpleAction* _tmp25_ = NULL;
	GSettings* _tmp26_ = NULL;
	GAction* _tmp27_ = NULL;
	GAction* _tmp28_ = NULL;
	GSettings* _tmp29_ = NULL;
	GAction* _tmp30_ = NULL;
	GAction* _tmp31_ = NULL;
	GObject* _tmp32_ = NULL;
	GtkWindow* _tmp33_ = NULL;
	GtkWindow* _tmp34_ = NULL;
	GtkWindow* _tmp35_ = NULL;
	GtkWindow* _tmp36_ = NULL;
	GtkWindow* _tmp37_ = NULL;
	GtkWindow* _tmp38_ = NULL;
	GSettings* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	GSettings* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	GSettings* _tmp43_ = NULL;
	gboolean _tmp44_ = FALSE;
	GtkWindow* _tmp46_ = NULL;
	gchar* desktop = NULL;
	const gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gboolean _tmp49_ = FALSE;
	const gchar* _tmp50_ = NULL;
	gboolean shell_shows_menubar = FALSE;
	GtkSettings* _tmp59_ = NULL;
	gboolean _tmp60_ = FALSE;
	gchar* _tmp118_ = NULL;
	gchar** _tmp119_ = NULL;
	gchar** _tmp120_ = NULL;
	gint _tmp120__length1 = 0;
	gchar* _tmp121_ = NULL;
	gchar** _tmp122_ = NULL;
	gchar** _tmp123_ = NULL;
	gint _tmp123__length1 = 0;
	gchar* _tmp124_ = NULL;
	gchar** _tmp125_ = NULL;
	gchar** _tmp126_ = NULL;
	gint _tmp126__length1 = 0;
	gchar* _tmp127_ = NULL;
	gchar** _tmp128_ = NULL;
	gchar** _tmp129_ = NULL;
	gint _tmp129__length1 = 0;
	gchar* _tmp130_ = NULL;
	gchar* _tmp131_ = NULL;
	gchar** _tmp132_ = NULL;
	gchar** _tmp133_ = NULL;
	gint _tmp133__length1 = 0;
	GSettings* _tmp134_ = NULL;
	MinefieldView* _tmp135_ = NULL;
	MinefieldView* _tmp136_ = NULL;
	GObject* _tmp137_ = NULL;
	GtkStack* _tmp138_ = NULL;
	GtkScrolledWindow* _tmp139_ = NULL;
	GtkScrolledWindow* _tmp140_ = NULL;
	GtkScrolledWindow* _tmp141_ = NULL;
	MinefieldView* _tmp142_ = NULL;
	GObject* _tmp143_ = NULL;
	GtkOverlay* _tmp144_ = NULL;
	GtkOverlay* _tmp145_ = NULL;
	GtkScrolledWindow* _tmp146_ = NULL;
	GtkOverlay* _tmp147_ = NULL;
	GObject* _tmp148_ = NULL;
	GtkAspectFrame* _tmp149_ = NULL;
	GtkAspectFrame* _tmp150_ = NULL;
	GObject* _tmp151_ = NULL;
	GtkBox* _tmp152_ = NULL;
	GtkBox* _tmp153_ = NULL;
	GtkOverlay* _tmp154_ = NULL;
	GtkBox* _tmp155_ = NULL;
	GObject* _tmp156_ = NULL;
	GtkWidget* _tmp157_ = NULL;
	GtkWidget* _tmp158_ = NULL;
	const gchar* _tmp159_ = NULL;
	gchar* _tmp160_ = NULL;
	gchar* _tmp161_ = NULL;
	History* _tmp162_ = NULL;
	History* _tmp163_ = NULL;
	GObject* _tmp164_ = NULL;
	GtkLabel* _tmp165_ = NULL;
	GObject* _tmp166_ = NULL;
	GtkLabel* _tmp167_ = NULL;
	GObject* _tmp168_ = NULL;
	GtkButton* _tmp169_ = NULL;
	GObject* _tmp170_ = NULL;
	GtkLabel* _tmp171_ = NULL;
	GObject* _tmp172_ = NULL;
	GtkButton* _tmp173_ = NULL;
	GObject* _tmp174_ = NULL;
	GtkButton* _tmp175_ = NULL;
	GObject* _tmp176_ = NULL;
	GtkButton* _tmp177_ = NULL;
	gint _tmp178_ = 0;
	GError * _inner_error_ = NULL;
	self = (Mines*) base;
	G_APPLICATION_CLASS (mines_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = _ ("Mines");
	g_set_application_name (_tmp0_);
	_tmp1_ = g_settings_new ("org.gnome.mines");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_tmp2_ = self->priv->settings;
	g_settings_delay (_tmp2_);
	_tmp3_ = mines_game_mode;
	if (_tmp3_ != (-1)) {
		GSettings* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp4_ = self->priv->settings;
		_tmp5_ = mines_game_mode;
		g_settings_set_int (_tmp4_, MINES_KEY_MODE, _tmp5_);
	}
	gtk_window_set_default_icon_name ("gnome-mines");
	_tmp6_ = gtk_css_provider_new ();
	css_provider = _tmp6_;
	_tmp7_ = g_build_filename (DATA_DIRECTORY, "gnome-mines.css", NULL);
	css_path = _tmp7_;
	{
		gtk_css_provider_load_from_path (css_provider, css_path, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("gnome-mines.vala:128: Error loading css styles from %s: %s", css_path, _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (css_path);
		_g_object_unref0 (css_provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp10_ = gdk_screen_get_default ();
	gtk_style_context_add_provider_for_screen (_tmp10_, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp11_ = gtk_builder_new ();
	ui_builder = _tmp11_;
	{
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		_tmp12_ = g_build_filename (DATA_DIRECTORY, "interface.ui", NULL, NULL);
		_tmp13_ = _tmp12_;
		gtk_builder_add_from_file (ui_builder, _tmp13_, &_inner_error_);
		_g_free0 (_tmp13_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("gnome-mines.vala:139: Could not load game UI: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (ui_builder);
		_g_free0 (css_path);
		_g_object_unref0 (css_provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp16_ = gtk_icon_theme_get_default ();
	gtk_icon_theme_append_search_path (_tmp16_, DATA_DIRECTORY);
	g_action_map_add_action_entries ((GActionMap*) self, MINES_action_entries, G_N_ELEMENTS (MINES_action_entries), self);
	_tmp17_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp17_) : NULL);
	_g_object_unref0 (self->priv->new_game_action);
	self->priv->new_game_action = _tmp18_;
	_tmp19_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp19_, FALSE);
	_tmp20_ = g_action_map_lookup_action ((GActionMap*) self, "repeat-size");
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp20_) : NULL);
	_g_object_unref0 (self->priv->repeat_size_action);
	self->priv->repeat_size_action = _tmp21_;
	_tmp22_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp22_, FALSE);
	_tmp23_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp23_) : NULL);
	_g_object_unref0 (self->priv->pause_action);
	self->priv->pause_action = _tmp24_;
	_tmp25_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp25_, FALSE);
	_tmp26_ = self->priv->settings;
	_tmp27_ = g_settings_create_action (_tmp26_, MINES_KEY_USE_OVERMINE_WARNING);
	_tmp28_ = _tmp27_;
	g_action_map_add_action ((GActionMap*) self, _tmp28_);
	_g_object_unref0 (_tmp28_);
	_tmp29_ = self->priv->settings;
	_tmp30_ = g_settings_create_action (_tmp29_, MINES_KEY_USE_QUESTION_MARKS);
	_tmp31_ = _tmp30_;
	g_action_map_add_action ((GActionMap*) self, _tmp31_);
	_g_object_unref0 (_tmp31_);
	_tmp32_ = gtk_builder_get_object (ui_builder, "main_window");
	_tmp33_ = _g_object_ref0 ((GtkWindow*) G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_application_window_get_type (), GtkApplicationWindow));
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp33_;
	_tmp34_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp34_, "configure-event", (GCallback) _mines_window_configure_event_cb_gtk_widget_configure_event, self, 0);
	_tmp35_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp35_, "window-state-event", (GCallback) _mines_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp36_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp36_, "focus-out-event", (GCallback) _mines_window_focus_out_event_cb_gtk_widget_focus_out_event, self, 0);
	_tmp37_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp37_, "focus-in-event", (GCallback) _mines_window_focus_in_event_cb_gtk_widget_focus_in_event, self, 0);
	_tmp38_ = self->priv->window;
	_tmp39_ = self->priv->settings;
	_tmp40_ = g_settings_get_int (_tmp39_, "window-width");
	_tmp41_ = self->priv->settings;
	_tmp42_ = g_settings_get_int (_tmp41_, "window-height");
	gtk_window_set_default_size (_tmp38_, _tmp40_, _tmp42_);
	_tmp43_ = self->priv->settings;
	_tmp44_ = g_settings_get_boolean (_tmp43_, "window-is-maximized");
	if (_tmp44_) {
		GtkWindow* _tmp45_ = NULL;
		_tmp45_ = self->priv->window;
		gtk_window_maximize (_tmp45_);
	}
	_tmp46_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, _tmp46_);
	_tmp47_ = g_getenv ("XDG_CURRENT_DESKTOP");
	_tmp48_ = g_strdup (_tmp47_);
	desktop = _tmp48_;
	_tmp50_ = desktop;
	if (_tmp50_ == NULL) {
		_tmp49_ = TRUE;
	} else {
		const gchar* _tmp51_ = NULL;
		_tmp51_ = desktop;
		_tmp49_ = g_strcmp0 (_tmp51_, "Unity") != 0;
	}
	if (_tmp49_) {
		GtkHeaderBar* headerbar = NULL;
		GtkHeaderBar* _tmp52_ = NULL;
		GtkHeaderBar* _tmp53_ = NULL;
		GtkHeaderBar* _tmp54_ = NULL;
		const gchar* _tmp55_ = NULL;
		GtkHeaderBar* _tmp56_ = NULL;
		GtkWindow* _tmp57_ = NULL;
		GtkHeaderBar* _tmp58_ = NULL;
		_tmp52_ = (GtkHeaderBar*) gtk_header_bar_new ();
		g_object_ref_sink (_tmp52_);
		headerbar = _tmp52_;
		_tmp53_ = headerbar;
		gtk_header_bar_set_show_close_button (_tmp53_, TRUE);
		_tmp54_ = headerbar;
		_tmp55_ = _ ("Mines");
		gtk_header_bar_set_title (_tmp54_, _tmp55_);
		_tmp56_ = headerbar;
		gtk_widget_show ((GtkWidget*) _tmp56_);
		_tmp57_ = self->priv->window;
		_tmp58_ = headerbar;
		gtk_window_set_titlebar (_tmp57_, (GtkWidget*) _tmp58_);
		_g_object_unref0 (headerbar);
	}
	_tmp59_ = gtk_settings_get_default ();
	g_object_get ((GObject*) _tmp59_, "gtk-shell-shows-menubar", &shell_shows_menubar, NULL);
	_tmp60_ = shell_shows_menubar;
	if (!_tmp60_) {
		GMenu* menu = NULL;
		GMenu* _tmp61_ = NULL;
		GMenu* _tmp62_ = NULL;
		GMenu* _tmp63_ = NULL;
		GMenu* _tmp64_ = NULL;
		GMenu* _tmp65_ = NULL;
		const gchar* _tmp66_ = NULL;
		GMenu* _tmp67_ = NULL;
		const gchar* _tmp68_ = NULL;
		GMenu* section = NULL;
		GMenu* _tmp69_ = NULL;
		GMenu* _tmp70_ = NULL;
		GMenu* _tmp71_ = NULL;
		GMenu* _tmp72_ = NULL;
		const gchar* _tmp73_ = NULL;
		gchar* _tmp74_ = NULL;
		gchar* _tmp75_ = NULL;
		GMenu* _tmp76_ = NULL;
		const gchar* _tmp77_ = NULL;
		gchar* _tmp78_ = NULL;
		gchar* _tmp79_ = NULL;
		GMenu* _tmp80_ = NULL;
		GMenu* _tmp81_ = NULL;
		GMenu* _tmp82_ = NULL;
		GMenu* _tmp83_ = NULL;
		const gchar* _tmp84_ = NULL;
		GMenu* _tmp85_ = NULL;
		const gchar* _tmp86_ = NULL;
		GMenu* _tmp87_ = NULL;
		const gchar* _tmp88_ = NULL;
		GMenu* _tmp89_ = NULL;
		_tmp61_ = g_menu_new ();
		menu = _tmp61_;
		_tmp62_ = g_menu_new ();
		_g_object_unref0 (self->priv->app_main_menu);
		self->priv->app_main_menu = _tmp62_;
		_tmp63_ = menu;
		_tmp64_ = self->priv->app_main_menu;
		g_menu_append_section (_tmp63_, NULL, (GMenuModel*) _tmp64_);
		_tmp65_ = self->priv->app_main_menu;
		_tmp66_ = _ ("_New Game");
		g_menu_append (_tmp65_, _tmp66_, "app.new-game");
		_tmp67_ = self->priv->app_main_menu;
		_tmp68_ = _ ("_Scores");
		g_menu_append (_tmp67_, _tmp68_, "app.scores");
		_tmp69_ = g_menu_new ();
		section = _tmp69_;
		_tmp70_ = menu;
		_tmp71_ = section;
		g_menu_append_section (_tmp70_, NULL, (GMenuModel*) _tmp71_);
		_tmp72_ = section;
		_tmp73_ = _ ("_Show Warnings");
		_tmp74_ = g_strdup_printf ("app.%s", MINES_KEY_USE_OVERMINE_WARNING);
		_tmp75_ = _tmp74_;
		g_menu_append (_tmp72_, _tmp73_, _tmp75_);
		_g_free0 (_tmp75_);
		_tmp76_ = section;
		_tmp77_ = _ ("_Use Question Flags");
		_tmp78_ = g_strdup_printf ("app.%s", MINES_KEY_USE_QUESTION_MARKS);
		_tmp79_ = _tmp78_;
		g_menu_append (_tmp76_, _tmp77_, _tmp79_);
		_g_free0 (_tmp79_);
		_tmp80_ = g_menu_new ();
		_g_object_unref0 (section);
		section = _tmp80_;
		_tmp81_ = menu;
		_tmp82_ = section;
		g_menu_append_section (_tmp81_, NULL, (GMenuModel*) _tmp82_);
		_tmp83_ = section;
		_tmp84_ = _ ("_Help");
		g_menu_append (_tmp83_, _tmp84_, "app.help");
		_tmp85_ = section;
		_tmp86_ = _ ("_About");
		g_menu_append (_tmp85_, _tmp86_, "app.about");
		_tmp87_ = section;
		_tmp88_ = _ ("_Quit");
		g_menu_append (_tmp87_, _tmp88_, "app.quit");
		_tmp89_ = menu;
		gtk_application_set_app_menu ((GtkApplication*) self, (GMenuModel*) _tmp89_);
		_g_object_unref0 (section);
		_g_object_unref0 (menu);
	} else {
		GMenu* menu = NULL;
		GMenu* _tmp90_ = NULL;
		GMenu* mines_menu = NULL;
		GMenu* _tmp91_ = NULL;
		GMenu* _tmp92_ = NULL;
		const gchar* _tmp93_ = NULL;
		GMenu* _tmp94_ = NULL;
		GMenu* _tmp95_ = NULL;
		const gchar* _tmp96_ = NULL;
		GMenu* _tmp97_ = NULL;
		const gchar* _tmp98_ = NULL;
		GMenu* _tmp99_ = NULL;
		const gchar* _tmp100_ = NULL;
		gchar* _tmp101_ = NULL;
		gchar* _tmp102_ = NULL;
		GMenu* _tmp103_ = NULL;
		const gchar* _tmp104_ = NULL;
		gchar* _tmp105_ = NULL;
		gchar* _tmp106_ = NULL;
		GMenu* _tmp107_ = NULL;
		const gchar* _tmp108_ = NULL;
		GMenu* help_menu = NULL;
		GMenu* _tmp109_ = NULL;
		GMenu* _tmp110_ = NULL;
		const gchar* _tmp111_ = NULL;
		GMenu* _tmp112_ = NULL;
		GMenu* _tmp113_ = NULL;
		const gchar* _tmp114_ = NULL;
		GMenu* _tmp115_ = NULL;
		const gchar* _tmp116_ = NULL;
		GMenu* _tmp117_ = NULL;
		_tmp90_ = g_menu_new ();
		menu = _tmp90_;
		_tmp91_ = g_menu_new ();
		mines_menu = _tmp91_;
		_tmp92_ = menu;
		_tmp93_ = _ ("_Mines");
		_tmp94_ = mines_menu;
		g_menu_append_submenu (_tmp92_, _tmp93_, (GMenuModel*) _tmp94_);
		_tmp95_ = mines_menu;
		_tmp96_ = _ ("_New Game");
		g_menu_append (_tmp95_, _tmp96_, "app.new-game");
		_tmp97_ = mines_menu;
		_tmp98_ = _ ("_Scores");
		g_menu_append (_tmp97_, _tmp98_, "app.scores");
		_tmp99_ = mines_menu;
		_tmp100_ = _ ("_Show Warnings");
		_tmp101_ = g_strdup_printf ("app.%s", MINES_KEY_USE_OVERMINE_WARNING);
		_tmp102_ = _tmp101_;
		g_menu_append (_tmp99_, _tmp100_, _tmp102_);
		_g_free0 (_tmp102_);
		_tmp103_ = mines_menu;
		_tmp104_ = _ ("_Use Question Flags");
		_tmp105_ = g_strdup_printf ("app.%s", MINES_KEY_USE_QUESTION_MARKS);
		_tmp106_ = _tmp105_;
		g_menu_append (_tmp103_, _tmp104_, _tmp106_);
		_g_free0 (_tmp106_);
		_tmp107_ = mines_menu;
		_tmp108_ = _ ("_Quit");
		g_menu_append (_tmp107_, _tmp108_, "app.quit");
		_tmp109_ = g_menu_new ();
		help_menu = _tmp109_;
		_tmp110_ = menu;
		_tmp111_ = _ ("_Help");
		_tmp112_ = help_menu;
		g_menu_append_submenu (_tmp110_, _tmp111_, (GMenuModel*) _tmp112_);
		_tmp113_ = help_menu;
		_tmp114_ = _ ("_Contents");
		g_menu_append (_tmp113_, _tmp114_, "app.help");
		_tmp115_ = help_menu;
		_tmp116_ = _ ("_About");
		g_menu_append (_tmp115_, _tmp116_, "app.about");
		_tmp117_ = menu;
		gtk_application_set_menubar ((GtkApplication*) self, (GMenuModel*) _tmp117_);
		_g_object_unref0 (help_menu);
		_g_object_unref0 (mines_menu);
		_g_object_unref0 (menu);
	}
	_tmp118_ = g_strdup ("<Primary>n");
	_tmp119_ = g_new0 (gchar*, 1 + 1);
	_tmp119_[0] = _tmp118_;
	_tmp120_ = _tmp119_;
	_tmp120__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp120_);
	_tmp120_ = (_vala_array_free (_tmp120_, _tmp120__length1, (GDestroyNotify) g_free), NULL);
	_tmp121_ = g_strdup ("<Primary>r");
	_tmp122_ = g_new0 (gchar*, 1 + 1);
	_tmp122_[0] = _tmp121_;
	_tmp123_ = _tmp122_;
	_tmp123__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.repeat-size", _tmp123_);
	_tmp123_ = (_vala_array_free (_tmp123_, _tmp123__length1, (GDestroyNotify) g_free), NULL);
	_tmp124_ = g_strdup ("Pause");
	_tmp125_ = g_new0 (gchar*, 1 + 1);
	_tmp125_[0] = _tmp124_;
	_tmp126_ = _tmp125_;
	_tmp126__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.pause", _tmp126_);
	_tmp126_ = (_vala_array_free (_tmp126_, _tmp126__length1, (GDestroyNotify) g_free), NULL);
	_tmp127_ = g_strdup ("F1");
	_tmp128_ = g_new0 (gchar*, 1 + 1);
	_tmp128_[0] = _tmp127_;
	_tmp129_ = _tmp128_;
	_tmp129__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp129_);
	_tmp129_ = (_vala_array_free (_tmp129_, _tmp129__length1, (GDestroyNotify) g_free), NULL);
	_tmp130_ = g_strdup ("<Primary>q");
	_tmp131_ = g_strdup ("<Primary>w");
	_tmp132_ = g_new0 (gchar*, 2 + 1);
	_tmp132_[0] = _tmp130_;
	_tmp132_[1] = _tmp131_;
	_tmp133_ = _tmp132_;
	_tmp133__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp133_);
	_tmp133_ = (_vala_array_free (_tmp133_, _tmp133__length1, (GDestroyNotify) g_free), NULL);
	_tmp134_ = self->priv->settings;
	_tmp135_ = minefield_view_new (_tmp134_);
	g_object_ref_sink (_tmp135_);
	_g_object_unref0 (self->priv->minefield_view);
	self->priv->minefield_view = _tmp135_;
	_tmp136_ = self->priv->minefield_view;
	gtk_widget_show ((GtkWidget*) _tmp136_);
	_tmp137_ = gtk_builder_get_object (ui_builder, "stack");
	_tmp138_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp137_, gtk_stack_get_type (), GtkStack));
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp138_;
	_tmp139_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp139_);
	_g_object_unref0 (self->priv->scrolled);
	self->priv->scrolled = _tmp139_;
	_tmp140_ = self->priv->scrolled;
	gtk_widget_show ((GtkWidget*) _tmp140_);
	_tmp141_ = self->priv->scrolled;
	_tmp142_ = self->priv->minefield_view;
	gtk_container_add ((GtkContainer*) _tmp141_, (GtkWidget*) _tmp142_);
	_tmp143_ = gtk_builder_get_object (ui_builder, "minefield_overlay");
	_tmp144_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp143_, gtk_overlay_get_type (), GtkOverlay));
	_g_object_unref0 (self->priv->minefield_overlay);
	self->priv->minefield_overlay = _tmp144_;
	_tmp145_ = self->priv->minefield_overlay;
	_tmp146_ = self->priv->scrolled;
	gtk_container_add ((GtkContainer*) _tmp145_, (GtkWidget*) _tmp146_);
	_tmp147_ = self->priv->minefield_overlay;
	gtk_widget_show ((GtkWidget*) _tmp147_);
	_tmp148_ = gtk_builder_get_object (ui_builder, "minefield_aspect");
	_tmp149_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp148_, gtk_aspect_frame_get_type (), GtkAspectFrame));
	_g_object_unref0 (self->priv->minefield_aspect);
	self->priv->minefield_aspect = _tmp149_;
	_tmp150_ = self->priv->minefield_aspect;
	gtk_widget_show ((GtkWidget*) _tmp150_);
	_tmp151_ = gtk_builder_get_object (ui_builder, "paused_box");
	_tmp152_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp151_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->paused_box);
	self->priv->paused_box = _tmp152_;
	_tmp153_ = self->priv->paused_box;
	g_signal_connect_object ((GtkWidget*) _tmp153_, "button-press-event", (GCallback) _mines_view_button_press_event_gtk_widget_button_press_event, self, 0);
	_tmp154_ = self->priv->minefield_overlay;
	_tmp155_ = self->priv->paused_box;
	gtk_overlay_add_overlay (_tmp154_, (GtkWidget*) _tmp155_);
	_tmp156_ = gtk_builder_get_object (ui_builder, "main_screen");
	_tmp157_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp156_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->main_screen);
	self->priv->main_screen = _tmp157_;
	_tmp158_ = self->priv->main_screen;
	gtk_widget_show_all (_tmp158_);
	mines_startup_new_game_screen (self, ui_builder);
	mines_startup_custom_game_screen (self, ui_builder);
	_tmp159_ = g_get_user_data_dir ();
	_tmp160_ = g_build_filename (_tmp159_, "gnome-mines", "history", NULL);
	_tmp161_ = _tmp160_;
	_tmp162_ = history_new (_tmp161_);
	_g_object_unref0 (self->priv->history);
	self->priv->history = _tmp162_;
	_g_free0 (_tmp161_);
	_tmp163_ = self->priv->history;
	history_load (_tmp163_);
	_tmp164_ = gtk_builder_get_object (ui_builder, "flag_label");
	_tmp165_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->flag_label);
	self->priv->flag_label = _tmp165_;
	_tmp166_ = gtk_builder_get_object (ui_builder, "clock_label");
	_tmp167_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp166_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->clock_label);
	self->priv->clock_label = _tmp167_;
	_tmp168_ = gtk_builder_get_object (ui_builder, "play_pause_button");
	_tmp169_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp168_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->play_pause_button);
	self->priv->play_pause_button = _tmp169_;
	_tmp170_ = gtk_builder_get_object (ui_builder, "play_pause_label");
	_tmp171_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp170_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->play_pause_label);
	self->priv->play_pause_label = _tmp171_;
	_tmp172_ = gtk_builder_get_object (ui_builder, "high_scores_button");
	_tmp173_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp172_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->high_scores_button);
	self->priv->high_scores_button = _tmp173_;
	_tmp174_ = gtk_builder_get_object (ui_builder, "replay_button");
	_tmp175_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp174_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->replay_button);
	self->priv->replay_button = _tmp175_;
	_tmp176_ = gtk_builder_get_object (ui_builder, "new_game_button");
	_tmp177_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp176_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->new_game_button);
	self->priv->new_game_button = _tmp177_;
	_tmp178_ = mines_game_mode;
	if (_tmp178_ != (-1)) {
		mines_start_game (self);
	}
	_g_free0 (desktop);
	_g_object_unref0 (ui_builder);
	_g_free0 (css_path);
	_g_object_unref0 (css_provider);
}


static void _mines_small_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_small_size_clicked_cb ((Mines*) self);
}


static void _mines_medium_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_medium_size_clicked_cb ((Mines*) self);
}


static void _mines_large_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_large_size_clicked_cb ((Mines*) self);
}


static void _mines_show_custom_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_show_custom_game_screen ((Mines*) self);
}


static void mines_startup_new_game_screen (Mines* self, GtkBuilder* builder) {
	GtkBuilder* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkAspectFrame* _tmp2_ = NULL;
	GtkButton* button = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	GtkLabel* label = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkButton* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkBuilder* _tmp14_ = NULL;
	GObject* _tmp15_ = NULL;
	GtkButton* _tmp16_ = NULL;
	GtkButton* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkButton* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	GtkBuilder* _tmp25_ = NULL;
	GObject* _tmp26_ = NULL;
	GtkButton* _tmp27_ = NULL;
	GtkButton* _tmp28_ = NULL;
	GtkLabel* _tmp29_ = NULL;
	GtkLabel* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	GtkLabel* _tmp33_ = NULL;
	GtkButton* _tmp34_ = NULL;
	GtkLabel* _tmp35_ = NULL;
	GtkBuilder* _tmp36_ = NULL;
	GObject* _tmp37_ = NULL;
	GtkButton* _tmp38_ = NULL;
	GtkButton* _tmp39_ = NULL;
	GtkLabel* _tmp40_ = NULL;
	GtkLabel* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	GtkLabel* _tmp46_ = NULL;
	GtkButton* _tmp47_ = NULL;
	GtkLabel* _tmp48_ = NULL;
	GtkAspectFrame* _tmp49_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "new_game_screen");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_aspect_frame_get_type (), GtkAspectFrame));
	_g_object_unref0 (self->priv->new_game_screen);
	self->priv->new_game_screen = _tmp2_;
	_tmp3_ = builder;
	_tmp4_ = gtk_builder_get_object (_tmp3_, "small_size_btn");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_button_get_type (), GtkButton));
	button = _tmp5_;
	_tmp6_ = button;
	g_signal_connect_object (_tmp6_, "clicked", (GCallback) _mines_small_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp7_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp7_);
	label = _tmp7_;
	_tmp8_ = label;
	_tmp9_ = mines_make_minefield_description (self, 8, 8, 10);
	_tmp10_ = _tmp9_;
	gtk_label_set_markup (_tmp8_, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = label;
	gtk_label_set_justify (_tmp11_, GTK_JUSTIFY_CENTER);
	_tmp12_ = button;
	_tmp13_ = label;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = builder;
	_tmp15_ = gtk_builder_get_object (_tmp14_, "medium_size_btn");
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (button);
	button = _tmp16_;
	_tmp17_ = button;
	g_signal_connect_object (_tmp17_, "clicked", (GCallback) _mines_medium_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp18_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (label);
	label = _tmp18_;
	_tmp19_ = label;
	_tmp20_ = mines_make_minefield_description (self, 16, 16, 40);
	_tmp21_ = _tmp20_;
	gtk_label_set_markup (_tmp19_, _tmp21_);
	_g_free0 (_tmp21_);
	_tmp22_ = label;
	gtk_label_set_justify (_tmp22_, GTK_JUSTIFY_CENTER);
	_tmp23_ = button;
	_tmp24_ = label;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = builder;
	_tmp26_ = gtk_builder_get_object (_tmp25_, "large_size_btn");
	_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (button);
	button = _tmp27_;
	_tmp28_ = button;
	g_signal_connect_object (_tmp28_, "clicked", (GCallback) _mines_large_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp29_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (label);
	label = _tmp29_;
	_tmp30_ = label;
	_tmp31_ = mines_make_minefield_description (self, 30, 16, 99);
	_tmp32_ = _tmp31_;
	gtk_label_set_markup (_tmp30_, _tmp32_);
	_g_free0 (_tmp32_);
	_tmp33_ = label;
	gtk_label_set_justify (_tmp33_, GTK_JUSTIFY_CENTER);
	_tmp34_ = button;
	_tmp35_ = label;
	gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = builder;
	_tmp37_ = gtk_builder_get_object (_tmp36_, "custom_size_btn");
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (button);
	button = _tmp38_;
	_tmp39_ = button;
	g_signal_connect_object (_tmp39_, "clicked", (GCallback) _mines_show_custom_game_screen_gtk_button_clicked, self, 0);
	_tmp40_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (label);
	label = _tmp40_;
	_tmp41_ = label;
	_tmp42_ = _ ("Custom");
	_tmp43_ = g_dpgettext2 (NULL, "board size", _tmp42_);
	_tmp44_ = g_strconcat ("<span size='xx-large' weight='heavy'>?</span>\n", _tmp43_, NULL);
	_tmp45_ = _tmp44_;
	gtk_label_set_markup_with_mnemonic (_tmp41_, _tmp45_);
	_g_free0 (_tmp45_);
	_tmp46_ = label;
	gtk_label_set_justify (_tmp46_, GTK_JUSTIFY_CENTER);
	_tmp47_ = button;
	_tmp48_ = label;
	gtk_container_add ((GtkContainer*) _tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = self->priv->new_game_screen;
	gtk_widget_show_all ((GtkWidget*) _tmp49_);
	_g_object_unref0 (label);
	_g_object_unref0 (button);
}


static void _mines_xsize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	mines_xsize_spin_cb ((Mines*) self, _sender);
}


static void _mines_ysize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	mines_ysize_spin_cb ((Mines*) self, _sender);
}


static void _mines_mines_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	mines_mines_spin_cb ((Mines*) self, _sender);
}


static void _mines_show_new_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_show_new_game_screen ((Mines*) self);
}


static void _mines_custom_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_custom_size_clicked_cb ((Mines*) self);
}


static void mines_startup_custom_game_screen (Mines* self, GtkBuilder* builder) {
	GtkBuilder* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkAspectFrame* _tmp2_ = NULL;
	GtkSpinButton* field_width_entry = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GtkSpinButton* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GtkSpinButton* field_height_entry = NULL;
	GtkBuilder* _tmp8_ = NULL;
	GObject* _tmp9_ = NULL;
	GtkSpinButton* _tmp10_ = NULL;
	GSettings* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GtkBuilder* _tmp13_ = NULL;
	GObject* _tmp14_ = NULL;
	GtkSpinButton* _tmp15_ = NULL;
	GtkSpinButton* _tmp16_ = NULL;
	GtkSpinButton* _tmp17_ = NULL;
	GtkSpinButton* _tmp18_ = NULL;
	GtkButton* button = NULL;
	GtkBuilder* _tmp19_ = NULL;
	GObject* _tmp20_ = NULL;
	GtkButton* _tmp21_ = NULL;
	GtkButton* _tmp22_ = NULL;
	GtkBuilder* _tmp23_ = NULL;
	GObject* _tmp24_ = NULL;
	GtkButton* _tmp25_ = NULL;
	GtkButton* _tmp26_ = NULL;
	GtkAspectFrame* _tmp27_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "custom_game_screen");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_aspect_frame_get_type (), GtkAspectFrame));
	_g_object_unref0 (self->priv->custom_game_screen);
	self->priv->custom_game_screen = _tmp2_;
	_tmp3_ = builder;
	_tmp4_ = gtk_builder_get_object (_tmp3_, "width_spin_btn");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_spin_button_get_type (), GtkSpinButton));
	field_width_entry = _tmp5_;
	gtk_spin_button_set_range (field_width_entry, (gdouble) MINES_XSIZE_MIN, (gdouble) MINES_XSIZE_MAX);
	g_signal_connect_object (field_width_entry, "value-changed", (GCallback) _mines_xsize_spin_cb_gtk_spin_button_value_changed, self, 0);
	gtk_spin_button_set_increments (field_width_entry, (gdouble) 1, (gdouble) 1);
	_tmp6_ = self->priv->settings;
	_tmp7_ = g_settings_get_int (_tmp6_, MINES_KEY_XSIZE);
	gtk_spin_button_set_value (field_width_entry, (gdouble) _tmp7_);
	_tmp8_ = builder;
	_tmp9_ = gtk_builder_get_object (_tmp8_, "height_spin_btn");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_spin_button_get_type (), GtkSpinButton));
	field_height_entry = _tmp10_;
	gtk_spin_button_set_range (field_height_entry, (gdouble) MINES_YSIZE_MIN, (gdouble) MINES_YSIZE_MAX);
	g_signal_connect_object (field_height_entry, "value-changed", (GCallback) _mines_ysize_spin_cb_gtk_spin_button_value_changed, self, 0);
	gtk_spin_button_set_increments (field_height_entry, (gdouble) 1, (gdouble) 1);
	_tmp11_ = self->priv->settings;
	_tmp12_ = g_settings_get_int (_tmp11_, MINES_KEY_YSIZE);
	gtk_spin_button_set_value (field_height_entry, (gdouble) _tmp12_);
	_tmp13_ = builder;
	_tmp14_ = gtk_builder_get_object (_tmp13_, "mines_spin_btn");
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_spin_button_get_type (), GtkSpinButton));
	_g_object_unref0 (self->priv->mines_spin);
	self->priv->mines_spin = _tmp15_;
	_tmp16_ = self->priv->mines_spin;
	gtk_spin_button_set_range (_tmp16_, (gdouble) 1, (gdouble) 100);
	_tmp17_ = self->priv->mines_spin;
	gtk_spin_button_set_increments (_tmp17_, (gdouble) 1, (gdouble) 1);
	_tmp18_ = self->priv->mines_spin;
	g_signal_connect_object (_tmp18_, "value-changed", (GCallback) _mines_mines_spin_cb_gtk_spin_button_value_changed, self, 0);
	mines_set_mines_limit (self);
	_tmp19_ = builder;
	_tmp20_ = gtk_builder_get_object (_tmp19_, "cancel_btn");
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_button_get_type (), GtkButton));
	button = _tmp21_;
	_tmp22_ = button;
	g_signal_connect_object (_tmp22_, "clicked", (GCallback) _mines_show_new_game_screen_gtk_button_clicked, self, 0);
	_tmp23_ = builder;
	_tmp24_ = gtk_builder_get_object (_tmp23_, "play_game_btn");
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (button);
	button = _tmp25_;
	_tmp26_ = button;
	g_signal_connect_object (_tmp26_, "clicked", (GCallback) _mines_custom_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp27_ = self->priv->custom_game_screen;
	gtk_widget_show_all ((GtkWidget*) _tmp27_);
	_g_object_unref0 (button);
	_g_object_unref0 (field_height_entry);
	_g_object_unref0 (field_width_entry);
}


static gboolean mines_window_configure_event_cb (Mines* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->is_maximized;
	if (!_tmp1_) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->priv->window_skip_configure;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GdkEventConfigure* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		GdkEventConfigure* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp3_ = event;
		_tmp4_ = _tmp3_->width;
		self->priv->window_width = _tmp4_;
		_tmp5_ = event;
		_tmp6_ = _tmp5_->height;
		self->priv->window_height = _tmp6_;
	}
	self->priv->window_skip_configure = FALSE;
	result = FALSE;
	return result;
}


static gboolean mines_window_state_event_cb (Mines* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->new_window_state;
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	result = FALSE;
	return result;
}


static gboolean mines_window_focus_out_event_cb (Mines* self, GdkEventFocus* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->minefield;
	if (_tmp1_ != NULL) {
		Minefield* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->minefield;
		_tmp3_ = minefield_is_clock_started (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Minefield* _tmp4_ = NULL;
		_tmp4_ = self->priv->minefield;
		minefield_set_paused (_tmp4_, TRUE);
	}
	result = FALSE;
	return result;
}


static gboolean mines_window_focus_in_event_cb (Mines* self, GdkEventFocus* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->minefield;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->priv->pause_requested;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Minefield* _tmp3_ = NULL;
		_tmp3_ = self->priv->minefield;
		minefield_set_paused (_tmp3_, FALSE);
	}
	result = FALSE;
	return result;
}


static gchar* mines_make_minefield_description (Mines* self, gint width, gint height, gint n_mines) {
	gchar* result = NULL;
	gchar* size_label = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* mines_label = NULL;
	gint _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = width;
	_tmp1_ = height;
	_tmp2_ = g_strdup_printf ("%d × %d", _tmp0_, _tmp1_);
	size_label = _tmp2_;
	_tmp3_ = n_mines;
	_tmp4_ = ngettext ("<b>%d</b> mine", "<b>%d</b> mines", (gulong) _tmp3_);
	_tmp5_ = n_mines;
	_tmp6_ = g_strdup_printf (_tmp4_, _tmp5_);
	mines_label = _tmp6_;
	_tmp7_ = g_strdup_printf ("<span size='x-large' weight='ultrabold'>%s</span>\n%s", size_label, mines_label);
	result = _tmp7_;
	_g_free0 (mines_label);
	_g_free0 (size_label);
	return result;
}


void mines_start (Mines* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	mines_show_new_game_screen (self);
}


static void mines_real_shutdown (GApplication* base) {
	Mines * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GSettings* _tmp6_ = NULL;
	self = (Mines*) base;
	G_APPLICATION_CLASS (mines_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->window_width;
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->window_height;
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
	_tmp6_ = self->priv->settings;
	g_settings_apply (_tmp6_);
}


static gint mines_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Mines * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GVariantDict* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GVariantDict* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GVariantDict* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	self = (Mines*) base;
	g_return_val_if_fail (options != NULL, 0);
	_tmp0_ = options;
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
	if (_tmp1_) {
		FILE* _tmp2_ = NULL;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "%1$s %2$s\n", "gnome-mines", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	_tmp3_ = options;
	_tmp4_ = g_variant_dict_contains (_tmp3_, "small");
	if (_tmp4_) {
		mines_game_mode = 0;
	}
	_tmp5_ = options;
	_tmp6_ = g_variant_dict_contains (_tmp5_, "medium");
	if (_tmp6_) {
		mines_game_mode = 1;
	}
	_tmp7_ = options;
	_tmp8_ = g_variant_dict_contains (_tmp7_, "big");
	if (_tmp8_) {
		mines_game_mode = 2;
	}
	result = -1;
	return result;
}


static void mines_real_activate (GApplication* base) {
	Mines * self;
	GtkWindow* _tmp0_ = NULL;
	self = (Mines*) base;
	_tmp0_ = self->priv->window;
	gtk_window_present (_tmp0_);
}


static gboolean mines_view_button_press_event (Mines* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	Minefield* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->minefield;
	_tmp1_ = minefield_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Minefield* _tmp3_ = NULL;
		_tmp3_ = self->priv->minefield;
		minefield_set_paused (_tmp3_, FALSE);
		self->priv->pause_requested = FALSE;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void mines_quit_cb (Mines* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void mines_update_flag_label (Mines* self) {
	GtkLabel* _tmp0_ = NULL;
	Minefield* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	Minefield* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->flag_label;
	_tmp1_ = self->priv->minefield;
	_tmp2_ = minefield_get_n_flags (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->minefield;
	_tmp5_ = _tmp4_->n_mines;
	_tmp6_ = g_strdup_printf ("%u/%u", _tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_label_set_text (_tmp0_, _tmp7_);
	_g_free0 (_tmp7_);
}


static gint mines_show_scores (Mines* self, HistoryEntry* selected_entry, gboolean show_close) {
	gint result = 0;
	ScoreDialog* dialog = NULL;
	History* _tmp0_ = NULL;
	HistoryEntry* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	ScoreDialog* _tmp3_ = NULL;
	GtkWindow* _tmp4_ = NULL;
	gint _result_ = 0;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->history;
	_tmp1_ = selected_entry;
	_tmp2_ = show_close;
	_tmp3_ = score_dialog_new (_tmp0_, _tmp1_, _tmp2_);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	gtk_window_set_modal ((GtkWindow*) dialog, TRUE);
	_tmp4_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) dialog, _tmp4_);
	_tmp5_ = gtk_dialog_run ((GtkDialog*) dialog);
	_result_ = _tmp5_;
	gtk_widget_destroy ((GtkWidget*) dialog);
	result = _result_;
	_g_object_unref0 (dialog);
	return result;
}


static void mines_scores_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_show_scores (self, NULL, FALSE);
}


static void mines_show_custom_game_screen (Mines* self) {
	GtkStack* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp0_, "custom_game");
}


static gboolean mines_can_start_new_game (Mines* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Minefield* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->minefield;
	if (_tmp3_ != NULL) {
		Minefield* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		guint _tmp6_ = 0U;
		_tmp4_ = self->priv->minefield;
		_tmp5_ = minefield_get_n_cleared (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ > ((guint) 0);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		Minefield* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = self->priv->minefield;
		_tmp8_ = _tmp7_->exploded;
		_tmp1_ = !_tmp8_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Minefield* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		_tmp9_ = self->priv->minefield;
		_tmp10_ = minefield_get_is_complete (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp0_ = !_tmp11_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean was_paused = FALSE;
		Minefield* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		Minefield* _tmp15_ = NULL;
		GtkMessageDialog* dialog = NULL;
		GtkWindow* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		GtkMessageDialog* _tmp18_ = NULL;
		GtkMessageDialog* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		GtkMessageDialog* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gint _result_ = 0;
		GtkMessageDialog* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		GtkMessageDialog* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		_tmp12_ = self->priv->minefield;
		_tmp13_ = minefield_get_paused (_tmp12_);
		_tmp14_ = _tmp13_;
		was_paused = _tmp14_;
		_tmp15_ = self->priv->minefield;
		minefield_set_paused (_tmp15_, TRUE);
		_tmp16_ = self->priv->window;
		_tmp17_ = _ ("Do you want to start a new game?");
		_tmp18_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp16_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp17_);
		g_object_ref_sink (_tmp18_);
		dialog = _tmp18_;
		_tmp19_ = dialog;
		_tmp20_ = _ ("If you start a new game, your current progress will be lost.");
		g_object_set (_tmp19_, "secondary-text", _tmp20_, NULL);
		_tmp21_ = dialog;
		_tmp22_ = _ ("Keep Current Game");
		_tmp23_ = _ ("Start New Game");
		gtk_dialog_add_buttons ((GtkDialog*) _tmp21_, _tmp22_, GTK_RESPONSE_DELETE_EVENT, _tmp23_, GTK_RESPONSE_ACCEPT, NULL, NULL);
		_tmp24_ = dialog;
		_tmp25_ = gtk_dialog_run ((GtkDialog*) _tmp24_);
		_result_ = _tmp25_;
		_tmp26_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp26_);
		_tmp27_ = _result_;
		if (_tmp27_ != ((gint) GTK_RESPONSE_ACCEPT)) {
			Minefield* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
			_tmp28_ = self->priv->minefield;
			_tmp29_ = was_paused;
			minefield_set_paused (_tmp28_, _tmp29_);
			result = FALSE;
			_g_object_unref0 (dialog);
			return result;
		}
		_g_object_unref0 (dialog);
	}
	result = TRUE;
	return result;
}


static void mines_show_new_game_screen (Mines* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	Minefield* _tmp3_ = NULL;
	GtkWindow* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GtkButton* _tmp9_ = NULL;
	GSimpleAction* _tmp10_ = NULL;
	GSimpleAction* _tmp11_ = NULL;
	GSimpleAction* _tmp12_ = NULL;
	GtkStack* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "new_game") == 0) {
		return;
	}
	_tmp3_ = self->priv->minefield;
	if (_tmp3_ != NULL) {
		Minefield* _tmp4_ = NULL;
		Minefield* _tmp5_ = NULL;
		_tmp4_ = self->priv->minefield;
		minefield_set_paused (_tmp4_, TRUE);
		self->priv->pause_requested = FALSE;
		_tmp5_ = self->priv->minefield;
		g_signal_handlers_disconnect_by_func (_tmp5_, NULL, self);
	}
	_g_object_unref0 (self->priv->minefield);
	self->priv->minefield = NULL;
	_tmp6_ = self->priv->window;
	_tmp7_ = self->priv->window_width;
	_tmp8_ = self->priv->window_height;
	gtk_window_resize (_tmp6_, _tmp7_, _tmp8_);
	_tmp9_ = self->priv->new_game_button;
	gtk_widget_show ((GtkWidget*) _tmp9_);
	_tmp10_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp10_, FALSE);
	_tmp11_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp11_, FALSE);
	_tmp12_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp12_, FALSE);
	_tmp13_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp13_, "new_game");
}


static void _mines_marks_changed_cb_minefield_marks_changed (Minefield* _sender, gpointer self) {
	mines_marks_changed_cb ((Mines*) self, _sender);
}


static void _mines_explode_cb_minefield_explode (Minefield* _sender, gpointer self) {
	mines_explode_cb ((Mines*) self, _sender);
}


static void _mines_cleared_cb_minefield_cleared (Minefield* _sender, gpointer self) {
	mines_cleared_cb ((Mines*) self, _sender);
}


static void _mines_tick_cb_minefield_tick (Minefield* _sender, gpointer self) {
	mines_tick_cb ((Mines*) self);
}


static void _mines_paused_changed_cb_minefield_paused_changed (Minefield* _sender, gpointer self) {
	mines_paused_changed_cb ((Mines*) self);
}


static void _mines_clock_started_cb_minefield_clock_started (Minefield* _sender, gpointer self) {
	mines_clock_started_cb ((Mines*) self);
}


static void mines_start_game (Mines* self) {
	MinefieldView* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	gint x = 0;
	gint y = 0;
	gint n = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	Minefield* _tmp18_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	Minefield* _tmp23_ = NULL;
	Minefield* _tmp24_ = NULL;
	Minefield* _tmp25_ = NULL;
	Minefield* _tmp26_ = NULL;
	Minefield* _tmp27_ = NULL;
	Minefield* _tmp28_ = NULL;
	Minefield* _tmp29_ = NULL;
	GtkAspectFrame* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	MinefieldView* _tmp33_ = NULL;
	Minefield* _tmp34_ = NULL;
	gint request_x = 0;
	gint request_y = 0;
	GtkWindow* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	GtkScrolledWindow* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	GtkWindow* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	GtkScrolledWindow* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
	gint _tmp52_ = 0;
	GtkAspectFrame* _tmp59_ = NULL;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	GSimpleAction* _tmp62_ = NULL;
	GSimpleAction* _tmp63_ = NULL;
	GSimpleAction* _tmp64_ = NULL;
	Minefield* _tmp65_ = NULL;
	GtkStack* _tmp66_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->window_skip_configure = TRUE;
	_tmp0_ = self->priv->minefield_view;
	g_object_set ((GtkWidget*) _tmp0_, "has-focus", TRUE, NULL);
	_tmp1_ = self->priv->play_pause_button;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->replay_button;
	gtk_widget_hide ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->new_game_button;
	gtk_widget_hide ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->high_scores_button;
	gtk_widget_hide ((GtkWidget*) _tmp4_);
	mines_tick_cb (self);
	_tmp5_ = self->priv->settings;
	_tmp6_ = g_settings_get_int (_tmp5_, MINES_KEY_MODE);
	switch (_tmp6_) {
		case 0:
		{
			x = 8;
			y = 8;
			n = 10;
			break;
		}
		case 1:
		{
			x = 16;
			y = 16;
			n = 40;
			break;
		}
		case 2:
		{
			x = 30;
			y = 16;
			n = 99;
			break;
		}
		default:
		case 3:
		{
			GSettings* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			GSettings* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			GSettings* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			_tmp7_ = self->priv->settings;
			_tmp8_ = g_settings_get_int (_tmp7_, MINES_KEY_XSIZE);
			_tmp9_ = CLAMP (_tmp8_, MINES_XSIZE_MIN, MINES_XSIZE_MAX);
			x = _tmp9_;
			_tmp10_ = self->priv->settings;
			_tmp11_ = g_settings_get_int (_tmp10_, MINES_KEY_YSIZE);
			_tmp12_ = CLAMP (_tmp11_, MINES_YSIZE_MIN, MINES_YSIZE_MAX);
			y = _tmp12_;
			_tmp13_ = self->priv->settings;
			_tmp14_ = g_settings_get_int (_tmp13_, MINES_KEY_NMINES);
			_tmp15_ = x;
			_tmp16_ = y;
			_tmp17_ = CLAMP (_tmp14_, 1, (_tmp15_ * _tmp16_) - 10);
			n = _tmp17_;
			break;
		}
	}
	_tmp18_ = self->priv->minefield;
	if (_tmp18_ != NULL) {
		Minefield* _tmp19_ = NULL;
		_tmp19_ = self->priv->minefield;
		g_signal_handlers_disconnect_by_func (_tmp19_, NULL, self);
	}
	_tmp20_ = x;
	_tmp21_ = y;
	_tmp22_ = n;
	_tmp23_ = minefield_new ((guint) _tmp20_, (guint) _tmp21_, (guint) _tmp22_);
	_g_object_unref0 (self->priv->minefield);
	self->priv->minefield = _tmp23_;
	_tmp24_ = self->priv->minefield;
	g_signal_connect_object (_tmp24_, "marks-changed", (GCallback) _mines_marks_changed_cb_minefield_marks_changed, self, 0);
	_tmp25_ = self->priv->minefield;
	g_signal_connect_object (_tmp25_, "explode", (GCallback) _mines_explode_cb_minefield_explode, self, 0);
	_tmp26_ = self->priv->minefield;
	g_signal_connect_object (_tmp26_, "cleared", (GCallback) _mines_cleared_cb_minefield_cleared, self, 0);
	_tmp27_ = self->priv->minefield;
	g_signal_connect_object (_tmp27_, "tick", (GCallback) _mines_tick_cb_minefield_tick, self, 0);
	_tmp28_ = self->priv->minefield;
	g_signal_connect_object (_tmp28_, "paused-changed", (GCallback) _mines_paused_changed_cb_minefield_paused_changed, self, 0);
	_tmp29_ = self->priv->minefield;
	g_signal_connect_object (_tmp29_, "clock-started", (GCallback) _mines_clock_started_cb_minefield_clock_started, self, 0);
	_tmp30_ = self->priv->minefield_aspect;
	_tmp31_ = x;
	_tmp32_ = y;
	g_object_set (_tmp30_, "ratio", ((gfloat) _tmp31_) / _tmp32_, NULL);
	_tmp33_ = self->priv->minefield_view;
	_tmp34_ = self->priv->minefield;
	minefield_view_set_minefield (_tmp33_, _tmp34_);
	request_x = -1;
	request_y = -1;
	_tmp35_ = self->priv->window;
	_tmp36_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp35_);
	_tmp37_ = self->priv->scrolled;
	_tmp38_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp37_);
	_tmp39_ = x;
	_tmp40_ = gdk_screen_width ();
	if (((_tmp36_ - _tmp38_) + (30 * _tmp39_)) < _tmp40_) {
		gint _tmp41_ = 0;
		_tmp41_ = x;
		request_x = 30 * _tmp41_;
	} else {
		gint _tmp42_ = 0;
		GtkWindow* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		GtkScrolledWindow* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		_tmp42_ = gdk_screen_width ();
		_tmp43_ = self->priv->window;
		_tmp44_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp43_);
		_tmp45_ = self->priv->scrolled;
		_tmp46_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp45_);
		request_x = (_tmp42_ - _tmp44_) + _tmp46_;
	}
	_tmp47_ = self->priv->window;
	_tmp48_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp47_);
	_tmp49_ = self->priv->scrolled;
	_tmp50_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp49_);
	_tmp51_ = y;
	_tmp52_ = gdk_screen_height ();
	if (((_tmp48_ - _tmp50_) + (30 * _tmp51_)) < _tmp52_) {
		gint _tmp53_ = 0;
		_tmp53_ = y;
		request_y = 30 * _tmp53_;
	} else {
		gint _tmp54_ = 0;
		GtkWindow* _tmp55_ = NULL;
		gint _tmp56_ = 0;
		GtkScrolledWindow* _tmp57_ = NULL;
		gint _tmp58_ = 0;
		_tmp54_ = gdk_screen_height ();
		_tmp55_ = self->priv->window;
		_tmp56_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp55_);
		_tmp57_ = self->priv->scrolled;
		_tmp58_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp57_);
		request_y = (_tmp54_ - _tmp56_) + _tmp58_;
	}
	_tmp59_ = self->priv->minefield_aspect;
	_tmp60_ = request_x;
	_tmp61_ = request_y;
	gtk_widget_set_size_request ((GtkWidget*) _tmp59_, _tmp60_, _tmp61_);
	mines_update_flag_label (self);
	_tmp62_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp62_, TRUE);
	_tmp63_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp63_, TRUE);
	_tmp64_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp64_, TRUE);
	_tmp65_ = self->priv->minefield;
	minefield_set_paused (_tmp65_, FALSE);
	self->priv->pause_requested = FALSE;
	_tmp66_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp66_, "game");
}


static void mines_new_game_cb (Mines* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = mines_can_start_new_game (self);
	if (_tmp0_) {
		mines_show_new_game_screen (self);
	}
}


static void mines_repeat_size_cb (Mines* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = mines_can_start_new_game (self);
	if (_tmp0_) {
		mines_start_game (self);
	}
}


static void mines_toggle_pause_cb (Mines* self) {
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->minefield;
	_tmp2_ = minefield_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = self->priv->pause_requested;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->pause_requested = TRUE;
	} else {
		Minefield* _tmp5_ = NULL;
		Minefield* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		Minefield* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		_tmp5_ = self->priv->minefield;
		_tmp6_ = self->priv->minefield;
		_tmp7_ = minefield_get_paused (_tmp6_);
		_tmp8_ = _tmp7_;
		minefield_set_paused (_tmp5_, !_tmp8_);
		_tmp9_ = self->priv->minefield;
		_tmp10_ = minefield_get_paused (_tmp9_);
		_tmp11_ = _tmp10_;
		self->priv->pause_requested = _tmp11_;
	}
}


static void mines_paused_changed_cb (Mines* self) {
	Minefield* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkBox* _tmp6_ = NULL;
	Minefield* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->minefield;
	_tmp1_ = minefield_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		mines_display_unpause_button (self);
	} else {
		Minefield* _tmp3_ = NULL;
		gdouble _tmp4_ = 0.0;
		gdouble _tmp5_ = 0.0;
		_tmp3_ = self->priv->minefield;
		_tmp4_ = minefield_get_elapsed (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ > ((gdouble) 0)) {
			mines_display_pause_button (self);
		}
	}
	_tmp6_ = self->priv->paused_box;
	_tmp7_ = self->priv->minefield;
	_tmp8_ = minefield_get_paused (_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, _tmp9_);
}


static void mines_marks_changed_cb (Mines* self, Minefield* minefield) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	mines_update_flag_label (self);
}


static void mines_explode_cb (Mines* self, Minefield* minefield) {
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	GSimpleAction* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	_tmp0_ = self->priv->new_game_button;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->replay_button;
	_tmp2_ = _ ("Play _Again");
	gtk_button_set_label (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->replay_button;
	gtk_widget_show ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->high_scores_button;
	gtk_widget_show ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp5_, FALSE);
	_tmp6_ = self->priv->play_pause_button;
	gtk_widget_hide ((GtkWidget*) _tmp6_);
}


static void mines_cleared_cb (Mines* self, Minefield* minefield) {
	GDateTime* date = NULL;
	GDateTime* _tmp0_ = NULL;
	guint duration = 0U;
	Minefield* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	HistoryEntry* entry = NULL;
	GDateTime* _tmp4_ = NULL;
	Minefield* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	Minefield* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	Minefield* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	HistoryEntry* _tmp12_ = NULL;
	History* _tmp13_ = NULL;
	HistoryEntry* _tmp14_ = NULL;
	History* _tmp15_ = NULL;
	HistoryEntry* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	_tmp0_ = g_date_time_new_now_local ();
	date = _tmp0_;
	_tmp1_ = minefield;
	_tmp2_ = minefield_get_elapsed (_tmp1_);
	_tmp3_ = _tmp2_;
	duration = (guint) (_tmp3_ + 0.5);
	_tmp4_ = date;
	_tmp5_ = minefield;
	_tmp6_ = _tmp5_->width;
	_tmp7_ = minefield;
	_tmp8_ = _tmp7_->height;
	_tmp9_ = minefield;
	_tmp10_ = _tmp9_->n_mines;
	_tmp11_ = duration;
	_tmp12_ = history_entry_new (_tmp4_, _tmp6_, _tmp8_, _tmp10_, _tmp11_);
	entry = _tmp12_;
	_tmp13_ = self->priv->history;
	_tmp14_ = entry;
	history_add (_tmp13_, _tmp14_);
	_tmp15_ = self->priv->history;
	history_save (_tmp15_);
	_tmp16_ = entry;
	_tmp17_ = mines_show_scores (self, _tmp16_, TRUE);
	if (_tmp17_ == ((gint) GTK_RESPONSE_OK)) {
		mines_show_new_game_screen (self);
	} else {
		GtkButton* _tmp18_ = NULL;
		GtkButton* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		GtkButton* _tmp21_ = NULL;
		GtkButton* _tmp22_ = NULL;
		GSimpleAction* _tmp23_ = NULL;
		GtkButton* _tmp24_ = NULL;
		_tmp18_ = self->priv->new_game_button;
		gtk_widget_show ((GtkWidget*) _tmp18_);
		_tmp19_ = self->priv->replay_button;
		_tmp20_ = _ ("Play _Again");
		gtk_button_set_label (_tmp19_, _tmp20_);
		_tmp21_ = self->priv->replay_button;
		gtk_widget_show ((GtkWidget*) _tmp21_);
		_tmp22_ = self->priv->high_scores_button;
		gtk_widget_show ((GtkWidget*) _tmp22_);
		_tmp23_ = self->priv->pause_action;
		g_simple_action_set_enabled (_tmp23_, FALSE);
		_tmp24_ = self->priv->play_pause_button;
		gtk_widget_hide ((GtkWidget*) _tmp24_);
	}
	_g_object_unref0 (entry);
	_g_date_time_unref0 (date);
}


static void mines_clock_started_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_display_pause_button (self);
}


static void mines_tick_cb (Mines* self) {
	gint elapsed = 0;
	Minefield* _tmp0_ = NULL;
	gint hours = 0;
	gint _tmp4_ = 0;
	gint minutes = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint seconds = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	g_return_if_fail (self != NULL);
	elapsed = 0;
	_tmp0_ = self->priv->minefield;
	if (_tmp0_ != NULL) {
		Minefield* _tmp1_ = NULL;
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		_tmp1_ = self->priv->minefield;
		_tmp2_ = minefield_get_elapsed (_tmp1_);
		_tmp3_ = _tmp2_;
		elapsed = (gint) (_tmp3_ + 0.5);
	}
	_tmp4_ = elapsed;
	hours = _tmp4_ / 3600;
	_tmp5_ = elapsed;
	_tmp6_ = hours;
	minutes = (_tmp5_ - (_tmp6_ * 3600)) / 60;
	_tmp7_ = elapsed;
	_tmp8_ = hours;
	_tmp9_ = minutes;
	seconds = (_tmp7_ - (_tmp8_ * 3600)) - (_tmp9_ * 60);
	_tmp10_ = hours;
	if (_tmp10_ > 0) {
		GtkLabel* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		_tmp11_ = self->priv->clock_label;
		_tmp12_ = hours;
		_tmp13_ = minutes;
		_tmp14_ = seconds;
		_tmp15_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d∶\xE2\x80\x8E%02d", _tmp12_, _tmp13_, _tmp14_);
		_tmp16_ = _tmp15_;
		gtk_label_set_text (_tmp11_, _tmp16_);
		_g_free0 (_tmp16_);
	} else {
		GtkLabel* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		_tmp17_ = self->priv->clock_label;
		_tmp18_ = minutes;
		_tmp19_ = seconds;
		_tmp20_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d", _tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		gtk_label_set_text (_tmp17_, _tmp21_);
		_g_free0 (_tmp21_);
	}
}


static void mines_about_cb (Mines* self) {
	gchar** authors = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** artists = NULL;
	gchar* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gint artists_length1 = 0;
	gint _artists_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	GtkWindow* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Main game:");
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_strdup ("Szekeres Istvan (Pista)");
	_tmp3_ = g_strdup ("Robert Ancell");
	_tmp4_ = g_strdup ("Robert Roth");
	_tmp5_ = g_strdup ("");
	_tmp6_ = _ ("Score:");
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = g_strdup ("Horacio J. Peña");
	_tmp9_ = g_strdup ("");
	_tmp10_ = _ ("Resizing and SVG support:");
	_tmp11_ = g_strdup (_tmp10_);
	_tmp12_ = g_strdup ("Steve Chaplin");
	_tmp13_ = g_strdup ("Callum McKenzie");
	_tmp14_ = g_new0 (gchar*, 12 + 1);
	_tmp14_[0] = _tmp1_;
	_tmp14_[1] = _tmp2_;
	_tmp14_[2] = _tmp3_;
	_tmp14_[3] = _tmp4_;
	_tmp14_[4] = _tmp5_;
	_tmp14_[5] = _tmp7_;
	_tmp14_[6] = _tmp8_;
	_tmp14_[7] = _tmp9_;
	_tmp14_[8] = _tmp11_;
	_tmp14_[9] = _tmp12_;
	_tmp14_[10] = _tmp13_;
	_tmp14_[11] = NULL;
	authors = _tmp14_;
	authors_length1 = 12;
	_authors_size_ = authors_length1;
	_tmp15_ = g_strdup ("Richard Hoelscher");
	_tmp16_ = g_new0 (gchar*, 2 + 1);
	_tmp16_[0] = _tmp15_;
	_tmp16_[1] = NULL;
	artists = _tmp16_;
	artists_length1 = 2;
	_artists_size_ = artists_length1;
	_tmp17_ = g_strdup ("Ekaterina Gerasimova");
	_tmp18_ = g_new0 (gchar*, 2 + 1);
	_tmp18_[0] = _tmp17_;
	_tmp18_[1] = NULL;
	documenters = _tmp18_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp19_ = self->priv->window;
	_tmp20_ = _ ("Mines");
	_tmp21_ = _ ("Clear explosive mines off the board\n" \
"\n" \
"Mines is a part of GNOME Games.");
	_tmp22_ = _ ("translator-credits");
	gtk_show_about_dialog (_tmp19_, "name", _tmp20_, "version", VERSION, "comments", _tmp21_, "copyright", "Copyright © 1997–2008 Free Software Foundation, Inc.", "license-type", GTK_LICENSE_GPL_2_0, "authors", authors, "artists", artists, "documenters", documenters, "translator-credits", _tmp22_, "logo-icon-name", "gnome-mines", "website", "https://wiki.gnome.org/Apps/Mines", NULL, NULL);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static gfloat mines_percent_mines (Mines* self) {
	gfloat result = 0.0F;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_int (_tmp0_, MINES_KEY_NMINES);
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_int (_tmp2_, MINES_KEY_XSIZE);
	_tmp4_ = self->priv->settings;
	_tmp5_ = g_settings_get_int (_tmp4_, MINES_KEY_YSIZE);
	result = (100.0f * ((gfloat) _tmp1_)) / (_tmp3_ * _tmp5_);
	return result;
}


static void mines_set_mines_limit (Mines* self) {
	gint size = 0;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint max_mines = 0;
	gdouble _tmp4_ = 0.0;
	gint min_mines = 0;
	gdouble _tmp5_ = 0.0;
	gint _tmp6_ = 0;
	GtkSpinButton* _tmp7_ = NULL;
	GtkSpinButton* _tmp8_ = NULL;
	gfloat _tmp9_ = 0.0F;
	gdouble _tmp10_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_int (_tmp0_, MINES_KEY_XSIZE);
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_int (_tmp2_, MINES_KEY_YSIZE);
	size = _tmp1_ * _tmp3_;
	_tmp4_ = round ((gdouble) ((100.0f * ((gfloat) (size - 10))) / size));
	max_mines = (gint) _tmp4_;
	_tmp5_ = round ((gdouble) (100.0f / size));
	_tmp6_ = MAX (1, (gint) _tmp5_);
	min_mines = _tmp6_;
	_tmp7_ = self->priv->mines_spin;
	gtk_spin_button_set_range (_tmp7_, (gdouble) min_mines, (gdouble) max_mines);
	_tmp8_ = self->priv->mines_spin;
	_tmp9_ = mines_percent_mines (self);
	_tmp10_ = round ((gdouble) _tmp9_);
	gtk_spin_button_set_value (_tmp8_, (gdouble) ((gint) _tmp10_));
}


static void mines_xsize_spin_cb (Mines* self, GtkSpinButton* spin) {
	gint xsize = 0;
	GtkSpinButton* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	_tmp0_ = spin;
	_tmp1_ = gtk_spin_button_get_value_as_int (_tmp0_);
	xsize = _tmp1_;
	_tmp2_ = xsize;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, MINES_KEY_XSIZE);
	if (_tmp2_ == _tmp4_) {
		return;
	}
	_tmp5_ = self->priv->settings;
	_tmp6_ = xsize;
	g_settings_set_int (_tmp5_, MINES_KEY_XSIZE, _tmp6_);
	mines_set_mines_limit (self);
}


static void mines_ysize_spin_cb (Mines* self, GtkSpinButton* spin) {
	gint ysize = 0;
	GtkSpinButton* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	_tmp0_ = spin;
	_tmp1_ = gtk_spin_button_get_value_as_int (_tmp0_);
	ysize = _tmp1_;
	_tmp2_ = ysize;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, MINES_KEY_YSIZE);
	if (_tmp2_ == _tmp4_) {
		return;
	}
	_tmp5_ = self->priv->settings;
	_tmp6_ = ysize;
	g_settings_set_int (_tmp5_, MINES_KEY_YSIZE, _tmp6_);
	mines_set_mines_limit (self);
}


static void mines_mines_spin_cb (Mines* self, GtkSpinButton* spin) {
	gfloat _tmp0_ = 0.0F;
	GtkSpinButton* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GSettings* _tmp4_ = NULL;
	GtkSpinButton* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	GSettings* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	GSettings* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gdouble _tmp11_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	_tmp0_ = mines_percent_mines (self);
	_tmp1_ = spin;
	_tmp2_ = gtk_spin_button_get_value (_tmp1_);
	_tmp3_ = fabs (_tmp0_ - _tmp2_);
	if (_tmp3_ <= ((gdouble) 0.5f)) {
		return;
	}
	_tmp4_ = self->priv->settings;
	_tmp5_ = spin;
	_tmp6_ = gtk_spin_button_get_value (_tmp5_);
	_tmp7_ = self->priv->settings;
	_tmp8_ = g_settings_get_int (_tmp7_, MINES_KEY_XSIZE);
	_tmp9_ = self->priv->settings;
	_tmp10_ = g_settings_get_int (_tmp9_, MINES_KEY_YSIZE);
	_tmp11_ = round ((_tmp6_ * (_tmp8_ * _tmp10_)) / 100.0f);
	g_settings_set_int (_tmp4_, MINES_KEY_NMINES, (gint) _tmp11_);
}


static void mines_set_mode (Mines* self, gint mode) {
	gint _tmp0_ = 0;
	GSettings* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = mode;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_int (_tmp1_, MINES_KEY_MODE);
	if (_tmp0_ != _tmp2_) {
		GSettings* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp3_ = self->priv->settings;
		_tmp4_ = mode;
		g_settings_set_int (_tmp3_, MINES_KEY_MODE, _tmp4_);
	}
	mines_start_game (self);
}


static void mines_small_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 0);
}


static void mines_medium_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 1);
}


static void mines_large_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 2);
}


static void mines_custom_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 3);
}


static void mines_help_cb (Mines* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-mines", _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("gnome-mines.vala:804: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void mines_display_pause_button (Mines* self) {
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->replay_button;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->new_game_button;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->play_pause_button;
	gtk_widget_show ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->play_pause_label;
	_tmp4_ = _ ("_Pause");
	gtk_label_set_label (_tmp3_, _tmp4_);
}


static void mines_display_unpause_button (Mines* self) {
	GtkButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->replay_button;
	_tmp1_ = _ ("St_art Over");
	gtk_button_set_label (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->replay_button;
	gtk_widget_show ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->new_game_button;
	gtk_widget_show ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->play_pause_button;
	gtk_widget_show ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->play_pause_label;
	_tmp6_ = _ ("_Resume");
	gtk_label_set_label (_tmp5_, _tmp6_);
}


gint mines_main (gchar** args, int args_length1) {
	gint result = 0;
	Mines* app = NULL;
	Mines* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = mines_new ();
	app = _tmp0_;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = g_application_run ((GApplication*) app, _tmp1__length1, _tmp1_);
	result = _tmp2_;
	_g_object_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return mines_main (argv, argc);
}


static void mines_class_init (MinesClass * klass) {
	mines_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MinesPrivate));
	((GApplicationClass *) klass)->startup = mines_real_startup;
	((GApplicationClass *) klass)->shutdown = mines_real_shutdown;
	((GApplicationClass *) klass)->handle_local_options = mines_real_handle_local_options;
	((GApplicationClass *) klass)->activate = mines_real_activate;
	G_OBJECT_CLASS (klass)->finalize = mines_finalize;
	mines_game_mode = -1;
}


static void mines_instance_init (Mines * self) {
	self->priv = MINES_GET_PRIVATE (self);
}


static void mines_finalize (GObject* obj) {
	Mines * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINES, Mines);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->main_screen);
	_g_object_unref0 (self->priv->play_pause_button);
	_g_object_unref0 (self->priv->play_pause_label);
	_g_object_unref0 (self->priv->replay_button);
	_g_object_unref0 (self->priv->high_scores_button);
	_g_object_unref0 (self->priv->new_game_button);
	_g_object_unref0 (self->priv->minefield_aspect);
	_g_object_unref0 (self->priv->minefield_overlay);
	_g_object_unref0 (self->priv->paused_box);
	_g_object_unref0 (self->priv->scrolled);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->clock_label);
	_g_object_unref0 (self->priv->app_main_menu);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->minefield);
	_g_object_unref0 (self->priv->minefield_view);
	_g_object_unref0 (self->priv->flag_label);
	_g_object_unref0 (self->priv->mines_spin);
	_g_object_unref0 (self->priv->new_game_action);
	_g_object_unref0 (self->priv->repeat_size_action);
	_g_object_unref0 (self->priv->pause_action);
	_g_object_unref0 (self->priv->new_game_screen);
	_g_object_unref0 (self->priv->custom_game_screen);
	G_OBJECT_CLASS (mines_parent_class)->finalize (obj);
}


GType mines_get_type (void) {
	static volatile gsize mines_type_id__volatile = 0;
	if (g_once_init_enter (&mines_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MinesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mines_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Mines), 0, (GInstanceInitFunc) mines_instance_init, NULL };
		GType mines_type_id;
		mines_type_id = g_type_register_static (gtk_application_get_type (), "Mines", &g_define_type_info, 0);
		g_once_init_leave (&mines_type_id__volatile, mines_type_id);
	}
	return mines_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



