/* repository.c generated by valac 0.25.1.21-9d0d5, the Vala compiler
 * generated from repository.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2013 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "libgitg/libgitg.h"
#include <libgit2-glib/ggit.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <gio/gio.h>
#include <gitg-assert.h>
#include <glib/gstdio.h>


#define GITG_TEST_TYPE_TEST (gitg_test_test_get_type ())
#define GITG_TEST_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_TEST, GitgTestTest))
#define GITG_TEST_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_TEST, GitgTestTestClass))
#define GITG_TEST_IS_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_TEST))
#define GITG_TEST_IS_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_TEST))
#define GITG_TEST_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_TEST, GitgTestTestClass))

typedef struct _GitgTestTest GitgTestTest;
typedef struct _GitgTestTestClass GitgTestTestClass;
typedef struct _GitgTestTestPrivate GitgTestTestPrivate;

#define GITG_TEST_TYPE_REPOSITORY (gitg_test_repository_get_type ())
#define GITG_TEST_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_REPOSITORY, GitgTestRepository))
#define GITG_TEST_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryClass))
#define GITG_TEST_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_REPOSITORY))
#define GITG_TEST_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_REPOSITORY))
#define GITG_TEST_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryClass))

typedef struct _GitgTestRepository GitgTestRepository;
typedef struct _GitgTestRepositoryClass GitgTestRepositoryClass;
typedef struct _GitgTestRepositoryPrivate GitgTestRepositoryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_TEST_REPOSITORY_TYPE_FILE (gitg_test_repository_file_get_type ())
typedef struct _GitgTestRepositoryFile GitgTestRepositoryFile;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _ggit_index_entry_unref0(var) ((var == NULL) ? NULL : (var = (ggit_index_entry_unref (var), NULL)))

struct _GitgTestTest {
	GObject parent_instance;
	GitgTestTestPrivate * priv;
};

struct _GitgTestTestClass {
	GObjectClass parent_class;
	void (*set_up) (GitgTestTest* self);
	void (*tear_down) (GitgTestTest* self);
};

struct _GitgTestRepository {
	GitgTestTest parent_instance;
	GitgTestRepositoryPrivate * priv;
	GitgRepository* d_repository;
};

struct _GitgTestRepositoryClass {
	GitgTestTestClass parent_class;
};

struct _GitgTestRepositoryPrivate {
	GgitCommit* d_last_commit;
};

struct _GitgTestRepositoryFile {
	gchar* filename;
	gchar* contents;
};


static gpointer gitg_test_repository_parent_class = NULL;

GType gitg_test_test_get_type (void) G_GNUC_CONST;
GType gitg_test_repository_get_type (void) G_GNUC_CONST;
#define GITG_TEST_REPOSITORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryPrivate))
enum  {
	GITG_TEST_REPOSITORY_DUMMY_PROPERTY
};
static GType gitg_test_repository_file_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GitgTestRepositoryFile* gitg_test_repository_file_dup (const GitgTestRepositoryFile* self);
static void gitg_test_repository_file_free (GitgTestRepositoryFile* self);
static void gitg_test_repository_file_copy (const GitgTestRepositoryFile* self, GitgTestRepositoryFile* dest);
static void gitg_test_repository_file_destroy (GitgTestRepositoryFile* self);
static GitgTestRepositoryFile* gitg_test_repository_files_from_varargs (GitgTestRepository* self, const gchar* filename, va_list l, int* result_length1);
static void _vala_array_add2 (GitgTestRepositoryFile** array, int* length, int* size, const GitgTestRepositoryFile* value);
static void _vala_GitgTestRepositoryFile_array_free (GitgTestRepositoryFile* array, gint array_length);
static GitgTestRepositoryFile* gitg_test_repository_filenames_from_varargs (GitgTestRepository* self, const gchar* filename, va_list l, int* result_length1);
static void _vala_array_add3 (GitgTestRepositoryFile** array, int* length, int* size, const GitgTestRepositoryFile* value);
static void gitg_test_repository_write_files (GitgTestRepository* self, GitgTestRepositoryFile* files, int files_length1);
void gitg_test_repository_commit (GitgTestRepository* self, const gchar* filename, ...);
static void _vala_GgitOId_free (GgitOId* self);
void gitg_test_repository_workdir_remove (GitgTestRepository* self, const gchar* filename, ...);
void gitg_test_repository_workdir_modify (GitgTestRepository* self, const gchar* filename, ...);
void gitg_test_repository_index_modify (GitgTestRepository* self, const gchar* filename, ...);
static void gitg_test_repository_real_set_up (GitgTestTest* base);
static void gitg_test_repository_real_tear_down (GitgTestTest* base);
GitgTestRepository* gitg_test_repository_new (void);
GitgTestRepository* gitg_test_repository_construct (GType object_type);
GitgTestTest* gitg_test_test_new (void);
GitgTestTest* gitg_test_test_construct (GType object_type);
static void gitg_test_repository_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _vala_array_add2 (GitgTestRepositoryFile** array, int* length, int* size, const GitgTestRepositoryFile* value) {
#line 41 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if ((*length) == (*size)) {
#line 41 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 41 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		*array = g_renew (GitgTestRepositoryFile, *array, *size);
#line 139 "repository.c"
	}
#line 41 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	(*array)[(*length)++] = *value;
#line 143 "repository.c"
}


static void _vala_GitgTestRepositoryFile_array_free (GitgTestRepositoryFile* array, gint array_length) {
#line 33 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if (array != NULL) {
#line 150 "repository.c"
		int i;
#line 33 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 33 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			gitg_test_repository_file_destroy (&array[i]);
#line 156 "repository.c"
		}
	}
#line 33 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	g_free (array);
#line 161 "repository.c"
}


static GitgTestRepositoryFile* gitg_test_repository_files_from_varargs (GitgTestRepository* self, const gchar* filename, va_list l, int* result_length1) {
	GitgTestRepositoryFile* result = NULL;
	GitgTestRepositoryFile* files = NULL;
	GitgTestRepositoryFile* _tmp0_ = NULL;
	gint files_length1 = 0;
	gint _files_size_ = 0;
	GitgTestRepositoryFile* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
#line 33 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 35 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp0_ = g_new0 (GitgTestRepositoryFile, 0);
#line 35 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	files = _tmp0_;
#line 35 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	files_length1 = 0;
#line 35 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_files_size_ = files_length1;
#line 37 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	while (TRUE) {
#line 185 "repository.c"
		const gchar* _tmp1_ = NULL;
		gchar* contents = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		GitgTestRepositoryFile* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		GitgTestRepositoryFile _tmp9_ = {0};
		const gchar* _tmp10_ = NULL;
#line 37 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp1_ = filename;
#line 37 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		if (!(_tmp1_ != NULL)) {
#line 37 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			break;
#line 204 "repository.c"
		}
#line 39 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp2_ = va_arg (l, gchar*);
#line 39 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 39 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		contents = _tmp3_;
#line 41 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp4_ = files;
#line 41 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp4__length1 = files_length1;
#line 41 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp5_ = filename;
#line 41 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 41 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp7_ = contents;
#line 41 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp8_ = g_strdup (_tmp7_);
#line 41 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		memset (&_tmp9_, 0, sizeof (GitgTestRepositoryFile));
#line 41 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_free0 (_tmp9_.filename);
#line 41 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp9_.filename = _tmp6_;
#line 41 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_free0 (_tmp9_.contents);
#line 41 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp9_.contents = _tmp8_;
#line 41 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_vala_array_add2 (&files, &files_length1, &_files_size_, &_tmp9_);
#line 46 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp10_ = va_arg (l, gchar*);
#line 46 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		filename = _tmp10_;
#line 37 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_free0 (contents);
#line 242 "repository.c"
	}
#line 49 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp11_ = files;
#line 49 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp11__length1 = files_length1;
#line 49 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if (result_length1) {
#line 49 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		*result_length1 = _tmp11__length1;
#line 252 "repository.c"
	}
#line 49 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	result = _tmp11_;
#line 49 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	return result;
#line 258 "repository.c"
}


static void _vala_array_add3 (GitgTestRepositoryFile** array, int* length, int* size, const GitgTestRepositoryFile* value) {
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if ((*length) == (*size)) {
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		*array = g_renew (GitgTestRepositoryFile, *array, *size);
#line 269 "repository.c"
	}
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	(*array)[(*length)++] = *value;
#line 273 "repository.c"
}


static GitgTestRepositoryFile* gitg_test_repository_filenames_from_varargs (GitgTestRepository* self, const gchar* filename, va_list l, int* result_length1) {
	GitgTestRepositoryFile* result = NULL;
	GitgTestRepositoryFile* files = NULL;
	GitgTestRepositoryFile* _tmp0_ = NULL;
	gint files_length1 = 0;
	gint _files_size_ = 0;
	GitgTestRepositoryFile* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 52 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 54 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp0_ = g_new0 (GitgTestRepositoryFile, 0);
#line 54 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	files = _tmp0_;
#line 54 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	files_length1 = 0;
#line 54 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_files_size_ = files_length1;
#line 56 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	while (TRUE) {
#line 297 "repository.c"
		const gchar* _tmp1_ = NULL;
		GitgTestRepositoryFile* _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		GitgTestRepositoryFile _tmp5_ = {0};
		const gchar* _tmp6_ = NULL;
#line 56 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp1_ = filename;
#line 56 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		if (!(_tmp1_ != NULL)) {
#line 56 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			break;
#line 311 "repository.c"
		}
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp2_ = files;
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp2__length1 = files_length1;
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp3_ = filename;
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		memset (&_tmp5_, 0, sizeof (GitgTestRepositoryFile));
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_free0 (_tmp5_.filename);
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp5_.filename = _tmp4_;
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_free0 (_tmp5_.contents);
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp5_.contents = NULL;
#line 58 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_vala_array_add3 (&files, &files_length1, &_files_size_, &_tmp5_);
#line 63 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp6_ = va_arg (l, gchar*);
#line 63 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		filename = _tmp6_;
#line 337 "repository.c"
	}
#line 66 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp7_ = files;
#line 66 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp7__length1 = files_length1;
#line 66 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if (result_length1) {
#line 66 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		*result_length1 = _tmp7__length1;
#line 347 "repository.c"
	}
#line 66 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	result = _tmp7_;
#line 66 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	return result;
#line 353 "repository.c"
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
#line 1300 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1301 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1301 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1301 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1302 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1302 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1302 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1302 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1303 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1303 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1303 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1303 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1303 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1303 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 397 "repository.c"
	}
#line 1303 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1303 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 403 "repository.c"
}


static void gitg_test_repository_write_files (GitgTestRepository* self, GitgTestRepositoryFile* files, int files_length1) {
	GFile* wd = NULL;
	GitgRepository* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GitgTestRepositoryFile* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	GError * _inner_error_ = NULL;
#line 69 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	g_return_if_fail (self != NULL);
#line 71 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp0_ = self->d_repository;
#line 71 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _tmp0_);
#line 71 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	wd = _tmp1_;
#line 73 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp2_ = files;
#line 73 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp2__length1 = files_length1;
#line 426 "repository.c"
	{
		GitgTestRepositoryFile* f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
#line 73 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		f_collection = _tmp2_;
#line 73 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		f_collection_length1 = _tmp2__length1;
#line 73 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		for (f_it = 0; f_it < _tmp2__length1; f_it = f_it + 1) {
#line 438 "repository.c"
			GitgTestRepositoryFile _tmp3_ = {0};
			GitgTestRepositoryFile f = {0};
#line 73 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			gitg_test_repository_file_copy (&f_collection[f_it], &_tmp3_);
#line 73 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			f = _tmp3_;
#line 445 "repository.c"
			{
				GFile* fp = NULL;
				GFile* _tmp4_ = NULL;
				GitgTestRepositoryFile _tmp5_ = {0};
				const gchar* _tmp6_ = NULL;
				GFile* _tmp7_ = NULL;
#line 75 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				_tmp4_ = wd;
#line 75 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				_tmp5_ = f;
#line 75 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				_tmp6_ = _tmp5_.filename;
#line 75 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				_tmp7_ = g_file_get_child (_tmp4_, _tmp6_);
#line 75 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				fp = _tmp7_;
#line 462 "repository.c"
				{
					GFileOutputStream* os = NULL;
					GFile* _tmp8_ = NULL;
					GFileOutputStream* _tmp9_ = NULL;
					GFileOutputStream* _tmp10_ = NULL;
					GitgTestRepositoryFile _tmp11_ = {0};
					const gchar* _tmp12_ = NULL;
					guint8* _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					guint8* _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					GFileOutputStream* _tmp15_ = NULL;
#line 79 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp8_ = fp;
#line 79 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp9_ = g_file_replace (_tmp8_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 79 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					os = _tmp9_;
#line 79 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 483 "repository.c"
						goto __catch0_g_error;
					}
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp10_ = os;
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp11_ = f;
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp12_ = _tmp11_.contents;
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp13_ = string_get_data (_tmp12_, &_tmp13__length1);
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp14_ = _tmp13_;
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp14__length1 = _tmp13__length1;
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					g_output_stream_write ((GOutputStream*) _tmp10_, _tmp14_, (gsize) _tmp14__length1, NULL, &_inner_error_);
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
						_g_object_unref0 (os);
#line 504 "repository.c"
						goto __catch0_g_error;
					}
#line 81 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp15_ = os;
#line 81 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					g_output_stream_close ((GOutputStream*) _tmp15_, NULL, &_inner_error_);
#line 81 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 81 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
						_g_object_unref0 (os);
#line 515 "repository.c"
						goto __catch0_g_error;
					}
#line 77 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_g_object_unref0 (os);
#line 520 "repository.c"
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp16_ = NULL;
#line 77 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					e = _inner_error_;
#line 77 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_inner_error_ = NULL;
#line 85 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp16_ = e;
#line 85 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					gitg_test_assert_assert_no_error (_tmp16_);
#line 77 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_g_error_free0 (e);
#line 537 "repository.c"
				}
				__finally0:
#line 77 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 77 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_g_object_unref0 (fp);
#line 77 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					gitg_test_repository_file_destroy (&f);
#line 77 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_g_object_unref0 (wd);
#line 77 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 77 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					g_clear_error (&_inner_error_);
#line 77 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					return;
#line 554 "repository.c"
				}
#line 73 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				_g_object_unref0 (fp);
#line 73 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				gitg_test_repository_file_destroy (&f);
#line 560 "repository.c"
			}
		}
	}
#line 69 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_g_object_unref0 (wd);
#line 566 "repository.c"
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 131 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 573 "repository.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 173 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	return self ? g_object_ref (self) : NULL;
#line 580 "repository.c"
}


void gitg_test_repository_commit (GitgTestRepository* self, const gchar* filename, ...) {
	GitgRepository* _tmp0_ = NULL;
	GitgTestRepositoryFile* files = NULL;
	const gchar* _tmp1_ = NULL;
	va_list _tmp2_ = {0};
	gint _tmp3_ = 0;
	GitgTestRepositoryFile* _tmp4_ = NULL;
	GitgTestRepositoryFile* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint files_length1 = 0;
	gint _files_size_ = 0;
	GitgTestRepositoryFile* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	GgitIndex* index = NULL;
	GitgTestRepositoryFile* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	GgitOId* treeoid = NULL;
	GgitSignature* sig = NULL;
	GgitTree* tree = NULL;
	GgitOId* commitoid = NULL;
	GError * _inner_error_ = NULL;
#line 90 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	g_return_if_fail (self != NULL);
#line 92 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp0_ = self->d_repository;
#line 92 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if (_tmp0_ == NULL) {
#line 94 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 613 "repository.c"
	}
#line 97 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp1_ = filename;
#line 97 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	va_start (_tmp2_, filename);
#line 97 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp4_ = gitg_test_repository_files_from_varargs (self, _tmp1_, _tmp2_, &_tmp3_);
#line 97 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp5_ = _tmp4_;
#line 97 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp5__length1 = _tmp3_;
#line 97 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	va_end (_tmp2_);
#line 97 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	files = _tmp5_;
#line 97 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	files_length1 = _tmp5__length1;
#line 97 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_files_size_ = files_length1;
#line 98 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp6_ = files;
#line 98 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp6__length1 = files_length1;
#line 98 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	gitg_test_repository_write_files (self, _tmp6_, _tmp6__length1);
#line 639 "repository.c"
	{
		GgitIndex* _tmp7_ = NULL;
		GitgRepository* _tmp8_ = NULL;
		GgitIndex* _tmp9_ = NULL;
		GgitIndex* _tmp10_ = NULL;
#line 106 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp8_ = self->d_repository;
#line 106 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp9_ = ggit_repository_get_index ((GgitRepository*) _tmp8_, &_inner_error_);
#line 106 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp7_ = _tmp9_;
#line 106 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 653 "repository.c"
			goto __catch1_g_error;
		}
#line 106 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp10_ = _tmp7_;
#line 106 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp7_ = NULL;
#line 106 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (index);
#line 106 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		index = _tmp10_;
#line 104 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (_tmp7_);
#line 666 "repository.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_ = NULL;
#line 104 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		e = _inner_error_;
#line 104 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_inner_error_ = NULL;
#line 110 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp11_ = e;
#line 110 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		gitg_test_assert_assert_no_error (_tmp11_);
#line 111 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_error_free0 (e);
#line 111 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (index);
#line 111 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 111 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 689 "repository.c"
	}
	__finally1:
#line 104 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 104 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (index);
#line 104 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 104 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 104 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_clear_error (&_inner_error_);
#line 104 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 704 "repository.c"
	}
#line 114 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp12_ = files;
#line 114 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp12__length1 = files_length1;
#line 710 "repository.c"
	{
		GitgTestRepositoryFile* f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
#line 114 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		f_collection = _tmp12_;
#line 114 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		f_collection_length1 = _tmp12__length1;
#line 114 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		for (f_it = 0; f_it < _tmp12__length1; f_it = f_it + 1) {
#line 722 "repository.c"
			GitgTestRepositoryFile _tmp13_ = {0};
			GitgTestRepositoryFile f = {0};
#line 114 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			gitg_test_repository_file_copy (&f_collection[f_it], &_tmp13_);
#line 114 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			f = _tmp13_;
#line 729 "repository.c"
			{
				{
					GgitIndex* _tmp14_ = NULL;
					GitgTestRepositoryFile _tmp15_ = {0};
					const gchar* _tmp16_ = NULL;
#line 118 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp14_ = index;
#line 118 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp15_ = f;
#line 118 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp16_ = _tmp15_.filename;
#line 118 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					ggit_index_add_path (_tmp14_, _tmp16_, &_inner_error_);
#line 118 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 745 "repository.c"
						goto __catch2_g_error;
					}
				}
				goto __finally2;
				__catch2_g_error:
				{
					GError* e = NULL;
					GError* _tmp17_ = NULL;
#line 116 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					e = _inner_error_;
#line 116 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_inner_error_ = NULL;
#line 122 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp17_ = e;
#line 122 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					gitg_test_assert_assert_no_error (_tmp17_);
#line 116 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_g_error_free0 (e);
#line 764 "repository.c"
				}
				__finally2:
#line 116 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 116 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					gitg_test_repository_file_destroy (&f);
#line 116 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_g_object_unref0 (index);
#line 116 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 116 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 116 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					g_clear_error (&_inner_error_);
#line 116 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					return;
#line 781 "repository.c"
				}
#line 114 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				gitg_test_repository_file_destroy (&f);
#line 785 "repository.c"
			}
		}
	}
	{
		GgitIndex* _tmp18_ = NULL;
		GgitOId* _tmp19_ = NULL;
		GgitIndex* _tmp20_ = NULL;
		GgitOId* _tmp21_ = NULL;
		GgitOId* _tmp22_ = NULL;
#line 130 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp18_ = index;
#line 130 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		ggit_index_write (_tmp18_, &_inner_error_);
#line 130 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 801 "repository.c"
			goto __catch3_g_error;
		}
#line 131 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp20_ = index;
#line 131 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp21_ = ggit_index_write_tree (_tmp20_, &_inner_error_);
#line 131 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp19_ = _tmp21_;
#line 131 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 812 "repository.c"
			goto __catch3_g_error;
		}
#line 131 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp22_ = _tmp19_;
#line 131 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp19_ = NULL;
#line 131 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		__vala_GgitOId_free0 (treeoid);
#line 131 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		treeoid = _tmp22_;
#line 128 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		__vala_GgitOId_free0 (_tmp19_);
#line 825 "repository.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_ = NULL;
#line 128 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		e = _inner_error_;
#line 128 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_inner_error_ = NULL;
#line 135 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp23_ = e;
#line 135 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		gitg_test_assert_assert_no_error (_tmp23_);
#line 136 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_error_free0 (e);
#line 136 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		__vala_GgitOId_free0 (treeoid);
#line 136 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (index);
#line 136 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 136 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 850 "repository.c"
	}
	__finally3:
#line 128 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 128 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		__vala_GgitOId_free0 (treeoid);
#line 128 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (index);
#line 128 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 128 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 128 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_clear_error (&_inner_error_);
#line 128 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 867 "repository.c"
	}
	{
		GgitSignature* _tmp24_ = NULL;
		GgitSignature* _tmp25_ = NULL;
		GgitSignature* _tmp26_ = NULL;
#line 144 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp25_ = ggit_signature_new_now ("gitg tester", "gitg-tester@gnome.org", &_inner_error_);
#line 144 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp24_ = _tmp25_;
#line 144 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 879 "repository.c"
			goto __catch4_g_error;
		}
#line 144 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp26_ = _tmp24_;
#line 144 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp24_ = NULL;
#line 144 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (sig);
#line 144 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		sig = _tmp26_;
#line 142 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (_tmp24_);
#line 892 "repository.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp27_ = NULL;
#line 142 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		e = _inner_error_;
#line 142 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_inner_error_ = NULL;
#line 149 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp27_ = e;
#line 149 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		gitg_test_assert_assert_no_error (_tmp27_);
#line 150 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_error_free0 (e);
#line 150 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (sig);
#line 150 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		__vala_GgitOId_free0 (treeoid);
#line 150 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (index);
#line 150 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 150 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 919 "repository.c"
	}
	__finally4:
#line 142 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 142 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (sig);
#line 142 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		__vala_GgitOId_free0 (treeoid);
#line 142 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (index);
#line 142 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 142 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 142 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_clear_error (&_inner_error_);
#line 142 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 938 "repository.c"
	}
	{
		GgitTree* _tmp28_ = NULL;
		GitgRepository* _tmp29_ = NULL;
		GgitOId* _tmp30_ = NULL;
		gpointer _tmp31_ = NULL;
		GgitTree* _tmp32_ = NULL;
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp29_ = self->d_repository;
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp30_ = treeoid;
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp31_ = gitg_repository_lookup (_tmp29_, ggit_tree_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp30_, &_inner_error_);
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp28_ = (GgitTree*) _tmp31_;
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 956 "repository.c"
			goto __catch5_g_error;
		}
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp32_ = _tmp28_;
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp28_ = NULL;
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (tree);
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		tree = _tmp32_;
#line 155 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (_tmp28_);
#line 969 "repository.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp33_ = NULL;
#line 155 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		e = _inner_error_;
#line 155 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_inner_error_ = NULL;
#line 161 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp33_ = e;
#line 161 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		gitg_test_assert_assert_no_error (_tmp33_);
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_error_free0 (e);
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (tree);
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (sig);
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		__vala_GgitOId_free0 (treeoid);
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (index);
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 998 "repository.c"
	}
	__finally5:
#line 155 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 155 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (tree);
#line 155 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (sig);
#line 155 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		__vala_GgitOId_free0 (treeoid);
#line 155 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (index);
#line 155 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 155 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 155 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_clear_error (&_inner_error_);
#line 155 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 1019 "repository.c"
	}
	{
		GgitCommit** parents = NULL;
		gint parents_length1 = 0;
		gint _parents_size_ = 0;
		GgitCommit* _tmp34_ = NULL;
		GgitOId* _tmp39_ = NULL;
		GitgRepository* _tmp40_ = NULL;
		GgitSignature* _tmp41_ = NULL;
		GgitSignature* _tmp42_ = NULL;
		GgitTree* _tmp43_ = NULL;
		GgitCommit** _tmp44_ = NULL;
		gint _tmp44__length1 = 0;
		GgitOId* _tmp45_ = NULL;
		GgitOId* _tmp46_ = NULL;
#line 171 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp34_ = self->priv->d_last_commit;
#line 171 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		if (_tmp34_ != NULL) {
#line 1039 "repository.c"
			GgitCommit* _tmp35_ = NULL;
			GgitCommit* _tmp36_ = NULL;
			GgitCommit** _tmp37_ = NULL;
#line 173 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			_tmp35_ = self->priv->d_last_commit;
#line 173 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			_tmp36_ = _g_object_ref0 (_tmp35_);
#line 173 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			_tmp37_ = g_new0 (GgitCommit*, 1 + 1);
#line 173 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			_tmp37_[0] = _tmp36_;
#line 173 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			parents = (_vala_array_free (parents, parents_length1, (GDestroyNotify) g_object_unref), NULL);
#line 173 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			parents = _tmp37_;
#line 173 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			parents_length1 = 1;
#line 173 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			_parents_size_ = parents_length1;
#line 1059 "repository.c"
		} else {
			GgitCommit** _tmp38_ = NULL;
#line 177 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			_tmp38_ = g_new0 (GgitCommit*, 0 + 1);
#line 177 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			parents = (_vala_array_free (parents, parents_length1, (GDestroyNotify) g_object_unref), NULL);
#line 177 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			parents = _tmp38_;
#line 177 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			parents_length1 = 0;
#line 177 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			_parents_size_ = parents_length1;
#line 1072 "repository.c"
		}
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp40_ = self->d_repository;
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp41_ = sig;
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp42_ = sig;
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp43_ = tree;
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp44_ = parents;
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp44__length1 = parents_length1;
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp45_ = ggit_repository_create_commit ((GgitRepository*) _tmp40_, "HEAD", _tmp41_, _tmp42_, NULL, "Initial commit", _tmp43_, _tmp44_, _tmp44__length1, &_inner_error_);
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp39_ = _tmp45_;
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			parents = (_vala_array_free (parents, parents_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1094 "repository.c"
			goto __catch6_g_error;
		}
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp46_ = _tmp39_;
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp39_ = NULL;
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		__vala_GgitOId_free0 (commitoid);
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		commitoid = _tmp46_;
#line 167 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		__vala_GgitOId_free0 (_tmp39_);
#line 167 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		parents = (_vala_array_free (parents, parents_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1109 "repository.c"
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp47_ = NULL;
#line 167 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		e = _inner_error_;
#line 167 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_inner_error_ = NULL;
#line 190 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp47_ = e;
#line 190 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		gitg_test_assert_assert_no_error (_tmp47_);
#line 191 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_error_free0 (e);
#line 191 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		__vala_GgitOId_free0 (commitoid);
#line 191 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (tree);
#line 191 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (sig);
#line 191 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		__vala_GgitOId_free0 (treeoid);
#line 191 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (index);
#line 191 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 191 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 1140 "repository.c"
	}
	__finally6:
#line 167 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 167 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		__vala_GgitOId_free0 (commitoid);
#line 167 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (tree);
#line 167 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (sig);
#line 167 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		__vala_GgitOId_free0 (treeoid);
#line 167 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (index);
#line 167 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 167 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 167 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_clear_error (&_inner_error_);
#line 167 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 1163 "repository.c"
	}
	{
		GgitCommit* _tmp48_ = NULL;
		GitgRepository* _tmp49_ = NULL;
		GgitOId* _tmp50_ = NULL;
		gpointer _tmp51_ = NULL;
		GgitCommit* _tmp52_ = NULL;
#line 196 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp49_ = self->d_repository;
#line 196 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp50_ = commitoid;
#line 196 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp51_ = gitg_repository_lookup (_tmp49_, ggit_commit_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp50_, &_inner_error_);
#line 196 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp48_ = (GgitCommit*) _tmp51_;
#line 196 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1181 "repository.c"
			goto __catch7_g_error;
		}
#line 196 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp52_ = _tmp48_;
#line 196 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp48_ = NULL;
#line 196 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (self->priv->d_last_commit);
#line 196 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		self->priv->d_last_commit = _tmp52_;
#line 194 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (_tmp48_);
#line 1194 "repository.c"
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp53_ = NULL;
#line 194 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		e = _inner_error_;
#line 194 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_inner_error_ = NULL;
#line 200 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp53_ = e;
#line 200 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		gitg_test_assert_assert_no_error (_tmp53_);
#line 194 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_error_free0 (e);
#line 1211 "repository.c"
	}
	__finally7:
#line 194 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 194 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		__vala_GgitOId_free0 (commitoid);
#line 194 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (tree);
#line 194 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (sig);
#line 194 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		__vala_GgitOId_free0 (treeoid);
#line 194 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (index);
#line 194 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 194 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 194 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_clear_error (&_inner_error_);
#line 194 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 1234 "repository.c"
	}
#line 90 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	__vala_GgitOId_free0 (commitoid);
#line 90 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_g_object_unref0 (tree);
#line 90 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_g_object_unref0 (sig);
#line 90 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	__vala_GgitOId_free0 (treeoid);
#line 90 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_g_object_unref0 (index);
#line 90 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 1248 "repository.c"
}


void gitg_test_repository_workdir_remove (GitgTestRepository* self, const gchar* filename, ...) {
	GitgRepository* _tmp0_ = NULL;
	GitgTestRepositoryFile* files = NULL;
	const gchar* _tmp1_ = NULL;
	va_list _tmp2_ = {0};
	gint _tmp3_ = 0;
	GitgTestRepositoryFile* _tmp4_ = NULL;
	GitgTestRepositoryFile* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint files_length1 = 0;
	gint _files_size_ = 0;
	GFile* wd = NULL;
	GitgRepository* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	GitgTestRepositoryFile* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	GError * _inner_error_ = NULL;
#line 204 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	g_return_if_fail (self != NULL);
#line 206 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp0_ = self->d_repository;
#line 206 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if (_tmp0_ == NULL) {
#line 208 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 1277 "repository.c"
	}
#line 211 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp1_ = filename;
#line 211 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	va_start (_tmp2_, filename);
#line 211 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp4_ = gitg_test_repository_filenames_from_varargs (self, _tmp1_, _tmp2_, &_tmp3_);
#line 211 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp5_ = _tmp4_;
#line 211 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp5__length1 = _tmp3_;
#line 211 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	va_end (_tmp2_);
#line 211 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	files = _tmp5_;
#line 211 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	files_length1 = _tmp5__length1;
#line 211 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_files_size_ = files_length1;
#line 212 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp6_ = self->d_repository;
#line 212 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp7_ = ggit_repository_get_workdir ((GgitRepository*) _tmp6_);
#line 212 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	wd = _tmp7_;
#line 214 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp8_ = files;
#line 214 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp8__length1 = files_length1;
#line 1307 "repository.c"
	{
		GitgTestRepositoryFile* f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
#line 214 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		f_collection = _tmp8_;
#line 214 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		f_collection_length1 = _tmp8__length1;
#line 214 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		for (f_it = 0; f_it < _tmp8__length1; f_it = f_it + 1) {
#line 1319 "repository.c"
			GitgTestRepositoryFile _tmp9_ = {0};
			GitgTestRepositoryFile f = {0};
#line 214 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			gitg_test_repository_file_copy (&f_collection[f_it], &_tmp9_);
#line 214 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			f = _tmp9_;
#line 1326 "repository.c"
			{
				GFile* fs = NULL;
				GFile* _tmp10_ = NULL;
				GitgTestRepositoryFile _tmp11_ = {0};
				const gchar* _tmp12_ = NULL;
				GFile* _tmp13_ = NULL;
#line 216 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				_tmp10_ = wd;
#line 216 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				_tmp11_ = f;
#line 216 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				_tmp12_ = _tmp11_.filename;
#line 216 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				_tmp13_ = g_file_get_child (_tmp10_, _tmp12_);
#line 216 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				fs = _tmp13_;
#line 1343 "repository.c"
				{
					GFile* _tmp14_ = NULL;
#line 220 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp14_ = fs;
#line 220 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					g_file_delete (_tmp14_, NULL, &_inner_error_);
#line 220 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1352 "repository.c"
						goto __catch8_g_error;
					}
				}
				goto __finally8;
				__catch8_g_error:
				{
					GError* e = NULL;
					GError* _tmp15_ = NULL;
#line 218 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					e = _inner_error_;
#line 218 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_inner_error_ = NULL;
#line 224 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp15_ = e;
#line 224 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					gitg_test_assert_assert_no_error (_tmp15_);
#line 218 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_g_error_free0 (e);
#line 1371 "repository.c"
				}
				__finally8:
#line 218 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 218 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_g_object_unref0 (fs);
#line 218 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					gitg_test_repository_file_destroy (&f);
#line 218 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_g_object_unref0 (wd);
#line 218 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 218 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 218 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					g_clear_error (&_inner_error_);
#line 218 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					return;
#line 1390 "repository.c"
				}
#line 214 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				_g_object_unref0 (fs);
#line 214 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				gitg_test_repository_file_destroy (&f);
#line 1396 "repository.c"
			}
		}
	}
#line 204 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_g_object_unref0 (wd);
#line 204 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 1404 "repository.c"
}


void gitg_test_repository_workdir_modify (GitgTestRepository* self, const gchar* filename, ...) {
	GitgRepository* _tmp0_ = NULL;
	GitgTestRepositoryFile* files = NULL;
	const gchar* _tmp1_ = NULL;
	va_list _tmp2_ = {0};
	gint _tmp3_ = 0;
	GitgTestRepositoryFile* _tmp4_ = NULL;
	GitgTestRepositoryFile* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint files_length1 = 0;
	gint _files_size_ = 0;
	GitgTestRepositoryFile* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
#line 229 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	g_return_if_fail (self != NULL);
#line 231 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp0_ = self->d_repository;
#line 231 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if (_tmp0_ == NULL) {
#line 233 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 1429 "repository.c"
	}
#line 236 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp1_ = filename;
#line 236 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	va_start (_tmp2_, filename);
#line 236 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp4_ = gitg_test_repository_files_from_varargs (self, _tmp1_, _tmp2_, &_tmp3_);
#line 236 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp5_ = _tmp4_;
#line 236 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp5__length1 = _tmp3_;
#line 236 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	va_end (_tmp2_);
#line 236 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	files = _tmp5_;
#line 236 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	files_length1 = _tmp5__length1;
#line 236 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_files_size_ = files_length1;
#line 237 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp6_ = files;
#line 237 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp6__length1 = files_length1;
#line 237 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	gitg_test_repository_write_files (self, _tmp6_, _tmp6__length1);
#line 229 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 1457 "repository.c"
}


void gitg_test_repository_index_modify (GitgTestRepository* self, const gchar* filename, ...) {
	GitgRepository* _tmp0_ = NULL;
	GitgTestRepositoryFile* files = NULL;
	const gchar* _tmp1_ = NULL;
	va_list _tmp2_ = {0};
	gint _tmp3_ = 0;
	GitgTestRepositoryFile* _tmp4_ = NULL;
	GitgTestRepositoryFile* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint files_length1 = 0;
	gint _files_size_ = 0;
	GgitOId* id = NULL;
	GgitIndex* index = NULL;
	GitgTestRepositoryFile* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	GError * _inner_error_ = NULL;
#line 240 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	g_return_if_fail (self != NULL);
#line 242 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp0_ = self->d_repository;
#line 242 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if (_tmp0_ == NULL) {
#line 244 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 1485 "repository.c"
	}
#line 247 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp1_ = filename;
#line 247 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	va_start (_tmp2_, filename);
#line 247 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp4_ = gitg_test_repository_files_from_varargs (self, _tmp1_, _tmp2_, &_tmp3_);
#line 247 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp5_ = _tmp4_;
#line 247 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp5__length1 = _tmp3_;
#line 247 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	va_end (_tmp2_);
#line 247 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	files = _tmp5_;
#line 247 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	files_length1 = _tmp5__length1;
#line 247 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_files_size_ = files_length1;
#line 1505 "repository.c"
	{
		GgitIndex* _tmp6_ = NULL;
		GitgRepository* _tmp7_ = NULL;
		GgitIndex* _tmp8_ = NULL;
		GgitIndex* _tmp9_ = NULL;
#line 255 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp7_ = self->d_repository;
#line 255 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp8_ = ggit_repository_get_index ((GgitRepository*) _tmp7_, &_inner_error_);
#line 255 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp6_ = _tmp8_;
#line 255 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1519 "repository.c"
			goto __catch9_g_error;
		}
#line 255 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp9_ = _tmp6_;
#line 255 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp6_ = NULL;
#line 255 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (index);
#line 255 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		index = _tmp9_;
#line 253 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (_tmp6_);
#line 1532 "repository.c"
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_ = NULL;
#line 253 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		e = _inner_error_;
#line 253 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_inner_error_ = NULL;
#line 259 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp10_ = e;
#line 259 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		gitg_test_assert_assert_no_error (_tmp10_);
#line 260 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_error_free0 (e);
#line 260 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (index);
#line 260 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		__vala_GgitOId_free0 (id);
#line 260 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 260 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 1557 "repository.c"
	}
	__finally9:
#line 253 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 253 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (index);
#line 253 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		__vala_GgitOId_free0 (id);
#line 253 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 253 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 253 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_clear_error (&_inner_error_);
#line 253 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 1574 "repository.c"
	}
#line 264 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp11_ = files;
#line 264 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp11__length1 = files_length1;
#line 1580 "repository.c"
	{
		GitgTestRepositoryFile* f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
#line 264 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		f_collection = _tmp11_;
#line 264 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		f_collection_length1 = _tmp11__length1;
#line 264 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		for (f_it = 0; f_it < _tmp11__length1; f_it = f_it + 1) {
#line 1592 "repository.c"
			GitgTestRepositoryFile _tmp12_ = {0};
			GitgTestRepositoryFile f = {0};
#line 264 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			gitg_test_repository_file_copy (&f_collection[f_it], &_tmp12_);
#line 264 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
			f = _tmp12_;
#line 1599 "repository.c"
			{
				{
					GgitOId* _tmp13_ = NULL;
					GitgRepository* _tmp14_ = NULL;
					GitgTestRepositoryFile _tmp15_ = {0};
					const gchar* _tmp16_ = NULL;
					guint8* _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					guint8* _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					GgitOId* _tmp19_ = NULL;
					GgitOId* _tmp20_ = NULL;
#line 268 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp14_ = self->d_repository;
#line 268 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp15_ = f;
#line 268 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp16_ = _tmp15_.contents;
#line 268 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp17_ = string_get_data (_tmp16_, &_tmp17__length1);
#line 268 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp18_ = _tmp17_;
#line 268 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp18__length1 = _tmp17__length1;
#line 268 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp19_ = ggit_repository_create_blob_from_buffer ((GgitRepository*) _tmp14_, _tmp18_, (gsize) _tmp18__length1, &_inner_error_);
#line 268 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp13_ = _tmp19_;
#line 268 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1630 "repository.c"
						goto __catch10_g_error;
					}
#line 268 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp20_ = _tmp13_;
#line 268 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp13_ = NULL;
#line 268 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					__vala_GgitOId_free0 (id);
#line 268 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					id = _tmp20_;
#line 266 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					__vala_GgitOId_free0 (_tmp13_);
#line 1643 "repository.c"
				}
				goto __finally10;
				__catch10_g_error:
				{
					GError* e = NULL;
					GError* _tmp21_ = NULL;
#line 266 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					e = _inner_error_;
#line 266 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_inner_error_ = NULL;
#line 272 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp21_ = e;
#line 272 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					gitg_test_assert_assert_no_error (_tmp21_);
#line 273 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_g_error_free0 (e);
#line 273 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					gitg_test_repository_file_destroy (&f);
#line 273 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					continue;
#line 1664 "repository.c"
				}
				__finally10:
#line 266 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 266 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					gitg_test_repository_file_destroy (&f);
#line 266 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_g_object_unref0 (index);
#line 266 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					__vala_GgitOId_free0 (id);
#line 266 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 266 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 266 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					g_clear_error (&_inner_error_);
#line 266 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					return;
#line 1683 "repository.c"
				}
				{
					GgitIndexEntry* entry = NULL;
					GitgRepository* _tmp22_ = NULL;
					GitgTestRepositoryFile _tmp23_ = {0};
					const gchar* _tmp24_ = NULL;
					GgitOId* _tmp25_ = NULL;
					GgitIndexEntry* _tmp26_ = NULL;
					GgitIndex* _tmp27_ = NULL;
					GgitIndexEntry* _tmp28_ = NULL;
#line 278 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp22_ = self->d_repository;
#line 278 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp23_ = f;
#line 278 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp24_ = _tmp23_.filename;
#line 278 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp25_ = id;
#line 278 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp26_ = ggit_repository_create_index_entry_for_path ((GgitRepository*) _tmp22_, _tmp24_, _tmp25_, &_inner_error_);
#line 278 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					entry = _tmp26_;
#line 278 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1708 "repository.c"
						goto __catch11_g_error;
					}
#line 279 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp27_ = index;
#line 279 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp28_ = entry;
#line 279 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					ggit_index_add (_tmp27_, _tmp28_, &_inner_error_);
#line 279 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 279 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
						_ggit_index_entry_unref0 (entry);
#line 1721 "repository.c"
						goto __catch11_g_error;
					}
#line 276 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_ggit_index_entry_unref0 (entry);
#line 1726 "repository.c"
				}
				goto __finally11;
				__catch11_g_error:
				{
					GError* e = NULL;
					GError* _tmp29_ = NULL;
#line 276 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					e = _inner_error_;
#line 276 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_inner_error_ = NULL;
#line 283 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_tmp29_ = e;
#line 283 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					gitg_test_assert_assert_no_error (_tmp29_);
#line 276 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_g_error_free0 (e);
#line 1743 "repository.c"
				}
				__finally11:
#line 276 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 276 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					gitg_test_repository_file_destroy (&f);
#line 276 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					_g_object_unref0 (index);
#line 276 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					__vala_GgitOId_free0 (id);
#line 276 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 276 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 276 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					g_clear_error (&_inner_error_);
#line 276 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
					return;
#line 1762 "repository.c"
				}
#line 264 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
				gitg_test_repository_file_destroy (&f);
#line 1766 "repository.c"
			}
		}
	}
	{
		GgitIndex* _tmp30_ = NULL;
#line 289 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp30_ = index;
#line 289 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		ggit_index_write (_tmp30_, &_inner_error_);
#line 289 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1778 "repository.c"
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		GError* _tmp31_ = NULL;
#line 287 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		e = _inner_error_;
#line 287 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_inner_error_ = NULL;
#line 293 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp31_ = e;
#line 293 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		gitg_test_assert_assert_no_error (_tmp31_);
#line 287 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_error_free0 (e);
#line 1797 "repository.c"
	}
	__finally12:
#line 287 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 287 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (index);
#line 287 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		__vala_GgitOId_free0 (id);
#line 287 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 287 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 287 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_clear_error (&_inner_error_);
#line 287 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 1814 "repository.c"
	}
#line 240 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_g_object_unref0 (index);
#line 240 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	__vala_GgitOId_free0 (id);
#line 240 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 1822 "repository.c"
}


static void gitg_test_repository_real_set_up (GitgTestTest* base) {
	GitgTestRepository * self;
	gchar* wd = NULL;
	GFile* f = NULL;
	const gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 297 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	self = (GitgTestRepository*) base;
#line 301 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_g_object_unref0 (self->priv->d_last_commit);
#line 301 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	self->priv->d_last_commit = NULL;
#line 1839 "repository.c"
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
#line 305 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp1_ = g_dir_make_tmp ("gitg-test-XXXXXX", &_inner_error_);
#line 305 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp0_ = _tmp1_;
#line 305 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1850 "repository.c"
			goto __catch13_g_error;
		}
#line 305 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp2_ = _tmp0_;
#line 305 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp0_ = NULL;
#line 305 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_free0 (wd);
#line 305 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		wd = _tmp2_;
#line 303 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_free0 (_tmp0_);
#line 1863 "repository.c"
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
#line 303 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		e = _inner_error_;
#line 303 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_inner_error_ = NULL;
#line 309 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp3_ = e;
#line 309 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		gitg_test_assert_assert_no_error (_tmp3_);
#line 310 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_error_free0 (e);
#line 310 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_free0 (wd);
#line 310 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 1884 "repository.c"
	}
	__finally13:
#line 303 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 303 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_free0 (wd);
#line 303 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 303 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_clear_error (&_inner_error_);
#line 303 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 1897 "repository.c"
	}
#line 313 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp4_ = wd;
#line 313 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp5_ = g_file_new_for_path (_tmp4_);
#line 313 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	f = _tmp5_;
#line 1905 "repository.c"
	{
		GgitRepository* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		GgitRepository* _tmp8_ = NULL;
		GgitRepository* _tmp9_ = NULL;
#line 317 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp7_ = f;
#line 317 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp8_ = ggit_repository_init_repository (_tmp7_, FALSE, &_inner_error_);
#line 317 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp6_ = _tmp8_;
#line 317 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1919 "repository.c"
			goto __catch14_g_error;
		}
#line 317 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp9_ = _tmp6_;
#line 317 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp6_ = NULL;
#line 317 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (self->d_repository);
#line 317 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		self->d_repository = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GITG_TYPE_REPOSITORY, GitgRepository);
#line 315 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (_tmp6_);
#line 1932 "repository.c"
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
#line 315 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		e = _inner_error_;
#line 315 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_inner_error_ = NULL;
#line 321 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp10_ = wd;
#line 321 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_rmdir (_tmp10_);
#line 322 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_tmp11_ = e;
#line 322 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		gitg_test_assert_assert_no_error (_tmp11_);
#line 315 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_error_free0 (e);
#line 1954 "repository.c"
	}
	__finally14:
#line 315 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 315 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_object_unref0 (f);
#line 315 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		_g_free0 (wd);
#line 315 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 315 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		g_clear_error (&_inner_error_);
#line 315 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 1969 "repository.c"
	}
#line 297 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_g_object_unref0 (f);
#line 297 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_g_free0 (wd);
#line 1975 "repository.c"
}


static void gitg_test_repository_real_tear_down (GitgTestTest* base) {
	GitgTestRepository * self;
	GitgRepository* _tmp0_ = NULL;
	GFile* wd = NULL;
	GitgRepository* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 326 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	self = (GitgTestRepository*) base;
#line 328 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp0_ = self->d_repository;
#line 328 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	if (_tmp0_ == NULL) {
#line 330 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
		return;
#line 1998 "repository.c"
	}
#line 333 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp1_ = self->d_repository;
#line 333 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp2_ = ggit_repository_get_workdir ((GgitRepository*) _tmp1_);
#line 333 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	wd = _tmp2_;
#line 337 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp3_ = wd;
#line 337 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp4_ = g_file_get_path (_tmp3_);
#line 337 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp5_ = _tmp4_;
#line 337 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp6_ = g_strdup_printf ("rm -rf '%s'", _tmp5_);
#line 337 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp7_ = _tmp6_;
#line 337 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	system (_tmp7_);
#line 337 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_g_free0 (_tmp7_);
#line 337 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_g_free0 (_tmp5_);
#line 339 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_g_object_unref0 (self->d_repository);
#line 339 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	self->d_repository = NULL;
#line 326 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_g_object_unref0 (wd);
#line 2028 "repository.c"
}


GitgTestRepository* gitg_test_repository_construct (GType object_type) {
	GitgTestRepository * self = NULL;
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	self = (GitgTestRepository*) gitg_test_test_construct (object_type);
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	return self;
#line 2038 "repository.c"
}


GitgTestRepository* gitg_test_repository_new (void) {
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	return gitg_test_repository_construct (GITG_TEST_TYPE_REPOSITORY);
#line 2045 "repository.c"
}


static void gitg_test_repository_file_copy (const GitgTestRepositoryFile* self, GitgTestRepositoryFile* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 27 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp0_ = (*self).filename;
#line 27 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 27 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_g_free0 ((*dest).filename);
#line 27 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	(*dest).filename = _tmp1_;
#line 27 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp2_ = (*self).contents;
#line 27 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 27 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_g_free0 ((*dest).contents);
#line 27 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	(*dest).contents = _tmp3_;
#line 2070 "repository.c"
}


static void gitg_test_repository_file_destroy (GitgTestRepositoryFile* self) {
#line 29 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_g_free0 ((*self).filename);
#line 30 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_g_free0 ((*self).contents);
#line 2079 "repository.c"
}


static GitgTestRepositoryFile* gitg_test_repository_file_dup (const GitgTestRepositoryFile* self) {
	GitgTestRepositoryFile* dup;
#line 27 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	dup = g_new0 (GitgTestRepositoryFile, 1);
#line 27 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	gitg_test_repository_file_copy (self, dup);
#line 27 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	return dup;
#line 2091 "repository.c"
}


static void gitg_test_repository_file_free (GitgTestRepositoryFile* self) {
#line 27 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	gitg_test_repository_file_destroy (self);
#line 27 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	g_free (self);
#line 2100 "repository.c"
}


static GType gitg_test_repository_file_get_type (void) {
	static volatile gsize gitg_test_repository_file_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_test_repository_file_type_id__volatile)) {
		GType gitg_test_repository_file_type_id;
		gitg_test_repository_file_type_id = g_boxed_type_register_static ("GitgTestRepositoryFile", (GBoxedCopyFunc) gitg_test_repository_file_dup, (GBoxedFreeFunc) gitg_test_repository_file_free);
		g_once_init_leave (&gitg_test_repository_file_type_id__volatile, gitg_test_repository_file_type_id);
	}
	return gitg_test_repository_file_type_id__volatile;
}


static void gitg_test_repository_class_init (GitgTestRepositoryClass * klass) {
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	gitg_test_repository_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	g_type_class_add_private (klass, sizeof (GitgTestRepositoryPrivate));
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	((GitgTestTestClass *) klass)->set_up = gitg_test_repository_real_set_up;
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	((GitgTestTestClass *) klass)->tear_down = gitg_test_repository_real_tear_down;
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_test_repository_finalize;
#line 2126 "repository.c"
}


static void gitg_test_repository_instance_init (GitgTestRepository * self) {
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	self->priv = GITG_TEST_REPOSITORY_GET_PRIVATE (self);
#line 2133 "repository.c"
}


static void gitg_test_repository_finalize (GObject* obj) {
	GitgTestRepository * self;
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TEST_TYPE_REPOSITORY, GitgTestRepository);
#line 24 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_g_object_unref0 (self->d_repository);
#line 25 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	_g_object_unref0 (self->priv->d_last_commit);
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/repository.vala"
	G_OBJECT_CLASS (gitg_test_repository_parent_class)->finalize (obj);
#line 2147 "repository.c"
}


GType gitg_test_repository_get_type (void) {
	static volatile gsize gitg_test_repository_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_test_repository_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgTestRepositoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_test_repository_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgTestRepository), 0, (GInstanceInitFunc) gitg_test_repository_instance_init, NULL };
		GType gitg_test_repository_type_id;
		gitg_test_repository_type_id = g_type_register_static (GITG_TEST_TYPE_TEST, "GitgTestRepository", &g_define_type_info, 0);
		g_once_init_leave (&gitg_test_repository_type_id__volatile, gitg_test_repository_type_id);
	}
	return gitg_test_repository_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



