/* gnome-tetravex.c generated by valac 0.22.1.2-49127, the Vala compiler
 * generated from gnome-tetravex.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <locale.h>


#define TYPE_TETRAVEX (tetravex_get_type ())
#define TETRAVEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TETRAVEX, Tetravex))
#define TETRAVEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TETRAVEX, TetravexClass))
#define IS_TETRAVEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TETRAVEX))
#define IS_TETRAVEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TETRAVEX))
#define TETRAVEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TETRAVEX, TetravexClass))

typedef struct _Tetravex Tetravex;
typedef struct _TetravexClass TetravexClass;
typedef struct _TetravexPrivate TetravexPrivate;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;

#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _puzzle_unref0(var) ((var == NULL) ? NULL : (var = (puzzle_unref (var), NULL)))
#define _history_unref0(var) ((var == NULL) ? NULL : (var = (history_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;
#define _history_entry_unref0(var) ((var == NULL) ? NULL : (var = (history_entry_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_SCORE_DIALOG (score_dialog_get_type ())
#define SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_DIALOG, ScoreDialog))
#define SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_DIALOG, ScoreDialogClass))
#define IS_SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_DIALOG))
#define IS_SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_DIALOG))
#define SCORE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_DIALOG, ScoreDialogClass))

typedef struct _ScoreDialog ScoreDialog;
typedef struct _ScoreDialogClass ScoreDialogClass;

struct _Tetravex {
	GtkApplication parent_instance;
	TetravexPrivate * priv;
};

struct _TetravexClass {
	GtkApplicationClass parent_class;
};

struct _TetravexPrivate {
	GSettings* settings;
	Puzzle* puzzle;
	GtkLabel* clock_label;
	History* history;
	PuzzleView* view;
	GtkApplicationWindow* window;
	gint window_width;
	gint window_height;
	gboolean is_maximized;
	GtkButton* pause_button;
	GtkImage* pause_image;
	GtkLabel* pause_label;
};


static gpointer tetravex_parent_class = NULL;

GType tetravex_get_type (void) G_GNUC_CONST;
gpointer puzzle_ref (gpointer instance);
void puzzle_unref (gpointer instance);
GParamSpec* param_spec_puzzle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_puzzle (GValue* value, gpointer v_object);
void value_take_puzzle (GValue* value, gpointer v_object);
gpointer value_get_puzzle (const GValue* value);
GType puzzle_get_type (void) G_GNUC_CONST;
gpointer history_ref (gpointer instance);
void history_unref (gpointer instance);
GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history (GValue* value, gpointer v_object);
void value_take_history (GValue* value, gpointer v_object);
gpointer value_get_history (const GValue* value);
GType history_get_type (void) G_GNUC_CONST;
GType puzzle_view_get_type (void) G_GNUC_CONST;
#define TETRAVEX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TETRAVEX, TetravexPrivate))
enum  {
	TETRAVEX_DUMMY_PROPERTY
};
#define TETRAVEX_KEY_GRID_SIZE "grid-size"
static void tetravex_new_game_cb (Tetravex* self);
static void _tetravex_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_pause_cb (Tetravex* self, GSimpleAction* action, GVariant* parameter);
static void _tetravex_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_solve_cb (Tetravex* self);
static void _tetravex_solve_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_scores_cb (Tetravex* self);
static void _tetravex_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_quit_cb (Tetravex* self);
static void _tetravex_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_move_up_cb (Tetravex* self);
static void _tetravex_move_up_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_move_down_cb (Tetravex* self);
static void _tetravex_move_down_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_move_left_cb (Tetravex* self);
static void _tetravex_move_left_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_move_right_cb (Tetravex* self);
static void _tetravex_move_right_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_radio_cb (Tetravex* self, GSimpleAction* action, GVariant* parameter);
static void _tetravex_radio_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_size_changed (Tetravex* self, GSimpleAction* action, GVariant* value);
static void _tetravex_size_changed_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self);
static void tetravex_help_cb (Tetravex* self);
static void _tetravex_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tetravex_about_cb (Tetravex* self);
static void _tetravex_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Tetravex* tetravex_new (void);
Tetravex* tetravex_construct (GType object_type);
static void tetravex_real_startup (GApplication* base);
History* history_new (const gchar* filename);
History* history_construct (GType object_type, const gchar* filename);
void history_load (History* self);
static gboolean tetravex_window_configure_event_cb (Tetravex* self, GdkEventConfigure* event);
static gboolean _tetravex_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean tetravex_window_state_event_cb (Tetravex* self, GdkEventWindowState* event);
static gboolean _tetravex_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static GVariant* _variant_new1 (gchar* value);
PuzzleView* puzzle_view_new (void);
PuzzleView* puzzle_view_construct (GType object_type);
static gboolean tetravex_view_button_press_event (Tetravex* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _tetravex_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void tetravex_tick_cb (Tetravex* self);
static void tetravex_new_game (Tetravex* self);
static void tetravex_real_shutdown (GApplication* base);
static void tetravex_real_activate (GApplication* base);
Puzzle* puzzle_new (guint size);
Puzzle* puzzle_construct (GType object_type, guint size);
static void _tetravex_tick_cb_puzzle_tick (Puzzle* _sender, gpointer self);
static void tetravex_solved_cb (Tetravex* self, Puzzle* puzzle);
static void _tetravex_solved_cb_puzzle_solved (Puzzle* _sender, gpointer self);
void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value);
static GVariant* _variant_new2 (gboolean value);
static void tetravex_update_button_states (Tetravex* self);
gdouble puzzle_get_elapsed (Puzzle* self);
gpointer history_entry_ref (gpointer instance);
void history_entry_unref (gpointer instance);
GParamSpec* param_spec_history_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history_entry (GValue* value, gpointer v_object);
void value_take_history_entry (GValue* value, gpointer v_object);
gpointer value_get_history_entry (const GValue* value);
GType history_entry_get_type (void) G_GNUC_CONST;
guint puzzle_get_size (Puzzle* self);
HistoryEntry* history_entry_new (GDateTime* date, guint size, guint duration);
HistoryEntry* history_entry_construct (GType object_type, GDateTime* date, guint size, guint duration);
void history_add (History* self, HistoryEntry* entry);
void history_save (History* self);
static gint tetravex_show_scores (Tetravex* self, HistoryEntry* selected_entry, gboolean show_quit);
GType score_dialog_get_type (void) G_GNUC_CONST;
ScoreDialog* score_dialog_new (History* history, HistoryEntry* selected_entry, gboolean show_quit);
ScoreDialog* score_dialog_construct (GType object_type, History* history, HistoryEntry* selected_entry, gboolean show_quit);
gboolean puzzle_get_paused (Puzzle* self);
void puzzle_set_paused (Puzzle* self, gboolean value);
void puzzle_solve (Puzzle* self);
static gchar* _variant_get3 (GVariant* value);
void puzzle_move_up (Puzzle* self);
void puzzle_move_left (Puzzle* self);
void puzzle_move_right (Puzzle* self);
void puzzle_move_down (Puzzle* self);
gint tetravex_main (gchar** args, int args_length1);
static void tetravex_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry TETRAVEX_action_entries[12] = {{"new-game", _tetravex_new_game_cb_gsimple_action_activate_callback}, {"pause", _tetravex_pause_cb_gsimple_action_activate_callback}, {"solve", _tetravex_solve_cb_gsimple_action_activate_callback}, {"scores", _tetravex_scores_cb_gsimple_action_activate_callback}, {"quit", _tetravex_quit_cb_gsimple_action_activate_callback}, {"move-up", _tetravex_move_up_cb_gsimple_action_activate_callback}, {"move-down", _tetravex_move_down_cb_gsimple_action_activate_callback}, {"move-left", _tetravex_move_left_cb_gsimple_action_activate_callback}, {"move-right", _tetravex_move_right_cb_gsimple_action_activate_callback}, {"size", _tetravex_radio_cb_gsimple_action_activate_callback, "s", "'2'", _tetravex_size_changed_gsimple_action_change_state_callback}, {"help", _tetravex_help_cb_gsimple_action_activate_callback}, {"about", _tetravex_about_cb_gsimple_action_activate_callback}};

static void _tetravex_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_new_game_cb (self);
}


static void _tetravex_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_pause_cb (self, action, parameter);
}


static void _tetravex_solve_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_solve_cb (self);
}


static void _tetravex_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_scores_cb (self);
}


static void _tetravex_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_quit_cb (self);
}


static void _tetravex_move_up_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_move_up_cb (self);
}


static void _tetravex_move_down_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_move_down_cb (self);
}


static void _tetravex_move_left_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_move_left_cb (self);
}


static void _tetravex_move_right_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_move_right_cb (self);
}


static void _tetravex_radio_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_radio_cb (self, action, parameter);
}


static void _tetravex_size_changed_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self) {
	tetravex_size_changed (self, action, value);
}


static void _tetravex_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_help_cb (self);
}


static void _tetravex_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tetravex_about_cb (self);
}


Tetravex* tetravex_construct (GType object_type) {
	Tetravex * self = NULL;
	self = (Tetravex*) g_object_new (object_type, "application-id", "org.gnome.tetravex", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	return self;
}


Tetravex* tetravex_new (void) {
	return tetravex_construct (TYPE_TETRAVEX);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _tetravex_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = tetravex_window_configure_event_cb (self, event);
	return result;
}


static gboolean _tetravex_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = tetravex_window_state_event_cb (self, event);
	return result;
}


static GVariant* _variant_new1 (gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static gboolean _tetravex_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = tetravex_view_button_press_event (self, _sender, event);
	return result;
}


static void tetravex_real_startup (GApplication* base) {
	Tetravex * self;
	const gchar* _tmp0_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GtkBuilder* _tmp5_ = NULL;
	GObject* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	History* _tmp11_ = NULL;
	History* _tmp12_ = NULL;
	GtkBuilder* _tmp13_ = NULL;
	GObject* _tmp14_ = NULL;
	GtkApplicationWindow* _tmp15_ = NULL;
	GtkApplicationWindow* _tmp16_ = NULL;
	GtkApplicationWindow* _tmp17_ = NULL;
	GtkApplicationWindow* _tmp18_ = NULL;
	GtkApplicationWindow* _tmp19_ = NULL;
	GSettings* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	GSettings* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	GSettings* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	GAction* _tmp27_ = NULL;
	GSettings* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	GVariant* _tmp32_ = NULL;
	GtkHeaderBar* headerbar = NULL;
	GtkHeaderBar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	GtkApplicationWindow* _tmp35_ = NULL;
	GtkGrid* grid = NULL;
	GtkBuilder* _tmp36_ = NULL;
	GObject* _tmp37_ = NULL;
	GtkGrid* _tmp38_ = NULL;
	PuzzleView* _tmp39_ = NULL;
	PuzzleView* _tmp40_ = NULL;
	PuzzleView* _tmp41_ = NULL;
	PuzzleView* _tmp42_ = NULL;
	PuzzleView* _tmp43_ = NULL;
	GtkSizeGroup* size = NULL;
	GtkSizeGroup* _tmp44_ = NULL;
	GtkButton* new_game_button = NULL;
	GtkButton* _tmp45_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp46_ = NULL;
	GtkImage* image = NULL;
	GtkImage* _tmp47_ = NULL;
	GtkBox* _tmp48_ = NULL;
	GtkImage* _tmp49_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp50_ = NULL;
	GtkLabel* _tmp51_ = NULL;
	GtkBox* _tmp52_ = NULL;
	GtkLabel* _tmp53_ = NULL;
	GtkBox* _tmp54_ = NULL;
	GtkButton* _tmp55_ = NULL;
	GtkBox* _tmp56_ = NULL;
	GtkImage* _tmp57_ = NULL;
	GtkBox* _tmp58_ = NULL;
	GtkImage* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	GtkLabel* _tmp61_ = NULL;
	GtkBox* _tmp62_ = NULL;
	GtkLabel* _tmp63_ = NULL;
	GtkButton* _tmp64_ = NULL;
	GtkBox* _tmp65_ = NULL;
	GtkButton* _tmp66_ = NULL;
	GtkButton* _tmp67_ = NULL;
	GtkButton* _tmp68_ = NULL;
	GtkButton* _tmp69_ = NULL;
	GtkButton* _tmp70_ = NULL;
	GtkButton* _tmp71_ = NULL;
	GtkButton* solve_button = NULL;
	GtkButton* _tmp72_ = NULL;
	GtkBox* _tmp73_ = NULL;
	GtkImage* _tmp74_ = NULL;
	GtkBox* _tmp75_ = NULL;
	GtkImage* _tmp76_ = NULL;
	const gchar* _tmp77_ = NULL;
	GtkLabel* _tmp78_ = NULL;
	GtkBox* _tmp79_ = NULL;
	GtkLabel* _tmp80_ = NULL;
	GtkBox* _tmp81_ = NULL;
	GtkBox* _tmp82_ = NULL;
	GtkBox* _tmp83_ = NULL;
	GtkImage* _tmp84_ = NULL;
	GtkBox* _tmp85_ = NULL;
	GtkImage* _tmp86_ = NULL;
	GtkLabel* _tmp87_ = NULL;
	GtkBox* _tmp88_ = NULL;
	GtkLabel* _tmp89_ = NULL;
	GtkBox* _tmp90_ = NULL;
	GtkBox* _tmp91_ = NULL;
	GtkBox* _tmp92_ = NULL;
	GtkBox* _tmp93_ = NULL;
	GtkBox* _tmp94_ = NULL;
	GtkApplicationWindow* _tmp95_ = NULL;
	GError * _inner_error_ = NULL;
	self = (Tetravex*) base;
	G_APPLICATION_CLASS (tetravex_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = _ ("Tetravex");
	g_set_application_name (_tmp0_);
	gtk_window_set_default_icon_name ("gnome-tetravex");
	g_action_map_add_action_entries ((GActionMap*) self, TETRAVEX_action_entries, G_N_ELEMENTS (TETRAVEX_action_entries), self);
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>n", "app.new-game", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "Pause", "app.pause", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "F1", "app.help", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>q", "app.quit", NULL);
	_tmp1_ = gtk_builder_new ();
	builder = _tmp1_;
	{
		GtkBuilder* _tmp2_ = NULL;
		GtkBuilder* _tmp3_ = NULL;
		_tmp2_ = builder;
		gtk_builder_add_from_resource (_tmp2_, "/org/gnome/tetravex/gnome-tetravex.ui", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp3_ = builder;
		gtk_builder_add_from_resource (_tmp3_, "/org/gnome/tetravex/app-menu.ui", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e->message;
		g_error ("gnome-tetravex.vala:74: Unable to build menus: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = builder;
	_tmp6_ = gtk_builder_get_object (_tmp5_, "gnome-tetravex-menu");
	gtk_application_set_app_menu ((GtkApplication*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp6_) : NULL);
	_tmp7_ = g_settings_new ("org.gnome.tetravex");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp7_;
	_tmp8_ = g_get_user_data_dir ();
	_tmp9_ = g_build_filename (_tmp8_, "gnome-tetravex", "history", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = history_new (_tmp10_);
	_history_unref0 (self->priv->history);
	self->priv->history = _tmp11_;
	_g_free0 (_tmp10_);
	_tmp12_ = self->priv->history;
	history_load (_tmp12_);
	_tmp13_ = builder;
	_tmp14_ = gtk_builder_get_object (_tmp13_, "gnome-tetravex-window");
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, GTK_TYPE_APPLICATION_WINDOW) ? ((GtkApplicationWindow*) _tmp14_) : NULL);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp15_;
	_tmp16_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp16_);
	_tmp17_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp17_, "configure-event", (GCallback) _tetravex_window_configure_event_cb_gtk_widget_configure_event, self, 0);
	_tmp18_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp18_, "window-state-event", (GCallback) _tetravex_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp19_ = self->priv->window;
	_tmp20_ = self->priv->settings;
	_tmp21_ = g_settings_get_int (_tmp20_, "window-width");
	_tmp22_ = self->priv->settings;
	_tmp23_ = g_settings_get_int (_tmp22_, "window-height");
	gtk_window_set_default_size ((GtkWindow*) _tmp19_, _tmp21_, _tmp23_);
	_tmp24_ = self->priv->settings;
	_tmp25_ = g_settings_get_boolean (_tmp24_, "window-is-maximized");
	if (_tmp25_) {
		GtkApplicationWindow* _tmp26_ = NULL;
		_tmp26_ = self->priv->window;
		gtk_window_maximize ((GtkWindow*) _tmp26_);
	}
	_tmp27_ = g_action_map_lookup_action ((GActionMap*) self, "size");
	_tmp28_ = self->priv->settings;
	_tmp29_ = g_settings_get_int (_tmp28_, TETRAVEX_KEY_GRID_SIZE);
	_tmp30_ = g_strdup_printf ("%d", _tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = _variant_new1 (_tmp31_);
	g_simple_action_set_state (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp27_) : NULL, _tmp32_);
	_g_variant_unref0 (_tmp32_);
	_g_free0 (_tmp31_);
	_tmp33_ = (GtkHeaderBar*) gtk_header_bar_new ();
	g_object_ref_sink (_tmp33_);
	headerbar = _tmp33_;
	_tmp34_ = _ ("Tetravex");
	gtk_header_bar_set_title (headerbar, _tmp34_);
	gtk_header_bar_set_show_close_button (headerbar, TRUE);
	_tmp35_ = self->priv->window;
	gtk_window_set_titlebar ((GtkWindow*) _tmp35_, (GtkWidget*) headerbar);
	_tmp36_ = builder;
	_tmp37_ = gtk_builder_get_object (_tmp36_, "grid");
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp37_) : NULL);
	grid = _tmp38_;
	_tmp39_ = puzzle_view_new ();
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp39_;
	_tmp40_ = self->priv->view;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp40_, TRUE);
	_tmp41_ = self->priv->view;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp41_, TRUE);
	_tmp42_ = self->priv->view;
	g_signal_connect_object ((GtkWidget*) _tmp42_, "button-press-event", (GCallback) _tetravex_view_button_press_event_gtk_widget_button_press_event, self, 0);
	_tmp43_ = self->priv->view;
	gtk_grid_attach (grid, (GtkWidget*) _tmp43_, 0, 0, 3, 1);
	_tmp44_ = gtk_size_group_new (GTK_SIZE_GROUP_BOTH);
	size = _tmp44_;
	_tmp45_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp45_);
	new_game_button = _tmp45_;
	_tmp46_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 2);
	g_object_ref_sink (_tmp46_);
	box = _tmp46_;
	_tmp47_ = (GtkImage*) gtk_image_new_from_icon_name ("view-refresh-symbolic", GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp47_);
	image = _tmp47_;
	_tmp48_ = box;
	_tmp49_ = image;
	gtk_box_pack_start (_tmp48_, (GtkWidget*) _tmp49_, TRUE, TRUE, (guint) 0);
	_tmp50_ = _ ("Play _Again");
	_tmp51_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp50_);
	g_object_ref_sink (_tmp51_);
	label = _tmp51_;
	_tmp52_ = box;
	_tmp53_ = label;
	gtk_box_pack_start (_tmp52_, (GtkWidget*) _tmp53_, TRUE, TRUE, (guint) 0);
	_tmp54_ = box;
	gtk_container_add ((GtkContainer*) new_game_button, (GtkWidget*) _tmp54_);
	gtk_widget_set_valign ((GtkWidget*) new_game_button, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) new_game_button, GTK_ALIGN_CENTER);
	gtk_button_set_relief (new_game_button, GTK_RELIEF_NONE);
	gtk_actionable_set_action_name ((GtkActionable*) new_game_button, "app.new-game");
	gtk_size_group_add_widget (size, (GtkWidget*) new_game_button);
	gtk_grid_attach (grid, (GtkWidget*) new_game_button, 0, 1, 1, 1);
	_tmp55_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp55_);
	_g_object_unref0 (self->priv->pause_button);
	self->priv->pause_button = _tmp55_;
	_tmp56_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 2);
	g_object_ref_sink (_tmp56_);
	_g_object_unref0 (box);
	box = _tmp56_;
	_tmp57_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playback-pause-symbolic", GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp57_);
	_g_object_unref0 (self->priv->pause_image);
	self->priv->pause_image = _tmp57_;
	_tmp58_ = box;
	_tmp59_ = self->priv->pause_image;
	gtk_box_pack_start (_tmp58_, (GtkWidget*) _tmp59_, TRUE, TRUE, (guint) 0);
	_tmp60_ = _ ("_Pause");
	_tmp61_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp60_);
	g_object_ref_sink (_tmp61_);
	_g_object_unref0 (self->priv->pause_label);
	self->priv->pause_label = _tmp61_;
	_tmp62_ = box;
	_tmp63_ = self->priv->pause_label;
	gtk_box_pack_start (_tmp62_, (GtkWidget*) _tmp63_, TRUE, TRUE, (guint) 0);
	_tmp64_ = self->priv->pause_button;
	_tmp65_ = box;
	gtk_container_add ((GtkContainer*) _tmp64_, (GtkWidget*) _tmp65_);
	_tmp66_ = self->priv->pause_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp66_, GTK_ALIGN_CENTER);
	_tmp67_ = self->priv->pause_button;
	gtk_widget_set_halign ((GtkWidget*) _tmp67_, GTK_ALIGN_CENTER);
	_tmp68_ = self->priv->pause_button;
	gtk_button_set_relief (_tmp68_, GTK_RELIEF_NONE);
	_tmp69_ = self->priv->pause_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp69_, "app.pause");
	_tmp70_ = self->priv->pause_button;
	gtk_size_group_add_widget (size, (GtkWidget*) _tmp70_);
	_tmp71_ = self->priv->pause_button;
	gtk_grid_attach (grid, (GtkWidget*) _tmp71_, 1, 1, 1, 1);
	_tmp72_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp72_);
	solve_button = _tmp72_;
	_tmp73_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 2);
	g_object_ref_sink (_tmp73_);
	_g_object_unref0 (box);
	box = _tmp73_;
	_tmp74_ = (GtkImage*) gtk_image_new_from_icon_name ("dialog-question-symbolic", GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp74_);
	_g_object_unref0 (image);
	image = _tmp74_;
	_tmp75_ = box;
	_tmp76_ = image;
	gtk_box_pack_start (_tmp75_, (GtkWidget*) _tmp76_, TRUE, TRUE, (guint) 0);
	_tmp77_ = _ ("_Resolve");
	_tmp78_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp77_);
	g_object_ref_sink (_tmp78_);
	_g_object_unref0 (label);
	label = _tmp78_;
	_tmp79_ = box;
	_tmp80_ = label;
	gtk_box_pack_start (_tmp79_, (GtkWidget*) _tmp80_, TRUE, TRUE, (guint) 0);
	_tmp81_ = box;
	gtk_container_add ((GtkContainer*) solve_button, (GtkWidget*) _tmp81_);
	gtk_widget_set_valign ((GtkWidget*) solve_button, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) solve_button, GTK_ALIGN_CENTER);
	gtk_button_set_relief (solve_button, GTK_RELIEF_NONE);
	gtk_actionable_set_action_name ((GtkActionable*) solve_button, "app.solve");
	gtk_size_group_add_widget (size, (GtkWidget*) solve_button);
	gtk_grid_attach (grid, (GtkWidget*) solve_button, 2, 1, 1, 1);
	_tmp82_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp82_);
	_g_object_unref0 (box);
	box = _tmp82_;
	_tmp83_ = box;
	gtk_box_set_spacing (_tmp83_, 8);
	_tmp84_ = (GtkImage*) gtk_image_new_from_icon_name ("preferences-system-time-symbolic", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp84_);
	_g_object_unref0 (image);
	image = _tmp84_;
	_tmp85_ = box;
	_tmp86_ = image;
	gtk_container_add ((GtkContainer*) _tmp85_, (GtkWidget*) _tmp86_);
	_tmp87_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp87_);
	_g_object_unref0 (self->priv->clock_label);
	self->priv->clock_label = _tmp87_;
	_tmp88_ = box;
	_tmp89_ = self->priv->clock_label;
	gtk_container_add ((GtkContainer*) _tmp88_, (GtkWidget*) _tmp89_);
	_tmp90_ = box;
	gtk_widget_set_halign ((GtkWidget*) _tmp90_, GTK_ALIGN_CENTER);
	_tmp91_ = box;
	gtk_widget_set_valign ((GtkWidget*) _tmp91_, GTK_ALIGN_BASELINE);
	_tmp92_ = box;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp92_, 20);
	_tmp93_ = box;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp93_, 20);
	_tmp94_ = box;
	gtk_grid_attach (grid, (GtkWidget*) _tmp94_, 0, 2, 3, 1);
	_tmp95_ = self->priv->window;
	gtk_widget_show_all ((GtkWidget*) _tmp95_);
	tetravex_tick_cb (self);
	tetravex_new_game (self);
	_g_object_unref0 (solve_button);
	_g_object_unref0 (label);
	_g_object_unref0 (image);
	_g_object_unref0 (box);
	_g_object_unref0 (new_game_button);
	_g_object_unref0 (size);
	_g_object_unref0 (grid);
	_g_object_unref0 (headerbar);
	_g_object_unref0 (builder);
}


static gboolean tetravex_window_configure_event_cb (Tetravex* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->is_maximized;
	if (!_tmp0_) {
		GdkEventConfigure _tmp1_ = {0};
		gint _tmp2_ = 0;
		GdkEventConfigure _tmp3_ = {0};
		gint _tmp4_ = 0;
		_tmp1_ = *event;
		_tmp2_ = _tmp1_.width;
		self->priv->window_width = _tmp2_;
		_tmp3_ = *event;
		_tmp4_ = _tmp3_.height;
		self->priv->window_height = _tmp4_;
	}
	result = FALSE;
	return result;
}


static gboolean tetravex_window_state_event_cb (Tetravex* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState _tmp0_ = {0};
	GdkWindowState _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState _tmp2_ = {0};
		GdkWindowState _tmp3_ = 0;
		_tmp2_ = *event;
		_tmp3_ = _tmp2_.new_window_state;
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	result = FALSE;
	return result;
}


static void tetravex_real_shutdown (GApplication* base) {
	Tetravex * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	self = (Tetravex*) base;
	G_APPLICATION_CLASS (tetravex_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->window_width;
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->window_height;
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
}


static void tetravex_real_activate (GApplication* base) {
	Tetravex * self;
	GtkApplicationWindow* _tmp0_ = NULL;
	self = (Tetravex*) base;
	_tmp0_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp0_);
}


static void _tetravex_tick_cb_puzzle_tick (Puzzle* _sender, gpointer self) {
	tetravex_tick_cb (self);
}


static void _tetravex_solved_cb_puzzle_solved (Puzzle* _sender, gpointer self) {
	tetravex_solved_cb (self, _sender);
}


static GVariant* _variant_new2 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static void tetravex_new_game (Tetravex* self) {
	Puzzle* _tmp0_ = NULL;
	gint size = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Puzzle* _tmp4_ = NULL;
	Puzzle* _tmp5_ = NULL;
	Puzzle* _tmp6_ = NULL;
	PuzzleView* _tmp7_ = NULL;
	Puzzle* _tmp8_ = NULL;
	GSimpleAction* pause = NULL;
	GAction* _tmp9_ = NULL;
	GSimpleAction* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzle;
	if (_tmp0_ != NULL) {
		Puzzle* _tmp1_ = NULL;
		_tmp1_ = self->priv->puzzle;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_int (_tmp2_, TETRAVEX_KEY_GRID_SIZE);
	size = _tmp3_;
	_tmp4_ = puzzle_new ((guint) size);
	_puzzle_unref0 (self->priv->puzzle);
	self->priv->puzzle = _tmp4_;
	_tmp5_ = self->priv->puzzle;
	g_signal_connect_object (_tmp5_, "tick", (GCallback) _tetravex_tick_cb_puzzle_tick, self, 0);
	_tmp6_ = self->priv->puzzle;
	g_signal_connect_object (_tmp6_, "solved", (GCallback) _tetravex_solved_cb_puzzle_solved, self, 0);
	_tmp7_ = self->priv->view;
	_tmp8_ = self->priv->puzzle;
	puzzle_view_set_puzzle (_tmp7_, _tmp8_);
	tetravex_tick_cb (self);
	_tmp9_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp9_) : NULL);
	pause = _tmp10_;
	_tmp11_ = _variant_new2 (FALSE);
	g_signal_emit_by_name (pause, "change-state", _tmp11_);
	_g_variant_unref0 (_tmp11_);
	tetravex_update_button_states (self);
	_g_object_unref0 (pause);
}


static void tetravex_tick_cb (Tetravex* self) {
	gint elapsed = 0;
	Puzzle* _tmp0_ = NULL;
	gint hours = 0;
	gint _tmp4_ = 0;
	gint minutes = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint seconds = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	g_return_if_fail (self != NULL);
	elapsed = 0;
	_tmp0_ = self->priv->puzzle;
	if (_tmp0_ != NULL) {
		Puzzle* _tmp1_ = NULL;
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		_tmp1_ = self->priv->puzzle;
		_tmp2_ = puzzle_get_elapsed (_tmp1_);
		_tmp3_ = _tmp2_;
		elapsed = (gint) (_tmp3_ + 0.5);
	}
	_tmp4_ = elapsed;
	hours = _tmp4_ / 3600;
	_tmp5_ = elapsed;
	_tmp6_ = hours;
	minutes = (_tmp5_ - (_tmp6_ * 3600)) / 60;
	_tmp7_ = elapsed;
	_tmp8_ = hours;
	_tmp9_ = minutes;
	seconds = (_tmp7_ - (_tmp8_ * 3600)) - (_tmp9_ * 60);
	_tmp10_ = hours;
	if (_tmp10_ > 0) {
		GtkLabel* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		_tmp11_ = self->priv->clock_label;
		_tmp12_ = hours;
		_tmp13_ = minutes;
		_tmp14_ = seconds;
		_tmp15_ = g_strdup_printf ("%02d:%02d:%02d", _tmp12_, _tmp13_, _tmp14_);
		_tmp16_ = _tmp15_;
		gtk_label_set_text (_tmp11_, _tmp16_);
		_g_free0 (_tmp16_);
	} else {
		GtkLabel* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		_tmp17_ = self->priv->clock_label;
		_tmp18_ = minutes;
		_tmp19_ = seconds;
		_tmp20_ = g_strdup_printf ("%02d:%02d", _tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		gtk_label_set_text (_tmp17_, _tmp21_);
		_g_free0 (_tmp21_);
	}
}


static void tetravex_solved_cb (Tetravex* self, Puzzle* puzzle) {
	GDateTime* date = NULL;
	GDateTime* _tmp0_ = NULL;
	guint duration = 0U;
	Puzzle* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	HistoryEntry* entry = NULL;
	GDateTime* _tmp4_ = NULL;
	Puzzle* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	HistoryEntry* _tmp9_ = NULL;
	History* _tmp10_ = NULL;
	HistoryEntry* _tmp11_ = NULL;
	History* _tmp12_ = NULL;
	HistoryEntry* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (puzzle != NULL);
	_tmp0_ = g_date_time_new_now_local ();
	date = _tmp0_;
	_tmp1_ = puzzle;
	_tmp2_ = puzzle_get_elapsed (_tmp1_);
	_tmp3_ = _tmp2_;
	duration = (guint) (_tmp3_ + 0.5);
	_tmp4_ = date;
	_tmp5_ = puzzle;
	_tmp6_ = puzzle_get_size (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = duration;
	_tmp9_ = history_entry_new (_tmp4_, _tmp7_, _tmp8_);
	entry = _tmp9_;
	_tmp10_ = self->priv->history;
	_tmp11_ = entry;
	history_add (_tmp10_, _tmp11_);
	_tmp12_ = self->priv->history;
	history_save (_tmp12_);
	_tmp13_ = entry;
	_tmp14_ = tetravex_show_scores (self, _tmp13_, TRUE);
	if (_tmp14_ == ((gint) GTK_RESPONSE_CLOSE)) {
		GtkApplicationWindow* _tmp15_ = NULL;
		_tmp15_ = self->priv->window;
		gtk_widget_destroy ((GtkWidget*) _tmp15_);
	} else {
		tetravex_new_game (self);
	}
	_history_entry_unref0 (entry);
	_g_date_time_unref0 (date);
}


static gint tetravex_show_scores (Tetravex* self, HistoryEntry* selected_entry, gboolean show_quit) {
	gint result = 0;
	ScoreDialog* dialog = NULL;
	History* _tmp0_ = NULL;
	HistoryEntry* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	ScoreDialog* _tmp3_ = NULL;
	GtkApplicationWindow* _tmp4_ = NULL;
	gint _result_ = 0;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->history;
	_tmp1_ = selected_entry;
	_tmp2_ = show_quit;
	_tmp3_ = score_dialog_new (_tmp0_, _tmp1_, _tmp2_);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	gtk_window_set_modal ((GtkWindow*) dialog, TRUE);
	_tmp4_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) dialog, (GtkWindow*) _tmp4_);
	_tmp5_ = gtk_dialog_run ((GtkDialog*) dialog);
	_result_ = _tmp5_;
	gtk_widget_destroy ((GtkWidget*) dialog);
	result = _result_;
	_g_object_unref0 (dialog);
	return result;
}


static void tetravex_new_game_cb (Tetravex* self) {
	g_return_if_fail (self != NULL);
	tetravex_new_game (self);
}


static void tetravex_quit_cb (Tetravex* self) {
	GtkApplicationWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void tetravex_scores_cb (Tetravex* self) {
	g_return_if_fail (self != NULL);
	tetravex_show_scores (self, NULL, FALSE);
}


static gboolean tetravex_view_button_press_event (Tetravex* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	Puzzle* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->puzzle;
	_tmp1_ = puzzle_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Puzzle* _tmp3_ = NULL;
		_tmp3_ = self->priv->puzzle;
		puzzle_set_paused (_tmp3_, FALSE);
		tetravex_update_button_states (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void tetravex_solve_cb (Tetravex* self) {
	Puzzle* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzle;
	puzzle_solve (_tmp0_);
}


static void tetravex_help_cb (Tetravex* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkApplicationWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-tetravex", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("gnome-tetravex.vala:302: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void tetravex_about_cb (Tetravex* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	gchar* license = NULL;
	gchar* _tmp5_ = NULL;
	GtkApplicationWindow* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Lars Rydlinge");
	_tmp1_ = g_strdup ("Robert Ancell");
	_tmp2_ = g_new0 (gchar*, 3 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp2_[2] = NULL;
	authors = _tmp2_;
	authors_length1 = 3;
	_authors_size_ = authors_length1;
	_tmp3_ = g_strdup ("Rob Bradford");
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp4_[1] = NULL;
	documenters = _tmp4_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp5_ = g_strdup ("Tetravex is free software; you can redistribute it and/or modify it un" \
"der the terms of the GNU General Public License as published by the Fr" \
"ee Software Foundation; either version 2 of the License, or (at your o" \
"ption) any later version.\n" \
"\n" \
"Tetravex is distributed in the hope that it will be useful, but WITHOU" \
"T ANY WARRANTY; without even the implied warranty of MERCHANTABILITY o" \
"r FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License" \
" for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License alon" \
"g with Tetravex; if not, write to the Free Software Foundation, Inc., " \
"51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA");
	license = _tmp5_;
	_tmp6_ = self->priv->window;
	_tmp7_ = _ ("Tetravex");
	_tmp8_ = _ ("Position pieces so that the same numbers are touching each other\n" \
"\n" \
"Tetravex is a part of GNOME Games.");
	_tmp9_ = _ ("translator-credits");
	_tmp10_ = _ ("GNOME Games web site");
	gtk_show_about_dialog ((GtkWindow*) _tmp6_, "program-name", _tmp7_, "version", VERSION, "comments", _tmp8_, "copyright", "Copyright \xc2\xa9 1999-2008 Lars Rydlinge", "license", license, "wrap-license", TRUE, "authors", authors, "documenters", documenters, "translator-credits", _tmp9_, "logo-icon-name", "gnome-tetravex", "website", "http://www.gnome.org/projects/gnome-games", "website-label", _tmp10_, NULL, NULL);
	_g_free0 (license);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static gchar* _variant_get3 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void tetravex_size_changed (Tetravex* self, GSimpleAction* action, GVariant* value) {
	gchar size = '\0';
	GVariant* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar _tmp3_ = '\0';
	gchar _tmp4_ = '\0';
	gchar _tmp5_ = '\0';
	GSettings* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GSettings* _tmp8_ = NULL;
	gchar _tmp9_ = '\0';
	GSimpleAction* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = value;
	_tmp1_ = _variant_get3 (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_get (_tmp2_, (glong) 0);
	_tmp4_ = _tmp3_ - '0';
	_g_free0 (_tmp2_);
	size = _tmp4_;
	_tmp5_ = size;
	_tmp6_ = self->priv->settings;
	_tmp7_ = g_settings_get_int (_tmp6_, TETRAVEX_KEY_GRID_SIZE);
	if (((gint) _tmp5_) == _tmp7_) {
		return;
	}
	_tmp8_ = self->priv->settings;
	_tmp9_ = size;
	g_settings_set_int (_tmp8_, TETRAVEX_KEY_GRID_SIZE, (gint) _tmp9_);
	_tmp10_ = action;
	_tmp11_ = value;
	g_simple_action_set_state (_tmp10_, _tmp11_);
	tetravex_new_game (self);
}


static void tetravex_move_up_cb (Tetravex* self) {
	Puzzle* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzle;
	puzzle_move_up (_tmp0_);
}


static void tetravex_move_left_cb (Tetravex* self) {
	Puzzle* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzle;
	puzzle_move_left (_tmp0_);
}


static void tetravex_move_right_cb (Tetravex* self) {
	Puzzle* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzle;
	puzzle_move_right (_tmp0_);
}


static void tetravex_move_down_cb (Tetravex* self) {
	Puzzle* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzle;
	puzzle_move_down (_tmp0_);
}


static void tetravex_pause_cb (Tetravex* self, GSimpleAction* action, GVariant* parameter) {
	Puzzle* _tmp0_ = NULL;
	Puzzle* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->puzzle;
	_tmp1_ = self->priv->puzzle;
	_tmp2_ = puzzle_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	puzzle_set_paused (_tmp0_, !_tmp3_);
	tetravex_update_button_states (self);
}


static void tetravex_update_button_states (Tetravex* self) {
	GSimpleAction* solve = NULL;
	GAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	Puzzle* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	Puzzle* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "solve");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL);
	solve = _tmp1_;
	_tmp2_ = solve;
	_tmp3_ = self->priv->puzzle;
	_tmp4_ = puzzle_get_paused (_tmp3_);
	_tmp5_ = _tmp4_;
	g_simple_action_set_enabled (_tmp2_, !_tmp5_);
	_tmp6_ = self->priv->puzzle;
	_tmp7_ = puzzle_get_paused (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		GtkButton* _tmp9_ = NULL;
		GtkTextDirection _tmp10_ = 0;
		GtkLabel* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		_tmp9_ = self->priv->pause_button;
		_tmp10_ = gtk_widget_get_direction ((GtkWidget*) _tmp9_);
		if (_tmp10_ == GTK_TEXT_DIR_RTL) {
			GtkImage* _tmp11_ = NULL;
			_tmp11_ = self->priv->pause_image;
			g_object_set (_tmp11_, "icon-name", "media-playback-start-rtl-symbolic", NULL);
		} else {
			GtkImage* _tmp12_ = NULL;
			_tmp12_ = self->priv->pause_image;
			g_object_set (_tmp12_, "icon-name", "media-playback-start-symbolic", NULL);
		}
		_tmp13_ = self->priv->pause_label;
		_tmp14_ = _ ("Res_ume");
		gtk_label_set_label (_tmp13_, _tmp14_);
	} else {
		GtkImage* _tmp15_ = NULL;
		GtkLabel* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp15_ = self->priv->pause_image;
		g_object_set (_tmp15_, "icon-name", "media-playback-pause-symbolic", NULL);
		_tmp16_ = self->priv->pause_label;
		_tmp17_ = _ ("_Pause");
		gtk_label_set_label (_tmp16_, _tmp17_);
	}
	_g_object_unref0 (solve);
}


static void tetravex_radio_cb (Tetravex* self, GSimpleAction* action, GVariant* parameter) {
	GSimpleAction* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = parameter;
	g_signal_emit_by_name (_tmp0_, "change-state", _tmp1_);
}


gint tetravex_main (gchar** args, int args_length1) {
	gint result = 0;
	Tetravex* app = NULL;
	Tetravex* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = tetravex_new ();
	app = _tmp0_;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = g_application_run ((GApplication*) app, _tmp1__length1, _tmp1_);
	result = _tmp2_;
	_g_object_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
	return tetravex_main (argv, argc);
}


static void tetravex_class_init (TetravexClass * klass) {
	tetravex_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TetravexPrivate));
	G_APPLICATION_CLASS (klass)->startup = tetravex_real_startup;
	G_APPLICATION_CLASS (klass)->shutdown = tetravex_real_shutdown;
	G_APPLICATION_CLASS (klass)->activate = tetravex_real_activate;
	G_OBJECT_CLASS (klass)->finalize = tetravex_finalize;
}


static void tetravex_instance_init (Tetravex * self) {
	self->priv = TETRAVEX_GET_PRIVATE (self);
}


static void tetravex_finalize (GObject* obj) {
	Tetravex * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TETRAVEX, Tetravex);
	_g_object_unref0 (self->priv->settings);
	_puzzle_unref0 (self->priv->puzzle);
	_g_object_unref0 (self->priv->clock_label);
	_history_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->pause_button);
	_g_object_unref0 (self->priv->pause_image);
	_g_object_unref0 (self->priv->pause_label);
	G_OBJECT_CLASS (tetravex_parent_class)->finalize (obj);
}


GType tetravex_get_type (void) {
	static volatile gsize tetravex_type_id__volatile = 0;
	if (g_once_init_enter (&tetravex_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TetravexClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tetravex_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Tetravex), 0, (GInstanceInitFunc) tetravex_instance_init, NULL };
		GType tetravex_type_id;
		tetravex_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Tetravex", &g_define_type_info, 0);
		g_once_init_leave (&tetravex_type_id__volatile, tetravex_type_id);
	}
	return tetravex_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



