/* game-view.c generated by valac 0.22.0.22-b05f, the Vala compiler
 * generated from game-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_LED_ARRAY (led_array_get_type ())
#define LED_ARRAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LED_ARRAY, LEDArray))
#define LED_ARRAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LED_ARRAY, LEDArrayClass))
#define IS_LED_ARRAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LED_ARRAY))
#define IS_LED_ARRAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LED_ARRAY))
#define LED_ARRAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LED_ARRAY, LEDArrayClass))

typedef struct _LEDArray LEDArray;
typedef struct _LEDArrayClass LEDArrayClass;

#define TYPE_BOARD_VIEW (board_view_get_type ())
#define BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD_VIEW, BoardView))
#define BOARD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOARD_VIEW, BoardViewClass))
#define IS_BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD_VIEW))
#define IS_BOARD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOARD_VIEW))
#define BOARD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOARD_VIEW, BoardViewClass))

typedef struct _BoardView BoardView;
typedef struct _BoardViewClass BoardViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BoardViewPrivate BoardViewPrivate;

struct _GameView {
	ClutterGroup parent_instance;
	GameViewPrivate * priv;
};

struct _GameViewClass {
	ClutterGroupClass parent_class;
};

struct _GameViewPrivate {
	ClutterTexture* backing_texture;
	ClutterTexture* highlight_texture;
	ClutterTexture* off_texture;
	ClutterTexture* on_texture;
	ClutterTexture* led_back_texture;
	ClutterTexture* arrow_texture;
	gint current_level;
	GList* actor_remove_queue;
	LEDArray* score_view;
	ClutterGroup* board_group;
	BoardView* board_view;
	BoardView* new_board_view;
	ClutterActor* backing_view;
	ClutterActor* left_arrow;
	ClutterActor* right_arrow;
	ClutterActor* key_cursor_view;
	ClutterTimeline* timeline;
	gint key_cursor_x;
	gint key_cursor_y;
	gboolean key_cursor_ready;
	gint last_direction;
	gint last_sign;
};

struct _BoardView {
	ClutterGroup parent_instance;
	BoardViewPrivate * priv;
	gboolean playable;
};

struct _BoardViewClass {
	ClutterGroupClass parent_class;
};


static gpointer game_view_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
GType led_array_get_type (void) G_GNUC_CONST;
GType board_view_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GameView* game_view_new (gint level);
GameView* game_view_construct (GType object_type, gint level);
static BoardView* game_view_create_board_view (GameView* self, gint level);
LEDArray* led_array_new (gint n_digits, ClutterActor* back_texture);
LEDArray* led_array_construct (GType object_type, gint n_digits, ClutterActor* back_texture);
void led_array_set_value (LEDArray* self, gint value);
static gboolean game_view_left_arrow_button_release_cb (GameView* self, ClutterActor* actor, ClutterButtonEvent* event);
static gboolean _game_view_left_arrow_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
static gboolean game_view_right_arrow_button_release_cb (GameView* self, ClutterActor* actor, ClutterButtonEvent* event);
static gboolean _game_view_right_arrow_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
BoardView* board_view_new (ClutterTexture* off_texture, ClutterTexture* on_texture);
BoardView* board_view_construct (GType object_type, ClutterTexture* off_texture, ClutterTexture* on_texture);
void board_view_load_level (BoardView* self, gint level);
static void game_view_game_won_cb (GameView* self);
static void _game_view_game_won_cb_board_view_game_won (BoardView* _sender, gpointer self);
static void game_view_transition_complete_cb (GameView* self);
void board_view_slide_in (BoardView* self, gint direction, gint sign, ClutterTimeline* timeline);
void board_view_slide_out (BoardView* self, gint direction, gint sign, ClutterTimeline* timeline);
static void _game_view_transition_complete_cb_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static void game_view_swap_board (GameView* self, gint direction);
void board_view_swap_in (BoardView* self, gfloat direction, ClutterTimeline* timeline);
void board_view_swap_out (BoardView* self, gfloat direction, ClutterTimeline* timeline);
void game_view_hide_cursor (GameView* self);
void game_view_move_cursor (GameView* self, gint x_step, gint y_step);
void board_view_get_light_position (BoardView* self, gint x, gint y, gfloat* xx, gfloat* yy);
void game_view_activate_cursor (GameView* self);
void board_view_toggle_light (BoardView* self, gint x, gint y, gboolean animate);
void game_view_reset_game (GameView* self);
static void game_view_finalize (GObject* obj);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean _game_view_left_arrow_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = game_view_left_arrow_button_release_cb (self, _sender, event);
	return result;
}


static gboolean _game_view_right_arrow_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = game_view_right_arrow_button_release_cb (self, _sender, event);
	return result;
}


GameView* game_view_construct (GType object_type, gint level) {
	GameView * self = NULL;
	ClutterTexture* _tmp32_ = NULL;
	ClutterTexture* _tmp33_ = NULL;
	ClutterTexture* _tmp34_ = NULL;
	ClutterTexture* _tmp35_ = NULL;
	ClutterTexture* _tmp36_ = NULL;
	ClutterTexture* _tmp37_ = NULL;
	ClutterTexture* _tmp38_ = NULL;
	ClutterTexture* _tmp39_ = NULL;
	ClutterTexture* _tmp40_ = NULL;
	ClutterTexture* _tmp41_ = NULL;
	ClutterTexture* _tmp42_ = NULL;
	ClutterTexture* _tmp43_ = NULL;
	gfloat real_board_width = 0.0F;
	ClutterTexture* _tmp44_ = NULL;
	gfloat _tmp45_ = 0.0F;
	gfloat _tmp46_ = 0.0F;
	gfloat real_board_height = 0.0F;
	ClutterTexture* _tmp47_ = NULL;
	gfloat _tmp48_ = 0.0F;
	gfloat _tmp49_ = 0.0F;
	ClutterGroup* _tmp50_ = NULL;
	ClutterGroup* _tmp51_ = NULL;
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	BoardView* _tmp54_ = NULL;
	BoardView* _tmp55_ = NULL;
	ClutterGroup* _tmp56_ = NULL;
	BoardView* _tmp57_ = NULL;
	ClutterTexture* _tmp58_ = NULL;
	ClutterClone* _tmp59_ = NULL;
	ClutterActor* _tmp60_ = NULL;
	ClutterActor* _tmp61_ = NULL;
	ClutterTexture* _tmp62_ = NULL;
	LEDArray* _tmp63_ = NULL;
	LEDArray* _tmp64_ = NULL;
	gint _tmp65_ = 0;
	LEDArray* _tmp66_ = NULL;
	LEDArray* _tmp67_ = NULL;
	gfloat _tmp68_ = 0.0F;
	gfloat _tmp69_ = 0.0F;
	LEDArray* _tmp70_ = NULL;
	LEDArray* _tmp71_ = NULL;
	LEDArray* _tmp72_ = NULL;
	gfloat _tmp73_ = 0.0F;
	gfloat _tmp74_ = 0.0F;
	LEDArray* _tmp75_ = NULL;
	gfloat _tmp76_ = 0.0F;
	gfloat _tmp77_ = 0.0F;
	ClutterTexture* _tmp78_ = NULL;
	ClutterClone* _tmp79_ = NULL;
	ClutterActor* _tmp80_ = NULL;
	ClutterActor* _tmp81_ = NULL;
	ClutterActor* _tmp82_ = NULL;
	ClutterActor* _tmp83_ = NULL;
	LEDArray* _tmp84_ = NULL;
	gfloat _tmp85_ = 0.0F;
	gfloat _tmp86_ = 0.0F;
	LEDArray* _tmp87_ = NULL;
	gfloat _tmp88_ = 0.0F;
	gfloat _tmp89_ = 0.0F;
	LEDArray* _tmp90_ = NULL;
	gfloat _tmp91_ = 0.0F;
	gfloat _tmp92_ = 0.0F;
	LEDArray* _tmp93_ = NULL;
	gfloat _tmp94_ = 0.0F;
	gfloat _tmp95_ = 0.0F;
	ClutterActor* _tmp96_ = NULL;
	ClutterTexture* _tmp97_ = NULL;
	ClutterClone* _tmp98_ = NULL;
	ClutterActor* _tmp99_ = NULL;
	ClutterActor* _tmp100_ = NULL;
	ClutterActor* _tmp101_ = NULL;
	ClutterActor* _tmp102_ = NULL;
	ClutterActor* _tmp103_ = NULL;
	ClutterActor* _tmp104_ = NULL;
	gfloat _tmp105_ = 0.0F;
	gfloat _tmp106_ = 0.0F;
	LEDArray* _tmp107_ = NULL;
	gfloat _tmp108_ = 0.0F;
	gfloat _tmp109_ = 0.0F;
	LEDArray* _tmp110_ = NULL;
	gfloat _tmp111_ = 0.0F;
	gfloat _tmp112_ = 0.0F;
	ClutterActor* _tmp113_ = NULL;
	ClutterTexture* _tmp114_ = NULL;
	ClutterClone* _tmp115_ = NULL;
	ClutterActor* _tmp116_ = NULL;
	ClutterActor* _tmp117_ = NULL;
	ClutterActor* _tmp118_ = NULL;
	GError * _inner_error_ = NULL;
	self = (GameView*) g_object_new (object_type, NULL);
	{
		ClutterTexture* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		ClutterTexture* _tmp3_ = NULL;
		ClutterTexture* _tmp4_ = NULL;
		ClutterTexture* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		ClutterTexture* _tmp8_ = NULL;
		ClutterTexture* _tmp9_ = NULL;
		ClutterTexture* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		ClutterTexture* _tmp13_ = NULL;
		ClutterTexture* _tmp14_ = NULL;
		ClutterTexture* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		ClutterTexture* _tmp18_ = NULL;
		ClutterTexture* _tmp19_ = NULL;
		ClutterTexture* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		ClutterTexture* _tmp23_ = NULL;
		ClutterTexture* _tmp24_ = NULL;
		ClutterTexture* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		ClutterTexture* _tmp28_ = NULL;
		ClutterTexture* _tmp29_ = NULL;
		_tmp1_ = g_build_filename (DATADIR, "backing.svg", NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp2_, &_inner_error_);
		g_object_ref_sink (_tmp3_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		g_object_ref_sink (_tmp0_);
		_g_object_unref0 (self->priv->backing_texture);
		self->priv->backing_texture = _tmp0_;
		_tmp6_ = g_build_filename (DATADIR, "highlight.svg", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp7_, &_inner_error_);
		g_object_ref_sink (_tmp8_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_tmp5_ = _tmp9_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (self->priv->highlight_texture);
		self->priv->highlight_texture = _tmp5_;
		_tmp11_ = g_build_filename (DATADIR, "off.svg", NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp12_, &_inner_error_);
		g_object_ref_sink (_tmp13_);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp12_);
		_tmp10_ = _tmp14_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		g_object_ref_sink (_tmp10_);
		_g_object_unref0 (self->priv->off_texture);
		self->priv->off_texture = _tmp10_;
		_tmp16_ = g_build_filename (DATADIR, "on.svg", NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp17_, &_inner_error_);
		g_object_ref_sink (_tmp18_);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		_tmp15_ = _tmp19_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		g_object_ref_sink (_tmp15_);
		_g_object_unref0 (self->priv->on_texture);
		self->priv->on_texture = _tmp15_;
		_tmp21_ = g_build_filename (DATADIR, "led-back.svg", NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp22_, &_inner_error_);
		g_object_ref_sink (_tmp23_);
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp22_);
		_tmp20_ = _tmp24_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		g_object_ref_sink (_tmp20_);
		_g_object_unref0 (self->priv->led_back_texture);
		self->priv->led_back_texture = _tmp20_;
		_tmp26_ = g_build_filename (DATADIR, "arrow.svg", NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp27_, &_inner_error_);
		g_object_ref_sink (_tmp28_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp27_);
		_tmp25_ = _tmp29_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		g_object_ref_sink (_tmp25_);
		_g_object_unref0 (self->priv->arrow_texture);
		self->priv->arrow_texture = _tmp25_;
	}
	goto __finally1;
	__catch1_clutter_texture_error:
	{
		GError* e = NULL;
		GError* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->message;
		g_warning ("game-view.vala:57: Failed to load textures: %s", _tmp31_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp32_ = self->priv->backing_texture;
	clutter_actor_hide ((ClutterActor*) _tmp32_);
	_tmp33_ = self->priv->backing_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp33_);
	_tmp34_ = self->priv->highlight_texture;
	clutter_actor_hide ((ClutterActor*) _tmp34_);
	_tmp35_ = self->priv->highlight_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp35_);
	_tmp36_ = self->priv->off_texture;
	clutter_actor_hide ((ClutterActor*) _tmp36_);
	_tmp37_ = self->priv->off_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp37_);
	_tmp38_ = self->priv->on_texture;
	clutter_actor_hide ((ClutterActor*) _tmp38_);
	_tmp39_ = self->priv->on_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp39_);
	_tmp40_ = self->priv->led_back_texture;
	clutter_actor_hide ((ClutterActor*) _tmp40_);
	_tmp41_ = self->priv->led_back_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp41_);
	_tmp42_ = self->priv->arrow_texture;
	clutter_actor_hide ((ClutterActor*) _tmp42_);
	_tmp43_ = self->priv->arrow_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp43_);
	_tmp44_ = self->priv->off_texture;
	_tmp45_ = clutter_actor_get_width ((ClutterActor*) _tmp44_);
	_tmp46_ = _tmp45_;
	real_board_width = (5 * _tmp46_) + 4;
	_tmp47_ = self->priv->off_texture;
	_tmp48_ = clutter_actor_get_height ((ClutterActor*) _tmp47_);
	_tmp49_ = _tmp48_;
	real_board_height = (5 * _tmp49_) + 4;
	_tmp50_ = (ClutterGroup*) clutter_group_new ();
	g_object_ref_sink (_tmp50_);
	_g_object_unref0 (self->priv->board_group);
	self->priv->board_group = _tmp50_;
	_tmp51_ = self->priv->board_group;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp51_);
	_tmp52_ = level;
	self->priv->current_level = _tmp52_;
	_tmp53_ = self->priv->current_level;
	_tmp54_ = game_view_create_board_view (self, _tmp53_);
	_g_object_unref0 (self->priv->board_view);
	self->priv->board_view = _tmp54_;
	_tmp55_ = self->priv->board_view;
	_tmp55_->playable = TRUE;
	_tmp56_ = self->priv->board_group;
	_tmp57_ = self->priv->board_view;
	clutter_container_add_actor ((ClutterContainer*) _tmp56_, (ClutterActor*) _tmp57_);
	_tmp58_ = self->priv->backing_texture;
	_tmp59_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp58_);
	g_object_ref_sink (_tmp59_);
	_g_object_unref0 (self->priv->backing_view);
	self->priv->backing_view = (ClutterActor*) _tmp59_;
	_tmp60_ = self->priv->backing_view;
	clutter_actor_set_position (_tmp60_, (gfloat) 0, real_board_height);
	_tmp61_ = self->priv->backing_view;
	clutter_container_add_actor ((ClutterContainer*) self, _tmp61_);
	_tmp62_ = self->priv->led_back_texture;
	_tmp63_ = led_array_new (5, (ClutterActor*) _tmp62_);
	g_object_ref_sink (_tmp63_);
	_g_object_unref0 (self->priv->score_view);
	self->priv->score_view = _tmp63_;
	_tmp64_ = self->priv->score_view;
	_tmp65_ = self->priv->current_level;
	led_array_set_value (_tmp64_, _tmp65_);
	_tmp66_ = self->priv->score_view;
	_tmp67_ = self->priv->score_view;
	_tmp68_ = clutter_actor_get_width ((ClutterActor*) _tmp67_);
	_tmp69_ = _tmp68_;
	clutter_actor_set_anchor_point ((ClutterActor*) _tmp66_, _tmp69_ / 2, (gfloat) 0);
	_tmp70_ = self->priv->score_view;
	clutter_actor_set_position ((ClutterActor*) _tmp70_, real_board_width / 2, real_board_height + 18);
	_tmp71_ = self->priv->score_view;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp71_);
	_tmp72_ = self->priv->score_view;
	_tmp73_ = clutter_actor_get_y ((ClutterActor*) _tmp72_);
	_tmp74_ = _tmp73_;
	_tmp75_ = self->priv->score_view;
	_tmp76_ = clutter_actor_get_height ((ClutterActor*) _tmp75_);
	_tmp77_ = _tmp76_;
	clutter_actor_set_size ((ClutterActor*) self, real_board_width, _tmp74_ + _tmp77_);
	_tmp78_ = self->priv->arrow_texture;
	_tmp79_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp78_);
	g_object_ref_sink (_tmp79_);
	_g_object_unref0 (self->priv->left_arrow);
	self->priv->left_arrow = (ClutterActor*) _tmp79_;
	_tmp80_ = self->priv->left_arrow;
	g_object_set (_tmp80_, "anchor-gravity", CLUTTER_GRAVITY_CENTER, NULL);
	_tmp81_ = self->priv->left_arrow;
	clutter_actor_set_reactive (_tmp81_, TRUE);
	_tmp82_ = self->priv->left_arrow;
	g_signal_connect_object (_tmp82_, "button-release-event", (GCallback) _game_view_left_arrow_button_release_cb_clutter_actor_button_release_event, self, 0);
	_tmp83_ = self->priv->left_arrow;
	_tmp84_ = self->priv->score_view;
	_tmp85_ = clutter_actor_get_x ((ClutterActor*) _tmp84_);
	_tmp86_ = _tmp85_;
	_tmp87_ = self->priv->score_view;
	g_object_get ((ClutterActor*) _tmp87_, "anchor-x", &_tmp88_, NULL);
	_tmp89_ = _tmp88_;
	_tmp90_ = self->priv->score_view;
	_tmp91_ = clutter_actor_get_y ((ClutterActor*) _tmp90_);
	_tmp92_ = _tmp91_;
	_tmp93_ = self->priv->score_view;
	_tmp94_ = clutter_actor_get_height ((ClutterActor*) _tmp93_);
	_tmp95_ = _tmp94_;
	clutter_actor_set_position (_tmp83_, (_tmp86_ - _tmp89_) / 2, (_tmp92_ + (_tmp95_ / 2)) - 10);
	_tmp96_ = self->priv->left_arrow;
	clutter_container_add_actor ((ClutterContainer*) self, _tmp96_);
	_tmp97_ = self->priv->arrow_texture;
	_tmp98_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp97_);
	g_object_ref_sink (_tmp98_);
	_g_object_unref0 (self->priv->right_arrow);
	self->priv->right_arrow = (ClutterActor*) _tmp98_;
	_tmp99_ = self->priv->right_arrow;
	g_object_set (_tmp99_, "anchor-gravity", CLUTTER_GRAVITY_CENTER, NULL);
	_tmp100_ = self->priv->right_arrow;
	clutter_actor_set_reactive (_tmp100_, TRUE);
	_tmp101_ = self->priv->right_arrow;
	g_signal_connect_object (_tmp101_, "button-release-event", (GCallback) _game_view_right_arrow_button_release_cb_clutter_actor_button_release_event, self, 0);
	_tmp102_ = self->priv->right_arrow;
	g_object_set (_tmp102_, "rotation-angle-y", (gdouble) 180, NULL);
	_tmp103_ = self->priv->right_arrow;
	_tmp104_ = self->priv->left_arrow;
	_tmp105_ = clutter_actor_get_x (_tmp104_);
	_tmp106_ = _tmp105_;
	_tmp107_ = self->priv->score_view;
	_tmp108_ = clutter_actor_get_y ((ClutterActor*) _tmp107_);
	_tmp109_ = _tmp108_;
	_tmp110_ = self->priv->score_view;
	_tmp111_ = clutter_actor_get_height ((ClutterActor*) _tmp110_);
	_tmp112_ = _tmp111_;
	clutter_actor_set_position (_tmp103_, real_board_width - _tmp106_, (_tmp109_ + (_tmp112_ / 2)) - 10);
	_tmp113_ = self->priv->right_arrow;
	clutter_container_add_actor ((ClutterContainer*) self, _tmp113_);
	_tmp114_ = self->priv->highlight_texture;
	_tmp115_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp114_);
	g_object_ref_sink (_tmp115_);
	_g_object_unref0 (self->priv->key_cursor_view);
	self->priv->key_cursor_view = (ClutterActor*) _tmp115_;
	_tmp116_ = self->priv->key_cursor_view;
	clutter_actor_set_position (_tmp116_, (gfloat) (-100), (gfloat) (-100));
	_tmp117_ = self->priv->key_cursor_view;
	g_object_set (_tmp117_, "anchor-gravity", CLUTTER_GRAVITY_CENTER, NULL);
	_tmp118_ = self->priv->key_cursor_view;
	clutter_container_add_actor ((ClutterContainer*) self, _tmp118_);
	return self;
}


GameView* game_view_new (gint level) {
	return game_view_construct (TYPE_GAME_VIEW, level);
}


static void _game_view_game_won_cb_board_view_game_won (BoardView* _sender, gpointer self) {
	game_view_game_won_cb (self);
}


static BoardView* game_view_create_board_view (GameView* self, gint level) {
	BoardView* result = NULL;
	BoardView* view = NULL;
	ClutterTexture* _tmp0_ = NULL;
	ClutterTexture* _tmp1_ = NULL;
	BoardView* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->off_texture;
	_tmp1_ = self->priv->on_texture;
	_tmp2_ = board_view_new (_tmp0_, _tmp1_);
	g_object_ref_sink (_tmp2_);
	view = _tmp2_;
	_tmp3_ = level;
	board_view_load_level (view, _tmp3_);
	g_signal_connect_object (view, "game-won", (GCallback) _game_view_game_won_cb_board_view_game_won, self, 0);
	view->playable = FALSE;
	result = view;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void game_view_transition_complete_cb (GameView* self) {
	BoardView* _tmp0_ = NULL;
	BoardView* _tmp1_ = NULL;
	BoardView* _tmp2_ = NULL;
	BoardView* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->board_view;
	clutter_actor_destroy ((ClutterActor*) _tmp0_);
	_tmp1_ = self->priv->new_board_view;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->board_view);
	self->priv->board_view = _tmp2_;
	_tmp3_ = self->priv->board_view;
	_tmp3_->playable = TRUE;
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = NULL;
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = NULL;
	_tmp4_ = self->priv->actor_remove_queue;
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp4_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* _tmp5_ = NULL;
			ClutterActor* actor = NULL;
			_tmp5_ = _g_object_ref0 ((ClutterActor*) actor_it->data);
			actor = _tmp5_;
			{
				ClutterActor* _tmp6_ = NULL;
				_tmp6_ = actor;
				clutter_actor_destroy (_tmp6_);
				_g_object_unref0 (actor);
			}
		}
	}
	__g_list_free__g_object_unref0_0 (self->priv->actor_remove_queue);
	self->priv->actor_remove_queue = NULL;
}


static void _game_view_transition_complete_cb_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
	game_view_transition_complete_cb (self);
}


static void game_view_game_won_cb (GameView* self) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_ = NULL;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	LEDArray* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint direction = 0;
	gint sign = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	BoardView* _tmp23_ = NULL;
	ClutterGroup* _tmp24_ = NULL;
	BoardView* _tmp25_ = NULL;
	ClutterTimeline* _tmp26_ = NULL;
	BoardView* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	ClutterTimeline* _tmp30_ = NULL;
	BoardView* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	ClutterTimeline* _tmp34_ = NULL;
	ClutterTimeline* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->timeline;
	if (_tmp1_ != NULL) {
		ClutterTimeline* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->timeline;
		_tmp3_ = clutter_timeline_is_playing (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->current_level;
	self->priv->current_level = _tmp5_ + 1;
	_tmp6_ = self->priv->score_view;
	_tmp7_ = self->priv->current_level;
	led_array_set_value (_tmp6_, _tmp7_);
	direction = 0;
	sign = 0;
	{
		gboolean _tmp8_ = FALSE;
		_tmp8_ = TRUE;
		while (TRUE) {
			gboolean _tmp9_ = FALSE;
			gint32 _tmp16_ = 0;
			gint _tmp17_ = 0;
			gboolean _tmp18_ = FALSE;
			gint _tmp19_ = 0;
			_tmp9_ = _tmp8_;
			if (!_tmp9_) {
				gboolean _tmp10_ = FALSE;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gboolean _tmp15_ = FALSE;
				_tmp11_ = self->priv->last_direction;
				_tmp12_ = direction;
				if (_tmp11_ == _tmp12_) {
					gint _tmp13_ = 0;
					gint _tmp14_ = 0;
					_tmp13_ = self->priv->last_sign;
					_tmp14_ = sign;
					_tmp10_ = _tmp13_ == _tmp14_;
				} else {
					_tmp10_ = FALSE;
				}
				_tmp15_ = _tmp10_;
				if (!_tmp15_) {
					break;
				}
			}
			_tmp8_ = FALSE;
			_tmp16_ = g_random_int_range ((gint32) 0, (gint32) 2);
			direction = (gint) _tmp16_;
			_tmp18_ = g_random_boolean ();
			if (_tmp18_) {
				_tmp17_ = 1;
			} else {
				_tmp17_ = -1;
			}
			_tmp19_ = _tmp17_;
			sign = _tmp19_;
		}
	}
	_tmp20_ = direction;
	self->priv->last_direction = _tmp20_;
	_tmp21_ = sign;
	self->priv->last_sign = _tmp21_;
	_tmp22_ = self->priv->current_level;
	_tmp23_ = game_view_create_board_view (self, _tmp22_);
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = _tmp23_;
	_tmp24_ = self->priv->board_group;
	_tmp25_ = self->priv->new_board_view;
	clutter_container_add_actor ((ClutterContainer*) _tmp24_, (ClutterActor*) _tmp25_);
	_tmp26_ = clutter_timeline_new ((guint) 1500);
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = _tmp26_;
	_tmp27_ = self->priv->new_board_view;
	_tmp28_ = direction;
	_tmp29_ = sign;
	_tmp30_ = self->priv->timeline;
	board_view_slide_in (_tmp27_, _tmp28_, _tmp29_, _tmp30_);
	_tmp31_ = self->priv->board_view;
	_tmp32_ = direction;
	_tmp33_ = sign;
	_tmp34_ = self->priv->timeline;
	board_view_slide_out (_tmp31_, _tmp32_, _tmp33_, _tmp34_);
	_tmp35_ = self->priv->timeline;
	g_signal_connect_object (_tmp35_, "completed", (GCallback) _game_view_transition_complete_cb_clutter_timeline_completed, self, 0);
	_tmp36_ = self->priv->current_level;
	g_signal_emit_by_name (self, "level-changed", _tmp36_);
}


static gboolean game_view_left_arrow_button_release_cb (GameView* self, ClutterActor* actor, ClutterButtonEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (actor != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	game_view_swap_board (self, -1);
	result = FALSE;
	return result;
}


static gboolean game_view_right_arrow_button_release_cb (GameView* self, ClutterActor* actor, ClutterButtonEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (actor != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	game_view_swap_board (self, 1);
	result = FALSE;
	return result;
}


static void game_view_swap_board (GameView* self, gint direction) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_ = NULL;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	LEDArray* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	ClutterTimeline* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	BoardView* _tmp12_ = NULL;
	ClutterGroup* _tmp13_ = NULL;
	BoardView* _tmp14_ = NULL;
	BoardView* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	BoardView* _tmp17_ = NULL;
	BoardView* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	ClutterTimeline* _tmp20_ = NULL;
	BoardView* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	ClutterTimeline* _tmp23_ = NULL;
	ClutterTimeline* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->timeline;
	if (_tmp1_ != NULL) {
		ClutterTimeline* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->timeline;
		_tmp3_ = clutter_timeline_is_playing (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->current_level;
	_tmp6_ = direction;
	self->priv->current_level = _tmp5_ + _tmp6_;
	_tmp7_ = self->priv->current_level;
	if (_tmp7_ <= 0) {
		self->priv->current_level = 1;
		return;
	}
	_tmp8_ = self->priv->score_view;
	_tmp9_ = self->priv->current_level;
	led_array_set_value (_tmp8_, _tmp9_);
	_tmp10_ = clutter_timeline_new ((guint) 500);
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = _tmp10_;
	_tmp11_ = self->priv->current_level;
	_tmp12_ = game_view_create_board_view (self, _tmp11_);
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = _tmp12_;
	_tmp13_ = self->priv->board_group;
	_tmp14_ = self->priv->new_board_view;
	clutter_container_add_actor ((ClutterContainer*) _tmp13_, (ClutterActor*) _tmp14_);
	_tmp15_ = self->priv->new_board_view;
	_tmp16_ = direction;
	clutter_actor_set_depth ((ClutterActor*) _tmp15_, (gfloat) ((-250) * _tmp16_));
	_tmp17_ = self->priv->new_board_view;
	clutter_actor_set_opacity ((ClutterActor*) _tmp17_, (guint) 0);
	_tmp18_ = self->priv->new_board_view;
	_tmp19_ = direction;
	_tmp20_ = self->priv->timeline;
	board_view_swap_in (_tmp18_, (gfloat) _tmp19_, _tmp20_);
	_tmp21_ = self->priv->board_view;
	_tmp22_ = direction;
	_tmp23_ = self->priv->timeline;
	board_view_swap_out (_tmp21_, (gfloat) _tmp22_, _tmp23_);
	_tmp24_ = self->priv->timeline;
	g_signal_connect_object (_tmp24_, "completed", (GCallback) _game_view_transition_complete_cb_clutter_timeline_completed, self, 0);
	_tmp25_ = self->priv->current_level;
	g_signal_emit_by_name (self, "level-changed", _tmp25_);
}


void game_view_hide_cursor (GameView* self) {
	ClutterActor* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_cursor_view;
	clutter_actor_animate (_tmp0_, (gulong) CLUTTER_EASE_OUT_SINE, (guint) 250, "opacity", 0, NULL);
	self->priv->key_cursor_ready = FALSE;
}


void game_view_move_cursor (GameView* self, gint x_step, gint y_step) {
	gboolean _tmp0_ = FALSE;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	BoardView* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gfloat _tmp16_ = 0.0F;
	gfloat _tmp17_ = 0.0F;
	gboolean _tmp18_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_cursor_ready;
	if (_tmp0_) {
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		_tmp1_ = self->priv->key_cursor_x;
		_tmp2_ = x_step;
		self->priv->key_cursor_x = _tmp1_ + _tmp2_;
		_tmp3_ = self->priv->key_cursor_y;
		_tmp4_ = y_step;
		self->priv->key_cursor_y = _tmp3_ + _tmp4_;
		_tmp5_ = self->priv->key_cursor_x;
		_tmp6_ = MAX (_tmp5_, 0);
		self->priv->key_cursor_x = _tmp6_;
		_tmp7_ = self->priv->key_cursor_x;
		_tmp8_ = MIN (_tmp7_, 4);
		self->priv->key_cursor_x = _tmp8_;
		_tmp9_ = self->priv->key_cursor_y;
		_tmp10_ = MAX (_tmp9_, 0);
		self->priv->key_cursor_y = _tmp10_;
		_tmp11_ = self->priv->key_cursor_y;
		_tmp12_ = MIN (_tmp11_, 4);
		self->priv->key_cursor_y = _tmp12_;
	}
	_tmp13_ = self->priv->board_view;
	_tmp14_ = self->priv->key_cursor_x;
	_tmp15_ = self->priv->key_cursor_y;
	board_view_get_light_position (_tmp13_, _tmp14_, _tmp15_, &_tmp16_, &_tmp17_);
	x = _tmp16_;
	y = _tmp17_;
	_tmp18_ = self->priv->key_cursor_ready;
	if (_tmp18_) {
		ClutterActor* _tmp19_ = NULL;
		gfloat _tmp20_ = 0.0F;
		gfloat _tmp21_ = 0.0F;
		_tmp19_ = self->priv->key_cursor_view;
		_tmp20_ = x;
		_tmp21_ = y;
		clutter_actor_animate (_tmp19_, (gulong) CLUTTER_EASE_OUT_SINE, (guint) 250, "x", _tmp20_, "y", _tmp21_, NULL);
	} else {
		ClutterActor* _tmp22_ = NULL;
		ClutterActor* _tmp23_ = NULL;
		gfloat _tmp24_ = 0.0F;
		gfloat _tmp25_ = 0.0F;
		ClutterActor* _tmp26_ = NULL;
		_tmp22_ = self->priv->key_cursor_view;
		clutter_actor_set_opacity (_tmp22_, (guint) 0);
		_tmp23_ = self->priv->key_cursor_view;
		_tmp24_ = x;
		_tmp25_ = y;
		clutter_actor_set_position (_tmp23_, _tmp24_, _tmp25_);
		_tmp26_ = self->priv->key_cursor_view;
		clutter_actor_animate (_tmp26_, (gulong) CLUTTER_EASE_OUT_SINE, (guint) 250, "opacity", 255, NULL);
	}
	self->priv->key_cursor_ready = TRUE;
}


void game_view_activate_cursor (GameView* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_cursor_ready;
	if (_tmp0_) {
		BoardView* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		_tmp1_ = self->priv->board_view;
		_tmp2_ = self->priv->key_cursor_x;
		_tmp3_ = self->priv->key_cursor_y;
		board_view_toggle_light (_tmp1_, _tmp2_, _tmp3_, TRUE);
	}
}


void game_view_reset_game (GameView* self) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_ = NULL;
	gboolean _tmp4_ = FALSE;
	LEDArray* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	ClutterTimeline* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	BoardView* _tmp9_ = NULL;
	ClutterGroup* _tmp10_ = NULL;
	BoardView* _tmp11_ = NULL;
	BoardView* _tmp12_ = NULL;
	BoardView* _tmp13_ = NULL;
	BoardView* _tmp14_ = NULL;
	ClutterTimeline* _tmp15_ = NULL;
	BoardView* _tmp16_ = NULL;
	ClutterTimeline* _tmp17_ = NULL;
	ClutterTimeline* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->timeline;
	if (_tmp1_ != NULL) {
		ClutterTimeline* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->timeline;
		_tmp3_ = clutter_timeline_is_playing (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		return;
	}
	self->priv->current_level = 1;
	_tmp5_ = self->priv->score_view;
	_tmp6_ = self->priv->current_level;
	led_array_set_value (_tmp5_, _tmp6_);
	_tmp7_ = clutter_timeline_new ((guint) 500);
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = _tmp7_;
	_tmp8_ = self->priv->current_level;
	_tmp9_ = game_view_create_board_view (self, _tmp8_);
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = _tmp9_;
	_tmp10_ = self->priv->board_group;
	_tmp11_ = self->priv->new_board_view;
	clutter_container_add_actor ((ClutterContainer*) _tmp10_, (ClutterActor*) _tmp11_);
	_tmp12_ = self->priv->new_board_view;
	clutter_actor_set_depth ((ClutterActor*) _tmp12_, (gfloat) 250);
	_tmp13_ = self->priv->new_board_view;
	clutter_actor_set_opacity ((ClutterActor*) _tmp13_, (guint) 0);
	_tmp14_ = self->priv->new_board_view;
	_tmp15_ = self->priv->timeline;
	board_view_swap_in (_tmp14_, (gfloat) (-1), _tmp15_);
	_tmp16_ = self->priv->board_view;
	_tmp17_ = self->priv->timeline;
	board_view_swap_out (_tmp16_, (gfloat) (-1), _tmp17_);
	_tmp18_ = self->priv->timeline;
	g_signal_connect_object (_tmp18_, "completed", (GCallback) _game_view_transition_complete_cb_clutter_timeline_completed, self, 0);
	_tmp19_ = self->priv->current_level;
	g_signal_emit_by_name (self, "level-changed", _tmp19_);
}


static void game_view_class_init (GameViewClass * klass) {
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
	g_signal_new ("level_changed", TYPE_GAME_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}


static void game_view_instance_init (GameView * self) {
	self->priv = GAME_VIEW_GET_PRIVATE (self);
	self->priv->actor_remove_queue = NULL;
	self->priv->new_board_view = NULL;
	self->priv->key_cursor_x = 0;
	self->priv->key_cursor_y = 0;
	self->priv->key_cursor_ready = FALSE;
	self->priv->last_direction = 0;
	self->priv->last_sign = 0;
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	_g_object_unref0 (self->priv->backing_texture);
	_g_object_unref0 (self->priv->highlight_texture);
	_g_object_unref0 (self->priv->off_texture);
	_g_object_unref0 (self->priv->on_texture);
	_g_object_unref0 (self->priv->led_back_texture);
	_g_object_unref0 (self->priv->arrow_texture);
	__g_list_free__g_object_unref0_0 (self->priv->actor_remove_queue);
	_g_object_unref0 (self->priv->score_view);
	_g_object_unref0 (self->priv->board_group);
	_g_object_unref0 (self->priv->board_view);
	_g_object_unref0 (self->priv->new_board_view);
	_g_object_unref0 (self->priv->backing_view);
	_g_object_unref0 (self->priv->left_arrow);
	_g_object_unref0 (self->priv->right_arrow);
	_g_object_unref0 (self->priv->key_cursor_view);
	_g_object_unref0 (self->priv->timeline);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}


GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (clutter_group_get_type (), "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}



