/* game-view.c generated by valac 0.22.0.17-a7395, the Vala compiler
 * generated from game-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <librsvg/rsvg.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _game_unref0(var) ((var == NULL) ? NULL : (var = (game_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;

#define TYPE_PLAYER (player_get_type ())

struct _GameView {
	GtkDrawingArea parent_instance;
	GameViewPrivate * priv;
};

struct _GameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _GameViewPrivate {
	guint render_size;
	cairo_pattern_t* tiles_pattern;
	gint* pixmaps;
	gint pixmaps_length1;
	gint pixmaps_length2;
	guint animate_timeout;
	gboolean flip_final_result_now;
	Game* _game;
	gchar* _theme;
	gboolean _show_grid;
	gboolean _flip_final_result;
};

struct _Block1Data {
	int _ref_count_;
	GameView * self;
	gint x;
	gint y;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_LIGHT,
	PLAYER_DARK
} Player;


static gpointer game_view_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
gpointer game_ref (gpointer instance);
void game_unref (gpointer instance);
GParamSpec* param_spec_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_game (GValue* value, gpointer v_object);
void value_take_game (GValue* value, gpointer v_object);
gpointer value_get_game (const GValue* value);
GType game_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY,
	GAME_VIEW_GAME,
	GAME_VIEW_THEME,
	GAME_VIEW_SHOW_GRID,
	GAME_VIEW_FLIP_FINAL_RESULT
};
#define GAME_VIEW_GRID_WIDTH 1
#define GAME_VIEW_PIXMAP_FLIP_DELAY 20
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void game_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural);
static void game_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural);
static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr);
Game* game_view_get_game (GameView* self);
static gint game_view_get_tile_size (GameView* self);
static GdkPixbuf* game_view_load_theme (GameView* self);
static gint game_view_get_x_offset (GameView* self);
static gint game_view_get_y_offset (GameView* self);
gboolean game_view_get_show_grid (GameView* self);
static gint game_view_get_board_size (GameView* self);
const gchar* game_view_get_theme (GameView* self);
void game_view_redraw (GameView* self);
static void game_view_square_changed_cb (GameView* self, gint x, gint y);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
GType player_get_type (void) G_GNUC_CONST;
static gint game_view_get_pixmap (GameView* self, Player color);
Player game_get_owner (Game* self, gint x, gint y);
gboolean game_get_is_complete (Game* self);
gint game_get_width (Game* self);
gint game_get_n_light_tiles (Game* self);
gint game_get_n_dark_tiles (Game* self);
static void game_view_set_square (GameView* self, gint x, gint y, gint pixmap);
gboolean game_view_get_flip_final_result (GameView* self);
static gboolean ___lambda2_ (Block1Data* _data1_);
static gboolean ____lambda2__gsource_func (gpointer self);
static gboolean game_view_animate_cb (GameView* self);
static gboolean _game_view_animate_cb_gsource_func (gpointer self);
static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
void game_view_set_game (GameView* self, Game* value);
static void _game_view_square_changed_cb_game_square_changed (Game* _sender, gint x, gint y, gpointer self);
void game_view_set_theme (GameView* self, const gchar* value);
void game_view_set_show_grid (GameView* self, gboolean value);
void game_view_set_flip_final_result (GameView* self, gboolean value);
gint game_get_height (Game* self);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void game_view_finalize (GObject* obj);
static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GameView* game_view_construct (GType object_type) {
	GameView * self = NULL;
	gint* _tmp0_ = NULL;
	self = (GameView*) g_object_new (object_type, NULL);
	gtk_widget_set_events ((GtkWidget*) self, (gint) (GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK));
	_tmp0_ = g_new0 (gint, 8 * 8);
	self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
	self->priv->pixmaps = _tmp0_;
	self->priv->pixmaps_length1 = 8;
	self->priv->pixmaps_length2 = 8;
	return self;
}


GameView* game_view_new (void) {
	return game_view_construct (TYPE_GAME_VIEW);
}


static void game_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural) {
	GameView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	self = (GameView*) base;
	_vala_natural = (gint) (8 * (20 + GAME_VIEW_GRID_WIDTH));
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void game_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural) {
	GameView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	self = (GameView*) base;
	_vala_natural = (gint) (8 * (20 + GAME_VIEW_GRID_WIDTH));
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr) {
	GameView * self;
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	cairo_pattern_t* _tmp3_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_ = FALSE;
	self = (GameView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->tiles_pattern;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		guint _tmp4_ = 0U;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp4_ = self->priv->render_size;
		_tmp5_ = game_view_get_tile_size (self);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp4_ != ((guint) _tmp6_);
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		cairo_surface_t* surface = NULL;
		cairo_t* _tmp10_ = NULL;
		cairo_surface_t* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		cairo_surface_t* _tmp16_ = NULL;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp17_ = NULL;
		cairo_t* _tmp18_ = NULL;
		GdkPixbuf* pixbuf = NULL;
		GdkPixbuf* _tmp19_ = NULL;
		cairo_t* _tmp20_ = NULL;
		GdkPixbuf* _tmp21_ = NULL;
		cairo_t* _tmp22_ = NULL;
		cairo_surface_t* _tmp23_ = NULL;
		cairo_pattern_t* _tmp24_ = NULL;
		_tmp8_ = game_view_get_tile_size (self);
		_tmp9_ = _tmp8_;
		self->priv->render_size = (guint) _tmp9_;
		_tmp10_ = cr;
		_tmp11_ = cairo_get_target (_tmp10_);
		_tmp12_ = game_view_get_tile_size (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = game_view_get_tile_size (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = cairo_surface_create_similar (_tmp11_, CAIRO_CONTENT_COLOR_ALPHA, _tmp13_ * 8, _tmp15_ * 4);
		surface = _tmp16_;
		_tmp17_ = surface;
		_tmp18_ = cairo_create (_tmp17_);
		c = _tmp18_;
		_tmp19_ = game_view_load_theme (self);
		pixbuf = _tmp19_;
		_tmp20_ = c;
		_tmp21_ = pixbuf;
		gdk_cairo_set_source_pixbuf (_tmp20_, _tmp21_, (gdouble) 0, (gdouble) 0);
		_tmp22_ = c;
		cairo_paint (_tmp22_);
		_tmp23_ = surface;
		_tmp24_ = cairo_pattern_create_for_surface (_tmp23_);
		_cairo_pattern_destroy0 (self->priv->tiles_pattern);
		self->priv->tiles_pattern = _tmp24_;
		_g_object_unref0 (pixbuf);
		_cairo_destroy0 (c);
		_cairo_surface_destroy0 (surface);
	}
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp25_ = FALSE;
			_tmp25_ = TRUE;
			while (TRUE) {
				gboolean _tmp26_ = FALSE;
				gint _tmp28_ = 0;
				_tmp26_ = _tmp25_;
				if (!_tmp26_) {
					gint _tmp27_ = 0;
					_tmp27_ = x;
					x = _tmp27_ + 1;
				}
				_tmp25_ = FALSE;
				_tmp28_ = x;
				if (!(_tmp28_ < 8)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp29_ = FALSE;
						_tmp29_ = TRUE;
						while (TRUE) {
							gboolean _tmp30_ = FALSE;
							gint _tmp32_ = 0;
							gint tile_x = 0;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							gint tile_y = 0;
							gint _tmp38_ = 0;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gint _tmp41_ = 0;
							gint _tmp42_ = 0;
							gint texture_x = 0;
							gint* _tmp43_ = NULL;
							gint _tmp43__length1 = 0;
							gint _tmp43__length2 = 0;
							gint _tmp44_ = 0;
							gint _tmp45_ = 0;
							gint _tmp46_ = 0;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							gint texture_y = 0;
							gint* _tmp49_ = NULL;
							gint _tmp49__length1 = 0;
							gint _tmp49__length2 = 0;
							gint _tmp50_ = 0;
							gint _tmp51_ = 0;
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
							gint _tmp54_ = 0;
							cairo_matrix_t matrix = {0};
							gint _tmp55_ = 0;
							gint _tmp56_ = 0;
							gint _tmp57_ = 0;
							gint _tmp58_ = 0;
							cairo_pattern_t* _tmp59_ = NULL;
							cairo_matrix_t _tmp60_ = {0};
							cairo_t* _tmp61_ = NULL;
							cairo_pattern_t* _tmp62_ = NULL;
							cairo_t* _tmp63_ = NULL;
							gint _tmp64_ = 0;
							gint _tmp65_ = 0;
							gint _tmp66_ = 0;
							gint _tmp67_ = 0;
							gint _tmp68_ = 0;
							gint _tmp69_ = 0;
							cairo_t* _tmp70_ = NULL;
							_tmp30_ = _tmp29_;
							if (!_tmp30_) {
								gint _tmp31_ = 0;
								_tmp31_ = y;
								y = _tmp31_ + 1;
							}
							_tmp29_ = FALSE;
							_tmp32_ = y;
							if (!(_tmp32_ < 8)) {
								break;
							}
							_tmp33_ = game_view_get_x_offset (self);
							_tmp34_ = _tmp33_;
							_tmp35_ = x;
							_tmp36_ = game_view_get_tile_size (self);
							_tmp37_ = _tmp36_;
							tile_x = _tmp34_ + (_tmp35_ * (_tmp37_ + GAME_VIEW_GRID_WIDTH));
							_tmp38_ = game_view_get_y_offset (self);
							_tmp39_ = _tmp38_;
							_tmp40_ = y;
							_tmp41_ = game_view_get_tile_size (self);
							_tmp42_ = _tmp41_;
							tile_y = _tmp39_ + (_tmp40_ * (_tmp42_ + GAME_VIEW_GRID_WIDTH));
							_tmp43_ = self->priv->pixmaps;
							_tmp43__length1 = self->priv->pixmaps_length1;
							_tmp43__length2 = self->priv->pixmaps_length2;
							_tmp44_ = x;
							_tmp45_ = y;
							_tmp46_ = _tmp43_[(_tmp44_ * _tmp43__length2) + _tmp45_];
							_tmp47_ = game_view_get_tile_size (self);
							_tmp48_ = _tmp47_;
							texture_x = (_tmp46_ % 8) * _tmp48_;
							_tmp49_ = self->priv->pixmaps;
							_tmp49__length1 = self->priv->pixmaps_length1;
							_tmp49__length2 = self->priv->pixmaps_length2;
							_tmp50_ = x;
							_tmp51_ = y;
							_tmp52_ = _tmp49_[(_tmp50_ * _tmp49__length2) + _tmp51_];
							_tmp53_ = game_view_get_tile_size (self);
							_tmp54_ = _tmp53_;
							texture_y = (_tmp52_ / 8) * _tmp54_;
							cairo_matrix_init_identity (&matrix);
							_tmp55_ = texture_x;
							_tmp56_ = tile_x;
							_tmp57_ = texture_y;
							_tmp58_ = tile_y;
							cairo_matrix_translate (&matrix, (gdouble) (_tmp55_ - _tmp56_), (gdouble) (_tmp57_ - _tmp58_));
							_tmp59_ = self->priv->tiles_pattern;
							_tmp60_ = matrix;
							cairo_pattern_set_matrix (_tmp59_, &_tmp60_);
							_tmp61_ = cr;
							_tmp62_ = self->priv->tiles_pattern;
							cairo_set_source (_tmp61_, _tmp62_);
							_tmp63_ = cr;
							_tmp64_ = tile_x;
							_tmp65_ = tile_y;
							_tmp66_ = game_view_get_tile_size (self);
							_tmp67_ = _tmp66_;
							_tmp68_ = game_view_get_tile_size (self);
							_tmp69_ = _tmp68_;
							cairo_rectangle (_tmp63_, (gdouble) _tmp64_, (gdouble) _tmp65_, (gdouble) _tmp67_, (gdouble) _tmp69_);
							_tmp70_ = cr;
							cairo_fill (_tmp70_);
						}
					}
				}
			}
		}
	}
	_tmp71_ = game_view_get_show_grid (self);
	_tmp72_ = _tmp71_;
	if (_tmp72_) {
		gint dash_count = 0;
		gint _tmp73_ = 0;
		gint _tmp74_ = 0;
		gint _tmp75_ = 0;
		gdouble dash[1] = {0};
		gint _tmp77_ = 0;
		gint _tmp78_ = 0;
		gint _tmp79_ = 0;
		gdouble _tmp80_ = 0.0;
		cairo_t* _tmp81_ = NULL;
		cairo_t* _tmp82_ = NULL;
		cairo_t* _tmp83_ = NULL;
		cairo_t* _tmp84_ = NULL;
		cairo_t* _tmp111_ = NULL;
		_tmp73_ = game_view_get_tile_size (self);
		_tmp74_ = _tmp73_;
		dash_count = (_tmp74_ + GAME_VIEW_GRID_WIDTH) / 4;
		_tmp75_ = dash_count;
		if ((_tmp75_ % 2) != 0) {
			gint _tmp76_ = 0;
			_tmp76_ = dash_count;
			dash_count = _tmp76_ - 1;
		}
		_tmp77_ = game_view_get_tile_size (self);
		_tmp78_ = _tmp77_;
		_tmp79_ = dash_count;
		dash[0] = ((gdouble) (_tmp78_ + GAME_VIEW_GRID_WIDTH)) / _tmp79_;
		_tmp80_ = dash[0];
		_tmp81_ = cr;
		cairo_set_dash (_tmp81_, dash, 1, 2.5);
		_tmp82_ = cr;
		cairo_set_source_rgb (_tmp82_, 1.0, 1.0, 1.0);
		_tmp83_ = cr;
		cairo_set_operator (_tmp83_, CAIRO_OPERATOR_DIFFERENCE);
		_tmp84_ = cr;
		cairo_set_line_width (_tmp84_, (gdouble) GAME_VIEW_GRID_WIDTH);
		{
			gint i = 0;
			i = 1;
			{
				gboolean _tmp85_ = FALSE;
				_tmp85_ = TRUE;
				while (TRUE) {
					gboolean _tmp86_ = FALSE;
					gint _tmp88_ = 0;
					cairo_t* _tmp89_ = NULL;
					gint _tmp90_ = 0;
					gint _tmp91_ = 0;
					gint _tmp92_ = 0;
					gint _tmp93_ = 0;
					gint _tmp94_ = 0;
					gint _tmp95_ = 0;
					gint _tmp96_ = 0;
					cairo_t* _tmp97_ = NULL;
					gint _tmp98_ = 0;
					gint _tmp99_ = 0;
					cairo_t* _tmp100_ = NULL;
					gint _tmp101_ = 0;
					gint _tmp102_ = 0;
					gint _tmp103_ = 0;
					gint _tmp104_ = 0;
					gint _tmp105_ = 0;
					gint _tmp106_ = 0;
					gint _tmp107_ = 0;
					cairo_t* _tmp108_ = NULL;
					gint _tmp109_ = 0;
					gint _tmp110_ = 0;
					_tmp86_ = _tmp85_;
					if (!_tmp86_) {
						gint _tmp87_ = 0;
						_tmp87_ = i;
						i = _tmp87_ + 1;
					}
					_tmp85_ = FALSE;
					_tmp88_ = i;
					if (!(_tmp88_ < 8)) {
						break;
					}
					_tmp89_ = cr;
					_tmp90_ = game_view_get_x_offset (self);
					_tmp91_ = _tmp90_;
					_tmp92_ = i;
					_tmp93_ = game_view_get_board_size (self);
					_tmp94_ = _tmp93_;
					_tmp95_ = game_view_get_y_offset (self);
					_tmp96_ = _tmp95_;
					cairo_move_to (_tmp89_, (_tmp91_ + ((_tmp92_ * _tmp94_) / 8)) - 0.5, (gdouble) _tmp96_);
					_tmp97_ = cr;
					_tmp98_ = game_view_get_board_size (self);
					_tmp99_ = _tmp98_;
					cairo_rel_line_to (_tmp97_, (gdouble) 0, (gdouble) _tmp99_);
					_tmp100_ = cr;
					_tmp101_ = game_view_get_x_offset (self);
					_tmp102_ = _tmp101_;
					_tmp103_ = game_view_get_y_offset (self);
					_tmp104_ = _tmp103_;
					_tmp105_ = i;
					_tmp106_ = game_view_get_board_size (self);
					_tmp107_ = _tmp106_;
					cairo_move_to (_tmp100_, (gdouble) _tmp102_, (_tmp104_ + ((_tmp105_ * _tmp107_) / 8)) - 0.5);
					_tmp108_ = cr;
					_tmp109_ = game_view_get_board_size (self);
					_tmp110_ = _tmp109_;
					cairo_rel_line_to (_tmp108_, (gdouble) _tmp110_, (gdouble) 0);
				}
			}
		}
		_tmp111_ = cr;
		cairo_stroke (_tmp111_);
	}
	result = FALSE;
	return result;
}


static GdkPixbuf* game_view_load_theme (GameView* self) {
	GdkPixbuf* result = NULL;
	gint width = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint height = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	GdkPixbuf* _tmp18_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = game_view_get_tile_size (self);
	_tmp1_ = _tmp0_;
	width = _tmp1_ * 8;
	_tmp2_ = game_view_get_tile_size (self);
	_tmp3_ = _tmp2_;
	height = _tmp3_ * 4;
	{
		GdkPixbuf* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		GdkPixbuf* _tmp9_ = NULL;
		_tmp5_ = game_view_get_theme (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = width;
		_tmp8_ = height;
		_tmp9_ = rsvg_pixbuf_from_file_at_size (_tmp6_, _tmp7_, _tmp8_, &_inner_error_);
		_tmp4_ = _tmp9_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		result = _tmp4_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		GdkPixbuf* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		GdkPixbuf* _tmp15_ = NULL;
		_tmp11_ = game_view_get_theme (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = width;
		_tmp14_ = height;
		_tmp15_ = gdk_pixbuf_new_from_file_at_scale (_tmp12_, _tmp13_, _tmp14_, FALSE, &_inner_error_);
		_tmp10_ = _tmp15_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		result = _tmp10_;
		return result;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp16_ = width;
	_tmp17_ = height;
	_tmp18_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, _tmp16_, _tmp17_);
	result = _tmp18_;
	return result;
}


void game_view_redraw (GameView* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GameView * self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean ___lambda2_ (Block1Data* _data1_) {
	GameView * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	self = _data1_->self;
	self->priv->flip_final_result_now = TRUE;
	_tmp0_ = _data1_->x;
	_tmp1_ = _data1_->y;
	game_view_square_changed_cb (self, _tmp0_, _tmp1_);
	result = FALSE;
	return result;
}


static gboolean ____lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda2_ (self);
	return result;
}


static void game_view_square_changed_cb (GameView* self, gint x, gint y) {
	Block1Data* _data1_;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint pixmap = 0;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Player _tmp6_ = 0;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gint _tmp51_ = 0;
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	Game* _tmp57_ = NULL;
	Game* _tmp58_ = NULL;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp68_ = FALSE;
	gboolean _tmp73_ = FALSE;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = x;
	_data1_->x = _tmp0_;
	_tmp1_ = y;
	_data1_->y = _tmp1_;
	_tmp2_ = game_view_get_game (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _data1_->x;
	_tmp5_ = _data1_->y;
	_tmp6_ = game_get_owner (_tmp3_, _tmp4_, _tmp5_);
	_tmp7_ = game_view_get_pixmap (self, _tmp6_);
	pixmap = _tmp7_;
	_tmp9_ = self->priv->flip_final_result_now;
	if (_tmp9_) {
		Game* _tmp10_ = NULL;
		Game* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		_tmp10_ = game_view_get_game (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = game_get_is_complete (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp8_ = _tmp13_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp14_ = _tmp8_;
	if (_tmp14_) {
		gint n = 0;
		gint _tmp15_ = 0;
		Game* _tmp16_ = NULL;
		Game* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		Player winning_color = 0;
		Player losing_color = 0;
		gint n_winning_tiles = 0;
		Game* _tmp21_ = NULL;
		Game* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		gint n_losing_tiles = 0;
		Game* _tmp25_ = NULL;
		Game* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		_tmp15_ = _data1_->y;
		_tmp16_ = game_view_get_game (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = game_get_width (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _data1_->x;
		n = (_tmp15_ * _tmp19_) + _tmp20_;
		winning_color = PLAYER_LIGHT;
		losing_color = PLAYER_DARK;
		_tmp21_ = game_view_get_game (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = game_get_n_light_tiles (_tmp22_);
		_tmp24_ = _tmp23_;
		n_winning_tiles = _tmp24_;
		_tmp25_ = game_view_get_game (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = game_get_n_dark_tiles (_tmp26_);
		_tmp28_ = _tmp27_;
		n_losing_tiles = _tmp28_;
		_tmp29_ = n_losing_tiles;
		_tmp30_ = n_winning_tiles;
		if (_tmp29_ > _tmp30_) {
			gint t = 0;
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			winning_color = PLAYER_DARK;
			losing_color = PLAYER_LIGHT;
			_tmp31_ = n_winning_tiles;
			t = _tmp31_;
			_tmp32_ = n_losing_tiles;
			n_winning_tiles = _tmp32_;
			_tmp33_ = t;
			n_losing_tiles = _tmp33_;
		}
		_tmp34_ = n;
		_tmp35_ = n_winning_tiles;
		if (_tmp34_ < _tmp35_) {
			Player _tmp36_ = 0;
			gint _tmp37_ = 0;
			_tmp36_ = winning_color;
			_tmp37_ = game_view_get_pixmap (self, _tmp36_);
			pixmap = _tmp37_;
		} else {
			gint _tmp38_ = 0;
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			_tmp38_ = n;
			_tmp39_ = n_winning_tiles;
			_tmp40_ = n_losing_tiles;
			if (_tmp38_ < (_tmp39_ + _tmp40_)) {
				Player _tmp41_ = 0;
				gint _tmp42_ = 0;
				_tmp41_ = losing_color;
				_tmp42_ = game_view_get_pixmap (self, _tmp41_);
				pixmap = _tmp42_;
			} else {
				gint _tmp43_ = 0;
				_tmp43_ = game_view_get_pixmap (self, PLAYER_NONE);
				pixmap = _tmp43_;
			}
		}
	} else {
		gboolean _tmp44_ = FALSE;
		gboolean _tmp45_ = FALSE;
		gboolean _tmp50_ = FALSE;
		_tmp45_ = self->priv->flip_final_result_now;
		if (_tmp45_) {
			Game* _tmp46_ = NULL;
			Game* _tmp47_ = NULL;
			gboolean _tmp48_ = FALSE;
			gboolean _tmp49_ = FALSE;
			_tmp46_ = game_view_get_game (self);
			_tmp47_ = _tmp46_;
			_tmp48_ = game_get_is_complete (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp44_ = !_tmp49_;
		} else {
			_tmp44_ = FALSE;
		}
		_tmp50_ = _tmp44_;
		if (_tmp50_) {
			self->priv->flip_final_result_now = FALSE;
		}
	}
	_tmp51_ = _data1_->x;
	_tmp52_ = _data1_->y;
	_tmp53_ = pixmap;
	game_view_set_square (self, _tmp51_, _tmp52_, _tmp53_);
	_tmp57_ = game_view_get_game (self);
	_tmp58_ = _tmp57_;
	_tmp59_ = game_get_is_complete (_tmp58_);
	_tmp60_ = _tmp59_;
	if (_tmp60_) {
		gboolean _tmp61_ = FALSE;
		gboolean _tmp62_ = FALSE;
		_tmp61_ = game_view_get_flip_final_result (self);
		_tmp62_ = _tmp61_;
		_tmp56_ = _tmp62_;
	} else {
		_tmp56_ = FALSE;
	}
	_tmp63_ = _tmp56_;
	if (_tmp63_) {
		Game* _tmp64_ = NULL;
		Game* _tmp65_ = NULL;
		gint _tmp66_ = 0;
		gint _tmp67_ = 0;
		_tmp64_ = game_view_get_game (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = game_get_n_light_tiles (_tmp65_);
		_tmp67_ = _tmp66_;
		_tmp55_ = _tmp67_ > 0;
	} else {
		_tmp55_ = FALSE;
	}
	_tmp68_ = _tmp55_;
	if (_tmp68_) {
		Game* _tmp69_ = NULL;
		Game* _tmp70_ = NULL;
		gint _tmp71_ = 0;
		gint _tmp72_ = 0;
		_tmp69_ = game_view_get_game (self);
		_tmp70_ = _tmp69_;
		_tmp71_ = game_get_n_dark_tiles (_tmp70_);
		_tmp72_ = _tmp71_;
		_tmp54_ = _tmp72_ > 0;
	} else {
		_tmp54_ = FALSE;
	}
	_tmp73_ = _tmp54_;
	if (_tmp73_) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 2000, ____lambda2__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static gboolean _game_view_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = game_view_animate_cb (self);
	return result;
}


static void game_view_set_square (GameView* self, gint x, gint y, gint pixmap) {
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_ = 0;
	gboolean _tmp11_ = FALSE;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	gint _tmp45_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pixmaps;
	_tmp0__length1 = self->priv->pixmaps_length1;
	_tmp0__length2 = self->priv->pixmaps_length2;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = pixmap;
	if (_tmp3_ == _tmp4_) {
		return;
	}
	_tmp6_ = pixmap;
	if (_tmp6_ == 0) {
		_tmp5_ = TRUE;
	} else {
		gint* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gint _tmp7__length2 = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		_tmp7_ = self->priv->pixmaps;
		_tmp7__length1 = self->priv->pixmaps_length1;
		_tmp7__length2 = self->priv->pixmaps_length2;
		_tmp8_ = x;
		_tmp9_ = y;
		_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
		_tmp5_ = _tmp10_ == 0;
	}
	_tmp11_ = _tmp5_;
	if (_tmp11_) {
		gint* _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		gint _tmp12__length2 = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		_tmp12_ = self->priv->pixmaps;
		_tmp12__length1 = self->priv->pixmaps_length1;
		_tmp12__length2 = self->priv->pixmaps_length2;
		_tmp13_ = x;
		_tmp14_ = y;
		_tmp15_ = pixmap;
		_tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_] = _tmp15_;
		_tmp16_ = _tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_];
	} else {
		gint _tmp17_ = 0;
		gint* _tmp18_ = NULL;
		gint _tmp18__length1 = 0;
		gint _tmp18__length2 = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		guint _tmp30_ = 0U;
		_tmp17_ = pixmap;
		_tmp18_ = self->priv->pixmaps;
		_tmp18__length1 = self->priv->pixmaps_length1;
		_tmp18__length2 = self->priv->pixmaps_length2;
		_tmp19_ = x;
		_tmp20_ = y;
		_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
		if (_tmp17_ > _tmp21_) {
			gint* _tmp22_ = NULL;
			gint _tmp22__length1 = 0;
			gint _tmp22__length2 = 0;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			_tmp22_ = self->priv->pixmaps;
			_tmp22__length1 = self->priv->pixmaps_length1;
			_tmp22__length2 = self->priv->pixmaps_length2;
			_tmp23_ = x;
			_tmp24_ = y;
			_tmp25_ = _tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_];
			_tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_] = _tmp25_ + 1;
		} else {
			gint* _tmp26_ = NULL;
			gint _tmp26__length1 = 0;
			gint _tmp26__length2 = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			_tmp26_ = self->priv->pixmaps;
			_tmp26__length1 = self->priv->pixmaps_length1;
			_tmp26__length2 = self->priv->pixmaps_length2;
			_tmp27_ = x;
			_tmp28_ = y;
			_tmp29_ = _tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_];
			_tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_] = _tmp29_ - 1;
		}
		_tmp30_ = self->priv->animate_timeout;
		if (_tmp30_ == ((guint) 0)) {
			guint _tmp31_ = 0U;
			_tmp31_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GAME_VIEW_PIXMAP_FLIP_DELAY, _game_view_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->animate_timeout = _tmp31_;
		}
	}
	_tmp32_ = game_view_get_x_offset (self);
	_tmp33_ = _tmp32_;
	_tmp34_ = x;
	_tmp35_ = game_view_get_tile_size (self);
	_tmp36_ = _tmp35_;
	_tmp37_ = game_view_get_y_offset (self);
	_tmp38_ = _tmp37_;
	_tmp39_ = y;
	_tmp40_ = game_view_get_tile_size (self);
	_tmp41_ = _tmp40_;
	_tmp42_ = game_view_get_tile_size (self);
	_tmp43_ = _tmp42_;
	_tmp44_ = game_view_get_tile_size (self);
	_tmp45_ = _tmp44_;
	gtk_widget_queue_draw_area ((GtkWidget*) self, _tmp33_ + (_tmp34_ * ((gint) (_tmp36_ + GAME_VIEW_GRID_WIDTH))), _tmp38_ + (_tmp39_ * ((gint) (_tmp41_ + GAME_VIEW_GRID_WIDTH))), _tmp43_, _tmp45_);
}


static gboolean game_view_animate_cb (GameView* self) {
	gboolean result = FALSE;
	gboolean animating = FALSE;
	gboolean _tmp19_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	animating = FALSE;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = x;
				if (!(_tmp3_ < 8)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							gint old = 0;
							gint* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp8__length2 = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint* _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = y;
								y = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = y;
							if (!(_tmp7_ < 8)) {
								break;
							}
							_tmp8_ = self->priv->pixmaps;
							_tmp8__length1 = self->priv->pixmaps_length1;
							_tmp8__length2 = self->priv->pixmaps_length2;
							_tmp9_ = x;
							_tmp10_ = y;
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
							old = _tmp11_;
							_tmp12_ = x;
							_tmp13_ = y;
							game_view_square_changed_cb (self, _tmp12_, _tmp13_);
							_tmp14_ = self->priv->pixmaps;
							_tmp14__length1 = self->priv->pixmaps_length1;
							_tmp14__length2 = self->priv->pixmaps_length2;
							_tmp15_ = x;
							_tmp16_ = y;
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
							_tmp18_ = old;
							if (_tmp17_ != _tmp18_) {
								animating = TRUE;
							}
						}
					}
				}
			}
		}
	}
	_tmp19_ = animating;
	if (!_tmp19_) {
		self->priv->animate_timeout = (guint) 0;
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gint game_view_get_pixmap (GameView* self, Player color) {
	gint result = 0;
	Player _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = color;
	switch (_tmp0_) {
		default:
		case PLAYER_NONE:
		{
			result = 0;
			return result;
		}
		case PLAYER_DARK:
		{
			result = 1;
			return result;
		}
		case PLAYER_LIGHT:
		{
			result = 31;
			return result;
		}
	}
}


static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	GameView * self;
	gboolean result = FALSE;
	GdkEventButton _tmp0_ = {0};
	guint _tmp1_ = 0U;
	self = (GameView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.button;
	if (_tmp1_ == ((guint) 1)) {
		gint x = 0;
		GdkEventButton _tmp2_ = {0};
		gdouble _tmp3_ = 0.0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint y = 0;
		GdkEventButton _tmp8_ = {0};
		gdouble _tmp9_ = 0.0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gint _tmp17_ = 0;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp23_ = FALSE;
		_tmp2_ = *event;
		_tmp3_ = _tmp2_.x;
		_tmp4_ = game_view_get_x_offset (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = game_view_get_tile_size (self);
		_tmp7_ = _tmp6_;
		x = ((gint) (_tmp3_ - _tmp5_)) / (_tmp7_ + GAME_VIEW_GRID_WIDTH);
		_tmp8_ = *event;
		_tmp9_ = _tmp8_.y;
		_tmp10_ = game_view_get_y_offset (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = game_view_get_tile_size (self);
		_tmp13_ = _tmp12_;
		y = ((gint) (_tmp9_ - _tmp11_)) / (_tmp13_ + GAME_VIEW_GRID_WIDTH);
		_tmp17_ = x;
		if (_tmp17_ >= 0) {
			gint _tmp18_ = 0;
			_tmp18_ = x;
			_tmp16_ = _tmp18_ < 8;
		} else {
			_tmp16_ = FALSE;
		}
		_tmp19_ = _tmp16_;
		if (_tmp19_) {
			gint _tmp20_ = 0;
			_tmp20_ = y;
			_tmp15_ = _tmp20_ >= 0;
		} else {
			_tmp15_ = FALSE;
		}
		_tmp21_ = _tmp15_;
		if (_tmp21_) {
			gint _tmp22_ = 0;
			_tmp22_ = y;
			_tmp14_ = _tmp22_ < 8;
		} else {
			_tmp14_ = FALSE;
		}
		_tmp23_ = _tmp14_;
		if (_tmp23_) {
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			_tmp24_ = x;
			_tmp25_ = y;
			g_signal_emit_by_name (self, "move", _tmp24_, _tmp25_);
		}
	}
	result = TRUE;
	return result;
}


static gint game_view_get_tile_size (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp2_ = MIN (_tmp0_ / 8, _tmp1_ / ((gint) 8));
	result = _tmp2_ - GAME_VIEW_GRID_WIDTH;
	return result;
}


static gint game_view_get_x_offset (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = game_view_get_tile_size (self);
	_tmp2_ = _tmp1_;
	result = (_tmp0_ - (8 * (_tmp2_ + GAME_VIEW_GRID_WIDTH))) / 2;
	return result;
}


static gint game_view_get_y_offset (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp1_ = game_view_get_tile_size (self);
	_tmp2_ = _tmp1_;
	result = (_tmp0_ - (8 * (_tmp2_ + GAME_VIEW_GRID_WIDTH))) / 2;
	return result;
}


static gint game_view_get_board_size (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = game_view_get_tile_size (self);
	_tmp1_ = _tmp0_;
	result = (_tmp1_ + GAME_VIEW_GRID_WIDTH) * 8;
	return result;
}


Game* game_view_get_game (GameView* self) {
	Game* result;
	Game* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}


static gpointer _game_ref0 (gpointer self) {
	return self ? game_ref (self) : NULL;
}


static void _game_view_square_changed_cb_game_square_changed (Game* _sender, gint x, gint y, gpointer self) {
	game_view_square_changed_cb (self, x, y);
}


void game_view_set_game (GameView* self, Game* value) {
	Game* _tmp0_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_ = NULL;
		_tmp1_ = self->priv->_game;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = value;
	_tmp3_ = _game_ref0 (_tmp2_);
	_game_unref0 (self->priv->_game);
	self->priv->_game = _tmp3_;
	_tmp4_ = self->priv->_game;
	if (_tmp4_ != NULL) {
		Game* _tmp5_ = NULL;
		_tmp5_ = self->priv->_game;
		g_signal_connect_object (_tmp5_, "square-changed", (GCallback) _game_view_square_changed_cb_game_square_changed, self, 0);
		{
			gint x = 0;
			x = 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					gboolean _tmp7_ = FALSE;
					gint _tmp9_ = 0;
					_tmp7_ = _tmp6_;
					if (!_tmp7_) {
						gint _tmp8_ = 0;
						_tmp8_ = x;
						x = _tmp8_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp9_ = x;
					if (!(_tmp9_ < 8)) {
						break;
					}
					{
						gint y = 0;
						y = 0;
						{
							gboolean _tmp10_ = FALSE;
							_tmp10_ = TRUE;
							while (TRUE) {
								gboolean _tmp11_ = FALSE;
								gint _tmp13_ = 0;
								gint* _tmp14_ = NULL;
								gint _tmp14__length1 = 0;
								gint _tmp14__length2 = 0;
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
								Game* _tmp17_ = NULL;
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
								Player _tmp20_ = 0;
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								_tmp11_ = _tmp10_;
								if (!_tmp11_) {
									gint _tmp12_ = 0;
									_tmp12_ = y;
									y = _tmp12_ + 1;
								}
								_tmp10_ = FALSE;
								_tmp13_ = y;
								if (!(_tmp13_ < 8)) {
									break;
								}
								_tmp14_ = self->priv->pixmaps;
								_tmp14__length1 = self->priv->pixmaps_length1;
								_tmp14__length2 = self->priv->pixmaps_length2;
								_tmp15_ = x;
								_tmp16_ = y;
								_tmp17_ = self->priv->_game;
								_tmp18_ = x;
								_tmp19_ = y;
								_tmp20_ = game_get_owner (_tmp17_, _tmp18_, _tmp19_);
								_tmp21_ = game_view_get_pixmap (self, _tmp20_);
								_tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_] = _tmp21_;
								_tmp22_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
							}
						}
					}
				}
			}
		}
	}
	game_view_redraw (self);
	g_object_notify ((GObject *) self, "game");
}


const gchar* game_view_get_theme (GameView* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme;
	result = _tmp0_;
	return result;
}


void game_view_set_theme (GameView* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_theme);
	self->priv->_theme = _tmp1_;
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	self->priv->tiles_pattern = NULL;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "theme");
}


gboolean game_view_get_show_grid (GameView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_grid;
	result = _tmp0_;
	return result;
}


void game_view_set_show_grid (GameView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_grid = _tmp0_;
	game_view_redraw (self);
	g_object_notify ((GObject *) self, "show-grid");
}


gboolean game_view_get_flip_final_result (GameView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_flip_final_result;
	result = _tmp0_;
	return result;
}


void game_view_set_flip_final_result (GameView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_flip_final_result = _tmp0_;
	_tmp1_ = game_view_get_game (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		return;
	}
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				gint _tmp6_ = 0;
				Game* _tmp7_ = NULL;
				Game* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = x;
					x = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = x;
				_tmp7_ = game_view_get_game (self);
				_tmp8_ = _tmp7_;
				_tmp9_ = game_get_width (_tmp8_);
				_tmp10_ = _tmp9_;
				if (!(_tmp6_ < _tmp10_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp11_ = FALSE;
						_tmp11_ = TRUE;
						while (TRUE) {
							gboolean _tmp12_ = FALSE;
							gint _tmp14_ = 0;
							Game* _tmp15_ = NULL;
							Game* _tmp16_ = NULL;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							_tmp12_ = _tmp11_;
							if (!_tmp12_) {
								gint _tmp13_ = 0;
								_tmp13_ = y;
								y = _tmp13_ + 1;
							}
							_tmp11_ = FALSE;
							_tmp14_ = y;
							_tmp15_ = game_view_get_game (self);
							_tmp16_ = _tmp15_;
							_tmp17_ = game_get_height (_tmp16_);
							_tmp18_ = _tmp17_;
							if (!(_tmp14_ < _tmp18_)) {
								break;
							}
							_tmp19_ = x;
							_tmp20_ = y;
							game_view_square_changed_cb (self, _tmp19_, _tmp20_);
						}
					}
				}
			}
		}
	}
	g_object_notify ((GObject *) self, "flip-final-result");
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void game_view_class_init (GameViewClass * klass) {
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
	GTK_WIDGET_CLASS (klass)->get_preferred_width = game_view_real_get_preferred_width;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = game_view_real_get_preferred_height;
	GTK_WIDGET_CLASS (klass)->draw = game_view_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = game_view_real_button_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME, param_spec_game ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME, g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_SHOW_GRID, g_param_spec_boolean ("show-grid", "show-grid", "show-grid", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_FLIP_FINAL_RESULT, g_param_spec_boolean ("flip-final-result", "flip-final-result", "flip-final-result", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("move", TYPE_GAME_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
}


static void game_view_instance_init (GameView * self) {
	self->priv = GAME_VIEW_GET_PRIVATE (self);
	self->priv->render_size = (guint) 0;
	self->priv->tiles_pattern = NULL;
	self->priv->animate_timeout = (guint) 0;
	self->priv->flip_final_result_now = FALSE;
	self->priv->_game = NULL;
	self->priv->_theme = NULL;
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
	_game_unref0 (self->priv->_game);
	_g_free0 (self->priv->_theme);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}


GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}


static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_GAME:
		value_set_game (value, game_view_get_game (self));
		break;
		case GAME_VIEW_THEME:
		g_value_set_string (value, game_view_get_theme (self));
		break;
		case GAME_VIEW_SHOW_GRID:
		g_value_set_boolean (value, game_view_get_show_grid (self));
		break;
		case GAME_VIEW_FLIP_FINAL_RESULT:
		g_value_set_boolean (value, game_view_get_flip_final_result (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_GAME:
		game_view_set_game (self, value_get_game (value));
		break;
		case GAME_VIEW_THEME:
		game_view_set_theme (self, g_value_get_string (value));
		break;
		case GAME_VIEW_SHOW_GRID:
		game_view_set_show_grid (self, g_value_get_boolean (value));
		break;
		case GAME_VIEW_FLIP_FINAL_RESULT:
		game_view_set_flip_final_result (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



