/* rygel-object-creator.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-object-creator.vala, do not modify */

/*
 * Copyright (C) 2010-2011 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>
#include <glib/gi18n-lib.h>
#include <libsoup/soup.h>
#include <stdio.h>
#include <uuid/uuid.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_BASE_MEDIA_CONTAINER (rygel_base_media_container_get_type ())
#define RYGEL_BASE_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASE_MEDIA_CONTAINER, RygelBaseMediaContainer))
#define RYGEL_BASE_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASE_MEDIA_CONTAINER, RygelBaseMediaContainerClass))
#define RYGEL_IS_BASE_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASE_MEDIA_CONTAINER))
#define RYGEL_IS_BASE_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASE_MEDIA_CONTAINER))
#define RYGEL_BASE_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASE_MEDIA_CONTAINER, RygelBaseMediaContainerClass))

typedef struct _RygelBaseMediaContainer RygelBaseMediaContainer;
typedef struct _RygelBaseMediaContainerClass RygelBaseMediaContainerClass;
typedef struct _RygelBaseMediaContainerPrivate RygelBaseMediaContainerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelBaseMediaContainerGetChildrenData RygelBaseMediaContainerGetChildrenData;
typedef struct _RygelBaseMediaContainerFindObjectData RygelBaseMediaContainerFindObjectData;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_OBJECT_CREATOR (rygel_object_creator_get_type ())
#define RYGEL_OBJECT_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreator))
#define RYGEL_OBJECT_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreatorClass))
#define RYGEL_IS_OBJECT_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_OBJECT_CREATOR))
#define RYGEL_IS_OBJECT_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_OBJECT_CREATOR))
#define RYGEL_OBJECT_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreatorClass))

typedef struct _RygelObjectCreator RygelObjectCreator;
typedef struct _RygelObjectCreatorClass RygelObjectCreatorClass;
typedef struct _RygelObjectCreatorPrivate RygelObjectCreatorPrivate;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;

#define RYGEL_TYPE_SERVICE_ACTION (rygel_service_action_get_type ())
#define RYGEL_SERVICE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERVICE_ACTION, RygelServiceAction))
#define RYGEL_SERVICE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERVICE_ACTION, RygelServiceActionClass))
#define RYGEL_IS_SERVICE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERVICE_ACTION))
#define RYGEL_IS_SERVICE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERVICE_ACTION))
#define RYGEL_SERVICE_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERVICE_ACTION, RygelServiceActionClass))

typedef struct _RygelServiceAction RygelServiceAction;
typedef struct _RygelServiceActionClass RygelServiceActionClass;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;

#define TYPE_SERIALIZER_TYPE (serializer_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_WRITABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerClass))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_IS_WRITABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerClass))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerClass RygelWritableContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_OBJECT_REMOVAL_QUEUE (rygel_object_removal_queue_get_type ())
#define RYGEL_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueue))
#define RYGEL_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_OBJECT_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))

typedef struct _RygelObjectRemovalQueue RygelObjectRemovalQueue;
typedef struct _RygelObjectRemovalQueueClass RygelObjectRemovalQueueClass;
typedef struct _RygelObjectCreatorRunData RygelObjectCreatorRunData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

#define RYGEL_TYPE_SEARCH_CRITERIA_PARSER (rygel_search_criteria_parser_get_type ())
#define RYGEL_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParser))
#define RYGEL_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_SEARCH_CRITERIA_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))

typedef struct _RygelSearchCriteriaParser RygelSearchCriteriaParser;
typedef struct _RygelSearchCriteriaParserClass RygelSearchCriteriaParserClass;

#define RYGEL_TYPE_LOGICAL_EXPRESSION (rygel_logical_expression_get_type ())
#define RYGEL_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpression))
#define RYGEL_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))
#define RYGEL_IS_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_IS_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_LOGICAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))

typedef struct _RygelLogicalExpression RygelLogicalExpression;
typedef struct _RygelLogicalExpressionClass RygelLogicalExpressionClass;

#define RYGEL_TYPE_LOGICAL_OPERATOR (rygel_logical_operator_get_type ())
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
typedef struct _RygelSearchCriteriaParserPrivate RygelSearchCriteriaParserPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _RygelObjectCreatorBuildCreateClassExpressionData RygelObjectCreatorBuildCreateClassExpressionData;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_SEARCHABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerClass))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_IS_SEARCHABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerClass))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerClass RygelSearchableContainerClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelObjectCreatorFindAnyContainerData RygelObjectCreatorFindAnyContainerData;
typedef struct _RygelObjectCreatorFetchContainerData RygelObjectCreatorFetchContainerData;

#define RYGEL_TYPE_IMAGE_ITEM (rygel_image_item_get_type ())
#define RYGEL_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItem))
#define RYGEL_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))
#define RYGEL_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))

typedef struct _RygelImageItem RygelImageItem;
typedef struct _RygelImageItemClass RygelImageItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelObjectCreatorCreateObjectFromDidlData RygelObjectCreatorCreateObjectFromDidlData;
#define __vala_SoupDate_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupDate_free (var), NULL)))

#define RYGEL_TYPE_PHOTO_ITEM (rygel_photo_item_get_type ())
#define RYGEL_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItem))
#define RYGEL_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))
#define RYGEL_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))

typedef struct _RygelPhotoItem RygelPhotoItem;
typedef struct _RygelPhotoItemClass RygelPhotoItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;

#define RYGEL_TYPE_PLAYLIST_ITEM (rygel_playlist_item_get_type ())
#define RYGEL_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYLIST_ITEM, RygelPlaylistItem))
#define RYGEL_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAYLIST_ITEM, RygelPlaylistItemClass))
#define RYGEL_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYLIST_ITEM))
#define RYGEL_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAYLIST_ITEM))
#define RYGEL_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAYLIST_ITEM, RygelPlaylistItemClass))

typedef struct _RygelPlaylistItem RygelPlaylistItem;
typedef struct _RygelPlaylistItemClass RygelPlaylistItemClass;
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
typedef struct _RygelObjectCreatorCreateUriData RygelObjectCreatorCreateUriData;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _RygelObjectCreatorWaitForObjectData RygelObjectCreatorWaitForObjectData;

#define RYGEL_TYPE_DLNA_PROFILE (rygel_dlna_profile_get_type ())
#define RYGEL_DLNA_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DLNA_PROFILE, RygelDLNAProfile))
#define RYGEL_DLNA_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DLNA_PROFILE, RygelDLNAProfileClass))
#define RYGEL_IS_DLNA_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DLNA_PROFILE))
#define RYGEL_IS_DLNA_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DLNA_PROFILE))
#define RYGEL_DLNA_PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DLNA_PROFILE, RygelDLNAProfileClass))

typedef struct _RygelDLNAProfile RygelDLNAProfile;
typedef struct _RygelDLNAProfileClass RygelDLNAProfileClass;

#define RYGEL_TYPE_MEDIA_SERVER_PLUGIN (rygel_media_server_plugin_get_type ())
#define RYGEL_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin))
#define RYGEL_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_MEDIA_SERVER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))

typedef struct _RygelMediaServerPlugin RygelMediaServerPlugin;
typedef struct _RygelMediaServerPluginClass RygelMediaServerPluginClass;
typedef struct _RygelRootDevicePrivate RygelRootDevicePrivate;
typedef struct _RygelMediaServerPluginPrivate RygelMediaServerPluginPrivate;
#define _rygel_dlna_profile_unref0(var) ((var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL)))

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* ref_id;
	gchar* upnp_class;
	GUPnPOCMFlags ocm_flags;
	GeeArrayList* uris;
	guint object_update_id;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*get_children) (RygelMediaObject* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaObject* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	GeeArrayList* create_classes;
	gchar* sort_criteria;
	guint update_id;
	RygelMediaObject* found_object;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelBaseMediaContainer {
	RygelMediaContainer parent_instance;
	RygelBaseMediaContainerPrivate * priv;
};

struct _RygelBaseMediaContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelBaseMediaContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelBaseMediaContainer* self;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
};

struct _RygelBaseMediaContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelBaseMediaContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelObjectCreator {
	GObject parent_instance;
	RygelObjectCreatorPrivate * priv;
};

struct _RygelObjectCreatorClass {
	GObjectClass parent_class;
};

struct _RygelObjectCreatorPrivate {
	gchar* container_id;
	gchar* elements;
	GUPnPDIDLLiteObject* didl_object;
	RygelMediaObject* object;
	RygelContentDirectory* content_dir;
	RygelServiceAction* action;
	RygelSerializer* serializer;
	GUPnPDIDLLiteParser* didl_parser;
	GRegex* title_regex;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GObject parent_instance;
	RygelContentDirectoryPrivate * priv;
	GCancellable* cancellable;
	RygelMediaContainer* root_container;
	RygelHTTPServer* http_server;
	RygelRootDevice* root_device;
};

struct _RygelContentDirectoryClass {
	GObjectClass parent_class;
};

typedef enum  {
	SERIALIZER_TYPE_GENERIC_DIDL,
	SERIALIZER_TYPE_DIDL_S,
	SERIALIZER_TYPE_M3UEXT
} SerializerType;

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT,
	RYGEL_CONTENT_DIRECTORY_ERROR_ERROR
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* dlna_profile;
	gchar* mime_type;
	glong size;
	gboolean place_holder;
	gchar* date;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelObjectCreatorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelWritableContainer* container;
	RygelWritableContainer* _tmp0_;
	gboolean _tmp1_;
	RygelWritableContainer* _tmp2_;
	GUPnPDIDLLiteObject* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	GUPnPDIDLLiteObject* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	RygelWritableContainer* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GError* _tmp15_;
	gboolean _tmp16_;
	GUPnPDIDLLiteObject* _tmp17_;
	RygelWritableContainer* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	const gchar* _tmp21_;
	GError* _tmp22_;
	RygelWritableContainer* _tmp23_;
	RygelMediaObject* _tmp24_;
	RygelWritableContainer* _tmp25_;
	RygelMediaObject* _tmp26_;
	GCancellable* _tmp27_;
	GCancellable* _tmp28_;
	RygelWritableContainer* _tmp29_;
	RygelMediaObject* _tmp30_;
	GCancellable* _tmp31_;
	GCancellable* _tmp32_;
	RygelWritableContainer* _tmp33_;
	RygelMediaObject* _tmp34_;
	RygelSerializer* _tmp35_;
	RygelContentDirectory* _tmp36_;
	RygelHTTPServer* _tmp37_;
	gboolean _tmp38_;
	const gchar* _tmp39_;
	gboolean _tmp40_;
	RygelMediaObject* _tmp41_;
	RygelMediaObject* _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp45_;
	RygelObjectRemovalQueue* queue;
	RygelObjectRemovalQueue* _tmp46_;
	RygelObjectRemovalQueue* _tmp47_;
	RygelMediaObject* _tmp48_;
	GCancellable* _tmp49_;
	GCancellable* _tmp50_;
	GError* err;
	GError* _tmp51_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_LOGICAL_OPERATOR_AND,
	RYGEL_LOGICAL_OPERATOR_OR
} RygelLogicalOperator;

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelSearchCriteriaParser {
	GObject parent_instance;
	RygelSearchCriteriaParserPrivate * priv;
	gchar* str;
	RygelSearchExpression* expression;
	GError* err;
};

struct _RygelSearchCriteriaParserClass {
	GObjectClass parent_class;
};

struct _RygelObjectCreatorBuildCreateClassExpressionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelSearchExpression* expression;
	RygelSearchExpression* result;
	GUPnPDIDLLiteObject* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	GUPnPDIDLLiteContainer* didl_container;
	GUPnPDIDLLiteObject* _tmp3_;
	GUPnPDIDLLiteContainer* _tmp4_;
	GList* create_classes;
	GUPnPDIDLLiteContainer* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	RygelSearchExpression* _tmp8_;
	RygelSearchExpression* _tmp9_;
	GString* builder;
	GString* _tmp10_;
	GList* _tmp11_;
	GList* create_class_collection;
	GList* create_class_it;
	gchar* _tmp12_;
	gchar* create_class;
	GString* _tmp13_;
	const gchar* _tmp14_;
	GString* _tmp15_;
	GString* _tmp16_;
	gssize _tmp17_;
	GString* _tmp18_;
	RygelSearchCriteriaParser* parser;
	GString* _tmp19_;
	const gchar* _tmp20_;
	RygelSearchCriteriaParser* _tmp21_;
	RygelSearchCriteriaParser* _tmp22_;
	RygelLogicalExpression* rel;
	RygelLogicalExpression* _tmp23_;
	RygelLogicalExpression* _tmp24_;
	RygelSearchExpression* _tmp25_;
	RygelSearchExpression* _tmp26_;
	RygelLogicalExpression* _tmp27_;
	RygelLogicalExpression* _tmp28_;
	RygelSearchCriteriaParser* _tmp29_;
	RygelSearchExpression* _tmp30_;
	RygelSearchExpression* _tmp31_;
	GError* _error_;
	GError * _inner_error_;
};

struct _RygelObjectCreatorFindAnyContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelMediaObject* result;
	RygelSearchableContainer* root_container;
	RygelContentDirectory* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelSearchableContainer* _tmp2_;
	RygelSearchableContainer* _tmp3_;
	gchar* upnp_class;
	GUPnPDIDLLiteObject* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp8_;
	RygelRelationalExpression* _tmp9_;
	RygelRelationalExpression* _tmp10_;
	gchar* _tmp11_;
	RygelSearchExpression* search_expression;
	RygelRelationalExpression* _tmp12_;
	RygelSearchExpression* _tmp13_;
	const gchar* _tmp14_;
	RygelRelationalExpression* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	guint total_matches;
	RygelMediaObjects* _result_;
	RygelSearchableContainer* _tmp18_;
	RygelSearchExpression* _tmp19_;
	RygelSearchableContainer* _tmp20_;
	const gchar* _tmp21_;
	GCancellable* _tmp22_;
	GCancellable* _tmp23_;
	gint _tmp24_;
	RygelMediaObjects* _tmp25_;
	RygelMediaObjects* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	GUPnPDIDLLiteObject* _tmp29_;
	const gchar* _tmp30_;
	RygelMediaObjects* _tmp31_;
	gpointer _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	GUPnPDIDLLiteObject* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	GError* _tmp38_;
	GError * _inner_error_;
};

struct _RygelObjectCreatorFetchContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelWritableContainer* result;
	RygelMediaObject* media_object;
	const gchar* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaObject* _tmp2_;
	RygelMediaObject* _tmp3_;
	RygelContentDirectory* _tmp4_;
	RygelMediaContainer* _tmp5_;
	const gchar* _tmp6_;
	GCancellable* _tmp7_;
	GCancellable* _tmp8_;
	RygelMediaObject* _tmp9_;
	gboolean _tmp10_;
	RygelMediaObject* _tmp11_;
	RygelMediaObject* _tmp12_;
	gboolean _tmp13_;
	const gchar* _tmp14_;
	GError* _tmp15_;
	RygelMediaObject* _tmp16_;
	const gchar* _tmp17_;
	RygelMediaObject* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GError* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	GUPnPDIDLLiteObject* _tmp24_;
	RygelMediaObject* _tmp25_;
	GUPnPOCMFlags _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	GUPnPDIDLLiteObject* _tmp29_;
	RygelMediaObject* _tmp30_;
	GUPnPOCMFlags _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	const gchar* _tmp34_;
	RygelMediaObject* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	GError* _tmp38_;
	RygelMediaObject* _tmp39_;
	RygelWritableContainer* _tmp40_;
	GError * _inner_error_;
};

struct _RygelObjectCreatorCreateObjectFromDidlData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelWritableContainer* container;
	RygelMediaObject* _tmp0_;
	GUPnPDIDLLiteObject* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelWritableContainer* _tmp4_;
	GUPnPDIDLLiteObject* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GUPnPDIDLLiteObject* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	RygelMediaObject* _tmp11_;
	RygelMediaObject* _tmp12_;
	RygelMediaObject* _tmp13_;
	GeeArrayList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gchar* uri;
	RygelWritableContainer* _tmp17_;
	RygelMediaObject* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	RygelMediaObject* _tmp22_;
	GeeArrayList* _tmp23_;
	const gchar* _tmp24_;
	RygelMediaObject* _tmp25_;
	RygelMediaObject* _tmp26_;
	RygelMediaObject* _tmp27_;
	GFile* file;
	RygelMediaObject* _tmp28_;
	GeeArrayList* _tmp29_;
	gpointer _tmp30_;
	gchar* _tmp31_;
	GFile* _tmp32_;
	GFile* _tmp33_;
	RygelMediaObject* _tmp34_;
	GFile* _tmp35_;
	gboolean _tmp36_;
	RygelMediaObject* _tmp37_;
	RygelMediaObject* _tmp38_;
	GeeArrayList* _tmp39_;
	gpointer _tmp40_;
	gchar* _tmp41_;
	GError * _inner_error_;
};

struct _RygelObjectCreatorCreateUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelWritableContainer* container;
	gchar* title;
	gchar* result;
	GFile* dir;
	RygelWritableContainer* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	const gchar* _tmp5_;
	RygelWritableContainer* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GFile* file;
	GFile* _tmp13_;
	gchar* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	gchar* _tmp18_;
	GError * _inner_error_;
};

struct _Block4Data {
	int _ref_count_;
	RygelObjectCreator * self;
	RygelWritableContainer* container;
	gpointer _async_data_;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	guint timeout;
};

struct _RygelObjectCreatorWaitForObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelWritableContainer* container;
	Block4Data* _data4_;
	RygelWritableContainer* _tmp0_;
	RygelWritableContainer* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaObject* object;
	RygelMediaObject* _tmp4_;
	RygelMediaObject* _tmp5_;
	RygelWritableContainer* _tmp6_;
	RygelMediaObject* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GCancellable* _tmp10_;
	GCancellable* _tmp11_;
	RygelMediaObject* _tmp12_;
	GError* _error_;
	gchar* msg;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	RygelWritableContainer* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	RygelMediaObject* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GError* _tmp22_;
	const gchar* _tmp23_;
	RygelMediaObject* _tmp24_;
	Block5Data* _data5_;
	gulong id;
	RygelWritableContainer* _tmp25_;
	gulong _tmp26_;
	guint _tmp27_;
	RygelWritableContainer* _tmp28_;
	gulong _tmp29_;
	guint _tmp30_;
	guint _tmp31_;
	RygelWritableContainer* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	RygelMediaObject* _tmp35_;
	RygelMediaObject* _tmp36_;
	GError * _inner_error_;
};

struct _RygelRootDevice {
	GObject parent_instance;
	RygelRootDevicePrivate * priv;
	RygelMediaServerPlugin* resource_factory;
};

struct _RygelRootDeviceClass {
	GObjectClass parent_class;
};

struct _RygelMediaServerPlugin {
	GObject parent_instance;
	RygelMediaServerPluginPrivate * priv;
	GList* upload_profiles;
};

struct _RygelMediaServerPluginClass {
	GObjectClass parent_class;
};


static gpointer rygel_base_media_container_parent_class = NULL;
static gpointer rygel_object_creator_parent_class = NULL;
static GPatternSpec* rygel_object_creator_comment_pattern;
static GPatternSpec* rygel_object_creator_comment_pattern = NULL;
static RygelStateMachineIface* rygel_object_creator_rygel_state_machine_parent_iface = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_base_media_container_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_BASE_MEDIA_CONTAINER_DUMMY_PROPERTY
};
RygelBaseMediaContainer* rygel_base_media_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count);
RygelBaseMediaContainer* rygel_base_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count);
static void rygel_base_media_container_real_get_children_data_free (gpointer _data);
static void rygel_base_media_container_real_get_children (RygelMediaObject* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_base_media_container_real_get_children_co (RygelBaseMediaContainerGetChildrenData* _data_);
static void rygel_base_media_container_real_find_object_data_free (gpointer _data);
static void rygel_base_media_container_real_find_object (RygelMediaObject* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_base_media_container_real_find_object_co (RygelBaseMediaContainerFindObjectData* _data_);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_object_creator_get_type (void) G_GNUC_CONST;
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
GType rygel_service_action_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
#define RYGEL_OBJECT_CREATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreatorPrivate))
enum  {
	RYGEL_OBJECT_CREATOR_DUMMY_PROPERTY,
	RYGEL_OBJECT_CREATOR_CANCELLABLE
};
#define RYGEL_OBJECT_CREATOR_INVALID_CHARS "/?<>\\:*|\""
RygelObjectCreator* rygel_object_creator_new (RygelContentDirectory* content_dir, RygelServiceAction* action);
RygelObjectCreator* rygel_object_creator_construct (GType object_type, RygelContentDirectory* content_dir, RygelServiceAction* action);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_root_device_get_type (void) G_GNUC_CONST;
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
GType serializer_type_get_type (void) G_GNUC_CONST;
RygelSerializer* rygel_serializer_new (SerializerType type);
RygelSerializer* rygel_serializer_construct (GType object_type, SerializerType type);
static void rygel_object_creator_real_run_data_free (gpointer _data);
static void rygel_object_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_object_creator_real_run_co (RygelObjectCreatorRunData* _data_);
static void rygel_object_creator_parse_args (RygelObjectCreator* self, GError** error);
static void rygel_object_creator_parse_didl (RygelObjectCreator* self, GError** error);
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
static void rygel_object_creator_fetch_container (RygelObjectCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelWritableContainer* rygel_object_creator_fetch_container_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error);
static void rygel_object_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean rygel_writable_container_can_create (RygelWritableContainer* self, const gchar* upnp_class);
#define RYGEL_MEDIA_CONTAINER_ANY "DLNA.ORG_AnyContainer"
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
GQuark rygel_content_directory_error_quark (void);
static gboolean rygel_object_creator_validate_create_class (RygelObjectCreator* self, RygelWritableContainer* container);
static void rygel_object_creator_create_object_from_didl (RygelObjectCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_object_creator_create_object_from_didl_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_writable_container_add_item (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_item_finish (RygelWritableContainer* self, GAsyncResult* _res_);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
void rygel_writable_container_add_container (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_container_finish (RygelWritableContainer* self, GAsyncResult* _res_);
static void rygel_object_creator_wait_for_object (RygelObjectCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_object_creator_wait_for_object_finish (RygelObjectCreator* self, GAsyncResult* _res_);
void rygel_media_object_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* server);
static void rygel_object_creator_conclude (RygelObjectCreator* self);
GType rygel_object_removal_queue_get_type (void) G_GNUC_CONST;
RygelObjectRemovalQueue* rygel_object_removal_queue_get_default (void);
void rygel_object_removal_queue_queue (RygelObjectRemovalQueue* self, RygelMediaObject* object, GCancellable* cancellable);
static void rygel_object_creator_handle_error (RygelObjectCreator* self, GError* _error_);
void rygel_service_action_get (RygelServiceAction* self, const gchar* arg1_name, GType arg1_type, gchar** arg1_val, const gchar* arg2_name, GType arg2_type, gchar** arg2_val);
static void __lambda4_ (RygelObjectCreator* self, GUPnPDIDLLiteObject* didl_object);
static void ___lambda4__gupnp_didl_lite_parser_object_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteObject* object, gpointer self);
#define RYGEL_PLAYLIST_ITEM_UPNP_CLASS "object.item.playlistItem"
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void rygel_object_creator_generalize_upnp_class (RygelObjectCreator* self, gchar** upnp_class);
static void rygel_object_creator_build_create_class_expression_data_free (gpointer _data);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
static void rygel_object_creator_build_create_class_expression (RygelObjectCreator* self, RygelSearchExpression* expression, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelSearchExpression* rygel_object_creator_build_create_class_expression_finish (RygelObjectCreator* self, GAsyncResult* _res_);
static gboolean rygel_object_creator_build_create_class_expression_co (RygelObjectCreatorBuildCreateClassExpressionData* _data_);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
GType rygel_search_criteria_parser_get_type (void) G_GNUC_CONST;
RygelSearchCriteriaParser* rygel_search_criteria_parser_new (const gchar* str, GError** error);
RygelSearchCriteriaParser* rygel_search_criteria_parser_construct (GType object_type, const gchar* str, GError** error);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
static void rygel_object_creator_build_create_class_expression_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_logical_expression_get_type (void) G_GNUC_CONST;
RygelLogicalExpression* rygel_logical_expression_new (void);
RygelLogicalExpression* rygel_logical_expression_construct (GType object_type);
GType rygel_logical_operator_get_type (void) G_GNUC_CONST;
static void rygel_object_creator_find_any_container_data_free (gpointer _data);
static void rygel_object_creator_find_any_container (RygelObjectCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObject* rygel_object_creator_find_any_container_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_object_creator_find_any_container_co (RygelObjectCreatorFindAnyContainerData* _data_);
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
static void rygel_object_creator_find_any_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, gint offset, gint count, const gchar* soer_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, gint* total_matches);
static void rygel_object_creator_fetch_container_data_free (gpointer _data);
static gboolean rygel_object_creator_fetch_container_co (RygelObjectCreatorFetchContainerData* _data_);
static void rygel_object_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_object_find_object (RygelMediaObject* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_object_find_object_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
gchar* rygel_serializer_get_string (RygelSerializer* self);
void rygel_service_action_set (RygelServiceAction* self, const gchar* arg1_name, GType arg1_type, const gchar* arg1_val, const gchar* arg2_name, GType arg2_type, const gchar* arg2_val);
void rygel_service_action_return (RygelServiceAction* self);
void rygel_service_action_return_error (RygelServiceAction* self, gint code, const gchar* message);
static gchar* rygel_object_creator_get_generic_mime_type (RygelObjectCreator* self);
GType rygel_image_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
static void rygel_object_creator_create_object_from_didl_data_free (gpointer _data);
static gboolean rygel_object_creator_create_object_from_didl_co (RygelObjectCreatorCreateObjectFromDidlData* _data_);
static RygelMediaObject* rygel_object_creator_create_object (RygelObjectCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error);
static void rygel_object_creator_extract_item_parameters (RygelObjectCreator* self, GError** error);
static void rygel_object_creator_create_uri (RygelObjectCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* rygel_object_creator_create_uri_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
static void rygel_object_creator_create_object_from_didl_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_object_set_id (RygelMediaObject* self, const gchar* value);
static void rygel_object_creator_parse_and_verify_didl_date (RygelObjectCreator* self, GError** error);
static gboolean rygel_object_creator_is_profile_valid (RygelObjectCreator* self, const gchar* profile);
static gboolean rygel_object_creator_is_valid_uri (RygelObjectCreator* self, const gchar* uri, gchar** sanitized_uri);
void rygel_media_object_add_uri (RygelMediaObject* self, const gchar* uri);
static void _vala_SoupDate_free (SoupDate* self);
#define RYGEL_IMAGE_ITEM_UPNP_CLASS "object.item.imageItem"
#define RYGEL_PHOTO_ITEM_UPNP_CLASS "object.item.imageItem.photo"
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
#define RYGEL_MUSIC_ITEM_UPNP_CLASS "object.item.audioItem.musicTrack"
#define RYGEL_MEDIA_CONTAINER_UPNP_CLASS "object.container"
#define RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER "object.container.storageFolder"
#define RYGEL_MEDIA_CONTAINER_PLAYLIST "object.container.playlistContainer"
RygelImageItem* rygel_image_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelImageItem* rygel_image_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelPhotoItem* rygel_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelPhotoItem* rygel_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
GType rygel_photo_item_get_type (void) G_GNUC_CONST;
RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelAudioItem* rygel_audio_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelAudioItem* rygel_audio_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
RygelPlaylistItem* rygel_playlist_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelPlaylistItem* rygel_playlist_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
GType rygel_playlist_item_get_type (void) G_GNUC_CONST;
static void _vala_SoupURI_free (SoupURI* self);
static gchar* rygel_object_creator_mangle_title (RygelObjectCreator* self, const gchar* title, GError** error);
static void rygel_object_creator_create_uri_data_free (gpointer _data);
static gboolean rygel_object_creator_create_uri_co (RygelObjectCreatorCreateUriData* _data_);
void rygel_writable_container_get_writable (RygelWritableContainer* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_writable_container_get_writable_finish (RygelWritableContainer* self, GAsyncResult* _res_);
static void rygel_object_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_object_creator_wait_for_object_data_free (gpointer _data);
static gboolean rygel_object_creator_wait_for_object_co (RygelObjectCreatorWaitForObjectData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void rygel_object_creator_wait_for_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ____lambda5_ (Block5Data* _data5_, RygelMediaContainer* container);
static void _____lambda5__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
static gboolean ____lambda6_ (Block5Data* _data5_);
static gboolean _____lambda6__gsource_func (gpointer self);
gpointer rygel_dlna_profile_ref (gpointer instance);
void rygel_dlna_profile_unref (gpointer instance);
GParamSpec* rygel_param_spec_dlna_profile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_dlna_profile (GValue* value, gpointer v_object);
void rygel_value_take_dlna_profile (GValue* value, gpointer v_object);
gpointer rygel_value_get_dlna_profile (const GValue* value);
GType rygel_dlna_profile_get_type (void) G_GNUC_CONST;
GType rygel_media_server_plugin_get_type (void) G_GNUC_CONST;
RygelDLNAProfile* rygel_dlna_profile_new (const gchar* name, const gchar* mime);
RygelDLNAProfile* rygel_dlna_profile_construct (GType object_type, const gchar* name, const gchar* mime);
gint rygel_dlna_profile_compare_by_name (RygelDLNAProfile* a, RygelDLNAProfile* b);
static gint _rygel_dlna_profile_compare_by_name_gcompare_func (gconstpointer a, gconstpointer b);
static void rygel_object_creator_finalize (GObject* obj);
static void _vala_rygel_object_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_object_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Create a media container with the specified details.
     *
     * @param id See the id property of the #RygelMediaObject class.
     * @param parent The parent container, if any.
     * @param title See the title property of the #RygelMediaObject class.
     * @param child_count The initially-known number of child items.
     */
RygelBaseMediaContainer* rygel_base_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count) {
	RygelBaseMediaContainer * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 40 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 40 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 44 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = id;
#line 44 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = parent;
#line 44 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp2_ = title;
#line 44 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp3_ = child_count;
#line 44 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	self = (RygelBaseMediaContainer*) g_object_new (object_type, "id", _tmp0_, "parent", _tmp1_, "title", _tmp2_, "child-count", _tmp3_, NULL);
#line 40 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return self;
#line 1138 "rygel-object-creator.c"
}


RygelBaseMediaContainer* rygel_base_media_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count) {
#line 40 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return rygel_base_media_container_construct (RYGEL_TYPE_BASE_MEDIA_CONTAINER, id, parent, title, child_count);
#line 1145 "rygel-object-creator.c"
}


static void rygel_base_media_container_real_get_children_data_free (gpointer _data) {
	RygelBaseMediaContainerGetChildrenData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (_data_->sort_criteria);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->cancellable);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->result);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_slice_free (RygelBaseMediaContainerGetChildrenData, _data_);
#line 1162 "rygel-object-creator.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return self ? g_object_ref (self) : NULL;
#line 1169 "rygel-object-creator.c"
}


static void rygel_base_media_container_real_get_children (RygelMediaObject* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelBaseMediaContainer * self;
	RygelBaseMediaContainerGetChildrenData* _data_;
	RygelBaseMediaContainer* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
	GCancellable* _tmp6_ = NULL;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	self = (RygelBaseMediaContainer*) base;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = g_slice_new0 (RygelBaseMediaContainerGetChildrenData);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_base_media_container_real_get_children);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_base_media_container_real_get_children_data_free);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = offset;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->offset = _tmp1_;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp2_ = max_count;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->max_count = _tmp2_;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp3_ = sort_criteria;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (_data_->sort_criteria);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->sort_criteria = _tmp4_;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp5_ = cancellable;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->cancellable);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->cancellable = _tmp6_;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_base_media_container_real_get_children_co (_data_);
#line 1221 "rygel-object-creator.c"
}


static RygelMediaObjects* rygel_base_media_container_real_get_children_finish (RygelMediaObject* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelBaseMediaContainerGetChildrenData* _data_;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return NULL;
#line 1232 "rygel-object-creator.c"
	}
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	result = _data_->result;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->result = NULL;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return result;
#line 1242 "rygel-object-creator.c"
}


/**
     * Fetches the list of media objects directly under this container.
     *
     * @param offset zero-based index of the first item to return
     * @param max_count maximum number of objects to return
     * @param sort_criteria sorting order of objects to return
     * @param cancellable optional cancellable for this operation
     *
     * @return A list of media objects.
     */
static gboolean rygel_base_media_container_real_get_children_co (RygelBaseMediaContainerGetChildrenData* _data_) {
#line 60 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	switch (_data_->_state_) {
#line 60 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 0:
#line 1261 "rygel-object-creator.c"
		goto _state_0;
		default:
#line 60 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 1266 "rygel-object-creator.c"
	}
	_state_0:
#line 66 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->result = NULL;
#line 66 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 66 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1275 "rygel-object-creator.c"
	} else {
#line 66 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1279 "rygel-object-creator.c"
	}
#line 66 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 66 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return FALSE;
#line 60 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 60 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1289 "rygel-object-creator.c"
	} else {
#line 60 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1293 "rygel-object-creator.c"
	}
#line 60 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 60 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return FALSE;
#line 1299 "rygel-object-creator.c"
}


static void rygel_base_media_container_real_find_object_data_free (gpointer _data) {
	RygelBaseMediaContainerFindObjectData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (_data_->id);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->cancellable);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->result);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_slice_free (RygelBaseMediaContainerFindObjectData, _data_);
#line 1316 "rygel-object-creator.c"
}


static void rygel_base_media_container_real_find_object (RygelMediaObject* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelBaseMediaContainer * self;
	RygelBaseMediaContainerFindObjectData* _data_;
	RygelBaseMediaContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	self = (RygelBaseMediaContainer*) base;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = g_slice_new0 (RygelBaseMediaContainerFindObjectData);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_base_media_container_real_find_object);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_base_media_container_real_find_object_data_free);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = id;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (_data_->id);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->id = _tmp2_;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp3_ = cancellable;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->cancellable);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->cancellable = _tmp4_;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_base_media_container_real_find_object_co (_data_);
#line 1358 "rygel-object-creator.c"
}


static RygelMediaObject* rygel_base_media_container_real_find_object_finish (RygelMediaObject* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelBaseMediaContainerFindObjectData* _data_;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return NULL;
#line 1369 "rygel-object-creator.c"
	}
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	result = _data_->result;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->result = NULL;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return result;
#line 1379 "rygel-object-creator.c"
}


/**
     * Recursively searches this container for a media object with the given ID.
     *
     * @param id ID of the media object to search for
     * @param cancellable optional cancellable for this operation
     *
     * @return the found media object.
     */
static gboolean rygel_base_media_container_real_find_object_co (RygelBaseMediaContainerFindObjectData* _data_) {
#line 77 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	switch (_data_->_state_) {
#line 77 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 0:
#line 1396 "rygel-object-creator.c"
		goto _state_0;
		default:
#line 77 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 1401 "rygel-object-creator.c"
	}
	_state_0:
#line 80 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->result = NULL;
#line 80 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 80 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1410 "rygel-object-creator.c"
	} else {
#line 80 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1414 "rygel-object-creator.c"
	}
#line 80 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 80 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return FALSE;
#line 77 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 77 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1424 "rygel-object-creator.c"
	} else {
#line 77 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1428 "rygel-object-creator.c"
	}
#line 77 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 77 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return FALSE;
#line 1434 "rygel-object-creator.c"
}


static void rygel_base_media_container_class_init (RygelBaseMediaContainerClass * klass) {
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_base_media_container_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_children = rygel_base_media_container_real_get_children;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_children_finish = rygel_base_media_container_real_get_children_finish;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->find_object = rygel_base_media_container_real_find_object;
#line 31 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->find_object_finish = rygel_base_media_container_real_find_object_finish;
#line 1449 "rygel-object-creator.c"
}


static void rygel_base_media_container_instance_init (RygelBaseMediaContainer * self) {
}


/**
 * Dummy implementation of Rygel.MediaContainer to pass on to
 * Rygel.WritableContianer for creation.
 */
GType rygel_base_media_container_get_type (void) {
	static volatile gsize rygel_base_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_base_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelBaseMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_base_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBaseMediaContainer), 0, (GInstanceInitFunc) rygel_base_media_container_instance_init, NULL };
		GType rygel_base_media_container_type_id;
		rygel_base_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelBaseMediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_base_media_container_type_id__volatile, rygel_base_media_container_type_id);
	}
	return rygel_base_media_container_type_id__volatile;
}


RygelObjectCreator* rygel_object_creator_construct (GType object_type, RygelContentDirectory* content_dir, RygelServiceAction* action) {
	RygelObjectCreator * self = NULL;
	RygelContentDirectory* _tmp0_ = NULL;
	RygelContentDirectory* _tmp1_ = NULL;
	RygelContentDirectory* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	RygelServiceAction* _tmp4_ = NULL;
	RygelSerializer* _tmp5_ = NULL;
	GUPnPDIDLLiteParser* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 110 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_val_if_fail (content_dir != NULL, NULL);
#line 110 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 110 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	self = (RygelObjectCreator*) g_object_new (object_type, NULL);
#line 112 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = content_dir;
#line 112 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 112 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->content_dir);
#line 112 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	self->priv->content_dir = _tmp1_;
#line 113 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp2_ = content_dir;
#line 113 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp3_ = _tmp2_->cancellable;
#line 113 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp3_);
#line 114 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp4_ = action;
#line 114 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	action = NULL;
#line 114 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->action);
#line 114 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	self->priv->action = _tmp4_;
#line 115 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp5_ = rygel_serializer_new (SERIALIZER_TYPE_GENERIC_DIDL);
#line 115 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->serializer);
#line 115 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	self->priv->serializer = _tmp5_;
#line 116 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp6_ = gupnp_didl_lite_parser_new ();
#line 116 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->didl_parser);
#line 116 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	self->priv->didl_parser = _tmp6_;
#line 1523 "rygel-object-creator.c"
	{
		gchar* pattern = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		GRegex* _tmp13_ = NULL;
		GRegex* _tmp14_ = NULL;
#line 118 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp7_ = g_regex_escape_string (RYGEL_OBJECT_CREATOR_INVALID_CHARS, -1);
#line 118 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp8_ = _tmp7_;
#line 118 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp9_ = g_strconcat ("[", _tmp8_, NULL);
#line 118 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp10_ = _tmp9_;
#line 118 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp11_ = g_strconcat (_tmp10_, "]", NULL);
#line 118 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp12_ = _tmp11_;
#line 118 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_free0 (_tmp10_);
#line 118 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_free0 (_tmp8_);
#line 118 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		pattern = _tmp12_;
#line 119 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp14_ = g_regex_new (pattern, G_REGEX_OPTIMIZE, G_REGEX_MATCH_NOTEMPTY, &_inner_error_);
#line 119 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp13_ = _tmp14_;
#line 119 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_inner_error_ != NULL) {
#line 119 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_free0 (pattern);
#line 1560 "rygel-object-creator.c"
			goto __catch0_g_error;
		}
#line 119 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_regex_unref0 (self->priv->title_regex);
#line 119 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		self->priv->title_regex = _tmp13_;
#line 117 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_free0 (pattern);
#line 1569 "rygel-object-creator.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
#line 117 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_error_ = _inner_error_;
#line 117 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_inner_error_ = NULL;
#line 122 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 117 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_error_free0 (_error_);
#line 1583 "rygel-object-creator.c"
	}
	__finally0:
#line 117 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_inner_error_ != NULL) {
#line 117 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (action);
#line 117 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 117 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_clear_error (&_inner_error_);
#line 117 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return NULL;
#line 1596 "rygel-object-creator.c"
	}
#line 110 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (action);
#line 110 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return self;
#line 1602 "rygel-object-creator.c"
}


RygelObjectCreator* rygel_object_creator_new (RygelContentDirectory* content_dir, RygelServiceAction* action) {
#line 110 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return rygel_object_creator_construct (RYGEL_TYPE_OBJECT_CREATOR, content_dir, action);
#line 1609 "rygel-object-creator.c"
}


static void rygel_object_creator_real_run_data_free (gpointer _data) {
	RygelObjectCreatorRunData* _data_;
	_data_ = _data;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_slice_free (RygelObjectCreatorRunData, _data_);
#line 1620 "rygel-object-creator.c"
}


static void rygel_object_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreator * self;
	RygelObjectCreatorRunData* _data_;
	RygelObjectCreator* _tmp0_ = NULL;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	self = (RygelObjectCreator*) base;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = g_slice_new0 (RygelObjectCreatorRunData);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_real_run);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_real_run_data_free);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->self = _tmp0_;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_real_run_co (_data_);
#line 1642 "rygel-object-creator.c"
}


static void rygel_object_creator_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelObjectCreatorRunData* _data_;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1650 "rygel-object-creator.c"
}


static void rygel_object_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorRunData* _data_;
#line 130 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = _user_data_;
#line 130 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_source_object_ = source_object;
#line 130 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_res_ = _res_;
#line 130 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_real_run_co (_data_);
#line 1664 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_real_run_co (RygelObjectCreatorRunData* _data_) {
#line 125 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	switch (_data_->_state_) {
#line 125 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 0:
#line 1673 "rygel-object-creator.c"
		goto _state_0;
#line 125 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 1:
#line 1677 "rygel-object-creator.c"
		goto _state_1;
#line 125 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 2:
#line 1681 "rygel-object-creator.c"
		goto _state_2;
#line 125 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 3:
#line 1685 "rygel-object-creator.c"
		goto _state_3;
#line 125 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 4:
#line 1689 "rygel-object-creator.c"
		goto _state_4;
#line 125 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 5:
#line 1693 "rygel-object-creator.c"
		goto _state_5;
		default:
#line 125 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 1698 "rygel-object-creator.c"
	}
	_state_0:
	{
#line 127 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_object_creator_parse_args (_data_->self, &_data_->_inner_error_);
#line 127 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1706 "rygel-object-creator.c"
			goto __catch1_g_error;
		}
#line 128 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_object_creator_parse_didl (_data_->self, &_data_->_inner_error_);
#line 128 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1713 "rygel-object-creator.c"
			goto __catch1_g_error;
		}
#line 130 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_state_ = 1;
#line 130 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_object_creator_fetch_container (_data_->self, rygel_object_creator_run_ready, _data_);
#line 130 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 1722 "rygel-object-creator.c"
		_state_1:
#line 130 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp0_ = NULL;
#line 130 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp0_ = rygel_object_creator_fetch_container_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 130 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->container = _data_->_tmp0_;
#line 130 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1732 "rygel-object-creator.c"
			goto __catch1_g_error;
		}
#line 139 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp2_ = NULL;
#line 139 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp2_ = _data_->container;
#line 139 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp3_ = NULL;
#line 139 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp3_ = _data_->self->priv->didl_object;
#line 139 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp4_ = NULL;
#line 139 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp4_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp3_);
#line 139 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp5_ = NULL;
#line 139 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 139 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp6_ = FALSE;
#line 139 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp6_ = rygel_writable_container_can_create (_data_->_tmp2_, _data_->_tmp5_);
#line 139 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (!_data_->_tmp6_) {
#line 140 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp7_ = NULL;
#line 140 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp7_ = _data_->self->priv->container_id;
#line 140 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp1_ = g_strcmp0 (_data_->_tmp7_, RYGEL_MEDIA_CONTAINER_ANY) != 0;
#line 1763 "rygel-object-creator.c"
		} else {
#line 139 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp1_ = FALSE;
#line 1767 "rygel-object-creator.c"
		}
#line 139 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp8_ = FALSE;
#line 139 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp8_ = _data_->_tmp1_;
#line 139 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_tmp8_) {
#line 141 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp9_ = NULL;
#line 141 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp9_ = _data_->self->priv->didl_object;
#line 141 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp10_ = NULL;
#line 141 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp10_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp9_);
#line 141 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp11_ = NULL;
#line 141 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp11_ = _data_->_tmp10_;
#line 141 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp12_ = NULL;
#line 141 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp12_ = _data_->container;
#line 141 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp13_ = NULL;
#line 141 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp13_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp12_);
#line 141 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp14_ = NULL;
#line 141 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp14_ = _data_->_tmp13_;
#line 141 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp15_ = NULL;
#line 141 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp15_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Creating of objects with class %s " "is not supported in %s", _data_->_tmp11_, _data_->_tmp14_);
#line 141 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_inner_error_ = _data_->_tmp15_;
#line 141 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_object_unref0 (_data_->container);
#line 1807 "rygel-object-creator.c"
			goto __catch1_g_error;
		}
#line 148 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp17_ = NULL;
#line 148 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp17_ = _data_->self->priv->didl_object;
#line 148 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp17_, gupnp_didl_lite_container_get_type ())) {
#line 149 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp18_ = NULL;
#line 149 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp18_ = _data_->container;
#line 149 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp19_ = FALSE;
#line 149 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp19_ = rygel_object_creator_validate_create_class (_data_->self, _data_->_tmp18_);
#line 149 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp16_ = !_data_->_tmp19_;
#line 1826 "rygel-object-creator.c"
		} else {
#line 148 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp16_ = FALSE;
#line 1830 "rygel-object-creator.c"
		}
#line 148 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp20_ = FALSE;
#line 148 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp20_ = _data_->_tmp16_;
#line 148 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_tmp20_) {
#line 150 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp21_ = NULL;
#line 150 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp21_ = _ ("upnp:createClass value not supported");
#line 150 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp22_ = NULL;
#line 150 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp22_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _data_->_tmp21_);
#line 150 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_inner_error_ = _data_->_tmp22_;
#line 150 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_object_unref0 (_data_->container);
#line 1850 "rygel-object-creator.c"
			goto __catch1_g_error;
		}
#line 154 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp23_ = NULL;
#line 154 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp23_ = _data_->container;
#line 154 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_state_ = 2;
#line 154 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_object_creator_create_object_from_didl (_data_->self, _data_->_tmp23_, rygel_object_creator_run_ready, _data_);
#line 154 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 1863 "rygel-object-creator.c"
		_state_2:
#line 154 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_object_creator_create_object_from_didl_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 154 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 154 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_object_unref0 (_data_->container);
#line 1871 "rygel-object-creator.c"
			goto __catch1_g_error;
		}
#line 155 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp24_ = NULL;
#line 155 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp24_ = _data_->self->priv->object;
#line 155 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp24_, RYGEL_TYPE_MEDIA_ITEM)) {
#line 156 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp25_ = NULL;
#line 156 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp25_ = _data_->container;
#line 156 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp26_ = NULL;
#line 156 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp26_ = _data_->self->priv->object;
#line 156 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp27_ = NULL;
#line 156 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp27_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 156 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp28_ = NULL;
#line 156 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp28_ = _data_->_tmp27_;
#line 156 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_state_ = 3;
#line 156 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			rygel_writable_container_add_item (_data_->_tmp25_, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp26_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp26_) : NULL, _data_->_tmp28_, rygel_object_creator_run_ready, _data_);
#line 156 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			return FALSE;
#line 1902 "rygel-object-creator.c"
			_state_3:
#line 156 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			rygel_writable_container_add_item_finish (_data_->_tmp25_, _data_->_res_);
#line 1906 "rygel-object-creator.c"
		} else {
#line 159 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp29_ = NULL;
#line 159 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp29_ = _data_->container;
#line 159 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp30_ = NULL;
#line 159 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp30_ = _data_->self->priv->object;
#line 159 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp31_ = NULL;
#line 159 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp31_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 159 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp32_ = NULL;
#line 159 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp32_ = _data_->_tmp31_;
#line 159 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_state_ = 4;
#line 159 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			rygel_writable_container_add_container (_data_->_tmp29_, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp30_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _data_->_tmp30_) : NULL, _data_->_tmp32_, rygel_object_creator_run_ready, _data_);
#line 159 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			return FALSE;
#line 1930 "rygel-object-creator.c"
			_state_4:
#line 159 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			rygel_writable_container_add_container_finish (_data_->_tmp29_, _data_->_res_);
#line 1934 "rygel-object-creator.c"
		}
#line 163 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp33_ = NULL;
#line 163 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp33_ = _data_->container;
#line 163 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_state_ = 5;
#line 163 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_object_creator_wait_for_object (_data_->self, _data_->_tmp33_, rygel_object_creator_run_ready, _data_);
#line 163 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 1946 "rygel-object-creator.c"
		_state_5:
#line 163 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_object_creator_wait_for_object_finish (_data_->self, _data_->_res_);
#line 165 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp34_ = NULL;
#line 165 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp34_ = _data_->self->priv->object;
#line 165 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp35_ = NULL;
#line 165 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp35_ = _data_->self->priv->serializer;
#line 165 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp36_ = NULL;
#line 165 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp36_ = _data_->self->priv->content_dir;
#line 165 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp37_ = NULL;
#line 165 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp37_ = _data_->_tmp36_->http_server;
#line 165 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_media_object_serialize (_data_->_tmp34_, _data_->_tmp35_, _data_->_tmp37_);
#line 168 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_object_creator_conclude (_data_->self);
#line 170 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp39_ = NULL;
#line 170 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp39_ = _data_->self->priv->container_id;
#line 170 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (g_strcmp0 (_data_->_tmp39_, RYGEL_MEDIA_CONTAINER_ANY) == 0) {
#line 171 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp41_ = NULL;
#line 171 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp41_ = _data_->self->priv->object;
#line 171 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp41_, RYGEL_TYPE_MEDIA_ITEM)) {
#line 171 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_data_->_tmp42_ = NULL;
#line 171 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_data_->_tmp42_ = _data_->self->priv->object;
#line 171 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_data_->_tmp43_ = FALSE;
#line 171 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_data_->_tmp43_ = (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp42_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp42_) : NULL)->place_holder;
#line 171 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_data_->_tmp40_ = _data_->_tmp43_;
#line 1992 "rygel-object-creator.c"
			} else {
#line 171 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_data_->_tmp40_ = FALSE;
#line 1996 "rygel-object-creator.c"
			}
#line 171 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp44_ = FALSE;
#line 171 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp44_ = _data_->_tmp40_;
#line 171 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp38_ = _data_->_tmp44_;
#line 2004 "rygel-object-creator.c"
		} else {
#line 170 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp38_ = FALSE;
#line 2008 "rygel-object-creator.c"
		}
#line 170 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp45_ = FALSE;
#line 170 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp45_ = _data_->_tmp38_;
#line 170 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_tmp45_) {
#line 173 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp46_ = NULL;
#line 173 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp46_ = rygel_object_removal_queue_get_default ();
#line 173 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->queue = _data_->_tmp46_;
#line 175 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp47_ = NULL;
#line 175 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp47_ = _data_->queue;
#line 175 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp48_ = NULL;
#line 175 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp48_ = _data_->self->priv->object;
#line 175 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp49_ = NULL;
#line 175 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp49_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 175 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp50_ = NULL;
#line 175 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp50_ = _data_->_tmp49_;
#line 175 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			rygel_object_removal_queue_queue (_data_->_tmp47_, _data_->_tmp48_, _data_->_tmp50_);
#line 170 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_object_unref0 (_data_->queue);
#line 2042 "rygel-object-creator.c"
		}
#line 126 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (_data_->container);
#line 2046 "rygel-object-creator.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 126 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->err = _data_->_inner_error_;
#line 126 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_inner_error_ = NULL;
#line 178 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp51_ = NULL;
#line 178 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp51_ = _data_->err;
#line 178 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_object_creator_handle_error (_data_->self, _data_->_tmp51_);
#line 126 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_error_free0 (_data_->err);
#line 2063 "rygel-object-creator.c"
	}
	__finally1:
#line 126 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_inner_error_ != NULL) {
#line 126 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 126 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_clear_error (&_data_->_inner_error_);
#line 126 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 2074 "rygel-object-creator.c"
	}
#line 125 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 125 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2080 "rygel-object-creator.c"
	} else {
#line 125 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2084 "rygel-object-creator.c"
	}
#line 125 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 125 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return FALSE;
#line 2090 "rygel-object-creator.c"
}


/**
     * Check the supplied input parameters.
     */
static void rygel_object_creator_parse_args (RygelObjectCreator* self, GError** error) {
	RygelServiceAction* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
#line 185 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_if_fail (self != NULL);
#line 187 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = self->priv->action;
#line 187 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_service_action_get (_tmp0_, "ContainerID", G_TYPE_STRING, &_tmp1_, "Elements", G_TYPE_STRING, &_tmp2_);
#line 187 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (self->priv->container_id);
#line 187 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	self->priv->container_id = _tmp1_;
#line 187 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (self->priv->elements);
#line 187 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	self->priv->elements = _tmp2_;
#line 190 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp3_ = self->priv->elements;
#line 190 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp3_ == NULL) {
#line 2122 "rygel-object-creator.c"
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
#line 191 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp4_ = _ ("'Elements' argument missing.");
#line 191 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp5_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp4_);
#line 191 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_inner_error_ = _tmp5_;
#line 191 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 191 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return;
#line 2135 "rygel-object-creator.c"
	} else {
		GPatternSpec* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 193 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp6_ = rygel_object_creator_comment_pattern;
#line 193 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp7_ = self->priv->elements;
#line 193 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp8_ = g_pattern_match_string (_tmp6_, _tmp7_);
#line 193 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_tmp8_) {
#line 2148 "rygel-object-creator.c"
			const gchar* _tmp9_ = NULL;
			GError* _tmp10_ = NULL;
#line 194 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp9_ = _ ("Comments not allowed in XML");
#line 194 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp10_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp9_);
#line 194 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_inner_error_ = _tmp10_;
#line 194 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_propagate_error (error, _inner_error_);
#line 194 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			return;
#line 2161 "rygel-object-creator.c"
		}
	}
#line 198 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp11_ = self->priv->container_id;
#line 198 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp11_ == NULL) {
#line 2168 "rygel-object-creator.c"
		const gchar* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
#line 200 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp12_ = _ ("Missing ContainerID argument");
#line 200 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp13_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _tmp12_);
#line 200 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_inner_error_ = _tmp13_;
#line 200 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 200 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return;
#line 2181 "rygel-object-creator.c"
	}
}


/**
     * Parse the given DIDL-Lite snippet.
     *
     * Parses the DIDL-Lite and performs checking of the passed meta-data
     * according to UPnP and DLNA guidelines.
     */
static void __lambda4_ (RygelObjectCreator* self, GUPnPDIDLLiteObject* didl_object) {
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteObject* _tmp1_ = NULL;
#line 214 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_if_fail (didl_object != NULL);
#line 215 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = didl_object;
#line 215 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 215 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->didl_object);
#line 215 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	self->priv->didl_object = _tmp1_;
#line 2205 "rygel-object-creator.c"
}


static void ___lambda4__gupnp_didl_lite_parser_object_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteObject* object, gpointer self) {
#line 214 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	__lambda4_ (self, object);
#line 2212 "rygel-object-creator.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 265 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 2219 "rygel-object-creator.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 265 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 265 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_list_free (self);
#line 2228 "rygel-object-creator.c"
}


static void rygel_object_creator_parse_didl (RygelObjectCreator* self, GError** error) {
	GUPnPDIDLLiteParser* _tmp0_ = NULL;
	GUPnPDIDLLiteObject* _tmp4_ = NULL;
	gboolean _tmp10_ = FALSE;
	GUPnPDIDLLiteObject* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gboolean _tmp17_ = FALSE;
	GUPnPDIDLLiteObject* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	gboolean _tmp29_ = FALSE;
	GUPnPDIDLLiteObject* _tmp30_ = NULL;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	GUPnPDIDLLiteObject* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp52_ = FALSE;
	GUPnPDIDLLiteObject* _tmp55_ = NULL;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp57_ = FALSE;
	GUPnPDIDLLiteObject* _tmp60_ = NULL;
	const gchar* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	GError * _inner_error_ = NULL;
#line 211 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_if_fail (self != NULL);
#line 214 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = self->priv->didl_parser;
#line 214 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_signal_connect_object (_tmp0_, "object-available", (GCallback) ___lambda4__gupnp_didl_lite_parser_object_available, self, 0);
#line 2266 "rygel-object-creator.c"
	{
		GUPnPDIDLLiteParser* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 219 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp1_ = self->priv->didl_parser;
#line 219 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp2_ = self->priv->elements;
#line 219 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		gupnp_didl_lite_parser_parse_didl (_tmp1_, _tmp2_, &_inner_error_);
#line 219 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_inner_error_ != NULL) {
#line 2278 "rygel-object-creator.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* parse_err = NULL;
		GError* _tmp3_ = NULL;
#line 218 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		parse_err = _inner_error_;
#line 218 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_inner_error_ = NULL;
#line 221 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Bad metadata");
#line 221 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_inner_error_ = _tmp3_;
#line 221 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_error_free0 (parse_err);
#line 2297 "rygel-object-creator.c"
		goto __finally2;
	}
	__finally2:
#line 218 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_inner_error_ != NULL) {
#line 218 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 218 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return;
#line 2307 "rygel-object-creator.c"
	}
#line 224 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp4_ = self->priv->didl_object;
#line 224 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp4_ == NULL) {
#line 2313 "rygel-object-creator.c"
		gchar* message = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
#line 225 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp5_ = _ ("No objects in DIDL-Lite from client: '%s'");
#line 225 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 225 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		message = _tmp6_;
#line 227 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp7_ = message;
#line 227 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp8_ = self->priv->elements;
#line 227 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp9_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp7_, _tmp8_);
#line 227 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_inner_error_ = _tmp9_;
#line 227 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 227 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_free0 (message);
#line 227 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return;
#line 2340 "rygel-object-creator.c"
	}
#line 231 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp11_ = self->priv->didl_object;
#line 231 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp12_ = gupnp_didl_lite_object_get_id (_tmp11_);
#line 231 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp13_ = _tmp12_;
#line 231 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp13_ == NULL) {
#line 231 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp10_ = TRUE;
#line 2352 "rygel-object-creator.c"
	} else {
		GUPnPDIDLLiteObject* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 231 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp14_ = self->priv->didl_object;
#line 231 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp15_ = gupnp_didl_lite_object_get_id (_tmp14_);
#line 231 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp16_ = _tmp15_;
#line 231 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp10_ = g_strcmp0 (_tmp16_, "") != 0;
#line 2365 "rygel-object-creator.c"
	}
#line 231 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp17_ = _tmp10_;
#line 231 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp17_) {
#line 2371 "rygel-object-creator.c"
		gchar* msg = NULL;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		GError* _tmp21_ = NULL;
#line 232 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp18_ = _ ("@id must be set to \"\" in CreateObject call");
#line 232 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp19_ = g_strdup (_tmp18_);
#line 232 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		msg = _tmp19_;
#line 233 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp20_ = msg;
#line 233 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp21_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp20_);
#line 233 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_inner_error_ = _tmp21_;
#line 233 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 233 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_free0 (msg);
#line 233 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return;
#line 2395 "rygel-object-creator.c"
	}
#line 236 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp22_ = self->priv->didl_object;
#line 236 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp23_ = gupnp_didl_lite_object_get_title (_tmp22_);
#line 236 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp24_ = _tmp23_;
#line 236 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp24_ == NULL) {
#line 2405 "rygel-object-creator.c"
		gchar* msg = NULL;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		GError* _tmp28_ = NULL;
#line 237 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp25_ = _ ("dc:title must not be empty in CreateObject call");
#line 237 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp26_ = g_strdup (_tmp25_);
#line 237 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		msg = _tmp26_;
#line 238 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp27_ = msg;
#line 238 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp28_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp27_);
#line 238 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_inner_error_ = _tmp28_;
#line 238 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 238 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_free0 (msg);
#line 238 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return;
#line 2429 "rygel-object-creator.c"
	}
#line 243 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp30_ = self->priv->didl_object;
#line 243 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, gupnp_didl_lite_item_get_type ())) {
#line 2435 "rygel-object-creator.c"
		GUPnPDIDLLiteObject* _tmp31_ = NULL;
		GUPnPOCMFlags _tmp32_ = 0;
		GUPnPOCMFlags _tmp33_ = 0;
#line 244 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp31_ = self->priv->didl_object;
#line 244 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp32_ = gupnp_didl_lite_object_get_dlna_managed (_tmp31_);
#line 244 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp33_ = _tmp32_;
#line 244 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp29_ = (_tmp33_ & ((GUPNP_OCM_FLAGS_UPLOAD | GUPNP_OCM_FLAGS_CREATE_CONTAINER) | GUPNP_OCM_FLAGS_UPLOAD_DESTROYABLE)) != 0;
#line 2447 "rygel-object-creator.c"
	} else {
#line 243 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp29_ = FALSE;
#line 2451 "rygel-object-creator.c"
	}
#line 243 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp34_ = _tmp29_;
#line 243 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp34_) {
#line 2457 "rygel-object-creator.c"
		gchar* msg = NULL;
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		GError* _tmp38_ = NULL;
#line 248 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp35_ = _ ("Flags that must not be set were found in 'dlnaManaged'");
#line 248 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp36_ = g_strdup (_tmp35_);
#line 248 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		msg = _tmp36_;
#line 249 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp37_ = msg;
#line 249 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp38_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp37_);
#line 249 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_inner_error_ = _tmp38_;
#line 249 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 249 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_free0 (msg);
#line 249 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return;
#line 2481 "rygel-object-creator.c"
	}
#line 252 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp41_ = self->priv->didl_object;
#line 252 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp42_ = gupnp_didl_lite_object_get_upnp_class (_tmp41_);
#line 252 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp43_ = _tmp42_;
#line 252 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp43_ == NULL) {
#line 252 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp40_ = TRUE;
#line 2493 "rygel-object-creator.c"
	} else {
		GUPnPDIDLLiteObject* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
#line 253 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp44_ = self->priv->didl_object;
#line 253 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp45_ = gupnp_didl_lite_object_get_upnp_class (_tmp44_);
#line 253 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp46_ = _tmp45_;
#line 253 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp40_ = g_strcmp0 (_tmp46_, "") == 0;
#line 2506 "rygel-object-creator.c"
	}
#line 252 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp47_ = _tmp40_;
#line 252 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp47_) {
#line 252 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp39_ = TRUE;
#line 2514 "rygel-object-creator.c"
	} else {
		GUPnPDIDLLiteObject* _tmp48_ = NULL;
		const gchar* _tmp49_ = NULL;
		const gchar* _tmp50_ = NULL;
		gboolean _tmp51_ = FALSE;
#line 254 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp48_ = self->priv->didl_object;
#line 254 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp49_ = gupnp_didl_lite_object_get_upnp_class (_tmp48_);
#line 254 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp50_ = _tmp49_;
#line 254 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp51_ = g_str_has_prefix (_tmp50_, "object");
#line 254 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp39_ = !_tmp51_;
#line 2530 "rygel-object-creator.c"
	}
#line 252 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp52_ = _tmp39_;
#line 252 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp52_) {
#line 2536 "rygel-object-creator.c"
		const gchar* _tmp53_ = NULL;
		GError* _tmp54_ = NULL;
#line 255 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp53_ = _ ("Invalid upnp:class given in CreateObject");
#line 255 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp54_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp53_);
#line 255 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_inner_error_ = _tmp54_;
#line 255 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 255 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return;
#line 2549 "rygel-object-creator.c"
	}
#line 259 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp55_ = self->priv->didl_object;
#line 259 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp56_ = gupnp_didl_lite_object_get_restricted (_tmp55_);
#line 259 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp57_ = _tmp56_;
#line 259 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp57_) {
#line 2559 "rygel-object-creator.c"
		const gchar* _tmp58_ = NULL;
		GError* _tmp59_ = NULL;
#line 260 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp58_ = _ ("Cannot create restricted item");
#line 260 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp59_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp58_);
#line 260 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_inner_error_ = _tmp59_;
#line 260 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 260 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return;
#line 2572 "rygel-object-creator.c"
	}
#line 265 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp60_ = self->priv->didl_object;
#line 265 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp61_ = gupnp_didl_lite_object_get_upnp_class (_tmp60_);
#line 265 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp62_ = _tmp61_;
#line 265 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (g_strcmp0 (_tmp62_, "object.item") == 0) {
#line 2582 "rygel-object-creator.c"
		GList* resources = NULL;
		GUPnPDIDLLiteObject* _tmp63_ = NULL;
		GList* _tmp64_ = NULL;
		gboolean _tmp65_ = FALSE;
		GList* _tmp66_ = NULL;
		gboolean _tmp73_ = FALSE;
#line 266 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp63_ = self->priv->didl_object;
#line 266 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp64_ = gupnp_didl_lite_object_get_resources (_tmp63_);
#line 266 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		resources = _tmp64_;
#line 267 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp66_ = resources;
#line 267 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_tmp66_ != NULL) {
#line 2599 "rygel-object-creator.c"
			GList* _tmp67_ = NULL;
			gconstpointer _tmp68_ = NULL;
			GUPnPProtocolInfo* _tmp69_ = NULL;
			GUPnPProtocolInfo* _tmp70_ = NULL;
			const gchar* _tmp71_ = NULL;
			const gchar* _tmp72_ = NULL;
#line 268 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp67_ = resources;
#line 268 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp68_ = _tmp67_->data;
#line 268 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp69_ = gupnp_didl_lite_resource_get_protocol_info ((GUPnPDIDLLiteResource*) _tmp68_);
#line 268 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp70_ = _tmp69_;
#line 268 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp71_ = gupnp_protocol_info_get_dlna_profile (_tmp70_);
#line 268 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp72_ = _tmp71_;
#line 268 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp65_ = g_strcmp0 (_tmp72_, "DIDL_S") == 0;
#line 2620 "rygel-object-creator.c"
		} else {
#line 267 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp65_ = FALSE;
#line 2624 "rygel-object-creator.c"
		}
#line 267 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp73_ = _tmp65_;
#line 267 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_tmp73_) {
#line 2630 "rygel-object-creator.c"
			GUPnPDIDLLiteObject* _tmp74_ = NULL;
#line 269 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp74_ = self->priv->didl_object;
#line 269 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			gupnp_didl_lite_object_set_upnp_class (_tmp74_, RYGEL_PLAYLIST_ITEM_UPNP_CLASS);
#line 2636 "rygel-object-creator.c"
		}
#line 265 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		__g_list_free__g_object_unref0_0 (resources);
#line 2640 "rygel-object-creator.c"
	}
}


/**
     * Modify the give UPnP class to be a more general one.
     *
     * Used to simplify the search for a valid container in the
     * DLNA.ORG_AnyContainer use-case.
     * Example: object.item.videoItem.videoBroadcast → object.item.videoItem
     *
     * @param upnp_class the current UPnP class which will be modified in-place.
     */
static void rygel_object_creator_generalize_upnp_class (RygelObjectCreator* self, gchar** upnp_class) {
	gchar* needle = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 283 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_if_fail (self != NULL);
#line 283 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_if_fail (*upnp_class != NULL);
#line 284 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = *upnp_class;
#line 284 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = g_strrstr_len (_tmp0_, (gssize) (-1), ".");
#line 284 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	needle = _tmp1_;
#line 285 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp2_ = needle;
#line 285 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp2_ != NULL) {
#line 2673 "rygel-object-creator.c"
		gchar* _tmp3_ = NULL;
		gchar _tmp4_ = '\0';
#line 286 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp3_ = needle;
#line 286 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		*_tmp3_ = '\0';
#line 286 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp4_ = *_tmp3_;
#line 2682 "rygel-object-creator.c"
	}
}


static void rygel_object_creator_build_create_class_expression_data_free (gpointer _data) {
	RygelObjectCreatorBuildCreateClassExpressionData* _data_;
	_data_ = _data;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_rygel_search_expression_unref0 (_data_->result);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_slice_free (RygelObjectCreatorBuildCreateClassExpressionData, _data_);
#line 2698 "rygel-object-creator.c"
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 2705 "rygel-object-creator.c"
}


static void rygel_object_creator_build_create_class_expression (RygelObjectCreator* self, RygelSearchExpression* expression, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorBuildCreateClassExpressionData* _data_;
	RygelObjectCreator* _tmp0_ = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	RygelSearchExpression* _tmp2_ = NULL;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = g_slice_new0 (RygelObjectCreatorBuildCreateClassExpressionData);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_build_create_class_expression);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_build_create_class_expression_data_free);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->self = _tmp0_;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = expression;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->expression = _tmp2_;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_build_create_class_expression_co (_data_);
#line 2734 "rygel-object-creator.c"
}


static RygelSearchExpression* rygel_object_creator_build_create_class_expression_finish (RygelObjectCreator* self, GAsyncResult* _res_) {
	RygelSearchExpression* result;
	RygelObjectCreatorBuildCreateClassExpressionData* _data_;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	result = _data_->result;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->result = NULL;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return result;
#line 2749 "rygel-object-creator.c"
}


static void _g_free0_ (gpointer var) {
#line 300 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	var = (g_free (var), NULL);
#line 2756 "rygel-object-creator.c"
}


static void _g_list_free__g_free0_ (GList* self) {
#line 300 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
#line 300 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_list_free (self);
#line 2765 "rygel-object-creator.c"
}


static void rygel_object_creator_build_create_class_expression_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorBuildCreateClassExpressionData* _data_;
#line 315 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = _user_data_;
#line 315 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_source_object_ = source_object;
#line 315 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_res_ = _res_;
#line 315 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_build_create_class_expression_co (_data_);
#line 2779 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_build_create_class_expression_co (RygelObjectCreatorBuildCreateClassExpressionData* _data_) {
#line 290 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	switch (_data_->_state_) {
#line 290 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 0:
#line 2788 "rygel-object-creator.c"
		goto _state_0;
#line 290 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 1:
#line 2792 "rygel-object-creator.c"
		goto _state_1;
		default:
#line 290 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 2797 "rygel-object-creator.c"
	}
	_state_0:
#line 293 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp0_ = NULL;
#line 293 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp0_ = _data_->self->priv->didl_object;
#line 293 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp0_, gupnp_didl_lite_container_get_type ())) {
#line 294 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp1_ = NULL;
#line 294 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp1_ = _data_->expression;
#line 294 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp2_ = NULL;
#line 294 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp2_ = _rygel_search_expression_ref0 (_data_->_tmp1_);
#line 294 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->result = _data_->_tmp2_;
#line 294 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 294 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2820 "rygel-object-creator.c"
		} else {
#line 294 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2824 "rygel-object-creator.c"
		}
#line 294 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 294 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 2830 "rygel-object-creator.c"
	}
#line 297 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp3_ = NULL;
#line 297 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp3_ = _data_->self->priv->didl_object;
#line 297 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp4_ = NULL;
#line 297 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp3_, gupnp_didl_lite_container_get_type ()) ? ((GUPnPDIDLLiteContainer*) _data_->_tmp3_) : NULL);
#line 297 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->didl_container = _data_->_tmp4_;
#line 298 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp5_ = NULL;
#line 298 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp5_ = _data_->didl_container;
#line 298 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp6_ = NULL;
#line 298 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp6_ = gupnp_didl_lite_container_get_create_classes (_data_->_tmp5_);
#line 298 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->create_classes = _data_->_tmp6_;
#line 299 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp7_ = NULL;
#line 299 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp7_ = _data_->create_classes;
#line 299 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_tmp7_ == NULL) {
#line 300 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp8_ = NULL;
#line 300 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp8_ = _data_->expression;
#line 300 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp9_ = NULL;
#line 300 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp9_ = _rygel_search_expression_ref0 (_data_->_tmp8_);
#line 300 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->result = _data_->_tmp9_;
#line 300 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		__g_list_free__g_free0_0 (_data_->create_classes);
#line 300 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (_data_->didl_container);
#line 300 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 300 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2876 "rygel-object-creator.c"
		} else {
#line 300 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2880 "rygel-object-creator.c"
		}
#line 300 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 300 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 2886 "rygel-object-creator.c"
	}
#line 303 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp10_ = NULL;
#line 303 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp10_ = g_string_new ("(");
#line 303 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->builder = _data_->_tmp10_;
#line 304 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp11_ = NULL;
#line 304 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp11_ = _data_->create_classes;
#line 2898 "rygel-object-creator.c"
	{
#line 304 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->create_class_collection = _data_->_tmp11_;
#line 304 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		for (_data_->create_class_it = _data_->create_class_collection; _data_->create_class_it != NULL; _data_->create_class_it = _data_->create_class_it->next) {
#line 304 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp12_ = NULL;
#line 304 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp12_ = g_strdup ((const gchar*) _data_->create_class_it->data);
#line 304 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->create_class = _data_->_tmp12_;
#line 2910 "rygel-object-creator.c"
			{
#line 305 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_data_->_tmp13_ = NULL;
#line 305 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_data_->_tmp13_ = _data_->builder;
#line 305 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_data_->_tmp14_ = NULL;
#line 305 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_data_->_tmp14_ = _data_->create_class;
#line 305 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				g_string_append_printf (_data_->_tmp13_, "(upnp:createClass derivedfrom \"%s\") AND", _data_->_tmp14_);
#line 304 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_g_free0 (_data_->create_class);
#line 2924 "rygel-object-creator.c"
			}
		}
	}
#line 310 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp15_ = NULL;
#line 310 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp15_ = _data_->builder;
#line 310 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp16_ = NULL;
#line 310 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp16_ = _data_->builder;
#line 310 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp17_ = 0L;
#line 310 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp17_ = _data_->_tmp16_->len;
#line 310 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_string_truncate (_data_->_tmp15_, (gsize) (_data_->_tmp17_ - 3));
#line 311 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp18_ = NULL;
#line 311 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp18_ = _data_->builder;
#line 311 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_string_append (_data_->_tmp18_, ")");
#line 2948 "rygel-object-creator.c"
	{
#line 314 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp19_ = NULL;
#line 314 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp19_ = _data_->builder;
#line 314 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp20_ = NULL;
#line 314 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp20_ = _data_->_tmp19_->str;
#line 314 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp21_ = NULL;
#line 314 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp21_ = rygel_search_criteria_parser_new (_data_->_tmp20_, &_data_->_inner_error_);
#line 314 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->parser = _data_->_tmp21_;
#line 314 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 2966 "rygel-object-creator.c"
			goto __catch3_g_error;
		}
#line 315 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp22_ = NULL;
#line 315 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp22_ = _data_->parser;
#line 315 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_state_ = 1;
#line 315 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_state_machine_run ((RygelStateMachine*) _data_->_tmp22_, rygel_object_creator_build_create_class_expression_ready, _data_);
#line 315 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 2979 "rygel-object-creator.c"
		_state_1:
#line 315 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_state_machine_run_finish ((RygelStateMachine*) _data_->_tmp22_, _data_->_res_);
#line 317 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp23_ = NULL;
#line 317 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp23_ = rygel_logical_expression_new ();
#line 317 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->rel = _data_->_tmp23_;
#line 318 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp24_ = NULL;
#line 318 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp24_ = _data_->rel;
#line 318 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp25_ = NULL;
#line 318 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp25_ = _data_->expression;
#line 318 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp26_ = NULL;
#line 318 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp26_ = _rygel_search_expression_ref0 (_data_->_tmp25_);
#line 318 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _data_->_tmp24_)->operand1);
#line 318 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		((RygelSearchExpression*) _data_->_tmp24_)->operand1 = _data_->_tmp26_;
#line 319 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp27_ = NULL;
#line 319 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp27_ = _data_->rel;
#line 319 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		((RygelSearchExpression*) _data_->_tmp27_)->op = (gpointer) ((gintptr) RYGEL_LOGICAL_OPERATOR_AND);
#line 320 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp28_ = NULL;
#line 320 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp28_ = _data_->rel;
#line 320 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp29_ = NULL;
#line 320 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp29_ = _data_->parser;
#line 320 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp30_ = NULL;
#line 320 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp30_ = _data_->_tmp29_->expression;
#line 320 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp31_ = NULL;
#line 320 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp31_ = _rygel_search_expression_ref0 (_data_->_tmp30_);
#line 320 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _data_->_tmp28_)->operand2);
#line 320 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		((RygelSearchExpression*) _data_->_tmp28_)->operand2 = _data_->_tmp31_;
#line 322 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->result = (RygelSearchExpression*) _data_->rel;
#line 322 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (_data_->parser);
#line 322 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_string_free0 (_data_->builder);
#line 322 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		__g_list_free__g_free0_0 (_data_->create_classes);
#line 322 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (_data_->didl_container);
#line 322 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 322 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3045 "rygel-object-creator.c"
		} else {
#line 322 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3049 "rygel-object-creator.c"
		}
#line 322 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 322 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 3055 "rygel-object-creator.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
#line 313 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 313 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_inner_error_ = NULL;
#line 324 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 313 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_error_free0 (_data_->_error_);
#line 3068 "rygel-object-creator.c"
	}
	__finally3:
#line 313 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_string_free0 (_data_->builder);
#line 313 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	__g_list_free__g_free0_0 (_data_->create_classes);
#line 313 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->didl_container);
#line 313 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 313 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_clear_error (&_data_->_inner_error_);
#line 313 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return FALSE;
#line 290 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_string_free0 (_data_->builder);
#line 290 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	__g_list_free__g_free0_0 (_data_->create_classes);
#line 290 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->didl_container);
#line 290 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 290 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3093 "rygel-object-creator.c"
	} else {
#line 290 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3097 "rygel-object-creator.c"
	}
#line 290 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 290 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return FALSE;
#line 3103 "rygel-object-creator.c"
}


static void rygel_object_creator_find_any_container_data_free (gpointer _data) {
	RygelObjectCreatorFindAnyContainerData* _data_;
	_data_ = _data;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->result);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_slice_free (RygelObjectCreatorFindAnyContainerData, _data_);
#line 3116 "rygel-object-creator.c"
}


static void rygel_object_creator_find_any_container (RygelObjectCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorFindAnyContainerData* _data_;
	RygelObjectCreator* _tmp0_ = NULL;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = g_slice_new0 (RygelObjectCreatorFindAnyContainerData);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_find_any_container);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_find_any_container_data_free);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->self = _tmp0_;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_find_any_container_co (_data_);
#line 3135 "rygel-object-creator.c"
}


static RygelMediaObject* rygel_object_creator_find_any_container_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelObjectCreatorFindAnyContainerData* _data_;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return NULL;
#line 3146 "rygel-object-creator.c"
	}
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	result = _data_->result;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->result = NULL;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return result;
#line 3156 "rygel-object-creator.c"
}


/**
     * Find a container that can create items matching the UPnP class of the
     * requested item.
     *
     * If the item's UPnP class cannot be found, generalize the UPnP class until
     * we reach object.item according to DLNA guideline 7.3.120.4.
     *
     * @returns a container able to create the item or null if no such container
     *          can be found.
     */
static void rygel_object_creator_find_any_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorFindAnyContainerData* _data_;
#line 354 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = _user_data_;
#line 354 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_source_object_ = source_object;
#line 354 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_res_ = _res_;
#line 354 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_find_any_container_co (_data_);
#line 3180 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_find_any_container_co (RygelObjectCreatorFindAnyContainerData* _data_) {
#line 338 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	switch (_data_->_state_) {
#line 338 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 0:
#line 3189 "rygel-object-creator.c"
		goto _state_0;
#line 338 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 1:
#line 3193 "rygel-object-creator.c"
		goto _state_1;
#line 338 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 2:
#line 3197 "rygel-object-creator.c"
		goto _state_2;
		default:
#line 338 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 3202 "rygel-object-creator.c"
	}
	_state_0:
#line 339 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp0_ = NULL;
#line 339 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp0_ = _data_->self->priv->content_dir;
#line 339 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp1_ = NULL;
#line 339 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp1_ = _data_->_tmp0_->root_container;
#line 339 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp2_ = NULL;
#line 339 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) _data_->_tmp1_) : NULL);
#line 339 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->root_container = _data_->_tmp2_;
#line 342 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp3_ = NULL;
#line 342 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp3_ = _data_->root_container;
#line 342 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_tmp3_ == NULL) {
#line 343 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->result = NULL;
#line 343 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (_data_->root_container);
#line 343 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 343 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3233 "rygel-object-creator.c"
		} else {
#line 343 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3237 "rygel-object-creator.c"
		}
#line 343 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 343 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 3243 "rygel-object-creator.c"
	}
#line 346 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp4_ = NULL;
#line 346 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp4_ = _data_->self->priv->didl_object;
#line 346 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp5_ = NULL;
#line 346 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp5_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp4_);
#line 346 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp6_ = NULL;
#line 346 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 346 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp7_ = NULL;
#line 346 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
#line 346 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->upnp_class = _data_->_tmp7_;
#line 348 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp8_ = NULL;
#line 348 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp8_ = rygel_relational_expression_new ();
#line 348 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->expression = _data_->_tmp8_;
#line 349 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp9_ = NULL;
#line 349 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp9_ = _data_->expression;
#line 349 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	((RygelSearchExpression*) _data_->_tmp9_)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM);
#line 350 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp10_ = NULL;
#line 350 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp10_ = _data_->expression;
#line 350 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp11_ = NULL;
#line 350 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp11_ = g_strdup ("upnp:createClass");
#line 350 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (((RygelSearchExpression*) _data_->_tmp10_)->operand1);
#line 350 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	((RygelSearchExpression*) _data_->_tmp10_)->operand1 = _data_->_tmp11_;
#line 354 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp12_ = NULL;
#line 354 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp12_ = _data_->expression;
#line 354 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_state_ = 1;
#line 354 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_build_create_class_expression (_data_->self, (RygelSearchExpression*) _data_->_tmp12_, rygel_object_creator_find_any_container_ready, _data_);
#line 354 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return FALSE;
#line 3297 "rygel-object-creator.c"
	_state_1:
#line 354 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp13_ = NULL;
#line 354 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp13_ = rygel_object_creator_build_create_class_expression_finish (_data_->self, _data_->_res_);
#line 354 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->search_expression = _data_->_tmp13_;
#line 357 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	while (TRUE) {
#line 357 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp14_ = NULL;
#line 357 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp14_ = _data_->upnp_class;
#line 357 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (!(g_strcmp0 (_data_->_tmp14_, "object") != 0)) {
#line 357 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			break;
#line 3315 "rygel-object-creator.c"
		}
#line 358 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp15_ = NULL;
#line 358 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp15_ = _data_->expression;
#line 358 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp16_ = NULL;
#line 358 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp16_ = _data_->upnp_class;
#line 358 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp17_ = NULL;
#line 358 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp17_ = g_strdup (_data_->_tmp16_);
#line 358 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_free0 (((RygelSearchExpression*) _data_->_tmp15_)->operand2);
#line 358 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		((RygelSearchExpression*) _data_->_tmp15_)->operand2 = _data_->_tmp17_;
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp18_ = NULL;
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp18_ = _data_->root_container;
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp19_ = NULL;
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp19_ = _data_->search_expression;
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp20_ = NULL;
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp20_ = _data_->root_container;
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp21_ = NULL;
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp21_ = ((RygelMediaContainer*) _data_->_tmp20_)->sort_criteria;
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp22_ = NULL;
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp22_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp23_ = NULL;
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp23_ = _data_->_tmp22_;
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp24_ = 0;
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_state_ = 2;
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_searchable_container_search (_data_->_tmp18_, _data_->_tmp19_, 0, 1, _data_->_tmp21_, _data_->_tmp23_, rygel_object_creator_find_any_container_ready, _data_);
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 3365 "rygel-object-creator.c"
		_state_2:
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp25_ = NULL;
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp25_ = rygel_searchable_container_search_finish (_data_->_tmp18_, _data_->_res_, &_data_->_tmp24_);
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->total_matches = (guint) _data_->_tmp24_;
#line 361 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_result_ = _data_->_tmp25_;
#line 367 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp26_ = NULL;
#line 367 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp26_ = _data_->_result_;
#line 367 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp27_ = 0;
#line 367 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp27_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp26_);
#line 367 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp28_ = 0;
#line 367 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp28_ = _data_->_tmp27_;
#line 367 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_tmp28_ > 0) {
#line 368 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp29_ = NULL;
#line 368 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp29_ = _data_->self->priv->didl_object;
#line 368 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp30_ = NULL;
#line 368 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp30_ = _data_->upnp_class;
#line 368 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			gupnp_didl_lite_object_set_upnp_class (_data_->_tmp29_, _data_->_tmp30_);
#line 370 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp31_ = NULL;
#line 370 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp31_ = _data_->_result_;
#line 370 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp32_ = NULL;
#line 370 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp31_, 0);
#line 370 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->result = (RygelMediaObject*) _data_->_tmp32_;
#line 370 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_object_unref0 (_data_->_result_);
#line 370 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_rygel_search_expression_unref0 (_data_->search_expression);
#line 370 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_rygel_search_expression_unref0 (_data_->expression);
#line 370 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_free0 (_data_->upnp_class);
#line 370 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_object_unref0 (_data_->root_container);
#line 370 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			if (_data_->_state_ == 0) {
#line 370 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3423 "rygel-object-creator.c"
			} else {
#line 370 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3427 "rygel-object-creator.c"
			}
#line 370 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_object_unref (_data_->_async_result);
#line 370 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			return FALSE;
#line 3433 "rygel-object-creator.c"
		} else {
#line 372 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			rygel_object_creator_generalize_upnp_class (_data_->self, &_data_->upnp_class);
#line 3437 "rygel-object-creator.c"
		}
#line 357 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (_data_->_result_);
#line 3441 "rygel-object-creator.c"
	}
#line 376 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp33_ = NULL;
#line 376 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp33_ = _data_->upnp_class;
#line 376 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (g_strcmp0 (_data_->_tmp33_, "object") == 0) {
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp34_ = NULL;
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp34_ = _ ("UPnP class '%s' not supported");
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp35_ = NULL;
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp35_ = _data_->self->priv->didl_object;
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp36_ = NULL;
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp36_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp35_);
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp37_ = NULL;
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp37_ = _data_->_tmp36_;
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp38_ = NULL;
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp38_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _data_->_tmp34_, _data_->_tmp37_);
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_inner_error_ = _data_->_tmp38_;
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_rygel_search_expression_unref0 (_data_->search_expression);
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_free0 (_data_->upnp_class);
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (_data_->root_container);
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3487 "rygel-object-creator.c"
		} else {
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3491 "rygel-object-creator.c"
		}
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 377 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 3497 "rygel-object-creator.c"
	}
#line 382 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->result = NULL;
#line 382 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_rygel_search_expression_unref0 (_data_->search_expression);
#line 382 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 382 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (_data_->upnp_class);
#line 382 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->root_container);
#line 382 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 382 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3513 "rygel-object-creator.c"
	} else {
#line 382 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3517 "rygel-object-creator.c"
	}
#line 382 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 382 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return FALSE;
#line 338 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_rygel_search_expression_unref0 (_data_->search_expression);
#line 338 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 338 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (_data_->upnp_class);
#line 338 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->root_container);
#line 338 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 338 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3535 "rygel-object-creator.c"
	} else {
#line 338 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3539 "rygel-object-creator.c"
	}
#line 338 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 338 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return FALSE;
#line 3545 "rygel-object-creator.c"
}


static void rygel_object_creator_fetch_container_data_free (gpointer _data) {
	RygelObjectCreatorFetchContainerData* _data_;
	_data_ = _data;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->result);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_slice_free (RygelObjectCreatorFetchContainerData, _data_);
#line 3558 "rygel-object-creator.c"
}


static void rygel_object_creator_fetch_container (RygelObjectCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorFetchContainerData* _data_;
	RygelObjectCreator* _tmp0_ = NULL;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = g_slice_new0 (RygelObjectCreatorFetchContainerData);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_fetch_container);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_fetch_container_data_free);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->self = _tmp0_;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_fetch_container_co (_data_);
#line 3577 "rygel-object-creator.c"
}


static RygelWritableContainer* rygel_object_creator_fetch_container_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error) {
	RygelWritableContainer* result;
	RygelObjectCreatorFetchContainerData* _data_;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return NULL;
#line 3588 "rygel-object-creator.c"
	}
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	result = _data_->result;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->result = NULL;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return result;
#line 3598 "rygel-object-creator.c"
}


/**
     * Get the container to create the item in.
     *
     * This will either try to fetch the container supplied by the caller or
     * search for a container if the caller supplied the "DLNA.ORG_AnyContainer"
     * id.
     *
     * @return an instance of WritableContainer matching the criteria
     * @throws ContentDirectoryError for various problems
     */
static void rygel_object_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorFetchContainerData* _data_;
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = _user_data_;
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_source_object_ = source_object;
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_res_ = _res_;
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_fetch_container_co (_data_);
#line 3622 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_fetch_container_co (RygelObjectCreatorFetchContainerData* _data_) {
#line 395 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	switch (_data_->_state_) {
#line 395 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 0:
#line 3631 "rygel-object-creator.c"
		goto _state_0;
#line 395 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 1:
#line 3635 "rygel-object-creator.c"
		goto _state_1;
#line 395 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 2:
#line 3639 "rygel-object-creator.c"
		goto _state_2;
		default:
#line 395 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 3644 "rygel-object-creator.c"
	}
	_state_0:
#line 396 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->media_object = NULL;
#line 398 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp0_ = NULL;
#line 398 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp0_ = _data_->self->priv->container_id;
#line 398 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (g_strcmp0 (_data_->_tmp0_, RYGEL_MEDIA_CONTAINER_ANY) == 0) {
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_state_ = 1;
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_object_creator_find_any_container (_data_->self, rygel_object_creator_fetch_container_ready, _data_);
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 3661 "rygel-object-creator.c"
		_state_1:
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp2_ = NULL;
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp2_ = rygel_object_creator_find_any_container_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp1_ = _data_->_tmp2_;
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_object_unref0 (_data_->media_object);
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			if (_data_->_state_ == 0) {
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3681 "rygel-object-creator.c"
			} else {
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3685 "rygel-object-creator.c"
			}
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_object_unref (_data_->_async_result);
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			return FALSE;
#line 3691 "rygel-object-creator.c"
		}
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (_data_->media_object);
#line 399 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->media_object = _data_->_tmp1_;
#line 3697 "rygel-object-creator.c"
	} else {
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp4_ = NULL;
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp4_ = _data_->self->priv->content_dir;
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp5_ = NULL;
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp5_ = _data_->_tmp4_->root_container;
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp6_ = NULL;
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp6_ = _data_->self->priv->container_id;
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp7_ = NULL;
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp7_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp8_ = NULL;
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp8_ = _data_->_tmp7_;
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_state_ = 2;
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_media_object_find_object ((RygelMediaObject*) _data_->_tmp5_, _data_->_tmp6_, _data_->_tmp8_, rygel_object_creator_fetch_container_ready, _data_);
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 3725 "rygel-object-creator.c"
		_state_2:
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp9_ = NULL;
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp9_ = rygel_media_object_find_object_finish ((RygelMediaObject*) _data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp3_ = _data_->_tmp9_;
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_object_unref0 (_data_->media_object);
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			if (_data_->_state_ == 0) {
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3745 "rygel-object-creator.c"
			} else {
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3749 "rygel-object-creator.c"
			}
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_object_unref (_data_->_async_result);
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			return FALSE;
#line 3755 "rygel-object-creator.c"
		}
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (_data_->media_object);
#line 401 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->media_object = _data_->_tmp3_;
#line 3761 "rygel-object-creator.c"
	}
#line 405 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp11_ = NULL;
#line 405 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp11_ = _data_->media_object;
#line 405 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_tmp11_ == NULL) {
#line 405 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp10_ = TRUE;
#line 3771 "rygel-object-creator.c"
	} else {
#line 405 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp12_ = NULL;
#line 405 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp12_ = _data_->media_object;
#line 405 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp10_ = !G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp12_, RYGEL_TYPE_MEDIA_CONTAINER);
#line 3779 "rygel-object-creator.c"
	}
#line 405 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp13_ = FALSE;
#line 405 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp13_ = _data_->_tmp10_;
#line 405 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_tmp13_) {
#line 406 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp14_ = NULL;
#line 406 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp14_ = _ ("No such container");
#line 406 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp15_ = NULL;
#line 406 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp15_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER, _data_->_tmp14_);
#line 406 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_inner_error_ = _data_->_tmp15_;
#line 406 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 406 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 406 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (_data_->media_object);
#line 406 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 406 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3807 "rygel-object-creator.c"
		} else {
#line 406 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3811 "rygel-object-creator.c"
		}
#line 406 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 406 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 3817 "rygel-object-creator.c"
	}
#line 410 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp16_ = NULL;
#line 410 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp16_ = _data_->media_object;
#line 410 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp16_, RYGEL_TYPE_WRITABLE_CONTAINER)) {
#line 411 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp17_ = NULL;
#line 411 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp17_ = _ (" %%% Object creation in %s not allowed");
#line 411 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp18_ = NULL;
#line 411 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp18_ = _data_->media_object;
#line 411 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp19_ = NULL;
#line 411 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp19_ = rygel_media_object_get_id (_data_->_tmp18_);
#line 411 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp20_ = NULL;
#line 411 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp20_ = _data_->_tmp19_;
#line 411 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp21_ = NULL;
#line 411 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp21_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp17_, _data_->_tmp20_);
#line 411 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_inner_error_ = _data_->_tmp21_;
#line 411 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 411 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 411 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (_data_->media_object);
#line 411 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 411 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3857 "rygel-object-creator.c"
		} else {
#line 411 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3861 "rygel-object-creator.c"
		}
#line 411 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 411 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 3867 "rygel-object-creator.c"
	}
#line 419 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp24_ = NULL;
#line 419 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp24_ = _data_->self->priv->didl_object;
#line 419 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp24_, gupnp_didl_lite_item_get_type ())) {
#line 420 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp25_ = NULL;
#line 420 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp25_ = _data_->media_object;
#line 420 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp26_ = 0;
#line 420 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp26_ = _data_->_tmp25_->ocm_flags;
#line 420 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp23_ = (_data_->_tmp26_ & GUPNP_OCM_FLAGS_UPLOAD) == GUPNP_OCM_FLAGS_UPLOAD;
#line 3885 "rygel-object-creator.c"
	} else {
#line 419 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp23_ = FALSE;
#line 3889 "rygel-object-creator.c"
	}
#line 419 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp27_ = FALSE;
#line 419 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp27_ = _data_->_tmp23_;
#line 419 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_tmp27_) {
#line 419 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp22_ = TRUE;
#line 3899 "rygel-object-creator.c"
	} else {
#line 421 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp29_ = NULL;
#line 421 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp29_ = _data_->self->priv->didl_object;
#line 421 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp29_, gupnp_didl_lite_container_get_type ())) {
#line 422 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp30_ = NULL;
#line 422 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp30_ = _data_->media_object;
#line 422 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp31_ = 0;
#line 422 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp31_ = _data_->_tmp30_->ocm_flags;
#line 422 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp28_ = (_data_->_tmp31_ & GUPNP_OCM_FLAGS_CREATE_CONTAINER) == GUPNP_OCM_FLAGS_CREATE_CONTAINER;
#line 3917 "rygel-object-creator.c"
		} else {
#line 421 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp28_ = FALSE;
#line 3921 "rygel-object-creator.c"
		}
#line 421 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp32_ = FALSE;
#line 421 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp32_ = _data_->_tmp28_;
#line 421 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp22_ = _data_->_tmp32_;
#line 3929 "rygel-object-creator.c"
	}
#line 419 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp33_ = FALSE;
#line 419 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp33_ = _data_->_tmp22_;
#line 419 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (!_data_->_tmp33_) {
#line 423 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp34_ = NULL;
#line 423 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp34_ = _ ("Object creation in %s not allowed");
#line 423 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp35_ = NULL;
#line 423 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp35_ = _data_->media_object;
#line 423 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp36_ = NULL;
#line 423 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp36_ = rygel_media_object_get_id (_data_->_tmp35_);
#line 423 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp37_ = NULL;
#line 423 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp37_ = _data_->_tmp36_;
#line 423 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp38_ = NULL;
#line 423 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp38_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp34_, _data_->_tmp37_);
#line 423 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_inner_error_ = _data_->_tmp38_;
#line 423 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 423 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 423 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (_data_->media_object);
#line 423 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 423 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3969 "rygel-object-creator.c"
		} else {
#line 423 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3973 "rygel-object-creator.c"
		}
#line 423 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 423 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 3979 "rygel-object-creator.c"
	}
#line 430 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp39_ = NULL;
#line 430 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp39_ = _data_->media_object;
#line 430 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp40_ = NULL;
#line 430 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp39_, RYGEL_TYPE_WRITABLE_CONTAINER) ? ((RygelWritableContainer*) _data_->_tmp39_) : NULL);
#line 430 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->result = _data_->_tmp40_;
#line 430 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->media_object);
#line 430 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 430 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3997 "rygel-object-creator.c"
	} else {
#line 430 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4001 "rygel-object-creator.c"
	}
#line 430 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 430 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return FALSE;
#line 395 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->media_object);
#line 395 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 395 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4013 "rygel-object-creator.c"
	} else {
#line 395 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4017 "rygel-object-creator.c"
	}
#line 395 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 395 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return FALSE;
#line 4023 "rygel-object-creator.c"
}


static void rygel_object_creator_conclude (RygelObjectCreator* self) {
	gchar* didl = NULL;
	RygelSerializer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	RygelServiceAction* _tmp2_ = NULL;
	RygelMediaObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	RygelServiceAction* _tmp6_ = NULL;
#line 433 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_if_fail (self != NULL);
#line 435 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = self->priv->serializer;
#line 435 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = rygel_serializer_get_string (_tmp0_);
#line 435 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	didl = _tmp1_;
#line 438 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp2_ = self->priv->action;
#line 438 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp3_ = self->priv->object;
#line 438 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp4_ = rygel_media_object_get_id (_tmp3_);
#line 438 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp5_ = _tmp4_;
#line 438 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_service_action_set (_tmp2_, "ObjectID", G_TYPE_STRING, _tmp5_, "Result", G_TYPE_STRING, didl);
#line 441 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp6_ = self->priv->action;
#line 441 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_service_action_return (_tmp6_);
#line 442 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 433 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (didl);
#line 4062 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_validate_create_class (RygelObjectCreator* self, RygelWritableContainer* container) {
	gboolean result = FALSE;
	GUPnPDIDLLiteContainer* didl_cont = NULL;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteContainer* _tmp1_ = NULL;
	GList* create_classes = NULL;
	GUPnPDIDLLiteContainer* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
#line 445 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 445 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_val_if_fail (container != NULL, FALSE);
#line 446 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = self->priv->didl_object;
#line 446 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gupnp_didl_lite_container_get_type ()) ? ((GUPnPDIDLLiteContainer*) _tmp0_) : NULL);
#line 446 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	didl_cont = _tmp1_;
#line 447 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp2_ = didl_cont;
#line 447 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp3_ = gupnp_didl_lite_container_get_create_classes (_tmp2_);
#line 447 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	create_classes = _tmp3_;
#line 449 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp4_ = create_classes;
#line 449 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp4_ == NULL) {
#line 450 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		result = TRUE;
#line 450 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		__g_list_free__g_free0_0 (create_classes);
#line 450 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (didl_cont);
#line 450 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return result;
#line 4104 "rygel-object-creator.c"
	}
#line 453 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp5_ = create_classes;
#line 4108 "rygel-object-creator.c"
	{
		GList* create_class_collection = NULL;
		GList* create_class_it = NULL;
#line 453 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		create_class_collection = _tmp5_;
#line 453 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		for (create_class_it = create_class_collection; create_class_it != NULL; create_class_it = create_class_it->next) {
#line 4116 "rygel-object-creator.c"
			gchar* _tmp6_ = NULL;
			gchar* create_class = NULL;
#line 453 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp6_ = g_strdup ((const gchar*) create_class_it->data);
#line 453 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			create_class = _tmp6_;
#line 4123 "rygel-object-creator.c"
			{
				RygelWritableContainer* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
#line 454 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp7_ = container;
#line 454 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp8_ = create_class;
#line 454 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp9_ = rygel_writable_container_can_create (_tmp7_, _tmp8_);
#line 454 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				if (!_tmp9_) {
#line 455 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					result = FALSE;
#line 455 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					_g_free0 (create_class);
#line 455 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					__g_list_free__g_free0_0 (create_classes);
#line 455 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					_g_object_unref0 (didl_cont);
#line 455 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					return result;
#line 4146 "rygel-object-creator.c"
				}
#line 453 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_g_free0 (create_class);
#line 4150 "rygel-object-creator.c"
			}
		}
	}
#line 459 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	result = TRUE;
#line 459 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	__g_list_free__g_free0_0 (create_classes);
#line 459 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (didl_cont);
#line 459 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return result;
#line 4162 "rygel-object-creator.c"
}


static void rygel_object_creator_handle_error (RygelObjectCreator* self, GError* _error_) {
	GError* _tmp0_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GError* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
#line 462 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_if_fail (self != NULL);
#line 463 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = _error_;
#line 463 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp0_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
#line 4178 "rygel-object-creator.c"
		RygelServiceAction* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 464 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp1_ = self->priv->action;
#line 464 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp2_ = _error_;
#line 464 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp3_ = _tmp2_->code;
#line 464 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp4_ = _error_;
#line 464 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp5_ = _tmp4_->message;
#line 464 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_service_action_return_error (_tmp1_, _tmp3_, _tmp5_);
#line 4196 "rygel-object-creator.c"
	} else {
		RygelServiceAction* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 466 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp6_ = self->priv->action;
#line 466 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp7_ = _error_;
#line 466 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp8_ = _tmp7_->message;
#line 466 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_service_action_return_error (_tmp6_, 701, _tmp8_);
#line 4209 "rygel-object-creator.c"
	}
#line 469 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp9_ = _ ("Failed to create item under '%s': %s");
#line 469 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp10_ = self->priv->container_id;
#line 469 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp11_ = _error_;
#line 469 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp12_ = _tmp11_->message;
#line 469 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_warning (_tmp9_, _tmp10_, _tmp12_);
#line 473 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 4223 "rygel-object-creator.c"
}


static gchar* rygel_object_creator_get_generic_mime_type (RygelObjectCreator* self) {
	gchar* result = NULL;
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaItem* item = NULL;
	RygelMediaObject* _tmp2_ = NULL;
	RygelMediaItem* _tmp3_ = NULL;
	RygelMediaItem* _tmp4_ = NULL;
#line 476 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 477 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = self->priv->object;
#line 477 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_ITEM)) {
#line 4240 "rygel-object-creator.c"
		gchar* _tmp1_ = NULL;
#line 478 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp1_ = g_strdup ("");
#line 478 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		result = _tmp1_;
#line 478 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return result;
#line 4248 "rygel-object-creator.c"
	}
#line 481 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp2_ = self->priv->object;
#line 481 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp2_) : NULL);
#line 481 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	item = _tmp3_;
#line 483 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp4_ = item;
#line 483 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_IMAGE_ITEM)) {
#line 4260 "rygel-object-creator.c"
		gchar* _tmp5_ = NULL;
#line 484 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp5_ = g_strdup ("image");
#line 484 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		result = _tmp5_;
#line 484 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (item);
#line 484 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return result;
#line 4270 "rygel-object-creator.c"
	} else {
		RygelMediaItem* _tmp6_ = NULL;
#line 485 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp6_ = item;
#line 485 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, RYGEL_TYPE_VIDEO_ITEM)) {
#line 4277 "rygel-object-creator.c"
			gchar* _tmp7_ = NULL;
#line 486 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp7_ = g_strdup ("video");
#line 486 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			result = _tmp7_;
#line 486 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_object_unref0 (item);
#line 486 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			return result;
#line 4287 "rygel-object-creator.c"
		} else {
			gchar* _tmp8_ = NULL;
#line 488 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp8_ = g_strdup ("audio");
#line 488 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			result = _tmp8_;
#line 488 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_object_unref0 (item);
#line 488 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			return result;
#line 4298 "rygel-object-creator.c"
		}
	}
#line 476 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (item);
#line 4303 "rygel-object-creator.c"
}


static void rygel_object_creator_create_object_from_didl_data_free (gpointer _data) {
	RygelObjectCreatorCreateObjectFromDidlData* _data_;
	_data_ = _data;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->container);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_slice_free (RygelObjectCreatorCreateObjectFromDidlData, _data_);
#line 4316 "rygel-object-creator.c"
}


static void rygel_object_creator_create_object_from_didl (RygelObjectCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorCreateObjectFromDidlData* _data_;
	RygelObjectCreator* _tmp0_ = NULL;
	RygelWritableContainer* _tmp1_ = NULL;
	RygelWritableContainer* _tmp2_ = NULL;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = g_slice_new0 (RygelObjectCreatorCreateObjectFromDidlData);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_create_object_from_didl);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_create_object_from_didl_data_free);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->self = _tmp0_;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = container;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->container);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->container = _tmp2_;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_create_object_from_didl_co (_data_);
#line 4345 "rygel-object-creator.c"
}


static void rygel_object_creator_create_object_from_didl_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error) {
	RygelObjectCreatorCreateObjectFromDidlData* _data_;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return;
#line 4355 "rygel-object-creator.c"
	}
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 4359 "rygel-object-creator.c"
}


/**
     * Transfer information passed by caller to a MediaObject.
     *
     * WritableContainer works on MediaObject so we transfer the supplied data
     * to one. Additionally some checks are performed (e.g. whether the DLNA
     * profile is supported or not) or sanitize the supplied title for use as
     * part of the on-disk filename.
     *
     * This function fills ObjectCreator.object.
     */
static void rygel_object_creator_create_object_from_didl_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorCreateObjectFromDidlData* _data_;
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = _user_data_;
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_source_object_ = source_object;
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_res_ = _res_;
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_create_object_from_didl_co (_data_);
#line 4383 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_create_object_from_didl_co (RygelObjectCreatorCreateObjectFromDidlData* _data_) {
#line 502 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	switch (_data_->_state_) {
#line 502 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 0:
#line 4392 "rygel-object-creator.c"
		goto _state_0;
#line 502 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 1:
#line 4396 "rygel-object-creator.c"
		goto _state_1;
		default:
#line 502 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 4401 "rygel-object-creator.c"
	}
	_state_0:
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp1_ = NULL;
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp1_ = _data_->self->priv->didl_object;
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp2_ = NULL;
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp2_ = gupnp_didl_lite_object_get_id (_data_->_tmp1_);
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp3_ = NULL;
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp4_ = NULL;
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp4_ = _data_->container;
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp5_ = NULL;
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp5_ = _data_->self->priv->didl_object;
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp6_ = NULL;
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp6_ = gupnp_didl_lite_object_get_title (_data_->_tmp5_);
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp7_ = NULL;
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp7_ = _data_->_tmp6_;
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp8_ = NULL;
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp8_ = _data_->self->priv->didl_object;
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp9_ = NULL;
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp9_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp8_);
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp10_ = NULL;
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp10_ = _data_->_tmp9_;
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp11_ = NULL;
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp11_ = rygel_object_creator_create_object (_data_->self, _data_->_tmp3_, _data_->_tmp4_, _data_->_tmp7_, _data_->_tmp10_, &_data_->_inner_error_);
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp0_ = _data_->_tmp11_;
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_inner_error_ != NULL) {
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4460 "rygel-object-creator.c"
		} else {
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 4464 "rygel-object-creator.c"
		}
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 4470 "rygel-object-creator.c"
	}
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self->priv->object);
#line 504 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->self->priv->object = _data_->_tmp0_;
#line 509 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp12_ = NULL;
#line 509 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp12_ = _data_->self->priv->object;
#line 509 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp12_, RYGEL_TYPE_MEDIA_ITEM)) {
#line 510 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_object_creator_extract_item_parameters (_data_->self, &_data_->_inner_error_);
#line 510 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 510 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 510 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 510 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			if (_data_->_state_ == 0) {
#line 510 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4494 "rygel-object-creator.c"
			} else {
#line 510 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 4498 "rygel-object-creator.c"
			}
#line 510 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_object_unref (_data_->_async_result);
#line 510 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			return FALSE;
#line 4504 "rygel-object-creator.c"
		}
	}
#line 514 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp13_ = NULL;
#line 514 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp13_ = _data_->self->priv->object;
#line 514 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp14_ = NULL;
#line 514 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp14_ = _data_->_tmp13_->uris;
#line 514 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp15_ = 0;
#line 514 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp15_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp14_);
#line 514 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp16_ = 0;
#line 514 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp16_ = _data_->_tmp15_;
#line 514 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_tmp16_ == 0) {
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp17_ = NULL;
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp17_ = _data_->container;
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp18_ = NULL;
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp18_ = _data_->self->priv->object;
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp19_ = NULL;
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp19_ = rygel_media_object_get_title (_data_->_tmp18_);
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp20_ = NULL;
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp20_ = _data_->_tmp19_;
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_state_ = 1;
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_object_creator_create_uri (_data_->self, _data_->_tmp17_, _data_->_tmp20_, rygel_object_creator_create_object_from_didl_ready, _data_);
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 4547 "rygel-object-creator.c"
		_state_1:
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp21_ = NULL;
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp21_ = rygel_object_creator_create_uri_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->uri = _data_->_tmp21_;
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			if (_data_->_state_ == 0) {
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4565 "rygel-object-creator.c"
			} else {
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 4569 "rygel-object-creator.c"
			}
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_object_unref (_data_->_async_result);
#line 515 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			return FALSE;
#line 4575 "rygel-object-creator.c"
		}
#line 516 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp22_ = NULL;
#line 516 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp22_ = _data_->self->priv->object;
#line 516 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp23_ = NULL;
#line 516 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp23_ = _data_->_tmp22_->uris;
#line 516 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp24_ = NULL;
#line 516 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp24_ = _data_->uri;
#line 516 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp23_, _data_->_tmp24_);
#line 517 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp25_ = NULL;
#line 517 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp25_ = _data_->self->priv->object;
#line 517 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp25_, RYGEL_TYPE_MEDIA_ITEM)) {
#line 518 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp26_ = NULL;
#line 518 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp26_ = _data_->self->priv->object;
#line 518 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			(G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp26_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp26_) : NULL)->place_holder = TRUE;
#line 4603 "rygel-object-creator.c"
		}
#line 514 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_free0 (_data_->uri);
#line 4607 "rygel-object-creator.c"
	} else {
#line 521 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp27_ = NULL;
#line 521 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp27_ = _data_->self->priv->object;
#line 521 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp27_, RYGEL_TYPE_MEDIA_ITEM)) {
#line 522 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp28_ = NULL;
#line 522 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp28_ = _data_->self->priv->object;
#line 522 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp29_ = NULL;
#line 522 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp29_ = _data_->_tmp28_->uris;
#line 522 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp30_ = NULL;
#line 522 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp29_, 0);
#line 522 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp31_ = NULL;
#line 522 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp31_ = (gchar*) _data_->_tmp30_;
#line 522 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp32_ = NULL;
#line 522 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp32_ = g_file_new_for_uri (_data_->_tmp31_);
#line 522 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp33_ = NULL;
#line 522 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp33_ = _data_->_tmp32_;
#line 522 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_free0 (_data_->_tmp31_);
#line 522 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->file = _data_->_tmp33_;
#line 523 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp34_ = NULL;
#line 523 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp34_ = _data_->self->priv->object;
#line 523 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp35_ = NULL;
#line 523 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp35_ = _data_->file;
#line 523 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp36_ = FALSE;
#line 523 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp36_ = g_file_is_native (_data_->_tmp35_);
#line 523 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			(G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp34_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp34_) : NULL)->place_holder = !_data_->_tmp36_;
#line 521 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_object_unref0 (_data_->file);
#line 4659 "rygel-object-creator.c"
		}
	}
#line 527 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp37_ = NULL;
#line 527 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp37_ = _data_->self->priv->object;
#line 527 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp38_ = NULL;
#line 527 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp38_ = _data_->self->priv->object;
#line 527 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp39_ = NULL;
#line 527 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp39_ = _data_->_tmp38_->uris;
#line 527 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp40_ = NULL;
#line 527 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp39_, 0);
#line 527 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp41_ = NULL;
#line 527 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp41_ = (gchar*) _data_->_tmp40_;
#line 527 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_media_object_set_id (_data_->_tmp37_, _data_->_tmp41_);
#line 527 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (_data_->_tmp41_);
#line 529 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_parse_and_verify_didl_date (_data_->self, &_data_->_inner_error_);
#line 529 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_inner_error_ != NULL) {
#line 529 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 529 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 529 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 529 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4698 "rygel-object-creator.c"
		} else {
#line 529 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 4702 "rygel-object-creator.c"
		}
#line 529 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 529 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 4708 "rygel-object-creator.c"
	}
#line 502 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 502 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4714 "rygel-object-creator.c"
	} else {
#line 502 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4718 "rygel-object-creator.c"
	}
#line 502 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 502 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return FALSE;
#line 4724 "rygel-object-creator.c"
}


static void rygel_object_creator_extract_item_parameters (RygelObjectCreator* self, GError** error) {
	RygelMediaItem* item = NULL;
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaItem* _tmp1_ = NULL;
	GList* resources = NULL;
	GUPnPDIDLLiteObject* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GList* _tmp5_ = NULL;
	gboolean _tmp8_ = FALSE;
	RygelMediaItem* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	RygelMediaItem* _tmp63_ = NULL;
	glong _tmp64_ = 0L;
	GError * _inner_error_ = NULL;
#line 532 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_if_fail (self != NULL);
#line 533 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = self->priv->object;
#line 533 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp0_) : NULL);
#line 533 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	item = _tmp1_;
#line 535 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp2_ = self->priv->didl_object;
#line 535 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp3_ = gupnp_didl_lite_object_get_resources (_tmp2_);
#line 535 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	resources = _tmp3_;
#line 536 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp5_ = resources;
#line 536 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp5_ != NULL) {
#line 4761 "rygel-object-creator.c"
		GList* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
#line 536 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp6_ = resources;
#line 536 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp7_ = g_list_length (_tmp6_);
#line 536 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp4_ = _tmp7_ > ((guint) 0);
#line 4770 "rygel-object-creator.c"
	} else {
#line 536 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp4_ = FALSE;
#line 4774 "rygel-object-creator.c"
	}
#line 536 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp8_ = _tmp4_;
#line 536 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp8_) {
#line 4780 "rygel-object-creator.c"
		GUPnPDIDLLiteResource* resource = NULL;
		GList* _tmp9_ = NULL;
		GList* _tmp10_ = NULL;
		gconstpointer _tmp11_ = NULL;
		GUPnPDIDLLiteResource* _tmp12_ = NULL;
		GUPnPProtocolInfo* info = NULL;
		GUPnPDIDLLiteResource* _tmp13_ = NULL;
		GUPnPProtocolInfo* _tmp14_ = NULL;
		GUPnPProtocolInfo* _tmp15_ = NULL;
		GUPnPProtocolInfo* _tmp16_ = NULL;
		GUPnPProtocolInfo* _tmp17_ = NULL;
		gchar* sanitized_uri = NULL;
		GUPnPDIDLLiteResource* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		gboolean _tmp49_ = FALSE;
		GUPnPDIDLLiteResource* _tmp52_ = NULL;
		glong _tmp53_ = 0L;
		glong _tmp54_ = 0L;
#line 537 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp9_ = resources;
#line 537 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp10_ = g_list_nth (_tmp9_, (guint) 0);
#line 537 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp11_ = _tmp10_->data;
#line 537 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp12_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) _tmp11_);
#line 537 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		resource = _tmp12_;
#line 538 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp13_ = resource;
#line 538 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp14_ = gupnp_didl_lite_resource_get_protocol_info (_tmp13_);
#line 538 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp15_ = _tmp14_;
#line 538 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp16_ = _g_object_ref0 (_tmp15_);
#line 538 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		info = _tmp16_;
#line 540 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp17_ = info;
#line 540 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_tmp17_ != NULL) {
#line 4825 "rygel-object-creator.c"
			GUPnPProtocolInfo* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			GUPnPProtocolInfo* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			const gchar* _tmp39_ = NULL;
#line 541 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp18_ = info;
#line 541 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp19_ = gupnp_protocol_info_get_dlna_profile (_tmp18_);
#line 541 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp20_ = _tmp19_;
#line 541 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			if (_tmp20_ != NULL) {
#line 4840 "rygel-object-creator.c"
				GUPnPProtocolInfo* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				gboolean _tmp24_ = FALSE;
				RygelMediaItem* _tmp32_ = NULL;
				GUPnPProtocolInfo* _tmp33_ = NULL;
				const gchar* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				gchar* _tmp36_ = NULL;
#line 542 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp21_ = info;
#line 542 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp22_ = gupnp_protocol_info_get_dlna_profile (_tmp21_);
#line 542 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp23_ = _tmp22_;
#line 542 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp24_ = rygel_object_creator_is_profile_valid (self, _tmp23_);
#line 542 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				if (!_tmp24_) {
#line 4860 "rygel-object-creator.c"
					gchar* msg = NULL;
					const gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					const gchar* _tmp27_ = NULL;
					GUPnPProtocolInfo* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					GError* _tmp31_ = NULL;
#line 543 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					_tmp25_ = _ ("DLNA profile '%s' not supported");
#line 543 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					_tmp26_ = g_strdup (_tmp25_);
#line 543 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					msg = _tmp26_;
#line 544 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					_tmp27_ = msg;
#line 544 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					_tmp28_ = info;
#line 544 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					_tmp29_ = gupnp_protocol_info_get_dlna_profile (_tmp28_);
#line 544 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					_tmp30_ = _tmp29_;
#line 544 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					_tmp31_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp27_, _tmp30_);
#line 544 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					_inner_error_ = _tmp31_;
#line 544 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					g_propagate_error (error, _inner_error_);
#line 544 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					_g_free0 (msg);
#line 544 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					_g_object_unref0 (info);
#line 544 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					_g_object_unref0 (resource);
#line 544 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					__g_list_free__g_object_unref0_0 (resources);
#line 544 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					_g_object_unref0 (item);
#line 544 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
					return;
#line 4901 "rygel-object-creator.c"
				}
#line 549 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp32_ = item;
#line 549 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp33_ = info;
#line 549 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp34_ = gupnp_protocol_info_get_dlna_profile (_tmp33_);
#line 549 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp35_ = _tmp34_;
#line 549 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp36_ = g_strdup (_tmp35_);
#line 549 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_g_free0 (_tmp32_->dlna_profile);
#line 549 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp32_->dlna_profile = _tmp36_;
#line 4917 "rygel-object-creator.c"
			}
#line 552 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp37_ = info;
#line 552 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp38_ = gupnp_protocol_info_get_mime_type (_tmp37_);
#line 552 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp39_ = _tmp38_;
#line 552 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			if (_tmp39_ != NULL) {
#line 4927 "rygel-object-creator.c"
				RygelMediaItem* _tmp40_ = NULL;
				GUPnPProtocolInfo* _tmp41_ = NULL;
				const gchar* _tmp42_ = NULL;
				const gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
#line 553 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp40_ = item;
#line 553 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp41_ = info;
#line 553 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp42_ = gupnp_protocol_info_get_mime_type (_tmp41_);
#line 553 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp43_ = _tmp42_;
#line 553 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp44_ = g_strdup (_tmp43_);
#line 553 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_g_free0 (_tmp40_->mime_type);
#line 553 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp40_->mime_type = _tmp44_;
#line 4947 "rygel-object-creator.c"
			}
		}
#line 557 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		sanitized_uri = NULL;
#line 558 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp45_ = resource;
#line 558 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp46_ = gupnp_didl_lite_resource_get_uri (_tmp45_);
#line 558 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp47_ = _tmp46_;
#line 558 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp49_ = rygel_object_creator_is_valid_uri (self, _tmp47_, &_tmp48_);
#line 558 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_free0 (sanitized_uri);
#line 558 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		sanitized_uri = _tmp48_;
#line 558 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_tmp49_) {
#line 4966 "rygel-object-creator.c"
			RygelMediaItem* _tmp50_ = NULL;
			const gchar* _tmp51_ = NULL;
#line 559 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp50_ = item;
#line 559 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp51_ = sanitized_uri;
#line 559 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			rygel_media_object_add_uri ((RygelMediaObject*) _tmp50_, _tmp51_);
#line 4975 "rygel-object-creator.c"
		}
#line 562 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp52_ = resource;
#line 562 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp53_ = gupnp_didl_lite_resource_get_size (_tmp52_);
#line 562 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp54_ = _tmp53_;
#line 562 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_tmp54_ >= ((glong) 0)) {
#line 4985 "rygel-object-creator.c"
			RygelMediaItem* _tmp55_ = NULL;
			GUPnPDIDLLiteResource* _tmp56_ = NULL;
			glong _tmp57_ = 0L;
			glong _tmp58_ = 0L;
#line 563 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp55_ = item;
#line 563 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp56_ = resource;
#line 563 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp57_ = gupnp_didl_lite_resource_get_size (_tmp56_);
#line 563 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp58_ = _tmp57_;
#line 563 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_tmp55_->size = _tmp58_;
#line 5000 "rygel-object-creator.c"
		}
#line 536 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_free0 (sanitized_uri);
#line 536 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (info);
#line 536 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (resource);
#line 5008 "rygel-object-creator.c"
	}
#line 567 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp59_ = item;
#line 567 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp60_ = _tmp59_->mime_type;
#line 567 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp60_ == NULL) {
#line 5016 "rygel-object-creator.c"
		RygelMediaItem* _tmp61_ = NULL;
		gchar* _tmp62_ = NULL;
#line 568 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp61_ = item;
#line 568 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp62_ = rygel_object_creator_get_generic_mime_type (self);
#line 568 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_free0 (_tmp61_->mime_type);
#line 568 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp61_->mime_type = _tmp62_;
#line 5027 "rygel-object-creator.c"
	}
#line 571 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp63_ = item;
#line 571 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp64_ = _tmp63_->size;
#line 571 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp64_ < ((glong) 0)) {
#line 5035 "rygel-object-creator.c"
		RygelMediaItem* _tmp65_ = NULL;
#line 572 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp65_ = item;
#line 572 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp65_->size = (glong) 0;
#line 5041 "rygel-object-creator.c"
	}
#line 532 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	__g_list_free__g_object_unref0_0 (resources);
#line 532 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (item);
#line 5047 "rygel-object-creator.c"
}


static void _vala_SoupDate_free (SoupDate* self) {
#line 591 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_boxed_free (soup_date_get_type (), self);
#line 5054 "rygel-object-creator.c"
}


static void rygel_object_creator_parse_and_verify_didl_date (RygelObjectCreator* self, GError** error) {
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteItem* didl_item = NULL;
	GUPnPDIDLLiteObject* _tmp1_ = NULL;
	GUPnPDIDLLiteItem* _tmp2_ = NULL;
	GUPnPDIDLLiteItem* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	SoupDate* parsed_date = NULL;
	GUPnPDIDLLiteItem* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	SoupDate* _tmp9_ = NULL;
	SoupDate* _tmp10_ = NULL;
	gint year = 0;
	gint month = 0;
	gint day = 0;
	GUPnPDIDLLiteItem* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	GDate date = {0};
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gboolean _tmp26_ = FALSE;
	RygelMediaObject* _tmp32_ = NULL;
	GUPnPDIDLLiteItem* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	GError * _inner_error_ = NULL;
#line 576 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_if_fail (self != NULL);
#line 577 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = self->priv->didl_object;
#line 577 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gupnp_didl_lite_item_get_type ())) {
#line 578 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return;
#line 5098 "rygel-object-creator.c"
	}
#line 581 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = self->priv->didl_object;
#line 581 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gupnp_didl_lite_item_get_type ()) ? ((GUPnPDIDLLiteItem*) _tmp1_) : NULL);
#line 581 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	didl_item = _tmp2_;
#line 582 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp3_ = didl_item;
#line 582 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp4_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp3_);
#line 582 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp5_ = _tmp4_;
#line 582 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp5_ == NULL) {
#line 583 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (didl_item);
#line 583 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return;
#line 5118 "rygel-object-creator.c"
	}
#line 586 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp6_ = didl_item;
#line 586 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp7_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp6_);
#line 586 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp8_ = _tmp7_;
#line 586 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp9_ = soup_date_new_from_string (_tmp8_);
#line 586 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	parsed_date = _tmp9_;
#line 587 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp10_ = parsed_date;
#line 587 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp10_ != NULL) {
#line 5134 "rygel-object-creator.c"
		RygelMediaObject* _tmp11_ = NULL;
		SoupDate* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 588 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp11_ = self->priv->object;
#line 588 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp12_ = parsed_date;
#line 588 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp13_ = soup_date_to_string (_tmp12_, SOUP_DATE_ISO8601);
#line 588 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_free0 ((G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp11_) : NULL)->date);
#line 588 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		(G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp11_) : NULL)->date = _tmp13_;
#line 591 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		__vala_SoupDate_free0 (parsed_date);
#line 591 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (didl_item);
#line 591 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return;
#line 5154 "rygel-object-creator.c"
	}
#line 594 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	year = 0;
#line 594 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	month = 0;
#line 594 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	day = 0;
#line 596 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp14_ = didl_item;
#line 596 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp15_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp14_);
#line 596 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp16_ = _tmp15_;
#line 596 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp17_ = sscanf (_tmp16_, "%4d-%02d-%02d", &year, &month, &day);
#line 596 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp17_ != 3) {
#line 5172 "rygel-object-creator.c"
		const gchar* _tmp18_ = NULL;
		GUPnPDIDLLiteItem* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		GError* _tmp22_ = NULL;
#line 600 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp18_ = _ ("Invalid date format: %s");
#line 600 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp19_ = didl_item;
#line 600 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp20_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp19_);
#line 600 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp21_ = _tmp20_;
#line 600 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp22_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp18_, _tmp21_);
#line 600 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_inner_error_ = _tmp22_;
#line 600 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 600 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		__vala_SoupDate_free0 (parsed_date);
#line 600 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (didl_item);
#line 600 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return;
#line 5198 "rygel-object-creator.c"
	}
#line 605 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	memset (&date, 0, sizeof (GDate));
#line 606 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp23_ = day;
#line 606 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp24_ = month;
#line 606 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp25_ = year;
#line 606 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_date_set_dmy (&date, (GDateDay) _tmp23_, (gint) ((GDateMonth) _tmp24_), (GDateYear) _tmp25_);
#line 608 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp26_ = g_date_valid (&date);
#line 608 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (!_tmp26_) {
#line 5214 "rygel-object-creator.c"
		const gchar* _tmp27_ = NULL;
		GUPnPDIDLLiteItem* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		GError* _tmp31_ = NULL;
#line 609 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp27_ = _ ("Invalid date: %s");
#line 609 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp28_ = didl_item;
#line 609 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp29_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp28_);
#line 609 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp30_ = _tmp29_;
#line 609 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp31_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp27_, _tmp30_);
#line 609 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_inner_error_ = _tmp31_;
#line 609 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 609 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		__vala_SoupDate_free0 (parsed_date);
#line 609 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (didl_item);
#line 609 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return;
#line 5240 "rygel-object-creator.c"
	}
#line 614 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp32_ = self->priv->object;
#line 614 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp33_ = didl_item;
#line 614 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp34_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp33_);
#line 614 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp35_ = _tmp34_;
#line 614 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp36_ = g_strconcat (_tmp35_, "T00:00:00", NULL);
#line 614 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 ((G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp32_) : NULL)->date);
#line 614 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	(G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp32_) : NULL)->date = _tmp36_;
#line 576 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	__vala_SoupDate_free0 (parsed_date);
#line 576 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (didl_item);
#line 5260 "rygel-object-creator.c"
}


static RygelMediaObject* rygel_object_creator_create_object (RygelObjectCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error) {
	RygelMediaObject* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	GError * _inner_error_ = NULL;
#line 617 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 617 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 617 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 617 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 617 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 622 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = upnp_class;
#line 622 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = _tmp0_;
#line 622 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 622 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp3_ == g_quark_from_string (RYGEL_IMAGE_ITEM_UPNP_CLASS)) {
#line 622 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		switch (0) {
#line 5290 "rygel-object-creator.c"
			default:
			{
				const gchar* _tmp4_ = NULL;
				RygelWritableContainer* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				RygelImageItem* _tmp7_ = NULL;
#line 624 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp4_ = id;
#line 624 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp5_ = parent;
#line 624 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp6_ = title;
#line 624 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp7_ = rygel_image_item_new (_tmp4_, (RygelMediaContainer*) _tmp5_, _tmp6_);
#line 624 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				result = (RygelMediaObject*) _tmp7_;
#line 624 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				return result;
#line 5309 "rygel-object-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_PHOTO_ITEM_UPNP_CLASS)) {
#line 622 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		switch (0) {
#line 5315 "rygel-object-creator.c"
			default:
			{
				const gchar* _tmp8_ = NULL;
				RygelWritableContainer* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				RygelPhotoItem* _tmp11_ = NULL;
#line 626 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp8_ = id;
#line 626 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp9_ = parent;
#line 626 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp10_ = title;
#line 626 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp11_ = rygel_photo_item_new (_tmp8_, (RygelMediaContainer*) _tmp9_, _tmp10_);
#line 626 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				result = (RygelMediaObject*) _tmp11_;
#line 626 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				return result;
#line 5334 "rygel-object-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_VIDEO_ITEM_UPNP_CLASS)) {
#line 622 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		switch (0) {
#line 5340 "rygel-object-creator.c"
			default:
			{
				const gchar* _tmp12_ = NULL;
				RygelWritableContainer* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				RygelVideoItem* _tmp15_ = NULL;
#line 628 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp12_ = id;
#line 628 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp13_ = parent;
#line 628 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp14_ = title;
#line 628 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp15_ = rygel_video_item_new (_tmp12_, (RygelMediaContainer*) _tmp13_, _tmp14_);
#line 628 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				result = (RygelMediaObject*) _tmp15_;
#line 628 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				return result;
#line 5359 "rygel-object-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_AUDIO_ITEM_UPNP_CLASS)) {
#line 622 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		switch (0) {
#line 5365 "rygel-object-creator.c"
			default:
			{
				const gchar* _tmp16_ = NULL;
				RygelWritableContainer* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				RygelAudioItem* _tmp19_ = NULL;
#line 630 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp16_ = id;
#line 630 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp17_ = parent;
#line 630 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp18_ = title;
#line 630 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp19_ = rygel_audio_item_new (_tmp16_, (RygelMediaContainer*) _tmp17_, _tmp18_);
#line 630 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				result = (RygelMediaObject*) _tmp19_;
#line 630 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				return result;
#line 5384 "rygel-object-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_MUSIC_ITEM_UPNP_CLASS)) {
#line 622 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		switch (0) {
#line 5390 "rygel-object-creator.c"
			default:
			{
				const gchar* _tmp20_ = NULL;
				RygelWritableContainer* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				RygelMusicItem* _tmp23_ = NULL;
#line 632 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp20_ = id;
#line 632 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp21_ = parent;
#line 632 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp22_ = title;
#line 632 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp23_ = rygel_music_item_new (_tmp20_, (RygelMediaContainer*) _tmp21_, _tmp22_);
#line 632 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				result = (RygelMediaObject*) _tmp23_;
#line 632 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				return result;
#line 5409 "rygel-object-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_PLAYLIST_ITEM_UPNP_CLASS)) {
#line 622 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		switch (0) {
#line 5415 "rygel-object-creator.c"
			default:
			{
				const gchar* _tmp24_ = NULL;
				RygelWritableContainer* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				RygelPlaylistItem* _tmp27_ = NULL;
#line 634 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp24_ = id;
#line 634 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp25_ = parent;
#line 634 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp26_ = title;
#line 634 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp27_ = rygel_playlist_item_new (_tmp24_, (RygelMediaContainer*) _tmp25_, _tmp26_);
#line 634 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				result = (RygelMediaObject*) _tmp27_;
#line 634 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				return result;
#line 5434 "rygel-object-creator.c"
			}
		}
	} else if ((_tmp3_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_UPNP_CLASS)) || (_tmp3_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER))) {
#line 622 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		switch (0) {
#line 5440 "rygel-object-creator.c"
			default:
			{
				const gchar* _tmp28_ = NULL;
				RygelWritableContainer* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				RygelBaseMediaContainer* _tmp31_ = NULL;
#line 637 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp28_ = id;
#line 637 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp29_ = parent;
#line 637 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp30_ = title;
#line 637 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp31_ = rygel_base_media_container_new (_tmp28_, (RygelMediaContainer*) _tmp29_, _tmp30_, 0);
#line 637 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				result = (RygelMediaObject*) _tmp31_;
#line 637 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				return result;
#line 5459 "rygel-object-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_PLAYLIST)) {
#line 622 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		switch (0) {
#line 5465 "rygel-object-creator.c"
			default:
			{
				RygelBaseMediaContainer* container = NULL;
				const gchar* _tmp32_ = NULL;
				RygelWritableContainer* _tmp33_ = NULL;
				const gchar* _tmp34_ = NULL;
				RygelBaseMediaContainer* _tmp35_ = NULL;
				RygelBaseMediaContainer* _tmp36_ = NULL;
				const gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
#line 639 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp32_ = id;
#line 639 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp33_ = parent;
#line 639 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp34_ = title;
#line 639 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp35_ = rygel_base_media_container_new (_tmp32_, (RygelMediaContainer*) _tmp33_, _tmp34_, 0);
#line 639 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				container = _tmp35_;
#line 640 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp36_ = container;
#line 640 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp37_ = upnp_class;
#line 640 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp38_ = g_strdup (_tmp37_);
#line 640 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_g_free0 (((RygelMediaObject*) _tmp36_)->upnp_class);
#line 640 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				((RygelMediaObject*) _tmp36_)->upnp_class = _tmp38_;
#line 641 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				result = (RygelMediaObject*) container;
#line 641 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				return result;
#line 5500 "rygel-object-creator.c"
			}
		}
	} else {
#line 622 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		switch (0) {
#line 5506 "rygel-object-creator.c"
			default:
			{
				gchar* msg = NULL;
				const gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				const gchar* _tmp42_ = NULL;
				GError* _tmp43_ = NULL;
#line 643 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp39_ = _ ("Cannot create object of class '%s': Not supported");
#line 643 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp40_ = g_strdup (_tmp39_);
#line 643 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				msg = _tmp40_;
#line 644 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp41_ = msg;
#line 644 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp42_ = upnp_class;
#line 644 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_tmp43_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp41_, _tmp42_);
#line 644 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_inner_error_ = _tmp43_;
#line 644 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				g_propagate_error (error, _inner_error_);
#line 644 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_g_free0 (msg);
#line 644 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				return NULL;
#line 5535 "rygel-object-creator.c"
			}
		}
	}
}


/**
     * Simple check for the validity of an URI.
     *
     * Check is done by parsing the URI with soup. Additionaly a cleaned-up
     * version of the URI is returned in sanitized_uri.
     *
     * @param uri the input URI
     * @param sanitized_uri containes a sanitized version of the URI on return
     * @returns true if the URI is valid, false otherwise.
     */
static void _vala_SoupURI_free (SoupURI* self) {
#line 667 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_boxed_free (soup_uri_get_type (), self);
#line 5555 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_is_valid_uri (RygelObjectCreator* self, const gchar* uri, gchar** sanitized_uri) {
	gchar* _vala_sanitized_uri = NULL;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
	SoupURI* soup_uri = NULL;
	const gchar* _tmp4_ = NULL;
	SoupURI* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	SoupURI* _tmp7_ = NULL;
	gboolean _tmp10_ = FALSE;
	SoupURI* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
#line 658 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 659 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (_vala_sanitized_uri);
#line 659 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_vala_sanitized_uri = NULL;
#line 660 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = uri;
#line 660 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp1_ == NULL) {
#line 660 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp0_ = TRUE;
#line 5585 "rygel-object-creator.c"
	} else {
		const gchar* _tmp2_ = NULL;
#line 660 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp2_ = uri;
#line 660 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
#line 5592 "rygel-object-creator.c"
	}
#line 660 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp3_ = _tmp0_;
#line 660 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp3_) {
#line 661 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		result = FALSE;
#line 661 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (sanitized_uri) {
#line 661 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			*sanitized_uri = _vala_sanitized_uri;
#line 5604 "rygel-object-creator.c"
		} else {
#line 661 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_free0 (_vala_sanitized_uri);
#line 5608 "rygel-object-creator.c"
		}
#line 661 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return result;
#line 5612 "rygel-object-creator.c"
	}
#line 664 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp4_ = uri;
#line 664 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp5_ = soup_uri_new (_tmp4_);
#line 664 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	soup_uri = _tmp5_;
#line 666 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp7_ = soup_uri;
#line 666 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp7_ == NULL) {
#line 666 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp6_ = TRUE;
#line 5626 "rygel-object-creator.c"
	} else {
		SoupURI* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 666 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp8_ = soup_uri;
#line 666 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp9_ = _tmp8_->scheme;
#line 666 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_tmp6_ = _tmp9_ == NULL;
#line 5636 "rygel-object-creator.c"
	}
#line 666 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp10_ = _tmp6_;
#line 666 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_tmp10_) {
#line 667 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		result = FALSE;
#line 667 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		__vala_SoupURI_free0 (soup_uri);
#line 667 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (sanitized_uri) {
#line 667 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			*sanitized_uri = _vala_sanitized_uri;
#line 5650 "rygel-object-creator.c"
		} else {
#line 667 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_free0 (_vala_sanitized_uri);
#line 5654 "rygel-object-creator.c"
		}
#line 667 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return result;
#line 5658 "rygel-object-creator.c"
	}
#line 670 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp11_ = soup_uri;
#line 670 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp12_ = soup_uri_to_string (_tmp11_, FALSE);
#line 670 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (_vala_sanitized_uri);
#line 670 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_vala_sanitized_uri = _tmp12_;
#line 672 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	result = TRUE;
#line 672 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	__vala_SoupURI_free0 (soup_uri);
#line 672 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (sanitized_uri) {
#line 672 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		*sanitized_uri = _vala_sanitized_uri;
#line 5676 "rygel-object-creator.c"
	} else {
#line 672 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_free0 (_vala_sanitized_uri);
#line 5680 "rygel-object-creator.c"
	}
#line 672 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return result;
#line 5684 "rygel-object-creator.c"
}


/**
     * Transform the title to be usable on legacy file-systems such as FAT32.
     *
     * The function trims down the title to 205 chars (leaving room for an UUID)
     * and replaces all special characters.
     *
     * @param title of the the media item
     * @return the cleaned and shortened title
     */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1157 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1157 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 5716 "rygel-object-creator.c"
		glong _tmp4_ = 0L;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 5724 "rygel-object-creator.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 5736 "rygel-object-creator.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
#line 1167 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 5761 "rygel-object-creator.c"
		glong _tmp2_ = 0L;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 5767 "rygel-object-creator.c"
	} else {
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 5771 "rygel-object-creator.c"
	}
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 5777 "rygel-object-creator.c"
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 5789 "rygel-object-creator.c"
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 5799 "rygel-object-creator.c"
	}
#line 1176 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1176 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 5805 "rygel-object-creator.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1178 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1178 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 5819 "rygel-object-creator.c"
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 5829 "rygel-object-creator.c"
	}
#line 1182 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1182 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 5835 "rygel-object-creator.c"
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 5844 "rygel-object-creator.c"
	}
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 5864 "rygel-object-creator.c"
}


static gchar* uuid_get (void) {
	gchar* result = NULL;
	guchar* id = NULL;
	guchar* _tmp0_ = NULL;
	gint id_length1 = 0;
	gint _id_size_ = 0;
	guchar* unparsed = NULL;
	guchar* _tmp1_ = NULL;
	gint unparsed_length1 = 0;
	gint _unparsed_size_ = 0;
	guchar* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guchar* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	guchar _tmp6_ = '\0';
	guchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar* _tmp8_ = NULL;
#line 8 "../src/librygel-core/uuid.vapi"
	_tmp0_ = g_new0 (guchar, 16);
#line 8 "../src/librygel-core/uuid.vapi"
	id = _tmp0_;
#line 8 "../src/librygel-core/uuid.vapi"
	id_length1 = 16;
#line 8 "../src/librygel-core/uuid.vapi"
	_id_size_ = id_length1;
#line 9 "../src/librygel-core/uuid.vapi"
	_tmp1_ = g_new0 (guchar, 51);
#line 9 "../src/librygel-core/uuid.vapi"
	unparsed = _tmp1_;
#line 9 "../src/librygel-core/uuid.vapi"
	unparsed_length1 = 51;
#line 9 "../src/librygel-core/uuid.vapi"
	_unparsed_size_ = unparsed_length1;
#line 11 "../src/librygel-core/uuid.vapi"
	_tmp2_ = id;
#line 11 "../src/librygel-core/uuid.vapi"
	_tmp2__length1 = id_length1;
#line 11 "../src/librygel-core/uuid.vapi"
	uuid_generate (_tmp2_);
#line 12 "../src/librygel-core/uuid.vapi"
	_tmp3_ = id;
#line 12 "../src/librygel-core/uuid.vapi"
	_tmp3__length1 = id_length1;
#line 12 "../src/librygel-core/uuid.vapi"
	_tmp4_ = unparsed;
#line 12 "../src/librygel-core/uuid.vapi"
	_tmp4__length1 = unparsed_length1;
#line 12 "../src/librygel-core/uuid.vapi"
	uuid_unparse (_tmp3_, _tmp4_);
#line 13 "../src/librygel-core/uuid.vapi"
	_tmp5_ = unparsed;
#line 13 "../src/librygel-core/uuid.vapi"
	_tmp5__length1 = unparsed_length1;
#line 13 "../src/librygel-core/uuid.vapi"
	_tmp5_[50] = (guchar) '\0';
#line 13 "../src/librygel-core/uuid.vapi"
	_tmp6_ = _tmp5_[50];
#line 15 "../src/librygel-core/uuid.vapi"
	_tmp7_ = unparsed;
#line 15 "../src/librygel-core/uuid.vapi"
	_tmp7__length1 = unparsed_length1;
#line 15 "../src/librygel-core/uuid.vapi"
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
#line 15 "../src/librygel-core/uuid.vapi"
	result = _tmp8_;
#line 15 "../src/librygel-core/uuid.vapi"
	unparsed = (g_free (unparsed), NULL);
#line 15 "../src/librygel-core/uuid.vapi"
	id = (g_free (id), NULL);
#line 15 "../src/librygel-core/uuid.vapi"
	return result;
#line 5944 "rygel-object-creator.c"
}


static gchar* rygel_object_creator_mangle_title (RygelObjectCreator* self, const gchar* title, GError** error) {
	gchar* result = NULL;
	gchar* mangled = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GRegex* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
#line 684 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 684 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 685 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = title;
#line 685 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = title;
#line 685 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp2_ = strlen (_tmp1_);
#line 685 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp3_ = _tmp2_;
#line 685 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp4_ = MIN (_tmp3_, 205);
#line 685 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp5_ = string_substring (_tmp0_, (glong) 0, (glong) _tmp4_);
#line 685 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	mangled = _tmp5_;
#line 686 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp7_ = self->priv->title_regex;
#line 686 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp8_ = mangled;
#line 686 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp9_ = g_regex_replace_literal (_tmp7_, _tmp8_, (gssize) (-1), 0, "_", G_REGEX_MATCH_NOTEMPTY, &_inner_error_);
#line 686 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp6_ = _tmp9_;
#line 686 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_inner_error_ != NULL) {
#line 686 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 686 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_free0 (mangled);
#line 686 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return NULL;
#line 6003 "rygel-object-creator.c"
	}
#line 686 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (mangled);
#line 686 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	mangled = _tmp6_;
#line 692 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp10_ = uuid_get ();
#line 692 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp11_ = _tmp10_;
#line 692 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp12_ = g_strconcat (_tmp11_, "-", NULL);
#line 692 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp13_ = _tmp12_;
#line 692 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp14_ = mangled;
#line 692 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp15_ = g_strconcat (_tmp13_, _tmp14_, NULL);
#line 692 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp16_ = _tmp15_;
#line 692 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (_tmp13_);
#line 692 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (_tmp11_);
#line 692 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	result = _tmp16_;
#line 692 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (mangled);
#line 692 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return result;
#line 6033 "rygel-object-creator.c"
}


static void rygel_object_creator_create_uri_data_free (gpointer _data) {
	RygelObjectCreatorCreateUriData* _data_;
	_data_ = _data;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->container);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (_data_->title);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (_data_->result);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_slice_free (RygelObjectCreatorCreateUriData, _data_);
#line 6050 "rygel-object-creator.c"
}


static void rygel_object_creator_create_uri (RygelObjectCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorCreateUriData* _data_;
	RygelObjectCreator* _tmp0_ = NULL;
	RygelWritableContainer* _tmp1_ = NULL;
	RygelWritableContainer* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = g_slice_new0 (RygelObjectCreatorCreateUriData);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_create_uri);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_create_uri_data_free);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->self = _tmp0_;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = container;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->container);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->container = _tmp2_;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp3_ = title;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (_data_->title);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->title = _tmp4_;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_create_uri_co (_data_);
#line 6089 "rygel-object-creator.c"
}


static gchar* rygel_object_creator_create_uri_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	RygelObjectCreatorCreateUriData* _data_;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return NULL;
#line 6100 "rygel-object-creator.c"
	}
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	result = _data_->result;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->result = NULL;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return result;
#line 6110 "rygel-object-creator.c"
}


/**
     * Create an URI from the item's title.
     *
     * Create an unique URI from the supplied title by cleaning it from
     * unwanted characters, shortening it and adding an UUID.
     *
     * @param container to create the item in
     * @param title of the item to base the name on
     * @returns an URI for the newly created item
     */
static void rygel_object_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorCreateUriData* _data_;
#line 707 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = _user_data_;
#line 707 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_source_object_ = source_object;
#line 707 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_res_ = _res_;
#line 707 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_create_uri_co (_data_);
#line 6134 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_create_uri_co (RygelObjectCreatorCreateUriData* _data_) {
#line 705 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	switch (_data_->_state_) {
#line 705 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 0:
#line 6143 "rygel-object-creator.c"
		goto _state_0;
#line 705 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 1:
#line 6147 "rygel-object-creator.c"
		goto _state_1;
		default:
#line 705 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 6152 "rygel-object-creator.c"
	}
	_state_0:
#line 707 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp0_ = NULL;
#line 707 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp0_ = _data_->container;
#line 707 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp1_ = NULL;
#line 707 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 707 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp2_ = NULL;
#line 707 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 707 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_state_ = 1;
#line 707 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_writable_container_get_writable (_data_->_tmp0_, _data_->_tmp2_, rygel_object_creator_create_uri_ready, _data_);
#line 707 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return FALSE;
#line 6173 "rygel-object-creator.c"
	_state_1:
#line 707 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp3_ = NULL;
#line 707 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp3_ = rygel_writable_container_get_writable_finish (_data_->_tmp0_, _data_->_res_);
#line 707 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->dir = _data_->_tmp3_;
#line 708 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp4_ = NULL;
#line 708 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp4_ = _data_->dir;
#line 708 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_tmp4_ == NULL) {
#line 709 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp5_ = NULL;
#line 709 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp5_ = _ ("Object creation in %s not allowed");
#line 709 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp6_ = NULL;
#line 709 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp6_ = _data_->container;
#line 709 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp7_ = NULL;
#line 709 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp7_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp6_);
#line 709 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp8_ = NULL;
#line 709 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp8_ = _data_->_tmp7_;
#line 709 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp9_ = NULL;
#line 709 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp9_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp5_, _data_->_tmp8_);
#line 709 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_inner_error_ = _data_->_tmp9_;
#line 709 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 709 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 709 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (_data_->dir);
#line 709 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 709 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 6219 "rygel-object-creator.c"
		} else {
#line 709 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 6223 "rygel-object-creator.c"
		}
#line 709 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 709 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 6229 "rygel-object-creator.c"
	}
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp11_ = NULL;
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp11_ = _data_->title;
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp12_ = NULL;
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp12_ = rygel_object_creator_mangle_title (_data_->self, _data_->_tmp11_, &_data_->_inner_error_);
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp10_ = _data_->_tmp12_;
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_inner_error_ != NULL) {
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (_data_->dir);
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 6253 "rygel-object-creator.c"
		} else {
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 6257 "rygel-object-creator.c"
		}
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 6263 "rygel-object-creator.c"
	}
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp13_ = NULL;
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp13_ = _data_->dir;
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp14_ = NULL;
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp14_ = _data_->_tmp10_;
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp15_ = NULL;
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp15_ = g_file_get_child_for_display_name (_data_->_tmp13_, _data_->_tmp14_, &_data_->_inner_error_);
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp16_ = NULL;
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp16_ = _data_->_tmp15_;
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (_data_->_tmp14_);
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->file = _data_->_tmp16_;
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_inner_error_ != NULL) {
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (_data_->dir);
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 6297 "rygel-object-creator.c"
		} else {
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 6301 "rygel-object-creator.c"
		}
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 714 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		return FALSE;
#line 6307 "rygel-object-creator.c"
	}
#line 716 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp17_ = NULL;
#line 716 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp17_ = _data_->file;
#line 716 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp18_ = NULL;
#line 716 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp18_ = g_file_get_uri (_data_->_tmp17_);
#line 716 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->result = _data_->_tmp18_;
#line 716 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->file);
#line 716 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->dir);
#line 716 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 716 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 6327 "rygel-object-creator.c"
	} else {
#line 716 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 6331 "rygel-object-creator.c"
	}
#line 716 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 716 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return FALSE;
#line 705 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->file);
#line 705 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->dir);
#line 705 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 705 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 6345 "rygel-object-creator.c"
	} else {
#line 705 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 6349 "rygel-object-creator.c"
	}
#line 705 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 705 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return FALSE;
#line 6355 "rygel-object-creator.c"
}


static void rygel_object_creator_wait_for_object_data_free (gpointer _data) {
	RygelObjectCreatorWaitForObjectData* _data_;
	_data_ = _data;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_slice_free (RygelObjectCreatorWaitForObjectData, _data_);
#line 6366 "rygel-object-creator.c"
}


static void rygel_object_creator_wait_for_object (RygelObjectCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorWaitForObjectData* _data_;
	RygelObjectCreator* _tmp0_ = NULL;
	RygelWritableContainer* _tmp1_ = NULL;
	RygelWritableContainer* _tmp2_ = NULL;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = g_slice_new0 (RygelObjectCreatorWaitForObjectData);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_wait_for_object);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_wait_for_object_data_free);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->self = _tmp0_;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = container;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->container);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->container = _tmp2_;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_wait_for_object_co (_data_);
#line 6395 "rygel-object-creator.c"
}


static void rygel_object_creator_wait_for_object_finish (RygelObjectCreator* self, GAsyncResult* _res_) {
	RygelObjectCreatorWaitForObjectData* _data_;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 6403 "rygel-object-creator.c"
}


/**
     * Wait for the new object
     *
     * When creating an object in the back-end via WritableContainer.add_item
     * or WritableContainer.add_container there might be a delay between the
     * creation and the back-end having the newly created item available. This
     * function waits for the item to become available by hooking into the
     * container_updated signal. The maximum time to wait is 5 seconds.
     *
     * @param container to watch
     */
static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return _data4_;
#line 6423 "rygel-object-creator.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 6432 "rygel-object-creator.c"
		RygelObjectCreator * self;
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		self = _data4_->self;
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (_data4_->container);
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_g_object_unref0 (self);
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_slice_free (Block4Data, _data4_);
#line 6442 "rygel-object-creator.c"
	}
}


static void rygel_object_creator_wait_for_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorWaitForObjectData* _data_;
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_ = _user_data_;
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_source_object_ = source_object;
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_res_ = _res_;
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_wait_for_object_co (_data_);
#line 6457 "rygel-object-creator.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 745 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 745 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return _data5_;
#line 6466 "rygel-object-creator.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 745 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 6475 "rygel-object-creator.c"
		RygelObjectCreator * self;
#line 745 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		self = _data5_->_data4_->self;
#line 745 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		block4_data_unref (_data5_->_data4_);
#line 745 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data5_->_data4_ = NULL;
#line 745 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_slice_free (Block5Data, _data5_);
#line 6485 "rygel-object-creator.c"
	}
}


static void ____lambda5_ (Block5Data* _data5_, RygelMediaContainer* container) {
	Block4Data* _data4_;
	RygelObjectCreator * self;
#line 746 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data4_ = _data5_->_data4_;
#line 746 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	self = _data4_->self;
#line 746 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_if_fail (container != NULL);
#line 747 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_wait_for_object_co (_data4_->_async_data_);
#line 6501 "rygel-object-creator.c"
}


static void _____lambda5__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 746 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	____lambda5_ (self, container);
#line 6508 "rygel-object-creator.c"
}


static gboolean ____lambda6_ (Block5Data* _data5_) {
	Block4Data* _data4_;
	RygelObjectCreator * self;
	gboolean result = FALSE;
	RygelWritableContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 751 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data4_ = _data5_->_data4_;
#line 751 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	self = _data4_->self;
#line 752 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = _data4_->container;
#line 752 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp0_);
#line 752 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp2_ = _tmp1_;
#line 752 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_debug ("rygel-object-creator.vala:752: Timeout on waiting for 'updated' signal" \
" on '%s'.", _tmp2_);
#line 754 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data5_->timeout = (guint) 0;
#line 755 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_wait_for_object_co (_data4_->_async_data_);
#line 757 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	result = FALSE;
#line 757 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return result;
#line 6539 "rygel-object-creator.c"
}


static gboolean _____lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda6_ (self);
#line 751 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return result;
#line 6548 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_wait_for_object_co (RygelObjectCreatorWaitForObjectData* _data_) {
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	switch (_data_->_state_) {
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 0:
#line 6557 "rygel-object-creator.c"
		goto _state_0;
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 1:
#line 6561 "rygel-object-creator.c"
		goto _state_1;
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case 2:
#line 6565 "rygel-object-creator.c"
		goto _state_2;
		default:
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 6570 "rygel-object-creator.c"
	}
	_state_0:
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_data4_ = g_slice_new0 (Block4Data);
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_data4_->_ref_count_ = 1;
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_data4_->self = g_object_ref (_data_->self);
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp0_ = NULL;
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp0_ = _data_->container;
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->_data4_->container);
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_data4_->container = _data_->_tmp0_;
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_data4_->_async_data_ = _data_;
#line 731 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp1_ = NULL;
#line 731 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp1_ = _data_->_data4_->container;
#line 731 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp2_ = NULL;
#line 731 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp1_);
#line 731 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp3_ = NULL;
#line 731 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 731 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_debug ("rygel-object-creator.vala:731: Waiting for new object to appear under " \
"container '%s'…", _data_->_tmp3_);
#line 734 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->object = NULL;
#line 736 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	while (TRUE) {
#line 736 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp4_ = NULL;
#line 736 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp4_ = _data_->object;
#line 736 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (!(_data_->_tmp4_ == NULL)) {
#line 736 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			break;
#line 6615 "rygel-object-creator.c"
		}
		{
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp6_ = NULL;
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp6_ = _data_->_data4_->container;
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp7_ = NULL;
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp7_ = _data_->self->priv->object;
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp8_ = NULL;
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp8_ = rygel_media_object_get_id (_data_->_tmp7_);
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp9_ = NULL;
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp9_ = _data_->_tmp8_;
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp10_ = NULL;
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp10_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp11_ = NULL;
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp11_ = _data_->_tmp10_;
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_state_ = 1;
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			rygel_media_object_find_object ((RygelMediaObject*) _data_->_tmp6_, _data_->_tmp9_, _data_->_tmp11_, rygel_object_creator_wait_for_object_ready, _data_);
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			return FALSE;
#line 6648 "rygel-object-creator.c"
			_state_1:
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp12_ = NULL;
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp12_ = rygel_media_object_find_object_finish ((RygelMediaObject*) _data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp5_ = _data_->_tmp12_;
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			if (_data_->_inner_error_ != NULL) {
#line 6658 "rygel-object-creator.c"
				goto __catch4_g_error;
			}
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_object_unref0 (_data_->object);
#line 738 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->object = _data_->_tmp5_;
#line 6665 "rygel-object-creator.c"
		}
		goto __finally4;
		__catch4_g_error:
		{
#line 737 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_error_ = _data_->_inner_error_;
#line 737 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_inner_error_ = NULL;
#line 741 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp13_ = NULL;
#line 741 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp13_ = _ ("Error from container '%s' on trying to find the newly added child obje" \
"ct '%s' in it: %s");
#line 741 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp14_ = NULL;
#line 741 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp14_ = g_strdup (_data_->_tmp13_);
#line 741 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->msg = _data_->_tmp14_;
#line 742 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp15_ = NULL;
#line 742 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp15_ = _data_->msg;
#line 742 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp16_ = NULL;
#line 742 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp16_ = _data_->_data4_->container;
#line 742 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp17_ = NULL;
#line 742 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp17_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp16_);
#line 742 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp18_ = NULL;
#line 742 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp18_ = _data_->_tmp17_;
#line 742 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp19_ = NULL;
#line 742 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp19_ = _data_->self->priv->object;
#line 742 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp20_ = NULL;
#line 742 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp20_ = rygel_media_object_get_id (_data_->_tmp19_);
#line 742 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp21_ = NULL;
#line 742 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp21_ = _data_->_tmp20_;
#line 742 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp22_ = NULL;
#line 742 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp22_ = _data_->_error_;
#line 742 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp23_ = NULL;
#line 742 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp23_ = _data_->_tmp22_->message;
#line 742 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_warning (_data_->_tmp15_, _data_->_tmp18_, _data_->_tmp21_, _data_->_tmp23_);
#line 737 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_free0 (_data_->msg);
#line 737 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_error_free0 (_data_->_error_);
#line 6726 "rygel-object-creator.c"
		}
		__finally4:
#line 737 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 737 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_g_object_unref0 (_data_->object);
#line 737 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			block4_data_unref (_data_->_data4_);
#line 737 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_data4_ = NULL;
#line 737 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 737 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_clear_error (&_data_->_inner_error_);
#line 737 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			return FALSE;
#line 6743 "rygel-object-creator.c"
		}
#line 745 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp24_ = NULL;
#line 745 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		_data_->_tmp24_ = _data_->object;
#line 745 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		if (_data_->_tmp24_ == NULL) {
#line 745 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_data5_ = g_slice_new0 (Block5Data);
#line 745 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_data5_->_ref_count_ = 1;
#line 745 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_data5_->_data4_ = block4_data_ref (_data_->_data4_);
#line 746 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp25_ = NULL;
#line 746 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp25_ = _data_->_data4_->container;
#line 746 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp26_ = 0UL;
#line 746 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp26_ = g_signal_connect_data ((RygelMediaContainer*) _data_->_tmp25_, "container-updated", (GCallback) _____lambda5__rygel_media_container_container_updated, block5_data_ref (_data_->_data5_), (GClosureNotify) block5_data_unref, 0);
#line 746 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->id = _data_->_tmp26_;
#line 750 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_data5_->timeout = (guint) 0;
#line 751 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp27_ = 0U;
#line 751 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp27_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, _____lambda6__gsource_func, block5_data_ref (_data_->_data5_), block5_data_unref);
#line 751 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_data5_->timeout = _data_->_tmp27_;
#line 760 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_state_ = 2;
#line 760 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			return FALSE;
#line 6779 "rygel-object-creator.c"
			_state_2:
			;
#line 762 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp28_ = NULL;
#line 762 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp28_ = _data_->_data4_->container;
#line 762 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp29_ = 0UL;
#line 762 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp29_ = _data_->id;
#line 762 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			g_signal_handler_disconnect ((GObject*) _data_->_tmp28_, _data_->_tmp29_);
#line 764 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp30_ = 0U;
#line 764 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_tmp30_ = _data_->_data5_->timeout;
#line 764 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			if (_data_->_tmp30_ != ((guint) 0)) {
#line 765 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_data_->_tmp31_ = 0U;
#line 765 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_data_->_tmp31_ = _data_->_data5_->timeout;
#line 765 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				g_source_remove (_data_->_tmp31_);
#line 6804 "rygel-object-creator.c"
			} else {
#line 767 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				block5_data_unref (_data_->_data5_);
#line 767 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				_data_->_data5_ = NULL;
#line 767 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
				break;
#line 6812 "rygel-object-creator.c"
			}
#line 745 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			block5_data_unref (_data_->_data5_);
#line 745 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
			_data_->_data5_ = NULL;
#line 6818 "rygel-object-creator.c"
		}
	}
#line 771 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp32_ = NULL;
#line 771 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp32_ = _data_->_data4_->container;
#line 771 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp33_ = NULL;
#line 771 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp33_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp32_);
#line 771 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp34_ = NULL;
#line 771 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp34_ = _data_->_tmp33_;
#line 771 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_debug ("rygel-object-creator.vala:771: Finished waiting for new object to appe" \
"ar under container '%s'", _data_->_tmp34_);
#line 774 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp35_ = NULL;
#line 774 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp35_ = _data_->object;
#line 774 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp36_ = NULL;
#line 774 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_tmp36_ = _g_object_ref0 (_data_->_tmp35_);
#line 774 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self->priv->object);
#line 774 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->self->priv->object = _data_->_tmp36_;
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (_data_->object);
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	block4_data_unref (_data_->_data4_);
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_data_->_data4_ = NULL;
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 6857 "rygel-object-creator.c"
	} else {
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 6861 "rygel-object-creator.c"
	}
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 730 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return FALSE;
#line 6867 "rygel-object-creator.c"
}


/**
     * Check if the profile is supported.
     *
     * The check is performed against the MediaEngine's database explicitly excluding
     * the transcoders.
     *
     * @param profile to check
     * @returns true if the profile is supported, false otherwise.
     */
static gint _rygel_dlna_profile_compare_by_name_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = rygel_dlna_profile_compare_by_name (a, b);
#line 793 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return result;
#line 6885 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_is_profile_valid (RygelObjectCreator* self, const gchar* profile) {
	gboolean result = FALSE;
	GList* profiles = NULL;
	GList* _result_ = NULL;
	RygelMediaServerPlugin* plugin = NULL;
	RygelContentDirectory* _tmp0_ = NULL;
	RygelRootDevice* _tmp1_ = NULL;
	RygelMediaServerPlugin* _tmp2_ = NULL;
	RygelMediaServerPlugin* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	RygelDLNAProfile* p = NULL;
	const gchar* _tmp5_ = NULL;
	RygelDLNAProfile* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
#line 786 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 786 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_return_val_if_fail (profile != NULL, FALSE);
#line 789 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = self->priv->content_dir;
#line 789 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = _tmp0_->root_device;
#line 789 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp2_ = _tmp1_->resource_factory;
#line 789 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _tmp2_) : NULL);
#line 789 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	plugin = _tmp3_;
#line 790 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp4_ = plugin->upload_profiles;
#line 790 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	profiles = _tmp4_;
#line 791 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp5_ = profile;
#line 791 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp6_ = rygel_dlna_profile_new (_tmp5_, "");
#line 791 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	p = _tmp6_;
#line 793 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp7_ = g_list_find_custom (profiles, p, _rygel_dlna_profile_compare_by_name_gcompare_func);
#line 793 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_result_ = _tmp7_;
#line 795 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	result = _result_ != NULL;
#line 795 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_rygel_dlna_profile_unref0 (p);
#line 795 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (plugin);
#line 795 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return result;
#line 6939 "rygel-object-creator.c"
}


static GCancellable* rygel_object_creator_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelObjectCreator* self;
	GCancellable* _tmp0_ = NULL;
#line 108 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	self = (RygelObjectCreator*) base;
#line 108 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = self->priv->_cancellable;
#line 108 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	result = _tmp0_;
#line 108 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	return result;
#line 6955 "rygel-object-creator.c"
}


static void rygel_object_creator_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelObjectCreator* self;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 108 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	self = (RygelObjectCreator*) base;
#line 108 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = value;
#line 108 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 108 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 108 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	self->priv->_cancellable = _tmp1_;
#line 108 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 6975 "rygel-object-creator.c"
}


static void rygel_object_creator_class_init (RygelObjectCreatorClass * klass) {
	GPatternSpec* _tmp0_ = NULL;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_parent_class = g_type_class_peek_parent (klass);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_type_class_add_private (klass, sizeof (RygelObjectCreatorPrivate));
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_object_creator_get_property;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_object_creator_set_property;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_object_creator_finalize;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_OBJECT_CREATOR_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 91 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_tmp0_ = g_pattern_spec_new ("*<!--*-->*");
#line 91 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_comment_pattern = _tmp0_;
#line 6997 "rygel-object-creator.c"
}


static void rygel_object_creator_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	rygel_object_creator_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_object_creator_real_run;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	iface->run_finish = rygel_object_creator_real_run_finish;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	iface->get_cancellable = rygel_object_creator_real_get_cancellable;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	iface->set_cancellable = rygel_object_creator_real_set_cancellable;
#line 7012 "rygel-object-creator.c"
}


static void rygel_object_creator_instance_init (RygelObjectCreator * self) {
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	self->priv = RYGEL_OBJECT_CREATOR_GET_PRIVATE (self);
#line 7019 "rygel-object-creator.c"
}


static void rygel_object_creator_finalize (GObject* obj) {
	RygelObjectCreator * self;
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreator);
#line 96 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (self->priv->container_id);
#line 97 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_free0 (self->priv->elements);
#line 99 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->didl_object);
#line 100 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->object);
#line 102 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->content_dir);
#line 103 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->action);
#line 104 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->serializer);
#line 105 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->didl_parser);
#line 106 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_regex_unref0 (self->priv->title_regex);
#line 108 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	G_OBJECT_CLASS (rygel_object_creator_parent_class)->finalize (obj);
#line 7049 "rygel-object-creator.c"
}


/**
 * CreateObject action implementation.
 */
GType rygel_object_creator_get_type (void) {
	static volatile gsize rygel_object_creator_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_object_creator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelObjectCreatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_object_creator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelObjectCreator), 0, (GInstanceInitFunc) rygel_object_creator_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_object_creator_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_object_creator_type_id;
		rygel_object_creator_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelObjectCreator", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_object_creator_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_object_creator_type_id__volatile, rygel_object_creator_type_id);
	}
	return rygel_object_creator_type_id__volatile;
}


static void _vala_rygel_object_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelObjectCreator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreator);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	switch (property_id) {
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case RYGEL_OBJECT_CREATOR_CANCELLABLE:
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		break;
#line 7081 "rygel-object-creator.c"
		default:
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		break;
#line 7087 "rygel-object-creator.c"
	}
}


static void _vala_rygel_object_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelObjectCreator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreator);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
	switch (property_id) {
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		case RYGEL_OBJECT_CREATOR_CANCELLABLE:
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		break;
#line 7103 "rygel-object-creator.c"
		default:
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 90 "/home/jens/Source/rygel/tests/rygel-object-creator.vala"
		break;
#line 7109 "rygel-object-creator.c"
	}
}



