/* rygel-video-item.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-video-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <rygel-core.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_SUBTITLE_MANAGER (rygel_subtitle_manager_get_type ())
#define RYGEL_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManager))
#define RYGEL_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))
#define RYGEL_IS_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_IS_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_SUBTITLE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))

typedef struct _RygelSubtitleManager RygelSubtitleManager;
typedef struct _RygelSubtitleManagerClass RygelSubtitleManagerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	GeeArrayList* uris;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	void (*start) (RygelDataSource* self, RygelHTTPSeek* offsets, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	RygelDataSource* (*create_stream_source) (RygelMediaItem* self, const gchar* host_ip);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelVideoItem {
	RygelAudioItem parent_instance;
	RygelVideoItemPrivate * priv;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelVideoItemPrivate {
	gchar* _author;
	gint _width;
	gint _height;
	gint _color_depth;
	GeeArrayList* _thumbnails;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	gchar* uri;
	gchar* mime_type;
	gchar* caption_type;
	gint64 size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};


static gpointer rygel_video_item_parent_class = NULL;
static RygelVisualItemIface* rygel_video_item_rygel_visual_item_parent_iface = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
#define RYGEL_VIDEO_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemPrivate))
enum  {
	RYGEL_VIDEO_ITEM_DUMMY_PROPERTY,
	RYGEL_VIDEO_ITEM_AUTHOR,
	RYGEL_VIDEO_ITEM_WIDTH,
	RYGEL_VIDEO_ITEM_HEIGHT,
	RYGEL_VIDEO_ITEM_COLOR_DEPTH,
	RYGEL_VIDEO_ITEM_THUMBNAILS
};
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
static void rygel_video_item_real_constructed (GObject* base);
void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value);
static gboolean rygel_video_item_real_streamable (RygelMediaItem* base);
static void rygel_video_item_real_add_uri (RygelMediaItem* base, const gchar* uri);
void rygel_media_item_add_uri (RygelMediaItem* self, const gchar* uri);
void rygel_visual_item_add_thumbnail_for_uri (RygelVisualItem* self, const gchar* uri, const gchar* mime_type);
const gchar* rygel_media_item_get_mime_type (RygelMediaItem* self);
GType rygel_subtitle_manager_get_type (void) G_GNUC_CONST;
RygelSubtitleManager* rygel_subtitle_manager_get_default (void);
GeeArrayList* rygel_subtitle_manager_get_subtitles (RygelSubtitleManager* self, const gchar* uri, GError** error);
static void rygel_video_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
gchar* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const gchar* uri, GError** error);
void rygel_subtitle_add_didl_node (RygelSubtitle* self, GUPnPDIDLLiteItem* didl_item);
void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
void rygel_visual_item_add_thumbnail_resources (RygelVisualItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
static GUPnPDIDLLiteResource* rygel_video_item_real_add_resource (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
GUPnPDIDLLiteResource* rygel_media_object_add_resource (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
void rygel_visual_item_add_visual_props (RygelVisualItem* self, GUPnPDIDLLiteResource* res);
static gint rygel_video_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2);
const gchar* rygel_video_item_get_author (RygelVideoItem* self);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static gchar* rygel_video_item_get_first (RygelVideoItem* self, GList* contributors);
static void rygel_video_item_real_apply_didl_lite (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object);
void rygel_media_object_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
void rygel_video_item_set_author (RygelVideoItem* self, const gchar* value);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static GUPnPDIDLLiteObject* rygel_video_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
static void rygel_video_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
gboolean rygel_http_server_need_proxy (RygelHTTPServer* self, const gchar* uri);
gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_target);
void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_visual_item_add_thumbnail_proxy_resources (RygelVisualItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
static void rygel_video_item_finalize (GObject* obj);
gint rygel_visual_item_get_width (RygelVisualItem* self);
gint rygel_visual_item_get_height (RygelVisualItem* self);
gint rygel_visual_item_get_color_depth (RygelVisualItem* self);
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
static void _vala_rygel_video_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_visual_item_set_width (RygelVisualItem* self, gint value);
void rygel_visual_item_set_height (RygelVisualItem* self, gint value);
void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value);
static void _vala_rygel_video_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	RygelVideoItem * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = id;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = parent;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp2_ = title;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp3_ = upnp_class;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) g_object_new (object_type, "id", _tmp0_, "parent", _tmp1_, "title", _tmp2_, "upnp-class", _tmp3_, NULL);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return self;
#line 388 "rygel-video-item.c"
}


RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return rygel_video_item_construct (RYGEL_TYPE_VIDEO_ITEM, id, parent, title, upnp_class);
#line 395 "rygel-video-item.c"
}


static void rygel_video_item_real_constructed (GObject* base) {
	RygelVideoItem * self;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	G_OBJECT_CLASS (rygel_video_item_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem));
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_icon_info_ref, rygel_icon_info_unref, NULL, NULL, NULL);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = _tmp0_;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, _tmp1_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_object_unref0 (_tmp1_);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp2_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) rygel_subtitle_ref, rygel_subtitle_unref, NULL, NULL, NULL);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_object_unref0 (self->subtitles);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->subtitles = _tmp2_;
#line 422 "rygel-video-item.c"
}


static gboolean rygel_video_item_real_streamable (RygelMediaItem* base) {
	RygelVideoItem * self;
	gboolean result = FALSE;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	result = TRUE;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return result;
#line 435 "rygel-video-item.c"
}


static void rygel_video_item_real_add_uri (RygelMediaItem* base, const gchar* uri) {
	RygelVideoItem * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	RygelSubtitleManager* subtitle_manager = NULL;
	RygelSubtitleManager* _tmp4_ = NULL;
	RygelSubtitleManager* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_if_fail (uri != NULL);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = uri;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (rygel_video_item_parent_class)->add_uri ((RygelMediaItem*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = uri;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp2_ = rygel_media_item_get_mime_type ((RygelMediaItem*) self);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp3_ = _tmp2_;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	rygel_visual_item_add_thumbnail_for_uri ((RygelVisualItem*) self, _tmp1_, _tmp3_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp4_ = rygel_subtitle_manager_get_default ();
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	subtitle_manager = _tmp4_;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp5_ = subtitle_manager;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (_tmp5_ != NULL) {
#line 473 "rygel-video-item.c"
		{
			GeeArrayList* subtitles = NULL;
			RygelSubtitleManager* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			GeeArrayList* _tmp8_ = NULL;
			GeeArrayList* _tmp9_ = NULL;
			GeeArrayList* _tmp10_ = NULL;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp6_ = subtitle_manager;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp7_ = uri;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp8_ = rygel_subtitle_manager_get_subtitles (_tmp6_, _tmp7_, &_inner_error_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			subtitles = _tmp8_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			if (_inner_error_ != NULL) {
#line 491 "rygel-video-item.c"
				goto __catch4_g_error;
			}
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp9_ = self->subtitles;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp10_ = subtitles;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			gee_array_list_add_all (_tmp9_, (GeeCollection*) _tmp10_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_g_object_unref0 (subtitles);
#line 502 "rygel-video-item.c"
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* err = NULL;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			err = _inner_error_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_inner_error_ = NULL;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_g_error_free0 (err);
#line 514 "rygel-video-item.c"
		}
		__finally4:
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		if (_inner_error_ != NULL) {
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_g_object_unref0 (subtitle_manager);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			g_clear_error (&_inner_error_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			return;
#line 527 "rygel-video-item.c"
		}
	}
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_object_unref0 (subtitle_manager);
#line 532 "rygel-video-item.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return self ? g_object_ref (self) : NULL;
#line 539 "rygel-video-item.c"
}


static void rygel_video_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
	RygelVideoItem * self;
	GUPnPDIDLLiteItem* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	GUPnPDIDLLiteItem* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	GError * _inner_error_ = NULL;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 554 "rygel-video-item.c"
	{
		GeeArrayList* _subtitle_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _subtitle_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _subtitle_index = 0;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp0_ = self->subtitles;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_subtitle_list = _tmp1_;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp2_ = _subtitle_list;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp4_ = _tmp3_;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_subtitle_size = _tmp4_;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_subtitle_index = -1;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		while (TRUE) {
#line 582 "rygel-video-item.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			RygelSubtitle* subtitle = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			gchar* protocol = NULL;
			RygelSubtitle* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			gboolean _tmp17_ = FALSE;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp5_ = _subtitle_index;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_subtitle_index = _tmp5_ + 1;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp6_ = _subtitle_index;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp7_ = _subtitle_size;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				break;
#line 609 "rygel-video-item.c"
			}
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp8_ = _subtitle_list;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp9_ = _subtitle_index;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			subtitle = (RygelSubtitle*) _tmp10_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp11_ = subtitle;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp12_ = _tmp11_->uri;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp13_ = rygel_media_item_get_protocol_for_uri ((RygelMediaItem*) self, _tmp12_, &_inner_error_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			protocol = _tmp13_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			if (_inner_error_ != NULL) {
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				g_propagate_error (error, _inner_error_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_rygel_subtitle_unref0 (subtitle);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_g_object_unref0 (_subtitle_list);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				return;
#line 637 "rygel-video-item.c"
			}
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp15_ = allow_internal;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			if (_tmp15_) {
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp14_ = TRUE;
#line 645 "rygel-video-item.c"
			} else {
				const gchar* _tmp16_ = NULL;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp16_ = protocol;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp14_ = g_strcmp0 (_tmp16_, "internal") != 0;
#line 652 "rygel-video-item.c"
			}
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp17_ = _tmp14_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			if (_tmp17_) {
#line 658 "rygel-video-item.c"
				RygelSubtitle* _tmp18_ = NULL;
				GUPnPDIDLLiteItem* _tmp19_ = NULL;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp18_ = subtitle;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp19_ = didl_item;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				rygel_subtitle_add_didl_node (_tmp18_, _tmp19_);
#line 667 "rygel-video-item.c"
			}
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_g_free0 (protocol);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_rygel_subtitle_unref0 (subtitle);
#line 673 "rygel-video-item.c"
		}
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_g_object_unref0 (_subtitle_list);
#line 677 "rygel-video-item.c"
	}
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp20_ = didl_item;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp21_ = allow_internal;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (rygel_video_item_parent_class)->add_resources ((RygelMediaItem*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp20_, _tmp21_, &_inner_error_);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (_inner_error_ != NULL) {
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		g_propagate_error (error, _inner_error_);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		return;
#line 691 "rygel-video-item.c"
	}
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp22_ = didl_item;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp23_ = allow_internal;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	rygel_visual_item_add_thumbnail_resources ((RygelVisualItem*) self, _tmp22_, _tmp23_, &_inner_error_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (_inner_error_ != NULL) {
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		g_propagate_error (error, _inner_error_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		return;
#line 705 "rygel-video-item.c"
	}
}


static GUPnPDIDLLiteResource* rygel_video_item_real_add_resource (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error) {
	RygelVideoItem * self;
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteResource* res = NULL;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GUPnPDIDLLiteResource* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (didl_object != NULL, NULL);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (protocol != NULL, NULL);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = didl_object;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = uri;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp2_ = protocol;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp3_ = import_uri;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp4_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->add_resource ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_, _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	res = _tmp4_;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (_inner_error_ != NULL) {
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		g_propagate_error (error, _inner_error_);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		return NULL;
#line 744 "rygel-video-item.c"
	}
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	rygel_visual_item_add_visual_props ((RygelVisualItem*) self, res);
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	result = res;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return result;
#line 752 "rygel-video-item.c"
}


static gint rygel_video_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property) {
	RygelVideoItem * self;
	gint result = 0;
	RygelMediaObject* _tmp0_ = NULL;
	RygelVideoItem* item = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelVideoItem* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GQuark _tmp6_ = 0U;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	static GQuark _tmp5_label0 = 0;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (media_object != NULL, 0);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (property != NULL, 0);
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = media_object;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_VIDEO_ITEM)) {
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		result = 1;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		return result;
#line 782 "rygel-video-item.c"
	}
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = media_object;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) _tmp1_) : NULL);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	item = _tmp2_;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp3_ = property;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp4_ = _tmp3_;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("upnp:author")))) {
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		switch (0) {
#line 800 "rygel-video-item.c"
			default:
			{
				const gchar* _tmp7_ = NULL;
				RygelVideoItem* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gint _tmp10_ = 0;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp7_ = self->priv->_author;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp8_ = item;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp9_ = _tmp8_->priv->_author;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp10_ = rygel_media_object_compare_string_props ((RygelMediaObject*) self, _tmp7_, _tmp9_);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				result = _tmp10_;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_g_object_unref0 (item);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				return result;
#line 821 "rygel-video-item.c"
			}
		}
	} else {
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		switch (0) {
#line 827 "rygel-video-item.c"
			default:
			{
				RygelVideoItem* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				gint _tmp13_ = 0;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp11_ = item;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp12_ = property;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp13_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->compare_by_property ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), (RygelMediaObject*) _tmp11_, _tmp12_);
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				result = _tmp13_;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_g_object_unref0 (item);
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				return result;
#line 845 "rygel-video-item.c"
			}
		}
	}
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_object_unref0 (item);
#line 851 "rygel-video-item.c"
}


static gchar* rygel_video_item_get_first (RygelVideoItem* self, GList* contributors) {
	gchar* result = NULL;
	GList* _tmp0_ = NULL;
	gchar* _tmp6_ = NULL;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = contributors;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (_tmp0_ != NULL) {
#line 865 "rygel-video-item.c"
		GList* _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp1_ = contributors;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp2_ = _tmp1_->data;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp3_ = gupnp_didl_lite_contributor_get_name ((GUPnPDIDLLiteContributor*) _tmp2_);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp4_ = _tmp3_;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		result = _tmp5_;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		return result;
#line 885 "rygel-video-item.c"
	}
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp6_ = g_strdup ("");
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	result = _tmp6_;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return result;
#line 893 "rygel-video-item.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 900 "rygel-video-item.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_list_free (self);
#line 909 "rygel-video-item.c"
}


static void rygel_video_item_real_apply_didl_lite (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object) {
	RygelVideoItem * self;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteObject* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_if_fail (didl_object != NULL);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = didl_object;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->apply_didl_lite ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = didl_object;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp2_ = gupnp_didl_lite_object_get_authors (_tmp1_);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp3_ = _tmp2_;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp4_ = rygel_video_item_get_first (self, _tmp3_);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp5_ = _tmp4_;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	rygel_video_item_set_author (self, _tmp5_);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_free0 (_tmp5_);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	__g_list_free__g_object_unref0_0 (_tmp3_);
#line 945 "rygel-video-item.c"
}


static GUPnPDIDLLiteObject* rygel_video_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
	RygelVideoItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteObject* didl_item = NULL;
	RygelSerializer* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	GUPnPDIDLLiteObject* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (serializer != NULL, NULL);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = serializer;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = http_server;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp2_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->serialize ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_, _tmp1_, &_inner_error_);
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	didl_item = _tmp2_;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (_inner_error_ != NULL) {
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		g_propagate_error (error, _inner_error_);
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		return NULL;
#line 980 "rygel-video-item.c"
	}
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp4_ = self->priv->_author;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (_tmp4_ != NULL) {
#line 986 "rygel-video-item.c"
		const gchar* _tmp5_ = NULL;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp5_ = self->priv->_author;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
#line 992 "rygel-video-item.c"
	} else {
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp3_ = FALSE;
#line 996 "rygel-video-item.c"
	}
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp6_ = _tmp3_;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (_tmp6_) {
#line 1002 "rygel-video-item.c"
		GUPnPDIDLLiteContributor* contributor = NULL;
		GUPnPDIDLLiteContributor* _tmp7_ = NULL;
		GUPnPDIDLLiteContributor* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp7_ = gupnp_didl_lite_object_add_author (didl_item);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		contributor = _tmp7_;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp8_ = contributor;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp9_ = self->priv->_author;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		gupnp_didl_lite_contributor_set_name (_tmp8_, _tmp9_);
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_g_object_unref0 (contributor);
#line 1019 "rygel-video-item.c"
	}
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	result = didl_item;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return result;
#line 1025 "rygel-video-item.c"
}


static void rygel_video_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
	RygelVideoItem * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	RygelHTTPServer* _tmp32_ = NULL;
	GUPnPDIDLLiteItem* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	GError * _inner_error_ = NULL;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_if_fail (server != NULL);
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = rygel_media_item_get_place_holder ((RygelMediaItem*) self);
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = _tmp0_;
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (!_tmp1_) {
#line 1050 "rygel-video-item.c"
		{
			GeeArrayList* _subtitle_list = NULL;
			GeeArrayList* _tmp2_ = NULL;
			GeeArrayList* _tmp3_ = NULL;
			gint _subtitle_size = 0;
			GeeArrayList* _tmp4_ = NULL;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _subtitle_index = 0;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp2_ = self->subtitles;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp3_ = _g_object_ref0 (_tmp2_);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_subtitle_list = _tmp3_;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp4_ = _subtitle_list;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp6_ = _tmp5_;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_subtitle_size = _tmp6_;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_subtitle_index = -1;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			while (TRUE) {
#line 1078 "rygel-video-item.c"
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				RygelSubtitle* subtitle = NULL;
				GeeArrayList* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gpointer _tmp12_ = NULL;
				RygelHTTPServer* _tmp13_ = NULL;
				RygelSubtitle* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				gchar* uri = NULL;
				RygelSubtitle* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gint index = 0;
				GeeArrayList* _tmp20_ = NULL;
				RygelSubtitle* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				RygelSubtitle* _tmp23_ = NULL;
				RygelHTTPServer* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gchar* _tmp26_ = NULL;
				RygelSubtitle* _tmp27_ = NULL;
				GUPnPDIDLLiteItem* _tmp28_ = NULL;
				RygelSubtitle* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				gchar* _tmp31_ = NULL;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp7_ = _subtitle_index;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_subtitle_index = _tmp7_ + 1;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp8_ = _subtitle_index;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp9_ = _subtitle_size;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				if (!(_tmp8_ < _tmp9_)) {
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					break;
#line 1119 "rygel-video-item.c"
				}
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp10_ = _subtitle_list;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp11_ = _subtitle_index;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				subtitle = (RygelSubtitle*) _tmp12_;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp13_ = server;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp14_ = subtitle;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp15_ = _tmp14_->uri;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp16_ = rygel_http_server_need_proxy (_tmp13_, _tmp15_);
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				if (!_tmp16_) {
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_rygel_subtitle_unref0 (subtitle);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					continue;
#line 1143 "rygel-video-item.c"
				}
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp17_ = subtitle;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp18_ = _tmp17_->uri;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp19_ = g_strdup (_tmp18_);
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				uri = _tmp19_;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp20_ = self->subtitles;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp21_ = subtitle;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp22_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp20_, _tmp21_);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				index = _tmp22_;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp23_ = subtitle;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp24_ = server;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp25_ = index;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp26_ = rygel_transcode_manager_create_uri_for_item ((RygelTranscodeManager*) _tmp24_, (RygelMediaItem*) self, -1, _tmp25_, NULL, NULL);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_g_free0 (_tmp23_->uri);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp23_->uri = _tmp26_;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp27_ = subtitle;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp28_ = didl_item;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				rygel_subtitle_add_didl_node (_tmp27_, _tmp28_);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp29_ = subtitle;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp30_ = uri;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp31_ = g_strdup (_tmp30_);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_g_free0 (_tmp29_->uri);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp29_->uri = _tmp31_;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_g_free0 (uri);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_rygel_subtitle_unref0 (subtitle);
#line 1193 "rygel-video-item.c"
			}
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_g_object_unref0 (_subtitle_list);
#line 1197 "rygel-video-item.c"
		}
	}
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp32_ = server;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp33_ = didl_item;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (rygel_video_item_parent_class)->add_proxy_resources ((RygelMediaItem*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp32_, _tmp33_, &_inner_error_);
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (_inner_error_ != NULL) {
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		g_propagate_error (error, _inner_error_);
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		return;
#line 1212 "rygel-video-item.c"
	}
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp34_ = rygel_media_item_get_place_holder ((RygelMediaItem*) self);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp35_ = _tmp34_;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (!_tmp35_) {
#line 1220 "rygel-video-item.c"
		RygelHTTPServer* _tmp36_ = NULL;
		GUPnPDIDLLiteItem* _tmp37_ = NULL;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp36_ = server;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp37_ = didl_item;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		rygel_visual_item_add_thumbnail_proxy_resources ((RygelVisualItem*) self, _tmp36_, _tmp37_, &_inner_error_);
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		if (_inner_error_ != NULL) {
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			g_propagate_error (error, _inner_error_);
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			return;
#line 1235 "rygel-video-item.c"
		}
	}
}


const gchar* rygel_video_item_get_author (RygelVideoItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = self->priv->_author;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	result = _tmp0_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return result;
#line 1252 "rygel-video-item.c"
}


void rygel_video_item_set_author (RygelVideoItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_if_fail (self != NULL);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = value;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_free0 (self->priv->_author);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->priv->_author = _tmp1_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_notify ((GObject *) self, "author");
#line 1271 "rygel-video-item.c"
}


static gint rygel_video_item_real_get_width (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_ = 0;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = self->priv->_width;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	result = _tmp0_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return result;
#line 1287 "rygel-video-item.c"
}


static void rygel_video_item_real_set_width (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_ = 0;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = value;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->priv->_width = _tmp0_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_notify ((GObject *) self, "width");
#line 1302 "rygel-video-item.c"
}


static gint rygel_video_item_real_get_height (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_ = 0;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = self->priv->_height;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	result = _tmp0_;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return result;
#line 1318 "rygel-video-item.c"
}


static void rygel_video_item_real_set_height (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_ = 0;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = value;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->priv->_height = _tmp0_;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_notify ((GObject *) self, "height");
#line 1333 "rygel-video-item.c"
}


static gint rygel_video_item_real_get_color_depth (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_ = 0;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = self->priv->_color_depth;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	result = _tmp0_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return result;
#line 1349 "rygel-video-item.c"
}


static void rygel_video_item_real_set_color_depth (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_ = 0;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = value;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->priv->_color_depth = _tmp0_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_notify ((GObject *) self, "color-depth");
#line 1364 "rygel-video-item.c"
}


static GeeArrayList* rygel_video_item_real_get_thumbnails (RygelVisualItem* base) {
	GeeArrayList* result;
	RygelVideoItem* self;
	GeeArrayList* _tmp0_ = NULL;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = self->priv->_thumbnails;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	result = _tmp0_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return result;
#line 1380 "rygel-video-item.c"
}


static void rygel_video_item_real_set_thumbnails (RygelVisualItem* base, GeeArrayList* value) {
	RygelVideoItem* self;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = value;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_object_unref0 (self->priv->_thumbnails);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->priv->_thumbnails = _tmp1_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_notify ((GObject *) self, "thumbnails");
#line 1400 "rygel-video-item.c"
}


static void rygel_video_item_class_init (RygelVideoItemClass * klass) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	rygel_video_item_parent_class = g_type_class_peek_parent (klass);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_type_class_add_private (klass, sizeof (RygelVideoItemPrivate));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	G_OBJECT_CLASS (klass)->constructed = rygel_video_item_real_constructed;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->streamable = rygel_video_item_real_streamable;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_uri = rygel_video_item_real_add_uri;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resources = rygel_video_item_real_add_resources;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->add_resource = rygel_video_item_real_add_resource;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_video_item_real_compare_by_property;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->apply_didl_lite = rygel_video_item_real_apply_didl_lite;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_video_item_real_serialize;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_proxy_resources = rygel_video_item_real_add_proxy_resources;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_video_item_get_property;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_video_item_set_property;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_video_item_finalize;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_AUTHOR, g_param_spec_string ("author", "author", "author", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1435 "rygel-video-item.c"
	/**
	     * The width of the item in pixels.
	     * A value of -1 means that the width is unknown and will not, or did not, appear in DIDL-Lite XML.
	     */
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_WIDTH, g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1442 "rygel-video-item.c"
	/**
	     * The height of the item in pixels.
	     * A value of -1 means that the height is unknown and will not, or did not, appear in DIDL-Lite XML.
	     */
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_HEIGHT, g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1449 "rygel-video-item.c"
	/**
	     * The number of bits per pixel used to represent the video resource.
	     * A value of -1 means that the color depth is unknown and will not, or did not, appear in DIDL-Lite XML.
	     */
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_COLOR_DEPTH, g_param_spec_int ("color-depth", "color-depth", "color-depth", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1456 "rygel-video-item.c"
	/**
	     * Thumbnail pictures to represent the video.
	     */
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_THUMBNAILS, g_param_spec_object ("thumbnails", "thumbnails", "thumbnails", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1462 "rygel-video-item.c"
}


static void rygel_video_item_rygel_visual_item_interface_init (RygelVisualItemIface * iface) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	rygel_video_item_rygel_visual_item_parent_iface = g_type_interface_peek_parent (iface);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	iface->get_width = rygel_video_item_real_get_width;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	iface->set_width = rygel_video_item_real_set_width;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	iface->get_height = rygel_video_item_real_get_height;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	iface->set_height = rygel_video_item_real_set_height;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	iface->get_color_depth = rygel_video_item_real_get_color_depth;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	iface->set_color_depth = rygel_video_item_real_set_color_depth;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	iface->get_thumbnails = rygel_video_item_real_get_thumbnails;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	iface->set_thumbnails = rygel_video_item_real_set_thumbnails;
#line 1485 "rygel-video-item.c"
}


static void rygel_video_item_instance_init (RygelVideoItem * self) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->priv = RYGEL_VIDEO_ITEM_GET_PRIVATE (self);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->priv->_width = -1;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->priv->_height = -1;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->priv->_color_depth = -1;
#line 1498 "rygel-video-item.c"
}


static void rygel_video_item_finalize (GObject* obj) {
	RygelVideoItem * self;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_free0 (self->priv->_author);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_object_unref0 (self->priv->_thumbnails);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_object_unref0 (self->subtitles);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	G_OBJECT_CLASS (rygel_video_item_parent_class)->finalize (obj);
#line 1514 "rygel-video-item.c"
}


/**
 * Represents a video item.
 */
GType rygel_video_item_get_type (void) {
	static volatile gsize rygel_video_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_video_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVideoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_video_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVideoItem), 0, (GInstanceInitFunc) rygel_video_item_instance_init, NULL };
		static const GInterfaceInfo rygel_visual_item_info = { (GInterfaceInitFunc) rygel_video_item_rygel_visual_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_video_item_type_id;
		rygel_video_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelVideoItem", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_video_item_type_id, RYGEL_TYPE_VISUAL_ITEM, &rygel_visual_item_info);
		g_once_init_leave (&rygel_video_item_type_id__volatile, rygel_video_item_type_id);
	}
	return rygel_video_item_type_id__volatile;
}


static void _vala_rygel_video_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelVideoItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	switch (property_id) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_AUTHOR:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		g_value_set_string (value, rygel_video_item_get_author (self));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_WIDTH:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		g_value_set_int (value, rygel_visual_item_get_width ((RygelVisualItem*) self));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_HEIGHT:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		g_value_set_int (value, rygel_visual_item_get_height ((RygelVisualItem*) self));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_COLOR_DEPTH:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		g_value_set_int (value, rygel_visual_item_get_color_depth ((RygelVisualItem*) self));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_THUMBNAILS:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		g_value_set_object (value, rygel_visual_item_get_thumbnails ((RygelVisualItem*) self));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 1570 "rygel-video-item.c"
		default:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 1576 "rygel-video-item.c"
	}
}


static void _vala_rygel_video_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelVideoItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	switch (property_id) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_AUTHOR:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		rygel_video_item_set_author (self, g_value_get_string (value));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_WIDTH:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		rygel_visual_item_set_width ((RygelVisualItem*) self, g_value_get_int (value));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_HEIGHT:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		rygel_visual_item_set_height ((RygelVisualItem*) self, g_value_get_int (value));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_COLOR_DEPTH:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		rygel_visual_item_set_color_depth ((RygelVisualItem*) self, g_value_get_int (value));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_THUMBNAILS:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, g_value_get_object (value));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 1616 "rygel-video-item.c"
		default:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 1622 "rygel-video-item.c"
	}
}



