/* rygel-http-playlist-handler.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-http-playlist-handler.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libsoup/soup.h>
#include <libgupnp-av/gupnp-av.h>
#include <rygel-core.h>


#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_PLAYLIST_DATASOURCE (rygel_playlist_datasource_get_type ())
#define RYGEL_PLAYLIST_DATASOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYLIST_DATASOURCE, RygelPlaylistDatasource))
#define RYGEL_PLAYLIST_DATASOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAYLIST_DATASOURCE, RygelPlaylistDatasourceClass))
#define RYGEL_IS_PLAYLIST_DATASOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYLIST_DATASOURCE))
#define RYGEL_IS_PLAYLIST_DATASOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAYLIST_DATASOURCE))
#define RYGEL_PLAYLIST_DATASOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAYLIST_DATASOURCE, RygelPlaylistDatasourceClass))

typedef struct _RygelPlaylistDatasource RygelPlaylistDatasource;
typedef struct _RygelPlaylistDatasourceClass RygelPlaylistDatasourceClass;
typedef struct _RygelPlaylistDatasourcePrivate RygelPlaylistDatasourcePrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define TYPE_SERIALIZER_TYPE (serializer_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;
typedef struct _RygelPlaylistDatasourceGenerateDataData RygelPlaylistDatasourceGenerateDataData;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;

#define RYGEL_TYPE_HTTP_PLAYLIST_HANDLER (rygel_http_playlist_handler_get_type ())
#define RYGEL_HTTP_PLAYLIST_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandler))
#define RYGEL_HTTP_PLAYLIST_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandlerClass))
#define RYGEL_IS_HTTP_PLAYLIST_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER))
#define RYGEL_IS_HTTP_PLAYLIST_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER))
#define RYGEL_HTTP_PLAYLIST_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandlerClass))

typedef struct _RygelHTTPPlaylistHandler RygelHTTPPlaylistHandler;
typedef struct _RygelHTTPPlaylistHandlerClass RygelHTTPPlaylistHandlerClass;
typedef struct _RygelHTTPPlaylistHandlerPrivate RygelHTTPPlaylistHandlerPrivate;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	void (*start) (RygelDataSource* self, RygelHTTPSeek* offsets, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelPlaylistDatasource {
	GObject parent_instance;
	RygelPlaylistDatasourcePrivate * priv;
};

struct _RygelPlaylistDatasourceClass {
	GObjectClass parent_class;
};

typedef enum  {
	SERIALIZER_TYPE_GENERIC_DIDL,
	SERIALIZER_TYPE_DIDL_S,
	SERIALIZER_TYPE_M3UEXT
} SerializerType;

struct _RygelPlaylistDatasourcePrivate {
	RygelMediaContainer* container;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	RygelHTTPServer* server;
	RygelClientHacks* hacks;
	SerializerType playlist_type;
};

struct _Block5Data {
	int _ref_count_;
	RygelPlaylistDatasource * self;
	RygelHTTPSeek* offsets;
};

typedef enum  {
	RYGEL_DATA_SOURCE_ERROR_GENERAL,
	RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED
} RygelDataSourceError;
#define RYGEL_DATA_SOURCE_ERROR rygel_data_source_error_quark ()
struct _RygelPlaylistDatasourceGenerateDataData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelPlaylistDatasource* self;
	gchar* sort_criteria;
	RygelMediaContainer* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gint count;
	RygelMediaContainer* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	RygelMediaObjects* children;
	RygelMediaContainer* _tmp7_;
	gint _tmp8_;
	const gchar* _tmp9_;
	RygelMediaObjects* _tmp10_;
	RygelMediaObjects* _tmp11_;
	RygelSerializer* serializer;
	SerializerType _tmp12_;
	RygelSerializer* _tmp13_;
	RygelMediaObjects* _tmp14_;
	RygelSerializer* _tmp15_;
	RygelHTTPServer* _tmp16_;
	RygelClientHacks* _tmp17_;
	gchar* xml;
	RygelSerializer* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	guint8* _tmp21_;
	gint _tmp21__length1;
	guint8* _tmp22_;
	gint _tmp22__length1;
	guint8* _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	GError* _tmp25_;
	GError* _tmp26_;
	GError* _error_;
	GError* _tmp27_;
	const gchar* _tmp28_;
	GError* _tmp29_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
	gboolean (*knows_size) (RygelHTTPGetHandler* self, RygelHTTPGet* request);
	RygelHTTPResponse* (*render_body) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
	GUPnPDIDLLiteResource* (*add_resource) (RygelHTTPGetHandler* self, GUPnPDIDLLiteObject* didl_object, RygelHTTPGet* request, GError** error);
};

struct _RygelHTTPPlaylistHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPPlaylistHandlerPrivate * priv;
};

struct _RygelHTTPPlaylistHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPPlaylistHandlerPrivate {
	SerializerType playlist_type;
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_playlist_datasource_parent_class = NULL;
static RygelDataSourceIface* rygel_playlist_datasource_rygel_data_source_parent_iface = NULL;
static gpointer rygel_http_playlist_handler_parent_class = NULL;

GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_playlist_datasource_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType serializer_type_get_type (void) G_GNUC_CONST;
#define RYGEL_PLAYLIST_DATASOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_PLAYLIST_DATASOURCE, RygelPlaylistDatasourcePrivate))
enum  {
	RYGEL_PLAYLIST_DATASOURCE_DUMMY_PROPERTY
};
RygelPlaylistDatasource* rygel_playlist_datasource_new (SerializerType playlist_type, RygelMediaContainer* container, RygelHTTPServer* server, RygelClientHacks* hacks);
RygelPlaylistDatasource* rygel_playlist_datasource_construct (GType object_type, SerializerType playlist_type, RygelMediaContainer* container, RygelHTTPServer* server, RygelClientHacks* hacks);
void rygel_playlist_datasource_generate_data (RygelPlaylistDatasource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_playlist_datasource_generate_data_finish (RygelPlaylistDatasource* self, GAsyncResult* _res_);
static void rygel_playlist_datasource_real_start (RygelDataSource* base, RygelHTTPSeek* offsets, GError** error);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
GQuark rygel_data_source_error_quark (void);
static void ___lambda14_ (Block5Data* _data5_);
void rygel_data_source_start (RygelDataSource* self, RygelHTTPSeek* offsets, GError** error);
static void ____lambda14__rygel_playlist_datasource_data_ready (RygelPlaylistDatasource* _sender, gpointer self);
static gboolean __lambda15_ (RygelPlaylistDatasource* self);
static gboolean ___lambda15__gsource_func (gpointer self);
static void rygel_playlist_datasource_real_freeze (RygelDataSource* base);
static void rygel_playlist_datasource_real_thaw (RygelDataSource* base);
static void rygel_playlist_datasource_real_stop (RygelDataSource* base);
static void rygel_playlist_datasource_generate_data_data_free (gpointer _data);
static gboolean rygel_playlist_datasource_generate_data_co (RygelPlaylistDatasourceGenerateDataData* _data_);
const gchar* rygel_media_container_get_sort_criteria (RygelMediaContainer* self);
gint rygel_media_container_get_child_count (RygelMediaContainer* self);
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_playlist_datasource_generate_data_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_serializer_get_type (void) G_GNUC_CONST;
RygelSerializer* rygel_serializer_new (SerializerType type);
RygelSerializer* rygel_serializer_construct (GType object_type, SerializerType type);
void rygel_media_objects_serialize (RygelMediaObjects* self, RygelSerializer* serializer, RygelHTTPServer* http_server, RygelClientHacks* hacks, GError** error);
gchar* rygel_serializer_get_string (RygelSerializer* self);
static guint8* _vala_array_dup1 (guint8* self, int length);
static void rygel_playlist_datasource_finalize (GObject* obj);
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_request_error_quark (void);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
GType rygel_http_playlist_handler_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_PLAYLIST_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandlerPrivate))
enum  {
	RYGEL_HTTP_PLAYLIST_HANDLER_DUMMY_PROPERTY
};
gboolean rygel_http_playlist_handler_is_supported (const gchar* playlist_format);
RygelHTTPPlaylistHandler* rygel_http_playlist_handler_new (const gchar* playlist_format, GCancellable* cancellable);
RygelHTTPPlaylistHandler* rygel_http_playlist_handler_construct (GType object_type, const gchar* playlist_format, GCancellable* cancellable);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type);
void rygel_http_get_handler_set_cancellable (RygelHTTPGetHandler* self, GCancellable* value);
static void rygel_http_playlist_handler_real_add_response_headers (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
static RygelHTTPResponse* rygel_http_playlist_handler_real_render_body (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error);
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, RygelDataSource* src, GError** error);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, RygelDataSource* src, GError** error);
static GUPnPDIDLLiteResource* rygel_http_playlist_handler_real_add_resource (RygelHTTPGetHandler* base, GUPnPDIDLLiteObject* didl_object, RygelHTTPGet* request, GError** error);
gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
GUPnPDIDLLiteResource* rygel_media_object_add_resource (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
static void rygel_http_playlist_handler_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	return self ? g_object_ref (self) : NULL;
#line 431 "rygel-http-playlist-handler.c"
}


RygelPlaylistDatasource* rygel_playlist_datasource_construct (GType object_type, SerializerType playlist_type, RygelMediaContainer* container, RygelHTTPServer* server, RygelClientHacks* hacks) {
	RygelPlaylistDatasource * self = NULL;
	SerializerType _tmp0_ = 0;
	RygelMediaContainer* _tmp1_ = NULL;
	RygelMediaContainer* _tmp2_ = NULL;
	RygelHTTPServer* _tmp3_ = NULL;
	RygelHTTPServer* _tmp4_ = NULL;
	RygelClientHacks* _tmp5_ = NULL;
	RygelClientHacks* _tmp6_ = NULL;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_return_val_if_fail (container != NULL, NULL);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	self = (RygelPlaylistDatasource*) g_object_new (object_type, NULL);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp0_ = playlist_type;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	self->priv->playlist_type = _tmp0_;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp1_ = container;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_g_object_unref0 (self->priv->container);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	self->priv->container = _tmp2_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp3_ = server;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_g_object_unref0 (self->priv->server);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	self->priv->server = _tmp4_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp5_ = hacks;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_g_object_unref0 (self->priv->hacks);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	self->priv->hacks = _tmp6_;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	rygel_playlist_datasource_generate_data (self, NULL, NULL);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	return self;
#line 482 "rygel-http-playlist-handler.c"
}


RygelPlaylistDatasource* rygel_playlist_datasource_new (SerializerType playlist_type, RygelMediaContainer* container, RygelHTTPServer* server, RygelClientHacks* hacks) {
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	return rygel_playlist_datasource_construct (RYGEL_TYPE_PLAYLIST_DATASOURCE, playlist_type, container, server, hacks);
#line 489 "rygel-http-playlist-handler.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	return _data5_;
#line 498 "rygel-http-playlist-handler.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 507 "rygel-http-playlist-handler.c"
		RygelPlaylistDatasource * self;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		self = _data5_->self;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_g_object_unref0 (_data5_->offsets);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_g_object_unref0 (self);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		g_slice_free (Block5Data, _data5_);
#line 517 "rygel-http-playlist-handler.c"
	}
}


static void ___lambda14_ (Block5Data* _data5_) {
	RygelPlaylistDatasource * self;
	GError * _inner_error_ = NULL;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	self = _data5_->self;
#line 527 "rygel-http-playlist-handler.c"
	{
		RygelHTTPSeek* _tmp0_ = NULL;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp0_ = _data5_->offsets;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		rygel_data_source_start ((RygelDataSource*) self, _tmp0_, &_inner_error_);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		if (_inner_error_ != NULL) {
#line 536 "rygel-http-playlist-handler.c"
			goto __catch32_g_error;
		}
	}
	goto __finally32;
	__catch32_g_error:
	{
		GError* _error_ = NULL;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_error_ = _inner_error_;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_inner_error_ = NULL;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_g_error_free0 (_error_);
#line 550 "rygel-http-playlist-handler.c"
	}
	__finally32:
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	if (_inner_error_ != NULL) {
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		g_clear_error (&_inner_error_);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		return;
#line 561 "rygel-http-playlist-handler.c"
	}
}


static void ____lambda14__rygel_playlist_datasource_data_ready (RygelPlaylistDatasource* _sender, gpointer self) {
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	___lambda14_ (self);
#line 569 "rygel-http-playlist-handler.c"
}


static gboolean __lambda15_ (RygelPlaylistDatasource* self) {
	gboolean result = FALSE;
	guint8* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp0_ = self->priv->data;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp0__length1 = self->priv->data_length1;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_signal_emit_by_name ((RygelDataSource*) self, "data-available", _tmp0_, _tmp0__length1);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_signal_emit_by_name ((RygelDataSource*) self, "done");
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	result = FALSE;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	return result;
#line 589 "rygel-http-playlist-handler.c"
}


static gboolean ___lambda15__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda15_ (self);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	return result;
#line 598 "rygel-http-playlist-handler.c"
}


static void rygel_playlist_datasource_real_start (RygelDataSource* base, RygelHTTPSeek* offsets, GError** error) {
	RygelPlaylistDatasource * self;
	Block5Data* _data5_;
	RygelHTTPSeek* _tmp0_ = NULL;
	RygelHTTPSeek* _tmp1_ = NULL;
	RygelHTTPSeek* _tmp2_ = NULL;
	guint8* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GError * _inner_error_ = NULL;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	self = (RygelPlaylistDatasource*) base;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_data5_->_ref_count_ = 1;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_data5_->self = g_object_ref (self);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp0_ = offsets;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_g_object_unref0 (_data5_->offsets);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_data5_->offsets = _tmp1_;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp2_ = _data5_->offsets;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	if (_tmp2_ != NULL) {
#line 631 "rygel-http-playlist-handler.c"
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp3_ = _ ("Seeking not supported");
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp4_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _tmp3_);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_inner_error_ = _tmp4_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		g_propagate_error (error, _inner_error_);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		block5_data_unref (_data5_);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data5_ = NULL;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		return;
#line 648 "rygel-http-playlist-handler.c"
	}
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp5_ = self->priv->data;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp5__length1 = self->priv->data_length1;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	if (_tmp5_ == NULL) {
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		g_signal_connect_data (self, "data-ready", (GCallback) ____lambda14__rygel_playlist_datasource_data_ready, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		block5_data_unref (_data5_);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data5_ = NULL;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		return;
#line 664 "rygel-http-playlist-handler.c"
	}
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda15__gsource_func, g_object_ref (self), g_object_unref);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	block5_data_unref (_data5_);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_data5_ = NULL;
#line 672 "rygel-http-playlist-handler.c"
}


static void rygel_playlist_datasource_real_freeze (RygelDataSource* base) {
	RygelPlaylistDatasource * self;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	self = (RygelPlaylistDatasource*) base;
#line 680 "rygel-http-playlist-handler.c"
}


static void rygel_playlist_datasource_real_thaw (RygelDataSource* base) {
	RygelPlaylistDatasource * self;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	self = (RygelPlaylistDatasource*) base;
#line 688 "rygel-http-playlist-handler.c"
}


static void rygel_playlist_datasource_real_stop (RygelDataSource* base) {
	RygelPlaylistDatasource * self;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	self = (RygelPlaylistDatasource*) base;
#line 696 "rygel-http-playlist-handler.c"
}


static void rygel_playlist_datasource_generate_data_data_free (gpointer _data) {
	RygelPlaylistDatasourceGenerateDataData* _data_;
	_data_ = _data;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_g_object_unref0 (_data_->self);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_slice_free (RygelPlaylistDatasourceGenerateDataData, _data_);
#line 707 "rygel-http-playlist-handler.c"
}


void rygel_playlist_datasource_generate_data (RygelPlaylistDatasource* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelPlaylistDatasourceGenerateDataData* _data_;
	RygelPlaylistDatasource* _tmp0_ = NULL;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_data_ = g_slice_new0 (RygelPlaylistDatasourceGenerateDataData);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_playlist_datasource_generate_data);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_playlist_datasource_generate_data_data_free);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_data_->self = _tmp0_;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	rygel_playlist_datasource_generate_data_co (_data_);
#line 726 "rygel-http-playlist-handler.c"
}


void rygel_playlist_datasource_generate_data_finish (RygelPlaylistDatasource* self, GAsyncResult* _res_) {
	RygelPlaylistDatasourceGenerateDataData* _data_;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 734 "rygel-http-playlist-handler.c"
}


static void rygel_playlist_datasource_generate_data_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelPlaylistDatasourceGenerateDataData* _data_;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_data_ = _user_data_;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_data_->_source_object_ = source_object;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_data_->_res_ = _res_;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	rygel_playlist_datasource_generate_data_co (_data_);
#line 748 "rygel-http-playlist-handler.c"
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
#line 1259 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1260 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1260 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1260 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1261 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1261 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1261 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1261 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1262 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1262 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1262 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1262 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1262 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1262 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 792 "rygel-http-playlist-handler.c"
	}
#line 1262 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1262 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 798 "rygel-http-playlist-handler.c"
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 805 "rygel-http-playlist-handler.c"
}


static gboolean rygel_playlist_datasource_generate_data_co (RygelPlaylistDatasourceGenerateDataData* _data_) {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	switch (_data_->_state_) {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		case 0:
#line 814 "rygel-http-playlist-handler.c"
		goto _state_0;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		case 1:
#line 818 "rygel-http-playlist-handler.c"
		goto _state_1;
		default:
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		g_assert_not_reached ();
#line 823 "rygel-http-playlist-handler.c"
	}
	_state_0:
	{
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp0_ = NULL;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp0_ = _data_->self->priv->container;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp1_ = NULL;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp1_ = rygel_media_container_get_sort_criteria (_data_->_tmp0_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp2_ = NULL;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp2_ = _data_->_tmp1_;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp3_ = NULL;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->sort_criteria = _data_->_tmp3_;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp4_ = NULL;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp4_ = _data_->self->priv->container;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp5_ = 0;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp5_ = rygel_media_container_get_child_count (_data_->_tmp4_);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp6_ = 0;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->count = _data_->_tmp6_;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp7_ = NULL;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp7_ = _data_->self->priv->container;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp8_ = 0;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp8_ = _data_->count;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp9_ = NULL;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp9_ = _data_->sort_criteria;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_state_ = 1;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		rygel_media_container_get_children (_data_->_tmp7_, (guint) 0, (guint) _data_->_tmp8_, _data_->_tmp9_, NULL, rygel_playlist_datasource_generate_data_ready, _data_);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		return FALSE;
#line 877 "rygel-http-playlist-handler.c"
		_state_1:
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp10_ = NULL;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp10_ = rygel_media_container_get_children_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->children = _data_->_tmp10_;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		if (_data_->_inner_error_ != NULL) {
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_g_free0 (_data_->sort_criteria);
#line 889 "rygel-http-playlist-handler.c"
			goto __catch33_g_error;
		}
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp11_ = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp11_ = _data_->children;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		if (_data_->_tmp11_ != NULL) {
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp12_ = 0;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp12_ = _data_->self->priv->playlist_type;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp13_ = NULL;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp13_ = rygel_serializer_new (_data_->_tmp12_);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->serializer = _data_->_tmp13_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp14_ = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp14_ = _data_->children;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp15_ = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp15_ = _data_->serializer;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp16_ = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp16_ = _data_->self->priv->server;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp17_ = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp17_ = _data_->self->priv->hacks;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			rygel_media_objects_serialize (_data_->_tmp14_, _data_->_tmp15_, _data_->_tmp16_, _data_->_tmp17_, &_data_->_inner_error_);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			if (_data_->_inner_error_ != NULL) {
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
				_g_object_unref0 (_data_->serializer);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
				_g_object_unref0 (_data_->children);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
				_g_free0 (_data_->sort_criteria);
#line 934 "rygel-http-playlist-handler.c"
				goto __catch33_g_error;
			}
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp18_ = NULL;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp18_ = _data_->serializer;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp19_ = NULL;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp19_ = rygel_serializer_get_string (_data_->_tmp18_);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->xml = _data_->_tmp19_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp20_ = NULL;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp20_ = _data_->xml;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp21_ = NULL;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp21__length1 = 0;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp21_ = string_get_data (_data_->_tmp20_, &_data_->_tmp21__length1);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp22_ = NULL;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp22__length1 = 0;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp22_ = _data_->_tmp21_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp22__length1 = _data_->_tmp21__length1;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp23_ = NULL;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp23__length1 = 0;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp23_ = (_data_->_tmp22_ != NULL) ? _vala_array_dup1 (_data_->_tmp22_, _data_->_tmp22__length1) : ((gpointer) _data_->_tmp22_);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp23__length1 = _data_->_tmp22__length1;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->self->priv->data = (g_free (_data_->self->priv->data), NULL);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->self->priv->data = _data_->_tmp23_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->self->priv->data_length1 = _data_->_tmp23__length1;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->self->priv->_data_size_ = _data_->self->priv->data_length1;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			g_signal_emit_by_name (_data_->self, "data-ready");
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_g_free0 (_data_->xml);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_g_object_unref0 (_data_->serializer);
#line 987 "rygel-http-playlist-handler.c"
		} else {
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp24_ = NULL;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp24_ = _ ("Failed to generate playlist");
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp25_ = NULL;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp25_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_GENERAL, _data_->_tmp24_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp26_ = NULL;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_data_->_tmp26_ = _data_->_tmp25_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			g_signal_emit_by_name ((RygelDataSource*) _data_->self, "error", _data_->_tmp26_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_g_error_free0 (_data_->_tmp26_);
#line 1005 "rygel-http-playlist-handler.c"
		}
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_g_object_unref0 (_data_->children);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_g_free0 (_data_->sort_criteria);
#line 1011 "rygel-http-playlist-handler.c"
	}
	goto __finally33;
	__catch33_g_error:
	{
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_inner_error_ = NULL;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp27_ = NULL;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp27_ = _data_->_error_;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp28_ = NULL;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp28_ = _data_->_tmp27_->message;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		g_warning ("rygel-http-playlist-handler.vala:100: Could not generate playlist: %s", _data_->_tmp28_);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp29_ = NULL;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_data_->_tmp29_ = _data_->_error_;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		g_signal_emit_by_name ((RygelDataSource*) _data_->self, "error", _data_->_tmp29_);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_g_error_free0 (_data_->_error_);
#line 1038 "rygel-http-playlist-handler.c"
	}
	__finally33:
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	if (_data_->_inner_error_ != NULL) {
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		g_clear_error (&_data_->_inner_error_);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		return FALSE;
#line 1049 "rygel-http-playlist-handler.c"
	}
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	if (_data_->_state_ == 0) {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1055 "rygel-http-playlist-handler.c"
	} else {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1059 "rygel-http-playlist-handler.c"
	}
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_object_unref (_data_->_async_result);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	return FALSE;
#line 1065 "rygel-http-playlist-handler.c"
}


static void rygel_playlist_datasource_class_init (RygelPlaylistDatasourceClass * klass) {
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	rygel_playlist_datasource_parent_class = g_type_class_peek_parent (klass);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_type_class_add_private (klass, sizeof (RygelPlaylistDatasourcePrivate));
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_playlist_datasource_finalize;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_signal_new ("data_ready", RYGEL_TYPE_PLAYLIST_DATASOURCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1078 "rygel-http-playlist-handler.c"
}


static void rygel_playlist_datasource_rygel_data_source_interface_init (RygelDataSourceIface * iface) {
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	rygel_playlist_datasource_rygel_data_source_parent_iface = g_type_interface_peek_parent (iface);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	iface->start = (void (*)(RygelDataSource*, RygelHTTPSeek*, GError**)) rygel_playlist_datasource_real_start;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	iface->freeze = (void (*)(RygelDataSource*)) rygel_playlist_datasource_real_freeze;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	iface->thaw = (void (*)(RygelDataSource*)) rygel_playlist_datasource_real_thaw;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	iface->stop = (void (*)(RygelDataSource*)) rygel_playlist_datasource_real_stop;
#line 1093 "rygel-http-playlist-handler.c"
}


static void rygel_playlist_datasource_instance_init (RygelPlaylistDatasource * self) {
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	self->priv = RYGEL_PLAYLIST_DATASOURCE_GET_PRIVATE (self);
#line 1100 "rygel-http-playlist-handler.c"
}


static void rygel_playlist_datasource_finalize (GObject* obj) {
	RygelPlaylistDatasource * self;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLAYLIST_DATASOURCE, RygelPlaylistDatasource);
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_g_object_unref0 (self->priv->container);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	self->priv->data = (g_free (self->priv->data), NULL);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_g_object_unref0 (self->priv->server);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_g_object_unref0 (self->priv->hacks);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	G_OBJECT_CLASS (rygel_playlist_datasource_parent_class)->finalize (obj);
#line 1118 "rygel-http-playlist-handler.c"
}


/**
 * Implementation of RygelDataSource to serve generated playlists to a client.
 */
GType rygel_playlist_datasource_get_type (void) {
	static volatile gsize rygel_playlist_datasource_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_playlist_datasource_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlaylistDatasourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_playlist_datasource_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaylistDatasource), 0, (GInstanceInitFunc) rygel_playlist_datasource_instance_init, NULL };
		static const GInterfaceInfo rygel_data_source_info = { (GInterfaceInitFunc) rygel_playlist_datasource_rygel_data_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_playlist_datasource_type_id;
		rygel_playlist_datasource_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPlaylistDatasource", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_playlist_datasource_type_id, RYGEL_TYPE_DATA_SOURCE, &rygel_data_source_info);
		g_once_init_leave (&rygel_playlist_datasource_type_id__volatile, rygel_playlist_datasource_type_id);
	}
	return rygel_playlist_datasource_type_id__volatile;
}


gboolean rygel_http_playlist_handler_is_supported (const gchar* playlist_format) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_return_val_if_fail (playlist_format != NULL, FALSE);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp1_ = playlist_format;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	if (g_strcmp0 (_tmp1_, "DIDL_S") == 0) {
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp0_ = TRUE;
#line 1152 "rygel-http-playlist-handler.c"
	} else {
		const gchar* _tmp2_ = NULL;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp2_ = playlist_format;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "M3U") == 0;
#line 1159 "rygel-http-playlist-handler.c"
	}
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp3_ = _tmp0_;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	result = _tmp3_;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	return result;
#line 1167 "rygel-http-playlist-handler.c"
}


RygelHTTPPlaylistHandler* rygel_http_playlist_handler_construct (GType object_type, const gchar* playlist_format, GCancellable* cancellable) {
	RygelHTTPPlaylistHandler * self = NULL;
	const gchar* _tmp0_ = NULL;
	GCancellable* _tmp2_ = NULL;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_return_val_if_fail (playlist_format != NULL, NULL);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	self = (RygelHTTPPlaylistHandler*) rygel_http_get_handler_construct (object_type);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp0_ = playlist_format;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	if (g_strcmp0 (_tmp0_, "DIDL_S") == 0) {
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		self->priv->playlist_type = SERIALIZER_TYPE_DIDL_S;
#line 1185 "rygel-http-playlist-handler.c"
	} else {
		const gchar* _tmp1_ = NULL;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp1_ = playlist_format;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		if (g_strcmp0 (_tmp1_, "M3U") == 0) {
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			self->priv->playlist_type = SERIALIZER_TYPE_M3UEXT;
#line 1194 "rygel-http-playlist-handler.c"
		}
	}
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp2_ = cancellable;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	rygel_http_get_handler_set_cancellable ((RygelHTTPGetHandler*) self, _tmp2_);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	return self;
#line 1203 "rygel-http-playlist-handler.c"
}


RygelHTTPPlaylistHandler* rygel_http_playlist_handler_new (const gchar* playlist_format, GCancellable* cancellable) {
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	return rygel_http_playlist_handler_construct (RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, playlist_format, cancellable);
#line 1210 "rygel-http-playlist-handler.c"
}


static void rygel_http_playlist_handler_real_add_response_headers (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error) {
	RygelHTTPPlaylistHandler * self;
	SerializerType _tmp0_ = 0;
	RygelHTTPGet* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	self = (RygelHTTPPlaylistHandler*) base;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_return_if_fail (request != NULL);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp0_ = self->priv->playlist_type;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	switch (_tmp0_) {
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		case SERIALIZER_TYPE_DIDL_S:
#line 1229 "rygel-http-playlist-handler.c"
		{
			RygelHTTPGet* _tmp1_ = NULL;
			SoupMessage* _tmp2_ = NULL;
			SoupMessageHeaders* _tmp3_ = NULL;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_tmp1_ = request;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_tmp2_ = ((RygelHTTPRequest*) _tmp1_)->msg;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_tmp3_ = _tmp2_->response_headers;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			soup_message_headers_append (_tmp3_, "Content-Type", "text/xml");
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			break;
#line 1244 "rygel-http-playlist-handler.c"
		}
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		case SERIALIZER_TYPE_M3UEXT:
#line 1248 "rygel-http-playlist-handler.c"
		{
			RygelHTTPGet* _tmp4_ = NULL;
			SoupMessage* _tmp5_ = NULL;
			SoupMessageHeaders* _tmp6_ = NULL;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_tmp4_ = request;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_tmp5_ = ((RygelHTTPRequest*) _tmp4_)->msg;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_tmp6_ = _tmp5_->response_headers;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			soup_message_headers_append (_tmp6_, "ContentType", "audio/x-mpegurl");
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			break;
#line 1263 "rygel-http-playlist-handler.c"
		}
		default:
		{
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			g_assert_not_reached ();
#line 1269 "rygel-http-playlist-handler.c"
		}
	}
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp7_ = request;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	RYGEL_HTTP_GET_HANDLER_CLASS (rygel_http_playlist_handler_parent_class)->add_response_headers (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler), _tmp7_, &_inner_error_);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	if (_inner_error_ != NULL) {
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			g_propagate_error (error, _inner_error_);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			return;
#line 1284 "rygel-http-playlist-handler.c"
		} else {
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			g_clear_error (&_inner_error_);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			return;
#line 1292 "rygel-http-playlist-handler.c"
		}
	}
}


static RygelHTTPResponse* rygel_http_playlist_handler_real_render_body (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error) {
	RygelHTTPPlaylistHandler * self;
	RygelHTTPResponse* result = NULL;
	GError * _inner_error_ = NULL;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	self = (RygelHTTPPlaylistHandler*) base;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_return_val_if_fail (request != NULL, NULL);
#line 1306 "rygel-http-playlist-handler.c"
	{
		RygelPlaylistDatasource* source = NULL;
		SerializerType _tmp0_ = 0;
		RygelHTTPGet* _tmp1_ = NULL;
		RygelMediaObject* _tmp2_ = NULL;
		RygelHTTPGet* _tmp3_ = NULL;
		RygelHTTPServer* _tmp4_ = NULL;
		RygelHTTPGet* _tmp5_ = NULL;
		RygelClientHacks* _tmp6_ = NULL;
		RygelPlaylistDatasource* _tmp7_ = NULL;
		RygelHTTPResponse* _tmp8_ = NULL;
		RygelHTTPGet* _tmp9_ = NULL;
		RygelPlaylistDatasource* _tmp10_ = NULL;
		RygelHTTPResponse* _tmp11_ = NULL;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp0_ = self->priv->playlist_type;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp1_ = request;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp2_ = ((RygelHTTPRequest*) _tmp1_)->object;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp3_ = request;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp4_ = ((RygelHTTPRequest*) _tmp3_)->http_server;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp5_ = request;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp6_ = ((RygelHTTPRequest*) _tmp5_)->hack;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp7_ = rygel_playlist_datasource_new (_tmp0_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp2_) : NULL, _tmp4_, _tmp6_);
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		source = _tmp7_;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp9_ = request;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp10_ = source;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp11_ = rygel_http_response_new (_tmp9_, (RygelHTTPGetHandler*) self, (RygelDataSource*) _tmp10_, &_inner_error_);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp8_ = _tmp11_;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		if (_inner_error_ != NULL) {
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
			_g_object_unref0 (source);
#line 1351 "rygel-http-playlist-handler.c"
			goto __catch34_g_error;
		}
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		result = _tmp8_;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_g_object_unref0 (source);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		return result;
#line 1360 "rygel-http-playlist-handler.c"
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_error_ = _inner_error_;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_inner_error_ = NULL;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp12_ = _error_;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp13_ = _tmp12_->message;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp14_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp13_);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_inner_error_ = _tmp14_;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_g_error_free0 (_error_);
#line 1383 "rygel-http-playlist-handler.c"
		goto __finally34;
	}
	__finally34:
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		g_propagate_error (error, _inner_error_);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		return NULL;
#line 1393 "rygel-http-playlist-handler.c"
	} else {
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		g_clear_error (&_inner_error_);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		return NULL;
#line 1401 "rygel-http-playlist-handler.c"
	}
}


static GUPnPDIDLLiteResource* rygel_http_playlist_handler_real_add_resource (RygelHTTPGetHandler* base, GUPnPDIDLLiteObject* didl_object, RygelHTTPGet* request, GError** error) {
	RygelHTTPPlaylistHandler * self;
	GUPnPDIDLLiteResource* result = NULL;
	gchar* protocol = NULL;
	RygelHTTPGet* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	self = (RygelHTTPPlaylistHandler*) base;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_return_val_if_fail (didl_object != NULL, NULL);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_return_val_if_fail (request != NULL, NULL);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp0_ = request;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->http_server;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_tmp2_ = rygel_transcode_manager_get_protocol ((RygelTranscodeManager*) _tmp1_);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	protocol = _tmp2_;
#line 1428 "rygel-http-playlist-handler.c"
	{
		GUPnPDIDLLiteResource* _tmp3_ = NULL;
		RygelHTTPGet* _tmp4_ = NULL;
		RygelMediaObject* _tmp5_ = NULL;
		GUPnPDIDLLiteObject* _tmp6_ = NULL;
		GUPnPDIDLLiteResource* _tmp7_ = NULL;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp4_ = request;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp5_ = ((RygelHTTPRequest*) _tmp4_)->object;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp6_ = didl_object;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp7_ = rygel_media_object_add_resource (_tmp5_, _tmp6_, NULL, protocol, NULL, &_inner_error_);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp3_ = _tmp7_;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		if (_inner_error_ != NULL) {
#line 1447 "rygel-http-playlist-handler.c"
			goto __catch35_g_error;
		}
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		result = _tmp3_;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_g_free0 (protocol);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		return result;
#line 1456 "rygel-http-playlist-handler.c"
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError* _error_ = NULL;
		gpointer _tmp8_ = NULL;
		GUPnPDIDLLiteResource* _tmp9_ = NULL;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_error_ = _inner_error_;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_inner_error_ = NULL;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp8_ = NULL;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gupnp_didl_lite_resource_get_type ()) ? ((GUPnPDIDLLiteResource*) _tmp8_) : NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		result = _tmp9_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_g_error_free0 (_error_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		_g_free0 (protocol);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
		return result;
#line 1480 "rygel-http-playlist-handler.c"
	}
	__finally35:
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	_g_free0 (protocol);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_clear_error (&_inner_error_);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	return NULL;
#line 1491 "rygel-http-playlist-handler.c"
}


static void rygel_http_playlist_handler_class_init (RygelHTTPPlaylistHandlerClass * klass) {
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	rygel_http_playlist_handler_parent_class = g_type_class_peek_parent (klass);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPPlaylistHandlerPrivate));
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	RYGEL_HTTP_GET_HANDLER_CLASS (klass)->add_response_headers = rygel_http_playlist_handler_real_add_response_headers;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	RYGEL_HTTP_GET_HANDLER_CLASS (klass)->render_body = rygel_http_playlist_handler_real_render_body;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	RYGEL_HTTP_GET_HANDLER_CLASS (klass)->add_resource = rygel_http_playlist_handler_real_add_resource;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_playlist_handler_finalize;
#line 1508 "rygel-http-playlist-handler.c"
}


static void rygel_http_playlist_handler_instance_init (RygelHTTPPlaylistHandler * self) {
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	self->priv = RYGEL_HTTP_PLAYLIST_HANDLER_GET_PRIVATE (self);
#line 1515 "rygel-http-playlist-handler.c"
}


static void rygel_http_playlist_handler_finalize (GObject* obj) {
	RygelHTTPPlaylistHandler * self;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandler);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-playlist-handler.vala"
	G_OBJECT_CLASS (rygel_http_playlist_handler_parent_class)->finalize (obj);
#line 1525 "rygel-http-playlist-handler.c"
}


/**
 * RygelHTTPPlaylistHandler implements a special handler for generating XML
 * playlists (DIDL_S format as defined by DLNA) on-the-fly.
 */
GType rygel_http_playlist_handler_get_type (void) {
	static volatile gsize rygel_http_playlist_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_playlist_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPPlaylistHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_playlist_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPPlaylistHandler), 0, (GInstanceInitFunc) rygel_http_playlist_handler_instance_init, NULL };
		GType rygel_http_playlist_handler_type_id;
		rygel_http_playlist_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPPlaylistHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_playlist_handler_type_id__volatile, rygel_http_playlist_handler_type_id);
	}
	return rygel_http_playlist_handler_type_id__volatile;
}



