/* rygel-media-server-plugin.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-media-server-plugin.vala, do not modify */

/*
 * Copyright (C) 2008,2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_MEDIA_SERVER_PLUGIN (rygel_media_server_plugin_get_type ())
#define RYGEL_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin))
#define RYGEL_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_MEDIA_SERVER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))

typedef struct _RygelMediaServerPlugin RygelMediaServerPlugin;
typedef struct _RygelMediaServerPluginClass RygelMediaServerPluginClass;
typedef struct _RygelMediaServerPluginPrivate RygelMediaServerPluginPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_DLNA_PROFILE (rygel_dlna_profile_get_type ())
#define RYGEL_DLNA_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DLNA_PROFILE, RygelDLNAProfile))
#define RYGEL_DLNA_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DLNA_PROFILE, RygelDLNAProfileClass))
#define RYGEL_IS_DLNA_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DLNA_PROFILE))
#define RYGEL_IS_DLNA_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DLNA_PROFILE))
#define RYGEL_DLNA_PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DLNA_PROFILE, RygelDLNAProfileClass))

typedef struct _RygelDLNAProfile RygelDLNAProfile;
typedef struct _RygelDLNAProfileClass RygelDLNAProfileClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__rygel_dlna_profile_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__rygel_dlna_profile_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;

#define RYGEL_TYPE_SOURCE_CONNECTION_MANAGER (rygel_source_connection_manager_get_type ())
#define RYGEL_SOURCE_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER, RygelSourceConnectionManager))
#define RYGEL_SOURCE_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER, RygelSourceConnectionManagerClass))
#define RYGEL_IS_SOURCE_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER))
#define RYGEL_IS_SOURCE_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER))
#define RYGEL_SOURCE_CONNECTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER, RygelSourceConnectionManagerClass))

typedef struct _RygelSourceConnectionManager RygelSourceConnectionManager;
typedef struct _RygelSourceConnectionManagerClass RygelSourceConnectionManagerClass;
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR (rygel_media_receiver_registrar_get_type ())
#define RYGEL_MEDIA_RECEIVER_REGISTRAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR, RygelMediaReceiverRegistrar))
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR, RygelMediaReceiverRegistrarClass))
#define RYGEL_IS_MEDIA_RECEIVER_REGISTRAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR))
#define RYGEL_IS_MEDIA_RECEIVER_REGISTRAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR))
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR, RygelMediaReceiverRegistrarClass))

typedef struct _RygelMediaReceiverRegistrar RygelMediaReceiverRegistrar;
typedef struct _RygelMediaReceiverRegistrarClass RygelMediaReceiverRegistrarClass;

#define RYGEL_TYPE_OBJECT_EVENT_TYPE (rygel_object_event_type_get_type ())

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;
#define _rygel_dlna_profile_unref0(var) ((var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_ENGINE (rygel_media_engine_get_type ())
#define RYGEL_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngine))
#define RYGEL_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))
#define RYGEL_IS_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_IS_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_MEDIA_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))

typedef struct _RygelMediaEngine RygelMediaEngine;
typedef struct _RygelMediaEngineClass RygelMediaEngineClass;

struct _RygelMediaServerPlugin {
	RygelPlugin parent_instance;
	RygelMediaServerPluginPrivate * priv;
};

struct _RygelMediaServerPluginClass {
	RygelPluginClass parent_class;
};

struct _RygelMediaServerPluginPrivate {
	RygelMediaContainer* _root_container;
	GList* _upload_profiles;
	GList* _supported_profiles;
};

typedef enum  {
	RYGEL_OBJECT_EVENT_TYPE_ADDED = 0,
	RYGEL_OBJECT_EVENT_TYPE_MODIFIED = 1,
	RYGEL_OBJECT_EVENT_TYPE_DELETED = 2
} RygelObjectEventType;

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()

static gpointer rygel_media_server_plugin_parent_class = NULL;

GType rygel_media_server_plugin_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gpointer rygel_dlna_profile_ref (gpointer instance);
void rygel_dlna_profile_unref (gpointer instance);
GParamSpec* rygel_param_spec_dlna_profile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_dlna_profile (GValue* value, gpointer v_object);
void rygel_value_take_dlna_profile (GValue* value, gpointer v_object);
gpointer rygel_value_get_dlna_profile (const GValue* value);
GType rygel_dlna_profile_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_SERVER_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginPrivate))
enum  {
	RYGEL_MEDIA_SERVER_PLUGIN_DUMMY_PROPERTY,
	RYGEL_MEDIA_SERVER_PLUGIN_ROOT_CONTAINER,
	RYGEL_MEDIA_SERVER_PLUGIN_UPLOAD_PROFILES,
	RYGEL_MEDIA_SERVER_PLUGIN_SUPPORTED_PROFILES
};
static void _rygel_dlna_profile_unref0_ (gpointer var);
static void _g_list_free__rygel_dlna_profile_unref0_ (GList* self);
#define RYGEL_MEDIA_SERVER_PLUGIN_DMS "urn:schemas-upnp-org:device:MediaServer"
#define RYGEL_MEDIA_SERVER_PLUGIN_MEDIA_SERVER_DESC_PATH DATA_DIR "/xml/MediaServer3.xml"
RygelMediaServerPlugin* rygel_media_server_plugin_construct (GType object_type, RygelMediaContainer* root_container, const gchar* name, const gchar* description, RygelPluginCapabilities capabilities);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
static void rygel_media_server_plugin_real_constructed (GObject* base);
#define RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH_NO_TRACK "xml/ContentDirectory-NoTrack.xml"
#define RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH "xml/ContentDirectory.xml"
#define RYGEL_CONTENT_DIRECTORY_UPNP_ID "urn:upnp-org:serviceId:ContentDirectory"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE "urn:schemas-upnp-org:service:ContentDirectory:3"
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
GType rygel_source_connection_manager_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_ID "urn:microsoft-com:serviceId:X_MS_MediaReceiverRegistrar"
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE "urn:microsoft-com:service:X_MS_MediaReceiverRegistrar:1"
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_DESCRIPTION_PATH "xml/X_MS_MediaReceiverRegistrar1.xml"
GType rygel_media_receiver_registrar_get_type (void) G_GNUC_CONST;
RygelMediaContainer* rygel_media_server_plugin_get_root_container (RygelMediaServerPlugin* self);
gint rygel_media_container_get_child_count (RygelMediaContainer* self);
GType rygel_object_event_type_get_type (void) G_GNUC_CONST;
static void rygel_media_server_plugin_on_container_updated (RygelMediaServerPlugin* self, RygelMediaContainer* root_container, RygelMediaContainer* updated, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static void _rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
static void rygel_media_server_plugin_real_apply_hacks (RygelPlugin* base, RygelRootDevice* device, const gchar* description_path, GError** error);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
GQuark rygel_client_hacks_error_quark (void);
RygelXBoxHacks* rygel_xbox_hacks_new (SoupMessage* message, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type, SoupMessage* message, GError** error);
void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const gchar* template_path, GError** error);
static void rygel_media_server_plugin_set_root_container (RygelMediaServerPlugin* self, RygelMediaContainer* value);
GList* rygel_media_server_plugin_get_upload_profiles (RygelMediaServerPlugin* self);
GList* rygel_media_server_plugin_get_supported_profiles (RygelMediaServerPlugin* self);
void rygel_media_server_plugin_set_upload_profiles (RygelMediaServerPlugin* self, GList* value);
GType rygel_media_engine_get_type (void) G_GNUC_CONST;
RygelMediaEngine* rygel_media_engine_get_default (void);
GList* rygel_media_engine_get_dlna_profiles (RygelMediaEngine* self);
void rygel_media_server_plugin_set_supported_profiles (RygelMediaServerPlugin* self, GList* value);
static void rygel_media_server_plugin_finalize (GObject* obj);
static void _vala_rygel_media_server_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_server_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _rygel_dlna_profile_unref0_ (gpointer var) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	(var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL));
#line 239 "rygel-media-server-plugin.c"
}


static void _g_list_free__rygel_dlna_profile_unref0_ (GList* self) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_list_foreach (self, (GFunc) _rygel_dlna_profile_unref0_, NULL);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_list_free (self);
#line 248 "rygel-media-server-plugin.c"
}


/**
     * Create an instance of the plugin.
     * The plugin's service will have the same title as its root container.
     *
     * @param root_container The container that should be served by this plugin's service.
     * @param name The non-human-readable name for the plugin and its service, used in UPnP messages and in the Rygel configuration file.
     * @param description An optional human-readable description (modelDescription) of the UPnP service provided by the plugin.
     */
RygelMediaServerPlugin* rygel_media_server_plugin_construct (GType object_type, RygelMediaContainer* root_container, const gchar* name, const gchar* description, RygelPluginCapabilities capabilities) {
	RygelMediaServerPlugin * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	RygelPluginCapabilities _tmp5_ = 0;
	RygelMediaContainer* _tmp6_ = NULL;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_val_if_fail (root_container != NULL, NULL);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = name;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp1_ = root_container;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp2_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp1_);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp3_ = _tmp2_;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp4_ = description;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp5_ = capabilities;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp6_ = root_container;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self = (RygelMediaServerPlugin*) g_object_new (object_type, "desc-path", RYGEL_MEDIA_SERVER_PLUGIN_MEDIA_SERVER_DESC_PATH, "name", _tmp0_, "title", _tmp3_, "description", _tmp4_, "capabilities", _tmp5_, "root-container", _tmp6_, NULL);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	return self;
#line 291 "rygel-media-server-plugin.c"
}


static void _rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_media_server_plugin_on_container_updated (self, _sender, container, object, event_type, sub_tree_update);
#line 298 "rygel-media-server-plugin.c"
}


static void rygel_media_server_plugin_real_constructed (GObject* base) {
	RygelMediaServerPlugin * self;
	gchar* path = NULL;
	gchar* _tmp0_ = NULL;
	RygelPluginCapabilities _tmp1_ = 0;
	RygelPluginCapabilities _tmp2_ = 0;
	RygelResourceInfo* info = NULL;
	const gchar* _tmp4_ = NULL;
	RygelResourceInfo* _tmp5_ = NULL;
	RygelResourceInfo* _tmp6_ = NULL;
	RygelResourceInfo* _tmp7_ = NULL;
	RygelResourceInfo* _tmp8_ = NULL;
	RygelResourceInfo* _tmp9_ = NULL;
	RygelResourceInfo* _tmp10_ = NULL;
	RygelMediaContainer* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self = (RygelMediaServerPlugin*) base;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	G_OBJECT_CLASS (rygel_media_server_plugin_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_PLUGIN, RygelPlugin));
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = g_strdup (RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH_NO_TRACK);
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	path = _tmp0_;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp1_ = rygel_plugin_get_capabilities ((RygelPlugin*) self);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp2_ = _tmp1_;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if ((_tmp2_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) {
#line 333 "rygel-media-server-plugin.c"
		gchar* _tmp3_ = NULL;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp3_ = g_strdup (RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH);
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_g_free0 (path);
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		path = _tmp3_;
#line 341 "rygel-media-server-plugin.c"
	}
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp4_ = path;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp5_ = rygel_resource_info_new (RYGEL_CONTENT_DIRECTORY_UPNP_ID, RYGEL_CONTENT_DIRECTORY_UPNP_TYPE, _tmp4_, RYGEL_TYPE_CONTENT_DIRECTORY);
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	info = _tmp5_;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp6_ = info;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp6_);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp7_ = rygel_resource_info_new (RYGEL_CONNECTION_MANAGER_UPNP_ID, RYGEL_CONNECTION_MANAGER_UPNP_TYPE, RYGEL_CONNECTION_MANAGER_DESCRIPTION_PATH, RYGEL_TYPE_SOURCE_CONNECTION_MANAGER);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_rygel_resource_info_unref0 (info);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	info = _tmp7_;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp8_ = info;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp8_);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp9_ = rygel_resource_info_new (RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_ID, RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE, RYGEL_MEDIA_RECEIVER_REGISTRAR_DESCRIPTION_PATH, RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_rygel_resource_info_unref0 (info);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	info = _tmp9_;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp10_ = info;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp10_);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp11_ = self->priv->_root_container;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp12_ = rygel_media_container_get_child_count (_tmp11_);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp13_ = _tmp12_;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_tmp13_ == 0) {
#line 381 "rygel-media-server-plugin.c"
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		RygelMediaContainer* _tmp16_ = NULL;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp14_ = rygel_plugin_get_name ((RygelPlugin*) self);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp15_ = _tmp14_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_debug ("rygel-media-server-plugin.vala:148: Deactivating plugin '%s' until it " \
"provides content.", _tmp15_);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		rygel_plugin_set_active ((RygelPlugin*) self, FALSE);
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp16_ = self->priv->_root_container;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_signal_connect_object (_tmp16_, "container-updated", (GCallback) _rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated, self, 0);
#line 397 "rygel-media-server-plugin.c"
	}
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_rygel_resource_info_unref0 (info);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_g_free0 (path);
#line 403 "rygel-media-server-plugin.c"
}


static void rygel_media_server_plugin_real_apply_hacks (RygelPlugin* base, RygelRootDevice* device, const gchar* description_path, GError** error) {
	RygelMediaServerPlugin * self;
	gchar** services = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint services_length1 = 0;
	gint _services_size_ = 0;
	RygelV1Hacks* v1_hacks = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	RygelV1Hacks* _tmp4_ = NULL;
	RygelV1Hacks* _tmp5_ = NULL;
	RygelRootDevice* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	RygelXBoxHacks* xbox_hacks = NULL;
	RygelXBoxHacks* _tmp8_ = NULL;
	RygelXBoxHacks* _tmp9_ = NULL;
	RygelRootDevice* _tmp10_ = NULL;
	RygelV1Hacks* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self = (RygelMediaServerPlugin*) base;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (device != NULL);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (description_path != NULL);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = g_strdup (RYGEL_CONTENT_DIRECTORY_UPNP_TYPE);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp1_ = g_strdup (RYGEL_CONNECTION_MANAGER_UPNP_TYPE);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp2_ = g_new0 (gchar*, 2 + 1);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp2_[0] = _tmp0_;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp2_[1] = _tmp1_;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	services = _tmp2_;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	services_length1 = 2;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_services_size_ = services_length1;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp3_ = services;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp3__length1 = services_length1;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp4_ = rygel_v1_hacks_new (RYGEL_MEDIA_SERVER_PLUGIN_DMS, _tmp3_, _tmp3__length1);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	v1_hacks = _tmp4_;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp5_ = v1_hacks;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp6_ = device;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp7_ = description_path;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_v1_hacks_apply_on_device (_tmp5_, _tmp6_, _tmp7_, &_inner_error_);
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_inner_error_ != NULL) {
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_propagate_error (error, _inner_error_);
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_g_object_unref0 (v1_hacks);
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		return;
#line 477 "rygel-media-server-plugin.c"
	}
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp8_ = rygel_xbox_hacks_new (NULL, &_inner_error_);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	xbox_hacks = _tmp8_;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_inner_error_ != NULL) {
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_propagate_error (error, _inner_error_);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_g_object_unref0 (v1_hacks);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		return;
#line 493 "rygel-media-server-plugin.c"
	}
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp9_ = xbox_hacks;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp10_ = device;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp11_ = v1_hacks;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp12_ = _tmp11_->description_path;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_xbox_hacks_apply_on_device (_tmp9_, _tmp10_, _tmp12_, &_inner_error_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_inner_error_ != NULL) {
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_propagate_error (error, _inner_error_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_g_object_unref0 (xbox_hacks);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_g_object_unref0 (v1_hacks);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		return;
#line 517 "rygel-media-server-plugin.c"
	}
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_g_object_unref0 (xbox_hacks);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_g_object_unref0 (v1_hacks);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
#line 525 "rygel-media-server-plugin.c"
}


static void rygel_media_server_plugin_on_container_updated (RygelMediaServerPlugin* self, RygelMediaContainer* root_container, RygelMediaContainer* updated, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	gboolean _tmp0_ = FALSE;
	RygelMediaContainer* _tmp1_ = NULL;
	RygelMediaContainer* _tmp2_ = NULL;
	gboolean _tmp6_ = FALSE;
	RygelMediaContainer* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (self != NULL);
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (root_container != NULL);
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (updated != NULL);
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (object != NULL);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp1_ = updated;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp2_ = root_container;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_tmp1_ != _tmp2_) {
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp0_ = TRUE;
#line 554 "rygel-media-server-plugin.c"
	} else {
		RygelMediaContainer* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp3_ = updated;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp4_ = rygel_media_container_get_child_count (_tmp3_);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp5_ = _tmp4_;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp0_ = _tmp5_ == 0;
#line 567 "rygel-media-server-plugin.c"
	}
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp6_ = _tmp0_;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_tmp6_) {
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		return;
#line 575 "rygel-media-server-plugin.c"
	}
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp7_ = root_container;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_signal_parse_name ("container-updated", RYGEL_TYPE_MEDIA_CONTAINER, &_tmp8_, NULL, FALSE);
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated, self);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp9_ = rygel_plugin_get_name ((RygelPlugin*) self);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp10_ = _tmp9_;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_debug ("rygel-media-server-plugin.vala:185: Activating plugin '%s' since it no" \
"w provides content.", _tmp10_);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_plugin_set_active ((RygelPlugin*) self, TRUE);
#line 591 "rygel-media-server-plugin.c"
}


RygelMediaContainer* rygel_media_server_plugin_get_root_container (RygelMediaServerPlugin* self) {
	RygelMediaContainer* result;
	RygelMediaContainer* _tmp0_ = NULL;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = self->priv->_root_container;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	result = _tmp0_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	return result;
#line 606 "rygel-media-server-plugin.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 613 "rygel-media-server-plugin.c"
}


static void rygel_media_server_plugin_set_root_container (RygelMediaServerPlugin* self, RygelMediaContainer* value) {
	RygelMediaContainer* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (self != NULL);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = value;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_g_object_unref0 (self->priv->_root_container);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self->priv->_root_container = _tmp1_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_object_notify ((GObject *) self, "root-container");
#line 632 "rygel-media-server-plugin.c"
}


GList* rygel_media_server_plugin_get_upload_profiles (RygelMediaServerPlugin* self) {
	GList* result;
	GList* _tmp0_ = NULL;
	GList* _tmp3_ = NULL;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = self->priv->_upload_profiles;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_tmp0_ == NULL) {
#line 646 "rygel-media-server-plugin.c"
		GList* _tmp1_ = NULL;
		GList* _tmp2_ = NULL;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp1_ = rygel_media_server_plugin_get_supported_profiles (self);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp2_ = _tmp1_;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		result = _tmp2_;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		return result;
#line 657 "rygel-media-server-plugin.c"
	}
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp3_ = self->priv->_upload_profiles;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	result = _tmp3_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	return result;
#line 665 "rygel-media-server-plugin.c"
}


static gpointer _rygel_dlna_profile_ref0 (gpointer self) {
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	return self ? rygel_dlna_profile_ref (self) : NULL;
#line 672 "rygel-media-server-plugin.c"
}


void rygel_media_server_plugin_set_upload_profiles (RygelMediaServerPlugin* self, GList* value) {
	GList* _tmp0_ = NULL;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (self != NULL);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->_upload_profiles);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self->priv->_upload_profiles = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = value;
#line 686 "rygel-media-server-plugin.c"
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		profile_collection = _tmp0_;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
#line 694 "rygel-media-server-plugin.c"
			RygelDLNAProfile* _tmp1_ = NULL;
			RygelDLNAProfile* profile = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
			_tmp1_ = _rygel_dlna_profile_ref0 ((RygelDLNAProfile*) profile_it->data);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
			profile = _tmp1_;
#line 701 "rygel-media-server-plugin.c"
			{
				RygelDLNAProfile* _tmp2_ = NULL;
				RygelDLNAProfile* _tmp3_ = NULL;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
				_tmp2_ = profile;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
				_tmp3_ = _rygel_dlna_profile_ref0 (_tmp2_);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
				self->priv->_upload_profiles = g_list_append (self->priv->_upload_profiles, _tmp3_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
				_rygel_dlna_profile_unref0 (profile);
#line 713 "rygel-media-server-plugin.c"
			}
		}
	}
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_object_notify ((GObject *) self, "upload-profiles");
#line 719 "rygel-media-server-plugin.c"
}


GList* rygel_media_server_plugin_get_supported_profiles (RygelMediaServerPlugin* self) {
	GList* result;
	GList* _tmp0_ = NULL;
	GList* _tmp5_ = NULL;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = self->priv->_supported_profiles;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_tmp0_ == NULL) {
#line 733 "rygel-media-server-plugin.c"
		RygelMediaEngine* _tmp1_ = NULL;
		RygelMediaEngine* _tmp2_ = NULL;
		GList* _tmp3_ = NULL;
		GList* _tmp4_ = NULL;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp1_ = rygel_media_engine_get_default ();
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp2_ = _tmp1_;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp3_ = rygel_media_engine_get_dlna_profiles (_tmp2_);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp4_ = _tmp3_;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_g_object_unref0 (_tmp2_);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		result = _tmp4_;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		return result;
#line 752 "rygel-media-server-plugin.c"
	}
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp5_ = self->priv->_supported_profiles;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	result = _tmp5_;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	return result;
#line 760 "rygel-media-server-plugin.c"
}


void rygel_media_server_plugin_set_supported_profiles (RygelMediaServerPlugin* self, GList* value) {
	GList* _tmp0_ = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (self != NULL);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->_supported_profiles);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self->priv->_supported_profiles = NULL;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = value;
#line 774 "rygel-media-server-plugin.c"
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		profile_collection = _tmp0_;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
#line 782 "rygel-media-server-plugin.c"
			RygelDLNAProfile* _tmp1_ = NULL;
			RygelDLNAProfile* profile = NULL;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
			_tmp1_ = _rygel_dlna_profile_ref0 ((RygelDLNAProfile*) profile_it->data);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
			profile = _tmp1_;
#line 789 "rygel-media-server-plugin.c"
			{
				RygelDLNAProfile* _tmp2_ = NULL;
				RygelDLNAProfile* _tmp3_ = NULL;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
				_tmp2_ = profile;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
				_tmp3_ = _rygel_dlna_profile_ref0 (_tmp2_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
				self->priv->_supported_profiles = g_list_append (self->priv->_supported_profiles, _tmp3_);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
				_rygel_dlna_profile_unref0 (profile);
#line 801 "rygel-media-server-plugin.c"
			}
		}
	}
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_object_notify ((GObject *) self, "supported-profiles");
#line 807 "rygel-media-server-plugin.c"
}


static void rygel_media_server_plugin_class_init (RygelMediaServerPluginClass * klass) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_media_server_plugin_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaServerPluginPrivate));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	G_OBJECT_CLASS (klass)->constructed = rygel_media_server_plugin_real_constructed;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	RYGEL_PLUGIN_CLASS (klass)->apply_hacks = rygel_media_server_plugin_real_apply_hacks;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_server_plugin_get_property;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_server_plugin_set_property;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_server_plugin_finalize;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_SERVER_PLUGIN_ROOT_CONTAINER, g_param_spec_object ("root-container", "root-container", "root-container", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 828 "rygel-media-server-plugin.c"
	/**
	     * The list of DLNA profiles the MediaServer in this plugin will accept
	     * files as upload.
	     *
	     * Can be a subset of :supported_profiles. If set to %NULL, it will be
	     * reset to :supported_profiles.
	     */
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_SERVER_PLUGIN_UPLOAD_PROFILES, g_param_spec_pointer ("upload-profiles", "upload-profiles", "upload-profiles", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 838 "rygel-media-server-plugin.c"
	/**
	     * The list of DLNA profiles the MediaServer in this plugin will be able
	     * to serve.
	     *
	     * If it does not accept all formats it can serve for uploading,
	     * :upload_profiles needs to be set to the supported subset.
	     *
	     * By default it will be the supported profiles of the #RygelMediaEngine.
	     */
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_SERVER_PLUGIN_SUPPORTED_PROFILES, g_param_spec_pointer ("supported-profiles", "supported-profiles", "supported-profiles", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 850 "rygel-media-server-plugin.c"
}


static void rygel_media_server_plugin_instance_init (RygelMediaServerPlugin * self) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self->priv = RYGEL_MEDIA_SERVER_PLUGIN_GET_PRIVATE (self);
#line 857 "rygel-media-server-plugin.c"
}


static void rygel_media_server_plugin_finalize (GObject* obj) {
	RygelMediaServerPlugin * self;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_g_object_unref0 (self->priv->_root_container);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->_upload_profiles);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->_supported_profiles);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	G_OBJECT_CLASS (rygel_media_server_plugin_parent_class)->finalize (obj);
#line 873 "rygel-media-server-plugin.c"
}


/**
 * This is the base class for every Rygel implementation of a UPnP media
 * server. It should be used either for a real plug-in for the Rygel process or used
 * in-process via the librygel-server API.
 *
 * The plugin instance should have a #RygelMediaContainer instance as its
 * root container, which may be provided to the constructor.
 *
 * See the
 * <link linkend="implementing-server-plugins">Implementing Server Plugins</link> section.
 */
GType rygel_media_server_plugin_get_type (void) {
	static volatile gsize rygel_media_server_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_server_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaServerPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_server_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaServerPlugin), 0, (GInstanceInitFunc) rygel_media_server_plugin_instance_init, NULL };
		GType rygel_media_server_plugin_type_id;
		rygel_media_server_plugin_type_id = g_type_register_static (RYGEL_TYPE_PLUGIN, "RygelMediaServerPlugin", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_server_plugin_type_id__volatile, rygel_media_server_plugin_type_id);
	}
	return rygel_media_server_plugin_type_id__volatile;
}


static void _vala_rygel_media_server_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaServerPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	switch (property_id) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		case RYGEL_MEDIA_SERVER_PLUGIN_ROOT_CONTAINER:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_value_set_object (value, rygel_media_server_plugin_get_root_container (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		case RYGEL_MEDIA_SERVER_PLUGIN_UPLOAD_PROFILES:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_value_set_pointer (value, rygel_media_server_plugin_get_upload_profiles (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		case RYGEL_MEDIA_SERVER_PLUGIN_SUPPORTED_PROFILES:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_value_set_pointer (value, rygel_media_server_plugin_get_supported_profiles (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		break;
#line 923 "rygel-media-server-plugin.c"
		default:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		break;
#line 929 "rygel-media-server-plugin.c"
	}
}


static void _vala_rygel_media_server_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaServerPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	switch (property_id) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		case RYGEL_MEDIA_SERVER_PLUGIN_ROOT_CONTAINER:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		rygel_media_server_plugin_set_root_container (self, g_value_get_object (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		case RYGEL_MEDIA_SERVER_PLUGIN_UPLOAD_PROFILES:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		rygel_media_server_plugin_set_upload_profiles (self, g_value_get_pointer (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		case RYGEL_MEDIA_SERVER_PLUGIN_SUPPORTED_PROFILES:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		rygel_media_server_plugin_set_supported_profiles (self, g_value_get_pointer (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		break;
#line 957 "rygel-media-server-plugin.c"
		default:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		break;
#line 963 "rygel-media-server-plugin.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



