/* contacts-store.c generated by valac 0.13.0.32-acab5, the Vala compiler
 * generated from contacts-store.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
typedef struct _ContactsStorePrivate ContactsStorePrivate;

#define CONTACTS_STORE_TYPE_CONTACT_DATA (contacts_store_contact_data_get_type ())
#define CONTACTS_STORE_CONTACT_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_STORE_TYPE_CONTACT_DATA, ContactsStoreContactData))
#define CONTACTS_STORE_CONTACT_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_STORE_TYPE_CONTACT_DATA, ContactsStoreContactDataClass))
#define CONTACTS_STORE_IS_CONTACT_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_STORE_TYPE_CONTACT_DATA))
#define CONTACTS_STORE_IS_CONTACT_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_STORE_TYPE_CONTACT_DATA))
#define CONTACTS_STORE_CONTACT_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_STORE_TYPE_CONTACT_DATA, ContactsStoreContactDataClass))

typedef struct _ContactsStoreContactData ContactsStoreContactData;
typedef struct _ContactsStoreContactDataClass ContactsStoreContactDataClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
typedef struct _ContactsContactPrivate ContactsContactPrivate;
typedef struct _ContactsStoreContactDataPrivate ContactsStoreContactDataPrivate;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _contacts_store_contact_data_unref0(var) ((var == NULL) ? NULL : (var = (contacts_store_contact_data_unref (var), NULL)))
typedef struct _ContactsStoreParamSpecContactData ContactsStoreParamSpecContactData;
typedef struct _ContactsParamSpecStore ContactsParamSpecStore;

struct _ContactsStore {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ContactsStorePrivate * priv;
};

struct _ContactsStoreClass {
	GTypeClass parent_class;
	void (*finalize) (ContactsStore *self);
};

struct _ContactsStorePrivate {
	GtkListStore* list_store;
	FolksIndividualAggregator* _aggregator;
	GeeArrayList* contacts;
	gchar** filter_values;
	gint filter_values_length1;
	gint _filter_values_size_;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _ContactsStoreContactData {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ContactsStoreContactDataPrivate * priv;
	ContactsContact* contact;
	GtkTreeIter iter;
	gboolean visible;
	gboolean is_first;
};

struct _ContactsStoreContactDataClass {
	GTypeClass parent_class;
	void (*finalize) (ContactsStoreContactData *self);
};

struct _ContactsStoreParamSpecContactData {
	GParamSpec parent_instance;
};

struct _ContactsParamSpecStore {
	GParamSpec parent_instance;
};


static gpointer contacts_store_parent_class = NULL;
static gpointer contacts_store_contact_data_parent_class = NULL;

gpointer contacts_store_ref (gpointer instance);
void contacts_store_unref (gpointer instance);
GParamSpec* contacts_param_spec_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void contacts_value_set_store (GValue* value, gpointer v_object);
void contacts_value_take_store (GValue* value, gpointer v_object);
gpointer contacts_value_get_store (const GValue* value);
GType contacts_store_get_type (void) G_GNUC_CONST;
static gpointer contacts_store_contact_data_ref (gpointer instance);
static void contacts_store_contact_data_unref (gpointer instance);
static GParamSpec* contacts_store_param_spec_contact_data (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void contacts_store_value_set_contact_data (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void contacts_store_value_take_contact_data (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer contacts_store_value_get_contact_data (const GValue* value) G_GNUC_UNUSED;
static GType contacts_store_contact_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define CONTACTS_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_STORE, ContactsStorePrivate))
enum  {
	CONTACTS_STORE_DUMMY_PROPERTY
};
ContactsStore* contacts_store_new (void);
ContactsStore* contacts_store_construct (GType object_type);
GType contacts_contact_get_type (void) G_GNUC_CONST;
static gint _lambda6_ (GtkTreeModel* model, GtkTreeIter* iter_a, GtkTreeIter* iter_b, ContactsStore* self);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
static gint __lambda6__gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self);
static void contacts_store_set_aggregator (ContactsStore* self, FolksIndividualAggregator* value);
FolksIndividualAggregator* contacts_store_get_aggregator (ContactsStore* self);
static void _lambda7_ (GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, ContactsStore* self);
void contacts_store_remove (ContactsStore* self, ContactsContact* c);
ContactsContact* contacts_contact_from_individual (FolksIndividual* i);
ContactsContact* contacts_contact_new (ContactsStore* store, FolksIndividual* i);
ContactsContact* contacts_contact_construct (GType object_type, ContactsStore* store, FolksIndividual* i);
void contacts_store_add (ContactsStore* self, ContactsContact* c);
static void __lambda7__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static gboolean contacts_store_apply_filter (ContactsStore* self, ContactsContact* contact);
gboolean contacts_contact_contains_strings (ContactsContact* self, gchar** strings, int strings_length1);
gboolean contacts_store_is_first (ContactsStore* self, GtkTreeIter* iter);
static ContactsStoreContactData* contacts_store_get_previous (ContactsStore* self, ContactsStoreContactData* data);
static ContactsStoreContactData* contacts_store_get_next (ContactsStore* self, ContactsStoreContactData* data);
static void contacts_store_row_changed_no_resort (ContactsStore* self, ContactsStoreContactData* data);
static void contacts_store_row_changed_resort (ContactsStore* self, ContactsStoreContactData* data);
static gboolean contacts_store_update_is_first (ContactsStore* self, ContactsStoreContactData* data, ContactsStoreContactData* previous);
static void contacts_store_add_to_model (ContactsStore* self, ContactsStoreContactData* data);
static void contacts_store_remove_from_model (ContactsStore* self, ContactsStoreContactData* data);
static void contacts_store_update_visible (ContactsStore* self, ContactsStoreContactData* data);
static void contacts_store_refilter (ContactsStore* self);
void contacts_store_set_filter_values (ContactsStore* self, gchar** values, int values_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
static void contacts_store_contact_changed (ContactsStore* self, ContactsContact* c);
static ContactsStoreContactData* contacts_store_lookup_data (ContactsStore* self, ContactsContact* c);
ContactsContact* contacts_store_find_contact_with_persona (ContactsStore* self, FolksPersona* persona);
static ContactsStoreContactData* contacts_store_contact_data_new (void);
static ContactsStoreContactData* contacts_store_contact_data_construct (GType object_type);
static void _contacts_store_contact_changed_contacts_contact_changed (ContactsContact* _sender, gpointer self);
GtkTreeModel* contacts_store_get_model (ContactsStore* self);
enum  {
	CONTACTS_STORE_CONTACT_DATA_DUMMY_PROPERTY
};
static void contacts_store_contact_data_finalize (ContactsStoreContactData* obj);
static void contacts_store_finalize (ContactsStore* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gint _lambda6_ (GtkTreeModel* model, GtkTreeIter* iter_a, GtkTreeIter* iter_b, ContactsStore* self) {
	gint result = 0;
	ContactsContact* a = NULL;
	ContactsContact* b = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_;
	g_return_val_if_fail (model != NULL, 0);
	gtk_tree_model_get (model, iter_a, 0, &a, -1);
	gtk_tree_model_get (model, iter_b, 0, &b, -1);
	_tmp0_ = contacts_contact_get_display_name (a);
	_tmp1_ = contacts_contact_get_display_name (b);
	_tmp2_ = g_utf8_collate (_tmp0_, _tmp1_);
	result = _tmp2_;
	_g_object_unref0 (b);
	_g_object_unref0 (a);
	return result;
}


static gint __lambda6__gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self) {
	gint result;
	result = _lambda6_ (model, a, b, self);
	return result;
}


static void _lambda7_ (GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, ContactsStore* self) {
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _i_it;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) removed);
		_i_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksIndividual* i;
			ContactsContact* _tmp3_ = NULL;
			ContactsContact* _tmp4_;
			_tmp1_ = gee_iterator_next (_i_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_i_it);
			i = (FolksIndividual*) _tmp2_;
			_tmp3_ = contacts_contact_from_individual (i);
			_tmp4_ = _tmp3_;
			contacts_store_remove (self, _tmp4_);
			_g_object_unref0 (_tmp4_);
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	{
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _i_it;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) added);
		_i_it = _tmp5_;
		while (TRUE) {
			gboolean _tmp6_;
			gpointer _tmp7_ = NULL;
			FolksIndividual* i;
			ContactsContact* _tmp8_ = NULL;
			ContactsContact* c;
			_tmp6_ = gee_iterator_next (_i_it);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = gee_iterator_get (_i_it);
			i = (FolksIndividual*) _tmp7_;
			_tmp8_ = contacts_contact_new (self, i);
			c = _tmp8_;
			contacts_store_add (self, c);
			_g_object_unref0 (c);
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
}


static void __lambda7__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_lambda7_ (added, removed, message, actor, reason, self);
}


ContactsStore* contacts_store_construct (GType object_type) {
	ContactsStore* self = NULL;
	GtkListStore* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	FolksIndividualAggregator* _tmp2_ = NULL;
	FolksIndividualAggregator* _tmp3_;
	self = (ContactsStore*) g_type_create_instance (object_type);
	_tmp0_ = gtk_list_store_new (2, CONTACTS_TYPE_CONTACT, G_TYPE_POINTER);
	_g_object_unref0 (self->priv->list_store);
	self->priv->list_store = _tmp0_;
	_tmp1_ = gee_array_list_new (CONTACTS_STORE_TYPE_CONTACT_DATA, (GBoxedCopyFunc) contacts_store_contact_data_ref, contacts_store_contact_data_unref, NULL);
	_g_object_unref0 (self->priv->contacts);
	self->priv->contacts = _tmp1_;
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) self->priv->list_store, 0, __lambda6__gtk_tree_iter_compare_func, contacts_store_ref (self), contacts_store_unref);
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) self->priv->list_store, 0, GTK_SORT_ASCENDING);
	_tmp2_ = folks_individual_aggregator_new ();
	_tmp3_ = _tmp2_;
	contacts_store_set_aggregator (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	g_signal_connect (self->priv->_aggregator, "individuals-changed", (GCallback) __lambda7__folks_individual_aggregator_individuals_changed, self);
	folks_individual_aggregator_prepare (self->priv->_aggregator, NULL, NULL);
	return self;
}


ContactsStore* contacts_store_new (void) {
	return contacts_store_construct (CONTACTS_TYPE_STORE);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean contacts_store_apply_filter (ContactsStore* self, ContactsContact* contact) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_;
	GeeSet* personas;
	GeeIterator* _tmp3_ = NULL;
	GeeIterator* i;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (contact != NULL, FALSE);
	_tmp0_ = folks_individual_get_is_user (contact->individual);
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = folks_individual_get_personas (contact->individual);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	personas = _tmp2_;
	_tmp3_ = gee_iterable_iterator ((GeeIterable*) personas);
	i = _tmp3_;
	_tmp5_ = gee_iterator_next (i);
	if (_tmp5_) {
		gboolean _tmp6_;
		_tmp6_ = gee_iterator_has_next (i);
		_tmp4_ = !_tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gpointer _tmp7_ = NULL;
		FolksPersona* persona;
		FolksPersonaStore* _tmp8_ = NULL;
		FolksPersonaStore* _tmp9_;
		FolksPersonaStore* store;
		const gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_ = NULL;
		_tmp7_ = gee_iterator_get (i);
		persona = (FolksPersona*) _tmp7_;
		_tmp8_ = folks_persona_get_store (persona);
		_tmp9_ = _g_object_ref0 (_tmp8_);
		store = _tmp9_;
		_tmp10_ = folks_persona_store_get_type_id (store);
		if (g_strcmp0 (_tmp10_, "key-file") == 0) {
			result = FALSE;
			_g_object_unref0 (store);
			_g_object_unref0 (persona);
			_g_object_unref0 (i);
			_g_object_unref0 (personas);
			return result;
		}
		_tmp12_ = folks_persona_store_get_type_id (store);
		if (g_strcmp0 (_tmp12_, "telepathy") == 0) {
			FolksPersonaStoreTrust _tmp13_;
			_tmp13_ = folks_persona_store_get_trust_level (store);
			_tmp11_ = _tmp13_ == FOLKS_PERSONA_STORE_TRUST_NONE;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			result = FALSE;
			_g_object_unref0 (store);
			_g_object_unref0 (persona);
			_g_object_unref0 (i);
			_g_object_unref0 (personas);
			return result;
		}
		_g_object_unref0 (store);
		_g_object_unref0 (persona);
	}
	if (self->priv->filter_values == NULL) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = self->priv->filter_values_length1 == 0;
	}
	if (_tmp14_) {
		result = TRUE;
		_g_object_unref0 (i);
		_g_object_unref0 (personas);
		return result;
	}
	_tmp15_ = contacts_contact_contains_strings (contact, self->priv->filter_values, self->priv->filter_values_length1);
	result = _tmp15_;
	_g_object_unref0 (i);
	_g_object_unref0 (personas);
	return result;
}


gboolean contacts_store_is_first (ContactsStore* self, GtkTreeIter* iter) {
	gboolean result = FALSE;
	ContactsStoreContactData* data = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_tree_model_get ((GtkTreeModel*) self->priv->list_store, iter, 1, &data, -1);
	if (data != NULL) {
		result = data->is_first;
		return result;
	}
	result = FALSE;
	return result;
}


static gpointer _contacts_store_contact_data_ref0 (gpointer self) {
	return self ? contacts_store_contact_data_ref (self) : NULL;
}


static ContactsStoreContactData* contacts_store_get_previous (ContactsStore* self, ContactsStoreContactData* data) {
	ContactsStoreContactData* result = NULL;
	ContactsStoreContactData* previous;
	GtkTreeIter iter;
	gboolean _tmp0_;
	ContactsStoreContactData* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	previous = NULL;
	iter = data->iter;
	_tmp0_ = gtk_tree_model_iter_previous ((GtkTreeModel*) self->priv->list_store, &iter);
	if (_tmp0_) {
		gtk_tree_model_get ((GtkTreeModel*) self->priv->list_store, &iter, 1, &previous, -1);
	}
	_tmp1_ = _contacts_store_contact_data_ref0 (previous);
	result = _tmp1_;
	return result;
}


static ContactsStoreContactData* contacts_store_get_next (ContactsStore* self, ContactsStoreContactData* data) {
	ContactsStoreContactData* result = NULL;
	ContactsStoreContactData* next;
	GtkTreeIter iter;
	gboolean _tmp0_;
	ContactsStoreContactData* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	next = NULL;
	iter = data->iter;
	_tmp0_ = gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->list_store, &iter);
	if (_tmp0_) {
		gtk_tree_model_get ((GtkTreeModel*) self->priv->list_store, &iter, 1, &next, -1);
	}
	_tmp1_ = _contacts_store_contact_data_ref0 (next);
	result = _tmp1_;
	return result;
}


static void contacts_store_row_changed_no_resort (ContactsStore* self, ContactsStoreContactData* data) {
	GtkTreePath* _tmp0_ = NULL;
	GtkTreePath* path;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = gtk_tree_model_get_path ((GtkTreeModel*) self->priv->list_store, &data->iter);
	path = _tmp0_;
	gtk_tree_model_row_changed ((GtkTreeModel*) self->priv->list_store, path, &data->iter);
	_gtk_tree_path_free0 (path);
}


static void contacts_store_row_changed_resort (ContactsStore* self, ContactsStoreContactData* data) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	gtk_list_store_set (self->priv->list_store, &data->iter, 0, data->contact, -1);
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + index);
	result = _tmp0_;
	return result;
}


static gboolean contacts_store_update_is_first (ContactsStore* self, ContactsStoreContactData* data, ContactsStoreContactData* previous) {
	gboolean result = FALSE;
	gboolean old_is_first;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (data != NULL, FALSE);
	old_is_first = data->is_first;
	if (previous != NULL) {
		const gchar* _tmp0_ = NULL;
		gunichar _tmp1_;
		gunichar _tmp2_;
		gunichar previous_initial;
		const gchar* _tmp3_ = NULL;
		gunichar _tmp4_;
		gunichar _tmp5_;
		gunichar initial;
		_tmp0_ = contacts_contact_get_display_name (previous->contact);
		_tmp1_ = string_get_char (_tmp0_, (glong) 0);
		_tmp2_ = g_unichar_totitle (_tmp1_);
		previous_initial = _tmp2_;
		_tmp3_ = contacts_contact_get_display_name (data->contact);
		_tmp4_ = string_get_char (_tmp3_, (glong) 0);
		_tmp5_ = g_unichar_totitle (_tmp4_);
		initial = _tmp5_;
		data->is_first = previous_initial != initial;
	} else {
		data->is_first = TRUE;
	}
	if (old_is_first != data->is_first) {
		contacts_store_row_changed_no_resort (self, data);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void contacts_store_add_to_model (ContactsStore* self, ContactsStoreContactData* data) {
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	ContactsStoreContactData* _tmp2_ = NULL;
	ContactsStoreContactData* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	gtk_list_store_append (self->priv->list_store, &_tmp0_);
	data->iter = _tmp0_;
	gtk_list_store_set (self->priv->list_store, &data->iter, 0, data->contact, 1, data, -1);
	_tmp2_ = contacts_store_get_previous (self, data);
	_tmp3_ = _tmp2_;
	_tmp4_ = contacts_store_update_is_first (self, data, _tmp3_);
	_tmp5_ = _tmp4_;
	_contacts_store_contact_data_unref0 (_tmp3_);
	if (_tmp5_) {
		_tmp1_ = data->is_first;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ContactsStoreContactData* _tmp6_ = NULL;
		ContactsStoreContactData* next;
		_tmp6_ = contacts_store_get_next (self, data);
		next = _tmp6_;
		if (next != NULL) {
			contacts_store_update_is_first (self, next, data);
		}
		_contacts_store_contact_data_unref0 (next);
	}
}


static void contacts_store_remove_from_model (ContactsStore* self, ContactsStoreContactData* data) {
	ContactsStoreContactData* next;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	next = NULL;
	if (data->is_first) {
		ContactsStoreContactData* _tmp0_ = NULL;
		_tmp0_ = contacts_store_get_next (self, data);
		_contacts_store_contact_data_unref0 (next);
		next = _tmp0_;
	}
	gtk_list_store_remove (self->priv->list_store, &data->iter);
	data->is_first = FALSE;
	if (next != NULL) {
		ContactsStoreContactData* _tmp1_ = NULL;
		ContactsStoreContactData* _tmp2_;
		_tmp1_ = contacts_store_get_previous (self, next);
		_tmp2_ = _tmp1_;
		contacts_store_update_is_first (self, next, _tmp2_);
		_contacts_store_contact_data_unref0 (_tmp2_);
	}
	_contacts_store_contact_data_unref0 (next);
}


static void contacts_store_update_visible (ContactsStore* self, ContactsStoreContactData* data) {
	gboolean was_visible;
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	was_visible = data->visible;
	_tmp0_ = contacts_store_apply_filter (self, data->contact);
	data->visible = _tmp0_;
	if (!was_visible) {
		_tmp1_ = data->visible;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		contacts_store_add_to_model (self, data);
	}
	if (was_visible) {
		_tmp2_ = !data->visible;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		contacts_store_remove_from_model (self, data);
	}
}


static void contacts_store_refilter (ContactsStore* self) {
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _d_list;
		gint _tmp1_;
		gint _d_size;
		gint _d_index;
		_tmp0_ = _g_object_ref0 (self->priv->contacts);
		_d_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _d_list);
		_d_size = _tmp1_;
		_d_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ContactsStoreContactData* d;
			_d_index = _d_index + 1;
			if (!(_d_index < _d_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _d_list, _d_index);
			d = (ContactsStoreContactData*) _tmp2_;
			contacts_store_update_visible (self, d);
			_contacts_store_contact_data_unref0 (d);
		}
		_g_object_unref0 (_d_list);
	}
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


void contacts_store_set_filter_values (ContactsStore* self, gchar** values, int values_length1) {
	gchar** _tmp0_;
	gchar** _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = (_tmp0_ = values, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup2 (_tmp0_, values_length1));
	self->priv->filter_values = (_vala_array_free (self->priv->filter_values, self->priv->filter_values_length1, (GDestroyNotify) g_free), NULL);
	self->priv->filter_values = _tmp1_;
	self->priv->filter_values_length1 = values_length1;
	self->priv->_filter_values_size_ = self->priv->filter_values_length1;
	contacts_store_refilter (self);
}


static void contacts_store_contact_changed (ContactsStore* self, ContactsContact* c) {
	ContactsStoreContactData* _tmp0_ = NULL;
	ContactsStoreContactData* data;
	gboolean was_visible;
	ContactsStoreContactData* next;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = contacts_store_lookup_data (self, c);
	data = _tmp0_;
	was_visible = data->visible;
	next = NULL;
	if (data->visible) {
		ContactsStoreContactData* _tmp1_ = NULL;
		_tmp1_ = contacts_store_get_next (self, data);
		_contacts_store_contact_data_unref0 (next);
		next = _tmp1_;
	}
	contacts_store_update_visible (self, data);
	if (was_visible) {
		_tmp2_ = data->visible;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ContactsStoreContactData* _tmp5_ = NULL;
		contacts_store_row_changed_resort (self, data);
		if (next != NULL) {
			ContactsStoreContactData* _tmp3_ = NULL;
			ContactsStoreContactData* _tmp4_;
			_tmp3_ = contacts_store_get_previous (self, next);
			_tmp4_ = _tmp3_;
			contacts_store_update_is_first (self, next, _tmp4_);
			_contacts_store_contact_data_unref0 (_tmp4_);
		}
		_tmp5_ = contacts_store_get_next (self, data);
		_contacts_store_contact_data_unref0 (next);
		next = _tmp5_;
		if (next != NULL) {
			contacts_store_update_is_first (self, next, data);
		}
	}
	_contacts_store_contact_data_unref0 (next);
	_contacts_store_contact_data_unref0 (data);
}


static ContactsStoreContactData* contacts_store_lookup_data (ContactsStore* self, ContactsContact* c) {
	ContactsStoreContactData* result = NULL;
	gconstpointer _tmp0_ = NULL;
	ContactsStoreContactData* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (c != NULL, NULL);
	_tmp0_ = g_object_get_data ((GObject*) c, "contact-data");
	_tmp1_ = _contacts_store_contact_data_ref0 ((ContactsStoreContactData*) _tmp0_);
	result = _tmp1_;
	return result;
}


ContactsContact* contacts_store_find_contact_with_persona (ContactsStore* self, FolksPersona* persona) {
	ContactsContact* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (persona != NULL, NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _data_list;
		gint _tmp1_;
		gint _data_size;
		gint _data_index;
		_tmp0_ = _g_object_ref0 (self->priv->contacts);
		_data_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _data_list);
		_data_size = _tmp1_;
		_data_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ContactsStoreContactData* data;
			GeeSet* _tmp3_ = NULL;
			gboolean _tmp4_;
			_data_index = _data_index + 1;
			if (!(_data_index < _data_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _data_list, _data_index);
			data = (ContactsStoreContactData*) _tmp2_;
			_tmp3_ = folks_individual_get_personas (data->contact->individual);
			_tmp4_ = gee_collection_contains ((GeeCollection*) _tmp3_, persona);
			if (_tmp4_) {
				ContactsContact* _tmp5_;
				_tmp5_ = _g_object_ref0 (data->contact);
				result = _tmp5_;
				_contacts_store_contact_data_unref0 (data);
				_g_object_unref0 (_data_list);
				return result;
			}
			_contacts_store_contact_data_unref0 (data);
		}
		_g_object_unref0 (_data_list);
	}
	result = NULL;
	return result;
}


static void _contacts_store_contact_changed_contacts_contact_changed (ContactsContact* _sender, gpointer self) {
	contacts_store_contact_changed (self, _sender);
}


void contacts_store_add (ContactsStore* self, ContactsContact* c) {
	ContactsStoreContactData* _tmp0_ = NULL;
	ContactsStoreContactData* data;
	ContactsContact* _tmp1_;
	ContactsStoreContactData* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = contacts_store_contact_data_new ();
	data = _tmp0_;
	_tmp1_ = _g_object_ref0 (c);
	_g_object_unref0 (data->contact);
	data->contact = _tmp1_;
	data->visible = FALSE;
	_tmp2_ = _contacts_store_contact_data_ref0 (data);
	g_object_set_data_full ((GObject*) c, "contact-data", _tmp2_, contacts_store_contact_data_unref);
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->contacts, data);
	g_signal_connect (c, "changed", (GCallback) _contacts_store_contact_changed_contacts_contact_changed, self);
	contacts_store_update_visible (self, data);
	_contacts_store_contact_data_unref0 (data);
}


void contacts_store_remove (ContactsStore* self, ContactsContact* c) {
	guint _tmp0_;
	ContactsStoreContactData* _tmp1_ = NULL;
	ContactsStoreContactData* data;
	gint _tmp2_;
	gint i;
	gint _tmp3_;
	gint _tmp7_;
	gpointer _tmp8_ = NULL;
	ContactsStoreContactData* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_signal_parse_name ("changed", CONTACTS_TYPE_CONTACT, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (c, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _contacts_store_contact_changed_contacts_contact_changed, self);
	_tmp1_ = contacts_store_lookup_data (self, c);
	data = _tmp1_;
	if (data->visible) {
		contacts_store_remove_from_model (self, data);
	}
	_tmp2_ = gee_abstract_list_index_of ((GeeAbstractList*) self->priv->contacts, data);
	i = _tmp2_;
	_tmp3_ = gee_collection_get_size ((GeeCollection*) self->priv->contacts);
	if (i != (_tmp3_ - 1)) {
		gint _tmp4_;
		gpointer _tmp5_ = NULL;
		ContactsStoreContactData* _tmp6_;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) self->priv->contacts);
		_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->contacts, _tmp4_ - 1);
		_tmp6_ = (ContactsStoreContactData*) _tmp5_;
		gee_abstract_list_set ((GeeAbstractList*) self->priv->contacts, i, _tmp6_);
		_contacts_store_contact_data_unref0 (_tmp6_);
	}
	_tmp7_ = gee_collection_get_size ((GeeCollection*) self->priv->contacts);
	_tmp8_ = gee_abstract_list_remove_at ((GeeAbstractList*) self->priv->contacts, _tmp7_ - 1);
	_tmp9_ = (ContactsStoreContactData*) _tmp8_;
	_contacts_store_contact_data_unref0 (_tmp9_);
	g_object_set_data_full ((GObject*) c, "contact-data", NULL, NULL);
	_contacts_store_contact_data_unref0 (data);
}


FolksIndividualAggregator* contacts_store_get_aggregator (ContactsStore* self) {
	FolksIndividualAggregator* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_aggregator;
	return result;
}


static void contacts_store_set_aggregator (ContactsStore* self, FolksIndividualAggregator* value) {
	FolksIndividualAggregator* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_aggregator);
	self->priv->_aggregator = _tmp0_;
}


GtkTreeModel* contacts_store_get_model (ContactsStore* self) {
	GtkTreeModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GtkTreeModel*) self->priv->list_store;
	return result;
}


static ContactsStoreContactData* contacts_store_contact_data_construct (GType object_type) {
	ContactsStoreContactData* self = NULL;
	self = (ContactsStoreContactData*) g_type_create_instance (object_type);
	return self;
}


static ContactsStoreContactData* contacts_store_contact_data_new (void) {
	return contacts_store_contact_data_construct (CONTACTS_STORE_TYPE_CONTACT_DATA);
}


static void contacts_store_value_contact_data_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void contacts_store_value_contact_data_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		contacts_store_contact_data_unref (value->data[0].v_pointer);
	}
}


static void contacts_store_value_contact_data_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = contacts_store_contact_data_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer contacts_store_value_contact_data_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* contacts_store_value_contact_data_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ContactsStoreContactData* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = contacts_store_contact_data_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* contacts_store_value_contact_data_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ContactsStoreContactData** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = contacts_store_contact_data_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* contacts_store_param_spec_contact_data (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ContactsStoreParamSpecContactData* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CONTACTS_STORE_TYPE_CONTACT_DATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer contacts_store_value_get_contact_data (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTACTS_STORE_TYPE_CONTACT_DATA), NULL);
	return value->data[0].v_pointer;
}


static void contacts_store_value_set_contact_data (GValue* value, gpointer v_object) {
	ContactsStoreContactData* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTACTS_STORE_TYPE_CONTACT_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CONTACTS_STORE_TYPE_CONTACT_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		contacts_store_contact_data_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		contacts_store_contact_data_unref (old);
	}
}


static void contacts_store_value_take_contact_data (GValue* value, gpointer v_object) {
	ContactsStoreContactData* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTACTS_STORE_TYPE_CONTACT_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CONTACTS_STORE_TYPE_CONTACT_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		contacts_store_contact_data_unref (old);
	}
}


static void contacts_store_contact_data_class_init (ContactsStoreContactDataClass * klass) {
	contacts_store_contact_data_parent_class = g_type_class_peek_parent (klass);
	CONTACTS_STORE_CONTACT_DATA_CLASS (klass)->finalize = contacts_store_contact_data_finalize;
}


static void contacts_store_contact_data_instance_init (ContactsStoreContactData * self) {
	self->ref_count = 1;
}


static void contacts_store_contact_data_finalize (ContactsStoreContactData* obj) {
	ContactsStoreContactData * self;
	self = CONTACTS_STORE_CONTACT_DATA (obj);
	_g_object_unref0 (self->contact);
}


static GType contacts_store_contact_data_get_type (void) {
	static volatile gsize contacts_store_contact_data_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_store_contact_data_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { contacts_store_value_contact_data_init, contacts_store_value_contact_data_free_value, contacts_store_value_contact_data_copy_value, contacts_store_value_contact_data_peek_pointer, "p", contacts_store_value_contact_data_collect_value, "p", contacts_store_value_contact_data_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ContactsStoreContactDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_store_contact_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsStoreContactData), 0, (GInstanceInitFunc) contacts_store_contact_data_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType contacts_store_contact_data_type_id;
		contacts_store_contact_data_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ContactsStoreContactData", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&contacts_store_contact_data_type_id__volatile, contacts_store_contact_data_type_id);
	}
	return contacts_store_contact_data_type_id__volatile;
}


static gpointer contacts_store_contact_data_ref (gpointer instance) {
	ContactsStoreContactData* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void contacts_store_contact_data_unref (gpointer instance) {
	ContactsStoreContactData* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CONTACTS_STORE_CONTACT_DATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void contacts_value_store_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void contacts_value_store_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		contacts_store_unref (value->data[0].v_pointer);
	}
}


static void contacts_value_store_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = contacts_store_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer contacts_value_store_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* contacts_value_store_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ContactsStore* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = contacts_store_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* contacts_value_store_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ContactsStore** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = contacts_store_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* contacts_param_spec_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ContactsParamSpecStore* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CONTACTS_TYPE_STORE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer contacts_value_get_store (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTACTS_TYPE_STORE), NULL);
	return value->data[0].v_pointer;
}


void contacts_value_set_store (GValue* value, gpointer v_object) {
	ContactsStore* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTACTS_TYPE_STORE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CONTACTS_TYPE_STORE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		contacts_store_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		contacts_store_unref (old);
	}
}


void contacts_value_take_store (GValue* value, gpointer v_object) {
	ContactsStore* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTACTS_TYPE_STORE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CONTACTS_TYPE_STORE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		contacts_store_unref (old);
	}
}


static void contacts_store_class_init (ContactsStoreClass * klass) {
	contacts_store_parent_class = g_type_class_peek_parent (klass);
	CONTACTS_STORE_CLASS (klass)->finalize = contacts_store_finalize;
	g_type_class_add_private (klass, sizeof (ContactsStorePrivate));
}


static void contacts_store_instance_init (ContactsStore * self) {
	self->priv = CONTACTS_STORE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void contacts_store_finalize (ContactsStore* obj) {
	ContactsStore * self;
	self = CONTACTS_STORE (obj);
	_g_object_unref0 (self->priv->list_store);
	_g_object_unref0 (self->priv->_aggregator);
	_g_object_unref0 (self->priv->contacts);
	self->priv->filter_values = (_vala_array_free (self->priv->filter_values, self->priv->filter_values_length1, (GDestroyNotify) g_free), NULL);
}


GType contacts_store_get_type (void) {
	static volatile gsize contacts_store_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_store_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { contacts_value_store_init, contacts_value_store_free_value, contacts_value_store_copy_value, contacts_value_store_peek_pointer, "p", contacts_value_store_collect_value, "p", contacts_value_store_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ContactsStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsStore), 0, (GInstanceInitFunc) contacts_store_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType contacts_store_type_id;
		contacts_store_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ContactsStore", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&contacts_store_type_id__volatile, contacts_store_type_id);
	}
	return contacts_store_type_id__volatile;
}


gpointer contacts_store_ref (gpointer instance) {
	ContactsStore* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void contacts_store_unref (gpointer instance) {
	ContactsStore* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CONTACTS_STORE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



