/* contacts-contact.c generated by valac 0.13.0.32-acab5, the Vala compiler
 * generated from contacts-contact.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks.h>
#include <pango/pango.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <folks/folks-telepathy.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <telepathy-glib/telepathy-glib.h>
#include <config.h>
#include <gio/gio.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>


#define CONTACTS_TYPE_CONTACT_PRESENCE (contacts_contact_presence_get_type ())
#define CONTACTS_CONTACT_PRESENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_PRESENCE, ContactsContactPresence))
#define CONTACTS_CONTACT_PRESENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_PRESENCE, ContactsContactPresenceClass))
#define CONTACTS_IS_CONTACT_PRESENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_PRESENCE))
#define CONTACTS_IS_CONTACT_PRESENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_PRESENCE))
#define CONTACTS_CONTACT_PRESENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_PRESENCE, ContactsContactPresenceClass))

typedef struct _ContactsContactPresence ContactsContactPresence;
typedef struct _ContactsContactPresenceClass ContactsContactPresenceClass;
typedef struct _ContactsContactPresencePrivate ContactsContactPresencePrivate;

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ContactsContactPrivate ContactsContactPrivate;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
typedef struct _Block1Data Block1Data;

#define CONTACTS_CONTACT_TYPE_IM_DISPLAY (contacts_contact_im_display_get_type ())
#define _contacts_store_unref0(var) ((var == NULL) ? NULL : (var = (contacts_store_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define CONTACTS_CONTACT_TYPE_IM_DATA (contacts_contact_im_data_get_type ())
typedef struct _ContactsContactImData ContactsContactImData;
typedef struct _Block2Data Block2Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define CONTACTS_TYPE_TYPESET (contacts_typeset_get_type ())
#define CONTACTS_TYPESET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_TYPESET, ContactsTypeSet))
#define CONTACTS_TYPESET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_TYPESET, ContactsTypeSetClass))
#define CONTACTS_IS_TYPESET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_TYPESET))
#define CONTACTS_IS_TYPESET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_TYPESET))
#define CONTACTS_TYPESET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_TYPESET, ContactsTypeSetClass))

typedef struct _ContactsTypeSet ContactsTypeSet;
typedef struct _ContactsTypeSetClass ContactsTypeSetClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
typedef struct _ContactsContactEnsureWritablePersonaData ContactsContactEnsureWritablePersonaData;

typedef enum  {
	CONTACT_ERROR_NOT_IMPLEMENTED
} ContactError;
#define CONTACT_ERROR contact_error_quark ()
struct _ContactsContactPresence {
	GtkGrid parent_instance;
	ContactsContactPresencePrivate * priv;
};

struct _ContactsContactPresenceClass {
	GtkGridClass parent_class;
};

struct _ContactsContactPresencePrivate {
	ContactsContact* contact;
	GtkImage* image;
	GtkLabel* label;
	gchar* last_class;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	ContactsContactPresence * self;
	gulong id;
	ContactsContact* contact;
};

struct _ContactsContactPrivate {
	guint changed_id;
	GdkPixbuf* _avatar;
	gchar* filter_data;
};

typedef enum  {
	CONTACTS_CONTACT_IM_DISPLAY_DEFAULT,
	CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE
} ContactsContactImDisplay;

struct _ContactsContactImData {
	const gchar* service;
	const gchar* display_name;
	ContactsContactImDisplay display;
};

struct _Block2Data {
	int _ref_count_;
	ContactsContact * self;
	TpfPersona* tp;
	GtkImage* i;
	gchar* last_class;
	gulong id1;
	gulong id2;
};

struct _ContactsContactEnsureWritablePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ContactsContact* self;
	FolksPersona* result;
	FolksPersona* _tmp0_;
	FolksPersona* p;
	GError* _tmp1_;
	GError * _inner_error_;
};


static gpointer contacts_contact_presence_parent_class = NULL;
static gpointer contacts_contact_parent_class = NULL;
static GdkPixbuf* contacts_contact_fallback_avatar;
static GdkPixbuf* contacts_contact_fallback_avatar = NULL;

GQuark contact_error_quark (void);
GType contacts_contact_presence_get_type (void) G_GNUC_CONST;
GType contacts_contact_get_type (void) G_GNUC_CONST;
#define CONTACTS_CONTACT_PRESENCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_CONTACT_PRESENCE, ContactsContactPresencePrivate))
enum  {
	CONTACTS_CONTACT_PRESENCE_DUMMY_PROPERTY
};
static void contacts_contact_presence_update_presence_widgets (ContactsContactPresence* self, GtkImage* image, GtkLabel* label);
gpointer contacts_store_ref (gpointer instance);
void contacts_store_unref (gpointer instance);
GParamSpec* contacts_param_spec_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void contacts_value_set_store (GValue* value, gpointer v_object);
void contacts_value_take_store (GValue* value, gpointer v_object);
gpointer contacts_value_get_store (const GValue* value);
GType contacts_store_get_type (void) G_GNUC_CONST;
gchar* contacts_contact_presence_to_icon_full (FolksPresenceType presence);
gchar* contacts_contact_presence_to_class (FolksPresenceType presence);
gchar* contacts_contact_presence_to_string (FolksPresenceType presence);
ContactsContactPresence* contacts_contact_presence_new (ContactsContact* contact);
ContactsContactPresence* contacts_contact_presence_construct (GType object_type, ContactsContact* contact);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda1_ (ContactsContactPresence* self);
static void __lambda1__contacts_contact_changed (ContactsContact* _sender, gpointer self);
static void _lambda2_ (Block1Data* _data1_);
static void __lambda2__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void contacts_contact_presence_finalize (GObject* obj);
#define CONTACTS_CONTACT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_CONTACT, ContactsContactPrivate))
enum  {
	CONTACTS_CONTACT_DUMMY_PROPERTY,
	CONTACTS_CONTACT_AVATAR,
	CONTACTS_CONTACT_DISPLAY_NAME
};
static GType contacts_contact_im_display_get_type (void) G_GNUC_UNUSED;
ContactsContact* contacts_contact_from_individual (FolksIndividual* i);
static void contacts_contact_persona_notify_cb (ContactsContact* self, GParamSpec* pspec);
static void contacts_contact_queue_changed (ContactsContact* self);
static void contacts_contact_connect_persona (ContactsContact* self, FolksPersona* p);
static void _contacts_contact_persona_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void contacts_contact_disconnect_persona (ContactsContact* self, FolksPersona* p);
ContactsContact* contacts_contact_new (ContactsStore* store, FolksIndividual* i);
ContactsContact* contacts_contact_construct (GType object_type, ContactsStore* store, FolksIndividual* i);
static void _lambda0_ (GeeSet* added, GeeSet* removed, ContactsContact* self);
static void __lambda0__folks_individual_personas_changed (FolksIndividual* _sender, GeeSet* added, GeeSet* removed, gpointer self);
static void contacts_contact_update (ContactsContact* self);
static void contacts_contact_notify_cb (ContactsContact* self, GParamSpec* pspec);
static void _contacts_contact_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void contacts_contact_remove (ContactsContact* self);
static void contacts_contact_unqueue_changed (ContactsContact* self);
gboolean contacts_contact_contains_strings (ContactsContact* self, gchar** strings, int strings_length1);
gchar* contacts_contact_presence_to_icon (FolksPresenceType presence);
static gchar* contacts_contact_get_first_string (GeeCollection* collection);
static gint contacts_contact_sort_fields_helper (FolksFieldDetails* a, FolksFieldDetails* b);
GList* contacts_contact_sort_fields (GeeSet* details);
static gint _contacts_contact_sort_fields_helper_gcompare_func (gconstpointer a, gconstpointer b);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
gchar** contacts_contact_format_address (FolksPostalAddress* addr, int* result_length1);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value);
TpfPersona* contacts_contact_find_im_persona (ContactsContact* self, const gchar* protocol, const gchar* im_address);
gchar* contacts_contact_format_im_name (ContactsContact* self, const gchar* protocol, const gchar* id);
static GType contacts_contact_im_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ContactsContactImData* contacts_contact_im_data_dup (const ContactsContactImData* self);
static void contacts_contact_im_data_free (ContactsContactImData* self);
GtkWidget* contacts_contact_create_merged_presence_widget (ContactsContact* self);
GtkWidget* contacts_contact_create_presence_widget (ContactsContact* self, const gchar* protocol, const gchar* im_address);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void _lambda3_ (GParamSpec* pspec, Block2Data* _data2_);
static void __lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda4_ (GParamSpec* pspec, Block2Data* _data2_);
static void __lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda5_ (Block2Data* _data2_);
static void __lambda5__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static gboolean contacts_contact_changed_cb (ContactsContact* self);
static gboolean _contacts_contact_changed_cb_gsource_func (gpointer self);
static gboolean contacts_contact_get_is_phone (FolksPersona* persona);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void contacts_contact_update_presence (ContactsContact* self);
static void contacts_contact_update_filter_data (ContactsContact* self);
GType contacts_typeset_get_type (void) G_GNUC_CONST;
ContactsTypeSet* contacts_typeset_get_general (void);
void contacts_typeset_type_seen (ContactsTypeSet* self, FolksFieldDetails* detail);
ContactsTypeSet* contacts_typeset_get_phone (void);
static GdkPixbuf* contacts_contact_load_icon (ContactsContact* self, GFile* file);
static void contacts_contact_cairo_ellipsis (cairo_t* cr, gdouble xc, gdouble yc, gdouble xradius, gdouble yradius, gdouble angle1, gdouble angle2);
static void contacts_contact_rounded_box_path (cairo_t* cr, gint x, gint y, gint width, gint height, gint radius);
static GdkPixbuf* contacts_contact_frame_icon (GdkPixbuf* icon);
GdkPixbuf* contacts_contact_draw_fallback_avatar (gint size);
gchar* contacts_contact_format_uri_link_text (FolksFieldDetails* detail);
static void contacts_contact_ensure_writable_persona_data_free (gpointer _data);
void contacts_contact_ensure_writable_persona (ContactsContact* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
FolksPersona* contacts_contact_ensure_writable_persona_finish (ContactsContact* self, GAsyncResult* _res_, GError** error);
static gboolean contacts_contact_ensure_writable_persona_co (ContactsContactEnsureWritablePersonaData* _data_);
FolksPersona* contacts_contact_find_writable_persona (ContactsContact* self);
FolksIndividualAggregator* contacts_store_get_aggregator (ContactsStore* self);
GdkPixbuf* contacts_contact_get_avatar (ContactsContact* self);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
static void contacts_contact_finalize (GObject* obj);
static void _vala_contacts_contact_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static GRegex* _tmp_regex_0 = NULL;
static GRegex* _tmp_regex_1 = NULL;
static GRegex* _tmp_regex_2 = NULL;

GQuark contact_error_quark (void) {
	return g_quark_from_static_string ("contact_error-quark");
}


static void contacts_contact_presence_update_presence_widgets (ContactsContactPresence* self, GtkImage* image, GtkLabel* label) {
	FolksPresenceType type = 0;
	gchar* message = NULL;
	gboolean is_phone = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp4_ = NULL;
	GtkStyleContext* _tmp5_ = NULL;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	g_return_if_fail (label != NULL);
	type = self->priv->contact->presence_type;
	_tmp0_ = g_strdup (self->priv->contact->presence_message);
	_g_free0 (message);
	message = _tmp0_;
	is_phone = self->priv->contact->is_phone;
	if (type == FOLKS_PRESENCE_TYPE_UNSET) {
		gtk_image_clear (image);
		gtk_widget_hide ((GtkWidget*) image);
		gtk_widget_hide ((GtkWidget*) label);
		gtk_label_set_text (label, "");
		_g_free0 (message);
		return;
	}
	_tmp1_ = contacts_contact_presence_to_icon_full (type);
	_tmp2_ = _tmp1_;
	gtk_image_set_from_icon_name (image, _tmp2_, GTK_ICON_SIZE_MENU);
	_g_free0 (_tmp2_);
	if (self->priv->last_class != NULL) {
		GtkStyleContext* _tmp3_ = NULL;
		_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) image);
		gtk_style_context_remove_class (_tmp3_, self->priv->last_class);
	}
	_tmp4_ = contacts_contact_presence_to_class (type);
	_g_free0 (self->priv->last_class);
	self->priv->last_class = _tmp4_;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) image);
	gtk_style_context_add_class (_tmp5_, self->priv->last_class);
	gtk_widget_show ((GtkWidget*) image);
	gtk_widget_show ((GtkWidget*) label);
	_tmp6_ = strlen (message);
	if (_tmp6_ == 0) {
		gchar* _tmp7_ = NULL;
		_tmp7_ = contacts_contact_presence_to_string (type);
		_g_free0 (message);
		message = _tmp7_;
	}
	if (is_phone) {
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = g_markup_escape_text (message, (gssize) (-1));
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp9_, " <span color='#8e9192'>(via phone)</span>", NULL);
		_tmp11_ = _tmp10_;
		gtk_label_set_markup (label, _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	} else {
		gtk_label_set_text (label, message);
	}
	_g_free0 (message);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->contact);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda1_ (ContactsContactPresence* self) {
	contacts_contact_presence_update_presence_widgets (self, self->priv->image, self->priv->label);
}


static void __lambda1__contacts_contact_changed (ContactsContact* _sender, gpointer self) {
	_lambda1_ (self);
}


static void _lambda2_ (Block1Data* _data1_) {
	ContactsContactPresence * self;
	self = _data1_->self;
	g_signal_handler_disconnect ((GObject*) _data1_->contact, _data1_->id);
}


static void __lambda2__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	_lambda2_ (self);
}


ContactsContactPresence* contacts_contact_presence_construct (GType object_type, ContactsContact* contact) {
	ContactsContactPresence * self = NULL;
	Block1Data* _data1_;
	ContactsContact* _tmp0_;
	GtkImage* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	gulong _tmp3_;
	g_return_val_if_fail (contact != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->contact = _g_object_ref0 (contact);
	self = (ContactsContactPresence*) g_object_new (object_type, NULL);
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (_data1_->contact);
	_g_object_unref0 (self->priv->contact);
	self->priv->contact = _tmp0_;
	gtk_grid_set_row_spacing ((GtkGrid*) self, (guint) 4);
	_tmp1_ = (GtkImage*) gtk_image_new ();
	_g_object_unref0 (self->priv->image);
	self->priv->image = g_object_ref_sink (_tmp1_);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->image, TRUE);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->image);
	_tmp2_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->label);
	self->priv->label = g_object_ref_sink (_tmp2_);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->label, TRUE);
	gtk_label_set_ellipsize (self->priv->label, PANGO_ELLIPSIZE_END);
	g_object_set ((GtkMisc*) self->priv->label, "xalign", 0.0f, NULL);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->label);
	contacts_contact_presence_update_presence_widgets (self, self->priv->image, self->priv->label);
	_tmp3_ = g_signal_connect_object (_data1_->contact, "changed", (GCallback) __lambda1__contacts_contact_changed, self, 0);
	_data1_->id = _tmp3_;
	g_signal_connect_data ((GtkWidget*) self, "destroy", (GCallback) __lambda2__gtk_widget_destroy, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}


ContactsContactPresence* contacts_contact_presence_new (ContactsContact* contact) {
	return contacts_contact_presence_construct (CONTACTS_TYPE_CONTACT_PRESENCE, contact);
}


static void contacts_contact_presence_class_init (ContactsContactPresenceClass * klass) {
	contacts_contact_presence_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsContactPresencePrivate));
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_presence_finalize;
}


static void contacts_contact_presence_instance_init (ContactsContactPresence * self) {
	self->priv = CONTACTS_CONTACT_PRESENCE_GET_PRIVATE (self);
}


static void contacts_contact_presence_finalize (GObject* obj) {
	ContactsContactPresence * self;
	self = CONTACTS_CONTACT_PRESENCE (obj);
	_g_object_unref0 (self->priv->contact);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->label);
	_g_free0 (self->priv->last_class);
	G_OBJECT_CLASS (contacts_contact_presence_parent_class)->finalize (obj);
}


GType contacts_contact_presence_get_type (void) {
	static volatile gsize contacts_contact_presence_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_presence_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsContactPresenceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_presence_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactPresence), 0, (GInstanceInitFunc) contacts_contact_presence_instance_init, NULL };
		GType contacts_contact_presence_type_id;
		contacts_contact_presence_type_id = g_type_register_static (GTK_TYPE_GRID, "ContactsContactPresence", &g_define_type_info, 0);
		g_once_init_leave (&contacts_contact_presence_type_id__volatile, contacts_contact_presence_type_id);
	}
	return contacts_contact_presence_type_id__volatile;
}


static GType contacts_contact_im_display_get_type (void) {
	static volatile gsize contacts_contact_im_display_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_im_display_type_id__volatile)) {
		static const GEnumValue values[] = {{CONTACTS_CONTACT_IM_DISPLAY_DEFAULT, "CONTACTS_CONTACT_IM_DISPLAY_DEFAULT", "default"}, {CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE, "CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE", "alias-service"}, {0, NULL, NULL}};
		GType contacts_contact_im_display_type_id;
		contacts_contact_im_display_type_id = g_enum_register_static ("ContactsContactImDisplay", values);
		g_once_init_leave (&contacts_contact_im_display_type_id__volatile, contacts_contact_im_display_type_id);
	}
	return contacts_contact_im_display_type_id__volatile;
}


ContactsContact* contacts_contact_from_individual (FolksIndividual* i) {
	ContactsContact* result = NULL;
	gconstpointer _tmp0_ = NULL;
	ContactsContact* _tmp1_;
	g_return_val_if_fail (i != NULL, NULL);
	_tmp0_ = g_object_get_data ((GObject*) i, "contact");
	_tmp1_ = _g_object_ref0 ((ContactsContact*) _tmp0_);
	result = _tmp1_;
	return result;
}


static void contacts_contact_persona_notify_cb (ContactsContact* self, GParamSpec* pspec) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	contacts_contact_queue_changed (self);
}


static void _contacts_contact_persona_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	contacts_contact_persona_notify_cb (self, pspec);
}


static void contacts_contact_connect_persona (ContactsContact* self, FolksPersona* p) {
	FolksPersona* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* tp;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	g_signal_connect_object ((GObject*) p, "notify::presence-type", (GCallback) _contacts_contact_persona_notify_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) p, "notify::presence-message", (GCallback) _contacts_contact_persona_notify_cb_g_object_notify, self, 0);
	_tmp0_ = p;
	_tmp1_ = _g_object_ref0 (TPF_IS_PERSONA (_tmp0_) ? ((TpfPersona*) _tmp0_) : NULL);
	tp = _tmp1_;
	if (tp != NULL) {
		TpContact* _tmp3_ = NULL;
		_tmp3_ = tpf_persona_get_contact (tp);
		_tmp2_ = _tmp3_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		TpContact* _tmp4_ = NULL;
		_tmp4_ = tpf_persona_get_contact (tp);
		g_signal_connect_object ((GObject*) _tmp4_, "notify::client-types", (GCallback) _contacts_contact_persona_notify_cb_g_object_notify, self, 0);
	}
	_g_object_unref0 (tp);
}


static void contacts_contact_disconnect_persona (ContactsContact* self, FolksPersona* p) {
	FolksPersona* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* tp;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	g_signal_handlers_disconnect_by_func (self->individual, (void*) contacts_contact_persona_notify_cb, self);
	_tmp0_ = p;
	_tmp1_ = _g_object_ref0 (TPF_IS_PERSONA (_tmp0_) ? ((TpfPersona*) _tmp0_) : NULL);
	tp = _tmp1_;
	if (tp != NULL) {
		TpContact* _tmp3_ = NULL;
		_tmp3_ = tpf_persona_get_contact (tp);
		_tmp2_ = _tmp3_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		TpContact* _tmp4_ = NULL;
		_tmp4_ = tpf_persona_get_contact (tp);
		g_signal_handlers_disconnect_by_func (_tmp4_, (void*) contacts_contact_persona_notify_cb, self);
	}
	_g_object_unref0 (tp);
}


static gpointer _contacts_store_ref0 (gpointer self) {
	return self ? contacts_store_ref (self) : NULL;
}


static void _lambda0_ (GeeSet* added, GeeSet* removed, ContactsContact* self) {
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _p_it;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) added);
		_p_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksPersona* p;
			_tmp1_ = gee_iterator_next (_p_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_p_it);
			p = (FolksPersona*) _tmp2_;
			contacts_contact_connect_persona (self, p);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	{
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _p_it;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) removed);
		_p_it = _tmp3_;
		while (TRUE) {
			gboolean _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksPersona* p;
			_tmp4_ = gee_iterator_next (_p_it);
			if (!_tmp4_) {
				break;
			}
			_tmp5_ = gee_iterator_get (_p_it);
			p = (FolksPersona*) _tmp5_;
			contacts_contact_disconnect_persona (self, p);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
}


static void __lambda0__folks_individual_personas_changed (FolksIndividual* _sender, GeeSet* added, GeeSet* removed, gpointer self) {
	_lambda0_ (added, removed, self);
}


static void _contacts_contact_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	contacts_contact_notify_cb (self, pspec);
}


ContactsContact* contacts_contact_construct (GType object_type, ContactsStore* store, FolksIndividual* i) {
	ContactsContact * self = NULL;
	ContactsStore* _tmp0_;
	FolksIndividual* _tmp1_;
	ContactsContact* _tmp2_;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (i != NULL, NULL);
	self = (ContactsContact*) g_object_new (object_type, NULL);
	_tmp0_ = _contacts_store_ref0 (store);
	_contacts_store_unref0 (self->store);
	self->store = _tmp0_;
	_tmp1_ = _g_object_ref0 (i);
	_g_object_unref0 (self->individual);
	self->individual = _tmp1_;
	_tmp2_ = _g_object_ref0 (self);
	g_object_set_data_full ((GObject*) self->individual, "contact", _tmp2_, g_object_unref);
	{
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _p_it;
		_tmp3_ = folks_individual_get_personas (self->individual);
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_p_it = _tmp4_;
		while (TRUE) {
			gboolean _tmp5_;
			gpointer _tmp6_ = NULL;
			FolksPersona* p;
			_tmp5_ = gee_iterator_next (_p_it);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = gee_iterator_get (_p_it);
			p = (FolksPersona*) _tmp6_;
			contacts_contact_connect_persona (self, p);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	g_signal_connect_object (self->individual, "personas-changed", (GCallback) __lambda0__folks_individual_personas_changed, self, 0);
	contacts_contact_update (self);
	g_signal_connect_object ((GObject*) self->individual, "notify", (GCallback) _contacts_contact_notify_cb_g_object_notify, self, 0);
	return self;
}


ContactsContact* contacts_contact_new (ContactsStore* store, FolksIndividual* i) {
	return contacts_contact_construct (CONTACTS_TYPE_CONTACT, store, i);
}


void contacts_contact_remove (ContactsContact* self) {
	guint _tmp4_;
	g_return_if_fail (self != NULL);
	contacts_contact_unqueue_changed (self);
	{
		GeeSet* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _p_it;
		_tmp0_ = folks_individual_get_personas (self->individual);
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_p_it = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			gpointer _tmp3_ = NULL;
			FolksPersona* p;
			_tmp2_ = gee_iterator_next (_p_it);
			if (!_tmp2_) {
				break;
			}
			_tmp3_ = gee_iterator_get (_p_it);
			p = (FolksPersona*) _tmp3_;
			contacts_contact_disconnect_persona (self, p);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) self->individual, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _contacts_contact_notify_cb_g_object_notify, self);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


gboolean contacts_contact_contains_strings (ContactsContact* self, gchar** strings, int strings_length1) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gchar** i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it;
		i_collection = strings;
		i_collection_length1 = strings_length1;
		for (i_it = 0; i_it < strings_length1; i_it = i_it + 1) {
			gchar* _tmp0_;
			gchar* i = NULL;
			_tmp0_ = g_strdup (i_collection[i_it]);
			i = _tmp0_;
			{
				gboolean _tmp1_;
				_tmp1_ = string_contains (self->priv->filter_data, i);
				if (!_tmp1_) {
					result = FALSE;
					_g_free0 (i);
					return result;
				}
				_g_free0 (i);
			}
		}
	}
	result = TRUE;
	return result;
}


gchar* contacts_contact_presence_to_string (FolksPresenceType presence) {
	gchar* result = NULL;
	switch (presence) {
		default:
		case FOLKS_PRESENCE_TYPE_UNKNOWN:
		{
			const gchar* _tmp0_ = NULL;
			gchar* _tmp1_;
			_tmp0_ = _ ("Unknown status");
			_tmp1_ = g_strdup (_tmp0_);
			result = _tmp1_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_OFFLINE:
		{
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			_tmp2_ = _ ("Offline");
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_UNSET:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("");
			result = _tmp4_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_ERROR:
		{
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			_tmp5_ = _ ("Error");
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_AVAILABLE:
		{
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			_tmp7_ = _ ("Available");
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_AWAY:
		{
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			_tmp9_ = _ ("Away");
			_tmp10_ = g_strdup (_tmp9_);
			result = _tmp10_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_EXTENDED_AWAY:
		{
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			_tmp11_ = _ ("Extended away");
			_tmp12_ = g_strdup (_tmp11_);
			result = _tmp12_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_BUSY:
		{
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			_tmp13_ = _ ("Busy");
			_tmp14_ = g_strdup (_tmp13_);
			result = _tmp14_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_HIDDEN:
		{
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			_tmp15_ = _ ("Hidden");
			_tmp16_ = g_strdup (_tmp15_);
			result = _tmp16_;
			return result;
		}
	}
}


gchar* contacts_contact_presence_to_icon (FolksPresenceType presence) {
	gchar* result = NULL;
	gchar* iconname;
	iconname = NULL;
	switch (presence) {
		default:
		case FOLKS_PRESENCE_TYPE_OFFLINE:
		case FOLKS_PRESENCE_TYPE_UNSET:
		case FOLKS_PRESENCE_TYPE_ERROR:
		{
			break;
		}
		case FOLKS_PRESENCE_TYPE_AVAILABLE:
		case FOLKS_PRESENCE_TYPE_UNKNOWN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("user-available-symbolic");
			_g_free0 (iconname);
			iconname = _tmp0_;
			break;
		}
		case FOLKS_PRESENCE_TYPE_AWAY:
		case FOLKS_PRESENCE_TYPE_EXTENDED_AWAY:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("user-away-symbolic");
			_g_free0 (iconname);
			iconname = _tmp1_;
			break;
		}
		case FOLKS_PRESENCE_TYPE_BUSY:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("user-busy-symbolic");
			_g_free0 (iconname);
			iconname = _tmp2_;
			break;
		}
		case FOLKS_PRESENCE_TYPE_HIDDEN:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("user-invisible-symbolic");
			_g_free0 (iconname);
			iconname = _tmp3_;
			break;
		}
	}
	result = iconname;
	return result;
}


gchar* contacts_contact_presence_to_icon_full (FolksPresenceType presence) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* iconname;
	gchar* _tmp1_;
	_tmp0_ = contacts_contact_presence_to_icon (presence);
	iconname = _tmp0_;
	if (iconname != NULL) {
		result = iconname;
		return result;
	}
	_tmp1_ = g_strdup ("user-offline-symbolic");
	result = _tmp1_;
	_g_free0 (iconname);
	return result;
}


gchar* contacts_contact_presence_to_class (FolksPresenceType presence) {
	gchar* result = NULL;
	gchar* classname;
	classname = NULL;
	switch (presence) {
		default:
		case FOLKS_PRESENCE_TYPE_HIDDEN:
		case FOLKS_PRESENCE_TYPE_OFFLINE:
		case FOLKS_PRESENCE_TYPE_UNSET:
		case FOLKS_PRESENCE_TYPE_ERROR:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("presence-icon-offline");
			_g_free0 (classname);
			classname = _tmp0_;
			break;
		}
		case FOLKS_PRESENCE_TYPE_AVAILABLE:
		case FOLKS_PRESENCE_TYPE_UNKNOWN:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("presence-icon-available");
			_g_free0 (classname);
			classname = _tmp1_;
			break;
		}
		case FOLKS_PRESENCE_TYPE_AWAY:
		case FOLKS_PRESENCE_TYPE_EXTENDED_AWAY:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("presence-icon-away");
			_g_free0 (classname);
			classname = _tmp2_;
			break;
		}
		case FOLKS_PRESENCE_TYPE_BUSY:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("presence-icon-busy");
			_g_free0 (classname);
			classname = _tmp3_;
			break;
		}
	}
	result = classname;
	return result;
}


static gchar* contacts_contact_get_first_string (GeeCollection* collection) {
	gchar* result = NULL;
	GeeIterator* _tmp0_ = NULL;
	GeeIterator* i;
	gboolean _tmp1_;
	g_return_val_if_fail (collection != NULL, NULL);
	_tmp0_ = gee_iterable_iterator ((GeeIterable*) collection);
	i = _tmp0_;
	_tmp1_ = gee_iterator_next (i);
	if (_tmp1_) {
		gpointer _tmp2_ = NULL;
		_tmp2_ = gee_iterator_get (i);
		result = (gchar*) _tmp2_;
		_g_object_unref0 (i);
		return result;
	}
	result = NULL;
	_g_object_unref0 (i);
	return result;
}


static gint contacts_contact_sort_fields_helper (FolksFieldDetails* a, FolksFieldDetails* b) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = folks_field_details_get_value (a);
	_tmp1_ = folks_field_details_get_value (b);
	_tmp2_ = g_strcmp0 (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gint _contacts_contact_sort_fields_helper_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = contacts_contact_sort_fields_helper (a, b);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


GList* contacts_contact_sort_fields (GeeSet* details) {
	GList* result = NULL;
	GList* pref;
	GList* rest;
	GList* _tmp20_;
	g_return_val_if_fail (details != NULL, NULL);
	pref = NULL;
	rest = NULL;
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _detail_it;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) details);
		_detail_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksFieldDetails* detail;
			GeeMultiMap* _tmp3_ = NULL;
			GeeCollection* _tmp4_ = NULL;
			GeeCollection* _tmp5_;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			gboolean _tmp8_;
			_tmp1_ = gee_iterator_next (_detail_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_detail_it);
			detail = (FolksFieldDetails*) _tmp2_;
			_tmp3_ = folks_field_details_get_parameters (detail);
			_tmp4_ = gee_multi_map_get (_tmp3_, "x-evolution-ui-slot");
			_tmp5_ = _tmp4_;
			_tmp6_ = contacts_contact_get_first_string (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strcmp0 (_tmp7_, "1") == 0;
			_g_free0 (_tmp7_);
			_g_object_unref0 (_tmp5_);
			if (_tmp8_) {
				FolksFieldDetails* _tmp9_;
				_tmp9_ = _g_object_ref0 (detail);
				pref = g_list_prepend (pref, _tmp9_);
			} else {
				gboolean found;
				found = FALSE;
				{
					GeeMultiMap* _tmp10_ = NULL;
					GeeCollection* _tmp11_ = NULL;
					GeeCollection* _tmp12_;
					GeeIterator* _tmp13_ = NULL;
					GeeIterator* _tmp14_;
					GeeIterator* _param_it;
					_tmp10_ = folks_field_details_get_parameters (detail);
					_tmp11_ = gee_multi_map_get (_tmp10_, "type");
					_tmp12_ = _tmp11_;
					_tmp13_ = gee_iterable_iterator ((GeeIterable*) _tmp12_);
					_tmp14_ = _tmp13_;
					_g_object_unref0 (_tmp12_);
					_param_it = _tmp14_;
					while (TRUE) {
						gboolean _tmp15_;
						gpointer _tmp16_ = NULL;
						gchar* param;
						gint _tmp17_;
						_tmp15_ = gee_iterator_next (_param_it);
						if (!_tmp15_) {
							break;
						}
						_tmp16_ = gee_iterator_get (_param_it);
						param = (gchar*) _tmp16_;
						_tmp17_ = g_ascii_strcasecmp (param, "PREF");
						if (_tmp17_ == 0) {
							found = TRUE;
							_g_free0 (param);
							break;
						}
						_g_free0 (param);
					}
					_g_object_unref0 (_param_it);
				}
				if (found) {
					FolksFieldDetails* _tmp18_;
					_tmp18_ = _g_object_ref0 (detail);
					pref = g_list_prepend (pref, _tmp18_);
				} else {
					FolksFieldDetails* _tmp19_;
					_tmp19_ = _g_object_ref0 (detail);
					rest = g_list_prepend (rest, _tmp19_);
				}
			}
			_g_object_unref0 (detail);
		}
		_g_object_unref0 (_detail_it);
	}
	pref = g_list_sort (pref, _contacts_contact_sort_fields_helper_gcompare_func);
	rest = g_list_sort (rest, _contacts_contact_sort_fields_helper_gcompare_func);
	_tmp20_ = rest;
	rest = NULL;
	pref = g_list_concat (pref, _tmp20_);
	result = pref;
	__g_list_free__g_object_unref0_0 (rest);
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar** contacts_contact_format_address (FolksPostalAddress* addr, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** lines;
	gint lines_length1;
	gint _lines_size_;
	gchar* str = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	gboolean _tmp23_ = FALSE;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	gboolean _tmp28_ = FALSE;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_;
	gboolean _tmp33_ = FALSE;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	gboolean _tmp38_ = FALSE;
	gchar** _tmp41_;
	g_return_val_if_fail (addr != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	lines = _tmp0_;
	lines_length1 = 0;
	_lines_size_ = lines_length1;
	_tmp1_ = folks_postal_address_get_street (addr);
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (str);
	str = _tmp2_;
	if (str != NULL) {
		gint _tmp4_;
		_tmp4_ = strlen (str);
		_tmp3_ = _tmp4_ > 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (str);
		_vala_array_add1 (&lines, &lines_length1, &_lines_size_, _tmp5_);
	}
	_tmp6_ = folks_postal_address_get_extension (addr);
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (str);
	str = _tmp7_;
	if (str != NULL) {
		gint _tmp9_;
		_tmp9_ = strlen (str);
		_tmp8_ = _tmp9_ > 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup (str);
		_vala_array_add2 (&lines, &lines_length1, &_lines_size_, _tmp10_);
	}
	_tmp11_ = folks_postal_address_get_locality (addr);
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (str);
	str = _tmp12_;
	if (str != NULL) {
		gint _tmp14_;
		_tmp14_ = strlen (str);
		_tmp13_ = _tmp14_ > 0;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gchar* _tmp15_;
		_tmp15_ = g_strdup (str);
		_vala_array_add3 (&lines, &lines_length1, &_lines_size_, _tmp15_);
	}
	_tmp16_ = folks_postal_address_get_region (addr);
	_tmp17_ = g_strdup (_tmp16_);
	_g_free0 (str);
	str = _tmp17_;
	if (str != NULL) {
		gint _tmp19_;
		_tmp19_ = strlen (str);
		_tmp18_ = _tmp19_ > 0;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		gchar* _tmp20_;
		_tmp20_ = g_strdup (str);
		_vala_array_add4 (&lines, &lines_length1, &_lines_size_, _tmp20_);
	}
	_tmp21_ = folks_postal_address_get_postal_code (addr);
	_tmp22_ = g_strdup (_tmp21_);
	_g_free0 (str);
	str = _tmp22_;
	if (str != NULL) {
		gint _tmp24_;
		_tmp24_ = strlen (str);
		_tmp23_ = _tmp24_ > 0;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		gchar* _tmp25_;
		_tmp25_ = g_strdup (str);
		_vala_array_add5 (&lines, &lines_length1, &_lines_size_, _tmp25_);
	}
	_tmp26_ = folks_postal_address_get_po_box (addr);
	_tmp27_ = g_strdup (_tmp26_);
	_g_free0 (str);
	str = _tmp27_;
	if (str != NULL) {
		gint _tmp29_;
		_tmp29_ = strlen (str);
		_tmp28_ = _tmp29_ > 0;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		gchar* _tmp30_;
		_tmp30_ = g_strdup (str);
		_vala_array_add6 (&lines, &lines_length1, &_lines_size_, _tmp30_);
	}
	_tmp31_ = folks_postal_address_get_country (addr);
	_tmp32_ = g_strdup (_tmp31_);
	_g_free0 (str);
	str = _tmp32_;
	if (str != NULL) {
		gint _tmp34_;
		_tmp34_ = strlen (str);
		_tmp33_ = _tmp34_ > 0;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		gchar* _tmp35_;
		_tmp35_ = g_strdup (str);
		_vala_array_add7 (&lines, &lines_length1, &_lines_size_, _tmp35_);
	}
	_tmp36_ = folks_postal_address_get_address_format (addr);
	_tmp37_ = g_strdup (_tmp36_);
	_g_free0 (str);
	str = _tmp37_;
	if (str != NULL) {
		gint _tmp39_;
		_tmp39_ = strlen (str);
		_tmp38_ = _tmp39_ > 0;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		gchar* _tmp40_;
		_tmp40_ = g_strdup (str);
		_vala_array_add8 (&lines, &lines_length1, &_lines_size_, _tmp40_);
	}
	_tmp41_ = lines;
	if (result_length1) {
		*result_length1 = lines_length1;
	}
	result = _tmp41_;
	_g_free0 (str);
	return result;
}


TpfPersona* contacts_contact_find_im_persona (ContactsContact* self, const gchar* protocol, const gchar* im_address) {
	TpfPersona* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* iid;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	g_return_val_if_fail (im_address != NULL, NULL);
	_tmp0_ = g_strconcat (protocol, ":", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, im_address, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	iid = _tmp3_;
	{
		GeeSet* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _p_it;
		_tmp4_ = folks_individual_get_personas (self->individual);
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_p_it = _tmp5_;
		while (TRUE) {
			gboolean _tmp6_;
			gpointer _tmp7_ = NULL;
			FolksPersona* p;
			FolksPersona* _tmp8_;
			TpfPersona* _tmp9_;
			TpfPersona* tp;
			gboolean _tmp10_ = FALSE;
			_tmp6_ = gee_iterator_next (_p_it);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = gee_iterator_get (_p_it);
			p = (FolksPersona*) _tmp7_;
			_tmp8_ = p;
			_tmp9_ = _g_object_ref0 (TPF_IS_PERSONA (_tmp8_) ? ((TpfPersona*) _tmp8_) : NULL);
			tp = _tmp9_;
			if (tp != NULL) {
				const gchar* _tmp11_ = NULL;
				_tmp11_ = folks_persona_get_iid ((FolksPersona*) tp);
				_tmp10_ = g_strcmp0 (_tmp11_, iid) == 0;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				result = tp;
				_g_object_unref0 (p);
				_g_object_unref0 (_p_it);
				_g_free0 (iid);
				return result;
			}
			_g_object_unref0 (tp);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = NULL;
	_g_free0 (iid);
	return result;
}


gchar* contacts_contact_format_im_name (ContactsContact* self, const gchar* protocol, const gchar* id) {
	gchar* result = NULL;
	gchar* service;
	TpfPersona* _tmp0_ = NULL;
	TpfPersona* persona;
	gboolean _tmp6_ = FALSE;
	static const ContactsContactImData data[] = {{"google-talk", "Google Talk"}, {"ovi-chat", "Ovi Chat"}, {"facebook", "Facebook", CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE}, {"lj-talk", "Livejournal"}, {"aim", "AOL Instant Messenger"}, {"gadugadu", "Gadu-Gadu"}, {"groupwise", "Novell Groupwise"}, {"icq", "ICQ"}, {"irc", "IRC"}, {"jabber", "Jabber"}, {"local-xmpp", "Local network"}, {"msn", "Windows Live Messenger"}, {"myspace", "MySpace"}, {"mxit", "MXit"}, {"napster", "Napster"}, {"qq", "Tencent QQ"}, {"sametime", "IBM Lotus Sametime"}, {"silc", "SILC"}, {"sip", "sip"}, {"skype", "Skype"}, {"tel", "Telephony"}, {"trepia", "Trepia"}, {"yahoo", "Yahoo! Messenger"}, {"yahoojp", "Yahoo! Messenger"}, {"zephyr", "Zephyr"}};
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	service = NULL;
	_tmp0_ = contacts_contact_find_im_persona (self, protocol, id);
	persona = _tmp0_;
	if (persona != NULL) {
		FolksPersonaStore* _tmp1_ = NULL;
		FolksPersonaStore* _tmp2_;
		TpAccount* _tmp3_ = NULL;
		TpAccount* _tmp4_;
		TpAccount* account;
		gchar* _tmp5_ = NULL;
		_tmp1_ = folks_persona_get_store ((FolksPersona*) persona);
		_tmp2_ = _tmp1_;
		_tmp3_ = tpf_persona_store_get_account (TPF_IS_PERSONA_STORE (_tmp2_) ? ((TpfPersonaStore*) _tmp2_) : NULL);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		account = _tmp4_;
		g_object_get (account, "service", &_tmp5_, NULL);
		_g_free0 (service);
		service = _tmp5_;
		_g_object_unref0 (account);
	}
	if (service == NULL) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = g_strcmp0 (service, "") == 0;
	}
	if (_tmp6_) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup (protocol);
		_g_free0 (service);
		service = _tmp7_;
	}
	{
		ContactsContactImData* d_collection = NULL;
		gint d_collection_length1 = 0;
		gint _d_collection_size_ = 0;
		gint d_it;
		d_collection = data;
		d_collection_length1 = G_N_ELEMENTS (data);
		for (d_it = 0; d_it < G_N_ELEMENTS (data); d_it = d_it + 1) {
			ContactsContactImData d = {0};
			d = d_collection[d_it];
			{
				if (g_strcmp0 (d.service, service) == 0) {
					switch (d.display) {
						default:
						case CONTACTS_CONTACT_IM_DISPLAY_DEFAULT:
						{
							gchar* _tmp8_;
							gchar* _tmp9_;
							const gchar* _tmp10_ = NULL;
							gchar* _tmp11_;
							gchar* _tmp12_;
							gchar* _tmp13_;
							gchar* _tmp14_;
							_tmp8_ = g_strconcat (id, " (", NULL);
							_tmp9_ = _tmp8_;
							_tmp10_ = g_dgettext (GETTEXT_PACKAGE, d.display_name);
							_tmp11_ = g_strconcat (_tmp9_, _tmp10_, NULL);
							_tmp12_ = _tmp11_;
							_tmp13_ = g_strconcat (_tmp12_, ")", NULL);
							_tmp14_ = _tmp13_;
							_g_free0 (_tmp12_);
							_g_free0 (_tmp9_);
							result = _tmp14_;
							_g_object_unref0 (persona);
							_g_free0 (service);
							return result;
						}
						case CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE:
						{
							const gchar* _tmp15_ = NULL;
							gchar* _tmp16_;
							gchar* _tmp17_;
							const gchar* _tmp18_ = NULL;
							gchar* _tmp19_;
							gchar* _tmp20_;
							gchar* _tmp21_;
							gchar* _tmp22_;
							_tmp15_ = folks_alias_details_get_alias ((FolksAliasDetails*) persona);
							_tmp16_ = g_strconcat (_tmp15_, " (", NULL);
							_tmp17_ = _tmp16_;
							_tmp18_ = g_dgettext (GETTEXT_PACKAGE, d.display_name);
							_tmp19_ = g_strconcat (_tmp17_, _tmp18_, NULL);
							_tmp20_ = _tmp19_;
							_tmp21_ = g_strconcat (_tmp20_, ")", NULL);
							_tmp22_ = _tmp21_;
							_g_free0 (_tmp20_);
							_g_free0 (_tmp17_);
							result = _tmp22_;
							_g_object_unref0 (persona);
							_g_free0 (service);
							return result;
						}
					}
				}
			}
		}
	}
	_tmp23_ = g_strconcat (id, " (", NULL);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strconcat (_tmp24_, protocol, NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat (_tmp26_, ")", NULL);
	_tmp28_ = _tmp27_;
	_g_free0 (_tmp26_);
	_g_free0 (_tmp24_);
	result = _tmp28_;
	_g_object_unref0 (persona);
	_g_free0 (service);
	return result;
}


GtkWidget* contacts_contact_create_merged_presence_widget (ContactsContact* self) {
	GtkWidget* result = NULL;
	ContactsContactPresence* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = contacts_contact_presence_new (self);
	result = (GtkWidget*) g_object_ref_sink (_tmp0_);
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_free0 (_data2_->last_class);
		_g_object_unref0 (_data2_->i);
		_g_object_unref0 (_data2_->tp);
		g_slice_free (Block2Data, _data2_);
	}
}


static void _lambda3_ (GParamSpec* pspec, Block2Data* _data2_) {
	ContactsContact * self;
	FolksPresenceType _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GtkStyleContext* _tmp3_ = NULL;
	FolksPresenceType _tmp4_;
	gchar* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_ = NULL;
	self = _data2_->self;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = folks_presence_details_get_presence_type ((FolksPresenceDetails*) _data2_->tp);
	_tmp1_ = contacts_contact_presence_to_icon_full (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_image_set_from_icon_name (_data2_->i, _tmp2_, GTK_ICON_SIZE_MENU);
	_g_free0 (_tmp2_);
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _data2_->i);
	gtk_style_context_remove_class (_tmp3_, _data2_->last_class);
	_tmp4_ = folks_presence_details_get_presence_type ((FolksPresenceDetails*) _data2_->tp);
	_tmp5_ = contacts_contact_presence_to_class (_tmp4_);
	_g_free0 (_data2_->last_class);
	_data2_->last_class = _tmp5_;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _data2_->i);
	gtk_style_context_add_class (_tmp6_, _data2_->last_class);
}


static void __lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda3_ (pspec, self);
}


static void _lambda4_ (GParamSpec* pspec, Block2Data* _data2_) {
	ContactsContact * self;
	const gchar* _tmp0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = folks_presence_details_get_presence_message ((FolksPresenceDetails*) _data2_->tp);
	gtk_widget_set_tooltip_text ((GtkWidget*) _data2_->i, _tmp0_);
}


static void __lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda4_ (pspec, self);
}


static void _lambda5_ (Block2Data* _data2_) {
	ContactsContact * self;
	self = _data2_->self;
	g_signal_handler_disconnect ((GObject*) _data2_->tp, _data2_->id1);
	g_signal_handler_disconnect ((GObject*) _data2_->tp, _data2_->id2);
}


static void __lambda5__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	_lambda5_ (self);
}


GtkWidget* contacts_contact_create_presence_widget (ContactsContact* self, const gchar* protocol, const gchar* im_address) {
	GtkWidget* result = NULL;
	Block2Data* _data2_;
	TpfPersona* _tmp0_ = NULL;
	GtkImage* _tmp1_ = NULL;
	FolksPresenceType _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	FolksPresenceType _tmp5_;
	gchar* _tmp6_ = NULL;
	GtkStyleContext* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gulong _tmp9_;
	gulong _tmp10_;
	GtkWidget* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	g_return_val_if_fail (im_address != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = contacts_contact_find_im_persona (self, protocol, im_address);
	_data2_->tp = _tmp0_;
	if (_data2_->tp == NULL) {
		result = NULL;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	_tmp1_ = (GtkImage*) gtk_image_new ();
	_data2_->i = g_object_ref_sink (_tmp1_);
	_tmp2_ = folks_presence_details_get_presence_type ((FolksPresenceDetails*) _data2_->tp);
	_tmp3_ = contacts_contact_presence_to_icon_full (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_image_set_from_icon_name (_data2_->i, _tmp4_, GTK_ICON_SIZE_MENU);
	_g_free0 (_tmp4_);
	_tmp5_ = folks_presence_details_get_presence_type ((FolksPresenceDetails*) _data2_->tp);
	_tmp6_ = contacts_contact_presence_to_class (_tmp5_);
	_data2_->last_class = _tmp6_;
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _data2_->i);
	gtk_style_context_add_class (_tmp7_, _data2_->last_class);
	_tmp8_ = folks_presence_details_get_presence_message ((FolksPresenceDetails*) _data2_->tp);
	gtk_widget_set_tooltip_text ((GtkWidget*) _data2_->i, _tmp8_);
	_tmp9_ = g_signal_connect_data ((GObject*) _data2_->tp, "notify::presence-type", (GCallback) __lambda3__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_data2_->id1 = _tmp9_;
	_tmp10_ = g_signal_connect_data ((GObject*) _data2_->tp, "notify::presence-message", (GCallback) __lambda4__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_data2_->id2 = _tmp10_;
	g_signal_connect_data ((GtkWidget*) _data2_->i, "destroy", (GCallback) __lambda5__gtk_widget_destroy, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp11_ = _g_object_ref0 ((GtkWidget*) _data2_->i);
	result = _tmp11_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


static gboolean contacts_contact_changed_cb (ContactsContact* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->changed_id = (guint) 0;
	contacts_contact_update (self);
	g_signal_emit_by_name (self, "changed");
	result = FALSE;
	return result;
}


static void contacts_contact_unqueue_changed (ContactsContact* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->changed_id != 0) {
		g_source_remove (self->priv->changed_id);
		self->priv->changed_id = (guint) 0;
	}
}


static gboolean _contacts_contact_changed_cb_gsource_func (gpointer self) {
	gboolean result;
	result = contacts_contact_changed_cb (self);
	return result;
}


static void contacts_contact_queue_changed (ContactsContact* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->changed_id != 0) {
		return;
	}
	_tmp0_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _contacts_contact_changed_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->changed_id = _tmp0_;
}


static void contacts_contact_notify_cb (ContactsContact* self, GParamSpec* pspec) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = g_param_spec_get_name (pspec);
	if (g_strcmp0 (_tmp0_, "avatar") == 0) {
		_g_object_unref0 (self->priv->_avatar);
		self->priv->_avatar = NULL;
	}
	contacts_contact_queue_changed (self);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gboolean contacts_contact_get_is_phone (FolksPersona* persona) {
	gboolean result = FALSE;
	FolksPersona* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* tp;
	gboolean _tmp2_ = FALSE;
	TpContact* _tmp4_ = NULL;
	gchar** _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gchar** types;
	gint types_length1;
	gint _types_size_;
	gboolean _tmp9_ = FALSE;
	g_return_val_if_fail (persona != NULL, FALSE);
	_tmp0_ = persona;
	_tmp1_ = _g_object_ref0 (TPF_IS_PERSONA (_tmp0_) ? ((TpfPersona*) _tmp0_) : NULL);
	tp = _tmp1_;
	if (tp == NULL) {
		_tmp2_ = TRUE;
	} else {
		TpContact* _tmp3_ = NULL;
		_tmp3_ = tpf_persona_get_contact (tp);
		_tmp2_ = _tmp3_ == NULL;
	}
	if (_tmp2_) {
		result = FALSE;
		_g_object_unref0 (tp);
		return result;
	}
	_tmp4_ = tpf_persona_get_contact (tp);
	_tmp6_ = _tmp5_ = tp_contact_get_client_types (_tmp4_);
	_tmp8_ = (_tmp7_ = _tmp6_, (_tmp7_ == NULL) ? ((gpointer) _tmp7_) : _vala_array_dup1 (_tmp7_, _vala_array_length (_tmp5_)));
	types = _tmp8_;
	types_length1 = _vala_array_length (_tmp5_);
	_types_size_ = types_length1;
	if (types != NULL) {
		_tmp9_ = g_strcmp0 (types[0], "phone") == 0;
	} else {
		_tmp9_ = FALSE;
	}
	result = _tmp9_;
	types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (tp);
	return result;
}


static void contacts_contact_update_presence (ContactsContact* self) {
	g_return_if_fail (self != NULL);
	_g_free0 (self->presence_message);
	self->presence_message = NULL;
	self->presence_type = FOLKS_PRESENCE_TYPE_UNSET;
	self->is_phone = FALSE;
	{
		GeeSet* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _p_it;
		_tmp0_ = folks_individual_get_personas (self->individual);
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_p_it = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			gpointer _tmp3_ = NULL;
			FolksPersona* p;
			_tmp2_ = gee_iterator_next (_p_it);
			if (!_tmp2_) {
				break;
			}
			_tmp3_ = gee_iterator_get (_p_it);
			p = (FolksPersona*) _tmp3_;
			if (FOLKS_IS_PRESENCE_DETAILS (p)) {
				FolksPresenceDetails* presence;
				gboolean _tmp4_;
				gboolean p_is_phone;
				gboolean _tmp5_ = FALSE;
				FolksPresenceType _tmp6_;
				gint _tmp7_;
				presence = FOLKS_PRESENCE_DETAILS (p);
				_tmp4_ = contacts_contact_get_is_phone (p);
				p_is_phone = _tmp4_;
				_tmp6_ = folks_presence_details_get_presence_type (presence);
				_tmp7_ = folks_presence_details_typecmp (_tmp6_, self->presence_type);
				if (_tmp7_ > 0) {
					_tmp5_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					gboolean _tmp9_ = FALSE;
					FolksPresenceType _tmp10_;
					_tmp10_ = folks_presence_details_get_presence_type (presence);
					if (_tmp10_ == self->presence_type) {
						_tmp9_ = self->is_phone;
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						_tmp8_ = !p_is_phone;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp5_ = _tmp8_;
				}
				if (_tmp5_) {
					FolksPresenceType _tmp11_;
					const gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					_tmp11_ = folks_presence_details_get_presence_type (presence);
					self->presence_type = _tmp11_;
					_tmp12_ = folks_presence_details_get_presence_message (presence);
					_tmp13_ = g_strdup (_tmp12_);
					_g_free0 (self->presence_message);
					self->presence_message = _tmp13_;
					self->is_phone = p_is_phone;
				}
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	if (self->presence_message == NULL) {
		gchar* _tmp14_;
		_tmp14_ = g_strdup ("");
		_g_free0 (self->presence_message);
		self->presence_message = _tmp14_;
	}
}


static void contacts_contact_update_filter_data (ContactsContact* self) {
	GString* _tmp0_ = NULL;
	GString* builder;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp9_ = NULL;
	GeeMultiMap* _tmp13_ = NULL;
	GeeMultiMap* _tmp14_;
	GeeMultiMap* im_addresses;
	GeeSet* _tmp23_ = NULL;
	GeeSet* _tmp24_;
	GeeSet* emails;
	gchar* _tmp31_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = folks_alias_details_get_alias ((FolksAliasDetails*) self->individual);
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp2_ = folks_alias_details_get_alias ((FolksAliasDetails*) self->individual);
		_tmp3_ = g_utf8_casefold (_tmp2_, (gssize) (-1));
		_tmp4_ = _tmp3_;
		g_string_append (builder, _tmp4_);
		_g_free0 (_tmp4_);
		g_string_append_unichar (builder, (gunichar) ' ');
	}
	_tmp5_ = folks_name_details_get_full_name ((FolksNameDetails*) self->individual);
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp6_ = folks_name_details_get_full_name ((FolksNameDetails*) self->individual);
		_tmp7_ = g_utf8_casefold (_tmp6_, (gssize) (-1));
		_tmp8_ = _tmp7_;
		g_string_append (builder, _tmp8_);
		_g_free0 (_tmp8_);
		g_string_append_unichar (builder, (gunichar) ' ');
	}
	_tmp9_ = folks_name_details_get_nickname ((FolksNameDetails*) self->individual);
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		_tmp10_ = folks_name_details_get_nickname ((FolksNameDetails*) self->individual);
		_tmp11_ = g_utf8_casefold (_tmp10_, (gssize) (-1));
		_tmp12_ = _tmp11_;
		g_string_append (builder, _tmp12_);
		_g_free0 (_tmp12_);
		g_string_append_unichar (builder, (gunichar) ' ');
	}
	_tmp13_ = folks_im_details_get_im_addresses ((FolksImDetails*) self->individual);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	im_addresses = _tmp14_;
	{
		GeeCollection* _tmp15_ = NULL;
		GeeCollection* _tmp16_;
		GeeIterator* _tmp17_ = NULL;
		GeeIterator* _tmp18_;
		GeeIterator* _addr_it;
		_tmp15_ = gee_multi_map_get_values (im_addresses);
		_tmp16_ = _tmp15_;
		_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp16_);
		_addr_it = _tmp18_;
		while (TRUE) {
			gboolean _tmp19_;
			gpointer _tmp20_ = NULL;
			gchar* addr;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			_tmp19_ = gee_iterator_next (_addr_it);
			if (!_tmp19_) {
				break;
			}
			_tmp20_ = gee_iterator_get (_addr_it);
			addr = (gchar*) _tmp20_;
			_tmp21_ = g_utf8_casefold (addr, (gssize) (-1));
			_tmp22_ = _tmp21_;
			g_string_append (builder, _tmp22_);
			_g_free0 (_tmp22_);
			g_string_append_unichar (builder, (gunichar) ' ');
			_g_free0 (addr);
		}
		_g_object_unref0 (_addr_it);
	}
	_tmp23_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) self->individual);
	_tmp24_ = _g_object_ref0 (_tmp23_);
	emails = _tmp24_;
	{
		GeeIterator* _tmp25_ = NULL;
		GeeIterator* _email_it;
		_tmp25_ = gee_iterable_iterator ((GeeIterable*) emails);
		_email_it = _tmp25_;
		while (TRUE) {
			gboolean _tmp26_;
			gpointer _tmp27_ = NULL;
			FolksFieldDetails* email;
			const gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_;
			_tmp26_ = gee_iterator_next (_email_it);
			if (!_tmp26_) {
				break;
			}
			_tmp27_ = gee_iterator_get (_email_it);
			email = (FolksFieldDetails*) _tmp27_;
			_tmp28_ = folks_field_details_get_value (email);
			_tmp29_ = g_utf8_casefold (_tmp28_, (gssize) (-1));
			_tmp30_ = _tmp29_;
			g_string_append (builder, _tmp30_);
			_g_free0 (_tmp30_);
			g_string_append_unichar (builder, (gunichar) ' ');
			_g_object_unref0 (email);
		}
		_g_object_unref0 (_email_it);
	}
	_tmp31_ = g_strdup (builder->str);
	_g_free0 (self->priv->filter_data);
	self->priv->filter_data = _tmp31_;
	_g_object_unref0 (emails);
	_g_object_unref0 (im_addresses);
	_g_string_free0 (builder);
}


static void contacts_contact_update (ContactsContact* self) {
	g_return_if_fail (self != NULL);
	{
		GeeSet* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _email_it;
		_tmp0_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) self->individual);
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_email_it = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			gpointer _tmp3_ = NULL;
			FolksFieldDetails* email;
			ContactsTypeSet* _tmp4_ = NULL;
			_tmp2_ = gee_iterator_next (_email_it);
			if (!_tmp2_) {
				break;
			}
			_tmp3_ = gee_iterator_get (_email_it);
			email = (FolksFieldDetails*) _tmp3_;
			_tmp4_ = contacts_typeset_get_general ();
			contacts_typeset_type_seen (_tmp4_, email);
			_g_object_unref0 (email);
		}
		_g_object_unref0 (_email_it);
	}
	{
		GeeSet* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
		GeeIterator* _phone_it;
		_tmp5_ = folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) self->individual);
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_phone_it = _tmp6_;
		while (TRUE) {
			gboolean _tmp7_;
			gpointer _tmp8_ = NULL;
			FolksFieldDetails* phone;
			ContactsTypeSet* _tmp9_ = NULL;
			_tmp7_ = gee_iterator_next (_phone_it);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = gee_iterator_get (_phone_it);
			phone = (FolksFieldDetails*) _tmp8_;
			_tmp9_ = contacts_typeset_get_phone ();
			contacts_typeset_type_seen (_tmp9_, phone);
			_g_object_unref0 (phone);
		}
		_g_object_unref0 (_phone_it);
	}
	contacts_contact_update_presence (self);
	contacts_contact_update_filter_data (self);
}


static GdkPixbuf* contacts_contact_load_icon (ContactsContact* self, GFile* file) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* res;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 (contacts_contact_fallback_avatar);
	res = _tmp0_;
	if (file != NULL) {
		{
			GFileInputStream* _tmp1_ = NULL;
			GFileInputStream* stream;
			GCancellable* _tmp2_ = NULL;
			GCancellable* c;
			GdkPixbuf* _tmp3_ = NULL;
			GdkPixbuf* _tmp4_;
			_tmp1_ = g_file_read (file, NULL, &_inner_error_);
			stream = _tmp1_;
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
			_tmp2_ = g_cancellable_new ();
			c = _tmp2_;
			_tmp3_ = gdk_pixbuf_new_from_stream_at_scale ((GInputStream*) stream, 48, 48, TRUE, c, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (c);
				_g_object_unref0 (stream);
				goto __catch0_g_error;
			}
			_g_object_unref0 (res);
			res = _tmp4_;
			_g_object_unref0 (c);
			_g_object_unref0 (stream);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (res);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = res;
	return result;
}


static void contacts_contact_cairo_ellipsis (cairo_t* cr, gdouble xc, gdouble yc, gdouble xradius, gdouble yradius, gdouble angle1, gdouble angle2) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (cr != NULL);
	if (xradius <= 0.0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = yradius <= 0.0;
	}
	if (_tmp0_) {
		cairo_line_to (cr, xc, yc);
		return;
	}
	cairo_save (cr);
	cairo_translate (cr, xc, yc);
	cairo_scale (cr, xradius, yradius);
	cairo_arc (cr, (gdouble) 0, (gdouble) 0, 1.0, angle1, angle2);
	cairo_restore (cr);
}


static void contacts_contact_rounded_box_path (cairo_t* cr, gint x, gint y, gint width, gint height, gint radius) {
	g_return_if_fail (cr != NULL);
	cairo_new_sub_path (cr);
	contacts_contact_cairo_ellipsis (cr, (gdouble) (x + radius), (gdouble) (y + radius), (gdouble) radius, (gdouble) radius, G_PI, (3 * G_PI) / 2);
	contacts_contact_cairo_ellipsis (cr, (gdouble) ((x + width) - radius), (gdouble) (y + radius), (gdouble) radius, (gdouble) radius, (-G_PI) / 2, (gdouble) 0);
	contacts_contact_cairo_ellipsis (cr, (gdouble) ((x + width) - radius), (gdouble) ((y + height) - radius), (gdouble) radius, (gdouble) radius, (gdouble) 0, G_PI / 2);
	contacts_contact_cairo_ellipsis (cr, (gdouble) (x + radius), (gdouble) ((y + height) - radius), (gdouble) radius, (gdouble) radius, G_PI / 2, G_PI);
}


static GdkPixbuf* contacts_contact_frame_icon (GdkPixbuf* icon) {
	GdkPixbuf* result = NULL;
	cairo_surface_t* _tmp0_ = NULL;
	cairo_surface_t* cst;
	cairo_t* _tmp1_ = NULL;
	cairo_t* cr;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_;
	g_return_val_if_fail (icon != NULL, NULL);
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 52, 52);
	cst = _tmp0_;
	_tmp1_ = cairo_create (cst);
	cr = _tmp1_;
	cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) 52, (gdouble) 52);
	cairo_fill (cr);
	gdk_cairo_set_source_pixbuf (cr, icon, (gdouble) 2, (gdouble) 2);
	cairo_paint (cr);
	contacts_contact_rounded_box_path (cr, 0, 0, 52, 52, 5);
	contacts_contact_rounded_box_path (cr, 2, 2, 48, 48, 3);
	cairo_set_source_rgb (cr, 0.533333, 0.541176, 0.521568);
	cairo_set_fill_rule (cr, CAIRO_FILL_RULE_EVEN_ODD);
	cairo_fill (cr);
	_tmp2_ = gdk_pixbuf_get_from_surface (cst, 0, 0, 52, 52);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (cst);
	return result;
}


GdkPixbuf* contacts_contact_draw_fallback_avatar (gint size) {
	GdkPixbuf* result = NULL;
	cairo_surface_t* _tmp0_ = NULL;
	cairo_surface_t* cst;
	cairo_t* _tmp1_ = NULL;
	cairo_t* cr;
	GdkPixbuf* _tmp5_ = NULL;
	GdkPixbuf* _tmp6_;
	GError * _inner_error_ = NULL;
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, size, size);
	cst = _tmp0_;
	_tmp1_ = cairo_create (cst);
	cr = _tmp1_;
	{
		GtkIconTheme* _tmp2_ = NULL;
		GtkIconInfo* _tmp3_ = NULL;
		GtkIconInfo* icon_info;
		GdkPixbuf* _tmp4_ = NULL;
		GdkPixbuf* image;
		_tmp2_ = gtk_icon_theme_get_default ();
		_tmp3_ = gtk_icon_theme_lookup_icon (_tmp2_, "avatar-default", size, GTK_ICON_LOOKUP_GENERIC_FALLBACK);
		icon_info = _tmp3_;
		_tmp4_ = gtk_icon_info_load_icon (icon_info, &_inner_error_);
		image = _tmp4_;
		if (_inner_error_ != NULL) {
			_gtk_icon_info_free0 (icon_info);
			goto __catch1_g_error;
		}
		if (image != NULL) {
			gdk_cairo_set_source_pixbuf (cr, image, (gdouble) 0, (gdouble) 0);
			cairo_paint (cr);
		}
		_g_object_unref0 (image);
		_gtk_icon_info_free0 (icon_info);
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_cairo_destroy0 (cr);
		_cairo_surface_destroy0 (cst);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp5_ = gdk_pixbuf_get_from_surface (cst, 0, 0, size, size);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	result = _tmp6_;
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (cst);
	return result;
}


static inline GRegex* _thread_safe_regex_init (GRegex** re, const gchar * pattern, GRegexMatchFlags match_options) {
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, match_options, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}


gchar* contacts_contact_format_uri_link_text (FolksFieldDetails* detail) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* uri;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp7_;
	g_return_val_if_fail (detail != NULL, NULL);
	_tmp0_ = folks_field_details_get_value (detail);
	_tmp1_ = g_strdup (_tmp0_);
	uri = _tmp1_;
	_tmp3_ = g_regex_match (_thread_safe_regex_init (&_tmp_regex_0, "https?:\\/\\/www.facebook.com\\/profile\\.php\\?id=[0-9]+$", 0), uri, 0, NULL);
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp4_;
		_tmp4_ = g_regex_match (_thread_safe_regex_init (&_tmp_regex_1, "https?:\\/\\/www.facebook.com\\/[a-zA-Z0-9]+$", 0), uri, 0, NULL);
		_tmp2_ = _tmp4_;
	}
	if (_tmp2_) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp5_ = _ ("Facebook");
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		_g_free0 (uri);
		return result;
	}
	_tmp7_ = g_regex_match (_thread_safe_regex_init (&_tmp_regex_2, "https?:\\/\\/twitter.com\\/#!\\/[a-zA-Z0-9]+$", 0), uri, 0, NULL);
	if (_tmp7_) {
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp8_ = _ ("Twitter");
		_tmp9_ = g_strdup (_tmp8_);
		result = _tmp9_;
		_g_free0 (uri);
		return result;
	}
	result = uri;
	return result;
}


static void contacts_contact_ensure_writable_persona_data_free (gpointer _data) {
	ContactsContactEnsureWritablePersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsContactEnsureWritablePersonaData, _data_);
}


void contacts_contact_ensure_writable_persona (ContactsContact* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsContactEnsureWritablePersonaData* _data_;
	_data_ = g_slice_new0 (ContactsContactEnsureWritablePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, contacts_contact_ensure_writable_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, contacts_contact_ensure_writable_persona_data_free);
	_data_->self = _g_object_ref0 (self);
	contacts_contact_ensure_writable_persona_co (_data_);
}


FolksPersona* contacts_contact_ensure_writable_persona_finish (ContactsContact* self, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	ContactsContactEnsureWritablePersonaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean contacts_contact_ensure_writable_persona_co (ContactsContactEnsureWritablePersonaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = contacts_contact_find_writable_persona (_data_->self);
	_data_->p = _data_->_tmp0_;
	if (_data_->p != NULL) {
		_data_->result = _data_->p;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_print ("new writable persona: %p\n", _data_->p);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_error_new_literal (CONTACT_ERROR, CONTACT_ERROR_NOT_IMPLEMENTED, "Not implemented yet");
	_data_->_inner_error_ = _data_->_tmp1_;
	g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
	g_error_free (_data_->_inner_error_);
	_g_object_unref0 (_data_->p);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->p);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


FolksPersona* contacts_contact_find_writable_persona (ContactsContact* self) {
	FolksPersona* result = NULL;
	FolksIndividualAggregator* _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_ = NULL;
	FolksPersonaStore* _tmp2_;
	FolksPersonaStore* primary_store;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = contacts_store_get_aggregator (self->store);
	_tmp1_ = folks_individual_aggregator_get_primary_store (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	primary_store = _tmp2_;
	{
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _persona_it;
		_tmp3_ = folks_individual_get_personas (self->individual);
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_persona_it = _tmp4_;
		while (TRUE) {
			gboolean _tmp5_;
			gpointer _tmp6_ = NULL;
			FolksPersona* persona;
			FolksPersonaStore* _tmp7_ = NULL;
			_tmp5_ = gee_iterator_next (_persona_it);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = gee_iterator_get (_persona_it);
			persona = (FolksPersona*) _tmp6_;
			_tmp7_ = folks_persona_get_store (persona);
			if (_tmp7_ == primary_store) {
				result = persona;
				_g_object_unref0 (_persona_it);
				_g_object_unref0 (primary_store);
				return result;
			}
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	{
		GeeSet* _tmp8_ = NULL;
		GeeIterator* _tmp9_ = NULL;
		GeeIterator* _persona_it;
		_tmp8_ = folks_individual_get_personas (self->individual);
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
		_persona_it = _tmp9_;
		while (TRUE) {
			gboolean _tmp10_;
			gpointer _tmp11_ = NULL;
			FolksPersona* persona;
			FolksPersonaStore* _tmp12_ = NULL;
			gboolean _tmp13_;
			_tmp10_ = gee_iterator_next (_persona_it);
			if (!_tmp10_) {
				break;
			}
			_tmp11_ = gee_iterator_get (_persona_it);
			persona = (FolksPersona*) _tmp11_;
			_tmp12_ = folks_persona_get_store (persona);
			_tmp13_ = folks_persona_store_get_is_writeable (_tmp12_);
			if (_tmp13_) {
				result = persona;
				_g_object_unref0 (_persona_it);
				_g_object_unref0 (primary_store);
				return result;
			}
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	result = NULL;
	_g_object_unref0 (primary_store);
	return result;
}


GdkPixbuf* contacts_contact_get_avatar (ContactsContact* self) {
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_avatar == NULL) {
		GFile* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_ = NULL;
		_tmp0_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) self->individual);
		_tmp1_ = contacts_contact_load_icon (self, _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = contacts_contact_frame_icon (_tmp2_);
		_g_object_unref0 (self->priv->_avatar);
		self->priv->_avatar = _tmp3_;
		_g_object_unref0 (_tmp2_);
	}
	result = self->priv->_avatar;
	return result;
}


const gchar* contacts_contact_get_display_name (ContactsContact* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* name;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp3_ = NULL;
	const gchar* alias;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = folks_name_details_get_full_name ((FolksNameDetails*) self->individual);
	name = _tmp0_;
	if (name != NULL) {
		gint _tmp2_;
		_tmp2_ = strlen (name);
		_tmp1_ = _tmp2_ > 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = name;
		return result;
	}
	_tmp3_ = folks_alias_details_get_alias ((FolksAliasDetails*) self->individual);
	alias = _tmp3_;
	if (alias != NULL) {
		gint _tmp5_;
		_tmp5_ = strlen (alias);
		_tmp4_ = _tmp5_ > 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = folks_alias_details_get_alias ((FolksAliasDetails*) self->individual);
		result = _tmp6_;
		return result;
	}
	{
		GeeSet* _tmp7_ = NULL;
		GeeIterator* _tmp8_ = NULL;
		GeeIterator* _email_it;
		_tmp7_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) self->individual);
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
		_email_it = _tmp8_;
		while (TRUE) {
			gboolean _tmp9_;
			gpointer _tmp10_ = NULL;
			FolksFieldDetails* email;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			gchar* e;
			gboolean _tmp13_ = FALSE;
			_tmp9_ = gee_iterator_next (_email_it);
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = gee_iterator_get (_email_it);
			email = (FolksFieldDetails*) _tmp10_;
			_tmp11_ = folks_field_details_get_value (email);
			_tmp12_ = g_strdup (_tmp11_);
			e = _tmp12_;
			if (e != NULL) {
				gint _tmp14_;
				_tmp14_ = strlen (e);
				_tmp13_ = _tmp14_ > 0;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				const gchar* _tmp15_ = NULL;
				_tmp15_ = folks_field_details_get_value (email);
				result = _tmp15_;
				_g_free0 (e);
				_g_object_unref0 (email);
				_g_object_unref0 (_email_it);
				return result;
			}
			_g_free0 (e);
			_g_object_unref0 (email);
		}
		_g_object_unref0 (_email_it);
	}
	result = "";
	return result;
}


static ContactsContactImData* contacts_contact_im_data_dup (const ContactsContactImData* self) {
	ContactsContactImData* dup;
	dup = g_new0 (ContactsContactImData, 1);
	memcpy (dup, self, sizeof (ContactsContactImData));
	return dup;
}


static void contacts_contact_im_data_free (ContactsContactImData* self) {
	g_free (self);
}


static GType contacts_contact_im_data_get_type (void) {
	static volatile gsize contacts_contact_im_data_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_im_data_type_id__volatile)) {
		GType contacts_contact_im_data_type_id;
		contacts_contact_im_data_type_id = g_boxed_type_register_static ("ContactsContactImData", (GBoxedCopyFunc) contacts_contact_im_data_dup, (GBoxedFreeFunc) contacts_contact_im_data_free);
		g_once_init_leave (&contacts_contact_im_data_type_id__volatile, contacts_contact_im_data_type_id);
	}
	return contacts_contact_im_data_type_id__volatile;
}


static void contacts_contact_class_init (ContactsContactClass * klass) {
	GdkPixbuf* _tmp0_ = NULL;
	contacts_contact_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsContactPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_contact_get_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_AVATAR, g_param_spec_object ("avatar", "avatar", "avatar", GDK_TYPE_PIXBUF, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("changed", CONTACTS_TYPE_CONTACT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = contacts_contact_draw_fallback_avatar (48);
	_g_object_unref0 (contacts_contact_fallback_avatar);
	contacts_contact_fallback_avatar = _tmp0_;
}


static void contacts_contact_instance_init (ContactsContact * self) {
	self->priv = CONTACTS_CONTACT_GET_PRIVATE (self);
}


static void contacts_contact_finalize (GObject* obj) {
	ContactsContact * self;
	self = CONTACTS_CONTACT (obj);
	_contacts_store_unref0 (self->store);
	_g_free0 (self->presence_message);
	_g_object_unref0 (self->individual);
	_g_object_unref0 (self->priv->_avatar);
	_g_free0 (self->priv->filter_data);
	G_OBJECT_CLASS (contacts_contact_parent_class)->finalize (obj);
}


GType contacts_contact_get_type (void) {
	static volatile gsize contacts_contact_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsContactClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContact), 0, (GInstanceInitFunc) contacts_contact_instance_init, NULL };
		GType contacts_contact_type_id;
		contacts_contact_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsContact", &g_define_type_info, 0);
		g_once_init_leave (&contacts_contact_type_id__volatile, contacts_contact_type_id);
	}
	return contacts_contact_type_id__volatile;
}


static void _vala_contacts_contact_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ContactsContact * self;
	self = CONTACTS_CONTACT (object);
	switch (property_id) {
		case CONTACTS_CONTACT_AVATAR:
		g_value_set_object (value, contacts_contact_get_avatar (self));
		break;
		case CONTACTS_CONTACT_DISPLAY_NAME:
		g_value_set_string (value, contacts_contact_get_display_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



