/* vinagre-utils.c generated by valac 0.12.0, the Vala compiler
 * generated from vinagre-utils.vala, do not modify */

/*  Vinagre - GNOME Remote Desktop viewer
 *
 *  Copyright (C) 2011  David King <amigadave@amigadave.com>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <config.h>
#include <gdk/gdk.h>

typedef struct _Block1Data Block1Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _Block1Data {
	int _ref_count_;
	GtkMessageDialog* dialog;
};



void vinagre_utils_show_error_dialog (const gchar* title, const gchar* message, GtkWindow* parent);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda0_ (GtkDialog* d, gint response, Block1Data* _data1_);
static void __lambda0__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
gboolean vinagre_utils_create_dir_for_file (const gchar* filename, GError** error);
void vinagre_utils_show_help (GtkWindow* window, const gchar* page);
void vinagre_utils_show_help_about (GtkWindow* parent);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->dialog);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda0_ (GtkDialog* d, gint response, Block1Data* _data1_) {
	g_return_if_fail (d != NULL);
	gtk_widget_destroy ((GtkWidget*) _data1_->dialog);
}


static void __lambda0__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	_lambda0_ (_sender, response_id, self);
}


void vinagre_utils_show_error_dialog (const gchar* title, const gchar* message, GtkWindow* parent) {
	Block1Data* _data1_;
	GtkMessageDialog* _tmp1_ = NULL;
	g_return_if_fail (parent != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	if (title != NULL) {
		const gchar* _tmp0_ = NULL;
		_tmp0_ = _ ("An error occurred");
		title = _tmp0_;
	}
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new (parent, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", title);
	_data1_->dialog = g_object_ref_sink (_tmp1_);
	if (message != NULL) {
		gtk_message_dialog_format_secondary_markup (_data1_->dialog, "%s", message, NULL);
	}
	g_signal_connect_data ((GtkDialog*) _data1_->dialog, "response", (GCallback) __lambda0__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	gtk_widget_show_all ((GtkWidget*) _data1_->dialog);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


gboolean vinagre_utils_create_dir_for_file (const gchar* filename, GError** error) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* file;
	GFile* _tmp1_ = NULL;
	GFile* parent;
	gchar* _tmp2_ = NULL;
	gchar* parent_path;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (filename);
	file = _tmp0_;
	_tmp1_ = g_file_get_parent (file);
	parent = _tmp1_;
	_tmp2_ = g_file_get_path (parent);
	parent_path = _tmp2_;
	_tmp3_ = g_file_test (parent_path, G_FILE_TEST_EXISTS);
	if (!_tmp3_) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (parent_path);
			_g_object_unref0 (parent);
			_g_object_unref0 (file);
			return FALSE;
		}
		result = _tmp5_;
		_g_free0 (parent_path);
		_g_object_unref0 (parent);
		_g_object_unref0 (file);
		return result;
	} else {
		result = TRUE;
		_g_free0 (parent_path);
		_g_object_unref0 (parent);
		_g_object_unref0 (file);
		return result;
	}
	_g_free0 (parent_path);
	_g_object_unref0 (parent);
	_g_object_unref0 (file);
}


void vinagre_utils_show_help (GtkWindow* window, const gchar* page) {
	gchar* uri = NULL;
	GdkScreen* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (window != NULL);
	if (page != NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strconcat ("ghelp:" PACKAGE_TARNAME "?", page, NULL);
		_g_free0 (uri);
		uri = _tmp0_;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("ghelp:" PACKAGE_TARNAME);
		_g_free0 (uri);
		uri = _tmp1_;
	}
	_tmp2_ = gtk_window_get_screen (window);
	gtk_show_uri (_tmp2_, uri, (guint32) GDK_CURRENT_TIME, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * _error_;
		const gchar* _tmp3_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _ ("Error showing help");
		vinagre_utils_show_error_dialog (_tmp3_, _error_->message, window);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_free0 (uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (uri);
}


void vinagre_utils_show_help_about (GtkWindow* parent) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** authors;
	gint authors_length1;
	gint _authors_size_;
	gchar* _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** artists;
	gint artists_length1;
	gint _artists_size_;
	static const char copyright[] = "Copyright \xc2\xa9 2007-2011 Jonh Wendell\n" \
"Copyright \xc2\xa9 2011 David King";
	static const char comments[] = "Vinagre is a remote desktop viewer for the GNOME Desktop";
	static const char license[] = "Vinagre is free software; you can redistribute it and/or modify it und" \
"er the terms of the GNU General Public License as published by the Fre" \
"e Software Foundation; either version 2 of the License, or (at your op" \
"tion) any later version.\n" \
"\n" \
"Vinagre is distributed in the hope that it will be useful, but WITHOUT" \
" ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or" \
" FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License" \
" for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License alon" \
"g with this program. If not, see <http://www.gnu.org/licenses/>.";
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	g_return_if_fail (parent != NULL);
	_tmp0_ = g_strdup ("David King <amigadave@amigadave.com>");
	_tmp1_ = g_strdup ("Jonh Wendell <jwendell@gnome.org>");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	authors = _tmp2_;
	authors_length1 = 2;
	_authors_size_ = 2;
	_tmp3_ = g_strdup ("Vinicius Depizzol <vdepizzol@gmail.com>");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	artists = _tmp4_;
	artists_length1 = 1;
	_artists_size_ = 1;
	_tmp5_ = _ (comments);
	_tmp6_ = _ ("translator-credits");
	_tmp7_ = _ ("Vinagre Website");
	gtk_show_about_dialog (parent, "authors", authors, "artists", artists, "comments", _tmp5_, "copyright", copyright, "license", license, "wrap-license", TRUE, "logo-icon-name", PACKAGE_TARNAME, "translator-credits", _tmp6_, "version", PACKAGE_VERSION, "website", PACKAGE_URL, "website-label", _tmp7_, NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



