/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor-cell-style.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-editor-cell-style
 * @title: IAnjutaEditorCellStyle
 * @short_description: Text editor cell style interface
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-editor-cell-style.h
 * 
 */

#include "ianjuta-editor-cell-style.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_editor_cell_style_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-editor-cell-style-quark");
	}
	
	return quark;
}

gchar*
ianjuta_editor_cell_style_get_background_color (IAnjutaEditorCellStyle *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_CELL_STYLE(obj), NULL);
	return IANJUTA_EDITOR_CELL_STYLE_GET_IFACE (obj)->get_background_color (obj, err);
}

/* Default implementation */
static gchar*
ianjuta_editor_cell_style_get_background_color_default (IAnjutaEditorCellStyle *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

gchar*
ianjuta_editor_cell_style_get_color (IAnjutaEditorCellStyle *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_CELL_STYLE(obj), NULL);
	return IANJUTA_EDITOR_CELL_STYLE_GET_IFACE (obj)->get_color (obj, err);
}

/* Default implementation */
static gchar*
ianjuta_editor_cell_style_get_color_default (IAnjutaEditorCellStyle *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

gchar*
ianjuta_editor_cell_style_get_font_description (IAnjutaEditorCellStyle *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_CELL_STYLE(obj), NULL);
	return IANJUTA_EDITOR_CELL_STYLE_GET_IFACE (obj)->get_font_description (obj, err);
}

/* Default implementation */
static gchar*
ianjuta_editor_cell_style_get_font_description_default (IAnjutaEditorCellStyle *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

static void
ianjuta_editor_cell_style_base_init (IAnjutaEditorCellStyleIface* klass)
{
	static gboolean initialized = FALSE;

	klass->get_background_color = ianjuta_editor_cell_style_get_background_color_default;
	klass->get_color = ianjuta_editor_cell_style_get_color_default;
	klass->get_font_description = ianjuta_editor_cell_style_get_font_description_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_editor_cell_style_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaEditorCellStyleIface),
			(GBaseInitFunc) ianjuta_editor_cell_style_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaEditorCellStyle", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_EDITOR_CELL);
	}
	return type;			
}
