/* rygel-media-export-harvesting-task.c generated by valac 0.18.1, the Vala compiler
 * generated from rygel-media-export-harvesting-task.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <rygel-server.h>
#include <gee.h>
#include <gst/pbutils/codec-utils.h>
#include <gst/pbutils/descriptions.h>
#include <gst/pbutils/encoding-profile.h>
#include <gst/pbutils/encoding-target.h>
#include <gst/pbutils/gstdiscoverer.h>
#include <gst/pbutils/gstpluginsbaseversion.h>
#include <gst/pbutils/install-plugins.h>
#include <gst/pbutils/missing-plugins.h>
#include <gst/pbutils/pbutils-enumtypes.h>
#include <gst/pbutils/pbutils.h>
#include <libgupnp-dlna/gupnp-dlna.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_FILE_QUEUE_ENTRY (file_queue_entry_get_type ())
#define FILE_QUEUE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_QUEUE_ENTRY, FileQueueEntry))
#define FILE_QUEUE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_QUEUE_ENTRY, FileQueueEntryClass))
#define IS_FILE_QUEUE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_QUEUE_ENTRY))
#define IS_FILE_QUEUE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_QUEUE_ENTRY))
#define FILE_QUEUE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_QUEUE_ENTRY, FileQueueEntryClass))

typedef struct _FileQueueEntry FileQueueEntry;
typedef struct _FileQueueEntryClass FileQueueEntryClass;
typedef struct _FileQueueEntryPrivate FileQueueEntryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecFileQueueEntry ParamSpecFileQueueEntry;

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK (rygel_media_export_harvesting_task_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))

typedef struct _RygelMediaExportHarvestingTask RygelMediaExportHarvestingTask;
typedef struct _RygelMediaExportHarvestingTaskClass RygelMediaExportHarvestingTaskClass;
typedef struct _RygelMediaExportHarvestingTaskPrivate RygelMediaExportHarvestingTaskPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;
#define __g_queue_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_queue_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskRunData RygelMediaExportHarvestingTaskRunData;
#define _file_queue_entry_unref0(var) ((var == NULL) ? NULL : (var = (file_queue_entry_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER (rygel_media_export_trackable_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer))
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_TRACKABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_TRACKABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainerClass))

typedef struct _RygelMediaExportTrackableDbContainer RygelMediaExportTrackableDbContainer;
typedef struct _RygelMediaExportTrackableDbContainerClass RygelMediaExportTrackableDbContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER (rygel_media_export_dummy_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainer))
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainerClass))

typedef struct _RygelMediaExportDummyContainer RygelMediaExportDummyContainer;
typedef struct _RygelMediaExportDummyContainerClass RygelMediaExportDummyContainerClass;
typedef struct _RygelMediaExportDBContainerPrivate RygelMediaExportDBContainerPrivate;
typedef struct _RygelMediaExportTrackableDbContainerPrivate RygelMediaExportTrackableDbContainerPrivate;
typedef struct _RygelMediaExportDummyContainerPrivate RygelMediaExportDummyContainerPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskEnumerateDirectoryData RygelMediaExportHarvestingTaskEnumerateDirectoryData;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;

struct _FileQueueEntry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FileQueueEntryPrivate * priv;
	GFile* file;
	gboolean known;
	gchar* content_type;
};

struct _FileQueueEntryClass {
	GTypeClass parent_class;
	void (*finalize) (FileQueueEntry *self);
};

struct _ParamSpecFileQueueEntry {
	GParamSpec parent_instance;
};

struct _RygelMediaExportHarvestingTask {
	GObject parent_instance;
	RygelMediaExportHarvestingTaskPrivate * priv;
	GFile* origin;
};

struct _RygelMediaExportHarvestingTaskClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportHarvestingTaskPrivate {
	RygelMediaExportMetadataExtractor* extractor;
	RygelMediaExportMediaCache* cache;
	GQueue* containers;
	GeeQueue* files;
	RygelMediaExportRecursiveFileMonitor* monitor;
	gchar* flag;
	RygelMediaContainer* parent;
	GCancellable* _cancellable;
};

struct _RygelMediaExportHarvestingTaskRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportHarvestingTask* self;
	GFile* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GFileInfo* _tmp3_;
	GFileInfo* info;
	GFile* _tmp4_;
	RygelMediaContainer* _tmp5_;
	gboolean _tmp6_;
	GFileType _tmp7_;
	GQueue* _tmp8_;
	RygelMediaContainer* _tmp9_;
	RygelMediaContainer* _tmp10_;
	GError* _error_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GFile* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _RygelMediaExportDBContainer {
	RygelMediaContainer parent_instance;
	RygelMediaExportDBContainerPrivate * priv;
	RygelMediaExportMediaCache* media_db;
};

struct _RygelMediaExportDBContainerClass {
	RygelMediaContainerClass parent_class;
	gint (*count_children) (RygelMediaExportDBContainer* self);
	void (*search) (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelMediaExportTrackableDbContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportTrackableDbContainerPrivate * priv;
};

struct _RygelMediaExportTrackableDbContainerClass {
	RygelMediaExportDBContainerClass parent_class;
	gchar* (*get_service_reset_token) (RygelMediaExportTrackableDbContainer* self);
	void (*set_service_reset_token) (RygelMediaExportTrackableDbContainer* self, const gchar* token);
	guint32 (*get_system_update_id) (RygelMediaExportTrackableDbContainer* self);
};

struct _RygelMediaExportDummyContainer {
	RygelMediaExportTrackableDbContainer parent_instance;
	RygelMediaExportDummyContainerPrivate * priv;
	GFile* file;
	GeeList* children;
};

struct _RygelMediaExportDummyContainerClass {
	RygelMediaExportTrackableDbContainerClass parent_class;
};

struct _RygelMediaExportHarvestingTaskEnumerateDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportHarvestingTask* self;
	GQueue* _tmp0_;
	gconstpointer _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* directory;
	GFile* _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	GFileEnumerator* _tmp7_;
	GFileEnumerator* enumerator;
	GList* list;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GList* _tmp10_;
	gboolean _tmp11_;
	GFileEnumerator* _tmp12_;
	GCancellable* _tmp13_;
	GCancellable* _tmp14_;
	GList* _tmp15_;
	GList* _tmp16_;
	GFileEnumerator* _tmp17_;
	GCancellable* _tmp18_;
	GCancellable* _tmp19_;
	GError* err;
	const gchar* _tmp20_;
	GError* _tmp21_;
	const gchar* _tmp22_;
	GError * _inner_error_;
};

struct _Block6Data {
	int _ref_count_;
	RygelMediaExportHarvestingTask * self;
	RygelMediaItem* item;
};

struct _Block7Data {
	int _ref_count_;
	RygelMediaExportHarvestingTask * self;
	RygelTrackableContainer* parent;
};


static gpointer file_queue_entry_parent_class = NULL;
static gpointer rygel_media_export_harvesting_task_parent_class = NULL;
static RygelStateMachineIface* rygel_media_export_harvesting_task_rygel_state_machine_parent_iface = NULL;

gpointer file_queue_entry_ref (gpointer instance);
void file_queue_entry_unref (gpointer instance);
GParamSpec* param_spec_file_queue_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_file_queue_entry (GValue* value, gpointer v_object);
void value_take_file_queue_entry (GValue* value, gpointer v_object);
gpointer value_get_file_queue_entry (const GValue* value);
GType file_queue_entry_get_type (void) G_GNUC_CONST;
enum  {
	FILE_QUEUE_ENTRY_DUMMY_PROPERTY
};
FileQueueEntry* file_queue_entry_new (GFile* file, gboolean known, const gchar* content_type);
FileQueueEntry* file_queue_entry_construct (GType object_type, GFile* file, gboolean known, const gchar* content_type);
static void file_queue_entry_finalize (FileQueueEntry* obj);
GType rygel_media_export_harvesting_task_get_type (void) G_GNUC_CONST;
GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTING_TASK_DUMMY_PROPERTY,
	RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE
};
static void _g_object_unref0_ (gpointer var);
static void _g_queue_free__g_object_unref0_ (GQueue* self);
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_BATCH_SIZE 256
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent, const gchar* flag);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent, const gchar* flag);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error);
static void rygel_media_export_harvesting_task_on_extracted_cb (RygelMediaExportHarvestingTask* self, GFile* file, GstDiscovererInfo* dlna, GUPnPDLNAProfile* profile, GFileInfo* file_info);
static void _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done (RygelMediaExportMetadataExtractor* _sender, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info, gpointer self);
static void rygel_media_export_harvesting_task_on_extractor_error_cb (RygelMediaExportHarvestingTask* self, GFile* file, GError* _error_);
static void _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error (RygelMediaExportMetadataExtractor* _sender, GFile* file, GError* err, gpointer self);
void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvesting_task_real_run_data_free (gpointer _data);
static void rygel_media_export_harvesting_task_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_harvesting_task_real_run_co (RygelMediaExportHarvestingTaskRunData* _data_);
static void rygel_media_export_harvesting_task_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_media_export_harvesting_task_process_file (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info, RygelMediaContainer* parent);
static gboolean rygel_media_export_harvesting_task_on_idle (RygelMediaExportHarvestingTask* self);
static gboolean rygel_media_export_harvesting_task_push_if_changed_or_unknown (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info);
GQuark rygel_media_export_database_error_quark (void);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error);
void rygel_media_export_recursive_file_monitor_add (RygelMediaExportRecursiveFileMonitor* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_recursive_file_monitor_add_finish (RygelMediaExportRecursiveFileMonitor* self, GAsyncResult* _res_);
RygelMediaExportDummyContainer* rygel_media_export_dummy_container_new (GFile* file, RygelMediaContainer* parent);
RygelMediaExportDummyContainer* rygel_media_export_dummy_container_construct (GType object_type, GFile* file, RygelMediaContainer* parent);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_trackable_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_dummy_container_get_type (void) G_GNUC_CONST;
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
gboolean rygel_media_export_harvester_is_eligible (GFileInfo* info);
static gboolean rygel_media_export_harvesting_task_process_children (RygelMediaExportHarvestingTask* self, GList* list);
void rygel_media_export_dummy_container_seen (RygelMediaExportDummyContainer* self, GFile* file);
static void rygel_media_export_harvesting_task_enumerate_directory_data_free (gpointer _data);
static void rygel_media_export_harvesting_task_enumerate_directory (RygelMediaExportHarvestingTask* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_export_harvesting_task_enumerate_directory_finish (RygelMediaExportHarvestingTask* self, GAsyncResult* _res_);
static gboolean rygel_media_export_harvesting_task_enumerate_directory_co (RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_);
static void rygel_media_export_harvesting_task_enumerate_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_list_free__g_object_unref0_ (GList* self);
static void rygel_media_export_harvesting_task_cleanup_database (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvesting_task_do_update (RygelMediaExportHarvestingTask* self);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error);
void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file, const gchar* content_type);
void rygel_media_export_media_cache_flag_object (RygelMediaExportMediaCache* self, GFile* file, const gchar* flag, GError** error);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, GFileInfo* info);
RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info);
static void ____lambda6_ (Block6Data* _data6_);
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
static void _____lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void _____lambda7_ (Block7Data* _data7_);
static void ______lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void rygel_media_export_harvesting_task_finalize (GObject* obj);
static void _vala_rygel_media_export_harvesting_task_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_export_harvesting_task_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FileQueueEntry* file_queue_entry_construct (GType object_type, GFile* file, gboolean known, const gchar* content_type) {
	FileQueueEntry* self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (content_type != NULL, NULL);
	self = (FileQueueEntry*) g_type_create_instance (object_type);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->file);
	self->file = _tmp1_;
	_tmp2_ = known;
	self->known = _tmp2_;
	_tmp3_ = content_type;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->content_type);
	self->content_type = _tmp4_;
	return self;
}


FileQueueEntry* file_queue_entry_new (GFile* file, gboolean known, const gchar* content_type) {
	return file_queue_entry_construct (TYPE_FILE_QUEUE_ENTRY, file, known, content_type);
}


static void value_file_queue_entry_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_file_queue_entry_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		file_queue_entry_unref (value->data[0].v_pointer);
	}
}


static void value_file_queue_entry_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = file_queue_entry_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_file_queue_entry_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_file_queue_entry_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FileQueueEntry* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = file_queue_entry_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_file_queue_entry_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FileQueueEntry** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = file_queue_entry_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_file_queue_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecFileQueueEntry* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_FILE_QUEUE_ENTRY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_file_queue_entry (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FILE_QUEUE_ENTRY), NULL);
	return value->data[0].v_pointer;
}


void value_set_file_queue_entry (GValue* value, gpointer v_object) {
	FileQueueEntry* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FILE_QUEUE_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FILE_QUEUE_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		file_queue_entry_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		file_queue_entry_unref (old);
	}
}


void value_take_file_queue_entry (GValue* value, gpointer v_object) {
	FileQueueEntry* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FILE_QUEUE_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FILE_QUEUE_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		file_queue_entry_unref (old);
	}
}


static void file_queue_entry_class_init (FileQueueEntryClass * klass) {
	file_queue_entry_parent_class = g_type_class_peek_parent (klass);
	FILE_QUEUE_ENTRY_CLASS (klass)->finalize = file_queue_entry_finalize;
}


static void file_queue_entry_instance_init (FileQueueEntry * self) {
	self->ref_count = 1;
}


static void file_queue_entry_finalize (FileQueueEntry* obj) {
	FileQueueEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILE_QUEUE_ENTRY, FileQueueEntry);
	_g_object_unref0 (self->file);
	_g_free0 (self->content_type);
}


GType file_queue_entry_get_type (void) {
	static volatile gsize file_queue_entry_type_id__volatile = 0;
	if (g_once_init_enter (&file_queue_entry_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_file_queue_entry_init, value_file_queue_entry_free_value, value_file_queue_entry_copy_value, value_file_queue_entry_peek_pointer, "p", value_file_queue_entry_collect_value, "p", value_file_queue_entry_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FileQueueEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_queue_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileQueueEntry), 0, (GInstanceInitFunc) file_queue_entry_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType file_queue_entry_type_id;
		file_queue_entry_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FileQueueEntry", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&file_queue_entry_type_id__volatile, file_queue_entry_type_id);
	}
	return file_queue_entry_type_id__volatile;
}


gpointer file_queue_entry_ref (gpointer instance) {
	FileQueueEntry* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void file_queue_entry_unref (gpointer instance) {
	FileQueueEntry* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FILE_QUEUE_ENTRY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_queue_free__g_object_unref0_ (GQueue* self) {
	g_queue_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_queue_free (self);
}


static void _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done (RygelMediaExportMetadataExtractor* _sender, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info, gpointer self) {
	rygel_media_export_harvesting_task_on_extracted_cb (self, file, info, profile, file_info);
}


static void _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error (RygelMediaExportMetadataExtractor* _sender, GFile* file, GError* err, gpointer self) {
	rygel_media_export_harvesting_task_on_extractor_error_cb (self, file, err);
}


RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent, const gchar* flag) {
	RygelMediaExportHarvestingTask * self = NULL;
	RygelMediaExportMetadataExtractor* _tmp0_;
	RygelMediaExportMetadataExtractor* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	RygelMediaContainer* _tmp4_;
	RygelMediaContainer* _tmp5_;
	RygelMediaExportMetadataExtractor* _tmp8_;
	RygelMediaExportMetadataExtractor* _tmp9_;
	GeeLinkedList* _tmp10_;
	GQueue* _tmp11_;
	RygelMediaExportRecursiveFileMonitor* _tmp12_;
	RygelMediaExportRecursiveFileMonitor* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (extractor != NULL, NULL);
	g_return_val_if_fail (monitor != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (RygelMediaExportHarvestingTask*) g_object_new (object_type, NULL);
	_tmp0_ = extractor;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->extractor);
	self->priv->extractor = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->origin);
	self->origin = _tmp3_;
	_tmp4_ = parent;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->parent);
	self->priv->parent = _tmp5_;
	{
		RygelMediaExportMediaCache* _tmp6_ = NULL;
		RygelMediaExportMediaCache* _tmp7_;
		_tmp6_ = rygel_media_export_media_cache_get_default (&_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			goto __catch55_g_error;
		}
		_g_object_unref0 (self->priv->cache);
		self->priv->cache = _tmp7_;
	}
	goto __finally55;
	__catch55_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally55:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp8_ = self->priv->extractor;
	g_signal_connect_object (_tmp8_, "extraction-done", (GCallback) _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done, self, 0);
	_tmp9_ = self->priv->extractor;
	g_signal_connect_object (_tmp9_, "error", (GCallback) _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error, self, 0);
	_tmp10_ = gee_linked_list_new (TYPE_FILE_QUEUE_ENTRY, (GBoxedCopyFunc) file_queue_entry_ref, file_queue_entry_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->files);
	self->priv->files = (GeeQueue*) _tmp10_;
	_tmp11_ = g_queue_new ();
	__g_queue_free__g_object_unref0_0 (self->priv->containers);
	self->priv->containers = _tmp11_;
	_tmp12_ = monitor;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp13_;
	_tmp14_ = flag;
	_tmp15_ = g_strdup (_tmp14_);
	_g_free0 (self->priv->flag);
	self->priv->flag = _tmp15_;
	return self;
}


RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent, const gchar* flag) {
	return rygel_media_export_harvesting_task_construct (RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, extractor, monitor, file, parent, flag);
}


void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self) {
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_cancellable_new ();
	_tmp1_ = _tmp0_;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp3_ = _tmp2_;
	g_cancellable_cancel (_tmp3_);
}


static void rygel_media_export_harvesting_task_real_run_data_free (gpointer _data) {
	RygelMediaExportHarvestingTaskRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportHarvestingTaskRunData, _data_);
}


static void rygel_media_export_harvesting_task_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportHarvestingTask * self;
	RygelMediaExportHarvestingTaskRunData* _data_;
	RygelMediaExportHarvestingTask* _tmp0_;
	self = (RygelMediaExportHarvestingTask*) base;
	_data_ = g_slice_new0 (RygelMediaExportHarvestingTaskRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_harvesting_task_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_harvesting_task_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_harvesting_task_real_run_co (_data_);
}


static void rygel_media_export_harvesting_task_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelMediaExportHarvestingTaskRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Extract all metainformation from a given file.
     *
     * What action will be taken depends on the arguments
     * * file is a simple file. Then only information of this
     *   file will be extracted
     * * file is a directory and recursive is false. The children
     *   of the directory (if not directories themselves) will be
     *   enqueued for extraction
     * * file is a directory and recursive is true. ++ All ++ children
     *   of the directory will be enqueued for extraction, even directories
     *
     * No matter how many children are contained within file's hierarchy,
     * only one event is sent when all the children are done.
     */
static void rygel_media_export_harvesting_task_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportHarvestingTaskRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_harvesting_task_real_run_co (_data_);
}


static gboolean rygel_media_export_harvesting_task_real_run_co (RygelMediaExportHarvestingTaskRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->origin;
		_data_->_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->_tmp0_, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->_tmp2_, rygel_media_export_harvesting_task_run_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = g_file_query_info_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
		_data_->info = _data_->_tmp3_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch56_g_error;
		}
		_data_->_tmp4_ = _data_->self->origin;
		_data_->_tmp5_ = _data_->self->priv->parent;
		_data_->_tmp6_ = FALSE;
		_data_->_tmp6_ = rygel_media_export_harvesting_task_process_file (_data_->self, _data_->_tmp4_, _data_->info, _data_->_tmp5_);
		if (_data_->_tmp6_) {
			_data_->_tmp7_ = 0;
			_data_->_tmp7_ = g_file_info_get_file_type (_data_->info);
			if (_data_->_tmp7_ != G_FILE_TYPE_DIRECTORY) {
				_data_->_tmp8_ = _data_->self->priv->containers;
				_data_->_tmp9_ = _data_->self->priv->parent;
				_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp9_);
				g_queue_push_tail (_data_->_tmp8_, _data_->_tmp10_);
			}
			rygel_media_export_harvesting_task_on_idle (_data_->self);
		} else {
			g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
		}
		_g_object_unref0 (_data_->info);
	}
	goto __finally56;
	__catch56_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp11_ = _data_->_error_;
		if (!g_error_matches (_data_->_tmp11_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _ ("Failed to harvest file %s: %s");
			_data_->_tmp13_ = _data_->self->origin;
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = g_file_get_uri (_data_->_tmp13_);
			_data_->_tmp15_ = _data_->_tmp14_;
			_data_->_tmp16_ = _data_->_error_;
			_data_->_tmp17_ = _data_->_tmp16_->message;
			g_warning (_data_->_tmp12_, _data_->_tmp15_, _data_->_tmp17_);
			_g_free0 (_data_->_tmp15_);
		} else {
			_data_->_tmp18_ = _data_->self->origin;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = g_file_get_uri (_data_->_tmp18_);
			_data_->_tmp20_ = _data_->_tmp19_;
			g_debug ("rygel-media-export-harvesting-task.vala:129: Harvesting of uri %s was " \
"cancelled", _data_->_tmp20_);
			_g_free0 (_data_->_tmp20_);
		}
		g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
		_g_error_free0 (_data_->_error_);
	}
	__finally56:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Add a file to the meta-data extraction queue.
     *
     * The file will only be added to the queue if one of the following
     * conditions is met:
     *   - The file is not in the cache
     *   - The current mtime of the file is larger than the cached
     *   - The size has changed
     * @param file to check
     * @param info FileInfo of the file to check
     * @return true, if the file has been queued, false otherwise.
     */
static gboolean rygel_media_export_harvesting_task_push_if_changed_or_unknown (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info) {
	gboolean result = FALSE;
	gint64 timestamp = 0LL;
	gint64 size = 0LL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	{
		RygelMediaExportMediaCache* _tmp0_;
		GFile* _tmp1_;
		gint64 _tmp2_ = 0LL;
		gint64 _tmp3_ = 0LL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		_tmp0_ = self->priv->cache;
		_tmp1_ = file;
		_tmp4_ = rygel_media_export_media_cache_exists (_tmp0_, _tmp1_, &_tmp2_, &_tmp3_, &_inner_error_);
		timestamp = _tmp2_;
		size = _tmp3_;
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			goto __catch57_g_error;
		}
		if (_tmp5_) {
			GFileInfo* _tmp6_;
			guint64 _tmp7_ = 0ULL;
			gint64 mtime;
			gboolean _tmp8_ = FALSE;
			gint64 _tmp9_;
			gint64 _tmp10_;
			gboolean _tmp14_;
			_tmp6_ = info;
			_tmp7_ = g_file_info_get_attribute_uint64 (_tmp6_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
			mtime = (gint64) _tmp7_;
			_tmp9_ = mtime;
			_tmp10_ = timestamp;
			if (_tmp9_ > _tmp10_) {
				_tmp8_ = TRUE;
			} else {
				GFileInfo* _tmp11_;
				gint64 _tmp12_ = 0LL;
				gint64 _tmp13_;
				_tmp11_ = info;
				_tmp12_ = g_file_info_get_size (_tmp11_);
				_tmp13_ = size;
				_tmp8_ = _tmp12_ != _tmp13_;
			}
			_tmp14_ = _tmp8_;
			if (_tmp14_) {
				GFile* _tmp15_;
				GFileInfo* _tmp16_;
				const gchar* _tmp17_ = NULL;
				FileQueueEntry* _tmp18_;
				FileQueueEntry* entry;
				GeeQueue* _tmp19_;
				FileQueueEntry* _tmp20_;
				_tmp15_ = file;
				_tmp16_ = info;
				_tmp17_ = g_file_info_get_content_type (_tmp16_);
				_tmp18_ = file_queue_entry_new (_tmp15_, TRUE, _tmp17_);
				entry = _tmp18_;
				_tmp19_ = self->priv->files;
				_tmp20_ = entry;
				gee_queue_offer (_tmp19_, _tmp20_);
				result = TRUE;
				_file_queue_entry_unref0 (entry);
				return result;
			}
		} else {
			GFile* _tmp21_;
			GFileInfo* _tmp22_;
			const gchar* _tmp23_ = NULL;
			FileQueueEntry* _tmp24_;
			FileQueueEntry* entry;
			GeeQueue* _tmp25_;
			FileQueueEntry* _tmp26_;
			_tmp21_ = file;
			_tmp22_ = info;
			_tmp23_ = g_file_info_get_content_type (_tmp22_);
			_tmp24_ = file_queue_entry_new (_tmp21_, FALSE, _tmp23_);
			entry = _tmp24_;
			_tmp25_ = self->priv->files;
			_tmp26_ = entry;
			gee_queue_offer (_tmp25_, _tmp26_);
			result = TRUE;
			_file_queue_entry_unref0 (entry);
			return result;
		}
	}
	goto __finally57;
	__catch57_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp27_ = NULL;
		GError* _tmp28_;
		const gchar* _tmp29_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp27_ = _ ("Failed to query database: %s");
		_tmp28_ = _error_;
		_tmp29_ = _tmp28_->message;
		g_warning (_tmp27_, _tmp29_);
		_g_error_free0 (_error_);
	}
	__finally57:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean rygel_media_export_harvesting_task_process_file (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info, RygelMediaContainer* parent) {
	gboolean result = FALSE;
	GFileInfo* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar _tmp2_ = '\0';
	GFileInfo* _tmp3_;
	GFileType _tmp4_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	g_return_val_if_fail (parent != NULL, FALSE);
	_tmp0_ = info;
	_tmp1_ = g_file_info_get_name (_tmp0_);
	_tmp2_ = string_get (_tmp1_, (glong) 0);
	if (_tmp2_ == '.') {
		result = FALSE;
		return result;
	}
	_tmp3_ = info;
	_tmp4_ = g_file_info_get_file_type (_tmp3_);
	if (_tmp4_ == G_FILE_TYPE_DIRECTORY) {
		RygelMediaExportRecursiveFileMonitor* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		RygelMediaContainer* _tmp8_;
		RygelMediaExportDummyContainer* _tmp9_;
		RygelMediaExportDummyContainer* container;
		GQueue* _tmp10_;
		RygelMediaExportDummyContainer* _tmp11_;
		RygelMediaContainer* _tmp12_;
		_tmp5_ = self->priv->monitor;
		_tmp6_ = file;
		rygel_media_export_recursive_file_monitor_add (_tmp5_, _tmp6_, NULL, NULL);
		_tmp7_ = file;
		_tmp8_ = parent;
		_tmp9_ = rygel_media_export_dummy_container_new (_tmp7_, _tmp8_);
		container = _tmp9_;
		_tmp10_ = self->priv->containers;
		_tmp11_ = container;
		_tmp12_ = _g_object_ref0 ((RygelMediaContainer*) _tmp11_);
		g_queue_push_tail (_tmp10_, _tmp12_);
		{
			RygelMediaExportMediaCache* _tmp13_;
			RygelMediaExportDummyContainer* _tmp14_;
			_tmp13_ = self->priv->cache;
			_tmp14_ = container;
			rygel_media_export_media_cache_save_container (_tmp13_, (RygelMediaContainer*) _tmp14_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch58_g_error;
			}
		}
		goto __finally58;
		__catch58_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp15_ = NULL;
			GError* _tmp16_;
			const gchar* _tmp17_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp15_ = _ ("Failed to update database: %s");
			_tmp16_ = err;
			_tmp17_ = _tmp16_->message;
			g_warning (_tmp15_, _tmp17_);
			result = FALSE;
			_g_error_free0 (err);
			_g_object_unref0 (container);
			return result;
		}
		__finally58:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (container);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		result = TRUE;
		_g_object_unref0 (container);
		return result;
	} else {
		GFileInfo* _tmp18_;
		gboolean _tmp19_ = FALSE;
		_tmp18_ = info;
		_tmp19_ = rygel_media_export_harvester_is_eligible (_tmp18_);
		if (_tmp19_) {
			GFile* _tmp20_;
			GFileInfo* _tmp21_;
			gboolean _tmp22_ = FALSE;
			_tmp20_ = file;
			_tmp21_ = info;
			_tmp22_ = rygel_media_export_harvesting_task_push_if_changed_or_unknown (self, _tmp20_, _tmp21_);
			result = _tmp22_;
			return result;
		}
		result = FALSE;
		return result;
	}
}


static gboolean rygel_media_export_harvesting_task_process_children (RygelMediaExportHarvestingTask* self, GList* list) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_;
	gboolean _tmp5_;
	GQueue* _tmp6_;
	gconstpointer _tmp7_ = NULL;
	RygelMediaExportDummyContainer* _tmp8_;
	RygelMediaExportDummyContainer* container;
	GList* _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = list;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GCancellable* _tmp2_;
		GCancellable* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_cancellable_is_cancelled (_tmp3_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = self->priv->containers;
	_tmp7_ = g_queue_peek_head (_tmp6_);
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE ((RygelMediaContainer*) _tmp7_, RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER) ? ((RygelMediaExportDummyContainer*) ((RygelMediaContainer*) _tmp7_)) : NULL);
	container = _tmp8_;
	_tmp9_ = list;
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp9_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			GFileInfo* _tmp10_;
			GFileInfo* info = NULL;
			_tmp10_ = _g_object_ref0 ((GFileInfo*) info_it->data);
			info = _tmp10_;
			{
				RygelMediaExportDummyContainer* _tmp11_;
				GFile* _tmp12_;
				GFileInfo* _tmp13_;
				const gchar* _tmp14_ = NULL;
				GFile* _tmp15_ = NULL;
				GFile* file;
				RygelMediaExportDummyContainer* _tmp16_;
				GFile* _tmp17_;
				GFile* _tmp18_;
				GFileInfo* _tmp19_;
				RygelMediaExportDummyContainer* _tmp20_;
				_tmp11_ = container;
				_tmp12_ = _tmp11_->file;
				_tmp13_ = info;
				_tmp14_ = g_file_info_get_name (_tmp13_);
				_tmp15_ = g_file_get_child (_tmp12_, _tmp14_);
				file = _tmp15_;
				_tmp16_ = container;
				_tmp17_ = file;
				rygel_media_export_dummy_container_seen (_tmp16_, _tmp17_);
				_tmp18_ = file;
				_tmp19_ = info;
				_tmp20_ = container;
				rygel_media_export_harvesting_task_process_file (self, _tmp18_, _tmp19_, (RygelMediaContainer*) _tmp20_);
				_g_object_unref0 (file);
				_g_object_unref0 (info);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (container);
	return result;
}


static void rygel_media_export_harvesting_task_enumerate_directory_data_free (gpointer _data) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportHarvestingTaskEnumerateDirectoryData, _data_);
}


static void rygel_media_export_harvesting_task_enumerate_directory (RygelMediaExportHarvestingTask* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	RygelMediaExportHarvestingTask* _tmp0_;
	_data_ = g_slice_new0 (RygelMediaExportHarvestingTaskEnumerateDirectoryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_harvesting_task_enumerate_directory);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_harvesting_task_enumerate_directory_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_harvesting_task_enumerate_directory_co (_data_);
}


static void rygel_media_export_harvesting_task_enumerate_directory_finish (RygelMediaExportHarvestingTask* self, GAsyncResult* _res_) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_media_export_harvesting_task_enumerate_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_harvesting_task_enumerate_directory_co (_data_);
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean rygel_media_export_harvesting_task_enumerate_directory_co (RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->containers;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_queue_peek_head (_data_->_tmp0_);
	_data_->_tmp2_ = (G_TYPE_CHECK_INSTANCE_TYPE ((RygelMediaContainer*) _data_->_tmp1_, RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER) ? ((RygelMediaExportDummyContainer*) ((RygelMediaContainer*) _data_->_tmp1_)) : NULL)->file;
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
	_data_->directory = _data_->_tmp3_;
	{
		_data_->_tmp4_ = _data_->directory;
		_data_->_tmp5_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_state_ = 1;
		g_file_enumerate_children_async (_data_->_tmp4_, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->_tmp6_, rygel_media_export_harvesting_task_enumerate_directory_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = g_file_enumerate_children_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
		_data_->enumerator = _data_->_tmp7_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch59_g_error;
		}
		_data_->list = NULL;
		{
			_data_->_tmp8_ = TRUE;
			while (TRUE) {
				_data_->_tmp9_ = _data_->_tmp8_;
				if (!_data_->_tmp9_) {
					_data_->_tmp10_ = _data_->list;
					_data_->_tmp11_ = FALSE;
					_data_->_tmp11_ = rygel_media_export_harvesting_task_process_children (_data_->self, _data_->_tmp10_);
					if (!_data_->_tmp11_) {
						break;
					}
				}
				_data_->_tmp8_ = FALSE;
				_data_->_tmp12_ = _data_->enumerator;
				_data_->_tmp13_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
				_data_->_tmp14_ = _data_->_tmp13_;
				_data_->_state_ = 2;
				g_file_enumerator_next_files_async (_data_->_tmp12_, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_BATCH_SIZE, G_PRIORITY_DEFAULT, _data_->_tmp14_, rygel_media_export_harvesting_task_enumerate_directory_ready, _data_);
				return FALSE;
				_state_2:
				_data_->_tmp15_ = NULL;
				_data_->_tmp15_ = g_file_enumerator_next_files_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error_);
				_data_->_tmp16_ = _data_->_tmp15_;
				if (_data_->_inner_error_ != NULL) {
					__g_list_free__g_object_unref0_0 (_data_->list);
					_g_object_unref0 (_data_->enumerator);
					goto __catch59_g_error;
				}
				__g_list_free__g_object_unref0_0 (_data_->list);
				_data_->list = _data_->_tmp16_;
			}
		}
		_data_->_tmp17_ = _data_->enumerator;
		_data_->_tmp18_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_state_ = 3;
		g_file_enumerator_close_async (_data_->_tmp17_, G_PRIORITY_DEFAULT, _data_->_tmp19_, rygel_media_export_harvesting_task_enumerate_directory_ready, _data_);
		return FALSE;
		_state_3:
		g_file_enumerator_close_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			__g_list_free__g_object_unref0_0 (_data_->list);
			_g_object_unref0 (_data_->enumerator);
			goto __catch59_g_error;
		}
		__g_list_free__g_object_unref0_0 (_data_->list);
		_g_object_unref0 (_data_->enumerator);
	}
	goto __finally59;
	__catch59_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _ ("failed to enumerate folder: %s");
		_data_->_tmp21_ = _data_->err;
		_data_->_tmp22_ = _data_->_tmp21_->message;
		g_warning (_data_->_tmp20_, _data_->_tmp22_);
		_g_error_free0 (_data_->err);
	}
	__finally59:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	rygel_media_export_harvesting_task_cleanup_database (_data_->self);
	rygel_media_export_harvesting_task_do_update (_data_->self);
	_g_object_unref0 (_data_->directory);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_media_export_harvesting_task_cleanup_database (RygelMediaExportHarvestingTask* self) {
	GQueue* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	RygelMediaExportDummyContainer* _tmp2_;
	RygelMediaExportDummyContainer* container;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->containers;
	_tmp1_ = g_queue_peek_head (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE ((RygelMediaContainer*) _tmp1_, RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER) ? ((RygelMediaExportDummyContainer*) ((RygelMediaContainer*) _tmp1_)) : NULL);
	container = _tmp2_;
	{
		{
			RygelMediaExportDummyContainer* _tmp3_;
			GeeList* _tmp4_;
			GeeList* _tmp5_;
			GeeList* _child_list;
			GeeList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _child_size;
			gint _child_index;
			_tmp3_ = container;
			_tmp4_ = _tmp3_->children;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			_child_list = _tmp5_;
			_tmp6_ = _child_list;
			_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_child_size = _tmp8_;
			_child_index = -1;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				GeeList* _tmp12_;
				gint _tmp13_;
				gpointer _tmp14_ = NULL;
				gchar* child;
				RygelMediaExportMediaCache* _tmp15_;
				const gchar* _tmp16_;
				_tmp9_ = _child_index;
				_child_index = _tmp9_ + 1;
				_tmp10_ = _child_index;
				_tmp11_ = _child_size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = _child_list;
				_tmp13_ = _child_index;
				_tmp14_ = gee_list_get (_tmp12_, _tmp13_);
				child = (gchar*) _tmp14_;
				_tmp15_ = self->priv->cache;
				_tmp16_ = child;
				rygel_media_export_media_cache_remove_by_id (_tmp15_, _tmp16_, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (child);
					_g_object_unref0 (_child_list);
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
						goto __catch60_rygel_media_export_database_error;
					}
					_g_free0 (child);
					_g_object_unref0 (_child_list);
					_g_object_unref0 (container);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_free0 (child);
			}
			_g_object_unref0 (_child_list);
		}
	}
	goto __finally60;
	__catch60_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp17_ = NULL;
		RygelMediaExportDummyContainer* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		GError* _tmp21_;
		const gchar* _tmp22_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = _ ("Failed to get children of container %s: %s");
		_tmp18_ = container;
		_tmp19_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _error_;
		_tmp22_ = _tmp21_->message;
		g_warning (_tmp17_, _tmp20_, _tmp22_);
		_g_error_free0 (_error_);
	}
	__finally60:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (container);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (container);
}


static gboolean rygel_media_export_harvesting_task_on_idle (RygelMediaExportHarvestingTask* self) {
	gboolean result = FALSE;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeQueue* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_cancellable_is_cancelled (_tmp1_);
	if (_tmp2_) {
		g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->files;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ > 0) {
		GeeQueue* _tmp6_;
		gpointer _tmp7_ = NULL;
		FileQueueEntry* _tmp8_;
		GFile* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		RygelMediaExportMetadataExtractor* _tmp12_;
		GeeQueue* _tmp13_;
		gpointer _tmp14_ = NULL;
		FileQueueEntry* _tmp15_;
		GFile* _tmp16_;
		GeeQueue* _tmp17_;
		gpointer _tmp18_ = NULL;
		FileQueueEntry* _tmp19_;
		const gchar* _tmp20_;
		_tmp6_ = self->priv->files;
		_tmp7_ = gee_queue_peek (_tmp6_);
		_tmp8_ = (FileQueueEntry*) _tmp7_;
		_tmp9_ = _tmp8_->file;
		_tmp10_ = g_file_get_uri (_tmp9_);
		_tmp11_ = _tmp10_;
		g_debug ("rygel-media-export-harvesting-task.vala:279: Scheduling file %s for me" \
"ta-data extraction…", _tmp11_);
		_g_free0 (_tmp11_);
		_file_queue_entry_unref0 (_tmp8_);
		_tmp12_ = self->priv->extractor;
		_tmp13_ = self->priv->files;
		_tmp14_ = gee_queue_peek (_tmp13_);
		_tmp15_ = (FileQueueEntry*) _tmp14_;
		_tmp16_ = _tmp15_->file;
		_tmp17_ = self->priv->files;
		_tmp18_ = gee_queue_peek (_tmp17_);
		_tmp19_ = (FileQueueEntry*) _tmp18_;
		_tmp20_ = _tmp19_->content_type;
		rygel_media_export_metadata_extractor_extract (_tmp12_, _tmp16_, _tmp20_);
		_file_queue_entry_unref0 (_tmp19_);
		_file_queue_entry_unref0 (_tmp15_);
	} else {
		GQueue* _tmp21_;
		guint _tmp22_ = 0U;
		_tmp21_ = self->priv->containers;
		_tmp22_ = g_queue_get_length (_tmp21_);
		if (_tmp22_ > ((guint) 0)) {
			rygel_media_export_harvesting_task_enumerate_directory (self, NULL, NULL);
		} else {
			const gchar* _tmp23_;
			_tmp23_ = self->priv->flag;
			if (_tmp23_ != NULL) {
				{
					RygelMediaExportMediaCache* _tmp24_;
					GFile* _tmp25_;
					const gchar* _tmp26_;
					_tmp24_ = self->priv->cache;
					_tmp25_ = self->origin;
					_tmp26_ = self->priv->flag;
					rygel_media_export_media_cache_flag_object (_tmp24_, _tmp25_, _tmp26_, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch61_g_error;
					}
				}
				goto __finally61;
				__catch61_g_error:
				{
					GError* _error_ = NULL;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (_error_);
				}
				__finally61:
				if (_inner_error_ != NULL) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
		}
	}
	result = FALSE;
	return result;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		RygelMediaExportHarvestingTask * self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->item);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static void ____lambda6_ (Block6Data* _data6_) {
	RygelMediaExportHarvestingTask * self;
	GError * _inner_error_ = NULL;
	self = _data6_->self;
	{
		RygelMediaExportMediaCache* _tmp0_;
		RygelMediaItem* _tmp1_;
		_tmp0_ = self->priv->cache;
		_tmp1_ = _data6_->item;
		rygel_media_export_media_cache_save_item (_tmp0_, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch62_g_error;
		}
	}
	goto __finally62;
	__catch62_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally62:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _____lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	____lambda6_ (self);
	block6_data_unref (self);
}


static void rygel_media_export_harvesting_task_on_extracted_cb (RygelMediaExportHarvestingTask* self, GFile* file, GstDiscovererInfo* dlna, GUPnPDLNAProfile* profile, GFileInfo* file_info) {
	Block6Data* _data6_;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeQueue* _tmp3_;
	gpointer _tmp4_ = NULL;
	FileQueueEntry* entry;
	gboolean _tmp5_ = FALSE;
	FileQueueEntry* _tmp6_;
	gboolean _tmp10_;
	GstDiscovererInfo* _tmp11_;
	RygelMediaItem* _tmp24_;
	GeeQueue* _tmp37_;
	gpointer _tmp38_ = NULL;
	FileQueueEntry* _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (file_info != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_cancellable_is_cancelled (_tmp1_);
	if (_tmp2_) {
		g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
	}
	_tmp3_ = self->priv->files;
	_tmp4_ = gee_queue_peek (_tmp3_);
	entry = (FileQueueEntry*) _tmp4_;
	_tmp6_ = entry;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		GFile* _tmp7_;
		FileQueueEntry* _tmp8_;
		GFile* _tmp9_;
		_tmp7_ = file;
		_tmp8_ = entry;
		_tmp9_ = _tmp8_->file;
		_tmp5_ = _tmp7_ != _tmp9_;
	}
	_tmp10_ = _tmp5_;
	if (_tmp10_) {
		_file_queue_entry_unref0 (entry);
		block6_data_unref (_data6_);
		_data6_ = NULL;
		return;
	}
	_tmp11_ = dlna;
	if (_tmp11_ == NULL) {
		GQueue* _tmp12_;
		gconstpointer _tmp13_ = NULL;
		GFile* _tmp14_;
		GFileInfo* _tmp15_;
		RygelMediaItem* _tmp16_ = NULL;
		_tmp12_ = self->priv->containers;
		_tmp13_ = g_queue_peek_head (_tmp12_);
		_tmp14_ = file;
		_tmp15_ = file_info;
		_tmp16_ = rygel_media_export_item_factory_create_simple ((RygelMediaContainer*) _tmp13_, _tmp14_, _tmp15_);
		_g_object_unref0 (_data6_->item);
		_data6_->item = _tmp16_;
	} else {
		GQueue* _tmp17_;
		gconstpointer _tmp18_ = NULL;
		GFile* _tmp19_;
		GstDiscovererInfo* _tmp20_;
		GUPnPDLNAProfile* _tmp21_;
		GFileInfo* _tmp22_;
		RygelMediaItem* _tmp23_ = NULL;
		_tmp17_ = self->priv->containers;
		_tmp18_ = g_queue_peek_head (_tmp17_);
		_tmp19_ = file;
		_tmp20_ = dlna;
		_tmp21_ = profile;
		_tmp22_ = file_info;
		_tmp23_ = rygel_media_export_item_factory_create_from_info ((RygelMediaContainer*) _tmp18_, _tmp19_, _tmp20_, _tmp21_, _tmp22_);
		_g_object_unref0 (_data6_->item);
		_data6_->item = _tmp23_;
	}
	_tmp24_ = _data6_->item;
	if (_tmp24_ != NULL) {
		RygelMediaItem* _tmp25_;
		GQueue* _tmp26_;
		gconstpointer _tmp27_ = NULL;
		FileQueueEntry* _tmp28_;
		gboolean _tmp29_;
		_tmp25_ = _data6_->item;
		_tmp26_ = self->priv->containers;
		_tmp27_ = g_queue_peek_head (_tmp26_);
		rygel_media_object_set_parent_ref ((RygelMediaObject*) _tmp25_, (RygelMediaContainer*) _tmp27_);
		_tmp28_ = entry;
		_tmp29_ = _tmp28_->known;
		if (_tmp29_) {
			RygelMediaItem* _tmp30_;
			_tmp30_ = _data6_->item;
			rygel_updatable_object_commit (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, RYGEL_TYPE_UPDATABLE_OBJECT) ? ((RygelUpdatableObject*) _tmp30_) : NULL, NULL, NULL);
		} else {
			RygelMediaItem* _tmp31_;
			RygelMediaContainer* _tmp32_;
			RygelMediaContainer* _tmp33_;
			RygelTrackableContainer* _tmp34_;
			RygelTrackableContainer* container;
			RygelTrackableContainer* _tmp35_;
			RygelMediaItem* _tmp36_;
			_tmp31_ = _data6_->item;
			_tmp32_ = rygel_media_object_get_parent ((RygelMediaObject*) _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _tmp33_) : NULL);
			container = _tmp34_;
			_tmp35_ = container;
			_tmp36_ = _data6_->item;
			rygel_trackable_container_add_child_tracked (_tmp35_, (RygelMediaObject*) _tmp36_, _____lambda6__gasync_ready_callback, block6_data_ref (_data6_));
			_g_object_unref0 (container);
		}
	}
	_tmp37_ = self->priv->files;
	_tmp38_ = gee_queue_poll (_tmp37_);
	_tmp39_ = (FileQueueEntry*) _tmp38_;
	_file_queue_entry_unref0 (_tmp39_);
	rygel_media_export_harvesting_task_do_update (self);
	_file_queue_entry_unref0 (entry);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}


static void rygel_media_export_harvesting_task_on_extractor_error_cb (RygelMediaExportHarvestingTask* self, GFile* file, GError* _error_) {
	GeeQueue* _tmp0_;
	gpointer _tmp1_ = NULL;
	FileQueueEntry* entry;
	gboolean _tmp2_ = FALSE;
	FileQueueEntry* _tmp3_;
	gboolean _tmp7_;
	GFile* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GeeQueue* _tmp13_;
	gpointer _tmp14_ = NULL;
	FileQueueEntry* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->files;
	_tmp1_ = gee_queue_peek (_tmp0_);
	entry = (FileQueueEntry*) _tmp1_;
	_tmp3_ = entry;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		GFile* _tmp4_;
		FileQueueEntry* _tmp5_;
		GFile* _tmp6_;
		_tmp4_ = file;
		_tmp5_ = entry;
		_tmp6_ = _tmp5_->file;
		_tmp2_ = _tmp4_ != _tmp6_;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		_file_queue_entry_unref0 (entry);
		return;
	}
	_tmp8_ = file;
	_tmp9_ = g_file_get_uri (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _error_;
	_tmp12_ = _tmp11_->message;
	g_debug ("rygel-media-export-harvesting-task.vala:361: Skipping %s; extraction c" \
"ompletely failed: %s", _tmp10_, _tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = self->priv->files;
	_tmp14_ = gee_queue_poll (_tmp13_);
	_tmp15_ = (FileQueueEntry*) _tmp14_;
	_file_queue_entry_unref0 (_tmp15_);
	rygel_media_export_harvesting_task_do_update (self);
	_file_queue_entry_unref0 (entry);
}


/**
     * If all files of a container were processed, notify the container
     * about this and set the updating signal.
     * Reschedule the iteration and extraction
     */
static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		RygelMediaExportHarvestingTask * self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->parent);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}


static void _____lambda7_ (Block7Data* _data7_) {
	RygelMediaExportHarvestingTask * self;
	GError * _inner_error_ = NULL;
	self = _data7_->self;
	{
		RygelMediaExportMediaCache* _tmp0_ = NULL;
		RygelMediaExportMediaCache* _tmp1_;
		RygelMediaExportMediaCache* _tmp2_;
		RygelTrackableContainer* _tmp3_;
		_tmp0_ = rygel_media_export_media_cache_get_default (&_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch64_g_error;
		}
		_tmp2_ = _tmp1_;
		_tmp3_ = _data7_->parent;
		rygel_media_export_media_cache_save_container (_tmp2_, (RygelMediaContainer*) _tmp3_, &_inner_error_);
		_g_object_unref0 (_tmp2_);
		if (_inner_error_ != NULL) {
			goto __catch64_g_error;
		}
	}
	goto __finally64;
	__catch64_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally64:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ______lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_____lambda7_ (self);
	block7_data_unref (self);
}


static void rygel_media_export_harvesting_task_do_update (RygelMediaExportHarvestingTask* self) {
	gboolean _tmp0_ = FALSE;
	GeeQueue* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->files;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		GQueue* _tmp4_;
		guint _tmp5_ = 0U;
		_tmp4_ = self->priv->containers;
		_tmp5_ = g_queue_get_length (_tmp4_);
		_tmp0_ = _tmp5_ != ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		GQueue* _tmp7_;
		gconstpointer _tmp8_ = NULL;
		RygelMediaContainer* _tmp9_;
		RygelMediaContainer* container;
		GQueue* _tmp23_;
		gpointer _tmp24_ = NULL;
		RygelMediaContainer* _tmp25_;
		_tmp7_ = self->priv->containers;
		_tmp8_ = g_queue_peek_head (_tmp7_);
		_tmp9_ = _g_object_ref0 ((RygelMediaContainer*) _tmp8_);
		container = _tmp9_;
		{
			RygelMediaExportMediaCache* _tmp10_ = NULL;
			RygelMediaExportMediaCache* cache;
			RygelMediaExportMediaCache* _tmp11_;
			RygelMediaContainer* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_ = 0;
			gint _tmp16_;
			_tmp10_ = rygel_media_export_media_cache_get_default (&_inner_error_);
			cache = _tmp10_;
			if (_inner_error_ != NULL) {
				goto __catch63_g_error;
			}
			_tmp11_ = cache;
			_tmp12_ = container;
			_tmp13_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = rygel_media_export_media_cache_get_child_count (_tmp11_, _tmp14_, &_inner_error_);
			_tmp16_ = _tmp15_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (cache);
				goto __catch63_g_error;
			}
			if (_tmp16_ == 0) {
				Block7Data* _data7_;
				RygelMediaContainer* _tmp17_;
				RygelMediaContainer* _tmp18_;
				RygelMediaContainer* _tmp19_;
				RygelTrackableContainer* _tmp20_;
				RygelTrackableContainer* _tmp21_;
				RygelMediaContainer* _tmp22_;
				_data7_ = g_slice_new0 (Block7Data);
				_data7_->_ref_count_ = 1;
				_data7_->self = g_object_ref (self);
				_tmp17_ = container;
				_tmp18_ = rygel_media_object_get_parent ((RygelMediaObject*) _tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _tmp19_) : NULL);
				_data7_->parent = _tmp20_;
				_tmp21_ = _data7_->parent;
				_tmp22_ = container;
				rygel_trackable_container_remove_child_tracked (_tmp21_, (RygelMediaObject*) _tmp22_, ______lambda7__gasync_ready_callback, block7_data_ref (_data7_));
				block7_data_unref (_data7_);
				_data7_ = NULL;
			}
			_g_object_unref0 (cache);
		}
		goto __finally63;
		__catch63_g_error:
		{
			GError* _error_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (_error_);
		}
		__finally63:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (container);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp23_ = self->priv->containers;
		_tmp24_ = g_queue_pop_head (_tmp23_);
		_tmp25_ = (RygelMediaContainer*) _tmp24_;
		_g_object_unref0 (_tmp25_);
		_g_object_unref0 (container);
	}
	rygel_media_export_harvesting_task_on_idle (self);
}


static GCancellable* rygel_media_export_harvesting_task_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelMediaExportHarvestingTask* self;
	GCancellable* _tmp0_;
	self = (RygelMediaExportHarvestingTask*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}


static void rygel_media_export_harvesting_task_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelMediaExportHarvestingTask* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	self = (RygelMediaExportHarvestingTask*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_media_export_harvesting_task_class_init (RygelMediaExportHarvestingTaskClass * klass) {
	rygel_media_export_harvesting_task_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportHarvestingTaskPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_harvesting_task_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_export_harvesting_task_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_harvesting_task_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_media_export_harvesting_task_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_media_export_harvesting_task_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_media_export_harvesting_task_real_run;
	iface->run_finish = rygel_media_export_harvesting_task_real_run_finish;
	iface->get_cancellable = rygel_media_export_harvesting_task_real_get_cancellable;
	iface->set_cancellable = rygel_media_export_harvesting_task_real_set_cancellable;
}


static void rygel_media_export_harvesting_task_instance_init (RygelMediaExportHarvestingTask * self) {
	self->priv = RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_PRIVATE (self);
}


static void rygel_media_export_harvesting_task_finalize (GObject* obj) {
	RygelMediaExportHarvestingTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask);
	_g_object_unref0 (self->origin);
	_g_object_unref0 (self->priv->extractor);
	_g_object_unref0 (self->priv->cache);
	__g_queue_free__g_object_unref0_0 (self->priv->containers);
	_g_object_unref0 (self->priv->files);
	_g_object_unref0 (self->priv->monitor);
	_g_free0 (self->priv->flag);
	_g_object_unref0 (self->priv->parent);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_media_export_harvesting_task_parent_class)->finalize (obj);
}


GType rygel_media_export_harvesting_task_get_type (void) {
	static volatile gsize rygel_media_export_harvesting_task_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_harvesting_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportHarvestingTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_harvesting_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportHarvestingTask), 0, (GInstanceInitFunc) rygel_media_export_harvesting_task_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_media_export_harvesting_task_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_media_export_harvesting_task_type_id;
		rygel_media_export_harvesting_task_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportHarvestingTask", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_media_export_harvesting_task_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_media_export_harvesting_task_type_id__volatile, rygel_media_export_harvesting_task_type_id);
	}
	return rygel_media_export_harvesting_task_type_id__volatile;
}


static void _vala_rygel_media_export_harvesting_task_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvestingTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_export_harvesting_task_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvestingTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



