/* puzzle-view.c generated by valac 0.18.0.12-9b79c, the Vala compiler
 * generated from puzzle-view.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <librsvg/rsvg.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <stdlib.h>
#include <librsvg/rsvg-cairo.h>
#include <string.h>


#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;
typedef struct _PuzzleViewPrivate PuzzleViewPrivate;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _puzzle_unref0(var) ((var == NULL) ? NULL : (var = (puzzle_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _PuzzlePrivate PuzzlePrivate;

struct _PuzzleView {
	GtkDrawingArea parent_instance;
	PuzzleViewPrivate * priv;
};

struct _PuzzleViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _PuzzleViewPrivate {
	gint render_size;
	gint piece_x;
	gint piece_y;
	gchar piece_id;
	gchar last_piece_id;
	gdouble kx;
	gdouble ky;
	RsvgHandle* tiles_handle;
	gchar* image_filepath;
	cairo_surface_t* surface;
	Puzzle* _puzzle;
};

struct _Puzzle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PuzzlePrivate * priv;
	gint width;
	gint height;
	gchar* map;
	gint map_length1;
	gchar* move_map;
	gint move_map_length1;
	gchar* orig_map;
	gint orig_map_length1;
	gchar* lastmove_map;
	gint lastmove_map_length1;
	gchar* undomove_map;
	gint undomove_map_length1;
	gint moves;
};

struct _PuzzleClass {
	GTypeClass parent_class;
	void (*finalize) (Puzzle *self);
};


static gpointer puzzle_view_parent_class = NULL;

GType puzzle_view_get_type (void) G_GNUC_CONST;
gpointer puzzle_ref (gpointer instance);
void puzzle_unref (gpointer instance);
GParamSpec* param_spec_puzzle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_puzzle (GValue* value, gpointer v_object);
void value_take_puzzle (GValue* value, gpointer v_object);
gpointer value_get_puzzle (const GValue* value);
GType puzzle_get_type (void) G_GNUC_CONST;
#define PUZZLE_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PUZZLE_VIEW, PuzzleViewPrivate))
enum  {
	PUZZLE_VIEW_DUMMY_PROPERTY,
	PUZZLE_VIEW_PUZZLE
};
#define PUZZLE_VIEW_SPACE_OFFSET 4
#define PUZZLE_VIEW_SPACE_PADDING 5
#define PUZZLE_VIEW_THEME_OVERLAY_SIZE 8
#define PUZZLE_VIEW_THEME_TILE_SEGMENTS 27
#define PUZZLE_VIEW_THEME_TILE_CENTER 14
#define PUZZLE_VIEW_THEME_TILE_SIZE 34
PuzzleView* puzzle_view_new (void);
PuzzleView* puzzle_view_construct (GType object_type);
static void puzzle_view_load_image (PuzzleView* self);
static gboolean puzzle_view_real_draw (GtkWidget* base, cairo_t* cr);
static gint puzzle_view_get_tile_size (PuzzleView* self);
Puzzle* puzzle_view_get_puzzle (PuzzleView* self);
static void puzzle_view_draw_square (PuzzleView* self, cairo_t* cr, gint x, gint y, gdouble kx, gdouble ky);
gchar puzzle_get_piece_id (Puzzle* self, gchar* src, int src_length1, gint x, gint y);
gint puzzle_get_piece_nr (Puzzle* self, gint x, gint y);
static gboolean puzzle_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
gboolean puzzle_game_over (Puzzle* self);
static gchar* _vala_array_dup7 (gchar* self, int length);
static gboolean puzzle_view_real_button_release_event (GtkWidget* base, GdkEventButton* event);
gboolean puzzle_movable (Puzzle* self, gint id);
gboolean puzzle_mapcmp (Puzzle* self, gchar* m1, int m1_length1, gchar* m2, int m2_length1);
static gchar* _vala_array_dup8 (gchar* self, int length);
static gchar* _vala_array_dup9 (gchar* self, int length);
static gboolean puzzle_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event);
gboolean puzzle_move_piece (Puzzle* self, gchar id, gint x1, gint y1, gint x2, gint y2);
static void puzzle_view_puzzle_changed_cb (PuzzleView* self);
void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value);
static void _puzzle_view_puzzle_changed_cb_puzzle_changed (Puzzle* _sender, gpointer self);
static void puzzle_view_finalize (GObject* obj);
static void _vala_puzzle_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_puzzle_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


PuzzleView* puzzle_view_construct (GType object_type) {
	PuzzleView * self = NULL;
	self = (PuzzleView*) g_object_new (object_type, NULL);
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_POINTER_MOTION_MASK) | GDK_BUTTON_RELEASE_MASK));
	puzzle_view_load_image (self);
	return self;
}


PuzzleView* puzzle_view_new (void) {
	return puzzle_view_construct (TYPE_PUZZLE_VIEW);
}


static void puzzle_view_load_image (PuzzleView* self) {
	gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_build_filename (DATA_DIRECTORY, "gnome-klotski.svg", NULL, NULL);
	_g_free0 (self->priv->image_filepath);
	self->priv->image_filepath = _tmp0_;
	{
		const gchar* _tmp1_;
		RsvgHandle* _tmp2_;
		RsvgHandle* _tmp3_;
		_tmp1_ = self->priv->image_filepath;
		_tmp2_ = rsvg_handle_new_from_file (_tmp1_, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		_g_object_unref0 (self->priv->tiles_handle);
		self->priv->tiles_handle = _tmp3_;
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		FILE* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s %s\n", "Error in puzzle-view.vala load image:", _tmp6_);
		_tmp7_ = stderr;
		_tmp8_ = self->priv->image_filepath;
		fprintf (_tmp7_, "%s %s\n", "image path:", _tmp8_);
		exit (EXIT_FAILURE);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean puzzle_view_real_draw (GtkWidget* base, cairo_t* cr) {
	PuzzleView * self;
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkStyleContext* _tmp24_ = NULL;
	GtkStyleContext* _tmp25_;
	GtkStyleContext* style;
	GtkStyleContext* _tmp26_;
	GdkRGBA _tmp27_ = {0};
	GdkRGBA fg;
	GtkStyleContext* _tmp28_;
	GdkRGBA _tmp29_ = {0};
	GdkRGBA bg;
	cairo_t* _tmp30_;
	GdkRGBA _tmp31_;
	cairo_t* _tmp32_;
	gint _tmp33_ = 0;
	gint width;
	gint _tmp34_ = 0;
	gint height;
	cairo_t* _tmp35_;
	GdkRGBA _tmp36_;
	cairo_t* _tmp37_;
	Puzzle* _tmp38_;
	Puzzle* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gdouble kwidth;
	Puzzle* _tmp43_;
	Puzzle* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	gdouble kheight;
	gint _tmp48_;
	gdouble _tmp49_;
	gint _tmp50_;
	gdouble _tmp51_;
	cairo_t* _tmp52_;
	gdouble _tmp53_;
	gdouble _tmp54_;
	gdouble _tmp55_;
	gdouble _tmp56_;
	cairo_t* _tmp57_;
	self = (PuzzleView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = puzzle_view_get_tile_size (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->render_size;
	if (_tmp1_ != _tmp2_) {
		RsvgHandle* _tmp3_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp3_ = self->priv->tiles_handle;
		if (_tmp3_ != NULL) {
			gint _tmp4_;
			gint _tmp5_;
			gint height;
			gint _tmp6_;
			gint _tmp7_;
			gint width;
			cairo_t* _tmp8_;
			cairo_surface_t* _tmp9_ = NULL;
			gint _tmp10_;
			gint _tmp11_;
			cairo_surface_t* _tmp12_;
			cairo_surface_t* _tmp13_;
			cairo_t* _tmp14_;
			cairo_t* c;
			gint _tmp15_;
			gdouble sfw;
			gint _tmp16_;
			gdouble sfh;
			cairo_t* _tmp17_;
			gdouble _tmp18_;
			gdouble _tmp19_;
			RsvgHandle* _tmp20_;
			cairo_t* _tmp21_;
			_tmp4_ = puzzle_view_get_tile_size (self);
			_tmp5_ = _tmp4_;
			height = _tmp5_ * 2;
			_tmp6_ = puzzle_view_get_tile_size (self);
			_tmp7_ = _tmp6_;
			width = _tmp7_ * PUZZLE_VIEW_THEME_TILE_SEGMENTS;
			_tmp8_ = cr;
			_tmp9_ = cairo_get_target (_tmp8_);
			_tmp10_ = width;
			_tmp11_ = height;
			_tmp12_ = cairo_surface_create_similar (_tmp9_, CAIRO_CONTENT_COLOR_ALPHA, _tmp10_, _tmp11_);
			_cairo_surface_destroy0 (self->priv->surface);
			self->priv->surface = _tmp12_;
			_tmp13_ = self->priv->surface;
			_tmp14_ = cairo_create (_tmp13_);
			c = _tmp14_;
			_tmp15_ = width;
			sfw = ((gdouble) _tmp15_) / 918;
			_tmp16_ = height;
			sfh = ((gdouble) _tmp16_) / 68;
			_tmp17_ = c;
			_tmp18_ = sfw;
			_tmp19_ = sfh;
			cairo_scale (_tmp17_, _tmp18_, _tmp19_);
			_tmp20_ = self->priv->tiles_handle;
			_tmp21_ = c;
			rsvg_handle_render_cairo (_tmp20_, _tmp21_);
			_cairo_destroy0 (c);
		}
		_tmp22_ = puzzle_view_get_tile_size (self);
		_tmp23_ = _tmp22_;
		self->priv->render_size = _tmp23_;
	}
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp25_ = _g_object_ref0 (_tmp24_);
	style = _tmp25_;
	_tmp26_ = style;
	gtk_style_context_get_color (_tmp26_, GTK_STATE_FLAG_NORMAL, &_tmp27_);
	fg = _tmp27_;
	_tmp28_ = style;
	gtk_style_context_get_background_color (_tmp28_, GTK_STATE_FLAG_NORMAL, &_tmp29_);
	bg = _tmp29_;
	_tmp30_ = cr;
	_tmp31_ = bg;
	gdk_cairo_set_source_rgba (_tmp30_, &_tmp31_);
	_tmp32_ = cr;
	cairo_paint (_tmp32_);
	_tmp33_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	width = _tmp33_;
	_tmp34_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	height = _tmp34_;
	_tmp35_ = cr;
	_tmp36_ = fg;
	gdk_cairo_set_source_rgba (_tmp35_, &_tmp36_);
	_tmp37_ = cr;
	cairo_set_line_width (_tmp37_, 1.0);
	_tmp38_ = puzzle_view_get_puzzle (self);
	_tmp39_ = _tmp38_;
	_tmp40_ = _tmp39_->width;
	_tmp41_ = puzzle_view_get_tile_size (self);
	_tmp42_ = _tmp41_;
	kwidth = ((_tmp40_ * _tmp42_) + PUZZLE_VIEW_SPACE_PADDING) - 2.0;
	_tmp43_ = puzzle_view_get_puzzle (self);
	_tmp44_ = _tmp43_;
	_tmp45_ = _tmp44_->height;
	_tmp46_ = puzzle_view_get_tile_size (self);
	_tmp47_ = _tmp46_;
	kheight = ((_tmp45_ * _tmp47_) + PUZZLE_VIEW_SPACE_PADDING) - 2.0;
	_tmp48_ = width;
	_tmp49_ = kwidth;
	self->priv->kx = (_tmp48_ - _tmp49_) / 2.0;
	_tmp50_ = height;
	_tmp51_ = kheight;
	self->priv->ky = (_tmp50_ - _tmp51_) / 2.0;
	_tmp52_ = cr;
	_tmp53_ = self->priv->kx;
	_tmp54_ = self->priv->ky;
	_tmp55_ = kwidth;
	_tmp56_ = kheight;
	cairo_rectangle (_tmp52_, _tmp53_, _tmp54_, _tmp55_, _tmp56_);
	_tmp57_ = cr;
	cairo_stroke (_tmp57_);
	{
		gint y;
		y = 0;
		{
			gboolean _tmp58_;
			_tmp58_ = TRUE;
			while (TRUE) {
				gboolean _tmp59_;
				gint _tmp61_;
				Puzzle* _tmp62_;
				Puzzle* _tmp63_;
				gint _tmp64_;
				_tmp59_ = _tmp58_;
				if (!_tmp59_) {
					gint _tmp60_;
					_tmp60_ = y;
					y = _tmp60_ + 1;
				}
				_tmp58_ = FALSE;
				_tmp61_ = y;
				_tmp62_ = puzzle_view_get_puzzle (self);
				_tmp63_ = _tmp62_;
				_tmp64_ = _tmp63_->height;
				if (!(_tmp61_ < _tmp64_)) {
					break;
				}
				{
					gint x;
					x = 0;
					{
						gboolean _tmp65_;
						_tmp65_ = TRUE;
						while (TRUE) {
							gboolean _tmp66_;
							gint _tmp68_;
							Puzzle* _tmp69_;
							Puzzle* _tmp70_;
							gint _tmp71_;
							cairo_t* _tmp72_;
							gint _tmp73_;
							gint _tmp74_;
							gdouble _tmp75_;
							gdouble _tmp76_;
							_tmp66_ = _tmp65_;
							if (!_tmp66_) {
								gint _tmp67_;
								_tmp67_ = x;
								x = _tmp67_ + 1;
							}
							_tmp65_ = FALSE;
							_tmp68_ = x;
							_tmp69_ = puzzle_view_get_puzzle (self);
							_tmp70_ = _tmp69_;
							_tmp71_ = _tmp70_->width;
							if (!(_tmp68_ < _tmp71_)) {
								break;
							}
							_tmp72_ = cr;
							_tmp73_ = x;
							_tmp74_ = y;
							_tmp75_ = self->priv->kx;
							_tmp76_ = self->priv->ky;
							puzzle_view_draw_square (self, _tmp72_, _tmp73_, _tmp74_, _tmp75_, _tmp76_);
						}
					}
				}
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (style);
	return result;
}


static void puzzle_view_draw_square (PuzzleView* self, cairo_t* cr, gint x, gint y, gdouble kx, gdouble ky) {
	GdkRectangle rect = {0};
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gdouble _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gdouble _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GtkStyleContext* _tmp12_ = NULL;
	GtkStyleContext* _tmp13_;
	GtkStyleContext* style;
	GtkStyleContext* _tmp14_;
	GdkRGBA _tmp15_ = {0};
	GdkRGBA bg;
	cairo_t* _tmp16_;
	GdkRectangle _tmp17_;
	cairo_t* _tmp18_;
	GdkRGBA _tmp19_;
	cairo_t* _tmp20_;
	Puzzle* _tmp21_;
	Puzzle* _tmp22_;
	Puzzle* _tmp23_;
	Puzzle* _tmp24_;
	gchar* _tmp25_;
	gint _tmp25__length1;
	gint _tmp26_;
	gint _tmp27_;
	gchar _tmp28_ = '\0';
	Puzzle* _tmp47_;
	Puzzle* _tmp48_;
	Puzzle* _tmp49_;
	Puzzle* _tmp50_;
	gchar* _tmp51_;
	gint _tmp51__length1;
	gint _tmp52_;
	gint _tmp53_;
	gchar _tmp54_ = '\0';
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	memset (&rect, 0, sizeof (GdkRectangle));
	_tmp0_ = x;
	_tmp1_ = puzzle_view_get_tile_size (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = kx;
	rect.x = (((_tmp0_ * _tmp2_) + PUZZLE_VIEW_SPACE_OFFSET) + ((gint) _tmp3_)) - 1;
	_tmp4_ = y;
	_tmp5_ = puzzle_view_get_tile_size (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = ky;
	rect.y = (((_tmp4_ * _tmp6_) + PUZZLE_VIEW_SPACE_OFFSET) + ((gint) _tmp7_)) - 1;
	_tmp8_ = puzzle_view_get_tile_size (self);
	_tmp9_ = _tmp8_;
	rect.width = _tmp9_;
	_tmp10_ = puzzle_view_get_tile_size (self);
	_tmp11_ = _tmp10_;
	rect.height = _tmp11_;
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	style = _tmp13_;
	_tmp14_ = style;
	gtk_style_context_get_background_color (_tmp14_, GTK_STATE_FLAG_NORMAL, &_tmp15_);
	bg = _tmp15_;
	_tmp16_ = cr;
	_tmp17_ = rect;
	gdk_cairo_rectangle (_tmp16_, &_tmp17_);
	_tmp18_ = cr;
	_tmp19_ = bg;
	gdk_cairo_set_source_rgba (_tmp18_, &_tmp19_);
	_tmp20_ = cr;
	cairo_fill (_tmp20_);
	_tmp21_ = puzzle_view_get_puzzle (self);
	_tmp22_ = _tmp21_;
	_tmp23_ = puzzle_view_get_puzzle (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp24_->map;
	_tmp25__length1 = _tmp24_->map_length1;
	_tmp26_ = x;
	_tmp27_ = y;
	_tmp28_ = puzzle_get_piece_id (_tmp22_, _tmp25_, _tmp25__length1, _tmp26_, _tmp27_);
	if (_tmp28_ != ' ') {
		cairo_t* _tmp29_;
		GdkRectangle _tmp30_;
		cairo_t* _tmp31_;
		cairo_surface_t* _tmp32_;
		GdkRectangle _tmp33_;
		gint _tmp34_;
		Puzzle* _tmp35_;
		Puzzle* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_ = 0;
		gint _tmp40_;
		gint _tmp41_;
		GdkRectangle _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		cairo_t* _tmp46_;
		_tmp29_ = cr;
		_tmp30_ = rect;
		gdk_cairo_rectangle (_tmp29_, &_tmp30_);
		_tmp31_ = cr;
		_tmp32_ = self->priv->surface;
		_tmp33_ = rect;
		_tmp34_ = _tmp33_.x;
		_tmp35_ = puzzle_view_get_puzzle (self);
		_tmp36_ = _tmp35_;
		_tmp37_ = x;
		_tmp38_ = y;
		_tmp39_ = puzzle_get_piece_nr (_tmp36_, _tmp37_, _tmp38_);
		_tmp40_ = puzzle_view_get_tile_size (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = rect;
		_tmp43_ = _tmp42_.y;
		_tmp44_ = puzzle_view_get_tile_size (self);
		_tmp45_ = _tmp44_;
		cairo_set_source_surface (_tmp31_, _tmp32_, (gdouble) (_tmp34_ - (_tmp39_ * _tmp41_)), (gdouble) (_tmp43_ - (_tmp45_ / 2)));
		_tmp46_ = cr;
		cairo_fill (_tmp46_);
	}
	_tmp47_ = puzzle_view_get_puzzle (self);
	_tmp48_ = _tmp47_;
	_tmp49_ = puzzle_view_get_puzzle (self);
	_tmp50_ = _tmp49_;
	_tmp51_ = _tmp50_->map;
	_tmp51__length1 = _tmp50_->map_length1;
	_tmp52_ = x;
	_tmp53_ = y;
	_tmp54_ = puzzle_get_piece_id (_tmp48_, _tmp51_, _tmp51__length1, _tmp52_, _tmp53_);
	if (_tmp54_ == '*') {
		gint value;
		Puzzle* _tmp55_;
		Puzzle* _tmp56_;
		Puzzle* _tmp57_;
		Puzzle* _tmp58_;
		gchar* _tmp59_;
		gint _tmp59__length1;
		gint _tmp60_;
		gint _tmp61_;
		gchar _tmp62_ = '\0';
		gint _tmp63_;
		gint _tmp64_;
		gint overlay_size;
		gint _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		gint overlay_offset;
		cairo_t* _tmp68_;
		GdkRectangle _tmp69_;
		gint _tmp70_;
		gint _tmp71_;
		GdkRectangle _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		gint _tmp75_;
		gint _tmp76_;
		cairo_t* _tmp77_;
		cairo_surface_t* _tmp78_;
		GdkRectangle _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _tmp82_;
		gint _tmp83_;
		GdkRectangle _tmp84_;
		gint _tmp85_;
		gint _tmp86_;
		gint _tmp87_;
		cairo_t* _tmp88_;
		value = 22;
		_tmp55_ = puzzle_view_get_puzzle (self);
		_tmp56_ = _tmp55_;
		_tmp57_ = puzzle_view_get_puzzle (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = _tmp58_->orig_map;
		_tmp59__length1 = _tmp58_->orig_map_length1;
		_tmp60_ = x;
		_tmp61_ = y;
		_tmp62_ = puzzle_get_piece_id (_tmp56_, _tmp59_, _tmp59__length1, _tmp60_, _tmp61_);
		if (_tmp62_ == '.') {
			value = 20;
		}
		_tmp63_ = puzzle_view_get_tile_size (self);
		_tmp64_ = _tmp63_;
		overlay_size = (PUZZLE_VIEW_THEME_OVERLAY_SIZE * _tmp64_) / PUZZLE_VIEW_THEME_TILE_SIZE;
		_tmp65_ = puzzle_view_get_tile_size (self);
		_tmp66_ = _tmp65_;
		_tmp67_ = overlay_size;
		overlay_offset = ((PUZZLE_VIEW_THEME_TILE_CENTER * _tmp66_) / PUZZLE_VIEW_THEME_TILE_SIZE) - (_tmp67_ / 2);
		_tmp68_ = cr;
		_tmp69_ = rect;
		_tmp70_ = _tmp69_.x;
		_tmp71_ = overlay_offset;
		_tmp72_ = rect;
		_tmp73_ = _tmp72_.y;
		_tmp74_ = overlay_offset;
		_tmp75_ = overlay_size;
		_tmp76_ = overlay_size;
		cairo_rectangle (_tmp68_, (gdouble) (_tmp70_ + _tmp71_), (gdouble) (_tmp73_ + _tmp74_), (gdouble) _tmp75_, (gdouble) _tmp76_);
		_tmp77_ = cr;
		_tmp78_ = self->priv->surface;
		_tmp79_ = rect;
		_tmp80_ = _tmp79_.x;
		_tmp81_ = value;
		_tmp82_ = puzzle_view_get_tile_size (self);
		_tmp83_ = _tmp82_;
		_tmp84_ = rect;
		_tmp85_ = _tmp84_.y;
		_tmp86_ = puzzle_view_get_tile_size (self);
		_tmp87_ = _tmp86_;
		cairo_set_source_surface (_tmp77_, _tmp78_, (gdouble) (_tmp80_ - (_tmp81_ * _tmp83_)), (gdouble) (_tmp85_ - (_tmp87_ / 2)));
		_tmp88_ = cr;
		cairo_fill (_tmp88_);
	}
	_g_object_unref0 (style);
}


static gchar* _vala_array_dup7 (gchar* self, int length) {
	return g_memdup (self, length * sizeof (gchar));
}


static gboolean puzzle_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	GdkEventButton _tmp0_;
	guint _tmp1_;
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.button;
	if (_tmp1_ == ((guint) 1)) {
		Puzzle* _tmp2_;
		Puzzle* _tmp3_;
		gboolean _tmp4_ = FALSE;
		GdkEventButton _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		GdkEventButton _tmp10_;
		gdouble _tmp11_;
		gdouble _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		Puzzle* _tmp15_;
		Puzzle* _tmp16_;
		Puzzle* _tmp17_;
		Puzzle* _tmp18_;
		gchar* _tmp19_;
		gint _tmp19__length1;
		gint _tmp20_;
		gint _tmp21_;
		gchar _tmp22_ = '\0';
		Puzzle* _tmp23_;
		Puzzle* _tmp24_;
		Puzzle* _tmp25_;
		Puzzle* _tmp26_;
		gchar* _tmp27_;
		gint _tmp27__length1;
		gchar* _tmp28_;
		gint _tmp28__length1;
		_tmp2_ = puzzle_view_get_puzzle (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = puzzle_game_over (_tmp3_);
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
		_tmp5_ = *event;
		_tmp6_ = _tmp5_.x;
		_tmp7_ = self->priv->kx;
		_tmp8_ = puzzle_view_get_tile_size (self);
		_tmp9_ = _tmp8_;
		self->priv->piece_x = ((gint) (_tmp6_ - _tmp7_)) / _tmp9_;
		_tmp10_ = *event;
		_tmp11_ = _tmp10_.y;
		_tmp12_ = self->priv->ky;
		_tmp13_ = puzzle_view_get_tile_size (self);
		_tmp14_ = _tmp13_;
		self->priv->piece_y = ((gint) (_tmp11_ - _tmp12_)) / _tmp14_;
		_tmp15_ = puzzle_view_get_puzzle (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = puzzle_view_get_puzzle (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_->map;
		_tmp19__length1 = _tmp18_->map_length1;
		_tmp20_ = self->priv->piece_x;
		_tmp21_ = self->priv->piece_y;
		_tmp22_ = puzzle_get_piece_id (_tmp16_, _tmp19_, _tmp19__length1, _tmp20_, _tmp21_);
		self->priv->piece_id = _tmp22_;
		_tmp23_ = puzzle_view_get_puzzle (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = puzzle_view_get_puzzle (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_->map;
		_tmp27__length1 = _tmp26_->map_length1;
		_tmp28_ = (_tmp27_ != NULL) ? _vala_array_dup7 (_tmp27_, _tmp27__length1) : ((gpointer) _tmp27_);
		_tmp28__length1 = _tmp27__length1;
		_tmp24_->move_map = (g_free (_tmp24_->move_map), NULL);
		_tmp24_->move_map = _tmp28_;
		_tmp24_->move_map_length1 = _tmp28__length1;
	}
	result = FALSE;
	return result;
}


static gchar* _vala_array_dup8 (gchar* self, int length) {
	return g_memdup (self, length * sizeof (gchar));
}


static gchar* _vala_array_dup9 (gchar* self, int length) {
	return g_memdup (self, length * sizeof (gchar));
}


static gboolean puzzle_view_real_button_release_event (GtkWidget* base, GdkEventButton* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton _tmp1_;
	guint _tmp2_;
	gboolean _tmp4_;
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.button;
	if (_tmp2_ == ((guint) 1)) {
		gchar _tmp3_;
		_tmp3_ = self->priv->piece_id;
		_tmp0_ = _tmp3_ != '\0';
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		Puzzle* _tmp6_;
		Puzzle* _tmp7_;
		gchar _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp19_;
		_tmp6_ = puzzle_view_get_puzzle (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->piece_id;
		_tmp9_ = puzzle_movable (_tmp7_, (gint) _tmp8_);
		if (_tmp9_) {
			Puzzle* _tmp10_;
			Puzzle* _tmp11_;
			Puzzle* _tmp12_;
			Puzzle* _tmp13_;
			gchar* _tmp14_;
			gint _tmp14__length1;
			Puzzle* _tmp15_;
			Puzzle* _tmp16_;
			gchar* _tmp17_;
			gint _tmp17__length1;
			gboolean _tmp18_ = FALSE;
			_tmp10_ = puzzle_view_get_puzzle (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = puzzle_view_get_puzzle (self);
			_tmp13_ = _tmp12_;
			_tmp14_ = _tmp13_->move_map;
			_tmp14__length1 = _tmp13_->move_map_length1;
			_tmp15_ = puzzle_view_get_puzzle (self);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_->map;
			_tmp17__length1 = _tmp16_->map_length1;
			_tmp18_ = puzzle_mapcmp (_tmp11_, _tmp14_, _tmp14__length1, _tmp17_, _tmp17__length1);
			_tmp5_ = _tmp18_;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp19_ = _tmp5_;
		if (_tmp19_) {
			gboolean _tmp20_ = FALSE;
			gchar _tmp21_;
			gboolean _tmp24_;
			gboolean _tmp37_ = FALSE;
			Puzzle* _tmp38_;
			Puzzle* _tmp39_;
			gint _tmp40_;
			gboolean _tmp50_;
			Puzzle* _tmp55_;
			Puzzle* _tmp56_;
			Puzzle* _tmp57_;
			Puzzle* _tmp58_;
			gchar* _tmp59_;
			gint _tmp59__length1;
			gchar* _tmp60_;
			gint _tmp60__length1;
			Puzzle* _tmp61_;
			Puzzle* _tmp62_;
			_tmp21_ = self->priv->last_piece_id;
			if (_tmp21_ == '\0') {
				_tmp20_ = TRUE;
			} else {
				gchar _tmp22_;
				gchar _tmp23_;
				_tmp22_ = self->priv->last_piece_id;
				_tmp23_ = self->priv->piece_id;
				_tmp20_ = _tmp22_ != _tmp23_;
			}
			_tmp24_ = _tmp20_;
			if (_tmp24_) {
				Puzzle* _tmp25_;
				Puzzle* _tmp26_;
				Puzzle* _tmp27_;
				Puzzle* _tmp28_;
				gchar* _tmp29_;
				gint _tmp29__length1;
				gchar* _tmp30_;
				gint _tmp30__length1;
				Puzzle* _tmp31_;
				Puzzle* _tmp32_;
				gint _tmp33_;
				_tmp25_ = puzzle_view_get_puzzle (self);
				_tmp26_ = _tmp25_;
				_tmp27_ = puzzle_view_get_puzzle (self);
				_tmp28_ = _tmp27_;
				_tmp29_ = _tmp28_->lastmove_map;
				_tmp29__length1 = _tmp28_->lastmove_map_length1;
				_tmp30_ = (_tmp29_ != NULL) ? _vala_array_dup8 (_tmp29_, _tmp29__length1) : ((gpointer) _tmp29_);
				_tmp30__length1 = _tmp29__length1;
				_tmp26_->undomove_map = (g_free (_tmp26_->undomove_map), NULL);
				_tmp26_->undomove_map = _tmp30_;
				_tmp26_->undomove_map_length1 = _tmp30__length1;
				_tmp31_ = puzzle_view_get_puzzle (self);
				_tmp32_ = _tmp31_;
				_tmp33_ = _tmp32_->moves;
				if (_tmp33_ < 999) {
					Puzzle* _tmp34_;
					Puzzle* _tmp35_;
					gint _tmp36_;
					_tmp34_ = puzzle_view_get_puzzle (self);
					_tmp35_ = _tmp34_;
					_tmp36_ = _tmp35_->moves;
					_tmp35_->moves = _tmp36_ + 1;
				}
			}
			_tmp38_ = puzzle_view_get_puzzle (self);
			_tmp39_ = _tmp38_;
			_tmp40_ = _tmp39_->moves;
			if (_tmp40_ > 0) {
				Puzzle* _tmp41_;
				Puzzle* _tmp42_;
				Puzzle* _tmp43_;
				Puzzle* _tmp44_;
				gchar* _tmp45_;
				gint _tmp45__length1;
				Puzzle* _tmp46_;
				Puzzle* _tmp47_;
				gchar* _tmp48_;
				gint _tmp48__length1;
				gboolean _tmp49_ = FALSE;
				_tmp41_ = puzzle_view_get_puzzle (self);
				_tmp42_ = _tmp41_;
				_tmp43_ = puzzle_view_get_puzzle (self);
				_tmp44_ = _tmp43_;
				_tmp45_ = _tmp44_->undomove_map;
				_tmp45__length1 = _tmp44_->undomove_map_length1;
				_tmp46_ = puzzle_view_get_puzzle (self);
				_tmp47_ = _tmp46_;
				_tmp48_ = _tmp47_->map;
				_tmp48__length1 = _tmp47_->map_length1;
				_tmp49_ = puzzle_mapcmp (_tmp42_, _tmp45_, _tmp45__length1, _tmp48_, _tmp48__length1);
				_tmp37_ = !_tmp49_;
			} else {
				_tmp37_ = FALSE;
			}
			_tmp50_ = _tmp37_;
			if (_tmp50_) {
				Puzzle* _tmp51_;
				Puzzle* _tmp52_;
				gint _tmp53_;
				_tmp51_ = puzzle_view_get_puzzle (self);
				_tmp52_ = _tmp51_;
				_tmp53_ = _tmp52_->moves;
				_tmp52_->moves = _tmp53_ - 1;
				self->priv->last_piece_id = '\0';
			} else {
				gchar _tmp54_;
				_tmp54_ = self->priv->piece_id;
				self->priv->last_piece_id = _tmp54_;
			}
			_tmp55_ = puzzle_view_get_puzzle (self);
			_tmp56_ = _tmp55_;
			_tmp57_ = puzzle_view_get_puzzle (self);
			_tmp58_ = _tmp57_;
			_tmp59_ = _tmp58_->map;
			_tmp59__length1 = _tmp58_->map_length1;
			_tmp60_ = (_tmp59_ != NULL) ? _vala_array_dup9 (_tmp59_, _tmp59__length1) : ((gpointer) _tmp59_);
			_tmp60__length1 = _tmp59__length1;
			_tmp56_->lastmove_map = (g_free (_tmp56_->lastmove_map), NULL);
			_tmp56_->lastmove_map = _tmp60_;
			_tmp56_->lastmove_map_length1 = _tmp60__length1;
			_tmp61_ = puzzle_view_get_puzzle (self);
			_tmp62_ = _tmp61_;
			g_signal_emit_by_name (_tmp62_, "moved");
		}
		self->priv->piece_id = '\0';
	}
	result = FALSE;
	return result;
}


static gboolean puzzle_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	gint new_piece_x = 0;
	gint new_piece_y = 0;
	gchar _tmp0_;
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->piece_id;
	if (_tmp0_ != '\0') {
		GdkEventMotion _tmp1_;
		gdouble _tmp2_;
		gdouble _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		GdkEventMotion _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gint _tmp14_;
		Puzzle* _tmp15_;
		Puzzle* _tmp16_;
		gint _tmp17_;
		gboolean _tmp20_;
		gboolean _tmp25_;
		gboolean _tmp28_;
		Puzzle* _tmp29_;
		Puzzle* _tmp30_;
		gchar _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gboolean _tmp36_ = FALSE;
		_tmp1_ = *event;
		_tmp2_ = _tmp1_.x;
		_tmp3_ = self->priv->kx;
		_tmp4_ = puzzle_view_get_tile_size (self);
		_tmp5_ = _tmp4_;
		new_piece_x = ((gint) (_tmp2_ - _tmp3_)) / _tmp5_;
		_tmp6_ = *event;
		_tmp7_ = _tmp6_.y;
		_tmp8_ = self->priv->ky;
		_tmp9_ = puzzle_view_get_tile_size (self);
		_tmp10_ = _tmp9_;
		new_piece_y = ((gint) (_tmp7_ - _tmp8_)) / _tmp10_;
		_tmp14_ = new_piece_x;
		_tmp15_ = puzzle_view_get_puzzle (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_->width;
		if (_tmp14_ >= _tmp17_) {
			_tmp13_ = TRUE;
		} else {
			GdkEventMotion _tmp18_;
			gdouble _tmp19_;
			_tmp18_ = *event;
			_tmp19_ = _tmp18_.x;
			_tmp13_ = _tmp19_ < ((gdouble) 0);
		}
		_tmp20_ = _tmp13_;
		if (_tmp20_) {
			_tmp12_ = TRUE;
		} else {
			gint _tmp21_;
			Puzzle* _tmp22_;
			Puzzle* _tmp23_;
			gint _tmp24_;
			_tmp21_ = new_piece_y;
			_tmp22_ = puzzle_view_get_puzzle (self);
			_tmp23_ = _tmp22_;
			_tmp24_ = _tmp23_->height;
			_tmp12_ = _tmp21_ >= _tmp24_;
		}
		_tmp25_ = _tmp12_;
		if (_tmp25_) {
			_tmp11_ = TRUE;
		} else {
			GdkEventMotion _tmp26_;
			gdouble _tmp27_;
			_tmp26_ = *event;
			_tmp27_ = _tmp26_.y;
			_tmp11_ = _tmp27_ < ((gdouble) 0);
		}
		_tmp28_ = _tmp11_;
		if (_tmp28_) {
			result = FALSE;
			return result;
		}
		_tmp29_ = puzzle_view_get_puzzle (self);
		_tmp30_ = _tmp29_;
		_tmp31_ = self->priv->piece_id;
		_tmp32_ = self->priv->piece_x;
		_tmp33_ = self->priv->piece_y;
		_tmp34_ = new_piece_x;
		_tmp35_ = new_piece_y;
		_tmp36_ = puzzle_move_piece (_tmp30_, _tmp31_, _tmp32_, _tmp33_, _tmp34_, _tmp35_);
		if (_tmp36_) {
			gint _tmp37_;
			gint _tmp38_;
			_tmp37_ = new_piece_x;
			self->priv->piece_x = _tmp37_;
			_tmp38_ = new_piece_y;
			self->priv->piece_y = _tmp38_;
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void puzzle_view_puzzle_changed_cb (PuzzleView* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
}


Puzzle* puzzle_view_get_puzzle (PuzzleView* self) {
	Puzzle* result;
	Puzzle* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_puzzle;
	result = _tmp0_;
	return result;
}


static gpointer _puzzle_ref0 (gpointer self) {
	return self ? puzzle_ref (self) : NULL;
}


static void _puzzle_view_puzzle_changed_cb_puzzle_changed (Puzzle* _sender, gpointer self) {
	puzzle_view_puzzle_changed_cb (self);
}


void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value) {
	Puzzle* _tmp0_;
	Puzzle* _tmp2_;
	Puzzle* _tmp3_;
	Puzzle* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_puzzle;
	if (_tmp0_ != NULL) {
		Puzzle* _tmp1_;
		_tmp1_ = self->priv->_puzzle;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = value;
	_tmp3_ = _puzzle_ref0 (_tmp2_);
	_puzzle_unref0 (self->priv->_puzzle);
	self->priv->_puzzle = _tmp3_;
	_tmp4_ = self->priv->_puzzle;
	g_signal_connect_object (_tmp4_, "changed", (GCallback) _puzzle_view_puzzle_changed_cb_puzzle_changed, self, 0);
	self->priv->piece_x = 0;
	self->priv->piece_y = 0;
	self->priv->piece_id = '\0';
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "puzzle");
}


static gint puzzle_view_get_tile_size (PuzzleView* self) {
	gint result;
	gint _tmp0_ = 0;
	Puzzle* _tmp1_;
	Puzzle* _tmp2_;
	gint _tmp3_;
	gint _tmp4_ = 0;
	Puzzle* _tmp5_;
	Puzzle* _tmp6_;
	gint _tmp7_;
	gint _tmp8_ = 0;
	gint s;
	gint _tmp9_;
	gint _tmp11_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = puzzle_view_get_puzzle (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->width;
	_tmp4_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp5_ = puzzle_view_get_puzzle (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->height;
	_tmp8_ = MIN ((_tmp0_ - PUZZLE_VIEW_SPACE_PADDING) / _tmp3_, (_tmp4_ - PUZZLE_VIEW_SPACE_PADDING) / _tmp7_);
	s = _tmp8_;
	_tmp9_ = s;
	if ((_tmp9_ % 2) != 0) {
		gint _tmp10_;
		_tmp10_ = s;
		s = _tmp10_ - 1;
	}
	_tmp11_ = s;
	result = _tmp11_;
	return result;
}


static void puzzle_view_class_init (PuzzleViewClass * klass) {
	puzzle_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PuzzleViewPrivate));
	GTK_WIDGET_CLASS (klass)->draw = puzzle_view_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = puzzle_view_real_button_press_event;
	GTK_WIDGET_CLASS (klass)->button_release_event = puzzle_view_real_button_release_event;
	GTK_WIDGET_CLASS (klass)->motion_notify_event = puzzle_view_real_motion_notify_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_puzzle_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_puzzle_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = puzzle_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_PUZZLE, param_spec_puzzle ("puzzle", "puzzle", "puzzle", TYPE_PUZZLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void puzzle_view_instance_init (PuzzleView * self) {
	gchar* _tmp0_;
	self->priv = PUZZLE_VIEW_GET_PRIVATE (self);
	self->priv->render_size = 0;
	self->priv->piece_x = 0;
	self->priv->piece_y = 0;
	self->priv->piece_id = '\0';
	self->priv->last_piece_id = '\0';
	self->priv->kx = (gdouble) 0;
	self->priv->ky = (gdouble) 0;
	self->priv->tiles_handle = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->image_filepath = _tmp0_;
	self->priv->surface = NULL;
	self->priv->_puzzle = NULL;
}


static void puzzle_view_finalize (GObject* obj) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE_VIEW, PuzzleView);
	_g_object_unref0 (self->priv->tiles_handle);
	_g_free0 (self->priv->image_filepath);
	_cairo_surface_destroy0 (self->priv->surface);
	_puzzle_unref0 (self->priv->_puzzle);
	G_OBJECT_CLASS (puzzle_view_parent_class)->finalize (obj);
}


GType puzzle_view_get_type (void) {
	static volatile gsize puzzle_view_type_id__volatile = 0;
	if (g_once_init_enter (&puzzle_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PuzzleViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PuzzleView), 0, (GInstanceInitFunc) puzzle_view_instance_init, NULL };
		GType puzzle_view_type_id;
		puzzle_view_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "PuzzleView", &g_define_type_info, 0);
		g_once_init_leave (&puzzle_view_type_id__volatile, puzzle_view_type_id);
	}
	return puzzle_view_type_id__volatile;
}


static void _vala_puzzle_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
	switch (property_id) {
		case PUZZLE_VIEW_PUZZLE:
		value_set_puzzle (value, puzzle_view_get_puzzle (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_puzzle_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
	switch (property_id) {
		case PUZZLE_VIEW_PUZZLE:
		puzzle_view_set_puzzle (self, value_get_puzzle (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



