/* report.c generated by valac 0.11.6, the Vala compiler
 * generated from report.vala, do not modify */

/*
 * Copyright (C) 2008-2009 Abderrahim Kitouni
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* A Vala.Report subclass for reporting errors in Anjuta UI */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <libanjuta/interfaces/libanjuta-interfaces.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>


#define TYPE_ANJUTA_REPORT (anjuta_report_get_type ())
#define ANJUTA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANJUTA_REPORT, AnjutaReport))
#define ANJUTA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANJUTA_REPORT, AnjutaReportClass))
#define IS_ANJUTA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANJUTA_REPORT))
#define IS_ANJUTA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANJUTA_REPORT))
#define ANJUTA_REPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANJUTA_REPORT, AnjutaReportClass))

typedef struct _AnjutaReport AnjutaReport;
typedef struct _AnjutaReportClass AnjutaReportClass;
typedef struct _AnjutaReportPrivate AnjutaReportPrivate;

#define ANJUTA_REPORT_TYPE_ERROR (anjuta_report_error_get_type ())
typedef struct _AnjutaReportError AnjutaReportError;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _anjuta_report_error_free0(var) ((var == NULL) ? NULL : (var = (anjuta_report_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _AnjutaReport {
	ValaReport parent_instance;
	AnjutaReportPrivate * priv;
};

struct _AnjutaReportClass {
	ValaReportClass parent_class;
};

struct _AnjutaReportError {
	ValaSourceReference* source;
	gboolean error;
	gchar* message;
};

struct _AnjutaReportPrivate {
	IAnjutaDocumentManager* _docman;
	ValaList* errors;
	GStaticRecMutex __lock_errors;
};


static gpointer anjuta_report_parent_class = NULL;
static GType anjuta_report_type_id = 0;

GType anjuta_report_get_type (void) G_GNUC_CONST;
GType anjuta_report_register_type (GTypeModule * module);
static GType anjuta_report_error_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static AnjutaReportError* anjuta_report_error_dup (const AnjutaReportError* self);
static void anjuta_report_error_free (AnjutaReportError* self);
static void anjuta_report_error_copy (const AnjutaReportError* self, AnjutaReportError* dest);
static void anjuta_report_error_destroy (AnjutaReportError* self);
#define ANJUTA_REPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ANJUTA_REPORT, AnjutaReportPrivate))
enum  {
	ANJUTA_REPORT_DUMMY_PROPERTY,
	ANJUTA_REPORT_DOCMAN
};
void anjuta_report_update_errors (AnjutaReport* self, IAnjutaEditor* editor);
void anjuta_report_clear_error_indicators (AnjutaReport* self);
IAnjutaDocumentManager* anjuta_report_get_docman (AnjutaReport* self);
static void anjuta_report_real_warn (ValaReport* base, ValaSourceReference* source, const gchar* message);
static void anjuta_report_real_err (ValaReport* base, ValaSourceReference* source, const gchar* message);
gboolean anjuta_report_errors_found (AnjutaReport* self);
AnjutaReport* anjuta_report_new (void);
AnjutaReport* anjuta_report_construct (GType object_type);
void anjuta_report_set_docman (AnjutaReport* self, IAnjutaDocumentManager* value);
static void anjuta_report_finalize (GObject* obj);
static void _vala_anjuta_report_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_anjuta_report_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


void anjuta_report_update_errors (AnjutaReport* self, IAnjutaEditor* editor) {
	IAnjutaEditor* _tmp0_;
	IAnjutaIndicable* _tmp1_;
	IAnjutaIndicable* ind;
	IAnjutaEditor* _tmp2_;
	IAnjutaMarkable* _tmp3_;
	IAnjutaMarkable* mark;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editor != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = editor, IANJUTA_IS_INDICABLE (_tmp0_) ? ((IAnjutaIndicable*) _tmp0_) : NULL));
	ind = _tmp1_;
	_tmp3_ = _g_object_ref0 ((_tmp2_ = editor, IANJUTA_IS_MARKABLE (_tmp2_) ? ((IAnjutaMarkable*) _tmp2_) : NULL));
	mark = _tmp3_;
	if (ind == NULL) {
		_tmp4_ = mark == NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_g_object_unref0 (mark);
		_g_object_unref0 (ind);
		return;
	}
	if (ind != NULL) {
		ianjuta_indicable_clear (ind, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (mark);
			_g_object_unref0 (ind);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (mark != NULL) {
		ianjuta_markable_delete_all_markers (mark, IANJUTA_MARKABLE_MESSAGE, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (mark);
			_g_object_unref0 (ind);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		ValaList* _tmp5_;
		ValaList* _e_list;
		gint _tmp6_;
		gint _e_size;
		gint _e_index;
		_tmp5_ = _vala_iterable_ref0 (self->priv->errors);
		_e_list = _tmp5_;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _e_list);
		_e_size = _tmp6_;
		_e_index = -1;
		while (TRUE) {
			gpointer _tmp7_ = NULL;
			AnjutaReportError* e;
			const gchar* _tmp8_ = NULL;
			const gchar* _tmp9_;
			ValaSourceFile* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			gboolean _tmp12_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp7_ = vala_list_get (_e_list, _e_index);
			e = (AnjutaReportError*) _tmp7_;
			_tmp8_ = ianjuta_document_get_filename (IANJUTA_DOCUMENT (editor), &_inner_error_);
			_tmp9_ = _tmp8_;
			if (_inner_error_ != NULL) {
				_anjuta_report_error_free0 (e);
				_vala_iterable_unref0 (_e_list);
				_g_object_unref0 (mark);
				_g_object_unref0 (ind);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp10_ = vala_source_reference_get_file ((*e).source);
			_tmp11_ = vala_source_file_get_filename (_tmp10_);
			_tmp12_ = g_str_has_suffix (_tmp11_, _tmp9_);
			if (_tmp12_) {
				if (ind != NULL) {
					gint _tmp13_;
					IAnjutaIterable* _tmp14_ = NULL;
					IAnjutaIterable* begin_iter;
					gint _tmp17_;
					IAnjutaIterable* _tmp18_ = NULL;
					IAnjutaIterable* end_iter;
					IAnjutaIndicableIndicator _tmp21_ = 0;
					_tmp13_ = vala_source_reference_get_first_line ((*e).source);
					_tmp14_ = ianjuta_editor_get_line_begin_position (editor, _tmp13_, &_inner_error_);
					begin_iter = _tmp14_;
					if (_inner_error_ != NULL) {
						_anjuta_report_error_free0 (e);
						_vala_iterable_unref0 (_e_list);
						_g_object_unref0 (mark);
						_g_object_unref0 (ind);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					{
						gint i;
						i = 1;
						{
							gboolean _tmp15_;
							_tmp15_ = TRUE;
							while (TRUE) {
								gint _tmp16_;
								if (!_tmp15_) {
									i++;
								}
								_tmp15_ = FALSE;
								_tmp16_ = vala_source_reference_get_first_column ((*e).source);
								if (!(i < _tmp16_)) {
									break;
								}
								ianjuta_iterable_next (begin_iter, &_inner_error_);
								if (_inner_error_ != NULL) {
									_g_object_unref0 (begin_iter);
									_anjuta_report_error_free0 (e);
									_vala_iterable_unref0 (_e_list);
									_g_object_unref0 (mark);
									_g_object_unref0 (ind);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
						}
					}
					_tmp17_ = vala_source_reference_get_last_line ((*e).source);
					_tmp18_ = ianjuta_editor_get_line_begin_position (editor, _tmp17_, &_inner_error_);
					end_iter = _tmp18_;
					if (_inner_error_ != NULL) {
						_g_object_unref0 (begin_iter);
						_anjuta_report_error_free0 (e);
						_vala_iterable_unref0 (_e_list);
						_g_object_unref0 (mark);
						_g_object_unref0 (ind);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					{
						gint i;
						i = 0;
						{
							gboolean _tmp19_;
							_tmp19_ = TRUE;
							while (TRUE) {
								gint _tmp20_;
								if (!_tmp19_) {
									i++;
								}
								_tmp19_ = FALSE;
								_tmp20_ = vala_source_reference_get_last_column ((*e).source);
								if (!(i < _tmp20_)) {
									break;
								}
								ianjuta_iterable_next (end_iter, &_inner_error_);
								if (_inner_error_ != NULL) {
									_g_object_unref0 (end_iter);
									_g_object_unref0 (begin_iter);
									_anjuta_report_error_free0 (e);
									_vala_iterable_unref0 (_e_list);
									_g_object_unref0 (mark);
									_g_object_unref0 (ind);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
						}
					}
					if ((*e).error) {
						_tmp21_ = IANJUTA_INDICABLE_CRITICAL;
					} else {
						_tmp21_ = IANJUTA_INDICABLE_WARNING;
					}
					ianjuta_indicable_set (ind, begin_iter, end_iter, _tmp21_, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_object_unref0 (end_iter);
						_g_object_unref0 (begin_iter);
						_anjuta_report_error_free0 (e);
						_vala_iterable_unref0 (_e_list);
						_g_object_unref0 (mark);
						_g_object_unref0 (ind);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (end_iter);
					_g_object_unref0 (begin_iter);
				}
				if (IANJUTA_IS_MARKABLE (editor)) {
					gint _tmp22_;
					_tmp22_ = vala_source_reference_get_first_line ((*e).source);
					ianjuta_markable_mark (mark, _tmp22_, IANJUTA_MARKABLE_MESSAGE, (*e).message, &_inner_error_);
					if (_inner_error_ != NULL) {
						_anjuta_report_error_free0 (e);
						_vala_iterable_unref0 (_e_list);
						_g_object_unref0 (mark);
						_g_object_unref0 (ind);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
			_anjuta_report_error_free0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_g_object_unref0 (mark);
	_g_object_unref0 (ind);
}


void anjuta_report_clear_error_indicators (AnjutaReport* self) {
	ValaArrayList* _tmp0_ = NULL;
	ValaList* _tmp1_;
	GList* _tmp2_ = NULL;
	GList* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_array_list_new (ANJUTA_REPORT_TYPE_ERROR, (GBoxedCopyFunc) anjuta_report_error_dup, anjuta_report_error_free, g_direct_equal);
	_tmp1_ = (ValaList*) _tmp0_;
	_vala_iterable_unref0 (self->priv->errors);
	self->priv->errors = _tmp1_;
	_tmp2_ = ianjuta_document_manager_get_doc_widgets (self->priv->_docman, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = _tmp3_;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			GtkWidget* doc;
			doc = (GtkWidget*) doc_it->data;
			{
				if (IANJUTA_IS_INDICABLE (doc)) {
					ianjuta_indicable_clear (IANJUTA_INDICABLE (doc), &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_list_free0 (doc_collection);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				if (IANJUTA_IS_MARKABLE (doc)) {
					ianjuta_markable_delete_all_markers (IANJUTA_MARKABLE (doc), IANJUTA_MARKABLE_MESSAGE, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_list_free0 (doc_collection);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
		}
		_g_list_free0 (doc_collection);
	}
}


static gpointer _vala_source_reference_ref0 (gpointer self) {
	return self ? vala_source_reference_ref (self) : NULL;
}


static void anjuta_report_real_warn (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	AnjutaReport * self;
	GError * _inner_error_ = NULL;
	self = (AnjutaReport*) base;
	g_return_if_fail (message != NULL);
	if (source == NULL) {
		return;
	}
	{
		ValaSourceReference* _tmp0_;
		gchar* _tmp1_;
		AnjutaReportError _tmp2_ = {0};
		AnjutaReportError _tmp3_ = {0};
		AnjutaReportError _tmp4_;
		g_static_rec_mutex_lock (&self->priv->__lock_errors);
		_tmp0_ = _vala_source_reference_ref0 (source);
		_tmp1_ = g_strdup (message);
		memset (&_tmp2_, 0, sizeof (AnjutaReportError));
		_tmp2_.source = _tmp0_;
		_tmp2_.message = _tmp1_;
		_tmp2_.error = FALSE;
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		vala_collection_add ((ValaCollection*) self->priv->errors, &_tmp4_);
		anjuta_report_error_destroy (&_tmp4_);
		__finally10:
		g_static_rec_mutex_unlock (&self->priv->__lock_errors);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void anjuta_report_real_err (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	AnjutaReport * self;
	GError * _inner_error_ = NULL;
	self = (AnjutaReport*) base;
	g_return_if_fail (message != NULL);
	if (source == NULL) {
		return;
	}
	{
		ValaSourceReference* _tmp0_;
		gchar* _tmp1_;
		AnjutaReportError _tmp2_ = {0};
		AnjutaReportError _tmp3_ = {0};
		AnjutaReportError _tmp4_;
		g_static_rec_mutex_lock (&self->priv->__lock_errors);
		_tmp0_ = _vala_source_reference_ref0 (source);
		_tmp1_ = g_strdup (message);
		memset (&_tmp2_, 0, sizeof (AnjutaReportError));
		_tmp2_.source = _tmp0_;
		_tmp2_.message = _tmp1_;
		_tmp2_.error = TRUE;
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		vala_collection_add ((ValaCollection*) self->priv->errors, &_tmp4_);
		anjuta_report_error_destroy (&_tmp4_);
		__finally11:
		g_static_rec_mutex_unlock (&self->priv->__lock_errors);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


gboolean anjuta_report_errors_found (AnjutaReport* self) {
	gboolean result = FALSE;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) self->priv->errors);
	result = _tmp0_ != 0;
	return result;
}


AnjutaReport* anjuta_report_construct (GType object_type) {
	AnjutaReport * self = NULL;
	self = (AnjutaReport*) vala_report_construct (object_type);
	return self;
}


AnjutaReport* anjuta_report_new (void) {
	return anjuta_report_construct (TYPE_ANJUTA_REPORT);
}


IAnjutaDocumentManager* anjuta_report_get_docman (AnjutaReport* self) {
	IAnjutaDocumentManager* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_docman;
	return result;
}


void anjuta_report_set_docman (AnjutaReport* self, IAnjutaDocumentManager* value) {
	IAnjutaDocumentManager* _tmp0_;
	IAnjutaDocumentManager* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_docman);
	self->priv->_docman = _tmp1_;
	g_object_notify ((GObject *) self, "docman");
}


static void anjuta_report_error_copy (const AnjutaReportError* self, AnjutaReportError* dest) {
	dest->source = _vala_source_reference_ref0 (self->source);
	dest->error = self->error;
	dest->message = g_strdup (self->message);
}


static void anjuta_report_error_destroy (AnjutaReportError* self) {
	_vala_source_reference_unref0 (self->source);
	_g_free0 (self->message);
}


static AnjutaReportError* anjuta_report_error_dup (const AnjutaReportError* self) {
	AnjutaReportError* dup;
	dup = g_new0 (AnjutaReportError, 1);
	anjuta_report_error_copy (self, dup);
	return dup;
}


static void anjuta_report_error_free (AnjutaReportError* self) {
	anjuta_report_error_destroy (self);
	g_free (self);
}


static GType anjuta_report_error_get_type (void) {
	static volatile gsize anjuta_report_error_type_id__volatile = 0;
	if (g_once_init_enter (&anjuta_report_error_type_id__volatile)) {
		GType anjuta_report_error_type_id;
		anjuta_report_error_type_id = g_boxed_type_register_static ("AnjutaReportError", (GBoxedCopyFunc) anjuta_report_error_dup, (GBoxedFreeFunc) anjuta_report_error_free);
		g_once_init_leave (&anjuta_report_error_type_id__volatile, anjuta_report_error_type_id);
	}
	return anjuta_report_error_type_id__volatile;
}


static void anjuta_report_class_init (AnjutaReportClass * klass) {
	anjuta_report_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AnjutaReportPrivate));
	VALA_REPORT_CLASS (klass)->warn = anjuta_report_real_warn;
	VALA_REPORT_CLASS (klass)->err = anjuta_report_real_err;
	G_OBJECT_CLASS (klass)->get_property = _vala_anjuta_report_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_anjuta_report_set_property;
	G_OBJECT_CLASS (klass)->finalize = anjuta_report_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANJUTA_REPORT_DOCMAN, g_param_spec_object ("docman", "docman", "docman", IANJUTA_TYPE_DOCUMENT_MANAGER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void anjuta_report_instance_init (AnjutaReport * self) {
	ValaArrayList* _tmp0_ = NULL;
	self->priv = ANJUTA_REPORT_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_errors);
	_tmp0_ = vala_array_list_new (ANJUTA_REPORT_TYPE_ERROR, (GBoxedCopyFunc) anjuta_report_error_dup, anjuta_report_error_free, g_direct_equal);
	self->priv->errors = (ValaList*) _tmp0_;
}


static void anjuta_report_finalize (GObject* obj) {
	AnjutaReport * self;
	self = ANJUTA_REPORT (obj);
	_g_object_unref0 (self->priv->_docman);
	g_static_rec_mutex_free (&self->priv->__lock_errors);
	_vala_iterable_unref0 (self->priv->errors);
	G_OBJECT_CLASS (anjuta_report_parent_class)->finalize (obj);
}


GType anjuta_report_get_type (void) {
	return anjuta_report_type_id;
}


GType anjuta_report_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (AnjutaReportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) anjuta_report_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AnjutaReport), 0, (GInstanceInitFunc) anjuta_report_instance_init, NULL };
	anjuta_report_type_id = g_type_module_register_type (module, VALA_TYPE_REPORT, "AnjutaReport", &g_define_type_info, 0);
	return anjuta_report_type_id;
}


static void _vala_anjuta_report_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AnjutaReport * self;
	self = ANJUTA_REPORT (object);
	switch (property_id) {
		case ANJUTA_REPORT_DOCMAN:
		g_value_set_object (value, anjuta_report_get_docman (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_anjuta_report_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AnjutaReport * self;
	self = ANJUTA_REPORT (object);
	switch (property_id) {
		case ANJUTA_REPORT_DOCMAN:
		anjuta_report_set_docman (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



