#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['asdf_standard']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

extras_require = \
{':python_version<"3.9"': ['importlib_resources >= 3'],
 'docs': ['toml',
          'sphinx',
          'sphinx-asdf >= 0.1.3',
          'sphinx-astropy',
          'graphviz',
          'matplotlib',
          'docutils',
          'sphinx-rtd-theme'],
 'test': ['pytest',
          'pyyaml',
          'asdf >= 2.8.0',
          'astropy >= 5.0.4',
          'gwcs',
          'packaging>=16.0']}

entry_points = \
{'asdf.resource_mappings': ['asdf_standard = '
                            'asdf_standard.integration:get_resource_mappings']}

setup(name='asdf_standard',
      version='%%PORTVERSION%%',
      description='The ASDF Standard schemas',
      author=None,
      author_email='The ASDF Developers <help@stsci.edu>',
      url=None,
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.8',
     )
