#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['etils',
 'etils.array_types',
 'etils.ecolab',
 'etils.edc',
 'etils.enp',
 'etils.epath',
 'etils.epy',
 'etils.etqdm',
 'etils.etree']

package_data = \
{'': ['*'], 'etils.epath': ['docs/*']}

extras_require = \
{'all': ['etils[array-types]',
         'etils[ecolab]',
         'etils[edc]',
         'etils[enp]',
         'etils[epath]',
         'etils[epy]',
         'etils[etqdm]',
         'etils[etree]',
         'etils[etree-dm]',
         'etils[etree-jax]'],
 'array-types': ['etils[enp]'],
 'dev': ['pytest',
         'pytest-subtests',
         'pytest-xdist',
         'pylint>=2.6.0',
         'yapf',
         'chex'],
 'ecolab': ['jupyter', 'numpy', 'mediapy', 'etils[enp]', 'etils[epy]'],
 'edc': ['etils[epy]'],
 'enp': ['numpy', 'etils[epy]'],
 'epath': ['importlib_resources', 'typing_extensions', 'zipp', 'etils[epy]'],
 'epy': ['typing_extensions'],
 'etqdm': ['absl-py', 'tqdm', 'etils[epy]'],
 'etree': ['etils[array_types]', 'etils[epy]', 'etils[enp]', 'etils[etqdm]'],
 'etree-dm': ['dm-tree', 'etils[etree]'],
 'etree-jax': ['jax[cpu]', 'etils[etree]'],
 'etree-tf': ['tf-nightly', 'etils[etree]']}

setup(name='etils',
      version='%%PORTVERSION%%',
      description='Collection of common python utils',
      author=None,
      author_email='Conchylicultor <etils@google.com>',
      url=None,
      packages=packages,
      package_data=package_data,
      extras_require=extras_require,
      python_requires='>=3.7',
     )
